/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.gephi.io.importer.plugin.file.spreadsheet.AbstractImporterSpreadsheet;
import org.gephi.io.importer.plugin.file.spreadsheet.SpreadsheetUtils;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.EmptySheet;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.ErrorSheet;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheets.excel.ExcelSheetParser;

public class ImporterSpreadsheetExcel
extends AbstractImporterSpreadsheet {
    private int sheetIndex = 0;

    @Override
    public SheetParser createParserWithoutHeaders() throws IOException {
        return this.createParser(false);
    }

    @Override
    public SheetParser createParser() throws IOException {
        boolean withFirstRecordAsHeader = this.generalConfig.getMode() == SpreadsheetGeneralConfiguration.Mode.NODES_TABLE || this.generalConfig.getMode() == SpreadsheetGeneralConfiguration.Mode.EDGES_TABLE;
        return this.createParser(withFirstRecordAsHeader);
    }

    private SheetParser createParser(boolean withFirstRecordAsHeader) throws IOException {
        try {
            boolean readOnly = true;
            Workbook workbook = WorkbookFactory.create((File)this.file, null, (boolean)readOnly);
            Sheet sheet = workbook.getSheetAt(this.sheetIndex);
            return new ExcelSheetParser(sheet, withFirstRecordAsHeader);
        }
        catch (Exception ex) {
            if (this.report != null) {
                SpreadsheetUtils.logError(this.report, ex.getMessage(), null);
                return EmptySheet.INSTANCE;
            }
            return new ErrorSheet(ex.getMessage());
        }
    }

    public String[] getAvailableSheetNames() {
        String[] stringArray;
        block9: {
            Workbook workbook = WorkbookFactory.create((File)this.file);
            try {
                int length = workbook.getNumberOfSheets();
                String[] names = new String[length];
                for (int i = 0; i < length; ++i) {
                    names[i] = workbook.getSheetName(i);
                }
                stringArray = names;
                if (workbook == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    Logger.getLogger("").log(Level.SEVERE, ex.getMessage());
                    return new String[]{"Error"};
                }
            }
            workbook.close();
        }
        return stringArray;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }
}

