/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyHelper<S, V>
extends Property<S, V> {
    private final boolean ignoresSource;
    private Object listeners;

    public PropertyHelper() {
        this(false);
    }

    public PropertyHelper(boolean ignoresSource) {
        this.ignoresSource = ignoresSource;
    }

    private List<PropertyStateListener> getListeners(S source, boolean create) {
        ArrayList list;
        if (this.ignoresSource) {
            ArrayList list2 = (ArrayList)this.listeners;
            if (list2 == null && create) {
                this.listeners = list2 = new ArrayList();
            }
            return list2;
        }
        IdentityHashMap map = (IdentityHashMap)this.listeners;
        if (map == null) {
            if (create) {
                this.listeners = map = new IdentityHashMap();
            } else {
                return null;
            }
        }
        if ((list = (ArrayList)map.get(source)) == null && create) {
            list = new ArrayList();
            map.put(source, list);
        }
        return list;
    }

    @Override
    public abstract Class<? extends V> getWriteType(S var1);

    @Override
    public abstract V getValue(S var1);

    @Override
    public abstract void setValue(S var1, V var2);

    @Override
    public abstract boolean isReadable(S var1);

    @Override
    public abstract boolean isWriteable(S var1);

    protected void listeningStarted(S source) {
    }

    protected void listeningStopped(S source) {
    }

    @Override
    public final void addPropertyStateListener(S source, PropertyStateListener listener) {
        if (listener == null) {
            return;
        }
        List<PropertyStateListener> listeners = this.getListeners(source, true);
        boolean wasListening = listeners.size() != 0;
        listeners.add(listener);
        if (!wasListening) {
            this.listeningStarted(this.ignoresSource ? null : (S)source);
        }
    }

    @Override
    public final void removePropertyStateListener(S source, PropertyStateListener listener) {
        if (listener == null) {
            return;
        }
        List<PropertyStateListener> listeners = this.getListeners(source, false);
        if (listeners == null) {
            return;
        }
        boolean wasListening = listeners.size() != 0;
        listeners.remove(listener);
        if (wasListening && listeners.size() == 0) {
            this.listeningStopped(this.ignoresSource ? null : (S)source);
        }
    }

    @Override
    public final PropertyStateListener[] getPropertyStateListeners(S source) {
        List<PropertyStateListener> listeners = this.getListeners(source, false);
        if (listeners == null) {
            return new PropertyStateListener[0];
        }
        PropertyStateListener[] ret = new PropertyStateListener[listeners.size()];
        ret = listeners.toArray(ret);
        return ret;
    }

    protected final void firePropertyStateChange(PropertyStateEvent pse) {
        List<PropertyStateListener> listeners = this.getListeners(pse.getSourceObject(), false);
        if (listeners == null) {
            return;
        }
        for (PropertyStateListener listener : listeners) {
            listener.propertyStateChanged(pse);
        }
    }

    public final boolean isListening(S source) {
        List<PropertyStateListener> listeners = this.getListeners(source, false);
        return listeners != null && listeners.size() != 0;
    }
}

