/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.attribute;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.AbstractAttributeFilter;
import org.gephi.filters.plugin.AbstractAttributeFilterBuilder;
import org.gephi.filters.plugin.attribute.EqualBooleanUI;
import org.gephi.filters.plugin.attribute.EqualNumberUI;
import org.gephi.filters.plugin.attribute.EqualStringUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.types.IntervalBooleanMap;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.graph.api.types.TimestampBooleanMap;
import org.gephi.graph.api.types.TimestampStringMap;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttributeEqualBuilder
implements CategoryBuilder {
    private static final Category EQUAL = new Category(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return EQUAL;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        ArrayList<EqualStringFilterBuilder> builders = new ArrayList<EqualStringFilterBuilder>();
        GraphModel am = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        ArrayList columns = new ArrayList();
        columns.addAll(am.getNodeTable().toList());
        columns.addAll(am.getEdgeTable().toList());
        for (Column c : columns) {
            AbstractAttributeFilterBuilder b;
            if (c.isProperty()) continue;
            if (c.getTypeClass().equals(String.class) || c.getTypeClass().equals(TimestampStringMap.class) || c.getTypeClass().equals(IntervalStringMap.class) || c.isArray()) {
                b = new EqualStringFilterBuilder(c);
                builders.add((EqualStringFilterBuilder)b);
                continue;
            }
            if (AttributeUtils.isNumberType((Class)c.getTypeClass())) {
                b = new EqualNumberFilterBuilder(c);
                builders.add((EqualStringFilterBuilder)b);
                continue;
            }
            if (!c.getTypeClass().equals(Boolean.class) && !c.getTypeClass().equals(TimestampBooleanMap.class) && !c.getTypeClass().equals(IntervalBooleanMap.class)) continue;
            b = new EqualBooleanFilterBuilder(c);
            builders.add((EqualStringFilterBuilder)b);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static abstract class EqualBooleanFilter<K extends Element>
    extends AbstractAttributeFilter<K> {
        private boolean match = false;

        public EqualBooleanFilter(Column column) {
            super(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name"), column);
            this.addProperty(Boolean.class, "match");
        }

        public boolean init(Graph graph) {
            return true;
        }

        public boolean evaluate(Graph graph, Element element) {
            Object val = element.getAttribute(this.column, graph.getView());
            if (val != null) {
                return val.equals(this.match);
            }
            return false;
        }

        public void finish() {
        }

        public boolean isMatch() {
            return this.match;
        }

        public void setMatch(boolean match) {
            this.match = match;
        }

        public static class Edge
        extends EqualBooleanFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(Column column) {
                super(column);
            }
        }

        public static class Node
        extends EqualBooleanFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(Column column) {
                super(column);
            }
        }
    }

    private static class EqualBooleanFilterBuilder
    extends AbstractAttributeFilterBuilder {
        public EqualBooleanFilterBuilder(Column column) {
            super(column, EQUAL, NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.description"), null);
        }

        public EqualBooleanFilter getFilter(Workspace workspace) {
            return AttributeUtils.isNodeColumn((Column)this.column) ? new EqualBooleanFilter.Node(this.column) : new EqualBooleanFilter.Edge(this.column);
        }

        public JPanel getPanel(Filter filter) {
            EqualBooleanUI ui = (EqualBooleanUI)Lookup.getDefault().lookup(EqualBooleanUI.class);
            if (ui != null) {
                return ui.getPanel((EqualBooleanFilter)filter);
            }
            return null;
        }
    }

    public static abstract class EqualNumberFilter<K extends Element>
    extends AbstractAttributeFilter<K>
    implements RangeFilter {
        private Number match;
        private Range range;

        public EqualNumberFilter(Column column) {
            super(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name"), column);
            this.addProperty(Number.class, "match");
            this.addProperty(Range.class, "range");
        }

        public boolean init(Graph graph) {
            if (AttributeUtils.isNodeColumn((Column)this.column)) {
                return graph.getNodeCount() != 0;
            }
            if (AttributeUtils.isEdgeColumn((Column)this.column)) {
                return graph.getEdgeCount() != 0;
            }
            return true;
        }

        public boolean evaluate(Graph graph, Element element) {
            Object val = element.getAttribute(this.column, graph.getView());
            if (val != null) {
                return val.equals(this.match);
            }
            return false;
        }

        public void finish() {
        }

        public Number[] getValues(Graph graph) {
            ArrayList<Number> vals = new ArrayList<Number>();
            if (AttributeUtils.isNodeColumn((Column)this.column)) {
                for (Element n : graph.getNodes()) {
                    Object val = n.getAttribute(this.column, graph.getView());
                    if (val == null) continue;
                    vals.add((Number)val);
                }
            } else {
                for (Element e : graph.getEdges()) {
                    Object val = e.getAttribute(this.column, graph.getView());
                    if (val == null) continue;
                    vals.add((Number)val);
                }
            }
            return vals.toArray(new Number[0]);
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[2];
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
            this.match = this.match == null ? (Number)range.getMinimum() : (Number)Range.trimToBounds((Number)range.getMinimum(), (Number)range.getMaximum(), (Number)this.match);
        }

        public Number getMatch() {
            return this.match;
        }

        public void setMatch(Number match) {
            this.match = match;
        }

        public static class Edge
        extends EqualNumberFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(Column column) {
                super(column);
            }
        }

        public static class Node
        extends EqualNumberFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(Column column) {
                super(column);
            }
        }
    }

    private static class EqualNumberFilterBuilder
    extends AbstractAttributeFilterBuilder {
        public EqualNumberFilterBuilder(Column column) {
            super(column, EQUAL, NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.description"), null);
        }

        public EqualNumberFilter getFilter(Workspace workspace) {
            return AttributeUtils.isNodeColumn((Column)this.column) ? new EqualNumberFilter.Node(this.column) : new EqualNumberFilter.Edge(this.column);
        }

        public JPanel getPanel(Filter filter) {
            EqualNumberUI ui = (EqualNumberUI)Lookup.getDefault().lookup(EqualNumberUI.class);
            if (ui != null) {
                return ui.getPanel((EqualNumberFilter)filter);
            }
            return null;
        }
    }

    public static abstract class EqualStringFilter<K extends Element>
    extends AbstractAttributeFilter<K> {
        private String pattern;
        private boolean useRegex;
        private Pattern regex;

        public EqualStringFilter(Column column) {
            super(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.name"), column);
            this.addProperty(String.class, "pattern");
            this.addProperty(Boolean.class, "useRegex");
        }

        public boolean init(Graph graph) {
            return true;
        }

        public boolean evaluate(Graph graph, Element element) {
            if (this.pattern == null) {
                return true;
            }
            Object val = element.getAttribute(this.column, graph.getView());
            if (val != null) {
                String valString;
                String string = valString = this.column.isArray() ? AttributeUtils.printArray((Object)val) : val.toString();
                if (this.useRegex) {
                    return this.regex.matcher(valString).matches();
                }
                return this.pattern.equals(valString);
            }
            return false;
        }

        public void finish() {
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
            this.regex = Pattern.compile(pattern);
        }

        public boolean isUseRegex() {
            return this.useRegex;
        }

        public void setUseRegex(boolean useRegex) {
            this.useRegex = useRegex;
        }

        public static class Edge
        extends EqualStringFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(Column column) {
                super(column);
            }
        }

        public static class Node
        extends EqualStringFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(Column column) {
                super(column);
            }
        }
    }

    private static class EqualStringFilterBuilder
    extends AbstractAttributeFilterBuilder {
        public EqualStringFilterBuilder(Column column) {
            super(column, EQUAL, NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeEqualBuilder.description"), null);
        }

        public EqualStringFilter getFilter(Workspace workspace) {
            return AttributeUtils.isNodeColumn((Column)this.column) ? new EqualStringFilter.Node(this.column) : new EqualStringFilter.Edge(this.column);
        }

        public JPanel getPanel(Filter filter) {
            EqualStringUI ui = (EqualStringUI)Lookup.getDefault().lookup(EqualStringUI.class);
            if (ui != null) {
                return ui.getPanel((EqualStringFilter)filter);
            }
            return null;
        }
    }
}

