/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.drm;

import com.jogamp.nativewindow.NativeWindowException;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import jogamp.nativewindow.drm.DRMLib;
import jogamp.nativewindow.drm.DRMUtil;
import jogamp.nativewindow.drm.drmModeConnector;
import jogamp.nativewindow.drm.drmModeEncoder;
import jogamp.nativewindow.drm.drmModeModeInfo;
import jogamp.nativewindow.drm.drmModeRes;

public class DrmMode {
    public final int drmFd;
    public final int count;
    private final drmModeConnector[] connectors;
    private final drmModeModeInfo[] modes;
    private final drmModeEncoder[] encoder;
    private final int[] crtc_ids;
    private final int[] crtc_indices;
    private volatile boolean valid;

    private DrmMode(int n, int n2) {
        this.drmFd = n;
        this.count = n2;
        this.connectors = new drmModeConnector[n2];
        this.modes = new drmModeModeInfo[n2];
        this.encoder = new drmModeEncoder[n2];
        this.crtc_ids = new int[n2];
        this.crtc_indices = new int[n2];
        this.valid = false;
    }

    public void print(PrintStream printStream) {
        for (int i = 0; i < this.count; ++i) {
            this.print(printStream, i);
        }
    }

    public void print(PrintStream printStream, int n) {
        drmModeConnector drmModeConnector2 = this.connectors[n];
        printStream.printf("Connector[%d]: id[con 0x%x, enc 0x%x], type %d[id 0x%x], connection %d, dim %dx%x mm, modes %d, encoders %d\n", n, drmModeConnector2.getConnector_id(), drmModeConnector2.getEncoder_id(), drmModeConnector2.getConnector_type(), drmModeConnector2.getConnector_type_id(), drmModeConnector2.getConnection(), drmModeConnector2.getMmWidth(), drmModeConnector2.getMmHeight(), drmModeConnector2.getCount_modes(), drmModeConnector2.getCount_encoders());
        drmModeModeInfo drmModeModeInfo2 = this.modes[n];
        System.err.printf("Connector[%d].Mode: clock %d, %dx%d @ %d Hz, type %d, name <%s>\n", n, drmModeModeInfo2.getClock(), drmModeModeInfo2.getHdisplay(), drmModeModeInfo2.getVdisplay(), drmModeModeInfo2.getVrefresh(), drmModeModeInfo2.getType(), drmModeModeInfo2.getNameAsString());
        drmModeEncoder drmModeEncoder2 = this.encoder[n];
        System.err.printf("Connector[%d].Encoder: id 0x%x, type %d, crtc_id 0x%x, possible[crtcs %d, clones %d]\n", n, drmModeEncoder2.getEncoder_id(), drmModeEncoder2.getEncoder_type(), drmModeEncoder2.getCrtc_id(), drmModeEncoder2.getPossible_crtcs(), drmModeEncoder2.getPossible_clones());
    }

    public static DrmMode create(int n, boolean bl) {
        drmModeRes drmModeRes2 = DRMLib.drmModeGetResources(n);
        if (null == drmModeRes2) {
            throw new NativeWindowException("drmModeGetResources failed");
        }
        DrmMode drmMode = null;
        try {
            int n2;
            int n3;
            int n4;
            ArrayList<drmModeConnector> arrayList = new ArrayList<drmModeConnector>();
            drmModeModeInfo[] drmModeModeInfoArray = drmModeRes2.getConnectors();
            if (DRMUtil.DEBUG) {
                for (int i = 0; i < drmModeModeInfoArray.limit(); ++i) {
                    drmModeConnector drmModeConnector2 = DRMLib.drmModeGetConnector(n, drmModeModeInfoArray.get(i));
                    n4 = 1 == drmModeConnector2.getConnection() ? 1 : 0;
                    System.err.printf("Connector %d/%d chosen %b,: id[con 0x%x, enc 0x%x], type %d[id 0x%x], connection %d, dim %dx%x mm, modes %d, encoders %d\n", i, drmModeModeInfoArray.limit(), n4 != 0, drmModeConnector2.getConnector_id(), drmModeConnector2.getEncoder_id(), drmModeConnector2.getConnector_type(), drmModeConnector2.getConnector_type_id(), drmModeConnector2.getConnection(), drmModeConnector2.getMmWidth(), drmModeConnector2.getMmHeight(), drmModeConnector2.getCount_modes(), drmModeConnector2.getCount_encoders());
                    DRMLib.drmModeFreeConnector(drmModeConnector2);
                }
            }
            Object object = null;
            for (n3 = 0; n3 < drmModeModeInfoArray.limit(); ++n3) {
                object = DRMLib.drmModeGetConnector(n, drmModeModeInfoArray.get(n3));
                if (1 == ((drmModeConnector)object).getConnection()) {
                    arrayList.add((drmModeConnector)object);
                    continue;
                }
                DRMLib.drmModeFreeConnector((drmModeConnector)object);
                object = null;
            }
            drmMode = new DrmMode(n, arrayList.size());
            arrayList.toArray(drmMode.connectors);
            for (int i = 0; i < drmMode.count; ++i) {
                drmModeModeInfoArray = drmMode.connectors[i].getModes(0, new drmModeModeInfo[drmMode.connectors[i].getCount_modes()]);
                object = null;
                n3 = 0;
                n4 = 0;
                for (int j = 0; j < drmModeModeInfoArray.length; ++j) {
                    drmModeModeInfo drmModeModeInfo2 = drmModeModeInfoArray[j];
                    int n5 = drmModeModeInfo2.getHdisplay() * drmModeModeInfo2.getVdisplay();
                    if (bl && drmModeModeInfo2.getType() == 8) {
                        object = drmModeModeInfo2;
                        n3 = Integer.MAX_VALUE;
                        n4 = j;
                    } else if (n5 > n3) {
                        object = drmModeModeInfo2;
                        n3 = n5;
                        n4 = j;
                    }
                    if (!DRMUtil.DEBUG) continue;
                    System.err.printf("Connector[%d].Mode %d/%d (max-chosen %d): clock %d, %dx%d @ %d Hz, type %d, name <%s>\n", i, j, drmModeModeInfoArray.length, n4, drmModeModeInfo2.getClock(), drmModeModeInfo2.getHdisplay(), drmModeModeInfo2.getVdisplay(), drmModeModeInfo2.getVrefresh(), drmModeModeInfo2.getType(), drmModeModeInfo2.getNameAsString());
                }
                if (null == object) {
                    throw new NativeWindowException("could not find mode");
                }
                drmMode.modes[i] = object;
            }
            IntBuffer intBuffer = drmModeRes2.getEncoders();
            for (n2 = 0; n2 < drmMode.count; ++n2) {
                if (DRMUtil.DEBUG) {
                    for (int i = 0; i < intBuffer.limit(); ++i) {
                        drmModeEncoder drmModeEncoder2 = DRMLib.drmModeGetEncoder(n, intBuffer.get(i));
                        n4 = drmModeEncoder2.getEncoder_id() == drmMode.connectors[n2].getEncoder_id() ? 1 : 0;
                        System.err.printf("Connector[%d].Encoder %d/%d chosen %b: id 0x%x, type %d, crtc_id 0x%x, possible[crtcs %d, clones %d]\n", n2, i, intBuffer.limit(), n4 != 0, drmModeEncoder2.getEncoder_id(), drmModeEncoder2.getEncoder_type(), drmModeEncoder2.getCrtc_id(), drmModeEncoder2.getPossible_crtcs(), drmModeEncoder2.getPossible_clones());
                        DRMLib.drmModeFreeEncoder(drmModeEncoder2);
                    }
                }
                object = null;
                for (n3 = 0; n3 < intBuffer.limit() && ((drmModeEncoder)(object = DRMLib.drmModeGetEncoder(n, intBuffer.get(n3)))).getEncoder_id() != drmMode.connectors[n2].getEncoder_id(); ++n3) {
                    DRMLib.drmModeFreeEncoder((drmModeEncoder)object);
                    object = null;
                }
                if (null == object) {
                    throw new NativeWindowException("could not find encoder");
                }
                drmMode.encoder[n2] = object;
            }
            intBuffer = drmModeRes2.getCrtcs();
            for (n2 = 0; n2 < drmMode.count; ++n2) {
                int n6 = -1;
                for (n3 = 0; n3 < intBuffer.limit(); ++n3) {
                    if (intBuffer.get(n3) != drmMode.encoder[n2].getCrtc_id()) continue;
                    n6 = n3;
                    break;
                }
                if (0 > n6) {
                    throw new NativeWindowException("could not find crtc index");
                }
                drmMode.crtc_ids[n2] = intBuffer.get(n6);
                drmMode.crtc_indices[n2] = n6;
            }
        }
        catch (Throwable throwable) {
            if (null != drmMode) {
                drmMode.destroy();
                drmMode = null;
            }
            throw throwable;
        }
        finally {
            DRMLib.drmModeFreeResources(drmModeRes2);
        }
        drmMode.valid = true;
        return drmMode;
    }

    public final boolean isValid() {
        return this.valid;
    }

    private final void checkValid() {
        if (!this.valid) {
            throw new IllegalStateException("Instance is invalid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.valid) {
            DrmMode drmMode = this;
            synchronized (drmMode) {
                if (this.valid) {
                    this.valid = false;
                    for (int i = 0; i < this.count; ++i) {
                        if (null != this.encoder[i]) {
                            DRMLib.drmModeFreeEncoder(this.encoder[i]);
                        }
                        if (null == this.connectors[i]) continue;
                        DRMLib.drmModeFreeConnector(this.connectors[i]);
                    }
                }
            }
        }
    }

    public final drmModeConnector[] getConnectors() throws IllegalStateException {
        this.checkValid();
        return this.connectors;
    }

    public final drmModeModeInfo[] getModes() throws IllegalStateException {
        this.checkValid();
        return this.modes;
    }

    public final drmModeEncoder[] getEncoder() throws IllegalStateException {
        this.checkValid();
        return this.encoder;
    }

    public final int[] getCrtcIDs() throws IllegalStateException {
        this.checkValid();
        return this.crtc_ids;
    }

    public final int[] getCrtcIndices() throws IllegalStateException {
        this.checkValid();
        return this.crtc_indices;
    }
}

