/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.packrect;

import com.jogamp.opengl.util.packrect.BackingStoreManager;
import com.jogamp.opengl.util.packrect.Level;
import com.jogamp.opengl.util.packrect.LevelSet;
import com.jogamp.opengl.util.packrect.Rect;
import com.jogamp.opengl.util.packrect.RectVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RectanglePacker {
    private final BackingStoreManager manager;
    private Object backingStore;
    private LevelSet levels;
    private static final float EXPANSION_FACTOR = 0.5f;
    private static final float SHRINK_FACTOR = 0.3f;
    private final int initialWidth;
    private final int initialHeight;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private static final Comparator<Rect> rectHComparator = new RectHComparator();

    public RectanglePacker(BackingStoreManager backingStoreManager, int n, int n2) {
        this.manager = backingStoreManager;
        this.levels = new LevelSet(n, n2);
        this.initialWidth = n;
        this.initialHeight = n2;
    }

    public Object getBackingStore() {
        if (this.backingStore == null) {
            this.backingStore = this.manager.allocateBackingStore(this.levels.w(), this.levels.h());
        }
        return this.backingStore;
    }

    public void setMaxSize(int n, int n2) {
        this.maxWidth = n;
        this.maxHeight = n2;
    }

    public void add(Rect rect) throws RuntimeException {
        if (this.backingStore == null) {
            this.backingStore = this.manager.allocateBackingStore(this.levels.w(), this.levels.h());
        }
        int n = 0;
        boolean bl = false;
        do {
            if (this.levels.add(rect)) {
                return;
            }
            if (this.manager.canCompact()) {
                if (this.levels.compactAndAdd(rect, this.backingStore, this.manager)) {
                    return;
                }
                bl = this.manager.preExpand(rect, n++);
                continue;
            }
            bl = this.manager.additionFailed(rect, n++);
        } while (bl);
        if (!this.manager.canCompact()) {
            throw new RuntimeException("BackingStoreManager does not support compaction or expansion, and didn't clear space for new rectangle");
        }
        this.compactImpl(rect);
        this.add(rect);
    }

    public void remove(Rect rect) {
        this.levels.remove(rect);
    }

    public void visit(RectVisitor rectVisitor) {
        this.levels.visit(rectVisitor);
    }

    public float verticalFragmentationRatio() {
        return this.levels.verticalFragmentationRatio();
    }

    public void compact() {
        this.compactImpl(null);
    }

    private void compactImpl(Rect rect) {
        Rect rect2;
        Iterator<Rect> iterator;
        Level level;
        Iterator<Level> iterator2;
        boolean bl = false;
        int n = this.levels.w();
        int n2 = this.levels.h();
        LevelSet levelSet = null;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl) {
            if (rect != null) {
                if (rect.w() > n) {
                    n = rect.w();
                } else {
                    n2 = (int)((float)n2 * 1.5f);
                }
            }
            bl2 = false;
            if (this.maxWidth > 0 && n > this.maxWidth) {
                n = this.maxWidth;
                bl2 = true;
            }
            if (this.maxHeight > 0 && n2 > this.maxHeight) {
                n2 = this.maxHeight;
                bl2 = true;
            }
            levelSet = new LevelSet(n, n2);
            ArrayList<Rect> arrayList = new ArrayList<Rect>();
            iterator2 = this.levels.iterator();
            while (iterator2.hasNext()) {
                level = iterator2.next();
                iterator = level.iterator();
                while (iterator.hasNext()) {
                    rect2 = iterator.next();
                    Rect rect3 = new Rect(0, 0, rect2.w(), rect2.h(), null);
                    rect2.setNextLocation(rect3);
                    rect3.setNextLocation(rect2);
                    arrayList.add(rect3);
                }
            }
            Collections.sort(arrayList, rectHComparator);
            bl = true;
            iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                if (levelSet.add((Rect)((Object)iterator2.next()))) continue;
                bl = false;
                break;
            }
            if (bl && rect != null && !levelSet.add(rect)) {
                bl = false;
            }
            if (!bl && bl2 && rect != null) {
                this.manager.additionFailed(rect, n3);
            }
            ++n3;
        }
        if (levelSet.getUsedHeight() > 0 && (float)levelSet.getUsedHeight() < (float)levelSet.h() * 0.3f) {
            int n4 = Math.max(this.initialHeight, (int)((float)levelSet.getUsedHeight() * 1.5f));
            if (this.maxHeight > 0 && n4 > this.maxHeight) {
                n4 = this.maxHeight;
            }
            levelSet.setHeight(n4);
        }
        if (rect != null) {
            levelSet.remove(rect);
        }
        Object object = this.manager.allocateBackingStore(levelSet.w(), levelSet.h());
        this.manager.beginMovement(this.backingStore, object);
        iterator2 = this.levels.iterator();
        while (iterator2.hasNext()) {
            level = iterator2.next();
            iterator = level.iterator();
            while (iterator.hasNext()) {
                rect2 = iterator.next();
                this.manager.move(this.backingStore, rect2, object, rect2.getNextLocation());
            }
        }
        levelSet.updateRectangleReferences();
        this.manager.endMovement(this.backingStore, object);
        this.manager.deleteBackingStore(this.backingStore);
        this.backingStore = object;
        this.levels = levelSet;
    }

    public void clear() {
        this.levels.clear();
    }

    public void dispose() {
        if (this.backingStore != null) {
            this.manager.deleteBackingStore(this.backingStore);
        }
        this.backingStore = null;
        this.levels = null;
    }

    static class RectHComparator
    implements Comparator<Rect> {
        RectHComparator() {
        }

        @Override
        public int compare(Rect rect, Rect rect2) {
            return rect2.h() - rect.h();
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }
}

