/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.gephi.statistics.plugin.GraphDistance;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.GraphDistancePanel;
import org.openide.util.NbBundle;

public class PathLengthUI
implements StatisticsUI {
    private GraphDistancePanel panel;
    private GraphDistance graphDistance;

    public JPanel getSettingsPanel() {
        this.panel = new GraphDistancePanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.graphDistance = (GraphDistance)statistics;
        if (this.panel != null) {
            this.panel.setDirected(this.graphDistance.isDirected());
            this.panel.doNormalize(this.graphDistance.isNormalized());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.graphDistance.setDirected(this.panel.isDirected());
            this.graphDistance.setNormalized(this.panel.normalize());
        }
        this.graphDistance = null;
        this.panel = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return GraphDistance.class;
    }

    public String getValue() {
        DecimalFormat df = new DecimalFormat("###.###");
        return df.format(this.graphDistance.getPathLength());
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"PathLengthUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_EDGE_OVERVIEW;
    }

    public int getPosition() {
        return 200;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"PathLengthUI.shortDescription");
    }
}

