/**
 * SECTION:postal-address-details
 * @short_description: Object representing a postal mail address.
 * 
 * <para>The components of the address are never <code>null</code>: an empty string indicates that a property is not set.</para>
 */
/**
 * FOLKS_TYPE_POSTAL_ADDRESS:
 * 
 * The type for <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link>.
 */
/**
 * folks_postal_address_is_empty:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance
 * 
 * Whether none of the components is set.
 * 
 * Returns: <para><code>true</code> if all the components are the empty string, <code>false</code> otherwise. </para>
 *
 * Since: 0.6.7
 */
/**
 * folks_postal_address_equal:
 * @with: <para>another postal address to compare with </para>
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance
 * @@with: &nbsp;
 * 
 * Compare if two postal addresses are equal. Addresses are equal if all their components are equal (where <code>null</code> compares equal only with <code>null</code>) and they have the same set of types (or both have no types).
 * 
 * <para>This does not factor in the <parameter>uid</parameter>.</para>
 * 
 * Returns: <para><code>true</code> if the addresses are equal, <code>false</code> otherwise </para>
 */
/**
 * folks_postal_address_to_string:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance
 * 
 * Get a formatted version of the address. The format is localised, and by default is comma-separated.
 * 
 * Returns: <para>a formatted address. </para>
 *
 * Since: 0.4.0
 */
/**
 * folks_postal_address_new:
 * @po_box: (in) (allow-none): &nbsp;.  <para>the PO Box </para>
 * @extension: (in) (allow-none): &nbsp;.  <para>the address extension </para>
 * @street: (in) (allow-none): &nbsp;.  <para>the street name and number </para>
 * @locality: (in) (allow-none): &nbsp;.  <para>the locality (city, town or village) name </para>
 * @region: (in) (allow-none): &nbsp;.  <para>the region (state or province) name </para>
 * @postal_code: (in) (allow-none): &nbsp;.  <para>the postal code </para>
 * @country: (in) (allow-none): &nbsp;.  <para>the country name </para>
 * @address_format: (in) (allow-none): &nbsp;.  <para>the address format </para>
 * @uid: (in) (allow-none): &nbsp;.  <para>external UID for the address instance </para>
 * 
 * Create a PostalAddress.
 * 
 * <para>You can pass <code>null</code> if a component is not set.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksPostalAddress:po-box:
 * 
 * The PO Box.
 * 
 * <para>The PO Box (also known as Postal office box or Postal box).</para>
 */
/**
 * folks_postal_address_get_po_box:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--po-box"><type>"po-box"</type></link> property.
 * 
 * The PO Box.
 * 
 * <para>The PO Box (also known as Postal office box or Postal box).</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--po-box"><type>"po-box"</type></link> property
 */
/**
 * folks_postal_address_set_po_box:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--po-box"><type>"po-box"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--po-box"><type>"po-box"</type></link> property to @value.
 * 
 * The PO Box.
 * 
 * <para>The PO Box (also known as Postal office box or Postal box).</para>
 */
/**
 * FolksPostalAddress:extension:
 * 
 * The address extension.
 * 
 * <para>Any additional part of the address, for instance a flat number.</para>
 */
/**
 * folks_postal_address_get_extension:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--extension"><type>"extension"</type></link> property.
 * 
 * The address extension.
 * 
 * <para>Any additional part of the address, for instance a flat number.</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--extension"><type>"extension"</type></link> property
 */
/**
 * folks_postal_address_set_extension:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--extension"><type>"extension"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--extension"><type>"extension"</type></link> property to @value.
 * 
 * The address extension.
 * 
 * <para>Any additional part of the address, for instance a flat number.</para>
 */
/**
 * FolksPostalAddress:street:
 * 
 * The street name and number.
 * 
 * <para>The street name including the optional building number. The number can be before or after the street name based on the language and country.</para>
 */
/**
 * folks_postal_address_get_street:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--street"><type>"street"</type></link> property.
 * 
 * The street name and number.
 * 
 * <para>The street name including the optional building number. The number can be before or after the street name based on the language and country.</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--street"><type>"street"</type></link> property
 */
/**
 * folks_postal_address_set_street:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--street"><type>"street"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--street"><type>"street"</type></link> property to @value.
 * 
 * The street name and number.
 * 
 * <para>The street name including the optional building number. The number can be before or after the street name based on the language and country.</para>
 */
/**
 * FolksPostalAddress:locality:
 * 
 * The locality.
 * 
 * <para>The locality, for instance the city name.</para>
 */
/**
 * folks_postal_address_get_locality:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--locality"><type>"locality"</type></link> property.
 * 
 * The locality.
 * 
 * <para>The locality, for instance the city name.</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--locality"><type>"locality"</type></link> property
 */
/**
 * folks_postal_address_set_locality:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--locality"><type>"locality"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--locality"><type>"locality"</type></link> property to @value.
 * 
 * The locality.
 * 
 * <para>The locality, for instance the city name.</para>
 */
/**
 * FolksPostalAddress:region:
 * 
 * The region.
 * 
 * <para>The region, for instance the name of the state or province.</para>
 */
/**
 * folks_postal_address_get_region:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--region"><type>"region"</type></link> property.
 * 
 * The region.
 * 
 * <para>The region, for instance the name of the state or province.</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--region"><type>"region"</type></link> property
 */
/**
 * folks_postal_address_set_region:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--region"><type>"region"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--region"><type>"region"</type></link> property to @value.
 * 
 * The region.
 * 
 * <para>The region, for instance the name of the state or province.</para>
 */
/**
 * FolksPostalAddress:postal-code:
 * 
 * The postal code.
 * 
 * <para>The postal code (also known as post code, postcode or ZIP code).</para>
 */
/**
 * folks_postal_address_get_postal_code:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--postal-code"><type>"postal-code"</type></link> property.
 * 
 * The postal code.
 * 
 * <para>The postal code (also known as post code, postcode or ZIP code).</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--postal-code"><type>"postal-code"</type></link> property
 */
/**
 * folks_postal_address_set_postal_code:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--postal-code"><type>"postal-code"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--postal-code"><type>"postal-code"</type></link> property to @value.
 * 
 * The postal code.
 * 
 * <para>The postal code (also known as post code, postcode or ZIP code).</para>
 */
/**
 * FolksPostalAddress:country:
 * 
 * The country.
 * 
 * <para>The name of the country.</para>
 */
/**
 * folks_postal_address_get_country:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--country"><type>"country"</type></link> property.
 * 
 * The country.
 * 
 * <para>The name of the country.</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--country"><type>"country"</type></link> property
 */
/**
 * folks_postal_address_set_country:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--country"><type>"country"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--country"><type>"country"</type></link> property to @value.
 * 
 * The country.
 * 
 * <para>The name of the country.</para>
 */
/**
 * FolksPostalAddress:address-format:
 * 
 * The address format.
 * 
 * <para>The two letter country code that determines the format or exact meaning of the other fields.</para>
 */
/**
 * folks_postal_address_get_address_format:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--address-format"><type>"address-format"</type></link> property.
 * 
 * The address format.
 * 
 * <para>The two letter country code that determines the format or exact meaning of the other fields.</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--address-format"><type>"address-format"</type></link> property
 */
/**
 * folks_postal_address_set_address_format:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--address-format"><type>"address-format"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--address-format"><type>"address-format"</type></link> property to @value.
 * 
 * The address format.
 * 
 * <para>The two letter country code that determines the format or exact meaning of the other fields.</para>
 */
/**
 * FolksPostalAddress:uid:
 * 
 * The UID of the Postal Address (if any).
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * folks_postal_address_get_uid:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddress--uid"><type>"uid"</type></link> property.
 * 
 * The UID of the Postal Address (if any).
 * 
 * Returns: the value of the <link linkend="FolksPostalAddress--uid"><type>"uid"</type></link> property
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * folks_postal_address_set_uid:
 * @self: the <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddress--uid"><type>"uid"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddress--uid"><type>"uid"</type></link> property to @value.
 * 
 * The UID of the Postal Address (if any).
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * FolksPostalAddress:
 * 
 * Object representing a postal mail address.
 * 
 * <para>The components of the address are never <code>null</code>: an empty string indicates that a property is not set.</para>
 */
/**
 * FolksPostalAddressClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-POSTAL-ADDRESS:CAPS"><literal>FOLKS_TYPE_POSTAL_ADDRESS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksPostalAddressFieldDetails"><type>FolksPostalAddressFieldDetails</type></link>.
 */
/**
 * folks_postal_address_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, a non-empty <link linkend="FolksPostalAddress"><type>FolksPostalAddress</type></link> </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to an empty map of parameters. </para>
 * 
 * Create a new PostalAddressFieldDetails.
 * 
 * Returns: <para>a new PostalAddressFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksPostalAddressFieldDetails:
 * 
 * Object representing a PostalAddress value that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksPostalAddressFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-POSTAL-ADDRESS-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_postal_address_details_change_postal_addresses:
 * @self: the <link linkend="FolksPostalAddressDetails"><type>FolksPostalAddressDetails</type></link> instance
 * @postal_addresses: (in): &nbsp;.  <para>the set of postal addresses </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s postal addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link> directly, as this method gives error notification and will only return once the addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-postal-address-details-change-postal-addresses-finish"><function>folks_postal_address_details_change_postal_addresses_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_postal_address_details_change_postal_addresses_finish:
 * @self: the <link linkend="FolksPostalAddressDetails"><type>FolksPostalAddressDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s postal addresses.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link> directly, as this method gives error notification and will only return once the addresses have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the addresses failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-postal-address-details-change-postal-addresses"><function>folks_postal_address_details_change_postal_addresses()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksPostalAddressDetails:postal-addresses:
 * 
 * The postal addresses of the contact.
 * 
 * <para>A list of postal addresses associated to the contact.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_postal_address_details_get_postal_addresses:
 * @self: the <link linkend="FolksPostalAddressDetails"><type>FolksPostalAddressDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link> property.
 * 
 * The postal addresses of the contact.
 * 
 * <para>A list of postal addresses associated to the contact.</para>
 * 
 * Returns: the value of the <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_postal_address_details_set_postal_addresses:
 * @self: the <link linkend="FolksPostalAddressDetails"><type>FolksPostalAddressDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link> property
 * 
 * Set the value of the <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link> property to @value.
 * 
 * The postal addresses of the contact.
 * 
 * <para>A list of postal addresses associated to the contact.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksPostalAddressDetails:
 * 
 * Interface for classes that can provide postal addresses, such as <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 */
/**
 * FolksPostalAddressDetailsIface:
 * @change_postal_addresses: virtual method called by <link linkend="folks-postal-address-details-change-postal-addresses"><function>folks_postal_address_details_change_postal_addresses()</function></link>
 * @change_postal_addresses_finish: asynchronous finish function for <structfield>change_postal_addresses</structfield>, called by <link linkend="folks-postal-address-details-change-postal-addresses"><function>folks_postal_address_details_change_postal_addresses()</function></link>
 * @get_postal_addresses: getter method for the abstract property <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link>
 * @set_postal_addresses: setter method for the abstract property <link linkend="FolksPostalAddressDetails--postal-addresses"><type>"postal-addresses"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksPostalAddressDetails"><type>FolksPostalAddressDetails</type></link> implementations.
 */
