/**
 * SECTION:local-id-details
 * @short_description: This interface represents the list of <link linkend="FolksPersona--iid"><type>"iid"</type></link>s corresponding to <link linkend="FolksPersona"><type>FolksPersona</type></link>s from backends with write support so that they can be linked.
 * 
 * <para>This is necessary so that personas from the same backend can be linked together even if they have no other linkeable properties set.</para>
 *
 * Since: 0.5.0
 */
/**
 * folks_local_id_details_change_local_ids:
 * @self: the <link linkend="FolksLocalIdDetails"><type>FolksLocalIdDetails</type></link> instance
 * @local_ids: (in): &nbsp;.  <para>the set of local IDs </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s local IDs.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link> directly, as this method gives error notification and will only return once the local IDs have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the local IDs failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-local-id-details-change-local-ids-finish"><function>folks_local_id_details_change_local_ids_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_local_id_details_change_local_ids_finish:
 * @self: the <link linkend="FolksLocalIdDetails"><type>FolksLocalIdDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s local IDs.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link> directly, as this method gives error notification and will only return once the local IDs have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the local IDs failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-local-id-details-change-local-ids"><function>folks_local_id_details_change_local_ids()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksLocalIdDetails:local-ids:
 * 
 * The IIDs corresponding to <link linkend="FolksPersona"><type>FolksPersona</type></link>s in a backend that we fully trust.
 *
 * Since: 0.5.1
 */
/**
 * folks_local_id_details_get_local_ids:
 * @self: the <link linkend="FolksLocalIdDetails"><type>FolksLocalIdDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link> property.
 * 
 * The IIDs corresponding to <link linkend="FolksPersona"><type>FolksPersona</type></link>s in a backend that we fully trust.
 * 
 * Returns: the value of the <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_local_id_details_set_local_ids:
 * @self: the <link linkend="FolksLocalIdDetails"><type>FolksLocalIdDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link> property
 * 
 * Set the value of the <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link> property to @value.
 * 
 * The IIDs corresponding to <link linkend="FolksPersona"><type>FolksPersona</type></link>s in a backend that we fully trust.
 *
 * Since: 0.5.1
 */
/**
 * FolksLocalIdDetails:
 * 
 * This interface represents the list of <link linkend="FolksPersona--iid"><type>"iid"</type></link>s corresponding to <link linkend="FolksPersona"><type>FolksPersona</type></link>s from backends with write support so that they can be linked.
 * 
 * <para>This is necessary so that personas from the same backend can be linked together even if they have no other linkeable properties set.</para>
 *
 * Since: 0.5.0
 */
/**
 * FolksLocalIdDetailsIface:
 * @change_local_ids: virtual method called by <link linkend="folks-local-id-details-change-local-ids"><function>folks_local_id_details_change_local_ids()</function></link>
 * @change_local_ids_finish: asynchronous finish function for <structfield>change_local_ids</structfield>, called by <link linkend="folks-local-id-details-change-local-ids"><function>folks_local_id_details_change_local_ids()</function></link>
 * @get_local_ids: getter method for the abstract property <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link>
 * @set_local_ids: setter method for the abstract property <link linkend="FolksLocalIdDetails--local-ids"><type>"local-ids"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksLocalIdDetails"><type>FolksLocalIdDetails</type></link> implementations.
 */
