/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.internal.util.Contract;
import org.abego.treelayout.internal.util.java.lang.string.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLayout<TreeNode> {
    private final TreeForTreeLayout<TreeNode> tree;
    private final NodeExtentProvider<TreeNode> nodeExtentProvider;
    private final Configuration<TreeNode> configuration;
    private double boundsLeft = Double.MAX_VALUE;
    private double boundsRight = Double.MIN_VALUE;
    private double boundsTop = Double.MAX_VALUE;
    private double boundsBottom = Double.MIN_VALUE;
    private final List<Double> sizeOfLevel = new ArrayList<Double>();
    private final boolean useIdentity;
    private final Map<TreeNode, Double> mod;
    private final Map<TreeNode, TreeNode> thread;
    private final Map<TreeNode, Double> prelim;
    private final Map<TreeNode, Double> change;
    private final Map<TreeNode, Double> shift;
    private final Map<TreeNode, TreeNode> ancestor;
    private final Map<TreeNode, Integer> number;
    private final Map<TreeNode, Point2D> positions;
    private Map<TreeNode, Rectangle2D.Double> nodeBounds;

    public TreeForTreeLayout<TreeNode> getTree() {
        return this.tree;
    }

    public NodeExtentProvider<TreeNode> getNodeExtentProvider() {
        return this.nodeExtentProvider;
    }

    private double getNodeHeight(TreeNode node) {
        return this.nodeExtentProvider.getHeight(node);
    }

    private double getNodeWidth(TreeNode node) {
        return this.nodeExtentProvider.getWidth(node);
    }

    private double getWidthOrHeightOfNode(TreeNode treeNode, boolean returnWidth) {
        return returnWidth ? this.getNodeWidth(treeNode) : this.getNodeHeight(treeNode);
    }

    private double getNodeThickness(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, !this.isLevelChangeInYAxis());
    }

    private double getNodeSize(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, this.isLevelChangeInYAxis());
    }

    public Configuration<TreeNode> getConfiguration() {
        return this.configuration;
    }

    private boolean isLevelChangeInYAxis() {
        Configuration.Location rootLocation = this.configuration.getRootLocation();
        return rootLocation == Configuration.Location.Top || rootLocation == Configuration.Location.Bottom;
    }

    private int getLevelChangeSign() {
        Configuration.Location rootLocation = this.configuration.getRootLocation();
        return rootLocation == Configuration.Location.Bottom || rootLocation == Configuration.Location.Right ? -1 : 1;
    }

    private void updateBounds(TreeNode node, double centerX, double centerY) {
        double width = this.getNodeWidth(node);
        double height = this.getNodeHeight(node);
        double left = centerX - width / 2.0;
        double right = centerX + width / 2.0;
        double top = centerY - height / 2.0;
        double bottom = centerY + height / 2.0;
        if (this.boundsLeft > left) {
            this.boundsLeft = left;
        }
        if (this.boundsRight < right) {
            this.boundsRight = right;
        }
        if (this.boundsTop > top) {
            this.boundsTop = top;
        }
        if (this.boundsBottom < bottom) {
            this.boundsBottom = bottom;
        }
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.boundsRight - this.boundsLeft, this.boundsBottom - this.boundsTop);
    }

    private void calcSizeOfLevels(TreeNode node, int level) {
        double oldSize;
        if (this.sizeOfLevel.size() <= level) {
            this.sizeOfLevel.add(0.0);
            oldSize = 0.0;
        } else {
            oldSize = this.sizeOfLevel.get(level);
        }
        double size = this.getNodeThickness(node);
        if (oldSize < size) {
            this.sizeOfLevel.set(level, size);
        }
        if (!this.tree.isLeaf(node)) {
            for (TreeNode child : this.tree.getChildren(node)) {
                this.calcSizeOfLevels(child, level + 1);
            }
        }
    }

    public int getLevelCount() {
        return this.sizeOfLevel.size();
    }

    public double getSizeOfLevel(int level) {
        Contract.checkArg(level >= 0, "level must be >= 0");
        Contract.checkArg(level < this.getLevelCount(), "level must be < levelCount");
        return this.sizeOfLevel.get(level);
    }

    private double getMod(TreeNode node) {
        Double d = this.mod.get(node);
        return d != null ? d : 0.0;
    }

    private void setMod(TreeNode node, double d) {
        this.mod.put(node, d);
    }

    private TreeNode getThread(TreeNode node) {
        TreeNode n = this.thread.get(node);
        return (TreeNode)(n != null ? n : null);
    }

    private void setThread(TreeNode node, TreeNode thread) {
        this.thread.put(node, thread);
    }

    private TreeNode getAncestor(TreeNode node) {
        TreeNode n = this.ancestor.get(node);
        return n != null ? n : node;
    }

    private void setAncestor(TreeNode node, TreeNode ancestor) {
        this.ancestor.put(node, ancestor);
    }

    private double getPrelim(TreeNode node) {
        Double d = this.prelim.get(node);
        return d != null ? d : 0.0;
    }

    private void setPrelim(TreeNode node, double d) {
        this.prelim.put(node, d);
    }

    private double getChange(TreeNode node) {
        Double d = this.change.get(node);
        return d != null ? d : 0.0;
    }

    private void setChange(TreeNode node, double d) {
        this.change.put(node, d);
    }

    private double getShift(TreeNode node) {
        Double d = this.shift.get(node);
        return d != null ? d : 0.0;
    }

    private void setShift(TreeNode node, double d) {
        this.shift.put(node, d);
    }

    private double getDistance(TreeNode v, TreeNode w) {
        double sizeOfNodes = this.getNodeSize(v) + this.getNodeSize(w);
        double distance = sizeOfNodes / 2.0 + this.configuration.getGapBetweenNodes(v, w);
        return distance;
    }

    private TreeNode nextLeft(TreeNode v) {
        return this.tree.isLeaf(v) ? this.getThread(v) : this.tree.getFirstChild(v);
    }

    private TreeNode nextRight(TreeNode v) {
        return this.tree.isLeaf(v) ? this.getThread(v) : this.tree.getLastChild(v);
    }

    private int getNumber(TreeNode node, TreeNode parentNode) {
        Integer n = this.number.get(node);
        if (n == null) {
            int i = 1;
            for (TreeNode child : this.tree.getChildren(parentNode)) {
                this.number.put(child, i++);
            }
            n = this.number.get(node);
        }
        return n;
    }

    private TreeNode ancestor(TreeNode vIMinus, TreeNode v, TreeNode parentOfV, TreeNode defaultAncestor) {
        TreeNode ancestor = this.getAncestor(vIMinus);
        return this.tree.isChildOfParent(ancestor, parentOfV) ? ancestor : defaultAncestor;
    }

    private void moveSubtree(TreeNode wMinus, TreeNode wPlus, TreeNode parent, double shift) {
        int subtrees = this.getNumber(wPlus, parent) - this.getNumber(wMinus, parent);
        this.setChange(wPlus, this.getChange(wPlus) - shift / (double)subtrees);
        this.setShift(wPlus, this.getShift(wPlus) + shift);
        this.setChange(wMinus, this.getChange(wMinus) + shift / (double)subtrees);
        this.setPrelim(wPlus, this.getPrelim(wPlus) + shift);
        this.setMod(wPlus, this.getMod(wPlus) + shift);
    }

    private TreeNode apportion(TreeNode v, TreeNode defaultAncestor, TreeNode leftSibling, TreeNode parentOfV) {
        TreeNode w = leftSibling;
        if (w == null) {
            return defaultAncestor;
        }
        TreeNode vOPlus = v;
        TreeNode vIPlus = v;
        TreeNode vIMinus = w;
        TreeNode vOMinus = this.tree.getFirstChild(parentOfV);
        Double sIPlus = this.getMod(vIPlus);
        Double sOPlus = this.getMod(vOPlus);
        Double sIMinus = this.getMod(vIMinus);
        Double sOMinus = this.getMod(vOMinus);
        TreeNode nextRightVIMinus = this.nextRight(vIMinus);
        TreeNode nextLeftVIPlus = this.nextLeft(vIPlus);
        while (nextRightVIMinus != null && nextLeftVIPlus != null) {
            vIMinus = nextRightVIMinus;
            vIPlus = nextLeftVIPlus;
            vOMinus = this.nextLeft(vOMinus);
            vOPlus = this.nextRight(vOPlus);
            this.setAncestor(vOPlus, v);
            double shift = this.getPrelim(vIMinus) + sIMinus - (this.getPrelim(vIPlus) + sIPlus) + this.getDistance(vIMinus, vIPlus);
            if (shift > 0.0) {
                this.moveSubtree(this.ancestor(vIMinus, v, parentOfV, defaultAncestor), v, parentOfV, shift);
                sIPlus = sIPlus + shift;
                sOPlus = sOPlus + shift;
            }
            sIMinus = sIMinus + this.getMod(vIMinus);
            sIPlus = sIPlus + this.getMod(vIPlus);
            sOMinus = sOMinus + this.getMod(vOMinus);
            sOPlus = sOPlus + this.getMod(vOPlus);
            nextRightVIMinus = this.nextRight(vIMinus);
            nextLeftVIPlus = this.nextLeft(vIPlus);
        }
        if (nextRightVIMinus != null && this.nextRight(vOPlus) == null) {
            this.setThread(vOPlus, nextRightVIMinus);
            this.setMod(vOPlus, this.getMod(vOPlus) + sIMinus - sOPlus);
        }
        if (nextLeftVIPlus != null && this.nextLeft(vOMinus) == null) {
            this.setThread(vOMinus, nextLeftVIPlus);
            this.setMod(vOMinus, this.getMod(vOMinus) + sIPlus - sOMinus);
            defaultAncestor = v;
        }
        return defaultAncestor;
    }

    private void executeShifts(TreeNode v) {
        double shift = 0.0;
        double change = 0.0;
        for (TreeNode w : this.tree.getChildrenReverse(v)) {
            this.setPrelim(w, this.getPrelim(w) + shift);
            this.setMod(w, this.getMod(w) + shift);
            shift = shift + this.getShift(w) + (change += this.getChange(w));
        }
    }

    private void firstWalk(TreeNode v, TreeNode leftSibling) {
        if (this.tree.isLeaf(v)) {
            TreeNode w = leftSibling;
            if (w != null) {
                this.setPrelim(v, this.getPrelim(w) + this.getDistance(v, w));
            }
        } else {
            TreeNode defaultAncestor = this.tree.getFirstChild(v);
            TreeNode previousChild = null;
            for (TreeNode w : this.tree.getChildren(v)) {
                this.firstWalk(w, previousChild);
                defaultAncestor = this.apportion(w, defaultAncestor, previousChild, v);
                previousChild = w;
            }
            this.executeShifts(v);
            double midpoint = (this.getPrelim(this.tree.getFirstChild(v)) + this.getPrelim(this.tree.getLastChild(v))) / 2.0;
            TreeNode w = leftSibling;
            if (w != null) {
                this.setPrelim(v, this.getPrelim(w) + this.getDistance(v, w));
                this.setMod(v, this.getPrelim(v) - midpoint);
            } else {
                this.setPrelim(v, midpoint);
            }
        }
    }

    private void secondWalk(TreeNode v, double m, int level, double levelStart) {
        double levelChangeSign = this.getLevelChangeSign();
        boolean levelChangeOnYAxis = this.isLevelChangeInYAxis();
        double levelSize = this.getSizeOfLevel(level);
        double x = this.getPrelim(v) + m;
        Configuration.AlignmentInLevel alignment = this.configuration.getAlignmentInLevel();
        double y = alignment == Configuration.AlignmentInLevel.Center ? levelStart + levelChangeSign * (levelSize / 2.0) : (alignment == Configuration.AlignmentInLevel.TowardsRoot ? levelStart + levelChangeSign * (this.getNodeThickness(v) / 2.0) : levelStart + levelSize - levelChangeSign * (this.getNodeThickness(v) / 2.0));
        if (!levelChangeOnYAxis) {
            double t = x;
            x = y;
            y = t;
        }
        this.positions.put(v, new NormalizedPosition(x, y));
        this.updateBounds(v, x, y);
        if (!this.tree.isLeaf(v)) {
            double nextLevelStart = levelStart + (levelSize + this.configuration.getGapBetweenLevels(level + 1)) * levelChangeSign;
            for (TreeNode w : this.tree.getChildren(v)) {
                this.secondWalk(w, m + this.getMod(v), level + 1, nextLevelStart);
            }
        }
    }

    public Map<TreeNode, Rectangle2D.Double> getNodeBounds() {
        if (this.nodeBounds == null) {
            this.nodeBounds = this.useIdentity ? new IdentityHashMap() : new HashMap();
            for (Map.Entry<TreeNode, Point2D> entry : this.positions.entrySet()) {
                TreeNode node = entry.getKey();
                Point2D pos = entry.getValue();
                double w = this.getNodeWidth(node);
                double h = this.getNodeHeight(node);
                double x = pos.getX() - w / 2.0;
                double y = pos.getY() - h / 2.0;
                this.nodeBounds.put(node, new Rectangle2D.Double(x, y, w, h));
            }
        }
        return this.nodeBounds;
    }

    public TreeLayout(TreeForTreeLayout<TreeNode> tree, NodeExtentProvider<TreeNode> nodeExtentProvider, Configuration<TreeNode> configuration, boolean useIdentity) {
        this.tree = tree;
        this.nodeExtentProvider = nodeExtentProvider;
        this.configuration = configuration;
        this.useIdentity = useIdentity;
        if (this.useIdentity) {
            this.mod = new IdentityHashMap<TreeNode, Double>();
            this.thread = new IdentityHashMap<TreeNode, TreeNode>();
            this.prelim = new IdentityHashMap<TreeNode, Double>();
            this.change = new IdentityHashMap<TreeNode, Double>();
            this.shift = new IdentityHashMap<TreeNode, Double>();
            this.ancestor = new IdentityHashMap<TreeNode, TreeNode>();
            this.number = new IdentityHashMap<TreeNode, Integer>();
            this.positions = new IdentityHashMap<TreeNode, Point2D>();
        } else {
            this.mod = new HashMap<TreeNode, Double>();
            this.thread = new HashMap<TreeNode, TreeNode>();
            this.prelim = new HashMap<TreeNode, Double>();
            this.change = new HashMap<TreeNode, Double>();
            this.shift = new HashMap<TreeNode, Double>();
            this.ancestor = new HashMap<TreeNode, TreeNode>();
            this.number = new HashMap<TreeNode, Integer>();
            this.positions = new HashMap<TreeNode, Point2D>();
        }
        TreeNode r = tree.getRoot();
        this.firstWalk(r, null);
        this.calcSizeOfLevels(r, 0);
        this.secondWalk(r, -this.getPrelim(r), 0, 0.0);
    }

    public TreeLayout(TreeForTreeLayout<TreeNode> tree, NodeExtentProvider<TreeNode> nodeExtentProvider, Configuration<TreeNode> configuration) {
        this(tree, nodeExtentProvider, configuration, false);
    }

    private void addUniqueNodes(Map<TreeNode, TreeNode> nodes, TreeNode newNode) {
        if (nodes.put(newNode, newNode) != null) {
            throw new RuntimeException(String.format("Node used more than once in tree: %s", newNode));
        }
        for (TreeNode n : this.tree.getChildren(newNode)) {
            this.addUniqueNodes(nodes, n);
        }
    }

    public void checkTree() {
        AbstractMap nodes = this.useIdentity ? new IdentityHashMap() : new HashMap();
        this.addUniqueNodes(nodes, this.tree.getRoot());
    }

    private void dumpTree(PrintStream output, TreeNode node, int indent, DumpConfiguration dumpConfiguration) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(dumpConfiguration.indent);
        }
        if (dumpConfiguration.includeObjectToString) {
            sb.append("[");
            sb.append(node.getClass().getName() + "@" + Integer.toHexString(node.hashCode()));
            if (node.hashCode() != System.identityHashCode(node)) {
                sb.append("/identityHashCode:");
                sb.append(Integer.toHexString(System.identityHashCode(node)));
            }
            sb.append("]");
        }
        sb.append(StringUtil.quote(node != null ? node.toString() : null));
        if (dumpConfiguration.includeNodeSize) {
            sb.append(" (size: ");
            sb.append(this.getNodeWidth(node));
            sb.append("x");
            sb.append(this.getNodeHeight(node));
            sb.append(")");
        }
        output.println(sb.toString());
        for (TreeNode n : this.tree.getChildren(node)) {
            this.dumpTree(output, n, indent + 1, dumpConfiguration);
        }
    }

    public void dumpTree(PrintStream printStream, DumpConfiguration dumpConfiguration) {
        this.dumpTree(printStream, this.tree.getRoot(), 0, dumpConfiguration);
    }

    public void dumpTree(PrintStream printStream) {
        this.dumpTree(printStream, new DumpConfiguration());
    }

    public static class DumpConfiguration {
        public final String indent;
        public final boolean includeNodeSize;
        public final boolean includeObjectToString;

        public DumpConfiguration(String indent, boolean includeNodeSize, boolean includePointer) {
            this.indent = indent;
            this.includeNodeSize = includeNodeSize;
            this.includeObjectToString = includePointer;
        }

        public DumpConfiguration() {
            this("    ", false, false);
        }
    }

    private class NormalizedPosition
    extends Point2D {
        private double x_relativeToRoot;
        private double y_relativeToRoot;

        public NormalizedPosition(double x_relativeToRoot, double y_relativeToRoot) {
            this.setLocation(x_relativeToRoot, y_relativeToRoot);
        }

        public double getX() {
            return this.x_relativeToRoot - TreeLayout.this.boundsLeft;
        }

        public double getY() {
            return this.y_relativeToRoot - TreeLayout.this.boundsTop;
        }

        public void setLocation(double x_relativeToRoot, double y_relativeToRoot) {
            this.x_relativeToRoot = x_relativeToRoot;
            this.y_relativeToRoot = y_relativeToRoot;
        }
    }
}

