/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PurchaseRequest> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(PurchaseRequest.getter(PurchaseRequest::instanceCount)).setter(PurchaseRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("InstanceCount").build()}).build();
    private static final SdkField<String> PURCHASE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PurchaseToken").getter(PurchaseRequest.getter(PurchaseRequest::purchaseToken)).setter(PurchaseRequest.setter(Builder::purchaseToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PurchaseToken").unmarshallLocationName("PurchaseToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, PURCHASE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final String purchaseToken;

    private PurchaseRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.purchaseToken = builder.purchaseToken;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String purchaseToken() {
        return this.purchaseToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchaseToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseRequest)) {
            return false;
        }
        PurchaseRequest other = (PurchaseRequest)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.purchaseToken(), other.purchaseToken());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseRequest").add("InstanceCount", (Object)this.instanceCount()).add("PurchaseToken", (Object)this.purchaseToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "PurchaseToken": {
                return Optional.ofNullable(clazz.cast(this.purchaseToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("PurchaseToken", PURCHASE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseRequest, T> g) {
        return obj -> g.apply((PurchaseRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String purchaseToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseRequest model) {
            this.instanceCount(model.instanceCount);
            this.purchaseToken(model.purchaseToken);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getPurchaseToken() {
            return this.purchaseToken;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        @Override
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public PurchaseRequest build() {
            return new PurchaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PurchaseRequest> {
        public Builder instanceCount(Integer var1);

        public Builder purchaseToken(String var1);
    }
}

