/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.configuration;

import com.hankcs.hanlp.dependency.perceptron.accessories.Edge;
import com.hankcs.hanlp.dependency.perceptron.structures.Sentence;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.State;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.Action;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.ArcEager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Instance {
    protected HashMap<Integer, Edge> goldDependencies = new HashMap();
    protected HashMap<Integer, HashSet<Integer>> reversedDependencies = new HashMap();
    protected Sentence sentence;

    public Instance(Sentence sentence, HashMap<Integer, Edge> goldDependencies) {
        for (Map.Entry<Integer, Edge> entry : goldDependencies.entrySet()) {
            Integer dependent = entry.getKey();
            Edge edge = entry.getValue();
            int head = edge.headIndex;
            this.goldDependencies.put(dependent, edge.clone());
            HashSet<Integer> dependents = this.reversedDependencies.get(head);
            if (dependents == null) {
                dependents = new HashSet();
                this.reversedDependencies.put(head, dependents);
            }
            dependents.add(dependent);
        }
        this.sentence = sentence;
    }

    public Sentence getSentence() {
        return this.sentence;
    }

    public int head(int dependent) {
        if (!this.goldDependencies.containsKey(dependent)) {
            return -1;
        }
        return this.goldDependencies.get((Object)Integer.valueOf((int)dependent)).headIndex;
    }

    public String relation(int dependent) {
        if (!this.goldDependencies.containsKey(dependent)) {
            return "_";
        }
        return this.goldDependencies.get((Object)Integer.valueOf((int)dependent)).relationId + "";
    }

    public HashMap<Integer, Edge> getGoldDependencies() {
        return this.goldDependencies;
    }

    public boolean isNonprojective() {
        for (int dep1 : this.goldDependencies.keySet()) {
            int head1 = this.goldDependencies.get((Object)Integer.valueOf((int)dep1)).headIndex;
            for (int dep2 : this.goldDependencies.keySet()) {
                int head2 = this.goldDependencies.get((Object)Integer.valueOf((int)dep2)).headIndex;
                if (head1 < 0 || head2 < 0) continue;
                if (dep1 > head1 && head1 != head2 && (dep1 > head2 && dep1 < dep2 && head1 < head2 || dep1 < head2 && dep1 > dep2 && head1 < dep2)) {
                    return true;
                }
                if (dep1 >= head1 || head1 == head2 || (head1 <= head2 || head1 >= dep2 || dep1 >= head2) && (head1 >= head2 || head1 <= dep2 || dep1 >= dep2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartial(boolean rootFirst) {
        for (int i = 0; i < this.sentence.size(); ++i) {
            if (!rootFirst && i >= this.sentence.size() - 1 || this.goldDependencies.containsKey(i + 1)) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, HashSet<Integer>> getReversedDependencies() {
        return this.reversedDependencies;
    }

    public int actionCost(Action action, int dependency, State state) {
        int cost;
        block17: {
            int stackHead;
            block19: {
                int bufferItem;
                block18: {
                    block16: {
                        int stackHead2;
                        int bufferHead;
                        if (!ArcEager.canDo(action, state)) {
                            return Integer.MAX_VALUE;
                        }
                        cost = 0;
                        if (action == Action.LeftArc) {
                            bufferHead = state.bufferHead();
                            stackHead2 = state.stackTop();
                            if (this.goldDependencies.containsKey(stackHead2) && this.goldDependencies.get((Object)Integer.valueOf((int)stackHead2)).headIndex == bufferHead && this.goldDependencies.get((Object)Integer.valueOf((int)stackHead2)).relationId != dependency) {
                                ++cost;
                            }
                        } else if (action == Action.RightArc) {
                            bufferHead = state.bufferHead();
                            stackHead2 = state.stackTop();
                            if (this.goldDependencies.containsKey(bufferHead) && this.goldDependencies.get((Object)Integer.valueOf((int)bufferHead)).headIndex == stackHead2 && this.goldDependencies.get((Object)Integer.valueOf((int)bufferHead)).relationId != dependency) {
                                ++cost;
                            }
                        }
                        if (action != Action.Shift) break block16;
                        bufferHead = state.bufferHead();
                        for (int stackItem : state.getStack()) {
                            if (this.goldDependencies.containsKey(stackItem) && this.goldDependencies.get((Object)Integer.valueOf((int)stackItem)).headIndex == bufferHead) {
                                ++cost;
                            }
                            if (!this.goldDependencies.containsKey(bufferHead) || this.goldDependencies.get((Object)Integer.valueOf((int)bufferHead)).headIndex != stackItem) continue;
                            ++cost;
                        }
                        break block17;
                    }
                    if (action != Action.Reduce) break block18;
                    stackHead = state.stackTop();
                    if (state.bufferEmpty()) break block17;
                    for (bufferItem = state.bufferHead(); bufferItem <= state.maxSentenceSize; ++bufferItem) {
                        if (!this.goldDependencies.containsKey(bufferItem) || this.goldDependencies.get((Object)Integer.valueOf((int)bufferItem)).headIndex != stackHead) continue;
                        ++cost;
                    }
                    break block17;
                }
                if (action != Action.LeftArc || cost != 0) break block19;
                stackHead = state.stackTop();
                if (state.bufferEmpty()) break block17;
                for (bufferItem = state.bufferHead(); bufferItem <= state.maxSentenceSize; ++bufferItem) {
                    if (this.goldDependencies.containsKey(bufferItem) && this.goldDependencies.get((Object)Integer.valueOf((int)bufferItem)).headIndex == stackHead) {
                        ++cost;
                    }
                    if (!this.goldDependencies.containsKey(stackHead) || this.goldDependencies.get((Object)Integer.valueOf((int)stackHead)).headIndex != bufferItem || bufferItem == state.bufferHead()) continue;
                    ++cost;
                }
                break block17;
            }
            if (action == Action.RightArc && cost == 0) {
                stackHead = state.stackTop();
                int bufferHead = state.bufferHead();
                for (int stackItem : state.getStack()) {
                    if (this.goldDependencies.containsKey(bufferHead) && this.goldDependencies.get((Object)Integer.valueOf((int)bufferHead)).headIndex == stackItem && stackItem != stackHead) {
                        ++cost;
                    }
                    if (!this.goldDependencies.containsKey(stackItem) || this.goldDependencies.get((Object)Integer.valueOf((int)stackItem)).headIndex != bufferHead) continue;
                    ++cost;
                }
                if (!state.bufferEmpty()) {
                    for (int bufferItem = state.bufferHead(); bufferItem <= state.maxSentenceSize; ++bufferItem) {
                        if (!this.goldDependencies.containsKey(bufferHead) || this.goldDependencies.get((Object)Integer.valueOf((int)bufferHead)).headIndex != bufferItem) continue;
                        ++cost;
                    }
                }
            }
        }
        return cost;
    }
}

