/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonTableFunction;
import org.hibernate.dialect.function.json.JsonTableSetReturningFunctionTypeResolver;
import org.hibernate.dialect.function.json.OracleJsonValueFunction;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonTableErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableQueryColumnDefinition;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonAsStringJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleJsonTableFunction
extends JsonTableFunction {
    public OracleJsonTableFunction(TypeConfiguration typeConfiguration) {
        super(new OracleJsonTableSetReturningFunctionTypeResolver(), typeConfiguration);
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, JsonTableFunction.JsonTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_table(");
        arguments.jsonDocument().accept(walker);
        if (arguments.jsonPath() != null) {
            sqlAppender.appendSql(',');
            JsonPathPassingClause passingClause = arguments.passingClause();
            if (passingClause != null) {
                JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
            } else {
                arguments.jsonPath().accept(walker);
            }
        }
        if (arguments.errorBehavior() == JsonTableErrorBehavior.ERROR) {
            sqlAppender.appendSql(" error on error");
        }
        this.renderColumns(sqlAppender, arguments.columnsClause(), 0, walker);
        sqlAppender.appendSql(')');
    }

    @Override
    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        String typeName;
        return switch (typeName = super.determineColumnType(castTarget, walker)) {
            case "float", "binary_float", "binary_double" -> "number";
            case "number(1,0)" -> {
                if (OracleJsonValueFunction.isEncodedBoolean(castTarget.getJdbcMapping())) {
                    yield "varchar2(5)";
                }
                yield typeName;
            }
            case "blob" -> {
                if (this.isJson(castTarget.getJdbcMapping())) {
                    yield "clob";
                }
                yield typeName;
            }
            default -> typeName;
        };
    }

    private boolean isJson(JdbcMapping jdbcMapping) {
        return jdbcMapping.getJdbcType().isJson();
    }

    private static class OracleJsonTableSetReturningFunctionTypeResolver
    extends JsonTableSetReturningFunctionTypeResolver {
        private OracleJsonTableSetReturningFunctionTypeResolver() {
        }

        @Override
        protected void addSelectableMappings(List<SelectableMapping> selectableMappings, JsonTableQueryColumnDefinition definition, SqmToSqlAstConverter converter) {
            TypeConfiguration typeConfiguration = converter.getCreationContext().getTypeConfiguration();
            JdbcType jsonType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(3001);
            if (jsonType.getDdlTypeCode() == 2004) {
                this.addSelectableMapping(selectableMappings, definition.name(), typeConfiguration.getBasicTypeRegistry().resolve(typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)String.class)), JsonAsStringJdbcType.CLOB_INSTANCE), converter);
            } else {
                super.addSelectableMappings(selectableMappings, definition, converter);
            }
        }

        @Override
        protected void addSelectableMapping(List<SelectableMapping> selectableMappings, String name, JdbcMapping type, SqmToSqlAstConverter converter) {
            if (OracleJsonValueFunction.isEncodedBoolean(type)) {
                JdbcLiteralFormatter jdbcLiteralFormatter = type.getJdbcLiteralFormatter();
                Dialect dialect = converter.getCreationContext().getDialect();
                WrapperOptions wrapperOptions = converter.getCreationContext().getWrapperOptions();
                Object trueValue = type.convertToRelationalValue(true);
                Object falseValue = type.convertToRelationalValue(false);
                String trueFragment = jdbcLiteralFormatter.toJdbcLiteral(trueValue, dialect, wrapperOptions);
                String falseFragment = jdbcLiteralFormatter.toJdbcLiteral(falseValue, dialect, wrapperOptions);
                selectableMappings.add(new SelectableMappingImpl("", name, new SelectablePath(name), "decode({@}." + name + ",'true'," + trueFragment + ",'false'," + falseFragment + ")", null, "varchar2(5)", null, null, null, null, false, false, false, false, false, false, type));
            } else {
                super.addSelectableMapping(selectableMappings, name, type, converter);
            }
        }
    }
}

