/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

The STAPLE filter implements the Simultaneous Truth and Performance
Level Estimation algorithm for generating ground truth volumes from a
set of binary expert segmentations.


The STAPLE algorithm treats segmentation as a pixelwise
classification, which leads to an averaging scheme that accounts for
systematic biases in the behavior of experts in order to generate a
fuzzy ground truth volume and simultaneous accuracy assessment of each
expert. The ground truth volumes produced by this filter are floating
point volumes of values between zero and one that indicate probability
of each pixel being in the object targeted by the segmentation.

The STAPLE algorithm is described in

S. Warfield, K. Zou, W. Wells, "Validation of image segmentation and
expert quality with an expectation-maximization algorithm" in MICCAI
2002: Fifth International Conference on Medical Image Computing and Computer-Assisted Intervention, Springer-Verlag,
Heidelberg, Germany, 2002, pp. 298-306

INPUTS
Input volumes to the STAPLE filter must be binary segmentations of an
image, that is, there must be a single foreground value that
represents positively classified pixels (pixels that are considered to
belong inside the segmentation). Any number of background pixel values
may be present in the input images. You can, for example, input
volumes with many different labels as long as the structure you are
interested in creating ground truth for is consistently labeled among
all input volumes. Pixel type of the input volumes does not matter.
Specify the label value for positively classified pixels using
SetForegroundValue. All other labels will be considered to be
negatively classified pixels (background).
 Input volumes must all contain the same size RequestedRegions.

OUTPUTS
The STAPLE filter produces a single output volume with a range of
floating point values from zero to one. IT IS VERY IMPORTANT TO
INSTANTIATE THIS FILTER WITH A FLOATING POINT OUTPUT TYPE (floats or
doubles). You may threshold the output above some probability
threshold if you wish to produce a binary ground truth.
PARAMETERS
The STAPLE algorithm requires a number of inputs. You may specify any
number of input volumes using the SetInput(i, p_i) method, where i
ranges from zero to N-1, N is the total number of input segmentations,
and p_i is the SmartPointer to the i-th segmentation.
 The SetConfidenceWeight parameter is a modifier for the prior
probability that any pixel would be classified as inside the target
object. This implementation of the STAPLE algorithm automatically
calculates prior positive classification probability as the average
fraction of the image volume filled by the target object in each input
segmentation. The ConfidenceWeight parameter allows for scaling the of
this default prior probability: if g_t is the prior probability that a
pixel would be classified inside the target object, then g_t is set to
g_t * ConfidenceWeight before iterating on the solution. In general
ConfidenceWeight should be left to the default of 1.0.

You must provide a foreground value using SetForegroundValue that the
STAPLE algorithm will use to identify positively classified pixels in
the input images. All other values in the image will be treated as
background values. For example, if your input segmentations consist of
1's everywhere inside the segmented region, then use
SetForegroundValue(1).

The STAPLE algorithm is an iterative E-M algorithm and will converge
on a solution after some number of iterations that cannot be known a
priori. After updating the filter, the total elapsed iterations taken
to converge on the solution can be queried through GetElapsedIterations() . You may also specify a MaximumNumberOfIterations, after which the
algorithm will stop iterating regardless of whether or not it has
converged. This implementation of the STAPLE algorithm will find the
solution to within seven digits of precision unless it is stopped
early.

Once updated, the Sensitivity (true positive fraction, q) and
Specificity (true negative fraction, q) for each expert input volume
can be queried using GetSensitivity(i) and GetSpecificity(i), where i
is the i-th input volume.

REQUIRED PARAMETERS
The only required parameters for this filter are the ForegroundValue
and the input volumes. All other parameters may be safely left to
their default values. Please see the paper cited above for more
information on the STAPLE algorithm and its parameters. A proper
understanding of the algorithm is important for interpreting the
results that it produces.
EVENTS
This filter invokes IterationEvent() at each iteration of the E-M
algorithm. Setting the AbortGenerateData() flag will cause the
algorithm to halt after the current iteration and produce results just
as if it had converged. The algorithm makes no attempt to report its
progress since the number of iterations needed cannot be known in
advance.

See:
 itk::simple::STAPLE for the procedural interface


C++ includes: sitkSTAPLEImageFilter.h
*/
public class STAPLEImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected STAPLEImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.STAPLEImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(STAPLEImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(STAPLEImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::STAPLEImageFilter::~STAPLEImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_STAPLEImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::STAPLEImageFilter::STAPLEImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  STAPLEImageFilter() {
    this(SimpleITKJNI.new_STAPLEImageFilter(), true);
  }

  /**
Self&amp; itk::simple::STAPLEImageFilter::SetConfidenceWeight(double ConfidenceWeight)

Scales the estimated prior probability that a pixel will be inside the
targeted object of segmentation. The default prior probability g_t is
calculated automatically as the average fraction of positively
classified pixels to the total size of the volume (across all input
volumes). ConfidenceWeight will scale this default value as g_t = g_t
* ConfidenceWeight. In general, ConfidenceWeight should be left to the
default of 1.0.

*/
public  void setConfidenceWeight(double ConfidenceWeight) {
    SimpleITKJNI.STAPLEImageFilter_setConfidenceWeight(swigCPtr, this, ConfidenceWeight);
  }

  /**
double itk::simple::STAPLEImageFilter::GetConfidenceWeight() const

Scales the estimated prior probability that a pixel will be inside the
targeted object of segmentation. The default prior probability g_t is
calculated automatically as the average fraction of positively
classified pixels to the total size of the volume (across all input
volumes). ConfidenceWeight will scale this default value as g_t = g_t
* ConfidenceWeight. In general, ConfidenceWeight should be left to the
default of 1.0.

*/
public  double getConfidenceWeight() {
    return SimpleITKJNI.STAPLEImageFilter_getConfidenceWeight(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::STAPLEImageFilter::SetForegroundValue(double ForegroundValue)

Set get the binary ON value of the input image.

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.STAPLEImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::STAPLEImageFilter::GetForegroundValue() const

Set get the binary ON value of the input image.

*/
public  double getForegroundValue() {
    return SimpleITKJNI.STAPLEImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::STAPLEImageFilter::SetMaximumIterations(unsigned int MaximumIterations)

Set/Get the maximum number of iterations after which the STAPLE
algorithm will be considered to have converged. In general this SHOULD
NOT be set and the algorithm should be allowed to converge on its own.

*/
public  void setMaximumIterations(long MaximumIterations) {
    SimpleITKJNI.STAPLEImageFilter_setMaximumIterations(swigCPtr, this, MaximumIterations);
  }

  /**
unsigned int itk::simple::STAPLEImageFilter::GetMaximumIterations() const

Set/Get the maximum number of iterations after which the STAPLE
algorithm will be considered to have converged. In general this SHOULD
NOT be set and the algorithm should be allowed to converge on its own.

*/
public  long getMaximumIterations() {
    return SimpleITKJNI.STAPLEImageFilter_getMaximumIterations(swigCPtr, this);
  }

  /**
uint32_t itk::simple::STAPLEImageFilter::GetElapsedIterations() const

Get the number of elapsed iterations of the iterative E-M algorithm.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.STAPLEImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::STAPLEImageFilter::GetSensitivity() const

After the filter is updated, this method returns a
std::vector&lt;double&gt; of all Sensitivity (true positive fraction,
p) values for the expert input volumes.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorDouble getSensitivity() {
    return new VectorDouble(SimpleITKJNI.STAPLEImageFilter_getSensitivity(swigCPtr, this), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::STAPLEImageFilter::GetSpecificity() const

After the filter is updated, this method returns the Specificity (true
negative fraction, q) value for the i-th expert input volume.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorDouble getSpecificity() {
    return new VectorDouble(SimpleITKJNI.STAPLEImageFilter_getSpecificity(swigCPtr, this), true);
  }

  /**
std::string itk::simple::STAPLEImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.STAPLEImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::STAPLEImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.STAPLEImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::STAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.STAPLEImageFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::STAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.STAPLEImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::STAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.STAPLEImageFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::STAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.STAPLEImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::STAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.STAPLEImageFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::STAPLEImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.STAPLEImageFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

}
