/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public final class FileGeneratedEvent
extends BuildMessage {
    private static final Logger LOG = Logger.getInstance(FileGeneratedEvent.class);
    private final Collection<Pair<String, String>> paths;
    private final BuildTarget<?> sourceTarget;

    public FileGeneratedEvent(@NotNull BuildTarget<?> sourceTarget) {
        if (sourceTarget == null) {
            FileGeneratedEvent.$$$reportNull$$$0(0);
        }
        super("", BuildMessage.Kind.INFO);
        this.paths = new ArrayList<Pair<String, String>>();
        this.sourceTarget = sourceTarget;
    }

    @NotNull
    public BuildTarget<?> getSourceTarget() {
        BuildTarget<?> buildTarget = this.sourceTarget;
        if (buildTarget == null) {
            FileGeneratedEvent.$$$reportNull$$$0(1);
        }
        return buildTarget;
    }

    public void add(String root, String relativePath) {
        if (root != null && relativePath != null) {
            this.paths.add((Pair<String, String>)new Pair((Object)FileUtilRt.toSystemIndependentName((String)root), (Object)FileUtilRt.toSystemIndependentName((String)relativePath)));
        } else {
            LOG.info("Invalid file generation event: root=" + root + "; relativePath=" + relativePath);
        }
    }

    @NotNull
    public Collection<Pair<String, String>> getPaths() {
        Collection<Pair<String, String>> collection = Collections.unmodifiableCollection(this.paths);
        if (collection == null) {
            FileGeneratedEvent.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/messages/FileGeneratedEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/messages/FileGeneratedEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

