/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyModel.auxiliary;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.tooling.util.StringUtils;

@ApiStatus.Internal
public class AuxiliaryConfigurationArtifacts {
    private static final Pattern PUNCTUATION_IN_SUFFIX_PATTERN = Pattern.compile("[\\p{Punct}\\s]+$");
    @NotNull
    private final Map<ComponentIdentifier, Set<File>> sources;
    @NotNull
    private final Map<ComponentIdentifier, Set<File>> javadocs;

    public AuxiliaryConfigurationArtifacts(@NotNull Map<ComponentIdentifier, Set<File>> sources, @NotNull Map<ComponentIdentifier, Set<File>> javadocs) {
        if (sources == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(0);
        }
        if (javadocs == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(1);
        }
        this.sources = sources;
        this.javadocs = javadocs;
    }

    @Nullable
    public File getJavadoc(@NotNull ComponentIdentifier identifier, @NotNull File artifactFile) {
        Set<File> files;
        if (identifier == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(2);
        }
        if (artifactFile == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(3);
        }
        if ((files = this.javadocs.get(identifier)) == null) {
            return null;
        }
        return AuxiliaryConfigurationArtifacts.chooseAuxiliaryArtifactFile(artifactFile, files);
    }

    @Nullable
    public File getSources(@NotNull ComponentIdentifier identifier, @NotNull File artifactFile) {
        Set<File> files;
        if (identifier == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(4);
        }
        if (artifactFile == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(5);
        }
        if ((files = this.sources.get(identifier)) == null) {
            return null;
        }
        return AuxiliaryConfigurationArtifacts.chooseAuxiliaryArtifactFile(artifactFile, files);
    }

    @VisibleForTesting
    @Nullable
    public static File chooseAuxiliaryArtifactFile(@NotNull File main, @NotNull Set<File> auxiliaries) {
        Iterator<File> auxiliariesIterator;
        if (main == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(6);
        }
        if (auxiliaries == null) {
            AuxiliaryConfigurationArtifacts.$$$reportNull$$$0(7);
        }
        if (!(auxiliariesIterator = auxiliaries.iterator()).hasNext()) {
            return null;
        }
        File firstAuxiliary = auxiliariesIterator.next();
        if (!auxiliariesIterator.hasNext()) {
            return firstAuxiliary;
        }
        String mainName = main.getName();
        String firstAuxiliaryName = firstAuxiliary.getName();
        int commonSuffixOfAuxiliaries = firstAuxiliaryName.length();
        do {
            File nextAuxiliary;
            int commonSuffix;
            if ((commonSuffix = StringUtils.commonSuffixLength(firstAuxiliaryName, (nextAuxiliary = auxiliariesIterator.next()).getName())) >= commonSuffixOfAuxiliaries) continue;
            commonSuffixOfAuxiliaries = commonSuffix;
        } while (auxiliariesIterator.hasNext());
        int commonSuffixOfMainAndAuxiliaries = Math.min(commonSuffixOfAuxiliaries, StringUtils.commonSuffixLength(mainName, firstAuxiliaryName));
        String mainSuffixlessName = mainName.substring(0, mainName.length() - commonSuffixOfMainAndAuxiliaries);
        int commonPrefixOfMainAndShortlistedAuxiliaries = 0;
        TreeMap<String, File> shortlistedAuxiliariesBySuffixlessName = new TreeMap<String, File>(Comparator.comparingInt(String::length).thenComparing(String::compareTo));
        for (File auxiliary : auxiliaries) {
            String auxiliaryName = auxiliary.getName();
            String auxiliarySuffixlessName = auxiliaryName.substring(0, auxiliaryName.length() - commonSuffixOfAuxiliaries);
            int commonPrefixNaive = StringUtils.commonPrefixLength(mainSuffixlessName, auxiliarySuffixlessName);
            Matcher commonPrefixExcessMatcher = PUNCTUATION_IN_SUFFIX_PATTERN.matcher(auxiliarySuffixlessName).region(0, commonPrefixNaive);
            int commonPrefix = commonPrefixExcessMatcher.find() ? commonPrefixExcessMatcher.start() : commonPrefixNaive;
            if (commonPrefix < commonPrefixOfMainAndShortlistedAuxiliaries) continue;
            if (commonPrefix > commonPrefixOfMainAndShortlistedAuxiliaries) {
                commonPrefixOfMainAndShortlistedAuxiliaries = commonPrefix;
                shortlistedAuxiliariesBySuffixlessName.clear();
            }
            shortlistedAuxiliariesBySuffixlessName.put(auxiliarySuffixlessName, auxiliary);
        }
        return (File)shortlistedAuxiliariesBySuffixlessName.firstEntry().getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javadocs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxiliaries";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyModel/auxiliary/AuxiliaryConfigurationArtifacts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getJavadoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSources";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAuxiliaryArtifactFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

