/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.mindmapmode.stylemode.DialogController;

public class SModeController
extends MModeController {
    private int status = -1;
    public static final String MODENAME = "StyleMap";

    public SModeController(Controller controller) {
        super(controller);
        JDialog dialog = ((DialogController)controller.getViewController()).getDialog();
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SModeController.this.setStatus(-1);
            }
        });
        String key = "styledialog";
        AFreeplaneAction okAction = new AFreeplaneAction("styledialog.ok"){

            public void actionPerformed(ActionEvent e) {
                SModeController.this.setStatus(0);
                SModeController.this.closeDialog();
            }
        };
        controller.addAction(okAction);
        AFreeplaneAction cancelAction = new AFreeplaneAction("styledialog.cancel"){

            public void actionPerformed(ActionEvent e) {
                SModeController.this.setStatus(2);
                SModeController.this.closeDialog();
            }
        };
        controller.addAction(cancelAction);
        AFreeplaneAction tryToCloseAction = new AFreeplaneAction("QuitAction"){

            public void actionPerformed(ActionEvent e) {
                SModeController.this.tryToCloseDialog();
            }
        };
        controller.addAction(tryToCloseAction);
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String getModeName() {
        return MODENAME;
    }

    protected void closeDialog() {
        JDialog dialog = ((DialogController)this.getController().getViewController()).getDialog();
        ((Window)dialog).setVisible(false);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    boolean tryToCloseDialog() {
        String title;
        IMapViewManager mapViewManager = this.getController().getMapViewManager();
        MapModel map = mapViewManager.getMap();
        IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
        JDialog dialog = ((DialogController)this.getController().getViewController()).getDialog();
        if (!undoHandler.canUndo()) {
            ((Window)dialog).setVisible(false);
            return true;
        }
        String text = TextUtils.getText((String)"save_unsaved_styles");
        int returnVal = JOptionPane.showOptionDialog(dialog, text, title = TextUtils.getText((String)"SaveAction.text"), 1, 3, null, null, null);
        if (returnVal == 2 || returnVal == -1) {
            return false;
        }
        this.setStatus(returnVal == 0 ? 0 : 2);
        ((Window)dialog).setVisible(false);
        return true;
    }

    @Override
    public void startup() {
    }

    public boolean canEdit(NodeModel model) {
        return model.getNodeLevel() >= 2;
    }

    @Override
    public boolean shouldCenterCompactMaps() {
        return true;
    }
}

