/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;

public class JobSnapshot
implements Comparable<JobSnapshot> {
    private final JobTreeElement reference;
    private final int index;
    private final int hashCode;
    private final boolean isUser;
    private final boolean isBlocked;
    private final int priority;
    private final String name;
    private final boolean isCanceled;
    private final int state;
    private final String displayString;

    public JobSnapshot(JobTreeElement reference) {
        this(reference, 0);
    }

    public JobSnapshot(JobTreeElement reference, int index) {
        JobInfo j;
        this.reference = reference;
        this.index = index;
        this.hashCode = reference.hashCode();
        this.displayString = reference.getDisplayString();
        JobInfo jobInfo = reference instanceof JobInfo ? (j = (JobInfo)reference) : null;
        this.isBlocked = jobInfo == null ? false : jobInfo.isBlocked();
        this.isCanceled = jobInfo == null ? false : jobInfo.isCanceled();
        Job job = jobInfo == null ? null : jobInfo.getJob();
        this.isUser = job == null ? false : job.isUser();
        this.priority = job == null ? 0 : job.getPriority();
        this.name = job == null ? "" : job.getName();
        this.state = job == null ? 0 : job.getState();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JobSnapshot) {
            return this.reference.equals(((JobSnapshot)obj).reference);
        }
        return false;
    }

    @Override
    public int compareTo(JobSnapshot other) {
        boolean thisCanceled = this.isCanceled();
        boolean anotherCanceled = other.isCanceled();
        if (thisCanceled && !anotherCanceled) {
            return 1;
        }
        if (!thisCanceled && anotherCanceled) {
            return -1;
        }
        if (this.getState() != other.getState()) {
            return Integer.compare(other.getState(), this.getState());
        }
        if (this.isUser()) {
            if (!other.isUser()) {
                return -1;
            }
        } else if (other.isUser()) {
            return 1;
        }
        if (this.isBlocked()) {
            if (!other.isBlocked()) {
                return 1;
            }
        } else if (other.isBlocked()) {
            return -1;
        }
        if (this.getPriority() != other.getPriority()) {
            if (this.getPriority() < other.getPriority()) {
                return -1;
            }
            return 1;
        }
        int n = this.getName().compareTo(other.getName());
        if (n != 0) {
            return n;
        }
        return this.getDisplayString().compareTo(other.getDisplayString());
    }

    public boolean isUser() {
        return this.isUser;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public int getState() {
        return this.state;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.reference.toString();
    }
}

