/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.internal.RegistryMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DataSourceNavigatorSettings
implements DBNBrowseSettings {
    static final String ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS = "show-system-objects";
    static final String ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS = "show-util-objects";
    static final String ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES = "navigator-show-only-entities";
    static final String ATTR_NAVIGATOR_HIDE_FOLDERS = "navigator-hide-folders";
    static final String ATTR_NAVIGATOR_HIDE_SCHEMAS = "navigator-hide-schemas";
    static final String ATTR_NAVIGATOR_HIDE_VIRTUAL = "navigator-hide-virtual";
    static final String ATTR_NAVIGATOR_MERGE_ENTITIES = "navigator-merge-entities";
    public static final Set<String> NAVIGATOR_SETTINGS = Set.of("show-system-objects", "show-util-objects", "navigator-show-only-entities", "navigator-hide-folders", "navigator-hide-schemas", "navigator-hide-virtual", "navigator-merge-entities");
    public static final Map<String, Preset> PRESETS = new LinkedHashMap<String, Preset>();
    public static final Preset PRESET_SIMPLE = new Preset("simple", RegistryMessages.navigator_settings_preset_simple_view_name, RegistryMessages.navigator_settings_preset_simple_view_description);
    public static final Preset PRESET_FULL = new Preset("advanced", RegistryMessages.navigator_settings_preset_advanced_view_name, RegistryMessages.navigator_settings_preset_advanced_view_description);
    public static final Preset PRESET_CUSTOM = new Preset("custom", RegistryMessages.navigator_settings_preset_custom_view_name, RegistryMessages.navigator_settings_preset_custom_view_description);
    private boolean showSystemObjects;
    private boolean showUtilityObjects;
    private boolean showOnlyEntities;
    private boolean mergeEntities;
    private boolean hideFolders;
    private boolean hideSchemas;
    private boolean hideVirtualModel;
    private boolean userSettings;
    public static final String DEFAULT_NAVIGATOR_SETTINGS_PRESET = "navigator.settings.default.preset";
    private static final String DEFAULT_SHOW_SYSTEM_OBJECTS = "navigator.settings.default.showSystemObjects";
    private static final String DEFAULT_SHOW_UTILITY_OBJECTS = "navigator.settings.default.showUtilityObjects";
    private static final String DEFAULT_SHOW_ONLY_ENTITIES = "navigator.settings.default.showOnlyEntities";
    private static final String DEFAULT_MERGE_ENTITIES = "navigator.settings.default.mergeEntities";
    private static final String DEFAULT_HIDE_FOLDERS = "navigator.settings.default.hideFolders";
    private static final String DEFAULT_MERGE_SCHEMAS = "navigator.settings.default.hideSchemas";
    private static final String DEFAULT_HIDE_VIRTUAL_MODEL = "navigator.settings.default.hideVirtualModel";

    static {
        DataSourceNavigatorSettings.PRESET_SIMPLE.settings.setShowOnlyEntities(true);
        DataSourceNavigatorSettings.PRESET_SIMPLE.settings.setHideFolders(true);
        DataSourceNavigatorSettings.PRESET_SIMPLE.settings.setHideVirtualModel(true);
        DataSourceNavigatorSettings.PRESET_FULL.settings.setShowSystemObjects(true);
        PRESETS.put(DataSourceNavigatorSettings.PRESET_SIMPLE.name, PRESET_SIMPLE);
        PRESETS.put(DataSourceNavigatorSettings.PRESET_FULL.name, PRESET_FULL);
        PRESETS.put(DataSourceNavigatorSettings.PRESET_CUSTOM.name, PRESET_CUSTOM);
    }

    public DataSourceNavigatorSettings() {
    }

    public DataSourceNavigatorSettings(@NotNull DBNBrowseSettings copyFrom) {
        this.showSystemObjects = copyFrom.isShowSystemObjects();
        this.showUtilityObjects = copyFrom.isShowUtilityObjects();
        this.showOnlyEntities = copyFrom.isShowOnlyEntities();
        this.mergeEntities = copyFrom.isMergeEntities();
        this.hideFolders = copyFrom.isHideFolders();
        this.hideSchemas = copyFrom.isHideSchemas();
        this.hideVirtualModel = copyFrom.isHideVirtualModel();
    }

    public boolean isShowSystemObjects() {
        return this.showSystemObjects;
    }

    public void setShowSystemObjects(boolean showSystemObjects) {
        this.showSystemObjects = showSystemObjects;
    }

    public boolean isShowUtilityObjects() {
        return this.showUtilityObjects;
    }

    public void setShowUtilityObjects(boolean showUtilityObjects) {
        this.showUtilityObjects = showUtilityObjects;
    }

    public boolean isShowOnlyEntities() {
        return this.showOnlyEntities;
    }

    public void setShowOnlyEntities(boolean showOnlyEntities) {
        this.showOnlyEntities = showOnlyEntities;
    }

    public boolean isMergeEntities() {
        return this.mergeEntities;
    }

    public void setMergeEntities(boolean mergeEntities) {
        this.mergeEntities = mergeEntities;
    }

    public boolean isHideFolders() {
        return this.hideFolders;
    }

    public void setHideFolders(boolean hideFolders) {
        this.hideFolders = hideFolders;
    }

    public boolean isHideSchemas() {
        return this.hideSchemas;
    }

    public void setHideSchemas(boolean hideSchemas) {
        this.hideSchemas = hideSchemas;
    }

    public boolean isHideVirtualModel() {
        return this.hideVirtualModel;
    }

    public void setHideVirtualModel(boolean hideVirtualModel) {
        this.hideVirtualModel = hideVirtualModel;
    }

    public boolean isUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(boolean userSettings) {
        this.userSettings = userSettings;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void source;
        if (!(obj instanceof DataSourceNavigatorSettings)) {
            return false;
        }
        DataSourceNavigatorSettings dataSourceNavigatorSettings = (DataSourceNavigatorSettings)obj;
        return this.showSystemObjects == source.showSystemObjects && this.showUtilityObjects == source.showUtilityObjects && this.showOnlyEntities == source.showOnlyEntities && this.mergeEntities == source.mergeEntities && this.hideFolders == source.hideFolders && this.hideSchemas == source.hideSchemas && this.hideVirtualModel == source.hideVirtualModel;
    }

    public static DBNBrowseSettings getDefaultSettings() {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        String defPreset = preferences.getString(DEFAULT_NAVIGATOR_SETTINGS_PRESET);
        if (!CommonUtils.isEmpty((String)defPreset)) {
            for (Preset p : PRESETS.values()) {
                if (!p.getId().equals(defPreset)) continue;
                return p.getSettings();
            }
        }
        DataSourceNavigatorSettings settings = new DataSourceNavigatorSettings();
        settings.setShowSystemObjects(preferences.getBoolean(DEFAULT_SHOW_SYSTEM_OBJECTS));
        settings.setShowUtilityObjects(preferences.getBoolean(DEFAULT_SHOW_UTILITY_OBJECTS));
        settings.setShowOnlyEntities(preferences.getBoolean(DEFAULT_SHOW_ONLY_ENTITIES));
        settings.setMergeEntities(preferences.getBoolean(DEFAULT_MERGE_ENTITIES));
        settings.setHideFolders(preferences.getBoolean(DEFAULT_HIDE_FOLDERS));
        settings.setHideSchemas(preferences.getBoolean(DEFAULT_MERGE_SCHEMAS));
        settings.setHideVirtualModel(preferences.getBoolean(DEFAULT_HIDE_VIRTUAL_MODEL));
        return settings;
    }

    public static void setDefaultSettings(DBNBrowseSettings settings) {
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        String presetId = null;
        for (Preset p : PRESETS.values()) {
            if (!p.getSettings().equals(settings)) continue;
            presetId = p.getId();
            break;
        }
        if (CommonUtils.isEmptyTrimmed(presetId)) {
            preferences.setValue(DEFAULT_NAVIGATOR_SETTINGS_PRESET, "");
        } else {
            preferences.setValue(DEFAULT_NAVIGATOR_SETTINGS_PRESET, presetId);
        }
        preferences.setValue(DEFAULT_SHOW_SYSTEM_OBJECTS, settings.isShowSystemObjects());
        preferences.setValue(DEFAULT_SHOW_UTILITY_OBJECTS, settings.isShowUtilityObjects());
        preferences.setValue(DEFAULT_SHOW_ONLY_ENTITIES, settings.isShowOnlyEntities());
        preferences.setValue(DEFAULT_MERGE_ENTITIES, settings.isMergeEntities());
        preferences.setValue(DEFAULT_HIDE_FOLDERS, settings.isHideFolders());
        preferences.setValue(DEFAULT_MERGE_SCHEMAS, settings.isHideSchemas());
        preferences.setValue(DEFAULT_HIDE_VIRTUAL_MODEL, settings.isHideVirtualModel());
    }

    public static void saveSettingsToMap(@NotNull JsonWriter json, @NotNull DataSourceNavigatorSettings navSettings) throws IOException {
        DataSourceNavigatorSettings.addTrueSetting(json, ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS, navSettings.showSystemObjects);
        DataSourceNavigatorSettings.addTrueSetting(json, ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS, navSettings.showUtilityObjects);
        DataSourceNavigatorSettings.addTrueSetting(json, ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES, navSettings.showOnlyEntities);
        DataSourceNavigatorSettings.addTrueSetting(json, ATTR_NAVIGATOR_HIDE_FOLDERS, navSettings.hideFolders);
        DataSourceNavigatorSettings.addTrueSetting(json, ATTR_NAVIGATOR_HIDE_SCHEMAS, navSettings.hideSchemas);
        DataSourceNavigatorSettings.addTrueSetting(json, ATTR_NAVIGATOR_HIDE_VIRTUAL, navSettings.hideVirtualModel);
        DataSourceNavigatorSettings.addTrueSetting(json, ATTR_NAVIGATOR_MERGE_ENTITIES, navSettings.mergeEntities);
    }

    private static void addTrueSetting(@NotNull JsonWriter json, @NotNull String name, boolean value) throws IOException {
        if (value) {
            JSONUtils.field((JsonWriter)json, (String)name, (boolean)true);
        }
    }

    public static Map<String, String> saveSettingsToMap(@NotNull DataSourceNavigatorSettings navSettings) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS, String.valueOf(navSettings.showSystemObjects));
        map.put(ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS, String.valueOf(navSettings.showUtilityObjects));
        map.put(ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES, String.valueOf(navSettings.showOnlyEntities));
        map.put(ATTR_NAVIGATOR_HIDE_FOLDERS, String.valueOf(navSettings.hideFolders));
        map.put(ATTR_NAVIGATOR_HIDE_SCHEMAS, String.valueOf(navSettings.hideSchemas));
        map.put(ATTR_NAVIGATOR_HIDE_VIRTUAL, String.valueOf(navSettings.hideVirtualModel));
        map.put(ATTR_NAVIGATOR_MERGE_ENTITIES, String.valueOf(navSettings.mergeEntities));
        return map;
    }

    public static class Preset {
        private final String id;
        private final String name;
        private final String description;
        private final DataSourceNavigatorSettings settings = new DataSourceNavigatorSettings();

        public Preset(String id, String name, String description) {
            this.id = id;
            this.name = name;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public DataSourceNavigatorSettings getSettings() {
            return this.settings;
        }
    }
}

