/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.synchronize.actions.StatusLineContributionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class DiffTreeStatusLineContributionGroup
extends StatusLineContributionGroup
implements IDiffChangeListener {
    public DiffTreeStatusLineContributionGroup(Shell shell, ISynchronizePageConfiguration configuration) {
        super(shell, configuration);
        this.getSynchronizationContext().getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
    }

    @Override
    public void dispose() {
        this.getSynchronizationContext().getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        super.dispose();
    }

    @Override
    protected int getChangeCount() {
        return this.getSynchronizationContext().getDiffTree().size();
    }

    private ISynchronizationContext getSynchronizationContext() {
        return (ISynchronizationContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    @Override
    protected int countFor(int state) {
        switch (state) {
            case 4: {
                state = 256;
                break;
            }
            case 8: {
                state = 512;
                break;
            }
            case 12: {
                state = 768;
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(state));
            }
        }
        return (int)this.getSynchronizationContext().getDiffTree().countFor(state, 768);
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        this.updateCounts();
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }
}

