/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2ConstraintCheckData;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;

public class DB2TableUniqueKey
extends JDBCTableConstraint<DB2Table, DB2TableKeyColumn> {
    private String owner;
    private DB2OwnerType ownerType;
    private Boolean enforced;
    private Boolean trusted;
    private DB2ConstraintCheckData checkExistingData;
    private Boolean enableQueryOpt;
    private String remarks;
    private final List<DB2TableKeyColumn> columns = new ArrayList<DB2TableKeyColumn>();

    public DB2TableUniqueKey(DBRProgressMonitor monitor, DB2Table table, ResultSet dbResult, DBSEntityConstraintType type) throws DBException {
        super((JDBCTable)table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTNAME"), null, type, true);
        DB2DataSource db2DataSource = (DB2DataSource)table.getDataSource();
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.enforced = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"ENFORCED", (String)DB2YesNo.Y.name());
        this.checkExistingData = (DB2ConstraintCheckData)CommonUtils.valueOf(DB2ConstraintCheckData.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHECKEXISTINGDATA"));
        this.enableQueryOpt = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"ENABLEQUERYOPT", (String)DB2YesNo.Y.name());
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
        if (db2DataSource.isAtLeastV10_1()) {
            this.trusted = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TRUSTED", (String)DB2YesNo.Y.name());
        }
    }

    public DB2TableUniqueKey(DB2Table db2Table, DBSEntityConstraintType constraintType) {
        super((JDBCTable)db2Table, null, null, constraintType, false);
        this.ownerType = DB2OwnerType.U;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getTable().getContainer(), this.getTable(), this});
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.getTable().getDataSource();
    }

    public List<DB2TableKeyColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void addAttributeReference(DBSTableColumn column) throws DBException {
        this.columns.add(new DB2TableKeyColumn((AbstractTableConstraint<DB2Table, ? extends DB2TableKeyColumn>)this, (DB2TableColumn)column, this.columns.size()));
    }

    public void setAttributeReferences(List<DB2TableKeyColumn> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2Table getTable() {
        return (DB2Table)super.getTable();
    }

    @Property(viewable=true, editable=false, order=3)
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return super.getConstraintType();
    }

    @Property(viewable=true, editable=false, length=PropertyLength.MULTILINE, order=4)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=false, editable=false)
    public Boolean getEnforced() {
        return this.enforced;
    }

    @Property(viewable=false, editable=false)
    public Boolean getTrusted() {
        return this.trusted;
    }

    @Property(viewable=false, editable=false)
    public DB2ConstraintCheckData getCheckExistingData() {
        return this.checkExistingData;
    }

    @Property(viewable=false, editable=false)
    public Boolean getEnableQueryOpt() {
        return this.enableQueryOpt;
    }
}

