/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaMdbReader;
import net.sf.mpxj.asta.AstaSqliteReader;
import net.sf.mpxj.asta.AstaTextFileReader;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.CloseIgnoringInputStream;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.SQLite;
import net.sf.mpxj.conceptdraw.ConceptDrawProjectReader;
import net.sf.mpxj.fasttrack.FastTrackReader;
import net.sf.mpxj.ganttdesigner.GanttDesignerReader;
import net.sf.mpxj.ganttproject.GanttProjectReader;
import net.sf.mpxj.merlin.MerlinReader;
import net.sf.mpxj.mpd.MPDFileReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.phoenix.PhoenixInputStream;
import net.sf.mpxj.phoenix.PhoenixReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.primavera.PrimaveraDatabaseFileReader;
import net.sf.mpxj.primavera.PrimaveraPMFileReader;
import net.sf.mpxj.primavera.PrimaveraXERFileReader;
import net.sf.mpxj.primavera.p3.P3DatabaseReader;
import net.sf.mpxj.primavera.p3.P3PRXFileReader;
import net.sf.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import net.sf.mpxj.primavera.suretrak.SureTrakSTXFileReader;
import net.sf.mpxj.projectcommander.ProjectCommanderReader;
import net.sf.mpxj.projectlibre.ProjectLibreReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.sage.SageReader;
import net.sf.mpxj.sdef.SDEFReader;
import net.sf.mpxj.synchro.SynchroReader;
import net.sf.mpxj.turboproject.TurboProjectReader;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class UniversalProjectReader
extends AbstractProjectReader {
    private Properties m_properties;
    private int m_skipBytes;
    private Charset m_charset;
    private boolean m_readAll;
    private static final int BUFFER_SIZE = 512;
    private static final byte[] OLE_COMPOUND_DOC_FINGERPRINT = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] PP_FINGERPRINT = new byte[]{0, 0, 48, 48, 48, 48, 48, 48};
    private static final byte[] MPX_FINGERPRINT = new byte[]{77, 80, 88};
    private static final byte[] MDB_FINGERPRINT = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
    private static final byte[] SQLITE_FINGERPRINT = new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116};
    private static final byte[] ZIP_FINGERPRINT = new byte[]{80, 75};
    private static final byte[] PHOENIX_FINGERPRINT = new byte[]{80, 80, 88, 33, 33, 33, 33};
    private static final byte[] BINARY_PLIST = new byte[]{98, 112, 108, 105, 115, 116};
    private static final byte[] FASTTRACK_FINGERPRINT = new byte[]{28, 0, 0, 0};
    private static final byte[] PROJECTLIBRE_FINGERPRINT = new byte[]{-84, -19, 0, 5};
    private static final byte[] BTRIEVE_FINGERPRINT = new byte[]{70, 67, 0, 0};
    private static final byte[] STW_FINGERPRINT = new byte[]{83, 84, 87};
    private static final byte[] DOS_EXE_FINGERPRINT = new byte[]{77, 90};
    private static final byte[] WINDOWS_NE_EXE_FINGERPRINT = new byte[]{78, 69};
    private static final byte[] STX_FINGERPRINT = new byte[]{85, -117};
    private static final byte[] SYNCHRO_FINGERPRINT = new byte[]{-74, 23};
    private static final byte[] SDEF_FINGERPRINT = new byte[]{86, 79, 76, 77};
    private static final byte[] SCHEDULE_GRID_FINGERPRINT = new byte[]{42, 42, 42, 42, 32, 83, 99, 104, 101, 100, 117, 108, 101, 32, 71, 114, 105, 100};
    private static final byte[] UTF8_BOM_FINGERPRINT = new byte[]{-17, -69, -65};
    private static final byte[] UTF16_BOM_FINGERPRINT = new byte[]{-2, -1};
    private static final byte[] UTF16LE_BOM_FINGERPRINT = new byte[]{-1, -2};
    private static final byte[] PROJECT_COMMANDER_FINGERPRINT_1 = new byte[]{0, -128, 1, 0};
    private static final byte[] PROJECT_COMMANDER_FINGERPRINT_2 = new byte[]{2, -128, 1, 0};
    private static final Pattern XER_FINGERPRINT = Pattern.compile("ERMHDR.*", 32);
    private static final Pattern PLANNER_FINGERPRINT = Pattern.compile(".*<project.*mrproject-version.*", 32);
    private static final Pattern PMXML_FINGERPRINT = Pattern.compile(".*(<BusinessObjects|APIBusinessObjects).*", 32);
    private static final Pattern MSPDI_FINGERPRINT_1 = Pattern.compile(".*xmlns=\"http://schemas\\.microsoft\\.com/project.*", 32);
    private static final Pattern MSPDI_FINGERPRINT_2 = Pattern.compile(".*<Project.*<SaveVersion>.*", 32);
    private static final Pattern MSPDI_FINGERPRINT_3 = Pattern.compile(".*<Project.*<Title>.*", 32);
    private static final Pattern PHOENIX_XML_FINGERPRINT1 = Pattern.compile(".*<project.*version=\"(\\d+|\\d+\\.\\d+)\".*update_mode=\"(true|false)\".*>.*", 32);
    private static final Pattern PHOENIX_XML_FINGERPRINT2 = Pattern.compile(".*<project.*version=\"(\\d+|\\d+\\.\\d+)\".*application=\"Phoenix.*", 32);
    private static final Pattern GANTTPROJECT_FINGERPRINT = Pattern.compile(".*<project.*webLink.*", 32);
    private static final Pattern TURBOPROJECT_FINGERPRINT = Pattern.compile(".*dWBSTAB.*", 32);
    private static final Pattern PRX_FINGERPRINT = Pattern.compile("!Self-Extracting Primavera Project", 32);
    private static final Pattern PRX3_FINGERPRINT = Pattern.compile("PRX3", 32);
    private static final Pattern CONCEPT_DRAW_FINGERPRINT = Pattern.compile(".*Application=\"CDProject\".*", 32);
    private static final Pattern GANTT_DESIGNER_FINGERPRINT = Pattern.compile(".*<Gantt Version=.*", 32);

    @Override
    public ProjectReader setProperties(Properties props) {
        this.m_properties = props;
        return this;
    }

    @Override
    public ProjectFile read(String fileName) throws MPXJException {
        return this.read(new File(fileName));
    }

    @Override
    public List<ProjectFile> readAll(String fileName) throws MPXJException {
        return this.readAll(new File(fileName));
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        this.m_readAll = false;
        List<ProjectFile> projects = this.readInternal(file);
        return projects.isEmpty() ? null : projects.get(0);
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        this.m_readAll = true;
        return this.readInternal(file);
    }

    private List<ProjectFile> readInternal(File file) throws MPXJException {
        try {
            List<ProjectFile> result = file.isDirectory() ? this.handleDirectory(file) : this.handleFile(file);
            return result;
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        this.m_readAll = false;
        List<ProjectFile> projects = this.readInternal(inputStream);
        return projects.isEmpty() ? null : projects.get(0);
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        this.m_readAll = true;
        return this.readInternal(inputStream);
    }

    private List<ProjectFile> readInternal(InputStream inputStream) throws MPXJException {
        return this.readInternal(null, inputStream);
    }

    private List<ProjectFile> readInternal(File file, InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            InputStreamHelper.skip(bis, this.m_skipBytes);
            bis.mark(512);
            byte[] buffer = new byte[512];
            int bytesRead = bis.read(buffer);
            bis.reset();
            if (bytesRead != 512) {
                return Collections.emptyList();
            }
            if (this.matchesFingerprint(buffer, UTF8_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF8_BOM_FINGERPRINT.length, CharsetHelper.UTF8);
            }
            if (this.matchesFingerprint(buffer, UTF16_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16_BOM_FINGERPRINT.length, CharsetHelper.UTF16);
            }
            if (this.matchesFingerprint(buffer, UTF16LE_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16LE_BOM_FINGERPRINT.length, CharsetHelper.UTF16LE);
            }
            if (this.matchesFingerprint(buffer, BINARY_PLIST)) {
                return this.handleBinaryPropertyList(bis);
            }
            if (this.matchesFingerprint(buffer, OLE_COMPOUND_DOC_FINGERPRINT)) {
                return this.handleOleCompoundDocument(file, bis);
            }
            if (this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_1) || this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_2) || this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_3)) {
                return this.readProjectFile((ProjectReader)new MSPDIReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PP_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new AstaTextFileReader(), bis);
            }
            if (this.matchesFingerprint(buffer, MPX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new MPXReader(), bis);
            }
            if (this.matchesFingerprint(buffer, XER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PrimaveraXERFileReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PLANNER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PlannerReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PMXML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PrimaveraPMFileReader(), bis);
            }
            if (this.matchesFingerprint(buffer, MDB_FINGERPRINT)) {
                return this.handleMDBFile(bis);
            }
            if (this.matchesFingerprint(buffer, SQLITE_FINGERPRINT)) {
                return this.handleSQLiteFile(bis);
            }
            if (this.matchesFingerprint(buffer, ZIP_FINGERPRINT)) {
                return this.handleZipFile(bis);
            }
            if (this.matchesFingerprint(buffer, PHOENIX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), new PhoenixInputStream(bis));
            }
            if (this.matchesFingerprint(buffer, PHOENIX_XML_FINGERPRINT1) || this.matchesFingerprint(buffer, PHOENIX_XML_FINGERPRINT2)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), bis);
            }
            if (this.matchesFingerprint(buffer, FASTTRACK_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new FastTrackReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PROJECTLIBRE_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new ProjectLibreReader(), bis);
            }
            if (this.matchesFingerprint(buffer, GANTTPROJECT_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new GanttProjectReader(), bis);
            }
            if (this.matchesFingerprint(buffer, TURBOPROJECT_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new TurboProjectReader(), bis);
            }
            if (this.matchesFingerprint(buffer, DOS_EXE_FINGERPRINT)) {
                return this.handleDosExeFile(bis);
            }
            if (this.matchesFingerprint(buffer, CONCEPT_DRAW_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new ConceptDrawProjectReader(), bis);
            }
            if (this.matchesFingerprint(buffer, SYNCHRO_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new SynchroReader(), bis);
            }
            if (this.matchesFingerprint(buffer, GANTT_DESIGNER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new GanttDesignerReader(), bis);
            }
            if (this.matchesFingerprint(buffer, SDEF_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new SDEFReader(), bis);
            }
            if (this.matchesFingerprint(buffer, SCHEDULE_GRID_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new SageReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PROJECT_COMMANDER_FINGERPRINT_1) || this.matchesFingerprint(buffer, PROJECT_COMMANDER_FINGERPRINT_2)) {
                return this.readProjectFile((ProjectReader)new ProjectCommanderReader(), bis);
            }
            return Collections.emptyList();
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }

    private boolean matchesFingerprint(byte[] buffer, byte[] fingerprint) {
        return Arrays.equals(fingerprint, Arrays.copyOf(buffer, fingerprint.length));
    }

    private boolean matchesFingerprint(byte[] buffer, Pattern fingerprint) {
        return fingerprint.matcher(this.m_charset == null ? new String(buffer) : new String(buffer, this.m_charset)).matches();
    }

    private List<ProjectFile> readProjectFile(ProjectReader reader, InputStream stream) throws MPXJException {
        this.addListenersToReader(reader);
        reader.setCharset(this.m_charset);
        reader.setProperties(this.m_properties);
        return this.m_readAll ? reader.readAll(stream) : Collections.singletonList(reader.read(stream));
    }

    private List<ProjectFile> readProjectFile(ProjectReader reader, File file) throws MPXJException {
        this.addListenersToReader(reader);
        reader.setCharset(this.m_charset);
        reader.setProperties(this.m_properties);
        return this.m_readAll ? reader.readAll(file) : Collections.singletonList(reader.read(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProjectFile> handleOleCompoundDocument(File file, InputStream stream) throws Exception {
        POIFSFileSystem fs;
        boolean closeFile = false;
        try {
            if (file == null) {
                fs = new POIFSFileSystem(new CloseIgnoringInputStream(stream));
            } else {
                fs = new POIFSFileSystem(file);
                closeFile = true;
            }
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
        try {
            String fileFormat = MPPReader.getFileFormat(fs);
            if (fileFormat == null || !fileFormat.startsWith("MSProject")) {
                List<ProjectFile> list = Collections.emptyList();
                return list;
            }
            MPPReader reader = new MPPReader();
            this.addListenersToReader(reader);
            reader.setProperties(this.m_properties);
            List<ProjectFile> list = Collections.singletonList(reader.read(fs));
            return list;
        }
        finally {
            if (closeFile) {
                AutoCloseableHelper.closeQuietly(fs);
            }
        }
    }

    private List<ProjectFile> handleBinaryPropertyList(InputStream stream) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProjectFile> handleMDBFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".mdb");
        try {
            Set<String> tableNames = this.populateMdbTableNames(file);
            if (tableNames.contains("MSP_PROJECTS")) {
                List<ProjectFile> list = this.readProjectFile((ProjectReader)new MPDFileReader(), file);
                return list;
            }
            if (tableNames.contains("EXCEPTIONN")) {
                List<ProjectFile> list = this.readProjectFile((ProjectReader)new AstaMdbReader(), file);
                return list;
            }
            List<ProjectFile> list = Collections.emptyList();
            return list;
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProjectFile> handleSQLiteFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".sqlite");
        try {
            Set<String> tableNames = this.populateSqliteTableNames(file);
            if (tableNames.contains("EXCEPTIONN")) {
                List<ProjectFile> list = this.readProjectFile((ProjectReader)new AstaSqliteReader(), file);
                return list;
            }
            if (tableNames.contains("PROJWBS")) {
                List<ProjectFile> list = this.readProjectFile((ProjectReader)new PrimaveraDatabaseFileReader(), file);
                return list;
            }
            if (tableNames.contains("ZSCHEDULEITEM")) {
                List<ProjectFile> list = this.readProjectFile((ProjectReader)new MerlinReader(), file);
                return list;
            }
            List<ProjectFile> list = Collections.emptyList();
            return list;
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProjectFile> handleZipFile(InputStream stream) throws Exception {
        File dir = null;
        try {
            dir = InputStreamHelper.writeZipStreamToTempDir(stream);
            List<ProjectFile> list = this.handleDirectory(dir);
            return list;
        }
        finally {
            FileHelper.deleteQuietly(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProjectFile> handleFile(File file) throws Exception {
        List<ProjectFile> list;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            List<ProjectFile> projectFiles = this.readInternal(file, fis);
            fis.close();
            list = projectFiles;
        }
        catch (Throwable throwable) {
            AutoCloseableHelper.closeQuietly(fis);
            throw throwable;
        }
        AutoCloseableHelper.closeQuietly(fis);
        return list;
    }

    private List<ProjectFile> handleDirectory(File directory) throws Exception {
        List<ProjectFile> result = this.handleDatabaseInDirectory(directory);
        if (result.isEmpty()) {
            result = this.handleFileInDirectory(directory);
        }
        return result;
    }

    private List<ProjectFile> handleDatabaseInDirectory(File directory) throws Exception {
        byte[] buffer = new byte[512];
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                FileInputStream fis = new FileInputStream(file);
                int bytesRead = fis.read(buffer);
                fis.close();
                if (bytesRead != 512) continue;
                if (this.matchesFingerprint(buffer, BTRIEVE_FINGERPRINT)) {
                    return this.handleP3BtrieveDatabase(directory);
                }
                if (!this.matchesFingerprint(buffer, STW_FINGERPRINT)) continue;
                return this.handleSureTrakDatabase(directory);
            }
        }
        return Collections.emptyList();
    }

    private List<ProjectFile> handleFileInDirectory(File directory) throws Exception {
        ArrayList<File> directories = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                Object result;
                if (file.isDirectory()) {
                    directories.add(file);
                    continue;
                }
                UniversalProjectReader reader = new UniversalProjectReader();
                reader.setProperties(this.m_properties);
                if (this.m_readAll) {
                    result = reader.readAll(file);
                    if (result.isEmpty()) continue;
                    return result;
                }
                result = reader.read(file);
                if (result == null) continue;
                return Collections.singletonList(result);
            }
            for (File file : directories) {
                List<ProjectFile> result = this.handleDirectory(file);
                if (result.isEmpty()) continue;
                return result;
            }
        }
        return Collections.emptyList();
    }

    private List<ProjectFile> handleP3BtrieveDatabase(File directory) throws Exception {
        return this.m_readAll ? new P3DatabaseReader().setProperties(this.m_properties).readAll(directory) : Collections.singletonList(P3DatabaseReader.setProjectNameAndRead(directory, this.m_properties));
    }

    private List<ProjectFile> handleSureTrakDatabase(File directory) throws Exception {
        return this.m_readAll ? new SureTrakDatabaseReader().setProperties(this.m_properties).readAll(directory) : Collections.singletonList(SureTrakDatabaseReader.setProjectNameAndRead(directory, this.m_properties));
    }

    private List<ProjectFile> handleByteOrderMark(InputStream stream, int length, Charset charset) throws Exception {
        UniversalProjectReader reader = new UniversalProjectReader();
        reader.setProperties(this.m_properties);
        reader.m_skipBytes = length;
        reader.m_charset = charset;
        return this.m_readAll ? reader.readAll(stream) : Collections.singletonList(reader.read(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProjectFile> handleDosExeFile(InputStream stream) throws Exception {
        InputStream is;
        File file;
        block4: {
            byte[] data;
            block5: {
                List<ProjectFile> list;
                file = InputStreamHelper.writeStreamToTempFile(stream, ".tmp");
                is = null;
                try {
                    is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    if (is.available() <= 1350) break block4;
                    InputStreamHelper.skip(is, 1024L);
                    data = InputStreamHelper.read(is, 2);
                    if (!this.matchesFingerprint(data, WINDOWS_NE_EXE_FINGERPRINT)) break block5;
                    InputStreamHelper.skip(is, 286L);
                    data = InputStreamHelper.read(is, 34);
                    if (!this.matchesFingerprint(data, PRX_FINGERPRINT)) break block5;
                    is.close();
                    is = null;
                    list = this.readProjectFile((ProjectReader)new P3PRXFileReader(), file);
                }
                catch (Throwable throwable) {
                    AutoCloseableHelper.closeQuietly(is);
                    FileHelper.deleteQuietly(file);
                    throw throwable;
                }
                AutoCloseableHelper.closeQuietly(is);
                FileHelper.deleteQuietly(file);
                return list;
            }
            if (!this.matchesFingerprint(data, STX_FINGERPRINT)) break block4;
            InputStreamHelper.skip(is, 31742L);
            data = InputStreamHelper.read(is, 4);
            if (!this.matchesFingerprint(data, PRX3_FINGERPRINT)) break block4;
            is.close();
            is = null;
            List<ProjectFile> list = this.readProjectFile((ProjectReader)new SureTrakSTXFileReader(), file);
            AutoCloseableHelper.closeQuietly(is);
            FileHelper.deleteQuietly(file);
            return list;
        }
        List<ProjectFile> list = Collections.emptyList();
        AutoCloseableHelper.closeQuietly(is);
        FileHelper.deleteQuietly(file);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> populateTableNames(Connection connection) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = connection.getMetaData();
            rs = dmd.getTables(null, null, null, null);
            while (rs.next()) {
                tableNames.add(rs.getString("TABLE_NAME").toUpperCase());
            }
        }
        catch (Throwable throwable) {
            AutoCloseableHelper.closeQuietly(rs);
            AutoCloseableHelper.closeQuietly(connection);
            throw throwable;
        }
        AutoCloseableHelper.closeQuietly(rs);
        AutoCloseableHelper.closeQuietly(connection);
        return tableNames;
    }

    private Set<String> populateMdbTableNames(File file) throws Exception {
        try (Database database = DatabaseBuilder.open(file);){
            Set<String> set = database.getTableNames();
            return set;
        }
    }

    private Set<String> populateSqliteTableNames(File file) throws Exception {
        return this.populateTableNames(SQLite.createConnection(file));
    }
}

