﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/MessageBody.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {
class UpdateEndpointsBatchResult {
 public:
  AWS_PINPOINT_API UpdateEndpointsBatchResult() = default;
  AWS_PINPOINT_API UpdateEndpointsBatchResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINT_API UpdateEndpointsBatchResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const MessageBody& GetMessageBody() const { return m_messageBody; }
  template <typename MessageBodyT = MessageBody>
  void SetMessageBody(MessageBodyT&& value) {
    m_messageBodyHasBeenSet = true;
    m_messageBody = std::forward<MessageBodyT>(value);
  }
  template <typename MessageBodyT = MessageBody>
  UpdateEndpointsBatchResult& WithMessageBody(MessageBodyT&& value) {
    SetMessageBody(std::forward<MessageBodyT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateEndpointsBatchResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  MessageBody m_messageBody;

  Aws::String m_requestId;
  bool m_messageBodyHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
