/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.Direction;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Spacer;
import com.dickimawbooks.texparserlib.SpacingObject;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class Skip
extends Primitive
implements Expandable,
SpacingObject {
    protected Direction direction;

    public Skip(String string, Direction direction) {
        super(string);
        this.direction = direction;
    }

    @Override
    public Object clone() {
        return new Skip(this.getName(), this.direction);
    }

    @Override
    public TeXDimension getSize(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            return teXObjectList.popDimension(teXParser);
        }
        return teXParser.popDimension();
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXDimension teXDimension = teXObjectList.popDimension(teXParser);
        Spacer spacer = teXParser.getListener().getSpacer(this.direction, teXDimension, this.direction == Direction.HORIZONTAL);
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        teXObjectList2.add(spacer);
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXDimension teXDimension = teXParser.popDimension();
        Spacer spacer = teXParser.getListener().getSpacer(this.direction, teXDimension, this.direction == Direction.HORIZONTAL);
        TeXObjectList teXObjectList = teXParser.getListener().createStack();
        teXObjectList.add(spacer);
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXDimension teXDimension = teXObjectList.popDimension(teXParser);
        Spacer spacer = teXParser.getListener().getSpacer(this.direction, teXDimension, this.direction == Direction.HORIZONTAL);
        spacer.process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXDimension teXDimension = teXParser.popDimension();
        Spacer spacer = teXParser.getListener().getSpacer(this.direction, teXDimension, this.direction == Direction.HORIZONTAL);
        spacer.process(teXParser);
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }
}

