/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.latex3.L3StorageCommand;
import java.io.IOException;

public class TokenListCommand
extends Command
implements L3StorageCommand {
    protected TeXObjectList content;
    public static final TokenListCommand EMPTY = new TokenListCommand("c_empty_tl");

    public TokenListCommand(String string) {
        super(string);
        this.content = new TeXObjectList();
    }

    public TokenListCommand(String string, int n) {
        super(string);
        this.content = new TeXObjectList(n);
    }

    public TokenListCommand(String string, TeXObject teXObject) {
        super(string);
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof Group)) {
            this.content = (TeXObjectList)teXObject;
        } else {
            this.content = new TeXObjectList();
            this.content.add(teXObject);
        }
    }

    public TokenListCommand(String string, TokenListCommand tokenListCommand) {
        super(string);
        this.content = (TeXObjectList)tokenListCommand.getContent().clone();
    }

    @Override
    public Object clone() {
        return new TokenListCommand(this.getName(), this);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return (TeXObjectList)this.content.clone();
    }

    public void trim() {
        this.content.trim();
    }

    public void setContent(TeXObjectList teXObjectList) {
        this.content = teXObjectList;
    }

    @Override
    public TeXObjectList getContent() {
        return this.content;
    }

    @Override
    public void setQuantity(TeXParser teXParser, TeXObject teXObject) throws TeXSyntaxException {
        if (teXObject instanceof TeXObjectList) {
            this.content = (TeXObjectList)teXObject;
        } else {
            this.content = new TeXObjectList();
            this.content.add(teXObject);
        }
    }

    @Override
    public TeXObject getQuantity(TeXParser teXParser, TeXObjectList teXObjectList) throws TeXSyntaxException {
        return (TeXObject)this.content.clone();
    }

    @Override
    public void append(TeXObject teXObject) {
        this.content.add(teXObject);
    }

    public void rightConcat(TeXObjectList teXObjectList) {
        this.content.addAll(teXObjectList);
    }

    public void appendValue(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXObject instanceof TokenListCommand) {
            this.appendValue((TokenListCommand)teXObject);
        } else if (!teXObject.isEmpty()) {
            TeXObject teXObject2 = TeXParserUtils.expandOnce((TeXObject)teXObject.clone(), teXParser, teXObjectList);
            if (teXParser.isStack(teXObject2)) {
                this.rightConcat((TeXObjectList)teXObject2);
            } else {
                this.append(teXObject2);
            }
        }
    }

    public void appendValue(TokenListCommand tokenListCommand) {
        if (!tokenListCommand.isEmpty()) {
            this.rightConcat((TeXObjectList)tokenListCommand.getContent().clone());
        }
    }

    @Override
    public void prepend(TeXObject teXObject) {
        this.content.add(0, teXObject);
    }

    public void leftConcat(TeXObjectList teXObjectList) {
        this.content.addAll(0, teXObjectList);
    }

    public void prependValue(TeXObject teXObject, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXObject instanceof TokenListCommand) {
            this.prependValue((TokenListCommand)teXObject);
        } else if (!teXObject.isEmpty()) {
            TeXObject teXObject2 = TeXParserUtils.expandOnce((TeXObject)teXObject.clone(), teXParser, teXObjectList);
            if (teXParser.isStack(teXObject2)) {
                this.leftConcat((TeXObjectList)teXObject2);
            } else {
                this.prepend(teXObject2);
            }
        }
    }

    public void prependValue(TokenListCommand tokenListCommand) {
        if (!tokenListCommand.isEmpty()) {
            this.leftConcat((TeXObjectList)tokenListCommand.getContent().clone());
        }
    }

    public TeXObject set(int n, TeXObject teXObject) throws ArrayIndexOutOfBoundsException {
        return this.content.set(n, teXObject);
    }

    public TeXObject get(int n) {
        return (TeXObject)this.content.get(n);
    }

    public int size() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public void clear() {
        this.content.clear();
    }

    public TeXObject head() {
        for (int i = 0; i < this.content.size(); ++i) {
            TeXObject teXObject = (TeXObject)this.content.get(i);
            if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) continue;
            return teXObject;
        }
        return new TeXObjectList();
    }

    public TeXObject tail() {
        TeXObjectList teXObjectList = new TeXObjectList();
        boolean bl = true;
        for (int i = 0; i < this.content.size(); ++i) {
            TeXObject teXObject = (TeXObject)this.content.get(i);
            if (bl && !(teXObject instanceof Ignoreable) && !(teXObject instanceof WhiteSpace)) {
                bl = false;
            }
            if (bl) continue;
            teXObjectList.add((TeXObject)teXObject.clone());
        }
        return teXObjectList;
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,content=%s]", this.getClass().getSimpleName(), this.getName(), this.content);
    }
}

