/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.CharsetUtil;
import org.apache.james.mime4j.util.ContentUtil;
import org.apache.james.mime4j.util.MimeUtil;

public final class RawField
implements Field {
    private final ByteSequence raw;
    private final int delimiterIdx;
    private final String name;
    private final String body;
    private String nameLowerCase;

    RawField(ByteSequence raw, int delimiterIdx, String name, String body) {
        if (name == null) {
            throw new IllegalArgumentException("Field may not be null");
        }
        this.raw = raw;
        this.delimiterIdx = delimiterIdx;
        this.name = name.trim();
        this.body = body;
    }

    public RawField(String name, String body) {
        this(null, -1, name, body);
        int pos = 0;
        while ((pos = body.indexOf(13, pos)) >= 0) {
            if (pos < body.length() + 2) {
                if (body.charAt(pos + 1) != '\n') {
                    throw new IllegalArgumentException("Injection of un-encoded line breaks inside header field could be assimilated to header injection");
                }
                if (pos != body.length() - 2 && !RawField.isSpace(body, pos + 2)) {
                    throw new IllegalArgumentException("Injection of un-encoded line breaks inside header field could be assimilated to header injection");
                }
            }
            ++pos;
        }
    }

    private static boolean isSpace(String body, int pos) {
        return body.charAt(pos) == ' ' || body.charAt(pos) == '\t';
    }

    @Override
    public ByteSequence getRaw() {
        return this.raw;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameLowerCase() {
        if (this.nameLowerCase == null) {
            this.nameLowerCase = this.name.toLowerCase(Locale.US);
        }
        return this.nameLowerCase;
    }

    @Override
    public String getBody() {
        if (this.body != null) {
            return this.body;
        }
        if (this.raw != null) {
            int off;
            int len = this.raw.length();
            if (len > (off = this.delimiterIdx + 1) + 1 && CharsetUtil.isWhitespace((char)(this.raw.byteAt(off) & 0xFF))) {
                ++off;
            }
            return MimeUtil.unfold(ContentUtil.decode(this.raw, off, len - off, StandardCharsets.UTF_8));
        }
        return null;
    }

    public int getDelimiterIdx() {
        return this.delimiterIdx;
    }

    public String toString() {
        if (this.raw != null) {
            return ContentUtil.decode(this.raw);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append(": ");
        if (this.body != null) {
            buf.append(this.body);
        }
        return buf.toString();
    }
}

