/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery.ec2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.SingleObjectCache;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.discovery.SeedHostsProvider;
import org.opensearch.discovery.ec2.AmazonEc2ClientReference;
import org.opensearch.discovery.ec2.AwsEc2Service;
import org.opensearch.discovery.ec2.SocketAccess;
import org.opensearch.transport.TransportService;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.Tag;

class AwsEc2SeedHostsProvider
implements SeedHostsProvider {
    private static final Logger logger = LogManager.getLogger(AwsEc2SeedHostsProvider.class);
    private final TransportService transportService;
    private final AwsEc2Service awsEc2Service;
    private final boolean bindAnyGroup;
    private final Set<String> groups;
    private final Map<String, List<String>> tags;
    private final Set<String> availabilityZones;
    private final String hostType;
    private final TransportAddressesCache dynamicHosts;
    private final Set<String> instanceStates;

    AwsEc2SeedHostsProvider(Settings settings, TransportService transportService, AwsEc2Service awsEc2Service) {
        this.transportService = transportService;
        this.awsEc2Service = awsEc2Service;
        this.hostType = (String)AwsEc2Service.HOST_TYPE_SETTING.get(settings);
        this.dynamicHosts = new TransportAddressesCache((TimeValue)AwsEc2Service.NODE_CACHE_TIME_SETTING.get(settings));
        this.bindAnyGroup = (Boolean)AwsEc2Service.ANY_GROUP_SETTING.get(settings);
        this.groups = new HashSet<String>();
        this.groups.addAll((Collection)AwsEc2Service.GROUPS_SETTING.get(settings));
        this.tags = AwsEc2Service.TAG_SETTING.getAsMap(settings);
        this.availabilityZones = new HashSet<String>();
        this.availabilityZones.addAll((Collection)AwsEc2Service.AVAILABILITY_ZONES_SETTING.get(settings));
        this.instanceStates = new HashSet<String>();
        this.instanceStates.add("running");
        this.instanceStates.add("pending");
        if (logger.isDebugEnabled()) {
            logger.debug("using host_type [{}], tags [{}], groups [{}] with any_group [{}], availability_zones [{}]", (Object)this.hostType, this.tags, this.groups, (Object)this.bindAnyGroup, this.availabilityZones);
        }
    }

    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        return (List)this.dynamicHosts.getOrRefresh();
    }

    protected List<TransportAddress> fetchDynamicNodes() {
        DescribeInstancesResponse descInstances;
        logger.info("fetching nodes from IMDS (instance-states={}, availability-zones={}, tags={}) ...", this.instanceStates, this.availabilityZones, this.tags);
        ArrayList<TransportAddress> dynamicHosts = new ArrayList<TransportAddress>();
        try (AmazonEc2ClientReference clientReference = this.awsEc2Service.client();){
            DescribeInstancesRequest instancesRequest = this.buildDescribeInstancesRequest();
            descInstances = SocketAccess.doPrivileged(() -> ((Ec2Client)clientReference.get()).describeInstances(instancesRequest));
        }
        catch (SdkException e) {
            logger.warn("error retrieving instance list from IMDS", (Throwable)e);
            return dynamicHosts;
        }
        logger.trace("finding seed nodes ...");
        for (Reservation reservation : descInstances.reservations()) {
            for (Instance instance : reservation.instances()) {
                if (!this.groups.isEmpty()) {
                    List instanceSecurityGroups = instance.securityGroups();
                    ArrayList<String> securityGroupNames = new ArrayList<String>(instanceSecurityGroups.size());
                    ArrayList<String> securityGroupIds = new ArrayList<String>(instanceSecurityGroups.size());
                    for (GroupIdentifier sg : instanceSecurityGroups) {
                        securityGroupNames.add(sg.groupName());
                        securityGroupIds.add(sg.groupId());
                    }
                    if (this.bindAnyGroup) {
                        if (Collections.disjoint(securityGroupNames, this.groups) && Collections.disjoint(securityGroupIds, this.groups)) {
                            logger.trace("filtering out instance {} based on groups {}, not part of {}", (Object)instance.instanceId(), (Object)instanceSecurityGroups, this.groups);
                            continue;
                        }
                    } else if (!securityGroupNames.containsAll(this.groups) && !securityGroupIds.containsAll(this.groups)) {
                        logger.trace("filtering out instance {} based on groups {}, does not include all of {}", (Object)instance.instanceId(), (Object)instanceSecurityGroups, this.groups);
                        continue;
                    }
                }
                String address = null;
                if (this.hostType.equals("private_dns")) {
                    address = instance.privateDnsName();
                } else if (this.hostType.equals("private_ip")) {
                    address = instance.privateIpAddress();
                } else if (this.hostType.equals("public_dns")) {
                    address = instance.publicDnsName();
                } else if (this.hostType.equals("public_ip")) {
                    address = instance.publicIpAddress();
                } else if (this.hostType.startsWith("tag:")) {
                    String tagName = this.hostType.substring("tag:".length());
                    logger.debug("reading hostname from [{}] instance tag", (Object)tagName);
                    List tags = instance.tags();
                    for (Tag tag : tags) {
                        if (!tag.key().equals(tagName)) continue;
                        address = tag.value();
                        logger.debug("using [{}] as the instance address", (Object)address);
                    }
                } else {
                    throw new IllegalArgumentException(this.hostType + " is unknown for discovery.ec2.host_type");
                }
                if (address != null) {
                    try {
                        TransportAddress[] addresses = this.transportService.addressesFromString(address);
                        for (int i = 0; i < addresses.length; ++i) {
                            logger.debug("adding {}, address {}, transport_address {}", (Object)instance.instanceId(), (Object)address, (Object)addresses[i]);
                            dynamicHosts.add(addresses[i]);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        String finalAddress = address;
                        logger.warn(() -> new ParameterizedMessage("failed to add {}, address {}", (Object)instance.instanceId(), (Object)finalAddress), (Throwable)e);
                        continue;
                    }
                }
                logger.warn("not adding {}, address is null, host_type {}", (Object)instance.instanceId(), (Object)this.hostType);
            }
        }
        logger.info("using dynamic transport addresses {}", dynamicHosts);
        return dynamicHosts;
    }

    private DescribeInstancesRequest buildDescribeInstancesRequest() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add((Filter)Filter.builder().name("instance-state-name").values(this.instanceStates).build());
        for (Map.Entry<String, List<String>> tagFilter : this.tags.entrySet()) {
            filters.add((Filter)Filter.builder().name("tag:" + tagFilter.getKey()).values((Collection)tagFilter.getValue()).build());
        }
        if (!this.availabilityZones.isEmpty()) {
            filters.add((Filter)Filter.builder().name("availability-zone").values(this.availabilityZones).build());
        }
        return (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(filters).build();
    }

    private final class TransportAddressesCache
    extends SingleObjectCache<List<TransportAddress>> {
        protected TransportAddressesCache(TimeValue refreshInterval) {
            super(refreshInterval, new ArrayList());
        }

        protected List<TransportAddress> refresh() {
            return AwsEc2SeedHostsProvider.this.fetchDynamicNodes();
        }
    }
}

