/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.join.SeekingTermSetTermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.RamUsageEstimator;

class TermsQuery
extends MultiTermQuery
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(TermsQuery.class);
    private final BytesRefHash terms;
    private final int[] ords;
    private final String fromField;
    private final Query fromQuery;
    private final Object indexReaderContextId;
    private final long ramBytesUsed;

    TermsQuery(String toField, BytesRefHash terms, String fromField, Query fromQuery, Object indexReaderContextId) {
        super(toField, CONSTANT_SCORE_BLENDED_REWRITE);
        this.terms = terms;
        this.ords = terms.sort();
        this.fromField = fromField;
        this.fromQuery = fromQuery;
        this.indexReaderContextId = indexReaderContextId;
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject((Object)this.field) + RamUsageEstimator.sizeOfObject((Object)fromField) + RamUsageEstimator.sizeOfObject((Object)fromQuery, (long)1024L) + RamUsageEstimator.sizeOfObject((Object)this.ords) + RamUsageEstimator.sizeOfObject((Object)terms);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        if (this.terms.size() == 0) {
            return TermsEnum.EMPTY;
        }
        return new SeekingTermSetTermsEnum(terms.iterator(), this.terms, this.ords);
    }

    public long getTermsCount() {
        return this.terms.size();
    }

    public String toString(String string) {
        return "TermsQuery{field=" + this.field + "fromQuery=" + this.fromQuery.toString(this.field) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TermsQuery other = (TermsQuery)((Object)obj);
        return Objects.equals(this.field, other.field) && Objects.equals(this.fromField, other.fromField) && Objects.equals(this.fromQuery, other.fromQuery) && Objects.equals(this.indexReaderContextId, other.indexReaderContextId);
    }

    public int hashCode() {
        return this.classHash() + Objects.hash(this.field, this.fromField, this.fromQuery, this.indexReaderContextId);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

