/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.stats.WorkloadGroupState;

public class WorkloadGroupStats
implements ToXContentObject,
Writeable {
    private final Map<String, WorkloadGroupStatsHolder> stats;

    public WorkloadGroupStats(Map<String, WorkloadGroupStatsHolder> stats) {
        this.stats = stats;
    }

    public WorkloadGroupStats(StreamInput in) throws IOException {
        this.stats = in.readMap(StreamInput::readString, WorkloadGroupStatsHolder::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.stats, StreamOutput::writeString, WorkloadGroupStatsHolder::writeTo);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("workload_groups");
        ArrayList<Map.Entry<String, WorkloadGroupStatsHolder>> entryList = new ArrayList<Map.Entry<String, WorkloadGroupStatsHolder>>(this.stats.entrySet());
        entryList.sort((k1, k2) -> ((String)k1.getKey()).compareTo((String)k2.getKey()));
        for (Map.Entry entry : entryList) {
            builder.startObject((String)entry.getKey());
            ((WorkloadGroupStatsHolder)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadGroupStats that = (WorkloadGroupStats)o;
        return Objects.equals(this.stats, that.stats);
    }

    public int hashCode() {
        return Objects.hash(this.stats);
    }

    public Map<String, WorkloadGroupStatsHolder> getStats() {
        return this.stats;
    }

    public static class WorkloadGroupStatsHolder
    implements ToXContentObject,
    Writeable {
        public static final String COMPLETIONS = "total_completions";
        public static final String REJECTIONS = "total_rejections";
        public static final String TOTAL_CANCELLATIONS = "total_cancellations";
        public static final String FAILURES = "failures";
        private long completions;
        private long rejections;
        private long failures;
        private long cancellations;
        private Map<ResourceType, ResourceStats> resourceStats;

        public WorkloadGroupStatsHolder() {
        }

        public WorkloadGroupStatsHolder(long completions, long rejections, long failures, long cancellations, Map<ResourceType, ResourceStats> resourceStats) {
            this.completions = completions;
            this.rejections = rejections;
            this.failures = failures;
            this.cancellations = cancellations;
            this.resourceStats = resourceStats;
        }

        public WorkloadGroupStatsHolder(StreamInput in) throws IOException {
            this.completions = in.readVLong();
            this.rejections = in.readVLong();
            this.failures = in.readVLong();
            this.cancellations = in.readVLong();
            this.resourceStats = in.readMap(i -> ResourceType.fromName(i.readString()), ResourceStats::new);
        }

        public long getCompletions() {
            return this.completions;
        }

        public long getRejections() {
            return this.rejections;
        }

        public long getCancellations() {
            return this.cancellations;
        }

        public Map<ResourceType, ResourceStats> getResourceStats() {
            return this.resourceStats;
        }

        public static WorkloadGroupStatsHolder from(WorkloadGroupState workloadGroupState) {
            WorkloadGroupStatsHolder statsHolder = new WorkloadGroupStatsHolder();
            HashMap<ResourceType, ResourceStats> resourceStatsMap = new HashMap<ResourceType, ResourceStats>();
            for (Map.Entry<ResourceType, WorkloadGroupState.ResourceTypeState> resourceTypeStateEntry : workloadGroupState.getResourceState().entrySet()) {
                resourceStatsMap.put(resourceTypeStateEntry.getKey(), ResourceStats.from(resourceTypeStateEntry.getValue()));
            }
            statsHolder.completions = workloadGroupState.getTotalCompletions();
            statsHolder.rejections = workloadGroupState.getTotalRejections();
            statsHolder.failures = workloadGroupState.getFailures();
            statsHolder.cancellations = workloadGroupState.getTotalCancellations();
            statsHolder.resourceStats = resourceStatsMap;
            return statsHolder;
        }

        public static void writeTo(StreamOutput out, WorkloadGroupStatsHolder statsHolder) throws IOException {
            out.writeVLong(statsHolder.completions);
            out.writeVLong(statsHolder.rejections);
            out.writeVLong(statsHolder.failures);
            out.writeVLong(statsHolder.cancellations);
            out.writeMap(statsHolder.resourceStats, (o, val) -> o.writeString(val.getName()), ResourceStats::writeTo);
        }

        public void writeTo(StreamOutput out) throws IOException {
            WorkloadGroupStatsHolder.writeTo(out, this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(COMPLETIONS, this.completions);
            builder.field(REJECTIONS, this.rejections);
            builder.field(TOTAL_CANCELLATIONS, this.cancellations);
            for (ResourceType resourceType : ResourceType.getSortedValues()) {
                ResourceStats resourceStats1 = this.resourceStats.get((Object)resourceType);
                if (resourceStats1 == null) continue;
                builder.startObject(resourceType.getName());
                resourceStats1.toXContent(builder, params);
                builder.endObject();
            }
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkloadGroupStatsHolder that = (WorkloadGroupStatsHolder)o;
            return this.completions == that.completions && this.rejections == that.rejections && Objects.equals(this.resourceStats, that.resourceStats) && this.failures == that.failures && this.cancellations == that.cancellations;
        }

        public int hashCode() {
            return Objects.hash(this.completions, this.rejections, this.cancellations, this.failures, this.resourceStats);
        }
    }

    public static class ResourceStats
    implements ToXContentObject,
    Writeable {
        public static final String CURRENT_USAGE = "current_usage";
        public static final String CANCELLATIONS = "cancellations";
        public static final String REJECTIONS = "rejections";
        public static final double PRECISION = 1.0E-9;
        private final double currentUsage;
        private final long cancellations;
        private final long rejections;

        public ResourceStats(double currentUsage, long cancellations, long rejections) {
            this.currentUsage = currentUsage;
            this.cancellations = cancellations;
            this.rejections = rejections;
        }

        public ResourceStats(StreamInput in) throws IOException {
            this.currentUsage = in.readDouble();
            this.cancellations = in.readVLong();
            this.rejections = in.readVLong();
        }

        public double getCurrentUsage() {
            return this.currentUsage;
        }

        public long getCancellations() {
            return this.cancellations;
        }

        public long getRejections() {
            return this.rejections;
        }

        public static ResourceStats from(WorkloadGroupState.ResourceTypeState resourceTypeState) {
            return new ResourceStats(resourceTypeState.getLastRecordedUsage(), resourceTypeState.cancellations.count(), resourceTypeState.rejections.count());
        }

        public static void writeTo(StreamOutput out, ResourceStats stats) throws IOException {
            out.writeDouble(stats.currentUsage);
            out.writeVLong(stats.cancellations);
            out.writeVLong(stats.rejections);
        }

        public void writeTo(StreamOutput out) throws IOException {
            ResourceStats.writeTo(out, this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(CURRENT_USAGE, this.currentUsage);
            builder.field(CANCELLATIONS, this.cancellations);
            builder.field(REJECTIONS, this.rejections);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceStats that = (ResourceStats)o;
            return this.currentUsage - that.currentUsage < 1.0E-9 && this.cancellations == that.cancellations && this.rejections == that.rejections;
        }

        public int hashCode() {
            return Objects.hash(this.currentUsage, this.cancellations, this.rejections);
        }
    }
}

