################################################################################
# Module for locating XRootD.
#
#   XROOTD_FOUND
#     Indicates whether the library has been found.
#
#   XROOTD_INCLUDE_DIRS
#      Specifies XRootD include directory.
#
#   XROOTD_LIBRARIES
#     Specifies XRootD libraries that should be passed to target_link_libararies.
#
#   XROOTD_<COMPONENT>_LIBRARIES
#     Specifies the libraries of a specific <COMPONENT>
#
#   XROOTD_<COMPONENT>_FOUND
#     Indicates whether the specified <COMPONENT> was found.
#
#   List of components: CLIENT, UTILS, SERVER, POSIX, HTTP and SSI
################################################################################


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was XRootDConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/XRootD" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(XRootD_FOUND TRUE)

set(XRootD_VERSION        5.6.4)
set(XRootD_PLUGIN_VERSION 5)

set(XRootD_VERSION_MAJOR  5)
set(XRootD_VERSION_MINOR  6)
set(XRootD_VERSION_PATCH  4)
set(XRootD_VERSION_TWEAK  0)
set(XRootD_VERSION_NUMBER 50604)
set(XRootD_VERSION_STRING v5.6.4)

################################################################################
# Make sure all *_FOUND variables are intialized to FALSE
################################################################################
SET( XROOTD_FOUND         FALSE )
SET( XROOTD_CLIENT_FOUND  FALSE )
SET( XROOTD_UTILS_FOUND   FALSE )
SET( XROOTD_SERVER_FOUND  FALSE )
SET( XROOTD_POSIX_FOUND   FALSE )
SET( XROOTD_HTTP_FOUND    FALSE )
SET( XROOTD_SSI_FOUND     FALSE )

################################################################################
# Set XRootD include paths
################################################################################

set_and_check(XRootD_CMAKE_DIR   "${CMAKE_CURRENT_LIST_DIR}")
set_and_check(XRootD_DATA_DIR    "${PACKAGE_PREFIX_DIR}/share")
set_and_check(XRootD_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include/xrootd")
set_and_check(XRootD_LIB_DIR     "${PACKAGE_PREFIX_DIR}/lib")

set(XRootD_INCLUDE_DIRS "${XRootD_INCLUDE_DIR};${XRootD_INCLUDE_DIR}/private")
set(XROOTD_INCLUDE_DIRS "${XRootD_INCLUDE_DIRS}") # backward compatibility

################################################################################
# XRootD client libs
#  - libXrdCl
################################################################################
FIND_LIBRARY( XROOTD_CLIENT_LIBRARIES XrdCl
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

IF( NOT "${XROOTD_CLIENT_LIBRARIES}" STREQUAL "XROOTD_CLIENT_LIBRARIES-NOTFOUND" )
  SET( XROOTD_CLIENT_FOUND TRUE )
  LIST( APPEND XROOTD_LIBRARIES ${XROOTD_CLIENT_LIBRARIES} )
ENDIF()

################################################################################
# XRootD utils libs
#  - libXrdUtils
################################################################################
FIND_LIBRARY( XROOTD_UTILS_LIBRARIES XrdUtils
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

IF( NOT "${XROOTD_UTILS_LIBRARIES}" STREQUAL "XROOTD_UTILS_LIBRARIES-NOTFOUND" )
  SET( XROOTD_UTILS_FOUND TRUE )
  LIST( APPEND XROOTD_LIBRARIES ${XROOTD_UTILS_LIBRARIES} )
ENDIF()

################################################################################
# XRootD server libs
#  - libXrdServer
################################################################################
FIND_LIBRARY( XROOTD_SERVER_LIBRARIES XrdServer
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

IF( NOT "${XROOTD_SERVER_LIBRARIES}" STREQUAL "XROOTD_SERVER_LIBRARIES-NOTFOUND" )
  SET( XROOTD_SERVER_FOUND TRUE )
  LIST( APPEND XROOTD_LIBRARIES ${XROOTD_SERVER_LIBRARIES} )
ENDIF()

################################################################################
# XRootD posix libs
#  - libXrdPosix
#  - libXrdPosixPreload
################################################################################
FIND_LIBRARY( XROOTD_POSIX_LIBRARY XrdPosix
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

FIND_LIBRARY( XROOTD_POSIX_PRELOAD_LIBRARY XrdPosixPreload
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

IF( NOT "${XROOTD_POSIX_LIBRARY}" STREQUAL "XROOTD_POSIX_LIBRARY-NOTFOUND" )
  IF( NOT "${XROOTD_POSIX_PRELOAD_LIBRARY}" STREQUAL "XROOTD_POSIX_PRELOAD_LIBRARY-NOTFOUND" )
    SET( XROOTD_POSIX_LIBRARIES ${XROOTD_POSIX_LIBRARY} ${XROOTD_POSIX_PRELOAD_LIBRARY} )
    SET( XROOTD_POSIX_FOUND TRUE )  
    LIST( APPEND XROOTD_LIBRARIES ${XROOTD_POSIX_LIBRARIES} )
  ENDIF()
ENDIF()

################################################################################
# XRootD HTTP (XrdHttp) libs
#  - libXrdHtppUtils
################################################################################
FIND_LIBRARY( XROOTD_HTTP_LIBRARIES XrdHttpUtils
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

IF( NOT "${XROOTD_HTTP_LIBRARIES}" STREQUAL "XROOTD_HTTP_LIBRARIES-NOTFOUND" )
  SET( XROOTD_HTTP_FOUND TRUE )
  LIST( APPEND XROOTD_LIBRARIES ${XROOTD_HTTP_LIBRARIES} )
ENDIF()

################################################################################
# XRootD SSI libs
#  - XrdSsiLib
#  - XrdSsiShMap
################################################################################
FIND_LIBRARY( XROOTD_SSI_LIBRARY XrdSsiLib
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

FIND_LIBRARY( XROOTD_SSI_SHMAP_LIBRARY XrdSsiShMap
  PATHS ${XRootD_LIB_DIR} NO_DEFAULT_PATH
)

IF( NOT "${XROOTD_SSI_LIBRARY}" STREQUAL "XROOTD_SSI_LIBRARY-NOTFOUND" )
  IF( NOT "${XROOTD_SSI_SHMAP_LIBRARY}" STREQUAL "XROOTD_SSI_SHMAP_LIBRARY-NOTFOUND" )
    SET( XROOTD_SSI_LIBRARIES ${XROOTD_SSI_LIBRARY} ${XROOTD_SSI_SHMAP_LIBRARY} )
    SET( XROOTD_SSI_FOUND TRUE )
    LIST( APPEND XROOTD_LIBRARIES ${XROOTD_SSI_LIBRARIES} )
  ENDIF()
ENDIF()

################################################################################
# Set up the XRootD find module
################################################################################

foreach(COMPONENT UTILS CLIENT SERVER HTTP POSIX SSI)
  # Set uppercase names to keep backward compatibility
  set(XRootD_${COMPONENT}_FOUND ${XROOTD_${COMPONENT}_FOUND})
  set(XRootD_${COMPONENT}_LIBRARIES ${XROOTD_${COMPONENT}_LIBRARIES})
endforeach()

check_required_components(XRootD)

set(XROOTD_FOUND ${XRootD_FOUND})
set(XRootD_LIBRARIES ${XROOTD_LIBRARIES})

message(DEBUG "XRootD_VERSION        = '${XRootD_VERSION}'")
message(DEBUG "XRootD_VERSION_MAJOR  = '${XRootD_VERSION_MAJOR}'")
message(DEBUG "XRootD_VERSION_MINOR  = '${XRootD_VERSION_MINOR}'")
message(DEBUG "XRootD_VERSION_PATCH  = '${XRootD_VERSION_PATCH}'")
message(TRACE "XRootD_VERSION_TWEAK  = '${XRootD_VERSION_TWEAK}'")
message(TRACE "XRootD_VERSION_NUMBER = '${XRootD_VERSION_NUMBER}'")

message(TRACE "XRootD_FOUND          = '${XRootD_FOUND}'")
message(TRACE "XRootD_INSTALL_PREFIX = '/usr'")
message(TRACE "XRootD_INCLUDE_DIR    = '${XRootD_INCLUDE_DIR}'")
message(TRACE "XRootD_LIBRARY_DIR    = '${XRootD_LIBRARY_DIR}'")
message(TRACE "XRootD_LIBRARIES      = '${XRootD_LIBRARIES}'")

foreach(COMPONENT UTILS CLIENT SERVER HTTP POSIX SSI)
  message(TRACE "XRootD_${COMPONENT}_FOUND\t\t= '${XRootD_${COMPONENT}_FOUND}'")
endforeach()

foreach(COMPONENT UTILS CLIENT SERVER HTTP POSIX SSI)
  message(TRACE "XRootD_${COMPONENT}_LIBRARIES\t= '${XRootD_${COMPONENT}_LIBRARIES}'")
endforeach()

include(FindPackageHandleStandardArgs)
set(XRootD_CONFIG ${CMAKE_CURRENT_LIST_FILE})
find_package_handle_standard_args(XRootD CONFIG_MODE HANDLE_COMPONENTS)
