/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tomcat.util.res.StringManager;

public final class NetMask {
    private static final StringManager sm = StringManager.getManager(NetMask.class);
    private final String expression;
    private final byte[] netaddr;
    private final int nrBytes;
    private final int lastByteShift;
    private final boolean foundPort;
    private final Pattern portPattern;

    public NetMask(String string) {
        int n;
        String string2;
        this.expression = string;
        int n2 = string.indexOf(59);
        if (n2 == -1) {
            this.foundPort = false;
            string2 = string;
            this.portPattern = null;
        } else {
            this.foundPort = true;
            string2 = string.substring(0, n2);
            try {
                this.portPattern = Pattern.compile(string.substring(n2 + 1));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new IllegalArgumentException(sm.getString("netmask.invalidPort", new Object[]{string}), patternSyntaxException);
            }
        }
        int n3 = string2.indexOf(47);
        if (n3 == -1) {
            try {
                this.netaddr = InetAddress.getByName(string2).getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", new Object[]{string2}));
            }
            this.nrBytes = this.netaddr.length;
            this.lastByteShift = 0;
            return;
        }
        String string3 = string2.substring(0, n3);
        String string4 = string2.substring(n3 + 1);
        try {
            this.netaddr = InetAddress.getByName(string3).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(sm.getString("netmask.invalidAddress", new Object[]{string3}));
        }
        int n4 = this.netaddr.length * 8;
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNotNumeric", new Object[]{string4}));
        }
        if (n < 0) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrNegative", new Object[]{string4}));
        }
        if (n > n4) {
            throw new IllegalArgumentException(sm.getString("netmask.cidrTooBig", new Object[]{string4, n4}));
        }
        this.nrBytes = n / 8;
        int n5 = n % 8;
        this.lastByteShift = n5 == 0 ? 0 : 8 - n5;
    }

    public boolean matches(InetAddress inetAddress, int n) {
        if (!this.foundPort) {
            return false;
        }
        String string = Integer.toString(n);
        if (!this.portPattern.matcher(string).matches()) {
            return false;
        }
        return this.matches(inetAddress, true);
    }

    public boolean matches(InetAddress inetAddress) {
        return this.matches(inetAddress, false);
    }

    public boolean matches(InetAddress inetAddress, boolean bl) {
        int n;
        if (!bl && this.foundPort) {
            return false;
        }
        byte[] byArray = inetAddress.getAddress();
        if (byArray.length != this.netaddr.length) {
            return false;
        }
        for (n = 0; n < this.nrBytes; ++n) {
            if (this.netaddr[n] == byArray[n]) continue;
            return false;
        }
        if (this.lastByteShift == 0) {
            return true;
        }
        int n2 = this.netaddr[n] ^ byArray[n];
        return n2 >> this.lastByteShift == 0;
    }

    public String toString() {
        return this.expression;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NetMask netMask = (NetMask)object;
        return this.nrBytes == netMask.nrBytes && this.lastByteShift == netMask.lastByteShift && Arrays.equals(this.netaddr, netMask.netaddr);
    }

    public int hashCode() {
        int n = 31 * Arrays.hashCode(this.netaddr) + this.lastByteShift;
        return n;
    }
}

