<!--
title: Tencent Cloud - Serverless Cloud Function (SCF) Documentation
menuText: Tencent
menuOrder: 3
layout: Doc
-->

<!-- DOCS-SITE-LINK:START automatically generated  -->

### [Read this on the main serverless docs site](https://www.serverless.com/framework/docs/providers/tencent/)

<!-- DOCS-SITE-LINK:END -->

# Tencent Provider Documentation

**Note:** [Tencent Cloud AccessKeys](./guide/credentials.md) are required for using the CLI.

<div class="docsSections">
  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Guides</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./guide/intro.md">Intro</a></li>
        <li><a href="./guide/installation.md">Installation</a></li>
        <li><a href="./guide/quick-start.md">Quickstart</a></li>
        <li><a href="./guide/credentials.md">Credentials</a></li>
        <li><a href="./guide/services.md">Services</a></li>
        <li><a href="./guide/functions.md">Functions</a></li>
        <li><a href="./guide/events.md">Events</a></li>
        <li><a href="./guide/deploying.md">Deploying</a></li>
        <li><a href="./guide/variables.md">Variables</a></li>
        <li><a href="./guide/packaging.md">Packaging</a></li>
        <li><a href="./guide/plugins.md">Plugins</a></li>
        <li><a href="./guide/workflow.md">Workflow</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>CLI references</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./cli-reference/create.md">Create</a></li>
        <li><a href="./cli-reference/install.md">Install</a></li>
        <li><a href="./cli-reference/deploy.md">Deploy</a></li>
        <li><a href="./cli-reference/deploy-function.md">Deploy Function</a></li>
        <li><a href="./cli-reference/deploy-list.md">Deploy List</a></li>
        <li><a href="./cli-reference/invoke.md">Invoke</a></li>
        <li><a href="./cli-reference/logs.md">Logs</a></li>
        <li><a href="./cli-reference/metrics.md">Metrics</a></li>
        <li><a href="./cli-reference/info.md">Info</a></li>
        <li><a href="./cli-reference/rollback.md">Rollback</a></li>
        <li><a href="./cli-reference/remove.md">Remove</a></li>
      </ul>
    </div>
  </div>

  <div class="docsSection">
    <div class="docsSectionSubHeader">
      <h4>Events</h4>
    </div>
    <div class="docsProviderItems">
      <ul>
        <li><a href="./events/apigateway.md">API Gateway</a></li>
        <li><a href="./events/cloud-kafka.md">Cloud Kafka</a></li>
        <li><a href="./events/cmq.md">Cloud Message Queue</a></li>
        <li><a href="./events/cos.md">Cloud Object Storage</a></li>
        <li><a href="./events/timer.md">Timer</a></li>
      </ul>
    </div>
  </div>
