/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class RaiseAtom
extends Atom {
    private Atom base;
    private int runit;
    private int hunit;
    private int dunit;
    private float r;
    private float h;
    private float d;

    public RaiseAtom(Atom base, int runit, float r, int hunit, float h, int dunit, float d) {
        this.base = base;
        this.runit = runit;
        this.r = r;
        this.hunit = hunit;
        this.h = h;
        this.dunit = dunit;
        this.d = d;
    }

    public int getLeftType() {
        return this.base.getLeftType();
    }

    public int getRightType() {
        return this.base.getRightType();
    }

    public Box createBox(TeXEnvironment env) {
        Box bbox = this.base.createBox(env);
        if (this.runit == -1) {
            bbox.setShift(0.0f);
        } else {
            bbox.setShift(-this.r * SpaceAtom.getFactor(this.runit, env));
        }
        if (this.hunit == -1) {
            return bbox;
        }
        HorizontalBox hbox = new HorizontalBox(bbox);
        hbox.setHeight(this.h * SpaceAtom.getFactor(this.hunit, env));
        if (this.dunit == -1) {
            hbox.setDepth(0.0f);
        } else {
            hbox.setDepth(this.d * SpaceAtom.getFactor(this.dunit, env));
        }
        return hbox;
    }
}

