/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auditlog.impl.AuditCategory;
import org.opensearch.security.configuration.StaticResourceException;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.threadpool.ThreadPool;

public class AuditApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/audit/"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/audit/config"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/audit/")));
    @VisibleForTesting
    public static final String READONLY_FIELD = "_readonly";
    @VisibleForTesting
    public static final String STATIC_RESOURCE = "/static_config/static_audit.yml";
    private final List<String> readonlyFields;

    public AuditApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        this(clusterService, threadPool, securityApiDependencies, AuditApiAction.readReadonlyFieldsFromFile());
    }

    private static List<String> readReadonlyFieldsFromFile() {
        try {
            List readonlyFields = (List)((Map)DefaultObjectMapper.YAML_MAPPER.readValue(AuditApiAction.class.getResourceAsStream(STATIC_RESOURCE), (TypeReference)new TypeReference<Map<String, List<String>>>(){})).get(READONLY_FIELD);
            if (!AuditConfig.FIELD_PATHS.containsAll(readonlyFields)) {
                throw new StaticResourceException("Invalid read-only field paths provided in static resource file /static_config/static_audit.yml", new Object[0]);
            }
            return readonlyFields;
        }
        catch (IOException e) {
            throw new StaticResourceException("Unable to load audit static resource file", e, new Object[0]);
        }
    }

    protected AuditApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies, List<String> readonlyFields) {
        super(Endpoint.AUDIT, clusterService, threadPool, securityApiDependencies);
        this.readonlyFields = readonlyFields;
        this.requestHandlersBuilder.configureRequestHandlers(this::auditApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return CType.AUDIT;
    }

    @Override
    protected void consumeParameters(RestRequest request) {
    }

    private void auditApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.onGetRequest((CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.withEnabledAuditApi((RestRequest)request).map(this::processGetRequest).map(securityConfiguration -> {
            SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
            configuration.putCObject(READONLY_FIELD, this.readonlyFields);
            return ValidationResult.success(securityConfiguration);
        }))).onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.withEnabledAuditApi((RestRequest)request).map(this::processPatchRequest))).onChangeRequest(RestRequest.Method.PUT, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.withEnabledAuditApi((RestRequest)request).map(ignore -> this.processPutRequest("config", (RestRequest)request)))).override(RestRequest.Method.POST, RequestHandler.methodNotImplementedHandler).override(RestRequest.Method.DELETE, RequestHandler.methodNotImplementedHandler);
    }

    ValidationResult<RestRequest> withEnabledAuditApi(RestRequest request) {
        if (!this.securityApiDependencies.configurationRepository().isAuditHotReloadingEnabled()) {
            return ValidationResult.error(RestStatus.NOT_IMPLEMENTED, Responses.methodNotImplementedMessage(request.method()));
        }
        return ValidationResult.success(request);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return AuditApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return AuditApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) throws IOException {
                return EndpointValidator.super.onConfigChange(securityConfiguration).map(this::verifyNotReadonlyFieldUpdated);
            }

            private ValidationResult<SecurityConfiguration> verifyNotReadonlyFieldUpdated(SecurityConfiguration securityConfiguration) {
                if (!this.isCurrentUserAdmin()) {
                    JsonNode existingResource = Utils.convertJsonToJackson(securityConfiguration.configuration(), false).get("config");
                    JsonNode targetResource = securityConfiguration.requestContent();
                    if (AuditApiAction.this.readonlyFields.stream().anyMatch(path -> !existingResource.at(path).equals((Object)targetResource.at(path)))) {
                        return ValidationResult.error(RestStatus.CONFLICT, Responses.conflictMessage("Attempted to update read-only property."));
                    }
                }
                return ValidationResult.success(securityConfiguration);
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return new AuditRequestContentValidator(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return AuditApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.of((Object)"enabled", (Object)((Object)RequestContentValidator.DataType.BOOLEAN), (Object)"audit", (Object)((Object)RequestContentValidator.DataType.OBJECT), (Object)"compliance", (Object)((Object)RequestContentValidator.DataType.OBJECT));
                    }
                });
            }
        };
    }

    public static class AuditRequestContentValidator
    extends RequestContentValidator {
        public static final Set<AuditCategory> DISABLED_REST_CATEGORIES = Set.of(AuditCategory.BAD_HEADERS, AuditCategory.SSL_EXCEPTION, AuditCategory.AUTHENTICATED, AuditCategory.FAILED_LOGIN, AuditCategory.GRANTED_PRIVILEGES, AuditCategory.MISSING_PRIVILEGES);
        public static final Set<AuditCategory> DISABLED_TRANSPORT_CATEGORIES = Set.of(AuditCategory.BAD_HEADERS, AuditCategory.SSL_EXCEPTION, AuditCategory.AUTHENTICATED, AuditCategory.FAILED_LOGIN, AuditCategory.GRANTED_PRIVILEGES, AuditCategory.MISSING_PRIVILEGES, AuditCategory.INDEX_EVENT, AuditCategory.OPENDISTRO_SECURITY_INDEX_ATTEMPT);

        protected AuditRequestContentValidator(RequestContentValidator.ValidationContext validationContext) {
            super(validationContext);
        }

        @Override
        public ValidationResult<JsonNode> validate(RestRequest request) throws IOException {
            return super.validate(request).map(this::validateAuditPayload);
        }

        @Override
        public ValidationResult<JsonNode> validate(RestRequest request, JsonNode jsonContent) throws IOException {
            return super.validate(request, jsonContent).map(this::validateAuditPayload);
        }

        private ValidationResult<JsonNode> validateAuditPayload(JsonNode jsonContent) {
            try {
                AuditConfig auditConfig = DefaultObjectMapper.readTree(jsonContent, AuditConfig.class);
                AuditConfig.Filter filter = auditConfig.getFilter();
                if (!DISABLED_REST_CATEGORIES.containsAll(filter.getDisabledRestCategories())) {
                    throw new IllegalArgumentException("Invalid REST categories passed in the request");
                }
                if (!DISABLED_TRANSPORT_CATEGORIES.containsAll(filter.getDisabledTransportCategories())) {
                    throw new IllegalArgumentException("Invalid transport categories passed in the request");
                }
                return ValidationResult.success(jsonContent);
            }
            catch (Exception e) {
                this.validationError = RequestContentValidator.ValidationError.BODY_NOT_PARSEABLE;
                LOGGER.error("Invalid content passed in the request", (Throwable)e);
                return ValidationResult.error(RestStatus.BAD_REQUEST, this);
            }
        }
    }
}

