/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.parkservices.StreamSampler;
import com.amazon.randomcutforest.parkservices.returntypes.GenericAnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import com.amazon.randomcutforest.summarization.GenericMultiCenter;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.Summarizer;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

public class GlobalLocalAnomalyDetector<P>
extends StreamSampler<P> {
    public static int DEFAULT_MAX = 10;
    public static float FLOAT_MAX = 10.0f;
    public static double DEFAULT_IGNORE_SMALL_CLUSTER_REPRESENTATIVE = 0.005;
    protected int doNotreclusterWithin;
    protected final BasicThresholder thresholder;
    protected long lastCluster = 0L;
    protected double lastMean = 1.0;
    List<ICluster<P>> clusters;
    protected int maxAllowed;
    protected double shrinkage;
    protected int numberOfRepresentatives;
    protected double ignoreBelow;
    protected BiFunction<P, P, Double> globalDistance;

    public static Builder<?> builder() {
        return new Builder();
    }

    protected GlobalLocalAnomalyDetector(Builder<?> builder) {
        super(builder);
        this.thresholder = new BasicThresholder(builder.timeDecay);
        this.thresholder.setAbsoluteThreshold(1.2);
        this.doNotreclusterWithin = builder.doNotReclusterWithin.orElse(builder.capacity / 2);
        this.shrinkage = builder.shrinkage;
        this.maxAllowed = builder.maxAllowed;
        this.numberOfRepresentatives = builder.numberOfRepresentatives;
        this.ignoreBelow = builder.ignoreBelow;
    }

    protected GlobalLocalAnomalyDetector(Builder<?> builder, BiFunction<P, P, Double> distance) {
        this(builder);
        this.globalDistance = distance;
    }

    public void setGlobalDistance(BiFunction<P, P, Double> dist) {
        this.globalDistance = dist;
    }

    public void setZfactor(double factor) {
        this.thresholder.setZfactor(factor);
    }

    public double getZfactor() {
        return this.thresholder.getZFactor();
    }

    public void setLowerThreshold(double lowerThreshold) {
        this.thresholder.setAbsoluteThreshold(lowerThreshold);
    }

    public double getLowerThreshold() {
        return this.thresholder.getAbsoluteThreshold();
    }

    public int getDoNotreclusterWithin() {
        return this.doNotreclusterWithin;
    }

    public void setDoNotreclusterWithin(int value) {
        CommonUtils.checkArgument((value > 0 ? 1 : 0) != 0, (String)" has to be positive, recommended as 1/2 the capacity");
        this.doNotreclusterWithin = value;
    }

    public int getNumberOfRepresentatives() {
        return this.numberOfRepresentatives;
    }

    public void setNumberOfRepresentatives(int reps) {
        CommonUtils.checkArgument((reps > 0 ? 1 : 0) != 0, (String)" has to be positive");
    }

    public double getShrinkage() {
        return this.shrinkage;
    }

    public void setShrinkage(double value) {
        CommonUtils.checkArgument((value >= 0.0 && value <= 1.0 ? 1 : 0) != 0, (String)" has to be in [0,1]");
        this.shrinkage = value;
    }

    public double getIgnoreBelow() {
        return this.ignoreBelow;
    }

    public void setIgnoreBelow(double value) {
        CommonUtils.checkArgument((value >= 0.0 && value < 0.1 ? 1 : 0) != 0, (String)" relative weight has to be in range [0,0.1] ");
        this.ignoreBelow = value;
    }

    public int getMaxAllowed() {
        return this.maxAllowed;
    }

    public void setMaxAllowed(int value) {
        CommonUtils.checkArgument((value >= 5 && value < 100 ? 1 : 0) != 0, (String)" too few or too many clusters are not meaningful to this algorithm");
        this.maxAllowed = value;
    }

    public GenericAnomalyDescriptor<P> process(P object, float weight, BiFunction<P, P, Double> localDistance, boolean considerOcclusion) {
        CommonUtils.checkArgument((weight >= 0.0f ? 1 : 0) != 0, (String)"weight cannot be negative");
        if (this.sequenceNumber > this.lastCluster + (long)this.doNotreclusterWithin) {
            CommonUtils.checkArgument((this.globalDistance != null ? 1 : 0) != 0, (String)"set global distance function");
            double currentMean = this.thresholder.getPrimaryDeviation().getMean();
            if (Math.abs(currentMean - this.lastMean) > 0.1 || currentMean > 1.7 || this.sequenceNumber > this.lastCluster + (long)(20 * this.doNotreclusterWithin)) {
                this.lastCluster = this.sequenceNumber;
                this.lastMean = currentMean;
                this.clusters = this.getClusters(this.maxAllowed, 4 * this.maxAllowed, 1, this.numberOfRepresentatives, this.shrinkage, this.globalDistance, null);
            }
        }
        List<Weighted<P>> result = this.score(object, localDistance, considerOcclusion);
        double threshold = this.thresholder.threshold();
        double grade = 0.0;
        float score = 0.0f;
        if (result != null) {
            score = result.stream().map(a -> Float.valueOf(a.weight)).reduce(Float.valueOf(FLOAT_MAX), Float::min).floatValue();
            if (score < FLOAT_MAX) {
                double sum = result.stream().map(a -> a.weight == FLOAT_MAX ? 0.0 : Math.exp(-a.weight * a.weight)).reduce(0.0, Double::sum);
                for (Weighted<P> item : result) {
                    item.weight = item.weight == FLOAT_MAX ? 0.0f : (float)Math.min(1.0, (double)((float)Math.exp(-item.weight * item.weight)) / sum);
                }
            } else {
                for (Weighted<P> item : result) {
                    item.weight = 1.0f / (float)result.size();
                }
            }
            grade = this.thresholder.getAnomalyGrade(score, false);
        }
        this.thresholder.update(score, Math.min((double)score, this.thresholder.getZFactor()));
        this.sample(object, weight);
        return new GenericAnomalyDescriptor<P>(result, score, threshold, grade);
    }

    public List<Weighted<P>> score(P current, BiFunction<P, P, Double> localDistance, boolean considerOcclusion) {
        if (this.clusters == null) {
            return null;
        }
        BiFunction<P, P, Double> local = localDistance != null ? localDistance : this.globalDistance;
        double totalWeight = this.clusters.stream().map(e -> e.getWeight()).reduce(0.0, Double::sum);
        ArrayList<Candidate> candidateList = new ArrayList<Candidate>();
        for (ICluster<P> cluster : this.clusters) {
            double wt = cluster.averageRadius();
            double tempMinimum = Double.MAX_VALUE;
            Object closestInCluster = null;
            for (Weighted rep : cluster.getRepresentatives()) {
                if (!((double)rep.weight > this.ignoreBelow * totalWeight)) continue;
                double tempDist = local.apply(current, rep.index);
                if (tempDist < 0.0) {
                    throw new IllegalArgumentException(" distance cannot be negative ");
                }
                if (!(tempMinimum > tempDist)) continue;
                tempMinimum = tempDist;
                closestInCluster = rep.index;
            }
            if (closestInCluster == null) continue;
            candidateList.add(new Candidate(closestInCluster, wt, tempMinimum));
        }
        candidateList.sort((o1, o2) -> Double.compare(o1.distance, o2.distance));
        CommonUtils.checkArgument((candidateList.size() > 0 ? 1 : 0) != 0, (String)"empty candidate list, should not happen");
        ArrayList<Weighted<P>> answer = new ArrayList<Weighted<P>>();
        if (((Candidate)candidateList.get((int)0)).distance == 0.0) {
            answer.add(new Weighted(((Candidate)candidateList.get((int)0)).representative, 0.0f));
            return answer;
        }
        for (int index = 0; index < candidateList.size(); ++index) {
            Candidate head = (Candidate)candidateList.get(index);
            double dist = localDistance == null ? head.distance : this.globalDistance.apply(current, head.representative);
            float tempMeasure = head.averageRadiusOfCluster > 0.0 ? Math.min(FLOAT_MAX, (float)(dist / head.averageRadiusOfCluster)) : FLOAT_MAX;
            answer.add(new Weighted(head.representative, tempMeasure));
            if (!considerOcclusion) continue;
            for (int j = index + 1; j < candidateList.size(); ++j) {
                double candidateDistance;
                double occludeDistance = local.apply(head.representative, ((Candidate)candidateList.get((int)j)).representative);
                if (!(occludeDistance < (candidateDistance = ((Candidate)candidateList.get((int)j)).distance)) || !(head.distance > Math.sqrt(head.distance * head.distance + candidateDistance * candidateDistance))) continue;
                candidateList.remove(j);
            }
        }
        return answer;
    }

    public GlobalLocalAnomalyDetector(GlobalLocalAnomalyDetector first, GlobalLocalAnomalyDetector second, Builder<?> builder, boolean recluster, BiFunction<P, P, Double> distance) {
        super(first, second, builder.capacity, builder.timeDecay, builder.randomSeed);
        this.thresholder = new BasicThresholder(builder.timeDecay, builder.anomalyRate, false);
        this.thresholder.setAbsoluteThreshold(1.2);
        this.doNotreclusterWithin = builder.doNotReclusterWithin.orElse(builder.capacity / 2);
        this.shrinkage = builder.shrinkage;
        this.maxAllowed = builder.maxAllowed;
        this.numberOfRepresentatives = builder.numberOfRepresentatives;
        this.globalDistance = distance;
        if (recluster) {
            this.lastCluster = this.sequenceNumber;
            this.clusters = this.getClusters(this.maxAllowed, 4 * this.maxAllowed, 1, this.numberOfRepresentatives, this.shrinkage, this.globalDistance, null);
        }
    }

    @Override
    public ArrayList<Weighted<P>> getObjectList() {
        return this.objectList;
    }

    public List<ICluster<P>> getClusters() {
        return this.clusters;
    }

    public List<ICluster<P>> getClusters(int maxAllowed, int initial, int stopAt, int representatives, double shrink, BiFunction<P, P, Double> distance, List<ICluster<P>> previousClusters) {
        BiFunction<Object, Float, ICluster> clusterInitializer = (a, b) -> GenericMultiCenter.initialize((Object)a, (float)b.floatValue(), (double)shrink, (int)representatives);
        return Summarizer.summarize((List)this.objectList, (int)maxAllowed, (int)initial, (int)stopAt, (boolean)false, (double)0.8, distance, clusterInitializer, (long)0L, (boolean)false, previousClusters);
    }

    public static class Builder<T extends Builder<T>>
    extends StreamSampler.Builder<T> {
        protected double shrinkage = GenericMultiCenter.DEFAULT_SHRINKAGE;
        protected double ignoreBelow = DEFAULT_IGNORE_SMALL_CLUSTER_REPRESENTATIVE;
        protected int numberOfRepresentatives = GenericMultiCenter.DEFAULT_NUMBER_OF_REPRESENTATIVES;
        protected Optional<Integer> doNotReclusterWithin = Optional.empty();
        protected int maxAllowed = DEFAULT_MAX;
        protected double anomalyRate = 0.01;

        public T ignoreBelow(double ignoreBelow) {
            this.ignoreBelow = ignoreBelow;
            return (T)this;
        }

        public T shrinkage(double shrinkage) {
            this.shrinkage = shrinkage;
            return (T)this;
        }

        public T doNotReclusterWithin(int refresh) {
            this.doNotReclusterWithin = Optional.of(refresh);
            return (T)this;
        }

        public T maxAllowed(int maxAllowed) {
            this.maxAllowed = maxAllowed;
            return (T)this;
        }

        public T numberOfRepresentatives(int number) {
            this.numberOfRepresentatives = number;
            return (T)this;
        }

        public T anomalyRate(double anomalyRate) {
            this.anomalyRate = anomalyRate;
            return (T)this;
        }

        @Override
        public GlobalLocalAnomalyDetector build() {
            return new GlobalLocalAnomalyDetector(this);
        }
    }

    class Candidate {
        P representative;
        double averageRadiusOfCluster;
        double distance;

        Candidate(P representative, double averageRadiusOfCluster, double distance) {
            this.representative = representative;
            this.averageRadiusOfCluster = averageRadiusOfCluster;
            this.distance = distance;
        }
    }
}

