/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.IMultiVisitorFactory;
import com.amazon.randomcutforest.IVisitorFactory;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.store.IPointStoreView;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import com.amazon.randomcutforest.tree.ITree;
import com.amazon.randomcutforest.tree.NodeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Stack;

public class RandomCutTree
implements ITree<Integer, float[]> {
    private Random testRandom;
    protected boolean storeSequenceIndexesEnabled;
    protected boolean centerOfMassEnabled;
    private long randomSeed;
    protected int root;
    protected IPointStoreView<float[]> pointStoreView;
    protected int numberOfLeaves;
    protected AbstractNodeStore nodeStore;
    protected double boundingBoxCacheFraction;
    protected int outputAfter;
    protected int dimension;
    protected final HashMap<Integer, Integer> leafMass;
    protected double[] rangeSumData;
    protected float[] boundingBoxData;
    protected float[] pointSum;
    protected HashMap<Integer, List<Long>> sequenceMap;

    protected RandomCutTree(Builder<?> builder) {
        this.pointStoreView = builder.pointStoreView;
        this.numberOfLeaves = builder.capacity;
        this.randomSeed = builder.randomSeed;
        this.testRandom = builder.random;
        this.outputAfter = builder.outputAfter.orElse(Math.max(1, this.numberOfLeaves / 4));
        this.dimension = builder.dimension != 0 ? builder.dimension : this.pointStoreView.getDimensions();
        this.nodeStore = builder.nodeStore != null ? builder.nodeStore : ((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)((AbstractNodeStore.Builder)AbstractNodeStore.builder().capacity(this.numberOfLeaves - 1)).storeParent(builder.storeParent)).dimension(this.dimension)).build();
        this.boundingBoxCacheFraction = builder.boundingBoxCacheFraction;
        this.storeSequenceIndexesEnabled = builder.storeSequenceIndexesEnabled;
        this.centerOfMassEnabled = builder.centerOfMassEnabled;
        this.root = builder.root;
        this.leafMass = new HashMap();
        int cache_limit = (int)Math.floor(this.boundingBoxCacheFraction * (double)(this.numberOfLeaves - 1));
        this.rangeSumData = new double[cache_limit];
        this.boundingBoxData = new float[2 * this.dimension * cache_limit];
        if (this.centerOfMassEnabled) {
            this.pointSum = new float[(this.numberOfLeaves - 1) * this.dimension];
        }
        if (this.storeSequenceIndexesEnabled) {
            this.sequenceMap = new HashMap();
        }
    }

    @Override
    public <T> void setConfig(String name, T value, Class<T> clazz) {
        if (!"bounding_box_cache_fraction".equals(name)) {
            throw new IllegalArgumentException("Unsupported configuration setting: " + name);
        }
        CommonUtils.checkArgument(Double.class.isAssignableFrom(clazz), () -> String.format("Setting '%s' must be a double value", name));
        this.setBoundingBoxCacheFraction((Double)value);
    }

    @Override
    public <T> T getConfig(String name, Class<T> clazz) {
        CommonUtils.checkNotNull(clazz, "clazz must not be null");
        if ("bounding_box_cache_fraction".equals(name)) {
            CommonUtils.checkArgument(clazz.isAssignableFrom(Double.class), () -> String.format("Setting '%s' must be a double value", name));
            return clazz.cast(this.boundingBoxCacheFraction);
        }
        throw new IllegalArgumentException("Unsupported configuration setting: " + name);
    }

    public void setBoundingBoxCacheFraction(double fraction) {
        CommonUtils.checkArgument(0.0 <= fraction && fraction <= 1.0, "incorrect parameter");
        this.boundingBoxCacheFraction = fraction;
        this.resizeCache(fraction);
    }

    protected Cut randomCut(double factor, float[] point, BoundingBox box) {
        float minValue;
        double range = 0.0;
        for (int i = 0; i < point.length; ++i) {
            float minValue2 = (float)box.getMinValue(i);
            float maxValue = (float)box.getMaxValue(i);
            if (point[i] < minValue2) {
                minValue2 = point[i];
            } else if (point[i] > maxValue) {
                maxValue = point[i];
            }
            range += (double)(maxValue - minValue2);
        }
        CommonUtils.checkArgument(range > 0.0, () -> " the union is a single point " + Arrays.toString(point) + "or the box is inappropriate, box" + box.toString() + "factor =" + factor);
        double breakPoint = factor * range;
        for (int i = 0; i < box.getDimensions(); ++i) {
            float minValue3 = (float)box.getMinValue(i);
            float maxValue = (float)box.getMaxValue(i);
            if (point[i] < minValue3) {
                minValue3 = point[i];
            } else if (point[i] > maxValue) {
                maxValue = point[i];
            }
            double gap = maxValue - minValue3;
            if (breakPoint <= gap && gap > 0.0) {
                float cutValue = (float)((double)minValue3 + breakPoint);
                if (cutValue >= maxValue) {
                    cutValue = Math.nextAfter(maxValue, (double)minValue3);
                }
                return new Cut(i, cutValue);
            }
            breakPoint -= gap;
        }
        Random rng = new Random((long)(factor * 9.223372036854776E18 / 2.0));
        if (rng.nextDouble() < 0.5) {
            for (int i = 0; i < box.getDimensions(); ++i) {
                minValue = (float)box.getMinValue(i);
                float maxValue = (float)box.getMaxValue(i);
                if (point[i] < minValue) {
                    minValue = point[i];
                } else if (point[i] > maxValue) {
                    maxValue = point[i];
                }
                if (!(maxValue > minValue)) continue;
                double cutValue = Math.nextAfter(maxValue, (double)minValue);
                return new Cut(i, cutValue);
            }
        } else {
            for (int i = box.getDimensions() - 1; i >= 0; --i) {
                minValue = (float)box.getMinValue(i);
                float maxValue = (float)box.getMaxValue(i);
                if (point[i] < minValue) {
                    minValue = point[i];
                } else if (point[i] > maxValue) {
                    maxValue = point[i];
                }
                if (!(maxValue > minValue)) continue;
                double cutValue = Math.nextAfter(maxValue, (double)minValue);
                return new Cut(i, cutValue);
            }
        }
        throw new IllegalStateException("The break point did not lie inside the expected range; factor " + factor + ", point " + Arrays.toString(point) + " box " + box.toString());
    }

    @Override
    public Integer addPoint(Integer pointIndex, long sequenceIndex) {
        Random rng;
        int node;
        int leafSavedSibling;
        if (this.root == AbstractNodeStore.Null) {
            this.root = this.convertToLeaf(pointIndex);
            this.addLeaf(pointIndex, sequenceIndex);
            return pointIndex;
        }
        float[] point = this.projectToTree(this.pointStoreView.getNumericVector(pointIndex));
        CommonUtils.checkArgument(point.length == this.dimension, () -> " mismatch in dimensions for " + pointIndex);
        Stack<int[]> pathToRoot = this.nodeStore.getPath(this.root, point, false);
        int[] first = pathToRoot.pop();
        int leafNode = first[0];
        int savedParent = pathToRoot.size() == 0 ? AbstractNodeStore.Null : ((int[])pathToRoot.lastElement())[0];
        int sibling = leafSavedSibling = first[1];
        int leafPointIndex = this.getPointIndex(leafNode);
        float[] oldPoint = this.projectToTree(this.pointStoreView.getNumericVector(leafPointIndex));
        CommonUtils.checkArgument(oldPoint.length == this.dimension, () -> " mismatch in dimensions for " + pointIndex);
        Stack<int[]> parentPath = new Stack<int[]>();
        if (Arrays.equals(point, oldPoint)) {
            this.increaseLeafMass(leafNode);
            this.manageAncestorsAdd(pathToRoot, point);
            this.addLeaf(leafPointIndex, sequenceIndex);
            return leafPointIndex;
        }
        int savedNode = node = leafNode;
        int parent = savedParent;
        float savedCutValue = 0.0f;
        BoundingBox currentBox = new BoundingBox(oldPoint, oldPoint);
        BoundingBox savedBox = currentBox.copy();
        int savedDim = Integer.MAX_VALUE;
        if (this.testRandom == null) {
            rng = new Random(this.randomSeed);
            this.randomSeed = rng.nextLong();
        } else {
            rng = this.testRandom;
        }
        while (true) {
            float value;
            double factor;
            Cut cut;
            int dim;
            boolean separation;
            boolean bl = separation = point[dim = (cut = this.randomCut(factor = rng.nextDouble(), point, currentBox)).getDimension()] <= (value = (float)cut.getValue()) && (double)value < currentBox.getMinValue(dim) || point[dim] > value && (double)value >= currentBox.getMaxValue(dim);
            if (separation) {
                savedCutValue = value;
                savedDim = dim;
                savedParent = parent;
                savedNode = node;
                savedBox = currentBox.copy();
                parentPath.clear();
            } else {
                parentPath.push(new int[]{node, sibling});
            }
            if (currentBox.contains(point) || parent == AbstractNodeStore.Null) break;
            this.growNodeBox(currentBox, this.pointStoreView, parent, sibling);
            int[] next = pathToRoot.pop();
            node = next[0];
            sibling = next[1];
            if (pathToRoot.size() != 0) {
                parent = ((int[])pathToRoot.lastElement())[0];
                continue;
            }
            parent = AbstractNodeStore.Null;
        }
        if (savedParent != AbstractNodeStore.Null) {
            while (!parentPath.isEmpty()) {
                pathToRoot.push((int[])parentPath.pop());
            }
        }
        int childMassIfLeaf = this.isLeaf(savedNode) ? this.getLeafMass(savedNode) : 0;
        int mergedNode = this.nodeStore.addNode(pathToRoot, point, sequenceIndex, pointIndex, savedNode, childMassIfLeaf, savedDim, savedCutValue, savedBox);
        this.addLeaf(pointIndex, sequenceIndex);
        this.addBox(mergedNode, point, savedBox);
        this.manageAncestorsAdd(pathToRoot, point);
        if (this.pointSum != null) {
            this.recomputePointSum(mergedNode);
        }
        if (savedParent == AbstractNodeStore.Null) {
            this.root = mergedNode;
        }
        return pointIndex;
    }

    protected void manageAncestorsAdd(Stack<int[]> path, float[] point) {
        while (!path.isEmpty()) {
            int index = path.pop()[0];
            this.nodeStore.increaseMassOfInternalNode(index);
            if (this.pointSum != null) {
                this.recomputePointSum(index);
            }
            if (!(this.boundingBoxCacheFraction > 0.0)) continue;
            this.checkContainsAndRebuildBox(index, point, this.pointStoreView);
            this.addPointInPlace(index, point);
        }
    }

    @Override
    public void addPointToPartialTree(Integer pointIndex, long sequenceIndex) {
        int savedParent;
        CommonUtils.checkArgument(this.root != AbstractNodeStore.Null, " a null root is not a partial tree");
        float[] point = this.projectToTree(this.pointStoreView.getNumericVector(pointIndex));
        CommonUtils.checkArgument(point.length == this.dimension, () -> " incorrect projection at index " + pointIndex);
        Stack<int[]> pathToRoot = this.nodeStore.getPath(this.root, point, false);
        int[] first = pathToRoot.pop();
        int leafNode = first[0];
        int n = savedParent = pathToRoot.size() == 0 ? AbstractNodeStore.Null : ((int[])pathToRoot.lastElement())[0];
        if (!this.isLeaf(leafNode)) {
            if (savedParent == AbstractNodeStore.Null) {
                this.root = this.convertToLeaf(pointIndex);
            } else {
                this.nodeStore.assignInPartialTree(savedParent, point, this.convertToLeaf(pointIndex));
                this.nodeStore.manageInternalNodesPartial(pathToRoot);
                this.addLeaf(pointIndex, sequenceIndex);
            }
            return;
        }
        int leafPointIndex = this.getPointIndex(leafNode);
        float[] oldPoint = this.projectToTree(this.pointStoreView.getNumericVector(leafPointIndex));
        CommonUtils.checkArgument(oldPoint.length == this.dimension && Arrays.equals(point, oldPoint), () -> "incorrect state on adding " + pointIndex);
        this.increaseLeafMass(leafNode);
        this.nodeStore.manageInternalNodesPartial(pathToRoot);
        this.addLeaf(leafPointIndex, sequenceIndex);
    }

    @Override
    public Integer deletePoint(Integer pointIndex, long sequenceIndex) {
        CommonUtils.checkArgument(this.root != AbstractNodeStore.Null, " deleting from an empty tree");
        float[] point = this.projectToTree(this.pointStoreView.getNumericVector(pointIndex));
        CommonUtils.checkArgument(point.length == this.dimension, () -> " incorrect projection at index " + pointIndex);
        Stack<int[]> pathToRoot = this.nodeStore.getPath(this.root, point, false);
        int[] first = pathToRoot.pop();
        int leafSavedSibling = first[1];
        int leafNode = first[0];
        int leafPointIndex = this.getPointIndex(leafNode);
        CommonUtils.checkArgument(leafPointIndex == pointIndex, () -> " deleting wrong node " + leafPointIndex + " instead of " + pointIndex);
        this.removeLeaf(leafPointIndex, sequenceIndex);
        if (this.decreaseLeafMass(leafNode) == 0) {
            if (pathToRoot.size() == 0) {
                this.root = AbstractNodeStore.Null;
            } else {
                int idx;
                int parent = pathToRoot.pop()[0];
                if (pathToRoot.size() == 0) {
                    this.root = leafSavedSibling;
                } else {
                    int grandParent = ((int[])pathToRoot.lastElement())[0];
                    this.nodeStore.replaceParentBySibling(grandParent, parent, leafNode);
                    this.manageAncestorsDelete(pathToRoot, point);
                }
                this.nodeStore.deleteInternalNode(parent);
                if (this.pointSum != null) {
                    this.invalidatePointSum(parent);
                }
                if ((idx = this.translate(parent)) != Integer.MAX_VALUE) {
                    this.rangeSumData[idx] = 0.0;
                }
            }
        } else {
            this.manageAncestorsDelete(pathToRoot, point);
        }
        return leafPointIndex;
    }

    protected void manageAncestorsDelete(Stack<int[]> path, float[] point) {
        boolean resolved = false;
        while (!path.isEmpty()) {
            int index = path.pop()[0];
            this.nodeStore.decreaseMassOfInternalNode(index);
            if (this.pointSum != null) {
                this.recomputePointSum(index);
            }
            if (!(this.boundingBoxCacheFraction > 0.0) || resolved) continue;
            resolved = this.checkContainsAndRebuildBox(index, point, this.pointStoreView);
        }
    }

    public boolean isLeaf(int index) {
        return index >= this.numberOfLeaves;
    }

    public boolean isInternal(int index) {
        return index < this.numberOfLeaves - 1 && index >= 0;
    }

    public int convertToLeaf(int pointIndex) {
        return pointIndex + this.numberOfLeaves;
    }

    public int getPointIndex(int index) {
        CommonUtils.checkArgument(index >= this.numberOfLeaves, () -> " does not have a point associated " + index);
        return index - this.numberOfLeaves;
    }

    public int getLeftChild(int index) {
        CommonUtils.checkArgument(this.isInternal(index), () -> "incorrect call to get left Index " + index);
        return this.nodeStore.getLeftIndex(index);
    }

    public int getRightChild(int index) {
        CommonUtils.checkArgument(this.isInternal(index), () -> "incorrect call to get right child " + index);
        return this.nodeStore.getRightIndex(index);
    }

    public int getCutDimension(int index) {
        CommonUtils.checkArgument(this.isInternal(index), () -> "incorrect call to get cut dimension " + index);
        return this.nodeStore.getCutDimension(index);
    }

    public double getCutValue(int index) {
        CommonUtils.checkArgument(this.isInternal(index), () -> "incorrect call to get cut value " + index);
        return this.nodeStore.getCutValue(index);
    }

    protected int getMass(int index) {
        return this.isLeaf(index) ? this.getLeafMass(index) : this.nodeStore.getMass(index);
    }

    protected int getLeafMass(int index) {
        int y = index - this.numberOfLeaves;
        Integer value = this.leafMass.get(y);
        return value != null ? value + 1 : 1;
    }

    protected void increaseLeafMass(int index) {
        int y = index - this.numberOfLeaves;
        this.leafMass.merge(y, 1, Integer::sum);
    }

    protected int decreaseLeafMass(int index) {
        int y = index - this.numberOfLeaves;
        Integer value = this.leafMass.remove(y);
        if (value != null) {
            if (value > 1) {
                this.leafMass.put(y, value - 1);
                return value;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getMass() {
        return this.root == AbstractNodeStore.Null ? 0 : (this.isLeaf(this.root) ? this.getLeafMass(this.root) : this.nodeStore.getMass(this.root));
    }

    public void resizeCache(double fraction) {
        if (fraction == 0.0) {
            this.rangeSumData = null;
            this.boundingBoxData = null;
        } else {
            int limit = (int)Math.floor(fraction * (double)(this.numberOfLeaves - 1));
            this.rangeSumData = this.rangeSumData == null ? new double[limit] : Arrays.copyOf(this.rangeSumData, limit);
            this.boundingBoxData = this.boundingBoxData == null ? new float[limit * 2 * this.dimension] : Arrays.copyOf(this.boundingBoxData, limit * 2 * this.dimension);
        }
        this.boundingBoxCacheFraction = fraction;
    }

    protected int translate(int index) {
        if (this.rangeSumData == null || this.rangeSumData.length <= index) {
            return Integer.MAX_VALUE;
        }
        return index;
    }

    void copyBoxToData(int idx, BoundingBox box) {
        int base = 2 * idx * this.dimension;
        int mid = base + this.dimension;
        System.arraycopy(box.getMinValues(), 0, this.boundingBoxData, base, this.dimension);
        System.arraycopy(box.getMaxValues(), 0, this.boundingBoxData, mid, this.dimension);
        this.rangeSumData[idx] = box.getRangeSum();
    }

    void addPointInPlace(int index, float[] point) {
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            int i;
            int base = 2 * idx * this.dimension;
            int mid = base + this.dimension;
            double rangeSum = 0.0;
            for (i = 0; i < this.dimension; ++i) {
                this.boundingBoxData[base + i] = Math.min(this.boundingBoxData[base + i], point[i]);
            }
            for (i = 0; i < this.dimension; ++i) {
                this.boundingBoxData[mid + i] = Math.max(this.boundingBoxData[mid + i], point[i]);
            }
            for (i = 0; i < this.dimension; ++i) {
                rangeSum += (double)(this.boundingBoxData[mid + i] - this.boundingBoxData[base + i]);
            }
            this.rangeSumData[idx] = rangeSum;
        }
    }

    public BoundingBox getBox(int index) {
        if (this.isLeaf(index)) {
            float[] point = this.projectToTree(this.pointStoreView.getNumericVector(this.getPointIndex(index)));
            CommonUtils.checkArgument(point.length == this.dimension, () -> "failure in projection at index " + index);
            return new BoundingBox(point, point);
        }
        CommonUtils.checkState(this.isInternal(index), " incomplete state");
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            if (this.rangeSumData[idx] != 0.0) {
                return this.getBoxFromData(idx);
            }
            BoundingBox box = this.reconstructBox(index, this.pointStoreView);
            this.copyBoxToData(idx, box);
            return box;
        }
        return this.reconstructBox(index, this.pointStoreView);
    }

    BoundingBox reconstructBox(int index, IPointStoreView<float[]> pointStoreView) {
        BoundingBox mutatedBoundingBox = this.getBox(this.nodeStore.getLeftIndex(index));
        this.growNodeBox(mutatedBoundingBox, pointStoreView, index, this.nodeStore.getRightIndex(index));
        return mutatedBoundingBox;
    }

    boolean checkStrictlyContains(int index, float[] point) {
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            int base = 2 * idx * this.dimension;
            int mid = base + this.dimension;
            boolean isInside = true;
            for (int i = 0; i < this.dimension && isInside; ++i) {
                if (!(point[i] >= this.boundingBoxData[mid + i]) && !(this.boundingBoxData[base + i] >= point[i])) continue;
                isInside = false;
            }
            return isInside;
        }
        return false;
    }

    boolean checkContainsAndRebuildBox(int index, float[] point, IPointStoreView<float[]> pointStoreView) {
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            if (!this.checkStrictlyContains(index, point)) {
                BoundingBox mutatedBoundingBox = this.reconstructBox(index, pointStoreView);
                this.copyBoxToData(idx, mutatedBoundingBox);
                return false;
            }
            return true;
        }
        return false;
    }

    BoundingBox getBoxFromData(int idx) {
        int base = 2 * idx * this.dimension;
        int mid = base + this.dimension;
        return new BoundingBox(Arrays.copyOfRange(this.boundingBoxData, base, base + this.dimension), Arrays.copyOfRange(this.boundingBoxData, mid, mid + this.dimension));
    }

    void addBox(int index, float[] point, BoundingBox box) {
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            this.copyBoxToData(idx, box);
            this.addPointInPlace(index, point);
        }
    }

    void growNodeBox(BoundingBox box, IPointStoreView<float[]> pointStoreView, int node, int sibling) {
        if (!this.isLeaf(sibling)) {
            if (!this.isInternal(sibling)) {
                throw new IllegalStateException(" incomplete state " + sibling);
            }
            int siblingIdx = this.translate(sibling);
            if (siblingIdx != Integer.MAX_VALUE) {
                if (this.rangeSumData[siblingIdx] != 0.0) {
                    box.addBox(this.getBoxFromData(siblingIdx));
                } else {
                    BoundingBox newBox = this.getBox(siblingIdx);
                    this.copyBoxToData(siblingIdx, newBox);
                    box.addBox(newBox);
                }
                return;
            }
            this.growNodeBox(box, pointStoreView, sibling, this.nodeStore.getLeftIndex(sibling));
            this.growNodeBox(box, pointStoreView, sibling, this.nodeStore.getRightIndex(sibling));
            return;
        }
        float[] point = this.projectToTree(pointStoreView.getNumericVector(this.getPointIndex(sibling)));
        CommonUtils.checkArgument(point.length == this.dimension, () -> " incorrect projection at index " + sibling);
        box.addPoint(point);
    }

    public double probabilityOfCut(int node, float[] point, BoundingBox otherBox) {
        int nodeIdx = this.translate(node);
        if (nodeIdx != Integer.MAX_VALUE && this.rangeSumData[nodeIdx] != 0.0) {
            int i;
            int base = 2 * nodeIdx * this.dimension;
            int mid = base + this.dimension;
            double minsum = 0.0;
            double maxsum = 0.0;
            for (i = 0; i < this.dimension; ++i) {
                minsum += (double)Math.max(this.boundingBoxData[base + i] - point[i], 0.0f);
            }
            for (i = 0; i < this.dimension; ++i) {
                maxsum += (double)Math.max(point[i] - this.boundingBoxData[mid + i], 0.0f);
            }
            double sum = maxsum + minsum;
            if (sum == 0.0) {
                return 0.0;
            }
            return sum / (this.rangeSumData[nodeIdx] + sum);
        }
        if (otherBox != null) {
            return otherBox.probabilityOfCut(point);
        }
        BoundingBox box = this.getBox(node);
        return box.probabilityOfCut(point);
    }

    public float[] getPointSum(int index) {
        CommonUtils.checkArgument(this.centerOfMassEnabled, " enable center of mass");
        if (this.isLeaf(index)) {
            float[] point = this.projectToTree(this.pointStoreView.getNumericVector(this.getPointIndex(index)));
            CommonUtils.checkArgument(point.length == this.dimension, () -> " incorrect projection");
            int mass = this.getMass(index);
            int i = 0;
            while (i < point.length) {
                int n = i++;
                point[n] = point[n] * (float)mass;
            }
            return point;
        }
        return Arrays.copyOfRange(this.pointSum, index * this.dimension, (index + 1) * this.dimension);
    }

    public void invalidatePointSum(int index) {
        for (int i = 0; i < this.dimension; ++i) {
            this.pointSum[index * this.dimension + i] = 0.0f;
        }
    }

    public void recomputePointSum(int index) {
        float[] left = this.getPointSum(this.nodeStore.getLeftIndex(index));
        float[] right = this.getPointSum(this.nodeStore.getRightIndex(index));
        for (int i = 0; i < this.dimension; ++i) {
            this.pointSum[index * this.dimension + i] = left[i] + right[i];
        }
    }

    public HashMap<Long, Integer> getSequenceMap(int index) {
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        List<Long> list = this.getSequenceList(index);
        for (Long e : list) {
            hashMap.merge(e, 1, Integer::sum);
        }
        return hashMap;
    }

    public List<Long> getSequenceList(int index) {
        return this.sequenceMap.get(index);
    }

    protected void addLeaf(int pointIndex, long sequenceIndex) {
        if (this.storeSequenceIndexesEnabled) {
            List<Long> leafList = this.sequenceMap.remove(pointIndex);
            if (leafList == null) {
                leafList = new ArrayList<Long>(1);
            }
            leafList.add(sequenceIndex);
            this.sequenceMap.put(pointIndex, leafList);
        }
    }

    public void removeLeaf(int leafPointIndex, long sequenceIndex) {
        if (this.storeSequenceIndexesEnabled) {
            List<Long> leafList = this.sequenceMap.remove(leafPointIndex);
            CommonUtils.checkArgument(leafList != null, " leaf index not found in tree");
            CommonUtils.checkArgument(leafList.remove(sequenceIndex), " sequence index not found in leaf");
            if (!leafList.isEmpty()) {
                this.sequenceMap.put(leafPointIndex, leafList);
            }
        }
    }

    @Override
    public void validateAndReconstruct() {
        if (this.root != AbstractNodeStore.Null) {
            this.validateAndReconstruct(this.root);
        }
    }

    public BoundingBox validateAndReconstruct(int index) {
        if (this.isLeaf(index)) {
            return this.getBox(index);
        }
        CommonUtils.checkState(this.isInternal(index), "illegal state");
        BoundingBox leftBox = this.validateAndReconstruct(this.getLeftChild(index));
        BoundingBox rightBox = this.validateAndReconstruct(this.getRightChild(index));
        if ((double)leftBox.maxValues[this.getCutDimension(index)] > this.getCutValue(index) || (double)rightBox.minValues[this.getCutDimension(index)] <= this.getCutValue(index)) {
            throw new IllegalStateException(" incorrect bounding state at index " + index + " cut value " + this.getCutValue(index) + "cut dimension " + this.getCutDimension(index) + " left Box " + leftBox.toString() + " right box " + rightBox.toString());
        }
        if (this.centerOfMassEnabled) {
            this.recomputePointSum(index);
        }
        rightBox.addBox(leftBox);
        int idx = this.translate(index);
        if (idx != Integer.MAX_VALUE) {
            this.copyBoxToData(idx, rightBox);
        }
        return rightBox;
    }

    @Override
    public <R> R traverse(float[] point, IVisitorFactory<R> visitorFactory) {
        CommonUtils.checkArgument(this.root != AbstractNodeStore.Null, "this tree doesn't contain any nodes");
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkNotNull(visitorFactory, "visitor must not be null");
        Visitor<R> visitor = visitorFactory.newVisitor(this, point);
        NodeView currentNodeView = new NodeView(this, this.pointStoreView, this.root);
        this.traversePathToLeafAndVisitNodes(point, visitor, currentNodeView, this.root, 0);
        return visitorFactory.liftResult(this, visitor.getResult());
    }

    protected <R> void traversePathToLeafAndVisitNodes(float[] point, Visitor<R> visitor, NodeView currentNodeView, int node, int depthOfNode) {
        if (this.isLeaf(node)) {
            currentNodeView.setCurrentNode(node, this.getPointIndex(node), true);
            visitor.acceptLeaf(currentNodeView, depthOfNode);
        } else {
            CommonUtils.checkState(this.isInternal(node), " incomplete state ");
            if (this.nodeStore.toLeft(point, node)) {
                this.traversePathToLeafAndVisitNodes(point, visitor, currentNodeView, this.nodeStore.getLeftIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.nodeStore.getRightIndex(node), !visitor.isConverged());
            } else {
                this.traversePathToLeafAndVisitNodes(point, visitor, currentNodeView, this.nodeStore.getRightIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.nodeStore.getLeftIndex(node), !visitor.isConverged());
            }
            visitor.accept(currentNodeView, depthOfNode);
        }
    }

    @Override
    public <R> R traverseMulti(float[] point, IMultiVisitorFactory<R> visitorFactory) {
        CommonUtils.checkArgument(this.root != AbstractNodeStore.Null, "this tree doesn't contain any nodes");
        CommonUtils.checkNotNull(point, "point must not be null");
        CommonUtils.checkNotNull(visitorFactory, "visitor must not be null");
        MultiVisitor<R> visitor = visitorFactory.newVisitor(this, point);
        NodeView currentNodeView = new NodeView(this, this.pointStoreView, this.root);
        this.traverseTreeMulti(point, visitor, currentNodeView, this.root, 0);
        return visitorFactory.liftResult(this, visitor.getResult());
    }

    protected <R> void traverseTreeMulti(float[] point, MultiVisitor<R> visitor, NodeView currentNodeView, int node, int depthOfNode) {
        if (this.isLeaf(node)) {
            currentNodeView.setCurrentNode(node, this.getPointIndex(node), false);
            visitor.acceptLeaf(currentNodeView, depthOfNode);
        } else {
            CommonUtils.checkState(this.isInternal(node), " incomplete state");
            currentNodeView.setCurrentNodeOnly(node);
            if (visitor.trigger(currentNodeView)) {
                this.traverseTreeMulti(point, visitor, currentNodeView, this.nodeStore.getLeftIndex(node), depthOfNode + 1);
                MultiVisitor<R> newVisitor = visitor.newCopy();
                currentNodeView.setCurrentNodeOnly(this.nodeStore.getRightIndex(node));
                this.traverseTreeMulti(point, newVisitor, currentNodeView, this.nodeStore.getRightIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.nodeStore.getLeftIndex(node), false);
                visitor.combine(newVisitor);
            } else if (this.nodeStore.toLeft(point, node)) {
                this.traverseTreeMulti(point, visitor, currentNodeView, this.nodeStore.getLeftIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.nodeStore.getRightIndex(node), false);
            } else {
                this.traverseTreeMulti(point, visitor, currentNodeView, this.nodeStore.getRightIndex(node), depthOfNode + 1);
                currentNodeView.updateToParent(node, this.nodeStore.getLeftIndex(node), false);
            }
            visitor.accept(currentNodeView, depthOfNode);
        }
    }

    public int getNumberOfLeaves() {
        return this.numberOfLeaves;
    }

    public boolean isCenterOfMassEnabled() {
        return this.centerOfMassEnabled;
    }

    public boolean isStoreSequenceIndexesEnabled() {
        return this.storeSequenceIndexesEnabled;
    }

    public double getBoundingBoxCacheFraction() {
        return this.boundingBoxCacheFraction;
    }

    public int getDimension() {
        return this.dimension;
    }

    public Integer getRoot() {
        return this.root;
    }

    public int getOutputAfter() {
        return this.outputAfter;
    }

    @Override
    public boolean isOutputReady() {
        return this.getMass() >= this.outputAfter;
    }

    @Override
    public float[] projectToTree(float[] point) {
        return Arrays.copyOf(point, point.length);
    }

    @Override
    public float[] liftFromTree(float[] result) {
        return Arrays.copyOf(result, result.length);
    }

    @Override
    public double[] liftFromTree(double[] result) {
        return Arrays.copyOf(result, result.length);
    }

    @Override
    public int[] projectMissingIndices(int[] list) {
        return Arrays.copyOf(list, list.length);
    }

    @Override
    public long getRandomSeed() {
        return this.randomSeed;
    }

    public AbstractNodeStore getNodeStore() {
        return this.nodeStore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        protected boolean storeSequenceIndexesEnabled = false;
        protected boolean centerOfMassEnabled = false;
        protected double boundingBoxCacheFraction = 1.0;
        protected long randomSeed = new Random().nextLong();
        protected Random random = null;
        protected int capacity = 256;
        protected Optional<Integer> outputAfter = Optional.empty();
        protected int dimension;
        protected IPointStoreView<float[]> pointStoreView;
        protected AbstractNodeStore nodeStore;
        protected int root = AbstractNodeStore.Null;
        protected boolean storeParent = AbstractNodeStore.DEFAULT_STORE_PARENT;

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T pointStoreView(IPointStoreView<float[]> pointStoreView) {
            this.pointStoreView = pointStoreView;
            return (T)this;
        }

        public T nodeStore(AbstractNodeStore nodeStore) {
            this.nodeStore = nodeStore;
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = randomSeed;
            return (T)this;
        }

        public T random(Random random) {
            this.random = random;
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T dimension(int dimension) {
            this.dimension = dimension;
            return (T)this;
        }

        public T setRoot(int root) {
            this.root = root;
            return (T)this;
        }

        public T storeParent(boolean storeParent) {
            this.storeParent = storeParent;
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public RandomCutTree build() {
            return new RandomCutTree(this);
        }
    }
}

