# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class Account(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'url': 'str',
        'name': 'str',
        'host': 'str',
        'following_count': 'int',
        'followers_count': 'int',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'avatar': 'Avatar',
        'user_id': 'str',
        'display_name': 'str',
        'description': 'str'
    }

    attribute_map = {
        'id': 'id',
        'url': 'url',
        'name': 'name',
        'host': 'host',
        'following_count': 'followingCount',
        'followers_count': 'followersCount',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'avatar': 'avatar',
        'user_id': 'userId',
        'display_name': 'displayName',
        'description': 'description'
    }

    def __init__(self, id=None, url=None, name=None, host=None, following_count=None, followers_count=None, created_at=None, updated_at=None, avatar=None, user_id=None, display_name=None, description=None, local_vars_configuration=None):  # noqa: E501
        """Account - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._url = None
        self._name = None
        self._host = None
        self._following_count = None
        self._followers_count = None
        self._created_at = None
        self._updated_at = None
        self._avatar = None
        self._user_id = None
        self._display_name = None
        self._description = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if url is not None:
            self.url = url
        if name is not None:
            self.name = name
        if host is not None:
            self.host = host
        if following_count is not None:
            self.following_count = following_count
        if followers_count is not None:
            self.followers_count = followers_count
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if avatar is not None:
            self.avatar = avatar
        if user_id is not None:
            self.user_id = user_id
        if display_name is not None:
            self.display_name = display_name
        if description is not None:
            self.description = description

    @property
    def id(self):
        """Gets the id of this Account.  # noqa: E501


        :return: The id of this Account.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Account.


        :param id: The id of this Account.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def url(self):
        """Gets the url of this Account.  # noqa: E501


        :return: The url of this Account.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this Account.


        :param url: The url of this Account.  # noqa: E501
        :type url: str
        """

        self._url = url

    @property
    def name(self):
        """Gets the name of this Account.  # noqa: E501


        :return: The name of this Account.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Account.


        :param name: The name of this Account.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def host(self):
        """Gets the host of this Account.  # noqa: E501


        :return: The host of this Account.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this Account.


        :param host: The host of this Account.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def following_count(self):
        """Gets the following_count of this Account.  # noqa: E501


        :return: The following_count of this Account.  # noqa: E501
        :rtype: int
        """
        return self._following_count

    @following_count.setter
    def following_count(self, following_count):
        """Sets the following_count of this Account.


        :param following_count: The following_count of this Account.  # noqa: E501
        :type following_count: int
        """

        self._following_count = following_count

    @property
    def followers_count(self):
        """Gets the followers_count of this Account.  # noqa: E501


        :return: The followers_count of this Account.  # noqa: E501
        :rtype: int
        """
        return self._followers_count

    @followers_count.setter
    def followers_count(self, followers_count):
        """Sets the followers_count of this Account.


        :param followers_count: The followers_count of this Account.  # noqa: E501
        :type followers_count: int
        """

        self._followers_count = followers_count

    @property
    def created_at(self):
        """Gets the created_at of this Account.  # noqa: E501


        :return: The created_at of this Account.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Account.


        :param created_at: The created_at of this Account.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Account.  # noqa: E501


        :return: The updated_at of this Account.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Account.


        :param updated_at: The updated_at of this Account.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def avatar(self):
        """Gets the avatar of this Account.  # noqa: E501


        :return: The avatar of this Account.  # noqa: E501
        :rtype: Avatar
        """
        return self._avatar

    @avatar.setter
    def avatar(self, avatar):
        """Sets the avatar of this Account.


        :param avatar: The avatar of this Account.  # noqa: E501
        :type avatar: Avatar
        """

        self._avatar = avatar

    @property
    def user_id(self):
        """Gets the user_id of this Account.  # noqa: E501


        :return: The user_id of this Account.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this Account.


        :param user_id: The user_id of this Account.  # noqa: E501
        :type user_id: str
        """

        self._user_id = user_id

    @property
    def display_name(self):
        """Gets the display_name of this Account.  # noqa: E501


        :return: The display_name of this Account.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this Account.


        :param display_name: The display_name of this Account.  # noqa: E501
        :type display_name: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """Gets the description of this Account.  # noqa: E501


        :return: The description of this Account.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Account.


        :param description: The description of this Account.  # noqa: E501
        :type description: str
        """

        self._description = description

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Account):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Account):
            return True

        return self.to_dict() != other.to_dict()
