/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.publish.ivy.internal.artifact.AbstractIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;

public class SingleOutputTaskIvyArtifact
extends AbstractIvyArtifact {
    private final TaskProvider<? extends Task> generator;
    private final IvyPublicationIdentity identity;
    private final String extension;
    private final String type;
    private final String classifier;
    private final TaskDependencyInternal buildDependencies;

    public SingleOutputTaskIvyArtifact(TaskProvider<? extends Task> generator, IvyPublicationIdentity identity, String extension, String type, String classifier) {
        this.generator = generator;
        this.identity = identity;
        this.extension = extension;
        this.type = type;
        this.classifier = classifier;
        this.buildDependencies = new GeneratorTaskDependency();
    }

    @Override
    protected String getDefaultName() {
        return this.identity.getModule();
    }

    @Override
    protected String getDefaultType() {
        return this.type;
    }

    @Override
    protected String getDefaultExtension() {
        return this.extension;
    }

    @Override
    protected String getDefaultClassifier() {
        return this.classifier;
    }

    @Override
    protected String getDefaultConf() {
        return null;
    }

    @Override
    protected TaskDependency getDefaultBuildDependencies() {
        return this.buildDependencies;
    }

    public File getFile() {
        return ((Task)this.generator.get()).getOutputs().getFiles().getSingleFile();
    }

    public boolean isEnabled() {
        TaskInternal task = (TaskInternal)this.generator.get();
        return task.getOnlyIf().isSatisfiedBy((Object)task);
    }

    public boolean shouldBePublished() {
        return this.isEnabled();
    }

    private class GeneratorTaskDependency
    extends AbstractTaskDependency {
        private GeneratorTaskDependency() {
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(SingleOutputTaskIvyArtifact.this.generator.get());
        }
    }
}

