/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;

@EnabledAction(checkOnNodeChange=true)
class RemoveNoteAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final MNoteController noteController;

    public RemoveNoteAction(MNoteController noteController) {
        super("RemoveNoteAction");
        this.noteController = noteController;
    }

    public void actionPerformed(ActionEvent e) {
        int showResult = OptionalDontShowMeAgainDialog.show((String)"really_remove_notes", (String)"remove_notes_without_question", (OptionalDontShowMeAgainDialog.MessageType)OptionalDontShowMeAgainDialog.MessageType.ONLY_OK_SELECTION_IS_STORED);
        if (showResult != 0) {
            return;
        }
        ModeController modeController = Controller.getCurrentModeController();
        for (NodeModel node : modeController.getMapController().getSelectedNodes()) {
            if (NoteModel.getNoteText((NodeModel)node) == null) continue;
            this.removeNote(node);
        }
    }

    private void removeNote(NodeModel node) {
        this.noteController.setNoteText(node, null);
    }

    public void setEnabled() {
        this.setEnabled(this.doesNoteExist());
    }

    private boolean doesNoteExist() {
        boolean foundNote = false;
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController == null) {
            foundNote = false;
        } else {
            for (NodeModel node : modeController.getMapController().getSelectedNodes()) {
                if (NoteModel.getNoteText((NodeModel)node) == null) continue;
                foundNote = true;
                break;
            }
        }
        return foundNote;
    }
}

