/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.location;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.location.LocationDecoder;
import net.infonode.docking.location.WindowLocation;
import net.infonode.util.IntList;

public abstract class AbstractWindowLocation
implements WindowLocation {
    private WindowLocation parentLocation;
    private WeakReference window;

    protected abstract boolean set(DockingWindow var1, DockingWindow var2);

    protected AbstractWindowLocation(DockingWindow window, WindowLocation parentLocation) {
        this.window = new WeakReference<DockingWindow>(window);
        this.parentLocation = parentLocation;
    }

    protected AbstractWindowLocation() {
    }

    @Override
    public boolean set(DockingWindow window) {
        DockingWindow w = this.getWindow();
        if (w != null) {
            this.set(w, window);
        } else if (this.parentLocation != null) {
            this.parentLocation.set(window);
        }
        return true;
    }

    private DockingWindow getWindow() {
        if (this.window == null) {
            return null;
        }
        DockingWindow w = (DockingWindow)this.window.get();
        return w != null && w.getRootWindow() != null && !w.isMinimized() ? w : null;
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        DockingWindow w;
        out.writeBoolean(this.parentLocation != null);
        if (this.parentLocation != null) {
            this.parentLocation.write(out);
        }
        out.writeBoolean((w = this.getWindow()) != null);
        if (w != null) {
            InternalDockingUtil.getWindowPath(w).write(out);
        }
    }

    protected void read(ObjectInputStream in, RootWindow rootWindow) throws IOException {
        this.parentLocation = in.readBoolean() ? LocationDecoder.decode(in, rootWindow) : null;
        this.window = in.readBoolean() ? new WeakReference<DockingWindow>(InternalDockingUtil.getWindow(rootWindow, IntList.decode(in))) : null;
    }
}

