/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.ui.INodeViewLifeCycleListener;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.features.filepreview.BitmapViewerFactory;
import org.freeplane.view.swing.features.filepreview.ExternalImagePopupMenu;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ImagePreview;
import org.freeplane.view.swing.features.filepreview.MExternalImageDropListener;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.filepreview.ViewerBorder;
import org.freeplane.view.swing.features.progress.mindmapmode.ProgressIcons;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

@NodeHookDescriptor(hookName="ExternalObject", onceForMap=false)
public class ViewerController
extends PersistentNodeHook
implements INodeViewLifeCycleListener,
IExtension {
    private static final MExternalImageDropListener DTL = new MExternalImageDropListener();
    private static final int BORDER_SIZE = 1;
    public static final Border VIEWER_BORDER_INSTANCE = new ViewerBorder(1, Color.BLACK);
    private static final int SENSITIVE_AREA_SIZE = (int)Math.max(10.0f, UITools.FONT_SCALE_FACTOR * 10.0f);
    private static ExternalImagePopupMenu imagePopupMenu;
    static final int VIEWER_POSITION = 5;
    private final MyMouseListener mouseListener = new MyMouseListener();
    private final Set<IViewerFactory> factories = new HashSet<IViewerFactory>();
    private final CombiFactory combiFactory;

    public ViewerController() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addINodeViewLifeCycleListener(this);
        modeController.addExtension(this.getClass(), this);
        this.factories.add(new BitmapViewerFactory());
        this.combiFactory = new CombiFactory();
    }

    @Override
    protected PersistentNodeHook.HookAction createHookAction() {
        return null;
    }

    public void setZoom(final ModeController modeController, final MapModel map, final ExternalResource model, final float size) {
        final float oldSize = model.getZoom();
        if (size == oldSize) {
            return;
        }
        IActor actor = new IActor(){

            @Override
            public void act() {
                model.setZoom(size);
                modeController.getMapController().mapSaved(map, false);
            }

            @Override
            public String getDescription() {
                return "setModelSize";
            }

            @Override
            public void undo() {
                model.setZoom(oldSize);
                modeController.getMapController().mapSaved(map, false);
            }
        };
        modeController.execute(actor, map);
    }

    @Override
    protected void add(NodeModel node, IExtension extension) {
        ExternalResource preview = (ExternalResource)extension;
        for (NodeModel nodeClone : node.allClones()) {
            for (INodeView iNodeView : nodeClone.getViewers()) {
                NodeView view = (NodeView)iNodeView;
                this.createViewer(preview, view);
            }
        }
        super.add(node, extension);
    }

    @Override
    protected IExtension createExtension(NodeModel node) {
        URI uri = this.createURI(node);
        if (uri == null) {
            return null;
        }
        File input = new File(uri.getPath());
        ExternalResource preview = new ExternalResource(uri);
        ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)input.getName());
        return preview;
    }

    protected URI createURI(NodeModel node) {
        FileFilter fileFilter;
        Controller controller = Controller.getCurrentController();
        ViewController viewController = controller.getViewController();
        MapModel map = node.getMap();
        File file = map.getFile();
        boolean useRelativeUri = ResourceController.getResourceController().getProperty("links").equals("relative");
        if (file == null && useRelativeUri) {
            JOptionPane.showMessageDialog(viewController.getCurrentRootComponent(), TextUtils.getText("not_saved_for_image_error"), "Freeplane", 2);
            return null;
        }
        UrlManager urlManager = controller.getModeController().getExtension(UrlManager.class);
        JFreeplaneCustomizableFileChooser chooser = urlManager.getFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        if (this.factories.size() > 1) {
            fileFilter = this.getCombiFileFilter();
            chooser.addChoosableFileFilter(fileFilter);
            for (IViewerFactory factory : this.factories) {
                chooser.addChoosableFileFilter(new FactoryFileFilter(factory));
            }
        } else {
            fileFilter = new FactoryFileFilter(this.factories.iterator().next());
        }
        chooser.setFileFilter(fileFilter);
        chooser.putClientProperty(FactoryFileFilter.class, fileFilter);
        chooser.setAccessory(new ImagePreview(chooser));
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getViewController().getCurrentRootComponent());
        if (returnVal != 0) {
            return null;
        }
        File input = chooser.getSelectedFile();
        if (input == null) {
            return null;
        }
        URI uri = this.uriOf(input);
        if (uri == null) {
            return null;
        }
        if (useRelativeUri && uri.getScheme().equals("file")) {
            uri = LinkController.toLinkTypeDependantURI(map.getFile(), input);
        }
        return uri;
    }

    private URI uriOf(File input) {
        String path = input.getPath();
        try {
            for (String protocol : new String[]{"http:" + File.separatorChar, "https:" + File.separatorChar}) {
                int uriStart = path.indexOf(protocol);
                if (uriStart == -1) continue;
                return new URI(protocol.substring(0, protocol.length() - 1) + "//" + path.substring(uriStart + protocol.length()).replace('\\', '/'));
            }
        }
        catch (URISyntaxException e) {
            LogUtils.warn(e);
        }
        return input.toURI();
    }

    private IViewerFactory getViewerFactory(URI uri) {
        for (IViewerFactory factory : this.factories) {
            if (!factory.accept(uri)) continue;
            return factory;
        }
        return null;
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        try {
            String attrUri = element.getAttribute("URI", null);
            if (attrUri != null) {
                URI uri = new URI(attrUri);
                ExternalResource previewUrl = new ExternalResource(uri);
                String attrSize = element.getAttribute("SIZE", null);
                if (attrSize != null) {
                    float size = Float.parseFloat(attrSize);
                    previewUrl.setZoom(size);
                }
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
                return previewUrl;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    void createViewer(ExternalResource resource, NodeView view) {
        MapView map = view.getMap();
        JComponent viewer = this.createViewer(map.getMap(), resource, map.getZoom());
        if (imagePopupMenu == null) {
            imagePopupMenu = new ExternalImagePopupMenu();
        }
        viewer.setBorder(VIEWER_BORDER_INSTANCE);
        Set<NodeView> viewers = resource.getViewers();
        viewers.add(view);
        viewer.setBounds(viewer.getX() - 5, viewer.getY() - 5, viewer.getWidth() + 15, viewer.getHeight() + 15);
        view.addContent(viewer, 5);
        if (map.getModeController().canEdit()) {
            DropTarget dropTarget = new DropTarget(viewer, DTL);
            dropTarget.setActive(true);
        }
        if (view.isShortened()) {
            viewer.setVisible(false);
        } else {
            viewer.revalidate();
            viewer.repaint();
        }
    }

    void deleteViewer(ExternalResource model, NodeView nodeView) {
        Set<NodeView> viewers = model.getViewers();
        if (!viewers.contains(nodeView)) {
            return;
        }
        nodeView.removeContent(5);
        viewers.remove(nodeView);
    }

    protected Class<ExternalResource> getExtensionClass() {
        return ExternalResource.class;
    }

    @Override
    public void onViewCreated(Container container) {
        NodeView nodeView = (NodeView)container;
        ExternalResource previewUri = nodeView.getNode().getExtension(ExternalResource.class);
        if (previewUri == null) {
            return;
        }
        this.createViewer(previewUri, nodeView);
    }

    @Override
    public void onViewRemoved(Container container) {
        NodeView nodeView = (NodeView)container;
        ExternalResource previewUri = nodeView.getNode().getExtension(ExternalResource.class);
        if (previewUri == null) {
            return;
        }
        this.deleteViewer(previewUri, nodeView);
    }

    @Override
    protected void remove(NodeModel node, IExtension extension) {
        ExternalResource resource = (ExternalResource)extension;
        resource.removeViewers();
        super.remove(node, extension);
    }

    @Override
    protected void saveExtension(IExtension extension, XMLElement element) {
        float size;
        ExternalResource previewUri = (ExternalResource)extension;
        URI uri = previewUri.getUri();
        if (uri != null) {
            element.setAttribute("URI", uri.toString());
        }
        if ((size = previewUri.getZoom()) != -1.0f) {
            element.setAttribute("SIZE", Float.toString(size));
        }
        super.saveExtension(extension, element);
    }

    private JComponent createViewer(MapModel map, ExternalResource model, float zoom) {
        URI uri = model.getUri();
        if (uri == null) {
            return new JLabel("no file set");
        }
        URI absoluteUri = model.getAbsoluteUri(map);
        if (absoluteUri == null) {
            return new JLabel(uri.toString());
        }
        IViewerFactory factory = this.getViewerFactory(absoluteUri);
        if (factory == null) {
            return new JLabel(uri.toString());
        }
        JComponent viewer = null;
        try {
            int maxWidth = ResourceController.getResourceController().getIntProperty("max_image_width");
            viewer = (JComponent)((Object)factory.createViewer(model, absoluteUri, maxWidth, zoom));
        }
        catch (Exception e) {
            String info = HtmlUtils.combineTextWithExceptionInfo(uri.toString(), e);
            JLabel errorLabel = new JLabel(info);
            errorLabel.addMouseListener(this.mouseListener);
            return errorLabel;
        }
        if (viewer == null) {
            return new JLabel(uri.toString());
        }
        viewer.putClientProperty(IViewerFactory.class, factory);
        viewer.putClientProperty(ExternalResource.class, model);
        viewer.addMouseListener(this.mouseListener);
        viewer.addMouseMotionListener(this.mouseListener);
        return viewer;
    }

    private FileFilter getCombiFileFilter() {
        return new FactoryFileFilter(this.combiFactory);
    }

    public void addFactory(IViewerFactory factory) {
        this.factories.add(factory);
    }

    public void removeFactory(IViewerFactory factory) {
        this.factories.remove(factory);
    }

    public boolean pasteImage(URI uri, NodeModel node) {
        return this.pasteImage(uri, node, PasteMode.INSIDE);
    }

    public boolean paste(URI uri, NodeModel node) {
        if (uri == null || this.getViewerFactory(uri) == null) {
            return false;
        }
        ExternalResource preview = new ExternalResource(uri);
        this.undoableDeactivateHook(node);
        this.undoableActivateHook(node, preview);
        ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)uri.getPath());
        return true;
    }

    public boolean paste(File file, NodeModel targetNode, PasteMode mode) {
        URI uri = this.uriOf(file);
        return this.pasteImage(uri, targetNode, mode);
    }

    public boolean pasteImage(URI uri, NodeModel targetNode, PasteMode mode) {
        NodeModel node;
        if (uri == null || this.getViewerFactory(uri) == null) {
            return false;
        }
        File file = new File(uri.getPath());
        boolean isFile = uri.getScheme().equals("file");
        if (isFile) {
            if (!file.exists()) {
                return false;
            }
            File mapFile = targetNode.getMap().getFile();
            if (mapFile == null && LinkController.getLinkType() == 1) {
                JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), TextUtils.getText("not_saved_for_image_error"), "Freeplane", 2);
                return false;
            }
            if (LinkController.getLinkType() != 0) {
                uri = LinkController.toLinkTypeDependantURI(mapFile, file);
            }
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        if (mode.equals((Object)PasteMode.INSIDE)) {
            node = targetNode;
        } else {
            node = mapController.newNode((Object)file.getName(), targetNode.getMap());
            boolean asSibling = mode.equals((Object)PasteMode.AS_SIBLING);
            node.setSide(MapController.suggestNewChildSide(targetNode, asSibling ? NodeModel.Side.AS_SIBLING : NodeModel.Side.DEFAULT));
            mapController.insertNode(node, targetNode, asSibling);
        }
        ExternalResource preview = new ExternalResource(uri);
        this.undoableDeactivateHook(node);
        this.undoableActivateHook(node, preview);
        ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)file.getName());
        return true;
    }

    public IViewerFactory getViewerFactory() {
        return this.combiFactory;
    }

    private class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        private boolean sizeChanged = false;
        private Point basePoint = null;
        private Dimension baseSize = null;

        private MyMouseListener() {
        }

        private boolean isActive() {
            return this.basePoint != null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.resetSize(e)) {
                return;
            }
            if (this.showNext(e)) {
                return;
            }
        }

        private boolean resetSize(MouseEvent e) {
            if (e.getClickCount() != 2) {
                return false;
            }
            JComponent viewer = (JComponent)e.getComponent();
            int x = e.getX();
            int width = viewer.getWidth();
            int y = e.getY();
            int height = viewer.getHeight();
            if (x < width - SENSITIVE_AREA_SIZE || y < height - SENSITIVE_AREA_SIZE) {
                return false;
            }
            IViewerFactory factory = (IViewerFactory)viewer.getClientProperty(IViewerFactory.class);
            if (factory == null) {
                return true;
            }
            MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, viewer);
            ViewerController.this.setZoom(mapView.getModeController(), mapView.getMap(), (ExternalResource)viewer.getClientProperty(ExternalResource.class), 1.0f);
            this.sizeChanged = false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean showNext(MouseEvent e) {
            int i;
            String sActUri;
            MapModel map;
            NodeModel node;
            ExternalResource activeView;
            block11: {
                JComponent component = (JComponent)e.getComponent();
                int cursorType = component.getCursor().getType();
                if (e.getClickCount() != 2 || e.getButton() != 1 || cursorType == 5) {
                    return false;
                }
                activeView = this.getModel(e);
                if (activeView == null) {
                    return false;
                }
                node = this.getNode(e);
                map = node.getMap();
                URI absoluteUri = activeView.getAbsoluteUri(map);
                if (absoluteUri == null) {
                    return false;
                }
                sActUri = absoluteUri.toString();
                if (!sActUri.matches(".*_[0-9]{2}\\.[a-zA-Z0-9]*")) {
                    return false;
                }
                i = Integer.parseInt(sActUri.substring(sActUri.lastIndexOf("_") + 1, sActUri.lastIndexOf("_") + 3));
                if (e.isControlDown()) {
                    if (i > 0) {
                        --i;
                        break block11;
                    } else {
                        if (activeView.getUri().toString().matches(".*[Pp]rogress_(tenth|quarter)_[0-9]{2}\\.[a-zA-Z0-9]*")) {
                            ProgressIcons.removeProgressIcons((NodeModel)node);
                        }
                        ViewerController.this.remove(node, activeView);
                        Controller.getCurrentModeController().getMapController().nodeChanged(node, NodeModel.UNKNOWN_PROPERTY, null, null);
                        return true;
                    }
                }
                ++i;
            }
            String sNextNum = i < 10 ? "0" + Integer.toString(i) : Integer.toString(i);
            URI nextUri = null;
            try {
                nextUri = new URI(sActUri.replaceFirst("_[0-9]{2}\\.", "_" + sNextNum + "."));
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            String sNextURI = nextUri.getPath();
            if (sNextURI.contains("_tenth_") && i > 10 || sNextURI.contains("_quarter_") && i > 4) {
                return false;
            }
            final ExternalResource nextView = new ExternalResource(nextUri);
            nextView.setZoom(activeView.getZoom());
            IActor actor = new IActor(){

                @Override
                public void undo() {
                    ViewerController.this.remove(node, nextView);
                    ViewerController.this.add(node, activeView);
                }

                @Override
                public String getDescription() {
                    return "updateExtendedProgressIcons";
                }

                @Override
                public void act() {
                    ViewerController.this.remove(node, activeView);
                    ViewerController.this.add(node, nextView);
                }
            };
            Controller.getCurrentModeController().execute(actor, map);
            ProgressIcons.updateExtendedProgressIcons((NodeModel)node, (String)sNextURI);
            return true;
        }

        private NodeModel getNode(MouseEvent e) {
            NodeModel node = null;
            for (int i = 0; i < e.getComponent().getParent().getComponentCount(); ++i) {
                if (!(e.getComponent().getParent().getComponent(i) instanceof MainView)) continue;
                MainView mv = (MainView)e.getComponent().getParent().getComponent(i);
                node = mv.getNodeView().getNode();
                break;
            }
            if (node == null) {
                node = Controller.getCurrentModeController().getMapController().getSelectedNode();
            }
            return node;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.isActive()) {
                return;
            }
            ExternalResource model = this.getModel(e);
            if (model == null) {
                return;
            }
            Controller.getCurrentController().getViewController().out(model.getUri().toString());
            this.setCursor(e);
        }

        private ExternalResource getModel(MouseEvent e) {
            JComponent component = (JComponent)e.getComponent();
            ExternalResource model = (ExternalResource)component.getClientProperty(ExternalResource.class);
            return model;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.isActive()) {
                return;
            }
            this.setCursor(e.getComponent(), 0);
        }

        private void setCursor(MouseEvent e) {
            Component component = e.getComponent();
            int x = e.getX();
            int width = component.getWidth();
            int y = e.getY();
            int height = component.getHeight();
            int cursorType = x >= 0 && x < width && y >= 0 && y < height && (width - SENSITIVE_AREA_SIZE <= x || height - SENSITIVE_AREA_SIZE <= y) ? 5 : 0;
            this.setCursor(component, cursorType);
        }

        private void setCursor(Component component, int cursorType) {
            Cursor cursor = component.getCursor();
            if (cursor.getType() != cursorType) {
                Cursor predefinedCursor = cursorType == 0 ? null : Cursor.getPredefinedCursor(cursorType);
                component.setCursor(predefinedCursor);
            }
            ViewerBorder.repaintBorder((JComponent)component);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JComponent component = (JComponent)e.getComponent();
            int cursorType = component.getCursor().getType();
            if (cursorType == 5) {
                IViewerFactory factory = (IViewerFactory)component.getClientProperty(IViewerFactory.class);
                if (factory == null) {
                    return;
                }
                Point point = e.getPoint();
                this.basePoint = new Point(component.getWidth() - point.x, component.getHeight() - point.y);
                this.baseSize = component.getSize();
                return;
            }
            imagePopupMenu.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.sizeChanged) {
                JComponent component = (JComponent)e.getComponent();
                int newWidth = component.getWidth();
                int newHeight = component.getHeight();
                float w = this.baseSize.width;
                float h = this.baseSize.height;
                float scalingFactor = Math.max((float)newWidth / w, (float)newHeight / h);
                if (newWidth != this.baseSize.width || newHeight != this.baseSize.height) {
                    if (scalingFactor > 0.0f && (double)Math.abs(scalingFactor - 1.0f) > 0.01) {
                        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, component);
                        ExternalResource zoomedResource = (ExternalResource)component.getClientProperty(ExternalResource.class);
                        float newZoom = zoomedResource.getZoom() * scalingFactor;
                        ViewerController.this.setZoom(mapView.getModeController(), mapView.getMap(), zoomedResource, newZoom);
                    } else {
                        component.revalidate();
                        component.repaint();
                    }
                }
                this.sizeChanged = false;
            } else {
                imagePopupMenu.maybeShowPopup(e);
            }
            this.basePoint = null;
            this.baseSize = null;
            this.setCursor(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.isActive()) {
                return;
            }
            JComponent component = (JComponent)e.getComponent();
            this.setSize(component, this.basePoint.x + e.getX(), this.basePoint.y + e.getY());
        }

        /*
         * Unable to fully structure code
         */
        private void setSize(JComponent component, int newWidth, int newHeight) {
            cursorType = component.getCursor().getType();
            this.sizeChanged = true;
            switch (cursorType) {
                case 5: {
                    newWidth = Math.max(newWidth, 2);
                    newHeight = Math.max(newHeight, 2);
                    minimumSize = new Dimension(10, 10);
                    baseWidth = this.baseSize.width;
                    baseHeight = this.baseSize.height;
                    scalingFactor = Math.max((float)newWidth / baseWidth, (float)newHeight / baseHeight);
                    newWidth = (int)(baseWidth * scalingFactor);
                    newHeight = (int)(baseHeight * scalingFactor);
                    mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, component);
                    if (!(scalingFactor < 1.0f)) ** GOTO lbl25
                    minimumWidth = mapView.getZoomed(minimumSize.width);
                    minimumHeight = mapView.getZoomed(minimumSize.height);
                    if (newWidth >= minimumWidth && newHeight >= minimumHeight) ** GOTO lbl23
                    if (baseWidth <= (float)minimumWidth || baseHeight <= (float)minimumHeight) {
                        size = this.baseSize;
                    } else {
                        this.setSize(component, minimumWidth, minimumHeight);
                        return;
lbl23:
                        // 1 sources

                        size = new Dimension(newWidth, newHeight);
                    }
                    ** GOTO lbl26
lbl25:
                    // 1 sources

                    size = new Dimension(newWidth, newHeight);
lbl26:
                    // 3 sources

                    ((ScalableComponent)component).setDraftViewerSize(size);
                    component.revalidate();
                    break;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isActive()) {
                return;
            }
            this.setCursor(e);
        }
    }

    private final class CombiFactory
    implements IViewerFactory {
        private IViewerFactory factory;

        private CombiFactory() {
        }

        @Override
        public ScalableComponent createViewer(URI uri, Dimension preferredSize) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(uri);
            ScalableComponent component = this.factory == null ? null : this.factory.createViewer(uri, preferredSize);
            return component;
        }

        @Override
        public ScalableComponent createViewer(URI uri, Dimension preferredSize, Runnable callback) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(uri);
            ScalableComponent component = this.factory == null ? null : this.factory.createViewer(uri, preferredSize, callback);
            return component;
        }

        @Override
        public ScalableComponent createViewer(ExternalResource resource, URI absoluteUri, int maximumWidth, float zoom) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(absoluteUri);
            ScalableComponent component = this.factory.createViewer(resource, absoluteUri, maximumWidth, zoom);
            return component;
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            for (IViewerFactory factory : ViewerController.this.factories) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(factory.getDescription());
            }
            return sb.toString();
        }

        @Override
        public boolean accept(URI uri) {
            return ViewerController.this.getViewerFactory(uri) != null;
        }

        @Override
        public ScalableComponent createViewer(URI uri, float zoom) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(uri);
            ScalableComponent component = this.factory == null ? null : this.factory.createViewer(uri, zoom);
            return component;
        }

        @Override
        public ScalableComponent createViewer(URI uri, float zoom, Runnable callback) throws MalformedURLException, IOException {
            this.factory = ViewerController.this.getViewerFactory(uri);
            ScalableComponent component = this.factory == null ? null : this.factory.createViewer(uri, zoom, callback);
            return component;
        }
    }

    static final class FactoryFileFilter
    extends FileFilter {
        private final IViewerFactory factory;

        protected IViewerFactory getFactory() {
            return this.factory;
        }

        private FactoryFileFilter(IViewerFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || this.factory.accept(f.toURI());
        }

        @Override
        public String getDescription() {
            return this.factory.getDescription();
        }
    }

    public static enum PasteMode {
        AS_SIBLING,
        AS_CHILD,
        INSIDE;


        public static PasteMode valueOf(boolean asSibling) {
            return asSibling ? AS_SIBLING : AS_CHILD;
        }

        public static PasteMode valueOf(NodeModel.Side side) {
            return side == NodeModel.Side.AS_SIBLING ? AS_SIBLING : AS_CHILD;
        }
    }
}

