/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.bugreport;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.bugreport.BugReportDialogManager;
import org.freeplane.plugin.bugreport.IBugReportListener;
import org.freeplane.plugin.bugreport.ReportRegistry;

class ManualBugReporter
implements IBugReportListener {
    private static final String OPTION = "org.freeplane.plugin.manualbugreport";

    @Override
    public void onReportSent(Map<String, String> report, String status) {
        if (!status.equals("wanted")) {
            return;
        }
        final String log = report.get("log");
        final String hash = report.get("hash");
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                ManualBugReporter.this.openBugTracker(log, hash);
            }
        });
    }

    private void openBugTracker(String log, String hash) {
        String option = this.showBugReportDialog(log, hash);
        if (!"org.freeplane.plugin.bugreport.allowed".equals(option)) {
            return;
        }
        try {
            ResourceController resourceController = ResourceController.getResourceController();
            String location = resourceController.getProperty("bugTrackerLocation");
            Controller controller = Controller.getCurrentController();
            controller.getViewController().openDocument(new URL(location));
        }
        catch (MalformedURLException ex) {
            UITools.errorMessage((Object)(TextUtils.getText((String)"url_error") + "\n" + ex));
            LogUtils.warn((Throwable)ex);
        }
        catch (Exception ex) {
            UITools.errorMessage((Object)ex);
            LogUtils.warn((Throwable)ex);
        }
    }

    private String showBugReportDialog(String log, String hash) {
        String title = TextUtils.getText((String)"org.freeplane.plugin.bugreport.freeplane_team").replaceAll("\\n", "\n");
        String option = ResourceController.getResourceController().getProperty(OPTION, "org.freeplane.plugin.bugreport.ask");
        if (option.equals("org.freeplane.plugin.bugreport.ask")) {
            String question = TextUtils.getText((String)"org.freeplane.plugin.bugreport.wanted_bug");
            if (!HtmlUtils.isHtml((String)question)) {
                question = HtmlUtils.plainToHTML((String)question);
            }
            Object[] options = new Object[]{TextUtils.getText((String)"ok"), TextUtils.getText((String)"cancel"), TextUtils.getText((String)"org.freeplane.plugin.bugreport.never")};
            String reportName = TextUtils.getText((String)"org.freeplane.plugin.bugreport.lastreport");
            int choice = BugReportDialogManager.showBugReportDialog(title, question, 3, options, options[0], reportName, log);
            ReportRegistry register = ReportRegistry.getInstance();
            if (choice != 2) {
                register.unregisterReport(hash);
            }
            switch (choice) {
                case 0: {
                    option = "org.freeplane.plugin.bugreport.allowed";
                    break;
                }
                case 1: {
                    option = "org.freeplane.plugin.bugreport.denied";
                    break;
                }
                case 2: {
                    option = "org.freeplane.plugin.bugreport.denied";
                    ResourceController.getResourceController().setProperty(OPTION, option);
                    break;
                }
                default: {
                    option = "org.freeplane.plugin.bugreport.denied";
                }
            }
        }
        return option;
    }
}

