/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.Writer;
import java.util.Properties;
import java.util.function.Consumer;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.s9api.Message;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.UnicodeWriterResult;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.str.UnicodeWriterToWriter;
import net.sf.saxon.trans.XPathException;

public class StandardMessageHandler
implements Consumer<Message> {
    private final Configuration config;
    private UnicodeWriter writer;
    private final SerializationProperties serializationProperties;

    public StandardMessageHandler(Configuration config) {
        this.config = config;
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "yes");
        props.setProperty("omit-xml-declaration", "yes");
        this.serializationProperties = new SerializationProperties(props);
    }

    public void setUnicodeWriter(UnicodeWriter writer) {
        this.writer = writer;
    }

    public UnicodeWriter getUnicodeWriter() {
        return this.writer;
    }

    @Override
    public synchronized void accept(Message message) {
        try {
            XdmNode node = message.getContent();
            assert (node.getNodeKind() == XdmNodeKind.DOCUMENT);
            if (this.writer == null) {
                Writer w = this.config.getLogger().asWriter();
                this.writer = new UnicodeWriterToWriter(w);
            }
            UnicodeWriterResult result = new UnicodeWriterResult(this.writer, null);
            Receiver out = this.config.getSerializerFactory().getReceiver(result, this.serializationProperties);
            out.open();
            out.append(node.getUnderlyingNode());
            out.close();
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }
}

