/******************************************************************************
 *
 * Copyright(c) 2016 - 2018 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef __INC_HALMAC_BIT_8814B_H
#define __INC_HALMAC_BIT_8814B_H

#define CPU_OPT_WIDTH 0x1F

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_SYS_ISO_CTRL_8814B */
#define BIT_PWC_EV12V_8814B BIT(15)

/* 2 REG_NOT_VALID_8814B */
#define BIT_PA33V_EN_8814B BIT(13)
#define BIT_PA12V_EN_8814B BIT(12)
#define BIT_UA33V_EN_8814B BIT(11)
#define BIT_UA12V_EN_8814B BIT(10)
#define BIT_ISO_RFDIO_8814B BIT(9)
#define BIT_ISO_EB2CORE_8814B BIT(8)
#define BIT_ISO_DIOE_8814B BIT(7)
#define BIT_ISO_WLPON2PP_8814B BIT(6)
#define BIT_ISO_IP2MAC_WA2PP_8814B BIT(5)
#define BIT_ISO_PD2CORE_8814B BIT(4)
#define BIT_ISO_PA2PCIE_8814B BIT(3)
#define BIT_ISO_UD2CORE_8814B BIT(2)
#define BIT_ISO_UA2USB_8814B BIT(1)
#define BIT_ISO_WD2PP_8814B BIT(0)

/* 2 REG_SYS_FUNC_EN_8814B */
#define BIT_FEN_MREGEN_8814B BIT(15)
#define BIT_FEN_HWPDN_8814B BIT(14)

/* 2 REG_NOT_VALID_8814B */
#define BIT_FEN_ELDR_8814B BIT(12)
#define BIT_FEN_DCORE_8814B BIT(11)
#define BIT_FEN_CPUEN_8814B BIT(10)
#define BIT_FEN_DIOE_8814B BIT(9)
#define BIT_FEN_PCIED_8814B BIT(8)
#define BIT_FEN_PPLL_8814B BIT(7)
#define BIT_FEN_PCIEA_8814B BIT(6)
#define BIT_FEN_DIO_PCIE_8814B BIT(5)
#define BIT_FEN_USBD_8814B BIT(4)
#define BIT_FEN_UPLL_8814B BIT(3)
#define BIT_FEN_USBA_8814B BIT(2)
#define BIT_FEN_BB_GLB_RSTN_8814B BIT(1)
#define BIT_FEN_BBRSTB_8814B BIT(0)

/* 2 REG_SYS_PW_CTRL_8814B */
#define BIT_SOP_EABM_8814B BIT(31)
#define BIT_SOP_ACKF_8814B BIT(30)
#define BIT_SOP_ERCK_8814B BIT(29)
#define BIT_SOP_ESWR_8814B BIT(28)
#define BIT_SOP_PWMM_8814B BIT(27)
#define BIT_SOP_EECK_8814B BIT(26)
#define BIT_SOP_EXTL_8814B BIT(24)
#define BIT_SYM_OP_RING_12M_8814B BIT(22)
#define BIT_ROP_SWPR_8814B BIT(21)
#define BIT_DIS_HW_LPLDM_8814B BIT(20)
#define BIT_OPT_SWRST_WLMCU_8814B BIT(19)
#define BIT_RDY_SYSPWR_8814B BIT(17)
#define BIT_EN_WLON_8814B BIT(16)
#define BIT_APDM_HPDN_8814B BIT(15)
#define BIT_AFSM_PCIE_SUS_EN_8814B BIT(12)
#define BIT_AFSM_WLSUS_EN_8814B BIT(11)
#define BIT_APFM_SWLPS_8814B BIT(10)
#define BIT_APFM_OFFMAC_8814B BIT(9)
#define BIT_APFN_ONMAC_8814B BIT(8)
#define BIT_CHIP_PDN_EN_8814B BIT(7)
#define BIT_RDY_MACDIS_8814B BIT(6)

/* 2 REG_NOT_VALID_8814B */
#define BIT_PFM_WOWL_8814B BIT(3)
#define BIT_PFM_LDKP_8814B BIT(2)
#define BIT_WL_HCI_ALD_8814B BIT(1)
#define BIT_PFM_LDALL_8814B BIT(0)

/* 2 REG_SYS_CLK_CTRL_8814B */
#define BIT_DATA_CPU_CLK_EN_8814B BIT(15)
#define BIT_CPU_CLK_EN_8814B BIT(14)
#define BIT_SYMREG_CLK_EN_8814B BIT(13)
#define BIT_HCI_CLK_EN_8814B BIT(12)
#define BIT_MAC_CLK_EN_8814B BIT(11)
#define BIT_SEC_CLK_EN_8814B BIT(10)
#define BIT_PHY_SSC_RSTB_8814B BIT(9)
#define BIT_EXT_32K_EN_8814B BIT(8)
#define BIT_WL_CLK_TEST_8814B BIT(7)
#define BIT_OP_SPS_PWM_EN_8814B BIT(6)
#define BIT_LOADER_CLK_EN_8814B BIT(5)
#define BIT_MACSLP_8814B BIT(4)
#define BIT_WAKEPAD_EN_8814B BIT(3)
#define BIT_ROMD16V_EN_8814B BIT(2)

/* 2 REG_NOT_VALID_8814B */
#define BIT_CNTD16V_EN_8814B BIT(0)

/* 2 REG_SYS_EEPROM_CTRL_8814B */

#define BIT_SHIFT_VPDIDX_8814B 8
#define BIT_MASK_VPDIDX_8814B 0xff
#define BIT_VPDIDX_8814B(x)                                                    \
	(((x) & BIT_MASK_VPDIDX_8814B) << BIT_SHIFT_VPDIDX_8814B)
#define BITS_VPDIDX_8814B (BIT_MASK_VPDIDX_8814B << BIT_SHIFT_VPDIDX_8814B)
#define BIT_CLEAR_VPDIDX_8814B(x) ((x) & (~BITS_VPDIDX_8814B))
#define BIT_GET_VPDIDX_8814B(x)                                                \
	(((x) >> BIT_SHIFT_VPDIDX_8814B) & BIT_MASK_VPDIDX_8814B)
#define BIT_SET_VPDIDX_8814B(x, v)                                             \
	(BIT_CLEAR_VPDIDX_8814B(x) | BIT_VPDIDX_8814B(v))

#define BIT_SHIFT_EEM1_0_8814B 6
#define BIT_MASK_EEM1_0_8814B 0x3
#define BIT_EEM1_0_8814B(x)                                                    \
	(((x) & BIT_MASK_EEM1_0_8814B) << BIT_SHIFT_EEM1_0_8814B)
#define BITS_EEM1_0_8814B (BIT_MASK_EEM1_0_8814B << BIT_SHIFT_EEM1_0_8814B)
#define BIT_CLEAR_EEM1_0_8814B(x) ((x) & (~BITS_EEM1_0_8814B))
#define BIT_GET_EEM1_0_8814B(x)                                                \
	(((x) >> BIT_SHIFT_EEM1_0_8814B) & BIT_MASK_EEM1_0_8814B)
#define BIT_SET_EEM1_0_8814B(x, v)                                             \
	(BIT_CLEAR_EEM1_0_8814B(x) | BIT_EEM1_0_8814B(v))

#define BIT_AUTOLOAD_SUS_8814B BIT(5)
#define BIT_EERPOMSEL_8814B BIT(4)
#define BIT_EECS_V1_8814B BIT(3)
#define BIT_EESK_V1_8814B BIT(2)
#define BIT_EEDI_V1_8814B BIT(1)
#define BIT_EEDO_V1_8814B BIT(0)

/* 2 REG_EE_VPD_8814B */

#define BIT_SHIFT_VPD_DATA_8814B 0
#define BIT_MASK_VPD_DATA_8814B 0xffffffffL
#define BIT_VPD_DATA_8814B(x)                                                  \
	(((x) & BIT_MASK_VPD_DATA_8814B) << BIT_SHIFT_VPD_DATA_8814B)
#define BITS_VPD_DATA_8814B                                                    \
	(BIT_MASK_VPD_DATA_8814B << BIT_SHIFT_VPD_DATA_8814B)
#define BIT_CLEAR_VPD_DATA_8814B(x) ((x) & (~BITS_VPD_DATA_8814B))
#define BIT_GET_VPD_DATA_8814B(x)                                              \
	(((x) >> BIT_SHIFT_VPD_DATA_8814B) & BIT_MASK_VPD_DATA_8814B)
#define BIT_SET_VPD_DATA_8814B(x, v)                                           \
	(BIT_CLEAR_VPD_DATA_8814B(x) | BIT_VPD_DATA_8814B(v))

/* 2 REG_SYS_SWR_CTRL1_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_CTRL_SPS_PWM_FREQ_8814B BIT(10)

/* 2 REG_NOT_VALID_8814B */
#define BIT_DISABLE_OPEN_SPS_LDO_8814B BIT(8)
#define BIT_MAC_ID_EN_8814B BIT(7)
#define BIT_WL_CTRL_XTAL_CADJ_8814B BIT(6)
#define BIT_AFE_BGEN_PCIE_OP_8814B BIT(2)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_SYS_SWR_CTRL2_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_SYS_SWR_CTRL3_8814B */
#define BIT_SPS18_OCP_DIS_8814B BIT(31)

#define BIT_SHIFT_SPS18_OCP_TH_8814B 16
#define BIT_MASK_SPS18_OCP_TH_8814B 0x7fff
#define BIT_SPS18_OCP_TH_8814B(x)                                              \
	(((x) & BIT_MASK_SPS18_OCP_TH_8814B) << BIT_SHIFT_SPS18_OCP_TH_8814B)
#define BITS_SPS18_OCP_TH_8814B                                                \
	(BIT_MASK_SPS18_OCP_TH_8814B << BIT_SHIFT_SPS18_OCP_TH_8814B)
#define BIT_CLEAR_SPS18_OCP_TH_8814B(x) ((x) & (~BITS_SPS18_OCP_TH_8814B))
#define BIT_GET_SPS18_OCP_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_SPS18_OCP_TH_8814B) & BIT_MASK_SPS18_OCP_TH_8814B)
#define BIT_SET_SPS18_OCP_TH_8814B(x, v)                                       \
	(BIT_CLEAR_SPS18_OCP_TH_8814B(x) | BIT_SPS18_OCP_TH_8814B(v))

#define BIT_SHIFT_OCP_WINDOW_8814B 0
#define BIT_MASK_OCP_WINDOW_8814B 0xffff
#define BIT_OCP_WINDOW_8814B(x)                                                \
	(((x) & BIT_MASK_OCP_WINDOW_8814B) << BIT_SHIFT_OCP_WINDOW_8814B)
#define BITS_OCP_WINDOW_8814B                                                  \
	(BIT_MASK_OCP_WINDOW_8814B << BIT_SHIFT_OCP_WINDOW_8814B)
#define BIT_CLEAR_OCP_WINDOW_8814B(x) ((x) & (~BITS_OCP_WINDOW_8814B))
#define BIT_GET_OCP_WINDOW_8814B(x)                                            \
	(((x) >> BIT_SHIFT_OCP_WINDOW_8814B) & BIT_MASK_OCP_WINDOW_8814B)
#define BIT_SET_OCP_WINDOW_8814B(x, v)                                         \
	(BIT_CLEAR_OCP_WINDOW_8814B(x) | BIT_OCP_WINDOW_8814B(v))

/* 2 REG_RSV_CTRL_8814B */

#define BIT_SHIFT_HREG_DBG_V1_8814B 12
#define BIT_MASK_HREG_DBG_V1_8814B 0xfff
#define BIT_HREG_DBG_V1_8814B(x)                                               \
	(((x) & BIT_MASK_HREG_DBG_V1_8814B) << BIT_SHIFT_HREG_DBG_V1_8814B)
#define BITS_HREG_DBG_V1_8814B                                                 \
	(BIT_MASK_HREG_DBG_V1_8814B << BIT_SHIFT_HREG_DBG_V1_8814B)
#define BIT_CLEAR_HREG_DBG_V1_8814B(x) ((x) & (~BITS_HREG_DBG_V1_8814B))
#define BIT_GET_HREG_DBG_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HREG_DBG_V1_8814B) & BIT_MASK_HREG_DBG_V1_8814B)
#define BIT_SET_HREG_DBG_V1_8814B(x, v)                                        \
	(BIT_CLEAR_HREG_DBG_V1_8814B(x) | BIT_HREG_DBG_V1_8814B(v))

#define BIT_WLMCUIOIF_8814B BIT(8)
#define BIT_LOCK_ALL_EN_8814B BIT(7)
#define BIT_R_DIS_PRST_8814B BIT(6)
#define BIT_WLOCK_1C_B6_8814B BIT(5)
#define BIT_WLOCK_40_8814B BIT(4)
#define BIT_WLOCK_08_8814B BIT(3)
#define BIT_WLOCK_04_8814B BIT(2)
#define BIT_WLOCK_00_8814B BIT(1)
#define BIT_WLOCK_ALL_8814B BIT(0)

/* 2 REG_RF_CTRL_8814B */
#define BIT_RF_SDMRSTB_8814B BIT(2)
#define BIT_RF_RSTB_8814B BIT(1)
#define BIT_RF_EN_8814B BIT(0)

/* 2 REG_AFE_LDO_CTRL_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_CPHY_LDO_CL_EN_8814B BIT(19)
#define BIT_CPHY_LDO_OK_8814B BIT(18)
#define BIT_PCIE_CALIB_EN_8814B BIT(17)
#define BIT_LDH12_EN_8814B BIT(16)
#define BIT_DATA_CPU_PWC_8814B BIT(15)
#define BIT_WLBBOFF_BIG_PWC_EN_8814B BIT(14)
#define BIT_WLBBOFF_SMALL_PWC_EN_8814B BIT(13)
#define BIT_WLMACOFF_BIG_PWC_EN_8814B BIT(12)
#define BIT_WLPON_PWC_EN_8814B BIT(11)

/* 2 REG_NOT_VALID_8814B */
#define BIT_LDOV12W_EN_8814B BIT(8)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_AFE_CTRL1_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_MAC_CLK_SEL_8814B 20
#define BIT_MASK_MAC_CLK_SEL_8814B 0x3
#define BIT_MAC_CLK_SEL_8814B(x)                                               \
	(((x) & BIT_MASK_MAC_CLK_SEL_8814B) << BIT_SHIFT_MAC_CLK_SEL_8814B)
#define BITS_MAC_CLK_SEL_8814B                                                 \
	(BIT_MASK_MAC_CLK_SEL_8814B << BIT_SHIFT_MAC_CLK_SEL_8814B)
#define BIT_CLEAR_MAC_CLK_SEL_8814B(x) ((x) & (~BITS_MAC_CLK_SEL_8814B))
#define BIT_GET_MAC_CLK_SEL_8814B(x)                                           \
	(((x) >> BIT_SHIFT_MAC_CLK_SEL_8814B) & BIT_MASK_MAC_CLK_SEL_8814B)
#define BIT_SET_MAC_CLK_SEL_8814B(x, v)                                        \
	(BIT_CLEAR_MAC_CLK_SEL_8814B(x) | BIT_MAC_CLK_SEL_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ANAPARSW_POW_MAC_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_ENB_LDO_DIODE_L_8814B BIT(3)
#define BIT_POW_LDO15_8814B BIT(2)
#define BIT_POW_SW_8814B BIT(1)
#define BIT_POW_LDO14_8814B BIT(0)

/* 2 REG_ANAPARLDO_POW_MAC_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_LDOE25_POW_L_8814B BIT(0)

/* 2 REG_ANAPAR_POW_MAC_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_POW_PC_LDO3_8814B BIT(5)
#define BIT_POW_PC_LDO2_8814B BIT(4)
#define BIT_POW_PC_LDO1_8814B BIT(3)
#define BIT_POW_PC_LDO0_8814B BIT(2)
#define BIT_POW_PLL_V1_8814B BIT(1)
#define BIT_POW_POWER_CUT_8814B BIT(0)

/* 2 REG_ANAPAR_POW_XTAL_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_POW_XTAL_8814B BIT(1)
#define BIT_POW_BG_8814B BIT(0)

/* 2 REG_ANAPARLDO_MAC_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_EFUSE_CTRL_8814B */
#define BIT_EF_FLAG_8814B BIT(31)

#define BIT_SHIFT_EF_PGPD_8814B 28
#define BIT_MASK_EF_PGPD_8814B 0x7
#define BIT_EF_PGPD_8814B(x)                                                   \
	(((x) & BIT_MASK_EF_PGPD_8814B) << BIT_SHIFT_EF_PGPD_8814B)
#define BITS_EF_PGPD_8814B (BIT_MASK_EF_PGPD_8814B << BIT_SHIFT_EF_PGPD_8814B)
#define BIT_CLEAR_EF_PGPD_8814B(x) ((x) & (~BITS_EF_PGPD_8814B))
#define BIT_GET_EF_PGPD_8814B(x)                                               \
	(((x) >> BIT_SHIFT_EF_PGPD_8814B) & BIT_MASK_EF_PGPD_8814B)
#define BIT_SET_EF_PGPD_8814B(x, v)                                            \
	(BIT_CLEAR_EF_PGPD_8814B(x) | BIT_EF_PGPD_8814B(v))

#define BIT_SHIFT_EF_RDT_8814B 24
#define BIT_MASK_EF_RDT_8814B 0xf
#define BIT_EF_RDT_8814B(x)                                                    \
	(((x) & BIT_MASK_EF_RDT_8814B) << BIT_SHIFT_EF_RDT_8814B)
#define BITS_EF_RDT_8814B (BIT_MASK_EF_RDT_8814B << BIT_SHIFT_EF_RDT_8814B)
#define BIT_CLEAR_EF_RDT_8814B(x) ((x) & (~BITS_EF_RDT_8814B))
#define BIT_GET_EF_RDT_8814B(x)                                                \
	(((x) >> BIT_SHIFT_EF_RDT_8814B) & BIT_MASK_EF_RDT_8814B)
#define BIT_SET_EF_RDT_8814B(x, v)                                             \
	(BIT_CLEAR_EF_RDT_8814B(x) | BIT_EF_RDT_8814B(v))

#define BIT_SHIFT_EF_PGTS_8814B 20
#define BIT_MASK_EF_PGTS_8814B 0xf
#define BIT_EF_PGTS_8814B(x)                                                   \
	(((x) & BIT_MASK_EF_PGTS_8814B) << BIT_SHIFT_EF_PGTS_8814B)
#define BITS_EF_PGTS_8814B (BIT_MASK_EF_PGTS_8814B << BIT_SHIFT_EF_PGTS_8814B)
#define BIT_CLEAR_EF_PGTS_8814B(x) ((x) & (~BITS_EF_PGTS_8814B))
#define BIT_GET_EF_PGTS_8814B(x)                                               \
	(((x) >> BIT_SHIFT_EF_PGTS_8814B) & BIT_MASK_EF_PGTS_8814B)
#define BIT_SET_EF_PGTS_8814B(x, v)                                            \
	(BIT_CLEAR_EF_PGTS_8814B(x) | BIT_EF_PGTS_8814B(v))

#define BIT_EF_PDWN_8814B BIT(19)
#define BIT_EF_ALDEN_8814B BIT(18)

#define BIT_SHIFT_EF_ADDR_8814B 8
#define BIT_MASK_EF_ADDR_8814B 0x3ff
#define BIT_EF_ADDR_8814B(x)                                                   \
	(((x) & BIT_MASK_EF_ADDR_8814B) << BIT_SHIFT_EF_ADDR_8814B)
#define BITS_EF_ADDR_8814B (BIT_MASK_EF_ADDR_8814B << BIT_SHIFT_EF_ADDR_8814B)
#define BIT_CLEAR_EF_ADDR_8814B(x) ((x) & (~BITS_EF_ADDR_8814B))
#define BIT_GET_EF_ADDR_8814B(x)                                               \
	(((x) >> BIT_SHIFT_EF_ADDR_8814B) & BIT_MASK_EF_ADDR_8814B)
#define BIT_SET_EF_ADDR_8814B(x, v)                                            \
	(BIT_CLEAR_EF_ADDR_8814B(x) | BIT_EF_ADDR_8814B(v))

#define BIT_SHIFT_EF_DATA_8814B 0
#define BIT_MASK_EF_DATA_8814B 0xff
#define BIT_EF_DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_EF_DATA_8814B) << BIT_SHIFT_EF_DATA_8814B)
#define BITS_EF_DATA_8814B (BIT_MASK_EF_DATA_8814B << BIT_SHIFT_EF_DATA_8814B)
#define BIT_CLEAR_EF_DATA_8814B(x) ((x) & (~BITS_EF_DATA_8814B))
#define BIT_GET_EF_DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_EF_DATA_8814B) & BIT_MASK_EF_DATA_8814B)
#define BIT_SET_EF_DATA_8814B(x, v)                                            \
	(BIT_CLEAR_EF_DATA_8814B(x) | BIT_EF_DATA_8814B(v))

/* 2 REG_LDO_EFUSE_CTRL_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_EF_CRES_SEL_8814B BIT(26)

#define BIT_SHIFT_EF_SCAN_START_V1_8814B 16
#define BIT_MASK_EF_SCAN_START_V1_8814B 0x3ff
#define BIT_EF_SCAN_START_V1_8814B(x)                                          \
	(((x) & BIT_MASK_EF_SCAN_START_V1_8814B)                               \
	 << BIT_SHIFT_EF_SCAN_START_V1_8814B)
#define BITS_EF_SCAN_START_V1_8814B                                            \
	(BIT_MASK_EF_SCAN_START_V1_8814B << BIT_SHIFT_EF_SCAN_START_V1_8814B)
#define BIT_CLEAR_EF_SCAN_START_V1_8814B(x)                                    \
	((x) & (~BITS_EF_SCAN_START_V1_8814B))
#define BIT_GET_EF_SCAN_START_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_EF_SCAN_START_V1_8814B) &                           \
	 BIT_MASK_EF_SCAN_START_V1_8814B)
#define BIT_SET_EF_SCAN_START_V1_8814B(x, v)                                   \
	(BIT_CLEAR_EF_SCAN_START_V1_8814B(x) | BIT_EF_SCAN_START_V1_8814B(v))

#define BIT_SHIFT_EF_SCAN_END_8814B 12
#define BIT_MASK_EF_SCAN_END_8814B 0xf
#define BIT_EF_SCAN_END_8814B(x)                                               \
	(((x) & BIT_MASK_EF_SCAN_END_8814B) << BIT_SHIFT_EF_SCAN_END_8814B)
#define BITS_EF_SCAN_END_8814B                                                 \
	(BIT_MASK_EF_SCAN_END_8814B << BIT_SHIFT_EF_SCAN_END_8814B)
#define BIT_CLEAR_EF_SCAN_END_8814B(x) ((x) & (~BITS_EF_SCAN_END_8814B))
#define BIT_GET_EF_SCAN_END_8814B(x)                                           \
	(((x) >> BIT_SHIFT_EF_SCAN_END_8814B) & BIT_MASK_EF_SCAN_END_8814B)
#define BIT_SET_EF_SCAN_END_8814B(x, v)                                        \
	(BIT_CLEAR_EF_SCAN_END_8814B(x) | BIT_EF_SCAN_END_8814B(v))

#define BIT_EF_PD_DIS_8814B BIT(11)

#define BIT_SHIFT_EF_CELL_SEL_8814B 8
#define BIT_MASK_EF_CELL_SEL_8814B 0x3
#define BIT_EF_CELL_SEL_8814B(x)                                               \
	(((x) & BIT_MASK_EF_CELL_SEL_8814B) << BIT_SHIFT_EF_CELL_SEL_8814B)
#define BITS_EF_CELL_SEL_8814B                                                 \
	(BIT_MASK_EF_CELL_SEL_8814B << BIT_SHIFT_EF_CELL_SEL_8814B)
#define BIT_CLEAR_EF_CELL_SEL_8814B(x) ((x) & (~BITS_EF_CELL_SEL_8814B))
#define BIT_GET_EF_CELL_SEL_8814B(x)                                           \
	(((x) >> BIT_SHIFT_EF_CELL_SEL_8814B) & BIT_MASK_EF_CELL_SEL_8814B)
#define BIT_SET_EF_CELL_SEL_8814B(x, v)                                        \
	(BIT_CLEAR_EF_CELL_SEL_8814B(x) | BIT_EF_CELL_SEL_8814B(v))

#define BIT_EF_TRPT_8814B BIT(7)

#define BIT_SHIFT_EF_TTHD_8814B 0
#define BIT_MASK_EF_TTHD_8814B 0x7f
#define BIT_EF_TTHD_8814B(x)                                                   \
	(((x) & BIT_MASK_EF_TTHD_8814B) << BIT_SHIFT_EF_TTHD_8814B)
#define BITS_EF_TTHD_8814B (BIT_MASK_EF_TTHD_8814B << BIT_SHIFT_EF_TTHD_8814B)
#define BIT_CLEAR_EF_TTHD_8814B(x) ((x) & (~BITS_EF_TTHD_8814B))
#define BIT_GET_EF_TTHD_8814B(x)                                               \
	(((x) >> BIT_SHIFT_EF_TTHD_8814B) & BIT_MASK_EF_TTHD_8814B)
#define BIT_SET_EF_TTHD_8814B(x, v)                                            \
	(BIT_CLEAR_EF_TTHD_8814B(x) | BIT_EF_TTHD_8814B(v))

/* 2 REG_PWR_OPTION_CTRL_8814B */

#define BIT_SHIFT_DBG_SEL_V1_8814B 16
#define BIT_MASK_DBG_SEL_V1_8814B 0xff
#define BIT_DBG_SEL_V1_8814B(x)                                                \
	(((x) & BIT_MASK_DBG_SEL_V1_8814B) << BIT_SHIFT_DBG_SEL_V1_8814B)
#define BITS_DBG_SEL_V1_8814B                                                  \
	(BIT_MASK_DBG_SEL_V1_8814B << BIT_SHIFT_DBG_SEL_V1_8814B)
#define BIT_CLEAR_DBG_SEL_V1_8814B(x) ((x) & (~BITS_DBG_SEL_V1_8814B))
#define BIT_GET_DBG_SEL_V1_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DBG_SEL_V1_8814B) & BIT_MASK_DBG_SEL_V1_8814B)
#define BIT_SET_DBG_SEL_V1_8814B(x, v)                                         \
	(BIT_CLEAR_DBG_SEL_V1_8814B(x) | BIT_DBG_SEL_V1_8814B(v))

#define BIT_SHIFT_DBG_SEL_BYTE_8814B 14
#define BIT_MASK_DBG_SEL_BYTE_8814B 0x3
#define BIT_DBG_SEL_BYTE_8814B(x)                                              \
	(((x) & BIT_MASK_DBG_SEL_BYTE_8814B) << BIT_SHIFT_DBG_SEL_BYTE_8814B)
#define BITS_DBG_SEL_BYTE_8814B                                                \
	(BIT_MASK_DBG_SEL_BYTE_8814B << BIT_SHIFT_DBG_SEL_BYTE_8814B)
#define BIT_CLEAR_DBG_SEL_BYTE_8814B(x) ((x) & (~BITS_DBG_SEL_BYTE_8814B))
#define BIT_GET_DBG_SEL_BYTE_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DBG_SEL_BYTE_8814B) & BIT_MASK_DBG_SEL_BYTE_8814B)
#define BIT_SET_DBG_SEL_BYTE_8814B(x, v)                                       \
	(BIT_CLEAR_DBG_SEL_BYTE_8814B(x) | BIT_DBG_SEL_BYTE_8814B(v))

/* 2 REG_NOT_VALID_8814B */
#define BIT_SYSON_DBG_PAD_E2_8814B BIT(11)
#define BIT_SYSON_LED_PAD_E2_8814B BIT(10)
#define BIT_SYSON_GPEE_PAD_E2_8814B BIT(9)
#define BIT_SYSON_PCI_PAD_E2_8814B BIT(8)
#define BIT_AUTO_SW_LDO_VOL_EN_8814B BIT(7)

#define BIT_SHIFT_SYSON_SPS0WWV_WT_8814B 4
#define BIT_MASK_SYSON_SPS0WWV_WT_8814B 0x3
#define BIT_SYSON_SPS0WWV_WT_8814B(x)                                          \
	(((x) & BIT_MASK_SYSON_SPS0WWV_WT_8814B)                               \
	 << BIT_SHIFT_SYSON_SPS0WWV_WT_8814B)
#define BITS_SYSON_SPS0WWV_WT_8814B                                            \
	(BIT_MASK_SYSON_SPS0WWV_WT_8814B << BIT_SHIFT_SYSON_SPS0WWV_WT_8814B)
#define BIT_CLEAR_SYSON_SPS0WWV_WT_8814B(x)                                    \
	((x) & (~BITS_SYSON_SPS0WWV_WT_8814B))
#define BIT_GET_SYSON_SPS0WWV_WT_8814B(x)                                      \
	(((x) >> BIT_SHIFT_SYSON_SPS0WWV_WT_8814B) &                           \
	 BIT_MASK_SYSON_SPS0WWV_WT_8814B)
#define BIT_SET_SYSON_SPS0WWV_WT_8814B(x, v)                                   \
	(BIT_CLEAR_SYSON_SPS0WWV_WT_8814B(x) | BIT_SYSON_SPS0WWV_WT_8814B(v))

#define BIT_SHIFT_SYSON_SPS0LDO_WT_8814B 2
#define BIT_MASK_SYSON_SPS0LDO_WT_8814B 0x3
#define BIT_SYSON_SPS0LDO_WT_8814B(x)                                          \
	(((x) & BIT_MASK_SYSON_SPS0LDO_WT_8814B)                               \
	 << BIT_SHIFT_SYSON_SPS0LDO_WT_8814B)
#define BITS_SYSON_SPS0LDO_WT_8814B                                            \
	(BIT_MASK_SYSON_SPS0LDO_WT_8814B << BIT_SHIFT_SYSON_SPS0LDO_WT_8814B)
#define BIT_CLEAR_SYSON_SPS0LDO_WT_8814B(x)                                    \
	((x) & (~BITS_SYSON_SPS0LDO_WT_8814B))
#define BIT_GET_SYSON_SPS0LDO_WT_8814B(x)                                      \
	(((x) >> BIT_SHIFT_SYSON_SPS0LDO_WT_8814B) &                           \
	 BIT_MASK_SYSON_SPS0LDO_WT_8814B)
#define BIT_SET_SYSON_SPS0LDO_WT_8814B(x, v)                                   \
	(BIT_CLEAR_SYSON_SPS0LDO_WT_8814B(x) | BIT_SYSON_SPS0LDO_WT_8814B(v))

#define BIT_SHIFT_SYSON_RCLK_SCALE_8814B 0
#define BIT_MASK_SYSON_RCLK_SCALE_8814B 0x3
#define BIT_SYSON_RCLK_SCALE_8814B(x)                                          \
	(((x) & BIT_MASK_SYSON_RCLK_SCALE_8814B)                               \
	 << BIT_SHIFT_SYSON_RCLK_SCALE_8814B)
#define BITS_SYSON_RCLK_SCALE_8814B                                            \
	(BIT_MASK_SYSON_RCLK_SCALE_8814B << BIT_SHIFT_SYSON_RCLK_SCALE_8814B)
#define BIT_CLEAR_SYSON_RCLK_SCALE_8814B(x)                                    \
	((x) & (~BITS_SYSON_RCLK_SCALE_8814B))
#define BIT_GET_SYSON_RCLK_SCALE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_SYSON_RCLK_SCALE_8814B) &                           \
	 BIT_MASK_SYSON_RCLK_SCALE_8814B)
#define BIT_SET_SYSON_RCLK_SCALE_8814B(x, v)                                   \
	(BIT_CLEAR_SYSON_RCLK_SCALE_8814B(x) | BIT_SYSON_RCLK_SCALE_8814B(v))

/* 2 REG_CAL_TIMER_8814B */

#define BIT_SHIFT_MATCH_CNT_8814B 8
#define BIT_MASK_MATCH_CNT_8814B 0xff
#define BIT_MATCH_CNT_8814B(x)                                                 \
	(((x) & BIT_MASK_MATCH_CNT_8814B) << BIT_SHIFT_MATCH_CNT_8814B)
#define BITS_MATCH_CNT_8814B                                                   \
	(BIT_MASK_MATCH_CNT_8814B << BIT_SHIFT_MATCH_CNT_8814B)
#define BIT_CLEAR_MATCH_CNT_8814B(x) ((x) & (~BITS_MATCH_CNT_8814B))
#define BIT_GET_MATCH_CNT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_MATCH_CNT_8814B) & BIT_MASK_MATCH_CNT_8814B)
#define BIT_SET_MATCH_CNT_8814B(x, v)                                          \
	(BIT_CLEAR_MATCH_CNT_8814B(x) | BIT_MATCH_CNT_8814B(v))

#define BIT_SHIFT_CAL_SCAL_8814B 0
#define BIT_MASK_CAL_SCAL_8814B 0xff
#define BIT_CAL_SCAL_8814B(x)                                                  \
	(((x) & BIT_MASK_CAL_SCAL_8814B) << BIT_SHIFT_CAL_SCAL_8814B)
#define BITS_CAL_SCAL_8814B                                                    \
	(BIT_MASK_CAL_SCAL_8814B << BIT_SHIFT_CAL_SCAL_8814B)
#define BIT_CLEAR_CAL_SCAL_8814B(x) ((x) & (~BITS_CAL_SCAL_8814B))
#define BIT_GET_CAL_SCAL_8814B(x)                                              \
	(((x) >> BIT_SHIFT_CAL_SCAL_8814B) & BIT_MASK_CAL_SCAL_8814B)
#define BIT_SET_CAL_SCAL_8814B(x, v)                                           \
	(BIT_CLEAR_CAL_SCAL_8814B(x) | BIT_CAL_SCAL_8814B(v))

/* 2 REG_ACLK_MON_8814B */

#define BIT_SHIFT_RCLK_MON_8814B 5
#define BIT_MASK_RCLK_MON_8814B 0x7ff
#define BIT_RCLK_MON_8814B(x)                                                  \
	(((x) & BIT_MASK_RCLK_MON_8814B) << BIT_SHIFT_RCLK_MON_8814B)
#define BITS_RCLK_MON_8814B                                                    \
	(BIT_MASK_RCLK_MON_8814B << BIT_SHIFT_RCLK_MON_8814B)
#define BIT_CLEAR_RCLK_MON_8814B(x) ((x) & (~BITS_RCLK_MON_8814B))
#define BIT_GET_RCLK_MON_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RCLK_MON_8814B) & BIT_MASK_RCLK_MON_8814B)
#define BIT_SET_RCLK_MON_8814B(x, v)                                           \
	(BIT_CLEAR_RCLK_MON_8814B(x) | BIT_RCLK_MON_8814B(v))

#define BIT_CAL_EN_8814B BIT(4)

#define BIT_SHIFT_DPSTU_8814B 2
#define BIT_MASK_DPSTU_8814B 0x3
#define BIT_DPSTU_8814B(x)                                                     \
	(((x) & BIT_MASK_DPSTU_8814B) << BIT_SHIFT_DPSTU_8814B)
#define BITS_DPSTU_8814B (BIT_MASK_DPSTU_8814B << BIT_SHIFT_DPSTU_8814B)
#define BIT_CLEAR_DPSTU_8814B(x) ((x) & (~BITS_DPSTU_8814B))
#define BIT_GET_DPSTU_8814B(x)                                                 \
	(((x) >> BIT_SHIFT_DPSTU_8814B) & BIT_MASK_DPSTU_8814B)
#define BIT_SET_DPSTU_8814B(x, v)                                              \
	(BIT_CLEAR_DPSTU_8814B(x) | BIT_DPSTU_8814B(v))

#define BIT_SUS_16X_8814B BIT(1)

/* 2 REG_GPIO_MUXCFG_8814B */
#define BIT_EN_DATACPU_GPIO2_8814B BIT(24)
#define BIT_EN_DATACPU_GPIO_8814B BIT(23)
#define BIT_EN_DATACPU_UART_8814B BIT(22)
#define BIT_DATACPU_FSPI_EN_8814B BIT(21)
#define BIT_EN_GPIO8_UART_OUT_8814B BIT(20)
#define BIT_FSPI_EN_8814B BIT(19)
#define BIT_WL_RTS_EXT_32K_SEL_8814B BIT(18)
#define BIT_WLGP_SPI_EN_8814B BIT(16)
#define BIT_SIC_LBK_8814B BIT(15)
#define BIT_ENHTP_8814B BIT(14)
#define BIT_ENSIC_8814B BIT(12)
#define BIT_SIC_SWRST_8814B BIT(11)
#define BIT_PO_WIFI_PTA_PINS_8814B BIT(10)
#define BIT_PO_BT_PTA_PINS_8814B BIT(9)
#define BIT_ENUART_8814B BIT(8)

#define BIT_SHIFT_BTMODE_8814B 6
#define BIT_MASK_BTMODE_8814B 0x3
#define BIT_BTMODE_8814B(x)                                                    \
	(((x) & BIT_MASK_BTMODE_8814B) << BIT_SHIFT_BTMODE_8814B)
#define BITS_BTMODE_8814B (BIT_MASK_BTMODE_8814B << BIT_SHIFT_BTMODE_8814B)
#define BIT_CLEAR_BTMODE_8814B(x) ((x) & (~BITS_BTMODE_8814B))
#define BIT_GET_BTMODE_8814B(x)                                                \
	(((x) >> BIT_SHIFT_BTMODE_8814B) & BIT_MASK_BTMODE_8814B)
#define BIT_SET_BTMODE_8814B(x, v)                                             \
	(BIT_CLEAR_BTMODE_8814B(x) | BIT_BTMODE_8814B(v))

#define BIT_ENBT_8814B BIT(5)
#define BIT_EROM_EN_8814B BIT(4)
#define BIT_WLRFE_6_7_EN_8814B BIT(3)
#define BIT_WLRFE_4_5_EN_8814B BIT(2)

#define BIT_SHIFT_GPIOSEL_8814B 0
#define BIT_MASK_GPIOSEL_8814B 0x3
#define BIT_GPIOSEL_8814B(x)                                                   \
	(((x) & BIT_MASK_GPIOSEL_8814B) << BIT_SHIFT_GPIOSEL_8814B)
#define BITS_GPIOSEL_8814B (BIT_MASK_GPIOSEL_8814B << BIT_SHIFT_GPIOSEL_8814B)
#define BIT_CLEAR_GPIOSEL_8814B(x) ((x) & (~BITS_GPIOSEL_8814B))
#define BIT_GET_GPIOSEL_8814B(x)                                               \
	(((x) >> BIT_SHIFT_GPIOSEL_8814B) & BIT_MASK_GPIOSEL_8814B)
#define BIT_SET_GPIOSEL_8814B(x, v)                                            \
	(BIT_CLEAR_GPIOSEL_8814B(x) | BIT_GPIOSEL_8814B(v))

/* 2 REG_GPIO_PIN_CTRL_8814B */

#define BIT_SHIFT_GPIO_MOD_7_TO_0_8814B 24
#define BIT_MASK_GPIO_MOD_7_TO_0_8814B 0xff
#define BIT_GPIO_MOD_7_TO_0_8814B(x)                                           \
	(((x) & BIT_MASK_GPIO_MOD_7_TO_0_8814B)                                \
	 << BIT_SHIFT_GPIO_MOD_7_TO_0_8814B)
#define BITS_GPIO_MOD_7_TO_0_8814B                                             \
	(BIT_MASK_GPIO_MOD_7_TO_0_8814B << BIT_SHIFT_GPIO_MOD_7_TO_0_8814B)
#define BIT_CLEAR_GPIO_MOD_7_TO_0_8814B(x) ((x) & (~BITS_GPIO_MOD_7_TO_0_8814B))
#define BIT_GET_GPIO_MOD_7_TO_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_GPIO_MOD_7_TO_0_8814B) &                            \
	 BIT_MASK_GPIO_MOD_7_TO_0_8814B)
#define BIT_SET_GPIO_MOD_7_TO_0_8814B(x, v)                                    \
	(BIT_CLEAR_GPIO_MOD_7_TO_0_8814B(x) | BIT_GPIO_MOD_7_TO_0_8814B(v))

#define BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8814B 16
#define BIT_MASK_GPIO_IO_SEL_7_TO_0_8814B 0xff
#define BIT_GPIO_IO_SEL_7_TO_0_8814B(x)                                        \
	(((x) & BIT_MASK_GPIO_IO_SEL_7_TO_0_8814B)                             \
	 << BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8814B)
#define BITS_GPIO_IO_SEL_7_TO_0_8814B                                          \
	(BIT_MASK_GPIO_IO_SEL_7_TO_0_8814B                                     \
	 << BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8814B)
#define BIT_CLEAR_GPIO_IO_SEL_7_TO_0_8814B(x)                                  \
	((x) & (~BITS_GPIO_IO_SEL_7_TO_0_8814B))
#define BIT_GET_GPIO_IO_SEL_7_TO_0_8814B(x)                                    \
	(((x) >> BIT_SHIFT_GPIO_IO_SEL_7_TO_0_8814B) &                         \
	 BIT_MASK_GPIO_IO_SEL_7_TO_0_8814B)
#define BIT_SET_GPIO_IO_SEL_7_TO_0_8814B(x, v)                                 \
	(BIT_CLEAR_GPIO_IO_SEL_7_TO_0_8814B(x) |                               \
	 BIT_GPIO_IO_SEL_7_TO_0_8814B(v))

#define BIT_SHIFT_GPIO_OUT_7_TO_0_8814B 8
#define BIT_MASK_GPIO_OUT_7_TO_0_8814B 0xff
#define BIT_GPIO_OUT_7_TO_0_8814B(x)                                           \
	(((x) & BIT_MASK_GPIO_OUT_7_TO_0_8814B)                                \
	 << BIT_SHIFT_GPIO_OUT_7_TO_0_8814B)
#define BITS_GPIO_OUT_7_TO_0_8814B                                             \
	(BIT_MASK_GPIO_OUT_7_TO_0_8814B << BIT_SHIFT_GPIO_OUT_7_TO_0_8814B)
#define BIT_CLEAR_GPIO_OUT_7_TO_0_8814B(x) ((x) & (~BITS_GPIO_OUT_7_TO_0_8814B))
#define BIT_GET_GPIO_OUT_7_TO_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_GPIO_OUT_7_TO_0_8814B) &                            \
	 BIT_MASK_GPIO_OUT_7_TO_0_8814B)
#define BIT_SET_GPIO_OUT_7_TO_0_8814B(x, v)                                    \
	(BIT_CLEAR_GPIO_OUT_7_TO_0_8814B(x) | BIT_GPIO_OUT_7_TO_0_8814B(v))

#define BIT_SHIFT_GPIO_IN_7_TO_0_8814B 0
#define BIT_MASK_GPIO_IN_7_TO_0_8814B 0xff
#define BIT_GPIO_IN_7_TO_0_8814B(x)                                            \
	(((x) & BIT_MASK_GPIO_IN_7_TO_0_8814B)                                 \
	 << BIT_SHIFT_GPIO_IN_7_TO_0_8814B)
#define BITS_GPIO_IN_7_TO_0_8814B                                              \
	(BIT_MASK_GPIO_IN_7_TO_0_8814B << BIT_SHIFT_GPIO_IN_7_TO_0_8814B)
#define BIT_CLEAR_GPIO_IN_7_TO_0_8814B(x) ((x) & (~BITS_GPIO_IN_7_TO_0_8814B))
#define BIT_GET_GPIO_IN_7_TO_0_8814B(x)                                        \
	(((x) >> BIT_SHIFT_GPIO_IN_7_TO_0_8814B) &                             \
	 BIT_MASK_GPIO_IN_7_TO_0_8814B)
#define BIT_SET_GPIO_IN_7_TO_0_8814B(x, v)                                     \
	(BIT_CLEAR_GPIO_IN_7_TO_0_8814B(x) | BIT_GPIO_IN_7_TO_0_8814B(v))

/* 2 REG_GPIO_INTM_8814B */

#define BIT_SHIFT_MUXDBG_SEL_8814B 30
#define BIT_MASK_MUXDBG_SEL_8814B 0x3
#define BIT_MUXDBG_SEL_8814B(x)                                                \
	(((x) & BIT_MASK_MUXDBG_SEL_8814B) << BIT_SHIFT_MUXDBG_SEL_8814B)
#define BITS_MUXDBG_SEL_8814B                                                  \
	(BIT_MASK_MUXDBG_SEL_8814B << BIT_SHIFT_MUXDBG_SEL_8814B)
#define BIT_CLEAR_MUXDBG_SEL_8814B(x) ((x) & (~BITS_MUXDBG_SEL_8814B))
#define BIT_GET_MUXDBG_SEL_8814B(x)                                            \
	(((x) >> BIT_SHIFT_MUXDBG_SEL_8814B) & BIT_MASK_MUXDBG_SEL_8814B)
#define BIT_SET_MUXDBG_SEL_8814B(x, v)                                         \
	(BIT_CLEAR_MUXDBG_SEL_8814B(x) | BIT_MUXDBG_SEL_8814B(v))

#define BIT_EXTWOL_SEL_8814B BIT(17)
#define BIT_EXTWOL_EN_8814B BIT(16)
#define BIT_GPIOF_INT_MD_8814B BIT(15)
#define BIT_GPIOE_INT_MD_8814B BIT(14)
#define BIT_GPIOD_INT_MD_8814B BIT(13)
#define BIT_GPIOF_INT_MD_8814B BIT(15)
#define BIT_GPIOE_INT_MD_8814B BIT(14)
#define BIT_GPIOD_INT_MD_8814B BIT(13)
#define BIT_GPIOC_INT_MD_8814B BIT(12)
#define BIT_GPIOB_INT_MD_8814B BIT(11)
#define BIT_GPIOA_INT_MD_8814B BIT(10)
#define BIT_GPIO9_INT_MD_8814B BIT(9)
#define BIT_GPIO8_INT_MD_8814B BIT(8)
#define BIT_GPIO7_INT_MD_8814B BIT(7)
#define BIT_GPIO6_INT_MD_8814B BIT(6)
#define BIT_GPIO5_INT_MD_8814B BIT(5)
#define BIT_GPIO4_INT_MD_8814B BIT(4)
#define BIT_GPIO3_INT_MD_8814B BIT(3)
#define BIT_GPIO2_INT_MD_8814B BIT(2)
#define BIT_GPIO1_INT_MD_8814B BIT(1)
#define BIT_GPIO0_INT_MD_8814B BIT(0)

/* 2 REG_LED_CFG_8814B */
#define BIT_GPIO3_WL_CTRL_EN_8814B BIT(27)
#define BIT_LNAON_SEL_EN_8814B BIT(26)
#define BIT_PAPE_SEL_EN_8814B BIT(25)
#define BIT_DPDT_WLBT_SEL_8814B BIT(24)
#define BIT_DPDT_SEL_EN_8814B BIT(23)
#define BIT_GPIO13_14_WL_CTRL_EN_8814B BIT(22)
#define BIT_LED2DIS_8814B BIT(21)
#define BIT_LED2PL_8814B BIT(20)
#define BIT_LED2SV_8814B BIT(19)

#define BIT_SHIFT_LED2CM_8814B 16
#define BIT_MASK_LED2CM_8814B 0x7
#define BIT_LED2CM_8814B(x)                                                    \
	(((x) & BIT_MASK_LED2CM_8814B) << BIT_SHIFT_LED2CM_8814B)
#define BITS_LED2CM_8814B (BIT_MASK_LED2CM_8814B << BIT_SHIFT_LED2CM_8814B)
#define BIT_CLEAR_LED2CM_8814B(x) ((x) & (~BITS_LED2CM_8814B))
#define BIT_GET_LED2CM_8814B(x)                                                \
	(((x) >> BIT_SHIFT_LED2CM_8814B) & BIT_MASK_LED2CM_8814B)
#define BIT_SET_LED2CM_8814B(x, v)                                             \
	(BIT_CLEAR_LED2CM_8814B(x) | BIT_LED2CM_8814B(v))

#define BIT_LED1DIS_8814B BIT(15)
#define BIT_LED1PL_8814B BIT(12)
#define BIT_LED1SV_8814B BIT(11)

#define BIT_SHIFT_LED1CM_8814B 8
#define BIT_MASK_LED1CM_8814B 0x7
#define BIT_LED1CM_8814B(x)                                                    \
	(((x) & BIT_MASK_LED1CM_8814B) << BIT_SHIFT_LED1CM_8814B)
#define BITS_LED1CM_8814B (BIT_MASK_LED1CM_8814B << BIT_SHIFT_LED1CM_8814B)
#define BIT_CLEAR_LED1CM_8814B(x) ((x) & (~BITS_LED1CM_8814B))
#define BIT_GET_LED1CM_8814B(x)                                                \
	(((x) >> BIT_SHIFT_LED1CM_8814B) & BIT_MASK_LED1CM_8814B)
#define BIT_SET_LED1CM_8814B(x, v)                                             \
	(BIT_CLEAR_LED1CM_8814B(x) | BIT_LED1CM_8814B(v))

#define BIT_LED0DIS_8814B BIT(7)

#define BIT_SHIFT_AFE_LDO_SWR_CHECK_8814B 5
#define BIT_MASK_AFE_LDO_SWR_CHECK_8814B 0x3
#define BIT_AFE_LDO_SWR_CHECK_8814B(x)                                         \
	(((x) & BIT_MASK_AFE_LDO_SWR_CHECK_8814B)                              \
	 << BIT_SHIFT_AFE_LDO_SWR_CHECK_8814B)
#define BITS_AFE_LDO_SWR_CHECK_8814B                                           \
	(BIT_MASK_AFE_LDO_SWR_CHECK_8814B << BIT_SHIFT_AFE_LDO_SWR_CHECK_8814B)
#define BIT_CLEAR_AFE_LDO_SWR_CHECK_8814B(x)                                   \
	((x) & (~BITS_AFE_LDO_SWR_CHECK_8814B))
#define BIT_GET_AFE_LDO_SWR_CHECK_8814B(x)                                     \
	(((x) >> BIT_SHIFT_AFE_LDO_SWR_CHECK_8814B) &                          \
	 BIT_MASK_AFE_LDO_SWR_CHECK_8814B)
#define BIT_SET_AFE_LDO_SWR_CHECK_8814B(x, v)                                  \
	(BIT_CLEAR_AFE_LDO_SWR_CHECK_8814B(x) | BIT_AFE_LDO_SWR_CHECK_8814B(v))

#define BIT_LED0PL_8814B BIT(4)
#define BIT_LED0SV_8814B BIT(3)

#define BIT_SHIFT_LED0CM_8814B 0
#define BIT_MASK_LED0CM_8814B 0x7
#define BIT_LED0CM_8814B(x)                                                    \
	(((x) & BIT_MASK_LED0CM_8814B) << BIT_SHIFT_LED0CM_8814B)
#define BITS_LED0CM_8814B (BIT_MASK_LED0CM_8814B << BIT_SHIFT_LED0CM_8814B)
#define BIT_CLEAR_LED0CM_8814B(x) ((x) & (~BITS_LED0CM_8814B))
#define BIT_GET_LED0CM_8814B(x)                                                \
	(((x) >> BIT_SHIFT_LED0CM_8814B) & BIT_MASK_LED0CM_8814B)
#define BIT_SET_LED0CM_8814B(x, v)                                             \
	(BIT_CLEAR_LED0CM_8814B(x) | BIT_LED0CM_8814B(v))

/* 2 REG_FSIMR_8814B */
#define BIT_FS_PDNINT_EN_8814B BIT(31)
#define BIT_NFC_INT_PAD_EN_8814B BIT(30)
#define BIT_FS_SPS_OCP_INT_EN_8814B BIT(29)
#define BIT_FS_PWMERR_INT_EN_8814B BIT(28)
#define BIT_FS_GPIOF_INT_EN_8814B BIT(27)
#define BIT_FS_GPIOE_INT_EN_8814B BIT(26)
#define BIT_FS_GPIOD_INT_EN_8814B BIT(25)
#define BIT_FS_GPIOC_INT_EN_8814B BIT(24)
#define BIT_FS_GPIOB_INT_EN_8814B BIT(23)
#define BIT_FS_GPIOA_INT_EN_8814B BIT(22)
#define BIT_FS_GPIO9_INT_EN_8814B BIT(21)
#define BIT_FS_GPIO8_INT_EN_8814B BIT(20)
#define BIT_FS_GPIO7_INT_EN_8814B BIT(19)
#define BIT_FS_GPIO6_INT_EN_8814B BIT(18)
#define BIT_FS_GPIO5_INT_EN_8814B BIT(17)
#define BIT_FS_GPIO4_INT_EN_8814B BIT(16)
#define BIT_FS_GPIO3_INT_EN_8814B BIT(15)
#define BIT_FS_GPIO2_INT_EN_8814B BIT(14)
#define BIT_FS_GPIO1_INT_EN_8814B BIT(13)
#define BIT_FS_GPIO0_INT_EN_8814B BIT(12)
#define BIT_FS_HCI_SUS_EN_8814B BIT(11)
#define BIT_FS_HCI_RES_EN_8814B BIT(10)
#define BIT_FS_HCI_RESET_EN_8814B BIT(9)
#define BIT_USB_SCSI_CMD_EN_8814B BIT(8)
#define BIT_FS_BTON_STS_UPDATE_MSK_EN_8814B BIT(7)
#define BIT_ACT2RECOVERY_INT_EN_V1_8814B BIT(6)
#define BIT_GEN1GEN2_SWITCH_8814B BIT(5)
#define BIT_HCI_TXDMA_REQ_HIMR_8814B BIT(4)
#define BIT_FS_32K_LEAVE_SETTING_MAK_8814B BIT(3)
#define BIT_FS_32K_ENTER_SETTING_MAK_8814B BIT(2)
#define BIT_FS_USB_LPMRSM_MSK_8814B BIT(1)
#define BIT_FS_USB_LPMINT_MSK_8814B BIT(0)

/* 2 REG_FSISR_8814B */
#define BIT_FS_PDNINT_8814B BIT(31)
#define BIT_FS_SPS_OCP_INT_8814B BIT(29)
#define BIT_FS_PWMERR_INT_8814B BIT(28)
#define BIT_FS_GPIOF_INT_8814B BIT(27)
#define BIT_FS_GPIOE_INT_8814B BIT(26)
#define BIT_FS_GPIOD_INT_8814B BIT(25)
#define BIT_FS_GPIOC_INT_8814B BIT(24)
#define BIT_FS_GPIOB_INT_8814B BIT(23)
#define BIT_FS_GPIOA_INT_8814B BIT(22)
#define BIT_FS_GPIO9_INT_8814B BIT(21)
#define BIT_FS_GPIO8_INT_8814B BIT(20)
#define BIT_FS_GPIO7_INT_8814B BIT(19)
#define BIT_FS_GPIO6_INT_8814B BIT(18)
#define BIT_FS_GPIO5_INT_8814B BIT(17)
#define BIT_FS_GPIO4_INT_8814B BIT(16)
#define BIT_FS_GPIO3_INT_8814B BIT(15)
#define BIT_FS_GPIO2_INT_8814B BIT(14)
#define BIT_FS_GPIO1_INT_8814B BIT(13)
#define BIT_FS_GPIO0_INT_8814B BIT(12)
#define BIT_FS_HCI_SUS_INT_8814B BIT(11)
#define BIT_FS_HCI_RES_INT_8814B BIT(10)
#define BIT_FS_HCI_RESET_INT_8814B BIT(9)
#define BIT_USB_SCSI_CMD_INT_8814B BIT(8)
#define BIT_FS_BTON_STS_UPDATE_INT_8814B BIT(7)
#define BIT_ACT2RECOVERY_8814B BIT(6)
#define BIT_GEN1GEN2_SWITCH_8814B BIT(5)
#define BIT_HCI_TXDMA_REQ_HISR_8814B BIT(4)
#define BIT_FS_32K_LEAVE_SETTING_INT_8814B BIT(3)
#define BIT_FS_32K_ENTER_SETTING_INT_8814B BIT(2)
#define BIT_FS_USB_LPMRSM_INT_8814B BIT(1)
#define BIT_FS_USB_LPMINT_INT_8814B BIT(0)

/* 2 REG_HSIMR_8814B */
#define BIT_GPIOF_INT_EN_8814B BIT(31)
#define BIT_GPIOE_INT_EN_8814B BIT(30)
#define BIT_GPIOD_INT_EN_8814B BIT(29)
#define BIT_GPIOC_INT_EN_8814B BIT(28)
#define BIT_GPIOB_INT_EN_8814B BIT(27)
#define BIT_GPIOA_INT_EN_8814B BIT(26)
#define BIT_GPIO9_INT_EN_8814B BIT(25)
#define BIT_GPIO8_INT_EN_8814B BIT(24)
#define BIT_GPIO7_INT_EN_8814B BIT(23)
#define BIT_GPIO6_INT_EN_8814B BIT(22)
#define BIT_GPIO5_INT_EN_8814B BIT(21)
#define BIT_GPIO4_INT_EN_8814B BIT(20)
#define BIT_GPIO3_INT_EN_8814B BIT(19)
#define BIT_GPIO2_INT_EN_V1_8814B BIT(18)
#define BIT_GPIO1_INT_EN_8814B BIT(17)
#define BIT_GPIO0_INT_EN_8814B BIT(16)
#define BIT_PDNINT_EN_8814B BIT(7)
#define BIT_RON_INT_EN_8814B BIT(6)
#define BIT_SPS_OCP_INT_EN_8814B BIT(5)
#define BIT_GPIO15_0_INT_EN_8814B BIT(0)

/* 2 REG_HSISR_8814B */
#define BIT_GPIOF_INT_8814B BIT(31)
#define BIT_GPIOE_INT_8814B BIT(30)
#define BIT_GPIOD_INT_8814B BIT(29)
#define BIT_GPIOC_INT_8814B BIT(28)
#define BIT_GPIOB_INT_8814B BIT(27)
#define BIT_GPIOA_INT_8814B BIT(26)
#define BIT_GPIO9_INT_8814B BIT(25)
#define BIT_GPIO8_INT_8814B BIT(24)
#define BIT_GPIO7_INT_8814B BIT(23)
#define BIT_GPIO6_INT_8814B BIT(22)
#define BIT_GPIO5_INT_8814B BIT(21)
#define BIT_GPIO4_INT_8814B BIT(20)
#define BIT_GPIO3_INT_8814B BIT(19)
#define BIT_GPIO2_INT_V1_8814B BIT(18)
#define BIT_GPIO1_INT_8814B BIT(17)
#define BIT_GPIO0_INT_8814B BIT(16)
#define BIT_PDNINT_8814B BIT(7)
#define BIT_RON_INT_8814B BIT(6)
#define BIT_SPS_OCP_INT_8814B BIT(5)
#define BIT_GPIO15_0_INT_8814B BIT(0)

/* 2 REG_GPIO_EXT_CTRL_8814B */

#define BIT_SHIFT_GPIO_MOD_15_TO_8_8814B 24
#define BIT_MASK_GPIO_MOD_15_TO_8_8814B 0xff
#define BIT_GPIO_MOD_15_TO_8_8814B(x)                                          \
	(((x) & BIT_MASK_GPIO_MOD_15_TO_8_8814B)                               \
	 << BIT_SHIFT_GPIO_MOD_15_TO_8_8814B)
#define BITS_GPIO_MOD_15_TO_8_8814B                                            \
	(BIT_MASK_GPIO_MOD_15_TO_8_8814B << BIT_SHIFT_GPIO_MOD_15_TO_8_8814B)
#define BIT_CLEAR_GPIO_MOD_15_TO_8_8814B(x)                                    \
	((x) & (~BITS_GPIO_MOD_15_TO_8_8814B))
#define BIT_GET_GPIO_MOD_15_TO_8_8814B(x)                                      \
	(((x) >> BIT_SHIFT_GPIO_MOD_15_TO_8_8814B) &                           \
	 BIT_MASK_GPIO_MOD_15_TO_8_8814B)
#define BIT_SET_GPIO_MOD_15_TO_8_8814B(x, v)                                   \
	(BIT_CLEAR_GPIO_MOD_15_TO_8_8814B(x) | BIT_GPIO_MOD_15_TO_8_8814B(v))

#define BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8814B 16
#define BIT_MASK_GPIO_IO_SEL_15_TO_8_8814B 0xff
#define BIT_GPIO_IO_SEL_15_TO_8_8814B(x)                                       \
	(((x) & BIT_MASK_GPIO_IO_SEL_15_TO_8_8814B)                            \
	 << BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8814B)
#define BITS_GPIO_IO_SEL_15_TO_8_8814B                                         \
	(BIT_MASK_GPIO_IO_SEL_15_TO_8_8814B                                    \
	 << BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8814B)
#define BIT_CLEAR_GPIO_IO_SEL_15_TO_8_8814B(x)                                 \
	((x) & (~BITS_GPIO_IO_SEL_15_TO_8_8814B))
#define BIT_GET_GPIO_IO_SEL_15_TO_8_8814B(x)                                   \
	(((x) >> BIT_SHIFT_GPIO_IO_SEL_15_TO_8_8814B) &                        \
	 BIT_MASK_GPIO_IO_SEL_15_TO_8_8814B)
#define BIT_SET_GPIO_IO_SEL_15_TO_8_8814B(x, v)                                \
	(BIT_CLEAR_GPIO_IO_SEL_15_TO_8_8814B(x) |                              \
	 BIT_GPIO_IO_SEL_15_TO_8_8814B(v))

#define BIT_SHIFT_GPIO_OUT_15_TO_8_8814B 8
#define BIT_MASK_GPIO_OUT_15_TO_8_8814B 0xff
#define BIT_GPIO_OUT_15_TO_8_8814B(x)                                          \
	(((x) & BIT_MASK_GPIO_OUT_15_TO_8_8814B)                               \
	 << BIT_SHIFT_GPIO_OUT_15_TO_8_8814B)
#define BITS_GPIO_OUT_15_TO_8_8814B                                            \
	(BIT_MASK_GPIO_OUT_15_TO_8_8814B << BIT_SHIFT_GPIO_OUT_15_TO_8_8814B)
#define BIT_CLEAR_GPIO_OUT_15_TO_8_8814B(x)                                    \
	((x) & (~BITS_GPIO_OUT_15_TO_8_8814B))
#define BIT_GET_GPIO_OUT_15_TO_8_8814B(x)                                      \
	(((x) >> BIT_SHIFT_GPIO_OUT_15_TO_8_8814B) &                           \
	 BIT_MASK_GPIO_OUT_15_TO_8_8814B)
#define BIT_SET_GPIO_OUT_15_TO_8_8814B(x, v)                                   \
	(BIT_CLEAR_GPIO_OUT_15_TO_8_8814B(x) | BIT_GPIO_OUT_15_TO_8_8814B(v))

#define BIT_SHIFT_GPIO_IN_15_TO_8_8814B 0
#define BIT_MASK_GPIO_IN_15_TO_8_8814B 0xff
#define BIT_GPIO_IN_15_TO_8_8814B(x)                                           \
	(((x) & BIT_MASK_GPIO_IN_15_TO_8_8814B)                                \
	 << BIT_SHIFT_GPIO_IN_15_TO_8_8814B)
#define BITS_GPIO_IN_15_TO_8_8814B                                             \
	(BIT_MASK_GPIO_IN_15_TO_8_8814B << BIT_SHIFT_GPIO_IN_15_TO_8_8814B)
#define BIT_CLEAR_GPIO_IN_15_TO_8_8814B(x) ((x) & (~BITS_GPIO_IN_15_TO_8_8814B))
#define BIT_GET_GPIO_IN_15_TO_8_8814B(x)                                       \
	(((x) >> BIT_SHIFT_GPIO_IN_15_TO_8_8814B) &                            \
	 BIT_MASK_GPIO_IN_15_TO_8_8814B)
#define BIT_SET_GPIO_IN_15_TO_8_8814B(x, v)                                    \
	(BIT_CLEAR_GPIO_IN_15_TO_8_8814B(x) | BIT_GPIO_IN_15_TO_8_8814B(v))

/* 2 REG_PAD_CTRL1_8814B */
#define BIT_DATA_CPU_JTAG_8814B BIT(30)
#define BIT_PAPE_WLBT_SEL_8814B BIT(29)
#define BIT_LNAON_WLBT_SEL_8814B BIT(28)
#define BIT_BTGP_GPG3_FEN_8814B BIT(26)
#define BIT_BTGP_GPG2_FEN_8814B BIT(25)
#define BIT_BTGP_JTAG_EN_8814B BIT(24)
#define BIT_XTAL_CLK_EXTARNAL_EN_8814B BIT(23)
#define BIT_BTGP_UART0_EN_8814B BIT(22)
#define BIT_BTGP_UART1_EN_8814B BIT(21)
#define BIT_BTGP_SPI_EN_8814B BIT(20)
#define BIT_BTGP_GPIO_E2_8814B BIT(19)
#define BIT_BTGP_GPIO_EN_8814B BIT(18)

#define BIT_SHIFT_BTGP_GPIO_SL_8814B 16
#define BIT_MASK_BTGP_GPIO_SL_8814B 0x3
#define BIT_BTGP_GPIO_SL_8814B(x)                                              \
	(((x) & BIT_MASK_BTGP_GPIO_SL_8814B) << BIT_SHIFT_BTGP_GPIO_SL_8814B)
#define BITS_BTGP_GPIO_SL_8814B                                                \
	(BIT_MASK_BTGP_GPIO_SL_8814B << BIT_SHIFT_BTGP_GPIO_SL_8814B)
#define BIT_CLEAR_BTGP_GPIO_SL_8814B(x) ((x) & (~BITS_BTGP_GPIO_SL_8814B))
#define BIT_GET_BTGP_GPIO_SL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_BTGP_GPIO_SL_8814B) & BIT_MASK_BTGP_GPIO_SL_8814B)
#define BIT_SET_BTGP_GPIO_SL_8814B(x, v)                                       \
	(BIT_CLEAR_BTGP_GPIO_SL_8814B(x) | BIT_BTGP_GPIO_SL_8814B(v))

#define BIT_WL_JTAG_8814B BIT(15)
#define BIT_PAD_SDIO_SR_8814B BIT(14)
#define BIT_GPIO14_OUTPUT_PL_8814B BIT(13)
#define BIT_HOST_WAKE_PAD_PULL_EN_8814B BIT(12)
#define BIT_HOST_WAKE_PAD_SL_8814B BIT(11)
#define BIT_SW_LNAON_G_SEL_DATA_8814B BIT(8)
#define BIT_SW_LNAON_A_SEL_DATA_8814B BIT(7)
#define BIT_SW_PAPE_G_SEL_DATA_8814B BIT(4)
#define BIT_SW_PAPE_A_SEL_DATA_8814B BIT(3)
#define BIT_SW_DPDT_SEL_DATA_8814B BIT(0)

/* 2 REG_WL_BT_PWR_CTRL_8814B */
#define BIT_ISO_BD2PP_8814B BIT(31)
#define BIT_LDOV12B_EN_8814B BIT(30)
#define BIT_CKEN_BTGPS_8814B BIT(29)
#define BIT_FEN_BTGPS_8814B BIT(28)
#define BIT_BTCPU_BOOTSEL_8814B BIT(27)
#define BIT_SPI_SPEEDUP_8814B BIT(26)
#define BIT_BT_SUS_8814B BIT(25)
#define BIT_DEVWAKE_PAD_TYPE_SEL_8814B BIT(24)
#define BIT_CLKREQ_PAD_TYPE_SEL_8814B BIT(23)
#define BIT_ISO_BTPON2PP_8814B BIT(22)
#define BIT_BTCOEX_CMD_8814B BIT(21)
#define BIT_BT_UART_INTF_8814B BIT(20)
#define BIT_BT_HWROF_EN_8814B BIT(19)
#define BIT_BT_FUNC_EN_8814B BIT(18)
#define BIT_BT_HWPDN_SL_8814B BIT(17)
#define BIT_BT_DISN_EN_8814B BIT(16)
#define BIT_BT_PDN_PULL_EN_8814B BIT(15)
#define BIT_WL_PDN_PULL_EN_8814B BIT(14)
#define BIT_EXTERNAL_REQUEST_PL_8814B BIT(13)
#define BIT_GPIO0_2_3_PULL_LOW_EN_8814B BIT(12)
#define BIT_ISO_BA2PP_8814B BIT(11)
#define BIT_BT_AFE_LDO_EN_8814B BIT(10)
#define BIT_BT_AFE_PLL_EN_8814B BIT(9)
#define BIT_BT_DIG_CLK_EN_8814B BIT(8)
#define BIT_UART_BRIDGE_8814B BIT(7)
#define BIT_OSC32K_CTRL_SEL_8814B BIT(6)
#define BIT_WL_DRV_EXIST_IDX_8814B BIT(5)
#define BIT_DOP_EHPAD_8814B BIT(4)
#define BIT_WL_HWROF_EN_8814B BIT(3)
#define BIT_WL_FUNC_EN_8814B BIT(2)
#define BIT_WL_HWPDN_SL_8814B BIT(1)
#define BIT_WL_HWPDN_EN_8814B BIT(0)

/* 2 REG_SDM_DEBUG_8814B */
#define BIT_BT_WAKE_DEV_EN_V1_8814B BIT(19)
#define BIT_BT_WAKE_HST_EN_V1_8814B BIT(18)
#define BIT_BT_WAKE_HST_PL_V1_8814B BIT(17)
#define BIT_BT_CLKREQ_EN_V1_8814B BIT(16)

#define BIT_SHIFT_WLCLK_PHASE_8814B 0
#define BIT_MASK_WLCLK_PHASE_8814B 0x1f
#define BIT_WLCLK_PHASE_8814B(x)                                               \
	(((x) & BIT_MASK_WLCLK_PHASE_8814B) << BIT_SHIFT_WLCLK_PHASE_8814B)
#define BITS_WLCLK_PHASE_8814B                                                 \
	(BIT_MASK_WLCLK_PHASE_8814B << BIT_SHIFT_WLCLK_PHASE_8814B)
#define BIT_CLEAR_WLCLK_PHASE_8814B(x) ((x) & (~BITS_WLCLK_PHASE_8814B))
#define BIT_GET_WLCLK_PHASE_8814B(x)                                           \
	(((x) >> BIT_SHIFT_WLCLK_PHASE_8814B) & BIT_MASK_WLCLK_PHASE_8814B)
#define BIT_SET_WLCLK_PHASE_8814B(x, v)                                        \
	(BIT_CLEAR_WLCLK_PHASE_8814B(x) | BIT_WLCLK_PHASE_8814B(v))

/* 2 REG_SYS_SDIO_CTRL_8814B */
#define BIT_DBG_GNT_WL_BT_8814B BIT(27)
#define BIT_LTE_MUX_CTRL_PATH_8814B BIT(26)
#define BIT_LTE_COEX_UART_8814B BIT(25)
#define BIT_3W_LTE_WL_GPIO_8814B BIT(24)
#define BIT_SDIO_INT_POLARITY_8814B BIT(19)
#define BIT_SDIO_INT_8814B BIT(18)
#define BIT_SDIO_OFF_EN_8814B BIT(17)
#define BIT_SDIO_ON_EN_8814B BIT(16)
#define BIT_PCIE_WAIT_TIMEOUT_EVENT_8814B BIT(10)
#define BIT_PCIE_WAIT_TIME_8814B BIT(9)
#define BIT_MPCIE_REFCLK_XTAL_SEL_8814B BIT(8)
#define BIT_BT_CLKREQ_EN_8814B BIT(6)

#define BIT_SHIFT_USB_CKREF_CML_R_8814B 4
#define BIT_MASK_USB_CKREF_CML_R_8814B 0x3
#define BIT_USB_CKREF_CML_R_8814B(x)                                           \
	(((x) & BIT_MASK_USB_CKREF_CML_R_8814B)                                \
	 << BIT_SHIFT_USB_CKREF_CML_R_8814B)
#define BITS_USB_CKREF_CML_R_8814B                                             \
	(BIT_MASK_USB_CKREF_CML_R_8814B << BIT_SHIFT_USB_CKREF_CML_R_8814B)
#define BIT_CLEAR_USB_CKREF_CML_R_8814B(x) ((x) & (~BITS_USB_CKREF_CML_R_8814B))
#define BIT_GET_USB_CKREF_CML_R_8814B(x)                                       \
	(((x) >> BIT_SHIFT_USB_CKREF_CML_R_8814B) &                            \
	 BIT_MASK_USB_CKREF_CML_R_8814B)
#define BIT_SET_USB_CKREF_CML_R_8814B(x, v)                                    \
	(BIT_CLEAR_USB_CKREF_CML_R_8814B(x) | BIT_USB_CKREF_CML_R_8814B(v))

#define BIT_SHIFT_USB_CKREF_D2S_I_8814B 2
#define BIT_MASK_USB_CKREF_D2S_I_8814B 0x3
#define BIT_USB_CKREF_D2S_I_8814B(x)                                           \
	(((x) & BIT_MASK_USB_CKREF_D2S_I_8814B)                                \
	 << BIT_SHIFT_USB_CKREF_D2S_I_8814B)
#define BITS_USB_CKREF_D2S_I_8814B                                             \
	(BIT_MASK_USB_CKREF_D2S_I_8814B << BIT_SHIFT_USB_CKREF_D2S_I_8814B)
#define BIT_CLEAR_USB_CKREF_D2S_I_8814B(x) ((x) & (~BITS_USB_CKREF_D2S_I_8814B))
#define BIT_GET_USB_CKREF_D2S_I_8814B(x)                                       \
	(((x) >> BIT_SHIFT_USB_CKREF_D2S_I_8814B) &                            \
	 BIT_MASK_USB_CKREF_D2S_I_8814B)
#define BIT_SET_USB_CKREF_D2S_I_8814B(x, v)                                    \
	(BIT_CLEAR_USB_CKREF_D2S_I_8814B(x) | BIT_USB_CKREF_D2S_I_8814B(v))

#define BIT_RES_USB_MASS_STORAGE_DESC_8814B BIT(1)
#define BIT_USB_WAIT_TIME_8814B BIT(0)

/* 2 REG_HCI_OPT_CTRL_8814B */

#define BIT_SHIFT_TSFT_SEL_8814B 29
#define BIT_MASK_TSFT_SEL_8814B 0x7
#define BIT_TSFT_SEL_8814B(x)                                                  \
	(((x) & BIT_MASK_TSFT_SEL_8814B) << BIT_SHIFT_TSFT_SEL_8814B)
#define BITS_TSFT_SEL_8814B                                                    \
	(BIT_MASK_TSFT_SEL_8814B << BIT_SHIFT_TSFT_SEL_8814B)
#define BIT_CLEAR_TSFT_SEL_8814B(x) ((x) & (~BITS_TSFT_SEL_8814B))
#define BIT_GET_TSFT_SEL_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TSFT_SEL_8814B) & BIT_MASK_TSFT_SEL_8814B)
#define BIT_SET_TSFT_SEL_8814B(x, v)                                           \
	(BIT_CLEAR_TSFT_SEL_8814B(x) | BIT_TSFT_SEL_8814B(v))

#define BIT_TSFT_BAND_SEL_8814B BIT(28)
#define BIT_USB_HOST_PWR_OFF_EN_8814B BIT(12)
#define BIT_SYM_LPS_BLOCK_EN_8814B BIT(11)
#define BIT_USB_LPM_ACT_EN_8814B BIT(10)
#define BIT_USB_LPM_NY_8814B BIT(9)
#define BIT_USB_SUS_DIS_8814B BIT(8)

#define BIT_SHIFT_SDIO_PAD_E_8814B 5
#define BIT_MASK_SDIO_PAD_E_8814B 0x7
#define BIT_SDIO_PAD_E_8814B(x)                                                \
	(((x) & BIT_MASK_SDIO_PAD_E_8814B) << BIT_SHIFT_SDIO_PAD_E_8814B)
#define BITS_SDIO_PAD_E_8814B                                                  \
	(BIT_MASK_SDIO_PAD_E_8814B << BIT_SHIFT_SDIO_PAD_E_8814B)
#define BIT_CLEAR_SDIO_PAD_E_8814B(x) ((x) & (~BITS_SDIO_PAD_E_8814B))
#define BIT_GET_SDIO_PAD_E_8814B(x)                                            \
	(((x) >> BIT_SHIFT_SDIO_PAD_E_8814B) & BIT_MASK_SDIO_PAD_E_8814B)
#define BIT_SET_SDIO_PAD_E_8814B(x, v)                                         \
	(BIT_CLEAR_SDIO_PAD_E_8814B(x) | BIT_SDIO_PAD_E_8814B(v))

#define BIT_USB_LPPLL_EN_8814B BIT(4)
#define BIT_ROP_SW15_8814B BIT(2)
#define BIT_PCI_CKRDY_OPT_8814B BIT(1)
#define BIT_PCI_VAUX_EN_8814B BIT(0)

/* 2 REG_AFE_CTRL4_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_LDO_SWR_CTRL_8814B */
#define BIT_ZCD_HW_AUTO_EN_8814B BIT(27)
#define BIT_ZCD_REGSEL_8814B BIT(26)

#define BIT_SHIFT_AUTO_ZCD_IN_CODE_8814B 21
#define BIT_MASK_AUTO_ZCD_IN_CODE_8814B 0x1f
#define BIT_AUTO_ZCD_IN_CODE_8814B(x)                                          \
	(((x) & BIT_MASK_AUTO_ZCD_IN_CODE_8814B)                               \
	 << BIT_SHIFT_AUTO_ZCD_IN_CODE_8814B)
#define BITS_AUTO_ZCD_IN_CODE_8814B                                            \
	(BIT_MASK_AUTO_ZCD_IN_CODE_8814B << BIT_SHIFT_AUTO_ZCD_IN_CODE_8814B)
#define BIT_CLEAR_AUTO_ZCD_IN_CODE_8814B(x)                                    \
	((x) & (~BITS_AUTO_ZCD_IN_CODE_8814B))
#define BIT_GET_AUTO_ZCD_IN_CODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_AUTO_ZCD_IN_CODE_8814B) &                           \
	 BIT_MASK_AUTO_ZCD_IN_CODE_8814B)
#define BIT_SET_AUTO_ZCD_IN_CODE_8814B(x, v)                                   \
	(BIT_CLEAR_AUTO_ZCD_IN_CODE_8814B(x) | BIT_AUTO_ZCD_IN_CODE_8814B(v))

#define BIT_SHIFT_ZCD_CODE_IN_L_8814B 16
#define BIT_MASK_ZCD_CODE_IN_L_8814B 0x1f
#define BIT_ZCD_CODE_IN_L_8814B(x)                                             \
	(((x) & BIT_MASK_ZCD_CODE_IN_L_8814B) << BIT_SHIFT_ZCD_CODE_IN_L_8814B)
#define BITS_ZCD_CODE_IN_L_8814B                                               \
	(BIT_MASK_ZCD_CODE_IN_L_8814B << BIT_SHIFT_ZCD_CODE_IN_L_8814B)
#define BIT_CLEAR_ZCD_CODE_IN_L_8814B(x) ((x) & (~BITS_ZCD_CODE_IN_L_8814B))
#define BIT_GET_ZCD_CODE_IN_L_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ZCD_CODE_IN_L_8814B) & BIT_MASK_ZCD_CODE_IN_L_8814B)
#define BIT_SET_ZCD_CODE_IN_L_8814B(x, v)                                      \
	(BIT_CLEAR_ZCD_CODE_IN_L_8814B(x) | BIT_ZCD_CODE_IN_L_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_MCUFW_CTRL_8814B */

#define BIT_SHIFT_RPWM_8814B 24
#define BIT_MASK_RPWM_8814B 0xff
#define BIT_RPWM_8814B(x) (((x) & BIT_MASK_RPWM_8814B) << BIT_SHIFT_RPWM_8814B)
#define BITS_RPWM_8814B (BIT_MASK_RPWM_8814B << BIT_SHIFT_RPWM_8814B)
#define BIT_CLEAR_RPWM_8814B(x) ((x) & (~BITS_RPWM_8814B))
#define BIT_GET_RPWM_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_RPWM_8814B) & BIT_MASK_RPWM_8814B)
#define BIT_SET_RPWM_8814B(x, v) (BIT_CLEAR_RPWM_8814B(x) | BIT_RPWM_8814B(v))

#define BIT_ANA_PORT_EN_8814B BIT(22)
#define BIT_MAC_PORT_EN_8814B BIT(21)
#define BIT_BOOT_FSPI_EN_8814B BIT(20)
#define BIT_ROM_DLEN_8814B BIT(19)

#define BIT_SHIFT_ROM_PGE_8814B 16
#define BIT_MASK_ROM_PGE_8814B 0x7
#define BIT_ROM_PGE_8814B(x)                                                   \
	(((x) & BIT_MASK_ROM_PGE_8814B) << BIT_SHIFT_ROM_PGE_8814B)
#define BITS_ROM_PGE_8814B (BIT_MASK_ROM_PGE_8814B << BIT_SHIFT_ROM_PGE_8814B)
#define BIT_CLEAR_ROM_PGE_8814B(x) ((x) & (~BITS_ROM_PGE_8814B))
#define BIT_GET_ROM_PGE_8814B(x)                                               \
	(((x) >> BIT_SHIFT_ROM_PGE_8814B) & BIT_MASK_ROM_PGE_8814B)
#define BIT_SET_ROM_PGE_8814B(x, v)                                            \
	(BIT_CLEAR_ROM_PGE_8814B(x) | BIT_ROM_PGE_8814B(v))

#define BIT_FW_INIT_RDY_8814B BIT(15)
#define BIT_FW_DW_RDY_8814B BIT(14)

#define BIT_SHIFT_CPU_CLK_SEL_8814B 12
#define BIT_MASK_CPU_CLK_SEL_8814B 0x3
#define BIT_CPU_CLK_SEL_8814B(x)                                               \
	(((x) & BIT_MASK_CPU_CLK_SEL_8814B) << BIT_SHIFT_CPU_CLK_SEL_8814B)
#define BITS_CPU_CLK_SEL_8814B                                                 \
	(BIT_MASK_CPU_CLK_SEL_8814B << BIT_SHIFT_CPU_CLK_SEL_8814B)
#define BIT_CLEAR_CPU_CLK_SEL_8814B(x) ((x) & (~BITS_CPU_CLK_SEL_8814B))
#define BIT_GET_CPU_CLK_SEL_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CPU_CLK_SEL_8814B) & BIT_MASK_CPU_CLK_SEL_8814B)
#define BIT_SET_CPU_CLK_SEL_8814B(x, v)                                        \
	(BIT_CLEAR_CPU_CLK_SEL_8814B(x) | BIT_CPU_CLK_SEL_8814B(v))

#define BIT_CCLK_CHG_MASK_8814B BIT(11)
#define BIT_EMEM__TXBUF_CHKSUM_OK_8814B BIT(10)
#define BIT_EMEM_TXBUF_DW_RDY_8814B BIT(9)
#define BIT_EMEM_CHKSUM_OK_8814B BIT(8)
#define BIT_EMEM_DW_OK_8814B BIT(7)
#define BIT_DMEM_CHKSUM_OK_8814B BIT(6)
#define BIT_DMEM_DW_OK_8814B BIT(5)
#define BIT_IMEM_CHKSUM_OK_8814B BIT(4)
#define BIT_IMEM_DW_OK_8814B BIT(3)
#define BIT_IMEM_BOOT_LOAD_CHKSUM_OK_8814B BIT(2)
#define BIT_IMEM_BOOT_LOAD_DW_OK_8814B BIT(1)
#define BIT_MCUFWDL_EN_8814B BIT(0)

/* 2 REG_MCU_TST_CFG_8814B */

#define BIT_SHIFT_C2H_MSG_8814B 0
#define BIT_MASK_C2H_MSG_8814B 0xffff
#define BIT_C2H_MSG_8814B(x)                                                   \
	(((x) & BIT_MASK_C2H_MSG_8814B) << BIT_SHIFT_C2H_MSG_8814B)
#define BITS_C2H_MSG_8814B (BIT_MASK_C2H_MSG_8814B << BIT_SHIFT_C2H_MSG_8814B)
#define BIT_CLEAR_C2H_MSG_8814B(x) ((x) & (~BITS_C2H_MSG_8814B))
#define BIT_GET_C2H_MSG_8814B(x)                                               \
	(((x) >> BIT_SHIFT_C2H_MSG_8814B) & BIT_MASK_C2H_MSG_8814B)
#define BIT_SET_C2H_MSG_8814B(x, v)                                            \
	(BIT_CLEAR_C2H_MSG_8814B(x) | BIT_C2H_MSG_8814B(v))

/* 2 REG_HMEBOX_E0_E1_8814B */

#define BIT_SHIFT_HOST_MSG_E1_8814B 16
#define BIT_MASK_HOST_MSG_E1_8814B 0xffff
#define BIT_HOST_MSG_E1_8814B(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E1_8814B) << BIT_SHIFT_HOST_MSG_E1_8814B)
#define BITS_HOST_MSG_E1_8814B                                                 \
	(BIT_MASK_HOST_MSG_E1_8814B << BIT_SHIFT_HOST_MSG_E1_8814B)
#define BIT_CLEAR_HOST_MSG_E1_8814B(x) ((x) & (~BITS_HOST_MSG_E1_8814B))
#define BIT_GET_HOST_MSG_E1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E1_8814B) & BIT_MASK_HOST_MSG_E1_8814B)
#define BIT_SET_HOST_MSG_E1_8814B(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E1_8814B(x) | BIT_HOST_MSG_E1_8814B(v))

#define BIT_SHIFT_HOST_MSG_E0_8814B 0
#define BIT_MASK_HOST_MSG_E0_8814B 0xffff
#define BIT_HOST_MSG_E0_8814B(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E0_8814B) << BIT_SHIFT_HOST_MSG_E0_8814B)
#define BITS_HOST_MSG_E0_8814B                                                 \
	(BIT_MASK_HOST_MSG_E0_8814B << BIT_SHIFT_HOST_MSG_E0_8814B)
#define BIT_CLEAR_HOST_MSG_E0_8814B(x) ((x) & (~BITS_HOST_MSG_E0_8814B))
#define BIT_GET_HOST_MSG_E0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E0_8814B) & BIT_MASK_HOST_MSG_E0_8814B)
#define BIT_SET_HOST_MSG_E0_8814B(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E0_8814B(x) | BIT_HOST_MSG_E0_8814B(v))

/* 2 REG_HMEBOX_E2_E3_8814B */

#define BIT_SHIFT_HOST_MSG_E3_8814B 16
#define BIT_MASK_HOST_MSG_E3_8814B 0xffff
#define BIT_HOST_MSG_E3_8814B(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E3_8814B) << BIT_SHIFT_HOST_MSG_E3_8814B)
#define BITS_HOST_MSG_E3_8814B                                                 \
	(BIT_MASK_HOST_MSG_E3_8814B << BIT_SHIFT_HOST_MSG_E3_8814B)
#define BIT_CLEAR_HOST_MSG_E3_8814B(x) ((x) & (~BITS_HOST_MSG_E3_8814B))
#define BIT_GET_HOST_MSG_E3_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E3_8814B) & BIT_MASK_HOST_MSG_E3_8814B)
#define BIT_SET_HOST_MSG_E3_8814B(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E3_8814B(x) | BIT_HOST_MSG_E3_8814B(v))

#define BIT_SHIFT_HOST_MSG_E2_8814B 0
#define BIT_MASK_HOST_MSG_E2_8814B 0xffff
#define BIT_HOST_MSG_E2_8814B(x)                                               \
	(((x) & BIT_MASK_HOST_MSG_E2_8814B) << BIT_SHIFT_HOST_MSG_E2_8814B)
#define BITS_HOST_MSG_E2_8814B                                                 \
	(BIT_MASK_HOST_MSG_E2_8814B << BIT_SHIFT_HOST_MSG_E2_8814B)
#define BIT_CLEAR_HOST_MSG_E2_8814B(x) ((x) & (~BITS_HOST_MSG_E2_8814B))
#define BIT_GET_HOST_MSG_E2_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HOST_MSG_E2_8814B) & BIT_MASK_HOST_MSG_E2_8814B)
#define BIT_SET_HOST_MSG_E2_8814B(x, v)                                        \
	(BIT_CLEAR_HOST_MSG_E2_8814B(x) | BIT_HOST_MSG_E2_8814B(v))

/* 2 REG_WLLPS_CTRL_8814B */
#define BIT_WLLPSOP_EABM_8814B BIT(31)
#define BIT_WLLPSOP_ACKF_8814B BIT(30)
#define BIT_WLLPSOP_DLDM_8814B BIT(29)
#define BIT_WLLPSOP_ESWR_8814B BIT(28)
#define BIT_WLLPSOP_PWMM_8814B BIT(27)
#define BIT_WLLPSOP_EECK_8814B BIT(26)
#define BIT_WLLPSOP_WLMACOFF_8814B BIT(25)
#define BIT_WLLPSOP_EXTAL_8814B BIT(24)
#define BIT_WL_SYNPON_VOLTSPDN_8814B BIT(23)
#define BIT_WLLPSOP_WLBBOFF_8814B BIT(22)
#define BIT_WLLPSOP_WLMEM_DS_8814B BIT(21)

#define BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8814B 12
#define BIT_MASK_LPLDH12_VADJ_STEP_DN_8814B 0xf
#define BIT_LPLDH12_VADJ_STEP_DN_8814B(x)                                      \
	(((x) & BIT_MASK_LPLDH12_VADJ_STEP_DN_8814B)                           \
	 << BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8814B)
#define BITS_LPLDH12_VADJ_STEP_DN_8814B                                        \
	(BIT_MASK_LPLDH12_VADJ_STEP_DN_8814B                                   \
	 << BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8814B)
#define BIT_CLEAR_LPLDH12_VADJ_STEP_DN_8814B(x)                                \
	((x) & (~BITS_LPLDH12_VADJ_STEP_DN_8814B))
#define BIT_GET_LPLDH12_VADJ_STEP_DN_8814B(x)                                  \
	(((x) >> BIT_SHIFT_LPLDH12_VADJ_STEP_DN_8814B) &                       \
	 BIT_MASK_LPLDH12_VADJ_STEP_DN_8814B)
#define BIT_SET_LPLDH12_VADJ_STEP_DN_8814B(x, v)                               \
	(BIT_CLEAR_LPLDH12_VADJ_STEP_DN_8814B(x) |                             \
	 BIT_LPLDH12_VADJ_STEP_DN_8814B(v))

#define BIT_SHIFT_V15ADJ_L1_STEP_DN_8814B 8
#define BIT_MASK_V15ADJ_L1_STEP_DN_8814B 0x7
#define BIT_V15ADJ_L1_STEP_DN_8814B(x)                                         \
	(((x) & BIT_MASK_V15ADJ_L1_STEP_DN_8814B)                              \
	 << BIT_SHIFT_V15ADJ_L1_STEP_DN_8814B)
#define BITS_V15ADJ_L1_STEP_DN_8814B                                           \
	(BIT_MASK_V15ADJ_L1_STEP_DN_8814B << BIT_SHIFT_V15ADJ_L1_STEP_DN_8814B)
#define BIT_CLEAR_V15ADJ_L1_STEP_DN_8814B(x)                                   \
	((x) & (~BITS_V15ADJ_L1_STEP_DN_8814B))
#define BIT_GET_V15ADJ_L1_STEP_DN_8814B(x)                                     \
	(((x) >> BIT_SHIFT_V15ADJ_L1_STEP_DN_8814B) &                          \
	 BIT_MASK_V15ADJ_L1_STEP_DN_8814B)
#define BIT_SET_V15ADJ_L1_STEP_DN_8814B(x, v)                                  \
	(BIT_CLEAR_V15ADJ_L1_STEP_DN_8814B(x) | BIT_V15ADJ_L1_STEP_DN_8814B(v))

#define BIT_REGU_32K_CLK_EN_8814B BIT(1)
#define BIT_WL_LPS_EN_8814B BIT(0)

/* 2 REG_AFE_CTRL5_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_GPIO_DEBOUNCE_CTRL_8814B */
#define BIT_WLGP_DBC1EN_8814B BIT(15)

#define BIT_SHIFT_WLGP_DBC1_8814B 8
#define BIT_MASK_WLGP_DBC1_8814B 0xf
#define BIT_WLGP_DBC1_8814B(x)                                                 \
	(((x) & BIT_MASK_WLGP_DBC1_8814B) << BIT_SHIFT_WLGP_DBC1_8814B)
#define BITS_WLGP_DBC1_8814B                                                   \
	(BIT_MASK_WLGP_DBC1_8814B << BIT_SHIFT_WLGP_DBC1_8814B)
#define BIT_CLEAR_WLGP_DBC1_8814B(x) ((x) & (~BITS_WLGP_DBC1_8814B))
#define BIT_GET_WLGP_DBC1_8814B(x)                                             \
	(((x) >> BIT_SHIFT_WLGP_DBC1_8814B) & BIT_MASK_WLGP_DBC1_8814B)
#define BIT_SET_WLGP_DBC1_8814B(x, v)                                          \
	(BIT_CLEAR_WLGP_DBC1_8814B(x) | BIT_WLGP_DBC1_8814B(v))

#define BIT_WLGP_DBC0EN_8814B BIT(7)

#define BIT_SHIFT_WLGP_DBC0_8814B 0
#define BIT_MASK_WLGP_DBC0_8814B 0xf
#define BIT_WLGP_DBC0_8814B(x)                                                 \
	(((x) & BIT_MASK_WLGP_DBC0_8814B) << BIT_SHIFT_WLGP_DBC0_8814B)
#define BITS_WLGP_DBC0_8814B                                                   \
	(BIT_MASK_WLGP_DBC0_8814B << BIT_SHIFT_WLGP_DBC0_8814B)
#define BIT_CLEAR_WLGP_DBC0_8814B(x) ((x) & (~BITS_WLGP_DBC0_8814B))
#define BIT_GET_WLGP_DBC0_8814B(x)                                             \
	(((x) >> BIT_SHIFT_WLGP_DBC0_8814B) & BIT_MASK_WLGP_DBC0_8814B)
#define BIT_SET_WLGP_DBC0_8814B(x, v)                                          \
	(BIT_CLEAR_WLGP_DBC0_8814B(x) | BIT_WLGP_DBC0_8814B(v))

/* 2 REG_RPWM2_8814B */

#define BIT_SHIFT_RPWM2_8814B 16
#define BIT_MASK_RPWM2_8814B 0xffff
#define BIT_RPWM2_8814B(x)                                                     \
	(((x) & BIT_MASK_RPWM2_8814B) << BIT_SHIFT_RPWM2_8814B)
#define BITS_RPWM2_8814B (BIT_MASK_RPWM2_8814B << BIT_SHIFT_RPWM2_8814B)
#define BIT_CLEAR_RPWM2_8814B(x) ((x) & (~BITS_RPWM2_8814B))
#define BIT_GET_RPWM2_8814B(x)                                                 \
	(((x) >> BIT_SHIFT_RPWM2_8814B) & BIT_MASK_RPWM2_8814B)
#define BIT_SET_RPWM2_8814B(x, v)                                              \
	(BIT_CLEAR_RPWM2_8814B(x) | BIT_RPWM2_8814B(v))

/* 2 REG_SYSON_FSM_MON_8814B */

#define BIT_SHIFT_FSM_MON_SEL_8814B 24
#define BIT_MASK_FSM_MON_SEL_8814B 0x7
#define BIT_FSM_MON_SEL_8814B(x)                                               \
	(((x) & BIT_MASK_FSM_MON_SEL_8814B) << BIT_SHIFT_FSM_MON_SEL_8814B)
#define BITS_FSM_MON_SEL_8814B                                                 \
	(BIT_MASK_FSM_MON_SEL_8814B << BIT_SHIFT_FSM_MON_SEL_8814B)
#define BIT_CLEAR_FSM_MON_SEL_8814B(x) ((x) & (~BITS_FSM_MON_SEL_8814B))
#define BIT_GET_FSM_MON_SEL_8814B(x)                                           \
	(((x) >> BIT_SHIFT_FSM_MON_SEL_8814B) & BIT_MASK_FSM_MON_SEL_8814B)
#define BIT_SET_FSM_MON_SEL_8814B(x, v)                                        \
	(BIT_CLEAR_FSM_MON_SEL_8814B(x) | BIT_FSM_MON_SEL_8814B(v))

#define BIT_DOP_ELDO_8814B BIT(23)
#define BIT_FSM_MON_UPD_8814B BIT(15)

#define BIT_SHIFT_FSM_PAR_8814B 0
#define BIT_MASK_FSM_PAR_8814B 0x7fff
#define BIT_FSM_PAR_8814B(x)                                                   \
	(((x) & BIT_MASK_FSM_PAR_8814B) << BIT_SHIFT_FSM_PAR_8814B)
#define BITS_FSM_PAR_8814B (BIT_MASK_FSM_PAR_8814B << BIT_SHIFT_FSM_PAR_8814B)
#define BIT_CLEAR_FSM_PAR_8814B(x) ((x) & (~BITS_FSM_PAR_8814B))
#define BIT_GET_FSM_PAR_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FSM_PAR_8814B) & BIT_MASK_FSM_PAR_8814B)
#define BIT_SET_FSM_PAR_8814B(x, v)                                            \
	(BIT_CLEAR_FSM_PAR_8814B(x) | BIT_FSM_PAR_8814B(v))

/* 2 REG_AFE_CTRL6_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_PMC_DBG_CTRL1_8814B */
#define BIT_BT_INT_EN_8814B BIT(31)

#define BIT_SHIFT_RD_WR_WIFI_BT_INFO_8814B 16
#define BIT_MASK_RD_WR_WIFI_BT_INFO_8814B 0x7fff
#define BIT_RD_WR_WIFI_BT_INFO_8814B(x)                                        \
	(((x) & BIT_MASK_RD_WR_WIFI_BT_INFO_8814B)                             \
	 << BIT_SHIFT_RD_WR_WIFI_BT_INFO_8814B)
#define BITS_RD_WR_WIFI_BT_INFO_8814B                                          \
	(BIT_MASK_RD_WR_WIFI_BT_INFO_8814B                                     \
	 << BIT_SHIFT_RD_WR_WIFI_BT_INFO_8814B)
#define BIT_CLEAR_RD_WR_WIFI_BT_INFO_8814B(x)                                  \
	((x) & (~BITS_RD_WR_WIFI_BT_INFO_8814B))
#define BIT_GET_RD_WR_WIFI_BT_INFO_8814B(x)                                    \
	(((x) >> BIT_SHIFT_RD_WR_WIFI_BT_INFO_8814B) &                         \
	 BIT_MASK_RD_WR_WIFI_BT_INFO_8814B)
#define BIT_SET_RD_WR_WIFI_BT_INFO_8814B(x, v)                                 \
	(BIT_CLEAR_RD_WR_WIFI_BT_INFO_8814B(x) |                               \
	 BIT_RD_WR_WIFI_BT_INFO_8814B(v))

#define BIT_PMC_WR_OVF_8814B BIT(8)

#define BIT_SHIFT_WLPMC_ERRINT_8814B 0
#define BIT_MASK_WLPMC_ERRINT_8814B 0xff
#define BIT_WLPMC_ERRINT_8814B(x)                                              \
	(((x) & BIT_MASK_WLPMC_ERRINT_8814B) << BIT_SHIFT_WLPMC_ERRINT_8814B)
#define BITS_WLPMC_ERRINT_8814B                                                \
	(BIT_MASK_WLPMC_ERRINT_8814B << BIT_SHIFT_WLPMC_ERRINT_8814B)
#define BIT_CLEAR_WLPMC_ERRINT_8814B(x) ((x) & (~BITS_WLPMC_ERRINT_8814B))
#define BIT_GET_WLPMC_ERRINT_8814B(x)                                          \
	(((x) >> BIT_SHIFT_WLPMC_ERRINT_8814B) & BIT_MASK_WLPMC_ERRINT_8814B)
#define BIT_SET_WLPMC_ERRINT_8814B(x, v)                                       \
	(BIT_CLEAR_WLPMC_ERRINT_8814B(x) | BIT_WLPMC_ERRINT_8814B(v))

/* 2 REG_AFE_CTRL7_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HIMR0_8814B */
#define BIT_PSTIMER_2_MSK_8814B BIT(31)
#define BIT_PSTIMER_1_MSK_8814B BIT(30)
#define BIT_PSTIMER_0_MSK_8814B BIT(29)
#define BIT_GTINT4_MSK_8814B BIT(28)
#define BIT_GTINT3_MSK_8814B BIT(27)
#define BIT_TXBCN0ERR_MSK_8814B BIT(26)
#define BIT_TXBCN0OK_MSK_8814B BIT(25)
#define BIT_TSF_BIT32_TOGGLE_MSK_8814B BIT(24)
#define BIT_TXDMA_START_INT_MSK_8814B BIT(23)
#define BIT_TXDMA_STOP_INT_MSK_8814B BIT(22)
#define BIT_HISR7_IND_MSK_8814B BIT(21)
#define BIT_BCNDMAINT0_MSK_8814B BIT(20)
#define BIT_HISR6_IND_MSK_8814B BIT(19)
#define BIT_HISR5_IND_MSK_8814B BIT(18)
#define BIT_HISR4_IND_MSK_8814B BIT(17)
#define BIT_BCNDERR0_MSK_8814B BIT(16)
#define BIT_HSISR_IND_ON_INT_MSK_8814B BIT(15)
#define BIT_HISR3_IND_MSK_8814B BIT(14)
#define BIT_HISR2_IND_MSK_8814B BIT(13)

/* 2 REG_NOT_VALID_8814B */
#define BIT_HISR1_IND_MSK_8814B BIT(11)
#define BIT_C2HCMD_MSK_8814B BIT(10)
#define BIT_CPWM2_MSK_8814B BIT(9)
#define BIT_CPWM_MSK_8814B BIT(8)
#define BIT_TXDMAOK_CHANNEL15_MSK_8814B BIT(7)
#define BIT_TXDMAOK_CHANNEL14_MSK_8814B BIT(6)
#define BIT_TXDMAOK_CHANNEL3_MSK_8814B BIT(5)
#define BIT_TXDMAOK_CHANNEL2_MSK_8814B BIT(4)
#define BIT_TXDMAOK_CHANNEL1_MSK_8814B BIT(3)
#define BIT_TXDMAOK_CHANNEL0_MSK_8814B BIT(2)
#define BIT_RDU_MSK_8814B BIT(1)
#define BIT_RXOK_MSK_8814B BIT(0)

/* 2 REG_HISR0_8814B */
#define BIT_PSTIMER_2_8814B BIT(31)
#define BIT_PSTIMER_1_8814B BIT(30)
#define BIT_PSTIMER_0_8814B BIT(29)
#define BIT_GTINT4_8814B BIT(28)
#define BIT_GTINT3_8814B BIT(27)
#define BIT_TXBCN0ERR_8814B BIT(26)
#define BIT_TXBCN0OK_8814B BIT(25)
#define BIT_TSF_BIT32_TOGGLE_8814B BIT(24)
#define BIT_TXDMA_START_INT_8814B BIT(23)
#define BIT_TXDMA_STOP_INT_8814B BIT(22)
#define BIT_HISR7_IND_8814B BIT(21)
#define BIT_BCNDMAINT0_8814B BIT(20)
#define BIT_HISR6_IND_8814B BIT(19)
#define BIT_HISR5_IND_8814B BIT(18)
#define BIT_HISR4_IND_8814B BIT(17)
#define BIT_BCNDERR0_8814B BIT(16)
#define BIT_HSISR_IND_ON_INT_8814B BIT(15)
#define BIT_HISR3_IND_8814B BIT(14)
#define BIT_HISR2_IND_8814B BIT(13)

/* 2 REG_NOT_VALID_8814B */
#define BIT_HISR1_IND_8814B BIT(11)
#define BIT_C2HCMD_8814B BIT(10)
#define BIT_CPWM2_8814B BIT(9)
#define BIT_CPWM_8814B BIT(8)
#define BIT_TXDMAOK_CHANNEL15_8814B BIT(7)
#define BIT_TXDMAOK_CHANNEL14_8814B BIT(6)
#define BIT_TXDMAOK_CHANNEL3_8814B BIT(5)
#define BIT_TXDMAOK_CHANNEL2_8814B BIT(4)
#define BIT_TXDMAOK_CHANNEL1_8814B BIT(3)
#define BIT_TXDMAOK_CHANNEL0_8814B BIT(2)
#define BIT_RDU_8814B BIT(1)
#define BIT_RXOK_8814B BIT(0)

/* 2 REG_HIMR1_8814B */
#define BIT_PRE_TX_ERR_INT_MSK_8814B BIT(31)
#define BIT_TXFIFO_TH_INT_8814B BIT(30)
#define BIT_BTON_STS_UPDATE_MASK_8814B BIT(29)
#define BIT_BCNDMAINT7__MSK_8814B BIT(27)
#define BIT_BCNDMAINT6__MSK_8814B BIT(26)
#define BIT_BCNDMAINT5__MSK_8814B BIT(25)
#define BIT_BCNDMAINT4__MSK_8814B BIT(24)
#define BIT_BCNDMAINT3_MSK_8814B BIT(23)
#define BIT_BCNDMAINT2_MSK_8814B BIT(22)
#define BIT_BCNDMAINT1_MSK_8814B BIT(21)
#define BIT_BCNDERR7_MSK_8814B BIT(20)
#define BIT_BCNDERR6_MSK_8814B BIT(19)
#define BIT_BCNDERR5_MSK_8814B BIT(18)
#define BIT_BCNDERR4_MSK_8814B BIT(17)
#define BIT_BCNDERR3_MSK_8814B BIT(16)
#define BIT_BCNDERR2_MSK_8814B BIT(15)
#define BIT_BCNDERR1_MSK_8814B BIT(14)
#define BIT_ATIMEND__MSK_8814B BIT(12)
#define BIT_TXERR_MSK_8814B BIT(11)
#define BIT_RXERR_MSK_8814B BIT(10)
#define BIT_TXFOVW_MSK_8814B BIT(9)
#define BIT_FOVW_MSK_8814B BIT(8)
#define BIT_CPU_MGQ_EARLY_INT_MSK_8814B BIT(6)
#define BIT_CPU_MGQ_TXDONE_MSK_8814B BIT(5)
#define BIT_PSTIMER_5_MSK_8814B BIT(4)
#define BIT_PSTIMER_4_MSK_8814B BIT(3)
#define BIT_PSTIMER_3_MSK_8814B BIT(2)
#define BIT_CPUMGQ_TX_TIMER_MSK_8814B BIT(1)
#define BIT_BB_STOPRX_INT_MSK_8814B BIT(0)

/* 2 REG_HISR1_8814B */
#define BIT_PRE_TX_ERR_INT_8814B BIT(31)
#define BIT_TXFIFO_TH_INT_8814B BIT(30)
#define BIT_BTON_STS_UPDATE_INT_8814B BIT(29)
#define BIT_BCNDMAINT7_8814B BIT(27)
#define BIT_BCNDMAINT6_8814B BIT(26)
#define BIT_BCNDMAINT5_8814B BIT(25)
#define BIT_BCNDMAINT4_8814B BIT(24)
#define BIT_BCNDMAINT3_8814B BIT(23)
#define BIT_BCNDMAINT2_8814B BIT(22)
#define BIT_BCNDMAINT1_8814B BIT(21)
#define BIT_BCNDERR7_8814B BIT(20)
#define BIT_BCNDERR6_8814B BIT(19)
#define BIT_BCNDERR5_8814B BIT(18)
#define BIT_BCNDERR4_8814B BIT(17)
#define BIT_BCNDERR3_8814B BIT(16)
#define BIT_BCNDERR2_8814B BIT(15)
#define BIT_BCNDERR1_8814B BIT(14)
#define BIT_ATIMEND_8814B BIT(12)
#define BIT_TXERR_INT_8814B BIT(11)
#define BIT_RXERR_INT_8814B BIT(10)
#define BIT_TXFOVW_8814B BIT(9)
#define BIT_FOVW_8814B BIT(8)

/* 2 REG_NOT_VALID_8814B */
#define BIT_CPU_MGQ_EARLY_INT_8814B BIT(6)
#define BIT_CPU_MGQ_TXDONE_8814B BIT(5)
#define BIT_PSTIMER_5_8814B BIT(4)
#define BIT_PSTIMER_4_8814B BIT(3)
#define BIT_PSTIMER_3_8814B BIT(2)
#define BIT_CPUMGQ_TX_TIMER_8814B BIT(1)
#define BIT_BB_STOPRX_INT_8814B BIT(0)

/* 2 REG_DBG_PORT_SEL_8814B */

#define BIT_SHIFT_DEBUG_ST_8814B 0
#define BIT_MASK_DEBUG_ST_8814B 0xffffffffL
#define BIT_DEBUG_ST_8814B(x)                                                  \
	(((x) & BIT_MASK_DEBUG_ST_8814B) << BIT_SHIFT_DEBUG_ST_8814B)
#define BITS_DEBUG_ST_8814B                                                    \
	(BIT_MASK_DEBUG_ST_8814B << BIT_SHIFT_DEBUG_ST_8814B)
#define BIT_CLEAR_DEBUG_ST_8814B(x) ((x) & (~BITS_DEBUG_ST_8814B))
#define BIT_GET_DEBUG_ST_8814B(x)                                              \
	(((x) >> BIT_SHIFT_DEBUG_ST_8814B) & BIT_MASK_DEBUG_ST_8814B)
#define BIT_SET_DEBUG_ST_8814B(x, v)                                           \
	(BIT_CLEAR_DEBUG_ST_8814B(x) | BIT_DEBUG_ST_8814B(v))

/* 2 REG_PAD_CTRL2_8814B */
#define BIT_USB3_USB2_TRANSITION_8814B BIT(20)

#define BIT_SHIFT_USB23_SW_MODE_V1_8814B 18
#define BIT_MASK_USB23_SW_MODE_V1_8814B 0x3
#define BIT_USB23_SW_MODE_V1_8814B(x)                                          \
	(((x) & BIT_MASK_USB23_SW_MODE_V1_8814B)                               \
	 << BIT_SHIFT_USB23_SW_MODE_V1_8814B)
#define BITS_USB23_SW_MODE_V1_8814B                                            \
	(BIT_MASK_USB23_SW_MODE_V1_8814B << BIT_SHIFT_USB23_SW_MODE_V1_8814B)
#define BIT_CLEAR_USB23_SW_MODE_V1_8814B(x)                                    \
	((x) & (~BITS_USB23_SW_MODE_V1_8814B))
#define BIT_GET_USB23_SW_MODE_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_USB23_SW_MODE_V1_8814B) &                           \
	 BIT_MASK_USB23_SW_MODE_V1_8814B)
#define BIT_SET_USB23_SW_MODE_V1_8814B(x, v)                                   \
	(BIT_CLEAR_USB23_SW_MODE_V1_8814B(x) | BIT_USB23_SW_MODE_V1_8814B(v))

#define BIT_NO_PDN_CHIPOFF_V1_8814B BIT(17)
#define BIT_RSM_EN_V1_8814B BIT(16)

#define BIT_SHIFT_MATCH_CNT_8814B 8
#define BIT_MASK_MATCH_CNT_8814B 0xff
#define BIT_MATCH_CNT_8814B(x)                                                 \
	(((x) & BIT_MASK_MATCH_CNT_8814B) << BIT_SHIFT_MATCH_CNT_8814B)
#define BITS_MATCH_CNT_8814B                                                   \
	(BIT_MASK_MATCH_CNT_8814B << BIT_SHIFT_MATCH_CNT_8814B)
#define BIT_CLEAR_MATCH_CNT_8814B(x) ((x) & (~BITS_MATCH_CNT_8814B))
#define BIT_GET_MATCH_CNT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_MATCH_CNT_8814B) & BIT_MASK_MATCH_CNT_8814B)
#define BIT_SET_MATCH_CNT_8814B(x, v)                                          \
	(BIT_CLEAR_MATCH_CNT_8814B(x) | BIT_MATCH_CNT_8814B(v))

#define BIT_LD_B12V_EN_8814B BIT(7)
#define BIT_EECS_IOSEL_V1_8814B BIT(6)
#define BIT_EECS_DATA_O_V1_8814B BIT(5)
#define BIT_EECS_DATA_I_V1_8814B BIT(4)
#define BIT_EESK_IOSEL_V1_8814B BIT(2)
#define BIT_EESK_DATA_O_V1_8814B BIT(1)
#define BIT_EESK_DATA_I_V1_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_PMC_DBG_CTRL2_8814B */

#define BIT_SHIFT_EFUSE_BURN_GNT_8814B 24
#define BIT_MASK_EFUSE_BURN_GNT_8814B 0xff
#define BIT_EFUSE_BURN_GNT_8814B(x)                                            \
	(((x) & BIT_MASK_EFUSE_BURN_GNT_8814B)                                 \
	 << BIT_SHIFT_EFUSE_BURN_GNT_8814B)
#define BITS_EFUSE_BURN_GNT_8814B                                              \
	(BIT_MASK_EFUSE_BURN_GNT_8814B << BIT_SHIFT_EFUSE_BURN_GNT_8814B)
#define BIT_CLEAR_EFUSE_BURN_GNT_8814B(x) ((x) & (~BITS_EFUSE_BURN_GNT_8814B))
#define BIT_GET_EFUSE_BURN_GNT_8814B(x)                                        \
	(((x) >> BIT_SHIFT_EFUSE_BURN_GNT_8814B) &                             \
	 BIT_MASK_EFUSE_BURN_GNT_8814B)
#define BIT_SET_EFUSE_BURN_GNT_8814B(x, v)                                     \
	(BIT_CLEAR_EFUSE_BURN_GNT_8814B(x) | BIT_EFUSE_BURN_GNT_8814B(v))

#define BIT_STOP_WL_PMC_8814B BIT(9)
#define BIT_STOP_SYM_PMC_8814B BIT(8)
#define BIT_BT_ACCESS_WL_PAGE0_8814B BIT(6)
#define BIT_REG_RST_WLPMC_8814B BIT(5)
#define BIT_REG_RST_PD12N_8814B BIT(4)
#define BIT_SYSON_DIS_WLREG_WRMSK_8814B BIT(3)
#define BIT_SYSON_DIS_PMCREG_WRMSK_8814B BIT(2)

#define BIT_SHIFT_SYSON_REG_ARB_8814B 0
#define BIT_MASK_SYSON_REG_ARB_8814B 0x3
#define BIT_SYSON_REG_ARB_8814B(x)                                             \
	(((x) & BIT_MASK_SYSON_REG_ARB_8814B) << BIT_SHIFT_SYSON_REG_ARB_8814B)
#define BITS_SYSON_REG_ARB_8814B                                               \
	(BIT_MASK_SYSON_REG_ARB_8814B << BIT_SHIFT_SYSON_REG_ARB_8814B)
#define BIT_CLEAR_SYSON_REG_ARB_8814B(x) ((x) & (~BITS_SYSON_REG_ARB_8814B))
#define BIT_GET_SYSON_REG_ARB_8814B(x)                                         \
	(((x) >> BIT_SHIFT_SYSON_REG_ARB_8814B) & BIT_MASK_SYSON_REG_ARB_8814B)
#define BIT_SET_SYSON_REG_ARB_8814B(x, v)                                      \
	(BIT_CLEAR_SYSON_REG_ARB_8814B(x) | BIT_SYSON_REG_ARB_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_MEM_CTRL_8814B */
#define BIT_UMEM_RME_8814B BIT(31)

#define BIT_SHIFT_BT_SPRAM_8814B 28
#define BIT_MASK_BT_SPRAM_8814B 0x3
#define BIT_BT_SPRAM_8814B(x)                                                  \
	(((x) & BIT_MASK_BT_SPRAM_8814B) << BIT_SHIFT_BT_SPRAM_8814B)
#define BITS_BT_SPRAM_8814B                                                    \
	(BIT_MASK_BT_SPRAM_8814B << BIT_SHIFT_BT_SPRAM_8814B)
#define BIT_CLEAR_BT_SPRAM_8814B(x) ((x) & (~BITS_BT_SPRAM_8814B))
#define BIT_GET_BT_SPRAM_8814B(x)                                              \
	(((x) >> BIT_SHIFT_BT_SPRAM_8814B) & BIT_MASK_BT_SPRAM_8814B)
#define BIT_SET_BT_SPRAM_8814B(x, v)                                           \
	(BIT_CLEAR_BT_SPRAM_8814B(x) | BIT_BT_SPRAM_8814B(v))

#define BIT_SHIFT_BT_ROM_8814B 24
#define BIT_MASK_BT_ROM_8814B 0xf
#define BIT_BT_ROM_8814B(x)                                                    \
	(((x) & BIT_MASK_BT_ROM_8814B) << BIT_SHIFT_BT_ROM_8814B)
#define BITS_BT_ROM_8814B (BIT_MASK_BT_ROM_8814B << BIT_SHIFT_BT_ROM_8814B)
#define BIT_CLEAR_BT_ROM_8814B(x) ((x) & (~BITS_BT_ROM_8814B))
#define BIT_GET_BT_ROM_8814B(x)                                                \
	(((x) >> BIT_SHIFT_BT_ROM_8814B) & BIT_MASK_BT_ROM_8814B)
#define BIT_SET_BT_ROM_8814B(x, v)                                             \
	(BIT_CLEAR_BT_ROM_8814B(x) | BIT_BT_ROM_8814B(v))

#define BIT_SHIFT_PCI_DPRAM_8814B 10
#define BIT_MASK_PCI_DPRAM_8814B 0x3
#define BIT_PCI_DPRAM_8814B(x)                                                 \
	(((x) & BIT_MASK_PCI_DPRAM_8814B) << BIT_SHIFT_PCI_DPRAM_8814B)
#define BITS_PCI_DPRAM_8814B                                                   \
	(BIT_MASK_PCI_DPRAM_8814B << BIT_SHIFT_PCI_DPRAM_8814B)
#define BIT_CLEAR_PCI_DPRAM_8814B(x) ((x) & (~BITS_PCI_DPRAM_8814B))
#define BIT_GET_PCI_DPRAM_8814B(x)                                             \
	(((x) >> BIT_SHIFT_PCI_DPRAM_8814B) & BIT_MASK_PCI_DPRAM_8814B)
#define BIT_SET_PCI_DPRAM_8814B(x, v)                                          \
	(BIT_CLEAR_PCI_DPRAM_8814B(x) | BIT_PCI_DPRAM_8814B(v))

#define BIT_SHIFT_PCI_SPRAM_8814B 8
#define BIT_MASK_PCI_SPRAM_8814B 0x3
#define BIT_PCI_SPRAM_8814B(x)                                                 \
	(((x) & BIT_MASK_PCI_SPRAM_8814B) << BIT_SHIFT_PCI_SPRAM_8814B)
#define BITS_PCI_SPRAM_8814B                                                   \
	(BIT_MASK_PCI_SPRAM_8814B << BIT_SHIFT_PCI_SPRAM_8814B)
#define BIT_CLEAR_PCI_SPRAM_8814B(x) ((x) & (~BITS_PCI_SPRAM_8814B))
#define BIT_GET_PCI_SPRAM_8814B(x)                                             \
	(((x) >> BIT_SHIFT_PCI_SPRAM_8814B) & BIT_MASK_PCI_SPRAM_8814B)
#define BIT_SET_PCI_SPRAM_8814B(x, v)                                          \
	(BIT_CLEAR_PCI_SPRAM_8814B(x) | BIT_PCI_SPRAM_8814B(v))

#define BIT_SHIFT_USB_SPRAM_8814B 6
#define BIT_MASK_USB_SPRAM_8814B 0x3
#define BIT_USB_SPRAM_8814B(x)                                                 \
	(((x) & BIT_MASK_USB_SPRAM_8814B) << BIT_SHIFT_USB_SPRAM_8814B)
#define BITS_USB_SPRAM_8814B                                                   \
	(BIT_MASK_USB_SPRAM_8814B << BIT_SHIFT_USB_SPRAM_8814B)
#define BIT_CLEAR_USB_SPRAM_8814B(x) ((x) & (~BITS_USB_SPRAM_8814B))
#define BIT_GET_USB_SPRAM_8814B(x)                                             \
	(((x) >> BIT_SHIFT_USB_SPRAM_8814B) & BIT_MASK_USB_SPRAM_8814B)
#define BIT_SET_USB_SPRAM_8814B(x, v)                                          \
	(BIT_CLEAR_USB_SPRAM_8814B(x) | BIT_USB_SPRAM_8814B(v))

#define BIT_SHIFT_USB_SPRF_8814B 4
#define BIT_MASK_USB_SPRF_8814B 0x3
#define BIT_USB_SPRF_8814B(x)                                                  \
	(((x) & BIT_MASK_USB_SPRF_8814B) << BIT_SHIFT_USB_SPRF_8814B)
#define BITS_USB_SPRF_8814B                                                    \
	(BIT_MASK_USB_SPRF_8814B << BIT_SHIFT_USB_SPRF_8814B)
#define BIT_CLEAR_USB_SPRF_8814B(x) ((x) & (~BITS_USB_SPRF_8814B))
#define BIT_GET_USB_SPRF_8814B(x)                                              \
	(((x) >> BIT_SHIFT_USB_SPRF_8814B) & BIT_MASK_USB_SPRF_8814B)
#define BIT_SET_USB_SPRF_8814B(x, v)                                           \
	(BIT_CLEAR_USB_SPRF_8814B(x) | BIT_USB_SPRF_8814B(v))

#define BIT_SHIFT_MCU_ROM_8814B 0
#define BIT_MASK_MCU_ROM_8814B 0xf
#define BIT_MCU_ROM_8814B(x)                                                   \
	(((x) & BIT_MASK_MCU_ROM_8814B) << BIT_SHIFT_MCU_ROM_8814B)
#define BITS_MCU_ROM_8814B (BIT_MASK_MCU_ROM_8814B << BIT_SHIFT_MCU_ROM_8814B)
#define BIT_CLEAR_MCU_ROM_8814B(x) ((x) & (~BITS_MCU_ROM_8814B))
#define BIT_GET_MCU_ROM_8814B(x)                                               \
	(((x) >> BIT_SHIFT_MCU_ROM_8814B) & BIT_MASK_MCU_ROM_8814B)
#define BIT_SET_MCU_ROM_8814B(x, v)                                            \
	(BIT_CLEAR_MCU_ROM_8814B(x) | BIT_MCU_ROM_8814B(v))

/* 2 REG_SYN_RFC_CTRL_8814B */

#define BIT_SHIFT_SYN_RF1_CTRL_8814B 8
#define BIT_MASK_SYN_RF1_CTRL_8814B 0xff
#define BIT_SYN_RF1_CTRL_8814B(x)                                              \
	(((x) & BIT_MASK_SYN_RF1_CTRL_8814B) << BIT_SHIFT_SYN_RF1_CTRL_8814B)
#define BITS_SYN_RF1_CTRL_8814B                                                \
	(BIT_MASK_SYN_RF1_CTRL_8814B << BIT_SHIFT_SYN_RF1_CTRL_8814B)
#define BIT_CLEAR_SYN_RF1_CTRL_8814B(x) ((x) & (~BITS_SYN_RF1_CTRL_8814B))
#define BIT_GET_SYN_RF1_CTRL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_SYN_RF1_CTRL_8814B) & BIT_MASK_SYN_RF1_CTRL_8814B)
#define BIT_SET_SYN_RF1_CTRL_8814B(x, v)                                       \
	(BIT_CLEAR_SYN_RF1_CTRL_8814B(x) | BIT_SYN_RF1_CTRL_8814B(v))

#define BIT_SHIFT_SYN_RF0_CTRL_8814B 0
#define BIT_MASK_SYN_RF0_CTRL_8814B 0xff
#define BIT_SYN_RF0_CTRL_8814B(x)                                              \
	(((x) & BIT_MASK_SYN_RF0_CTRL_8814B) << BIT_SHIFT_SYN_RF0_CTRL_8814B)
#define BITS_SYN_RF0_CTRL_8814B                                                \
	(BIT_MASK_SYN_RF0_CTRL_8814B << BIT_SHIFT_SYN_RF0_CTRL_8814B)
#define BIT_CLEAR_SYN_RF0_CTRL_8814B(x) ((x) & (~BITS_SYN_RF0_CTRL_8814B))
#define BIT_GET_SYN_RF0_CTRL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_SYN_RF0_CTRL_8814B) & BIT_MASK_SYN_RF0_CTRL_8814B)
#define BIT_SET_SYN_RF0_CTRL_8814B(x, v)                                       \
	(BIT_CLEAR_SYN_RF0_CTRL_8814B(x) | BIT_SYN_RF0_CTRL_8814B(v))

/* 2 REG_USB_SIE_INTF_8814B */
#define BIT_RD_SEL_8814B BIT(31)
#define BIT_USB_SIE_INTF_WE_V1_8814B BIT(30)
#define BIT_USB_SIE_INTF_BYIOREG_V1_8814B BIT(29)
#define BIT_USB_SIE_SELECT_8814B BIT(28)

#define BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8814B 16
#define BIT_MASK_USB_SIE_INTF_ADDR_V1_8814B 0x1ff
#define BIT_USB_SIE_INTF_ADDR_V1_8814B(x)                                      \
	(((x) & BIT_MASK_USB_SIE_INTF_ADDR_V1_8814B)                           \
	 << BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8814B)
#define BITS_USB_SIE_INTF_ADDR_V1_8814B                                        \
	(BIT_MASK_USB_SIE_INTF_ADDR_V1_8814B                                   \
	 << BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8814B)
#define BIT_CLEAR_USB_SIE_INTF_ADDR_V1_8814B(x)                                \
	((x) & (~BITS_USB_SIE_INTF_ADDR_V1_8814B))
#define BIT_GET_USB_SIE_INTF_ADDR_V1_8814B(x)                                  \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_ADDR_V1_8814B) &                       \
	 BIT_MASK_USB_SIE_INTF_ADDR_V1_8814B)
#define BIT_SET_USB_SIE_INTF_ADDR_V1_8814B(x, v)                               \
	(BIT_CLEAR_USB_SIE_INTF_ADDR_V1_8814B(x) |                             \
	 BIT_USB_SIE_INTF_ADDR_V1_8814B(v))

#define BIT_SHIFT_USB_SIE_INTF_RD_8814B 8
#define BIT_MASK_USB_SIE_INTF_RD_8814B 0xff
#define BIT_USB_SIE_INTF_RD_8814B(x)                                           \
	(((x) & BIT_MASK_USB_SIE_INTF_RD_8814B)                                \
	 << BIT_SHIFT_USB_SIE_INTF_RD_8814B)
#define BITS_USB_SIE_INTF_RD_8814B                                             \
	(BIT_MASK_USB_SIE_INTF_RD_8814B << BIT_SHIFT_USB_SIE_INTF_RD_8814B)
#define BIT_CLEAR_USB_SIE_INTF_RD_8814B(x) ((x) & (~BITS_USB_SIE_INTF_RD_8814B))
#define BIT_GET_USB_SIE_INTF_RD_8814B(x)                                       \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_RD_8814B) &                            \
	 BIT_MASK_USB_SIE_INTF_RD_8814B)
#define BIT_SET_USB_SIE_INTF_RD_8814B(x, v)                                    \
	(BIT_CLEAR_USB_SIE_INTF_RD_8814B(x) | BIT_USB_SIE_INTF_RD_8814B(v))

#define BIT_SHIFT_USB_SIE_INTF_WD_8814B 0
#define BIT_MASK_USB_SIE_INTF_WD_8814B 0xff
#define BIT_USB_SIE_INTF_WD_8814B(x)                                           \
	(((x) & BIT_MASK_USB_SIE_INTF_WD_8814B)                                \
	 << BIT_SHIFT_USB_SIE_INTF_WD_8814B)
#define BITS_USB_SIE_INTF_WD_8814B                                             \
	(BIT_MASK_USB_SIE_INTF_WD_8814B << BIT_SHIFT_USB_SIE_INTF_WD_8814B)
#define BIT_CLEAR_USB_SIE_INTF_WD_8814B(x) ((x) & (~BITS_USB_SIE_INTF_WD_8814B))
#define BIT_GET_USB_SIE_INTF_WD_8814B(x)                                       \
	(((x) >> BIT_SHIFT_USB_SIE_INTF_WD_8814B) &                            \
	 BIT_MASK_USB_SIE_INTF_WD_8814B)
#define BIT_SET_USB_SIE_INTF_WD_8814B(x, v)                                    \
	(BIT_CLEAR_USB_SIE_INTF_WD_8814B(x) | BIT_USB_SIE_INTF_WD_8814B(v))

/* 2 REG_PCIE_MIO_INTF_8814B */

#define BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8814B 16
#define BIT_MASK_PCIE_MIO_ADDR_PAGE_8814B 0x3
#define BIT_PCIE_MIO_ADDR_PAGE_8814B(x)                                        \
	(((x) & BIT_MASK_PCIE_MIO_ADDR_PAGE_8814B)                             \
	 << BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8814B)
#define BITS_PCIE_MIO_ADDR_PAGE_8814B                                          \
	(BIT_MASK_PCIE_MIO_ADDR_PAGE_8814B                                     \
	 << BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8814B)
#define BIT_CLEAR_PCIE_MIO_ADDR_PAGE_8814B(x)                                  \
	((x) & (~BITS_PCIE_MIO_ADDR_PAGE_8814B))
#define BIT_GET_PCIE_MIO_ADDR_PAGE_8814B(x)                                    \
	(((x) >> BIT_SHIFT_PCIE_MIO_ADDR_PAGE_8814B) &                         \
	 BIT_MASK_PCIE_MIO_ADDR_PAGE_8814B)
#define BIT_SET_PCIE_MIO_ADDR_PAGE_8814B(x, v)                                 \
	(BIT_CLEAR_PCIE_MIO_ADDR_PAGE_8814B(x) |                               \
	 BIT_PCIE_MIO_ADDR_PAGE_8814B(v))

#define BIT_PCIE_MIO_BYIOREG_8814B BIT(13)
#define BIT_PCIE_MIO_RE_8814B BIT(12)

#define BIT_SHIFT_PCIE_MIO_WE_8814B 8
#define BIT_MASK_PCIE_MIO_WE_8814B 0xf
#define BIT_PCIE_MIO_WE_8814B(x)                                               \
	(((x) & BIT_MASK_PCIE_MIO_WE_8814B) << BIT_SHIFT_PCIE_MIO_WE_8814B)
#define BITS_PCIE_MIO_WE_8814B                                                 \
	(BIT_MASK_PCIE_MIO_WE_8814B << BIT_SHIFT_PCIE_MIO_WE_8814B)
#define BIT_CLEAR_PCIE_MIO_WE_8814B(x) ((x) & (~BITS_PCIE_MIO_WE_8814B))
#define BIT_GET_PCIE_MIO_WE_8814B(x)                                           \
	(((x) >> BIT_SHIFT_PCIE_MIO_WE_8814B) & BIT_MASK_PCIE_MIO_WE_8814B)
#define BIT_SET_PCIE_MIO_WE_8814B(x, v)                                        \
	(BIT_CLEAR_PCIE_MIO_WE_8814B(x) | BIT_PCIE_MIO_WE_8814B(v))

#define BIT_SHIFT_PCIE_MIO_ADDR_8814B 0
#define BIT_MASK_PCIE_MIO_ADDR_8814B 0xff
#define BIT_PCIE_MIO_ADDR_8814B(x)                                             \
	(((x) & BIT_MASK_PCIE_MIO_ADDR_8814B) << BIT_SHIFT_PCIE_MIO_ADDR_8814B)
#define BITS_PCIE_MIO_ADDR_8814B                                               \
	(BIT_MASK_PCIE_MIO_ADDR_8814B << BIT_SHIFT_PCIE_MIO_ADDR_8814B)
#define BIT_CLEAR_PCIE_MIO_ADDR_8814B(x) ((x) & (~BITS_PCIE_MIO_ADDR_8814B))
#define BIT_GET_PCIE_MIO_ADDR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_PCIE_MIO_ADDR_8814B) & BIT_MASK_PCIE_MIO_ADDR_8814B)
#define BIT_SET_PCIE_MIO_ADDR_8814B(x, v)                                      \
	(BIT_CLEAR_PCIE_MIO_ADDR_8814B(x) | BIT_PCIE_MIO_ADDR_8814B(v))

/* 2 REG_PCIE_MIO_INTD_8814B */

#define BIT_SHIFT_PCIE_MIO_DATA_8814B 0
#define BIT_MASK_PCIE_MIO_DATA_8814B 0xffffffffL
#define BIT_PCIE_MIO_DATA_8814B(x)                                             \
	(((x) & BIT_MASK_PCIE_MIO_DATA_8814B) << BIT_SHIFT_PCIE_MIO_DATA_8814B)
#define BITS_PCIE_MIO_DATA_8814B                                               \
	(BIT_MASK_PCIE_MIO_DATA_8814B << BIT_SHIFT_PCIE_MIO_DATA_8814B)
#define BIT_CLEAR_PCIE_MIO_DATA_8814B(x) ((x) & (~BITS_PCIE_MIO_DATA_8814B))
#define BIT_GET_PCIE_MIO_DATA_8814B(x)                                         \
	(((x) >> BIT_SHIFT_PCIE_MIO_DATA_8814B) & BIT_MASK_PCIE_MIO_DATA_8814B)
#define BIT_SET_PCIE_MIO_DATA_8814B(x, v)                                      \
	(BIT_CLEAR_PCIE_MIO_DATA_8814B(x) | BIT_PCIE_MIO_DATA_8814B(v))

/* 2 REG_WLRF1_8814B */

#define BIT_SHIFT_WLRF1_CTRL_8814B 24
#define BIT_MASK_WLRF1_CTRL_8814B 0xff
#define BIT_WLRF1_CTRL_8814B(x)                                                \
	(((x) & BIT_MASK_WLRF1_CTRL_8814B) << BIT_SHIFT_WLRF1_CTRL_8814B)
#define BITS_WLRF1_CTRL_8814B                                                  \
	(BIT_MASK_WLRF1_CTRL_8814B << BIT_SHIFT_WLRF1_CTRL_8814B)
#define BIT_CLEAR_WLRF1_CTRL_8814B(x) ((x) & (~BITS_WLRF1_CTRL_8814B))
#define BIT_GET_WLRF1_CTRL_8814B(x)                                            \
	(((x) >> BIT_SHIFT_WLRF1_CTRL_8814B) & BIT_MASK_WLRF1_CTRL_8814B)
#define BIT_SET_WLRF1_CTRL_8814B(x, v)                                         \
	(BIT_CLEAR_WLRF1_CTRL_8814B(x) | BIT_WLRF1_CTRL_8814B(v))

#define BIT_SHIFT_WLRF2_CTRL_8814B 16
#define BIT_MASK_WLRF2_CTRL_8814B 0xff
#define BIT_WLRF2_CTRL_8814B(x)                                                \
	(((x) & BIT_MASK_WLRF2_CTRL_8814B) << BIT_SHIFT_WLRF2_CTRL_8814B)
#define BITS_WLRF2_CTRL_8814B                                                  \
	(BIT_MASK_WLRF2_CTRL_8814B << BIT_SHIFT_WLRF2_CTRL_8814B)
#define BIT_CLEAR_WLRF2_CTRL_8814B(x) ((x) & (~BITS_WLRF2_CTRL_8814B))
#define BIT_GET_WLRF2_CTRL_8814B(x)                                            \
	(((x) >> BIT_SHIFT_WLRF2_CTRL_8814B) & BIT_MASK_WLRF2_CTRL_8814B)
#define BIT_SET_WLRF2_CTRL_8814B(x, v)                                         \
	(BIT_CLEAR_WLRF2_CTRL_8814B(x) | BIT_WLRF2_CTRL_8814B(v))

#define BIT_SHIFT_WLRF3_CTRL_8814B 8
#define BIT_MASK_WLRF3_CTRL_8814B 0xff
#define BIT_WLRF3_CTRL_8814B(x)                                                \
	(((x) & BIT_MASK_WLRF3_CTRL_8814B) << BIT_SHIFT_WLRF3_CTRL_8814B)
#define BITS_WLRF3_CTRL_8814B                                                  \
	(BIT_MASK_WLRF3_CTRL_8814B << BIT_SHIFT_WLRF3_CTRL_8814B)
#define BIT_CLEAR_WLRF3_CTRL_8814B(x) ((x) & (~BITS_WLRF3_CTRL_8814B))
#define BIT_GET_WLRF3_CTRL_8814B(x)                                            \
	(((x) >> BIT_SHIFT_WLRF3_CTRL_8814B) & BIT_MASK_WLRF3_CTRL_8814B)
#define BIT_SET_WLRF3_CTRL_8814B(x, v)                                         \
	(BIT_CLEAR_WLRF3_CTRL_8814B(x) | BIT_WLRF3_CTRL_8814B(v))

/* 2 REG_SYS_CFG1_8814B */

#define BIT_SHIFT_TRP_ICFG_8814B 28
#define BIT_MASK_TRP_ICFG_8814B 0xf
#define BIT_TRP_ICFG_8814B(x)                                                  \
	(((x) & BIT_MASK_TRP_ICFG_8814B) << BIT_SHIFT_TRP_ICFG_8814B)
#define BITS_TRP_ICFG_8814B                                                    \
	(BIT_MASK_TRP_ICFG_8814B << BIT_SHIFT_TRP_ICFG_8814B)
#define BIT_CLEAR_TRP_ICFG_8814B(x) ((x) & (~BITS_TRP_ICFG_8814B))
#define BIT_GET_TRP_ICFG_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TRP_ICFG_8814B) & BIT_MASK_TRP_ICFG_8814B)
#define BIT_SET_TRP_ICFG_8814B(x, v)                                           \
	(BIT_CLEAR_TRP_ICFG_8814B(x) | BIT_TRP_ICFG_8814B(v))

#define BIT_RF_TYPE_ID_8814B BIT(27)
#define BIT_BD_HCI_SEL_8814B BIT(26)
#define BIT_BD_PKG_SEL_8814B BIT(25)
#define BIT_SPSLDO_SEL_8814B BIT(24)
#define BIT_RTL_ID_8814B BIT(23)
#define BIT_PAD_HWPD_IDN_8814B BIT(22)
#define BIT_TESTMODE_8814B BIT(20)

#define BIT_SHIFT_VENDOR_ID_8814B 16
#define BIT_MASK_VENDOR_ID_8814B 0xf
#define BIT_VENDOR_ID_8814B(x)                                                 \
	(((x) & BIT_MASK_VENDOR_ID_8814B) << BIT_SHIFT_VENDOR_ID_8814B)
#define BITS_VENDOR_ID_8814B                                                   \
	(BIT_MASK_VENDOR_ID_8814B << BIT_SHIFT_VENDOR_ID_8814B)
#define BIT_CLEAR_VENDOR_ID_8814B(x) ((x) & (~BITS_VENDOR_ID_8814B))
#define BIT_GET_VENDOR_ID_8814B(x)                                             \
	(((x) >> BIT_SHIFT_VENDOR_ID_8814B) & BIT_MASK_VENDOR_ID_8814B)
#define BIT_SET_VENDOR_ID_8814B(x, v)                                          \
	(BIT_CLEAR_VENDOR_ID_8814B(x) | BIT_VENDOR_ID_8814B(v))

#define BIT_SHIFT_CHIP_VER_8814B 12
#define BIT_MASK_CHIP_VER_8814B 0xf
#define BIT_CHIP_VER_8814B(x)                                                  \
	(((x) & BIT_MASK_CHIP_VER_8814B) << BIT_SHIFT_CHIP_VER_8814B)
#define BITS_CHIP_VER_8814B                                                    \
	(BIT_MASK_CHIP_VER_8814B << BIT_SHIFT_CHIP_VER_8814B)
#define BIT_CLEAR_CHIP_VER_8814B(x) ((x) & (~BITS_CHIP_VER_8814B))
#define BIT_GET_CHIP_VER_8814B(x)                                              \
	(((x) >> BIT_SHIFT_CHIP_VER_8814B) & BIT_MASK_CHIP_VER_8814B)
#define BIT_SET_CHIP_VER_8814B(x, v)                                           \
	(BIT_CLEAR_CHIP_VER_8814B(x) | BIT_CHIP_VER_8814B(v))

#define BIT_BD_MAC3_8814B BIT(11)
#define BIT_BD_MAC1_8814B BIT(10)
#define BIT_BD_MAC2_8814B BIT(9)
#define BIT_SIC_IDLE_8814B BIT(8)
#define BIT_SW_OFFLOAD_EN_8814B BIT(7)
#define BIT_OCP_SHUTDN_8814B BIT(6)
#define BIT_V15_VLD_8814B BIT(5)
#define BIT_PCIRSTB_8814B BIT(4)
#define BIT_PCLK_VLD_8814B BIT(3)
#define BIT_UCLK_VLD_8814B BIT(2)
#define BIT_ACLK_VLD_8814B BIT(1)
#define BIT_XCLK_VLD_8814B BIT(0)

/* 2 REG_SYS_STATUS1_8814B */

#define BIT_SHIFT_RF_RL_ID_8814B 28
#define BIT_MASK_RF_RL_ID_8814B 0xf
#define BIT_RF_RL_ID_8814B(x)                                                  \
	(((x) & BIT_MASK_RF_RL_ID_8814B) << BIT_SHIFT_RF_RL_ID_8814B)
#define BITS_RF_RL_ID_8814B                                                    \
	(BIT_MASK_RF_RL_ID_8814B << BIT_SHIFT_RF_RL_ID_8814B)
#define BIT_CLEAR_RF_RL_ID_8814B(x) ((x) & (~BITS_RF_RL_ID_8814B))
#define BIT_GET_RF_RL_ID_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RF_RL_ID_8814B) & BIT_MASK_RF_RL_ID_8814B)
#define BIT_SET_RF_RL_ID_8814B(x, v)                                           \
	(BIT_CLEAR_RF_RL_ID_8814B(x) | BIT_RF_RL_ID_8814B(v))

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_XTAL_SEL_8814B 25
#define BIT_MASK_XTAL_SEL_8814B 0x3
#define BIT_XTAL_SEL_8814B(x)                                                  \
	(((x) & BIT_MASK_XTAL_SEL_8814B) << BIT_SHIFT_XTAL_SEL_8814B)
#define BITS_XTAL_SEL_8814B                                                    \
	(BIT_MASK_XTAL_SEL_8814B << BIT_SHIFT_XTAL_SEL_8814B)
#define BIT_CLEAR_XTAL_SEL_8814B(x) ((x) & (~BITS_XTAL_SEL_8814B))
#define BIT_GET_XTAL_SEL_8814B(x)                                              \
	(((x) >> BIT_SHIFT_XTAL_SEL_8814B) & BIT_MASK_XTAL_SEL_8814B)
#define BIT_SET_XTAL_SEL_8814B(x, v)                                           \
	(BIT_CLEAR_XTAL_SEL_8814B(x) | BIT_XTAL_SEL_8814B(v))

#define BIT_HPHY_ICFG_8814B BIT(19)

#define BIT_SHIFT_SEL_0XC0_8814B 16
#define BIT_MASK_SEL_0XC0_8814B 0x3
#define BIT_SEL_0XC0_8814B(x)                                                  \
	(((x) & BIT_MASK_SEL_0XC0_8814B) << BIT_SHIFT_SEL_0XC0_8814B)
#define BITS_SEL_0XC0_8814B                                                    \
	(BIT_MASK_SEL_0XC0_8814B << BIT_SHIFT_SEL_0XC0_8814B)
#define BIT_CLEAR_SEL_0XC0_8814B(x) ((x) & (~BITS_SEL_0XC0_8814B))
#define BIT_GET_SEL_0XC0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_SEL_0XC0_8814B) & BIT_MASK_SEL_0XC0_8814B)
#define BIT_SET_SEL_0XC0_8814B(x, v)                                           \
	(BIT_CLEAR_SEL_0XC0_8814B(x) | BIT_SEL_0XC0_8814B(v))

#define BIT_SHIFT_HCI_SEL_V4_8814B 12
#define BIT_MASK_HCI_SEL_V4_8814B 0x3
#define BIT_HCI_SEL_V4_8814B(x)                                                \
	(((x) & BIT_MASK_HCI_SEL_V4_8814B) << BIT_SHIFT_HCI_SEL_V4_8814B)
#define BITS_HCI_SEL_V4_8814B                                                  \
	(BIT_MASK_HCI_SEL_V4_8814B << BIT_SHIFT_HCI_SEL_V4_8814B)
#define BIT_CLEAR_HCI_SEL_V4_8814B(x) ((x) & (~BITS_HCI_SEL_V4_8814B))
#define BIT_GET_HCI_SEL_V4_8814B(x)                                            \
	(((x) >> BIT_SHIFT_HCI_SEL_V4_8814B) & BIT_MASK_HCI_SEL_V4_8814B)
#define BIT_SET_HCI_SEL_V4_8814B(x, v)                                         \
	(BIT_CLEAR_HCI_SEL_V4_8814B(x) | BIT_HCI_SEL_V4_8814B(v))

#define BIT_USB_OPERATION_MODE_8814B BIT(10)
#define BIT_BT_PDN_8814B BIT(9)
#define BIT_AUTO_WLPON_8814B BIT(8)
#define BIT_WL_MODE_8814B BIT(7)
#define BIT_PKG_SEL_HCI_8814B BIT(6)

#define BIT_SHIFT_PAD_HCI_SEL_V2_8814B 3
#define BIT_MASK_PAD_HCI_SEL_V2_8814B 0x3
#define BIT_PAD_HCI_SEL_V2_8814B(x)                                            \
	(((x) & BIT_MASK_PAD_HCI_SEL_V2_8814B)                                 \
	 << BIT_SHIFT_PAD_HCI_SEL_V2_8814B)
#define BITS_PAD_HCI_SEL_V2_8814B                                              \
	(BIT_MASK_PAD_HCI_SEL_V2_8814B << BIT_SHIFT_PAD_HCI_SEL_V2_8814B)
#define BIT_CLEAR_PAD_HCI_SEL_V2_8814B(x) ((x) & (~BITS_PAD_HCI_SEL_V2_8814B))
#define BIT_GET_PAD_HCI_SEL_V2_8814B(x)                                        \
	(((x) >> BIT_SHIFT_PAD_HCI_SEL_V2_8814B) &                             \
	 BIT_MASK_PAD_HCI_SEL_V2_8814B)
#define BIT_SET_PAD_HCI_SEL_V2_8814B(x, v)                                     \
	(BIT_CLEAR_PAD_HCI_SEL_V2_8814B(x) | BIT_PAD_HCI_SEL_V2_8814B(v))

#define BIT_SHIFT_EFS_HCI_SEL_8814B 0
#define BIT_MASK_EFS_HCI_SEL_8814B 0x3
#define BIT_EFS_HCI_SEL_8814B(x)                                               \
	(((x) & BIT_MASK_EFS_HCI_SEL_8814B) << BIT_SHIFT_EFS_HCI_SEL_8814B)
#define BITS_EFS_HCI_SEL_8814B                                                 \
	(BIT_MASK_EFS_HCI_SEL_8814B << BIT_SHIFT_EFS_HCI_SEL_8814B)
#define BIT_CLEAR_EFS_HCI_SEL_8814B(x) ((x) & (~BITS_EFS_HCI_SEL_8814B))
#define BIT_GET_EFS_HCI_SEL_8814B(x)                                           \
	(((x) >> BIT_SHIFT_EFS_HCI_SEL_8814B) & BIT_MASK_EFS_HCI_SEL_8814B)
#define BIT_SET_EFS_HCI_SEL_8814B(x, v)                                        \
	(BIT_CLEAR_EFS_HCI_SEL_8814B(x) | BIT_EFS_HCI_SEL_8814B(v))

/* 2 REG_SYS_STATUS2_8814B */
#define BIT_SIO_ALDN_8814B BIT(19)
#define BIT_USB_ALDN_8814B BIT(18)
#define BIT_PCI_ALDN_8814B BIT(17)
#define BIT_SYS_ALDN_8814B BIT(16)

#define BIT_SHIFT_EPVID1_8814B 8
#define BIT_MASK_EPVID1_8814B 0xff
#define BIT_EPVID1_8814B(x)                                                    \
	(((x) & BIT_MASK_EPVID1_8814B) << BIT_SHIFT_EPVID1_8814B)
#define BITS_EPVID1_8814B (BIT_MASK_EPVID1_8814B << BIT_SHIFT_EPVID1_8814B)
#define BIT_CLEAR_EPVID1_8814B(x) ((x) & (~BITS_EPVID1_8814B))
#define BIT_GET_EPVID1_8814B(x)                                                \
	(((x) >> BIT_SHIFT_EPVID1_8814B) & BIT_MASK_EPVID1_8814B)
#define BIT_SET_EPVID1_8814B(x, v)                                             \
	(BIT_CLEAR_EPVID1_8814B(x) | BIT_EPVID1_8814B(v))

#define BIT_SHIFT_EPVID0_8814B 0
#define BIT_MASK_EPVID0_8814B 0xff
#define BIT_EPVID0_8814B(x)                                                    \
	(((x) & BIT_MASK_EPVID0_8814B) << BIT_SHIFT_EPVID0_8814B)
#define BITS_EPVID0_8814B (BIT_MASK_EPVID0_8814B << BIT_SHIFT_EPVID0_8814B)
#define BIT_CLEAR_EPVID0_8814B(x) ((x) & (~BITS_EPVID0_8814B))
#define BIT_GET_EPVID0_8814B(x)                                                \
	(((x) >> BIT_SHIFT_EPVID0_8814B) & BIT_MASK_EPVID0_8814B)
#define BIT_SET_EPVID0_8814B(x, v)                                             \
	(BIT_CLEAR_EPVID0_8814B(x) | BIT_EPVID0_8814B(v))

/* 2 REG_SYS_CFG2_8814B */
#define BIT_USB2_SEL_8814B BIT(31)
#define BIT_U3PHY_RST_V1_8814B BIT(30)
#define BIT_U3_TERM_DETECT_8814B BIT(29)

#define BIT_SHIFT_HW_ID_8814B 0
#define BIT_MASK_HW_ID_8814B 0xff
#define BIT_HW_ID_8814B(x)                                                     \
	(((x) & BIT_MASK_HW_ID_8814B) << BIT_SHIFT_HW_ID_8814B)
#define BITS_HW_ID_8814B (BIT_MASK_HW_ID_8814B << BIT_SHIFT_HW_ID_8814B)
#define BIT_CLEAR_HW_ID_8814B(x) ((x) & (~BITS_HW_ID_8814B))
#define BIT_GET_HW_ID_8814B(x)                                                 \
	(((x) >> BIT_SHIFT_HW_ID_8814B) & BIT_MASK_HW_ID_8814B)
#define BIT_SET_HW_ID_8814B(x, v)                                              \
	(BIT_CLEAR_HW_ID_8814B(x) | BIT_HW_ID_8814B(v))

/* 2 REG_NOT_VALID_8814B */
#define BIT_FEN_WLMAC_OFF_8814B BIT(31)
#define BIT_PWC_MA33V_8814B BIT(15)
#define BIT_PWC_MA12V_8814B BIT(14)
#define BIT_PWC_MD12V_8814B BIT(13)
#define BIT_PWC_PD12V_8814B BIT(12)
#define BIT_PWC_UD12V_8814B BIT(11)
#define BIT_ISO_BB2PP_8814B BIT(7)
#define BIT_ISO_DENG2PP_8814B BIT(6)
#define BIT_ISO_MA2MD_8814B BIT(1)
#define BIT_ISO_MD2PP_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ANAPARSW_MAC_0_8814B */
#define BIT_OCP_L_0_8814B BIT(31)
#define BIT_POWOCP_L_8814B BIT(30)

#define BIT_SHIFT_CF_L_1_0_8814B 28
#define BIT_MASK_CF_L_1_0_8814B 0x3
#define BIT_CF_L_1_0_8814B(x)                                                  \
	(((x) & BIT_MASK_CF_L_1_0_8814B) << BIT_SHIFT_CF_L_1_0_8814B)
#define BITS_CF_L_1_0_8814B                                                    \
	(BIT_MASK_CF_L_1_0_8814B << BIT_SHIFT_CF_L_1_0_8814B)
#define BIT_CLEAR_CF_L_1_0_8814B(x) ((x) & (~BITS_CF_L_1_0_8814B))
#define BIT_GET_CF_L_1_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_CF_L_1_0_8814B) & BIT_MASK_CF_L_1_0_8814B)
#define BIT_SET_CF_L_1_0_8814B(x, v)                                           \
	(BIT_CLEAR_CF_L_1_0_8814B(x) | BIT_CF_L_1_0_8814B(v))

#define BIT_SHIFT_CFC_L_1_0_8814B 26
#define BIT_MASK_CFC_L_1_0_8814B 0x3
#define BIT_CFC_L_1_0_8814B(x)                                                 \
	(((x) & BIT_MASK_CFC_L_1_0_8814B) << BIT_SHIFT_CFC_L_1_0_8814B)
#define BITS_CFC_L_1_0_8814B                                                   \
	(BIT_MASK_CFC_L_1_0_8814B << BIT_SHIFT_CFC_L_1_0_8814B)
#define BIT_CLEAR_CFC_L_1_0_8814B(x) ((x) & (~BITS_CFC_L_1_0_8814B))
#define BIT_GET_CFC_L_1_0_8814B(x)                                             \
	(((x) >> BIT_SHIFT_CFC_L_1_0_8814B) & BIT_MASK_CFC_L_1_0_8814B)
#define BIT_SET_CFC_L_1_0_8814B(x, v)                                          \
	(BIT_CLEAR_CFC_L_1_0_8814B(x) | BIT_CFC_L_1_0_8814B(v))

#define BIT_SHIFT_R3_L_1_0_8814B 24
#define BIT_MASK_R3_L_1_0_8814B 0x3
#define BIT_R3_L_1_0_8814B(x)                                                  \
	(((x) & BIT_MASK_R3_L_1_0_8814B) << BIT_SHIFT_R3_L_1_0_8814B)
#define BITS_R3_L_1_0_8814B                                                    \
	(BIT_MASK_R3_L_1_0_8814B << BIT_SHIFT_R3_L_1_0_8814B)
#define BIT_CLEAR_R3_L_1_0_8814B(x) ((x) & (~BITS_R3_L_1_0_8814B))
#define BIT_GET_R3_L_1_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_R3_L_1_0_8814B) & BIT_MASK_R3_L_1_0_8814B)
#define BIT_SET_R3_L_1_0_8814B(x, v)                                           \
	(BIT_CLEAR_R3_L_1_0_8814B(x) | BIT_R3_L_1_0_8814B(v))

#define BIT_SHIFT_R2_L_1_0_8814B 22
#define BIT_MASK_R2_L_1_0_8814B 0x3
#define BIT_R2_L_1_0_8814B(x)                                                  \
	(((x) & BIT_MASK_R2_L_1_0_8814B) << BIT_SHIFT_R2_L_1_0_8814B)
#define BITS_R2_L_1_0_8814B                                                    \
	(BIT_MASK_R2_L_1_0_8814B << BIT_SHIFT_R2_L_1_0_8814B)
#define BIT_CLEAR_R2_L_1_0_8814B(x) ((x) & (~BITS_R2_L_1_0_8814B))
#define BIT_GET_R2_L_1_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_R2_L_1_0_8814B) & BIT_MASK_R2_L_1_0_8814B)
#define BIT_SET_R2_L_1_0_8814B(x, v)                                           \
	(BIT_CLEAR_R2_L_1_0_8814B(x) | BIT_R2_L_1_0_8814B(v))

#define BIT_SHIFT_R1_L_1_0_8814B 20
#define BIT_MASK_R1_L_1_0_8814B 0x3
#define BIT_R1_L_1_0_8814B(x)                                                  \
	(((x) & BIT_MASK_R1_L_1_0_8814B) << BIT_SHIFT_R1_L_1_0_8814B)
#define BITS_R1_L_1_0_8814B                                                    \
	(BIT_MASK_R1_L_1_0_8814B << BIT_SHIFT_R1_L_1_0_8814B)
#define BIT_CLEAR_R1_L_1_0_8814B(x) ((x) & (~BITS_R1_L_1_0_8814B))
#define BIT_GET_R1_L_1_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_R1_L_1_0_8814B) & BIT_MASK_R1_L_1_0_8814B)
#define BIT_SET_R1_L_1_0_8814B(x, v)                                           \
	(BIT_CLEAR_R1_L_1_0_8814B(x) | BIT_R1_L_1_0_8814B(v))

#define BIT_SHIFT_C3_L_1_0_8814B 18
#define BIT_MASK_C3_L_1_0_8814B 0x3
#define BIT_C3_L_1_0_8814B(x)                                                  \
	(((x) & BIT_MASK_C3_L_1_0_8814B) << BIT_SHIFT_C3_L_1_0_8814B)
#define BITS_C3_L_1_0_8814B                                                    \
	(BIT_MASK_C3_L_1_0_8814B << BIT_SHIFT_C3_L_1_0_8814B)
#define BIT_CLEAR_C3_L_1_0_8814B(x) ((x) & (~BITS_C3_L_1_0_8814B))
#define BIT_GET_C3_L_1_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_C3_L_1_0_8814B) & BIT_MASK_C3_L_1_0_8814B)
#define BIT_SET_C3_L_1_0_8814B(x, v)                                           \
	(BIT_CLEAR_C3_L_1_0_8814B(x) | BIT_C3_L_1_0_8814B(v))

#define BIT_SHIFT_C2_L_1_0_8814B 16
#define BIT_MASK_C2_L_1_0_8814B 0x3
#define BIT_C2_L_1_0_8814B(x)                                                  \
	(((x) & BIT_MASK_C2_L_1_0_8814B) << BIT_SHIFT_C2_L_1_0_8814B)
#define BITS_C2_L_1_0_8814B                                                    \
	(BIT_MASK_C2_L_1_0_8814B << BIT_SHIFT_C2_L_1_0_8814B)
#define BIT_CLEAR_C2_L_1_0_8814B(x) ((x) & (~BITS_C2_L_1_0_8814B))
#define BIT_GET_C2_L_1_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_C2_L_1_0_8814B) & BIT_MASK_C2_L_1_0_8814B)
#define BIT_SET_C2_L_1_0_8814B(x, v)                                           \
	(BIT_CLEAR_C2_L_1_0_8814B(x) | BIT_C2_L_1_0_8814B(v))

#define BIT_SHIFT_C1_L_1_0_8814B 14
#define BIT_MASK_C1_L_1_0_8814B 0x3
#define BIT_C1_L_1_0_8814B(x)                                                  \
	(((x) & BIT_MASK_C1_L_1_0_8814B) << BIT_SHIFT_C1_L_1_0_8814B)
#define BITS_C1_L_1_0_8814B                                                    \
	(BIT_MASK_C1_L_1_0_8814B << BIT_SHIFT_C1_L_1_0_8814B)
#define BIT_CLEAR_C1_L_1_0_8814B(x) ((x) & (~BITS_C1_L_1_0_8814B))
#define BIT_GET_C1_L_1_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_C1_L_1_0_8814B) & BIT_MASK_C1_L_1_0_8814B)
#define BIT_SET_C1_L_1_0_8814B(x, v)                                           \
	(BIT_CLEAR_C1_L_1_0_8814B(x) | BIT_C1_L_1_0_8814B(v))

#define BIT_REG_TYPE_L_V2_8814B BIT(13)
#define BIT_REG_PWM_L_8814B BIT(12)

#define BIT_SHIFT_V15ADJ_L_2_0_8814B 9
#define BIT_MASK_V15ADJ_L_2_0_8814B 0x7
#define BIT_V15ADJ_L_2_0_8814B(x)                                              \
	(((x) & BIT_MASK_V15ADJ_L_2_0_8814B) << BIT_SHIFT_V15ADJ_L_2_0_8814B)
#define BITS_V15ADJ_L_2_0_8814B                                                \
	(BIT_MASK_V15ADJ_L_2_0_8814B << BIT_SHIFT_V15ADJ_L_2_0_8814B)
#define BIT_CLEAR_V15ADJ_L_2_0_8814B(x) ((x) & (~BITS_V15ADJ_L_2_0_8814B))
#define BIT_GET_V15ADJ_L_2_0_8814B(x)                                          \
	(((x) >> BIT_SHIFT_V15ADJ_L_2_0_8814B) & BIT_MASK_V15ADJ_L_2_0_8814B)
#define BIT_SET_V15ADJ_L_2_0_8814B(x, v)                                       \
	(BIT_CLEAR_V15ADJ_L_2_0_8814B(x) | BIT_V15ADJ_L_2_0_8814B(v))

#define BIT_SHIFT_IN_L_2_0_8814B 6
#define BIT_MASK_IN_L_2_0_8814B 0x7
#define BIT_IN_L_2_0_8814B(x)                                                  \
	(((x) & BIT_MASK_IN_L_2_0_8814B) << BIT_SHIFT_IN_L_2_0_8814B)
#define BITS_IN_L_2_0_8814B                                                    \
	(BIT_MASK_IN_L_2_0_8814B << BIT_SHIFT_IN_L_2_0_8814B)
#define BIT_CLEAR_IN_L_2_0_8814B(x) ((x) & (~BITS_IN_L_2_0_8814B))
#define BIT_GET_IN_L_2_0_8814B(x)                                              \
	(((x) >> BIT_SHIFT_IN_L_2_0_8814B) & BIT_MASK_IN_L_2_0_8814B)
#define BIT_SET_IN_L_2_0_8814B(x, v)                                           \
	(BIT_CLEAR_IN_L_2_0_8814B(x) | BIT_IN_L_2_0_8814B(v))

#define BIT_SHIFT_STD_L_1_0_8814B 4
#define BIT_MASK_STD_L_1_0_8814B 0x3
#define BIT_STD_L_1_0_8814B(x)                                                 \
	(((x) & BIT_MASK_STD_L_1_0_8814B) << BIT_SHIFT_STD_L_1_0_8814B)
#define BITS_STD_L_1_0_8814B                                                   \
	(BIT_MASK_STD_L_1_0_8814B << BIT_SHIFT_STD_L_1_0_8814B)
#define BIT_CLEAR_STD_L_1_0_8814B(x) ((x) & (~BITS_STD_L_1_0_8814B))
#define BIT_GET_STD_L_1_0_8814B(x)                                             \
	(((x) >> BIT_SHIFT_STD_L_1_0_8814B) & BIT_MASK_STD_L_1_0_8814B)
#define BIT_SET_STD_L_1_0_8814B(x, v)                                          \
	(BIT_CLEAR_STD_L_1_0_8814B(x) | BIT_STD_L_1_0_8814B(v))

#define BIT_SHIFT_VOL_L_3_0_8814B 0
#define BIT_MASK_VOL_L_3_0_8814B 0xf
#define BIT_VOL_L_3_0_8814B(x)                                                 \
	(((x) & BIT_MASK_VOL_L_3_0_8814B) << BIT_SHIFT_VOL_L_3_0_8814B)
#define BITS_VOL_L_3_0_8814B                                                   \
	(BIT_MASK_VOL_L_3_0_8814B << BIT_SHIFT_VOL_L_3_0_8814B)
#define BIT_CLEAR_VOL_L_3_0_8814B(x) ((x) & (~BITS_VOL_L_3_0_8814B))
#define BIT_GET_VOL_L_3_0_8814B(x)                                             \
	(((x) >> BIT_SHIFT_VOL_L_3_0_8814B) & BIT_MASK_VOL_L_3_0_8814B)
#define BIT_SET_VOL_L_3_0_8814B(x, v)                                          \
	(BIT_CLEAR_VOL_L_3_0_8814B(x) | BIT_VOL_L_3_0_8814B(v))

/* 2 REG_ANAPARSW_MAC_1_8814B */

#define BIT_SHIFT_REG_FREQ_L_V1_8814B 20
#define BIT_MASK_REG_FREQ_L_V1_8814B 0x7
#define BIT_REG_FREQ_L_V1_8814B(x)                                             \
	(((x) & BIT_MASK_REG_FREQ_L_V1_8814B) << BIT_SHIFT_REG_FREQ_L_V1_8814B)
#define BITS_REG_FREQ_L_V1_8814B                                               \
	(BIT_MASK_REG_FREQ_L_V1_8814B << BIT_SHIFT_REG_FREQ_L_V1_8814B)
#define BIT_CLEAR_REG_FREQ_L_V1_8814B(x) ((x) & (~BITS_REG_FREQ_L_V1_8814B))
#define BIT_GET_REG_FREQ_L_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_REG_FREQ_L_V1_8814B) & BIT_MASK_REG_FREQ_L_V1_8814B)
#define BIT_SET_REG_FREQ_L_V1_8814B(x, v)                                      \
	(BIT_CLEAR_REG_FREQ_L_V1_8814B(x) | BIT_REG_FREQ_L_V1_8814B(v))

#define BIT_EN_DUTY_8814B BIT(19)

#define BIT_SHIFT_REG_MOS_HALF_8814B 17
#define BIT_MASK_REG_MOS_HALF_8814B 0x3
#define BIT_REG_MOS_HALF_8814B(x)                                              \
	(((x) & BIT_MASK_REG_MOS_HALF_8814B) << BIT_SHIFT_REG_MOS_HALF_8814B)
#define BITS_REG_MOS_HALF_8814B                                                \
	(BIT_MASK_REG_MOS_HALF_8814B << BIT_SHIFT_REG_MOS_HALF_8814B)
#define BIT_CLEAR_REG_MOS_HALF_8814B(x) ((x) & (~BITS_REG_MOS_HALF_8814B))
#define BIT_GET_REG_MOS_HALF_8814B(x)                                          \
	(((x) >> BIT_SHIFT_REG_MOS_HALF_8814B) & BIT_MASK_REG_MOS_HALF_8814B)
#define BIT_SET_REG_MOS_HALF_8814B(x, v)                                       \
	(BIT_CLEAR_REG_MOS_HALF_8814B(x) | BIT_REG_MOS_HALF_8814B(v))

#define BIT_EN_SP_8814B BIT(16)
#define BIT_REG_AUTO_L_V1_8814B BIT(15)
#define BIT_REG_LDOF_L_V2_8814B BIT(14)
#define BIT_REG_OCPS_L_V2_8814B BIT(13)

/* 2 REG_NOT_VALID_8814B */
#define BIT_ARENB_L_V1_8814B BIT(11)

#define BIT_SHIFT_TBOX_L1_1_0_8814B 9
#define BIT_MASK_TBOX_L1_1_0_8814B 0x3
#define BIT_TBOX_L1_1_0_8814B(x)                                               \
	(((x) & BIT_MASK_TBOX_L1_1_0_8814B) << BIT_SHIFT_TBOX_L1_1_0_8814B)
#define BITS_TBOX_L1_1_0_8814B                                                 \
	(BIT_MASK_TBOX_L1_1_0_8814B << BIT_SHIFT_TBOX_L1_1_0_8814B)
#define BIT_CLEAR_TBOX_L1_1_0_8814B(x) ((x) & (~BITS_TBOX_L1_1_0_8814B))
#define BIT_GET_TBOX_L1_1_0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_TBOX_L1_1_0_8814B) & BIT_MASK_TBOX_L1_1_0_8814B)
#define BIT_SET_TBOX_L1_1_0_8814B(x, v)                                        \
	(BIT_CLEAR_TBOX_L1_1_0_8814B(x) | BIT_TBOX_L1_1_0_8814B(v))

#define BIT_SHIFT_REG_DELAY_L_1_0_8814B 7
#define BIT_MASK_REG_DELAY_L_1_0_8814B 0x3
#define BIT_REG_DELAY_L_1_0_8814B(x)                                           \
	(((x) & BIT_MASK_REG_DELAY_L_1_0_8814B)                                \
	 << BIT_SHIFT_REG_DELAY_L_1_0_8814B)
#define BITS_REG_DELAY_L_1_0_8814B                                             \
	(BIT_MASK_REG_DELAY_L_1_0_8814B << BIT_SHIFT_REG_DELAY_L_1_0_8814B)
#define BIT_CLEAR_REG_DELAY_L_1_0_8814B(x) ((x) & (~BITS_REG_DELAY_L_1_0_8814B))
#define BIT_GET_REG_DELAY_L_1_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_REG_DELAY_L_1_0_8814B) &                            \
	 BIT_MASK_REG_DELAY_L_1_0_8814B)
#define BIT_SET_REG_DELAY_L_1_0_8814B(x, v)                                    \
	(BIT_CLEAR_REG_DELAY_L_1_0_8814B(x) | BIT_REG_DELAY_L_1_0_8814B(v))

#define BIT_REG_CLAMP_D_L_8814B BIT(6)
#define BIT_REG_BYPASS_L_V1_8814B BIT(5)
#define BIT_REG_AUTOZCD_L_8814B BIT(4)
#define BIT_POW_ZCD_L_V1_8814B BIT(3)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_OCP_L_2_1_8814B 0
#define BIT_MASK_OCP_L_2_1_8814B 0x3
#define BIT_OCP_L_2_1_8814B(x)                                                 \
	(((x) & BIT_MASK_OCP_L_2_1_8814B) << BIT_SHIFT_OCP_L_2_1_8814B)
#define BITS_OCP_L_2_1_8814B                                                   \
	(BIT_MASK_OCP_L_2_1_8814B << BIT_SHIFT_OCP_L_2_1_8814B)
#define BIT_CLEAR_OCP_L_2_1_8814B(x) ((x) & (~BITS_OCP_L_2_1_8814B))
#define BIT_GET_OCP_L_2_1_8814B(x)                                             \
	(((x) >> BIT_SHIFT_OCP_L_2_1_8814B) & BIT_MASK_OCP_L_2_1_8814B)
#define BIT_SET_OCP_L_2_1_8814B(x, v)                                          \
	(BIT_CLEAR_OCP_L_2_1_8814B(x) | BIT_OCP_L_2_1_8814B(v))

/* 2 REG_ANAPAR_MAC_0_8814B */

#define BIT_SHIFT_LPF_C2_1_0_8814B 30
#define BIT_MASK_LPF_C2_1_0_8814B 0x3
#define BIT_LPF_C2_1_0_8814B(x)                                                \
	(((x) & BIT_MASK_LPF_C2_1_0_8814B) << BIT_SHIFT_LPF_C2_1_0_8814B)
#define BITS_LPF_C2_1_0_8814B                                                  \
	(BIT_MASK_LPF_C2_1_0_8814B << BIT_SHIFT_LPF_C2_1_0_8814B)
#define BIT_CLEAR_LPF_C2_1_0_8814B(x) ((x) & (~BITS_LPF_C2_1_0_8814B))
#define BIT_GET_LPF_C2_1_0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_LPF_C2_1_0_8814B) & BIT_MASK_LPF_C2_1_0_8814B)
#define BIT_SET_LPF_C2_1_0_8814B(x, v)                                         \
	(BIT_CLEAR_LPF_C2_1_0_8814B(x) | BIT_LPF_C2_1_0_8814B(v))

#define BIT_SHIFT_LPF_C1_5_0_8814B 24
#define BIT_MASK_LPF_C1_5_0_8814B 0x3f
#define BIT_LPF_C1_5_0_8814B(x)                                                \
	(((x) & BIT_MASK_LPF_C1_5_0_8814B) << BIT_SHIFT_LPF_C1_5_0_8814B)
#define BITS_LPF_C1_5_0_8814B                                                  \
	(BIT_MASK_LPF_C1_5_0_8814B << BIT_SHIFT_LPF_C1_5_0_8814B)
#define BIT_CLEAR_LPF_C1_5_0_8814B(x) ((x) & (~BITS_LPF_C1_5_0_8814B))
#define BIT_GET_LPF_C1_5_0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_LPF_C1_5_0_8814B) & BIT_MASK_LPF_C1_5_0_8814B)
#define BIT_SET_LPF_C1_5_0_8814B(x, v)                                         \
	(BIT_CLEAR_LPF_C1_5_0_8814B(x) | BIT_LPF_C1_5_0_8814B(v))

#define BIT_LPF_TIEL_8814B BIT(23)
#define BIT_LPF_TIEH_8814B BIT(22)

#define BIT_SHIFT_LOCKDET_VREF_L_1_0_8814B 20
#define BIT_MASK_LOCKDET_VREF_L_1_0_8814B 0x3
#define BIT_LOCKDET_VREF_L_1_0_8814B(x)                                        \
	(((x) & BIT_MASK_LOCKDET_VREF_L_1_0_8814B)                             \
	 << BIT_SHIFT_LOCKDET_VREF_L_1_0_8814B)
#define BITS_LOCKDET_VREF_L_1_0_8814B                                          \
	(BIT_MASK_LOCKDET_VREF_L_1_0_8814B                                     \
	 << BIT_SHIFT_LOCKDET_VREF_L_1_0_8814B)
#define BIT_CLEAR_LOCKDET_VREF_L_1_0_8814B(x)                                  \
	((x) & (~BITS_LOCKDET_VREF_L_1_0_8814B))
#define BIT_GET_LOCKDET_VREF_L_1_0_8814B(x)                                    \
	(((x) >> BIT_SHIFT_LOCKDET_VREF_L_1_0_8814B) &                         \
	 BIT_MASK_LOCKDET_VREF_L_1_0_8814B)
#define BIT_SET_LOCKDET_VREF_L_1_0_8814B(x, v)                                 \
	(BIT_CLEAR_LOCKDET_VREF_L_1_0_8814B(x) |                               \
	 BIT_LOCKDET_VREF_L_1_0_8814B(v))

#define BIT_SHIFT_LOCKDET_VREF_H_1_0_8814B 18
#define BIT_MASK_LOCKDET_VREF_H_1_0_8814B 0x3
#define BIT_LOCKDET_VREF_H_1_0_8814B(x)                                        \
	(((x) & BIT_MASK_LOCKDET_VREF_H_1_0_8814B)                             \
	 << BIT_SHIFT_LOCKDET_VREF_H_1_0_8814B)
#define BITS_LOCKDET_VREF_H_1_0_8814B                                          \
	(BIT_MASK_LOCKDET_VREF_H_1_0_8814B                                     \
	 << BIT_SHIFT_LOCKDET_VREF_H_1_0_8814B)
#define BIT_CLEAR_LOCKDET_VREF_H_1_0_8814B(x)                                  \
	((x) & (~BITS_LOCKDET_VREF_H_1_0_8814B))
#define BIT_GET_LOCKDET_VREF_H_1_0_8814B(x)                                    \
	(((x) >> BIT_SHIFT_LOCKDET_VREF_H_1_0_8814B) &                         \
	 BIT_MASK_LOCKDET_VREF_H_1_0_8814B)
#define BIT_SET_LOCKDET_VREF_H_1_0_8814B(x, v)                                 \
	(BIT_CLEAR_LOCKDET_VREF_H_1_0_8814B(x) |                               \
	 BIT_LOCKDET_VREF_H_1_0_8814B(v))

#define BIT_SHIFT_LDO_SEL_1_0_8814B 16
#define BIT_MASK_LDO_SEL_1_0_8814B 0x3
#define BIT_LDO_SEL_1_0_8814B(x)                                               \
	(((x) & BIT_MASK_LDO_SEL_1_0_8814B) << BIT_SHIFT_LDO_SEL_1_0_8814B)
#define BITS_LDO_SEL_1_0_8814B                                                 \
	(BIT_MASK_LDO_SEL_1_0_8814B << BIT_SHIFT_LDO_SEL_1_0_8814B)
#define BIT_CLEAR_LDO_SEL_1_0_8814B(x) ((x) & (~BITS_LDO_SEL_1_0_8814B))
#define BIT_GET_LDO_SEL_1_0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_LDO_SEL_1_0_8814B) & BIT_MASK_LDO_SEL_1_0_8814B)
#define BIT_SET_LDO_SEL_1_0_8814B(x, v)                                        \
	(BIT_CLEAR_LDO_SEL_1_0_8814B(x) | BIT_LDO_SEL_1_0_8814B(v))

#define BIT_SHIFT_IOFFSET_5_0_8814B 10
#define BIT_MASK_IOFFSET_5_0_8814B 0x3f
#define BIT_IOFFSET_5_0_8814B(x)                                               \
	(((x) & BIT_MASK_IOFFSET_5_0_8814B) << BIT_SHIFT_IOFFSET_5_0_8814B)
#define BITS_IOFFSET_5_0_8814B                                                 \
	(BIT_MASK_IOFFSET_5_0_8814B << BIT_SHIFT_IOFFSET_5_0_8814B)
#define BIT_CLEAR_IOFFSET_5_0_8814B(x) ((x) & (~BITS_IOFFSET_5_0_8814B))
#define BIT_GET_IOFFSET_5_0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_IOFFSET_5_0_8814B) & BIT_MASK_IOFFSET_5_0_8814B)
#define BIT_SET_IOFFSET_5_0_8814B(x, v)                                        \
	(BIT_CLEAR_IOFFSET_5_0_8814B(x) | BIT_IOFFSET_5_0_8814B(v))

#define BIT_CP_ICPX2_8814B BIT(9)

#define BIT_SHIFT_CP_ICP_SEL_4_0_8814B 4
#define BIT_MASK_CP_ICP_SEL_4_0_8814B 0x1f
#define BIT_CP_ICP_SEL_4_0_8814B(x)                                            \
	(((x) & BIT_MASK_CP_ICP_SEL_4_0_8814B)                                 \
	 << BIT_SHIFT_CP_ICP_SEL_4_0_8814B)
#define BITS_CP_ICP_SEL_4_0_8814B                                              \
	(BIT_MASK_CP_ICP_SEL_4_0_8814B << BIT_SHIFT_CP_ICP_SEL_4_0_8814B)
#define BIT_CLEAR_CP_ICP_SEL_4_0_8814B(x) ((x) & (~BITS_CP_ICP_SEL_4_0_8814B))
#define BIT_GET_CP_ICP_SEL_4_0_8814B(x)                                        \
	(((x) >> BIT_SHIFT_CP_ICP_SEL_4_0_8814B) &                             \
	 BIT_MASK_CP_ICP_SEL_4_0_8814B)
#define BIT_SET_CP_ICP_SEL_4_0_8814B(x, v)                                     \
	(BIT_CLEAR_CP_ICP_SEL_4_0_8814B(x) | BIT_CP_ICP_SEL_4_0_8814B(v))

#define BIT_SHIFT_IB_PI_1_0_8814B 2
#define BIT_MASK_IB_PI_1_0_8814B 0x3
#define BIT_IB_PI_1_0_8814B(x)                                                 \
	(((x) & BIT_MASK_IB_PI_1_0_8814B) << BIT_SHIFT_IB_PI_1_0_8814B)
#define BITS_IB_PI_1_0_8814B                                                   \
	(BIT_MASK_IB_PI_1_0_8814B << BIT_SHIFT_IB_PI_1_0_8814B)
#define BIT_CLEAR_IB_PI_1_0_8814B(x) ((x) & (~BITS_IB_PI_1_0_8814B))
#define BIT_GET_IB_PI_1_0_8814B(x)                                             \
	(((x) >> BIT_SHIFT_IB_PI_1_0_8814B) & BIT_MASK_IB_PI_1_0_8814B)
#define BIT_SET_IB_PI_1_0_8814B(x, v)                                          \
	(BIT_CLEAR_IB_PI_1_0_8814B(x) | BIT_IB_PI_1_0_8814B(v))

#define BIT_SHIFT_LDO_VSEL_8814B 0
#define BIT_MASK_LDO_VSEL_8814B 0x3
#define BIT_LDO_VSEL_8814B(x)                                                  \
	(((x) & BIT_MASK_LDO_VSEL_8814B) << BIT_SHIFT_LDO_VSEL_8814B)
#define BITS_LDO_VSEL_8814B                                                    \
	(BIT_MASK_LDO_VSEL_8814B << BIT_SHIFT_LDO_VSEL_8814B)
#define BIT_CLEAR_LDO_VSEL_8814B(x) ((x) & (~BITS_LDO_VSEL_8814B))
#define BIT_GET_LDO_VSEL_8814B(x)                                              \
	(((x) >> BIT_SHIFT_LDO_VSEL_8814B) & BIT_MASK_LDO_VSEL_8814B)
#define BIT_SET_LDO_VSEL_8814B(x, v)                                           \
	(BIT_CLEAR_LDO_VSEL_8814B(x) | BIT_LDO_VSEL_8814B(v))

/* 2 REG_ANAPAR_MAC_1_8814B */

#define BIT_SHIFT_CKX_USB_IB_SEL_8814B 29
#define BIT_MASK_CKX_USB_IB_SEL_8814B 0x7
#define BIT_CKX_USB_IB_SEL_8814B(x)                                            \
	(((x) & BIT_MASK_CKX_USB_IB_SEL_8814B)                                 \
	 << BIT_SHIFT_CKX_USB_IB_SEL_8814B)
#define BITS_CKX_USB_IB_SEL_8814B                                              \
	(BIT_MASK_CKX_USB_IB_SEL_8814B << BIT_SHIFT_CKX_USB_IB_SEL_8814B)
#define BIT_CLEAR_CKX_USB_IB_SEL_8814B(x) ((x) & (~BITS_CKX_USB_IB_SEL_8814B))
#define BIT_GET_CKX_USB_IB_SEL_8814B(x)                                        \
	(((x) >> BIT_SHIFT_CKX_USB_IB_SEL_8814B) &                             \
	 BIT_MASK_CKX_USB_IB_SEL_8814B)
#define BIT_SET_CKX_USB_IB_SEL_8814B(x, v)                                     \
	(BIT_CLEAR_CKX_USB_IB_SEL_8814B(x) | BIT_CKX_USB_IB_SEL_8814B(v))

#define BIT_PFD_DN_GATED_8814B BIT(28)
#define BIT_PFD_UP_GATED_8814B BIT(27)
#define BIT_PFD_RESET_GATED_8814B BIT(26)

#define BIT_SHIFT_PFD_OUT_DRV_1_0_8814B 24
#define BIT_MASK_PFD_OUT_DRV_1_0_8814B 0x3
#define BIT_PFD_OUT_DRV_1_0_8814B(x)                                           \
	(((x) & BIT_MASK_PFD_OUT_DRV_1_0_8814B)                                \
	 << BIT_SHIFT_PFD_OUT_DRV_1_0_8814B)
#define BITS_PFD_OUT_DRV_1_0_8814B                                             \
	(BIT_MASK_PFD_OUT_DRV_1_0_8814B << BIT_SHIFT_PFD_OUT_DRV_1_0_8814B)
#define BIT_CLEAR_PFD_OUT_DRV_1_0_8814B(x) ((x) & (~BITS_PFD_OUT_DRV_1_0_8814B))
#define BIT_GET_PFD_OUT_DRV_1_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_PFD_OUT_DRV_1_0_8814B) &                            \
	 BIT_MASK_PFD_OUT_DRV_1_0_8814B)
#define BIT_SET_PFD_OUT_DRV_1_0_8814B(x, v)                                    \
	(BIT_CLEAR_PFD_OUT_DRV_1_0_8814B(x) | BIT_PFD_OUT_DRV_1_0_8814B(v))

#define BIT_SHIFT_LPF_TIEMID_2_0_8814B 20
#define BIT_MASK_LPF_TIEMID_2_0_8814B 0x7
#define BIT_LPF_TIEMID_2_0_8814B(x)                                            \
	(((x) & BIT_MASK_LPF_TIEMID_2_0_8814B)                                 \
	 << BIT_SHIFT_LPF_TIEMID_2_0_8814B)
#define BITS_LPF_TIEMID_2_0_8814B                                              \
	(BIT_MASK_LPF_TIEMID_2_0_8814B << BIT_SHIFT_LPF_TIEMID_2_0_8814B)
#define BIT_CLEAR_LPF_TIEMID_2_0_8814B(x) ((x) & (~BITS_LPF_TIEMID_2_0_8814B))
#define BIT_GET_LPF_TIEMID_2_0_8814B(x)                                        \
	(((x) >> BIT_SHIFT_LPF_TIEMID_2_0_8814B) &                             \
	 BIT_MASK_LPF_TIEMID_2_0_8814B)
#define BIT_SET_LPF_TIEMID_2_0_8814B(x, v)                                     \
	(BIT_CLEAR_LPF_TIEMID_2_0_8814B(x) | BIT_LPF_TIEMID_2_0_8814B(v))

#define BIT_SHIFT_LPF_R3_4_0_8814B 15
#define BIT_MASK_LPF_R3_4_0_8814B 0x1f
#define BIT_LPF_R3_4_0_8814B(x)                                                \
	(((x) & BIT_MASK_LPF_R3_4_0_8814B) << BIT_SHIFT_LPF_R3_4_0_8814B)
#define BITS_LPF_R3_4_0_8814B                                                  \
	(BIT_MASK_LPF_R3_4_0_8814B << BIT_SHIFT_LPF_R3_4_0_8814B)
#define BIT_CLEAR_LPF_R3_4_0_8814B(x) ((x) & (~BITS_LPF_R3_4_0_8814B))
#define BIT_GET_LPF_R3_4_0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_LPF_R3_4_0_8814B) & BIT_MASK_LPF_R3_4_0_8814B)
#define BIT_SET_LPF_R3_4_0_8814B(x, v)                                         \
	(BIT_CLEAR_LPF_R3_4_0_8814B(x) | BIT_LPF_R3_4_0_8814B(v))

#define BIT_SHIFT_LPF_R2_4_0_8814B 10
#define BIT_MASK_LPF_R2_4_0_8814B 0x1f
#define BIT_LPF_R2_4_0_8814B(x)                                                \
	(((x) & BIT_MASK_LPF_R2_4_0_8814B) << BIT_SHIFT_LPF_R2_4_0_8814B)
#define BITS_LPF_R2_4_0_8814B                                                  \
	(BIT_MASK_LPF_R2_4_0_8814B << BIT_SHIFT_LPF_R2_4_0_8814B)
#define BIT_CLEAR_LPF_R2_4_0_8814B(x) ((x) & (~BITS_LPF_R2_4_0_8814B))
#define BIT_GET_LPF_R2_4_0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_LPF_R2_4_0_8814B) & BIT_MASK_LPF_R2_4_0_8814B)
#define BIT_SET_LPF_R2_4_0_8814B(x, v)                                         \
	(BIT_CLEAR_LPF_R2_4_0_8814B(x) | BIT_LPF_R2_4_0_8814B(v))

#define BIT_SHIFT_LPF_C3_5_0_8814B 4
#define BIT_MASK_LPF_C3_5_0_8814B 0x3f
#define BIT_LPF_C3_5_0_8814B(x)                                                \
	(((x) & BIT_MASK_LPF_C3_5_0_8814B) << BIT_SHIFT_LPF_C3_5_0_8814B)
#define BITS_LPF_C3_5_0_8814B                                                  \
	(BIT_MASK_LPF_C3_5_0_8814B << BIT_SHIFT_LPF_C3_5_0_8814B)
#define BIT_CLEAR_LPF_C3_5_0_8814B(x) ((x) & (~BITS_LPF_C3_5_0_8814B))
#define BIT_GET_LPF_C3_5_0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_LPF_C3_5_0_8814B) & BIT_MASK_LPF_C3_5_0_8814B)
#define BIT_SET_LPF_C3_5_0_8814B(x, v)                                         \
	(BIT_CLEAR_LPF_C3_5_0_8814B(x) | BIT_LPF_C3_5_0_8814B(v))

#define BIT_SHIFT_LPF_C2_5_2_8814B 0
#define BIT_MASK_LPF_C2_5_2_8814B 0xf
#define BIT_LPF_C2_5_2_8814B(x)                                                \
	(((x) & BIT_MASK_LPF_C2_5_2_8814B) << BIT_SHIFT_LPF_C2_5_2_8814B)
#define BITS_LPF_C2_5_2_8814B                                                  \
	(BIT_MASK_LPF_C2_5_2_8814B << BIT_SHIFT_LPF_C2_5_2_8814B)
#define BIT_CLEAR_LPF_C2_5_2_8814B(x) ((x) & (~BITS_LPF_C2_5_2_8814B))
#define BIT_GET_LPF_C2_5_2_8814B(x)                                            \
	(((x) >> BIT_SHIFT_LPF_C2_5_2_8814B) & BIT_MASK_LPF_C2_5_2_8814B)
#define BIT_SET_LPF_C2_5_2_8814B(x, v)                                         \
	(BIT_CLEAR_LPF_C2_5_2_8814B(x) | BIT_LPF_C2_5_2_8814B(v))

/* 2 REG_ANAPAR_MAC_2_8814B */
#define BIT_CK_PHASE_SEL_8814B BIT(31)
#define BIT_CK960M_EN_8814B BIT(30)
#define BIT_CK640M_EN_8814B BIT(29)
#define BIT_CK240M_EN_8814B BIT(28)

#define BIT_SHIFT_CK_MON_SEL_2_0_8814B 25
#define BIT_MASK_CK_MON_SEL_2_0_8814B 0x7
#define BIT_CK_MON_SEL_2_0_8814B(x)                                            \
	(((x) & BIT_MASK_CK_MON_SEL_2_0_8814B)                                 \
	 << BIT_SHIFT_CK_MON_SEL_2_0_8814B)
#define BITS_CK_MON_SEL_2_0_8814B                                              \
	(BIT_MASK_CK_MON_SEL_2_0_8814B << BIT_SHIFT_CK_MON_SEL_2_0_8814B)
#define BIT_CLEAR_CK_MON_SEL_2_0_8814B(x) ((x) & (~BITS_CK_MON_SEL_2_0_8814B))
#define BIT_GET_CK_MON_SEL_2_0_8814B(x)                                        \
	(((x) >> BIT_SHIFT_CK_MON_SEL_2_0_8814B) &                             \
	 BIT_MASK_CK_MON_SEL_2_0_8814B)
#define BIT_SET_CK_MON_SEL_2_0_8814B(x, v)                                     \
	(BIT_CLEAR_CK_MON_SEL_2_0_8814B(x) | BIT_CK_MON_SEL_2_0_8814B(v))

#define BIT_CK_MON_EN_V1_8814B BIT(24)
#define BIT_XTAL_SOURCE_SEL_8814B BIT(23)
#define BIT_XTAL_FREQ_SEL_8814B BIT(22)
#define BIT_XTAL_EDGE_SEL_8814B BIT(21)
#define BIT_XTAL_BUF_SEL_8814B BIT(20)

#define BIT_SHIFT_VCO_CV_7_0_8814B 4
#define BIT_MASK_VCO_CV_7_0_8814B 0xff
#define BIT_VCO_CV_7_0_8814B(x)                                                \
	(((x) & BIT_MASK_VCO_CV_7_0_8814B) << BIT_SHIFT_VCO_CV_7_0_8814B)
#define BITS_VCO_CV_7_0_8814B                                                  \
	(BIT_MASK_VCO_CV_7_0_8814B << BIT_SHIFT_VCO_CV_7_0_8814B)
#define BIT_CLEAR_VCO_CV_7_0_8814B(x) ((x) & (~BITS_VCO_CV_7_0_8814B))
#define BIT_GET_VCO_CV_7_0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_VCO_CV_7_0_8814B) & BIT_MASK_VCO_CV_7_0_8814B)
#define BIT_SET_VCO_CV_7_0_8814B(x, v)                                         \
	(BIT_CLEAR_VCO_CV_7_0_8814B(x) | BIT_VCO_CV_7_0_8814B(v))

#define BIT_VCO_KVCO_8814B BIT(3)
#define BIT_SDM_EDGE_SEL_8814B BIT(2)
#define BIT_SDM_CK_SEL_8814B BIT(1)
#define BIT_SDM_CK_GATED_8814B BIT(0)

/* 2 REG_ANAPAR_MAC_3_8814B */

#define BIT_SHIFT_LCK_WAIT_CYCLE_2_0_8814B 28
#define BIT_MASK_LCK_WAIT_CYCLE_2_0_8814B 0x7
#define BIT_LCK_WAIT_CYCLE_2_0_8814B(x)                                        \
	(((x) & BIT_MASK_LCK_WAIT_CYCLE_2_0_8814B)                             \
	 << BIT_SHIFT_LCK_WAIT_CYCLE_2_0_8814B)
#define BITS_LCK_WAIT_CYCLE_2_0_8814B                                          \
	(BIT_MASK_LCK_WAIT_CYCLE_2_0_8814B                                     \
	 << BIT_SHIFT_LCK_WAIT_CYCLE_2_0_8814B)
#define BIT_CLEAR_LCK_WAIT_CYCLE_2_0_8814B(x)                                  \
	((x) & (~BITS_LCK_WAIT_CYCLE_2_0_8814B))
#define BIT_GET_LCK_WAIT_CYCLE_2_0_8814B(x)                                    \
	(((x) >> BIT_SHIFT_LCK_WAIT_CYCLE_2_0_8814B) &                         \
	 BIT_MASK_LCK_WAIT_CYCLE_2_0_8814B)
#define BIT_SET_LCK_WAIT_CYCLE_2_0_8814B(x, v)                                 \
	(BIT_CLEAR_LCK_WAIT_CYCLE_2_0_8814B(x) |                               \
	 BIT_LCK_WAIT_CYCLE_2_0_8814B(v))

#define BIT_SHIFT_LCK_VCO_DIVISOR_1_0_8814B 26
#define BIT_MASK_LCK_VCO_DIVISOR_1_0_8814B 0x3
#define BIT_LCK_VCO_DIVISOR_1_0_8814B(x)                                       \
	(((x) & BIT_MASK_LCK_VCO_DIVISOR_1_0_8814B)                            \
	 << BIT_SHIFT_LCK_VCO_DIVISOR_1_0_8814B)
#define BITS_LCK_VCO_DIVISOR_1_0_8814B                                         \
	(BIT_MASK_LCK_VCO_DIVISOR_1_0_8814B                                    \
	 << BIT_SHIFT_LCK_VCO_DIVISOR_1_0_8814B)
#define BIT_CLEAR_LCK_VCO_DIVISOR_1_0_8814B(x)                                 \
	((x) & (~BITS_LCK_VCO_DIVISOR_1_0_8814B))
#define BIT_GET_LCK_VCO_DIVISOR_1_0_8814B(x)                                   \
	(((x) >> BIT_SHIFT_LCK_VCO_DIVISOR_1_0_8814B) &                        \
	 BIT_MASK_LCK_VCO_DIVISOR_1_0_8814B)
#define BIT_SET_LCK_VCO_DIVISOR_1_0_8814B(x, v)                                \
	(BIT_CLEAR_LCK_VCO_DIVISOR_1_0_8814B(x) |                              \
	 BIT_LCK_VCO_DIVISOR_1_0_8814B(v))

#define BIT_SHIFT_LCK_SEARCH_MODE_1_0_8814B 24
#define BIT_MASK_LCK_SEARCH_MODE_1_0_8814B 0x3
#define BIT_LCK_SEARCH_MODE_1_0_8814B(x)                                       \
	(((x) & BIT_MASK_LCK_SEARCH_MODE_1_0_8814B)                            \
	 << BIT_SHIFT_LCK_SEARCH_MODE_1_0_8814B)
#define BITS_LCK_SEARCH_MODE_1_0_8814B                                         \
	(BIT_MASK_LCK_SEARCH_MODE_1_0_8814B                                    \
	 << BIT_SHIFT_LCK_SEARCH_MODE_1_0_8814B)
#define BIT_CLEAR_LCK_SEARCH_MODE_1_0_8814B(x)                                 \
	((x) & (~BITS_LCK_SEARCH_MODE_1_0_8814B))
#define BIT_GET_LCK_SEARCH_MODE_1_0_8814B(x)                                   \
	(((x) >> BIT_SHIFT_LCK_SEARCH_MODE_1_0_8814B) &                        \
	 BIT_MASK_LCK_SEARCH_MODE_1_0_8814B)
#define BIT_SET_LCK_SEARCH_MODE_1_0_8814B(x, v)                                \
	(BIT_CLEAR_LCK_SEARCH_MODE_1_0_8814B(x) |                              \
	 BIT_LCK_SEARCH_MODE_1_0_8814B(v))

#define BIT_SHIFT_LS_CV_OFFSET_3_0_8814B 12
#define BIT_MASK_LS_CV_OFFSET_3_0_8814B 0xf
#define BIT_LS_CV_OFFSET_3_0_8814B(x)                                          \
	(((x) & BIT_MASK_LS_CV_OFFSET_3_0_8814B)                               \
	 << BIT_SHIFT_LS_CV_OFFSET_3_0_8814B)
#define BITS_LS_CV_OFFSET_3_0_8814B                                            \
	(BIT_MASK_LS_CV_OFFSET_3_0_8814B << BIT_SHIFT_LS_CV_OFFSET_3_0_8814B)
#define BIT_CLEAR_LS_CV_OFFSET_3_0_8814B(x)                                    \
	((x) & (~BITS_LS_CV_OFFSET_3_0_8814B))
#define BIT_GET_LS_CV_OFFSET_3_0_8814B(x)                                      \
	(((x) >> BIT_SHIFT_LS_CV_OFFSET_3_0_8814B) &                           \
	 BIT_MASK_LS_CV_OFFSET_3_0_8814B)
#define BIT_SET_LS_CV_OFFSET_3_0_8814B(x, v)                                   \
	(BIT_CLEAR_LS_CV_OFFSET_3_0_8814B(x) | BIT_LS_CV_OFFSET_3_0_8814B(v))

#define BIT_LS_EN_LC_CK40M_8814B BIT(11)
#define BIT_LS__CV_MANUAL_8814B BIT(10)
#define BIT_LS_PYPASS_PI_8814B BIT(9)
#define BIT_MBIASE_8814B BIT(4)

/* 2 REG_ANAPAR_MAC_4_8814B */
#define BIT_LS_TIE_MID_MODE_8814B BIT(28)

#define BIT_SHIFT_LS_SYNC_CYCLE_1_0_8814B 26
#define BIT_MASK_LS_SYNC_CYCLE_1_0_8814B 0x3
#define BIT_LS_SYNC_CYCLE_1_0_8814B(x)                                         \
	(((x) & BIT_MASK_LS_SYNC_CYCLE_1_0_8814B)                              \
	 << BIT_SHIFT_LS_SYNC_CYCLE_1_0_8814B)
#define BITS_LS_SYNC_CYCLE_1_0_8814B                                           \
	(BIT_MASK_LS_SYNC_CYCLE_1_0_8814B << BIT_SHIFT_LS_SYNC_CYCLE_1_0_8814B)
#define BIT_CLEAR_LS_SYNC_CYCLE_1_0_8814B(x)                                   \
	((x) & (~BITS_LS_SYNC_CYCLE_1_0_8814B))
#define BIT_GET_LS_SYNC_CYCLE_1_0_8814B(x)                                     \
	(((x) >> BIT_SHIFT_LS_SYNC_CYCLE_1_0_8814B) &                          \
	 BIT_MASK_LS_SYNC_CYCLE_1_0_8814B)
#define BIT_SET_LS_SYNC_CYCLE_1_0_8814B(x, v)                                  \
	(BIT_CLEAR_LS_SYNC_CYCLE_1_0_8814B(x) | BIT_LS_SYNC_CYCLE_1_0_8814B(v))

#define BIT_LS_SDM_ORDER_8814B BIT(25)
#define BIT_LS_RST_LC_CAL_8814B BIT(14)
#define BIT_LS_RSTB_8814B BIT(13)
#define BIT_LS_POW_LC_CAL_PREP_8814B BIT(11)

#define BIT_SHIFT_LCK_XTAL_DIVISOR_1_0_8814B 0
#define BIT_MASK_LCK_XTAL_DIVISOR_1_0_8814B 0x3
#define BIT_LCK_XTAL_DIVISOR_1_0_8814B(x)                                      \
	(((x) & BIT_MASK_LCK_XTAL_DIVISOR_1_0_8814B)                           \
	 << BIT_SHIFT_LCK_XTAL_DIVISOR_1_0_8814B)
#define BITS_LCK_XTAL_DIVISOR_1_0_8814B                                        \
	(BIT_MASK_LCK_XTAL_DIVISOR_1_0_8814B                                   \
	 << BIT_SHIFT_LCK_XTAL_DIVISOR_1_0_8814B)
#define BIT_CLEAR_LCK_XTAL_DIVISOR_1_0_8814B(x)                                \
	((x) & (~BITS_LCK_XTAL_DIVISOR_1_0_8814B))
#define BIT_GET_LCK_XTAL_DIVISOR_1_0_8814B(x)                                  \
	(((x) >> BIT_SHIFT_LCK_XTAL_DIVISOR_1_0_8814B) &                       \
	 BIT_MASK_LCK_XTAL_DIVISOR_1_0_8814B)
#define BIT_SET_LCK_XTAL_DIVISOR_1_0_8814B(x, v)                               \
	(BIT_CLEAR_LCK_XTAL_DIVISOR_1_0_8814B(x) |                             \
	 BIT_LCK_XTAL_DIVISOR_1_0_8814B(v))

/* 2 REG_ANAPAR_MAC_5_8814B */

#define BIT_SHIFT_LS_XTAL_SEL_3_0_8814B 0
#define BIT_MASK_LS_XTAL_SEL_3_0_8814B 0xf
#define BIT_LS_XTAL_SEL_3_0_8814B(x)                                           \
	(((x) & BIT_MASK_LS_XTAL_SEL_3_0_8814B)                                \
	 << BIT_SHIFT_LS_XTAL_SEL_3_0_8814B)
#define BITS_LS_XTAL_SEL_3_0_8814B                                             \
	(BIT_MASK_LS_XTAL_SEL_3_0_8814B << BIT_SHIFT_LS_XTAL_SEL_3_0_8814B)
#define BIT_CLEAR_LS_XTAL_SEL_3_0_8814B(x) ((x) & (~BITS_LS_XTAL_SEL_3_0_8814B))
#define BIT_GET_LS_XTAL_SEL_3_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_LS_XTAL_SEL_3_0_8814B) &                            \
	 BIT_MASK_LS_XTAL_SEL_3_0_8814B)
#define BIT_SET_LS_XTAL_SEL_3_0_8814B(x, v)                                    \
	(BIT_CLEAR_LS_XTAL_SEL_3_0_8814B(x) | BIT_LS_XTAL_SEL_3_0_8814B(v))

/* 2 REG_ANAPAR_MAC_6_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ANAPAR_MAC_7_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ANAPAR_MAC_8_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ANAPAR_XTAL_0_8814B */
#define BIT_XTAL_DRV_RF1_0_8814B BIT(31)
#define BIT_XTAL_GATED_RF1N_8814B BIT(30)
#define BIT_XTAL_GATED_RF1P_8814B BIT(29)
#define BIT_XTAL_GM_SEP_V2_8814B BIT(28)

#define BIT_SHIFT_XTAL_LDO_1_0_8814B 26
#define BIT_MASK_XTAL_LDO_1_0_8814B 0x3
#define BIT_XTAL_LDO_1_0_8814B(x)                                              \
	(((x) & BIT_MASK_XTAL_LDO_1_0_8814B) << BIT_SHIFT_XTAL_LDO_1_0_8814B)
#define BITS_XTAL_LDO_1_0_8814B                                                \
	(BIT_MASK_XTAL_LDO_1_0_8814B << BIT_SHIFT_XTAL_LDO_1_0_8814B)
#define BIT_CLEAR_XTAL_LDO_1_0_8814B(x) ((x) & (~BITS_XTAL_LDO_1_0_8814B))
#define BIT_GET_XTAL_LDO_1_0_8814B(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_LDO_1_0_8814B) & BIT_MASK_XTAL_LDO_1_0_8814B)
#define BIT_SET_XTAL_LDO_1_0_8814B(x, v)                                       \
	(BIT_CLEAR_XTAL_LDO_1_0_8814B(x) | BIT_XTAL_LDO_1_0_8814B(v))

#define BIT_XQSEL_V1_8814B BIT(25)
#define BIT_GATED_XTAL_OK0_8814B BIT(24)

#define BIT_SHIFT_XTAL_SC_XO_6_0_8814B 17
#define BIT_MASK_XTAL_SC_XO_6_0_8814B 0x7f
#define BIT_XTAL_SC_XO_6_0_8814B(x)                                            \
	(((x) & BIT_MASK_XTAL_SC_XO_6_0_8814B)                                 \
	 << BIT_SHIFT_XTAL_SC_XO_6_0_8814B)
#define BITS_XTAL_SC_XO_6_0_8814B                                              \
	(BIT_MASK_XTAL_SC_XO_6_0_8814B << BIT_SHIFT_XTAL_SC_XO_6_0_8814B)
#define BIT_CLEAR_XTAL_SC_XO_6_0_8814B(x) ((x) & (~BITS_XTAL_SC_XO_6_0_8814B))
#define BIT_GET_XTAL_SC_XO_6_0_8814B(x)                                        \
	(((x) >> BIT_SHIFT_XTAL_SC_XO_6_0_8814B) &                             \
	 BIT_MASK_XTAL_SC_XO_6_0_8814B)
#define BIT_SET_XTAL_SC_XO_6_0_8814B(x, v)                                     \
	(BIT_CLEAR_XTAL_SC_XO_6_0_8814B(x) | BIT_XTAL_SC_XO_6_0_8814B(v))

#define BIT_SHIFT_XTAL_SC_XI_6_0_8814B 10
#define BIT_MASK_XTAL_SC_XI_6_0_8814B 0x7f
#define BIT_XTAL_SC_XI_6_0_8814B(x)                                            \
	(((x) & BIT_MASK_XTAL_SC_XI_6_0_8814B)                                 \
	 << BIT_SHIFT_XTAL_SC_XI_6_0_8814B)
#define BITS_XTAL_SC_XI_6_0_8814B                                              \
	(BIT_MASK_XTAL_SC_XI_6_0_8814B << BIT_SHIFT_XTAL_SC_XI_6_0_8814B)
#define BIT_CLEAR_XTAL_SC_XI_6_0_8814B(x) ((x) & (~BITS_XTAL_SC_XI_6_0_8814B))
#define BIT_GET_XTAL_SC_XI_6_0_8814B(x)                                        \
	(((x) >> BIT_SHIFT_XTAL_SC_XI_6_0_8814B) &                             \
	 BIT_MASK_XTAL_SC_XI_6_0_8814B)
#define BIT_SET_XTAL_SC_XI_6_0_8814B(x, v)                                     \
	(BIT_CLEAR_XTAL_SC_XI_6_0_8814B(x) | BIT_XTAL_SC_XI_6_0_8814B(v))

#define BIT_SHIFT_XTAL_GMN_4_0_8814B 5
#define BIT_MASK_XTAL_GMN_4_0_8814B 0x1f
#define BIT_XTAL_GMN_4_0_8814B(x)                                              \
	(((x) & BIT_MASK_XTAL_GMN_4_0_8814B) << BIT_SHIFT_XTAL_GMN_4_0_8814B)
#define BITS_XTAL_GMN_4_0_8814B                                                \
	(BIT_MASK_XTAL_GMN_4_0_8814B << BIT_SHIFT_XTAL_GMN_4_0_8814B)
#define BIT_CLEAR_XTAL_GMN_4_0_8814B(x) ((x) & (~BITS_XTAL_GMN_4_0_8814B))
#define BIT_GET_XTAL_GMN_4_0_8814B(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_GMN_4_0_8814B) & BIT_MASK_XTAL_GMN_4_0_8814B)
#define BIT_SET_XTAL_GMN_4_0_8814B(x, v)                                       \
	(BIT_CLEAR_XTAL_GMN_4_0_8814B(x) | BIT_XTAL_GMN_4_0_8814B(v))

#define BIT_SHIFT_XTAL_GMP_4_0_8814B 0
#define BIT_MASK_XTAL_GMP_4_0_8814B 0x1f
#define BIT_XTAL_GMP_4_0_8814B(x)                                              \
	(((x) & BIT_MASK_XTAL_GMP_4_0_8814B) << BIT_SHIFT_XTAL_GMP_4_0_8814B)
#define BITS_XTAL_GMP_4_0_8814B                                                \
	(BIT_MASK_XTAL_GMP_4_0_8814B << BIT_SHIFT_XTAL_GMP_4_0_8814B)
#define BIT_CLEAR_XTAL_GMP_4_0_8814B(x) ((x) & (~BITS_XTAL_GMP_4_0_8814B))
#define BIT_GET_XTAL_GMP_4_0_8814B(x)                                          \
	(((x) >> BIT_SHIFT_XTAL_GMP_4_0_8814B) & BIT_MASK_XTAL_GMP_4_0_8814B)
#define BIT_SET_XTAL_GMP_4_0_8814B(x, v)                                       \
	(BIT_CLEAR_XTAL_GMP_4_0_8814B(x) | BIT_XTAL_GMP_4_0_8814B(v))

/* 2 REG_ANAPAR_XTAL_1_8814B */

#define BIT_SHIFT_XTAL_LDO_OK_1_0_8814B 30
#define BIT_MASK_XTAL_LDO_OK_1_0_8814B 0x3
#define BIT_XTAL_LDO_OK_1_0_8814B(x)                                           \
	(((x) & BIT_MASK_XTAL_LDO_OK_1_0_8814B)                                \
	 << BIT_SHIFT_XTAL_LDO_OK_1_0_8814B)
#define BITS_XTAL_LDO_OK_1_0_8814B                                             \
	(BIT_MASK_XTAL_LDO_OK_1_0_8814B << BIT_SHIFT_XTAL_LDO_OK_1_0_8814B)
#define BIT_CLEAR_XTAL_LDO_OK_1_0_8814B(x) ((x) & (~BITS_XTAL_LDO_OK_1_0_8814B))
#define BIT_GET_XTAL_LDO_OK_1_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_XTAL_LDO_OK_1_0_8814B) &                            \
	 BIT_MASK_XTAL_LDO_OK_1_0_8814B)
#define BIT_SET_XTAL_LDO_OK_1_0_8814B(x, v)                                    \
	(BIT_CLEAR_XTAL_LDO_OK_1_0_8814B(x) | BIT_XTAL_LDO_OK_1_0_8814B(v))

#define BIT_SHIFT_XTAL_XORES_SEL_2_0_8814B 27
#define BIT_MASK_XTAL_XORES_SEL_2_0_8814B 0x7
#define BIT_XTAL_XORES_SEL_2_0_8814B(x)                                        \
	(((x) & BIT_MASK_XTAL_XORES_SEL_2_0_8814B)                             \
	 << BIT_SHIFT_XTAL_XORES_SEL_2_0_8814B)
#define BITS_XTAL_XORES_SEL_2_0_8814B                                          \
	(BIT_MASK_XTAL_XORES_SEL_2_0_8814B                                     \
	 << BIT_SHIFT_XTAL_XORES_SEL_2_0_8814B)
#define BIT_CLEAR_XTAL_XORES_SEL_2_0_8814B(x)                                  \
	((x) & (~BITS_XTAL_XORES_SEL_2_0_8814B))
#define BIT_GET_XTAL_XORES_SEL_2_0_8814B(x)                                    \
	(((x) >> BIT_SHIFT_XTAL_XORES_SEL_2_0_8814B) &                         \
	 BIT_MASK_XTAL_XORES_SEL_2_0_8814B)
#define BIT_SET_XTAL_XORES_SEL_2_0_8814B(x, v)                                 \
	(BIT_CLEAR_XTAL_XORES_SEL_2_0_8814B(x) |                               \
	 BIT_XTAL_XORES_SEL_2_0_8814B(v))

#define BIT_SHIFT_XTAL_AAC_PK_SEL_1_0_8814B 25
#define BIT_MASK_XTAL_AAC_PK_SEL_1_0_8814B 0x3
#define BIT_XTAL_AAC_PK_SEL_1_0_8814B(x)                                       \
	(((x) & BIT_MASK_XTAL_AAC_PK_SEL_1_0_8814B)                            \
	 << BIT_SHIFT_XTAL_AAC_PK_SEL_1_0_8814B)
#define BITS_XTAL_AAC_PK_SEL_1_0_8814B                                         \
	(BIT_MASK_XTAL_AAC_PK_SEL_1_0_8814B                                    \
	 << BIT_SHIFT_XTAL_AAC_PK_SEL_1_0_8814B)
#define BIT_CLEAR_XTAL_AAC_PK_SEL_1_0_8814B(x)                                 \
	((x) & (~BITS_XTAL_AAC_PK_SEL_1_0_8814B))
#define BIT_GET_XTAL_AAC_PK_SEL_1_0_8814B(x)                                   \
	(((x) >> BIT_SHIFT_XTAL_AAC_PK_SEL_1_0_8814B) &                        \
	 BIT_MASK_XTAL_AAC_PK_SEL_1_0_8814B)
#define BIT_SET_XTAL_AAC_PK_SEL_1_0_8814B(x, v)                                \
	(BIT_CLEAR_XTAL_AAC_PK_SEL_1_0_8814B(x) |                              \
	 BIT_XTAL_AAC_PK_SEL_1_0_8814B(v))

#define BIT_EN_XTAL_AAC_PKDET_8814B BIT(24)
#define BIT_EN_XTAL_AAC_GM_8814B BIT(23)
#define BIT_XTAL_LPMODE_8814B BIT(22)

#define BIT_SHIFT_XTAL_SEL_TOK_2_0_8814B 19
#define BIT_MASK_XTAL_SEL_TOK_2_0_8814B 0x7
#define BIT_XTAL_SEL_TOK_2_0_8814B(x)                                          \
	(((x) & BIT_MASK_XTAL_SEL_TOK_2_0_8814B)                               \
	 << BIT_SHIFT_XTAL_SEL_TOK_2_0_8814B)
#define BITS_XTAL_SEL_TOK_2_0_8814B                                            \
	(BIT_MASK_XTAL_SEL_TOK_2_0_8814B << BIT_SHIFT_XTAL_SEL_TOK_2_0_8814B)
#define BIT_CLEAR_XTAL_SEL_TOK_2_0_8814B(x)                                    \
	((x) & (~BITS_XTAL_SEL_TOK_2_0_8814B))
#define BIT_GET_XTAL_SEL_TOK_2_0_8814B(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_SEL_TOK_2_0_8814B) &                           \
	 BIT_MASK_XTAL_SEL_TOK_2_0_8814B)
#define BIT_SET_XTAL_SEL_TOK_2_0_8814B(x, v)                                   \
	(BIT_CLEAR_XTAL_SEL_TOK_2_0_8814B(x) | BIT_XTAL_SEL_TOK_2_0_8814B(v))

#define BIT_XQSEL_RF_AWAKE_V2_8814B BIT(18)
#define BIT_XQSEL_RF_INITIAL_V2_8814B BIT(17)
#define BIT_XTAL_DELAY_USB_V1_8814B BIT(16)
#define BIT_XTAL_DELAY_DIGI_V1_8814B BIT(15)
#define BIT_XTAL_DELAY_AFE_V1_8814B BIT(14)
#define BIT_XTAL_DRV_RF_LATCH_V3_8814B BIT(13)

#define BIT_SHIFT_XTAL_DRV_DIGI_1_0_8814B 11
#define BIT_MASK_XTAL_DRV_DIGI_1_0_8814B 0x3
#define BIT_XTAL_DRV_DIGI_1_0_8814B(x)                                         \
	(((x) & BIT_MASK_XTAL_DRV_DIGI_1_0_8814B)                              \
	 << BIT_SHIFT_XTAL_DRV_DIGI_1_0_8814B)
#define BITS_XTAL_DRV_DIGI_1_0_8814B                                           \
	(BIT_MASK_XTAL_DRV_DIGI_1_0_8814B << BIT_SHIFT_XTAL_DRV_DIGI_1_0_8814B)
#define BIT_CLEAR_XTAL_DRV_DIGI_1_0_8814B(x)                                   \
	((x) & (~BITS_XTAL_DRV_DIGI_1_0_8814B))
#define BIT_GET_XTAL_DRV_DIGI_1_0_8814B(x)                                     \
	(((x) >> BIT_SHIFT_XTAL_DRV_DIGI_1_0_8814B) &                          \
	 BIT_MASK_XTAL_DRV_DIGI_1_0_8814B)
#define BIT_SET_XTAL_DRV_DIGI_1_0_8814B(x, v)                                  \
	(BIT_CLEAR_XTAL_DRV_DIGI_1_0_8814B(x) | BIT_XTAL_DRV_DIGI_1_0_8814B(v))

#define BIT_XTAL_GATED_DIGIN_8814B BIT(10)
#define BIT_XTAL_GATED_DIGIP_8814B BIT(9)

#define BIT_SHIFT_XTAL_DRV_USB_1_0_8814B 7
#define BIT_MASK_XTAL_DRV_USB_1_0_8814B 0x3
#define BIT_XTAL_DRV_USB_1_0_8814B(x)                                          \
	(((x) & BIT_MASK_XTAL_DRV_USB_1_0_8814B)                               \
	 << BIT_SHIFT_XTAL_DRV_USB_1_0_8814B)
#define BITS_XTAL_DRV_USB_1_0_8814B                                            \
	(BIT_MASK_XTAL_DRV_USB_1_0_8814B << BIT_SHIFT_XTAL_DRV_USB_1_0_8814B)
#define BIT_CLEAR_XTAL_DRV_USB_1_0_8814B(x)                                    \
	((x) & (~BITS_XTAL_DRV_USB_1_0_8814B))
#define BIT_GET_XTAL_DRV_USB_1_0_8814B(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_DRV_USB_1_0_8814B) &                           \
	 BIT_MASK_XTAL_DRV_USB_1_0_8814B)
#define BIT_SET_XTAL_DRV_USB_1_0_8814B(x, v)                                   \
	(BIT_CLEAR_XTAL_DRV_USB_1_0_8814B(x) | BIT_XTAL_DRV_USB_1_0_8814B(v))

#define BIT_XTAL_GATED_USBN_8814B BIT(6)
#define BIT_XTAL_GATED_USBP_8814B BIT(5)

#define BIT_SHIFT_XTAL_DRV_AFE_1_0_8814B 3
#define BIT_MASK_XTAL_DRV_AFE_1_0_8814B 0x3
#define BIT_XTAL_DRV_AFE_1_0_8814B(x)                                          \
	(((x) & BIT_MASK_XTAL_DRV_AFE_1_0_8814B)                               \
	 << BIT_SHIFT_XTAL_DRV_AFE_1_0_8814B)
#define BITS_XTAL_DRV_AFE_1_0_8814B                                            \
	(BIT_MASK_XTAL_DRV_AFE_1_0_8814B << BIT_SHIFT_XTAL_DRV_AFE_1_0_8814B)
#define BIT_CLEAR_XTAL_DRV_AFE_1_0_8814B(x)                                    \
	((x) & (~BITS_XTAL_DRV_AFE_1_0_8814B))
#define BIT_GET_XTAL_DRV_AFE_1_0_8814B(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_DRV_AFE_1_0_8814B) &                           \
	 BIT_MASK_XTAL_DRV_AFE_1_0_8814B)
#define BIT_SET_XTAL_DRV_AFE_1_0_8814B(x, v)                                   \
	(BIT_CLEAR_XTAL_DRV_AFE_1_0_8814B(x) | BIT_XTAL_DRV_AFE_1_0_8814B(v))

#define BIT_XTAL_GATED_AFEN_8814B BIT(2)
#define BIT_XTAL_GATED_AFEP_8814B BIT(1)
#define BIT_XTAL_DRV_RF1_1_8814B BIT(0)

/* 2 REG_ANAPAR_XTAL_2_8814B */
#define BIT_XTAL_DRV_RF2_LATCH_8814B BIT(6)

#define BIT_SHIFT_XTAL_DRV_RF2_1_0_8814B 4
#define BIT_MASK_XTAL_DRV_RF2_1_0_8814B 0x3
#define BIT_XTAL_DRV_RF2_1_0_8814B(x)                                          \
	(((x) & BIT_MASK_XTAL_DRV_RF2_1_0_8814B)                               \
	 << BIT_SHIFT_XTAL_DRV_RF2_1_0_8814B)
#define BITS_XTAL_DRV_RF2_1_0_8814B                                            \
	(BIT_MASK_XTAL_DRV_RF2_1_0_8814B << BIT_SHIFT_XTAL_DRV_RF2_1_0_8814B)
#define BIT_CLEAR_XTAL_DRV_RF2_1_0_8814B(x)                                    \
	((x) & (~BITS_XTAL_DRV_RF2_1_0_8814B))
#define BIT_GET_XTAL_DRV_RF2_1_0_8814B(x)                                      \
	(((x) >> BIT_SHIFT_XTAL_DRV_RF2_1_0_8814B) &                           \
	 BIT_MASK_XTAL_DRV_RF2_1_0_8814B)
#define BIT_SET_XTAL_DRV_RF2_1_0_8814B(x, v)                                   \
	(BIT_CLEAR_XTAL_DRV_RF2_1_0_8814B(x) | BIT_XTAL_DRV_RF2_1_0_8814B(v))

#define BIT_XTAL_GATED_RF2N_8814B BIT(3)
#define BIT_XTAL_GATED_RF2P_8814B BIT(2)
#define BIT_XTAL_LDO_DI_8814B BIT(1)
#define BIT_XTAL_SEL_PWR_8814B BIT(0)

/* 2 REG_ANAPAR_XTAL_AAC_8814B */
#define BIT_EN_XTAL_AAC_TRIG_8814B BIT(28)
#define BIT_EN_XTAL_AAC_8814B BIT(27)
#define BIT_EN_XTAL_AAC_DIGI_8814B BIT(26)

#define BIT_SHIFT_GM_MANUAL_4_0_8814B 21
#define BIT_MASK_GM_MANUAL_4_0_8814B 0x1f
#define BIT_GM_MANUAL_4_0_8814B(x)                                             \
	(((x) & BIT_MASK_GM_MANUAL_4_0_8814B) << BIT_SHIFT_GM_MANUAL_4_0_8814B)
#define BITS_GM_MANUAL_4_0_8814B                                               \
	(BIT_MASK_GM_MANUAL_4_0_8814B << BIT_SHIFT_GM_MANUAL_4_0_8814B)
#define BIT_CLEAR_GM_MANUAL_4_0_8814B(x) ((x) & (~BITS_GM_MANUAL_4_0_8814B))
#define BIT_GET_GM_MANUAL_4_0_8814B(x)                                         \
	(((x) >> BIT_SHIFT_GM_MANUAL_4_0_8814B) & BIT_MASK_GM_MANUAL_4_0_8814B)
#define BIT_SET_GM_MANUAL_4_0_8814B(x, v)                                      \
	(BIT_CLEAR_GM_MANUAL_4_0_8814B(x) | BIT_GM_MANUAL_4_0_8814B(v))

#define BIT_SHIFT_GM_STUP_4_0_8814B 16
#define BIT_MASK_GM_STUP_4_0_8814B 0x1f
#define BIT_GM_STUP_4_0_8814B(x)                                               \
	(((x) & BIT_MASK_GM_STUP_4_0_8814B) << BIT_SHIFT_GM_STUP_4_0_8814B)
#define BITS_GM_STUP_4_0_8814B                                                 \
	(BIT_MASK_GM_STUP_4_0_8814B << BIT_SHIFT_GM_STUP_4_0_8814B)
#define BIT_CLEAR_GM_STUP_4_0_8814B(x) ((x) & (~BITS_GM_STUP_4_0_8814B))
#define BIT_GET_GM_STUP_4_0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_GM_STUP_4_0_8814B) & BIT_MASK_GM_STUP_4_0_8814B)
#define BIT_SET_GM_STUP_4_0_8814B(x, v)                                        \
	(BIT_CLEAR_GM_STUP_4_0_8814B(x) | BIT_GM_STUP_4_0_8814B(v))

#define BIT_SHIFT_XTAL_CK_SET_2_0_8814B 13
#define BIT_MASK_XTAL_CK_SET_2_0_8814B 0x7
#define BIT_XTAL_CK_SET_2_0_8814B(x)                                           \
	(((x) & BIT_MASK_XTAL_CK_SET_2_0_8814B)                                \
	 << BIT_SHIFT_XTAL_CK_SET_2_0_8814B)
#define BITS_XTAL_CK_SET_2_0_8814B                                             \
	(BIT_MASK_XTAL_CK_SET_2_0_8814B << BIT_SHIFT_XTAL_CK_SET_2_0_8814B)
#define BIT_CLEAR_XTAL_CK_SET_2_0_8814B(x) ((x) & (~BITS_XTAL_CK_SET_2_0_8814B))
#define BIT_GET_XTAL_CK_SET_2_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_XTAL_CK_SET_2_0_8814B) &                            \
	 BIT_MASK_XTAL_CK_SET_2_0_8814B)
#define BIT_SET_XTAL_CK_SET_2_0_8814B(x, v)                                    \
	(BIT_CLEAR_XTAL_CK_SET_2_0_8814B(x) | BIT_XTAL_CK_SET_2_0_8814B(v))

#define BIT_SHIFT_GM_INIT_4_0_8814B 8
#define BIT_MASK_GM_INIT_4_0_8814B 0x1f
#define BIT_GM_INIT_4_0_8814B(x)                                               \
	(((x) & BIT_MASK_GM_INIT_4_0_8814B) << BIT_SHIFT_GM_INIT_4_0_8814B)
#define BITS_GM_INIT_4_0_8814B                                                 \
	(BIT_MASK_GM_INIT_4_0_8814B << BIT_SHIFT_GM_INIT_4_0_8814B)
#define BIT_CLEAR_GM_INIT_4_0_8814B(x) ((x) & (~BITS_GM_INIT_4_0_8814B))
#define BIT_GET_GM_INIT_4_0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_GM_INIT_4_0_8814B) & BIT_MASK_GM_INIT_4_0_8814B)
#define BIT_SET_GM_INIT_4_0_8814B(x, v)                                        \
	(BIT_CLEAR_GM_INIT_4_0_8814B(x) | BIT_GM_INIT_4_0_8814B(v))

#define BIT_GM_STEP_8814B BIT(7)

#define BIT_SHIFT_XAAC_GM_OFFSET_4_0_8814B 2
#define BIT_MASK_XAAC_GM_OFFSET_4_0_8814B 0x1f
#define BIT_XAAC_GM_OFFSET_4_0_8814B(x)                                        \
	(((x) & BIT_MASK_XAAC_GM_OFFSET_4_0_8814B)                             \
	 << BIT_SHIFT_XAAC_GM_OFFSET_4_0_8814B)
#define BITS_XAAC_GM_OFFSET_4_0_8814B                                          \
	(BIT_MASK_XAAC_GM_OFFSET_4_0_8814B                                     \
	 << BIT_SHIFT_XAAC_GM_OFFSET_4_0_8814B)
#define BIT_CLEAR_XAAC_GM_OFFSET_4_0_8814B(x)                                  \
	((x) & (~BITS_XAAC_GM_OFFSET_4_0_8814B))
#define BIT_GET_XAAC_GM_OFFSET_4_0_8814B(x)                                    \
	(((x) >> BIT_SHIFT_XAAC_GM_OFFSET_4_0_8814B) &                         \
	 BIT_MASK_XAAC_GM_OFFSET_4_0_8814B)
#define BIT_SET_XAAC_GM_OFFSET_4_0_8814B(x, v)                                 \
	(BIT_CLEAR_XAAC_GM_OFFSET_4_0_8814B(x) |                               \
	 BIT_XAAC_GM_OFFSET_4_0_8814B(v))

#define BIT_OFFSET_PLUS_8814B BIT(1)
#define BIT_RESET_N_8814B BIT(0)

/* 2 REG_ANAPAR_XTAL_R_ONLY_8814B */
#define BIT_XTAL_PKDET_OUT_8814B BIT(6)

#define BIT_SHIFT_XTAL_GM_AAC_4_0_8814B 1
#define BIT_MASK_XTAL_GM_AAC_4_0_8814B 0x1f
#define BIT_XTAL_GM_AAC_4_0_8814B(x)                                           \
	(((x) & BIT_MASK_XTAL_GM_AAC_4_0_8814B)                                \
	 << BIT_SHIFT_XTAL_GM_AAC_4_0_8814B)
#define BITS_XTAL_GM_AAC_4_0_8814B                                             \
	(BIT_MASK_XTAL_GM_AAC_4_0_8814B << BIT_SHIFT_XTAL_GM_AAC_4_0_8814B)
#define BIT_CLEAR_XTAL_GM_AAC_4_0_8814B(x) ((x) & (~BITS_XTAL_GM_AAC_4_0_8814B))
#define BIT_GET_XTAL_GM_AAC_4_0_8814B(x)                                       \
	(((x) >> BIT_SHIFT_XTAL_GM_AAC_4_0_8814B) &                            \
	 BIT_MASK_XTAL_GM_AAC_4_0_8814B)
#define BIT_SET_XTAL_GM_AAC_4_0_8814B(x, v)                                    \
	(BIT_CLEAR_XTAL_GM_AAC_4_0_8814B(x) | BIT_XTAL_GM_AAC_4_0_8814B(v))

#define BIT_XAAC_READY_8814B BIT(0)

/* 2 REG_CPHY_LDO_8814B */

#define BIT_SHIFT_CPHY_LDO_PD_8814B 12
#define BIT_MASK_CPHY_LDO_PD_8814B 0x3
#define BIT_CPHY_LDO_PD_8814B(x)                                               \
	(((x) & BIT_MASK_CPHY_LDO_PD_8814B) << BIT_SHIFT_CPHY_LDO_PD_8814B)
#define BITS_CPHY_LDO_PD_8814B                                                 \
	(BIT_MASK_CPHY_LDO_PD_8814B << BIT_SHIFT_CPHY_LDO_PD_8814B)
#define BIT_CLEAR_CPHY_LDO_PD_8814B(x) ((x) & (~BITS_CPHY_LDO_PD_8814B))
#define BIT_GET_CPHY_LDO_PD_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CPHY_LDO_PD_8814B) & BIT_MASK_CPHY_LDO_PD_8814B)
#define BIT_SET_CPHY_LDO_PD_8814B(x, v)                                        \
	(BIT_CLEAR_CPHY_LDO_PD_8814B(x) | BIT_CPHY_LDO_PD_8814B(v))

#define BIT_SHIFT_CPHY_LDO_SR_8814B 10
#define BIT_MASK_CPHY_LDO_SR_8814B 0x3
#define BIT_CPHY_LDO_SR_8814B(x)                                               \
	(((x) & BIT_MASK_CPHY_LDO_SR_8814B) << BIT_SHIFT_CPHY_LDO_SR_8814B)
#define BITS_CPHY_LDO_SR_8814B                                                 \
	(BIT_MASK_CPHY_LDO_SR_8814B << BIT_SHIFT_CPHY_LDO_SR_8814B)
#define BIT_CLEAR_CPHY_LDO_SR_8814B(x) ((x) & (~BITS_CPHY_LDO_SR_8814B))
#define BIT_GET_CPHY_LDO_SR_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CPHY_LDO_SR_8814B) & BIT_MASK_CPHY_LDO_SR_8814B)
#define BIT_SET_CPHY_LDO_SR_8814B(x, v)                                        \
	(BIT_CLEAR_CPHY_LDO_SR_8814B(x) | BIT_CPHY_LDO_SR_8814B(v))

#define BIT_SHIFT_CPHY_LDO_TUNEREF_8814B 8
#define BIT_MASK_CPHY_LDO_TUNEREF_8814B 0x3
#define BIT_CPHY_LDO_TUNEREF_8814B(x)                                          \
	(((x) & BIT_MASK_CPHY_LDO_TUNEREF_8814B)                               \
	 << BIT_SHIFT_CPHY_LDO_TUNEREF_8814B)
#define BITS_CPHY_LDO_TUNEREF_8814B                                            \
	(BIT_MASK_CPHY_LDO_TUNEREF_8814B << BIT_SHIFT_CPHY_LDO_TUNEREF_8814B)
#define BIT_CLEAR_CPHY_LDO_TUNEREF_8814B(x)                                    \
	((x) & (~BITS_CPHY_LDO_TUNEREF_8814B))
#define BIT_GET_CPHY_LDO_TUNEREF_8814B(x)                                      \
	(((x) >> BIT_SHIFT_CPHY_LDO_TUNEREF_8814B) &                           \
	 BIT_MASK_CPHY_LDO_TUNEREF_8814B)
#define BIT_SET_CPHY_LDO_TUNEREF_8814B(x, v)                                   \
	(BIT_CLEAR_CPHY_LDO_TUNEREF_8814B(x) | BIT_CPHY_LDO_TUNEREF_8814B(v))

#define BIT_SHIFT_CPHY_LDO_TUNE_VO_8814B 5
#define BIT_MASK_CPHY_LDO_TUNE_VO_8814B 0x7
#define BIT_CPHY_LDO_TUNE_VO_8814B(x)                                          \
	(((x) & BIT_MASK_CPHY_LDO_TUNE_VO_8814B)                               \
	 << BIT_SHIFT_CPHY_LDO_TUNE_VO_8814B)
#define BITS_CPHY_LDO_TUNE_VO_8814B                                            \
	(BIT_MASK_CPHY_LDO_TUNE_VO_8814B << BIT_SHIFT_CPHY_LDO_TUNE_VO_8814B)
#define BIT_CLEAR_CPHY_LDO_TUNE_VO_8814B(x)                                    \
	((x) & (~BITS_CPHY_LDO_TUNE_VO_8814B))
#define BIT_GET_CPHY_LDO_TUNE_VO_8814B(x)                                      \
	(((x) >> BIT_SHIFT_CPHY_LDO_TUNE_VO_8814B) &                           \
	 BIT_MASK_CPHY_LDO_TUNE_VO_8814B)
#define BIT_SET_CPHY_LDO_TUNE_VO_8814B(x, v)                                   \
	(BIT_CLEAR_CPHY_LDO_TUNE_VO_8814B(x) | BIT_CPHY_LDO_TUNE_VO_8814B(v))

#define BIT_SHIFT_CPHY_LDO_OCP_VTH_8814B 2
#define BIT_MASK_CPHY_LDO_OCP_VTH_8814B 0x7
#define BIT_CPHY_LDO_OCP_VTH_8814B(x)                                          \
	(((x) & BIT_MASK_CPHY_LDO_OCP_VTH_8814B)                               \
	 << BIT_SHIFT_CPHY_LDO_OCP_VTH_8814B)
#define BITS_CPHY_LDO_OCP_VTH_8814B                                            \
	(BIT_MASK_CPHY_LDO_OCP_VTH_8814B << BIT_SHIFT_CPHY_LDO_OCP_VTH_8814B)
#define BIT_CLEAR_CPHY_LDO_OCP_VTH_8814B(x)                                    \
	((x) & (~BITS_CPHY_LDO_OCP_VTH_8814B))
#define BIT_GET_CPHY_LDO_OCP_VTH_8814B(x)                                      \
	(((x) >> BIT_SHIFT_CPHY_LDO_OCP_VTH_8814B) &                           \
	 BIT_MASK_CPHY_LDO_OCP_VTH_8814B)
#define BIT_SET_CPHY_LDO_OCP_VTH_8814B(x, v)                                   \
	(BIT_CLEAR_CPHY_LDO_OCP_VTH_8814B(x) | BIT_CPHY_LDO_OCP_VTH_8814B(v))

#define BIT_SHIFT_VREF_LDO_OK_8814B 0
#define BIT_MASK_VREF_LDO_OK_8814B 0x3
#define BIT_VREF_LDO_OK_8814B(x)                                               \
	(((x) & BIT_MASK_VREF_LDO_OK_8814B) << BIT_SHIFT_VREF_LDO_OK_8814B)
#define BITS_VREF_LDO_OK_8814B                                                 \
	(BIT_MASK_VREF_LDO_OK_8814B << BIT_SHIFT_VREF_LDO_OK_8814B)
#define BIT_CLEAR_VREF_LDO_OK_8814B(x) ((x) & (~BITS_VREF_LDO_OK_8814B))
#define BIT_GET_VREF_LDO_OK_8814B(x)                                           \
	(((x) >> BIT_SHIFT_VREF_LDO_OK_8814B) & BIT_MASK_VREF_LDO_OK_8814B)
#define BIT_SET_VREF_LDO_OK_8814B(x, v)                                        \
	(BIT_CLEAR_VREF_LDO_OK_8814B(x) | BIT_VREF_LDO_OK_8814B(v))

/* 2 REG_CPHY_BG_8814B */

#define BIT_SHIFT_BG_8814B 0
#define BIT_MASK_BG_8814B 0x7
#define BIT_BG_8814B(x) (((x) & BIT_MASK_BG_8814B) << BIT_SHIFT_BG_8814B)
#define BITS_BG_8814B (BIT_MASK_BG_8814B << BIT_SHIFT_BG_8814B)
#define BIT_CLEAR_BG_8814B(x) ((x) & (~BITS_BG_8814B))
#define BIT_GET_BG_8814B(x) (((x) >> BIT_SHIFT_BG_8814B) & BIT_MASK_BG_8814B)
#define BIT_SET_BG_8814B(x, v) (BIT_CLEAR_BG_8814B(x) | BIT_BG_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HIMR_4_8814B */
#define BIT_TXBCN_OK_PORT4_8814B BIT(31)
#define BIT_TXBCN_OK_PORT3_8814B BIT(30)
#define BIT_TXBCN_OK_PORT2_8814B BIT(29)
#define BIT_TXBCN_OK_PORT1_8814B BIT(28)
#define BIT_TXBCN15OK_8814B BIT(23)
#define BIT_TXBCN14OK_8814B BIT(22)
#define BIT_TXBCN13OK_8814B BIT(21)
#define BIT_TXBCN12OK_8814B BIT(20)
#define BIT_TXBCN11OK_8814B BIT(19)
#define BIT_TXBCN10OK_8814B BIT(18)
#define BIT_TXBCN9OK_8814B BIT(17)
#define BIT_TXBCN8OK_8814B BIT(16)
#define BIT_BCNDERR_PORT4_8814B BIT(15)
#define BIT_BCNDERR_PORT3_8814B BIT(14)
#define BIT_BCNDERR_PORT2_8814B BIT(13)
#define BIT_BCNDERR_PORT1_8814B BIT(12)
#define BIT_TXBCN15ERR_8814B BIT(7)
#define BIT_TXBCN14ERR_8814B BIT(6)
#define BIT_TXBCN13ERR_8814B BIT(5)
#define BIT_TXBCN12ERR_8814B BIT(4)
#define BIT_TXBCN11ERR_8814B BIT(3)
#define BIT_TXBCN10ERR_8814B BIT(2)
#define BIT_TXBCN9ERR_8814B BIT(1)
#define BIT_TXBCN8ERR_8814B BIT(0)

/* 2 REG_HISR_4_8814B */
#define BIT_TXBCN_OK_PORT4_8814B BIT(31)
#define BIT_TXBCN_OK_PORT3_8814B BIT(30)
#define BIT_TXBCN_OK_PORT2_8814B BIT(29)
#define BIT_TXBCN_OK_PORT1_8814B BIT(28)
#define BIT_TXBCN15OK_8814B BIT(23)
#define BIT_TXBCN14OK_8814B BIT(22)
#define BIT_TXBCN13OK_8814B BIT(21)
#define BIT_TXBCN12OK_8814B BIT(20)
#define BIT_TXBCN11OK_8814B BIT(19)
#define BIT_TXBCN10OK_8814B BIT(18)
#define BIT_TXBCN9OK_8814B BIT(17)
#define BIT_TXBCN8OK_8814B BIT(16)
#define BIT_BCNDERR_PORT4_8814B BIT(15)
#define BIT_BCNDERR_PORT3_8814B BIT(14)
#define BIT_BCNDERR_PORT2_8814B BIT(13)
#define BIT_BCNDERR_PORT1_8814B BIT(12)
#define BIT_TXBCN15ERR_8814B BIT(7)
#define BIT_TXBCN14ERR_8814B BIT(6)
#define BIT_TXBCN13ERR_8814B BIT(5)
#define BIT_TXBCN12ERR_8814B BIT(4)
#define BIT_TXBCN11ERR_8814B BIT(3)
#define BIT_TXBCN10ERR_8814B BIT(2)
#define BIT_TXBCN9ERR_8814B BIT(1)
#define BIT_TXBCN8ERR_8814B BIT(0)

/* 2 REG_HIMR_5_8814B */
#define BIT_BCNDMAINT15_8814B BIT(23)
#define BIT_BCNDMAINT14_8814B BIT(22)
#define BIT_BCNDMAINT13_8814B BIT(21)
#define BIT_BCNDMAINT12_8814B BIT(20)
#define BIT_BCNDMAINT11_8814B BIT(19)
#define BIT_BCNDMAINT10_8814B BIT(18)
#define BIT_BCNDMAINT9_8814B BIT(17)
#define BIT_BCNDMAINT8_8814B BIT(16)
#define BIT_BCNDERR_PORT4_8814B BIT(15)
#define BIT_BCNDERR_PORT3_8814B BIT(14)
#define BIT_BCNDERR_PORT2_8814B BIT(13)
#define BIT_BCNDERR_PORT1_8814B BIT(12)
#define BIT_BCNDERR15_8814B BIT(7)
#define BIT_BCNDERR14_8814B BIT(6)
#define BIT_BCNDERR13_8814B BIT(5)
#define BIT_BCNDERR12_8814B BIT(4)
#define BIT_BCNDERR11_8814B BIT(3)
#define BIT_BCNDERR10_8814B BIT(2)
#define BIT_BCNDERR9_8814B BIT(1)
#define BIT_BCNDERR8_8814B BIT(0)

/* 2 REG_HISR_5_8814B */
#define BIT_BCNDMAINT15_8814B BIT(23)
#define BIT_BCNDMAINT14_8814B BIT(22)
#define BIT_BCNDMAINT13_8814B BIT(21)
#define BIT_BCNDMAINT12_8814B BIT(20)
#define BIT_BCNDMAINT11_8814B BIT(19)
#define BIT_BCNDMAINT10_8814B BIT(18)
#define BIT_BCNDMAINT9_8814B BIT(17)
#define BIT_BCNDMAINT8_8814B BIT(16)
#define BIT_BCNDERR_PORT4_8814B BIT(15)
#define BIT_BCNDERR_PORT3_8814B BIT(14)
#define BIT_BCNDERR_PORT2_8814B BIT(13)
#define BIT_BCNDERR_PORT1_8814B BIT(12)
#define BIT_BCNDERR15_8814B BIT(7)
#define BIT_BCNDERR14_8814B BIT(6)
#define BIT_BCNDERR13_8814B BIT(5)
#define BIT_BCNDERR12_8814B BIT(4)
#define BIT_BCNDERR11_8814B BIT(3)
#define BIT_BCNDERR10_8814B BIT(2)
#define BIT_BCNDERR9_8814B BIT(1)
#define BIT_BCNDERR8_8814B BIT(0)

/* 2 REG_SYS_CFG5_8814B */
#define BIT_LPS_STATUS_8814B BIT(3)
#define BIT_HCI_TXDMA_BUSY_8814B BIT(2)
#define BIT_HCI_TXDMA_ALLOW_8814B BIT(1)
#define BIT_FW_CTRL_HCI_TXDMA_EN_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HIMR_6_8814B */
#define BIT_ATIMEND_PORT4_8814B BIT(31)
#define BIT_ATIMEND_PORT3_8814B BIT(30)
#define BIT_ATIMEND_PORT2_8814B BIT(29)
#define BIT_ATIMEND_PORT1_8814B BIT(28)
#define BIT_ATIMEND15_8814B BIT(23)
#define BIT_ATIMEND14_8814B BIT(22)
#define BIT_ATIMEND13_8814B BIT(21)
#define BIT_ATIMEND12_8814B BIT(20)
#define BIT_ATIMEND11_8814B BIT(19)
#define BIT_ATIMEND10_8814B BIT(18)
#define BIT_ATIMEND9_8814B BIT(17)
#define BIT_ATIMEND8_8814B BIT(16)
#define BIT_PS_TIMER_EARLY_INT_5_8814B BIT(5)
#define BIT_PS_TIMER_EARLY_INT_4_8814B BIT(4)
#define BIT_PS_TIMER_EARLY_INT_3_8814B BIT(3)
#define BIT_PS_TIMER_EARLY_INT_2_8814B BIT(2)
#define BIT_PS_TIMER_EARLY_INT_1_8814B BIT(1)
#define BIT_PS_TIMER_EARLY_INT_0_8814B BIT(0)

/* 2 REG_HISR_6_8814B */
#define BIT_ATIMEND_PORT4_8814B BIT(31)
#define BIT_ATIMEND_PORT3_8814B BIT(30)
#define BIT_ATIMEND_PORT2_8814B BIT(29)
#define BIT_ATIMEND_PORT1_8814B BIT(28)
#define BIT_ATIMEND15_8814B BIT(23)
#define BIT_ATIMEND14_8814B BIT(22)
#define BIT_ATIMEND13_8814B BIT(21)
#define BIT_ATIMEND12_8814B BIT(20)
#define BIT_ATIMEND11_8814B BIT(19)
#define BIT_ATIMEND10_8814B BIT(18)
#define BIT_ATIMEND9_8814B BIT(17)
#define BIT_ATIMEND8_8814B BIT(16)
#define BIT_PS_TIMER_EARLY_INT_5_8814B BIT(5)
#define BIT_PS_TIMER_EARLY_INT_4_8814B BIT(4)
#define BIT_PS_TIMER_EARLY_INT_3_8814B BIT(3)
#define BIT_PS_TIMER_EARLY_INT_2_8814B BIT(2)
#define BIT_PS_TIMER_EARLY_INT_1_8814B BIT(1)
#define BIT_PS_TIMER_EARLY_INT_0_8814B BIT(0)

/* 2 REG_CPU_DMEM_CON_8814B */
#define BIT_WDT_AUTO_MODE_8814B BIT(22)
#define BIT_WDT_PLATFORM_EN_8814B BIT(21)
#define BIT_WDT_CPU_EN_8814B BIT(20)
#define BIT_WDT_OPT_IOWRAPPER_8814B BIT(19)
#define BIT_ANA_PORT_IDLE_8814B BIT(18)
#define BIT_MAC_PORT_IDLE_8814B BIT(17)
#define BIT_WL_PLATFORM_RST_8814B BIT(16)
#define BIT_WL_SECURITY_CLK_8814B BIT(15)
#define BIT_DDMA_EN_8814B BIT(8)

#define BIT_SHIFT_CPU_DMEM_CON_8814B 0
#define BIT_MASK_CPU_DMEM_CON_8814B 0xff
#define BIT_CPU_DMEM_CON_8814B(x)                                              \
	(((x) & BIT_MASK_CPU_DMEM_CON_8814B) << BIT_SHIFT_CPU_DMEM_CON_8814B)
#define BITS_CPU_DMEM_CON_8814B                                                \
	(BIT_MASK_CPU_DMEM_CON_8814B << BIT_SHIFT_CPU_DMEM_CON_8814B)
#define BIT_CLEAR_CPU_DMEM_CON_8814B(x) ((x) & (~BITS_CPU_DMEM_CON_8814B))
#define BIT_GET_CPU_DMEM_CON_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CPU_DMEM_CON_8814B) & BIT_MASK_CPU_DMEM_CON_8814B)
#define BIT_SET_CPU_DMEM_CON_8814B(x, v)                                       \
	(BIT_CLEAR_CPU_DMEM_CON_8814B(x) | BIT_CPU_DMEM_CON_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BOOT_REASON_8814B */

#define BIT_SHIFT_BOOT_REASON_V1_8814B 0
#define BIT_MASK_BOOT_REASON_V1_8814B 0x7
#define BIT_BOOT_REASON_V1_8814B(x)                                            \
	(((x) & BIT_MASK_BOOT_REASON_V1_8814B)                                 \
	 << BIT_SHIFT_BOOT_REASON_V1_8814B)
#define BITS_BOOT_REASON_V1_8814B                                              \
	(BIT_MASK_BOOT_REASON_V1_8814B << BIT_SHIFT_BOOT_REASON_V1_8814B)
#define BIT_CLEAR_BOOT_REASON_V1_8814B(x) ((x) & (~BITS_BOOT_REASON_V1_8814B))
#define BIT_GET_BOOT_REASON_V1_8814B(x)                                        \
	(((x) >> BIT_SHIFT_BOOT_REASON_V1_8814B) &                             \
	 BIT_MASK_BOOT_REASON_V1_8814B)
#define BIT_SET_BOOT_REASON_V1_8814B(x, v)                                     \
	(BIT_CLEAR_BOOT_REASON_V1_8814B(x) | BIT_BOOT_REASON_V1_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_DATA_CPU_CTL0_8814B */
#define BIT_DATA_FW_READY_8814B BIT(31)
#define BIT_WDT_SYS_RST_8814B BIT(13)
#define BIT_WDT_ENABLE_8814B BIT(12)

#define BIT_SHIFT_BOOT_SEL_8814B 6
#define BIT_MASK_BOOT_SEL_8814B 0x3
#define BIT_BOOT_SEL_8814B(x)                                                  \
	(((x) & BIT_MASK_BOOT_SEL_8814B) << BIT_SHIFT_BOOT_SEL_8814B)
#define BITS_BOOT_SEL_8814B                                                    \
	(BIT_MASK_BOOT_SEL_8814B << BIT_SHIFT_BOOT_SEL_8814B)
#define BIT_CLEAR_BOOT_SEL_8814B(x) ((x) & (~BITS_BOOT_SEL_8814B))
#define BIT_GET_BOOT_SEL_8814B(x)                                              \
	(((x) >> BIT_SHIFT_BOOT_SEL_8814B) & BIT_MASK_BOOT_SEL_8814B)
#define BIT_SET_BOOT_SEL_8814B(x, v)                                           \
	(BIT_CLEAR_BOOT_SEL_8814B(x) | BIT_BOOT_SEL_8814B(v))

#define BIT_CLK_SEL_8814B BIT(4)
#define BIT_DATA_PLATFORM_RST_8814B BIT(1)
#define BIT_DATA_CPU_RST_8814B BIT(0)

/* 2 REG_DATA_CPU_CTL1_8814B */
#define BIT_HOST_INTERFACE_IO_PATH_8814B BIT(7)
#define BIT_EN_TXDMA_OFLD_8814B BIT(6)
#define BIT_EN_RXDMA_OFLD_8814B BIT(5)
#define BIT_EN_HCI_DMA_TX_8814B BIT(4)
#define BIT_EN_HCI_DMA_RX_8814B BIT(3)
#define BIT_EN_AXI_DMA_TX_8814B BIT(2)
#define BIT_EN_AXI_DMA_RX_8814B BIT(1)
#define BIT_EN_PKT_ENG_8814B BIT(0)

/* 2 REG_TXDMA_STOP_HIMR_8814B */

#define BIT_SHIFT_NTH_TXDMA_STOP_INT_MSK_8814B 0
#define BIT_MASK_NTH_TXDMA_STOP_INT_MSK_8814B 0x1ffff
#define BIT_NTH_TXDMA_STOP_INT_MSK_8814B(x)                                    \
	(((x) & BIT_MASK_NTH_TXDMA_STOP_INT_MSK_8814B)                         \
	 << BIT_SHIFT_NTH_TXDMA_STOP_INT_MSK_8814B)
#define BITS_NTH_TXDMA_STOP_INT_MSK_8814B                                      \
	(BIT_MASK_NTH_TXDMA_STOP_INT_MSK_8814B                                 \
	 << BIT_SHIFT_NTH_TXDMA_STOP_INT_MSK_8814B)
#define BIT_CLEAR_NTH_TXDMA_STOP_INT_MSK_8814B(x)                              \
	((x) & (~BITS_NTH_TXDMA_STOP_INT_MSK_8814B))
#define BIT_GET_NTH_TXDMA_STOP_INT_MSK_8814B(x)                                \
	(((x) >> BIT_SHIFT_NTH_TXDMA_STOP_INT_MSK_8814B) &                     \
	 BIT_MASK_NTH_TXDMA_STOP_INT_MSK_8814B)
#define BIT_SET_NTH_TXDMA_STOP_INT_MSK_8814B(x, v)                             \
	(BIT_CLEAR_NTH_TXDMA_STOP_INT_MSK_8814B(x) |                           \
	 BIT_NTH_TXDMA_STOP_INT_MSK_8814B(v))

/* 2 REG_TXDMA_STOP_HISR_8814B */

#define BIT_SHIFT_NTH_TXDMA_STOP_INT_8814B 0
#define BIT_MASK_NTH_TXDMA_STOP_INT_8814B 0x1ffff
#define BIT_NTH_TXDMA_STOP_INT_8814B(x)                                        \
	(((x) & BIT_MASK_NTH_TXDMA_STOP_INT_8814B)                             \
	 << BIT_SHIFT_NTH_TXDMA_STOP_INT_8814B)
#define BITS_NTH_TXDMA_STOP_INT_8814B                                          \
	(BIT_MASK_NTH_TXDMA_STOP_INT_8814B                                     \
	 << BIT_SHIFT_NTH_TXDMA_STOP_INT_8814B)
#define BIT_CLEAR_NTH_TXDMA_STOP_INT_8814B(x)                                  \
	((x) & (~BITS_NTH_TXDMA_STOP_INT_8814B))
#define BIT_GET_NTH_TXDMA_STOP_INT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_NTH_TXDMA_STOP_INT_8814B) &                         \
	 BIT_MASK_NTH_TXDMA_STOP_INT_8814B)
#define BIT_SET_NTH_TXDMA_STOP_INT_8814B(x, v)                                 \
	(BIT_CLEAR_NTH_TXDMA_STOP_INT_8814B(x) |                               \
	 BIT_NTH_TXDMA_STOP_INT_8814B(v))

/* 2 REG_TXDMA_START_HIMR_8814B */

#define BIT_SHIFT_NTH_TXDMA_START_INT_MSK_8814B 0
#define BIT_MASK_NTH_TXDMA_START_INT_MSK_8814B 0x1ffff
#define BIT_NTH_TXDMA_START_INT_MSK_8814B(x)                                   \
	(((x) & BIT_MASK_NTH_TXDMA_START_INT_MSK_8814B)                        \
	 << BIT_SHIFT_NTH_TXDMA_START_INT_MSK_8814B)
#define BITS_NTH_TXDMA_START_INT_MSK_8814B                                     \
	(BIT_MASK_NTH_TXDMA_START_INT_MSK_8814B                                \
	 << BIT_SHIFT_NTH_TXDMA_START_INT_MSK_8814B)
#define BIT_CLEAR_NTH_TXDMA_START_INT_MSK_8814B(x)                             \
	((x) & (~BITS_NTH_TXDMA_START_INT_MSK_8814B))
#define BIT_GET_NTH_TXDMA_START_INT_MSK_8814B(x)                               \
	(((x) >> BIT_SHIFT_NTH_TXDMA_START_INT_MSK_8814B) &                    \
	 BIT_MASK_NTH_TXDMA_START_INT_MSK_8814B)
#define BIT_SET_NTH_TXDMA_START_INT_MSK_8814B(x, v)                            \
	(BIT_CLEAR_NTH_TXDMA_START_INT_MSK_8814B(x) |                          \
	 BIT_NTH_TXDMA_START_INT_MSK_8814B(v))

/* 2 REG_TXDMA_START_HISR_8814B */

#define BIT_SHIFT_NTH_TXDMA_START_INT_8814B 0
#define BIT_MASK_NTH_TXDMA_START_INT_8814B 0x1ffff
#define BIT_NTH_TXDMA_START_INT_8814B(x)                                       \
	(((x) & BIT_MASK_NTH_TXDMA_START_INT_8814B)                            \
	 << BIT_SHIFT_NTH_TXDMA_START_INT_8814B)
#define BITS_NTH_TXDMA_START_INT_8814B                                         \
	(BIT_MASK_NTH_TXDMA_START_INT_8814B                                    \
	 << BIT_SHIFT_NTH_TXDMA_START_INT_8814B)
#define BIT_CLEAR_NTH_TXDMA_START_INT_8814B(x)                                 \
	((x) & (~BITS_NTH_TXDMA_START_INT_8814B))
#define BIT_GET_NTH_TXDMA_START_INT_8814B(x)                                   \
	(((x) >> BIT_SHIFT_NTH_TXDMA_START_INT_8814B) &                        \
	 BIT_MASK_NTH_TXDMA_START_INT_8814B)
#define BIT_SET_NTH_TXDMA_START_INT_8814B(x, v)                                \
	(BIT_CLEAR_NTH_TXDMA_START_INT_8814B(x) |                              \
	 BIT_NTH_TXDMA_START_INT_8814B(v))

/* 2 REG_NFCPAD_CTRL_8814B */
#define BIT_PAD_SHUTDW_8814B BIT(18)
#define BIT_SYSON_NFC_PAD_8814B BIT(17)
#define BIT_NFC_INT_PAD_CTRL_8814B BIT(16)
#define BIT_NFC_RFDIS_PAD_CTRL_8814B BIT(15)
#define BIT_NFC_CLK_PAD_CTRL_8814B BIT(14)
#define BIT_NFC_DATA_PAD_CTRL_8814B BIT(13)
#define BIT_NFC_PAD_PULL_CTRL_8814B BIT(12)

#define BIT_SHIFT_NFCPAD_IO_SEL_8814B 8
#define BIT_MASK_NFCPAD_IO_SEL_8814B 0xf
#define BIT_NFCPAD_IO_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_NFCPAD_IO_SEL_8814B) << BIT_SHIFT_NFCPAD_IO_SEL_8814B)
#define BITS_NFCPAD_IO_SEL_8814B                                               \
	(BIT_MASK_NFCPAD_IO_SEL_8814B << BIT_SHIFT_NFCPAD_IO_SEL_8814B)
#define BIT_CLEAR_NFCPAD_IO_SEL_8814B(x) ((x) & (~BITS_NFCPAD_IO_SEL_8814B))
#define BIT_GET_NFCPAD_IO_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_NFCPAD_IO_SEL_8814B) & BIT_MASK_NFCPAD_IO_SEL_8814B)
#define BIT_SET_NFCPAD_IO_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_NFCPAD_IO_SEL_8814B(x) | BIT_NFCPAD_IO_SEL_8814B(v))

#define BIT_SHIFT_NFCPAD_OUT_8814B 4
#define BIT_MASK_NFCPAD_OUT_8814B 0xf
#define BIT_NFCPAD_OUT_8814B(x)                                                \
	(((x) & BIT_MASK_NFCPAD_OUT_8814B) << BIT_SHIFT_NFCPAD_OUT_8814B)
#define BITS_NFCPAD_OUT_8814B                                                  \
	(BIT_MASK_NFCPAD_OUT_8814B << BIT_SHIFT_NFCPAD_OUT_8814B)
#define BIT_CLEAR_NFCPAD_OUT_8814B(x) ((x) & (~BITS_NFCPAD_OUT_8814B))
#define BIT_GET_NFCPAD_OUT_8814B(x)                                            \
	(((x) >> BIT_SHIFT_NFCPAD_OUT_8814B) & BIT_MASK_NFCPAD_OUT_8814B)
#define BIT_SET_NFCPAD_OUT_8814B(x, v)                                         \
	(BIT_CLEAR_NFCPAD_OUT_8814B(x) | BIT_NFCPAD_OUT_8814B(v))

#define BIT_SHIFT_NFCPAD_IN_8814B 0
#define BIT_MASK_NFCPAD_IN_8814B 0xf
#define BIT_NFCPAD_IN_8814B(x)                                                 \
	(((x) & BIT_MASK_NFCPAD_IN_8814B) << BIT_SHIFT_NFCPAD_IN_8814B)
#define BITS_NFCPAD_IN_8814B                                                   \
	(BIT_MASK_NFCPAD_IN_8814B << BIT_SHIFT_NFCPAD_IN_8814B)
#define BIT_CLEAR_NFCPAD_IN_8814B(x) ((x) & (~BITS_NFCPAD_IN_8814B))
#define BIT_GET_NFCPAD_IN_8814B(x)                                             \
	(((x) >> BIT_SHIFT_NFCPAD_IN_8814B) & BIT_MASK_NFCPAD_IN_8814B)
#define BIT_SET_NFCPAD_IN_8814B(x, v)                                          \
	(BIT_CLEAR_NFCPAD_IN_8814B(x) | BIT_NFCPAD_IN_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HIMR2_8814B */
#define BIT_BCNDMAINT_P4_MSK_8814B BIT(31)
#define BIT_BCNDMAINT_P3_MSK_8814B BIT(30)
#define BIT_BCNDMAINT_P2_MSK_8814B BIT(29)
#define BIT_BCNDMAINT_P1_MSK_8814B BIT(28)
#define BIT_SCH_PHY_TXOP_SIFS_INT_MSK_8814B BIT(23)
#define BIT_ATIMEND7_MSK_8814B BIT(22)
#define BIT_ATIMEND6_MSK_8814B BIT(21)
#define BIT_ATIMEND5_MSK_8814B BIT(20)
#define BIT_ATIMEND4_MSK_8814B BIT(19)
#define BIT_ATIMEND3_MSK_8814B BIT(18)
#define BIT_ATIMEND2_MSK_8814B BIT(17)
#define BIT_ATIMEND1_MSK_8814B BIT(16)
#define BIT_TXBCN7OK_MSK_8814B BIT(14)
#define BIT_TXBCN6OK_MSK_8814B BIT(13)
#define BIT_TXBCN5OK_MSK_8814B BIT(12)
#define BIT_TXBCN4OK_MSK_8814B BIT(11)
#define BIT_TXBCN3OK_MSK_8814B BIT(10)
#define BIT_TXBCN2OK_MSK_8814B BIT(9)
#define BIT_TXBCN1OK_MSK_V1_8814B BIT(8)
#define BIT_TXBCN7ERR_MSK_8814B BIT(6)
#define BIT_TXBCN6ERR_MSK_8814B BIT(5)
#define BIT_TXBCN5ERR_MSK_8814B BIT(4)
#define BIT_TXBCN4ERR_MSK_8814B BIT(3)
#define BIT_TXBCN3ERR_MSK_8814B BIT(2)
#define BIT_TXBCN2ERR_MSK_8814B BIT(1)
#define BIT_TXBCN1ERR_MSK_V1_8814B BIT(0)

/* 2 REG_HISR2_8814B */
#define BIT_BCNDMAINT_P4_8814B BIT(31)
#define BIT_BCNDMAINT_P3_8814B BIT(30)
#define BIT_BCNDMAINT_P2_8814B BIT(29)
#define BIT_BCNDMAINT_P1_8814B BIT(28)
#define BIT_SCH_PHY_TXOP_SIFS_INT_8814B BIT(23)
#define BIT_ATIMEND7_8814B BIT(22)
#define BIT_ATIMEND6_8814B BIT(21)
#define BIT_ATIMEND5_8814B BIT(20)
#define BIT_ATIMEND4_8814B BIT(19)
#define BIT_ATIMEND3_8814B BIT(18)
#define BIT_ATIMEND2_8814B BIT(17)
#define BIT_ATIMEND1_8814B BIT(16)
#define BIT_TXBCN7OK_8814B BIT(14)
#define BIT_TXBCN6OK_8814B BIT(13)
#define BIT_TXBCN5OK_8814B BIT(12)
#define BIT_TXBCN4OK_8814B BIT(11)
#define BIT_TXBCN3OK_8814B BIT(10)
#define BIT_TXBCN2OK_8814B BIT(9)
#define BIT_TXBCN1OK_8814B BIT(8)
#define BIT_TXBCN7ERR_8814B BIT(6)
#define BIT_TXBCN6ERR_8814B BIT(5)
#define BIT_TXBCN5ERR_8814B BIT(4)
#define BIT_TXBCN4ERR_8814B BIT(3)
#define BIT_TXBCN3ERR_8814B BIT(2)
#define BIT_TXBCN2ERR_8814B BIT(1)
#define BIT_TXBCN1ERR_8814B BIT(0)

/* 2 REG_HIMR3_8814B */
#define BIT_GTINT12_MSK_8814B BIT(24)
#define BIT_GTINT11_MSK_8814B BIT(23)
#define BIT_GTINT10_MSK_8814B BIT(22)
#define BIT_GTINT9_MSK_8814B BIT(21)
#define BIT_RX_DESC_BUF_FULL_MSK_8814B BIT(20)
#define BIT_CPHY_LDO_OCP_DET_INT_MSK_8814B BIT(19)
#define BIT_WDT_PLATFORM_INT_MSK_8814B BIT(18)
#define BIT_WDT_CPU_INT_MSK_8814B BIT(17)
#define BIT_SETH2CDOK_MASK_8814B BIT(16)
#define BIT_H2C_CMD_FULL_MASK_8814B BIT(15)
#define BIT_PKT_TRANS_ERR_MASK_8814B BIT(14)
#define BIT_TXSHORTCUT_TXDESUPDATEOK_MASK_8814B BIT(13)
#define BIT_TXSHORTCUT_BKUPDATEOK_MASK_8814B BIT(12)
#define BIT_TXSHORTCUT_BEUPDATEOK_MASK_8814B BIT(11)
#define BIT_TXSHORTCUT_VIUPDATEOK_MAS_8814B BIT(10)
#define BIT_TXSHORTCUT_VOUPDATEOK_MASK_8814B BIT(9)
#define BIT_SEARCH_FAIL_MSK_8814B BIT(8)
#define BIT_PWR_INT_127TO96_MASK_8814B BIT(7)
#define BIT_PWR_INT_95TO64_MASK_8814B BIT(6)
#define BIT_PWR_INT_63TO32_MASK_8814B BIT(5)
#define BIT_PWR_INT_31TO0_MASK_8814B BIT(4)
#define BIT_RX_DMA_STUCK_MSK_8814B BIT(3)
#define BIT_TX_DMA_STUCK_MSK_8814B BIT(2)
#define BIT_DDMA0_LP_INT_MSK_8814B BIT(1)
#define BIT_DDMA0_HP_INT_MSK_8814B BIT(0)

/* 2 REG_HISR3_8814B */
#define BIT_GTINT12_8814B BIT(24)
#define BIT_GTINT11_8814B BIT(23)
#define BIT_GTINT10_8814B BIT(22)
#define BIT_GTINT9_8814B BIT(21)
#define BIT_RX_DESC_BUF_FULL_8814B BIT(20)
#define BIT_CPHY_LDO_OCP_DET_INT_8814B BIT(19)
#define BIT_WDT_PLATFORM_INT_8814B BIT(18)
#define BIT_WDT_CPU_INT_8814B BIT(17)
#define BIT_SETH2CDOK_8814B BIT(16)
#define BIT_H2C_CMD_FULL_8814B BIT(15)
#define BIT_PKT_TRANS_ERR_8814B BIT(14)
#define BIT_TXSHORTCUT_TXDESUPDATEOK_8814B BIT(13)
#define BIT_TXSHORTCUT_BKUPDATEOK_8814B BIT(12)
#define BIT_TXSHORTCUT_BEUPDATEOK_8814B BIT(11)
#define BIT_TXSHORTCUT_VIUPDATEOK_8814B BIT(10)
#define BIT_TXSHORTCUT_VOUPDATEOK_8814B BIT(9)
#define BIT_SEARCH_FAIL_8814B BIT(8)
#define BIT_PWR_INT_127TO96_8814B BIT(7)
#define BIT_PWR_INT_95TO64_8814B BIT(6)
#define BIT_PWR_INT_63TO32_8814B BIT(5)
#define BIT_PWR_INT_31TO0_8814B BIT(4)
#define BIT_RX_DMA_STUCK_8814B BIT(3)
#define BIT_TX_DMA_STUCK_8814B BIT(2)
#define BIT_DDMA0_LP_INT_8814B BIT(1)
#define BIT_DDMA0_HP_INT_8814B BIT(0)

/* 2 REG_SW_MDIO_8814B */
#define BIT_DIS_TIMEOUT_IO_8814B BIT(24)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HIMR_7_8814B */
#define BIT_DATA_CPU_WDT_INT_MSK_8814B BIT(31)
#define BIT_OFLD_TXDMA_ERR_MSK_8814B BIT(30)
#define BIT_OFLD_TXDMA_FULL_MSK_8814B BIT(29)
#define BIT_OFLD_RXDMA_OVR_MSK_8814B BIT(28)
#define BIT_OFLD_RXDMA_ERR_MSK_8814B BIT(27)
#define BIT_OFLD_RXDMA_DES_UA_MSK_8814B BIT(26)
#define BIT_TXDMAOK_CHANNEL_16_MSK_8814B BIT(16)
#define BIT_TXDMAOK_CHANNEL_13_MSK_8814B BIT(13)
#define BIT_TXDMAOK_CHANNEL_12_MSK_8814B BIT(12)
#define BIT_TXDMAOK_CHANNEL_11_MSK_8814B BIT(11)
#define BIT_TXDMAOK_CHANNEL_10_MSK_8814B BIT(10)
#define BIT_TXDMAOK_CHANNEL_9_MSK_8814B BIT(9)
#define BIT_TXDMAOK_CHANNEL_8_MSK_8814B BIT(8)
#define BIT_TXDMAOK_CHANNEL_7_MSK_8814B BIT(7)
#define BIT_TXDMAOK_CHANNEL_6_MSK_8814B BIT(6)
#define BIT_TXDMAOK_CHANNEL_5_MSK_8814B BIT(5)
#define BIT_TXDMAOK_CHANNEL_4_MSK_8814B BIT(4)

/* 2 REG_HISR_7_8814B */
#define BIT_DATA_CPU_WDT_INT_8814B BIT(31)
#define BIT_OFLD_TXDMA_ERR_8814B BIT(30)
#define BIT_OFLD_TXDMA_FULL_8814B BIT(29)
#define BIT_OFLD_RXDMA_OVR_8814B BIT(28)
#define BIT_OFLD_RXDMA_ERR_8814B BIT(27)
#define BIT_OFLD_RXDMA_DES_UA_8814B BIT(26)
#define BIT_TXDMAOK_CHANNEL_16_8814B BIT(16)
#define BIT_TXDMAOK_CHANNEL_13_8814B BIT(13)
#define BIT_TXDMAOK_CHANNEL_12_8814B BIT(12)
#define BIT_TXDMAOK_CHANNEL_11_8814B BIT(11)
#define BIT_TXDMAOK_CHANNEL_10_8814B BIT(10)
#define BIT_TXDMAOK_CHANNEL_9_8814B BIT(9)
#define BIT_TXDMAOK_CHANNEL_8_8814B BIT(8)
#define BIT_TXDMAOK_CHANNEL_7_8814B BIT(7)
#define BIT_TXDMAOK_CHANNEL_6_8814B BIT(6)
#define BIT_TXDMAOK_CHANNEL_5_8814B BIT(5)
#define BIT_TXDMAOK_CHANNEL_4_8814B BIT(4)

/* 2 REG_H2C_PKT_READADDR_8814B */

#define BIT_SHIFT_H2C_PKT_READADDR_8814B 0
#define BIT_MASK_H2C_PKT_READADDR_8814B 0x3ffff
#define BIT_H2C_PKT_READADDR_8814B(x)                                          \
	(((x) & BIT_MASK_H2C_PKT_READADDR_8814B)                               \
	 << BIT_SHIFT_H2C_PKT_READADDR_8814B)
#define BITS_H2C_PKT_READADDR_8814B                                            \
	(BIT_MASK_H2C_PKT_READADDR_8814B << BIT_SHIFT_H2C_PKT_READADDR_8814B)
#define BIT_CLEAR_H2C_PKT_READADDR_8814B(x)                                    \
	((x) & (~BITS_H2C_PKT_READADDR_8814B))
#define BIT_GET_H2C_PKT_READADDR_8814B(x)                                      \
	(((x) >> BIT_SHIFT_H2C_PKT_READADDR_8814B) &                           \
	 BIT_MASK_H2C_PKT_READADDR_8814B)
#define BIT_SET_H2C_PKT_READADDR_8814B(x, v)                                   \
	(BIT_CLEAR_H2C_PKT_READADDR_8814B(x) | BIT_H2C_PKT_READADDR_8814B(v))

/* 2 REG_H2C_PKT_WRITEADDR_8814B */

#define BIT_SHIFT_H2C_PKT_WRITEADDR_8814B 0
#define BIT_MASK_H2C_PKT_WRITEADDR_8814B 0x3ffff
#define BIT_H2C_PKT_WRITEADDR_8814B(x)                                         \
	(((x) & BIT_MASK_H2C_PKT_WRITEADDR_8814B)                              \
	 << BIT_SHIFT_H2C_PKT_WRITEADDR_8814B)
#define BITS_H2C_PKT_WRITEADDR_8814B                                           \
	(BIT_MASK_H2C_PKT_WRITEADDR_8814B << BIT_SHIFT_H2C_PKT_WRITEADDR_8814B)
#define BIT_CLEAR_H2C_PKT_WRITEADDR_8814B(x)                                   \
	((x) & (~BITS_H2C_PKT_WRITEADDR_8814B))
#define BIT_GET_H2C_PKT_WRITEADDR_8814B(x)                                     \
	(((x) >> BIT_SHIFT_H2C_PKT_WRITEADDR_8814B) &                          \
	 BIT_MASK_H2C_PKT_WRITEADDR_8814B)
#define BIT_SET_H2C_PKT_WRITEADDR_8814B(x, v)                                  \
	(BIT_CLEAR_H2C_PKT_WRITEADDR_8814B(x) | BIT_H2C_PKT_WRITEADDR_8814B(v))

/* 2 REG_MEM_PWR_CRTL_8814B */
#define BIT_MEM_BB_SD_8814B BIT(17)
#define BIT_MEM_BB_DS_8814B BIT(16)
#define BIT_MEM_DENG_LS_8814B BIT(13)
#define BIT_MEM_DENG_DS_8814B BIT(12)
#define BIT_MEM_BT_DS_8814B BIT(10)
#define BIT_MEM_SDIO_LS_8814B BIT(9)
#define BIT_MEM_SDIO_DS_8814B BIT(8)
#define BIT_MEM_USB_LS_8814B BIT(7)
#define BIT_MEM_USB_DS_8814B BIT(6)
#define BIT_MEM_PCI_LS_8814B BIT(5)
#define BIT_MEM_PCI_DS_8814B BIT(4)
#define BIT_MEM_WLMAC_LS_8814B BIT(3)
#define BIT_MEM_WLMAC_DS_8814B BIT(2)
#define BIT_MEM_WLMCU_LS_8814B BIT(1)
#define BIT_MEM_WLMCU_DS_8814B BIT(0)

/* 2 REG_FW_DRV_HANDSHAKE_8814B */

#define BIT_SHIFT_FW_DRV_HANDSHAKE_8814B 0
#define BIT_MASK_FW_DRV_HANDSHAKE_8814B 0xffffffffL
#define BIT_FW_DRV_HANDSHAKE_8814B(x)                                          \
	(((x) & BIT_MASK_FW_DRV_HANDSHAKE_8814B)                               \
	 << BIT_SHIFT_FW_DRV_HANDSHAKE_8814B)
#define BITS_FW_DRV_HANDSHAKE_8814B                                            \
	(BIT_MASK_FW_DRV_HANDSHAKE_8814B << BIT_SHIFT_FW_DRV_HANDSHAKE_8814B)
#define BIT_CLEAR_FW_DRV_HANDSHAKE_8814B(x)                                    \
	((x) & (~BITS_FW_DRV_HANDSHAKE_8814B))
#define BIT_GET_FW_DRV_HANDSHAKE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_FW_DRV_HANDSHAKE_8814B) &                           \
	 BIT_MASK_FW_DRV_HANDSHAKE_8814B)
#define BIT_SET_FW_DRV_HANDSHAKE_8814B(x, v)                                   \
	(BIT_CLEAR_FW_DRV_HANDSHAKE_8814B(x) | BIT_FW_DRV_HANDSHAKE_8814B(v))

/* 2 REG_FW_DBG0_8814B */

#define BIT_SHIFT_FW_DBG0_8814B 0
#define BIT_MASK_FW_DBG0_8814B 0xffffffffL
#define BIT_FW_DBG0_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG0_8814B) << BIT_SHIFT_FW_DBG0_8814B)
#define BITS_FW_DBG0_8814B (BIT_MASK_FW_DBG0_8814B << BIT_SHIFT_FW_DBG0_8814B)
#define BIT_CLEAR_FW_DBG0_8814B(x) ((x) & (~BITS_FW_DBG0_8814B))
#define BIT_GET_FW_DBG0_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG0_8814B) & BIT_MASK_FW_DBG0_8814B)
#define BIT_SET_FW_DBG0_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG0_8814B(x) | BIT_FW_DBG0_8814B(v))

/* 2 REG_FW_DBG1_8814B */

#define BIT_SHIFT_FW_DBG1_8814B 0
#define BIT_MASK_FW_DBG1_8814B 0xffffffffL
#define BIT_FW_DBG1_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG1_8814B) << BIT_SHIFT_FW_DBG1_8814B)
#define BITS_FW_DBG1_8814B (BIT_MASK_FW_DBG1_8814B << BIT_SHIFT_FW_DBG1_8814B)
#define BIT_CLEAR_FW_DBG1_8814B(x) ((x) & (~BITS_FW_DBG1_8814B))
#define BIT_GET_FW_DBG1_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG1_8814B) & BIT_MASK_FW_DBG1_8814B)
#define BIT_SET_FW_DBG1_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG1_8814B(x) | BIT_FW_DBG1_8814B(v))

/* 2 REG_FW_DBG2_8814B */

#define BIT_SHIFT_FW_DBG2_8814B 0
#define BIT_MASK_FW_DBG2_8814B 0xffffffffL
#define BIT_FW_DBG2_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG2_8814B) << BIT_SHIFT_FW_DBG2_8814B)
#define BITS_FW_DBG2_8814B (BIT_MASK_FW_DBG2_8814B << BIT_SHIFT_FW_DBG2_8814B)
#define BIT_CLEAR_FW_DBG2_8814B(x) ((x) & (~BITS_FW_DBG2_8814B))
#define BIT_GET_FW_DBG2_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG2_8814B) & BIT_MASK_FW_DBG2_8814B)
#define BIT_SET_FW_DBG2_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG2_8814B(x) | BIT_FW_DBG2_8814B(v))

/* 2 REG_FW_DBG3_8814B */

#define BIT_SHIFT_FW_DBG3_8814B 0
#define BIT_MASK_FW_DBG3_8814B 0xffffffffL
#define BIT_FW_DBG3_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG3_8814B) << BIT_SHIFT_FW_DBG3_8814B)
#define BITS_FW_DBG3_8814B (BIT_MASK_FW_DBG3_8814B << BIT_SHIFT_FW_DBG3_8814B)
#define BIT_CLEAR_FW_DBG3_8814B(x) ((x) & (~BITS_FW_DBG3_8814B))
#define BIT_GET_FW_DBG3_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG3_8814B) & BIT_MASK_FW_DBG3_8814B)
#define BIT_SET_FW_DBG3_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG3_8814B(x) | BIT_FW_DBG3_8814B(v))

/* 2 REG_FW_DBG4_8814B */

#define BIT_SHIFT_FW_DBG4_8814B 0
#define BIT_MASK_FW_DBG4_8814B 0xffffffffL
#define BIT_FW_DBG4_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG4_8814B) << BIT_SHIFT_FW_DBG4_8814B)
#define BITS_FW_DBG4_8814B (BIT_MASK_FW_DBG4_8814B << BIT_SHIFT_FW_DBG4_8814B)
#define BIT_CLEAR_FW_DBG4_8814B(x) ((x) & (~BITS_FW_DBG4_8814B))
#define BIT_GET_FW_DBG4_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG4_8814B) & BIT_MASK_FW_DBG4_8814B)
#define BIT_SET_FW_DBG4_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG4_8814B(x) | BIT_FW_DBG4_8814B(v))

/* 2 REG_FW_DBG5_8814B */

#define BIT_SHIFT_FW_DBG5_8814B 0
#define BIT_MASK_FW_DBG5_8814B 0xffffffffL
#define BIT_FW_DBG5_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG5_8814B) << BIT_SHIFT_FW_DBG5_8814B)
#define BITS_FW_DBG5_8814B (BIT_MASK_FW_DBG5_8814B << BIT_SHIFT_FW_DBG5_8814B)
#define BIT_CLEAR_FW_DBG5_8814B(x) ((x) & (~BITS_FW_DBG5_8814B))
#define BIT_GET_FW_DBG5_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG5_8814B) & BIT_MASK_FW_DBG5_8814B)
#define BIT_SET_FW_DBG5_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG5_8814B(x) | BIT_FW_DBG5_8814B(v))

/* 2 REG_FW_DBG6_8814B */

#define BIT_SHIFT_FW_DBG6_8814B 0
#define BIT_MASK_FW_DBG6_8814B 0xffffffffL
#define BIT_FW_DBG6_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG6_8814B) << BIT_SHIFT_FW_DBG6_8814B)
#define BITS_FW_DBG6_8814B (BIT_MASK_FW_DBG6_8814B << BIT_SHIFT_FW_DBG6_8814B)
#define BIT_CLEAR_FW_DBG6_8814B(x) ((x) & (~BITS_FW_DBG6_8814B))
#define BIT_GET_FW_DBG6_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG6_8814B) & BIT_MASK_FW_DBG6_8814B)
#define BIT_SET_FW_DBG6_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG6_8814B(x) | BIT_FW_DBG6_8814B(v))

/* 2 REG_FW_DBG7_8814B */

#define BIT_SHIFT_FW_DBG7_8814B 0
#define BIT_MASK_FW_DBG7_8814B 0xffffffffL
#define BIT_FW_DBG7_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_DBG7_8814B) << BIT_SHIFT_FW_DBG7_8814B)
#define BITS_FW_DBG7_8814B (BIT_MASK_FW_DBG7_8814B << BIT_SHIFT_FW_DBG7_8814B)
#define BIT_CLEAR_FW_DBG7_8814B(x) ((x) & (~BITS_FW_DBG7_8814B))
#define BIT_GET_FW_DBG7_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_DBG7_8814B) & BIT_MASK_FW_DBG7_8814B)
#define BIT_SET_FW_DBG7_8814B(x, v)                                            \
	(BIT_CLEAR_FW_DBG7_8814B(x) | BIT_FW_DBG7_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_CR_8814B */

#define BIT_SHIFT_LBMODE_8814B 24
#define BIT_MASK_LBMODE_8814B 0x1f
#define BIT_LBMODE_8814B(x)                                                    \
	(((x) & BIT_MASK_LBMODE_8814B) << BIT_SHIFT_LBMODE_8814B)
#define BITS_LBMODE_8814B (BIT_MASK_LBMODE_8814B << BIT_SHIFT_LBMODE_8814B)
#define BIT_CLEAR_LBMODE_8814B(x) ((x) & (~BITS_LBMODE_8814B))
#define BIT_GET_LBMODE_8814B(x)                                                \
	(((x) >> BIT_SHIFT_LBMODE_8814B) & BIT_MASK_LBMODE_8814B)
#define BIT_SET_LBMODE_8814B(x, v)                                             \
	(BIT_CLEAR_LBMODE_8814B(x) | BIT_LBMODE_8814B(v))

#define BIT_SHIFT_NETYPE1_8814B 18
#define BIT_MASK_NETYPE1_8814B 0x3
#define BIT_NETYPE1_8814B(x)                                                   \
	(((x) & BIT_MASK_NETYPE1_8814B) << BIT_SHIFT_NETYPE1_8814B)
#define BITS_NETYPE1_8814B (BIT_MASK_NETYPE1_8814B << BIT_SHIFT_NETYPE1_8814B)
#define BIT_CLEAR_NETYPE1_8814B(x) ((x) & (~BITS_NETYPE1_8814B))
#define BIT_GET_NETYPE1_8814B(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE1_8814B) & BIT_MASK_NETYPE1_8814B)
#define BIT_SET_NETYPE1_8814B(x, v)                                            \
	(BIT_CLEAR_NETYPE1_8814B(x) | BIT_NETYPE1_8814B(v))

#define BIT_SHIFT_NETYPE0_8814B 16
#define BIT_MASK_NETYPE0_8814B 0x3
#define BIT_NETYPE0_8814B(x)                                                   \
	(((x) & BIT_MASK_NETYPE0_8814B) << BIT_SHIFT_NETYPE0_8814B)
#define BITS_NETYPE0_8814B (BIT_MASK_NETYPE0_8814B << BIT_SHIFT_NETYPE0_8814B)
#define BIT_CLEAR_NETYPE0_8814B(x) ((x) & (~BITS_NETYPE0_8814B))
#define BIT_GET_NETYPE0_8814B(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE0_8814B) & BIT_MASK_NETYPE0_8814B)
#define BIT_SET_NETYPE0_8814B(x, v)                                            \
	(BIT_CLEAR_NETYPE0_8814B(x) | BIT_NETYPE0_8814B(v))

#define BIT_COUNTER_STS_EN_8814B BIT(13)
#define BIT_I2C_MAILBOX_EN_8814B BIT(12)
#define BIT_SHCUT_EN_8814B BIT(11)
#define BIT_32K_CAL_TMR_EN_8814B BIT(10)
#define BIT_MAC_SEC_EN_8814B BIT(9)
#define BIT_ENSWBCN_8814B BIT(8)
#define BIT_MACRXEN_8814B BIT(7)
#define BIT_MACTXEN_8814B BIT(6)
#define BIT_SCHEDULE_EN_8814B BIT(5)
#define BIT_PROTOCOL_EN_8814B BIT(4)
#define BIT_RXDMA_EN_8814B BIT(3)
#define BIT_TXDMA_EN_8814B BIT(2)
#define BIT_HCI_RXDMA_EN_8814B BIT(1)
#define BIT_HCI_TXDMA_EN_8814B BIT(0)

/* 2 REG_PG_SIZE_8814B */

#define BIT_SHIFT_DBG_FIFO_SEL_8814B 16
#define BIT_MASK_DBG_FIFO_SEL_8814B 0xff
#define BIT_DBG_FIFO_SEL_8814B(x)                                              \
	(((x) & BIT_MASK_DBG_FIFO_SEL_8814B) << BIT_SHIFT_DBG_FIFO_SEL_8814B)
#define BITS_DBG_FIFO_SEL_8814B                                                \
	(BIT_MASK_DBG_FIFO_SEL_8814B << BIT_SHIFT_DBG_FIFO_SEL_8814B)
#define BIT_CLEAR_DBG_FIFO_SEL_8814B(x) ((x) & (~BITS_DBG_FIFO_SEL_8814B))
#define BIT_GET_DBG_FIFO_SEL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DBG_FIFO_SEL_8814B) & BIT_MASK_DBG_FIFO_SEL_8814B)
#define BIT_SET_DBG_FIFO_SEL_8814B(x, v)                                       \
	(BIT_CLEAR_DBG_FIFO_SEL_8814B(x) | BIT_DBG_FIFO_SEL_8814B(v))

/* 2 REG_PKT_BUFF_ACCESS_CTRL_8814B */

#define BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8814B 0
#define BIT_MASK_PKT_BUFF_ACCESS_CTRL_8814B 0xff
#define BIT_PKT_BUFF_ACCESS_CTRL_8814B(x)                                      \
	(((x) & BIT_MASK_PKT_BUFF_ACCESS_CTRL_8814B)                           \
	 << BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8814B)
#define BITS_PKT_BUFF_ACCESS_CTRL_8814B                                        \
	(BIT_MASK_PKT_BUFF_ACCESS_CTRL_8814B                                   \
	 << BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8814B)
#define BIT_CLEAR_PKT_BUFF_ACCESS_CTRL_8814B(x)                                \
	((x) & (~BITS_PKT_BUFF_ACCESS_CTRL_8814B))
#define BIT_GET_PKT_BUFF_ACCESS_CTRL_8814B(x)                                  \
	(((x) >> BIT_SHIFT_PKT_BUFF_ACCESS_CTRL_8814B) &                       \
	 BIT_MASK_PKT_BUFF_ACCESS_CTRL_8814B)
#define BIT_SET_PKT_BUFF_ACCESS_CTRL_8814B(x, v)                               \
	(BIT_CLEAR_PKT_BUFF_ACCESS_CTRL_8814B(x) |                             \
	 BIT_PKT_BUFF_ACCESS_CTRL_8814B(v))

/* 2 REG_TSF_CLK_STATE_8814B */
#define BIT_TSF_CLK_STABLE_8814B BIT(15)

/* 2 REG_TXDMA_PQ_MAP_8814B */

#define BIT_SHIFT_TXDMA_H2C_MAP_8814B 16
#define BIT_MASK_TXDMA_H2C_MAP_8814B 0x3
#define BIT_TXDMA_H2C_MAP_8814B(x)                                             \
	(((x) & BIT_MASK_TXDMA_H2C_MAP_8814B) << BIT_SHIFT_TXDMA_H2C_MAP_8814B)
#define BITS_TXDMA_H2C_MAP_8814B                                               \
	(BIT_MASK_TXDMA_H2C_MAP_8814B << BIT_SHIFT_TXDMA_H2C_MAP_8814B)
#define BIT_CLEAR_TXDMA_H2C_MAP_8814B(x) ((x) & (~BITS_TXDMA_H2C_MAP_8814B))
#define BIT_GET_TXDMA_H2C_MAP_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_H2C_MAP_8814B) & BIT_MASK_TXDMA_H2C_MAP_8814B)
#define BIT_SET_TXDMA_H2C_MAP_8814B(x, v)                                      \
	(BIT_CLEAR_TXDMA_H2C_MAP_8814B(x) | BIT_TXDMA_H2C_MAP_8814B(v))

#define BIT_SHIFT_TXDMA_HIQ_MAP_8814B 14
#define BIT_MASK_TXDMA_HIQ_MAP_8814B 0x3
#define BIT_TXDMA_HIQ_MAP_8814B(x)                                             \
	(((x) & BIT_MASK_TXDMA_HIQ_MAP_8814B) << BIT_SHIFT_TXDMA_HIQ_MAP_8814B)
#define BITS_TXDMA_HIQ_MAP_8814B                                               \
	(BIT_MASK_TXDMA_HIQ_MAP_8814B << BIT_SHIFT_TXDMA_HIQ_MAP_8814B)
#define BIT_CLEAR_TXDMA_HIQ_MAP_8814B(x) ((x) & (~BITS_TXDMA_HIQ_MAP_8814B))
#define BIT_GET_TXDMA_HIQ_MAP_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_HIQ_MAP_8814B) & BIT_MASK_TXDMA_HIQ_MAP_8814B)
#define BIT_SET_TXDMA_HIQ_MAP_8814B(x, v)                                      \
	(BIT_CLEAR_TXDMA_HIQ_MAP_8814B(x) | BIT_TXDMA_HIQ_MAP_8814B(v))

#define BIT_SHIFT_TXDMA_MGQ_MAP_8814B 12
#define BIT_MASK_TXDMA_MGQ_MAP_8814B 0x3
#define BIT_TXDMA_MGQ_MAP_8814B(x)                                             \
	(((x) & BIT_MASK_TXDMA_MGQ_MAP_8814B) << BIT_SHIFT_TXDMA_MGQ_MAP_8814B)
#define BITS_TXDMA_MGQ_MAP_8814B                                               \
	(BIT_MASK_TXDMA_MGQ_MAP_8814B << BIT_SHIFT_TXDMA_MGQ_MAP_8814B)
#define BIT_CLEAR_TXDMA_MGQ_MAP_8814B(x) ((x) & (~BITS_TXDMA_MGQ_MAP_8814B))
#define BIT_GET_TXDMA_MGQ_MAP_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_MGQ_MAP_8814B) & BIT_MASK_TXDMA_MGQ_MAP_8814B)
#define BIT_SET_TXDMA_MGQ_MAP_8814B(x, v)                                      \
	(BIT_CLEAR_TXDMA_MGQ_MAP_8814B(x) | BIT_TXDMA_MGQ_MAP_8814B(v))

#define BIT_SHIFT_TXDMA_BKQ_MAP_8814B 10
#define BIT_MASK_TXDMA_BKQ_MAP_8814B 0x3
#define BIT_TXDMA_BKQ_MAP_8814B(x)                                             \
	(((x) & BIT_MASK_TXDMA_BKQ_MAP_8814B) << BIT_SHIFT_TXDMA_BKQ_MAP_8814B)
#define BITS_TXDMA_BKQ_MAP_8814B                                               \
	(BIT_MASK_TXDMA_BKQ_MAP_8814B << BIT_SHIFT_TXDMA_BKQ_MAP_8814B)
#define BIT_CLEAR_TXDMA_BKQ_MAP_8814B(x) ((x) & (~BITS_TXDMA_BKQ_MAP_8814B))
#define BIT_GET_TXDMA_BKQ_MAP_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_BKQ_MAP_8814B) & BIT_MASK_TXDMA_BKQ_MAP_8814B)
#define BIT_SET_TXDMA_BKQ_MAP_8814B(x, v)                                      \
	(BIT_CLEAR_TXDMA_BKQ_MAP_8814B(x) | BIT_TXDMA_BKQ_MAP_8814B(v))

#define BIT_SHIFT_TXDMA_BEQ_MAP_8814B 8
#define BIT_MASK_TXDMA_BEQ_MAP_8814B 0x3
#define BIT_TXDMA_BEQ_MAP_8814B(x)                                             \
	(((x) & BIT_MASK_TXDMA_BEQ_MAP_8814B) << BIT_SHIFT_TXDMA_BEQ_MAP_8814B)
#define BITS_TXDMA_BEQ_MAP_8814B                                               \
	(BIT_MASK_TXDMA_BEQ_MAP_8814B << BIT_SHIFT_TXDMA_BEQ_MAP_8814B)
#define BIT_CLEAR_TXDMA_BEQ_MAP_8814B(x) ((x) & (~BITS_TXDMA_BEQ_MAP_8814B))
#define BIT_GET_TXDMA_BEQ_MAP_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_BEQ_MAP_8814B) & BIT_MASK_TXDMA_BEQ_MAP_8814B)
#define BIT_SET_TXDMA_BEQ_MAP_8814B(x, v)                                      \
	(BIT_CLEAR_TXDMA_BEQ_MAP_8814B(x) | BIT_TXDMA_BEQ_MAP_8814B(v))

#define BIT_SHIFT_TXDMA_VIQ_MAP_8814B 6
#define BIT_MASK_TXDMA_VIQ_MAP_8814B 0x3
#define BIT_TXDMA_VIQ_MAP_8814B(x)                                             \
	(((x) & BIT_MASK_TXDMA_VIQ_MAP_8814B) << BIT_SHIFT_TXDMA_VIQ_MAP_8814B)
#define BITS_TXDMA_VIQ_MAP_8814B                                               \
	(BIT_MASK_TXDMA_VIQ_MAP_8814B << BIT_SHIFT_TXDMA_VIQ_MAP_8814B)
#define BIT_CLEAR_TXDMA_VIQ_MAP_8814B(x) ((x) & (~BITS_TXDMA_VIQ_MAP_8814B))
#define BIT_GET_TXDMA_VIQ_MAP_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_VIQ_MAP_8814B) & BIT_MASK_TXDMA_VIQ_MAP_8814B)
#define BIT_SET_TXDMA_VIQ_MAP_8814B(x, v)                                      \
	(BIT_CLEAR_TXDMA_VIQ_MAP_8814B(x) | BIT_TXDMA_VIQ_MAP_8814B(v))

#define BIT_SHIFT_TXDMA_VOQ_MAP_8814B 4
#define BIT_MASK_TXDMA_VOQ_MAP_8814B 0x3
#define BIT_TXDMA_VOQ_MAP_8814B(x)                                             \
	(((x) & BIT_MASK_TXDMA_VOQ_MAP_8814B) << BIT_SHIFT_TXDMA_VOQ_MAP_8814B)
#define BITS_TXDMA_VOQ_MAP_8814B                                               \
	(BIT_MASK_TXDMA_VOQ_MAP_8814B << BIT_SHIFT_TXDMA_VOQ_MAP_8814B)
#define BIT_CLEAR_TXDMA_VOQ_MAP_8814B(x) ((x) & (~BITS_TXDMA_VOQ_MAP_8814B))
#define BIT_GET_TXDMA_VOQ_MAP_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXDMA_VOQ_MAP_8814B) & BIT_MASK_TXDMA_VOQ_MAP_8814B)
#define BIT_SET_TXDMA_VOQ_MAP_8814B(x, v)                                      \
	(BIT_CLEAR_TXDMA_VOQ_MAP_8814B(x) | BIT_TXDMA_VOQ_MAP_8814B(v))

#define BIT_RXDMA_AGG_EN_8814B BIT(2)
#define BIT_RXSHFT_EN_8814B BIT(1)
#define BIT_RXDMA_ARBBW_EN_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_TRXFF_BNDY_8814B */

#define BIT_SHIFT_FWFFOVFL_RSV_8814B 16
#define BIT_MASK_FWFFOVFL_RSV_8814B 0xf
#define BIT_FWFFOVFL_RSV_8814B(x)                                              \
	(((x) & BIT_MASK_FWFFOVFL_RSV_8814B) << BIT_SHIFT_FWFFOVFL_RSV_8814B)
#define BITS_FWFFOVFL_RSV_8814B                                                \
	(BIT_MASK_FWFFOVFL_RSV_8814B << BIT_SHIFT_FWFFOVFL_RSV_8814B)
#define BIT_CLEAR_FWFFOVFL_RSV_8814B(x) ((x) & (~BITS_FWFFOVFL_RSV_8814B))
#define BIT_GET_FWFFOVFL_RSV_8814B(x)                                          \
	(((x) >> BIT_SHIFT_FWFFOVFL_RSV_8814B) & BIT_MASK_FWFFOVFL_RSV_8814B)
#define BIT_SET_FWFFOVFL_RSV_8814B(x, v)                                       \
	(BIT_CLEAR_FWFFOVFL_RSV_8814B(x) | BIT_FWFFOVFL_RSV_8814B(v))

#define BIT_SHIFT_RXFFOVFL_RSV_V2_8814B 8
#define BIT_MASK_RXFFOVFL_RSV_V2_8814B 0xf
#define BIT_RXFFOVFL_RSV_V2_8814B(x)                                           \
	(((x) & BIT_MASK_RXFFOVFL_RSV_V2_8814B)                                \
	 << BIT_SHIFT_RXFFOVFL_RSV_V2_8814B)
#define BITS_RXFFOVFL_RSV_V2_8814B                                             \
	(BIT_MASK_RXFFOVFL_RSV_V2_8814B << BIT_SHIFT_RXFFOVFL_RSV_V2_8814B)
#define BIT_CLEAR_RXFFOVFL_RSV_V2_8814B(x) ((x) & (~BITS_RXFFOVFL_RSV_V2_8814B))
#define BIT_GET_RXFFOVFL_RSV_V2_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RXFFOVFL_RSV_V2_8814B) &                            \
	 BIT_MASK_RXFFOVFL_RSV_V2_8814B)
#define BIT_SET_RXFFOVFL_RSV_V2_8814B(x, v)                                    \
	(BIT_CLEAR_RXFFOVFL_RSV_V2_8814B(x) | BIT_RXFFOVFL_RSV_V2_8814B(v))

/* 2 REG_PTA_I2C_MBOX_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_I2C_M_STATUS_8814B 8
#define BIT_MASK_I2C_M_STATUS_8814B 0xf
#define BIT_I2C_M_STATUS_8814B(x)                                              \
	(((x) & BIT_MASK_I2C_M_STATUS_8814B) << BIT_SHIFT_I2C_M_STATUS_8814B)
#define BITS_I2C_M_STATUS_8814B                                                \
	(BIT_MASK_I2C_M_STATUS_8814B << BIT_SHIFT_I2C_M_STATUS_8814B)
#define BIT_CLEAR_I2C_M_STATUS_8814B(x) ((x) & (~BITS_I2C_M_STATUS_8814B))
#define BIT_GET_I2C_M_STATUS_8814B(x)                                          \
	(((x) >> BIT_SHIFT_I2C_M_STATUS_8814B) & BIT_MASK_I2C_M_STATUS_8814B)
#define BIT_SET_I2C_M_STATUS_8814B(x, v)                                       \
	(BIT_CLEAR_I2C_M_STATUS_8814B(x) | BIT_I2C_M_STATUS_8814B(v))

#define BIT_SHIFT_I2C_M_BUS_GNT_FW_8814B 4
#define BIT_MASK_I2C_M_BUS_GNT_FW_8814B 0x7
#define BIT_I2C_M_BUS_GNT_FW_8814B(x)                                          \
	(((x) & BIT_MASK_I2C_M_BUS_GNT_FW_8814B)                               \
	 << BIT_SHIFT_I2C_M_BUS_GNT_FW_8814B)
#define BITS_I2C_M_BUS_GNT_FW_8814B                                            \
	(BIT_MASK_I2C_M_BUS_GNT_FW_8814B << BIT_SHIFT_I2C_M_BUS_GNT_FW_8814B)
#define BIT_CLEAR_I2C_M_BUS_GNT_FW_8814B(x)                                    \
	((x) & (~BITS_I2C_M_BUS_GNT_FW_8814B))
#define BIT_GET_I2C_M_BUS_GNT_FW_8814B(x)                                      \
	(((x) >> BIT_SHIFT_I2C_M_BUS_GNT_FW_8814B) &                           \
	 BIT_MASK_I2C_M_BUS_GNT_FW_8814B)
#define BIT_SET_I2C_M_BUS_GNT_FW_8814B(x, v)                                   \
	(BIT_CLEAR_I2C_M_BUS_GNT_FW_8814B(x) | BIT_I2C_M_BUS_GNT_FW_8814B(v))

#define BIT_I2C_M_GNT_FW_8814B BIT(3)

#define BIT_SHIFT_I2C_M_SPEED_8814B 1
#define BIT_MASK_I2C_M_SPEED_8814B 0x3
#define BIT_I2C_M_SPEED_8814B(x)                                               \
	(((x) & BIT_MASK_I2C_M_SPEED_8814B) << BIT_SHIFT_I2C_M_SPEED_8814B)
#define BITS_I2C_M_SPEED_8814B                                                 \
	(BIT_MASK_I2C_M_SPEED_8814B << BIT_SHIFT_I2C_M_SPEED_8814B)
#define BIT_CLEAR_I2C_M_SPEED_8814B(x) ((x) & (~BITS_I2C_M_SPEED_8814B))
#define BIT_GET_I2C_M_SPEED_8814B(x)                                           \
	(((x) >> BIT_SHIFT_I2C_M_SPEED_8814B) & BIT_MASK_I2C_M_SPEED_8814B)
#define BIT_SET_I2C_M_SPEED_8814B(x, v)                                        \
	(BIT_CLEAR_I2C_M_SPEED_8814B(x) | BIT_I2C_M_SPEED_8814B(v))

#define BIT_I2C_M_UNLOCK_8814B BIT(0)

/* 2 REG_RXFF_BNDY_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_RXFF0_BNDY_V2_8814B 0
#define BIT_MASK_RXFF0_BNDY_V2_8814B 0x3ffff
#define BIT_RXFF0_BNDY_V2_8814B(x)                                             \
	(((x) & BIT_MASK_RXFF0_BNDY_V2_8814B) << BIT_SHIFT_RXFF0_BNDY_V2_8814B)
#define BITS_RXFF0_BNDY_V2_8814B                                               \
	(BIT_MASK_RXFF0_BNDY_V2_8814B << BIT_SHIFT_RXFF0_BNDY_V2_8814B)
#define BIT_CLEAR_RXFF0_BNDY_V2_8814B(x) ((x) & (~BITS_RXFF0_BNDY_V2_8814B))
#define BIT_GET_RXFF0_BNDY_V2_8814B(x)                                         \
	(((x) >> BIT_SHIFT_RXFF0_BNDY_V2_8814B) & BIT_MASK_RXFF0_BNDY_V2_8814B)
#define BIT_SET_RXFF0_BNDY_V2_8814B(x, v)                                      \
	(BIT_CLEAR_RXFF0_BNDY_V2_8814B(x) | BIT_RXFF0_BNDY_V2_8814B(v))

/* 2 REG_FE1IMR_8814B */
#define BIT_CPUMGQ_DROP_BY_HOLD_TIME_INT_EN_8814B BIT(31)
#define BIT_FWFF_FULL_INT_EN_8814B BIT(30)
#define BIT_BB_STOP_RX_INT_EN_8814B BIT(29)
#define BIT_FS_RXDMA2_DONE_INT_EN_8814B BIT(28)
#define BIT_FS_RXDONE3_INT_EN_8814B BIT(27)
#define BIT_FS_RXDONE2_INT_EN_8814B BIT(26)
#define BIT_FS_RX_BCN_P4_INT_EN_8814B BIT(25)
#define BIT_FS_RX_BCN_P3_INT_EN_8814B BIT(24)
#define BIT_FS_RX_BCN_P2_INT_EN_8814B BIT(23)
#define BIT_FS_RX_BCN_P1_INT_EN_8814B BIT(22)
#define BIT_FS_RX_BCN_P0_INT_EN_8814B BIT(21)
#define BIT_FS_RX_UMD0_INT_EN_8814B BIT(20)
#define BIT_FS_RX_UMD1_INT_EN_8814B BIT(19)
#define BIT_FS_RX_BMD0_INT_EN_8814B BIT(18)
#define BIT_FS_RX_BMD1_INT_EN_8814B BIT(17)
#define BIT_FS_RXDONE_INT_EN_8814B BIT(16)
#define BIT_FS_WWLAN_INT_EN_8814B BIT(15)
#define BIT_FS_SOUND_DONE_INT_EN_8814B BIT(14)
#define BIT_FS_TRL_MTR_INT_EN_8814B BIT(12)
#define BIT_FS_BF1_PRETO_INT_EN_8814B BIT(11)
#define BIT_FS_BF0_PRETO_INT_EN_8814B BIT(10)
#define BIT_FS_PTCL_RELEASE_MACID_INT_EN_8814B BIT(9)
#define BIT_PRETX_ERRHLD_INT_EN_8814B BIT(8)
#define BIT_FS_GTRD_INT_EN_8814B BIT(7)
#define BIT_FS_LTE_COEX_EN_8814B BIT(6)
#define BIT_FS_WLACTOFF_INT_EN_8814B BIT(5)
#define BIT_FS_WLACTON_INT_EN_8814B BIT(4)
#define BIT_FS_BTCMD_INT_EN_8814B BIT(3)
#define BIT_FS_REG_MAILBOX_TO_I2C_INT_EN_8814B BIT(2)
#define BIT_FS_TRPC_TO_INT_EN_V1_8814B BIT(1)
#define BIT_FS_RPC_O_T_INT_EN_V1_8814B BIT(0)

/* 2 REG_FE1ISR_8814B */
#define BIT_CPUMGQ_DROP_BY_HOLD_TIME_INT_8814B BIT(31)
#define BIT_FWFF_FULL_INT_8814B BIT(30)
#define BIT_BB_STOP_RX_INT_8814B BIT(29)
#define BIT_FS_RXDMA2_DONE_INT_8814B BIT(28)
#define BIT_FS_RXDONE3_INT_INT_8814B BIT(27)
#define BIT_FS_RXDONE2_INT_8814B BIT(26)
#define BIT_FS_RX_BCN_P4_INT_8814B BIT(25)
#define BIT_FS_RX_BCN_P3_INT_8814B BIT(24)
#define BIT_FS_RX_BCN_P2_INT_8814B BIT(23)
#define BIT_FS_RX_BCN_P1_INT_8814B BIT(22)
#define BIT_FS_RX_BCN_P0_INT_8814B BIT(21)
#define BIT_FS_RX_UMD0_INT_8814B BIT(20)
#define BIT_FS_RX_UMD1_INT_8814B BIT(19)
#define BIT_FS_RX_BMD0_INT_8814B BIT(18)
#define BIT_FS_RX_BMD1_INT_8814B BIT(17)
#define BIT_FS_RXDONE_INT_8814B BIT(16)
#define BIT_FS_WWLAN_INT_8814B BIT(15)
#define BIT_FS_SOUND_DONE_INT_8814B BIT(14)
#define BIT_FS_TRL_MTR_INT_8814B BIT(12)
#define BIT_FS_BF1_PRETO_INT_8814B BIT(11)
#define BIT_FS_BF0_PRETO_INT_8814B BIT(10)
#define BIT_FS_PTCL_RELEASE_MACID_INT_8814B BIT(9)
#define BIT_PRETX_ERRHLD_INT_8814B BIT(8)
#define BIT_SND_RDY_INT_8814B BIT(7)
#define BIT_FS_LTE_COEX_INT_8814B BIT(6)
#define BIT_FS_WLACTOFF_INT_8814B BIT(5)
#define BIT_FS_WLACTON_INT_8814B BIT(4)
#define BIT_BT_CMD_INT_8814B BIT(3)
#define BIT_FS_MAILBOX_TO_I2C_INT_8814B BIT(2)
#define BIT_FS_TRPC_TO_INT_8814B BIT(1)
#define BIT_FS_RPC_O_T_INT_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_CPWM_8814B */
#define BIT_CPWM_TOGGLING_8814B BIT(31)

#define BIT_SHIFT_CPWM_MOD_8814B 24
#define BIT_MASK_CPWM_MOD_8814B 0x7f
#define BIT_CPWM_MOD_8814B(x)                                                  \
	(((x) & BIT_MASK_CPWM_MOD_8814B) << BIT_SHIFT_CPWM_MOD_8814B)
#define BITS_CPWM_MOD_8814B                                                    \
	(BIT_MASK_CPWM_MOD_8814B << BIT_SHIFT_CPWM_MOD_8814B)
#define BIT_CLEAR_CPWM_MOD_8814B(x) ((x) & (~BITS_CPWM_MOD_8814B))
#define BIT_GET_CPWM_MOD_8814B(x)                                              \
	(((x) >> BIT_SHIFT_CPWM_MOD_8814B) & BIT_MASK_CPWM_MOD_8814B)
#define BIT_SET_CPWM_MOD_8814B(x, v)                                           \
	(BIT_CLEAR_CPWM_MOD_8814B(x) | BIT_CPWM_MOD_8814B(v))

/* 2 REG_FWIMR_8814B */
#define BIT_FS_TXBCNOK_MB7_INT_EN_8814B BIT(31)
#define BIT_FS_TXBCNOK_MB6_INT_EN_8814B BIT(30)
#define BIT_FS_TXBCNOK_MB5_INT_EN_8814B BIT(29)
#define BIT_FS_TXBCNOK_MB4_INT_EN_8814B BIT(28)
#define BIT_FS_TXBCNOK_MB3_INT_EN_8814B BIT(27)
#define BIT_FS_TXBCNOK_MB2_INT_EN_8814B BIT(26)
#define BIT_FS_TXBCNOK_MB1_INT_EN_8814B BIT(25)
#define BIT_FS_TXBCNOK_MB0_INT_EN_8814B BIT(24)
#define BIT_FS_TXBCNERR_MB7_INT_EN_8814B BIT(23)
#define BIT_FS_TXBCNERR_MB6_INT_EN_8814B BIT(22)
#define BIT_FS_TXBCNERR_MB5_INT_EN_8814B BIT(21)
#define BIT_FS_TXBCNERR_MB4_INT_EN_8814B BIT(20)
#define BIT_FS_TXBCNERR_MB3_INT_EN_8814B BIT(19)
#define BIT_FS_TXBCNERR_MB2_INT_EN_8814B BIT(18)
#define BIT_FS_TXBCNERR_MB1_INT_EN_8814B BIT(17)
#define BIT_FS_TXBCNERR_MB0_INT_EN_8814B BIT(16)
#define BIT_CPU_MGQ_TXDONE_INT_EN_8814B BIT(15)
#define BIT_SIFS_OVERSPEC_INT_EN_8814B BIT(14)
#define BIT_FS_MGNTQ_RPTR_RELEASE_INT_EN_8814B BIT(13)
#define BIT_FS_MGNTQFF_TO_INT_EN_8814B BIT(12)
#define BIT_FS_CPUMGQ_ERR_INT_EN_8814B BIT(11)
#define BIT_FS_DDMA0_LP_INT_EN_8814B BIT(9)
#define BIT_FS_DDMA0_HP_INT_EN_8814B BIT(8)
#define BIT_FS_TRXRPT_INT_EN_8814B BIT(7)
#define BIT_FS_C2H_W_READY_INT_EN_8814B BIT(6)
#define BIT_FS_HRCV_INT_EN_8814B BIT(5)
#define BIT_FS_H2CCMD_INT_EN_8814B BIT(4)
#define BIT_FS_TXPKTIN_INT_EN_8814B BIT(3)
#define BIT_FS_ERRORHDL_INT_EN_8814B BIT(2)
#define BIT_FS_TXCCX_INT_EN_8814B BIT(1)
#define BIT_FS_TXCLOSE_INT_EN_8814B BIT(0)

/* 2 REG_FWISR_8814B */
#define BIT_FS_TXBCNOK_MB7_INT_8814B BIT(31)
#define BIT_FS_TXBCNOK_MB6_INT_8814B BIT(30)
#define BIT_FS_TXBCNOK_MB5_INT_8814B BIT(29)
#define BIT_FS_TXBCNOK_MB4_INT_8814B BIT(28)
#define BIT_FS_TXBCNOK_MB3_INT_8814B BIT(27)
#define BIT_FS_TXBCNOK_MB2_INT_8814B BIT(26)
#define BIT_FS_TXBCNOK_MB1_INT_8814B BIT(25)
#define BIT_FS_TXBCNOK_MB0_INT_8814B BIT(24)
#define BIT_FS_TXBCNERR_MB7_INT_8814B BIT(23)
#define BIT_FS_TXBCNERR_MB6_INT_8814B BIT(22)
#define BIT_FS_TXBCNERR_MB5_INT_8814B BIT(21)
#define BIT_FS_TXBCNERR_MB4_INT_8814B BIT(20)
#define BIT_FS_TXBCNERR_MB3_INT_8814B BIT(19)
#define BIT_FS_TXBCNERR_MB2_INT_8814B BIT(18)
#define BIT_FS_TXBCNERR_MB1_INT_8814B BIT(17)
#define BIT_FS_TXBCNERR_MB0_INT_8814B BIT(16)
#define BIT_CPU_MGQ_TXDONE_INT_8814B BIT(15)
#define BIT_SIFS_OVERSPEC_INT_8814B BIT(14)
#define BIT_FS_MGNTQ_RPTR_RELEASE_INT_8814B BIT(13)
#define BIT_FS_MGNTQFF_TO_INT_8814B BIT(12)
#define BIT_FS_CPUMGQ_ERR_INT_8814B BIT(11)
#define BIT_FWCMD_PKTIN_INT_8814B BIT(10)
#define BIT_FS_DDMA0_LP_INT_8814B BIT(9)
#define BIT_FS_DDMA0_HP_INT_8814B BIT(8)
#define BIT_FS_TRXRPT_INT_8814B BIT(7)
#define BIT_FS_C2H_W_READY_INT_8814B BIT(6)
#define BIT_FS_HRCV_INT_8814B BIT(5)
#define BIT_FS_H2CCMD_INT_8814B BIT(4)
#define BIT_FS_TXPKTIN_INT_8814B BIT(3)
#define BIT_FS_ERRORHDL_INT_8814B BIT(2)
#define BIT_FS_TXCCX_INT_8814B BIT(1)
#define BIT_FS_TXCLOSE_INT_8814B BIT(0)

/* 2 REG_FTIMR_8814B */
#define BIT_PS_TIMER_C_EARLY_INT_EN_8814B BIT(23)
#define BIT_PS_TIMER_B_EARLY_INT_EN_8814B BIT(22)
#define BIT_PS_TIMER_A_EARLY_INT_EN_8814B BIT(21)
#define BIT_CPUMGQ_TX_TIMER_EARLY_INT_EN_8814B BIT(20)
#define BIT_PS_TIMER_C_INT_EN_8814B BIT(19)
#define BIT_PS_TIMER_B_INT_EN_8814B BIT(18)
#define BIT_PS_TIMER_A_INT_EN_8814B BIT(17)
#define BIT_CPUMGQ_TX_TIMER_INT_EN_8814B BIT(16)
#define BIT_FS_PS_TIMEOUT2_EN_8814B BIT(15)
#define BIT_FS_PS_TIMEOUT1_EN_8814B BIT(14)
#define BIT_FS_PS_TIMEOUT0_EN_8814B BIT(13)
#define BIT_FS_GTINT12_EN_8814B BIT(12)
#define BIT_FS_GTINT11_EN_8814B BIT(11)
#define BIT_FS_GTINT10_EN_8814B BIT(10)
#define BIT_FS_GTINT9_EN_8814B BIT(9)
#define BIT_FS_GTINT8_EN_8814B BIT(8)
#define BIT_FS_GTINT7_EN_8814B BIT(7)
#define BIT_FS_GTINT6_EN_8814B BIT(6)
#define BIT_FS_GTINT5_EN_8814B BIT(5)
#define BIT_FS_GTINT4_EN_8814B BIT(4)
#define BIT_FS_GTINT3_EN_8814B BIT(3)
#define BIT_FS_GTINT2_EN_8814B BIT(2)
#define BIT_FS_GTINT1_EN_8814B BIT(1)
#define BIT_FS_GTINT0_EN_8814B BIT(0)

/* 2 REG_FTISR_8814B */
#define BIT_PS_TIMER_5_EARLY__INT_8814B BIT(26)
#define BIT_PS_TIMER_4_EARLY__INT_8814B BIT(25)
#define BIT_PS_TIMER_3_EARLY__INT_8814B BIT(24)
#define BIT_PS_TIMER_2_EARLY__INT_8814B BIT(23)
#define BIT_PS_TIMER_1_EARLY__INT_8814B BIT(22)
#define BIT_PS_TIMER_0_EARLY__INT_8814B BIT(21)
#define BIT_CPUMGQ_TX_TIMER_EARLY_INT_8814B BIT(20)
#define BIT_PS_TIMER_5_INT_8814B BIT(19)
#define BIT_PS_TIMER_4_INT_8814B BIT(18)
#define BIT_PS_TIMER_3_INT_8814B BIT(17)
#define BIT_CPUMGQ_TX_TIMER_INT_8814B BIT(16)
#define BIT_PS_TIMER_2_INT_8814B BIT(15)
#define BIT_PS_TIMER_1_INT_8814B BIT(14)
#define BIT_PS_TIMER_0_INT_8814B BIT(13)
#define BIT_FS_GTINT12_INT_8814B BIT(12)
#define BIT_FS_GTINT11_INT_8814B BIT(11)
#define BIT_FS_GTINT10_INT_8814B BIT(10)
#define BIT_FS_GTINT9_INT_8814B BIT(9)
#define BIT_FS_GTINT8_INT_8814B BIT(8)
#define BIT_FS_GTINT7_INT_8814B BIT(7)
#define BIT_FS_GTINT6_INT_8814B BIT(6)
#define BIT_FS_GTINT5_INT_8814B BIT(5)
#define BIT_FS_GTINT4_INT_8814B BIT(4)
#define BIT_FS_GTINT3_INT_8814B BIT(3)
#define BIT_FS_GTINT2_INT_8814B BIT(2)
#define BIT_FS_GTINT1_INT_8814B BIT(1)
#define BIT_FS_GTINT0_INT_8814B BIT(0)

/* 2 REG_PKTBUF_DBG_CTRL_8814B */

#define BIT_SHIFT_PKTBUF_WRITE_EN_8814B 24
#define BIT_MASK_PKTBUF_WRITE_EN_8814B 0xff
#define BIT_PKTBUF_WRITE_EN_8814B(x)                                           \
	(((x) & BIT_MASK_PKTBUF_WRITE_EN_8814B)                                \
	 << BIT_SHIFT_PKTBUF_WRITE_EN_8814B)
#define BITS_PKTBUF_WRITE_EN_8814B                                             \
	(BIT_MASK_PKTBUF_WRITE_EN_8814B << BIT_SHIFT_PKTBUF_WRITE_EN_8814B)
#define BIT_CLEAR_PKTBUF_WRITE_EN_8814B(x) ((x) & (~BITS_PKTBUF_WRITE_EN_8814B))
#define BIT_GET_PKTBUF_WRITE_EN_8814B(x)                                       \
	(((x) >> BIT_SHIFT_PKTBUF_WRITE_EN_8814B) &                            \
	 BIT_MASK_PKTBUF_WRITE_EN_8814B)
#define BIT_SET_PKTBUF_WRITE_EN_8814B(x, v)                                    \
	(BIT_CLEAR_PKTBUF_WRITE_EN_8814B(x) | BIT_PKTBUF_WRITE_EN_8814B(v))

#define BIT_TXRPTBUF_DBG_8814B BIT(23)

/* 2 REG_NOT_VALID_8814B */
#define BIT_TXPKTBUF_DBG_V2_8814B BIT(20)
#define BIT_RXPKTBUF_DBG_8814B BIT(16)

#define BIT_SHIFT_PKTBUF_DBG_ADDR_8814B 0
#define BIT_MASK_PKTBUF_DBG_ADDR_8814B 0x1fff
#define BIT_PKTBUF_DBG_ADDR_8814B(x)                                           \
	(((x) & BIT_MASK_PKTBUF_DBG_ADDR_8814B)                                \
	 << BIT_SHIFT_PKTBUF_DBG_ADDR_8814B)
#define BITS_PKTBUF_DBG_ADDR_8814B                                             \
	(BIT_MASK_PKTBUF_DBG_ADDR_8814B << BIT_SHIFT_PKTBUF_DBG_ADDR_8814B)
#define BIT_CLEAR_PKTBUF_DBG_ADDR_8814B(x) ((x) & (~BITS_PKTBUF_DBG_ADDR_8814B))
#define BIT_GET_PKTBUF_DBG_ADDR_8814B(x)                                       \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_ADDR_8814B) &                            \
	 BIT_MASK_PKTBUF_DBG_ADDR_8814B)
#define BIT_SET_PKTBUF_DBG_ADDR_8814B(x, v)                                    \
	(BIT_CLEAR_PKTBUF_DBG_ADDR_8814B(x) | BIT_PKTBUF_DBG_ADDR_8814B(v))

/* 2 REG_PKTBUF_DBG_DATA_L_8814B */

#define BIT_SHIFT_PKTBUF_DBG_DATA_L_8814B 0
#define BIT_MASK_PKTBUF_DBG_DATA_L_8814B 0xffffffffL
#define BIT_PKTBUF_DBG_DATA_L_8814B(x)                                         \
	(((x) & BIT_MASK_PKTBUF_DBG_DATA_L_8814B)                              \
	 << BIT_SHIFT_PKTBUF_DBG_DATA_L_8814B)
#define BITS_PKTBUF_DBG_DATA_L_8814B                                           \
	(BIT_MASK_PKTBUF_DBG_DATA_L_8814B << BIT_SHIFT_PKTBUF_DBG_DATA_L_8814B)
#define BIT_CLEAR_PKTBUF_DBG_DATA_L_8814B(x)                                   \
	((x) & (~BITS_PKTBUF_DBG_DATA_L_8814B))
#define BIT_GET_PKTBUF_DBG_DATA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_DATA_L_8814B) &                          \
	 BIT_MASK_PKTBUF_DBG_DATA_L_8814B)
#define BIT_SET_PKTBUF_DBG_DATA_L_8814B(x, v)                                  \
	(BIT_CLEAR_PKTBUF_DBG_DATA_L_8814B(x) | BIT_PKTBUF_DBG_DATA_L_8814B(v))

/* 2 REG_PKTBUF_DBG_DATA_H_8814B */

#define BIT_SHIFT_PKTBUF_DBG_DATA_H_8814B 0
#define BIT_MASK_PKTBUF_DBG_DATA_H_8814B 0xffffffffL
#define BIT_PKTBUF_DBG_DATA_H_8814B(x)                                         \
	(((x) & BIT_MASK_PKTBUF_DBG_DATA_H_8814B)                              \
	 << BIT_SHIFT_PKTBUF_DBG_DATA_H_8814B)
#define BITS_PKTBUF_DBG_DATA_H_8814B                                           \
	(BIT_MASK_PKTBUF_DBG_DATA_H_8814B << BIT_SHIFT_PKTBUF_DBG_DATA_H_8814B)
#define BIT_CLEAR_PKTBUF_DBG_DATA_H_8814B(x)                                   \
	((x) & (~BITS_PKTBUF_DBG_DATA_H_8814B))
#define BIT_GET_PKTBUF_DBG_DATA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_PKTBUF_DBG_DATA_H_8814B) &                          \
	 BIT_MASK_PKTBUF_DBG_DATA_H_8814B)
#define BIT_SET_PKTBUF_DBG_DATA_H_8814B(x, v)                                  \
	(BIT_CLEAR_PKTBUF_DBG_DATA_H_8814B(x) | BIT_PKTBUF_DBG_DATA_H_8814B(v))

/* 2 REG_CPWM2_8814B */

#define BIT_SHIFT_L0S_TO_RCVY_NUM_8814B 16
#define BIT_MASK_L0S_TO_RCVY_NUM_8814B 0xff
#define BIT_L0S_TO_RCVY_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_L0S_TO_RCVY_NUM_8814B)                                \
	 << BIT_SHIFT_L0S_TO_RCVY_NUM_8814B)
#define BITS_L0S_TO_RCVY_NUM_8814B                                             \
	(BIT_MASK_L0S_TO_RCVY_NUM_8814B << BIT_SHIFT_L0S_TO_RCVY_NUM_8814B)
#define BIT_CLEAR_L0S_TO_RCVY_NUM_8814B(x) ((x) & (~BITS_L0S_TO_RCVY_NUM_8814B))
#define BIT_GET_L0S_TO_RCVY_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_L0S_TO_RCVY_NUM_8814B) &                            \
	 BIT_MASK_L0S_TO_RCVY_NUM_8814B)
#define BIT_SET_L0S_TO_RCVY_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_L0S_TO_RCVY_NUM_8814B(x) | BIT_L0S_TO_RCVY_NUM_8814B(v))

#define BIT_CPWM2_TOGGLING_8814B BIT(15)

#define BIT_SHIFT_CPWM2_MOD_8814B 0
#define BIT_MASK_CPWM2_MOD_8814B 0x7fff
#define BIT_CPWM2_MOD_8814B(x)                                                 \
	(((x) & BIT_MASK_CPWM2_MOD_8814B) << BIT_SHIFT_CPWM2_MOD_8814B)
#define BITS_CPWM2_MOD_8814B                                                   \
	(BIT_MASK_CPWM2_MOD_8814B << BIT_SHIFT_CPWM2_MOD_8814B)
#define BIT_CLEAR_CPWM2_MOD_8814B(x) ((x) & (~BITS_CPWM2_MOD_8814B))
#define BIT_GET_CPWM2_MOD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_CPWM2_MOD_8814B) & BIT_MASK_CPWM2_MOD_8814B)
#define BIT_SET_CPWM2_MOD_8814B(x, v)                                          \
	(BIT_CLEAR_CPWM2_MOD_8814B(x) | BIT_CPWM2_MOD_8814B(v))

/* 2 REG_TC0_CTRL_8814B */
#define BIT_TC0INT_EN_8814B BIT(26)
#define BIT_TC0MODE_8814B BIT(25)
#define BIT_TC0EN_8814B BIT(24)

#define BIT_SHIFT_TC0DATA_8814B 0
#define BIT_MASK_TC0DATA_8814B 0xffffff
#define BIT_TC0DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC0DATA_8814B) << BIT_SHIFT_TC0DATA_8814B)
#define BITS_TC0DATA_8814B (BIT_MASK_TC0DATA_8814B << BIT_SHIFT_TC0DATA_8814B)
#define BIT_CLEAR_TC0DATA_8814B(x) ((x) & (~BITS_TC0DATA_8814B))
#define BIT_GET_TC0DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC0DATA_8814B) & BIT_MASK_TC0DATA_8814B)
#define BIT_SET_TC0DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC0DATA_8814B(x) | BIT_TC0DATA_8814B(v))

/* 2 REG_TC1_CTRL_8814B */
#define BIT_TC1INT_EN_8814B BIT(26)
#define BIT_TC1MODE_8814B BIT(25)
#define BIT_TC1EN_8814B BIT(24)

#define BIT_SHIFT_TC1DATA_8814B 0
#define BIT_MASK_TC1DATA_8814B 0xffffff
#define BIT_TC1DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC1DATA_8814B) << BIT_SHIFT_TC1DATA_8814B)
#define BITS_TC1DATA_8814B (BIT_MASK_TC1DATA_8814B << BIT_SHIFT_TC1DATA_8814B)
#define BIT_CLEAR_TC1DATA_8814B(x) ((x) & (~BITS_TC1DATA_8814B))
#define BIT_GET_TC1DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC1DATA_8814B) & BIT_MASK_TC1DATA_8814B)
#define BIT_SET_TC1DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC1DATA_8814B(x) | BIT_TC1DATA_8814B(v))

/* 2 REG_TC2_CTRL_8814B */
#define BIT_TC2INT_EN_8814B BIT(26)
#define BIT_TC2MODE_8814B BIT(25)
#define BIT_TC2EN_8814B BIT(24)

#define BIT_SHIFT_TC2DATA_8814B 0
#define BIT_MASK_TC2DATA_8814B 0xffffff
#define BIT_TC2DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC2DATA_8814B) << BIT_SHIFT_TC2DATA_8814B)
#define BITS_TC2DATA_8814B (BIT_MASK_TC2DATA_8814B << BIT_SHIFT_TC2DATA_8814B)
#define BIT_CLEAR_TC2DATA_8814B(x) ((x) & (~BITS_TC2DATA_8814B))
#define BIT_GET_TC2DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC2DATA_8814B) & BIT_MASK_TC2DATA_8814B)
#define BIT_SET_TC2DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC2DATA_8814B(x) | BIT_TC2DATA_8814B(v))

/* 2 REG_TC3_CTRL_8814B */
#define BIT_TC3INT_EN_8814B BIT(26)
#define BIT_TC3MODE_8814B BIT(25)
#define BIT_TC3EN_8814B BIT(24)

#define BIT_SHIFT_TC3DATA_8814B 0
#define BIT_MASK_TC3DATA_8814B 0xffffff
#define BIT_TC3DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC3DATA_8814B) << BIT_SHIFT_TC3DATA_8814B)
#define BITS_TC3DATA_8814B (BIT_MASK_TC3DATA_8814B << BIT_SHIFT_TC3DATA_8814B)
#define BIT_CLEAR_TC3DATA_8814B(x) ((x) & (~BITS_TC3DATA_8814B))
#define BIT_GET_TC3DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC3DATA_8814B) & BIT_MASK_TC3DATA_8814B)
#define BIT_SET_TC3DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC3DATA_8814B(x) | BIT_TC3DATA_8814B(v))

/* 2 REG_TC4_CTRL_8814B */
#define BIT_TC4INT_EN_8814B BIT(26)
#define BIT_TC4MODE_8814B BIT(25)
#define BIT_TC4EN_8814B BIT(24)

#define BIT_SHIFT_TC4DATA_8814B 0
#define BIT_MASK_TC4DATA_8814B 0xffffff
#define BIT_TC4DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC4DATA_8814B) << BIT_SHIFT_TC4DATA_8814B)
#define BITS_TC4DATA_8814B (BIT_MASK_TC4DATA_8814B << BIT_SHIFT_TC4DATA_8814B)
#define BIT_CLEAR_TC4DATA_8814B(x) ((x) & (~BITS_TC4DATA_8814B))
#define BIT_GET_TC4DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC4DATA_8814B) & BIT_MASK_TC4DATA_8814B)
#define BIT_SET_TC4DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC4DATA_8814B(x) | BIT_TC4DATA_8814B(v))

/* 2 REG_TCUNIT_BASE_8814B */

#define BIT_SHIFT_TCUNIT_BASE_8814B 0
#define BIT_MASK_TCUNIT_BASE_8814B 0x3fff
#define BIT_TCUNIT_BASE_8814B(x)                                               \
	(((x) & BIT_MASK_TCUNIT_BASE_8814B) << BIT_SHIFT_TCUNIT_BASE_8814B)
#define BITS_TCUNIT_BASE_8814B                                                 \
	(BIT_MASK_TCUNIT_BASE_8814B << BIT_SHIFT_TCUNIT_BASE_8814B)
#define BIT_CLEAR_TCUNIT_BASE_8814B(x) ((x) & (~BITS_TCUNIT_BASE_8814B))
#define BIT_GET_TCUNIT_BASE_8814B(x)                                           \
	(((x) >> BIT_SHIFT_TCUNIT_BASE_8814B) & BIT_MASK_TCUNIT_BASE_8814B)
#define BIT_SET_TCUNIT_BASE_8814B(x, v)                                        \
	(BIT_CLEAR_TCUNIT_BASE_8814B(x) | BIT_TCUNIT_BASE_8814B(v))

/* 2 REG_TC5_CTRL_8814B */
#define BIT_TC5INT_EN_8814B BIT(26)
#define BIT_TC5MODE_8814B BIT(25)
#define BIT_TC5EN_8814B BIT(24)

#define BIT_SHIFT_TC5DATA_8814B 0
#define BIT_MASK_TC5DATA_8814B 0xffffff
#define BIT_TC5DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC5DATA_8814B) << BIT_SHIFT_TC5DATA_8814B)
#define BITS_TC5DATA_8814B (BIT_MASK_TC5DATA_8814B << BIT_SHIFT_TC5DATA_8814B)
#define BIT_CLEAR_TC5DATA_8814B(x) ((x) & (~BITS_TC5DATA_8814B))
#define BIT_GET_TC5DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC5DATA_8814B) & BIT_MASK_TC5DATA_8814B)
#define BIT_SET_TC5DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC5DATA_8814B(x) | BIT_TC5DATA_8814B(v))

/* 2 REG_TC6_CTRL_8814B */
#define BIT_TC6INT_EN_8814B BIT(26)
#define BIT_TC6MODE_8814B BIT(25)
#define BIT_TC6EN_8814B BIT(24)

#define BIT_SHIFT_TC6DATA_8814B 0
#define BIT_MASK_TC6DATA_8814B 0xffffff
#define BIT_TC6DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC6DATA_8814B) << BIT_SHIFT_TC6DATA_8814B)
#define BITS_TC6DATA_8814B (BIT_MASK_TC6DATA_8814B << BIT_SHIFT_TC6DATA_8814B)
#define BIT_CLEAR_TC6DATA_8814B(x) ((x) & (~BITS_TC6DATA_8814B))
#define BIT_GET_TC6DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC6DATA_8814B) & BIT_MASK_TC6DATA_8814B)
#define BIT_SET_TC6DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC6DATA_8814B(x) | BIT_TC6DATA_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_AES_DECRPT_DATA_8814B */

#define BIT_SHIFT_IPS_CFG_ADDR_8814B 0
#define BIT_MASK_IPS_CFG_ADDR_8814B 0xff
#define BIT_IPS_CFG_ADDR_8814B(x)                                              \
	(((x) & BIT_MASK_IPS_CFG_ADDR_8814B) << BIT_SHIFT_IPS_CFG_ADDR_8814B)
#define BITS_IPS_CFG_ADDR_8814B                                                \
	(BIT_MASK_IPS_CFG_ADDR_8814B << BIT_SHIFT_IPS_CFG_ADDR_8814B)
#define BIT_CLEAR_IPS_CFG_ADDR_8814B(x) ((x) & (~BITS_IPS_CFG_ADDR_8814B))
#define BIT_GET_IPS_CFG_ADDR_8814B(x)                                          \
	(((x) >> BIT_SHIFT_IPS_CFG_ADDR_8814B) & BIT_MASK_IPS_CFG_ADDR_8814B)
#define BIT_SET_IPS_CFG_ADDR_8814B(x, v)                                       \
	(BIT_CLEAR_IPS_CFG_ADDR_8814B(x) | BIT_IPS_CFG_ADDR_8814B(v))

/* 2 REG_AES_DECRPT_CFG_8814B */

#define BIT_SHIFT_IPS_CFG_DATA_8814B 0
#define BIT_MASK_IPS_CFG_DATA_8814B 0xffffffffL
#define BIT_IPS_CFG_DATA_8814B(x)                                              \
	(((x) & BIT_MASK_IPS_CFG_DATA_8814B) << BIT_SHIFT_IPS_CFG_DATA_8814B)
#define BITS_IPS_CFG_DATA_8814B                                                \
	(BIT_MASK_IPS_CFG_DATA_8814B << BIT_SHIFT_IPS_CFG_DATA_8814B)
#define BIT_CLEAR_IPS_CFG_DATA_8814B(x) ((x) & (~BITS_IPS_CFG_DATA_8814B))
#define BIT_GET_IPS_CFG_DATA_8814B(x)                                          \
	(((x) >> BIT_SHIFT_IPS_CFG_DATA_8814B) & BIT_MASK_IPS_CFG_DATA_8814B)
#define BIT_SET_IPS_CFG_DATA_8814B(x, v)                                       \
	(BIT_CLEAR_IPS_CFG_DATA_8814B(x) | BIT_IPS_CFG_DATA_8814B(v))

/* 2 REG_HIOE_CTRL_8814B */
#define BIT_HIOE_WRITE_REQ_8814B BIT(30)
#define BIT_HIOE_READ_REQ_8814B BIT(29)
#define BIT_INST_FORMAT_ERR_8814B BIT(25)
#define BIT_OP_TIMEOUT_ERR_8814B BIT(24)

#define BIT_SHIFT_HIOE_OP_TIMEOUT_8814B 16
#define BIT_MASK_HIOE_OP_TIMEOUT_8814B 0xff
#define BIT_HIOE_OP_TIMEOUT_8814B(x)                                           \
	(((x) & BIT_MASK_HIOE_OP_TIMEOUT_8814B)                                \
	 << BIT_SHIFT_HIOE_OP_TIMEOUT_8814B)
#define BITS_HIOE_OP_TIMEOUT_8814B                                             \
	(BIT_MASK_HIOE_OP_TIMEOUT_8814B << BIT_SHIFT_HIOE_OP_TIMEOUT_8814B)
#define BIT_CLEAR_HIOE_OP_TIMEOUT_8814B(x) ((x) & (~BITS_HIOE_OP_TIMEOUT_8814B))
#define BIT_GET_HIOE_OP_TIMEOUT_8814B(x)                                       \
	(((x) >> BIT_SHIFT_HIOE_OP_TIMEOUT_8814B) &                            \
	 BIT_MASK_HIOE_OP_TIMEOUT_8814B)
#define BIT_SET_HIOE_OP_TIMEOUT_8814B(x, v)                                    \
	(BIT_CLEAR_HIOE_OP_TIMEOUT_8814B(x) | BIT_HIOE_OP_TIMEOUT_8814B(v))

#define BIT_SHIFT_BITDATA_CHECKSUM_8814B 0
#define BIT_MASK_BITDATA_CHECKSUM_8814B 0xffff
#define BIT_BITDATA_CHECKSUM_8814B(x)                                          \
	(((x) & BIT_MASK_BITDATA_CHECKSUM_8814B)                               \
	 << BIT_SHIFT_BITDATA_CHECKSUM_8814B)
#define BITS_BITDATA_CHECKSUM_8814B                                            \
	(BIT_MASK_BITDATA_CHECKSUM_8814B << BIT_SHIFT_BITDATA_CHECKSUM_8814B)
#define BIT_CLEAR_BITDATA_CHECKSUM_8814B(x)                                    \
	((x) & (~BITS_BITDATA_CHECKSUM_8814B))
#define BIT_GET_BITDATA_CHECKSUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BITDATA_CHECKSUM_8814B) &                           \
	 BIT_MASK_BITDATA_CHECKSUM_8814B)
#define BIT_SET_BITDATA_CHECKSUM_8814B(x, v)                                   \
	(BIT_CLEAR_BITDATA_CHECKSUM_8814B(x) | BIT_BITDATA_CHECKSUM_8814B(v))

/* 2 REG_HIOE_CFG_FILE_8814B */

#define BIT_SHIFT_TXBF_END_ADDR_8814B 16
#define BIT_MASK_TXBF_END_ADDR_8814B 0xffff
#define BIT_TXBF_END_ADDR_8814B(x)                                             \
	(((x) & BIT_MASK_TXBF_END_ADDR_8814B) << BIT_SHIFT_TXBF_END_ADDR_8814B)
#define BITS_TXBF_END_ADDR_8814B                                               \
	(BIT_MASK_TXBF_END_ADDR_8814B << BIT_SHIFT_TXBF_END_ADDR_8814B)
#define BIT_CLEAR_TXBF_END_ADDR_8814B(x) ((x) & (~BITS_TXBF_END_ADDR_8814B))
#define BIT_GET_TXBF_END_ADDR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXBF_END_ADDR_8814B) & BIT_MASK_TXBF_END_ADDR_8814B)
#define BIT_SET_TXBF_END_ADDR_8814B(x, v)                                      \
	(BIT_CLEAR_TXBF_END_ADDR_8814B(x) | BIT_TXBF_END_ADDR_8814B(v))

#define BIT_SHIFT_TXBF_STR_ADDR_8814B 0
#define BIT_MASK_TXBF_STR_ADDR_8814B 0xffff
#define BIT_TXBF_STR_ADDR_8814B(x)                                             \
	(((x) & BIT_MASK_TXBF_STR_ADDR_8814B) << BIT_SHIFT_TXBF_STR_ADDR_8814B)
#define BITS_TXBF_STR_ADDR_8814B                                               \
	(BIT_MASK_TXBF_STR_ADDR_8814B << BIT_SHIFT_TXBF_STR_ADDR_8814B)
#define BIT_CLEAR_TXBF_STR_ADDR_8814B(x) ((x) & (~BITS_TXBF_STR_ADDR_8814B))
#define BIT_GET_TXBF_STR_ADDR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXBF_STR_ADDR_8814B) & BIT_MASK_TXBF_STR_ADDR_8814B)
#define BIT_SET_TXBF_STR_ADDR_8814B(x, v)                                      \
	(BIT_CLEAR_TXBF_STR_ADDR_8814B(x) | BIT_TXBF_STR_ADDR_8814B(v))

/* 2 REG_TMETER_8814B */
#define BIT_TEMP_VALID_8814B BIT(31)

#define BIT_SHIFT_TEMP_VALUE_8814B 24
#define BIT_MASK_TEMP_VALUE_8814B 0x3f
#define BIT_TEMP_VALUE_8814B(x)                                                \
	(((x) & BIT_MASK_TEMP_VALUE_8814B) << BIT_SHIFT_TEMP_VALUE_8814B)
#define BITS_TEMP_VALUE_8814B                                                  \
	(BIT_MASK_TEMP_VALUE_8814B << BIT_SHIFT_TEMP_VALUE_8814B)
#define BIT_CLEAR_TEMP_VALUE_8814B(x) ((x) & (~BITS_TEMP_VALUE_8814B))
#define BIT_GET_TEMP_VALUE_8814B(x)                                            \
	(((x) >> BIT_SHIFT_TEMP_VALUE_8814B) & BIT_MASK_TEMP_VALUE_8814B)
#define BIT_SET_TEMP_VALUE_8814B(x, v)                                         \
	(BIT_CLEAR_TEMP_VALUE_8814B(x) | BIT_TEMP_VALUE_8814B(v))

#define BIT_SHIFT_REG_TMETER_TIMER_8814B 8
#define BIT_MASK_REG_TMETER_TIMER_8814B 0xfff
#define BIT_REG_TMETER_TIMER_8814B(x)                                          \
	(((x) & BIT_MASK_REG_TMETER_TIMER_8814B)                               \
	 << BIT_SHIFT_REG_TMETER_TIMER_8814B)
#define BITS_REG_TMETER_TIMER_8814B                                            \
	(BIT_MASK_REG_TMETER_TIMER_8814B << BIT_SHIFT_REG_TMETER_TIMER_8814B)
#define BIT_CLEAR_REG_TMETER_TIMER_8814B(x)                                    \
	((x) & (~BITS_REG_TMETER_TIMER_8814B))
#define BIT_GET_REG_TMETER_TIMER_8814B(x)                                      \
	(((x) >> BIT_SHIFT_REG_TMETER_TIMER_8814B) &                           \
	 BIT_MASK_REG_TMETER_TIMER_8814B)
#define BIT_SET_REG_TMETER_TIMER_8814B(x, v)                                   \
	(BIT_CLEAR_REG_TMETER_TIMER_8814B(x) | BIT_REG_TMETER_TIMER_8814B(v))

#define BIT_SHIFT_REG_TEMP_DELTA_8814B 2
#define BIT_MASK_REG_TEMP_DELTA_8814B 0x3f
#define BIT_REG_TEMP_DELTA_8814B(x)                                            \
	(((x) & BIT_MASK_REG_TEMP_DELTA_8814B)                                 \
	 << BIT_SHIFT_REG_TEMP_DELTA_8814B)
#define BITS_REG_TEMP_DELTA_8814B                                              \
	(BIT_MASK_REG_TEMP_DELTA_8814B << BIT_SHIFT_REG_TEMP_DELTA_8814B)
#define BIT_CLEAR_REG_TEMP_DELTA_8814B(x) ((x) & (~BITS_REG_TEMP_DELTA_8814B))
#define BIT_GET_REG_TEMP_DELTA_8814B(x)                                        \
	(((x) >> BIT_SHIFT_REG_TEMP_DELTA_8814B) &                             \
	 BIT_MASK_REG_TEMP_DELTA_8814B)
#define BIT_SET_REG_TEMP_DELTA_8814B(x, v)                                     \
	(BIT_CLEAR_REG_TEMP_DELTA_8814B(x) | BIT_REG_TEMP_DELTA_8814B(v))

#define BIT_REG_TMETER_EN_8814B BIT(0)

/* 2 REG_OSC_32K_CTRL_8814B */

#define BIT_SHIFT_OSC_32K_CLKGEN_0_8814B 16
#define BIT_MASK_OSC_32K_CLKGEN_0_8814B 0xffff
#define BIT_OSC_32K_CLKGEN_0_8814B(x)                                          \
	(((x) & BIT_MASK_OSC_32K_CLKGEN_0_8814B)                               \
	 << BIT_SHIFT_OSC_32K_CLKGEN_0_8814B)
#define BITS_OSC_32K_CLKGEN_0_8814B                                            \
	(BIT_MASK_OSC_32K_CLKGEN_0_8814B << BIT_SHIFT_OSC_32K_CLKGEN_0_8814B)
#define BIT_CLEAR_OSC_32K_CLKGEN_0_8814B(x)                                    \
	((x) & (~BITS_OSC_32K_CLKGEN_0_8814B))
#define BIT_GET_OSC_32K_CLKGEN_0_8814B(x)                                      \
	(((x) >> BIT_SHIFT_OSC_32K_CLKGEN_0_8814B) &                           \
	 BIT_MASK_OSC_32K_CLKGEN_0_8814B)
#define BIT_SET_OSC_32K_CLKGEN_0_8814B(x, v)                                   \
	(BIT_CLEAR_OSC_32K_CLKGEN_0_8814B(x) | BIT_OSC_32K_CLKGEN_0_8814B(v))

#define BIT_SHIFT_OSC_32K_RES_COMP_8814B 4
#define BIT_MASK_OSC_32K_RES_COMP_8814B 0x3
#define BIT_OSC_32K_RES_COMP_8814B(x)                                          \
	(((x) & BIT_MASK_OSC_32K_RES_COMP_8814B)                               \
	 << BIT_SHIFT_OSC_32K_RES_COMP_8814B)
#define BITS_OSC_32K_RES_COMP_8814B                                            \
	(BIT_MASK_OSC_32K_RES_COMP_8814B << BIT_SHIFT_OSC_32K_RES_COMP_8814B)
#define BIT_CLEAR_OSC_32K_RES_COMP_8814B(x)                                    \
	((x) & (~BITS_OSC_32K_RES_COMP_8814B))
#define BIT_GET_OSC_32K_RES_COMP_8814B(x)                                      \
	(((x) >> BIT_SHIFT_OSC_32K_RES_COMP_8814B) &                           \
	 BIT_MASK_OSC_32K_RES_COMP_8814B)
#define BIT_SET_OSC_32K_RES_COMP_8814B(x, v)                                   \
	(BIT_CLEAR_OSC_32K_RES_COMP_8814B(x) | BIT_OSC_32K_RES_COMP_8814B(v))

#define BIT_OSC_32K_OUT_SEL_8814B BIT(3)
#define BIT_ISO_WL_2_OSC_32K_8814B BIT(1)
#define BIT_POW_CKGEN_8814B BIT(0)

/* 2 REG_32K_CAL_REG1_8814B */
#define BIT_CAL_32K_REG_WR_8814B BIT(31)
#define BIT_CAL_32K_DBG_SEL_8814B BIT(22)

#define BIT_SHIFT_CAL_32K_REG_ADDR_8814B 16
#define BIT_MASK_CAL_32K_REG_ADDR_8814B 0x3f
#define BIT_CAL_32K_REG_ADDR_8814B(x)                                          \
	(((x) & BIT_MASK_CAL_32K_REG_ADDR_8814B)                               \
	 << BIT_SHIFT_CAL_32K_REG_ADDR_8814B)
#define BITS_CAL_32K_REG_ADDR_8814B                                            \
	(BIT_MASK_CAL_32K_REG_ADDR_8814B << BIT_SHIFT_CAL_32K_REG_ADDR_8814B)
#define BIT_CLEAR_CAL_32K_REG_ADDR_8814B(x)                                    \
	((x) & (~BITS_CAL_32K_REG_ADDR_8814B))
#define BIT_GET_CAL_32K_REG_ADDR_8814B(x)                                      \
	(((x) >> BIT_SHIFT_CAL_32K_REG_ADDR_8814B) &                           \
	 BIT_MASK_CAL_32K_REG_ADDR_8814B)
#define BIT_SET_CAL_32K_REG_ADDR_8814B(x, v)                                   \
	(BIT_CLEAR_CAL_32K_REG_ADDR_8814B(x) | BIT_CAL_32K_REG_ADDR_8814B(v))

#define BIT_SHIFT_CAL_32K_REG_DATA_8814B 0
#define BIT_MASK_CAL_32K_REG_DATA_8814B 0xffff
#define BIT_CAL_32K_REG_DATA_8814B(x)                                          \
	(((x) & BIT_MASK_CAL_32K_REG_DATA_8814B)                               \
	 << BIT_SHIFT_CAL_32K_REG_DATA_8814B)
#define BITS_CAL_32K_REG_DATA_8814B                                            \
	(BIT_MASK_CAL_32K_REG_DATA_8814B << BIT_SHIFT_CAL_32K_REG_DATA_8814B)
#define BIT_CLEAR_CAL_32K_REG_DATA_8814B(x)                                    \
	((x) & (~BITS_CAL_32K_REG_DATA_8814B))
#define BIT_GET_CAL_32K_REG_DATA_8814B(x)                                      \
	(((x) >> BIT_SHIFT_CAL_32K_REG_DATA_8814B) &                           \
	 BIT_MASK_CAL_32K_REG_DATA_8814B)
#define BIT_SET_CAL_32K_REG_DATA_8814B(x, v)                                   \
	(BIT_CLEAR_CAL_32K_REG_DATA_8814B(x) | BIT_CAL_32K_REG_DATA_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_C2HEVT_8814B */

#define BIT_SHIFT_C2HEVT_MSG_V1_8814B 0
#define BIT_MASK_C2HEVT_MSG_V1_8814B 0xffffffffL
#define BIT_C2HEVT_MSG_V1_8814B(x)                                             \
	(((x) & BIT_MASK_C2HEVT_MSG_V1_8814B) << BIT_SHIFT_C2HEVT_MSG_V1_8814B)
#define BITS_C2HEVT_MSG_V1_8814B                                               \
	(BIT_MASK_C2HEVT_MSG_V1_8814B << BIT_SHIFT_C2HEVT_MSG_V1_8814B)
#define BIT_CLEAR_C2HEVT_MSG_V1_8814B(x) ((x) & (~BITS_C2HEVT_MSG_V1_8814B))
#define BIT_GET_C2HEVT_MSG_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_V1_8814B) & BIT_MASK_C2HEVT_MSG_V1_8814B)
#define BIT_SET_C2HEVT_MSG_V1_8814B(x, v)                                      \
	(BIT_CLEAR_C2HEVT_MSG_V1_8814B(x) | BIT_C2HEVT_MSG_V1_8814B(v))

/* 2 REG_C2HEVT_1_8814B */

#define BIT_SHIFT_C2HEVT_MSG_1_8814B 0
#define BIT_MASK_C2HEVT_MSG_1_8814B 0xffffffffL
#define BIT_C2HEVT_MSG_1_8814B(x)                                              \
	(((x) & BIT_MASK_C2HEVT_MSG_1_8814B) << BIT_SHIFT_C2HEVT_MSG_1_8814B)
#define BITS_C2HEVT_MSG_1_8814B                                                \
	(BIT_MASK_C2HEVT_MSG_1_8814B << BIT_SHIFT_C2HEVT_MSG_1_8814B)
#define BIT_CLEAR_C2HEVT_MSG_1_8814B(x) ((x) & (~BITS_C2HEVT_MSG_1_8814B))
#define BIT_GET_C2HEVT_MSG_1_8814B(x)                                          \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_1_8814B) & BIT_MASK_C2HEVT_MSG_1_8814B)
#define BIT_SET_C2HEVT_MSG_1_8814B(x, v)                                       \
	(BIT_CLEAR_C2HEVT_MSG_1_8814B(x) | BIT_C2HEVT_MSG_1_8814B(v))

/* 2 REG_C2HEVT_2_8814B */

#define BIT_SHIFT_C2HEVT_MSG_2_8814B 0
#define BIT_MASK_C2HEVT_MSG_2_8814B 0xffffffffL
#define BIT_C2HEVT_MSG_2_8814B(x)                                              \
	(((x) & BIT_MASK_C2HEVT_MSG_2_8814B) << BIT_SHIFT_C2HEVT_MSG_2_8814B)
#define BITS_C2HEVT_MSG_2_8814B                                                \
	(BIT_MASK_C2HEVT_MSG_2_8814B << BIT_SHIFT_C2HEVT_MSG_2_8814B)
#define BIT_CLEAR_C2HEVT_MSG_2_8814B(x) ((x) & (~BITS_C2HEVT_MSG_2_8814B))
#define BIT_GET_C2HEVT_MSG_2_8814B(x)                                          \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_2_8814B) & BIT_MASK_C2HEVT_MSG_2_8814B)
#define BIT_SET_C2HEVT_MSG_2_8814B(x, v)                                       \
	(BIT_CLEAR_C2HEVT_MSG_2_8814B(x) | BIT_C2HEVT_MSG_2_8814B(v))

/* 2 REG_C2HEVT_3_8814B */

#define BIT_SHIFT_C2HEVT_MSG_3_8814B 0
#define BIT_MASK_C2HEVT_MSG_3_8814B 0xffffffffL
#define BIT_C2HEVT_MSG_3_8814B(x)                                              \
	(((x) & BIT_MASK_C2HEVT_MSG_3_8814B) << BIT_SHIFT_C2HEVT_MSG_3_8814B)
#define BITS_C2HEVT_MSG_3_8814B                                                \
	(BIT_MASK_C2HEVT_MSG_3_8814B << BIT_SHIFT_C2HEVT_MSG_3_8814B)
#define BIT_CLEAR_C2HEVT_MSG_3_8814B(x) ((x) & (~BITS_C2HEVT_MSG_3_8814B))
#define BIT_GET_C2HEVT_MSG_3_8814B(x)                                          \
	(((x) >> BIT_SHIFT_C2HEVT_MSG_3_8814B) & BIT_MASK_C2HEVT_MSG_3_8814B)
#define BIT_SET_C2HEVT_MSG_3_8814B(x, v)                                       \
	(BIT_CLEAR_C2HEVT_MSG_3_8814B(x) | BIT_C2HEVT_MSG_3_8814B(v))

/* 2 REG_RXDESC_BUFF_RPTR_8814B */

#define BIT_SHIFT_RXDESC_BUFF_RPTR_8814B 0
#define BIT_MASK_RXDESC_BUFF_RPTR_8814B 0xffffffffL
#define BIT_RXDESC_BUFF_RPTR_8814B(x)                                          \
	(((x) & BIT_MASK_RXDESC_BUFF_RPTR_8814B)                               \
	 << BIT_SHIFT_RXDESC_BUFF_RPTR_8814B)
#define BITS_RXDESC_BUFF_RPTR_8814B                                            \
	(BIT_MASK_RXDESC_BUFF_RPTR_8814B << BIT_SHIFT_RXDESC_BUFF_RPTR_8814B)
#define BIT_CLEAR_RXDESC_BUFF_RPTR_8814B(x)                                    \
	((x) & (~BITS_RXDESC_BUFF_RPTR_8814B))
#define BIT_GET_RXDESC_BUFF_RPTR_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RXDESC_BUFF_RPTR_8814B) &                           \
	 BIT_MASK_RXDESC_BUFF_RPTR_8814B)
#define BIT_SET_RXDESC_BUFF_RPTR_8814B(x, v)                                   \
	(BIT_CLEAR_RXDESC_BUFF_RPTR_8814B(x) | BIT_RXDESC_BUFF_RPTR_8814B(v))

/* 2 REG_RXDESC_BUFF_WPTR_8814B */

#define BIT_SHIFT_RXDESC_BUFF_WPTR_8814B 0
#define BIT_MASK_RXDESC_BUFF_WPTR_8814B 0xffffffffL
#define BIT_RXDESC_BUFF_WPTR_8814B(x)                                          \
	(((x) & BIT_MASK_RXDESC_BUFF_WPTR_8814B)                               \
	 << BIT_SHIFT_RXDESC_BUFF_WPTR_8814B)
#define BITS_RXDESC_BUFF_WPTR_8814B                                            \
	(BIT_MASK_RXDESC_BUFF_WPTR_8814B << BIT_SHIFT_RXDESC_BUFF_WPTR_8814B)
#define BIT_CLEAR_RXDESC_BUFF_WPTR_8814B(x)                                    \
	((x) & (~BITS_RXDESC_BUFF_WPTR_8814B))
#define BIT_GET_RXDESC_BUFF_WPTR_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RXDESC_BUFF_WPTR_8814B) &                           \
	 BIT_MASK_RXDESC_BUFF_WPTR_8814B)
#define BIT_SET_RXDESC_BUFF_WPTR_8814B(x, v)                                   \
	(BIT_CLEAR_RXDESC_BUFF_WPTR_8814B(x) | BIT_RXDESC_BUFF_WPTR_8814B(v))

/* 2 REG_SW_DEFINED_PAGE1_8814B */

#define BIT_SHIFT_SW_DEFINED_PAGE1_V1_8814B 0
#define BIT_MASK_SW_DEFINED_PAGE1_V1_8814B 0xffffffffL
#define BIT_SW_DEFINED_PAGE1_V1_8814B(x)                                       \
	(((x) & BIT_MASK_SW_DEFINED_PAGE1_V1_8814B)                            \
	 << BIT_SHIFT_SW_DEFINED_PAGE1_V1_8814B)
#define BITS_SW_DEFINED_PAGE1_V1_8814B                                         \
	(BIT_MASK_SW_DEFINED_PAGE1_V1_8814B                                    \
	 << BIT_SHIFT_SW_DEFINED_PAGE1_V1_8814B)
#define BIT_CLEAR_SW_DEFINED_PAGE1_V1_8814B(x)                                 \
	((x) & (~BITS_SW_DEFINED_PAGE1_V1_8814B))
#define BIT_GET_SW_DEFINED_PAGE1_V1_8814B(x)                                   \
	(((x) >> BIT_SHIFT_SW_DEFINED_PAGE1_V1_8814B) &                        \
	 BIT_MASK_SW_DEFINED_PAGE1_V1_8814B)
#define BIT_SET_SW_DEFINED_PAGE1_V1_8814B(x, v)                                \
	(BIT_CLEAR_SW_DEFINED_PAGE1_V1_8814B(x) |                              \
	 BIT_SW_DEFINED_PAGE1_V1_8814B(v))

/* 2 REG_SW_DEFINED_PAGE2_8814B */

#define BIT_SHIFT_SW_DEFINED_PAGE2_8814B 0
#define BIT_MASK_SW_DEFINED_PAGE2_8814B 0xffffffffL
#define BIT_SW_DEFINED_PAGE2_8814B(x)                                          \
	(((x) & BIT_MASK_SW_DEFINED_PAGE2_8814B)                               \
	 << BIT_SHIFT_SW_DEFINED_PAGE2_8814B)
#define BITS_SW_DEFINED_PAGE2_8814B                                            \
	(BIT_MASK_SW_DEFINED_PAGE2_8814B << BIT_SHIFT_SW_DEFINED_PAGE2_8814B)
#define BIT_CLEAR_SW_DEFINED_PAGE2_8814B(x)                                    \
	((x) & (~BITS_SW_DEFINED_PAGE2_8814B))
#define BIT_GET_SW_DEFINED_PAGE2_8814B(x)                                      \
	(((x) >> BIT_SHIFT_SW_DEFINED_PAGE2_8814B) &                           \
	 BIT_MASK_SW_DEFINED_PAGE2_8814B)
#define BIT_SET_SW_DEFINED_PAGE2_8814B(x, v)                                   \
	(BIT_CLEAR_SW_DEFINED_PAGE2_8814B(x) | BIT_SW_DEFINED_PAGE2_8814B(v))

/* 2 REG_MCUTST_I_8814B */

#define BIT_SHIFT_MCUDMSG_I_8814B 0
#define BIT_MASK_MCUDMSG_I_8814B 0xffffffffL
#define BIT_MCUDMSG_I_8814B(x)                                                 \
	(((x) & BIT_MASK_MCUDMSG_I_8814B) << BIT_SHIFT_MCUDMSG_I_8814B)
#define BITS_MCUDMSG_I_8814B                                                   \
	(BIT_MASK_MCUDMSG_I_8814B << BIT_SHIFT_MCUDMSG_I_8814B)
#define BIT_CLEAR_MCUDMSG_I_8814B(x) ((x) & (~BITS_MCUDMSG_I_8814B))
#define BIT_GET_MCUDMSG_I_8814B(x)                                             \
	(((x) >> BIT_SHIFT_MCUDMSG_I_8814B) & BIT_MASK_MCUDMSG_I_8814B)
#define BIT_SET_MCUDMSG_I_8814B(x, v)                                          \
	(BIT_CLEAR_MCUDMSG_I_8814B(x) | BIT_MCUDMSG_I_8814B(v))

/* 2 REG_MCUTST_II_8814B */

#define BIT_SHIFT_MCUDMSG_II_8814B 0
#define BIT_MASK_MCUDMSG_II_8814B 0xffffffffL
#define BIT_MCUDMSG_II_8814B(x)                                                \
	(((x) & BIT_MASK_MCUDMSG_II_8814B) << BIT_SHIFT_MCUDMSG_II_8814B)
#define BITS_MCUDMSG_II_8814B                                                  \
	(BIT_MASK_MCUDMSG_II_8814B << BIT_SHIFT_MCUDMSG_II_8814B)
#define BIT_CLEAR_MCUDMSG_II_8814B(x) ((x) & (~BITS_MCUDMSG_II_8814B))
#define BIT_GET_MCUDMSG_II_8814B(x)                                            \
	(((x) >> BIT_SHIFT_MCUDMSG_II_8814B) & BIT_MASK_MCUDMSG_II_8814B)
#define BIT_SET_MCUDMSG_II_8814B(x, v)                                         \
	(BIT_CLEAR_MCUDMSG_II_8814B(x) | BIT_MCUDMSG_II_8814B(v))

/* 2 REG_FMETHR_8814B */
#define BIT_FMSG_INT_8814B BIT(31)

#define BIT_SHIFT_FW_MSG_8814B 0
#define BIT_MASK_FW_MSG_8814B 0xffffffffL
#define BIT_FW_MSG_8814B(x)                                                    \
	(((x) & BIT_MASK_FW_MSG_8814B) << BIT_SHIFT_FW_MSG_8814B)
#define BITS_FW_MSG_8814B (BIT_MASK_FW_MSG_8814B << BIT_SHIFT_FW_MSG_8814B)
#define BIT_CLEAR_FW_MSG_8814B(x) ((x) & (~BITS_FW_MSG_8814B))
#define BIT_GET_FW_MSG_8814B(x)                                                \
	(((x) >> BIT_SHIFT_FW_MSG_8814B) & BIT_MASK_FW_MSG_8814B)
#define BIT_SET_FW_MSG_8814B(x, v)                                             \
	(BIT_CLEAR_FW_MSG_8814B(x) | BIT_FW_MSG_8814B(v))

/* 2 REG_HMETFR_8814B */

#define BIT_SHIFT_HRCV_MSG_8814B 24
#define BIT_MASK_HRCV_MSG_8814B 0xff
#define BIT_HRCV_MSG_8814B(x)                                                  \
	(((x) & BIT_MASK_HRCV_MSG_8814B) << BIT_SHIFT_HRCV_MSG_8814B)
#define BITS_HRCV_MSG_8814B                                                    \
	(BIT_MASK_HRCV_MSG_8814B << BIT_SHIFT_HRCV_MSG_8814B)
#define BIT_CLEAR_HRCV_MSG_8814B(x) ((x) & (~BITS_HRCV_MSG_8814B))
#define BIT_GET_HRCV_MSG_8814B(x)                                              \
	(((x) >> BIT_SHIFT_HRCV_MSG_8814B) & BIT_MASK_HRCV_MSG_8814B)
#define BIT_SET_HRCV_MSG_8814B(x, v)                                           \
	(BIT_CLEAR_HRCV_MSG_8814B(x) | BIT_HRCV_MSG_8814B(v))

#define BIT_INT_BOX3_8814B BIT(3)
#define BIT_INT_BOX2_8814B BIT(2)
#define BIT_INT_BOX1_8814B BIT(1)
#define BIT_INT_BOX0_8814B BIT(0)

/* 2 REG_HMEBOX0_8814B */

#define BIT_SHIFT_HOST_MSG_0_8814B 0
#define BIT_MASK_HOST_MSG_0_8814B 0xffffffffL
#define BIT_HOST_MSG_0_8814B(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_0_8814B) << BIT_SHIFT_HOST_MSG_0_8814B)
#define BITS_HOST_MSG_0_8814B                                                  \
	(BIT_MASK_HOST_MSG_0_8814B << BIT_SHIFT_HOST_MSG_0_8814B)
#define BIT_CLEAR_HOST_MSG_0_8814B(x) ((x) & (~BITS_HOST_MSG_0_8814B))
#define BIT_GET_HOST_MSG_0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_0_8814B) & BIT_MASK_HOST_MSG_0_8814B)
#define BIT_SET_HOST_MSG_0_8814B(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_0_8814B(x) | BIT_HOST_MSG_0_8814B(v))

/* 2 REG_HMEBOX1_8814B */

#define BIT_SHIFT_HOST_MSG_1_8814B 0
#define BIT_MASK_HOST_MSG_1_8814B 0xffffffffL
#define BIT_HOST_MSG_1_8814B(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_1_8814B) << BIT_SHIFT_HOST_MSG_1_8814B)
#define BITS_HOST_MSG_1_8814B                                                  \
	(BIT_MASK_HOST_MSG_1_8814B << BIT_SHIFT_HOST_MSG_1_8814B)
#define BIT_CLEAR_HOST_MSG_1_8814B(x) ((x) & (~BITS_HOST_MSG_1_8814B))
#define BIT_GET_HOST_MSG_1_8814B(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_1_8814B) & BIT_MASK_HOST_MSG_1_8814B)
#define BIT_SET_HOST_MSG_1_8814B(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_1_8814B(x) | BIT_HOST_MSG_1_8814B(v))

/* 2 REG_HMEBOX2_8814B */

#define BIT_SHIFT_HOST_MSG_2_8814B 0
#define BIT_MASK_HOST_MSG_2_8814B 0xffffffffL
#define BIT_HOST_MSG_2_8814B(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_2_8814B) << BIT_SHIFT_HOST_MSG_2_8814B)
#define BITS_HOST_MSG_2_8814B                                                  \
	(BIT_MASK_HOST_MSG_2_8814B << BIT_SHIFT_HOST_MSG_2_8814B)
#define BIT_CLEAR_HOST_MSG_2_8814B(x) ((x) & (~BITS_HOST_MSG_2_8814B))
#define BIT_GET_HOST_MSG_2_8814B(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_2_8814B) & BIT_MASK_HOST_MSG_2_8814B)
#define BIT_SET_HOST_MSG_2_8814B(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_2_8814B(x) | BIT_HOST_MSG_2_8814B(v))

/* 2 REG_HMEBOX3_8814B */

#define BIT_SHIFT_HOST_MSG_3_8814B 0
#define BIT_MASK_HOST_MSG_3_8814B 0xffffffffL
#define BIT_HOST_MSG_3_8814B(x)                                                \
	(((x) & BIT_MASK_HOST_MSG_3_8814B) << BIT_SHIFT_HOST_MSG_3_8814B)
#define BITS_HOST_MSG_3_8814B                                                  \
	(BIT_MASK_HOST_MSG_3_8814B << BIT_SHIFT_HOST_MSG_3_8814B)
#define BIT_CLEAR_HOST_MSG_3_8814B(x) ((x) & (~BITS_HOST_MSG_3_8814B))
#define BIT_GET_HOST_MSG_3_8814B(x)                                            \
	(((x) >> BIT_SHIFT_HOST_MSG_3_8814B) & BIT_MASK_HOST_MSG_3_8814B)
#define BIT_SET_HOST_MSG_3_8814B(x, v)                                         \
	(BIT_CLEAR_HOST_MSG_3_8814B(x) | BIT_HOST_MSG_3_8814B(v))

/* 2 REG_RXDESC_BUFF_BNDY_8814B */

#define BIT_SHIFT_RXDESC_BUFF_BNDY_8814B 0
#define BIT_MASK_RXDESC_BUFF_BNDY_8814B 0xffffffffL
#define BIT_RXDESC_BUFF_BNDY_8814B(x)                                          \
	(((x) & BIT_MASK_RXDESC_BUFF_BNDY_8814B)                               \
	 << BIT_SHIFT_RXDESC_BUFF_BNDY_8814B)
#define BITS_RXDESC_BUFF_BNDY_8814B                                            \
	(BIT_MASK_RXDESC_BUFF_BNDY_8814B << BIT_SHIFT_RXDESC_BUFF_BNDY_8814B)
#define BIT_CLEAR_RXDESC_BUFF_BNDY_8814B(x)                                    \
	((x) & (~BITS_RXDESC_BUFF_BNDY_8814B))
#define BIT_GET_RXDESC_BUFF_BNDY_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RXDESC_BUFF_BNDY_8814B) &                           \
	 BIT_MASK_RXDESC_BUFF_BNDY_8814B)
#define BIT_SET_RXDESC_BUFF_BNDY_8814B(x, v)                                   \
	(BIT_CLEAR_RXDESC_BUFF_BNDY_8814B(x) | BIT_RXDESC_BUFF_BNDY_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BB_ACCESS_CTRL_8814B */

#define BIT_SHIFT_BB_WRITE_READ_8814B 30
#define BIT_MASK_BB_WRITE_READ_8814B 0x3
#define BIT_BB_WRITE_READ_8814B(x)                                             \
	(((x) & BIT_MASK_BB_WRITE_READ_8814B) << BIT_SHIFT_BB_WRITE_READ_8814B)
#define BITS_BB_WRITE_READ_8814B                                               \
	(BIT_MASK_BB_WRITE_READ_8814B << BIT_SHIFT_BB_WRITE_READ_8814B)
#define BIT_CLEAR_BB_WRITE_READ_8814B(x) ((x) & (~BITS_BB_WRITE_READ_8814B))
#define BIT_GET_BB_WRITE_READ_8814B(x)                                         \
	(((x) >> BIT_SHIFT_BB_WRITE_READ_8814B) & BIT_MASK_BB_WRITE_READ_8814B)
#define BIT_SET_BB_WRITE_READ_8814B(x, v)                                      \
	(BIT_CLEAR_BB_WRITE_READ_8814B(x) | BIT_BB_WRITE_READ_8814B(v))

#define BIT_SHIFT_BB_WRITE_EN_8814B 12
#define BIT_MASK_BB_WRITE_EN_8814B 0xf
#define BIT_BB_WRITE_EN_8814B(x)                                               \
	(((x) & BIT_MASK_BB_WRITE_EN_8814B) << BIT_SHIFT_BB_WRITE_EN_8814B)
#define BITS_BB_WRITE_EN_8814B                                                 \
	(BIT_MASK_BB_WRITE_EN_8814B << BIT_SHIFT_BB_WRITE_EN_8814B)
#define BIT_CLEAR_BB_WRITE_EN_8814B(x) ((x) & (~BITS_BB_WRITE_EN_8814B))
#define BIT_GET_BB_WRITE_EN_8814B(x)                                           \
	(((x) >> BIT_SHIFT_BB_WRITE_EN_8814B) & BIT_MASK_BB_WRITE_EN_8814B)
#define BIT_SET_BB_WRITE_EN_8814B(x, v)                                        \
	(BIT_CLEAR_BB_WRITE_EN_8814B(x) | BIT_BB_WRITE_EN_8814B(v))

#define BIT_SHIFT_BB_ADDR_8814B 2
#define BIT_MASK_BB_ADDR_8814B 0x1ff
#define BIT_BB_ADDR_8814B(x)                                                   \
	(((x) & BIT_MASK_BB_ADDR_8814B) << BIT_SHIFT_BB_ADDR_8814B)
#define BITS_BB_ADDR_8814B (BIT_MASK_BB_ADDR_8814B << BIT_SHIFT_BB_ADDR_8814B)
#define BIT_CLEAR_BB_ADDR_8814B(x) ((x) & (~BITS_BB_ADDR_8814B))
#define BIT_GET_BB_ADDR_8814B(x)                                               \
	(((x) >> BIT_SHIFT_BB_ADDR_8814B) & BIT_MASK_BB_ADDR_8814B)
#define BIT_SET_BB_ADDR_8814B(x, v)                                            \
	(BIT_CLEAR_BB_ADDR_8814B(x) | BIT_BB_ADDR_8814B(v))

#define BIT_BB_ERRACC_8814B BIT(0)

/* 2 REG_BB_ACCESS_DATA_8814B */

#define BIT_SHIFT_BB_DATA_8814B 0
#define BIT_MASK_BB_DATA_8814B 0xffffffffL
#define BIT_BB_DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_BB_DATA_8814B) << BIT_SHIFT_BB_DATA_8814B)
#define BITS_BB_DATA_8814B (BIT_MASK_BB_DATA_8814B << BIT_SHIFT_BB_DATA_8814B)
#define BIT_CLEAR_BB_DATA_8814B(x) ((x) & (~BITS_BB_DATA_8814B))
#define BIT_GET_BB_DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_BB_DATA_8814B) & BIT_MASK_BB_DATA_8814B)
#define BIT_SET_BB_DATA_8814B(x, v)                                            \
	(BIT_CLEAR_BB_DATA_8814B(x) | BIT_BB_DATA_8814B(v))

/* 2 REG_HMEBOX_E0_8814B */

#define BIT_SHIFT_HMEBOX_E0_8814B 0
#define BIT_MASK_HMEBOX_E0_8814B 0xffffffffL
#define BIT_HMEBOX_E0_8814B(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E0_8814B) << BIT_SHIFT_HMEBOX_E0_8814B)
#define BITS_HMEBOX_E0_8814B                                                   \
	(BIT_MASK_HMEBOX_E0_8814B << BIT_SHIFT_HMEBOX_E0_8814B)
#define BIT_CLEAR_HMEBOX_E0_8814B(x) ((x) & (~BITS_HMEBOX_E0_8814B))
#define BIT_GET_HMEBOX_E0_8814B(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E0_8814B) & BIT_MASK_HMEBOX_E0_8814B)
#define BIT_SET_HMEBOX_E0_8814B(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E0_8814B(x) | BIT_HMEBOX_E0_8814B(v))

/* 2 REG_HMEBOX_E1_8814B */

#define BIT_SHIFT_HMEBOX_E1_8814B 0
#define BIT_MASK_HMEBOX_E1_8814B 0xffffffffL
#define BIT_HMEBOX_E1_8814B(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E1_8814B) << BIT_SHIFT_HMEBOX_E1_8814B)
#define BITS_HMEBOX_E1_8814B                                                   \
	(BIT_MASK_HMEBOX_E1_8814B << BIT_SHIFT_HMEBOX_E1_8814B)
#define BIT_CLEAR_HMEBOX_E1_8814B(x) ((x) & (~BITS_HMEBOX_E1_8814B))
#define BIT_GET_HMEBOX_E1_8814B(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E1_8814B) & BIT_MASK_HMEBOX_E1_8814B)
#define BIT_SET_HMEBOX_E1_8814B(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E1_8814B(x) | BIT_HMEBOX_E1_8814B(v))

/* 2 REG_HMEBOX_E2_8814B */

#define BIT_SHIFT_HMEBOX_E2_8814B 0
#define BIT_MASK_HMEBOX_E2_8814B 0xffffffffL
#define BIT_HMEBOX_E2_8814B(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E2_8814B) << BIT_SHIFT_HMEBOX_E2_8814B)
#define BITS_HMEBOX_E2_8814B                                                   \
	(BIT_MASK_HMEBOX_E2_8814B << BIT_SHIFT_HMEBOX_E2_8814B)
#define BIT_CLEAR_HMEBOX_E2_8814B(x) ((x) & (~BITS_HMEBOX_E2_8814B))
#define BIT_GET_HMEBOX_E2_8814B(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E2_8814B) & BIT_MASK_HMEBOX_E2_8814B)
#define BIT_SET_HMEBOX_E2_8814B(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E2_8814B(x) | BIT_HMEBOX_E2_8814B(v))

/* 2 REG_HMEBOX_E3_8814B */

#define BIT_SHIFT_HMEBOX_E3_8814B 0
#define BIT_MASK_HMEBOX_E3_8814B 0xffffffffL
#define BIT_HMEBOX_E3_8814B(x)                                                 \
	(((x) & BIT_MASK_HMEBOX_E3_8814B) << BIT_SHIFT_HMEBOX_E3_8814B)
#define BITS_HMEBOX_E3_8814B                                                   \
	(BIT_MASK_HMEBOX_E3_8814B << BIT_SHIFT_HMEBOX_E3_8814B)
#define BIT_CLEAR_HMEBOX_E3_8814B(x) ((x) & (~BITS_HMEBOX_E3_8814B))
#define BIT_GET_HMEBOX_E3_8814B(x)                                             \
	(((x) >> BIT_SHIFT_HMEBOX_E3_8814B) & BIT_MASK_HMEBOX_E3_8814B)
#define BIT_SET_HMEBOX_E3_8814B(x, v)                                          \
	(BIT_CLEAR_HMEBOX_E3_8814B(x) | BIT_HMEBOX_E3_8814B(v))

/* 2 REG_CR_EXT_8814B */

#define BIT_SHIFT_PHY_REQ_DELAY_8814B 24
#define BIT_MASK_PHY_REQ_DELAY_8814B 0xf
#define BIT_PHY_REQ_DELAY_8814B(x)                                             \
	(((x) & BIT_MASK_PHY_REQ_DELAY_8814B) << BIT_SHIFT_PHY_REQ_DELAY_8814B)
#define BITS_PHY_REQ_DELAY_8814B                                               \
	(BIT_MASK_PHY_REQ_DELAY_8814B << BIT_SHIFT_PHY_REQ_DELAY_8814B)
#define BIT_CLEAR_PHY_REQ_DELAY_8814B(x) ((x) & (~BITS_PHY_REQ_DELAY_8814B))
#define BIT_GET_PHY_REQ_DELAY_8814B(x)                                         \
	(((x) >> BIT_SHIFT_PHY_REQ_DELAY_8814B) & BIT_MASK_PHY_REQ_DELAY_8814B)
#define BIT_SET_PHY_REQ_DELAY_8814B(x, v)                                      \
	(BIT_CLEAR_PHY_REQ_DELAY_8814B(x) | BIT_PHY_REQ_DELAY_8814B(v))

/* 2 REG_NOT_VALID_8814B */
#define BIT_FW_FIFO_PTR_RST_8814B BIT(18)
#define BIT_PHY_FIFO_PTR_RST_8814B BIT(17)
#define BIT_SPD_DOWN_8814B BIT(16)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_NETYPE4_8814B 4
#define BIT_MASK_NETYPE4_8814B 0x3
#define BIT_NETYPE4_8814B(x)                                                   \
	(((x) & BIT_MASK_NETYPE4_8814B) << BIT_SHIFT_NETYPE4_8814B)
#define BITS_NETYPE4_8814B (BIT_MASK_NETYPE4_8814B << BIT_SHIFT_NETYPE4_8814B)
#define BIT_CLEAR_NETYPE4_8814B(x) ((x) & (~BITS_NETYPE4_8814B))
#define BIT_GET_NETYPE4_8814B(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE4_8814B) & BIT_MASK_NETYPE4_8814B)
#define BIT_SET_NETYPE4_8814B(x, v)                                            \
	(BIT_CLEAR_NETYPE4_8814B(x) | BIT_NETYPE4_8814B(v))

#define BIT_SHIFT_NETYPE3_8814B 2
#define BIT_MASK_NETYPE3_8814B 0x3
#define BIT_NETYPE3_8814B(x)                                                   \
	(((x) & BIT_MASK_NETYPE3_8814B) << BIT_SHIFT_NETYPE3_8814B)
#define BITS_NETYPE3_8814B (BIT_MASK_NETYPE3_8814B << BIT_SHIFT_NETYPE3_8814B)
#define BIT_CLEAR_NETYPE3_8814B(x) ((x) & (~BITS_NETYPE3_8814B))
#define BIT_GET_NETYPE3_8814B(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE3_8814B) & BIT_MASK_NETYPE3_8814B)
#define BIT_SET_NETYPE3_8814B(x, v)                                            \
	(BIT_CLEAR_NETYPE3_8814B(x) | BIT_NETYPE3_8814B(v))

#define BIT_SHIFT_NETYPE2_8814B 0
#define BIT_MASK_NETYPE2_8814B 0x3
#define BIT_NETYPE2_8814B(x)                                                   \
	(((x) & BIT_MASK_NETYPE2_8814B) << BIT_SHIFT_NETYPE2_8814B)
#define BITS_NETYPE2_8814B (BIT_MASK_NETYPE2_8814B << BIT_SHIFT_NETYPE2_8814B)
#define BIT_CLEAR_NETYPE2_8814B(x) ((x) & (~BITS_NETYPE2_8814B))
#define BIT_GET_NETYPE2_8814B(x)                                               \
	(((x) >> BIT_SHIFT_NETYPE2_8814B) & BIT_MASK_NETYPE2_8814B)
#define BIT_SET_NETYPE2_8814B(x, v)                                            \
	(BIT_CLEAR_NETYPE2_8814B(x) | BIT_NETYPE2_8814B(v))

/* 2 REG_TC9_CTRL_8814B */
#define BIT_TC9INT_EN_8814B BIT(26)
#define BIT_TC9MODE_8814B BIT(25)
#define BIT_TC9EN_8814B BIT(24)

#define BIT_SHIFT_TC9DATA_8814B 0
#define BIT_MASK_TC9DATA_8814B 0xffffff
#define BIT_TC9DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC9DATA_8814B) << BIT_SHIFT_TC9DATA_8814B)
#define BITS_TC9DATA_8814B (BIT_MASK_TC9DATA_8814B << BIT_SHIFT_TC9DATA_8814B)
#define BIT_CLEAR_TC9DATA_8814B(x) ((x) & (~BITS_TC9DATA_8814B))
#define BIT_GET_TC9DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC9DATA_8814B) & BIT_MASK_TC9DATA_8814B)
#define BIT_SET_TC9DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC9DATA_8814B(x) | BIT_TC9DATA_8814B(v))

/* 2 REG_TC10_CTRL_8814B */
#define BIT_TC10INT_EN_8814B BIT(26)
#define BIT_TC10MODE_8814B BIT(25)
#define BIT_TC10EN_8814B BIT(24)

#define BIT_SHIFT_TC10DATA_8814B 0
#define BIT_MASK_TC10DATA_8814B 0xffffff
#define BIT_TC10DATA_8814B(x)                                                  \
	(((x) & BIT_MASK_TC10DATA_8814B) << BIT_SHIFT_TC10DATA_8814B)
#define BITS_TC10DATA_8814B                                                    \
	(BIT_MASK_TC10DATA_8814B << BIT_SHIFT_TC10DATA_8814B)
#define BIT_CLEAR_TC10DATA_8814B(x) ((x) & (~BITS_TC10DATA_8814B))
#define BIT_GET_TC10DATA_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TC10DATA_8814B) & BIT_MASK_TC10DATA_8814B)
#define BIT_SET_TC10DATA_8814B(x, v)                                           \
	(BIT_CLEAR_TC10DATA_8814B(x) | BIT_TC10DATA_8814B(v))

/* 2 REG_TC11_CTRL_8814B */
#define BIT_TC11INT_EN_8814B BIT(26)
#define BIT_TC11MODE_8814B BIT(25)
#define BIT_TC11EN_8814B BIT(24)

#define BIT_SHIFT_TC11DATA_8814B 0
#define BIT_MASK_TC11DATA_8814B 0xffffff
#define BIT_TC11DATA_8814B(x)                                                  \
	(((x) & BIT_MASK_TC11DATA_8814B) << BIT_SHIFT_TC11DATA_8814B)
#define BITS_TC11DATA_8814B                                                    \
	(BIT_MASK_TC11DATA_8814B << BIT_SHIFT_TC11DATA_8814B)
#define BIT_CLEAR_TC11DATA_8814B(x) ((x) & (~BITS_TC11DATA_8814B))
#define BIT_GET_TC11DATA_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TC11DATA_8814B) & BIT_MASK_TC11DATA_8814B)
#define BIT_SET_TC11DATA_8814B(x, v)                                           \
	(BIT_CLEAR_TC11DATA_8814B(x) | BIT_TC11DATA_8814B(v))

/* 2 REG_TC12_CTRL_8814B */
#define BIT_TC12INT_EN_8814B BIT(26)
#define BIT_TC12MODE_8814B BIT(25)
#define BIT_TC12EN_8814B BIT(24)

#define BIT_SHIFT_TC12DATA_8814B 0
#define BIT_MASK_TC12DATA_8814B 0xffffff
#define BIT_TC12DATA_8814B(x)                                                  \
	(((x) & BIT_MASK_TC12DATA_8814B) << BIT_SHIFT_TC12DATA_8814B)
#define BITS_TC12DATA_8814B                                                    \
	(BIT_MASK_TC12DATA_8814B << BIT_SHIFT_TC12DATA_8814B)
#define BIT_CLEAR_TC12DATA_8814B(x) ((x) & (~BITS_TC12DATA_8814B))
#define BIT_GET_TC12DATA_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TC12DATA_8814B) & BIT_MASK_TC12DATA_8814B)
#define BIT_SET_TC12DATA_8814B(x, v)                                           \
	(BIT_CLEAR_TC12DATA_8814B(x) | BIT_TC12DATA_8814B(v))

/* 2 REG_FWFF_8814B */

#define BIT_SHIFT_PKTNUM_TH_V1_8814B 24
#define BIT_MASK_PKTNUM_TH_V1_8814B 0xff
#define BIT_PKTNUM_TH_V1_8814B(x)                                              \
	(((x) & BIT_MASK_PKTNUM_TH_V1_8814B) << BIT_SHIFT_PKTNUM_TH_V1_8814B)
#define BITS_PKTNUM_TH_V1_8814B                                                \
	(BIT_MASK_PKTNUM_TH_V1_8814B << BIT_SHIFT_PKTNUM_TH_V1_8814B)
#define BIT_CLEAR_PKTNUM_TH_V1_8814B(x) ((x) & (~BITS_PKTNUM_TH_V1_8814B))
#define BIT_GET_PKTNUM_TH_V1_8814B(x)                                          \
	(((x) >> BIT_SHIFT_PKTNUM_TH_V1_8814B) & BIT_MASK_PKTNUM_TH_V1_8814B)
#define BIT_SET_PKTNUM_TH_V1_8814B(x, v)                                       \
	(BIT_CLEAR_PKTNUM_TH_V1_8814B(x) | BIT_PKTNUM_TH_V1_8814B(v))

#define BIT_SHIFT_TIMER_TH_8814B 16
#define BIT_MASK_TIMER_TH_8814B 0xff
#define BIT_TIMER_TH_8814B(x)                                                  \
	(((x) & BIT_MASK_TIMER_TH_8814B) << BIT_SHIFT_TIMER_TH_8814B)
#define BITS_TIMER_TH_8814B                                                    \
	(BIT_MASK_TIMER_TH_8814B << BIT_SHIFT_TIMER_TH_8814B)
#define BIT_CLEAR_TIMER_TH_8814B(x) ((x) & (~BITS_TIMER_TH_8814B))
#define BIT_GET_TIMER_TH_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TIMER_TH_8814B) & BIT_MASK_TIMER_TH_8814B)
#define BIT_SET_TIMER_TH_8814B(x, v)                                           \
	(BIT_CLEAR_TIMER_TH_8814B(x) | BIT_TIMER_TH_8814B(v))

#define BIT_SHIFT_RXPKT1ENADDR_8814B 0
#define BIT_MASK_RXPKT1ENADDR_8814B 0xffff
#define BIT_RXPKT1ENADDR_8814B(x)                                              \
	(((x) & BIT_MASK_RXPKT1ENADDR_8814B) << BIT_SHIFT_RXPKT1ENADDR_8814B)
#define BITS_RXPKT1ENADDR_8814B                                                \
	(BIT_MASK_RXPKT1ENADDR_8814B << BIT_SHIFT_RXPKT1ENADDR_8814B)
#define BIT_CLEAR_RXPKT1ENADDR_8814B(x) ((x) & (~BITS_RXPKT1ENADDR_8814B))
#define BIT_GET_RXPKT1ENADDR_8814B(x)                                          \
	(((x) >> BIT_SHIFT_RXPKT1ENADDR_8814B) & BIT_MASK_RXPKT1ENADDR_8814B)
#define BIT_SET_RXPKT1ENADDR_8814B(x, v)                                       \
	(BIT_CLEAR_RXPKT1ENADDR_8814B(x) | BIT_RXPKT1ENADDR_8814B(v))

/* 2 REG_RXFF_PTR_V1_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_RXFF0_RDPTR_V2_8814B 0
#define BIT_MASK_RXFF0_RDPTR_V2_8814B 0x3ffff
#define BIT_RXFF0_RDPTR_V2_8814B(x)                                            \
	(((x) & BIT_MASK_RXFF0_RDPTR_V2_8814B)                                 \
	 << BIT_SHIFT_RXFF0_RDPTR_V2_8814B)
#define BITS_RXFF0_RDPTR_V2_8814B                                              \
	(BIT_MASK_RXFF0_RDPTR_V2_8814B << BIT_SHIFT_RXFF0_RDPTR_V2_8814B)
#define BIT_CLEAR_RXFF0_RDPTR_V2_8814B(x) ((x) & (~BITS_RXFF0_RDPTR_V2_8814B))
#define BIT_GET_RXFF0_RDPTR_V2_8814B(x)                                        \
	(((x) >> BIT_SHIFT_RXFF0_RDPTR_V2_8814B) &                             \
	 BIT_MASK_RXFF0_RDPTR_V2_8814B)
#define BIT_SET_RXFF0_RDPTR_V2_8814B(x, v)                                     \
	(BIT_CLEAR_RXFF0_RDPTR_V2_8814B(x) | BIT_RXFF0_RDPTR_V2_8814B(v))

/* 2 REG_RXFF_WTR_V1_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_RXFF0_WTPTR_V2_8814B 0
#define BIT_MASK_RXFF0_WTPTR_V2_8814B 0x3ffff
#define BIT_RXFF0_WTPTR_V2_8814B(x)                                            \
	(((x) & BIT_MASK_RXFF0_WTPTR_V2_8814B)                                 \
	 << BIT_SHIFT_RXFF0_WTPTR_V2_8814B)
#define BITS_RXFF0_WTPTR_V2_8814B                                              \
	(BIT_MASK_RXFF0_WTPTR_V2_8814B << BIT_SHIFT_RXFF0_WTPTR_V2_8814B)
#define BIT_CLEAR_RXFF0_WTPTR_V2_8814B(x) ((x) & (~BITS_RXFF0_WTPTR_V2_8814B))
#define BIT_GET_RXFF0_WTPTR_V2_8814B(x)                                        \
	(((x) >> BIT_SHIFT_RXFF0_WTPTR_V2_8814B) &                             \
	 BIT_MASK_RXFF0_WTPTR_V2_8814B)
#define BIT_SET_RXFF0_WTPTR_V2_8814B(x, v)                                     \
	(BIT_CLEAR_RXFF0_WTPTR_V2_8814B(x) | BIT_RXFF0_WTPTR_V2_8814B(v))

/* 2 REG_FE2IMR_8814B */
#define BIT__FE4ISR__IND_MSK_8814B BIT(29)
#define BIT_FS_TXSC_DESC_DONE_INT_EN_8814B BIT(28)
#define BIT_FS_TXSC_BKDONE_INT_EN_8814B BIT(27)
#define BIT_FS_TXSC_BEDONE_INT_EN_8814B BIT(26)
#define BIT_FS_TXSC_VIDONE_INT_EN_8814B BIT(25)
#define BIT_FS_TXSC_VODONE_INT_EN_8814B BIT(24)
#define BIT_FS_ATIM_MB7_INT_EN_8814B BIT(23)
#define BIT_FS_ATIM_MB6_INT_EN_8814B BIT(22)
#define BIT_FS_ATIM_MB5_INT_EN_8814B BIT(21)
#define BIT_FS_ATIM_MB4_INT_EN_8814B BIT(20)
#define BIT_FS_ATIM_MB3_INT_EN_8814B BIT(19)
#define BIT_FS_ATIM_MB2_INT_EN_8814B BIT(18)
#define BIT_FS_ATIM_MB1_INT_EN_8814B BIT(17)
#define BIT_FS_ATIM_MB0_INT_EN_8814B BIT(16)
#define BIT_FS_TBTT4INT_EN_8814B BIT(11)
#define BIT_FS_TBTT3INT_EN_8814B BIT(10)
#define BIT_FS_TBTT2INT_EN_8814B BIT(9)
#define BIT_FS_TBTT1INT_EN_8814B BIT(8)
#define BIT_FS_TBTT0_MB7INT_EN_8814B BIT(7)
#define BIT_FS_TBTT0_MB6INT_EN_8814B BIT(6)
#define BIT_FS_TBTT0_MB5INT_EN_8814B BIT(5)
#define BIT_FS_TBTT0_MB4INT_EN_8814B BIT(4)
#define BIT_FS_TBTT0_MB3INT_EN_8814B BIT(3)
#define BIT_FS_TBTT0_MB2INT_EN_8814B BIT(2)
#define BIT_FS_TBTT0_MB1INT_EN_8814B BIT(1)
#define BIT_FS_TBTT0_INT_EN_8814B BIT(0)

/* 2 REG_FE2ISR_8814B */
#define BIT__FE4ISR__IND_INT_8814B BIT(29)
#define BIT_FS_TXSC_DESC_DONE_INT_8814B BIT(28)
#define BIT_FS_TXSC_BKDONE_INT_8814B BIT(27)
#define BIT_FS_TXSC_BEDONE_INT_8814B BIT(26)
#define BIT_FS_TXSC_VIDONE_INT_8814B BIT(25)
#define BIT_FS_TXSC_VODONE_INT_8814B BIT(24)
#define BIT_FS_ATIM_MB7_INT_8814B BIT(23)
#define BIT_FS_ATIM_MB6_INT_8814B BIT(22)
#define BIT_FS_ATIM_MB5_INT_8814B BIT(21)
#define BIT_FS_ATIM_MB4_INT_8814B BIT(20)
#define BIT_FS_ATIM_MB3_INT_8814B BIT(19)
#define BIT_FS_ATIM_MB2_INT_8814B BIT(18)
#define BIT_FS_ATIM_MB1_INT_8814B BIT(17)
#define BIT_FS_ATIM_MB0_INT_8814B BIT(16)
#define BIT_FS_TBTT4INT_8814B BIT(11)
#define BIT_FS_TBTT3INT_8814B BIT(10)
#define BIT_FS_TBTT2INT_8814B BIT(9)
#define BIT_FS_TBTT1INT_8814B BIT(8)
#define BIT_FS_TBTT0_MB7INT_8814B BIT(7)
#define BIT_FS_TBTT0_MB6INT_8814B BIT(6)
#define BIT_FS_TBTT0_MB5INT_8814B BIT(5)
#define BIT_FS_TBTT0_MB4INT_8814B BIT(4)
#define BIT_FS_TBTT0_MB3INT_8814B BIT(3)
#define BIT_FS_TBTT0_MB2INT_8814B BIT(2)
#define BIT_FS_TBTT0_MB1INT_8814B BIT(1)
#define BIT_FS_TBTT0_INT_8814B BIT(0)

/* 2 REG_FE3IMR_8814B */
#define BIT_FS_CLI3_MTI_BCNIVLEAR_INT__EN_8814B BIT(31)
#define BIT_FS_CLI2_MTI_BCNIVLEAR_INT__EN_8814B BIT(30)
#define BIT_FS_CLI1_MTI_BCNIVLEAR_INT__EN_8814B BIT(29)
#define BIT_FS_CLI0_MTI_BCNIVLEAR_INT__EN_8814B BIT(28)
#define BIT_FS_BCNDMA4_INT_EN_8814B BIT(27)
#define BIT_FS_BCNDMA3_INT_EN_8814B BIT(26)
#define BIT_FS_BCNDMA2_INT_EN_8814B BIT(25)
#define BIT_FS_BCNDMA1_INT_EN_8814B BIT(24)
#define BIT_FS_BCNDMA0_MB7_INT_EN_8814B BIT(23)
#define BIT_FS_BCNDMA0_MB6_INT_EN_8814B BIT(22)
#define BIT_FS_BCNDMA0_MB5_INT_EN_8814B BIT(21)
#define BIT_FS_BCNDMA0_MB4_INT_EN_8814B BIT(20)
#define BIT_FS_BCNDMA0_MB3_INT_EN_8814B BIT(19)
#define BIT_FS_BCNDMA0_MB2_INT_EN_8814B BIT(18)
#define BIT_FS_BCNDMA0_MB1_INT_EN_8814B BIT(17)
#define BIT_FS_BCNDMA0_INT_EN_8814B BIT(16)
#define BIT_FS_MTI_BCNIVLEAR_INT__EN_8814B BIT(15)
#define BIT_FS_BCNERLY4_INT_EN_8814B BIT(11)
#define BIT_FS_BCNERLY3_INT_EN_8814B BIT(10)
#define BIT_FS_BCNERLY2_INT_EN_8814B BIT(9)
#define BIT_FS_BCNERLY1_INT_EN_8814B BIT(8)
#define BIT_FS_BCNERLY0_MB7INT_EN_8814B BIT(7)
#define BIT_FS_BCNERLY0_MB6INT_EN_8814B BIT(6)
#define BIT_FS_BCNERLY0_MB5INT_EN_8814B BIT(5)
#define BIT_FS_BCNERLY0_MB4INT_EN_8814B BIT(4)
#define BIT_FS_BCNERLY0_MB3INT_EN_8814B BIT(3)
#define BIT_FS_BCNERLY0_MB2INT_EN_8814B BIT(2)
#define BIT_FS_BCNERLY0_MB1INT_EN_8814B BIT(1)
#define BIT_FS_BCNERLY0_INT_EN_8814B BIT(0)

/* 2 REG_FE3ISR_8814B */
#define BIT_FS_CLI3_MTI_BCNIVLEAR_INT_8814B BIT(31)
#define BIT_FS_CLI2_MTI_BCNIVLEAR_INT_8814B BIT(30)
#define BIT_FS_CLI1_MTI_BCNIVLEAR_INT_8814B BIT(29)
#define BIT_FS_CLI0_MTI_BCNIVLEAR_INT_8814B BIT(28)
#define BIT_FS_BCNDMA4_INT_8814B BIT(27)
#define BIT_FS_BCNDMA3_INT_8814B BIT(26)
#define BIT_FS_BCNDMA2_INT_8814B BIT(25)
#define BIT_FS_BCNDMA1_INT_8814B BIT(24)
#define BIT_FS_BCNDMA0_MB7_INT_8814B BIT(23)
#define BIT_FS_BCNDMA0_MB6_INT_8814B BIT(22)
#define BIT_FS_BCNDMA0_MB5_INT_8814B BIT(21)
#define BIT_FS_BCNDMA0_MB4_INT_8814B BIT(20)
#define BIT_FS_BCNDMA0_MB3_INT_8814B BIT(19)
#define BIT_FS_BCNDMA0_MB2_INT_8814B BIT(18)
#define BIT_FS_BCNDMA0_MB1_INT_8814B BIT(17)
#define BIT_FS_BCNDMA0_INT_8814B BIT(16)
#define BIT_FS_MTI_BCNIVLEAR_INT_8814B BIT(15)
#define BIT_FS_BCNERLY4_INT_8814B BIT(11)
#define BIT_FS_BCNERLY3_INT_8814B BIT(10)
#define BIT_FS_BCNERLY2_INT_8814B BIT(9)
#define BIT_FS_BCNERLY1_INT_8814B BIT(8)
#define BIT_FS_BCNERLY0_MB7INT_8814B BIT(7)
#define BIT_FS_BCNERLY0_MB6INT_8814B BIT(6)
#define BIT_FS_BCNERLY0_MB5INT_8814B BIT(5)
#define BIT_FS_BCNERLY0_MB4INT_8814B BIT(4)
#define BIT_FS_BCNERLY0_MB3INT_8814B BIT(3)
#define BIT_FS_BCNERLY0_MB2INT_8814B BIT(2)
#define BIT_FS_BCNERLY0_MB1INT_8814B BIT(1)
#define BIT_FS_BCNERLY0_INT_8814B BIT(0)

/* 2 REG_FE4IMR_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_FS_CLI3_TXPKTIN_INT_EN_8814B BIT(19)
#define BIT_FS_CLI2_TXPKTIN_INT_EN_8814B BIT(18)
#define BIT_FS_CLI1_TXPKTIN_INT_EN_8814B BIT(17)
#define BIT_FS_CLI0_TXPKTIN_INT_EN_8814B BIT(16)
#define BIT_FS_CLI3_RX_UMD0_INT_EN_8814B BIT(15)
#define BIT_FS_CLI3_RX_UMD1_INT_EN_8814B BIT(14)
#define BIT_FS_CLI3_RX_BMD0_INT_EN_8814B BIT(13)
#define BIT_FS_CLI3_RX_BMD1_INT_EN_8814B BIT(12)
#define BIT_FS_CLI2_RX_UMD0_INT_EN_8814B BIT(11)
#define BIT_FS_CLI2_RX_UMD1_INT_EN_8814B BIT(10)
#define BIT_FS_CLI2_RX_BMD0_INT_EN_8814B BIT(9)
#define BIT_FS_CLI2_RX_BMD1_INT_EN_8814B BIT(8)
#define BIT_FS_CLI1_RX_UMD0_INT_EN_8814B BIT(7)
#define BIT_FS_CLI1_RX_UMD1_INT_EN_8814B BIT(6)
#define BIT_FS_CLI1_RX_BMD0_INT_EN_8814B BIT(5)
#define BIT_FS_CLI1_RX_BMD1_INT_EN_8814B BIT(4)
#define BIT_FS_CLI0_RX_UMD0_INT_EN_8814B BIT(3)
#define BIT_FS_CLI0_RX_UMD1_INT_EN_8814B BIT(2)
#define BIT_FS_CLI0_RX_BMD0_INT_EN_8814B BIT(1)
#define BIT_FS_CLI0_RX_BMD1_INT_EN_8814B BIT(0)

/* 2 REG_FE4ISR_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_P2P_PWROFF_NOA2_ERLY_INT_8814B BIT(22)
#define BIT_P2P_PWROFF_NOA1_ERLY_INT_8814B BIT(21)
#define BIT_P2P_PWROFF_NOA0_ERLY_INT_8814B BIT(20)
#define BIT_FS_CLI3_TXPKTIN_INT_8814B BIT(19)
#define BIT_FS_CLI2_TXPKTIN_INT_8814B BIT(18)
#define BIT_FS_CLI1_TXPKTIN_INT_8814B BIT(17)
#define BIT_FS_CLI0_TXPKTIN_INT_8814B BIT(16)
#define BIT_FS_CLI3_RX_UMD0_INT_8814B BIT(15)
#define BIT_FS_CLI3_RX_UMD1_INT_8814B BIT(14)
#define BIT_FS_CLI3_RX_BMD0_INT_8814B BIT(13)
#define BIT_FS_CLI3_RX_BMD1_INT_8814B BIT(12)
#define BIT_FS_CLI2_RX_UMD0_INT_8814B BIT(11)
#define BIT_FS_CLI2_RX_UMD1_INT_8814B BIT(10)
#define BIT_FS_CLI2_RX_BMD0_INT_8814B BIT(9)
#define BIT_FS_CLI2_RX_BMD1_INT_8814B BIT(8)
#define BIT_FS_CLI1_RX_UMD0_INT_8814B BIT(7)
#define BIT_FS_CLI1_RX_UMD1_INT_8814B BIT(6)
#define BIT_FS_CLI1_RX_BMD0_INT_8814B BIT(5)
#define BIT_FS_CLI1_RX_BMD1_INT_8814B BIT(4)
#define BIT_FS_CLI0_RX_UMD0_INT_8814B BIT(3)
#define BIT_FS_CLI0_RX_UMD1_INT_8814B BIT(2)
#define BIT_FS_CLI0_RX_BMD0_INT_8814B BIT(1)
#define BIT_FS_CLI0_RX_BMD1_INT_8814B BIT(0)

/* 2 REG_FT1IMR_8814B */
#define BIT__FT2ISR__IND_MSK_8814B BIT(30)
#define BIT_FTM_PTT_INT_EN_8814B BIT(29)
#define BIT_RXFTMREQ_INT_EN_8814B BIT(28)
#define BIT_RXFTM_INT_EN_8814B BIT(27)
#define BIT_TXFTM_INT_EN_8814B BIT(26)
#define BIT_FS_H2C_CMD_OK_INT_EN_8814B BIT(25)
#define BIT_FS_H2C_CMD_FULL_INT_EN_8814B BIT(24)
#define BIT_FS_MACID_SEARCH_FAIL_INT_EN_8814B BIT(22)
#define BIT_FS_MACID_PWRCHANGE3_INT_EN_8814B BIT(21)
#define BIT_FS_MACID_PWRCHANGE2_INT_EN_8814B BIT(20)
#define BIT_FS_MACID_PWRCHANGE1_INT_EN_8814B BIT(19)
#define BIT_FS_MACID_PWRCHANGE0_INT_EN_8814B BIT(18)
#define BIT_FS_CTWEND2_INT_EN_8814B BIT(17)
#define BIT_FS_CTWEND1_INT_EN_8814B BIT(16)
#define BIT_FS_CTWEND0_INT_EN_8814B BIT(15)
#define BIT_FS_TX_NULL1_INT_EN_8814B BIT(14)
#define BIT_FS_TX_NULL0_INT_EN_8814B BIT(13)
#define BIT_FS_TSF_BIT32_TOGGLE_EN_8814B BIT(12)
#define BIT_FS_P2P_RFON2_INT_EN_8814B BIT(11)
#define BIT_FS_P2P_RFOFF2_INT_EN_8814B BIT(10)
#define BIT_FS_P2P_RFON1_INT_EN_8814B BIT(9)
#define BIT_FS_P2P_RFOFF1_INT_EN_8814B BIT(8)
#define BIT_FS_P2P_RFON0_INT_EN_8814B BIT(7)
#define BIT_FS_P2P_RFOFF0_INT_EN_8814B BIT(6)
#define BIT_FS_RX_UAPSDMD1_EN_8814B BIT(5)
#define BIT_FS_RX_UAPSDMD0_EN_8814B BIT(4)
#define BIT_FS_TRIGGER_PKT_EN_8814B BIT(3)
#define BIT_FS_EOSP_INT_EN_8814B BIT(2)
#define BIT_FS_RPWM2_INT_EN_8814B BIT(1)
#define BIT_FS_RPWM_INT_EN_8814B BIT(0)

/* 2 REG_FT1ISR_8814B */
#define BIT__FT2ISR__IND_INT_8814B BIT(30)
#define BIT_FTM_PTT_INT_8814B BIT(29)
#define BIT_RXFTMREQ_INT_8814B BIT(28)
#define BIT_RXFTM_INT_8814B BIT(27)
#define BIT_TXFTM_INT_8814B BIT(26)
#define BIT_FS_H2C_CMD_OK_INT_8814B BIT(25)
#define BIT_FS_H2C_CMD_FULL_INT_8814B BIT(24)
#define BIT_FS_MACID_SEARCH_FAIL_INT_8814B BIT(22)
#define BIT_FS_MACID_PWRCHANGE3_INT_8814B BIT(21)
#define BIT_FS_MACID_PWRCHANGE2_INT_8814B BIT(20)
#define BIT_FS_MACID_PWRCHANGE1_INT_8814B BIT(19)
#define BIT_FS_MACID_PWRCHANGE0_INT_8814B BIT(18)
#define BIT_FS_CTWEND2_INT_8814B BIT(17)
#define BIT_FS_CTWEND1_INT_8814B BIT(16)
#define BIT_FS_CTWEND0_INT_8814B BIT(15)
#define BIT_FS_TX_NULL1_INT_8814B BIT(14)
#define BIT_FS_TX_NULL0_INT_8814B BIT(13)
#define BIT_FS_TSF_BIT32_TOGGLE_INT_8814B BIT(12)
#define BIT_FS_P2P_RFON2_INT_8814B BIT(11)
#define BIT_FS_P2P_RFOFF2_INT_8814B BIT(10)
#define BIT_FS_P2P_RFON1_INT_8814B BIT(9)
#define BIT_FS_P2P_RFOFF1_INT_8814B BIT(8)
#define BIT_FS_P2P_RFON0_INT_8814B BIT(7)
#define BIT_FS_P2P_RFOFF0_INT_8814B BIT(6)
#define BIT_FS_RX_UAPSDMD1_INT_8814B BIT(5)
#define BIT_FS_RX_UAPSDMD0_INT_8814B BIT(4)
#define BIT_FS_TRIGGER_PKT_INT_8814B BIT(3)
#define BIT_FS_EOSP_INT_8814B BIT(2)
#define BIT_FS_RPWM2_INT_8814B BIT(1)
#define BIT_FS_RPWM_INT_8814B BIT(0)

/* 2 REG_SPWR0_8814B */

#define BIT_SHIFT_MID_31TO0_8814B 0
#define BIT_MASK_MID_31TO0_8814B 0xffffffffL
#define BIT_MID_31TO0_8814B(x)                                                 \
	(((x) & BIT_MASK_MID_31TO0_8814B) << BIT_SHIFT_MID_31TO0_8814B)
#define BITS_MID_31TO0_8814B                                                   \
	(BIT_MASK_MID_31TO0_8814B << BIT_SHIFT_MID_31TO0_8814B)
#define BIT_CLEAR_MID_31TO0_8814B(x) ((x) & (~BITS_MID_31TO0_8814B))
#define BIT_GET_MID_31TO0_8814B(x)                                             \
	(((x) >> BIT_SHIFT_MID_31TO0_8814B) & BIT_MASK_MID_31TO0_8814B)
#define BIT_SET_MID_31TO0_8814B(x, v)                                          \
	(BIT_CLEAR_MID_31TO0_8814B(x) | BIT_MID_31TO0_8814B(v))

/* 2 REG_SPWR1_8814B */

#define BIT_SHIFT_MID_63TO32_8814B 0
#define BIT_MASK_MID_63TO32_8814B 0xffffffffL
#define BIT_MID_63TO32_8814B(x)                                                \
	(((x) & BIT_MASK_MID_63TO32_8814B) << BIT_SHIFT_MID_63TO32_8814B)
#define BITS_MID_63TO32_8814B                                                  \
	(BIT_MASK_MID_63TO32_8814B << BIT_SHIFT_MID_63TO32_8814B)
#define BIT_CLEAR_MID_63TO32_8814B(x) ((x) & (~BITS_MID_63TO32_8814B))
#define BIT_GET_MID_63TO32_8814B(x)                                            \
	(((x) >> BIT_SHIFT_MID_63TO32_8814B) & BIT_MASK_MID_63TO32_8814B)
#define BIT_SET_MID_63TO32_8814B(x, v)                                         \
	(BIT_CLEAR_MID_63TO32_8814B(x) | BIT_MID_63TO32_8814B(v))

/* 2 REG_SPWR2_8814B */

#define BIT_SHIFT_MID_95O64_8814B 0
#define BIT_MASK_MID_95O64_8814B 0xffffffffL
#define BIT_MID_95O64_8814B(x)                                                 \
	(((x) & BIT_MASK_MID_95O64_8814B) << BIT_SHIFT_MID_95O64_8814B)
#define BITS_MID_95O64_8814B                                                   \
	(BIT_MASK_MID_95O64_8814B << BIT_SHIFT_MID_95O64_8814B)
#define BIT_CLEAR_MID_95O64_8814B(x) ((x) & (~BITS_MID_95O64_8814B))
#define BIT_GET_MID_95O64_8814B(x)                                             \
	(((x) >> BIT_SHIFT_MID_95O64_8814B) & BIT_MASK_MID_95O64_8814B)
#define BIT_SET_MID_95O64_8814B(x, v)                                          \
	(BIT_CLEAR_MID_95O64_8814B(x) | BIT_MID_95O64_8814B(v))

/* 2 REG_SPWR3_8814B */

#define BIT_SHIFT_MID_127TO96_8814B 0
#define BIT_MASK_MID_127TO96_8814B 0xffffffffL
#define BIT_MID_127TO96_8814B(x)                                               \
	(((x) & BIT_MASK_MID_127TO96_8814B) << BIT_SHIFT_MID_127TO96_8814B)
#define BITS_MID_127TO96_8814B                                                 \
	(BIT_MASK_MID_127TO96_8814B << BIT_SHIFT_MID_127TO96_8814B)
#define BIT_CLEAR_MID_127TO96_8814B(x) ((x) & (~BITS_MID_127TO96_8814B))
#define BIT_GET_MID_127TO96_8814B(x)                                           \
	(((x) >> BIT_SHIFT_MID_127TO96_8814B) & BIT_MASK_MID_127TO96_8814B)
#define BIT_SET_MID_127TO96_8814B(x, v)                                        \
	(BIT_CLEAR_MID_127TO96_8814B(x) | BIT_MID_127TO96_8814B(v))

/* 2 REG_POWSEQ_8814B */

#define BIT_SHIFT_SEQNUM_MID_8814B 16
#define BIT_MASK_SEQNUM_MID_8814B 0xffff
#define BIT_SEQNUM_MID_8814B(x)                                                \
	(((x) & BIT_MASK_SEQNUM_MID_8814B) << BIT_SHIFT_SEQNUM_MID_8814B)
#define BITS_SEQNUM_MID_8814B                                                  \
	(BIT_MASK_SEQNUM_MID_8814B << BIT_SHIFT_SEQNUM_MID_8814B)
#define BIT_CLEAR_SEQNUM_MID_8814B(x) ((x) & (~BITS_SEQNUM_MID_8814B))
#define BIT_GET_SEQNUM_MID_8814B(x)                                            \
	(((x) >> BIT_SHIFT_SEQNUM_MID_8814B) & BIT_MASK_SEQNUM_MID_8814B)
#define BIT_SET_SEQNUM_MID_8814B(x, v)                                         \
	(BIT_CLEAR_SEQNUM_MID_8814B(x) | BIT_SEQNUM_MID_8814B(v))

#define BIT_SHIFT_REF_MID_8814B 0
#define BIT_MASK_REF_MID_8814B 0x7f
#define BIT_REF_MID_8814B(x)                                                   \
	(((x) & BIT_MASK_REF_MID_8814B) << BIT_SHIFT_REF_MID_8814B)
#define BITS_REF_MID_8814B (BIT_MASK_REF_MID_8814B << BIT_SHIFT_REF_MID_8814B)
#define BIT_CLEAR_REF_MID_8814B(x) ((x) & (~BITS_REF_MID_8814B))
#define BIT_GET_REF_MID_8814B(x)                                               \
	(((x) >> BIT_SHIFT_REF_MID_8814B) & BIT_MASK_REF_MID_8814B)
#define BIT_SET_REF_MID_8814B(x, v)                                            \
	(BIT_CLEAR_REF_MID_8814B(x) | BIT_REF_MID_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_TC7_CTRL_V1_8814B */
#define BIT_TC7INT_EN_8814B BIT(26)
#define BIT_TC7MODE_8814B BIT(25)
#define BIT_TC7EN_8814B BIT(24)

#define BIT_SHIFT_TC7DATA_8814B 0
#define BIT_MASK_TC7DATA_8814B 0xffffff
#define BIT_TC7DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC7DATA_8814B) << BIT_SHIFT_TC7DATA_8814B)
#define BITS_TC7DATA_8814B (BIT_MASK_TC7DATA_8814B << BIT_SHIFT_TC7DATA_8814B)
#define BIT_CLEAR_TC7DATA_8814B(x) ((x) & (~BITS_TC7DATA_8814B))
#define BIT_GET_TC7DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC7DATA_8814B) & BIT_MASK_TC7DATA_8814B)
#define BIT_SET_TC7DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC7DATA_8814B(x) | BIT_TC7DATA_8814B(v))

/* 2 REG_TC8_CTRL_V1_8814B */
#define BIT_TC8INT_EN_8814B BIT(26)
#define BIT_TC8MODE_8814B BIT(25)
#define BIT_TC8EN_8814B BIT(24)

#define BIT_SHIFT_TC8DATA_8814B 0
#define BIT_MASK_TC8DATA_8814B 0xffffff
#define BIT_TC8DATA_8814B(x)                                                   \
	(((x) & BIT_MASK_TC8DATA_8814B) << BIT_SHIFT_TC8DATA_8814B)
#define BITS_TC8DATA_8814B (BIT_MASK_TC8DATA_8814B << BIT_SHIFT_TC8DATA_8814B)
#define BIT_CLEAR_TC8DATA_8814B(x) ((x) & (~BITS_TC8DATA_8814B))
#define BIT_GET_TC8DATA_8814B(x)                                               \
	(((x) >> BIT_SHIFT_TC8DATA_8814B) & BIT_MASK_TC8DATA_8814B)
#define BIT_SET_TC8DATA_8814B(x, v)                                            \
	(BIT_CLEAR_TC8DATA_8814B(x) | BIT_TC8DATA_8814B(v))

/* 2 REG_RX_BCN_TBTT_ITVL0_8814B */

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8814B 24
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8814B 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT2_8814B(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8814B)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8814B)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT2_8814B                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8814B                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8814B)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT2_8814B(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT2_8814B))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT2_8814B(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT2_8814B) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT2_8814B)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT2_8814B(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT2_8814B(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT2_8814B(v))

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8814B 16
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8814B 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT1_8814B(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8814B)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8814B)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT1_8814B                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8814B                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8814B)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT1_8814B(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT1_8814B))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT1_8814B(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT1_8814B) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT1_8814B)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT1_8814B(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT1_8814B(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT1_8814B(v))

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8814B 8
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8814B 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT0_8814B(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8814B)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8814B)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT0_8814B                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8814B                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8814B)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT0_8814B(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT0_8814B))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT0_8814B(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT0_8814B) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT0_8814B)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT0_8814B(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT0_8814B(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT0_8814B(v))

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8814B 0
#define BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8814B 0xff
#define BIT_RX_BCN_TBTT_ITVL_PORT0_8814B(x)                                    \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8814B)                         \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8814B)
#define BITS_RX_BCN_TBTT_ITVL_PORT0_8814B                                      \
	(BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8814B                                 \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8814B)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_PORT0_8814B(x)                              \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_PORT0_8814B))
#define BIT_GET_RX_BCN_TBTT_ITVL_PORT0_8814B(x)                                \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_PORT0_8814B) &                     \
	 BIT_MASK_RX_BCN_TBTT_ITVL_PORT0_8814B)
#define BIT_SET_RX_BCN_TBTT_ITVL_PORT0_8814B(x, v)                             \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_PORT0_8814B(x) |                           \
	 BIT_RX_BCN_TBTT_ITVL_PORT0_8814B(v))

/* 2 REG_RX_BCN_TBTT_ITVL1_8814B */

#define BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8814B 0
#define BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8814B 0xff
#define BIT_RX_BCN_TBTT_ITVL_CLIENT3_8814B(x)                                  \
	(((x) & BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8814B)                       \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8814B)
#define BITS_RX_BCN_TBTT_ITVL_CLIENT3_8814B                                    \
	(BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8814B                               \
	 << BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8814B)
#define BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT3_8814B(x)                            \
	((x) & (~BITS_RX_BCN_TBTT_ITVL_CLIENT3_8814B))
#define BIT_GET_RX_BCN_TBTT_ITVL_CLIENT3_8814B(x)                              \
	(((x) >> BIT_SHIFT_RX_BCN_TBTT_ITVL_CLIENT3_8814B) &                   \
	 BIT_MASK_RX_BCN_TBTT_ITVL_CLIENT3_8814B)
#define BIT_SET_RX_BCN_TBTT_ITVL_CLIENT3_8814B(x, v)                           \
	(BIT_CLEAR_RX_BCN_TBTT_ITVL_CLIENT3_8814B(x) |                         \
	 BIT_RX_BCN_TBTT_ITVL_CLIENT3_8814B(v))

/* 2 REG_FWIMR1_8814B */
#define BIT_FS_ATIM_MB15_INT_EN_8814B BIT(31)
#define BIT_FS_ATIM_MB14_INT_EN_8814B BIT(30)
#define BIT_FS_ATIM_MB13_INT_EN_8814B BIT(29)
#define BIT_FS_ATIM_MB12_INT_EN_8814B BIT(28)
#define BIT_FS_ATIM_MB11_INT_EN_8814B BIT(27)
#define BIT_FS_ATIM_MB10_INT_EN_8814B BIT(26)
#define BIT_FS_ATIM_MB9_INT_EN_8814B BIT(25)
#define BIT_FS_ATIM_MB8_INT_EN_8814B BIT(24)
#define BIT_FS_TXBCNERR_MB15_INT_EN_8814B BIT(23)
#define BIT_FS_TXBCNERR_MB14_INT_EN_8814B BIT(22)
#define BIT_FS_TXBCNERR_MB13_INT_EN_8814B BIT(21)
#define BIT_FS_TXBCNERR_MB12_INT_EN_8814B BIT(20)
#define BIT_FS_TXBCNERR_MB11_INT_EN_8814B BIT(19)
#define BIT_FS_TXBCNERR_MB10_INT_EN_8814B BIT(18)
#define BIT_FS_TXBCNERR_MB9_INT_EN_8814B BIT(17)
#define BIT_FS_TXBCNERR_MB8_INT_EN_8814B BIT(16)
#define BIT_FS_TXBCNOK_MB15_INT_EN_8814B BIT(15)
#define BIT_FS_TXBCNOK_MB14_INT_EN_8814B BIT(14)
#define BIT_FS_TXBCNOK_MB13_INT_EN_8814B BIT(13)
#define BIT_FS_TXBCNOK_MB12_INT_EN_8814B BIT(12)
#define BIT_FS_TXBCNOK_MB11_INT_EN_8814B BIT(11)
#define BIT_FS_TXBCNOK_MB10_INT_EN_8814B BIT(10)
#define BIT_FS_TXBCNOK_MB9_INT_EN_8814B BIT(9)
#define BIT_FS_TXBCNOK_MB8_INT_EN_8814B BIT(8)
#define BIT_FS_BCNERLY0_MB15INT_EN_8814B BIT(7)
#define BIT_FS_BCNERLY0_MB14INT_EN_8814B BIT(6)
#define BIT_FS_BCNERLY0_MB13INT_EN_8814B BIT(5)
#define BIT_FS_BCNERLY0_MB12INT_EN_8814B BIT(4)
#define BIT_FS_BCNERLY0_MB11INT_EN_8814B BIT(3)
#define BIT_FS_BCNERLY0_MB10INT_EN_8814B BIT(2)
#define BIT_FS_BCNERLY0_MB9INT_EN_8814B BIT(1)
#define BIT_FS_BCNERLY0_MB8INT_EN_8814B BIT(0)

/* 2 REG_FWISR1_8814B */
#define BIT_FS_ATIM_MB15_INT_8814B BIT(31)
#define BIT_FS_ATIM_MB14_INT_8814B BIT(30)
#define BIT_FS_ATIM_MB13_INT_8814B BIT(29)
#define BIT_FS_ATIM_MB12_INT_8814B BIT(28)
#define BIT_FS_ATIM_MB11_INT_8814B BIT(27)
#define BIT_FS_ATIM_MB10_INT_8814B BIT(26)
#define BIT_FS_ATIM_MB9_INT_8814B BIT(25)
#define BIT_FS_ATIM_MB8_INT_8814B BIT(24)
#define BIT_FS_TXBCNERR_MB15_INT_8814B BIT(23)
#define BIT_FS_TXBCNERR_MB14_INT_8814B BIT(22)
#define BIT_FS_TXBCNERR_MB13_INT_8814B BIT(21)
#define BIT_FS_TXBCNERR_MB12_INT_8814B BIT(20)
#define BIT_FS_TXBCNERR_MB11_INT_8814B BIT(19)
#define BIT_FS_TXBCNERR_MB10_INT_8814B BIT(18)
#define BIT_FS_TXBCNERR_MB9_INT_8814B BIT(17)
#define BIT_FS_TXBCNERR_MB8_INT_8814B BIT(16)
#define BIT_FS_TXBCNOK_MB15_INT_8814B BIT(15)
#define BIT_FS_TXBCNOK_MB14_INT_8814B BIT(14)
#define BIT_FS_TXBCNOK_MB13_INT_8814B BIT(13)
#define BIT_FS_TXBCNOK_MB12_INT_8814B BIT(12)
#define BIT_FS_TXBCNOK_MB11_INT_8814B BIT(11)
#define BIT_FS_TXBCNOK_MB10_INT_8814B BIT(10)
#define BIT_FS_TXBCNOK_MB9_INT_8814B BIT(9)
#define BIT_FS_TXBCNOK_MB8_INT_8814B BIT(8)
#define BIT_FS_BCNERLY0_MB15INT_8814B BIT(7)
#define BIT_FS_BCNERLY0_MB14INT_8814B BIT(6)
#define BIT_FS_BCNERLY0_MB13INT_8814B BIT(5)
#define BIT_FS_BCNERLY0_MB12INT_8814B BIT(4)
#define BIT_FS_BCNERLY0_MB11INT_8814B BIT(3)
#define BIT_FS_BCNERLY0_MB10INT_8814B BIT(2)
#define BIT_FS_BCNERLY0_MB9INT_8814B BIT(1)
#define BIT_FS_BCNERLY0_MB8INT_8814B BIT(0)

/* 2 REG_FWIMR2_8814B */
#define BIT_FS_BCNDMA0_MB15_INT_EN_8814B BIT(15)
#define BIT_FS_BCNDMA0_MB14_INT_EN_8814B BIT(14)
#define BIT_FS_BCNDMA0_MB13_INT_EN_8814B BIT(13)
#define BIT_FS_BCNDMA0_MB12_INT_EN_8814B BIT(12)
#define BIT_FS_BCNDMA0_MB11_INT_EN_8814B BIT(11)
#define BIT_FS_BCNDMA0_MB10_INT_EN_8814B BIT(10)
#define BIT_FS_BCNDMA0_MB9_INT_EN_8814B BIT(9)
#define BIT_FS_BCNDMA0_MB8_INT_EN_8814B BIT(8)
#define BIT_FS_TBTT0_MB15INT_EN_8814B BIT(7)
#define BIT_FS_TBTT0_MB14INT_EN_8814B BIT(6)
#define BIT_FS_TBTT0_MB13INT_EN_8814B BIT(5)
#define BIT_FS_TBTT0_MB12INT_EN_8814B BIT(4)
#define BIT_FS_TBTT0_MB11INT_EN_8814B BIT(3)
#define BIT_FS_TBTT0_MB10INT_EN_8814B BIT(2)
#define BIT_FS_TBTT0_MB9INT_EN_8814B BIT(1)
#define BIT_FS_TBTT0_MB8INT_EN_8814B BIT(0)

/* 2 REG_FWISR2_8814B */
#define BIT_FS_BCNDMA0_MB15_INT_8814B BIT(15)
#define BIT_FS_BCNDMA0_MB14_INT_8814B BIT(14)
#define BIT_FS_BCNDMA0_MB13_INT_8814B BIT(13)
#define BIT_FS_BCNDMA0_MB12_INT_8814B BIT(12)
#define BIT_FS_BCNDMA0_MB11_INT_8814B BIT(11)
#define BIT_FS_BCNDMA0_MB10_INT_8814B BIT(10)
#define BIT_FS_BCNDMA0_MB9_INT_8814B BIT(9)
#define BIT_FS_BCNDMA0_MB8_INT_8814B BIT(8)
#define BIT_FS_TBTT0_MB15INT_8814B BIT(7)
#define BIT_FS_TBTT0_MB14INT_8814B BIT(6)
#define BIT_FS_TBTT0_MB13INT_8814B BIT(5)
#define BIT_FS_TBTT0_MB12INT_8814B BIT(4)
#define BIT_FS_TBTT0_MB11INT_8814B BIT(3)
#define BIT_FS_TBTT0_MB10INT_8814B BIT(2)
#define BIT_FS_TBTT0_MB9INT_8814B BIT(1)
#define BIT_FS_TBTT0_MB8INT_8814B BIT(0)

/* 2 REG_FWIMR3_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_FS_TXBCNOK_PORT4_INT_EN_8814B BIT(11)
#define BIT_FS_TXBCNOK_PORT3_INT_EN_8814B BIT(10)
#define BIT_FS_TXBCNOK_PORT2_INT_EN_8814B BIT(9)
#define BIT_FS_TXBCNOK_PORT1_INT_EN_8814B BIT(8)
#define BIT_FS_TXBCNERR_PORT4_INT_EN_8814B BIT(7)
#define BIT_FS_TXBCNERR_PORT3_INT_EN_8814B BIT(6)
#define BIT_FS_TXBCNERR_PORT2_INT_EN_8814B BIT(5)
#define BIT_FS_TXBCNERR_PORT1_INT_EN_8814B BIT(4)
#define BIT_FS_ATIM_PORT4_INT_EN_8814B BIT(3)
#define BIT_FS_ATIM_PORT3_INT_EN_8814B BIT(2)
#define BIT_FS_ATIM_PORT2_INT_EN_8814B BIT(1)
#define BIT_FS_ATIM_PORT1_INT_EN_8814B BIT(0)

/* 2 REG_FWISR3_8814B */
#define BIT_FS_TXBCNOK_PORT4_INT_8814B BIT(11)
#define BIT_FS_TXBCNOK_PORT3_INT_8814B BIT(10)
#define BIT_FS_TXBCNOK_PORT2_INT_8814B BIT(9)
#define BIT_FS_TXBCNOK_PORT1_INT_8814B BIT(8)
#define BIT_FS_TXBCNERR_PORT4_INT_8814B BIT(7)
#define BIT_FS_TXBCNERR_PORT3_INT_8814B BIT(6)
#define BIT_FS_TXBCNERR_PORT2_INT_8814B BIT(5)
#define BIT_FS_TXBCNERR_PORT1_INT_8814B BIT(4)
#define BIT_FS_ATIM_PORT4_INT_8814B BIT(3)
#define BIT_FS_ATIM_PORT3_INT_8814B BIT(2)
#define BIT_FS_ATIM_PORT2_INT_8814B BIT(1)
#define BIT_FS_ATIM_PORT1_INT_8814B BIT(0)

/* 2 REG_SPEED_SENSOR_8814B */
#define BIT_DSS_1_RST_N_8814B BIT(31)
#define BIT_DSS_1_SPEED_EN_8814B BIT(30)
#define BIT_DSS_1_WIRE_SEL_8814B BIT(29)
#define BIT_DSS_ENCLK_8814B BIT(28)

#define BIT_SHIFT_DSS_1_RO_SEL_8814B 24
#define BIT_MASK_DSS_1_RO_SEL_8814B 0x7
#define BIT_DSS_1_RO_SEL_8814B(x)                                              \
	(((x) & BIT_MASK_DSS_1_RO_SEL_8814B) << BIT_SHIFT_DSS_1_RO_SEL_8814B)
#define BITS_DSS_1_RO_SEL_8814B                                                \
	(BIT_MASK_DSS_1_RO_SEL_8814B << BIT_SHIFT_DSS_1_RO_SEL_8814B)
#define BIT_CLEAR_DSS_1_RO_SEL_8814B(x) ((x) & (~BITS_DSS_1_RO_SEL_8814B))
#define BIT_GET_DSS_1_RO_SEL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DSS_1_RO_SEL_8814B) & BIT_MASK_DSS_1_RO_SEL_8814B)
#define BIT_SET_DSS_1_RO_SEL_8814B(x, v)                                       \
	(BIT_CLEAR_DSS_1_RO_SEL_8814B(x) | BIT_DSS_1_RO_SEL_8814B(v))

#define BIT_SHIFT_DSS_1_DATA_IN_8814B 0
#define BIT_MASK_DSS_1_DATA_IN_8814B 0xfffff
#define BIT_DSS_1_DATA_IN_8814B(x)                                             \
	(((x) & BIT_MASK_DSS_1_DATA_IN_8814B) << BIT_SHIFT_DSS_1_DATA_IN_8814B)
#define BITS_DSS_1_DATA_IN_8814B                                               \
	(BIT_MASK_DSS_1_DATA_IN_8814B << BIT_SHIFT_DSS_1_DATA_IN_8814B)
#define BIT_CLEAR_DSS_1_DATA_IN_8814B(x) ((x) & (~BITS_DSS_1_DATA_IN_8814B))
#define BIT_GET_DSS_1_DATA_IN_8814B(x)                                         \
	(((x) >> BIT_SHIFT_DSS_1_DATA_IN_8814B) & BIT_MASK_DSS_1_DATA_IN_8814B)
#define BIT_SET_DSS_1_DATA_IN_8814B(x, v)                                      \
	(BIT_CLEAR_DSS_1_DATA_IN_8814B(x) | BIT_DSS_1_DATA_IN_8814B(v))

/* 2 REG_SPEED_SENSOR1_8814B */
#define BIT_DSS_1_READY_8814B BIT(31)
#define BIT_DSS_1_WSORT_GO_8814B BIT(30)

#define BIT_SHIFT_DSS_1_COUNT_OUT_8814B 0
#define BIT_MASK_DSS_1_COUNT_OUT_8814B 0xfffff
#define BIT_DSS_1_COUNT_OUT_8814B(x)                                           \
	(((x) & BIT_MASK_DSS_1_COUNT_OUT_8814B)                                \
	 << BIT_SHIFT_DSS_1_COUNT_OUT_8814B)
#define BITS_DSS_1_COUNT_OUT_8814B                                             \
	(BIT_MASK_DSS_1_COUNT_OUT_8814B << BIT_SHIFT_DSS_1_COUNT_OUT_8814B)
#define BIT_CLEAR_DSS_1_COUNT_OUT_8814B(x) ((x) & (~BITS_DSS_1_COUNT_OUT_8814B))
#define BIT_GET_DSS_1_COUNT_OUT_8814B(x)                                       \
	(((x) >> BIT_SHIFT_DSS_1_COUNT_OUT_8814B) &                            \
	 BIT_MASK_DSS_1_COUNT_OUT_8814B)
#define BIT_SET_DSS_1_COUNT_OUT_8814B(x, v)                                    \
	(BIT_CLEAR_DSS_1_COUNT_OUT_8814B(x) | BIT_DSS_1_COUNT_OUT_8814B(v))

/* 2 REG_SPEED_SENSOR2_8814B */
#define BIT_DSS_2_RST_N_8814B BIT(31)
#define BIT_DSS_2_SPEED_EN_8814B BIT(30)
#define BIT_DSS_2_WIRE_SEL_8814B BIT(29)
#define BIT_DSS_ENCLK_8814B BIT(28)

#define BIT_SHIFT_DSS_2_RO_SEL_8814B 24
#define BIT_MASK_DSS_2_RO_SEL_8814B 0x7
#define BIT_DSS_2_RO_SEL_8814B(x)                                              \
	(((x) & BIT_MASK_DSS_2_RO_SEL_8814B) << BIT_SHIFT_DSS_2_RO_SEL_8814B)
#define BITS_DSS_2_RO_SEL_8814B                                                \
	(BIT_MASK_DSS_2_RO_SEL_8814B << BIT_SHIFT_DSS_2_RO_SEL_8814B)
#define BIT_CLEAR_DSS_2_RO_SEL_8814B(x) ((x) & (~BITS_DSS_2_RO_SEL_8814B))
#define BIT_GET_DSS_2_RO_SEL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DSS_2_RO_SEL_8814B) & BIT_MASK_DSS_2_RO_SEL_8814B)
#define BIT_SET_DSS_2_RO_SEL_8814B(x, v)                                       \
	(BIT_CLEAR_DSS_2_RO_SEL_8814B(x) | BIT_DSS_2_RO_SEL_8814B(v))

#define BIT_SHIFT_DSS_2_DATA_IN_8814B 0
#define BIT_MASK_DSS_2_DATA_IN_8814B 0xfffff
#define BIT_DSS_2_DATA_IN_8814B(x)                                             \
	(((x) & BIT_MASK_DSS_2_DATA_IN_8814B) << BIT_SHIFT_DSS_2_DATA_IN_8814B)
#define BITS_DSS_2_DATA_IN_8814B                                               \
	(BIT_MASK_DSS_2_DATA_IN_8814B << BIT_SHIFT_DSS_2_DATA_IN_8814B)
#define BIT_CLEAR_DSS_2_DATA_IN_8814B(x) ((x) & (~BITS_DSS_2_DATA_IN_8814B))
#define BIT_GET_DSS_2_DATA_IN_8814B(x)                                         \
	(((x) >> BIT_SHIFT_DSS_2_DATA_IN_8814B) & BIT_MASK_DSS_2_DATA_IN_8814B)
#define BIT_SET_DSS_2_DATA_IN_8814B(x, v)                                      \
	(BIT_CLEAR_DSS_2_DATA_IN_8814B(x) | BIT_DSS_2_DATA_IN_8814B(v))

/* 2 REG_SPEED_SENSOR3_8814B */
#define BIT_DSS_2_READY_8814B BIT(31)
#define BIT_DSS_2_WSORT_GO_8814B BIT(30)

#define BIT_SHIFT_DSS_2_COUNT_OUT_8814B 0
#define BIT_MASK_DSS_2_COUNT_OUT_8814B 0xfffff
#define BIT_DSS_2_COUNT_OUT_8814B(x)                                           \
	(((x) & BIT_MASK_DSS_2_COUNT_OUT_8814B)                                \
	 << BIT_SHIFT_DSS_2_COUNT_OUT_8814B)
#define BITS_DSS_2_COUNT_OUT_8814B                                             \
	(BIT_MASK_DSS_2_COUNT_OUT_8814B << BIT_SHIFT_DSS_2_COUNT_OUT_8814B)
#define BIT_CLEAR_DSS_2_COUNT_OUT_8814B(x) ((x) & (~BITS_DSS_2_COUNT_OUT_8814B))
#define BIT_GET_DSS_2_COUNT_OUT_8814B(x)                                       \
	(((x) >> BIT_SHIFT_DSS_2_COUNT_OUT_8814B) &                            \
	 BIT_MASK_DSS_2_COUNT_OUT_8814B)
#define BIT_SET_DSS_2_COUNT_OUT_8814B(x, v)                                    \
	(BIT_CLEAR_DSS_2_COUNT_OUT_8814B(x) | BIT_DSS_2_COUNT_OUT_8814B(v))

/* 2 REG_SPEED_SENSOR4_8814B */
#define BIT_DSS_3_RST_N_8814B BIT(31)
#define BIT_DSS_3_SPEED_EN_8814B BIT(30)
#define BIT_DSS_3_WIRE_SEL_8814B BIT(29)
#define BIT_DSS_ENCLK_8814B BIT(28)

#define BIT_SHIFT_DSS_3_RO_SEL_8814B 24
#define BIT_MASK_DSS_3_RO_SEL_8814B 0x7
#define BIT_DSS_3_RO_SEL_8814B(x)                                              \
	(((x) & BIT_MASK_DSS_3_RO_SEL_8814B) << BIT_SHIFT_DSS_3_RO_SEL_8814B)
#define BITS_DSS_3_RO_SEL_8814B                                                \
	(BIT_MASK_DSS_3_RO_SEL_8814B << BIT_SHIFT_DSS_3_RO_SEL_8814B)
#define BIT_CLEAR_DSS_3_RO_SEL_8814B(x) ((x) & (~BITS_DSS_3_RO_SEL_8814B))
#define BIT_GET_DSS_3_RO_SEL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DSS_3_RO_SEL_8814B) & BIT_MASK_DSS_3_RO_SEL_8814B)
#define BIT_SET_DSS_3_RO_SEL_8814B(x, v)                                       \
	(BIT_CLEAR_DSS_3_RO_SEL_8814B(x) | BIT_DSS_3_RO_SEL_8814B(v))

#define BIT_SHIFT_DSS_3_DATA_IN_8814B 0
#define BIT_MASK_DSS_3_DATA_IN_8814B 0xfffff
#define BIT_DSS_3_DATA_IN_8814B(x)                                             \
	(((x) & BIT_MASK_DSS_3_DATA_IN_8814B) << BIT_SHIFT_DSS_3_DATA_IN_8814B)
#define BITS_DSS_3_DATA_IN_8814B                                               \
	(BIT_MASK_DSS_3_DATA_IN_8814B << BIT_SHIFT_DSS_3_DATA_IN_8814B)
#define BIT_CLEAR_DSS_3_DATA_IN_8814B(x) ((x) & (~BITS_DSS_3_DATA_IN_8814B))
#define BIT_GET_DSS_3_DATA_IN_8814B(x)                                         \
	(((x) >> BIT_SHIFT_DSS_3_DATA_IN_8814B) & BIT_MASK_DSS_3_DATA_IN_8814B)
#define BIT_SET_DSS_3_DATA_IN_8814B(x, v)                                      \
	(BIT_CLEAR_DSS_3_DATA_IN_8814B(x) | BIT_DSS_3_DATA_IN_8814B(v))

/* 2 REG_SPEED_SENSOR5_8814B */
#define BIT_DSS_3_READY_8814B BIT(31)
#define BIT_DSS_3_WSORT_GO_8814B BIT(30)

#define BIT_SHIFT_DSS_3_COUNT_OUT_8814B 0
#define BIT_MASK_DSS_3_COUNT_OUT_8814B 0xfffff
#define BIT_DSS_3_COUNT_OUT_8814B(x)                                           \
	(((x) & BIT_MASK_DSS_3_COUNT_OUT_8814B)                                \
	 << BIT_SHIFT_DSS_3_COUNT_OUT_8814B)
#define BITS_DSS_3_COUNT_OUT_8814B                                             \
	(BIT_MASK_DSS_3_COUNT_OUT_8814B << BIT_SHIFT_DSS_3_COUNT_OUT_8814B)
#define BIT_CLEAR_DSS_3_COUNT_OUT_8814B(x) ((x) & (~BITS_DSS_3_COUNT_OUT_8814B))
#define BIT_GET_DSS_3_COUNT_OUT_8814B(x)                                       \
	(((x) >> BIT_SHIFT_DSS_3_COUNT_OUT_8814B) &                            \
	 BIT_MASK_DSS_3_COUNT_OUT_8814B)
#define BIT_SET_DSS_3_COUNT_OUT_8814B(x, v)                                    \
	(BIT_CLEAR_DSS_3_COUNT_OUT_8814B(x) | BIT_DSS_3_COUNT_OUT_8814B(v))

/* 2 REG_RXPKTBUF_1_MAX_ADDR_8814B */

#define BIT_SHIFT_RXPKTBUF_SIZE_8814B 30
#define BIT_MASK_RXPKTBUF_SIZE_8814B 0x3
#define BIT_RXPKTBUF_SIZE_8814B(x)                                             \
	(((x) & BIT_MASK_RXPKTBUF_SIZE_8814B) << BIT_SHIFT_RXPKTBUF_SIZE_8814B)
#define BITS_RXPKTBUF_SIZE_8814B                                               \
	(BIT_MASK_RXPKTBUF_SIZE_8814B << BIT_SHIFT_RXPKTBUF_SIZE_8814B)
#define BIT_CLEAR_RXPKTBUF_SIZE_8814B(x) ((x) & (~BITS_RXPKTBUF_SIZE_8814B))
#define BIT_GET_RXPKTBUF_SIZE_8814B(x)                                         \
	(((x) >> BIT_SHIFT_RXPKTBUF_SIZE_8814B) & BIT_MASK_RXPKTBUF_SIZE_8814B)
#define BIT_SET_RXPKTBUF_SIZE_8814B(x, v)                                      \
	(BIT_CLEAR_RXPKTBUF_SIZE_8814B(x) | BIT_RXPKTBUF_SIZE_8814B(v))

#define BIT_RXPKTBUF_DBG_SEL_8814B BIT(29)

#define BIT_SHIFT_RXPKTBUF_1_MAX_ADDR_8814B 0
#define BIT_MASK_RXPKTBUF_1_MAX_ADDR_8814B 0x3ffff
#define BIT_RXPKTBUF_1_MAX_ADDR_8814B(x)                                       \
	(((x) & BIT_MASK_RXPKTBUF_1_MAX_ADDR_8814B)                            \
	 << BIT_SHIFT_RXPKTBUF_1_MAX_ADDR_8814B)
#define BITS_RXPKTBUF_1_MAX_ADDR_8814B                                         \
	(BIT_MASK_RXPKTBUF_1_MAX_ADDR_8814B                                    \
	 << BIT_SHIFT_RXPKTBUF_1_MAX_ADDR_8814B)
#define BIT_CLEAR_RXPKTBUF_1_MAX_ADDR_8814B(x)                                 \
	((x) & (~BITS_RXPKTBUF_1_MAX_ADDR_8814B))
#define BIT_GET_RXPKTBUF_1_MAX_ADDR_8814B(x)                                   \
	(((x) >> BIT_SHIFT_RXPKTBUF_1_MAX_ADDR_8814B) &                        \
	 BIT_MASK_RXPKTBUF_1_MAX_ADDR_8814B)
#define BIT_SET_RXPKTBUF_1_MAX_ADDR_8814B(x, v)                                \
	(BIT_CLEAR_RXPKTBUF_1_MAX_ADDR_8814B(x) |                              \
	 BIT_RXPKTBUF_1_MAX_ADDR_8814B(v))

/* 2 REG_RXFWBUF_1_MAX_ADDR_8814B */

#define BIT_SHIFT_RXFWBUF_1_MAX_ADDR_8814B 0
#define BIT_MASK_RXFWBUF_1_MAX_ADDR_8814B 0xffff
#define BIT_RXFWBUF_1_MAX_ADDR_8814B(x)                                        \
	(((x) & BIT_MASK_RXFWBUF_1_MAX_ADDR_8814B)                             \
	 << BIT_SHIFT_RXFWBUF_1_MAX_ADDR_8814B)
#define BITS_RXFWBUF_1_MAX_ADDR_8814B                                          \
	(BIT_MASK_RXFWBUF_1_MAX_ADDR_8814B                                     \
	 << BIT_SHIFT_RXFWBUF_1_MAX_ADDR_8814B)
#define BIT_CLEAR_RXFWBUF_1_MAX_ADDR_8814B(x)                                  \
	((x) & (~BITS_RXFWBUF_1_MAX_ADDR_8814B))
#define BIT_GET_RXFWBUF_1_MAX_ADDR_8814B(x)                                    \
	(((x) >> BIT_SHIFT_RXFWBUF_1_MAX_ADDR_8814B) &                         \
	 BIT_MASK_RXFWBUF_1_MAX_ADDR_8814B)
#define BIT_SET_RXFWBUF_1_MAX_ADDR_8814B(x, v)                                 \
	(BIT_CLEAR_RXFWBUF_1_MAX_ADDR_8814B(x) |                               \
	 BIT_RXFWBUF_1_MAX_ADDR_8814B(v))

/* 2 REG_IO_WRAP_ERR_FLAG_V1_8814B */
#define BIT_IO_WRAP_ERR_8814B BIT(0)

/* 2 REG_RXPKTBUF_1_READ_8814B */

#define BIT_SHIFT_RXPKTBUF_1_READ_8814B 0
#define BIT_MASK_RXPKTBUF_1_READ_8814B 0x3ffff
#define BIT_RXPKTBUF_1_READ_8814B(x)                                           \
	(((x) & BIT_MASK_RXPKTBUF_1_READ_8814B)                                \
	 << BIT_SHIFT_RXPKTBUF_1_READ_8814B)
#define BITS_RXPKTBUF_1_READ_8814B                                             \
	(BIT_MASK_RXPKTBUF_1_READ_8814B << BIT_SHIFT_RXPKTBUF_1_READ_8814B)
#define BIT_CLEAR_RXPKTBUF_1_READ_8814B(x) ((x) & (~BITS_RXPKTBUF_1_READ_8814B))
#define BIT_GET_RXPKTBUF_1_READ_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RXPKTBUF_1_READ_8814B) &                            \
	 BIT_MASK_RXPKTBUF_1_READ_8814B)
#define BIT_SET_RXPKTBUF_1_READ_8814B(x, v)                                    \
	(BIT_CLEAR_RXPKTBUF_1_READ_8814B(x) | BIT_RXPKTBUF_1_READ_8814B(v))

/* 2 REG_RXPKTBUF_1_WRITE_8814B */

#define BIT_SHIFT_RXPKTBUF_1_WRITE_8814B 0
#define BIT_MASK_RXPKTBUF_1_WRITE_8814B 0x3ffff
#define BIT_RXPKTBUF_1_WRITE_8814B(x)                                          \
	(((x) & BIT_MASK_RXPKTBUF_1_WRITE_8814B)                               \
	 << BIT_SHIFT_RXPKTBUF_1_WRITE_8814B)
#define BITS_RXPKTBUF_1_WRITE_8814B                                            \
	(BIT_MASK_RXPKTBUF_1_WRITE_8814B << BIT_SHIFT_RXPKTBUF_1_WRITE_8814B)
#define BIT_CLEAR_RXPKTBUF_1_WRITE_8814B(x)                                    \
	((x) & (~BITS_RXPKTBUF_1_WRITE_8814B))
#define BIT_GET_RXPKTBUF_1_WRITE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RXPKTBUF_1_WRITE_8814B) &                           \
	 BIT_MASK_RXPKTBUF_1_WRITE_8814B)
#define BIT_SET_RXPKTBUF_1_WRITE_8814B(x, v)                                   \
	(BIT_CLEAR_RXPKTBUF_1_WRITE_8814B(x) | BIT_RXPKTBUF_1_WRITE_8814B(v))

/* 2 REG_BUFF_DBGUG_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_R_OQT_DBG_SEL_8814B 16
#define BIT_MASK_R_OQT_DBG_SEL_8814B 0xff
#define BIT_R_OQT_DBG_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_R_OQT_DBG_SEL_8814B) << BIT_SHIFT_R_OQT_DBG_SEL_8814B)
#define BITS_R_OQT_DBG_SEL_8814B                                               \
	(BIT_MASK_R_OQT_DBG_SEL_8814B << BIT_SHIFT_R_OQT_DBG_SEL_8814B)
#define BIT_CLEAR_R_OQT_DBG_SEL_8814B(x) ((x) & (~BITS_R_OQT_DBG_SEL_8814B))
#define BIT_GET_R_OQT_DBG_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_R_OQT_DBG_SEL_8814B) & BIT_MASK_R_OQT_DBG_SEL_8814B)
#define BIT_SET_R_OQT_DBG_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_R_OQT_DBG_SEL_8814B(x) | BIT_R_OQT_DBG_SEL_8814B(v))

#define BIT_SHIFT_R_TXPKTBF_DBG_SEL_8814B 8
#define BIT_MASK_R_TXPKTBF_DBG_SEL_8814B 0x7
#define BIT_R_TXPKTBF_DBG_SEL_8814B(x)                                         \
	(((x) & BIT_MASK_R_TXPKTBF_DBG_SEL_8814B)                              \
	 << BIT_SHIFT_R_TXPKTBF_DBG_SEL_8814B)
#define BITS_R_TXPKTBF_DBG_SEL_8814B                                           \
	(BIT_MASK_R_TXPKTBF_DBG_SEL_8814B << BIT_SHIFT_R_TXPKTBF_DBG_SEL_8814B)
#define BIT_CLEAR_R_TXPKTBF_DBG_SEL_8814B(x)                                   \
	((x) & (~BITS_R_TXPKTBF_DBG_SEL_8814B))
#define BIT_GET_R_TXPKTBF_DBG_SEL_8814B(x)                                     \
	(((x) >> BIT_SHIFT_R_TXPKTBF_DBG_SEL_8814B) &                          \
	 BIT_MASK_R_TXPKTBF_DBG_SEL_8814B)
#define BIT_SET_R_TXPKTBF_DBG_SEL_8814B(x, v)                                  \
	(BIT_CLEAR_R_TXPKTBF_DBG_SEL_8814B(x) | BIT_R_TXPKTBF_DBG_SEL_8814B(v))

#define BIT_SHIFT_R_RXPKT_DBG_SEL_8814B 6
#define BIT_MASK_R_RXPKT_DBG_SEL_8814B 0x3
#define BIT_R_RXPKT_DBG_SEL_8814B(x)                                           \
	(((x) & BIT_MASK_R_RXPKT_DBG_SEL_8814B)                                \
	 << BIT_SHIFT_R_RXPKT_DBG_SEL_8814B)
#define BITS_R_RXPKT_DBG_SEL_8814B                                             \
	(BIT_MASK_R_RXPKT_DBG_SEL_8814B << BIT_SHIFT_R_RXPKT_DBG_SEL_8814B)
#define BIT_CLEAR_R_RXPKT_DBG_SEL_8814B(x) ((x) & (~BITS_R_RXPKT_DBG_SEL_8814B))
#define BIT_GET_R_RXPKT_DBG_SEL_8814B(x)                                       \
	(((x) >> BIT_SHIFT_R_RXPKT_DBG_SEL_8814B) &                            \
	 BIT_MASK_R_RXPKT_DBG_SEL_8814B)
#define BIT_SET_R_RXPKT_DBG_SEL_8814B(x, v)                                    \
	(BIT_CLEAR_R_RXPKT_DBG_SEL_8814B(x) | BIT_R_RXPKT_DBG_SEL_8814B(v))

#define BIT_SHIFT_R_RXPKTBF_DBG_SEL_8814B 0
#define BIT_MASK_R_RXPKTBF_DBG_SEL_8814B 0x3
#define BIT_R_RXPKTBF_DBG_SEL_8814B(x)                                         \
	(((x) & BIT_MASK_R_RXPKTBF_DBG_SEL_8814B)                              \
	 << BIT_SHIFT_R_RXPKTBF_DBG_SEL_8814B)
#define BITS_R_RXPKTBF_DBG_SEL_8814B                                           \
	(BIT_MASK_R_RXPKTBF_DBG_SEL_8814B << BIT_SHIFT_R_RXPKTBF_DBG_SEL_8814B)
#define BIT_CLEAR_R_RXPKTBF_DBG_SEL_8814B(x)                                   \
	((x) & (~BITS_R_RXPKTBF_DBG_SEL_8814B))
#define BIT_GET_R_RXPKTBF_DBG_SEL_8814B(x)                                     \
	(((x) >> BIT_SHIFT_R_RXPKTBF_DBG_SEL_8814B) &                          \
	 BIT_MASK_R_RXPKTBF_DBG_SEL_8814B)
#define BIT_SET_R_RXPKTBF_DBG_SEL_8814B(x, v)                                  \
	(BIT_CLEAR_R_RXPKTBF_DBG_SEL_8814B(x) | BIT_R_RXPKTBF_DBG_SEL_8814B(v))

/* 2 REG_RFE_CTRL_PAD_E2_8814B */
#define BIT_RFE_CTRL_ANTSW_E2_8814B BIT(16)
#define BIT_RFE_CTRL_PIN15_E2_8814B BIT(15)
#define BIT_RFE_CTRL_PIN14_E2_8814B BIT(14)
#define BIT_RFE_CTRL_PIN13_E2_8814B BIT(13)
#define BIT_RFE_CTRL_PIN12_E2_8814B BIT(12)
#define BIT_RFE_CTRL_PIN11_E2_8814B BIT(11)
#define BIT_RFE_CTRL_PIN10_E2_8814B BIT(10)
#define BIT_RFE_CTRL_PIN9_E2_8814B BIT(9)
#define BIT_RFE_CTRL_PIN8_E2_8814B BIT(8)
#define BIT_RFE_CTRL_PIN7_E2_8814B BIT(7)
#define BIT_RFE_CTRL_PIN6_E2_8814B BIT(6)
#define BIT_RFE_CTRL_PIN5_E2_8814B BIT(5)
#define BIT_RFE_CTRL_PIN4_E2_8814B BIT(4)
#define BIT_RFE_CTRL_PIN3_E2_8814B BIT(3)
#define BIT_RFE_CTRL_PIN2_E2_8814B BIT(2)
#define BIT_RFE_CTRL_PIN1_E2_8814B BIT(1)
#define BIT_RFE_CTRL_PIN0_E2_8814B BIT(0)

/* 2 REG_RFE_CTRL_PAD_SR_8814B */
#define BIT_RFE_CTRL_ANTSW_SR_8814B BIT(16)
#define BIT_RFE_CTRL_PIN15_SR_8814B BIT(15)
#define BIT_RFE_CTRL_PIN14_SR_8814B BIT(14)
#define BIT_RFE_CTRL_PIN13_SR_8814B BIT(13)
#define BIT_RFE_CTRL_PIN12_SR_8814B BIT(12)
#define BIT_RFE_CTRL_PIN11_SR_8814B BIT(11)
#define BIT_RFE_CTRL_PIN10_SR_8814B BIT(10)
#define BIT_RFE_CTRL_PIN9_SR_8814B BIT(9)
#define BIT_RFE_CTRL_PIN8_SR_8814B BIT(8)
#define BIT_RFE_CTRL_PIN7_SR_8814B BIT(7)
#define BIT_RFE_CTRL_PIN6_SR_8814B BIT(6)
#define BIT_RFE_CTRL_PIN5_SR_8814B BIT(5)
#define BIT_RFE_CTRL_PIN4_SR_8814B BIT(4)
#define BIT_RFE_CTRL_PIN3_SR_8814B BIT(3)
#define BIT_RFE_CTRL_PIN2_SR_8814B BIT(2)
#define BIT_RFE_CTRL_PIN1_SR_8814B BIT(1)
#define BIT_RFE_CTRL_PIN0_SR_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_H2C_PRIORITY_SEL_8814B */

#define BIT_SHIFT_H2C_PRIORITY_SEL_8814B 0
#define BIT_MASK_H2C_PRIORITY_SEL_8814B 0x3
#define BIT_H2C_PRIORITY_SEL_8814B(x)                                          \
	(((x) & BIT_MASK_H2C_PRIORITY_SEL_8814B)                               \
	 << BIT_SHIFT_H2C_PRIORITY_SEL_8814B)
#define BITS_H2C_PRIORITY_SEL_8814B                                            \
	(BIT_MASK_H2C_PRIORITY_SEL_8814B << BIT_SHIFT_H2C_PRIORITY_SEL_8814B)
#define BIT_CLEAR_H2C_PRIORITY_SEL_8814B(x)                                    \
	((x) & (~BITS_H2C_PRIORITY_SEL_8814B))
#define BIT_GET_H2C_PRIORITY_SEL_8814B(x)                                      \
	(((x) >> BIT_SHIFT_H2C_PRIORITY_SEL_8814B) &                           \
	 BIT_MASK_H2C_PRIORITY_SEL_8814B)
#define BIT_SET_H2C_PRIORITY_SEL_8814B(x, v)                                   \
	(BIT_CLEAR_H2C_PRIORITY_SEL_8814B(x) | BIT_H2C_PRIORITY_SEL_8814B(v))

/* 2 REG_COUNTER_CTRL_8814B */

#define BIT_SHIFT_COUNTER_BASE_8814B 16
#define BIT_MASK_COUNTER_BASE_8814B 0x1fff
#define BIT_COUNTER_BASE_8814B(x)                                              \
	(((x) & BIT_MASK_COUNTER_BASE_8814B) << BIT_SHIFT_COUNTER_BASE_8814B)
#define BITS_COUNTER_BASE_8814B                                                \
	(BIT_MASK_COUNTER_BASE_8814B << BIT_SHIFT_COUNTER_BASE_8814B)
#define BIT_CLEAR_COUNTER_BASE_8814B(x) ((x) & (~BITS_COUNTER_BASE_8814B))
#define BIT_GET_COUNTER_BASE_8814B(x)                                          \
	(((x) >> BIT_SHIFT_COUNTER_BASE_8814B) & BIT_MASK_COUNTER_BASE_8814B)
#define BIT_SET_COUNTER_BASE_8814B(x, v)                                       \
	(BIT_CLEAR_COUNTER_BASE_8814B(x) | BIT_COUNTER_BASE_8814B(v))

#define BIT_EN_RTS_REQ_8814B BIT(9)
#define BIT_EN_EDCA_REQ_8814B BIT(8)
#define BIT_EN_PTCL_REQ_8814B BIT(7)
#define BIT_EN_SCH_REQ_8814B BIT(6)
#define BIT_USB_COUNT_EN_8814B BIT(5)
#define BIT_PCIE_COUNT_EN_8814B BIT(4)
#define BIT_RQPN_COUNT_EN_8814B BIT(3)
#define BIT_RDE_COUNT_EN_8814B BIT(2)
#define BIT_TDE_COUNT_EN_8814B BIT(1)
#define BIT_DISABLE_COUNTER_8814B BIT(0)

/* 2 REG_COUNTER_THRESHOLD_8814B */
#define BIT_SEL_ALL_MACID_8814B BIT(31)

#define BIT_SHIFT_COUNTER_MACID_8814B 24
#define BIT_MASK_COUNTER_MACID_8814B 0x7f
#define BIT_COUNTER_MACID_8814B(x)                                             \
	(((x) & BIT_MASK_COUNTER_MACID_8814B) << BIT_SHIFT_COUNTER_MACID_8814B)
#define BITS_COUNTER_MACID_8814B                                               \
	(BIT_MASK_COUNTER_MACID_8814B << BIT_SHIFT_COUNTER_MACID_8814B)
#define BIT_CLEAR_COUNTER_MACID_8814B(x) ((x) & (~BITS_COUNTER_MACID_8814B))
#define BIT_GET_COUNTER_MACID_8814B(x)                                         \
	(((x) >> BIT_SHIFT_COUNTER_MACID_8814B) & BIT_MASK_COUNTER_MACID_8814B)
#define BIT_SET_COUNTER_MACID_8814B(x, v)                                      \
	(BIT_CLEAR_COUNTER_MACID_8814B(x) | BIT_COUNTER_MACID_8814B(v))

#define BIT_SHIFT_AGG_VALUE2_8814B 16
#define BIT_MASK_AGG_VALUE2_8814B 0x7f
#define BIT_AGG_VALUE2_8814B(x)                                                \
	(((x) & BIT_MASK_AGG_VALUE2_8814B) << BIT_SHIFT_AGG_VALUE2_8814B)
#define BITS_AGG_VALUE2_8814B                                                  \
	(BIT_MASK_AGG_VALUE2_8814B << BIT_SHIFT_AGG_VALUE2_8814B)
#define BIT_CLEAR_AGG_VALUE2_8814B(x) ((x) & (~BITS_AGG_VALUE2_8814B))
#define BIT_GET_AGG_VALUE2_8814B(x)                                            \
	(((x) >> BIT_SHIFT_AGG_VALUE2_8814B) & BIT_MASK_AGG_VALUE2_8814B)
#define BIT_SET_AGG_VALUE2_8814B(x, v)                                         \
	(BIT_CLEAR_AGG_VALUE2_8814B(x) | BIT_AGG_VALUE2_8814B(v))

#define BIT_SHIFT_AGG_VALUE1_8814B 8
#define BIT_MASK_AGG_VALUE1_8814B 0x7f
#define BIT_AGG_VALUE1_8814B(x)                                                \
	(((x) & BIT_MASK_AGG_VALUE1_8814B) << BIT_SHIFT_AGG_VALUE1_8814B)
#define BITS_AGG_VALUE1_8814B                                                  \
	(BIT_MASK_AGG_VALUE1_8814B << BIT_SHIFT_AGG_VALUE1_8814B)
#define BIT_CLEAR_AGG_VALUE1_8814B(x) ((x) & (~BITS_AGG_VALUE1_8814B))
#define BIT_GET_AGG_VALUE1_8814B(x)                                            \
	(((x) >> BIT_SHIFT_AGG_VALUE1_8814B) & BIT_MASK_AGG_VALUE1_8814B)
#define BIT_SET_AGG_VALUE1_8814B(x, v)                                         \
	(BIT_CLEAR_AGG_VALUE1_8814B(x) | BIT_AGG_VALUE1_8814B(v))

#define BIT_SHIFT_AGG_VALUE0_8814B 0
#define BIT_MASK_AGG_VALUE0_8814B 0x7f
#define BIT_AGG_VALUE0_8814B(x)                                                \
	(((x) & BIT_MASK_AGG_VALUE0_8814B) << BIT_SHIFT_AGG_VALUE0_8814B)
#define BITS_AGG_VALUE0_8814B                                                  \
	(BIT_MASK_AGG_VALUE0_8814B << BIT_SHIFT_AGG_VALUE0_8814B)
#define BIT_CLEAR_AGG_VALUE0_8814B(x) ((x) & (~BITS_AGG_VALUE0_8814B))
#define BIT_GET_AGG_VALUE0_8814B(x)                                            \
	(((x) >> BIT_SHIFT_AGG_VALUE0_8814B) & BIT_MASK_AGG_VALUE0_8814B)
#define BIT_SET_AGG_VALUE0_8814B(x, v)                                         \
	(BIT_CLEAR_AGG_VALUE0_8814B(x) | BIT_AGG_VALUE0_8814B(v))

/* 2 REG_COUNTER_SET_8814B */

#define BIT_SHIFT_REQUEST_RESET_8814B 16
#define BIT_MASK_REQUEST_RESET_8814B 0xffff
#define BIT_REQUEST_RESET_8814B(x)                                             \
	(((x) & BIT_MASK_REQUEST_RESET_8814B) << BIT_SHIFT_REQUEST_RESET_8814B)
#define BITS_REQUEST_RESET_8814B                                               \
	(BIT_MASK_REQUEST_RESET_8814B << BIT_SHIFT_REQUEST_RESET_8814B)
#define BIT_CLEAR_REQUEST_RESET_8814B(x) ((x) & (~BITS_REQUEST_RESET_8814B))
#define BIT_GET_REQUEST_RESET_8814B(x)                                         \
	(((x) >> BIT_SHIFT_REQUEST_RESET_8814B) & BIT_MASK_REQUEST_RESET_8814B)
#define BIT_SET_REQUEST_RESET_8814B(x, v)                                      \
	(BIT_CLEAR_REQUEST_RESET_8814B(x) | BIT_REQUEST_RESET_8814B(v))

#define BIT_SHIFT_REQUEST_START_8814B 0
#define BIT_MASK_REQUEST_START_8814B 0xffff
#define BIT_REQUEST_START_8814B(x)                                             \
	(((x) & BIT_MASK_REQUEST_START_8814B) << BIT_SHIFT_REQUEST_START_8814B)
#define BITS_REQUEST_START_8814B                                               \
	(BIT_MASK_REQUEST_START_8814B << BIT_SHIFT_REQUEST_START_8814B)
#define BIT_CLEAR_REQUEST_START_8814B(x) ((x) & (~BITS_REQUEST_START_8814B))
#define BIT_GET_REQUEST_START_8814B(x)                                         \
	(((x) >> BIT_SHIFT_REQUEST_START_8814B) & BIT_MASK_REQUEST_START_8814B)
#define BIT_SET_REQUEST_START_8814B(x, v)                                      \
	(BIT_CLEAR_REQUEST_START_8814B(x) | BIT_REQUEST_START_8814B(v))

/* 2 REG_COUNTER_OVERFLOW_8814B */

#define BIT_SHIFT_CNT_OVF_REG_8814B 0
#define BIT_MASK_CNT_OVF_REG_8814B 0xffff
#define BIT_CNT_OVF_REG_8814B(x)                                               \
	(((x) & BIT_MASK_CNT_OVF_REG_8814B) << BIT_SHIFT_CNT_OVF_REG_8814B)
#define BITS_CNT_OVF_REG_8814B                                                 \
	(BIT_MASK_CNT_OVF_REG_8814B << BIT_SHIFT_CNT_OVF_REG_8814B)
#define BIT_CLEAR_CNT_OVF_REG_8814B(x) ((x) & (~BITS_CNT_OVF_REG_8814B))
#define BIT_GET_CNT_OVF_REG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CNT_OVF_REG_8814B) & BIT_MASK_CNT_OVF_REG_8814B)
#define BIT_SET_CNT_OVF_REG_8814B(x, v)                                        \
	(BIT_CLEAR_CNT_OVF_REG_8814B(x) | BIT_CNT_OVF_REG_8814B(v))

/* 2 REG_TXDMA_LEN_THRESHOLD_8814B */

#define BIT_SHIFT_TDE_LEN_TH1_8814B 16
#define BIT_MASK_TDE_LEN_TH1_8814B 0xffff
#define BIT_TDE_LEN_TH1_8814B(x)                                               \
	(((x) & BIT_MASK_TDE_LEN_TH1_8814B) << BIT_SHIFT_TDE_LEN_TH1_8814B)
#define BITS_TDE_LEN_TH1_8814B                                                 \
	(BIT_MASK_TDE_LEN_TH1_8814B << BIT_SHIFT_TDE_LEN_TH1_8814B)
#define BIT_CLEAR_TDE_LEN_TH1_8814B(x) ((x) & (~BITS_TDE_LEN_TH1_8814B))
#define BIT_GET_TDE_LEN_TH1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_TDE_LEN_TH1_8814B) & BIT_MASK_TDE_LEN_TH1_8814B)
#define BIT_SET_TDE_LEN_TH1_8814B(x, v)                                        \
	(BIT_CLEAR_TDE_LEN_TH1_8814B(x) | BIT_TDE_LEN_TH1_8814B(v))

#define BIT_SHIFT_TDE_LEN_TH0_8814B 0
#define BIT_MASK_TDE_LEN_TH0_8814B 0xffff
#define BIT_TDE_LEN_TH0_8814B(x)                                               \
	(((x) & BIT_MASK_TDE_LEN_TH0_8814B) << BIT_SHIFT_TDE_LEN_TH0_8814B)
#define BITS_TDE_LEN_TH0_8814B                                                 \
	(BIT_MASK_TDE_LEN_TH0_8814B << BIT_SHIFT_TDE_LEN_TH0_8814B)
#define BIT_CLEAR_TDE_LEN_TH0_8814B(x) ((x) & (~BITS_TDE_LEN_TH0_8814B))
#define BIT_GET_TDE_LEN_TH0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_TDE_LEN_TH0_8814B) & BIT_MASK_TDE_LEN_TH0_8814B)
#define BIT_SET_TDE_LEN_TH0_8814B(x, v)                                        \
	(BIT_CLEAR_TDE_LEN_TH0_8814B(x) | BIT_TDE_LEN_TH0_8814B(v))

/* 2 REG_RXDMA_LEN_THRESHOLD_8814B */

#define BIT_SHIFT_RDE_LEN_TH1_8814B 16
#define BIT_MASK_RDE_LEN_TH1_8814B 0xffff
#define BIT_RDE_LEN_TH1_8814B(x)                                               \
	(((x) & BIT_MASK_RDE_LEN_TH1_8814B) << BIT_SHIFT_RDE_LEN_TH1_8814B)
#define BITS_RDE_LEN_TH1_8814B                                                 \
	(BIT_MASK_RDE_LEN_TH1_8814B << BIT_SHIFT_RDE_LEN_TH1_8814B)
#define BIT_CLEAR_RDE_LEN_TH1_8814B(x) ((x) & (~BITS_RDE_LEN_TH1_8814B))
#define BIT_GET_RDE_LEN_TH1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_RDE_LEN_TH1_8814B) & BIT_MASK_RDE_LEN_TH1_8814B)
#define BIT_SET_RDE_LEN_TH1_8814B(x, v)                                        \
	(BIT_CLEAR_RDE_LEN_TH1_8814B(x) | BIT_RDE_LEN_TH1_8814B(v))

#define BIT_SHIFT_RDE_LEN_TH0_8814B 0
#define BIT_MASK_RDE_LEN_TH0_8814B 0xffff
#define BIT_RDE_LEN_TH0_8814B(x)                                               \
	(((x) & BIT_MASK_RDE_LEN_TH0_8814B) << BIT_SHIFT_RDE_LEN_TH0_8814B)
#define BITS_RDE_LEN_TH0_8814B                                                 \
	(BIT_MASK_RDE_LEN_TH0_8814B << BIT_SHIFT_RDE_LEN_TH0_8814B)
#define BIT_CLEAR_RDE_LEN_TH0_8814B(x) ((x) & (~BITS_RDE_LEN_TH0_8814B))
#define BIT_GET_RDE_LEN_TH0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_RDE_LEN_TH0_8814B) & BIT_MASK_RDE_LEN_TH0_8814B)
#define BIT_SET_RDE_LEN_TH0_8814B(x, v)                                        \
	(BIT_CLEAR_RDE_LEN_TH0_8814B(x) | BIT_RDE_LEN_TH0_8814B(v))

/* 2 REG_PCIE_EXEC_TIME_THRESHOLD_8814B */

#define BIT_SHIFT_COUNT_INT_SEL_8814B 16
#define BIT_MASK_COUNT_INT_SEL_8814B 0x3
#define BIT_COUNT_INT_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_COUNT_INT_SEL_8814B) << BIT_SHIFT_COUNT_INT_SEL_8814B)
#define BITS_COUNT_INT_SEL_8814B                                               \
	(BIT_MASK_COUNT_INT_SEL_8814B << BIT_SHIFT_COUNT_INT_SEL_8814B)
#define BIT_CLEAR_COUNT_INT_SEL_8814B(x) ((x) & (~BITS_COUNT_INT_SEL_8814B))
#define BIT_GET_COUNT_INT_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_COUNT_INT_SEL_8814B) & BIT_MASK_COUNT_INT_SEL_8814B)
#define BIT_SET_COUNT_INT_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_COUNT_INT_SEL_8814B(x) | BIT_COUNT_INT_SEL_8814B(v))

#define BIT_SHIFT_EXEC_TIME_TH_8814B 0
#define BIT_MASK_EXEC_TIME_TH_8814B 0xffff
#define BIT_EXEC_TIME_TH_8814B(x)                                              \
	(((x) & BIT_MASK_EXEC_TIME_TH_8814B) << BIT_SHIFT_EXEC_TIME_TH_8814B)
#define BITS_EXEC_TIME_TH_8814B                                                \
	(BIT_MASK_EXEC_TIME_TH_8814B << BIT_SHIFT_EXEC_TIME_TH_8814B)
#define BIT_CLEAR_EXEC_TIME_TH_8814B(x) ((x) & (~BITS_EXEC_TIME_TH_8814B))
#define BIT_GET_EXEC_TIME_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_EXEC_TIME_TH_8814B) & BIT_MASK_EXEC_TIME_TH_8814B)
#define BIT_SET_EXEC_TIME_TH_8814B(x, v)                                       \
	(BIT_CLEAR_EXEC_TIME_TH_8814B(x) | BIT_EXEC_TIME_TH_8814B(v))

/* 2 REG_FT2IMR_8814B */
#define BIT_FS_CLI3_RX_UAPSDMD1_EN_8814B BIT(31)
#define BIT_FS_CLI3_RX_UAPSDMD0_EN_8814B BIT(30)
#define BIT_FS_CLI3_TRIGGER_PKT_EN_8814B BIT(29)
#define BIT_FS_CLI3_EOSP_INT_EN_8814B BIT(28)
#define BIT_FS_CLI2_RX_UAPSDMD1_EN_8814B BIT(27)
#define BIT_FS_CLI2_RX_UAPSDMD0_EN_8814B BIT(26)
#define BIT_FS_CLI2_TRIGGER_PKT_EN_8814B BIT(25)
#define BIT_FS_CLI2_EOSP_INT_EN_8814B BIT(24)
#define BIT_FS_CLI1_RX_UAPSDMD1_EN_8814B BIT(23)
#define BIT_FS_CLI1_RX_UAPSDMD0_EN_8814B BIT(22)
#define BIT_FS_CLI1_TRIGGER_PKT_EN_8814B BIT(21)
#define BIT_FS_CLI1_EOSP_INT_EN_8814B BIT(20)
#define BIT_FS_CLI0_RX_UAPSDMD1_EN_8814B BIT(19)
#define BIT_FS_CLI0_RX_UAPSDMD0_EN_8814B BIT(18)
#define BIT_FS_CLI0_TRIGGER_PKT_EN_8814B BIT(17)
#define BIT_FS_CLI0_EOSP_INT_EN_8814B BIT(16)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P2_EN_8814B BIT(9)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P1_EN_8814B BIT(8)
#define BIT_FS_CLI3_TX_NULL1_INT_EN_8814B BIT(7)
#define BIT_FS_CLI3_TX_NULL0_INT_EN_8814B BIT(6)
#define BIT_FS_CLI2_TX_NULL1_INT_EN_8814B BIT(5)
#define BIT_FS_CLI2_TX_NULL0_INT_EN_8814B BIT(4)
#define BIT_FS_CLI1_TX_NULL1_INT_EN_8814B BIT(3)
#define BIT_FS_CLI1_TX_NULL0_INT_EN_8814B BIT(2)
#define BIT_FS_CLI0_TX_NULL1_INT_EN_8814B BIT(1)
#define BIT_FS_CLI0_TX_NULL0_INT_EN_8814B BIT(0)

/* 2 REG_FT2ISR_8814B */
#define BIT_FS_CLI3_RX_UAPSDMD1_INT_8814B BIT(31)
#define BIT_FS_CLI3_RX_UAPSDMD0_INT_8814B BIT(30)
#define BIT_FS_CLI3_TRIGGER_PKT_INT_8814B BIT(29)
#define BIT_FS_CLI3_EOSP_INT_8814B BIT(28)
#define BIT_FS_CLI2_RX_UAPSDMD1_INT_8814B BIT(27)
#define BIT_FS_CLI2_RX_UAPSDMD0_INT_8814B BIT(26)
#define BIT_FS_CLI2_TRIGGER_PKT_INT_8814B BIT(25)
#define BIT_FS_CLI2_EOSP_INT_8814B BIT(24)
#define BIT_FS_CLI1_RX_UAPSDMD1_INT_8814B BIT(23)
#define BIT_FS_CLI1_RX_UAPSDMD0_INT_8814B BIT(22)
#define BIT_FS_CLI1_TRIGGER_PKT_INT_8814B BIT(21)
#define BIT_FS_CLI1_EOSP_INT_8814B BIT(20)
#define BIT_FS_CLI0_RX_UAPSDMD1_INT_8814B BIT(19)
#define BIT_FS_CLI0_RX_UAPSDMD0_INT_8814B BIT(18)
#define BIT_FS_CLI0_TRIGGER_PKT_INT_8814B BIT(17)
#define BIT_FS_CLI0_EOSP_INT_8814B BIT(16)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P2_INT_8814B BIT(9)
#define BIT_FS_TSF_BIT32_TOGGLE_P2P1_INT_8814B BIT(8)
#define BIT_FS_CLI3_TX_NULL1_INT_8814B BIT(7)
#define BIT_FS_CLI3_TX_NULL0_INT_8814B BIT(6)
#define BIT_FS_CLI2_TX_NULL1_INT_8814B BIT(5)
#define BIT_FS_CLI2_TX_NULL0_INT_8814B BIT(4)
#define BIT_FS_CLI1_TX_NULL1_INT_8814B BIT(3)
#define BIT_FS_CLI1_TX_NULL0_INT_8814B BIT(2)
#define BIT_FS_CLI0_TX_NULL1_INT_8814B BIT(1)
#define BIT_FS_CLI0_TX_NULL0_INT_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_MSG2_8814B */

#define BIT_SHIFT_FW_MSG2_8814B 0
#define BIT_MASK_FW_MSG2_8814B 0xffffffffL
#define BIT_FW_MSG2_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_MSG2_8814B) << BIT_SHIFT_FW_MSG2_8814B)
#define BITS_FW_MSG2_8814B (BIT_MASK_FW_MSG2_8814B << BIT_SHIFT_FW_MSG2_8814B)
#define BIT_CLEAR_FW_MSG2_8814B(x) ((x) & (~BITS_FW_MSG2_8814B))
#define BIT_GET_FW_MSG2_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG2_8814B) & BIT_MASK_FW_MSG2_8814B)
#define BIT_SET_FW_MSG2_8814B(x, v)                                            \
	(BIT_CLEAR_FW_MSG2_8814B(x) | BIT_FW_MSG2_8814B(v))

/* 2 REG_MSG3_8814B */

#define BIT_SHIFT_FW_MSG3_8814B 0
#define BIT_MASK_FW_MSG3_8814B 0xffffffffL
#define BIT_FW_MSG3_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_MSG3_8814B) << BIT_SHIFT_FW_MSG3_8814B)
#define BITS_FW_MSG3_8814B (BIT_MASK_FW_MSG3_8814B << BIT_SHIFT_FW_MSG3_8814B)
#define BIT_CLEAR_FW_MSG3_8814B(x) ((x) & (~BITS_FW_MSG3_8814B))
#define BIT_GET_FW_MSG3_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG3_8814B) & BIT_MASK_FW_MSG3_8814B)
#define BIT_SET_FW_MSG3_8814B(x, v)                                            \
	(BIT_CLEAR_FW_MSG3_8814B(x) | BIT_FW_MSG3_8814B(v))

/* 2 REG_MSG4_8814B */

#define BIT_SHIFT_FW_MSG4_8814B 0
#define BIT_MASK_FW_MSG4_8814B 0xffffffffL
#define BIT_FW_MSG4_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_MSG4_8814B) << BIT_SHIFT_FW_MSG4_8814B)
#define BITS_FW_MSG4_8814B (BIT_MASK_FW_MSG4_8814B << BIT_SHIFT_FW_MSG4_8814B)
#define BIT_CLEAR_FW_MSG4_8814B(x) ((x) & (~BITS_FW_MSG4_8814B))
#define BIT_GET_FW_MSG4_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG4_8814B) & BIT_MASK_FW_MSG4_8814B)
#define BIT_SET_FW_MSG4_8814B(x, v)                                            \
	(BIT_CLEAR_FW_MSG4_8814B(x) | BIT_FW_MSG4_8814B(v))

/* 2 REG_MSG5_8814B */

#define BIT_SHIFT_FW_MSG5_8814B 0
#define BIT_MASK_FW_MSG5_8814B 0xffffffffL
#define BIT_FW_MSG5_8814B(x)                                                   \
	(((x) & BIT_MASK_FW_MSG5_8814B) << BIT_SHIFT_FW_MSG5_8814B)
#define BITS_FW_MSG5_8814B (BIT_MASK_FW_MSG5_8814B << BIT_SHIFT_FW_MSG5_8814B)
#define BIT_CLEAR_FW_MSG5_8814B(x) ((x) & (~BITS_FW_MSG5_8814B))
#define BIT_GET_FW_MSG5_8814B(x)                                               \
	(((x) >> BIT_SHIFT_FW_MSG5_8814B) & BIT_MASK_FW_MSG5_8814B)
#define BIT_SET_FW_MSG5_8814B(x, v)                                            \
	(BIT_CLEAR_FW_MSG5_8814B(x) | BIT_FW_MSG5_8814B(v))

/* 2 REG_BIST_RSTN0_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_RSTN2_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_MODE_NRML0_8814B */

/* 2 REG_BIST_MODE_NRML1_8814B */

/* 2 REG_BIST_MODE_NRML2_8814B */

/* 2 REG_BIST_MODE_NRML3_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_DONE_NRML_MAC_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_DONE_NRML1_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_DONE_DRF_MAC_8814B */

/* 2 REG_BIST_DONE_DRF_8814B */

/* 2 REG_BIST_DONE_DRF1_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_FAIL_NRML_MAC_8814B */

/* 2 REG_BIST_FAIL_NRML_8814B */

/* 2 REG_BIST_FAIL_NRML1_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_FAIL_NRML_MAC_V1_8814B */

/* 2 REG_BIST_FAIL_NRML_V1_8814B */

/* 2 REG_BIST_FAIL_NRML1_V1_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BIST_MISR_DATAOUT_8814B */

/* 2 REG_BIST_MISR_DATAOUT1_8814B */

/* 2 REG_BIST_MISR_DATAOUT_CPU_8814B */

/* 2 REG_BIST_MISR_DATAOUT_CPU1_8814B */

/* 2 REG_BIST_MISR_DATAOUT_CPU2_8814B */

/* 2 REG_BIST_MISR_DATOUT_CPU3_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BCN_CTRL_0_8814B */
#define BIT_BCN1_VALID_8814B BIT(31)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_BCN1_HEAD_8814B 16
#define BIT_MASK_BCN1_HEAD_8814B 0xfff
#define BIT_BCN1_HEAD_8814B(x)                                                 \
	(((x) & BIT_MASK_BCN1_HEAD_8814B) << BIT_SHIFT_BCN1_HEAD_8814B)
#define BITS_BCN1_HEAD_8814B                                                   \
	(BIT_MASK_BCN1_HEAD_8814B << BIT_SHIFT_BCN1_HEAD_8814B)
#define BIT_CLEAR_BCN1_HEAD_8814B(x) ((x) & (~BITS_BCN1_HEAD_8814B))
#define BIT_GET_BCN1_HEAD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCN1_HEAD_8814B) & BIT_MASK_BCN1_HEAD_8814B)
#define BIT_SET_BCN1_HEAD_8814B(x, v)                                          \
	(BIT_CLEAR_BCN1_HEAD_8814B(x) | BIT_BCN1_HEAD_8814B(v))

#define BIT_BCN0_VALID_8814B BIT(15)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_BCN0_HEAD_8814B 0
#define BIT_MASK_BCN0_HEAD_8814B 0xfff
#define BIT_BCN0_HEAD_8814B(x)                                                 \
	(((x) & BIT_MASK_BCN0_HEAD_8814B) << BIT_SHIFT_BCN0_HEAD_8814B)
#define BITS_BCN0_HEAD_8814B                                                   \
	(BIT_MASK_BCN0_HEAD_8814B << BIT_SHIFT_BCN0_HEAD_8814B)
#define BIT_CLEAR_BCN0_HEAD_8814B(x) ((x) & (~BITS_BCN0_HEAD_8814B))
#define BIT_GET_BCN0_HEAD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCN0_HEAD_8814B) & BIT_MASK_BCN0_HEAD_8814B)
#define BIT_SET_BCN0_HEAD_8814B(x, v)                                          \
	(BIT_CLEAR_BCN0_HEAD_8814B(x) | BIT_BCN0_HEAD_8814B(v))

/* 2 REG_BCN_CTRL_1_8814B */
#define BIT_BCN3_VALID_8814B BIT(31)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_BCN3_HEAD_8814B 16
#define BIT_MASK_BCN3_HEAD_8814B 0xfff
#define BIT_BCN3_HEAD_8814B(x)                                                 \
	(((x) & BIT_MASK_BCN3_HEAD_8814B) << BIT_SHIFT_BCN3_HEAD_8814B)
#define BITS_BCN3_HEAD_8814B                                                   \
	(BIT_MASK_BCN3_HEAD_8814B << BIT_SHIFT_BCN3_HEAD_8814B)
#define BIT_CLEAR_BCN3_HEAD_8814B(x) ((x) & (~BITS_BCN3_HEAD_8814B))
#define BIT_GET_BCN3_HEAD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCN3_HEAD_8814B) & BIT_MASK_BCN3_HEAD_8814B)
#define BIT_SET_BCN3_HEAD_8814B(x, v)                                          \
	(BIT_CLEAR_BCN3_HEAD_8814B(x) | BIT_BCN3_HEAD_8814B(v))

#define BIT_BCN2_VALID_8814B BIT(15)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_BCN2_HEAD_8814B 0
#define BIT_MASK_BCN2_HEAD_8814B 0xfff
#define BIT_BCN2_HEAD_8814B(x)                                                 \
	(((x) & BIT_MASK_BCN2_HEAD_8814B) << BIT_SHIFT_BCN2_HEAD_8814B)
#define BITS_BCN2_HEAD_8814B                                                   \
	(BIT_MASK_BCN2_HEAD_8814B << BIT_SHIFT_BCN2_HEAD_8814B)
#define BIT_CLEAR_BCN2_HEAD_8814B(x) ((x) & (~BITS_BCN2_HEAD_8814B))
#define BIT_GET_BCN2_HEAD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCN2_HEAD_8814B) & BIT_MASK_BCN2_HEAD_8814B)
#define BIT_SET_BCN2_HEAD_8814B(x, v)                                          \
	(BIT_CLEAR_BCN2_HEAD_8814B(x) | BIT_BCN2_HEAD_8814B(v))

/* 2 REG_AUTO_LLT_V1_8814B */

#define BIT_SHIFT_MAX_TX_PKT_V1_8814B 24
#define BIT_MASK_MAX_TX_PKT_V1_8814B 0xff
#define BIT_MAX_TX_PKT_V1_8814B(x)                                             \
	(((x) & BIT_MASK_MAX_TX_PKT_V1_8814B) << BIT_SHIFT_MAX_TX_PKT_V1_8814B)
#define BITS_MAX_TX_PKT_V1_8814B                                               \
	(BIT_MASK_MAX_TX_PKT_V1_8814B << BIT_SHIFT_MAX_TX_PKT_V1_8814B)
#define BIT_CLEAR_MAX_TX_PKT_V1_8814B(x) ((x) & (~BITS_MAX_TX_PKT_V1_8814B))
#define BIT_GET_MAX_TX_PKT_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MAX_TX_PKT_V1_8814B) & BIT_MASK_MAX_TX_PKT_V1_8814B)
#define BIT_SET_MAX_TX_PKT_V1_8814B(x, v)                                      \
	(BIT_CLEAR_MAX_TX_PKT_V1_8814B(x) | BIT_MAX_TX_PKT_V1_8814B(v))

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_R_BCN_HEAD_SEL_V1_8814B 20
#define BIT_MASK_R_BCN_HEAD_SEL_V1_8814B 0x7
#define BIT_R_BCN_HEAD_SEL_V1_8814B(x)                                         \
	(((x) & BIT_MASK_R_BCN_HEAD_SEL_V1_8814B)                              \
	 << BIT_SHIFT_R_BCN_HEAD_SEL_V1_8814B)
#define BITS_R_BCN_HEAD_SEL_V1_8814B                                           \
	(BIT_MASK_R_BCN_HEAD_SEL_V1_8814B << BIT_SHIFT_R_BCN_HEAD_SEL_V1_8814B)
#define BIT_CLEAR_R_BCN_HEAD_SEL_V1_8814B(x)                                   \
	((x) & (~BITS_R_BCN_HEAD_SEL_V1_8814B))
#define BIT_GET_R_BCN_HEAD_SEL_V1_8814B(x)                                     \
	(((x) >> BIT_SHIFT_R_BCN_HEAD_SEL_V1_8814B) &                          \
	 BIT_MASK_R_BCN_HEAD_SEL_V1_8814B)
#define BIT_SET_R_BCN_HEAD_SEL_V1_8814B(x, v)                                  \
	(BIT_CLEAR_R_BCN_HEAD_SEL_V1_8814B(x) | BIT_R_BCN_HEAD_SEL_V1_8814B(v))

#define BIT_SHIFT_LLT_FREE_PAGE_V2_8814B 8
#define BIT_MASK_LLT_FREE_PAGE_V2_8814B 0xfff
#define BIT_LLT_FREE_PAGE_V2_8814B(x)                                          \
	(((x) & BIT_MASK_LLT_FREE_PAGE_V2_8814B)                               \
	 << BIT_SHIFT_LLT_FREE_PAGE_V2_8814B)
#define BITS_LLT_FREE_PAGE_V2_8814B                                            \
	(BIT_MASK_LLT_FREE_PAGE_V2_8814B << BIT_SHIFT_LLT_FREE_PAGE_V2_8814B)
#define BIT_CLEAR_LLT_FREE_PAGE_V2_8814B(x)                                    \
	((x) & (~BITS_LLT_FREE_PAGE_V2_8814B))
#define BIT_GET_LLT_FREE_PAGE_V2_8814B(x)                                      \
	(((x) >> BIT_SHIFT_LLT_FREE_PAGE_V2_8814B) &                           \
	 BIT_MASK_LLT_FREE_PAGE_V2_8814B)
#define BIT_SET_LLT_FREE_PAGE_V2_8814B(x, v)                                   \
	(BIT_CLEAR_LLT_FREE_PAGE_V2_8814B(x) | BIT_LLT_FREE_PAGE_V2_8814B(v))

#define BIT_SHIFT_BLK_DESC_NUM_8814B 4
#define BIT_MASK_BLK_DESC_NUM_8814B 0xf
#define BIT_BLK_DESC_NUM_8814B(x)                                              \
	(((x) & BIT_MASK_BLK_DESC_NUM_8814B) << BIT_SHIFT_BLK_DESC_NUM_8814B)
#define BITS_BLK_DESC_NUM_8814B                                                \
	(BIT_MASK_BLK_DESC_NUM_8814B << BIT_SHIFT_BLK_DESC_NUM_8814B)
#define BIT_CLEAR_BLK_DESC_NUM_8814B(x) ((x) & (~BITS_BLK_DESC_NUM_8814B))
#define BIT_GET_BLK_DESC_NUM_8814B(x)                                          \
	(((x) >> BIT_SHIFT_BLK_DESC_NUM_8814B) & BIT_MASK_BLK_DESC_NUM_8814B)
#define BIT_SET_BLK_DESC_NUM_8814B(x, v)                                       \
	(BIT_CLEAR_BLK_DESC_NUM_8814B(x) | BIT_BLK_DESC_NUM_8814B(v))

#define BIT_TDE_ERROR_STOP_8814B BIT(3)
#define BIT_R_EN_BCN_SW_HEAD_SEL_8814B BIT(2)
#define BIT_LLT_DBG_SEL_8814B BIT(1)
#define BIT_AUTO_INIT_LLT_V1_8814B BIT(0)

/* 2 REG_TXDMA_OFFSET_CHK_8814B */
#define BIT_EM_CHKSUM_FIN_8814B BIT(31)
#define BIT_EMN_PCIE_DMA_MOD_8814B BIT(30)
#define BIT_EN_TXQUE_CLR_8814B BIT(29)
#define BIT_EN_PCIE_FIFO_MODE_8814B BIT(28)

#define BIT_SHIFT_PG_UNDER_TH_V1_8814B 16
#define BIT_MASK_PG_UNDER_TH_V1_8814B 0xfff
#define BIT_PG_UNDER_TH_V1_8814B(x)                                            \
	(((x) & BIT_MASK_PG_UNDER_TH_V1_8814B)                                 \
	 << BIT_SHIFT_PG_UNDER_TH_V1_8814B)
#define BITS_PG_UNDER_TH_V1_8814B                                              \
	(BIT_MASK_PG_UNDER_TH_V1_8814B << BIT_SHIFT_PG_UNDER_TH_V1_8814B)
#define BIT_CLEAR_PG_UNDER_TH_V1_8814B(x) ((x) & (~BITS_PG_UNDER_TH_V1_8814B))
#define BIT_GET_PG_UNDER_TH_V1_8814B(x)                                        \
	(((x) >> BIT_SHIFT_PG_UNDER_TH_V1_8814B) &                             \
	 BIT_MASK_PG_UNDER_TH_V1_8814B)
#define BIT_SET_PG_UNDER_TH_V1_8814B(x, v)                                     \
	(BIT_CLEAR_PG_UNDER_TH_V1_8814B(x) | BIT_PG_UNDER_TH_V1_8814B(v))

#define BIT_R_EN_RESET_RESTORE_H2C_8814B BIT(15)
#define BIT_SDIO_TDE_FINISH_8814B BIT(14)
#define BIT_SDIO_TXDESC_CHKSUM_EN_8814B BIT(13)
#define BIT_RST_RDPTR_8814B BIT(12)
#define BIT_RST_WRPTR_8814B BIT(11)
#define BIT_CHK_PG_TH_EN_8814B BIT(10)
#define BIT_DROP_DATA_EN_8814B BIT(9)
#define BIT_CHECK_OFFSET_EN_8814B BIT(8)

#define BIT_SHIFT_CHECK_OFFSET_8814B 0
#define BIT_MASK_CHECK_OFFSET_8814B 0xff
#define BIT_CHECK_OFFSET_8814B(x)                                              \
	(((x) & BIT_MASK_CHECK_OFFSET_8814B) << BIT_SHIFT_CHECK_OFFSET_8814B)
#define BITS_CHECK_OFFSET_8814B                                                \
	(BIT_MASK_CHECK_OFFSET_8814B << BIT_SHIFT_CHECK_OFFSET_8814B)
#define BIT_CLEAR_CHECK_OFFSET_8814B(x) ((x) & (~BITS_CHECK_OFFSET_8814B))
#define BIT_GET_CHECK_OFFSET_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CHECK_OFFSET_8814B) & BIT_MASK_CHECK_OFFSET_8814B)
#define BIT_SET_CHECK_OFFSET_8814B(x, v)                                       \
	(BIT_CLEAR_CHECK_OFFSET_8814B(x) | BIT_CHECK_OFFSET_8814B(v))

/* 2 REG_TXDMA_STATUS_8814B */
#define BIT_AMSDU_PKT_SIZE_ERR_8814B BIT(31)
#define BIT_AMSDU_EN_ERR_8814B BIT(30)
#define BIT_CHKSUM_AMSDU_EN_ERR_8814B BIT(29)
#define BIT_TXPKTBF_REQ_ERR_8814B BIT(28)
#define BIT_OQT_UDN_16_8814B BIT(27)
#define BIT_OQT_OVF_16_8814B BIT(26)
#define BIT_OQT_UDN_14_15_8814B BIT(25)
#define BIT_OQT_OVF_14_15_8814B BIT(24)
#define BIT_OQT_UDN_13_8814B BIT(23)
#define BIT_OQT_OVF_13_8814B BIT(22)
#define BIT_OQT_UDN_12_8814B BIT(21)
#define BIT_OQT_OVF_12_8814B BIT(20)
#define BIT_OQT_UDN_8_11_8814B BIT(19)
#define BIT_OQT_OVF_8_11_8814B BIT(18)
#define BIT_OQT_UDN_4_7_8814B BIT(17)
#define BIT_OQT_OVF_4_7_8814B BIT(16)
#define BIT_PAYLOAD_CHKSUM_ERR_8814B BIT(15)
#define BIT_PAYLOAD_UDN_8814B BIT(14)
#define BIT_PAYLOAD_OVF_8814B BIT(13)
#define BIT_DSC_CHKSUM_FAIL_8814B BIT(12)
#define BIT_EP_QSEL_DIFF_8814B BIT(10)
#define BIT_TX_OFFS_UNMATCH_8814B BIT(9)
#define BIT_TXOQT_UDN_0_3_8814B BIT(8)
#define BIT_TXOQT_OVF_0_3_8814B BIT(7)
#define BIT_TXDMA_SFF_UDN_8814B BIT(6)
#define BIT_TXDMA_SFF_OVF_8814B BIT(5)
#define BIT_LLT_NULL_PG_8814B BIT(4)
#define BIT_PAGE_UDN_8814B BIT(3)
#define BIT_PAGE_OVF_8814B BIT(2)
#define BIT_TXFF_PG_UDN_8814B BIT(1)
#define BIT_TXFF_PG_OVF_8814B BIT(0)

/* 2 REG_TX_DMA_DBG_8814B */

/* 2 REG_DMA_RQPN_INFO_PUB_8814B */

#define BIT_SHIFT_PUB_AVAL_PG_8814B 16
#define BIT_MASK_PUB_AVAL_PG_8814B 0xfff
#define BIT_PUB_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_PUB_AVAL_PG_8814B) << BIT_SHIFT_PUB_AVAL_PG_8814B)
#define BITS_PUB_AVAL_PG_8814B                                                 \
	(BIT_MASK_PUB_AVAL_PG_8814B << BIT_SHIFT_PUB_AVAL_PG_8814B)
#define BIT_CLEAR_PUB_AVAL_PG_8814B(x) ((x) & (~BITS_PUB_AVAL_PG_8814B))
#define BIT_GET_PUB_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_PUB_AVAL_PG_8814B) & BIT_MASK_PUB_AVAL_PG_8814B)
#define BIT_SET_PUB_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_PUB_AVAL_PG_8814B(x) | BIT_PUB_AVAL_PG_8814B(v))

#define BIT_SHIFT_PUB_RSVD_PG_8814B 0
#define BIT_MASK_PUB_RSVD_PG_8814B 0xfff
#define BIT_PUB_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_PUB_RSVD_PG_8814B) << BIT_SHIFT_PUB_RSVD_PG_8814B)
#define BITS_PUB_RSVD_PG_8814B                                                 \
	(BIT_MASK_PUB_RSVD_PG_8814B << BIT_SHIFT_PUB_RSVD_PG_8814B)
#define BIT_CLEAR_PUB_RSVD_PG_8814B(x) ((x) & (~BITS_PUB_RSVD_PG_8814B))
#define BIT_GET_PUB_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_PUB_RSVD_PG_8814B) & BIT_MASK_PUB_RSVD_PG_8814B)
#define BIT_SET_PUB_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_PUB_RSVD_PG_8814B(x) | BIT_PUB_RSVD_PG_8814B(v))

/* 2 REG_RQPN_CTRL_2_V1_8814B */
#define BIT_LD_RQPN_V1_8814B BIT(31)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_CH16_PUBLIC_DIS_8814B BIT(16)
#define BIT_CH15_PUBLIC_DIS_8814B BIT(15)
#define BIT_CH14_PUBLIC_DIS_8814B BIT(14)
#define BIT_CH13_PUBLIC_DIS_8814B BIT(13)
#define BIT_CH12_PUBLIC_DIS_8814B BIT(12)
#define BIT_CH11_PUBLIC_DIS_8814B BIT(11)
#define BIT_CH10_PUBLIC_DIS_8814B BIT(10)
#define BIT_CH9_PUBLIC_DIS_8814B BIT(9)
#define BIT_CH8_PUBLIC_DIS_8814B BIT(8)
#define BIT_CH7_PUBLIC_DIS_8814B BIT(7)
#define BIT_CH6_PUBLIC_DIS_8814B BIT(6)
#define BIT_CH5_PUBLIC_DIS_8814B BIT(5)
#define BIT_CH4_PUBLIC_DIS_8814B BIT(4)
#define BIT_CH3_PUBLIC_DIS_8814B BIT(3)
#define BIT_CH2_PUBLIC_DIS_8814B BIT(2)
#define BIT_CH1_PUBLIC_DIS_8814B BIT(1)
#define BIT_CH0_PUBLIC_DIS_8814B BIT(0)

/* 2 REG_BCN_CTRL_2_8814B */
#define BIT_BCN0_EXT_VALID_8814B BIT(31)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_BCN0_EXT_HEAD_8814B 16
#define BIT_MASK_BCN0_EXT_HEAD_8814B 0xfff
#define BIT_BCN0_EXT_HEAD_8814B(x)                                             \
	(((x) & BIT_MASK_BCN0_EXT_HEAD_8814B) << BIT_SHIFT_BCN0_EXT_HEAD_8814B)
#define BITS_BCN0_EXT_HEAD_8814B                                               \
	(BIT_MASK_BCN0_EXT_HEAD_8814B << BIT_SHIFT_BCN0_EXT_HEAD_8814B)
#define BIT_CLEAR_BCN0_EXT_HEAD_8814B(x) ((x) & (~BITS_BCN0_EXT_HEAD_8814B))
#define BIT_GET_BCN0_EXT_HEAD_8814B(x)                                         \
	(((x) >> BIT_SHIFT_BCN0_EXT_HEAD_8814B) & BIT_MASK_BCN0_EXT_HEAD_8814B)
#define BIT_SET_BCN0_EXT_HEAD_8814B(x, v)                                      \
	(BIT_CLEAR_BCN0_EXT_HEAD_8814B(x) | BIT_BCN0_EXT_HEAD_8814B(v))

#define BIT_BCN4_VALID_8814B BIT(15)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_BCN4_HEAD_8814B 0
#define BIT_MASK_BCN4_HEAD_8814B 0xfff
#define BIT_BCN4_HEAD_8814B(x)                                                 \
	(((x) & BIT_MASK_BCN4_HEAD_8814B) << BIT_SHIFT_BCN4_HEAD_8814B)
#define BITS_BCN4_HEAD_8814B                                                   \
	(BIT_MASK_BCN4_HEAD_8814B << BIT_SHIFT_BCN4_HEAD_8814B)
#define BIT_CLEAR_BCN4_HEAD_8814B(x) ((x) & (~BITS_BCN4_HEAD_8814B))
#define BIT_GET_BCN4_HEAD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCN4_HEAD_8814B) & BIT_MASK_BCN4_HEAD_8814B)
#define BIT_SET_BCN4_HEAD_8814B(x, v)                                          \
	(BIT_CLEAR_BCN4_HEAD_8814B(x) | BIT_BCN4_HEAD_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_TXPKTNUM_0_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXPKTNUM_CH4_7_8814B 16
#define BIT_MASK_TXPKTNUM_CH4_7_8814B 0xfff
#define BIT_TXPKTNUM_CH4_7_8814B(x)                                            \
	(((x) & BIT_MASK_TXPKTNUM_CH4_7_8814B)                                 \
	 << BIT_SHIFT_TXPKTNUM_CH4_7_8814B)
#define BITS_TXPKTNUM_CH4_7_8814B                                              \
	(BIT_MASK_TXPKTNUM_CH4_7_8814B << BIT_SHIFT_TXPKTNUM_CH4_7_8814B)
#define BIT_CLEAR_TXPKTNUM_CH4_7_8814B(x) ((x) & (~BITS_TXPKTNUM_CH4_7_8814B))
#define BIT_GET_TXPKTNUM_CH4_7_8814B(x)                                        \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH4_7_8814B) &                             \
	 BIT_MASK_TXPKTNUM_CH4_7_8814B)
#define BIT_SET_TXPKTNUM_CH4_7_8814B(x, v)                                     \
	(BIT_CLEAR_TXPKTNUM_CH4_7_8814B(x) | BIT_TXPKTNUM_CH4_7_8814B(v))

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXPKTNUM_CH0_3_8814B 0
#define BIT_MASK_TXPKTNUM_CH0_3_8814B 0xfff
#define BIT_TXPKTNUM_CH0_3_8814B(x)                                            \
	(((x) & BIT_MASK_TXPKTNUM_CH0_3_8814B)                                 \
	 << BIT_SHIFT_TXPKTNUM_CH0_3_8814B)
#define BITS_TXPKTNUM_CH0_3_8814B                                              \
	(BIT_MASK_TXPKTNUM_CH0_3_8814B << BIT_SHIFT_TXPKTNUM_CH0_3_8814B)
#define BIT_CLEAR_TXPKTNUM_CH0_3_8814B(x) ((x) & (~BITS_TXPKTNUM_CH0_3_8814B))
#define BIT_GET_TXPKTNUM_CH0_3_8814B(x)                                        \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH0_3_8814B) &                             \
	 BIT_MASK_TXPKTNUM_CH0_3_8814B)
#define BIT_SET_TXPKTNUM_CH0_3_8814B(x, v)                                     \
	(BIT_CLEAR_TXPKTNUM_CH0_3_8814B(x) | BIT_TXPKTNUM_CH0_3_8814B(v))

/* 2 REG_TXPKTNUM_1_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXPKTNUM_CH12_8814B 16
#define BIT_MASK_TXPKTNUM_CH12_8814B 0xfff
#define BIT_TXPKTNUM_CH12_8814B(x)                                             \
	(((x) & BIT_MASK_TXPKTNUM_CH12_8814B) << BIT_SHIFT_TXPKTNUM_CH12_8814B)
#define BITS_TXPKTNUM_CH12_8814B                                               \
	(BIT_MASK_TXPKTNUM_CH12_8814B << BIT_SHIFT_TXPKTNUM_CH12_8814B)
#define BIT_CLEAR_TXPKTNUM_CH12_8814B(x) ((x) & (~BITS_TXPKTNUM_CH12_8814B))
#define BIT_GET_TXPKTNUM_CH12_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH12_8814B) & BIT_MASK_TXPKTNUM_CH12_8814B)
#define BIT_SET_TXPKTNUM_CH12_8814B(x, v)                                      \
	(BIT_CLEAR_TXPKTNUM_CH12_8814B(x) | BIT_TXPKTNUM_CH12_8814B(v))

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXPKTNUM_CH8_11_8814B 0
#define BIT_MASK_TXPKTNUM_CH8_11_8814B 0xfff
#define BIT_TXPKTNUM_CH8_11_8814B(x)                                           \
	(((x) & BIT_MASK_TXPKTNUM_CH8_11_8814B)                                \
	 << BIT_SHIFT_TXPKTNUM_CH8_11_8814B)
#define BITS_TXPKTNUM_CH8_11_8814B                                             \
	(BIT_MASK_TXPKTNUM_CH8_11_8814B << BIT_SHIFT_TXPKTNUM_CH8_11_8814B)
#define BIT_CLEAR_TXPKTNUM_CH8_11_8814B(x) ((x) & (~BITS_TXPKTNUM_CH8_11_8814B))
#define BIT_GET_TXPKTNUM_CH8_11_8814B(x)                                       \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH8_11_8814B) &                            \
	 BIT_MASK_TXPKTNUM_CH8_11_8814B)
#define BIT_SET_TXPKTNUM_CH8_11_8814B(x, v)                                    \
	(BIT_CLEAR_TXPKTNUM_CH8_11_8814B(x) | BIT_TXPKTNUM_CH8_11_8814B(v))

/* 2 REG_TXPKTNUM_2_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXPKTNUM_CH14_15_8814B 16
#define BIT_MASK_TXPKTNUM_CH14_15_8814B 0xfff
#define BIT_TXPKTNUM_CH14_15_8814B(x)                                          \
	(((x) & BIT_MASK_TXPKTNUM_CH14_15_8814B)                               \
	 << BIT_SHIFT_TXPKTNUM_CH14_15_8814B)
#define BITS_TXPKTNUM_CH14_15_8814B                                            \
	(BIT_MASK_TXPKTNUM_CH14_15_8814B << BIT_SHIFT_TXPKTNUM_CH14_15_8814B)
#define BIT_CLEAR_TXPKTNUM_CH14_15_8814B(x)                                    \
	((x) & (~BITS_TXPKTNUM_CH14_15_8814B))
#define BIT_GET_TXPKTNUM_CH14_15_8814B(x)                                      \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH14_15_8814B) &                           \
	 BIT_MASK_TXPKTNUM_CH14_15_8814B)
#define BIT_SET_TXPKTNUM_CH14_15_8814B(x, v)                                   \
	(BIT_CLEAR_TXPKTNUM_CH14_15_8814B(x) | BIT_TXPKTNUM_CH14_15_8814B(v))

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXPKTNUM_CH13_8814B 0
#define BIT_MASK_TXPKTNUM_CH13_8814B 0xfff
#define BIT_TXPKTNUM_CH13_8814B(x)                                             \
	(((x) & BIT_MASK_TXPKTNUM_CH13_8814B) << BIT_SHIFT_TXPKTNUM_CH13_8814B)
#define BITS_TXPKTNUM_CH13_8814B                                               \
	(BIT_MASK_TXPKTNUM_CH13_8814B << BIT_SHIFT_TXPKTNUM_CH13_8814B)
#define BIT_CLEAR_TXPKTNUM_CH13_8814B(x) ((x) & (~BITS_TXPKTNUM_CH13_8814B))
#define BIT_GET_TXPKTNUM_CH13_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH13_8814B) & BIT_MASK_TXPKTNUM_CH13_8814B)
#define BIT_SET_TXPKTNUM_CH13_8814B(x, v)                                      \
	(BIT_CLEAR_TXPKTNUM_CH13_8814B(x) | BIT_TXPKTNUM_CH13_8814B(v))

/* 2 REG_TXPKTNUM_3_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXPKTNUM_CH16_8814B 0
#define BIT_MASK_TXPKTNUM_CH16_8814B 0xfff
#define BIT_TXPKTNUM_CH16_8814B(x)                                             \
	(((x) & BIT_MASK_TXPKTNUM_CH16_8814B) << BIT_SHIFT_TXPKTNUM_CH16_8814B)
#define BITS_TXPKTNUM_CH16_8814B                                               \
	(BIT_MASK_TXPKTNUM_CH16_8814B << BIT_SHIFT_TXPKTNUM_CH16_8814B)
#define BIT_CLEAR_TXPKTNUM_CH16_8814B(x) ((x) & (~BITS_TXPKTNUM_CH16_8814B))
#define BIT_GET_TXPKTNUM_CH16_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXPKTNUM_CH16_8814B) & BIT_MASK_TXPKTNUM_CH16_8814B)
#define BIT_SET_TXPKTNUM_CH16_8814B(x, v)                                      \
	(BIT_CLEAR_TXPKTNUM_CH16_8814B(x) | BIT_TXPKTNUM_CH16_8814B(v))

/* 2 REG_TX_AGG_ALIGN_8814B */

#define BIT_SHIFT_HW_FLOW_CTL_EN_8814B 16
#define BIT_MASK_HW_FLOW_CTL_EN_8814B 0xffff
#define BIT_HW_FLOW_CTL_EN_8814B(x)                                            \
	(((x) & BIT_MASK_HW_FLOW_CTL_EN_8814B)                                 \
	 << BIT_SHIFT_HW_FLOW_CTL_EN_8814B)
#define BITS_HW_FLOW_CTL_EN_8814B                                              \
	(BIT_MASK_HW_FLOW_CTL_EN_8814B << BIT_SHIFT_HW_FLOW_CTL_EN_8814B)
#define BIT_CLEAR_HW_FLOW_CTL_EN_8814B(x) ((x) & (~BITS_HW_FLOW_CTL_EN_8814B))
#define BIT_GET_HW_FLOW_CTL_EN_8814B(x)                                        \
	(((x) >> BIT_SHIFT_HW_FLOW_CTL_EN_8814B) &                             \
	 BIT_MASK_HW_FLOW_CTL_EN_8814B)
#define BIT_SET_HW_FLOW_CTL_EN_8814B(x, v)                                     \
	(BIT_CLEAR_HW_FLOW_CTL_EN_8814B(x) | BIT_HW_FLOW_CTL_EN_8814B(v))

/* 2 REG_NOT_VALID_8814B */
#define BIT_SDIO_TXAGG_ALIGN_ADJUST_EN_V1_8814B BIT(15)

#define BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1_8814B 0
#define BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1_8814B 0xfff
#define BIT_SDIO_TXAGG_ALIGN_SIZE_V1_8814B(x)                                  \
	(((x) & BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1_8814B)                       \
	 << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1_8814B)
#define BITS_SDIO_TXAGG_ALIGN_SIZE_V1_8814B                                    \
	(BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1_8814B                               \
	 << BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1_8814B)
#define BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE_V1_8814B(x)                            \
	((x) & (~BITS_SDIO_TXAGG_ALIGN_SIZE_V1_8814B))
#define BIT_GET_SDIO_TXAGG_ALIGN_SIZE_V1_8814B(x)                              \
	(((x) >> BIT_SHIFT_SDIO_TXAGG_ALIGN_SIZE_V1_8814B) &                   \
	 BIT_MASK_SDIO_TXAGG_ALIGN_SIZE_V1_8814B)
#define BIT_SET_SDIO_TXAGG_ALIGN_SIZE_V1_8814B(x, v)                           \
	(BIT_CLEAR_SDIO_TXAGG_ALIGN_SIZE_V1_8814B(x) |                         \
	 BIT_SDIO_TXAGG_ALIGN_SIZE_V1_8814B(v))

/* 2 REG_H2C_HEAD_8814B */

#define BIT_SHIFT_H2C_HEAD_V1_8814B 0
#define BIT_MASK_H2C_HEAD_V1_8814B 0x7ffff
#define BIT_H2C_HEAD_V1_8814B(x)                                               \
	(((x) & BIT_MASK_H2C_HEAD_V1_8814B) << BIT_SHIFT_H2C_HEAD_V1_8814B)
#define BITS_H2C_HEAD_V1_8814B                                                 \
	(BIT_MASK_H2C_HEAD_V1_8814B << BIT_SHIFT_H2C_HEAD_V1_8814B)
#define BIT_CLEAR_H2C_HEAD_V1_8814B(x) ((x) & (~BITS_H2C_HEAD_V1_8814B))
#define BIT_GET_H2C_HEAD_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_H2C_HEAD_V1_8814B) & BIT_MASK_H2C_HEAD_V1_8814B)
#define BIT_SET_H2C_HEAD_V1_8814B(x, v)                                        \
	(BIT_CLEAR_H2C_HEAD_V1_8814B(x) | BIT_H2C_HEAD_V1_8814B(v))

/* 2 REG_H2C_TAIL_8814B */

#define BIT_SHIFT_H2C_TAIL_V1_8814B 0
#define BIT_MASK_H2C_TAIL_V1_8814B 0x7ffff
#define BIT_H2C_TAIL_V1_8814B(x)                                               \
	(((x) & BIT_MASK_H2C_TAIL_V1_8814B) << BIT_SHIFT_H2C_TAIL_V1_8814B)
#define BITS_H2C_TAIL_V1_8814B                                                 \
	(BIT_MASK_H2C_TAIL_V1_8814B << BIT_SHIFT_H2C_TAIL_V1_8814B)
#define BIT_CLEAR_H2C_TAIL_V1_8814B(x) ((x) & (~BITS_H2C_TAIL_V1_8814B))
#define BIT_GET_H2C_TAIL_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_H2C_TAIL_V1_8814B) & BIT_MASK_H2C_TAIL_V1_8814B)
#define BIT_SET_H2C_TAIL_V1_8814B(x, v)                                        \
	(BIT_CLEAR_H2C_TAIL_V1_8814B(x) | BIT_H2C_TAIL_V1_8814B(v))

/* 2 REG_H2C_READ_ADDR_8814B */

#define BIT_SHIFT_H2C_READ_ADDR_V1_8814B 0
#define BIT_MASK_H2C_READ_ADDR_V1_8814B 0x7ffff
#define BIT_H2C_READ_ADDR_V1_8814B(x)                                          \
	(((x) & BIT_MASK_H2C_READ_ADDR_V1_8814B)                               \
	 << BIT_SHIFT_H2C_READ_ADDR_V1_8814B)
#define BITS_H2C_READ_ADDR_V1_8814B                                            \
	(BIT_MASK_H2C_READ_ADDR_V1_8814B << BIT_SHIFT_H2C_READ_ADDR_V1_8814B)
#define BIT_CLEAR_H2C_READ_ADDR_V1_8814B(x)                                    \
	((x) & (~BITS_H2C_READ_ADDR_V1_8814B))
#define BIT_GET_H2C_READ_ADDR_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_H2C_READ_ADDR_V1_8814B) &                           \
	 BIT_MASK_H2C_READ_ADDR_V1_8814B)
#define BIT_SET_H2C_READ_ADDR_V1_8814B(x, v)                                   \
	(BIT_CLEAR_H2C_READ_ADDR_V1_8814B(x) | BIT_H2C_READ_ADDR_V1_8814B(v))

/* 2 REG_H2C_WR_ADDR_8814B */

#define BIT_SHIFT_H2C_WR_ADDR_V1_8814B 0
#define BIT_MASK_H2C_WR_ADDR_V1_8814B 0x7ffff
#define BIT_H2C_WR_ADDR_V1_8814B(x)                                            \
	(((x) & BIT_MASK_H2C_WR_ADDR_V1_8814B)                                 \
	 << BIT_SHIFT_H2C_WR_ADDR_V1_8814B)
#define BITS_H2C_WR_ADDR_V1_8814B                                              \
	(BIT_MASK_H2C_WR_ADDR_V1_8814B << BIT_SHIFT_H2C_WR_ADDR_V1_8814B)
#define BIT_CLEAR_H2C_WR_ADDR_V1_8814B(x) ((x) & (~BITS_H2C_WR_ADDR_V1_8814B))
#define BIT_GET_H2C_WR_ADDR_V1_8814B(x)                                        \
	(((x) >> BIT_SHIFT_H2C_WR_ADDR_V1_8814B) &                             \
	 BIT_MASK_H2C_WR_ADDR_V1_8814B)
#define BIT_SET_H2C_WR_ADDR_V1_8814B(x, v)                                     \
	(BIT_CLEAR_H2C_WR_ADDR_V1_8814B(x) | BIT_H2C_WR_ADDR_V1_8814B(v))

/* 2 REG_H2C_INFO_8814B */
#define BIT_H2C_SPACE_VLD_8814B BIT(3)
#define BIT_H2C_WR_ADDR_RST_8814B BIT(2)

#define BIT_SHIFT_H2C_LEN_SEL_8814B 0
#define BIT_MASK_H2C_LEN_SEL_8814B 0x3
#define BIT_H2C_LEN_SEL_8814B(x)                                               \
	(((x) & BIT_MASK_H2C_LEN_SEL_8814B) << BIT_SHIFT_H2C_LEN_SEL_8814B)
#define BITS_H2C_LEN_SEL_8814B                                                 \
	(BIT_MASK_H2C_LEN_SEL_8814B << BIT_SHIFT_H2C_LEN_SEL_8814B)
#define BIT_CLEAR_H2C_LEN_SEL_8814B(x) ((x) & (~BITS_H2C_LEN_SEL_8814B))
#define BIT_GET_H2C_LEN_SEL_8814B(x)                                           \
	(((x) >> BIT_SHIFT_H2C_LEN_SEL_8814B) & BIT_MASK_H2C_LEN_SEL_8814B)
#define BIT_SET_H2C_LEN_SEL_8814B(x, v)                                        \
	(BIT_CLEAR_H2C_LEN_SEL_8814B(x) | BIT_H2C_LEN_SEL_8814B(v))

/* 2 REG_DMA_OQT_0_8814B */

#define BIT_SHIFT_TX_OQT_12_FREE_SPACE_8814B 24
#define BIT_MASK_TX_OQT_12_FREE_SPACE_8814B 0xff
#define BIT_TX_OQT_12_FREE_SPACE_8814B(x)                                      \
	(((x) & BIT_MASK_TX_OQT_12_FREE_SPACE_8814B)                           \
	 << BIT_SHIFT_TX_OQT_12_FREE_SPACE_8814B)
#define BITS_TX_OQT_12_FREE_SPACE_8814B                                        \
	(BIT_MASK_TX_OQT_12_FREE_SPACE_8814B                                   \
	 << BIT_SHIFT_TX_OQT_12_FREE_SPACE_8814B)
#define BIT_CLEAR_TX_OQT_12_FREE_SPACE_8814B(x)                                \
	((x) & (~BITS_TX_OQT_12_FREE_SPACE_8814B))
#define BIT_GET_TX_OQT_12_FREE_SPACE_8814B(x)                                  \
	(((x) >> BIT_SHIFT_TX_OQT_12_FREE_SPACE_8814B) &                       \
	 BIT_MASK_TX_OQT_12_FREE_SPACE_8814B)
#define BIT_SET_TX_OQT_12_FREE_SPACE_8814B(x, v)                               \
	(BIT_CLEAR_TX_OQT_12_FREE_SPACE_8814B(x) |                             \
	 BIT_TX_OQT_12_FREE_SPACE_8814B(v))

#define BIT_SHIFT_TX_OQT_8_11_FREE_SPACE_8814B 16
#define BIT_MASK_TX_OQT_8_11_FREE_SPACE_8814B 0xff
#define BIT_TX_OQT_8_11_FREE_SPACE_8814B(x)                                    \
	(((x) & BIT_MASK_TX_OQT_8_11_FREE_SPACE_8814B)                         \
	 << BIT_SHIFT_TX_OQT_8_11_FREE_SPACE_8814B)
#define BITS_TX_OQT_8_11_FREE_SPACE_8814B                                      \
	(BIT_MASK_TX_OQT_8_11_FREE_SPACE_8814B                                 \
	 << BIT_SHIFT_TX_OQT_8_11_FREE_SPACE_8814B)
#define BIT_CLEAR_TX_OQT_8_11_FREE_SPACE_8814B(x)                              \
	((x) & (~BITS_TX_OQT_8_11_FREE_SPACE_8814B))
#define BIT_GET_TX_OQT_8_11_FREE_SPACE_8814B(x)                                \
	(((x) >> BIT_SHIFT_TX_OQT_8_11_FREE_SPACE_8814B) &                     \
	 BIT_MASK_TX_OQT_8_11_FREE_SPACE_8814B)
#define BIT_SET_TX_OQT_8_11_FREE_SPACE_8814B(x, v)                             \
	(BIT_CLEAR_TX_OQT_8_11_FREE_SPACE_8814B(x) |                           \
	 BIT_TX_OQT_8_11_FREE_SPACE_8814B(v))

#define BIT_SHIFT_TX_OQT_4_7_FREE_SPACE_8814B 8
#define BIT_MASK_TX_OQT_4_7_FREE_SPACE_8814B 0xff
#define BIT_TX_OQT_4_7_FREE_SPACE_8814B(x)                                     \
	(((x) & BIT_MASK_TX_OQT_4_7_FREE_SPACE_8814B)                          \
	 << BIT_SHIFT_TX_OQT_4_7_FREE_SPACE_8814B)
#define BITS_TX_OQT_4_7_FREE_SPACE_8814B                                       \
	(BIT_MASK_TX_OQT_4_7_FREE_SPACE_8814B                                  \
	 << BIT_SHIFT_TX_OQT_4_7_FREE_SPACE_8814B)
#define BIT_CLEAR_TX_OQT_4_7_FREE_SPACE_8814B(x)                               \
	((x) & (~BITS_TX_OQT_4_7_FREE_SPACE_8814B))
#define BIT_GET_TX_OQT_4_7_FREE_SPACE_8814B(x)                                 \
	(((x) >> BIT_SHIFT_TX_OQT_4_7_FREE_SPACE_8814B) &                      \
	 BIT_MASK_TX_OQT_4_7_FREE_SPACE_8814B)
#define BIT_SET_TX_OQT_4_7_FREE_SPACE_8814B(x, v)                              \
	(BIT_CLEAR_TX_OQT_4_7_FREE_SPACE_8814B(x) |                            \
	 BIT_TX_OQT_4_7_FREE_SPACE_8814B(v))

#define BIT_SHIFT_TX_OQT_0_3_FREE_SPACE_8814B 0
#define BIT_MASK_TX_OQT_0_3_FREE_SPACE_8814B 0xff
#define BIT_TX_OQT_0_3_FREE_SPACE_8814B(x)                                     \
	(((x) & BIT_MASK_TX_OQT_0_3_FREE_SPACE_8814B)                          \
	 << BIT_SHIFT_TX_OQT_0_3_FREE_SPACE_8814B)
#define BITS_TX_OQT_0_3_FREE_SPACE_8814B                                       \
	(BIT_MASK_TX_OQT_0_3_FREE_SPACE_8814B                                  \
	 << BIT_SHIFT_TX_OQT_0_3_FREE_SPACE_8814B)
#define BIT_CLEAR_TX_OQT_0_3_FREE_SPACE_8814B(x)                               \
	((x) & (~BITS_TX_OQT_0_3_FREE_SPACE_8814B))
#define BIT_GET_TX_OQT_0_3_FREE_SPACE_8814B(x)                                 \
	(((x) >> BIT_SHIFT_TX_OQT_0_3_FREE_SPACE_8814B) &                      \
	 BIT_MASK_TX_OQT_0_3_FREE_SPACE_8814B)
#define BIT_SET_TX_OQT_0_3_FREE_SPACE_8814B(x, v)                              \
	(BIT_CLEAR_TX_OQT_0_3_FREE_SPACE_8814B(x) |                            \
	 BIT_TX_OQT_0_3_FREE_SPACE_8814B(v))

/* 2 REG_DMA_OQT_1_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TX_OQT_16_FREE_SPACE_8814B 16
#define BIT_MASK_TX_OQT_16_FREE_SPACE_8814B 0xff
#define BIT_TX_OQT_16_FREE_SPACE_8814B(x)                                      \
	(((x) & BIT_MASK_TX_OQT_16_FREE_SPACE_8814B)                           \
	 << BIT_SHIFT_TX_OQT_16_FREE_SPACE_8814B)
#define BITS_TX_OQT_16_FREE_SPACE_8814B                                        \
	(BIT_MASK_TX_OQT_16_FREE_SPACE_8814B                                   \
	 << BIT_SHIFT_TX_OQT_16_FREE_SPACE_8814B)
#define BIT_CLEAR_TX_OQT_16_FREE_SPACE_8814B(x)                                \
	((x) & (~BITS_TX_OQT_16_FREE_SPACE_8814B))
#define BIT_GET_TX_OQT_16_FREE_SPACE_8814B(x)                                  \
	(((x) >> BIT_SHIFT_TX_OQT_16_FREE_SPACE_8814B) &                       \
	 BIT_MASK_TX_OQT_16_FREE_SPACE_8814B)
#define BIT_SET_TX_OQT_16_FREE_SPACE_8814B(x, v)                               \
	(BIT_CLEAR_TX_OQT_16_FREE_SPACE_8814B(x) |                             \
	 BIT_TX_OQT_16_FREE_SPACE_8814B(v))

#define BIT_SHIFT_TX_OQT_14_15_FREE_SPACE_8814B 8
#define BIT_MASK_TX_OQT_14_15_FREE_SPACE_8814B 0xff
#define BIT_TX_OQT_14_15_FREE_SPACE_8814B(x)                                   \
	(((x) & BIT_MASK_TX_OQT_14_15_FREE_SPACE_8814B)                        \
	 << BIT_SHIFT_TX_OQT_14_15_FREE_SPACE_8814B)
#define BITS_TX_OQT_14_15_FREE_SPACE_8814B                                     \
	(BIT_MASK_TX_OQT_14_15_FREE_SPACE_8814B                                \
	 << BIT_SHIFT_TX_OQT_14_15_FREE_SPACE_8814B)
#define BIT_CLEAR_TX_OQT_14_15_FREE_SPACE_8814B(x)                             \
	((x) & (~BITS_TX_OQT_14_15_FREE_SPACE_8814B))
#define BIT_GET_TX_OQT_14_15_FREE_SPACE_8814B(x)                               \
	(((x) >> BIT_SHIFT_TX_OQT_14_15_FREE_SPACE_8814B) &                    \
	 BIT_MASK_TX_OQT_14_15_FREE_SPACE_8814B)
#define BIT_SET_TX_OQT_14_15_FREE_SPACE_8814B(x, v)                            \
	(BIT_CLEAR_TX_OQT_14_15_FREE_SPACE_8814B(x) |                          \
	 BIT_TX_OQT_14_15_FREE_SPACE_8814B(v))

#define BIT_SHIFT_TX_OQT_13_FREE_SPACE_8814B 0
#define BIT_MASK_TX_OQT_13_FREE_SPACE_8814B 0xff
#define BIT_TX_OQT_13_FREE_SPACE_8814B(x)                                      \
	(((x) & BIT_MASK_TX_OQT_13_FREE_SPACE_8814B)                           \
	 << BIT_SHIFT_TX_OQT_13_FREE_SPACE_8814B)
#define BITS_TX_OQT_13_FREE_SPACE_8814B                                        \
	(BIT_MASK_TX_OQT_13_FREE_SPACE_8814B                                   \
	 << BIT_SHIFT_TX_OQT_13_FREE_SPACE_8814B)
#define BIT_CLEAR_TX_OQT_13_FREE_SPACE_8814B(x)                                \
	((x) & (~BITS_TX_OQT_13_FREE_SPACE_8814B))
#define BIT_GET_TX_OQT_13_FREE_SPACE_8814B(x)                                  \
	(((x) >> BIT_SHIFT_TX_OQT_13_FREE_SPACE_8814B) &                       \
	 BIT_MASK_TX_OQT_13_FREE_SPACE_8814B)
#define BIT_SET_TX_OQT_13_FREE_SPACE_8814B(x, v)                               \
	(BIT_CLEAR_TX_OQT_13_FREE_SPACE_8814B(x) |                             \
	 BIT_TX_OQT_13_FREE_SPACE_8814B(v))

/* 2 REG_RXDMA_AGG_PG_TH_8814B */
#define BIT_DMA_STORE_8814B BIT(31)

/* 2 REG_NOT_VALID_8814B */
#define BIT_EN_PRE_CALC_8814B BIT(29)
#define BIT_RXAGG_SW_EN_8814B BIT(28)
#define BIT_RXAGG_SW_TRIG_8814B BIT(27)

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_DMA_AGG_TO_V1_8814B 8
#define BIT_MASK_DMA_AGG_TO_V1_8814B 0xff
#define BIT_DMA_AGG_TO_V1_8814B(x)                                             \
	(((x) & BIT_MASK_DMA_AGG_TO_V1_8814B) << BIT_SHIFT_DMA_AGG_TO_V1_8814B)
#define BITS_DMA_AGG_TO_V1_8814B                                               \
	(BIT_MASK_DMA_AGG_TO_V1_8814B << BIT_SHIFT_DMA_AGG_TO_V1_8814B)
#define BIT_CLEAR_DMA_AGG_TO_V1_8814B(x) ((x) & (~BITS_DMA_AGG_TO_V1_8814B))
#define BIT_GET_DMA_AGG_TO_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_DMA_AGG_TO_V1_8814B) & BIT_MASK_DMA_AGG_TO_V1_8814B)
#define BIT_SET_DMA_AGG_TO_V1_8814B(x, v)                                      \
	(BIT_CLEAR_DMA_AGG_TO_V1_8814B(x) | BIT_DMA_AGG_TO_V1_8814B(v))

#define BIT_SHIFT_RXDMA_AGG_PG_TH_8814B 0
#define BIT_MASK_RXDMA_AGG_PG_TH_8814B 0xff
#define BIT_RXDMA_AGG_PG_TH_8814B(x)                                           \
	(((x) & BIT_MASK_RXDMA_AGG_PG_TH_8814B)                                \
	 << BIT_SHIFT_RXDMA_AGG_PG_TH_8814B)
#define BITS_RXDMA_AGG_PG_TH_8814B                                             \
	(BIT_MASK_RXDMA_AGG_PG_TH_8814B << BIT_SHIFT_RXDMA_AGG_PG_TH_8814B)
#define BIT_CLEAR_RXDMA_AGG_PG_TH_8814B(x) ((x) & (~BITS_RXDMA_AGG_PG_TH_8814B))
#define BIT_GET_RXDMA_AGG_PG_TH_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RXDMA_AGG_PG_TH_8814B) &                            \
	 BIT_MASK_RXDMA_AGG_PG_TH_8814B)
#define BIT_SET_RXDMA_AGG_PG_TH_8814B(x, v)                                    \
	(BIT_CLEAR_RXDMA_AGG_PG_TH_8814B(x) | BIT_RXDMA_AGG_PG_TH_8814B(v))

/* 2 REG_RXDMA_CTRL_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8814B 20
#define BIT_MASK_FW_UPD_RDPTR19_TO_16_8814B 0xf
#define BIT_FW_UPD_RDPTR19_TO_16_8814B(x)                                      \
	(((x) & BIT_MASK_FW_UPD_RDPTR19_TO_16_8814B)                           \
	 << BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8814B)
#define BITS_FW_UPD_RDPTR19_TO_16_8814B                                        \
	(BIT_MASK_FW_UPD_RDPTR19_TO_16_8814B                                   \
	 << BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8814B)
#define BIT_CLEAR_FW_UPD_RDPTR19_TO_16_8814B(x)                                \
	((x) & (~BITS_FW_UPD_RDPTR19_TO_16_8814B))
#define BIT_GET_FW_UPD_RDPTR19_TO_16_8814B(x)                                  \
	(((x) >> BIT_SHIFT_FW_UPD_RDPTR19_TO_16_8814B) &                       \
	 BIT_MASK_FW_UPD_RDPTR19_TO_16_8814B)
#define BIT_SET_FW_UPD_RDPTR19_TO_16_8814B(x, v)                               \
	(BIT_CLEAR_FW_UPD_RDPTR19_TO_16_8814B(x) |                             \
	 BIT_FW_UPD_RDPTR19_TO_16_8814B(v))

#define BIT_RXDMA_REQ_8814B BIT(19)
#define BIT_RW_RELEASE_EN_8814B BIT(18)
#define BIT_RXDMA_IDLE_8814B BIT(17)
#define BIT_RXPKT_RELEASE_POLL_8814B BIT(16)

#define BIT_SHIFT_FW_UPD_RDPTR_8814B 0
#define BIT_MASK_FW_UPD_RDPTR_8814B 0xffff
#define BIT_FW_UPD_RDPTR_8814B(x)                                              \
	(((x) & BIT_MASK_FW_UPD_RDPTR_8814B) << BIT_SHIFT_FW_UPD_RDPTR_8814B)
#define BITS_FW_UPD_RDPTR_8814B                                                \
	(BIT_MASK_FW_UPD_RDPTR_8814B << BIT_SHIFT_FW_UPD_RDPTR_8814B)
#define BIT_CLEAR_FW_UPD_RDPTR_8814B(x) ((x) & (~BITS_FW_UPD_RDPTR_8814B))
#define BIT_GET_FW_UPD_RDPTR_8814B(x)                                          \
	(((x) >> BIT_SHIFT_FW_UPD_RDPTR_8814B) & BIT_MASK_FW_UPD_RDPTR_8814B)
#define BIT_SET_FW_UPD_RDPTR_8814B(x, v)                                       \
	(BIT_CLEAR_FW_UPD_RDPTR_8814B(x) | BIT_FW_UPD_RDPTR_8814B(v))

/* 2 REG_RXDMA_STATUS_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_C2H_PKT_OVF_8814B BIT(7)
#define BIT_AGG_CONFGI_ISSUE_8814B BIT(6)
#define BIT_FW_POLL_ISSUE_8814B BIT(5)
#define BIT_RX_DATA_UDN_8814B BIT(4)
#define BIT_RX_SFF_UDN_8814B BIT(3)
#define BIT_RX_SFF_OVF_8814B BIT(2)
#define BIT_RXPKT_OVF_8814B BIT(0)

/* 2 REG_RXDMA_DPR_8814B */

#define BIT_SHIFT_RDE_DEBUG_8814B 0
#define BIT_MASK_RDE_DEBUG_8814B 0xffffffffL
#define BIT_RDE_DEBUG_8814B(x)                                                 \
	(((x) & BIT_MASK_RDE_DEBUG_8814B) << BIT_SHIFT_RDE_DEBUG_8814B)
#define BITS_RDE_DEBUG_8814B                                                   \
	(BIT_MASK_RDE_DEBUG_8814B << BIT_SHIFT_RDE_DEBUG_8814B)
#define BIT_CLEAR_RDE_DEBUG_8814B(x) ((x) & (~BITS_RDE_DEBUG_8814B))
#define BIT_GET_RDE_DEBUG_8814B(x)                                             \
	(((x) >> BIT_SHIFT_RDE_DEBUG_8814B) & BIT_MASK_RDE_DEBUG_8814B)
#define BIT_SET_RDE_DEBUG_8814B(x, v)                                          \
	(BIT_CLEAR_RDE_DEBUG_8814B(x) | BIT_RDE_DEBUG_8814B(v))

/* 2 REG_RXDMA_MODE_8814B */

#define BIT_SHIFT_PKTNUM_TH_V2_8814B 24
#define BIT_MASK_PKTNUM_TH_V2_8814B 0x1f
#define BIT_PKTNUM_TH_V2_8814B(x)                                              \
	(((x) & BIT_MASK_PKTNUM_TH_V2_8814B) << BIT_SHIFT_PKTNUM_TH_V2_8814B)
#define BITS_PKTNUM_TH_V2_8814B                                                \
	(BIT_MASK_PKTNUM_TH_V2_8814B << BIT_SHIFT_PKTNUM_TH_V2_8814B)
#define BIT_CLEAR_PKTNUM_TH_V2_8814B(x) ((x) & (~BITS_PKTNUM_TH_V2_8814B))
#define BIT_GET_PKTNUM_TH_V2_8814B(x)                                          \
	(((x) >> BIT_SHIFT_PKTNUM_TH_V2_8814B) & BIT_MASK_PKTNUM_TH_V2_8814B)
#define BIT_SET_PKTNUM_TH_V2_8814B(x, v)                                       \
	(BIT_CLEAR_PKTNUM_TH_V2_8814B(x) | BIT_PKTNUM_TH_V2_8814B(v))

#define BIT_TXBA_BREAK_USBAGG_8814B BIT(23)

#define BIT_SHIFT_PKTLEN_PARA_8814B 16
#define BIT_MASK_PKTLEN_PARA_8814B 0x7
#define BIT_PKTLEN_PARA_8814B(x)                                               \
	(((x) & BIT_MASK_PKTLEN_PARA_8814B) << BIT_SHIFT_PKTLEN_PARA_8814B)
#define BITS_PKTLEN_PARA_8814B                                                 \
	(BIT_MASK_PKTLEN_PARA_8814B << BIT_SHIFT_PKTLEN_PARA_8814B)
#define BIT_CLEAR_PKTLEN_PARA_8814B(x) ((x) & (~BITS_PKTLEN_PARA_8814B))
#define BIT_GET_PKTLEN_PARA_8814B(x)                                           \
	(((x) >> BIT_SHIFT_PKTLEN_PARA_8814B) & BIT_MASK_PKTLEN_PARA_8814B)
#define BIT_SET_PKTLEN_PARA_8814B(x, v)                                        \
	(BIT_CLEAR_PKTLEN_PARA_8814B(x) | BIT_PKTLEN_PARA_8814B(v))

#define BIT_RX_DBG_SEL_8814B BIT(7)
#define BIT_EN_SPD_8814B BIT(6)

#define BIT_SHIFT_BURST_SIZE_8814B 4
#define BIT_MASK_BURST_SIZE_8814B 0x3
#define BIT_BURST_SIZE_8814B(x)                                                \
	(((x) & BIT_MASK_BURST_SIZE_8814B) << BIT_SHIFT_BURST_SIZE_8814B)
#define BITS_BURST_SIZE_8814B                                                  \
	(BIT_MASK_BURST_SIZE_8814B << BIT_SHIFT_BURST_SIZE_8814B)
#define BIT_CLEAR_BURST_SIZE_8814B(x) ((x) & (~BITS_BURST_SIZE_8814B))
#define BIT_GET_BURST_SIZE_8814B(x)                                            \
	(((x) >> BIT_SHIFT_BURST_SIZE_8814B) & BIT_MASK_BURST_SIZE_8814B)
#define BIT_SET_BURST_SIZE_8814B(x, v)                                         \
	(BIT_CLEAR_BURST_SIZE_8814B(x) | BIT_BURST_SIZE_8814B(v))

#define BIT_SHIFT_BURST_CNT_8814B 2
#define BIT_MASK_BURST_CNT_8814B 0x3
#define BIT_BURST_CNT_8814B(x)                                                 \
	(((x) & BIT_MASK_BURST_CNT_8814B) << BIT_SHIFT_BURST_CNT_8814B)
#define BITS_BURST_CNT_8814B                                                   \
	(BIT_MASK_BURST_CNT_8814B << BIT_SHIFT_BURST_CNT_8814B)
#define BIT_CLEAR_BURST_CNT_8814B(x) ((x) & (~BITS_BURST_CNT_8814B))
#define BIT_GET_BURST_CNT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BURST_CNT_8814B) & BIT_MASK_BURST_CNT_8814B)
#define BIT_SET_BURST_CNT_8814B(x, v)                                          \
	(BIT_CLEAR_BURST_CNT_8814B(x) | BIT_BURST_CNT_8814B(v))

#define BIT_DMA_MODE_8814B BIT(1)

/* 2 REG_C2H_PKT_8814B */

#define BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8814B 24
#define BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8814B 0xf
#define BIT_R_C2H_STR_ADDR_16_TO_19_8814B(x)                                   \
	(((x) & BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8814B)                        \
	 << BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8814B)
#define BITS_R_C2H_STR_ADDR_16_TO_19_8814B                                     \
	(BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8814B                                \
	 << BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8814B)
#define BIT_CLEAR_R_C2H_STR_ADDR_16_TO_19_8814B(x)                             \
	((x) & (~BITS_R_C2H_STR_ADDR_16_TO_19_8814B))
#define BIT_GET_R_C2H_STR_ADDR_16_TO_19_8814B(x)                               \
	(((x) >> BIT_SHIFT_R_C2H_STR_ADDR_16_TO_19_8814B) &                    \
	 BIT_MASK_R_C2H_STR_ADDR_16_TO_19_8814B)
#define BIT_SET_R_C2H_STR_ADDR_16_TO_19_8814B(x, v)                            \
	(BIT_CLEAR_R_C2H_STR_ADDR_16_TO_19_8814B(x) |                          \
	 BIT_R_C2H_STR_ADDR_16_TO_19_8814B(v))

#define BIT_R_C2H_PKT_REQ_8814B BIT(16)

#define BIT_SHIFT_R_C2H_STR_ADDR_8814B 0
#define BIT_MASK_R_C2H_STR_ADDR_8814B 0xffff
#define BIT_R_C2H_STR_ADDR_8814B(x)                                            \
	(((x) & BIT_MASK_R_C2H_STR_ADDR_8814B)                                 \
	 << BIT_SHIFT_R_C2H_STR_ADDR_8814B)
#define BITS_R_C2H_STR_ADDR_8814B                                              \
	(BIT_MASK_R_C2H_STR_ADDR_8814B << BIT_SHIFT_R_C2H_STR_ADDR_8814B)
#define BIT_CLEAR_R_C2H_STR_ADDR_8814B(x) ((x) & (~BITS_R_C2H_STR_ADDR_8814B))
#define BIT_GET_R_C2H_STR_ADDR_8814B(x)                                        \
	(((x) >> BIT_SHIFT_R_C2H_STR_ADDR_8814B) &                             \
	 BIT_MASK_R_C2H_STR_ADDR_8814B)
#define BIT_SET_R_C2H_STR_ADDR_8814B(x, v)                                     \
	(BIT_CLEAR_R_C2H_STR_ADDR_8814B(x) | BIT_R_C2H_STR_ADDR_8814B(v))

/* 2 REG_FWFF_C2H_8814B */

#define BIT_SHIFT_C2H_DMA_ADDR_8814B 0
#define BIT_MASK_C2H_DMA_ADDR_8814B 0x3ffff
#define BIT_C2H_DMA_ADDR_8814B(x)                                              \
	(((x) & BIT_MASK_C2H_DMA_ADDR_8814B) << BIT_SHIFT_C2H_DMA_ADDR_8814B)
#define BITS_C2H_DMA_ADDR_8814B                                                \
	(BIT_MASK_C2H_DMA_ADDR_8814B << BIT_SHIFT_C2H_DMA_ADDR_8814B)
#define BIT_CLEAR_C2H_DMA_ADDR_8814B(x) ((x) & (~BITS_C2H_DMA_ADDR_8814B))
#define BIT_GET_C2H_DMA_ADDR_8814B(x)                                          \
	(((x) >> BIT_SHIFT_C2H_DMA_ADDR_8814B) & BIT_MASK_C2H_DMA_ADDR_8814B)
#define BIT_SET_C2H_DMA_ADDR_8814B(x, v)                                       \
	(BIT_CLEAR_C2H_DMA_ADDR_8814B(x) | BIT_C2H_DMA_ADDR_8814B(v))

/* 2 REG_FWFF_CTRL_8814B */
#define BIT_FWFF_DMAPKT_REQ_8814B BIT(31)

#define BIT_SHIFT_FWFF_DMA_PKT_NUM_V1_8814B 16
#define BIT_MASK_FWFF_DMA_PKT_NUM_V1_8814B 0x7fff
#define BIT_FWFF_DMA_PKT_NUM_V1_8814B(x)                                       \
	(((x) & BIT_MASK_FWFF_DMA_PKT_NUM_V1_8814B)                            \
	 << BIT_SHIFT_FWFF_DMA_PKT_NUM_V1_8814B)
#define BITS_FWFF_DMA_PKT_NUM_V1_8814B                                         \
	(BIT_MASK_FWFF_DMA_PKT_NUM_V1_8814B                                    \
	 << BIT_SHIFT_FWFF_DMA_PKT_NUM_V1_8814B)
#define BIT_CLEAR_FWFF_DMA_PKT_NUM_V1_8814B(x)                                 \
	((x) & (~BITS_FWFF_DMA_PKT_NUM_V1_8814B))
#define BIT_GET_FWFF_DMA_PKT_NUM_V1_8814B(x)                                   \
	(((x) >> BIT_SHIFT_FWFF_DMA_PKT_NUM_V1_8814B) &                        \
	 BIT_MASK_FWFF_DMA_PKT_NUM_V1_8814B)
#define BIT_SET_FWFF_DMA_PKT_NUM_V1_8814B(x, v)                                \
	(BIT_CLEAR_FWFF_DMA_PKT_NUM_V1_8814B(x) |                              \
	 BIT_FWFF_DMA_PKT_NUM_V1_8814B(v))

#define BIT_SHIFT_FWFF_STR_ADDR_8814B 0
#define BIT_MASK_FWFF_STR_ADDR_8814B 0xffff
#define BIT_FWFF_STR_ADDR_8814B(x)                                             \
	(((x) & BIT_MASK_FWFF_STR_ADDR_8814B) << BIT_SHIFT_FWFF_STR_ADDR_8814B)
#define BITS_FWFF_STR_ADDR_8814B                                               \
	(BIT_MASK_FWFF_STR_ADDR_8814B << BIT_SHIFT_FWFF_STR_ADDR_8814B)
#define BIT_CLEAR_FWFF_STR_ADDR_8814B(x) ((x) & (~BITS_FWFF_STR_ADDR_8814B))
#define BIT_GET_FWFF_STR_ADDR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_FWFF_STR_ADDR_8814B) & BIT_MASK_FWFF_STR_ADDR_8814B)
#define BIT_SET_FWFF_STR_ADDR_8814B(x, v)                                      \
	(BIT_CLEAR_FWFF_STR_ADDR_8814B(x) | BIT_FWFF_STR_ADDR_8814B(v))

/* 2 REG_FWFF_PKT_INFO_8814B */

#define BIT_SHIFT_FWFF_PKT_READ_ADDR_8814B 16
#define BIT_MASK_FWFF_PKT_READ_ADDR_8814B 0xffff
#define BIT_FWFF_PKT_READ_ADDR_8814B(x)                                        \
	(((x) & BIT_MASK_FWFF_PKT_READ_ADDR_8814B)                             \
	 << BIT_SHIFT_FWFF_PKT_READ_ADDR_8814B)
#define BITS_FWFF_PKT_READ_ADDR_8814B                                          \
	(BIT_MASK_FWFF_PKT_READ_ADDR_8814B                                     \
	 << BIT_SHIFT_FWFF_PKT_READ_ADDR_8814B)
#define BIT_CLEAR_FWFF_PKT_READ_ADDR_8814B(x)                                  \
	((x) & (~BITS_FWFF_PKT_READ_ADDR_8814B))
#define BIT_GET_FWFF_PKT_READ_ADDR_8814B(x)                                    \
	(((x) >> BIT_SHIFT_FWFF_PKT_READ_ADDR_8814B) &                         \
	 BIT_MASK_FWFF_PKT_READ_ADDR_8814B)
#define BIT_SET_FWFF_PKT_READ_ADDR_8814B(x, v)                                 \
	(BIT_CLEAR_FWFF_PKT_READ_ADDR_8814B(x) |                               \
	 BIT_FWFF_PKT_READ_ADDR_8814B(v))

#define BIT_SHIFT_FWFF_PKT_WRITE_ADDR_8814B 0
#define BIT_MASK_FWFF_PKT_WRITE_ADDR_8814B 0xffff
#define BIT_FWFF_PKT_WRITE_ADDR_8814B(x)                                       \
	(((x) & BIT_MASK_FWFF_PKT_WRITE_ADDR_8814B)                            \
	 << BIT_SHIFT_FWFF_PKT_WRITE_ADDR_8814B)
#define BITS_FWFF_PKT_WRITE_ADDR_8814B                                         \
	(BIT_MASK_FWFF_PKT_WRITE_ADDR_8814B                                    \
	 << BIT_SHIFT_FWFF_PKT_WRITE_ADDR_8814B)
#define BIT_CLEAR_FWFF_PKT_WRITE_ADDR_8814B(x)                                 \
	((x) & (~BITS_FWFF_PKT_WRITE_ADDR_8814B))
#define BIT_GET_FWFF_PKT_WRITE_ADDR_8814B(x)                                   \
	(((x) >> BIT_SHIFT_FWFF_PKT_WRITE_ADDR_8814B) &                        \
	 BIT_MASK_FWFF_PKT_WRITE_ADDR_8814B)
#define BIT_SET_FWFF_PKT_WRITE_ADDR_8814B(x, v)                                \
	(BIT_CLEAR_FWFF_PKT_WRITE_ADDR_8814B(x) |                              \
	 BIT_FWFF_PKT_WRITE_ADDR_8814B(v))

/* 2 REG_FWFF_PKT_INFO2_8814B */

#define BIT_SHIFT_FWFF_PKT_QUEUED_V1_8814B 0
#define BIT_MASK_FWFF_PKT_QUEUED_V1_8814B 0xffff
#define BIT_FWFF_PKT_QUEUED_V1_8814B(x)                                        \
	(((x) & BIT_MASK_FWFF_PKT_QUEUED_V1_8814B)                             \
	 << BIT_SHIFT_FWFF_PKT_QUEUED_V1_8814B)
#define BITS_FWFF_PKT_QUEUED_V1_8814B                                          \
	(BIT_MASK_FWFF_PKT_QUEUED_V1_8814B                                     \
	 << BIT_SHIFT_FWFF_PKT_QUEUED_V1_8814B)
#define BIT_CLEAR_FWFF_PKT_QUEUED_V1_8814B(x)                                  \
	((x) & (~BITS_FWFF_PKT_QUEUED_V1_8814B))
#define BIT_GET_FWFF_PKT_QUEUED_V1_8814B(x)                                    \
	(((x) >> BIT_SHIFT_FWFF_PKT_QUEUED_V1_8814B) &                         \
	 BIT_MASK_FWFF_PKT_QUEUED_V1_8814B)
#define BIT_SET_FWFF_PKT_QUEUED_V1_8814B(x, v)                                 \
	(BIT_CLEAR_FWFF_PKT_QUEUED_V1_8814B(x) |                               \
	 BIT_FWFF_PKT_QUEUED_V1_8814B(v))

/* 2 REG_RXPKTNUM_8814B */

#define BIT_SHIFT_PKT_NUM_WOL_V1_8814B 16
#define BIT_MASK_PKT_NUM_WOL_V1_8814B 0xffff
#define BIT_PKT_NUM_WOL_V1_8814B(x)                                            \
	(((x) & BIT_MASK_PKT_NUM_WOL_V1_8814B)                                 \
	 << BIT_SHIFT_PKT_NUM_WOL_V1_8814B)
#define BITS_PKT_NUM_WOL_V1_8814B                                              \
	(BIT_MASK_PKT_NUM_WOL_V1_8814B << BIT_SHIFT_PKT_NUM_WOL_V1_8814B)
#define BIT_CLEAR_PKT_NUM_WOL_V1_8814B(x) ((x) & (~BITS_PKT_NUM_WOL_V1_8814B))
#define BIT_GET_PKT_NUM_WOL_V1_8814B(x)                                        \
	(((x) >> BIT_SHIFT_PKT_NUM_WOL_V1_8814B) &                             \
	 BIT_MASK_PKT_NUM_WOL_V1_8814B)
#define BIT_SET_PKT_NUM_WOL_V1_8814B(x, v)                                     \
	(BIT_CLEAR_PKT_NUM_WOL_V1_8814B(x) | BIT_PKT_NUM_WOL_V1_8814B(v))

#define BIT_SHIFT_RXPKT_NUM_V1_8814B 0
#define BIT_MASK_RXPKT_NUM_V1_8814B 0xffff
#define BIT_RXPKT_NUM_V1_8814B(x)                                              \
	(((x) & BIT_MASK_RXPKT_NUM_V1_8814B) << BIT_SHIFT_RXPKT_NUM_V1_8814B)
#define BITS_RXPKT_NUM_V1_8814B                                                \
	(BIT_MASK_RXPKT_NUM_V1_8814B << BIT_SHIFT_RXPKT_NUM_V1_8814B)
#define BIT_CLEAR_RXPKT_NUM_V1_8814B(x) ((x) & (~BITS_RXPKT_NUM_V1_8814B))
#define BIT_GET_RXPKT_NUM_V1_8814B(x)                                          \
	(((x) >> BIT_SHIFT_RXPKT_NUM_V1_8814B) & BIT_MASK_RXPKT_NUM_V1_8814B)
#define BIT_SET_RXPKT_NUM_V1_8814B(x, v)                                       \
	(BIT_CLEAR_RXPKT_NUM_V1_8814B(x) | BIT_RXPKT_NUM_V1_8814B(v))

/* 2 REG_RXPKTNUM_TH_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_RXPKT_NUM_TH_8814B 0
#define BIT_MASK_RXPKT_NUM_TH_8814B 0xff
#define BIT_RXPKT_NUM_TH_8814B(x)                                              \
	(((x) & BIT_MASK_RXPKT_NUM_TH_8814B) << BIT_SHIFT_RXPKT_NUM_TH_8814B)
#define BITS_RXPKT_NUM_TH_8814B                                                \
	(BIT_MASK_RXPKT_NUM_TH_8814B << BIT_SHIFT_RXPKT_NUM_TH_8814B)
#define BIT_CLEAR_RXPKT_NUM_TH_8814B(x) ((x) & (~BITS_RXPKT_NUM_TH_8814B))
#define BIT_GET_RXPKT_NUM_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_RXPKT_NUM_TH_8814B) & BIT_MASK_RXPKT_NUM_TH_8814B)
#define BIT_SET_RXPKT_NUM_TH_8814B(x, v)                                       \
	(BIT_CLEAR_RXPKT_NUM_TH_8814B(x) | BIT_RXPKT_NUM_TH_8814B(v))

/* 2 REG_FW_UPD_RXDES_RDPTR_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_FW_UPD_RXDES_RD_PTR_8814B 0
#define BIT_MASK_FW_UPD_RXDES_RD_PTR_8814B 0x3ffff
#define BIT_FW_UPD_RXDES_RD_PTR_8814B(x)                                       \
	(((x) & BIT_MASK_FW_UPD_RXDES_RD_PTR_8814B)                            \
	 << BIT_SHIFT_FW_UPD_RXDES_RD_PTR_8814B)
#define BITS_FW_UPD_RXDES_RD_PTR_8814B                                         \
	(BIT_MASK_FW_UPD_RXDES_RD_PTR_8814B                                    \
	 << BIT_SHIFT_FW_UPD_RXDES_RD_PTR_8814B)
#define BIT_CLEAR_FW_UPD_RXDES_RD_PTR_8814B(x)                                 \
	((x) & (~BITS_FW_UPD_RXDES_RD_PTR_8814B))
#define BIT_GET_FW_UPD_RXDES_RD_PTR_8814B(x)                                   \
	(((x) >> BIT_SHIFT_FW_UPD_RXDES_RD_PTR_8814B) &                        \
	 BIT_MASK_FW_UPD_RXDES_RD_PTR_8814B)
#define BIT_SET_FW_UPD_RXDES_RD_PTR_8814B(x, v)                                \
	(BIT_CLEAR_FW_UPD_RXDES_RD_PTR_8814B(x) |                              \
	 BIT_FW_UPD_RXDES_RD_PTR_8814B(v))

/* 2 REG_DDMA_CH0SA_8814B */

#define BIT_SHIFT_DDMACH0_SA_8814B 0
#define BIT_MASK_DDMACH0_SA_8814B 0xffffffffL
#define BIT_DDMACH0_SA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH0_SA_8814B) << BIT_SHIFT_DDMACH0_SA_8814B)
#define BITS_DDMACH0_SA_8814B                                                  \
	(BIT_MASK_DDMACH0_SA_8814B << BIT_SHIFT_DDMACH0_SA_8814B)
#define BIT_CLEAR_DDMACH0_SA_8814B(x) ((x) & (~BITS_DDMACH0_SA_8814B))
#define BIT_GET_DDMACH0_SA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH0_SA_8814B) & BIT_MASK_DDMACH0_SA_8814B)
#define BIT_SET_DDMACH0_SA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH0_SA_8814B(x) | BIT_DDMACH0_SA_8814B(v))

/* 2 REG_DDMA_CH0DA_8814B */

#define BIT_SHIFT_DDMACH0_DA_8814B 0
#define BIT_MASK_DDMACH0_DA_8814B 0xffffffffL
#define BIT_DDMACH0_DA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH0_DA_8814B) << BIT_SHIFT_DDMACH0_DA_8814B)
#define BITS_DDMACH0_DA_8814B                                                  \
	(BIT_MASK_DDMACH0_DA_8814B << BIT_SHIFT_DDMACH0_DA_8814B)
#define BIT_CLEAR_DDMACH0_DA_8814B(x) ((x) & (~BITS_DDMACH0_DA_8814B))
#define BIT_GET_DDMACH0_DA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH0_DA_8814B) & BIT_MASK_DDMACH0_DA_8814B)
#define BIT_SET_DDMACH0_DA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH0_DA_8814B(x) | BIT_DDMACH0_DA_8814B(v))

/* 2 REG_DDMA_CH0CTRL_8814B */
#define BIT_DDMACH0_OWN_8814B BIT(31)
#define BIT_DDMACH0_IDMEM_ERR_8814B BIT(30)
#define BIT_DDMACH0_CHKSUM_EN_8814B BIT(29)
#define BIT_DDMACH0_DA_W_DISABLE_8814B BIT(28)
#define BIT_DDMACH0_CHKSUM_STS_8814B BIT(27)
#define BIT_DDMACH0_DDMA_MODE_8814B BIT(26)
#define BIT_DDMACH0_RESET_CHKSUM_STS_8814B BIT(25)
#define BIT_DDMACH0_CHKSUM_CONT_8814B BIT(24)

#define BIT_SHIFT_DDMACH0_DLEN_8814B 0
#define BIT_MASK_DDMACH0_DLEN_8814B 0x3ffff
#define BIT_DDMACH0_DLEN_8814B(x)                                              \
	(((x) & BIT_MASK_DDMACH0_DLEN_8814B) << BIT_SHIFT_DDMACH0_DLEN_8814B)
#define BITS_DDMACH0_DLEN_8814B                                                \
	(BIT_MASK_DDMACH0_DLEN_8814B << BIT_SHIFT_DDMACH0_DLEN_8814B)
#define BIT_CLEAR_DDMACH0_DLEN_8814B(x) ((x) & (~BITS_DDMACH0_DLEN_8814B))
#define BIT_GET_DDMACH0_DLEN_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH0_DLEN_8814B) & BIT_MASK_DDMACH0_DLEN_8814B)
#define BIT_SET_DDMACH0_DLEN_8814B(x, v)                                       \
	(BIT_CLEAR_DDMACH0_DLEN_8814B(x) | BIT_DDMACH0_DLEN_8814B(v))

/* 2 REG_DDMA_CH1SA_8814B */

#define BIT_SHIFT_DDMACH1_SA_8814B 0
#define BIT_MASK_DDMACH1_SA_8814B 0xffffffffL
#define BIT_DDMACH1_SA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH1_SA_8814B) << BIT_SHIFT_DDMACH1_SA_8814B)
#define BITS_DDMACH1_SA_8814B                                                  \
	(BIT_MASK_DDMACH1_SA_8814B << BIT_SHIFT_DDMACH1_SA_8814B)
#define BIT_CLEAR_DDMACH1_SA_8814B(x) ((x) & (~BITS_DDMACH1_SA_8814B))
#define BIT_GET_DDMACH1_SA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH1_SA_8814B) & BIT_MASK_DDMACH1_SA_8814B)
#define BIT_SET_DDMACH1_SA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH1_SA_8814B(x) | BIT_DDMACH1_SA_8814B(v))

/* 2 REG_DDMA_CH1DA_8814B */

#define BIT_SHIFT_DDMACH1_DA_8814B 0
#define BIT_MASK_DDMACH1_DA_8814B 0xffffffffL
#define BIT_DDMACH1_DA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH1_DA_8814B) << BIT_SHIFT_DDMACH1_DA_8814B)
#define BITS_DDMACH1_DA_8814B                                                  \
	(BIT_MASK_DDMACH1_DA_8814B << BIT_SHIFT_DDMACH1_DA_8814B)
#define BIT_CLEAR_DDMACH1_DA_8814B(x) ((x) & (~BITS_DDMACH1_DA_8814B))
#define BIT_GET_DDMACH1_DA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH1_DA_8814B) & BIT_MASK_DDMACH1_DA_8814B)
#define BIT_SET_DDMACH1_DA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH1_DA_8814B(x) | BIT_DDMACH1_DA_8814B(v))

/* 2 REG_DDMA_CH1CTRL_8814B */
#define BIT_DDMACH1_OWN_8814B BIT(31)
#define BIT_DDMACH1_IDMEM_ERR_8814B BIT(30)
#define BIT_DDMACH1_CHKSUM_EN_8814B BIT(29)
#define BIT_DDMACH1_DA_W_DISABLE_8814B BIT(28)
#define BIT_DDMACH1_CHKSUM_STS_8814B BIT(27)
#define BIT_DDMACH1_DDMA_MODE_8814B BIT(26)
#define BIT_DDMACH1_RESET_CHKSUM_STS_8814B BIT(25)
#define BIT_DDMACH1_CHKSUM_CONT_8814B BIT(24)

#define BIT_SHIFT_DDMACH1_DLEN_8814B 0
#define BIT_MASK_DDMACH1_DLEN_8814B 0x3ffff
#define BIT_DDMACH1_DLEN_8814B(x)                                              \
	(((x) & BIT_MASK_DDMACH1_DLEN_8814B) << BIT_SHIFT_DDMACH1_DLEN_8814B)
#define BITS_DDMACH1_DLEN_8814B                                                \
	(BIT_MASK_DDMACH1_DLEN_8814B << BIT_SHIFT_DDMACH1_DLEN_8814B)
#define BIT_CLEAR_DDMACH1_DLEN_8814B(x) ((x) & (~BITS_DDMACH1_DLEN_8814B))
#define BIT_GET_DDMACH1_DLEN_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH1_DLEN_8814B) & BIT_MASK_DDMACH1_DLEN_8814B)
#define BIT_SET_DDMACH1_DLEN_8814B(x, v)                                       \
	(BIT_CLEAR_DDMACH1_DLEN_8814B(x) | BIT_DDMACH1_DLEN_8814B(v))

/* 2 REG_DDMA_CH2SA_8814B */

#define BIT_SHIFT_DDMACH2_SA_8814B 0
#define BIT_MASK_DDMACH2_SA_8814B 0xffffffffL
#define BIT_DDMACH2_SA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH2_SA_8814B) << BIT_SHIFT_DDMACH2_SA_8814B)
#define BITS_DDMACH2_SA_8814B                                                  \
	(BIT_MASK_DDMACH2_SA_8814B << BIT_SHIFT_DDMACH2_SA_8814B)
#define BIT_CLEAR_DDMACH2_SA_8814B(x) ((x) & (~BITS_DDMACH2_SA_8814B))
#define BIT_GET_DDMACH2_SA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH2_SA_8814B) & BIT_MASK_DDMACH2_SA_8814B)
#define BIT_SET_DDMACH2_SA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH2_SA_8814B(x) | BIT_DDMACH2_SA_8814B(v))

/* 2 REG_DDMA_CH2DA_8814B */

#define BIT_SHIFT_DDMACH2_DA_8814B 0
#define BIT_MASK_DDMACH2_DA_8814B 0xffffffffL
#define BIT_DDMACH2_DA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH2_DA_8814B) << BIT_SHIFT_DDMACH2_DA_8814B)
#define BITS_DDMACH2_DA_8814B                                                  \
	(BIT_MASK_DDMACH2_DA_8814B << BIT_SHIFT_DDMACH2_DA_8814B)
#define BIT_CLEAR_DDMACH2_DA_8814B(x) ((x) & (~BITS_DDMACH2_DA_8814B))
#define BIT_GET_DDMACH2_DA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH2_DA_8814B) & BIT_MASK_DDMACH2_DA_8814B)
#define BIT_SET_DDMACH2_DA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH2_DA_8814B(x) | BIT_DDMACH2_DA_8814B(v))

/* 2 REG_DDMA_CH2CTRL_8814B */
#define BIT_DDMACH2_OWN_8814B BIT(31)
#define BIT_DDMACH2_IDMEM_ERR_8814B BIT(30)
#define BIT_DDMACH2_CHKSUM_EN_8814B BIT(29)
#define BIT_DDMACH2_DA_W_DISABLE_8814B BIT(28)
#define BIT_DDMACH2_CHKSUM_STS_8814B BIT(27)
#define BIT_DDMACH2_DDMA_MODE_8814B BIT(26)
#define BIT_DDMACH2_RESET_CHKSUM_STS_8814B BIT(25)
#define BIT_DDMACH2_CHKSUM_CONT_8814B BIT(24)

#define BIT_SHIFT_DDMACH2_DLEN_8814B 0
#define BIT_MASK_DDMACH2_DLEN_8814B 0x3ffff
#define BIT_DDMACH2_DLEN_8814B(x)                                              \
	(((x) & BIT_MASK_DDMACH2_DLEN_8814B) << BIT_SHIFT_DDMACH2_DLEN_8814B)
#define BITS_DDMACH2_DLEN_8814B                                                \
	(BIT_MASK_DDMACH2_DLEN_8814B << BIT_SHIFT_DDMACH2_DLEN_8814B)
#define BIT_CLEAR_DDMACH2_DLEN_8814B(x) ((x) & (~BITS_DDMACH2_DLEN_8814B))
#define BIT_GET_DDMACH2_DLEN_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH2_DLEN_8814B) & BIT_MASK_DDMACH2_DLEN_8814B)
#define BIT_SET_DDMACH2_DLEN_8814B(x, v)                                       \
	(BIT_CLEAR_DDMACH2_DLEN_8814B(x) | BIT_DDMACH2_DLEN_8814B(v))

/* 2 REG_DDMA_CH3SA_8814B */

#define BIT_SHIFT_DDMACH3_SA_8814B 0
#define BIT_MASK_DDMACH3_SA_8814B 0xffffffffL
#define BIT_DDMACH3_SA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH3_SA_8814B) << BIT_SHIFT_DDMACH3_SA_8814B)
#define BITS_DDMACH3_SA_8814B                                                  \
	(BIT_MASK_DDMACH3_SA_8814B << BIT_SHIFT_DDMACH3_SA_8814B)
#define BIT_CLEAR_DDMACH3_SA_8814B(x) ((x) & (~BITS_DDMACH3_SA_8814B))
#define BIT_GET_DDMACH3_SA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH3_SA_8814B) & BIT_MASK_DDMACH3_SA_8814B)
#define BIT_SET_DDMACH3_SA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH3_SA_8814B(x) | BIT_DDMACH3_SA_8814B(v))

/* 2 REG_DDMA_CH3DA_8814B */

#define BIT_SHIFT_DDMACH3_DA_8814B 0
#define BIT_MASK_DDMACH3_DA_8814B 0xffffffffL
#define BIT_DDMACH3_DA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH3_DA_8814B) << BIT_SHIFT_DDMACH3_DA_8814B)
#define BITS_DDMACH3_DA_8814B                                                  \
	(BIT_MASK_DDMACH3_DA_8814B << BIT_SHIFT_DDMACH3_DA_8814B)
#define BIT_CLEAR_DDMACH3_DA_8814B(x) ((x) & (~BITS_DDMACH3_DA_8814B))
#define BIT_GET_DDMACH3_DA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH3_DA_8814B) & BIT_MASK_DDMACH3_DA_8814B)
#define BIT_SET_DDMACH3_DA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH3_DA_8814B(x) | BIT_DDMACH3_DA_8814B(v))

/* 2 REG_DDMA_CH3CTRL_8814B */
#define BIT_DDMACH3_OWN_8814B BIT(31)
#define BIT_DDMACH3_IDMEM_ERR_8814B BIT(30)
#define BIT_DDMACH3_CHKSUM_EN_8814B BIT(29)
#define BIT_DDMACH3_DA_W_DISABLE_8814B BIT(28)
#define BIT_DDMACH3_CHKSUM_STS_8814B BIT(27)
#define BIT_DDMACH3_DDMA_MODE_8814B BIT(26)
#define BIT_DDMACH3_RESET_CHKSUM_STS_8814B BIT(25)
#define BIT_DDMACH3_CHKSUM_CONT_8814B BIT(24)

#define BIT_SHIFT_DDMACH3_DLEN_8814B 0
#define BIT_MASK_DDMACH3_DLEN_8814B 0x3ffff
#define BIT_DDMACH3_DLEN_8814B(x)                                              \
	(((x) & BIT_MASK_DDMACH3_DLEN_8814B) << BIT_SHIFT_DDMACH3_DLEN_8814B)
#define BITS_DDMACH3_DLEN_8814B                                                \
	(BIT_MASK_DDMACH3_DLEN_8814B << BIT_SHIFT_DDMACH3_DLEN_8814B)
#define BIT_CLEAR_DDMACH3_DLEN_8814B(x) ((x) & (~BITS_DDMACH3_DLEN_8814B))
#define BIT_GET_DDMACH3_DLEN_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH3_DLEN_8814B) & BIT_MASK_DDMACH3_DLEN_8814B)
#define BIT_SET_DDMACH3_DLEN_8814B(x, v)                                       \
	(BIT_CLEAR_DDMACH3_DLEN_8814B(x) | BIT_DDMACH3_DLEN_8814B(v))

/* 2 REG_DDMA_CH4SA_8814B */

#define BIT_SHIFT_DDMACH4_SA_8814B 0
#define BIT_MASK_DDMACH4_SA_8814B 0xffffffffL
#define BIT_DDMACH4_SA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH4_SA_8814B) << BIT_SHIFT_DDMACH4_SA_8814B)
#define BITS_DDMACH4_SA_8814B                                                  \
	(BIT_MASK_DDMACH4_SA_8814B << BIT_SHIFT_DDMACH4_SA_8814B)
#define BIT_CLEAR_DDMACH4_SA_8814B(x) ((x) & (~BITS_DDMACH4_SA_8814B))
#define BIT_GET_DDMACH4_SA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH4_SA_8814B) & BIT_MASK_DDMACH4_SA_8814B)
#define BIT_SET_DDMACH4_SA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH4_SA_8814B(x) | BIT_DDMACH4_SA_8814B(v))

/* 2 REG_DDMA_CH4DA_8814B */

#define BIT_SHIFT_DDMACH4_DA_8814B 0
#define BIT_MASK_DDMACH4_DA_8814B 0xffffffffL
#define BIT_DDMACH4_DA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH4_DA_8814B) << BIT_SHIFT_DDMACH4_DA_8814B)
#define BITS_DDMACH4_DA_8814B                                                  \
	(BIT_MASK_DDMACH4_DA_8814B << BIT_SHIFT_DDMACH4_DA_8814B)
#define BIT_CLEAR_DDMACH4_DA_8814B(x) ((x) & (~BITS_DDMACH4_DA_8814B))
#define BIT_GET_DDMACH4_DA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH4_DA_8814B) & BIT_MASK_DDMACH4_DA_8814B)
#define BIT_SET_DDMACH4_DA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH4_DA_8814B(x) | BIT_DDMACH4_DA_8814B(v))

/* 2 REG_DDMA_CH4CTRL_8814B */
#define BIT_DDMACH4_OWN_8814B BIT(31)
#define BIT_DDMACH4_IDMEM_ERR_8814B BIT(30)
#define BIT_DDMACH4_CHKSUM_EN_8814B BIT(29)
#define BIT_DDMACH4_DA_W_DISABLE_8814B BIT(28)
#define BIT_DDMACH4_CHKSUM_STS_8814B BIT(27)
#define BIT_DDMACH4_DDMA_MODE_8814B BIT(26)
#define BIT_DDMACH4_RESET_CHKSUM_STS_8814B BIT(25)
#define BIT_DDMACH4_CHKSUM_CONT_8814B BIT(24)

#define BIT_SHIFT_DDMACH4_DLEN_8814B 0
#define BIT_MASK_DDMACH4_DLEN_8814B 0x3ffff
#define BIT_DDMACH4_DLEN_8814B(x)                                              \
	(((x) & BIT_MASK_DDMACH4_DLEN_8814B) << BIT_SHIFT_DDMACH4_DLEN_8814B)
#define BITS_DDMACH4_DLEN_8814B                                                \
	(BIT_MASK_DDMACH4_DLEN_8814B << BIT_SHIFT_DDMACH4_DLEN_8814B)
#define BIT_CLEAR_DDMACH4_DLEN_8814B(x) ((x) & (~BITS_DDMACH4_DLEN_8814B))
#define BIT_GET_DDMACH4_DLEN_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH4_DLEN_8814B) & BIT_MASK_DDMACH4_DLEN_8814B)
#define BIT_SET_DDMACH4_DLEN_8814B(x, v)                                       \
	(BIT_CLEAR_DDMACH4_DLEN_8814B(x) | BIT_DDMACH4_DLEN_8814B(v))

/* 2 REG_DDMA_CH5SA_8814B */

#define BIT_SHIFT_DDMACH5_SA_8814B 0
#define BIT_MASK_DDMACH5_SA_8814B 0xffffffffL
#define BIT_DDMACH5_SA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH5_SA_8814B) << BIT_SHIFT_DDMACH5_SA_8814B)
#define BITS_DDMACH5_SA_8814B                                                  \
	(BIT_MASK_DDMACH5_SA_8814B << BIT_SHIFT_DDMACH5_SA_8814B)
#define BIT_CLEAR_DDMACH5_SA_8814B(x) ((x) & (~BITS_DDMACH5_SA_8814B))
#define BIT_GET_DDMACH5_SA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH5_SA_8814B) & BIT_MASK_DDMACH5_SA_8814B)
#define BIT_SET_DDMACH5_SA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH5_SA_8814B(x) | BIT_DDMACH5_SA_8814B(v))

/* 2 REG_DDMA_CH5DA_8814B */

#define BIT_SHIFT_DDMACH5_DA_8814B 0
#define BIT_MASK_DDMACH5_DA_8814B 0xffffffffL
#define BIT_DDMACH5_DA_8814B(x)                                                \
	(((x) & BIT_MASK_DDMACH5_DA_8814B) << BIT_SHIFT_DDMACH5_DA_8814B)
#define BITS_DDMACH5_DA_8814B                                                  \
	(BIT_MASK_DDMACH5_DA_8814B << BIT_SHIFT_DDMACH5_DA_8814B)
#define BIT_CLEAR_DDMACH5_DA_8814B(x) ((x) & (~BITS_DDMACH5_DA_8814B))
#define BIT_GET_DDMACH5_DA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DDMACH5_DA_8814B) & BIT_MASK_DDMACH5_DA_8814B)
#define BIT_SET_DDMACH5_DA_8814B(x, v)                                         \
	(BIT_CLEAR_DDMACH5_DA_8814B(x) | BIT_DDMACH5_DA_8814B(v))

/* 2 REG_DDMA_CH5CTRL_8814B */
#define BIT_DDMACH5_OWN_8814B BIT(31)
#define BIT_DDMACH5_IDMEM_ERR_8814B BIT(30)
#define BIT_DDMACH5_CHKSUM_EN_8814B BIT(29)
#define BIT_DDMACH5_DA_W_DISABLE_8814B BIT(28)
#define BIT_DDMACH5_CHKSUM_STS_8814B BIT(27)
#define BIT_DDMACH5_DDMA_MODE_8814B BIT(26)
#define BIT_DDMACH5_RESET_CHKSUM_STS_8814B BIT(25)
#define BIT_DDMACH5_CHKSUM_CONT_8814B BIT(24)

#define BIT_SHIFT_DDMACH5_DLEN_8814B 0
#define BIT_MASK_DDMACH5_DLEN_8814B 0x3ffff
#define BIT_DDMACH5_DLEN_8814B(x)                                              \
	(((x) & BIT_MASK_DDMACH5_DLEN_8814B) << BIT_SHIFT_DDMACH5_DLEN_8814B)
#define BITS_DDMACH5_DLEN_8814B                                                \
	(BIT_MASK_DDMACH5_DLEN_8814B << BIT_SHIFT_DDMACH5_DLEN_8814B)
#define BIT_CLEAR_DDMACH5_DLEN_8814B(x) ((x) & (~BITS_DDMACH5_DLEN_8814B))
#define BIT_GET_DDMACH5_DLEN_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DDMACH5_DLEN_8814B) & BIT_MASK_DDMACH5_DLEN_8814B)
#define BIT_SET_DDMACH5_DLEN_8814B(x, v)                                       \
	(BIT_CLEAR_DDMACH5_DLEN_8814B(x) | BIT_DDMACH5_DLEN_8814B(v))

/* 2 REG_DDMA_INT_MSK_8814B */
#define BIT_DDMACH5_MSK_8814B BIT(5)
#define BIT_DDMACH4_MSK_8814B BIT(4)
#define BIT_DDMACH3_MSK_8814B BIT(3)
#define BIT_DDMACH2_MSK_8814B BIT(2)
#define BIT_DDMACH1_MSK_8814B BIT(1)
#define BIT_DDMACH0_MSK_8814B BIT(0)

/* 2 REG_DDMA_CHSTATUS_8814B */
#define BIT_DDMACH5_BUSY_8814B BIT(5)
#define BIT_DDMACH4_BUSY_8814B BIT(4)
#define BIT_DDMACH3_BUSY_8814B BIT(3)
#define BIT_DDMACH2_BUSY_8814B BIT(2)
#define BIT_DDMACH1_BUSY_8814B BIT(1)
#define BIT_DDMACH0_BUSY_8814B BIT(0)

/* 2 REG_DDMA_CHKSUM_8814B */

#define BIT_SHIFT_IDDMA0_CHKSUM_8814B 0
#define BIT_MASK_IDDMA0_CHKSUM_8814B 0xffff
#define BIT_IDDMA0_CHKSUM_8814B(x)                                             \
	(((x) & BIT_MASK_IDDMA0_CHKSUM_8814B) << BIT_SHIFT_IDDMA0_CHKSUM_8814B)
#define BITS_IDDMA0_CHKSUM_8814B                                               \
	(BIT_MASK_IDDMA0_CHKSUM_8814B << BIT_SHIFT_IDDMA0_CHKSUM_8814B)
#define BIT_CLEAR_IDDMA0_CHKSUM_8814B(x) ((x) & (~BITS_IDDMA0_CHKSUM_8814B))
#define BIT_GET_IDDMA0_CHKSUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_IDDMA0_CHKSUM_8814B) & BIT_MASK_IDDMA0_CHKSUM_8814B)
#define BIT_SET_IDDMA0_CHKSUM_8814B(x, v)                                      \
	(BIT_CLEAR_IDDMA0_CHKSUM_8814B(x) | BIT_IDDMA0_CHKSUM_8814B(v))

/* 2 REG_DDMA_MONITOR_8814B */
#define BIT_IDDMA0_PERMU_UNDERFLOW_8814B BIT(14)
#define BIT_IDDMA0_FIFO_UNDERFLOW_8814B BIT(13)
#define BIT_IDDMA0_FIFO_OVERFLOW_8814B BIT(12)
#define BIT_CH5_ERR_8814B BIT(5)
#define BIT_CH4_ERR_8814B BIT(4)
#define BIT_CH3_ERR_8814B BIT(3)
#define BIT_CH2_ERR_8814B BIT(2)
#define BIT_CH1_ERR_8814B BIT(1)
#define BIT_CH0_ERR_8814B BIT(0)

/* 2 REG_DMA_RQPN_INFO_0_8814B */

#define BIT_SHIFT_CH0_AVAL_PG_8814B 16
#define BIT_MASK_CH0_AVAL_PG_8814B 0xfff
#define BIT_CH0_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH0_AVAL_PG_8814B) << BIT_SHIFT_CH0_AVAL_PG_8814B)
#define BITS_CH0_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH0_AVAL_PG_8814B << BIT_SHIFT_CH0_AVAL_PG_8814B)
#define BIT_CLEAR_CH0_AVAL_PG_8814B(x) ((x) & (~BITS_CH0_AVAL_PG_8814B))
#define BIT_GET_CH0_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH0_AVAL_PG_8814B) & BIT_MASK_CH0_AVAL_PG_8814B)
#define BIT_SET_CH0_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH0_AVAL_PG_8814B(x) | BIT_CH0_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH0_RSVD_PG_8814B 0
#define BIT_MASK_CH0_RSVD_PG_8814B 0xfff
#define BIT_CH0_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH0_RSVD_PG_8814B) << BIT_SHIFT_CH0_RSVD_PG_8814B)
#define BITS_CH0_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH0_RSVD_PG_8814B << BIT_SHIFT_CH0_RSVD_PG_8814B)
#define BIT_CLEAR_CH0_RSVD_PG_8814B(x) ((x) & (~BITS_CH0_RSVD_PG_8814B))
#define BIT_GET_CH0_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH0_RSVD_PG_8814B) & BIT_MASK_CH0_RSVD_PG_8814B)
#define BIT_SET_CH0_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH0_RSVD_PG_8814B(x) | BIT_CH0_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_1_8814B */

#define BIT_SHIFT_CH1_AVAL_PG_8814B 16
#define BIT_MASK_CH1_AVAL_PG_8814B 0xfff
#define BIT_CH1_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH1_AVAL_PG_8814B) << BIT_SHIFT_CH1_AVAL_PG_8814B)
#define BITS_CH1_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH1_AVAL_PG_8814B << BIT_SHIFT_CH1_AVAL_PG_8814B)
#define BIT_CLEAR_CH1_AVAL_PG_8814B(x) ((x) & (~BITS_CH1_AVAL_PG_8814B))
#define BIT_GET_CH1_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH1_AVAL_PG_8814B) & BIT_MASK_CH1_AVAL_PG_8814B)
#define BIT_SET_CH1_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH1_AVAL_PG_8814B(x) | BIT_CH1_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH1_RSVD_PG_8814B 0
#define BIT_MASK_CH1_RSVD_PG_8814B 0xfff
#define BIT_CH1_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH1_RSVD_PG_8814B) << BIT_SHIFT_CH1_RSVD_PG_8814B)
#define BITS_CH1_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH1_RSVD_PG_8814B << BIT_SHIFT_CH1_RSVD_PG_8814B)
#define BIT_CLEAR_CH1_RSVD_PG_8814B(x) ((x) & (~BITS_CH1_RSVD_PG_8814B))
#define BIT_GET_CH1_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH1_RSVD_PG_8814B) & BIT_MASK_CH1_RSVD_PG_8814B)
#define BIT_SET_CH1_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH1_RSVD_PG_8814B(x) | BIT_CH1_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_2_8814B */

#define BIT_SHIFT_CH2_AVAL_PG_8814B 16
#define BIT_MASK_CH2_AVAL_PG_8814B 0xfff
#define BIT_CH2_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH2_AVAL_PG_8814B) << BIT_SHIFT_CH2_AVAL_PG_8814B)
#define BITS_CH2_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH2_AVAL_PG_8814B << BIT_SHIFT_CH2_AVAL_PG_8814B)
#define BIT_CLEAR_CH2_AVAL_PG_8814B(x) ((x) & (~BITS_CH2_AVAL_PG_8814B))
#define BIT_GET_CH2_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH2_AVAL_PG_8814B) & BIT_MASK_CH2_AVAL_PG_8814B)
#define BIT_SET_CH2_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH2_AVAL_PG_8814B(x) | BIT_CH2_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH2_RSVD_PG_8814B 0
#define BIT_MASK_CH2_RSVD_PG_8814B 0xfff
#define BIT_CH2_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH2_RSVD_PG_8814B) << BIT_SHIFT_CH2_RSVD_PG_8814B)
#define BITS_CH2_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH2_RSVD_PG_8814B << BIT_SHIFT_CH2_RSVD_PG_8814B)
#define BIT_CLEAR_CH2_RSVD_PG_8814B(x) ((x) & (~BITS_CH2_RSVD_PG_8814B))
#define BIT_GET_CH2_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH2_RSVD_PG_8814B) & BIT_MASK_CH2_RSVD_PG_8814B)
#define BIT_SET_CH2_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH2_RSVD_PG_8814B(x) | BIT_CH2_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_3_8814B */

#define BIT_SHIFT_CH3_AVAL_PG_8814B 16
#define BIT_MASK_CH3_AVAL_PG_8814B 0xfff
#define BIT_CH3_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH3_AVAL_PG_8814B) << BIT_SHIFT_CH3_AVAL_PG_8814B)
#define BITS_CH3_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH3_AVAL_PG_8814B << BIT_SHIFT_CH3_AVAL_PG_8814B)
#define BIT_CLEAR_CH3_AVAL_PG_8814B(x) ((x) & (~BITS_CH3_AVAL_PG_8814B))
#define BIT_GET_CH3_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH3_AVAL_PG_8814B) & BIT_MASK_CH3_AVAL_PG_8814B)
#define BIT_SET_CH3_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH3_AVAL_PG_8814B(x) | BIT_CH3_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH3_RSVD_PG_8814B 0
#define BIT_MASK_CH3_RSVD_PG_8814B 0xfff
#define BIT_CH3_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH3_RSVD_PG_8814B) << BIT_SHIFT_CH3_RSVD_PG_8814B)
#define BITS_CH3_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH3_RSVD_PG_8814B << BIT_SHIFT_CH3_RSVD_PG_8814B)
#define BIT_CLEAR_CH3_RSVD_PG_8814B(x) ((x) & (~BITS_CH3_RSVD_PG_8814B))
#define BIT_GET_CH3_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH3_RSVD_PG_8814B) & BIT_MASK_CH3_RSVD_PG_8814B)
#define BIT_SET_CH3_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH3_RSVD_PG_8814B(x) | BIT_CH3_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_4_8814B */

#define BIT_SHIFT_CH4_AVAL_PG_8814B 16
#define BIT_MASK_CH4_AVAL_PG_8814B 0xfff
#define BIT_CH4_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH4_AVAL_PG_8814B) << BIT_SHIFT_CH4_AVAL_PG_8814B)
#define BITS_CH4_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH4_AVAL_PG_8814B << BIT_SHIFT_CH4_AVAL_PG_8814B)
#define BIT_CLEAR_CH4_AVAL_PG_8814B(x) ((x) & (~BITS_CH4_AVAL_PG_8814B))
#define BIT_GET_CH4_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH4_AVAL_PG_8814B) & BIT_MASK_CH4_AVAL_PG_8814B)
#define BIT_SET_CH4_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH4_AVAL_PG_8814B(x) | BIT_CH4_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH4_RSVD_PG_8814B 0
#define BIT_MASK_CH4_RSVD_PG_8814B 0xfff
#define BIT_CH4_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH4_RSVD_PG_8814B) << BIT_SHIFT_CH4_RSVD_PG_8814B)
#define BITS_CH4_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH4_RSVD_PG_8814B << BIT_SHIFT_CH4_RSVD_PG_8814B)
#define BIT_CLEAR_CH4_RSVD_PG_8814B(x) ((x) & (~BITS_CH4_RSVD_PG_8814B))
#define BIT_GET_CH4_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH4_RSVD_PG_8814B) & BIT_MASK_CH4_RSVD_PG_8814B)
#define BIT_SET_CH4_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH4_RSVD_PG_8814B(x) | BIT_CH4_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_5_8814B */

#define BIT_SHIFT_CH5_AVAL_PG_8814B 16
#define BIT_MASK_CH5_AVAL_PG_8814B 0xfff
#define BIT_CH5_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH5_AVAL_PG_8814B) << BIT_SHIFT_CH5_AVAL_PG_8814B)
#define BITS_CH5_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH5_AVAL_PG_8814B << BIT_SHIFT_CH5_AVAL_PG_8814B)
#define BIT_CLEAR_CH5_AVAL_PG_8814B(x) ((x) & (~BITS_CH5_AVAL_PG_8814B))
#define BIT_GET_CH5_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH5_AVAL_PG_8814B) & BIT_MASK_CH5_AVAL_PG_8814B)
#define BIT_SET_CH5_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH5_AVAL_PG_8814B(x) | BIT_CH5_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH5_RSVD_PG_8814B 0
#define BIT_MASK_CH5_RSVD_PG_8814B 0xfff
#define BIT_CH5_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH5_RSVD_PG_8814B) << BIT_SHIFT_CH5_RSVD_PG_8814B)
#define BITS_CH5_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH5_RSVD_PG_8814B << BIT_SHIFT_CH5_RSVD_PG_8814B)
#define BIT_CLEAR_CH5_RSVD_PG_8814B(x) ((x) & (~BITS_CH5_RSVD_PG_8814B))
#define BIT_GET_CH5_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH5_RSVD_PG_8814B) & BIT_MASK_CH5_RSVD_PG_8814B)
#define BIT_SET_CH5_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH5_RSVD_PG_8814B(x) | BIT_CH5_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_6_8814B */

#define BIT_SHIFT_CH6_AVAL_PG_8814B 16
#define BIT_MASK_CH6_AVAL_PG_8814B 0xfff
#define BIT_CH6_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH6_AVAL_PG_8814B) << BIT_SHIFT_CH6_AVAL_PG_8814B)
#define BITS_CH6_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH6_AVAL_PG_8814B << BIT_SHIFT_CH6_AVAL_PG_8814B)
#define BIT_CLEAR_CH6_AVAL_PG_8814B(x) ((x) & (~BITS_CH6_AVAL_PG_8814B))
#define BIT_GET_CH6_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH6_AVAL_PG_8814B) & BIT_MASK_CH6_AVAL_PG_8814B)
#define BIT_SET_CH6_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH6_AVAL_PG_8814B(x) | BIT_CH6_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH6_RSVD_PG_8814B 0
#define BIT_MASK_CH6_RSVD_PG_8814B 0xfff
#define BIT_CH6_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH6_RSVD_PG_8814B) << BIT_SHIFT_CH6_RSVD_PG_8814B)
#define BITS_CH6_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH6_RSVD_PG_8814B << BIT_SHIFT_CH6_RSVD_PG_8814B)
#define BIT_CLEAR_CH6_RSVD_PG_8814B(x) ((x) & (~BITS_CH6_RSVD_PG_8814B))
#define BIT_GET_CH6_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH6_RSVD_PG_8814B) & BIT_MASK_CH6_RSVD_PG_8814B)
#define BIT_SET_CH6_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH6_RSVD_PG_8814B(x) | BIT_CH6_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_7_8814B */

#define BIT_SHIFT_CH7_AVAL_PG_8814B 16
#define BIT_MASK_CH7_AVAL_PG_8814B 0xfff
#define BIT_CH7_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH7_AVAL_PG_8814B) << BIT_SHIFT_CH7_AVAL_PG_8814B)
#define BITS_CH7_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH7_AVAL_PG_8814B << BIT_SHIFT_CH7_AVAL_PG_8814B)
#define BIT_CLEAR_CH7_AVAL_PG_8814B(x) ((x) & (~BITS_CH7_AVAL_PG_8814B))
#define BIT_GET_CH7_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH7_AVAL_PG_8814B) & BIT_MASK_CH7_AVAL_PG_8814B)
#define BIT_SET_CH7_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH7_AVAL_PG_8814B(x) | BIT_CH7_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH7_RSVD_PG_8814B 0
#define BIT_MASK_CH7_RSVD_PG_8814B 0xfff
#define BIT_CH7_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH7_RSVD_PG_8814B) << BIT_SHIFT_CH7_RSVD_PG_8814B)
#define BITS_CH7_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH7_RSVD_PG_8814B << BIT_SHIFT_CH7_RSVD_PG_8814B)
#define BIT_CLEAR_CH7_RSVD_PG_8814B(x) ((x) & (~BITS_CH7_RSVD_PG_8814B))
#define BIT_GET_CH7_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH7_RSVD_PG_8814B) & BIT_MASK_CH7_RSVD_PG_8814B)
#define BIT_SET_CH7_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH7_RSVD_PG_8814B(x) | BIT_CH7_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_8_8814B */

#define BIT_SHIFT_CH8_AVAL_PG_8814B 16
#define BIT_MASK_CH8_AVAL_PG_8814B 0xfff
#define BIT_CH8_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH8_AVAL_PG_8814B) << BIT_SHIFT_CH8_AVAL_PG_8814B)
#define BITS_CH8_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH8_AVAL_PG_8814B << BIT_SHIFT_CH8_AVAL_PG_8814B)
#define BIT_CLEAR_CH8_AVAL_PG_8814B(x) ((x) & (~BITS_CH8_AVAL_PG_8814B))
#define BIT_GET_CH8_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH8_AVAL_PG_8814B) & BIT_MASK_CH8_AVAL_PG_8814B)
#define BIT_SET_CH8_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH8_AVAL_PG_8814B(x) | BIT_CH8_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH8_RSVD_PG_8814B 0
#define BIT_MASK_CH8_RSVD_PG_8814B 0xfff
#define BIT_CH8_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH8_RSVD_PG_8814B) << BIT_SHIFT_CH8_RSVD_PG_8814B)
#define BITS_CH8_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH8_RSVD_PG_8814B << BIT_SHIFT_CH8_RSVD_PG_8814B)
#define BIT_CLEAR_CH8_RSVD_PG_8814B(x) ((x) & (~BITS_CH8_RSVD_PG_8814B))
#define BIT_GET_CH8_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH8_RSVD_PG_8814B) & BIT_MASK_CH8_RSVD_PG_8814B)
#define BIT_SET_CH8_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH8_RSVD_PG_8814B(x) | BIT_CH8_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_9_8814B */

#define BIT_SHIFT_CH9_AVAL_PG_8814B 16
#define BIT_MASK_CH9_AVAL_PG_8814B 0xfff
#define BIT_CH9_AVAL_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH9_AVAL_PG_8814B) << BIT_SHIFT_CH9_AVAL_PG_8814B)
#define BITS_CH9_AVAL_PG_8814B                                                 \
	(BIT_MASK_CH9_AVAL_PG_8814B << BIT_SHIFT_CH9_AVAL_PG_8814B)
#define BIT_CLEAR_CH9_AVAL_PG_8814B(x) ((x) & (~BITS_CH9_AVAL_PG_8814B))
#define BIT_GET_CH9_AVAL_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH9_AVAL_PG_8814B) & BIT_MASK_CH9_AVAL_PG_8814B)
#define BIT_SET_CH9_AVAL_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH9_AVAL_PG_8814B(x) | BIT_CH9_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH9_RSVD_PG_8814B 0
#define BIT_MASK_CH9_RSVD_PG_8814B 0xfff
#define BIT_CH9_RSVD_PG_8814B(x)                                               \
	(((x) & BIT_MASK_CH9_RSVD_PG_8814B) << BIT_SHIFT_CH9_RSVD_PG_8814B)
#define BITS_CH9_RSVD_PG_8814B                                                 \
	(BIT_MASK_CH9_RSVD_PG_8814B << BIT_SHIFT_CH9_RSVD_PG_8814B)
#define BIT_CLEAR_CH9_RSVD_PG_8814B(x) ((x) & (~BITS_CH9_RSVD_PG_8814B))
#define BIT_GET_CH9_RSVD_PG_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH9_RSVD_PG_8814B) & BIT_MASK_CH9_RSVD_PG_8814B)
#define BIT_SET_CH9_RSVD_PG_8814B(x, v)                                        \
	(BIT_CLEAR_CH9_RSVD_PG_8814B(x) | BIT_CH9_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_10_8814B */

#define BIT_SHIFT_CH10_AVAL_PG_8814B 16
#define BIT_MASK_CH10_AVAL_PG_8814B 0xfff
#define BIT_CH10_AVAL_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH10_AVAL_PG_8814B) << BIT_SHIFT_CH10_AVAL_PG_8814B)
#define BITS_CH10_AVAL_PG_8814B                                                \
	(BIT_MASK_CH10_AVAL_PG_8814B << BIT_SHIFT_CH10_AVAL_PG_8814B)
#define BIT_CLEAR_CH10_AVAL_PG_8814B(x) ((x) & (~BITS_CH10_AVAL_PG_8814B))
#define BIT_GET_CH10_AVAL_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH10_AVAL_PG_8814B) & BIT_MASK_CH10_AVAL_PG_8814B)
#define BIT_SET_CH10_AVAL_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH10_AVAL_PG_8814B(x) | BIT_CH10_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH10_RSVD_PG_8814B 0
#define BIT_MASK_CH10_RSVD_PG_8814B 0xfff
#define BIT_CH10_RSVD_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH10_RSVD_PG_8814B) << BIT_SHIFT_CH10_RSVD_PG_8814B)
#define BITS_CH10_RSVD_PG_8814B                                                \
	(BIT_MASK_CH10_RSVD_PG_8814B << BIT_SHIFT_CH10_RSVD_PG_8814B)
#define BIT_CLEAR_CH10_RSVD_PG_8814B(x) ((x) & (~BITS_CH10_RSVD_PG_8814B))
#define BIT_GET_CH10_RSVD_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH10_RSVD_PG_8814B) & BIT_MASK_CH10_RSVD_PG_8814B)
#define BIT_SET_CH10_RSVD_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH10_RSVD_PG_8814B(x) | BIT_CH10_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_11_8814B */

#define BIT_SHIFT_CH11_AVAL_PG_8814B 16
#define BIT_MASK_CH11_AVAL_PG_8814B 0xfff
#define BIT_CH11_AVAL_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH11_AVAL_PG_8814B) << BIT_SHIFT_CH11_AVAL_PG_8814B)
#define BITS_CH11_AVAL_PG_8814B                                                \
	(BIT_MASK_CH11_AVAL_PG_8814B << BIT_SHIFT_CH11_AVAL_PG_8814B)
#define BIT_CLEAR_CH11_AVAL_PG_8814B(x) ((x) & (~BITS_CH11_AVAL_PG_8814B))
#define BIT_GET_CH11_AVAL_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH11_AVAL_PG_8814B) & BIT_MASK_CH11_AVAL_PG_8814B)
#define BIT_SET_CH11_AVAL_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH11_AVAL_PG_8814B(x) | BIT_CH11_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH11_RSVD_PG_8814B 0
#define BIT_MASK_CH11_RSVD_PG_8814B 0xfff
#define BIT_CH11_RSVD_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH11_RSVD_PG_8814B) << BIT_SHIFT_CH11_RSVD_PG_8814B)
#define BITS_CH11_RSVD_PG_8814B                                                \
	(BIT_MASK_CH11_RSVD_PG_8814B << BIT_SHIFT_CH11_RSVD_PG_8814B)
#define BIT_CLEAR_CH11_RSVD_PG_8814B(x) ((x) & (~BITS_CH11_RSVD_PG_8814B))
#define BIT_GET_CH11_RSVD_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH11_RSVD_PG_8814B) & BIT_MASK_CH11_RSVD_PG_8814B)
#define BIT_SET_CH11_RSVD_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH11_RSVD_PG_8814B(x) | BIT_CH11_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_12_8814B */

#define BIT_SHIFT_CH12_AVAL_PG_8814B 16
#define BIT_MASK_CH12_AVAL_PG_8814B 0xfff
#define BIT_CH12_AVAL_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH12_AVAL_PG_8814B) << BIT_SHIFT_CH12_AVAL_PG_8814B)
#define BITS_CH12_AVAL_PG_8814B                                                \
	(BIT_MASK_CH12_AVAL_PG_8814B << BIT_SHIFT_CH12_AVAL_PG_8814B)
#define BIT_CLEAR_CH12_AVAL_PG_8814B(x) ((x) & (~BITS_CH12_AVAL_PG_8814B))
#define BIT_GET_CH12_AVAL_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH12_AVAL_PG_8814B) & BIT_MASK_CH12_AVAL_PG_8814B)
#define BIT_SET_CH12_AVAL_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH12_AVAL_PG_8814B(x) | BIT_CH12_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH12_RSVD_PG_8814B 0
#define BIT_MASK_CH12_RSVD_PG_8814B 0xfff
#define BIT_CH12_RSVD_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH12_RSVD_PG_8814B) << BIT_SHIFT_CH12_RSVD_PG_8814B)
#define BITS_CH12_RSVD_PG_8814B                                                \
	(BIT_MASK_CH12_RSVD_PG_8814B << BIT_SHIFT_CH12_RSVD_PG_8814B)
#define BIT_CLEAR_CH12_RSVD_PG_8814B(x) ((x) & (~BITS_CH12_RSVD_PG_8814B))
#define BIT_GET_CH12_RSVD_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH12_RSVD_PG_8814B) & BIT_MASK_CH12_RSVD_PG_8814B)
#define BIT_SET_CH12_RSVD_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH12_RSVD_PG_8814B(x) | BIT_CH12_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_13_8814B */

#define BIT_SHIFT_CH13_AVAL_PG_8814B 16
#define BIT_MASK_CH13_AVAL_PG_8814B 0xfff
#define BIT_CH13_AVAL_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH13_AVAL_PG_8814B) << BIT_SHIFT_CH13_AVAL_PG_8814B)
#define BITS_CH13_AVAL_PG_8814B                                                \
	(BIT_MASK_CH13_AVAL_PG_8814B << BIT_SHIFT_CH13_AVAL_PG_8814B)
#define BIT_CLEAR_CH13_AVAL_PG_8814B(x) ((x) & (~BITS_CH13_AVAL_PG_8814B))
#define BIT_GET_CH13_AVAL_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH13_AVAL_PG_8814B) & BIT_MASK_CH13_AVAL_PG_8814B)
#define BIT_SET_CH13_AVAL_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH13_AVAL_PG_8814B(x) | BIT_CH13_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH13_RSVD_PG_8814B 0
#define BIT_MASK_CH13_RSVD_PG_8814B 0xfff
#define BIT_CH13_RSVD_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH13_RSVD_PG_8814B) << BIT_SHIFT_CH13_RSVD_PG_8814B)
#define BITS_CH13_RSVD_PG_8814B                                                \
	(BIT_MASK_CH13_RSVD_PG_8814B << BIT_SHIFT_CH13_RSVD_PG_8814B)
#define BIT_CLEAR_CH13_RSVD_PG_8814B(x) ((x) & (~BITS_CH13_RSVD_PG_8814B))
#define BIT_GET_CH13_RSVD_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH13_RSVD_PG_8814B) & BIT_MASK_CH13_RSVD_PG_8814B)
#define BIT_SET_CH13_RSVD_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH13_RSVD_PG_8814B(x) | BIT_CH13_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_14_8814B */

#define BIT_SHIFT_CH14_AVAL_PG_8814B 16
#define BIT_MASK_CH14_AVAL_PG_8814B 0xfff
#define BIT_CH14_AVAL_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH14_AVAL_PG_8814B) << BIT_SHIFT_CH14_AVAL_PG_8814B)
#define BITS_CH14_AVAL_PG_8814B                                                \
	(BIT_MASK_CH14_AVAL_PG_8814B << BIT_SHIFT_CH14_AVAL_PG_8814B)
#define BIT_CLEAR_CH14_AVAL_PG_8814B(x) ((x) & (~BITS_CH14_AVAL_PG_8814B))
#define BIT_GET_CH14_AVAL_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH14_AVAL_PG_8814B) & BIT_MASK_CH14_AVAL_PG_8814B)
#define BIT_SET_CH14_AVAL_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH14_AVAL_PG_8814B(x) | BIT_CH14_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH14_RSVD_PG_8814B 0
#define BIT_MASK_CH14_RSVD_PG_8814B 0xfff
#define BIT_CH14_RSVD_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH14_RSVD_PG_8814B) << BIT_SHIFT_CH14_RSVD_PG_8814B)
#define BITS_CH14_RSVD_PG_8814B                                                \
	(BIT_MASK_CH14_RSVD_PG_8814B << BIT_SHIFT_CH14_RSVD_PG_8814B)
#define BIT_CLEAR_CH14_RSVD_PG_8814B(x) ((x) & (~BITS_CH14_RSVD_PG_8814B))
#define BIT_GET_CH14_RSVD_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH14_RSVD_PG_8814B) & BIT_MASK_CH14_RSVD_PG_8814B)
#define BIT_SET_CH14_RSVD_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH14_RSVD_PG_8814B(x) | BIT_CH14_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_15_8814B */

#define BIT_SHIFT_CH15_AVAL_PG_8814B 16
#define BIT_MASK_CH15_AVAL_PG_8814B 0xfff
#define BIT_CH15_AVAL_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH15_AVAL_PG_8814B) << BIT_SHIFT_CH15_AVAL_PG_8814B)
#define BITS_CH15_AVAL_PG_8814B                                                \
	(BIT_MASK_CH15_AVAL_PG_8814B << BIT_SHIFT_CH15_AVAL_PG_8814B)
#define BIT_CLEAR_CH15_AVAL_PG_8814B(x) ((x) & (~BITS_CH15_AVAL_PG_8814B))
#define BIT_GET_CH15_AVAL_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH15_AVAL_PG_8814B) & BIT_MASK_CH15_AVAL_PG_8814B)
#define BIT_SET_CH15_AVAL_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH15_AVAL_PG_8814B(x) | BIT_CH15_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH15_RSVD_PG_8814B 0
#define BIT_MASK_CH15_RSVD_PG_8814B 0xfff
#define BIT_CH15_RSVD_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH15_RSVD_PG_8814B) << BIT_SHIFT_CH15_RSVD_PG_8814B)
#define BITS_CH15_RSVD_PG_8814B                                                \
	(BIT_MASK_CH15_RSVD_PG_8814B << BIT_SHIFT_CH15_RSVD_PG_8814B)
#define BIT_CLEAR_CH15_RSVD_PG_8814B(x) ((x) & (~BITS_CH15_RSVD_PG_8814B))
#define BIT_GET_CH15_RSVD_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH15_RSVD_PG_8814B) & BIT_MASK_CH15_RSVD_PG_8814B)
#define BIT_SET_CH15_RSVD_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH15_RSVD_PG_8814B(x) | BIT_CH15_RSVD_PG_8814B(v))

/* 2 REG_DMA_RQPN_INFO_16_8814B */

#define BIT_SHIFT_CH16_AVAL_PG_8814B 16
#define BIT_MASK_CH16_AVAL_PG_8814B 0xfff
#define BIT_CH16_AVAL_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH16_AVAL_PG_8814B) << BIT_SHIFT_CH16_AVAL_PG_8814B)
#define BITS_CH16_AVAL_PG_8814B                                                \
	(BIT_MASK_CH16_AVAL_PG_8814B << BIT_SHIFT_CH16_AVAL_PG_8814B)
#define BIT_CLEAR_CH16_AVAL_PG_8814B(x) ((x) & (~BITS_CH16_AVAL_PG_8814B))
#define BIT_GET_CH16_AVAL_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH16_AVAL_PG_8814B) & BIT_MASK_CH16_AVAL_PG_8814B)
#define BIT_SET_CH16_AVAL_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH16_AVAL_PG_8814B(x) | BIT_CH16_AVAL_PG_8814B(v))

#define BIT_SHIFT_CH16_RSVD_PG_8814B 0
#define BIT_MASK_CH16_RSVD_PG_8814B 0xfff
#define BIT_CH16_RSVD_PG_8814B(x)                                              \
	(((x) & BIT_MASK_CH16_RSVD_PG_8814B) << BIT_SHIFT_CH16_RSVD_PG_8814B)
#define BITS_CH16_RSVD_PG_8814B                                                \
	(BIT_MASK_CH16_RSVD_PG_8814B << BIT_SHIFT_CH16_RSVD_PG_8814B)
#define BIT_CLEAR_CH16_RSVD_PG_8814B(x) ((x) & (~BITS_CH16_RSVD_PG_8814B))
#define BIT_GET_CH16_RSVD_PG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH16_RSVD_PG_8814B) & BIT_MASK_CH16_RSVD_PG_8814B)
#define BIT_SET_CH16_RSVD_PG_8814B(x, v)                                       \
	(BIT_CLEAR_CH16_RSVD_PG_8814B(x) | BIT_CH16_RSVD_PG_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HWAMSDU_CTL1_8814B */

#define BIT_SHIFT_HWAMSDU_PKTNUM_8814B 8
#define BIT_MASK_HWAMSDU_PKTNUM_8814B 0x3f
#define BIT_HWAMSDU_PKTNUM_8814B(x)                                            \
	(((x) & BIT_MASK_HWAMSDU_PKTNUM_8814B)                                 \
	 << BIT_SHIFT_HWAMSDU_PKTNUM_8814B)
#define BITS_HWAMSDU_PKTNUM_8814B                                              \
	(BIT_MASK_HWAMSDU_PKTNUM_8814B << BIT_SHIFT_HWAMSDU_PKTNUM_8814B)
#define BIT_CLEAR_HWAMSDU_PKTNUM_8814B(x) ((x) & (~BITS_HWAMSDU_PKTNUM_8814B))
#define BIT_GET_HWAMSDU_PKTNUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_HWAMSDU_PKTNUM_8814B) &                             \
	 BIT_MASK_HWAMSDU_PKTNUM_8814B)
#define BIT_SET_HWAMSDU_PKTNUM_8814B(x, v)                                     \
	(BIT_CLEAR_HWAMSDU_PKTNUM_8814B(x) | BIT_HWAMSDU_PKTNUM_8814B(v))

#define BIT_HWAMSDU_BUSY_8814B BIT(7)
#define BIT_SINGLE_AMSDU_8814B BIT(2)
#define BIT_HWAMSDU_PADDING_MODE_8814B BIT(1)
#define BIT_HWAMSDU_EN_8814B BIT(0)

/* 2 REG_HWAMSDU_CTL2_8814B */

#define BIT_SHIFT_HWAMSDU_AMSDU_TIMEOUT_8814B 16
#define BIT_MASK_HWAMSDU_AMSDU_TIMEOUT_8814B 0xffff
#define BIT_HWAMSDU_AMSDU_TIMEOUT_8814B(x)                                     \
	(((x) & BIT_MASK_HWAMSDU_AMSDU_TIMEOUT_8814B)                          \
	 << BIT_SHIFT_HWAMSDU_AMSDU_TIMEOUT_8814B)
#define BITS_HWAMSDU_AMSDU_TIMEOUT_8814B                                       \
	(BIT_MASK_HWAMSDU_AMSDU_TIMEOUT_8814B                                  \
	 << BIT_SHIFT_HWAMSDU_AMSDU_TIMEOUT_8814B)
#define BIT_CLEAR_HWAMSDU_AMSDU_TIMEOUT_8814B(x)                               \
	((x) & (~BITS_HWAMSDU_AMSDU_TIMEOUT_8814B))
#define BIT_GET_HWAMSDU_AMSDU_TIMEOUT_8814B(x)                                 \
	(((x) >> BIT_SHIFT_HWAMSDU_AMSDU_TIMEOUT_8814B) &                      \
	 BIT_MASK_HWAMSDU_AMSDU_TIMEOUT_8814B)
#define BIT_SET_HWAMSDU_AMSDU_TIMEOUT_8814B(x, v)                              \
	(BIT_CLEAR_HWAMSDU_AMSDU_TIMEOUT_8814B(x) |                            \
	 BIT_HWAMSDU_AMSDU_TIMEOUT_8814B(v))

#define BIT_SHIFT_HWAMSDU_MSDU_TIMEOUT_8814B 0
#define BIT_MASK_HWAMSDU_MSDU_TIMEOUT_8814B 0xffff
#define BIT_HWAMSDU_MSDU_TIMEOUT_8814B(x)                                      \
	(((x) & BIT_MASK_HWAMSDU_MSDU_TIMEOUT_8814B)                           \
	 << BIT_SHIFT_HWAMSDU_MSDU_TIMEOUT_8814B)
#define BITS_HWAMSDU_MSDU_TIMEOUT_8814B                                        \
	(BIT_MASK_HWAMSDU_MSDU_TIMEOUT_8814B                                   \
	 << BIT_SHIFT_HWAMSDU_MSDU_TIMEOUT_8814B)
#define BIT_CLEAR_HWAMSDU_MSDU_TIMEOUT_8814B(x)                                \
	((x) & (~BITS_HWAMSDU_MSDU_TIMEOUT_8814B))
#define BIT_GET_HWAMSDU_MSDU_TIMEOUT_8814B(x)                                  \
	(((x) >> BIT_SHIFT_HWAMSDU_MSDU_TIMEOUT_8814B) &                       \
	 BIT_MASK_HWAMSDU_MSDU_TIMEOUT_8814B)
#define BIT_SET_HWAMSDU_MSDU_TIMEOUT_8814B(x, v)                               \
	(BIT_CLEAR_HWAMSDU_MSDU_TIMEOUT_8814B(x) |                             \
	 BIT_HWAMSDU_MSDU_TIMEOUT_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_0_8814B */
#define BIT_CH0_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH0_HIGH_TH_8814B 16
#define BIT_MASK_CH0_HIGH_TH_8814B 0xfff
#define BIT_CH0_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH0_HIGH_TH_8814B) << BIT_SHIFT_CH0_HIGH_TH_8814B)
#define BITS_CH0_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH0_HIGH_TH_8814B << BIT_SHIFT_CH0_HIGH_TH_8814B)
#define BIT_CLEAR_CH0_HIGH_TH_8814B(x) ((x) & (~BITS_CH0_HIGH_TH_8814B))
#define BIT_GET_CH0_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH0_HIGH_TH_8814B) & BIT_MASK_CH0_HIGH_TH_8814B)
#define BIT_SET_CH0_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH0_HIGH_TH_8814B(x) | BIT_CH0_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH0_LOW_TH_8814B 0
#define BIT_MASK_CH0_LOW_TH_8814B 0xfff
#define BIT_CH0_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH0_LOW_TH_8814B) << BIT_SHIFT_CH0_LOW_TH_8814B)
#define BITS_CH0_LOW_TH_8814B                                                  \
	(BIT_MASK_CH0_LOW_TH_8814B << BIT_SHIFT_CH0_LOW_TH_8814B)
#define BIT_CLEAR_CH0_LOW_TH_8814B(x) ((x) & (~BITS_CH0_LOW_TH_8814B))
#define BIT_GET_CH0_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH0_LOW_TH_8814B) & BIT_MASK_CH0_LOW_TH_8814B)
#define BIT_SET_CH0_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH0_LOW_TH_8814B(x) | BIT_CH0_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_1_8814B */
#define BIT_CH1_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH1_HIGH_TH_8814B 16
#define BIT_MASK_CH1_HIGH_TH_8814B 0xfff
#define BIT_CH1_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH1_HIGH_TH_8814B) << BIT_SHIFT_CH1_HIGH_TH_8814B)
#define BITS_CH1_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH1_HIGH_TH_8814B << BIT_SHIFT_CH1_HIGH_TH_8814B)
#define BIT_CLEAR_CH1_HIGH_TH_8814B(x) ((x) & (~BITS_CH1_HIGH_TH_8814B))
#define BIT_GET_CH1_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH1_HIGH_TH_8814B) & BIT_MASK_CH1_HIGH_TH_8814B)
#define BIT_SET_CH1_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH1_HIGH_TH_8814B(x) | BIT_CH1_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH1_LOW_TH_8814B 0
#define BIT_MASK_CH1_LOW_TH_8814B 0xfff
#define BIT_CH1_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH1_LOW_TH_8814B) << BIT_SHIFT_CH1_LOW_TH_8814B)
#define BITS_CH1_LOW_TH_8814B                                                  \
	(BIT_MASK_CH1_LOW_TH_8814B << BIT_SHIFT_CH1_LOW_TH_8814B)
#define BIT_CLEAR_CH1_LOW_TH_8814B(x) ((x) & (~BITS_CH1_LOW_TH_8814B))
#define BIT_GET_CH1_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH1_LOW_TH_8814B) & BIT_MASK_CH1_LOW_TH_8814B)
#define BIT_SET_CH1_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH1_LOW_TH_8814B(x) | BIT_CH1_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_2_8814B */
#define BIT_CH2_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH2_HIGH_TH_8814B 16
#define BIT_MASK_CH2_HIGH_TH_8814B 0xfff
#define BIT_CH2_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH2_HIGH_TH_8814B) << BIT_SHIFT_CH2_HIGH_TH_8814B)
#define BITS_CH2_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH2_HIGH_TH_8814B << BIT_SHIFT_CH2_HIGH_TH_8814B)
#define BIT_CLEAR_CH2_HIGH_TH_8814B(x) ((x) & (~BITS_CH2_HIGH_TH_8814B))
#define BIT_GET_CH2_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH2_HIGH_TH_8814B) & BIT_MASK_CH2_HIGH_TH_8814B)
#define BIT_SET_CH2_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH2_HIGH_TH_8814B(x) | BIT_CH2_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH2_LOW_TH_8814B 0
#define BIT_MASK_CH2_LOW_TH_8814B 0xfff
#define BIT_CH2_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH2_LOW_TH_8814B) << BIT_SHIFT_CH2_LOW_TH_8814B)
#define BITS_CH2_LOW_TH_8814B                                                  \
	(BIT_MASK_CH2_LOW_TH_8814B << BIT_SHIFT_CH2_LOW_TH_8814B)
#define BIT_CLEAR_CH2_LOW_TH_8814B(x) ((x) & (~BITS_CH2_LOW_TH_8814B))
#define BIT_GET_CH2_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH2_LOW_TH_8814B) & BIT_MASK_CH2_LOW_TH_8814B)
#define BIT_SET_CH2_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH2_LOW_TH_8814B(x) | BIT_CH2_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_3_8814B */
#define BIT_CH3_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH3_HIGH_TH_8814B 16
#define BIT_MASK_CH3_HIGH_TH_8814B 0xfff
#define BIT_CH3_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH3_HIGH_TH_8814B) << BIT_SHIFT_CH3_HIGH_TH_8814B)
#define BITS_CH3_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH3_HIGH_TH_8814B << BIT_SHIFT_CH3_HIGH_TH_8814B)
#define BIT_CLEAR_CH3_HIGH_TH_8814B(x) ((x) & (~BITS_CH3_HIGH_TH_8814B))
#define BIT_GET_CH3_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH3_HIGH_TH_8814B) & BIT_MASK_CH3_HIGH_TH_8814B)
#define BIT_SET_CH3_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH3_HIGH_TH_8814B(x) | BIT_CH3_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH3_LOW_TH_8814B 0
#define BIT_MASK_CH3_LOW_TH_8814B 0xfff
#define BIT_CH3_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH3_LOW_TH_8814B) << BIT_SHIFT_CH3_LOW_TH_8814B)
#define BITS_CH3_LOW_TH_8814B                                                  \
	(BIT_MASK_CH3_LOW_TH_8814B << BIT_SHIFT_CH3_LOW_TH_8814B)
#define BIT_CLEAR_CH3_LOW_TH_8814B(x) ((x) & (~BITS_CH3_LOW_TH_8814B))
#define BIT_GET_CH3_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH3_LOW_TH_8814B) & BIT_MASK_CH3_LOW_TH_8814B)
#define BIT_SET_CH3_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH3_LOW_TH_8814B(x) | BIT_CH3_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_4_8814B */
#define BIT_CH4_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH4_HIGH_TH_8814B 16
#define BIT_MASK_CH4_HIGH_TH_8814B 0xfff
#define BIT_CH4_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH4_HIGH_TH_8814B) << BIT_SHIFT_CH4_HIGH_TH_8814B)
#define BITS_CH4_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH4_HIGH_TH_8814B << BIT_SHIFT_CH4_HIGH_TH_8814B)
#define BIT_CLEAR_CH4_HIGH_TH_8814B(x) ((x) & (~BITS_CH4_HIGH_TH_8814B))
#define BIT_GET_CH4_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH4_HIGH_TH_8814B) & BIT_MASK_CH4_HIGH_TH_8814B)
#define BIT_SET_CH4_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH4_HIGH_TH_8814B(x) | BIT_CH4_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH4_LOW_TH_8814B 0
#define BIT_MASK_CH4_LOW_TH_8814B 0xfff
#define BIT_CH4_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH4_LOW_TH_8814B) << BIT_SHIFT_CH4_LOW_TH_8814B)
#define BITS_CH4_LOW_TH_8814B                                                  \
	(BIT_MASK_CH4_LOW_TH_8814B << BIT_SHIFT_CH4_LOW_TH_8814B)
#define BIT_CLEAR_CH4_LOW_TH_8814B(x) ((x) & (~BITS_CH4_LOW_TH_8814B))
#define BIT_GET_CH4_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH4_LOW_TH_8814B) & BIT_MASK_CH4_LOW_TH_8814B)
#define BIT_SET_CH4_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH4_LOW_TH_8814B(x) | BIT_CH4_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_5_8814B */
#define BIT_CH5_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH5_HIGH_TH_8814B 16
#define BIT_MASK_CH5_HIGH_TH_8814B 0xfff
#define BIT_CH5_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH5_HIGH_TH_8814B) << BIT_SHIFT_CH5_HIGH_TH_8814B)
#define BITS_CH5_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH5_HIGH_TH_8814B << BIT_SHIFT_CH5_HIGH_TH_8814B)
#define BIT_CLEAR_CH5_HIGH_TH_8814B(x) ((x) & (~BITS_CH5_HIGH_TH_8814B))
#define BIT_GET_CH5_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH5_HIGH_TH_8814B) & BIT_MASK_CH5_HIGH_TH_8814B)
#define BIT_SET_CH5_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH5_HIGH_TH_8814B(x) | BIT_CH5_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH5_LOW_TH_8814B 0
#define BIT_MASK_CH5_LOW_TH_8814B 0xfff
#define BIT_CH5_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH5_LOW_TH_8814B) << BIT_SHIFT_CH5_LOW_TH_8814B)
#define BITS_CH5_LOW_TH_8814B                                                  \
	(BIT_MASK_CH5_LOW_TH_8814B << BIT_SHIFT_CH5_LOW_TH_8814B)
#define BIT_CLEAR_CH5_LOW_TH_8814B(x) ((x) & (~BITS_CH5_LOW_TH_8814B))
#define BIT_GET_CH5_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH5_LOW_TH_8814B) & BIT_MASK_CH5_LOW_TH_8814B)
#define BIT_SET_CH5_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH5_LOW_TH_8814B(x) | BIT_CH5_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_6_8814B */
#define BIT_CH6_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH6_HIGH_TH_8814B 16
#define BIT_MASK_CH6_HIGH_TH_8814B 0xfff
#define BIT_CH6_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH6_HIGH_TH_8814B) << BIT_SHIFT_CH6_HIGH_TH_8814B)
#define BITS_CH6_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH6_HIGH_TH_8814B << BIT_SHIFT_CH6_HIGH_TH_8814B)
#define BIT_CLEAR_CH6_HIGH_TH_8814B(x) ((x) & (~BITS_CH6_HIGH_TH_8814B))
#define BIT_GET_CH6_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH6_HIGH_TH_8814B) & BIT_MASK_CH6_HIGH_TH_8814B)
#define BIT_SET_CH6_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH6_HIGH_TH_8814B(x) | BIT_CH6_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH6_LOW_TH_8814B 0
#define BIT_MASK_CH6_LOW_TH_8814B 0xfff
#define BIT_CH6_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH6_LOW_TH_8814B) << BIT_SHIFT_CH6_LOW_TH_8814B)
#define BITS_CH6_LOW_TH_8814B                                                  \
	(BIT_MASK_CH6_LOW_TH_8814B << BIT_SHIFT_CH6_LOW_TH_8814B)
#define BIT_CLEAR_CH6_LOW_TH_8814B(x) ((x) & (~BITS_CH6_LOW_TH_8814B))
#define BIT_GET_CH6_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH6_LOW_TH_8814B) & BIT_MASK_CH6_LOW_TH_8814B)
#define BIT_SET_CH6_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH6_LOW_TH_8814B(x) | BIT_CH6_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_7_8814B */
#define BIT_CH7_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH7_HIGH_TH_8814B 16
#define BIT_MASK_CH7_HIGH_TH_8814B 0xfff
#define BIT_CH7_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH7_HIGH_TH_8814B) << BIT_SHIFT_CH7_HIGH_TH_8814B)
#define BITS_CH7_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH7_HIGH_TH_8814B << BIT_SHIFT_CH7_HIGH_TH_8814B)
#define BIT_CLEAR_CH7_HIGH_TH_8814B(x) ((x) & (~BITS_CH7_HIGH_TH_8814B))
#define BIT_GET_CH7_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH7_HIGH_TH_8814B) & BIT_MASK_CH7_HIGH_TH_8814B)
#define BIT_SET_CH7_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH7_HIGH_TH_8814B(x) | BIT_CH7_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH7_LOW_TH_8814B 0
#define BIT_MASK_CH7_LOW_TH_8814B 0xfff
#define BIT_CH7_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH7_LOW_TH_8814B) << BIT_SHIFT_CH7_LOW_TH_8814B)
#define BITS_CH7_LOW_TH_8814B                                                  \
	(BIT_MASK_CH7_LOW_TH_8814B << BIT_SHIFT_CH7_LOW_TH_8814B)
#define BIT_CLEAR_CH7_LOW_TH_8814B(x) ((x) & (~BITS_CH7_LOW_TH_8814B))
#define BIT_GET_CH7_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH7_LOW_TH_8814B) & BIT_MASK_CH7_LOW_TH_8814B)
#define BIT_SET_CH7_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH7_LOW_TH_8814B(x) | BIT_CH7_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_8_8814B */
#define BIT_CH8_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH8_HIGH_TH_8814B 16
#define BIT_MASK_CH8_HIGH_TH_8814B 0xfff
#define BIT_CH8_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH8_HIGH_TH_8814B) << BIT_SHIFT_CH8_HIGH_TH_8814B)
#define BITS_CH8_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH8_HIGH_TH_8814B << BIT_SHIFT_CH8_HIGH_TH_8814B)
#define BIT_CLEAR_CH8_HIGH_TH_8814B(x) ((x) & (~BITS_CH8_HIGH_TH_8814B))
#define BIT_GET_CH8_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH8_HIGH_TH_8814B) & BIT_MASK_CH8_HIGH_TH_8814B)
#define BIT_SET_CH8_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH8_HIGH_TH_8814B(x) | BIT_CH8_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH8_LOW_TH_8814B 0
#define BIT_MASK_CH8_LOW_TH_8814B 0xfff
#define BIT_CH8_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH8_LOW_TH_8814B) << BIT_SHIFT_CH8_LOW_TH_8814B)
#define BITS_CH8_LOW_TH_8814B                                                  \
	(BIT_MASK_CH8_LOW_TH_8814B << BIT_SHIFT_CH8_LOW_TH_8814B)
#define BIT_CLEAR_CH8_LOW_TH_8814B(x) ((x) & (~BITS_CH8_LOW_TH_8814B))
#define BIT_GET_CH8_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH8_LOW_TH_8814B) & BIT_MASK_CH8_LOW_TH_8814B)
#define BIT_SET_CH8_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH8_LOW_TH_8814B(x) | BIT_CH8_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_9_8814B */
#define BIT_CH9_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH9_HIGH_TH_8814B 16
#define BIT_MASK_CH9_HIGH_TH_8814B 0xfff
#define BIT_CH9_HIGH_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH9_HIGH_TH_8814B) << BIT_SHIFT_CH9_HIGH_TH_8814B)
#define BITS_CH9_HIGH_TH_8814B                                                 \
	(BIT_MASK_CH9_HIGH_TH_8814B << BIT_SHIFT_CH9_HIGH_TH_8814B)
#define BIT_CLEAR_CH9_HIGH_TH_8814B(x) ((x) & (~BITS_CH9_HIGH_TH_8814B))
#define BIT_GET_CH9_HIGH_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH9_HIGH_TH_8814B) & BIT_MASK_CH9_HIGH_TH_8814B)
#define BIT_SET_CH9_HIGH_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH9_HIGH_TH_8814B(x) | BIT_CH9_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH9_LOW_TH_8814B 0
#define BIT_MASK_CH9_LOW_TH_8814B 0xfff
#define BIT_CH9_LOW_TH_8814B(x)                                                \
	(((x) & BIT_MASK_CH9_LOW_TH_8814B) << BIT_SHIFT_CH9_LOW_TH_8814B)
#define BITS_CH9_LOW_TH_8814B                                                  \
	(BIT_MASK_CH9_LOW_TH_8814B << BIT_SHIFT_CH9_LOW_TH_8814B)
#define BIT_CLEAR_CH9_LOW_TH_8814B(x) ((x) & (~BITS_CH9_LOW_TH_8814B))
#define BIT_GET_CH9_LOW_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_CH9_LOW_TH_8814B) & BIT_MASK_CH9_LOW_TH_8814B)
#define BIT_SET_CH9_LOW_TH_8814B(x, v)                                         \
	(BIT_CLEAR_CH9_LOW_TH_8814B(x) | BIT_CH9_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_10_8814B */
#define BIT_CH10_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH10_HIGH_TH_8814B 16
#define BIT_MASK_CH10_HIGH_TH_8814B 0xfff
#define BIT_CH10_HIGH_TH_8814B(x)                                              \
	(((x) & BIT_MASK_CH10_HIGH_TH_8814B) << BIT_SHIFT_CH10_HIGH_TH_8814B)
#define BITS_CH10_HIGH_TH_8814B                                                \
	(BIT_MASK_CH10_HIGH_TH_8814B << BIT_SHIFT_CH10_HIGH_TH_8814B)
#define BIT_CLEAR_CH10_HIGH_TH_8814B(x) ((x) & (~BITS_CH10_HIGH_TH_8814B))
#define BIT_GET_CH10_HIGH_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH10_HIGH_TH_8814B) & BIT_MASK_CH10_HIGH_TH_8814B)
#define BIT_SET_CH10_HIGH_TH_8814B(x, v)                                       \
	(BIT_CLEAR_CH10_HIGH_TH_8814B(x) | BIT_CH10_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH10_LOW_TH_8814B 0
#define BIT_MASK_CH10_LOW_TH_8814B 0xfff
#define BIT_CH10_LOW_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH10_LOW_TH_8814B) << BIT_SHIFT_CH10_LOW_TH_8814B)
#define BITS_CH10_LOW_TH_8814B                                                 \
	(BIT_MASK_CH10_LOW_TH_8814B << BIT_SHIFT_CH10_LOW_TH_8814B)
#define BIT_CLEAR_CH10_LOW_TH_8814B(x) ((x) & (~BITS_CH10_LOW_TH_8814B))
#define BIT_GET_CH10_LOW_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH10_LOW_TH_8814B) & BIT_MASK_CH10_LOW_TH_8814B)
#define BIT_SET_CH10_LOW_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH10_LOW_TH_8814B(x) | BIT_CH10_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_11_8814B */
#define BIT_CH11_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH11_HIGH_TH_8814B 16
#define BIT_MASK_CH11_HIGH_TH_8814B 0xfff
#define BIT_CH11_HIGH_TH_8814B(x)                                              \
	(((x) & BIT_MASK_CH11_HIGH_TH_8814B) << BIT_SHIFT_CH11_HIGH_TH_8814B)
#define BITS_CH11_HIGH_TH_8814B                                                \
	(BIT_MASK_CH11_HIGH_TH_8814B << BIT_SHIFT_CH11_HIGH_TH_8814B)
#define BIT_CLEAR_CH11_HIGH_TH_8814B(x) ((x) & (~BITS_CH11_HIGH_TH_8814B))
#define BIT_GET_CH11_HIGH_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH11_HIGH_TH_8814B) & BIT_MASK_CH11_HIGH_TH_8814B)
#define BIT_SET_CH11_HIGH_TH_8814B(x, v)                                       \
	(BIT_CLEAR_CH11_HIGH_TH_8814B(x) | BIT_CH11_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH11_LOW_TH_8814B 0
#define BIT_MASK_CH11_LOW_TH_8814B 0xfff
#define BIT_CH11_LOW_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH11_LOW_TH_8814B) << BIT_SHIFT_CH11_LOW_TH_8814B)
#define BITS_CH11_LOW_TH_8814B                                                 \
	(BIT_MASK_CH11_LOW_TH_8814B << BIT_SHIFT_CH11_LOW_TH_8814B)
#define BIT_CLEAR_CH11_LOW_TH_8814B(x) ((x) & (~BITS_CH11_LOW_TH_8814B))
#define BIT_GET_CH11_LOW_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH11_LOW_TH_8814B) & BIT_MASK_CH11_LOW_TH_8814B)
#define BIT_SET_CH11_LOW_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH11_LOW_TH_8814B(x) | BIT_CH11_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_12_8814B */
#define BIT_CH12_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH12_HIGH_TH_8814B 16
#define BIT_MASK_CH12_HIGH_TH_8814B 0xfff
#define BIT_CH12_HIGH_TH_8814B(x)                                              \
	(((x) & BIT_MASK_CH12_HIGH_TH_8814B) << BIT_SHIFT_CH12_HIGH_TH_8814B)
#define BITS_CH12_HIGH_TH_8814B                                                \
	(BIT_MASK_CH12_HIGH_TH_8814B << BIT_SHIFT_CH12_HIGH_TH_8814B)
#define BIT_CLEAR_CH12_HIGH_TH_8814B(x) ((x) & (~BITS_CH12_HIGH_TH_8814B))
#define BIT_GET_CH12_HIGH_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH12_HIGH_TH_8814B) & BIT_MASK_CH12_HIGH_TH_8814B)
#define BIT_SET_CH12_HIGH_TH_8814B(x, v)                                       \
	(BIT_CLEAR_CH12_HIGH_TH_8814B(x) | BIT_CH12_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH12_LOW_TH_8814B 0
#define BIT_MASK_CH12_LOW_TH_8814B 0xfff
#define BIT_CH12_LOW_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH12_LOW_TH_8814B) << BIT_SHIFT_CH12_LOW_TH_8814B)
#define BITS_CH12_LOW_TH_8814B                                                 \
	(BIT_MASK_CH12_LOW_TH_8814B << BIT_SHIFT_CH12_LOW_TH_8814B)
#define BIT_CLEAR_CH12_LOW_TH_8814B(x) ((x) & (~BITS_CH12_LOW_TH_8814B))
#define BIT_GET_CH12_LOW_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH12_LOW_TH_8814B) & BIT_MASK_CH12_LOW_TH_8814B)
#define BIT_SET_CH12_LOW_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH12_LOW_TH_8814B(x) | BIT_CH12_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_13_8814B */
#define BIT_CH13_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH13_HIGH_TH_8814B 16
#define BIT_MASK_CH13_HIGH_TH_8814B 0xfff
#define BIT_CH13_HIGH_TH_8814B(x)                                              \
	(((x) & BIT_MASK_CH13_HIGH_TH_8814B) << BIT_SHIFT_CH13_HIGH_TH_8814B)
#define BITS_CH13_HIGH_TH_8814B                                                \
	(BIT_MASK_CH13_HIGH_TH_8814B << BIT_SHIFT_CH13_HIGH_TH_8814B)
#define BIT_CLEAR_CH13_HIGH_TH_8814B(x) ((x) & (~BITS_CH13_HIGH_TH_8814B))
#define BIT_GET_CH13_HIGH_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH13_HIGH_TH_8814B) & BIT_MASK_CH13_HIGH_TH_8814B)
#define BIT_SET_CH13_HIGH_TH_8814B(x, v)                                       \
	(BIT_CLEAR_CH13_HIGH_TH_8814B(x) | BIT_CH13_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH13_LOW_TH_8814B 0
#define BIT_MASK_CH13_LOW_TH_8814B 0xfff
#define BIT_CH13_LOW_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH13_LOW_TH_8814B) << BIT_SHIFT_CH13_LOW_TH_8814B)
#define BITS_CH13_LOW_TH_8814B                                                 \
	(BIT_MASK_CH13_LOW_TH_8814B << BIT_SHIFT_CH13_LOW_TH_8814B)
#define BIT_CLEAR_CH13_LOW_TH_8814B(x) ((x) & (~BITS_CH13_LOW_TH_8814B))
#define BIT_GET_CH13_LOW_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH13_LOW_TH_8814B) & BIT_MASK_CH13_LOW_TH_8814B)
#define BIT_SET_CH13_LOW_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH13_LOW_TH_8814B(x) | BIT_CH13_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_14_8814B */
#define BIT_CH14_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH14_HIGH_TH_8814B 16
#define BIT_MASK_CH14_HIGH_TH_8814B 0xfff
#define BIT_CH14_HIGH_TH_8814B(x)                                              \
	(((x) & BIT_MASK_CH14_HIGH_TH_8814B) << BIT_SHIFT_CH14_HIGH_TH_8814B)
#define BITS_CH14_HIGH_TH_8814B                                                \
	(BIT_MASK_CH14_HIGH_TH_8814B << BIT_SHIFT_CH14_HIGH_TH_8814B)
#define BIT_CLEAR_CH14_HIGH_TH_8814B(x) ((x) & (~BITS_CH14_HIGH_TH_8814B))
#define BIT_GET_CH14_HIGH_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH14_HIGH_TH_8814B) & BIT_MASK_CH14_HIGH_TH_8814B)
#define BIT_SET_CH14_HIGH_TH_8814B(x, v)                                       \
	(BIT_CLEAR_CH14_HIGH_TH_8814B(x) | BIT_CH14_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH14_LOW_TH_8814B 0
#define BIT_MASK_CH14_LOW_TH_8814B 0xfff
#define BIT_CH14_LOW_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH14_LOW_TH_8814B) << BIT_SHIFT_CH14_LOW_TH_8814B)
#define BITS_CH14_LOW_TH_8814B                                                 \
	(BIT_MASK_CH14_LOW_TH_8814B << BIT_SHIFT_CH14_LOW_TH_8814B)
#define BIT_CLEAR_CH14_LOW_TH_8814B(x) ((x) & (~BITS_CH14_LOW_TH_8814B))
#define BIT_GET_CH14_LOW_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH14_LOW_TH_8814B) & BIT_MASK_CH14_LOW_TH_8814B)
#define BIT_SET_CH14_LOW_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH14_LOW_TH_8814B(x) | BIT_CH14_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_15_8814B */
#define BIT_CH15_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH15_HIGH_TH_8814B 16
#define BIT_MASK_CH15_HIGH_TH_8814B 0xfff
#define BIT_CH15_HIGH_TH_8814B(x)                                              \
	(((x) & BIT_MASK_CH15_HIGH_TH_8814B) << BIT_SHIFT_CH15_HIGH_TH_8814B)
#define BITS_CH15_HIGH_TH_8814B                                                \
	(BIT_MASK_CH15_HIGH_TH_8814B << BIT_SHIFT_CH15_HIGH_TH_8814B)
#define BIT_CLEAR_CH15_HIGH_TH_8814B(x) ((x) & (~BITS_CH15_HIGH_TH_8814B))
#define BIT_GET_CH15_HIGH_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH15_HIGH_TH_8814B) & BIT_MASK_CH15_HIGH_TH_8814B)
#define BIT_SET_CH15_HIGH_TH_8814B(x, v)                                       \
	(BIT_CLEAR_CH15_HIGH_TH_8814B(x) | BIT_CH15_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH15_LOW_TH_8814B 0
#define BIT_MASK_CH15_LOW_TH_8814B 0xfff
#define BIT_CH15_LOW_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH15_LOW_TH_8814B) << BIT_SHIFT_CH15_LOW_TH_8814B)
#define BITS_CH15_LOW_TH_8814B                                                 \
	(BIT_MASK_CH15_LOW_TH_8814B << BIT_SHIFT_CH15_LOW_TH_8814B)
#define BIT_CLEAR_CH15_LOW_TH_8814B(x) ((x) & (~BITS_CH15_LOW_TH_8814B))
#define BIT_GET_CH15_LOW_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH15_LOW_TH_8814B) & BIT_MASK_CH15_LOW_TH_8814B)
#define BIT_SET_CH15_LOW_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH15_LOW_TH_8814B(x) | BIT_CH15_LOW_TH_8814B(v))

/* 2 REG_TXPAGE_INT_CTRL_16_8814B */
#define BIT_CH16_INT_EN_8814B BIT(31)

#define BIT_SHIFT_CH16_HIGH_TH_8814B 16
#define BIT_MASK_CH16_HIGH_TH_8814B 0xfff
#define BIT_CH16_HIGH_TH_8814B(x)                                              \
	(((x) & BIT_MASK_CH16_HIGH_TH_8814B) << BIT_SHIFT_CH16_HIGH_TH_8814B)
#define BITS_CH16_HIGH_TH_8814B                                                \
	(BIT_MASK_CH16_HIGH_TH_8814B << BIT_SHIFT_CH16_HIGH_TH_8814B)
#define BIT_CLEAR_CH16_HIGH_TH_8814B(x) ((x) & (~BITS_CH16_HIGH_TH_8814B))
#define BIT_GET_CH16_HIGH_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_CH16_HIGH_TH_8814B) & BIT_MASK_CH16_HIGH_TH_8814B)
#define BIT_SET_CH16_HIGH_TH_8814B(x, v)                                       \
	(BIT_CLEAR_CH16_HIGH_TH_8814B(x) | BIT_CH16_HIGH_TH_8814B(v))

#define BIT_SHIFT_CH16_LOW_TH_8814B 0
#define BIT_MASK_CH16_LOW_TH_8814B 0xfff
#define BIT_CH16_LOW_TH_8814B(x)                                               \
	(((x) & BIT_MASK_CH16_LOW_TH_8814B) << BIT_SHIFT_CH16_LOW_TH_8814B)
#define BITS_CH16_LOW_TH_8814B                                                 \
	(BIT_MASK_CH16_LOW_TH_8814B << BIT_SHIFT_CH16_LOW_TH_8814B)
#define BIT_CLEAR_CH16_LOW_TH_8814B(x) ((x) & (~BITS_CH16_LOW_TH_8814B))
#define BIT_GET_CH16_LOW_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_CH16_LOW_TH_8814B) & BIT_MASK_CH16_LOW_TH_8814B)
#define BIT_SET_CH16_LOW_TH_8814B(x, v)                                        \
	(BIT_CLEAR_CH16_LOW_TH_8814B(x) | BIT_CH16_LOW_TH_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_PCIE_CTRL_8814B */
#define BIT_PCIEIO_PERSTB_SEL_8814B BIT(31)

#define BIT_SHIFT_PCIE_MAX_RXDMA_8814B 28
#define BIT_MASK_PCIE_MAX_RXDMA_8814B 0x7
#define BIT_PCIE_MAX_RXDMA_8814B(x)                                            \
	(((x) & BIT_MASK_PCIE_MAX_RXDMA_8814B)                                 \
	 << BIT_SHIFT_PCIE_MAX_RXDMA_8814B)
#define BITS_PCIE_MAX_RXDMA_8814B                                              \
	(BIT_MASK_PCIE_MAX_RXDMA_8814B << BIT_SHIFT_PCIE_MAX_RXDMA_8814B)
#define BIT_CLEAR_PCIE_MAX_RXDMA_8814B(x) ((x) & (~BITS_PCIE_MAX_RXDMA_8814B))
#define BIT_GET_PCIE_MAX_RXDMA_8814B(x)                                        \
	(((x) >> BIT_SHIFT_PCIE_MAX_RXDMA_8814B) &                             \
	 BIT_MASK_PCIE_MAX_RXDMA_8814B)
#define BIT_SET_PCIE_MAX_RXDMA_8814B(x, v)                                     \
	(BIT_CLEAR_PCIE_MAX_RXDMA_8814B(x) | BIT_PCIE_MAX_RXDMA_8814B(v))

#define BIT_MULRW_8814B BIT(27)

#define BIT_SHIFT_PCIE_MAX_TXDMA_8814B 24
#define BIT_MASK_PCIE_MAX_TXDMA_8814B 0x7
#define BIT_PCIE_MAX_TXDMA_8814B(x)                                            \
	(((x) & BIT_MASK_PCIE_MAX_TXDMA_8814B)                                 \
	 << BIT_SHIFT_PCIE_MAX_TXDMA_8814B)
#define BITS_PCIE_MAX_TXDMA_8814B                                              \
	(BIT_MASK_PCIE_MAX_TXDMA_8814B << BIT_SHIFT_PCIE_MAX_TXDMA_8814B)
#define BIT_CLEAR_PCIE_MAX_TXDMA_8814B(x) ((x) & (~BITS_PCIE_MAX_TXDMA_8814B))
#define BIT_GET_PCIE_MAX_TXDMA_8814B(x)                                        \
	(((x) >> BIT_SHIFT_PCIE_MAX_TXDMA_8814B) &                             \
	 BIT_MASK_PCIE_MAX_TXDMA_8814B)
#define BIT_SET_PCIE_MAX_TXDMA_8814B(x, v)                                     \
	(BIT_CLEAR_PCIE_MAX_TXDMA_8814B(x) | BIT_PCIE_MAX_TXDMA_8814B(v))

#define BIT_PWR_SCALE_START_PS_8814B BIT(23)
#define BIT_EN_CPL_TIMEOUT_PS_8814B BIT(22)
#define BIT_REG_TXDMA_FAIL_PS_8814B BIT(21)
#define BIT_PCIE_RST_TRXDMA_INTF_8814B BIT(20)
#define BIT_EN_HWENTR_L1_8814B BIT(19)
#define BIT_EN_ADV_CLKGATE_8814B BIT(18)
#define BIT_PCIE_EN_SWENT_L23_8814B BIT(17)
#define BIT_PCIE_EN_HWEXT_L1_8814B BIT(16)
#define BIT_STOP_P0_MPRT_BCNQ4_8814B BIT(6)
#define BIT_STOP_P0_MPRT_BCNQ3_8814B BIT(4)
#define BIT_STOP_P0_MPRT_BCNQ2_8814B BIT(2)
#define BIT_STOP_P0_MPRT_BCNQ1_8814B BIT(0)

/* 2 REG_ACH_CTRL_8814B */
#define BIT_STOP_P0HIQ19_8814B BIT(27)
#define BIT_STOP_P0HIQ18_8814B BIT(26)
#define BIT_STOP_P0HIQ17_8814B BIT(25)
#define BIT_STOP_P0HIQ16_8814B BIT(24)
#define BIT_RX_CLOSE_EN_V1_8814B BIT(21)
#define BIT_STOP_FWCMDQ_8814B BIT(20)
#define BIT_STOP_P0BCNQ_8814B BIT(18)
#define BIT_STOP_P0MGQ_8814B BIT(16)
#define BIT_STOP_ACH13_8814B BIT(15)
#define BIT_STOP_ACH12_8814B BIT(14)
#define BIT_STOP_ACH11_8814B BIT(13)
#define BIT_STOP_ACH10_8814B BIT(12)
#define BIT_STOP_ACH9_8814B BIT(11)
#define BIT_STOP_ACH8_8814B BIT(10)
#define BIT_STOP_ACH7_8814B BIT(9)
#define BIT_STOP_ACH6_8814B BIT(8)
#define BIT_STOP_ACH5_8814B BIT(7)
#define BIT_STOP_ACH4_8814B BIT(6)
#define BIT_STOP_ACH3_8814B BIT(5)
#define BIT_STOP_ACH2_8814B BIT(4)
#define BIT_STOP_ACH1_8814B BIT(3)
#define BIT_STOP_ACH0_8814B BIT(2)
#define BIT_STOP_P0RX_8814B BIT(0)

/* 2 REG_HIQ_CTRL_8814B */
#define BIT_STOP_P0HIQ15_8814B BIT(15)
#define BIT_STOP_P0HIQ14_8814B BIT(14)
#define BIT_STOP_P0HIQ13_8814B BIT(13)
#define BIT_STOP_P0HIQ12_8814B BIT(12)
#define BIT_STOP_P0HIQ11_8814B BIT(11)
#define BIT_STOP_P0HIQ10_8814B BIT(10)
#define BIT_STOP_P0HIQ9_8814B BIT(9)
#define BIT_STOP_P0HIQ8_8814B BIT(8)
#define BIT_STOP_P0HIQ7_8814B BIT(7)
#define BIT_STOP_P0HIQ6_8814B BIT(6)
#define BIT_STOP_P0HIQ5_8814B BIT(5)
#define BIT_STOP_P0HIQ4_8814B BIT(4)
#define BIT_STOP_P0HIQ3_8814B BIT(3)
#define BIT_STOP_P0HIQ2_8814B BIT(2)
#define BIT_STOP_P0HIQ1_8814B BIT(1)
#define BIT_STOP_P0HIQ0_8814B BIT(0)

/* 2 REG_INT_MIG_V1_8814B */

#define BIT_SHIFT_TXTTIMER_MATCH_NUM_8814B 28
#define BIT_MASK_TXTTIMER_MATCH_NUM_8814B 0xf
#define BIT_TXTTIMER_MATCH_NUM_8814B(x)                                        \
	(((x) & BIT_MASK_TXTTIMER_MATCH_NUM_8814B)                             \
	 << BIT_SHIFT_TXTTIMER_MATCH_NUM_8814B)
#define BITS_TXTTIMER_MATCH_NUM_8814B                                          \
	(BIT_MASK_TXTTIMER_MATCH_NUM_8814B                                     \
	 << BIT_SHIFT_TXTTIMER_MATCH_NUM_8814B)
#define BIT_CLEAR_TXTTIMER_MATCH_NUM_8814B(x)                                  \
	((x) & (~BITS_TXTTIMER_MATCH_NUM_8814B))
#define BIT_GET_TXTTIMER_MATCH_NUM_8814B(x)                                    \
	(((x) >> BIT_SHIFT_TXTTIMER_MATCH_NUM_8814B) &                         \
	 BIT_MASK_TXTTIMER_MATCH_NUM_8814B)
#define BIT_SET_TXTTIMER_MATCH_NUM_8814B(x, v)                                 \
	(BIT_CLEAR_TXTTIMER_MATCH_NUM_8814B(x) |                               \
	 BIT_TXTTIMER_MATCH_NUM_8814B(v))

#define BIT_SHIFT_TXPKT_NUM_MATCH_8814B 24
#define BIT_MASK_TXPKT_NUM_MATCH_8814B 0xf
#define BIT_TXPKT_NUM_MATCH_8814B(x)                                           \
	(((x) & BIT_MASK_TXPKT_NUM_MATCH_8814B)                                \
	 << BIT_SHIFT_TXPKT_NUM_MATCH_8814B)
#define BITS_TXPKT_NUM_MATCH_8814B                                             \
	(BIT_MASK_TXPKT_NUM_MATCH_8814B << BIT_SHIFT_TXPKT_NUM_MATCH_8814B)
#define BIT_CLEAR_TXPKT_NUM_MATCH_8814B(x) ((x) & (~BITS_TXPKT_NUM_MATCH_8814B))
#define BIT_GET_TXPKT_NUM_MATCH_8814B(x)                                       \
	(((x) >> BIT_SHIFT_TXPKT_NUM_MATCH_8814B) &                            \
	 BIT_MASK_TXPKT_NUM_MATCH_8814B)
#define BIT_SET_TXPKT_NUM_MATCH_8814B(x, v)                                    \
	(BIT_CLEAR_TXPKT_NUM_MATCH_8814B(x) | BIT_TXPKT_NUM_MATCH_8814B(v))

#define BIT_SHIFT_RXTTIMER_MATCH_NUM_8814B 20
#define BIT_MASK_RXTTIMER_MATCH_NUM_8814B 0xf
#define BIT_RXTTIMER_MATCH_NUM_8814B(x)                                        \
	(((x) & BIT_MASK_RXTTIMER_MATCH_NUM_8814B)                             \
	 << BIT_SHIFT_RXTTIMER_MATCH_NUM_8814B)
#define BITS_RXTTIMER_MATCH_NUM_8814B                                          \
	(BIT_MASK_RXTTIMER_MATCH_NUM_8814B                                     \
	 << BIT_SHIFT_RXTTIMER_MATCH_NUM_8814B)
#define BIT_CLEAR_RXTTIMER_MATCH_NUM_8814B(x)                                  \
	((x) & (~BITS_RXTTIMER_MATCH_NUM_8814B))
#define BIT_GET_RXTTIMER_MATCH_NUM_8814B(x)                                    \
	(((x) >> BIT_SHIFT_RXTTIMER_MATCH_NUM_8814B) &                         \
	 BIT_MASK_RXTTIMER_MATCH_NUM_8814B)
#define BIT_SET_RXTTIMER_MATCH_NUM_8814B(x, v)                                 \
	(BIT_CLEAR_RXTTIMER_MATCH_NUM_8814B(x) |                               \
	 BIT_RXTTIMER_MATCH_NUM_8814B(v))

#define BIT_SHIFT_RXPKT_NUM_MATCH_8814B 16
#define BIT_MASK_RXPKT_NUM_MATCH_8814B 0xf
#define BIT_RXPKT_NUM_MATCH_8814B(x)                                           \
	(((x) & BIT_MASK_RXPKT_NUM_MATCH_8814B)                                \
	 << BIT_SHIFT_RXPKT_NUM_MATCH_8814B)
#define BITS_RXPKT_NUM_MATCH_8814B                                             \
	(BIT_MASK_RXPKT_NUM_MATCH_8814B << BIT_SHIFT_RXPKT_NUM_MATCH_8814B)
#define BIT_CLEAR_RXPKT_NUM_MATCH_8814B(x) ((x) & (~BITS_RXPKT_NUM_MATCH_8814B))
#define BIT_GET_RXPKT_NUM_MATCH_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RXPKT_NUM_MATCH_8814B) &                            \
	 BIT_MASK_RXPKT_NUM_MATCH_8814B)
#define BIT_SET_RXPKT_NUM_MATCH_8814B(x, v)                                    \
	(BIT_CLEAR_RXPKT_NUM_MATCH_8814B(x) | BIT_RXPKT_NUM_MATCH_8814B(v))

#define BIT_SHIFT_MIGRATE_TIMER_8814B 0
#define BIT_MASK_MIGRATE_TIMER_8814B 0xffff
#define BIT_MIGRATE_TIMER_8814B(x)                                             \
	(((x) & BIT_MASK_MIGRATE_TIMER_8814B) << BIT_SHIFT_MIGRATE_TIMER_8814B)
#define BITS_MIGRATE_TIMER_8814B                                               \
	(BIT_MASK_MIGRATE_TIMER_8814B << BIT_SHIFT_MIGRATE_TIMER_8814B)
#define BIT_CLEAR_MIGRATE_TIMER_8814B(x) ((x) & (~BITS_MIGRATE_TIMER_8814B))
#define BIT_GET_MIGRATE_TIMER_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MIGRATE_TIMER_8814B) & BIT_MASK_MIGRATE_TIMER_8814B)
#define BIT_SET_MIGRATE_TIMER_8814B(x, v)                                      \
	(BIT_CLEAR_MIGRATE_TIMER_8814B(x) | BIT_MIGRATE_TIMER_8814B(v))

/* 2 REG_P0MGQ_TXBD_DESA_L_8814B */

/* 2 REG_P0MGQ_TXBD_DESA_H_8814B */

/* 2 REG_ACH0_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH0_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH0_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH0_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH0_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH0_TXBD_DESA_L_8814B)
#define BITS_ACH0_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH0_TXBD_DESA_L_8814B << BIT_SHIFT_ACH0_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH0_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH0_TXBD_DESA_L_8814B))
#define BIT_GET_ACH0_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH0_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH0_TXBD_DESA_L_8814B)
#define BIT_SET_ACH0_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH0_TXBD_DESA_L_8814B(x) | BIT_ACH0_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH0_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH0_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH0_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH0_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH0_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH0_TXBD_DESA_H_8814B)
#define BITS_ACH0_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH0_TXBD_DESA_H_8814B << BIT_SHIFT_ACH0_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH0_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH0_TXBD_DESA_H_8814B))
#define BIT_GET_ACH0_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH0_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH0_TXBD_DESA_H_8814B)
#define BIT_SET_ACH0_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH0_TXBD_DESA_H_8814B(x) | BIT_ACH0_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH1_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH1_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH1_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH1_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH1_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH1_TXBD_DESA_L_8814B)
#define BITS_ACH1_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH1_TXBD_DESA_L_8814B << BIT_SHIFT_ACH1_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH1_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH1_TXBD_DESA_L_8814B))
#define BIT_GET_ACH1_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH1_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH1_TXBD_DESA_L_8814B)
#define BIT_SET_ACH1_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH1_TXBD_DESA_L_8814B(x) | BIT_ACH1_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH1_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH1_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH1_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH1_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH1_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH1_TXBD_DESA_H_8814B)
#define BITS_ACH1_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH1_TXBD_DESA_H_8814B << BIT_SHIFT_ACH1_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH1_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH1_TXBD_DESA_H_8814B))
#define BIT_GET_ACH1_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH1_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH1_TXBD_DESA_H_8814B)
#define BIT_SET_ACH1_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH1_TXBD_DESA_H_8814B(x) | BIT_ACH1_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH2_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH2_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH2_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH2_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH2_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH2_TXBD_DESA_L_8814B)
#define BITS_ACH2_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH2_TXBD_DESA_L_8814B << BIT_SHIFT_ACH2_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH2_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH2_TXBD_DESA_L_8814B))
#define BIT_GET_ACH2_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH2_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH2_TXBD_DESA_L_8814B)
#define BIT_SET_ACH2_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH2_TXBD_DESA_L_8814B(x) | BIT_ACH2_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH2_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH2_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH2_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH2_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH2_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH2_TXBD_DESA_H_8814B)
#define BITS_ACH2_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH2_TXBD_DESA_H_8814B << BIT_SHIFT_ACH2_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH2_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH2_TXBD_DESA_H_8814B))
#define BIT_GET_ACH2_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH2_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH2_TXBD_DESA_H_8814B)
#define BIT_SET_ACH2_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH2_TXBD_DESA_H_8814B(x) | BIT_ACH2_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH3_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH3_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH3_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH3_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH3_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH3_TXBD_DESA_L_8814B)
#define BITS_ACH3_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH3_TXBD_DESA_L_8814B << BIT_SHIFT_ACH3_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH3_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH3_TXBD_DESA_L_8814B))
#define BIT_GET_ACH3_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH3_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH3_TXBD_DESA_L_8814B)
#define BIT_SET_ACH3_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH3_TXBD_DESA_L_8814B(x) | BIT_ACH3_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH3_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH3_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH3_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH3_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH3_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH3_TXBD_DESA_H_8814B)
#define BITS_ACH3_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH3_TXBD_DESA_H_8814B << BIT_SHIFT_ACH3_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH3_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH3_TXBD_DESA_H_8814B))
#define BIT_GET_ACH3_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH3_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH3_TXBD_DESA_H_8814B)
#define BIT_SET_ACH3_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH3_TXBD_DESA_H_8814B(x) | BIT_ACH3_TXBD_DESA_H_8814B(v))

/* 2 REG_P0RXQ_RXBD_DESA_L_8814B */

#define BIT_SHIFT_P0RXQ_RXBD_DESA_L_8814B 0
#define BIT_MASK_P0RXQ_RXBD_DESA_L_8814B 0xffffffffL
#define BIT_P0RXQ_RXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_P0RXQ_RXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_P0RXQ_RXBD_DESA_L_8814B)
#define BITS_P0RXQ_RXBD_DESA_L_8814B                                           \
	(BIT_MASK_P0RXQ_RXBD_DESA_L_8814B << BIT_SHIFT_P0RXQ_RXBD_DESA_L_8814B)
#define BIT_CLEAR_P0RXQ_RXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_P0RXQ_RXBD_DESA_L_8814B))
#define BIT_GET_P0RXQ_RXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0RXQ_RXBD_DESA_L_8814B) &                          \
	 BIT_MASK_P0RXQ_RXBD_DESA_L_8814B)
#define BIT_SET_P0RXQ_RXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_P0RXQ_RXBD_DESA_L_8814B(x) | BIT_P0RXQ_RXBD_DESA_L_8814B(v))

/* 2 REG_P0RXQ_RXBD_DESA_H_8814B */

#define BIT_SHIFT_P0RXQ_RXBD_DESA_H_8814B 0
#define BIT_MASK_P0RXQ_RXBD_DESA_H_8814B 0xffffffffL
#define BIT_P0RXQ_RXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_P0RXQ_RXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_P0RXQ_RXBD_DESA_H_8814B)
#define BITS_P0RXQ_RXBD_DESA_H_8814B                                           \
	(BIT_MASK_P0RXQ_RXBD_DESA_H_8814B << BIT_SHIFT_P0RXQ_RXBD_DESA_H_8814B)
#define BIT_CLEAR_P0RXQ_RXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_P0RXQ_RXBD_DESA_H_8814B))
#define BIT_GET_P0RXQ_RXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0RXQ_RXBD_DESA_H_8814B) &                          \
	 BIT_MASK_P0RXQ_RXBD_DESA_H_8814B)
#define BIT_SET_P0RXQ_RXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_P0RXQ_RXBD_DESA_H_8814B(x) | BIT_P0RXQ_RXBD_DESA_H_8814B(v))

/* 2 REG_P0BCNQ_TXBD_DESA_L_8814B */

#define BIT_SHIFT_P0BCNQ_TXBD_DESA_L_8814B 0
#define BIT_MASK_P0BCNQ_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_P0BCNQ_TXBD_DESA_L_8814B(x)                                        \
	(((x) & BIT_MASK_P0BCNQ_TXBD_DESA_L_8814B)                             \
	 << BIT_SHIFT_P0BCNQ_TXBD_DESA_L_8814B)
#define BITS_P0BCNQ_TXBD_DESA_L_8814B                                          \
	(BIT_MASK_P0BCNQ_TXBD_DESA_L_8814B                                     \
	 << BIT_SHIFT_P0BCNQ_TXBD_DESA_L_8814B)
#define BIT_CLEAR_P0BCNQ_TXBD_DESA_L_8814B(x)                                  \
	((x) & (~BITS_P0BCNQ_TXBD_DESA_L_8814B))
#define BIT_GET_P0BCNQ_TXBD_DESA_L_8814B(x)                                    \
	(((x) >> BIT_SHIFT_P0BCNQ_TXBD_DESA_L_8814B) &                         \
	 BIT_MASK_P0BCNQ_TXBD_DESA_L_8814B)
#define BIT_SET_P0BCNQ_TXBD_DESA_L_8814B(x, v)                                 \
	(BIT_CLEAR_P0BCNQ_TXBD_DESA_L_8814B(x) |                               \
	 BIT_P0BCNQ_TXBD_DESA_L_8814B(v))

/* 2 REG_P0BCNQ_TXBD_DESA_H_8814B */

#define BIT_SHIFT_P0BCNQ_TXBD_DESA_H_8814B 0
#define BIT_MASK_P0BCNQ_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_P0BCNQ_TXBD_DESA_H_8814B(x)                                        \
	(((x) & BIT_MASK_P0BCNQ_TXBD_DESA_H_8814B)                             \
	 << BIT_SHIFT_P0BCNQ_TXBD_DESA_H_8814B)
#define BITS_P0BCNQ_TXBD_DESA_H_8814B                                          \
	(BIT_MASK_P0BCNQ_TXBD_DESA_H_8814B                                     \
	 << BIT_SHIFT_P0BCNQ_TXBD_DESA_H_8814B)
#define BIT_CLEAR_P0BCNQ_TXBD_DESA_H_8814B(x)                                  \
	((x) & (~BITS_P0BCNQ_TXBD_DESA_H_8814B))
#define BIT_GET_P0BCNQ_TXBD_DESA_H_8814B(x)                                    \
	(((x) >> BIT_SHIFT_P0BCNQ_TXBD_DESA_H_8814B) &                         \
	 BIT_MASK_P0BCNQ_TXBD_DESA_H_8814B)
#define BIT_SET_P0BCNQ_TXBD_DESA_H_8814B(x, v)                                 \
	(BIT_CLEAR_P0BCNQ_TXBD_DESA_H_8814B(x) |                               \
	 BIT_P0BCNQ_TXBD_DESA_H_8814B(v))

/* 2 REG_FWCMDQ_TXBD_DESA_L_8814B */

#define BIT_SHIFT_FWCMDQ_TXBD_DESA_L_8814B 0
#define BIT_MASK_FWCMDQ_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_FWCMDQ_TXBD_DESA_L_8814B(x)                                        \
	(((x) & BIT_MASK_FWCMDQ_TXBD_DESA_L_8814B)                             \
	 << BIT_SHIFT_FWCMDQ_TXBD_DESA_L_8814B)
#define BITS_FWCMDQ_TXBD_DESA_L_8814B                                          \
	(BIT_MASK_FWCMDQ_TXBD_DESA_L_8814B                                     \
	 << BIT_SHIFT_FWCMDQ_TXBD_DESA_L_8814B)
#define BIT_CLEAR_FWCMDQ_TXBD_DESA_L_8814B(x)                                  \
	((x) & (~BITS_FWCMDQ_TXBD_DESA_L_8814B))
#define BIT_GET_FWCMDQ_TXBD_DESA_L_8814B(x)                                    \
	(((x) >> BIT_SHIFT_FWCMDQ_TXBD_DESA_L_8814B) &                         \
	 BIT_MASK_FWCMDQ_TXBD_DESA_L_8814B)
#define BIT_SET_FWCMDQ_TXBD_DESA_L_8814B(x, v)                                 \
	(BIT_CLEAR_FWCMDQ_TXBD_DESA_L_8814B(x) |                               \
	 BIT_FWCMDQ_TXBD_DESA_L_8814B(v))

/* 2 REG_FWCMDQ_TXBD_DESA_H_8814B */

#define BIT_SHIFT_FWCMDQ_TXBD_DESA_H_8814B 0
#define BIT_MASK_FWCMDQ_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_FWCMDQ_TXBD_DESA_H_8814B(x)                                        \
	(((x) & BIT_MASK_FWCMDQ_TXBD_DESA_H_8814B)                             \
	 << BIT_SHIFT_FWCMDQ_TXBD_DESA_H_8814B)
#define BITS_FWCMDQ_TXBD_DESA_H_8814B                                          \
	(BIT_MASK_FWCMDQ_TXBD_DESA_H_8814B                                     \
	 << BIT_SHIFT_FWCMDQ_TXBD_DESA_H_8814B)
#define BIT_CLEAR_FWCMDQ_TXBD_DESA_H_8814B(x)                                  \
	((x) & (~BITS_FWCMDQ_TXBD_DESA_H_8814B))
#define BIT_GET_FWCMDQ_TXBD_DESA_H_8814B(x)                                    \
	(((x) >> BIT_SHIFT_FWCMDQ_TXBD_DESA_H_8814B) &                         \
	 BIT_MASK_FWCMDQ_TXBD_DESA_H_8814B)
#define BIT_SET_FWCMDQ_TXBD_DESA_H_8814B(x, v)                                 \
	(BIT_CLEAR_FWCMDQ_TXBD_DESA_H_8814B(x) |                               \
	 BIT_FWCMDQ_TXBD_DESA_H_8814B(v))

/* 2 REG_PCIE_HRPWM1_HCPWM1_DCPU_8814B */

#define BIT_SHIFT_PCIE_HCPWM1_DCPU_8814B 16
#define BIT_MASK_PCIE_HCPWM1_DCPU_8814B 0xff
#define BIT_PCIE_HCPWM1_DCPU_8814B(x)                                          \
	(((x) & BIT_MASK_PCIE_HCPWM1_DCPU_8814B)                               \
	 << BIT_SHIFT_PCIE_HCPWM1_DCPU_8814B)
#define BITS_PCIE_HCPWM1_DCPU_8814B                                            \
	(BIT_MASK_PCIE_HCPWM1_DCPU_8814B << BIT_SHIFT_PCIE_HCPWM1_DCPU_8814B)
#define BIT_CLEAR_PCIE_HCPWM1_DCPU_8814B(x)                                    \
	((x) & (~BITS_PCIE_HCPWM1_DCPU_8814B))
#define BIT_GET_PCIE_HCPWM1_DCPU_8814B(x)                                      \
	(((x) >> BIT_SHIFT_PCIE_HCPWM1_DCPU_8814B) &                           \
	 BIT_MASK_PCIE_HCPWM1_DCPU_8814B)
#define BIT_SET_PCIE_HCPWM1_DCPU_8814B(x, v)                                   \
	(BIT_CLEAR_PCIE_HCPWM1_DCPU_8814B(x) | BIT_PCIE_HCPWM1_DCPU_8814B(v))

#define BIT_SHIFT_PCIE_HRPWM1_DCPU_8814B 8
#define BIT_MASK_PCIE_HRPWM1_DCPU_8814B 0xff
#define BIT_PCIE_HRPWM1_DCPU_8814B(x)                                          \
	(((x) & BIT_MASK_PCIE_HRPWM1_DCPU_8814B)                               \
	 << BIT_SHIFT_PCIE_HRPWM1_DCPU_8814B)
#define BITS_PCIE_HRPWM1_DCPU_8814B                                            \
	(BIT_MASK_PCIE_HRPWM1_DCPU_8814B << BIT_SHIFT_PCIE_HRPWM1_DCPU_8814B)
#define BIT_CLEAR_PCIE_HRPWM1_DCPU_8814B(x)                                    \
	((x) & (~BITS_PCIE_HRPWM1_DCPU_8814B))
#define BIT_GET_PCIE_HRPWM1_DCPU_8814B(x)                                      \
	(((x) >> BIT_SHIFT_PCIE_HRPWM1_DCPU_8814B) &                           \
	 BIT_MASK_PCIE_HRPWM1_DCPU_8814B)
#define BIT_SET_PCIE_HRPWM1_DCPU_8814B(x, v)                                   \
	(BIT_CLEAR_PCIE_HRPWM1_DCPU_8814B(x) | BIT_PCIE_HRPWM1_DCPU_8814B(v))

/* 2 REG_P0_MPRT_BCNQ_TXBD_DESA_L_8814B */

#define BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_L_8814B 0
#define BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_P0_MPRT_BCNQ_TXBD_DESA_L_8814B(x)                                  \
	(((x) & BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_L_8814B)                       \
	 << BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_L_8814B)
#define BITS_P0_MPRT_BCNQ_TXBD_DESA_L_8814B                                    \
	(BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_L_8814B                               \
	 << BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_L_8814B)
#define BIT_CLEAR_P0_MPRT_BCNQ_TXBD_DESA_L_8814B(x)                            \
	((x) & (~BITS_P0_MPRT_BCNQ_TXBD_DESA_L_8814B))
#define BIT_GET_P0_MPRT_BCNQ_TXBD_DESA_L_8814B(x)                              \
	(((x) >> BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_L_8814B) &                   \
	 BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_L_8814B)
#define BIT_SET_P0_MPRT_BCNQ_TXBD_DESA_L_8814B(x, v)                           \
	(BIT_CLEAR_P0_MPRT_BCNQ_TXBD_DESA_L_8814B(x) |                         \
	 BIT_P0_MPRT_BCNQ_TXBD_DESA_L_8814B(v))

/* 2 REG_P0_MPRT_BCNQ_TXBD_DESA_H_8814B */

#define BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_H_8814B 0
#define BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_P0_MPRT_BCNQ_TXBD_DESA_H_8814B(x)                                  \
	(((x) & BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_H_8814B)                       \
	 << BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_H_8814B)
#define BITS_P0_MPRT_BCNQ_TXBD_DESA_H_8814B                                    \
	(BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_H_8814B                               \
	 << BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_H_8814B)
#define BIT_CLEAR_P0_MPRT_BCNQ_TXBD_DESA_H_8814B(x)                            \
	((x) & (~BITS_P0_MPRT_BCNQ_TXBD_DESA_H_8814B))
#define BIT_GET_P0_MPRT_BCNQ_TXBD_DESA_H_8814B(x)                              \
	(((x) >> BIT_SHIFT_P0_MPRT_BCNQ_TXBD_DESA_H_8814B) &                   \
	 BIT_MASK_P0_MPRT_BCNQ_TXBD_DESA_H_8814B)
#define BIT_SET_P0_MPRT_BCNQ_TXBD_DESA_H_8814B(x, v)                           \
	(BIT_CLEAR_P0_MPRT_BCNQ_TXBD_DESA_H_8814B(x) |                         \
	 BIT_P0_MPRT_BCNQ_TXBD_DESA_H_8814B(v))

/* 2 REG_P0_MPRT_BCNQ_TXRXBD_NUM_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_P0_MPRT_BCNQ_DESC_MODE_8814B 13
#define BIT_MASK_P0_MPRT_BCNQ_DESC_MODE_8814B 0x3
#define BIT_P0_MPRT_BCNQ_DESC_MODE_8814B(x)                                    \
	(((x) & BIT_MASK_P0_MPRT_BCNQ_DESC_MODE_8814B)                         \
	 << BIT_SHIFT_P0_MPRT_BCNQ_DESC_MODE_8814B)
#define BITS_P0_MPRT_BCNQ_DESC_MODE_8814B                                      \
	(BIT_MASK_P0_MPRT_BCNQ_DESC_MODE_8814B                                 \
	 << BIT_SHIFT_P0_MPRT_BCNQ_DESC_MODE_8814B)
#define BIT_CLEAR_P0_MPRT_BCNQ_DESC_MODE_8814B(x)                              \
	((x) & (~BITS_P0_MPRT_BCNQ_DESC_MODE_8814B))
#define BIT_GET_P0_MPRT_BCNQ_DESC_MODE_8814B(x)                                \
	(((x) >> BIT_SHIFT_P0_MPRT_BCNQ_DESC_MODE_8814B) &                     \
	 BIT_MASK_P0_MPRT_BCNQ_DESC_MODE_8814B)
#define BIT_SET_P0_MPRT_BCNQ_DESC_MODE_8814B(x, v)                             \
	(BIT_CLEAR_P0_MPRT_BCNQ_DESC_MODE_8814B(x) |                           \
	 BIT_P0_MPRT_BCNQ_DESC_MODE_8814B(v))

#define BIT_PCIE_P0MPRT_BCNQ4_FLAG_8814B BIT(11)
#define BIT_PCIE_P0MPRT_BCNQ3_FLAG_8814B BIT(10)
#define BIT_PCIE_P0MPRT_BCNQ2_FLAG_8814B BIT(9)
#define BIT_PCIE_P0MPRT_BCNQ1_FLAG_8814B BIT(8)
#define BIT_EPHY_CAL_DONE_8814B BIT(1)
#define BIT_RESET_APHY_8814B BIT(0)

/* 2 REG_BD_RWPTR_CLR2_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_ACH7_HW_IDX_8814B BIT(21)
#define BIT_CLR_ACH6_HW_IDX_8814B BIT(20)
#define BIT_CLR_ACH5_HW_IDX_8814B BIT(19)
#define BIT_CLR_ACH4_HW_IDX_8814B BIT(18)

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_ACH7_HOST_IDX_8814B BIT(5)
#define BIT_CLR_ACH6_HOST_IDX_8814B BIT(4)
#define BIT_CLR_ACH5_HOST_IDX_8814B BIT(3)
#define BIT_CLR_ACH4_HOST_IDX_8814B BIT(2)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_BD_RWPTR_CLR3_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_P0HI15Q_HW_IDX_8814B BIT(29)
#define BIT_CLR_P0HI14Q_HW_IDX_8814B BIT(28)
#define BIT_CLR_P0HI13Q_HW_IDX_8814B BIT(27)
#define BIT_CLR_P0HI12Q_HW_IDX_8814B BIT(26)
#define BIT_CLR_P0HI11Q_HW_IDX_8814B BIT(25)
#define BIT_CLR_P0HI10Q_HW_IDX_8814B BIT(24)
#define BIT_CLR_P0HI9Q_HW_IDX_8814B BIT(23)
#define BIT_CLR_P0HI8Q_HW_IDX_8814B BIT(22)
#define BIT_CLR_ACH13_HW_IDX_8814B BIT(21)
#define BIT_CLR_ACH12_HW_IDX_8814B BIT(20)
#define BIT_CLR_ACH11_HW_IDX_8814B BIT(19)
#define BIT_CLR_ACH10_HW_IDX_8814B BIT(18)
#define BIT_CLR_ACH9_HW_IDX_8814B BIT(17)
#define BIT_CLR_ACH8_HW_IDX_8814B BIT(16)

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_P0HI15Q_HOST_IDX_8814B BIT(13)
#define BIT_CLR_P0HI14Q_HOST_IDX_8814B BIT(12)
#define BIT_CLR_P0HI13Q_HOST_IDX_8814B BIT(11)
#define BIT_CLR_P0HI12Q_HOST_IDX_8814B BIT(10)
#define BIT_CLR_P0HI11Q_HOST_IDX_8814B BIT(9)
#define BIT_CLR_P0HI10Q_HOST_IDX_8814B BIT(8)
#define BIT_CLR_P0HI9Q_HOST_IDX_8814B BIT(7)
#define BIT_CLR_P0HI8Q_HOST_IDX_8814B BIT(6)
#define BIT_CLR_ACH13_HOST_IDX_8814B BIT(5)
#define BIT_CLR_ACH12_HOST_IDX_8814B BIT(4)
#define BIT_CLR_ACH11_HOST_IDX_8814B BIT(3)
#define BIT_CLR_ACH10_HOST_IDX_8814B BIT(2)
#define BIT_CLR_ACH9_HOST_IDX_8814B BIT(1)
#define BIT_CLR_ACH8_HOST_IDX_8814B BIT(0)

/* 2 REG_P0MGQ_RXQ_TXRXBD_NUM_8814B */
#define BIT_SYS_32_64_V1_8814B BIT(31)

#define BIT_SHIFT_P0BCNQ_DESC_MODE_8814B 29
#define BIT_MASK_P0BCNQ_DESC_MODE_8814B 0x3
#define BIT_P0BCNQ_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0BCNQ_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0BCNQ_DESC_MODE_8814B)
#define BITS_P0BCNQ_DESC_MODE_8814B                                            \
	(BIT_MASK_P0BCNQ_DESC_MODE_8814B << BIT_SHIFT_P0BCNQ_DESC_MODE_8814B)
#define BIT_CLEAR_P0BCNQ_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0BCNQ_DESC_MODE_8814B))
#define BIT_GET_P0BCNQ_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0BCNQ_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0BCNQ_DESC_MODE_8814B)
#define BIT_SET_P0BCNQ_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0BCNQ_DESC_MODE_8814B(x) | BIT_P0BCNQ_DESC_MODE_8814B(v))

#define BIT_PCIE_P0BCNQ_FLAG_8814B BIT(28)

#define BIT_SHIFT_P0RXQ_DESC_NUM_8814B 16
#define BIT_MASK_P0RXQ_DESC_NUM_8814B 0xfff
#define BIT_P0RXQ_DESC_NUM_8814B(x)                                            \
	(((x) & BIT_MASK_P0RXQ_DESC_NUM_8814B)                                 \
	 << BIT_SHIFT_P0RXQ_DESC_NUM_8814B)
#define BITS_P0RXQ_DESC_NUM_8814B                                              \
	(BIT_MASK_P0RXQ_DESC_NUM_8814B << BIT_SHIFT_P0RXQ_DESC_NUM_8814B)
#define BIT_CLEAR_P0RXQ_DESC_NUM_8814B(x) ((x) & (~BITS_P0RXQ_DESC_NUM_8814B))
#define BIT_GET_P0RXQ_DESC_NUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0RXQ_DESC_NUM_8814B) &                             \
	 BIT_MASK_P0RXQ_DESC_NUM_8814B)
#define BIT_SET_P0RXQ_DESC_NUM_8814B(x, v)                                     \
	(BIT_CLEAR_P0RXQ_DESC_NUM_8814B(x) | BIT_P0RXQ_DESC_NUM_8814B(v))

#define BIT_PCIE_P0MGQ_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0MGQ_DESC_MODE_8814B 12
#define BIT_MASK_P0MGQ_DESC_MODE_8814B 0x3
#define BIT_P0MGQ_DESC_MODE_8814B(x)                                           \
	(((x) & BIT_MASK_P0MGQ_DESC_MODE_8814B)                                \
	 << BIT_SHIFT_P0MGQ_DESC_MODE_8814B)
#define BITS_P0MGQ_DESC_MODE_8814B                                             \
	(BIT_MASK_P0MGQ_DESC_MODE_8814B << BIT_SHIFT_P0MGQ_DESC_MODE_8814B)
#define BIT_CLEAR_P0MGQ_DESC_MODE_8814B(x) ((x) & (~BITS_P0MGQ_DESC_MODE_8814B))
#define BIT_GET_P0MGQ_DESC_MODE_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0MGQ_DESC_MODE_8814B) &                            \
	 BIT_MASK_P0MGQ_DESC_MODE_8814B)
#define BIT_SET_P0MGQ_DESC_MODE_8814B(x, v)                                    \
	(BIT_CLEAR_P0MGQ_DESC_MODE_8814B(x) | BIT_P0MGQ_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0MGQ_DESC_NUM_8814B 0
#define BIT_MASK_P0MGQ_DESC_NUM_8814B 0xfff
#define BIT_P0MGQ_DESC_NUM_8814B(x)                                            \
	(((x) & BIT_MASK_P0MGQ_DESC_NUM_8814B)                                 \
	 << BIT_SHIFT_P0MGQ_DESC_NUM_8814B)
#define BITS_P0MGQ_DESC_NUM_8814B                                              \
	(BIT_MASK_P0MGQ_DESC_NUM_8814B << BIT_SHIFT_P0MGQ_DESC_NUM_8814B)
#define BIT_CLEAR_P0MGQ_DESC_NUM_8814B(x) ((x) & (~BITS_P0MGQ_DESC_NUM_8814B))
#define BIT_GET_P0MGQ_DESC_NUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0MGQ_DESC_NUM_8814B) &                             \
	 BIT_MASK_P0MGQ_DESC_NUM_8814B)
#define BIT_SET_P0MGQ_DESC_NUM_8814B(x, v)                                     \
	(BIT_CLEAR_P0MGQ_DESC_NUM_8814B(x) | BIT_P0MGQ_DESC_NUM_8814B(v))

/* 2 REG_CHNL_DMA_CFG_8814B */
#define BIT_TXHCI_EN_8814B BIT(26)
#define BIT_TXHCI_IDLE_8814B BIT(25)
#define BIT_DMA_PRI_EN_8814B BIT(24)

/* 2 REG_FWCMDQ_TXBD_NUM_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_PCIE_FWCMDQ_FLAG_8814B BIT(14)

#define BIT_SHIFT_FWCMDQ_DESC_MODE_8814B 12
#define BIT_MASK_FWCMDQ_DESC_MODE_8814B 0x3
#define BIT_FWCMDQ_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_FWCMDQ_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_FWCMDQ_DESC_MODE_8814B)
#define BITS_FWCMDQ_DESC_MODE_8814B                                            \
	(BIT_MASK_FWCMDQ_DESC_MODE_8814B << BIT_SHIFT_FWCMDQ_DESC_MODE_8814B)
#define BIT_CLEAR_FWCMDQ_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_FWCMDQ_DESC_MODE_8814B))
#define BIT_GET_FWCMDQ_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_FWCMDQ_DESC_MODE_8814B) &                           \
	 BIT_MASK_FWCMDQ_DESC_MODE_8814B)
#define BIT_SET_FWCMDQ_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_FWCMDQ_DESC_MODE_8814B(x) | BIT_FWCMDQ_DESC_MODE_8814B(v))

#define BIT_SHIFT_FWCMDQ_DESC_NUM_8814B 0
#define BIT_MASK_FWCMDQ_DESC_NUM_8814B 0xfff
#define BIT_FWCMDQ_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_FWCMDQ_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_FWCMDQ_DESC_NUM_8814B)
#define BITS_FWCMDQ_DESC_NUM_8814B                                             \
	(BIT_MASK_FWCMDQ_DESC_NUM_8814B << BIT_SHIFT_FWCMDQ_DESC_NUM_8814B)
#define BIT_CLEAR_FWCMDQ_DESC_NUM_8814B(x) ((x) & (~BITS_FWCMDQ_DESC_NUM_8814B))
#define BIT_GET_FWCMDQ_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_FWCMDQ_DESC_NUM_8814B) &                            \
	 BIT_MASK_FWCMDQ_DESC_NUM_8814B)
#define BIT_SET_FWCMDQ_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_FWCMDQ_DESC_NUM_8814B(x) | BIT_FWCMDQ_DESC_NUM_8814B(v))

/* 2 REG_ACH0_ACH1_TXBD_NUM_8814B */
#define BIT_PCIE_ACH1_FLAG_V1_8814B BIT(30)

#define BIT_SHIFT_ACH1_DESC_MODE_V1_8814B 28
#define BIT_MASK_ACH1_DESC_MODE_V1_8814B 0x3
#define BIT_ACH1_DESC_MODE_V1_8814B(x)                                         \
	(((x) & BIT_MASK_ACH1_DESC_MODE_V1_8814B)                              \
	 << BIT_SHIFT_ACH1_DESC_MODE_V1_8814B)
#define BITS_ACH1_DESC_MODE_V1_8814B                                           \
	(BIT_MASK_ACH1_DESC_MODE_V1_8814B << BIT_SHIFT_ACH1_DESC_MODE_V1_8814B)
#define BIT_CLEAR_ACH1_DESC_MODE_V1_8814B(x)                                   \
	((x) & (~BITS_ACH1_DESC_MODE_V1_8814B))
#define BIT_GET_ACH1_DESC_MODE_V1_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH1_DESC_MODE_V1_8814B) &                          \
	 BIT_MASK_ACH1_DESC_MODE_V1_8814B)
#define BIT_SET_ACH1_DESC_MODE_V1_8814B(x, v)                                  \
	(BIT_CLEAR_ACH1_DESC_MODE_V1_8814B(x) | BIT_ACH1_DESC_MODE_V1_8814B(v))

#define BIT_SHIFT_ACH1_DESC_NUM_V1_8814B 16
#define BIT_MASK_ACH1_DESC_NUM_V1_8814B 0xfff
#define BIT_ACH1_DESC_NUM_V1_8814B(x)                                          \
	(((x) & BIT_MASK_ACH1_DESC_NUM_V1_8814B)                               \
	 << BIT_SHIFT_ACH1_DESC_NUM_V1_8814B)
#define BITS_ACH1_DESC_NUM_V1_8814B                                            \
	(BIT_MASK_ACH1_DESC_NUM_V1_8814B << BIT_SHIFT_ACH1_DESC_NUM_V1_8814B)
#define BIT_CLEAR_ACH1_DESC_NUM_V1_8814B(x)                                    \
	((x) & (~BITS_ACH1_DESC_NUM_V1_8814B))
#define BIT_GET_ACH1_DESC_NUM_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH1_DESC_NUM_V1_8814B) &                           \
	 BIT_MASK_ACH1_DESC_NUM_V1_8814B)
#define BIT_SET_ACH1_DESC_NUM_V1_8814B(x, v)                                   \
	(BIT_CLEAR_ACH1_DESC_NUM_V1_8814B(x) | BIT_ACH1_DESC_NUM_V1_8814B(v))

#define BIT_PCIE_ACH0_FLAG_8814B BIT(14)

#define BIT_SHIFT_ACH0_DESC_MODE_8814B 12
#define BIT_MASK_ACH0_DESC_MODE_8814B 0x3
#define BIT_ACH0_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH0_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH0_DESC_MODE_8814B)
#define BITS_ACH0_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH0_DESC_MODE_8814B << BIT_SHIFT_ACH0_DESC_MODE_8814B)
#define BIT_CLEAR_ACH0_DESC_MODE_8814B(x) ((x) & (~BITS_ACH0_DESC_MODE_8814B))
#define BIT_GET_ACH0_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH0_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH0_DESC_MODE_8814B)
#define BIT_SET_ACH0_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH0_DESC_MODE_8814B(x) | BIT_ACH0_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH0_DESC_NUM_8814B 0
#define BIT_MASK_ACH0_DESC_NUM_8814B 0xfff
#define BIT_ACH0_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH0_DESC_NUM_8814B) << BIT_SHIFT_ACH0_DESC_NUM_8814B)
#define BITS_ACH0_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH0_DESC_NUM_8814B << BIT_SHIFT_ACH0_DESC_NUM_8814B)
#define BIT_CLEAR_ACH0_DESC_NUM_8814B(x) ((x) & (~BITS_ACH0_DESC_NUM_8814B))
#define BIT_GET_ACH0_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH0_DESC_NUM_8814B) & BIT_MASK_ACH0_DESC_NUM_8814B)
#define BIT_SET_ACH0_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH0_DESC_NUM_8814B(x) | BIT_ACH0_DESC_NUM_8814B(v))

/* 2 REG_ACH2_ACH3_TXBD_NUM_8814B */
#define BIT_PCIE_ACH3_FLAG_V1_8814B BIT(30)

#define BIT_SHIFT_ACH3_DESC_MODE_V1_8814B 28
#define BIT_MASK_ACH3_DESC_MODE_V1_8814B 0x3
#define BIT_ACH3_DESC_MODE_V1_8814B(x)                                         \
	(((x) & BIT_MASK_ACH3_DESC_MODE_V1_8814B)                              \
	 << BIT_SHIFT_ACH3_DESC_MODE_V1_8814B)
#define BITS_ACH3_DESC_MODE_V1_8814B                                           \
	(BIT_MASK_ACH3_DESC_MODE_V1_8814B << BIT_SHIFT_ACH3_DESC_MODE_V1_8814B)
#define BIT_CLEAR_ACH3_DESC_MODE_V1_8814B(x)                                   \
	((x) & (~BITS_ACH3_DESC_MODE_V1_8814B))
#define BIT_GET_ACH3_DESC_MODE_V1_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH3_DESC_MODE_V1_8814B) &                          \
	 BIT_MASK_ACH3_DESC_MODE_V1_8814B)
#define BIT_SET_ACH3_DESC_MODE_V1_8814B(x, v)                                  \
	(BIT_CLEAR_ACH3_DESC_MODE_V1_8814B(x) | BIT_ACH3_DESC_MODE_V1_8814B(v))

#define BIT_SHIFT_ACH3_DESC_NUM_V1_8814B 16
#define BIT_MASK_ACH3_DESC_NUM_V1_8814B 0xfff
#define BIT_ACH3_DESC_NUM_V1_8814B(x)                                          \
	(((x) & BIT_MASK_ACH3_DESC_NUM_V1_8814B)                               \
	 << BIT_SHIFT_ACH3_DESC_NUM_V1_8814B)
#define BITS_ACH3_DESC_NUM_V1_8814B                                            \
	(BIT_MASK_ACH3_DESC_NUM_V1_8814B << BIT_SHIFT_ACH3_DESC_NUM_V1_8814B)
#define BIT_CLEAR_ACH3_DESC_NUM_V1_8814B(x)                                    \
	((x) & (~BITS_ACH3_DESC_NUM_V1_8814B))
#define BIT_GET_ACH3_DESC_NUM_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH3_DESC_NUM_V1_8814B) &                           \
	 BIT_MASK_ACH3_DESC_NUM_V1_8814B)
#define BIT_SET_ACH3_DESC_NUM_V1_8814B(x, v)                                   \
	(BIT_CLEAR_ACH3_DESC_NUM_V1_8814B(x) | BIT_ACH3_DESC_NUM_V1_8814B(v))

#define BIT_PCIE_ACH2_FLAG_8814B BIT(14)

#define BIT_SHIFT_ACH2_DESC_MODE_8814B 12
#define BIT_MASK_ACH2_DESC_MODE_8814B 0x3
#define BIT_ACH2_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH2_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH2_DESC_MODE_8814B)
#define BITS_ACH2_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH2_DESC_MODE_8814B << BIT_SHIFT_ACH2_DESC_MODE_8814B)
#define BIT_CLEAR_ACH2_DESC_MODE_8814B(x) ((x) & (~BITS_ACH2_DESC_MODE_8814B))
#define BIT_GET_ACH2_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH2_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH2_DESC_MODE_8814B)
#define BIT_SET_ACH2_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH2_DESC_MODE_8814B(x) | BIT_ACH2_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH2_DESC_NUM_8814B 0
#define BIT_MASK_ACH2_DESC_NUM_8814B 0xfff
#define BIT_ACH2_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH2_DESC_NUM_8814B) << BIT_SHIFT_ACH2_DESC_NUM_8814B)
#define BITS_ACH2_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH2_DESC_NUM_8814B << BIT_SHIFT_ACH2_DESC_NUM_8814B)
#define BIT_CLEAR_ACH2_DESC_NUM_8814B(x) ((x) & (~BITS_ACH2_DESC_NUM_8814B))
#define BIT_GET_ACH2_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH2_DESC_NUM_8814B) & BIT_MASK_ACH2_DESC_NUM_8814B)
#define BIT_SET_ACH2_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH2_DESC_NUM_8814B(x) | BIT_ACH2_DESC_NUM_8814B(v))

/* 2 REG_P0HI0Q_HI1Q_TXBD_NUM_8814B */
#define BIT_P0HI1Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI1Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI1Q_DESC_MODE_8814B 0x3
#define BIT_P0HI1Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI1Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI1Q_DESC_MODE_8814B)
#define BITS_P0HI1Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI1Q_DESC_MODE_8814B << BIT_SHIFT_P0HI1Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI1Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI1Q_DESC_MODE_8814B))
#define BIT_GET_P0HI1Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI1Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI1Q_DESC_MODE_8814B)
#define BIT_SET_P0HI1Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI1Q_DESC_MODE_8814B(x) | BIT_P0HI1Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI1Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI1Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI1Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI1Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI1Q_DESC_NUM_8814B)
#define BITS_P0HI1Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI1Q_DESC_NUM_8814B << BIT_SHIFT_P0HI1Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI1Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI1Q_DESC_NUM_8814B))
#define BIT_GET_P0HI1Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI1Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI1Q_DESC_NUM_8814B)
#define BIT_SET_P0HI1Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI1Q_DESC_NUM_8814B(x) | BIT_P0HI1Q_DESC_NUM_8814B(v))

#define BIT_P0HI0Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI0Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI0Q_DESC_MODE_8814B 0x3
#define BIT_P0HI0Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI0Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI0Q_DESC_MODE_8814B)
#define BITS_P0HI0Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI0Q_DESC_MODE_8814B << BIT_SHIFT_P0HI0Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI0Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI0Q_DESC_MODE_8814B))
#define BIT_GET_P0HI0Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI0Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI0Q_DESC_MODE_8814B)
#define BIT_SET_P0HI0Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI0Q_DESC_MODE_8814B(x) | BIT_P0HI0Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI0Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI0Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI0Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI0Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI0Q_DESC_NUM_8814B)
#define BITS_P0HI0Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI0Q_DESC_NUM_8814B << BIT_SHIFT_P0HI0Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI0Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI0Q_DESC_NUM_8814B))
#define BIT_GET_P0HI0Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI0Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI0Q_DESC_NUM_8814B)
#define BIT_SET_P0HI0Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI0Q_DESC_NUM_8814B(x) | BIT_P0HI0Q_DESC_NUM_8814B(v))

/* 2 REG_P0HI2Q_HI3Q_TXBD_NUM_8814B */
#define BIT_P0HI3Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI3Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI3Q_DESC_MODE_8814B 0x3
#define BIT_P0HI3Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI3Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI3Q_DESC_MODE_8814B)
#define BITS_P0HI3Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI3Q_DESC_MODE_8814B << BIT_SHIFT_P0HI3Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI3Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI3Q_DESC_MODE_8814B))
#define BIT_GET_P0HI3Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI3Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI3Q_DESC_MODE_8814B)
#define BIT_SET_P0HI3Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI3Q_DESC_MODE_8814B(x) | BIT_P0HI3Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI3Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI3Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI3Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI3Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI3Q_DESC_NUM_8814B)
#define BITS_P0HI3Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI3Q_DESC_NUM_8814B << BIT_SHIFT_P0HI3Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI3Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI3Q_DESC_NUM_8814B))
#define BIT_GET_P0HI3Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI3Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI3Q_DESC_NUM_8814B)
#define BIT_SET_P0HI3Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI3Q_DESC_NUM_8814B(x) | BIT_P0HI3Q_DESC_NUM_8814B(v))

#define BIT_P0HI2Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI2Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI2Q_DESC_MODE_8814B 0x3
#define BIT_P0HI2Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI2Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI2Q_DESC_MODE_8814B)
#define BITS_P0HI2Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI2Q_DESC_MODE_8814B << BIT_SHIFT_P0HI2Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI2Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI2Q_DESC_MODE_8814B))
#define BIT_GET_P0HI2Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI2Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI2Q_DESC_MODE_8814B)
#define BIT_SET_P0HI2Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI2Q_DESC_MODE_8814B(x) | BIT_P0HI2Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI2Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI2Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI2Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI2Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI2Q_DESC_NUM_8814B)
#define BITS_P0HI2Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI2Q_DESC_NUM_8814B << BIT_SHIFT_P0HI2Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI2Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI2Q_DESC_NUM_8814B))
#define BIT_GET_P0HI2Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI2Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI2Q_DESC_NUM_8814B)
#define BIT_SET_P0HI2Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI2Q_DESC_NUM_8814B(x) | BIT_P0HI2Q_DESC_NUM_8814B(v))

/* 2 REG_P0HI4Q_HI5Q_TXBD_NUM_8814B */
#define BIT_P0HI5Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI5Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI5Q_DESC_MODE_8814B 0x3
#define BIT_P0HI5Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI5Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI5Q_DESC_MODE_8814B)
#define BITS_P0HI5Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI5Q_DESC_MODE_8814B << BIT_SHIFT_P0HI5Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI5Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI5Q_DESC_MODE_8814B))
#define BIT_GET_P0HI5Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI5Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI5Q_DESC_MODE_8814B)
#define BIT_SET_P0HI5Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI5Q_DESC_MODE_8814B(x) | BIT_P0HI5Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI5Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI5Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI5Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI5Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI5Q_DESC_NUM_8814B)
#define BITS_P0HI5Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI5Q_DESC_NUM_8814B << BIT_SHIFT_P0HI5Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI5Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI5Q_DESC_NUM_8814B))
#define BIT_GET_P0HI5Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI5Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI5Q_DESC_NUM_8814B)
#define BIT_SET_P0HI5Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI5Q_DESC_NUM_8814B(x) | BIT_P0HI5Q_DESC_NUM_8814B(v))

#define BIT_P0HI4Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI4Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI4Q_DESC_MODE_8814B 0x3
#define BIT_P0HI4Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI4Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI4Q_DESC_MODE_8814B)
#define BITS_P0HI4Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI4Q_DESC_MODE_8814B << BIT_SHIFT_P0HI4Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI4Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI4Q_DESC_MODE_8814B))
#define BIT_GET_P0HI4Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI4Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI4Q_DESC_MODE_8814B)
#define BIT_SET_P0HI4Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI4Q_DESC_MODE_8814B(x) | BIT_P0HI4Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI4Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI4Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI4Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI4Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI4Q_DESC_NUM_8814B)
#define BITS_P0HI4Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI4Q_DESC_NUM_8814B << BIT_SHIFT_P0HI4Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI4Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI4Q_DESC_NUM_8814B))
#define BIT_GET_P0HI4Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI4Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI4Q_DESC_NUM_8814B)
#define BIT_SET_P0HI4Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI4Q_DESC_NUM_8814B(x) | BIT_P0HI4Q_DESC_NUM_8814B(v))

/* 2 REG_P0HI6Q_HI7Q_TXBD_NUM_8814B */
#define BIT_P0HI7Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI7Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI7Q_DESC_MODE_8814B 0x3
#define BIT_P0HI7Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI7Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI7Q_DESC_MODE_8814B)
#define BITS_P0HI7Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI7Q_DESC_MODE_8814B << BIT_SHIFT_P0HI7Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI7Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI7Q_DESC_MODE_8814B))
#define BIT_GET_P0HI7Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI7Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI7Q_DESC_MODE_8814B)
#define BIT_SET_P0HI7Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI7Q_DESC_MODE_8814B(x) | BIT_P0HI7Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI7Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI7Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI7Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI7Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI7Q_DESC_NUM_8814B)
#define BITS_P0HI7Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI7Q_DESC_NUM_8814B << BIT_SHIFT_P0HI7Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI7Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI7Q_DESC_NUM_8814B))
#define BIT_GET_P0HI7Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI7Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI7Q_DESC_NUM_8814B)
#define BIT_SET_P0HI7Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI7Q_DESC_NUM_8814B(x) | BIT_P0HI7Q_DESC_NUM_8814B(v))

#define BIT_P0HI6Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI6Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI6Q_DESC_MODE_8814B 0x3
#define BIT_P0HI6Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI6Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI6Q_DESC_MODE_8814B)
#define BITS_P0HI6Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI6Q_DESC_MODE_8814B << BIT_SHIFT_P0HI6Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI6Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI6Q_DESC_MODE_8814B))
#define BIT_GET_P0HI6Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI6Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI6Q_DESC_MODE_8814B)
#define BIT_SET_P0HI6Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI6Q_DESC_MODE_8814B(x) | BIT_P0HI6Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI6Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI6Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI6Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI6Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI6Q_DESC_NUM_8814B)
#define BITS_P0HI6Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI6Q_DESC_NUM_8814B << BIT_SHIFT_P0HI6Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI6Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI6Q_DESC_NUM_8814B))
#define BIT_GET_P0HI6Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI6Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI6Q_DESC_NUM_8814B)
#define BIT_SET_P0HI6Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI6Q_DESC_NUM_8814B(x) | BIT_P0HI6Q_DESC_NUM_8814B(v))

/* 2 REG_BD_RWPTR_CLR1_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_FWCMDQ_HW_IDX_8814B BIT(30)
#define BIT_CLR_P0HI7Q_HW_IDX_8814B BIT(29)
#define BIT_CLR_P0HI6Q_HW_IDX_8814B BIT(28)
#define BIT_CLR_P0HI5Q_HW_IDX_8814B BIT(27)
#define BIT_CLR_P0HI4Q_HW_IDX_8814B BIT(26)
#define BIT_CLR_P0HI3Q_HW_IDX_8814B BIT(25)
#define BIT_CLR_P0HI2Q_HW_IDX_8814B BIT(24)
#define BIT_CLR_P0HI1Q_HW_IDX_8814B BIT(23)
#define BIT_CLR_P0HI0Q_HW_IDX_8814B BIT(22)
#define BIT_CLR_ACH3_HW_IDX_8814B BIT(21)
#define BIT_CLR_ACH2_HW_IDX_8814B BIT(20)
#define BIT_CLR_ACH1_HW_IDX_8814B BIT(19)
#define BIT_CLR_ACH0_HW_IDX_8814B BIT(18)
#define BIT_CLR_P0MGQ_HW_IDX_8814B BIT(17)
#define BIT_CLR_P0RXQ_HW_IDX_8814B BIT(16)

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_PFWCMDQ_HOST_IDX_8814B BIT(14)
#define BIT_CLR_P0HI7Q_HOST_IDX_8814B BIT(13)
#define BIT_CLR_P0HI6Q_HOST_IDX_8814B BIT(12)
#define BIT_CLR_P0HI5Q_HOST_IDX_8814B BIT(11)
#define BIT_CLR_P0HI4Q_HOST_IDX_8814B BIT(10)
#define BIT_CLR_P0HI3Q_HOST_IDX_8814B BIT(9)
#define BIT_CLR_P0HI2Q_HOST_IDX_8814B BIT(8)
#define BIT_CLR_P0HI1Q_HOST_IDX_8814B BIT(7)
#define BIT_CLR_P0HI0Q_HOST_IDX_8814B BIT(6)
#define BIT_CLR_ACH3_HOST_IDX_8814B BIT(5)
#define BIT_CLR_ACH2_HOST_IDX_8814B BIT(4)
#define BIT_CLR_ACH1_HOST_IDX_8814B BIT(3)
#define BIT_CLR_ACH0_HOST_IDX_8814B BIT(2)
#define BIT_CLR_P0MGQ_HOST_IDX_8814B BIT(1)
#define BIT_CLR_P0RXQ_HOST_IDX_8814B BIT(0)

/* 2 REG_TSFTIMER_HCI_8814B */

#define BIT_SHIFT_TSFT2_HCI_8814B 16
#define BIT_MASK_TSFT2_HCI_8814B 0xffff
#define BIT_TSFT2_HCI_8814B(x)                                                 \
	(((x) & BIT_MASK_TSFT2_HCI_8814B) << BIT_SHIFT_TSFT2_HCI_8814B)
#define BITS_TSFT2_HCI_8814B                                                   \
	(BIT_MASK_TSFT2_HCI_8814B << BIT_SHIFT_TSFT2_HCI_8814B)
#define BIT_CLEAR_TSFT2_HCI_8814B(x) ((x) & (~BITS_TSFT2_HCI_8814B))
#define BIT_GET_TSFT2_HCI_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TSFT2_HCI_8814B) & BIT_MASK_TSFT2_HCI_8814B)
#define BIT_SET_TSFT2_HCI_8814B(x, v)                                          \
	(BIT_CLEAR_TSFT2_HCI_8814B(x) | BIT_TSFT2_HCI_8814B(v))

#define BIT_SHIFT_TSFT1_HCI_8814B 0
#define BIT_MASK_TSFT1_HCI_8814B 0xffff
#define BIT_TSFT1_HCI_8814B(x)                                                 \
	(((x) & BIT_MASK_TSFT1_HCI_8814B) << BIT_SHIFT_TSFT1_HCI_8814B)
#define BITS_TSFT1_HCI_8814B                                                   \
	(BIT_MASK_TSFT1_HCI_8814B << BIT_SHIFT_TSFT1_HCI_8814B)
#define BIT_CLEAR_TSFT1_HCI_8814B(x) ((x) & (~BITS_TSFT1_HCI_8814B))
#define BIT_GET_TSFT1_HCI_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TSFT1_HCI_8814B) & BIT_MASK_TSFT1_HCI_8814B)
#define BIT_SET_TSFT1_HCI_8814B(x, v)                                          \
	(BIT_CLEAR_TSFT1_HCI_8814B(x) | BIT_TSFT1_HCI_8814B(v))

/* 2 REG_ACH0_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH0_HW_IDX_8814B 16
#define BIT_MASK_ACH0_HW_IDX_8814B 0xfff
#define BIT_ACH0_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH0_HW_IDX_8814B) << BIT_SHIFT_ACH0_HW_IDX_8814B)
#define BITS_ACH0_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH0_HW_IDX_8814B << BIT_SHIFT_ACH0_HW_IDX_8814B)
#define BIT_CLEAR_ACH0_HW_IDX_8814B(x) ((x) & (~BITS_ACH0_HW_IDX_8814B))
#define BIT_GET_ACH0_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH0_HW_IDX_8814B) & BIT_MASK_ACH0_HW_IDX_8814B)
#define BIT_SET_ACH0_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH0_HW_IDX_8814B(x) | BIT_ACH0_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH0_HOST_IDX_8814B 0
#define BIT_MASK_ACH0_HOST_IDX_8814B 0xfff
#define BIT_ACH0_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH0_HOST_IDX_8814B) << BIT_SHIFT_ACH0_HOST_IDX_8814B)
#define BITS_ACH0_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH0_HOST_IDX_8814B << BIT_SHIFT_ACH0_HOST_IDX_8814B)
#define BIT_CLEAR_ACH0_HOST_IDX_8814B(x) ((x) & (~BITS_ACH0_HOST_IDX_8814B))
#define BIT_GET_ACH0_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH0_HOST_IDX_8814B) & BIT_MASK_ACH0_HOST_IDX_8814B)
#define BIT_SET_ACH0_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH0_HOST_IDX_8814B(x) | BIT_ACH0_HOST_IDX_8814B(v))

/* 2 REG_ACH1_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH1_HW_IDX_8814B 16
#define BIT_MASK_ACH1_HW_IDX_8814B 0xfff
#define BIT_ACH1_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH1_HW_IDX_8814B) << BIT_SHIFT_ACH1_HW_IDX_8814B)
#define BITS_ACH1_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH1_HW_IDX_8814B << BIT_SHIFT_ACH1_HW_IDX_8814B)
#define BIT_CLEAR_ACH1_HW_IDX_8814B(x) ((x) & (~BITS_ACH1_HW_IDX_8814B))
#define BIT_GET_ACH1_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH1_HW_IDX_8814B) & BIT_MASK_ACH1_HW_IDX_8814B)
#define BIT_SET_ACH1_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH1_HW_IDX_8814B(x) | BIT_ACH1_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH1_HOST_IDX_8814B 0
#define BIT_MASK_ACH1_HOST_IDX_8814B 0xfff
#define BIT_ACH1_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH1_HOST_IDX_8814B) << BIT_SHIFT_ACH1_HOST_IDX_8814B)
#define BITS_ACH1_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH1_HOST_IDX_8814B << BIT_SHIFT_ACH1_HOST_IDX_8814B)
#define BIT_CLEAR_ACH1_HOST_IDX_8814B(x) ((x) & (~BITS_ACH1_HOST_IDX_8814B))
#define BIT_GET_ACH1_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH1_HOST_IDX_8814B) & BIT_MASK_ACH1_HOST_IDX_8814B)
#define BIT_SET_ACH1_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH1_HOST_IDX_8814B(x) | BIT_ACH1_HOST_IDX_8814B(v))

/* 2 REG_ACH2_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH2_HW_IDX_8814B 16
#define BIT_MASK_ACH2_HW_IDX_8814B 0xfff
#define BIT_ACH2_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH2_HW_IDX_8814B) << BIT_SHIFT_ACH2_HW_IDX_8814B)
#define BITS_ACH2_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH2_HW_IDX_8814B << BIT_SHIFT_ACH2_HW_IDX_8814B)
#define BIT_CLEAR_ACH2_HW_IDX_8814B(x) ((x) & (~BITS_ACH2_HW_IDX_8814B))
#define BIT_GET_ACH2_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH2_HW_IDX_8814B) & BIT_MASK_ACH2_HW_IDX_8814B)
#define BIT_SET_ACH2_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH2_HW_IDX_8814B(x) | BIT_ACH2_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH2_HOST_IDX_8814B 0
#define BIT_MASK_ACH2_HOST_IDX_8814B 0xfff
#define BIT_ACH2_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH2_HOST_IDX_8814B) << BIT_SHIFT_ACH2_HOST_IDX_8814B)
#define BITS_ACH2_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH2_HOST_IDX_8814B << BIT_SHIFT_ACH2_HOST_IDX_8814B)
#define BIT_CLEAR_ACH2_HOST_IDX_8814B(x) ((x) & (~BITS_ACH2_HOST_IDX_8814B))
#define BIT_GET_ACH2_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH2_HOST_IDX_8814B) & BIT_MASK_ACH2_HOST_IDX_8814B)
#define BIT_SET_ACH2_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH2_HOST_IDX_8814B(x) | BIT_ACH2_HOST_IDX_8814B(v))

/* 2 REG_ACH3_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH3_HW_IDX_8814B 16
#define BIT_MASK_ACH3_HW_IDX_8814B 0xfff
#define BIT_ACH3_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH3_HW_IDX_8814B) << BIT_SHIFT_ACH3_HW_IDX_8814B)
#define BITS_ACH3_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH3_HW_IDX_8814B << BIT_SHIFT_ACH3_HW_IDX_8814B)
#define BIT_CLEAR_ACH3_HW_IDX_8814B(x) ((x) & (~BITS_ACH3_HW_IDX_8814B))
#define BIT_GET_ACH3_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH3_HW_IDX_8814B) & BIT_MASK_ACH3_HW_IDX_8814B)
#define BIT_SET_ACH3_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH3_HW_IDX_8814B(x) | BIT_ACH3_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH3_HOST_IDX_8814B 0
#define BIT_MASK_ACH3_HOST_IDX_8814B 0xfff
#define BIT_ACH3_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH3_HOST_IDX_8814B) << BIT_SHIFT_ACH3_HOST_IDX_8814B)
#define BITS_ACH3_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH3_HOST_IDX_8814B << BIT_SHIFT_ACH3_HOST_IDX_8814B)
#define BIT_CLEAR_ACH3_HOST_IDX_8814B(x) ((x) & (~BITS_ACH3_HOST_IDX_8814B))
#define BIT_GET_ACH3_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH3_HOST_IDX_8814B) & BIT_MASK_ACH3_HOST_IDX_8814B)
#define BIT_SET_ACH3_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH3_HOST_IDX_8814B(x) | BIT_ACH3_HOST_IDX_8814B(v))

/* 2 REG_P0MGQ_TXBD_IDX_8814B */

#define BIT_SHIFT_P0MGQ_HW_IDX_8814B 16
#define BIT_MASK_P0MGQ_HW_IDX_8814B 0xfff
#define BIT_P0MGQ_HW_IDX_8814B(x)                                              \
	(((x) & BIT_MASK_P0MGQ_HW_IDX_8814B) << BIT_SHIFT_P0MGQ_HW_IDX_8814B)
#define BITS_P0MGQ_HW_IDX_8814B                                                \
	(BIT_MASK_P0MGQ_HW_IDX_8814B << BIT_SHIFT_P0MGQ_HW_IDX_8814B)
#define BIT_CLEAR_P0MGQ_HW_IDX_8814B(x) ((x) & (~BITS_P0MGQ_HW_IDX_8814B))
#define BIT_GET_P0MGQ_HW_IDX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_P0MGQ_HW_IDX_8814B) & BIT_MASK_P0MGQ_HW_IDX_8814B)
#define BIT_SET_P0MGQ_HW_IDX_8814B(x, v)                                       \
	(BIT_CLEAR_P0MGQ_HW_IDX_8814B(x) | BIT_P0MGQ_HW_IDX_8814B(v))

#define BIT_SHIFT_P0MGQ_HOST_IDX_8814B 0
#define BIT_MASK_P0MGQ_HOST_IDX_8814B 0xfff
#define BIT_P0MGQ_HOST_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0MGQ_HOST_IDX_8814B)                                 \
	 << BIT_SHIFT_P0MGQ_HOST_IDX_8814B)
#define BITS_P0MGQ_HOST_IDX_8814B                                              \
	(BIT_MASK_P0MGQ_HOST_IDX_8814B << BIT_SHIFT_P0MGQ_HOST_IDX_8814B)
#define BIT_CLEAR_P0MGQ_HOST_IDX_8814B(x) ((x) & (~BITS_P0MGQ_HOST_IDX_8814B))
#define BIT_GET_P0MGQ_HOST_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0MGQ_HOST_IDX_8814B) &                             \
	 BIT_MASK_P0MGQ_HOST_IDX_8814B)
#define BIT_SET_P0MGQ_HOST_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0MGQ_HOST_IDX_8814B(x) | BIT_P0MGQ_HOST_IDX_8814B(v))

/* 2 REG_P0RXQ_RXBD_IDX_8814B */

#define BIT_SHIFT_P0RXQ_HW_IDX_8814B 16
#define BIT_MASK_P0RXQ_HW_IDX_8814B 0xfff
#define BIT_P0RXQ_HW_IDX_8814B(x)                                              \
	(((x) & BIT_MASK_P0RXQ_HW_IDX_8814B) << BIT_SHIFT_P0RXQ_HW_IDX_8814B)
#define BITS_P0RXQ_HW_IDX_8814B                                                \
	(BIT_MASK_P0RXQ_HW_IDX_8814B << BIT_SHIFT_P0RXQ_HW_IDX_8814B)
#define BIT_CLEAR_P0RXQ_HW_IDX_8814B(x) ((x) & (~BITS_P0RXQ_HW_IDX_8814B))
#define BIT_GET_P0RXQ_HW_IDX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_P0RXQ_HW_IDX_8814B) & BIT_MASK_P0RXQ_HW_IDX_8814B)
#define BIT_SET_P0RXQ_HW_IDX_8814B(x, v)                                       \
	(BIT_CLEAR_P0RXQ_HW_IDX_8814B(x) | BIT_P0RXQ_HW_IDX_8814B(v))

#define BIT_SHIFT_P0RXQ_HOST_IDX_8814B 0
#define BIT_MASK_P0RXQ_HOST_IDX_8814B 0xfff
#define BIT_P0RXQ_HOST_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0RXQ_HOST_IDX_8814B)                                 \
	 << BIT_SHIFT_P0RXQ_HOST_IDX_8814B)
#define BITS_P0RXQ_HOST_IDX_8814B                                              \
	(BIT_MASK_P0RXQ_HOST_IDX_8814B << BIT_SHIFT_P0RXQ_HOST_IDX_8814B)
#define BIT_CLEAR_P0RXQ_HOST_IDX_8814B(x) ((x) & (~BITS_P0RXQ_HOST_IDX_8814B))
#define BIT_GET_P0RXQ_HOST_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0RXQ_HOST_IDX_8814B) &                             \
	 BIT_MASK_P0RXQ_HOST_IDX_8814B)
#define BIT_SET_P0RXQ_HOST_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0RXQ_HOST_IDX_8814B(x) | BIT_P0RXQ_HOST_IDX_8814B(v))

/* 2 REG_P0HI0Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI0Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI0Q_HW_IDX_8814B 0xfff
#define BIT_P0HI0Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI0Q_HW_IDX_8814B) << BIT_SHIFT_P0HI0Q_HW_IDX_8814B)
#define BITS_P0HI0Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI0Q_HW_IDX_8814B << BIT_SHIFT_P0HI0Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI0Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI0Q_HW_IDX_8814B))
#define BIT_GET_P0HI0Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI0Q_HW_IDX_8814B) & BIT_MASK_P0HI0Q_HW_IDX_8814B)
#define BIT_SET_P0HI0Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI0Q_HW_IDX_8814B(x) | BIT_P0HI0Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI0Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI0Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI0Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI0Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI0Q_HOST_IDX_8814B)
#define BITS_P0HI0Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI0Q_HOST_IDX_8814B << BIT_SHIFT_P0HI0Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI0Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI0Q_HOST_IDX_8814B))
#define BIT_GET_P0HI0Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI0Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI0Q_HOST_IDX_8814B)
#define BIT_SET_P0HI0Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI0Q_HOST_IDX_8814B(x) | BIT_P0HI0Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI1Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI1Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI1Q_HW_IDX_8814B 0xfff
#define BIT_P0HI1Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI1Q_HW_IDX_8814B) << BIT_SHIFT_P0HI1Q_HW_IDX_8814B)
#define BITS_P0HI1Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI1Q_HW_IDX_8814B << BIT_SHIFT_P0HI1Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI1Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI1Q_HW_IDX_8814B))
#define BIT_GET_P0HI1Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI1Q_HW_IDX_8814B) & BIT_MASK_P0HI1Q_HW_IDX_8814B)
#define BIT_SET_P0HI1Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI1Q_HW_IDX_8814B(x) | BIT_P0HI1Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI1Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI1Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI1Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI1Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI1Q_HOST_IDX_8814B)
#define BITS_P0HI1Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI1Q_HOST_IDX_8814B << BIT_SHIFT_P0HI1Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI1Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI1Q_HOST_IDX_8814B))
#define BIT_GET_P0HI1Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI1Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI1Q_HOST_IDX_8814B)
#define BIT_SET_P0HI1Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI1Q_HOST_IDX_8814B(x) | BIT_P0HI1Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI2Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI2Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI2Q_HW_IDX_8814B 0xfff
#define BIT_P0HI2Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI2Q_HW_IDX_8814B) << BIT_SHIFT_P0HI2Q_HW_IDX_8814B)
#define BITS_P0HI2Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI2Q_HW_IDX_8814B << BIT_SHIFT_P0HI2Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI2Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI2Q_HW_IDX_8814B))
#define BIT_GET_P0HI2Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI2Q_HW_IDX_8814B) & BIT_MASK_P0HI2Q_HW_IDX_8814B)
#define BIT_SET_P0HI2Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI2Q_HW_IDX_8814B(x) | BIT_P0HI2Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI2Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI2Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI2Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI2Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI2Q_HOST_IDX_8814B)
#define BITS_P0HI2Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI2Q_HOST_IDX_8814B << BIT_SHIFT_P0HI2Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI2Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI2Q_HOST_IDX_8814B))
#define BIT_GET_P0HI2Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI2Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI2Q_HOST_IDX_8814B)
#define BIT_SET_P0HI2Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI2Q_HOST_IDX_8814B(x) | BIT_P0HI2Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI3Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI3Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI3Q_HW_IDX_8814B 0xfff
#define BIT_P0HI3Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI3Q_HW_IDX_8814B) << BIT_SHIFT_P0HI3Q_HW_IDX_8814B)
#define BITS_P0HI3Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI3Q_HW_IDX_8814B << BIT_SHIFT_P0HI3Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI3Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI3Q_HW_IDX_8814B))
#define BIT_GET_P0HI3Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI3Q_HW_IDX_8814B) & BIT_MASK_P0HI3Q_HW_IDX_8814B)
#define BIT_SET_P0HI3Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI3Q_HW_IDX_8814B(x) | BIT_P0HI3Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI3Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI3Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI3Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI3Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI3Q_HOST_IDX_8814B)
#define BITS_P0HI3Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI3Q_HOST_IDX_8814B << BIT_SHIFT_P0HI3Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI3Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI3Q_HOST_IDX_8814B))
#define BIT_GET_P0HI3Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI3Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI3Q_HOST_IDX_8814B)
#define BIT_SET_P0HI3Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI3Q_HOST_IDX_8814B(x) | BIT_P0HI3Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI4Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI4Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI4Q_HW_IDX_8814B 0xfff
#define BIT_P0HI4Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI4Q_HW_IDX_8814B) << BIT_SHIFT_P0HI4Q_HW_IDX_8814B)
#define BITS_P0HI4Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI4Q_HW_IDX_8814B << BIT_SHIFT_P0HI4Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI4Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI4Q_HW_IDX_8814B))
#define BIT_GET_P0HI4Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI4Q_HW_IDX_8814B) & BIT_MASK_P0HI4Q_HW_IDX_8814B)
#define BIT_SET_P0HI4Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI4Q_HW_IDX_8814B(x) | BIT_P0HI4Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI4Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI4Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI4Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI4Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI4Q_HOST_IDX_8814B)
#define BITS_P0HI4Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI4Q_HOST_IDX_8814B << BIT_SHIFT_P0HI4Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI4Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI4Q_HOST_IDX_8814B))
#define BIT_GET_P0HI4Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI4Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI4Q_HOST_IDX_8814B)
#define BIT_SET_P0HI4Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI4Q_HOST_IDX_8814B(x) | BIT_P0HI4Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI5Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI5Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI5Q_HW_IDX_8814B 0xfff
#define BIT_P0HI5Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI5Q_HW_IDX_8814B) << BIT_SHIFT_P0HI5Q_HW_IDX_8814B)
#define BITS_P0HI5Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI5Q_HW_IDX_8814B << BIT_SHIFT_P0HI5Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI5Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI5Q_HW_IDX_8814B))
#define BIT_GET_P0HI5Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI5Q_HW_IDX_8814B) & BIT_MASK_P0HI5Q_HW_IDX_8814B)
#define BIT_SET_P0HI5Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI5Q_HW_IDX_8814B(x) | BIT_P0HI5Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI5Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI5Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI5Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI5Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI5Q_HOST_IDX_8814B)
#define BITS_P0HI5Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI5Q_HOST_IDX_8814B << BIT_SHIFT_P0HI5Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI5Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI5Q_HOST_IDX_8814B))
#define BIT_GET_P0HI5Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI5Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI5Q_HOST_IDX_8814B)
#define BIT_SET_P0HI5Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI5Q_HOST_IDX_8814B(x) | BIT_P0HI5Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI6Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI6Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI6Q_HW_IDX_8814B 0xfff
#define BIT_P0HI6Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI6Q_HW_IDX_8814B) << BIT_SHIFT_P0HI6Q_HW_IDX_8814B)
#define BITS_P0HI6Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI6Q_HW_IDX_8814B << BIT_SHIFT_P0HI6Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI6Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI6Q_HW_IDX_8814B))
#define BIT_GET_P0HI6Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI6Q_HW_IDX_8814B) & BIT_MASK_P0HI6Q_HW_IDX_8814B)
#define BIT_SET_P0HI6Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI6Q_HW_IDX_8814B(x) | BIT_P0HI6Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI6Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI6Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI6Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI6Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI6Q_HOST_IDX_8814B)
#define BITS_P0HI6Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI6Q_HOST_IDX_8814B << BIT_SHIFT_P0HI6Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI6Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI6Q_HOST_IDX_8814B))
#define BIT_GET_P0HI6Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI6Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI6Q_HOST_IDX_8814B)
#define BIT_SET_P0HI6Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI6Q_HOST_IDX_8814B(x) | BIT_P0HI6Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI7Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI7Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI7Q_HW_IDX_8814B 0xfff
#define BIT_P0HI7Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI7Q_HW_IDX_8814B) << BIT_SHIFT_P0HI7Q_HW_IDX_8814B)
#define BITS_P0HI7Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI7Q_HW_IDX_8814B << BIT_SHIFT_P0HI7Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI7Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI7Q_HW_IDX_8814B))
#define BIT_GET_P0HI7Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI7Q_HW_IDX_8814B) & BIT_MASK_P0HI7Q_HW_IDX_8814B)
#define BIT_SET_P0HI7Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI7Q_HW_IDX_8814B(x) | BIT_P0HI7Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI7Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI7Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI7Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI7Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI7Q_HOST_IDX_8814B)
#define BITS_P0HI7Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI7Q_HOST_IDX_8814B << BIT_SHIFT_P0HI7Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI7Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI7Q_HOST_IDX_8814B))
#define BIT_GET_P0HI7Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI7Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI7Q_HOST_IDX_8814B)
#define BIT_SET_P0HI7Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI7Q_HOST_IDX_8814B(x) | BIT_P0HI7Q_HOST_IDX_8814B(v))

/* 2 REG_DBGSEL_PCIE_HRPWM1_HCPWM1_V1_8814B */
#define BIT_DIS_TXDMA_PRE_V1_8814B BIT(31)
#define BIT_DIS_RXDMA_PRE_V1_8814B BIT(30)

#define BIT_SHIFT_HPS_CLKR_PCIE_V1_8814B 28
#define BIT_MASK_HPS_CLKR_PCIE_V1_8814B 0x3
#define BIT_HPS_CLKR_PCIE_V1_8814B(x)                                          \
	(((x) & BIT_MASK_HPS_CLKR_PCIE_V1_8814B)                               \
	 << BIT_SHIFT_HPS_CLKR_PCIE_V1_8814B)
#define BITS_HPS_CLKR_PCIE_V1_8814B                                            \
	(BIT_MASK_HPS_CLKR_PCIE_V1_8814B << BIT_SHIFT_HPS_CLKR_PCIE_V1_8814B)
#define BIT_CLEAR_HPS_CLKR_PCIE_V1_8814B(x)                                    \
	((x) & (~BITS_HPS_CLKR_PCIE_V1_8814B))
#define BIT_GET_HPS_CLKR_PCIE_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HPS_CLKR_PCIE_V1_8814B) &                           \
	 BIT_MASK_HPS_CLKR_PCIE_V1_8814B)
#define BIT_SET_HPS_CLKR_PCIE_V1_8814B(x, v)                                   \
	(BIT_CLEAR_HPS_CLKR_PCIE_V1_8814B(x) | BIT_HPS_CLKR_PCIE_V1_8814B(v))

#define BIT_PCIE_INT_V1_8814B BIT(27)
#define BIT_TXFLAG_EXIT_L1_EN_V1_8814B BIT(26)
#define BIT_EN_RXDMA_ALIGN_V2_8814B BIT(25)
#define BIT_EN_TXDMA_ALIGN_V2_8814B BIT(24)

#define BIT_SHIFT_PCIE_HCPWM_V1_8814B 16
#define BIT_MASK_PCIE_HCPWM_V1_8814B 0xff
#define BIT_PCIE_HCPWM_V1_8814B(x)                                             \
	(((x) & BIT_MASK_PCIE_HCPWM_V1_8814B) << BIT_SHIFT_PCIE_HCPWM_V1_8814B)
#define BITS_PCIE_HCPWM_V1_8814B                                               \
	(BIT_MASK_PCIE_HCPWM_V1_8814B << BIT_SHIFT_PCIE_HCPWM_V1_8814B)
#define BIT_CLEAR_PCIE_HCPWM_V1_8814B(x) ((x) & (~BITS_PCIE_HCPWM_V1_8814B))
#define BIT_GET_PCIE_HCPWM_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_PCIE_HCPWM_V1_8814B) & BIT_MASK_PCIE_HCPWM_V1_8814B)
#define BIT_SET_PCIE_HCPWM_V1_8814B(x, v)                                      \
	(BIT_CLEAR_PCIE_HCPWM_V1_8814B(x) | BIT_PCIE_HCPWM_V1_8814B(v))

#define BIT_SHIFT_PCIE_HRPWM_V1_8814B 8
#define BIT_MASK_PCIE_HRPWM_V1_8814B 0xff
#define BIT_PCIE_HRPWM_V1_8814B(x)                                             \
	(((x) & BIT_MASK_PCIE_HRPWM_V1_8814B) << BIT_SHIFT_PCIE_HRPWM_V1_8814B)
#define BITS_PCIE_HRPWM_V1_8814B                                               \
	(BIT_MASK_PCIE_HRPWM_V1_8814B << BIT_SHIFT_PCIE_HRPWM_V1_8814B)
#define BIT_CLEAR_PCIE_HRPWM_V1_8814B(x) ((x) & (~BITS_PCIE_HRPWM_V1_8814B))
#define BIT_GET_PCIE_HRPWM_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_PCIE_HRPWM_V1_8814B) & BIT_MASK_PCIE_HRPWM_V1_8814B)
#define BIT_SET_PCIE_HRPWM_V1_8814B(x, v)                                      \
	(BIT_CLEAR_PCIE_HRPWM_V1_8814B(x) | BIT_PCIE_HRPWM_V1_8814B(v))

#define BIT_SHIFT_DBG_SEL_8814B 0
#define BIT_MASK_DBG_SEL_8814B 0xff
#define BIT_DBG_SEL_8814B(x)                                                   \
	(((x) & BIT_MASK_DBG_SEL_8814B) << BIT_SHIFT_DBG_SEL_8814B)
#define BITS_DBG_SEL_8814B (BIT_MASK_DBG_SEL_8814B << BIT_SHIFT_DBG_SEL_8814B)
#define BIT_CLEAR_DBG_SEL_8814B(x) ((x) & (~BITS_DBG_SEL_8814B))
#define BIT_GET_DBG_SEL_8814B(x)                                               \
	(((x) >> BIT_SHIFT_DBG_SEL_8814B) & BIT_MASK_DBG_SEL_8814B)
#define BIT_SET_DBG_SEL_8814B(x, v)                                            \
	(BIT_CLEAR_DBG_SEL_8814B(x) | BIT_DBG_SEL_8814B(v))

/* 2 REG_PCIE_HRPWM2_HCPWM2_V1_8814B */

#define BIT_SHIFT_PCIE_HCPWM2_V1_8814B 16
#define BIT_MASK_PCIE_HCPWM2_V1_8814B 0xffff
#define BIT_PCIE_HCPWM2_V1_8814B(x)                                            \
	(((x) & BIT_MASK_PCIE_HCPWM2_V1_8814B)                                 \
	 << BIT_SHIFT_PCIE_HCPWM2_V1_8814B)
#define BITS_PCIE_HCPWM2_V1_8814B                                              \
	(BIT_MASK_PCIE_HCPWM2_V1_8814B << BIT_SHIFT_PCIE_HCPWM2_V1_8814B)
#define BIT_CLEAR_PCIE_HCPWM2_V1_8814B(x) ((x) & (~BITS_PCIE_HCPWM2_V1_8814B))
#define BIT_GET_PCIE_HCPWM2_V1_8814B(x)                                        \
	(((x) >> BIT_SHIFT_PCIE_HCPWM2_V1_8814B) &                             \
	 BIT_MASK_PCIE_HCPWM2_V1_8814B)
#define BIT_SET_PCIE_HCPWM2_V1_8814B(x, v)                                     \
	(BIT_CLEAR_PCIE_HCPWM2_V1_8814B(x) | BIT_PCIE_HCPWM2_V1_8814B(v))

#define BIT_SHIFT_PCIE_HRPWM2_8814B 0
#define BIT_MASK_PCIE_HRPWM2_8814B 0xffff
#define BIT_PCIE_HRPWM2_8814B(x)                                               \
	(((x) & BIT_MASK_PCIE_HRPWM2_8814B) << BIT_SHIFT_PCIE_HRPWM2_8814B)
#define BITS_PCIE_HRPWM2_8814B                                                 \
	(BIT_MASK_PCIE_HRPWM2_8814B << BIT_SHIFT_PCIE_HRPWM2_8814B)
#define BIT_CLEAR_PCIE_HRPWM2_8814B(x) ((x) & (~BITS_PCIE_HRPWM2_8814B))
#define BIT_GET_PCIE_HRPWM2_8814B(x)                                           \
	(((x) >> BIT_SHIFT_PCIE_HRPWM2_8814B) & BIT_MASK_PCIE_HRPWM2_8814B)
#define BIT_SET_PCIE_HRPWM2_8814B(x, v)                                        \
	(BIT_CLEAR_PCIE_HRPWM2_8814B(x) | BIT_PCIE_HRPWM2_8814B(v))

/* 2 REG_PCIE_H2C_MSG_V1_8814B */

#define BIT_SHIFT_DRV2FW_INFO_8814B 0
#define BIT_MASK_DRV2FW_INFO_8814B 0xffffffffL
#define BIT_DRV2FW_INFO_8814B(x)                                               \
	(((x) & BIT_MASK_DRV2FW_INFO_8814B) << BIT_SHIFT_DRV2FW_INFO_8814B)
#define BITS_DRV2FW_INFO_8814B                                                 \
	(BIT_MASK_DRV2FW_INFO_8814B << BIT_SHIFT_DRV2FW_INFO_8814B)
#define BIT_CLEAR_DRV2FW_INFO_8814B(x) ((x) & (~BITS_DRV2FW_INFO_8814B))
#define BIT_GET_DRV2FW_INFO_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DRV2FW_INFO_8814B) & BIT_MASK_DRV2FW_INFO_8814B)
#define BIT_SET_DRV2FW_INFO_8814B(x, v)                                        \
	(BIT_CLEAR_DRV2FW_INFO_8814B(x) | BIT_DRV2FW_INFO_8814B(v))

/* 2 REG_PCIE_C2H_MSG_V1_8814B */

#define BIT_SHIFT_HCI_PCIE_C2H_MSG_8814B 0
#define BIT_MASK_HCI_PCIE_C2H_MSG_8814B 0xffffffffL
#define BIT_HCI_PCIE_C2H_MSG_8814B(x)                                          \
	(((x) & BIT_MASK_HCI_PCIE_C2H_MSG_8814B)                               \
	 << BIT_SHIFT_HCI_PCIE_C2H_MSG_8814B)
#define BITS_HCI_PCIE_C2H_MSG_8814B                                            \
	(BIT_MASK_HCI_PCIE_C2H_MSG_8814B << BIT_SHIFT_HCI_PCIE_C2H_MSG_8814B)
#define BIT_CLEAR_HCI_PCIE_C2H_MSG_8814B(x)                                    \
	((x) & (~BITS_HCI_PCIE_C2H_MSG_8814B))
#define BIT_GET_HCI_PCIE_C2H_MSG_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HCI_PCIE_C2H_MSG_8814B) &                           \
	 BIT_MASK_HCI_PCIE_C2H_MSG_8814B)
#define BIT_SET_HCI_PCIE_C2H_MSG_8814B(x, v)                                   \
	(BIT_CLEAR_HCI_PCIE_C2H_MSG_8814B(x) | BIT_HCI_PCIE_C2H_MSG_8814B(v))

/* 2 REG_DBI_WDATA_V1_8814B */

#define BIT_SHIFT_DBI_WDATA_8814B 0
#define BIT_MASK_DBI_WDATA_8814B 0xffffffffL
#define BIT_DBI_WDATA_8814B(x)                                                 \
	(((x) & BIT_MASK_DBI_WDATA_8814B) << BIT_SHIFT_DBI_WDATA_8814B)
#define BITS_DBI_WDATA_8814B                                                   \
	(BIT_MASK_DBI_WDATA_8814B << BIT_SHIFT_DBI_WDATA_8814B)
#define BIT_CLEAR_DBI_WDATA_8814B(x) ((x) & (~BITS_DBI_WDATA_8814B))
#define BIT_GET_DBI_WDATA_8814B(x)                                             \
	(((x) >> BIT_SHIFT_DBI_WDATA_8814B) & BIT_MASK_DBI_WDATA_8814B)
#define BIT_SET_DBI_WDATA_8814B(x, v)                                          \
	(BIT_CLEAR_DBI_WDATA_8814B(x) | BIT_DBI_WDATA_8814B(v))

/* 2 REG_DBI_RDATA_V1_8814B */

#define BIT_SHIFT_DBI_RDATA_8814B 0
#define BIT_MASK_DBI_RDATA_8814B 0xffffffffL
#define BIT_DBI_RDATA_8814B(x)                                                 \
	(((x) & BIT_MASK_DBI_RDATA_8814B) << BIT_SHIFT_DBI_RDATA_8814B)
#define BITS_DBI_RDATA_8814B                                                   \
	(BIT_MASK_DBI_RDATA_8814B << BIT_SHIFT_DBI_RDATA_8814B)
#define BIT_CLEAR_DBI_RDATA_8814B(x) ((x) & (~BITS_DBI_RDATA_8814B))
#define BIT_GET_DBI_RDATA_8814B(x)                                             \
	(((x) >> BIT_SHIFT_DBI_RDATA_8814B) & BIT_MASK_DBI_RDATA_8814B)
#define BIT_SET_DBI_RDATA_8814B(x, v)                                          \
	(BIT_CLEAR_DBI_RDATA_8814B(x) | BIT_DBI_RDATA_8814B(v))

/* 2 REG_DBI_FLAG_V1_8814B */

#define BIT_SHIFT_LOOPBACK_DBG_SEL_8814B 28
#define BIT_MASK_LOOPBACK_DBG_SEL_8814B 0xf
#define BIT_LOOPBACK_DBG_SEL_8814B(x)                                          \
	(((x) & BIT_MASK_LOOPBACK_DBG_SEL_8814B)                               \
	 << BIT_SHIFT_LOOPBACK_DBG_SEL_8814B)
#define BITS_LOOPBACK_DBG_SEL_8814B                                            \
	(BIT_MASK_LOOPBACK_DBG_SEL_8814B << BIT_SHIFT_LOOPBACK_DBG_SEL_8814B)
#define BIT_CLEAR_LOOPBACK_DBG_SEL_8814B(x)                                    \
	((x) & (~BITS_LOOPBACK_DBG_SEL_8814B))
#define BIT_GET_LOOPBACK_DBG_SEL_8814B(x)                                      \
	(((x) >> BIT_SHIFT_LOOPBACK_DBG_SEL_8814B) &                           \
	 BIT_MASK_LOOPBACK_DBG_SEL_8814B)
#define BIT_SET_LOOPBACK_DBG_SEL_8814B(x, v)                                   \
	(BIT_CLEAR_LOOPBACK_DBG_SEL_8814B(x) | BIT_LOOPBACK_DBG_SEL_8814B(v))

#define BIT_EN_STUCK_DBG_8814B BIT(26)
#define BIT_RX_STUCK_8814B BIT(25)
#define BIT_TX_STUCK_8814B BIT(24)
#define BIT_DBI_RFLAG_8814B BIT(17)
#define BIT_DBI_WFLAG_8814B BIT(16)

#define BIT_SHIFT_DBI_WREN_8814B 12
#define BIT_MASK_DBI_WREN_8814B 0xf
#define BIT_DBI_WREN_8814B(x)                                                  \
	(((x) & BIT_MASK_DBI_WREN_8814B) << BIT_SHIFT_DBI_WREN_8814B)
#define BITS_DBI_WREN_8814B                                                    \
	(BIT_MASK_DBI_WREN_8814B << BIT_SHIFT_DBI_WREN_8814B)
#define BIT_CLEAR_DBI_WREN_8814B(x) ((x) & (~BITS_DBI_WREN_8814B))
#define BIT_GET_DBI_WREN_8814B(x)                                              \
	(((x) >> BIT_SHIFT_DBI_WREN_8814B) & BIT_MASK_DBI_WREN_8814B)
#define BIT_SET_DBI_WREN_8814B(x, v)                                           \
	(BIT_CLEAR_DBI_WREN_8814B(x) | BIT_DBI_WREN_8814B(v))

#define BIT_SHIFT_DBI_ADDR_8814B 0
#define BIT_MASK_DBI_ADDR_8814B 0xfff
#define BIT_DBI_ADDR_8814B(x)                                                  \
	(((x) & BIT_MASK_DBI_ADDR_8814B) << BIT_SHIFT_DBI_ADDR_8814B)
#define BITS_DBI_ADDR_8814B                                                    \
	(BIT_MASK_DBI_ADDR_8814B << BIT_SHIFT_DBI_ADDR_8814B)
#define BIT_CLEAR_DBI_ADDR_8814B(x) ((x) & (~BITS_DBI_ADDR_8814B))
#define BIT_GET_DBI_ADDR_8814B(x)                                              \
	(((x) >> BIT_SHIFT_DBI_ADDR_8814B) & BIT_MASK_DBI_ADDR_8814B)
#define BIT_SET_DBI_ADDR_8814B(x, v)                                           \
	(BIT_CLEAR_DBI_ADDR_8814B(x) | BIT_DBI_ADDR_8814B(v))

/* 2 REG_MDIO_V1_8814B */

#define BIT_SHIFT_MDIO_RDATA_8814B 16
#define BIT_MASK_MDIO_RDATA_8814B 0xffff
#define BIT_MDIO_RDATA_8814B(x)                                                \
	(((x) & BIT_MASK_MDIO_RDATA_8814B) << BIT_SHIFT_MDIO_RDATA_8814B)
#define BITS_MDIO_RDATA_8814B                                                  \
	(BIT_MASK_MDIO_RDATA_8814B << BIT_SHIFT_MDIO_RDATA_8814B)
#define BIT_CLEAR_MDIO_RDATA_8814B(x) ((x) & (~BITS_MDIO_RDATA_8814B))
#define BIT_GET_MDIO_RDATA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_MDIO_RDATA_8814B) & BIT_MASK_MDIO_RDATA_8814B)
#define BIT_SET_MDIO_RDATA_8814B(x, v)                                         \
	(BIT_CLEAR_MDIO_RDATA_8814B(x) | BIT_MDIO_RDATA_8814B(v))

#define BIT_SHIFT_MDIO_WDATA_8814B 0
#define BIT_MASK_MDIO_WDATA_8814B 0xffff
#define BIT_MDIO_WDATA_8814B(x)                                                \
	(((x) & BIT_MASK_MDIO_WDATA_8814B) << BIT_SHIFT_MDIO_WDATA_8814B)
#define BITS_MDIO_WDATA_8814B                                                  \
	(BIT_MASK_MDIO_WDATA_8814B << BIT_SHIFT_MDIO_WDATA_8814B)
#define BIT_CLEAR_MDIO_WDATA_8814B(x) ((x) & (~BITS_MDIO_WDATA_8814B))
#define BIT_GET_MDIO_WDATA_8814B(x)                                            \
	(((x) >> BIT_SHIFT_MDIO_WDATA_8814B) & BIT_MASK_MDIO_WDATA_8814B)
#define BIT_SET_MDIO_WDATA_8814B(x, v)                                         \
	(BIT_CLEAR_MDIO_WDATA_8814B(x) | BIT_MDIO_WDATA_8814B(v))

/* 2 REG_PCIE_MIX_CFG_8814B */

#define BIT_SHIFT_MDIO_PHY_ADDR_8814B 24
#define BIT_MASK_MDIO_PHY_ADDR_8814B 0x1f
#define BIT_MDIO_PHY_ADDR_8814B(x)                                             \
	(((x) & BIT_MASK_MDIO_PHY_ADDR_8814B) << BIT_SHIFT_MDIO_PHY_ADDR_8814B)
#define BITS_MDIO_PHY_ADDR_8814B                                               \
	(BIT_MASK_MDIO_PHY_ADDR_8814B << BIT_SHIFT_MDIO_PHY_ADDR_8814B)
#define BIT_CLEAR_MDIO_PHY_ADDR_8814B(x) ((x) & (~BITS_MDIO_PHY_ADDR_8814B))
#define BIT_GET_MDIO_PHY_ADDR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MDIO_PHY_ADDR_8814B) & BIT_MASK_MDIO_PHY_ADDR_8814B)
#define BIT_SET_MDIO_PHY_ADDR_8814B(x, v)                                      \
	(BIT_CLEAR_MDIO_PHY_ADDR_8814B(x) | BIT_MDIO_PHY_ADDR_8814B(v))

#define BIT_SHIFT_WATCH_DOG_RECORD_V1_8814B 10
#define BIT_MASK_WATCH_DOG_RECORD_V1_8814B 0x3fff
#define BIT_WATCH_DOG_RECORD_V1_8814B(x)                                       \
	(((x) & BIT_MASK_WATCH_DOG_RECORD_V1_8814B)                            \
	 << BIT_SHIFT_WATCH_DOG_RECORD_V1_8814B)
#define BITS_WATCH_DOG_RECORD_V1_8814B                                         \
	(BIT_MASK_WATCH_DOG_RECORD_V1_8814B                                    \
	 << BIT_SHIFT_WATCH_DOG_RECORD_V1_8814B)
#define BIT_CLEAR_WATCH_DOG_RECORD_V1_8814B(x)                                 \
	((x) & (~BITS_WATCH_DOG_RECORD_V1_8814B))
#define BIT_GET_WATCH_DOG_RECORD_V1_8814B(x)                                   \
	(((x) >> BIT_SHIFT_WATCH_DOG_RECORD_V1_8814B) &                        \
	 BIT_MASK_WATCH_DOG_RECORD_V1_8814B)
#define BIT_SET_WATCH_DOG_RECORD_V1_8814B(x, v)                                \
	(BIT_CLEAR_WATCH_DOG_RECORD_V1_8814B(x) |                              \
	 BIT_WATCH_DOG_RECORD_V1_8814B(v))

#define BIT_R_IO_TIMEOUT_FLAG_V1_8814B BIT(9)
#define BIT_EN_WATCH_DOG_8814B BIT(8)
#define BIT_ECRC_EN_8814B BIT(7)
#define BIT_MDIO_RFLAG_8814B BIT(6)
#define BIT_MDIO_WFLAG_8814B BIT(5)

#define BIT_SHIFT_MDIO_REG_ADDR_8814B 0
#define BIT_MASK_MDIO_REG_ADDR_8814B 0x1f
#define BIT_MDIO_REG_ADDR_8814B(x)                                             \
	(((x) & BIT_MASK_MDIO_REG_ADDR_8814B) << BIT_SHIFT_MDIO_REG_ADDR_8814B)
#define BITS_MDIO_REG_ADDR_8814B                                               \
	(BIT_MASK_MDIO_REG_ADDR_8814B << BIT_SHIFT_MDIO_REG_ADDR_8814B)
#define BIT_CLEAR_MDIO_REG_ADDR_8814B(x) ((x) & (~BITS_MDIO_REG_ADDR_8814B))
#define BIT_GET_MDIO_REG_ADDR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MDIO_REG_ADDR_8814B) & BIT_MASK_MDIO_REG_ADDR_8814B)
#define BIT_SET_MDIO_REG_ADDR_8814B(x, v)                                      \
	(BIT_CLEAR_MDIO_REG_ADDR_8814B(x) | BIT_MDIO_REG_ADDR_8814B(v))

/* 2 REG_HCI_MIX_CFG_8814B */
#define BIT_EN_ALIGN_MTU_8814B BIT(23)

#define BIT_SHIFT_LATENCY_CONTROL_8814B 21
#define BIT_MASK_LATENCY_CONTROL_8814B 0x3
#define BIT_LATENCY_CONTROL_8814B(x)                                           \
	(((x) & BIT_MASK_LATENCY_CONTROL_8814B)                                \
	 << BIT_SHIFT_LATENCY_CONTROL_8814B)
#define BITS_LATENCY_CONTROL_8814B                                             \
	(BIT_MASK_LATENCY_CONTROL_8814B << BIT_SHIFT_LATENCY_CONTROL_8814B)
#define BIT_CLEAR_LATENCY_CONTROL_8814B(x) ((x) & (~BITS_LATENCY_CONTROL_8814B))
#define BIT_GET_LATENCY_CONTROL_8814B(x)                                       \
	(((x) >> BIT_SHIFT_LATENCY_CONTROL_8814B) &                            \
	 BIT_MASK_LATENCY_CONTROL_8814B)
#define BIT_SET_LATENCY_CONTROL_8814B(x, v)                                    \
	(BIT_CLEAR_LATENCY_CONTROL_8814B(x) | BIT_LATENCY_CONTROL_8814B(v))

#define BIT_HOST_GEN2_SUPPORT_8814B BIT(20)

#define BIT_SHIFT_TXDMA_ERR_FLAG_V1_8814B 15
#define BIT_MASK_TXDMA_ERR_FLAG_V1_8814B 0x1f
#define BIT_TXDMA_ERR_FLAG_V1_8814B(x)                                         \
	(((x) & BIT_MASK_TXDMA_ERR_FLAG_V1_8814B)                              \
	 << BIT_SHIFT_TXDMA_ERR_FLAG_V1_8814B)
#define BITS_TXDMA_ERR_FLAG_V1_8814B                                           \
	(BIT_MASK_TXDMA_ERR_FLAG_V1_8814B << BIT_SHIFT_TXDMA_ERR_FLAG_V1_8814B)
#define BIT_CLEAR_TXDMA_ERR_FLAG_V1_8814B(x)                                   \
	((x) & (~BITS_TXDMA_ERR_FLAG_V1_8814B))
#define BIT_GET_TXDMA_ERR_FLAG_V1_8814B(x)                                     \
	(((x) >> BIT_SHIFT_TXDMA_ERR_FLAG_V1_8814B) &                          \
	 BIT_MASK_TXDMA_ERR_FLAG_V1_8814B)
#define BIT_SET_TXDMA_ERR_FLAG_V1_8814B(x, v)                                  \
	(BIT_CLEAR_TXDMA_ERR_FLAG_V1_8814B(x) | BIT_TXDMA_ERR_FLAG_V1_8814B(v))

#define BIT_EPHY_RX50_EN_8814B BIT(11)

#define BIT_SHIFT_MSI_TIMEOUT_ID_V1_8814B 8
#define BIT_MASK_MSI_TIMEOUT_ID_V1_8814B 0x7
#define BIT_MSI_TIMEOUT_ID_V1_8814B(x)                                         \
	(((x) & BIT_MASK_MSI_TIMEOUT_ID_V1_8814B)                              \
	 << BIT_SHIFT_MSI_TIMEOUT_ID_V1_8814B)
#define BITS_MSI_TIMEOUT_ID_V1_8814B                                           \
	(BIT_MASK_MSI_TIMEOUT_ID_V1_8814B << BIT_SHIFT_MSI_TIMEOUT_ID_V1_8814B)
#define BIT_CLEAR_MSI_TIMEOUT_ID_V1_8814B(x)                                   \
	((x) & (~BITS_MSI_TIMEOUT_ID_V1_8814B))
#define BIT_GET_MSI_TIMEOUT_ID_V1_8814B(x)                                     \
	(((x) >> BIT_SHIFT_MSI_TIMEOUT_ID_V1_8814B) &                          \
	 BIT_MASK_MSI_TIMEOUT_ID_V1_8814B)
#define BIT_SET_MSI_TIMEOUT_ID_V1_8814B(x, v)                                  \
	(BIT_CLEAR_MSI_TIMEOUT_ID_V1_8814B(x) | BIT_MSI_TIMEOUT_ID_V1_8814B(v))

#define BIT_RADDR_RD_8814B BIT(7)
#define BIT_L0S_LINK_OFF_8814B BIT(4)
#define BIT_ACT_LINK_OFF_8814B BIT(3)
#define BIT_EN_SLOW_MAC_TX_8814B BIT(2)
#define BIT_EN_SLOW_MAC_RX_8814B BIT(1)
#define BIT_EN_SLOW_MAC_HW_8814B BIT(0)

/* 2 REG_STC_INT_CS_8814B(PCIE STATE CHANGE INTERRUPT CONTROL AND STATUS) */
#define BIT_STC_INT_EN_8814B BIT(31)

#define BIT_SHIFT_STC_INT_FLAG_8814B 16
#define BIT_MASK_STC_INT_FLAG_8814B 0xff
#define BIT_STC_INT_FLAG_8814B(x)                                              \
	(((x) & BIT_MASK_STC_INT_FLAG_8814B) << BIT_SHIFT_STC_INT_FLAG_8814B)
#define BITS_STC_INT_FLAG_8814B                                                \
	(BIT_MASK_STC_INT_FLAG_8814B << BIT_SHIFT_STC_INT_FLAG_8814B)
#define BIT_CLEAR_STC_INT_FLAG_8814B(x) ((x) & (~BITS_STC_INT_FLAG_8814B))
#define BIT_GET_STC_INT_FLAG_8814B(x)                                          \
	(((x) >> BIT_SHIFT_STC_INT_FLAG_8814B) & BIT_MASK_STC_INT_FLAG_8814B)
#define BIT_SET_STC_INT_FLAG_8814B(x, v)                                       \
	(BIT_CLEAR_STC_INT_FLAG_8814B(x) | BIT_STC_INT_FLAG_8814B(v))

#define BIT_SHIFT_STC_INT_IDX_8814B 8
#define BIT_MASK_STC_INT_IDX_8814B 0x7
#define BIT_STC_INT_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_STC_INT_IDX_8814B) << BIT_SHIFT_STC_INT_IDX_8814B)
#define BITS_STC_INT_IDX_8814B                                                 \
	(BIT_MASK_STC_INT_IDX_8814B << BIT_SHIFT_STC_INT_IDX_8814B)
#define BIT_CLEAR_STC_INT_IDX_8814B(x) ((x) & (~BITS_STC_INT_IDX_8814B))
#define BIT_GET_STC_INT_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_STC_INT_IDX_8814B) & BIT_MASK_STC_INT_IDX_8814B)
#define BIT_SET_STC_INT_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_STC_INT_IDX_8814B(x) | BIT_STC_INT_IDX_8814B(v))

#define BIT_SHIFT_STC_INT_REALTIME_CS_8814B 0
#define BIT_MASK_STC_INT_REALTIME_CS_8814B 0x3f
#define BIT_STC_INT_REALTIME_CS_8814B(x)                                       \
	(((x) & BIT_MASK_STC_INT_REALTIME_CS_8814B)                            \
	 << BIT_SHIFT_STC_INT_REALTIME_CS_8814B)
#define BITS_STC_INT_REALTIME_CS_8814B                                         \
	(BIT_MASK_STC_INT_REALTIME_CS_8814B                                    \
	 << BIT_SHIFT_STC_INT_REALTIME_CS_8814B)
#define BIT_CLEAR_STC_INT_REALTIME_CS_8814B(x)                                 \
	((x) & (~BITS_STC_INT_REALTIME_CS_8814B))
#define BIT_GET_STC_INT_REALTIME_CS_8814B(x)                                   \
	(((x) >> BIT_SHIFT_STC_INT_REALTIME_CS_8814B) &                        \
	 BIT_MASK_STC_INT_REALTIME_CS_8814B)
#define BIT_SET_STC_INT_REALTIME_CS_8814B(x, v)                                \
	(BIT_CLEAR_STC_INT_REALTIME_CS_8814B(x) |                              \
	 BIT_STC_INT_REALTIME_CS_8814B(v))

/* 2 REG_ST_INT_CFG_8814B(PCIE STATE CHANGE INTERRUPT CONFIGURATION) */
#define BIT_STC_INT_GRP_EN_8814B BIT(31)

#define BIT_SHIFT_STC_INT_EXPECT_LS_8814B 8
#define BIT_MASK_STC_INT_EXPECT_LS_8814B 0x3f
#define BIT_STC_INT_EXPECT_LS_8814B(x)                                         \
	(((x) & BIT_MASK_STC_INT_EXPECT_LS_8814B)                              \
	 << BIT_SHIFT_STC_INT_EXPECT_LS_8814B)
#define BITS_STC_INT_EXPECT_LS_8814B                                           \
	(BIT_MASK_STC_INT_EXPECT_LS_8814B << BIT_SHIFT_STC_INT_EXPECT_LS_8814B)
#define BIT_CLEAR_STC_INT_EXPECT_LS_8814B(x)                                   \
	((x) & (~BITS_STC_INT_EXPECT_LS_8814B))
#define BIT_GET_STC_INT_EXPECT_LS_8814B(x)                                     \
	(((x) >> BIT_SHIFT_STC_INT_EXPECT_LS_8814B) &                          \
	 BIT_MASK_STC_INT_EXPECT_LS_8814B)
#define BIT_SET_STC_INT_EXPECT_LS_8814B(x, v)                                  \
	(BIT_CLEAR_STC_INT_EXPECT_LS_8814B(x) | BIT_STC_INT_EXPECT_LS_8814B(v))

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_STC_INT_EXPECT_CS_8814B 0
#define BIT_MASK_STC_INT_EXPECT_CS_8814B 0x3f
#define BIT_STC_INT_EXPECT_CS_8814B(x)                                         \
	(((x) & BIT_MASK_STC_INT_EXPECT_CS_8814B)                              \
	 << BIT_SHIFT_STC_INT_EXPECT_CS_8814B)
#define BITS_STC_INT_EXPECT_CS_8814B                                           \
	(BIT_MASK_STC_INT_EXPECT_CS_8814B << BIT_SHIFT_STC_INT_EXPECT_CS_8814B)
#define BIT_CLEAR_STC_INT_EXPECT_CS_8814B(x)                                   \
	((x) & (~BITS_STC_INT_EXPECT_CS_8814B))
#define BIT_GET_STC_INT_EXPECT_CS_8814B(x)                                     \
	(((x) >> BIT_SHIFT_STC_INT_EXPECT_CS_8814B) &                          \
	 BIT_MASK_STC_INT_EXPECT_CS_8814B)
#define BIT_SET_STC_INT_EXPECT_CS_8814B(x, v)                                  \
	(BIT_CLEAR_STC_INT_EXPECT_CS_8814B(x) | BIT_STC_INT_EXPECT_CS_8814B(v))

/* 2 REG_ACH4_ACH5_TXBD_NUM_8814B */
#define BIT_PCIE_ACH5_FLAG_8814B BIT(30)

#define BIT_SHIFT_ACH5_DESC_MODE_8814B 28
#define BIT_MASK_ACH5_DESC_MODE_8814B 0x3
#define BIT_ACH5_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH5_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH5_DESC_MODE_8814B)
#define BITS_ACH5_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH5_DESC_MODE_8814B << BIT_SHIFT_ACH5_DESC_MODE_8814B)
#define BIT_CLEAR_ACH5_DESC_MODE_8814B(x) ((x) & (~BITS_ACH5_DESC_MODE_8814B))
#define BIT_GET_ACH5_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH5_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH5_DESC_MODE_8814B)
#define BIT_SET_ACH5_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH5_DESC_MODE_8814B(x) | BIT_ACH5_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH5_DESC_NUM_8814B 16
#define BIT_MASK_ACH5_DESC_NUM_8814B 0xfff
#define BIT_ACH5_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH5_DESC_NUM_8814B) << BIT_SHIFT_ACH5_DESC_NUM_8814B)
#define BITS_ACH5_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH5_DESC_NUM_8814B << BIT_SHIFT_ACH5_DESC_NUM_8814B)
#define BIT_CLEAR_ACH5_DESC_NUM_8814B(x) ((x) & (~BITS_ACH5_DESC_NUM_8814B))
#define BIT_GET_ACH5_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH5_DESC_NUM_8814B) & BIT_MASK_ACH5_DESC_NUM_8814B)
#define BIT_SET_ACH5_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH5_DESC_NUM_8814B(x) | BIT_ACH5_DESC_NUM_8814B(v))

#define BIT_PCIE_ACH4_FLAG_8814B BIT(14)

#define BIT_SHIFT_ACH4_DESC_MODE_8814B 12
#define BIT_MASK_ACH4_DESC_MODE_8814B 0x3
#define BIT_ACH4_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH4_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH4_DESC_MODE_8814B)
#define BITS_ACH4_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH4_DESC_MODE_8814B << BIT_SHIFT_ACH4_DESC_MODE_8814B)
#define BIT_CLEAR_ACH4_DESC_MODE_8814B(x) ((x) & (~BITS_ACH4_DESC_MODE_8814B))
#define BIT_GET_ACH4_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH4_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH4_DESC_MODE_8814B)
#define BIT_SET_ACH4_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH4_DESC_MODE_8814B(x) | BIT_ACH4_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH4_DESC_NUM_8814B 0
#define BIT_MASK_ACH4_DESC_NUM_8814B 0xfff
#define BIT_ACH4_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH4_DESC_NUM_8814B) << BIT_SHIFT_ACH4_DESC_NUM_8814B)
#define BITS_ACH4_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH4_DESC_NUM_8814B << BIT_SHIFT_ACH4_DESC_NUM_8814B)
#define BIT_CLEAR_ACH4_DESC_NUM_8814B(x) ((x) & (~BITS_ACH4_DESC_NUM_8814B))
#define BIT_GET_ACH4_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH4_DESC_NUM_8814B) & BIT_MASK_ACH4_DESC_NUM_8814B)
#define BIT_SET_ACH4_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH4_DESC_NUM_8814B(x) | BIT_ACH4_DESC_NUM_8814B(v))

/* 2 REG_FWCMDQ_TXBD_IDX_8814B */

#define BIT_SHIFT_FWCMDQ_HW_IDX_8814B 16
#define BIT_MASK_FWCMDQ_HW_IDX_8814B 0xfff
#define BIT_FWCMDQ_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_FWCMDQ_HW_IDX_8814B) << BIT_SHIFT_FWCMDQ_HW_IDX_8814B)
#define BITS_FWCMDQ_HW_IDX_8814B                                               \
	(BIT_MASK_FWCMDQ_HW_IDX_8814B << BIT_SHIFT_FWCMDQ_HW_IDX_8814B)
#define BIT_CLEAR_FWCMDQ_HW_IDX_8814B(x) ((x) & (~BITS_FWCMDQ_HW_IDX_8814B))
#define BIT_GET_FWCMDQ_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_FWCMDQ_HW_IDX_8814B) & BIT_MASK_FWCMDQ_HW_IDX_8814B)
#define BIT_SET_FWCMDQ_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_FWCMDQ_HW_IDX_8814B(x) | BIT_FWCMDQ_HW_IDX_8814B(v))

#define BIT_SHIFT_FWCMDQ_HOST_IDX_8814B 0
#define BIT_MASK_FWCMDQ_HOST_IDX_8814B 0xfff
#define BIT_FWCMDQ_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_FWCMDQ_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_FWCMDQ_HOST_IDX_8814B)
#define BITS_FWCMDQ_HOST_IDX_8814B                                             \
	(BIT_MASK_FWCMDQ_HOST_IDX_8814B << BIT_SHIFT_FWCMDQ_HOST_IDX_8814B)
#define BIT_CLEAR_FWCMDQ_HOST_IDX_8814B(x) ((x) & (~BITS_FWCMDQ_HOST_IDX_8814B))
#define BIT_GET_FWCMDQ_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_FWCMDQ_HOST_IDX_8814B) &                            \
	 BIT_MASK_FWCMDQ_HOST_IDX_8814B)
#define BIT_SET_FWCMDQ_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_FWCMDQ_HOST_IDX_8814B(x) | BIT_FWCMDQ_HOST_IDX_8814B(v))

/* 2 REG_P0HI8Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI8Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI8Q_HW_IDX_8814B 0xfff
#define BIT_P0HI8Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI8Q_HW_IDX_8814B) << BIT_SHIFT_P0HI8Q_HW_IDX_8814B)
#define BITS_P0HI8Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI8Q_HW_IDX_8814B << BIT_SHIFT_P0HI8Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI8Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI8Q_HW_IDX_8814B))
#define BIT_GET_P0HI8Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI8Q_HW_IDX_8814B) & BIT_MASK_P0HI8Q_HW_IDX_8814B)
#define BIT_SET_P0HI8Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI8Q_HW_IDX_8814B(x) | BIT_P0HI8Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI8Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI8Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI8Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI8Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI8Q_HOST_IDX_8814B)
#define BITS_P0HI8Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI8Q_HOST_IDX_8814B << BIT_SHIFT_P0HI8Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI8Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI8Q_HOST_IDX_8814B))
#define BIT_GET_P0HI8Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI8Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI8Q_HOST_IDX_8814B)
#define BIT_SET_P0HI8Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI8Q_HOST_IDX_8814B(x) | BIT_P0HI8Q_HOST_IDX_8814B(v))

/* 2 REG_H2CQ_TXBD_DESA_L_8814B */

#define BIT_SHIFT_H2CQ_TXBD_DESA_L_8814B 0
#define BIT_MASK_H2CQ_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_H2CQ_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_H2CQ_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_H2CQ_TXBD_DESA_L_8814B)
#define BITS_H2CQ_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_H2CQ_TXBD_DESA_L_8814B << BIT_SHIFT_H2CQ_TXBD_DESA_L_8814B)
#define BIT_CLEAR_H2CQ_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_H2CQ_TXBD_DESA_L_8814B))
#define BIT_GET_H2CQ_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_H2CQ_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_H2CQ_TXBD_DESA_L_8814B)
#define BIT_SET_H2CQ_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_H2CQ_TXBD_DESA_L_8814B(x) | BIT_H2CQ_TXBD_DESA_L_8814B(v))

/* 2 REG_H2CQ_TXBD_DESA_H_8814B */

#define BIT_SHIFT_H2CQ_TXBD_DESA_H_8814B 0
#define BIT_MASK_H2CQ_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_H2CQ_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_H2CQ_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_H2CQ_TXBD_DESA_H_8814B)
#define BITS_H2CQ_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_H2CQ_TXBD_DESA_H_8814B << BIT_SHIFT_H2CQ_TXBD_DESA_H_8814B)
#define BIT_CLEAR_H2CQ_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_H2CQ_TXBD_DESA_H_8814B))
#define BIT_GET_H2CQ_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_H2CQ_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_H2CQ_TXBD_DESA_H_8814B)
#define BIT_SET_H2CQ_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_H2CQ_TXBD_DESA_H_8814B(x) | BIT_H2CQ_TXBD_DESA_H_8814B(v))

/* 2 REG_H2CQ_TXBD_NUM_8814B */
#define BIT_PCIE_H2CQ_FLAG_8814B BIT(14)

#define BIT_SHIFT_H2CQ_DESC_MODE_8814B 12
#define BIT_MASK_H2CQ_DESC_MODE_8814B 0x3
#define BIT_H2CQ_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_H2CQ_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_H2CQ_DESC_MODE_8814B)
#define BITS_H2CQ_DESC_MODE_8814B                                              \
	(BIT_MASK_H2CQ_DESC_MODE_8814B << BIT_SHIFT_H2CQ_DESC_MODE_8814B)
#define BIT_CLEAR_H2CQ_DESC_MODE_8814B(x) ((x) & (~BITS_H2CQ_DESC_MODE_8814B))
#define BIT_GET_H2CQ_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_H2CQ_DESC_MODE_8814B) &                             \
	 BIT_MASK_H2CQ_DESC_MODE_8814B)
#define BIT_SET_H2CQ_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_H2CQ_DESC_MODE_8814B(x) | BIT_H2CQ_DESC_MODE_8814B(v))

#define BIT_SHIFT_H2CQ_DESC_NUM_8814B 0
#define BIT_MASK_H2CQ_DESC_NUM_8814B 0xfff
#define BIT_H2CQ_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_H2CQ_DESC_NUM_8814B) << BIT_SHIFT_H2CQ_DESC_NUM_8814B)
#define BITS_H2CQ_DESC_NUM_8814B                                               \
	(BIT_MASK_H2CQ_DESC_NUM_8814B << BIT_SHIFT_H2CQ_DESC_NUM_8814B)
#define BIT_CLEAR_H2CQ_DESC_NUM_8814B(x) ((x) & (~BITS_H2CQ_DESC_NUM_8814B))
#define BIT_GET_H2CQ_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_H2CQ_DESC_NUM_8814B) & BIT_MASK_H2CQ_DESC_NUM_8814B)
#define BIT_SET_H2CQ_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_H2CQ_DESC_NUM_8814B(x) | BIT_H2CQ_DESC_NUM_8814B(v))

/* 2 REG_H2CQ_TXBD_IDX_8814B */

#define BIT_SHIFT_H2CQ_HW_IDX_8814B 16
#define BIT_MASK_H2CQ_HW_IDX_8814B 0xfff
#define BIT_H2CQ_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_H2CQ_HW_IDX_8814B) << BIT_SHIFT_H2CQ_HW_IDX_8814B)
#define BITS_H2CQ_HW_IDX_8814B                                                 \
	(BIT_MASK_H2CQ_HW_IDX_8814B << BIT_SHIFT_H2CQ_HW_IDX_8814B)
#define BIT_CLEAR_H2CQ_HW_IDX_8814B(x) ((x) & (~BITS_H2CQ_HW_IDX_8814B))
#define BIT_GET_H2CQ_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_H2CQ_HW_IDX_8814B) & BIT_MASK_H2CQ_HW_IDX_8814B)
#define BIT_SET_H2CQ_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_H2CQ_HW_IDX_8814B(x) | BIT_H2CQ_HW_IDX_8814B(v))

#define BIT_SHIFT_H2CQ_HOST_IDX_8814B 0
#define BIT_MASK_H2CQ_HOST_IDX_8814B 0xfff
#define BIT_H2CQ_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_H2CQ_HOST_IDX_8814B) << BIT_SHIFT_H2CQ_HOST_IDX_8814B)
#define BITS_H2CQ_HOST_IDX_8814B                                               \
	(BIT_MASK_H2CQ_HOST_IDX_8814B << BIT_SHIFT_H2CQ_HOST_IDX_8814B)
#define BIT_CLEAR_H2CQ_HOST_IDX_8814B(x) ((x) & (~BITS_H2CQ_HOST_IDX_8814B))
#define BIT_GET_H2CQ_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_H2CQ_HOST_IDX_8814B) & BIT_MASK_H2CQ_HOST_IDX_8814B)
#define BIT_SET_H2CQ_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_H2CQ_HOST_IDX_8814B(x) | BIT_H2CQ_HOST_IDX_8814B(v))

/* 2 REG_H2CQ_CSR_8814B[31:0] (H2CQ CONTROL AND STATUS) */
#define BIT_H2CQ_FULL_8814B BIT(31)
#define BIT_CLR_H2CQ_HOST_IDX_8814B BIT(16)
#define BIT_CLR_H2CQ_HW_IDX_8814B BIT(8)
#define BIT_STOP_H2CQ_8814B BIT(0)

/* 2 REG_P0HI9Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI9Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI9Q_HW_IDX_8814B 0xfff
#define BIT_P0HI9Q_HW_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_P0HI9Q_HW_IDX_8814B) << BIT_SHIFT_P0HI9Q_HW_IDX_8814B)
#define BITS_P0HI9Q_HW_IDX_8814B                                               \
	(BIT_MASK_P0HI9Q_HW_IDX_8814B << BIT_SHIFT_P0HI9Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI9Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI9Q_HW_IDX_8814B))
#define BIT_GET_P0HI9Q_HW_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_P0HI9Q_HW_IDX_8814B) & BIT_MASK_P0HI9Q_HW_IDX_8814B)
#define BIT_SET_P0HI9Q_HW_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_P0HI9Q_HW_IDX_8814B(x) | BIT_P0HI9Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI9Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI9Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI9Q_HOST_IDX_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI9Q_HOST_IDX_8814B)                                \
	 << BIT_SHIFT_P0HI9Q_HOST_IDX_8814B)
#define BITS_P0HI9Q_HOST_IDX_8814B                                             \
	(BIT_MASK_P0HI9Q_HOST_IDX_8814B << BIT_SHIFT_P0HI9Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI9Q_HOST_IDX_8814B(x) ((x) & (~BITS_P0HI9Q_HOST_IDX_8814B))
#define BIT_GET_P0HI9Q_HOST_IDX_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI9Q_HOST_IDX_8814B) &                            \
	 BIT_MASK_P0HI9Q_HOST_IDX_8814B)
#define BIT_SET_P0HI9Q_HOST_IDX_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI9Q_HOST_IDX_8814B(x) | BIT_P0HI9Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI10Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI10Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI10Q_HW_IDX_8814B 0xfff
#define BIT_P0HI10Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI10Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI10Q_HW_IDX_8814B)
#define BITS_P0HI10Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI10Q_HW_IDX_8814B << BIT_SHIFT_P0HI10Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI10Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI10Q_HW_IDX_8814B))
#define BIT_GET_P0HI10Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI10Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI10Q_HW_IDX_8814B)
#define BIT_SET_P0HI10Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI10Q_HW_IDX_8814B(x) | BIT_P0HI10Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI10Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI10Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI10Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI10Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI10Q_HOST_IDX_8814B)
#define BITS_P0HI10Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI10Q_HOST_IDX_8814B << BIT_SHIFT_P0HI10Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI10Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI10Q_HOST_IDX_8814B))
#define BIT_GET_P0HI10Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI10Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI10Q_HOST_IDX_8814B)
#define BIT_SET_P0HI10Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI10Q_HOST_IDX_8814B(x) | BIT_P0HI10Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI11Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI11Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI11Q_HW_IDX_8814B 0xfff
#define BIT_P0HI11Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI11Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI11Q_HW_IDX_8814B)
#define BITS_P0HI11Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI11Q_HW_IDX_8814B << BIT_SHIFT_P0HI11Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI11Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI11Q_HW_IDX_8814B))
#define BIT_GET_P0HI11Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI11Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI11Q_HW_IDX_8814B)
#define BIT_SET_P0HI11Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI11Q_HW_IDX_8814B(x) | BIT_P0HI11Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI11Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI11Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI11Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI11Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI11Q_HOST_IDX_8814B)
#define BITS_P0HI11Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI11Q_HOST_IDX_8814B << BIT_SHIFT_P0HI11Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI11Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI11Q_HOST_IDX_8814B))
#define BIT_GET_P0HI11Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI11Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI11Q_HOST_IDX_8814B)
#define BIT_SET_P0HI11Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI11Q_HOST_IDX_8814B(x) | BIT_P0HI11Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI12Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI12Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI12Q_HW_IDX_8814B 0xfff
#define BIT_P0HI12Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI12Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI12Q_HW_IDX_8814B)
#define BITS_P0HI12Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI12Q_HW_IDX_8814B << BIT_SHIFT_P0HI12Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI12Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI12Q_HW_IDX_8814B))
#define BIT_GET_P0HI12Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI12Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI12Q_HW_IDX_8814B)
#define BIT_SET_P0HI12Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI12Q_HW_IDX_8814B(x) | BIT_P0HI12Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI12Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI12Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI12Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI12Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI12Q_HOST_IDX_8814B)
#define BITS_P0HI12Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI12Q_HOST_IDX_8814B << BIT_SHIFT_P0HI12Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI12Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI12Q_HOST_IDX_8814B))
#define BIT_GET_P0HI12Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI12Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI12Q_HOST_IDX_8814B)
#define BIT_SET_P0HI12Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI12Q_HOST_IDX_8814B(x) | BIT_P0HI12Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI13Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI13Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI13Q_HW_IDX_8814B 0xfff
#define BIT_P0HI13Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI13Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI13Q_HW_IDX_8814B)
#define BITS_P0HI13Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI13Q_HW_IDX_8814B << BIT_SHIFT_P0HI13Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI13Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI13Q_HW_IDX_8814B))
#define BIT_GET_P0HI13Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI13Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI13Q_HW_IDX_8814B)
#define BIT_SET_P0HI13Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI13Q_HW_IDX_8814B(x) | BIT_P0HI13Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI13Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI13Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI13Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI13Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI13Q_HOST_IDX_8814B)
#define BITS_P0HI13Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI13Q_HOST_IDX_8814B << BIT_SHIFT_P0HI13Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI13Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI13Q_HOST_IDX_8814B))
#define BIT_GET_P0HI13Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI13Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI13Q_HOST_IDX_8814B)
#define BIT_SET_P0HI13Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI13Q_HOST_IDX_8814B(x) | BIT_P0HI13Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI14Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI14Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI14Q_HW_IDX_8814B 0xfff
#define BIT_P0HI14Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI14Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI14Q_HW_IDX_8814B)
#define BITS_P0HI14Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI14Q_HW_IDX_8814B << BIT_SHIFT_P0HI14Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI14Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI14Q_HW_IDX_8814B))
#define BIT_GET_P0HI14Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI14Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI14Q_HW_IDX_8814B)
#define BIT_SET_P0HI14Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI14Q_HW_IDX_8814B(x) | BIT_P0HI14Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI14Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI14Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI14Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI14Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI14Q_HOST_IDX_8814B)
#define BITS_P0HI14Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI14Q_HOST_IDX_8814B << BIT_SHIFT_P0HI14Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI14Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI14Q_HOST_IDX_8814B))
#define BIT_GET_P0HI14Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI14Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI14Q_HOST_IDX_8814B)
#define BIT_SET_P0HI14Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI14Q_HOST_IDX_8814B(x) | BIT_P0HI14Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI15Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI15Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI15Q_HW_IDX_8814B 0xfff
#define BIT_P0HI15Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI15Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI15Q_HW_IDX_8814B)
#define BITS_P0HI15Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI15Q_HW_IDX_8814B << BIT_SHIFT_P0HI15Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI15Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI15Q_HW_IDX_8814B))
#define BIT_GET_P0HI15Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI15Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI15Q_HW_IDX_8814B)
#define BIT_SET_P0HI15Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI15Q_HW_IDX_8814B(x) | BIT_P0HI15Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI15Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI15Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI15Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI15Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI15Q_HOST_IDX_8814B)
#define BITS_P0HI15Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI15Q_HOST_IDX_8814B << BIT_SHIFT_P0HI15Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI15Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI15Q_HOST_IDX_8814B))
#define BIT_GET_P0HI15Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI15Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI15Q_HOST_IDX_8814B)
#define BIT_SET_P0HI15Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI15Q_HOST_IDX_8814B(x) | BIT_P0HI15Q_HOST_IDX_8814B(v))

/* 2 REG_CHANGE_PCIE_SPEED_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_RXDMA_ERR_CNT_8814B 8
#define BIT_MASK_RXDMA_ERR_CNT_8814B 0xff
#define BIT_RXDMA_ERR_CNT_8814B(x)                                             \
	(((x) & BIT_MASK_RXDMA_ERR_CNT_8814B) << BIT_SHIFT_RXDMA_ERR_CNT_8814B)
#define BITS_RXDMA_ERR_CNT_8814B                                               \
	(BIT_MASK_RXDMA_ERR_CNT_8814B << BIT_SHIFT_RXDMA_ERR_CNT_8814B)
#define BIT_CLEAR_RXDMA_ERR_CNT_8814B(x) ((x) & (~BITS_RXDMA_ERR_CNT_8814B))
#define BIT_GET_RXDMA_ERR_CNT_8814B(x)                                         \
	(((x) >> BIT_SHIFT_RXDMA_ERR_CNT_8814B) & BIT_MASK_RXDMA_ERR_CNT_8814B)
#define BIT_SET_RXDMA_ERR_CNT_8814B(x, v)                                      \
	(BIT_CLEAR_RXDMA_ERR_CNT_8814B(x) | BIT_RXDMA_ERR_CNT_8814B(v))

#define BIT_TXDMA_ERR_HANDLE_REQ_8814B BIT(7)
#define BIT_TXDMA_ERROR_PS_8814B BIT(6)
#define BIT_EN_TXDMA_STUCK_ERR_HANDLE_8814B BIT(5)
#define BIT_EN_TXDMA_RTN_ERR_HANDLE_8814B BIT(4)
#define BIT_RXDMA_ERR_HANDLE_REQ_8814B BIT(3)
#define BIT_RXDMA_ERROR_PS_8814B BIT(2)
#define BIT_EN_RXDMA_STUCK_ERR_HANDLE_8814B BIT(1)
#define BIT_EN_RXDMA_RTN_ERR_HANDLE_8814B BIT(0)

/* 2 REG_DEBUG_STATE1_8814B */

#define BIT_SHIFT_DEBUG_STATE1_8814B 0
#define BIT_MASK_DEBUG_STATE1_8814B 0xffffffffL
#define BIT_DEBUG_STATE1_8814B(x)                                              \
	(((x) & BIT_MASK_DEBUG_STATE1_8814B) << BIT_SHIFT_DEBUG_STATE1_8814B)
#define BITS_DEBUG_STATE1_8814B                                                \
	(BIT_MASK_DEBUG_STATE1_8814B << BIT_SHIFT_DEBUG_STATE1_8814B)
#define BIT_CLEAR_DEBUG_STATE1_8814B(x) ((x) & (~BITS_DEBUG_STATE1_8814B))
#define BIT_GET_DEBUG_STATE1_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DEBUG_STATE1_8814B) & BIT_MASK_DEBUG_STATE1_8814B)
#define BIT_SET_DEBUG_STATE1_8814B(x, v)                                       \
	(BIT_CLEAR_DEBUG_STATE1_8814B(x) | BIT_DEBUG_STATE1_8814B(v))

/* 2 REG_DEBUG_STATE2_8814B */

#define BIT_SHIFT_DEBUG_STATE2_8814B 0
#define BIT_MASK_DEBUG_STATE2_8814B 0xffffffffL
#define BIT_DEBUG_STATE2_8814B(x)                                              \
	(((x) & BIT_MASK_DEBUG_STATE2_8814B) << BIT_SHIFT_DEBUG_STATE2_8814B)
#define BITS_DEBUG_STATE2_8814B                                                \
	(BIT_MASK_DEBUG_STATE2_8814B << BIT_SHIFT_DEBUG_STATE2_8814B)
#define BIT_CLEAR_DEBUG_STATE2_8814B(x) ((x) & (~BITS_DEBUG_STATE2_8814B))
#define BIT_GET_DEBUG_STATE2_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DEBUG_STATE2_8814B) & BIT_MASK_DEBUG_STATE2_8814B)
#define BIT_SET_DEBUG_STATE2_8814B(x, v)                                       \
	(BIT_CLEAR_DEBUG_STATE2_8814B(x) | BIT_DEBUG_STATE2_8814B(v))

/* 2 REG_DEBUG_STATE3_8814B */

#define BIT_SHIFT_DEBUG_STATE3_8814B 0
#define BIT_MASK_DEBUG_STATE3_8814B 0xffffffffL
#define BIT_DEBUG_STATE3_8814B(x)                                              \
	(((x) & BIT_MASK_DEBUG_STATE3_8814B) << BIT_SHIFT_DEBUG_STATE3_8814B)
#define BITS_DEBUG_STATE3_8814B                                                \
	(BIT_MASK_DEBUG_STATE3_8814B << BIT_SHIFT_DEBUG_STATE3_8814B)
#define BIT_CLEAR_DEBUG_STATE3_8814B(x) ((x) & (~BITS_DEBUG_STATE3_8814B))
#define BIT_GET_DEBUG_STATE3_8814B(x)                                          \
	(((x) >> BIT_SHIFT_DEBUG_STATE3_8814B) & BIT_MASK_DEBUG_STATE3_8814B)
#define BIT_SET_DEBUG_STATE3_8814B(x, v)                                       \
	(BIT_CLEAR_DEBUG_STATE3_8814B(x) | BIT_DEBUG_STATE3_8814B(v))

/* 2 REG_ACH5_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH5_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH5_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH5_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH5_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH5_TXBD_DESA_L_8814B)
#define BITS_ACH5_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH5_TXBD_DESA_L_8814B << BIT_SHIFT_ACH5_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH5_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH5_TXBD_DESA_L_8814B))
#define BIT_GET_ACH5_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH5_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH5_TXBD_DESA_L_8814B)
#define BIT_SET_ACH5_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH5_TXBD_DESA_L_8814B(x) | BIT_ACH5_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH5_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH5_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH5_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH5_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH5_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH5_TXBD_DESA_H_8814B)
#define BITS_ACH5_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH5_TXBD_DESA_H_8814B << BIT_SHIFT_ACH5_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH5_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH5_TXBD_DESA_H_8814B))
#define BIT_GET_ACH5_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH5_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH5_TXBD_DESA_H_8814B)
#define BIT_SET_ACH5_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH5_TXBD_DESA_H_8814B(x) | BIT_ACH5_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH6_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH6_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH6_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH6_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH6_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH6_TXBD_DESA_L_8814B)
#define BITS_ACH6_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH6_TXBD_DESA_L_8814B << BIT_SHIFT_ACH6_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH6_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH6_TXBD_DESA_L_8814B))
#define BIT_GET_ACH6_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH6_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH6_TXBD_DESA_L_8814B)
#define BIT_SET_ACH6_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH6_TXBD_DESA_L_8814B(x) | BIT_ACH6_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH6_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH6_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH6_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH6_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH6_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH6_TXBD_DESA_H_8814B)
#define BITS_ACH6_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH6_TXBD_DESA_H_8814B << BIT_SHIFT_ACH6_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH6_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH6_TXBD_DESA_H_8814B))
#define BIT_GET_ACH6_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH6_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH6_TXBD_DESA_H_8814B)
#define BIT_SET_ACH6_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH6_TXBD_DESA_H_8814B(x) | BIT_ACH6_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH7_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH7_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH7_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH7_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH7_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH7_TXBD_DESA_L_8814B)
#define BITS_ACH7_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH7_TXBD_DESA_L_8814B << BIT_SHIFT_ACH7_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH7_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH7_TXBD_DESA_L_8814B))
#define BIT_GET_ACH7_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH7_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH7_TXBD_DESA_L_8814B)
#define BIT_SET_ACH7_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH7_TXBD_DESA_L_8814B(x) | BIT_ACH7_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH7_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH7_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH7_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH7_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH7_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH7_TXBD_DESA_H_8814B)
#define BITS_ACH7_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH7_TXBD_DESA_H_8814B << BIT_SHIFT_ACH7_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH7_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH7_TXBD_DESA_H_8814B))
#define BIT_GET_ACH7_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH7_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH7_TXBD_DESA_H_8814B)
#define BIT_SET_ACH7_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH7_TXBD_DESA_H_8814B(x) | BIT_ACH7_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH8_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH8_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH8_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH8_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH8_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH8_TXBD_DESA_L_8814B)
#define BITS_ACH8_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH8_TXBD_DESA_L_8814B << BIT_SHIFT_ACH8_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH8_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH8_TXBD_DESA_L_8814B))
#define BIT_GET_ACH8_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH8_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH8_TXBD_DESA_L_8814B)
#define BIT_SET_ACH8_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH8_TXBD_DESA_L_8814B(x) | BIT_ACH8_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH8_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH8_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH8_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH8_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH8_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH8_TXBD_DESA_H_8814B)
#define BITS_ACH8_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH8_TXBD_DESA_H_8814B << BIT_SHIFT_ACH8_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH8_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH8_TXBD_DESA_H_8814B))
#define BIT_GET_ACH8_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH8_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH8_TXBD_DESA_H_8814B)
#define BIT_SET_ACH8_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH8_TXBD_DESA_H_8814B(x) | BIT_ACH8_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH9_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH9_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH9_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH9_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH9_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH9_TXBD_DESA_L_8814B)
#define BITS_ACH9_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH9_TXBD_DESA_L_8814B << BIT_SHIFT_ACH9_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH9_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH9_TXBD_DESA_L_8814B))
#define BIT_GET_ACH9_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH9_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH9_TXBD_DESA_L_8814B)
#define BIT_SET_ACH9_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH9_TXBD_DESA_L_8814B(x) | BIT_ACH9_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH9_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH9_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH9_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH9_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH9_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH9_TXBD_DESA_H_8814B)
#define BITS_ACH9_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH9_TXBD_DESA_H_8814B << BIT_SHIFT_ACH9_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH9_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH9_TXBD_DESA_H_8814B))
#define BIT_GET_ACH9_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH9_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH9_TXBD_DESA_H_8814B)
#define BIT_SET_ACH9_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH9_TXBD_DESA_H_8814B(x) | BIT_ACH9_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH10_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH10_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH10_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH10_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_ACH10_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_ACH10_TXBD_DESA_L_8814B)
#define BITS_ACH10_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_ACH10_TXBD_DESA_L_8814B << BIT_SHIFT_ACH10_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH10_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_ACH10_TXBD_DESA_L_8814B))
#define BIT_GET_ACH10_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH10_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_ACH10_TXBD_DESA_L_8814B)
#define BIT_SET_ACH10_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_ACH10_TXBD_DESA_L_8814B(x) | BIT_ACH10_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH10_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH10_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH10_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH10_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_ACH10_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_ACH10_TXBD_DESA_H_8814B)
#define BITS_ACH10_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_ACH10_TXBD_DESA_H_8814B << BIT_SHIFT_ACH10_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH10_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_ACH10_TXBD_DESA_H_8814B))
#define BIT_GET_ACH10_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH10_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_ACH10_TXBD_DESA_H_8814B)
#define BIT_SET_ACH10_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_ACH10_TXBD_DESA_H_8814B(x) | BIT_ACH10_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH11_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH11_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH11_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH11_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_ACH11_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_ACH11_TXBD_DESA_L_8814B)
#define BITS_ACH11_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_ACH11_TXBD_DESA_L_8814B << BIT_SHIFT_ACH11_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH11_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_ACH11_TXBD_DESA_L_8814B))
#define BIT_GET_ACH11_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH11_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_ACH11_TXBD_DESA_L_8814B)
#define BIT_SET_ACH11_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_ACH11_TXBD_DESA_L_8814B(x) | BIT_ACH11_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH11_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH11_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH11_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH11_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_ACH11_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_ACH11_TXBD_DESA_H_8814B)
#define BITS_ACH11_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_ACH11_TXBD_DESA_H_8814B << BIT_SHIFT_ACH11_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH11_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_ACH11_TXBD_DESA_H_8814B))
#define BIT_GET_ACH11_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH11_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_ACH11_TXBD_DESA_H_8814B)
#define BIT_SET_ACH11_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_ACH11_TXBD_DESA_H_8814B(x) | BIT_ACH11_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH12_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH12_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH12_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH12_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_ACH12_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_ACH12_TXBD_DESA_L_8814B)
#define BITS_ACH12_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_ACH12_TXBD_DESA_L_8814B << BIT_SHIFT_ACH12_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH12_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_ACH12_TXBD_DESA_L_8814B))
#define BIT_GET_ACH12_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH12_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_ACH12_TXBD_DESA_L_8814B)
#define BIT_SET_ACH12_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_ACH12_TXBD_DESA_L_8814B(x) | BIT_ACH12_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH12_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH12_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH12_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH12_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_ACH12_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_ACH12_TXBD_DESA_H_8814B)
#define BITS_ACH12_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_ACH12_TXBD_DESA_H_8814B << BIT_SHIFT_ACH12_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH12_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_ACH12_TXBD_DESA_H_8814B))
#define BIT_GET_ACH12_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH12_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_ACH12_TXBD_DESA_H_8814B)
#define BIT_SET_ACH12_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_ACH12_TXBD_DESA_H_8814B(x) | BIT_ACH12_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH13_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH13_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH13_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH13_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_ACH13_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_ACH13_TXBD_DESA_L_8814B)
#define BITS_ACH13_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_ACH13_TXBD_DESA_L_8814B << BIT_SHIFT_ACH13_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH13_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_ACH13_TXBD_DESA_L_8814B))
#define BIT_GET_ACH13_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH13_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_ACH13_TXBD_DESA_L_8814B)
#define BIT_SET_ACH13_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_ACH13_TXBD_DESA_L_8814B(x) | BIT_ACH13_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH13_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH13_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH13_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH13_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_ACH13_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_ACH13_TXBD_DESA_H_8814B)
#define BITS_ACH13_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_ACH13_TXBD_DESA_H_8814B << BIT_SHIFT_ACH13_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH13_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_ACH13_TXBD_DESA_H_8814B))
#define BIT_GET_ACH13_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_ACH13_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_ACH13_TXBD_DESA_H_8814B)
#define BIT_SET_ACH13_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_ACH13_TXBD_DESA_H_8814B(x) | BIT_ACH13_TXBD_DESA_H_8814B(v))

/* 2 REG_HI0Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI0Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI0Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI0Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI0Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI0Q_TXBD_DESA_L_8814B)
#define BITS_HI0Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI0Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI0Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI0Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI0Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI0Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI0Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI0Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI0Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI0Q_TXBD_DESA_L_8814B(x) | BIT_HI0Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI0Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI0Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI0Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI0Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI0Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI0Q_TXBD_DESA_H_8814B)
#define BITS_HI0Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI0Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI0Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI0Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI0Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI0Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI0Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI0Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI0Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI0Q_TXBD_DESA_H_8814B(x) | BIT_HI0Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI1Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI1Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI1Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI1Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI1Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI1Q_TXBD_DESA_L_8814B)
#define BITS_HI1Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI1Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI1Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI1Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI1Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI1Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI1Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI1Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI1Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI1Q_TXBD_DESA_L_8814B(x) | BIT_HI1Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI1Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI1Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI1Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI1Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI1Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI1Q_TXBD_DESA_H_8814B)
#define BITS_HI1Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI1Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI1Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI1Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI1Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI1Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI1Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI1Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI1Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI1Q_TXBD_DESA_H_8814B(x) | BIT_HI1Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI2Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI2Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI2Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI2Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI2Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI2Q_TXBD_DESA_L_8814B)
#define BITS_HI2Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI2Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI2Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI2Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI2Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI2Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI2Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI2Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI2Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI2Q_TXBD_DESA_L_8814B(x) | BIT_HI2Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI2Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI2Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI2Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI2Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI2Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI2Q_TXBD_DESA_H_8814B)
#define BITS_HI2Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI2Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI2Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI2Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI2Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI2Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI2Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI2Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI2Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI2Q_TXBD_DESA_H_8814B(x) | BIT_HI2Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI3Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI3Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI3Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI3Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI3Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI3Q_TXBD_DESA_L_8814B)
#define BITS_HI3Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI3Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI3Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI3Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI3Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI3Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI3Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI3Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI3Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI3Q_TXBD_DESA_L_8814B(x) | BIT_HI3Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI3Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI3Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI3Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI3Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI3Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI3Q_TXBD_DESA_H_8814B)
#define BITS_HI3Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI3Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI3Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI3Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI3Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI3Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI3Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI3Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI3Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI3Q_TXBD_DESA_H_8814B(x) | BIT_HI3Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI4Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI4Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI4Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI4Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI4Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI4Q_TXBD_DESA_L_8814B)
#define BITS_HI4Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI4Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI4Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI4Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI4Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI4Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI4Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI4Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI4Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI4Q_TXBD_DESA_L_8814B(x) | BIT_HI4Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI4Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI4Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI4Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI4Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI4Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI4Q_TXBD_DESA_H_8814B)
#define BITS_HI4Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI4Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI4Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI4Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI4Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI4Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI4Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI4Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI4Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI4Q_TXBD_DESA_H_8814B(x) | BIT_HI4Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI5Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI5Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI5Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI5Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI5Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI5Q_TXBD_DESA_L_8814B)
#define BITS_HI5Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI5Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI5Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI5Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI5Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI5Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI5Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI5Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI5Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI5Q_TXBD_DESA_L_8814B(x) | BIT_HI5Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI5Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI5Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI5Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI5Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI5Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI5Q_TXBD_DESA_H_8814B)
#define BITS_HI5Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI5Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI5Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI5Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI5Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI5Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI5Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI5Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI5Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI5Q_TXBD_DESA_H_8814B(x) | BIT_HI5Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI6Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI6Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI6Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI6Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI6Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI6Q_TXBD_DESA_L_8814B)
#define BITS_HI6Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI6Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI6Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI6Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI6Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI6Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI6Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI6Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI6Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI6Q_TXBD_DESA_L_8814B(x) | BIT_HI6Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI6Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI6Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI6Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI6Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI6Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI6Q_TXBD_DESA_H_8814B)
#define BITS_HI6Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI6Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI6Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI6Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI6Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI6Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI6Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI6Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI6Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI6Q_TXBD_DESA_H_8814B(x) | BIT_HI6Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI7Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI7Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI7Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI7Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI7Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI7Q_TXBD_DESA_L_8814B)
#define BITS_HI7Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI7Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI7Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI7Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI7Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI7Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI7Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI7Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI7Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI7Q_TXBD_DESA_L_8814B(x) | BIT_HI7Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI7Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI7Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI7Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI7Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI7Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI7Q_TXBD_DESA_H_8814B)
#define BITS_HI7Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI7Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI7Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI7Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI7Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI7Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI7Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI7Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI7Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI7Q_TXBD_DESA_H_8814B(x) | BIT_HI7Q_TXBD_DESA_H_8814B(v))

/* 2 REG_ACH8_ACH9_TXBD_NUM_8814B */
#define BIT_PCIE_ACH9_FLAG_8814B BIT(30)

#define BIT_SHIFT_ACH9_DESC_MODE_8814B 28
#define BIT_MASK_ACH9_DESC_MODE_8814B 0x3
#define BIT_ACH9_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH9_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH9_DESC_MODE_8814B)
#define BITS_ACH9_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH9_DESC_MODE_8814B << BIT_SHIFT_ACH9_DESC_MODE_8814B)
#define BIT_CLEAR_ACH9_DESC_MODE_8814B(x) ((x) & (~BITS_ACH9_DESC_MODE_8814B))
#define BIT_GET_ACH9_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH9_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH9_DESC_MODE_8814B)
#define BIT_SET_ACH9_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH9_DESC_MODE_8814B(x) | BIT_ACH9_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH9_DESC_NUM_8814B 16
#define BIT_MASK_ACH9_DESC_NUM_8814B 0xfff
#define BIT_ACH9_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH9_DESC_NUM_8814B) << BIT_SHIFT_ACH9_DESC_NUM_8814B)
#define BITS_ACH9_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH9_DESC_NUM_8814B << BIT_SHIFT_ACH9_DESC_NUM_8814B)
#define BIT_CLEAR_ACH9_DESC_NUM_8814B(x) ((x) & (~BITS_ACH9_DESC_NUM_8814B))
#define BIT_GET_ACH9_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH9_DESC_NUM_8814B) & BIT_MASK_ACH9_DESC_NUM_8814B)
#define BIT_SET_ACH9_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH9_DESC_NUM_8814B(x) | BIT_ACH9_DESC_NUM_8814B(v))

#define BIT_PCIE_ACH8_FLAG_8814B BIT(14)

#define BIT_SHIFT_ACH8_DESC_MODE_8814B 12
#define BIT_MASK_ACH8_DESC_MODE_8814B 0x3
#define BIT_ACH8_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH8_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH8_DESC_MODE_8814B)
#define BITS_ACH8_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH8_DESC_MODE_8814B << BIT_SHIFT_ACH8_DESC_MODE_8814B)
#define BIT_CLEAR_ACH8_DESC_MODE_8814B(x) ((x) & (~BITS_ACH8_DESC_MODE_8814B))
#define BIT_GET_ACH8_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH8_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH8_DESC_MODE_8814B)
#define BIT_SET_ACH8_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH8_DESC_MODE_8814B(x) | BIT_ACH8_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH8_DESC_NUM_8814B 0
#define BIT_MASK_ACH8_DESC_NUM_8814B 0xfff
#define BIT_ACH8_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH8_DESC_NUM_8814B) << BIT_SHIFT_ACH8_DESC_NUM_8814B)
#define BITS_ACH8_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH8_DESC_NUM_8814B << BIT_SHIFT_ACH8_DESC_NUM_8814B)
#define BIT_CLEAR_ACH8_DESC_NUM_8814B(x) ((x) & (~BITS_ACH8_DESC_NUM_8814B))
#define BIT_GET_ACH8_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH8_DESC_NUM_8814B) & BIT_MASK_ACH8_DESC_NUM_8814B)
#define BIT_SET_ACH8_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH8_DESC_NUM_8814B(x) | BIT_ACH8_DESC_NUM_8814B(v))

/* 2 REG_ACH10_ACH11_TXBD_NUM_8814B */
#define BIT_PCIE_ACH11_FLAG_8814B BIT(30)

#define BIT_SHIFT_ACH11_DESC_MODE_8814B 28
#define BIT_MASK_ACH11_DESC_MODE_8814B 0x3
#define BIT_ACH11_DESC_MODE_8814B(x)                                           \
	(((x) & BIT_MASK_ACH11_DESC_MODE_8814B)                                \
	 << BIT_SHIFT_ACH11_DESC_MODE_8814B)
#define BITS_ACH11_DESC_MODE_8814B                                             \
	(BIT_MASK_ACH11_DESC_MODE_8814B << BIT_SHIFT_ACH11_DESC_MODE_8814B)
#define BIT_CLEAR_ACH11_DESC_MODE_8814B(x) ((x) & (~BITS_ACH11_DESC_MODE_8814B))
#define BIT_GET_ACH11_DESC_MODE_8814B(x)                                       \
	(((x) >> BIT_SHIFT_ACH11_DESC_MODE_8814B) &                            \
	 BIT_MASK_ACH11_DESC_MODE_8814B)
#define BIT_SET_ACH11_DESC_MODE_8814B(x, v)                                    \
	(BIT_CLEAR_ACH11_DESC_MODE_8814B(x) | BIT_ACH11_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH11_DESC_NUM_8814B 16
#define BIT_MASK_ACH11_DESC_NUM_8814B 0xfff
#define BIT_ACH11_DESC_NUM_8814B(x)                                            \
	(((x) & BIT_MASK_ACH11_DESC_NUM_8814B)                                 \
	 << BIT_SHIFT_ACH11_DESC_NUM_8814B)
#define BITS_ACH11_DESC_NUM_8814B                                              \
	(BIT_MASK_ACH11_DESC_NUM_8814B << BIT_SHIFT_ACH11_DESC_NUM_8814B)
#define BIT_CLEAR_ACH11_DESC_NUM_8814B(x) ((x) & (~BITS_ACH11_DESC_NUM_8814B))
#define BIT_GET_ACH11_DESC_NUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH11_DESC_NUM_8814B) &                             \
	 BIT_MASK_ACH11_DESC_NUM_8814B)
#define BIT_SET_ACH11_DESC_NUM_8814B(x, v)                                     \
	(BIT_CLEAR_ACH11_DESC_NUM_8814B(x) | BIT_ACH11_DESC_NUM_8814B(v))

#define BIT_PCIE_ACH10_FLAG_8814B BIT(14)

#define BIT_SHIFT_ACH10_DESC_MODE_8814B 12
#define BIT_MASK_ACH10_DESC_MODE_8814B 0x3
#define BIT_ACH10_DESC_MODE_8814B(x)                                           \
	(((x) & BIT_MASK_ACH10_DESC_MODE_8814B)                                \
	 << BIT_SHIFT_ACH10_DESC_MODE_8814B)
#define BITS_ACH10_DESC_MODE_8814B                                             \
	(BIT_MASK_ACH10_DESC_MODE_8814B << BIT_SHIFT_ACH10_DESC_MODE_8814B)
#define BIT_CLEAR_ACH10_DESC_MODE_8814B(x) ((x) & (~BITS_ACH10_DESC_MODE_8814B))
#define BIT_GET_ACH10_DESC_MODE_8814B(x)                                       \
	(((x) >> BIT_SHIFT_ACH10_DESC_MODE_8814B) &                            \
	 BIT_MASK_ACH10_DESC_MODE_8814B)
#define BIT_SET_ACH10_DESC_MODE_8814B(x, v)                                    \
	(BIT_CLEAR_ACH10_DESC_MODE_8814B(x) | BIT_ACH10_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH10_DESC_NUM_8814B 0
#define BIT_MASK_ACH10_DESC_NUM_8814B 0xfff
#define BIT_ACH10_DESC_NUM_8814B(x)                                            \
	(((x) & BIT_MASK_ACH10_DESC_NUM_8814B)                                 \
	 << BIT_SHIFT_ACH10_DESC_NUM_8814B)
#define BITS_ACH10_DESC_NUM_8814B                                              \
	(BIT_MASK_ACH10_DESC_NUM_8814B << BIT_SHIFT_ACH10_DESC_NUM_8814B)
#define BIT_CLEAR_ACH10_DESC_NUM_8814B(x) ((x) & (~BITS_ACH10_DESC_NUM_8814B))
#define BIT_GET_ACH10_DESC_NUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH10_DESC_NUM_8814B) &                             \
	 BIT_MASK_ACH10_DESC_NUM_8814B)
#define BIT_SET_ACH10_DESC_NUM_8814B(x, v)                                     \
	(BIT_CLEAR_ACH10_DESC_NUM_8814B(x) | BIT_ACH10_DESC_NUM_8814B(v))

/* 2 REG_ACH12_ACH13_TXBD_NUM_8814B */
#define BIT_PCIE_ACH13_FLAG_8814B BIT(30)

#define BIT_SHIFT_ACH13_DESC_MODE_8814B 28
#define BIT_MASK_ACH13_DESC_MODE_8814B 0x3
#define BIT_ACH13_DESC_MODE_8814B(x)                                           \
	(((x) & BIT_MASK_ACH13_DESC_MODE_8814B)                                \
	 << BIT_SHIFT_ACH13_DESC_MODE_8814B)
#define BITS_ACH13_DESC_MODE_8814B                                             \
	(BIT_MASK_ACH13_DESC_MODE_8814B << BIT_SHIFT_ACH13_DESC_MODE_8814B)
#define BIT_CLEAR_ACH13_DESC_MODE_8814B(x) ((x) & (~BITS_ACH13_DESC_MODE_8814B))
#define BIT_GET_ACH13_DESC_MODE_8814B(x)                                       \
	(((x) >> BIT_SHIFT_ACH13_DESC_MODE_8814B) &                            \
	 BIT_MASK_ACH13_DESC_MODE_8814B)
#define BIT_SET_ACH13_DESC_MODE_8814B(x, v)                                    \
	(BIT_CLEAR_ACH13_DESC_MODE_8814B(x) | BIT_ACH13_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH13_DESC_NUM_8814B 16
#define BIT_MASK_ACH13_DESC_NUM_8814B 0xfff
#define BIT_ACH13_DESC_NUM_8814B(x)                                            \
	(((x) & BIT_MASK_ACH13_DESC_NUM_8814B)                                 \
	 << BIT_SHIFT_ACH13_DESC_NUM_8814B)
#define BITS_ACH13_DESC_NUM_8814B                                              \
	(BIT_MASK_ACH13_DESC_NUM_8814B << BIT_SHIFT_ACH13_DESC_NUM_8814B)
#define BIT_CLEAR_ACH13_DESC_NUM_8814B(x) ((x) & (~BITS_ACH13_DESC_NUM_8814B))
#define BIT_GET_ACH13_DESC_NUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH13_DESC_NUM_8814B) &                             \
	 BIT_MASK_ACH13_DESC_NUM_8814B)
#define BIT_SET_ACH13_DESC_NUM_8814B(x, v)                                     \
	(BIT_CLEAR_ACH13_DESC_NUM_8814B(x) | BIT_ACH13_DESC_NUM_8814B(v))

#define BIT_PCIE_ACH12_FLAG_8814B BIT(14)

#define BIT_SHIFT_ACH12_DESC_MODE_8814B 12
#define BIT_MASK_ACH12_DESC_MODE_8814B 0x3
#define BIT_ACH12_DESC_MODE_8814B(x)                                           \
	(((x) & BIT_MASK_ACH12_DESC_MODE_8814B)                                \
	 << BIT_SHIFT_ACH12_DESC_MODE_8814B)
#define BITS_ACH12_DESC_MODE_8814B                                             \
	(BIT_MASK_ACH12_DESC_MODE_8814B << BIT_SHIFT_ACH12_DESC_MODE_8814B)
#define BIT_CLEAR_ACH12_DESC_MODE_8814B(x) ((x) & (~BITS_ACH12_DESC_MODE_8814B))
#define BIT_GET_ACH12_DESC_MODE_8814B(x)                                       \
	(((x) >> BIT_SHIFT_ACH12_DESC_MODE_8814B) &                            \
	 BIT_MASK_ACH12_DESC_MODE_8814B)
#define BIT_SET_ACH12_DESC_MODE_8814B(x, v)                                    \
	(BIT_CLEAR_ACH12_DESC_MODE_8814B(x) | BIT_ACH12_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH12_DESC_NUM_8814B 0
#define BIT_MASK_ACH12_DESC_NUM_8814B 0xfff
#define BIT_ACH12_DESC_NUM_8814B(x)                                            \
	(((x) & BIT_MASK_ACH12_DESC_NUM_8814B)                                 \
	 << BIT_SHIFT_ACH12_DESC_NUM_8814B)
#define BITS_ACH12_DESC_NUM_8814B                                              \
	(BIT_MASK_ACH12_DESC_NUM_8814B << BIT_SHIFT_ACH12_DESC_NUM_8814B)
#define BIT_CLEAR_ACH12_DESC_NUM_8814B(x) ((x) & (~BITS_ACH12_DESC_NUM_8814B))
#define BIT_GET_ACH12_DESC_NUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH12_DESC_NUM_8814B) &                             \
	 BIT_MASK_ACH12_DESC_NUM_8814B)
#define BIT_SET_ACH12_DESC_NUM_8814B(x, v)                                     \
	(BIT_CLEAR_ACH12_DESC_NUM_8814B(x) | BIT_ACH12_DESC_NUM_8814B(v))

/* 2 REG_OLD_DEHANG_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_OLD_DEHANG_8814B BIT(1)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ACH4_TXBD_DESA_L_8814B */

#define BIT_SHIFT_ACH4_TXBD_DESA_L_8814B 0
#define BIT_MASK_ACH4_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_ACH4_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_ACH4_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_ACH4_TXBD_DESA_L_8814B)
#define BITS_ACH4_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_ACH4_TXBD_DESA_L_8814B << BIT_SHIFT_ACH4_TXBD_DESA_L_8814B)
#define BIT_CLEAR_ACH4_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_ACH4_TXBD_DESA_L_8814B))
#define BIT_GET_ACH4_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH4_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_ACH4_TXBD_DESA_L_8814B)
#define BIT_SET_ACH4_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_ACH4_TXBD_DESA_L_8814B(x) | BIT_ACH4_TXBD_DESA_L_8814B(v))

/* 2 REG_ACH4_TXBD_DESA_H_8814B */

#define BIT_SHIFT_ACH4_TXBD_DESA_H_8814B 0
#define BIT_MASK_ACH4_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_ACH4_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_ACH4_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_ACH4_TXBD_DESA_H_8814B)
#define BITS_ACH4_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_ACH4_TXBD_DESA_H_8814B << BIT_SHIFT_ACH4_TXBD_DESA_H_8814B)
#define BIT_CLEAR_ACH4_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_ACH4_TXBD_DESA_H_8814B))
#define BIT_GET_ACH4_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_ACH4_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_ACH4_TXBD_DESA_H_8814B)
#define BIT_SET_ACH4_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_ACH4_TXBD_DESA_H_8814B(x) | BIT_ACH4_TXBD_DESA_H_8814B(v))

/* 2 REG_HI8Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI8Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI8Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI8Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI8Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI8Q_TXBD_DESA_L_8814B)
#define BITS_HI8Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI8Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI8Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI8Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI8Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI8Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI8Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI8Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI8Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI8Q_TXBD_DESA_L_8814B(x) | BIT_HI8Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI8Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI8Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI8Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI8Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI8Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI8Q_TXBD_DESA_H_8814B)
#define BITS_HI8Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI8Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI8Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI8Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI8Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI8Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI8Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI8Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI8Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI8Q_TXBD_DESA_H_8814B(x) | BIT_HI8Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI9Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI9Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI9Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI9Q_TXBD_DESA_L_8814B(x)                                          \
	(((x) & BIT_MASK_HI9Q_TXBD_DESA_L_8814B)                               \
	 << BIT_SHIFT_HI9Q_TXBD_DESA_L_8814B)
#define BITS_HI9Q_TXBD_DESA_L_8814B                                            \
	(BIT_MASK_HI9Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI9Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI9Q_TXBD_DESA_L_8814B(x)                                    \
	((x) & (~BITS_HI9Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI9Q_TXBD_DESA_L_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI9Q_TXBD_DESA_L_8814B) &                           \
	 BIT_MASK_HI9Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI9Q_TXBD_DESA_L_8814B(x, v)                                   \
	(BIT_CLEAR_HI9Q_TXBD_DESA_L_8814B(x) | BIT_HI9Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI9Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI9Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI9Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI9Q_TXBD_DESA_H_8814B(x)                                          \
	(((x) & BIT_MASK_HI9Q_TXBD_DESA_H_8814B)                               \
	 << BIT_SHIFT_HI9Q_TXBD_DESA_H_8814B)
#define BITS_HI9Q_TXBD_DESA_H_8814B                                            \
	(BIT_MASK_HI9Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI9Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI9Q_TXBD_DESA_H_8814B(x)                                    \
	((x) & (~BITS_HI9Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI9Q_TXBD_DESA_H_8814B(x)                                      \
	(((x) >> BIT_SHIFT_HI9Q_TXBD_DESA_H_8814B) &                           \
	 BIT_MASK_HI9Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI9Q_TXBD_DESA_H_8814B(x, v)                                   \
	(BIT_CLEAR_HI9Q_TXBD_DESA_H_8814B(x) | BIT_HI9Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI10Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI10Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI10Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI10Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI10Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI10Q_TXBD_DESA_L_8814B)
#define BITS_HI10Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI10Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI10Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI10Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI10Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI10Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI10Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI10Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI10Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI10Q_TXBD_DESA_L_8814B(x) | BIT_HI10Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI10Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI10Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI10Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI10Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI10Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI10Q_TXBD_DESA_H_8814B)
#define BITS_HI10Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI10Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI10Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI10Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI10Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI10Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI10Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI10Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI10Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI10Q_TXBD_DESA_H_8814B(x) | BIT_HI10Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI11Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI11Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI11Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI11Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI11Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI11Q_TXBD_DESA_L_8814B)
#define BITS_HI11Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI11Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI11Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI11Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI11Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI11Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI11Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI11Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI11Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI11Q_TXBD_DESA_L_8814B(x) | BIT_HI11Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI11Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI11Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI11Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI11Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI11Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI11Q_TXBD_DESA_H_8814B)
#define BITS_HI11Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI11Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI11Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI11Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI11Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI11Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI11Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI11Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI11Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI11Q_TXBD_DESA_H_8814B(x) | BIT_HI11Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI12Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI12Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI12Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI12Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI12Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI12Q_TXBD_DESA_L_8814B)
#define BITS_HI12Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI12Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI12Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI12Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI12Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI12Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI12Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI12Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI12Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI12Q_TXBD_DESA_L_8814B(x) | BIT_HI12Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI12Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI12Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI12Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI12Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI12Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI12Q_TXBD_DESA_H_8814B)
#define BITS_HI12Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI12Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI12Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI12Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI12Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI12Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI12Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI12Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI12Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI12Q_TXBD_DESA_H_8814B(x) | BIT_HI12Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI13Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI13Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI13Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI13Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI13Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI13Q_TXBD_DESA_L_8814B)
#define BITS_HI13Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI13Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI13Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI13Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI13Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI13Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI13Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI13Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI13Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI13Q_TXBD_DESA_L_8814B(x) | BIT_HI13Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI13Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI13Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI13Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI13Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI13Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI13Q_TXBD_DESA_H_8814B)
#define BITS_HI13Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI13Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI13Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI13Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI13Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI13Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI13Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI13Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI13Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI13Q_TXBD_DESA_H_8814B(x) | BIT_HI13Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI14Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI14Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI14Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI14Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI14Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI14Q_TXBD_DESA_L_8814B)
#define BITS_HI14Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI14Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI14Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI14Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI14Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI14Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI14Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI14Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI14Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI14Q_TXBD_DESA_L_8814B(x) | BIT_HI14Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI14Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI14Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI14Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI14Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI14Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI14Q_TXBD_DESA_H_8814B)
#define BITS_HI14Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI14Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI14Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI14Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI14Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI14Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI14Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI14Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI14Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI14Q_TXBD_DESA_H_8814B(x) | BIT_HI14Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI15Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI15Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI15Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI15Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI15Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI15Q_TXBD_DESA_L_8814B)
#define BITS_HI15Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI15Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI15Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI15Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI15Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI15Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI15Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI15Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI15Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI15Q_TXBD_DESA_L_8814B(x) | BIT_HI15Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI15Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI15Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI15Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI15Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI15Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI15Q_TXBD_DESA_H_8814B)
#define BITS_HI15Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI15Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI15Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI15Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI15Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI15Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI15Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI15Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI15Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI15Q_TXBD_DESA_H_8814B(x) | BIT_HI15Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI16Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI16Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI16Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI16Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI16Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI16Q_TXBD_DESA_L_8814B)
#define BITS_HI16Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI16Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI16Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI16Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI16Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI16Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI16Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI16Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI16Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI16Q_TXBD_DESA_L_8814B(x) | BIT_HI16Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI16Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI16Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI16Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI16Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI16Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI16Q_TXBD_DESA_H_8814B)
#define BITS_HI16Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI16Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI16Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI16Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI16Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI16Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI16Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI16Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI16Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI16Q_TXBD_DESA_H_8814B(x) | BIT_HI16Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI17Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI17Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI17Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI17Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI17Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI17Q_TXBD_DESA_L_8814B)
#define BITS_HI17Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI17Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI17Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI17Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI17Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI17Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI17Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI17Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI17Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI17Q_TXBD_DESA_L_8814B(x) | BIT_HI17Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI17Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI17Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI17Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI17Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI17Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI17Q_TXBD_DESA_H_8814B)
#define BITS_HI17Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI17Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI17Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI17Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI17Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI17Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI17Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI17Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI17Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI17Q_TXBD_DESA_H_8814B(x) | BIT_HI17Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI18Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI18Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI18Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI18Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI18Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI18Q_TXBD_DESA_L_8814B)
#define BITS_HI18Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI18Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI18Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI18Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI18Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI18Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI18Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI18Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI18Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI18Q_TXBD_DESA_L_8814B(x) | BIT_HI18Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI18Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI18Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI18Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI18Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI18Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI18Q_TXBD_DESA_H_8814B)
#define BITS_HI18Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI18Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI18Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI18Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI18Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI18Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI18Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI18Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI18Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI18Q_TXBD_DESA_H_8814B(x) | BIT_HI18Q_TXBD_DESA_H_8814B(v))

/* 2 REG_HI19Q_TXBD_DESA_L_8814B */

#define BIT_SHIFT_HI19Q_TXBD_DESA_L_8814B 0
#define BIT_MASK_HI19Q_TXBD_DESA_L_8814B 0xffffffffL
#define BIT_HI19Q_TXBD_DESA_L_8814B(x)                                         \
	(((x) & BIT_MASK_HI19Q_TXBD_DESA_L_8814B)                              \
	 << BIT_SHIFT_HI19Q_TXBD_DESA_L_8814B)
#define BITS_HI19Q_TXBD_DESA_L_8814B                                           \
	(BIT_MASK_HI19Q_TXBD_DESA_L_8814B << BIT_SHIFT_HI19Q_TXBD_DESA_L_8814B)
#define BIT_CLEAR_HI19Q_TXBD_DESA_L_8814B(x)                                   \
	((x) & (~BITS_HI19Q_TXBD_DESA_L_8814B))
#define BIT_GET_HI19Q_TXBD_DESA_L_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI19Q_TXBD_DESA_L_8814B) &                          \
	 BIT_MASK_HI19Q_TXBD_DESA_L_8814B)
#define BIT_SET_HI19Q_TXBD_DESA_L_8814B(x, v)                                  \
	(BIT_CLEAR_HI19Q_TXBD_DESA_L_8814B(x) | BIT_HI19Q_TXBD_DESA_L_8814B(v))

/* 2 REG_HI19Q_TXBD_DESA_H_8814B */

#define BIT_SHIFT_HI19Q_TXBD_DESA_H_8814B 0
#define BIT_MASK_HI19Q_TXBD_DESA_H_8814B 0xffffffffL
#define BIT_HI19Q_TXBD_DESA_H_8814B(x)                                         \
	(((x) & BIT_MASK_HI19Q_TXBD_DESA_H_8814B)                              \
	 << BIT_SHIFT_HI19Q_TXBD_DESA_H_8814B)
#define BITS_HI19Q_TXBD_DESA_H_8814B                                           \
	(BIT_MASK_HI19Q_TXBD_DESA_H_8814B << BIT_SHIFT_HI19Q_TXBD_DESA_H_8814B)
#define BIT_CLEAR_HI19Q_TXBD_DESA_H_8814B(x)                                   \
	((x) & (~BITS_HI19Q_TXBD_DESA_H_8814B))
#define BIT_GET_HI19Q_TXBD_DESA_H_8814B(x)                                     \
	(((x) >> BIT_SHIFT_HI19Q_TXBD_DESA_H_8814B) &                          \
	 BIT_MASK_HI19Q_TXBD_DESA_H_8814B)
#define BIT_SET_HI19Q_TXBD_DESA_H_8814B(x, v)                                  \
	(BIT_CLEAR_HI19Q_TXBD_DESA_H_8814B(x) | BIT_HI19Q_TXBD_DESA_H_8814B(v))

/* 2 REG_BD_RWPTR_CLR6_8814B */

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_P0HI19Q_HW_IDX_8814B BIT(25)
#define BIT_CLR_P0HI18Q_HW_IDX_8814B BIT(24)
#define BIT_CLR_P0HI17Q_HW_IDX_8814B BIT(23)
#define BIT_CLR_P0HI16Q_HW_IDX_8814B BIT(22)

/* 2 REG_NOT_VALID_8814B */
#define BIT_CLR_P0HI19Q_HOST_IDX_8814B BIT(9)
#define BIT_CLR_P0HI18Q_HOST_IDX_8814B BIT(8)
#define BIT_CLR_P0HI17Q_HOST_IDX_8814B BIT(7)
#define BIT_CLR_P0HI16Q_HOST_IDX_8814B BIT(6)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_P0HI16Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI16Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI16Q_HW_IDX_8814B 0xfff
#define BIT_P0HI16Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI16Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI16Q_HW_IDX_8814B)
#define BITS_P0HI16Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI16Q_HW_IDX_8814B << BIT_SHIFT_P0HI16Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI16Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI16Q_HW_IDX_8814B))
#define BIT_GET_P0HI16Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI16Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI16Q_HW_IDX_8814B)
#define BIT_SET_P0HI16Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI16Q_HW_IDX_8814B(x) | BIT_P0HI16Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI16Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI16Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI16Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI16Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI16Q_HOST_IDX_8814B)
#define BITS_P0HI16Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI16Q_HOST_IDX_8814B << BIT_SHIFT_P0HI16Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI16Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI16Q_HOST_IDX_8814B))
#define BIT_GET_P0HI16Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI16Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI16Q_HOST_IDX_8814B)
#define BIT_SET_P0HI16Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI16Q_HOST_IDX_8814B(x) | BIT_P0HI16Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI17Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI17Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI17Q_HW_IDX_8814B 0xfff
#define BIT_P0HI17Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI17Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI17Q_HW_IDX_8814B)
#define BITS_P0HI17Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI17Q_HW_IDX_8814B << BIT_SHIFT_P0HI17Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI17Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI17Q_HW_IDX_8814B))
#define BIT_GET_P0HI17Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI17Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI17Q_HW_IDX_8814B)
#define BIT_SET_P0HI17Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI17Q_HW_IDX_8814B(x) | BIT_P0HI17Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI17Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI17Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI17Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI17Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI17Q_HOST_IDX_8814B)
#define BITS_P0HI17Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI17Q_HOST_IDX_8814B << BIT_SHIFT_P0HI17Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI17Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI17Q_HOST_IDX_8814B))
#define BIT_GET_P0HI17Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI17Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI17Q_HOST_IDX_8814B)
#define BIT_SET_P0HI17Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI17Q_HOST_IDX_8814B(x) | BIT_P0HI17Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI18Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI18Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI18Q_HW_IDX_8814B 0xfff
#define BIT_P0HI18Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI18Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI18Q_HW_IDX_8814B)
#define BITS_P0HI18Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI18Q_HW_IDX_8814B << BIT_SHIFT_P0HI18Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI18Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI18Q_HW_IDX_8814B))
#define BIT_GET_P0HI18Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI18Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI18Q_HW_IDX_8814B)
#define BIT_SET_P0HI18Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI18Q_HW_IDX_8814B(x) | BIT_P0HI18Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI18Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI18Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI18Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI18Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI18Q_HOST_IDX_8814B)
#define BITS_P0HI18Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI18Q_HOST_IDX_8814B << BIT_SHIFT_P0HI18Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI18Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI18Q_HOST_IDX_8814B))
#define BIT_GET_P0HI18Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI18Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI18Q_HOST_IDX_8814B)
#define BIT_SET_P0HI18Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI18Q_HOST_IDX_8814B(x) | BIT_P0HI18Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI19Q_TXBD_IDX_8814B */

#define BIT_SHIFT_P0HI19Q_HW_IDX_8814B 16
#define BIT_MASK_P0HI19Q_HW_IDX_8814B 0xfff
#define BIT_P0HI19Q_HW_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_P0HI19Q_HW_IDX_8814B)                                 \
	 << BIT_SHIFT_P0HI19Q_HW_IDX_8814B)
#define BITS_P0HI19Q_HW_IDX_8814B                                              \
	(BIT_MASK_P0HI19Q_HW_IDX_8814B << BIT_SHIFT_P0HI19Q_HW_IDX_8814B)
#define BIT_CLEAR_P0HI19Q_HW_IDX_8814B(x) ((x) & (~BITS_P0HI19Q_HW_IDX_8814B))
#define BIT_GET_P0HI19Q_HW_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_P0HI19Q_HW_IDX_8814B) &                             \
	 BIT_MASK_P0HI19Q_HW_IDX_8814B)
#define BIT_SET_P0HI19Q_HW_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_P0HI19Q_HW_IDX_8814B(x) | BIT_P0HI19Q_HW_IDX_8814B(v))

#define BIT_SHIFT_P0HI19Q_HOST_IDX_8814B 0
#define BIT_MASK_P0HI19Q_HOST_IDX_8814B 0xfff
#define BIT_P0HI19Q_HOST_IDX_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI19Q_HOST_IDX_8814B)                               \
	 << BIT_SHIFT_P0HI19Q_HOST_IDX_8814B)
#define BITS_P0HI19Q_HOST_IDX_8814B                                            \
	(BIT_MASK_P0HI19Q_HOST_IDX_8814B << BIT_SHIFT_P0HI19Q_HOST_IDX_8814B)
#define BIT_CLEAR_P0HI19Q_HOST_IDX_8814B(x)                                    \
	((x) & (~BITS_P0HI19Q_HOST_IDX_8814B))
#define BIT_GET_P0HI19Q_HOST_IDX_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI19Q_HOST_IDX_8814B) &                           \
	 BIT_MASK_P0HI19Q_HOST_IDX_8814B)
#define BIT_SET_P0HI19Q_HOST_IDX_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI19Q_HOST_IDX_8814B(x) | BIT_P0HI19Q_HOST_IDX_8814B(v))

/* 2 REG_P0HI16Q_HI17Q_TXBD_NUM_8814B */
#define BIT_P0HI17Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI17Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI17Q_DESC_MODE_8814B 0x3
#define BIT_P0HI17Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI17Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI17Q_DESC_MODE_8814B)
#define BITS_P0HI17Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI17Q_DESC_MODE_8814B << BIT_SHIFT_P0HI17Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI17Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI17Q_DESC_MODE_8814B))
#define BIT_GET_P0HI17Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI17Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI17Q_DESC_MODE_8814B)
#define BIT_SET_P0HI17Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI17Q_DESC_MODE_8814B(x) | BIT_P0HI17Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI17Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI17Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI17Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI17Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI17Q_DESC_NUM_8814B)
#define BITS_P0HI17Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI17Q_DESC_NUM_8814B << BIT_SHIFT_P0HI17Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI17Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI17Q_DESC_NUM_8814B))
#define BIT_GET_P0HI17Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI17Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI17Q_DESC_NUM_8814B)
#define BIT_SET_P0HI17Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI17Q_DESC_NUM_8814B(x) | BIT_P0HI17Q_DESC_NUM_8814B(v))

#define BIT_P0HI16Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI16Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI16Q_DESC_MODE_8814B 0x3
#define BIT_P0HI16Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI16Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI16Q_DESC_MODE_8814B)
#define BITS_P0HI16Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI16Q_DESC_MODE_8814B << BIT_SHIFT_P0HI16Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI16Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI16Q_DESC_MODE_8814B))
#define BIT_GET_P0HI16Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI16Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI16Q_DESC_MODE_8814B)
#define BIT_SET_P0HI16Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI16Q_DESC_MODE_8814B(x) | BIT_P0HI16Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI16Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI16Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI16Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI16Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI16Q_DESC_NUM_8814B)
#define BITS_P0HI16Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI16Q_DESC_NUM_8814B << BIT_SHIFT_P0HI16Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI16Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI16Q_DESC_NUM_8814B))
#define BIT_GET_P0HI16Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI16Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI16Q_DESC_NUM_8814B)
#define BIT_SET_P0HI16Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI16Q_DESC_NUM_8814B(x) | BIT_P0HI16Q_DESC_NUM_8814B(v))

/* 2 REG_P0HI18Q_HI19Q_TXBD_NUM_8814B */
#define BIT_P0HI19Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI19Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI19Q_DESC_MODE_8814B 0x3
#define BIT_P0HI19Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI19Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI19Q_DESC_MODE_8814B)
#define BITS_P0HI19Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI19Q_DESC_MODE_8814B << BIT_SHIFT_P0HI19Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI19Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI19Q_DESC_MODE_8814B))
#define BIT_GET_P0HI19Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI19Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI19Q_DESC_MODE_8814B)
#define BIT_SET_P0HI19Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI19Q_DESC_MODE_8814B(x) | BIT_P0HI19Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI19Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI19Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI19Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI19Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI19Q_DESC_NUM_8814B)
#define BITS_P0HI19Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI19Q_DESC_NUM_8814B << BIT_SHIFT_P0HI19Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI19Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI19Q_DESC_NUM_8814B))
#define BIT_GET_P0HI19Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI19Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI19Q_DESC_NUM_8814B)
#define BIT_SET_P0HI19Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI19Q_DESC_NUM_8814B(x) | BIT_P0HI19Q_DESC_NUM_8814B(v))

#define BIT_P0HI18Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI18Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI18Q_DESC_MODE_8814B 0x3
#define BIT_P0HI18Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI18Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI18Q_DESC_MODE_8814B)
#define BITS_P0HI18Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI18Q_DESC_MODE_8814B << BIT_SHIFT_P0HI18Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI18Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI18Q_DESC_MODE_8814B))
#define BIT_GET_P0HI18Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI18Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI18Q_DESC_MODE_8814B)
#define BIT_SET_P0HI18Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI18Q_DESC_MODE_8814B(x) | BIT_P0HI18Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI18Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI18Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI18Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI18Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI18Q_DESC_NUM_8814B)
#define BITS_P0HI18Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI18Q_DESC_NUM_8814B << BIT_SHIFT_P0HI18Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI18Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI18Q_DESC_NUM_8814B))
#define BIT_GET_P0HI18Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI18Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI18Q_DESC_NUM_8814B)
#define BIT_SET_P0HI18Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI18Q_DESC_NUM_8814B(x) | BIT_P0HI18Q_DESC_NUM_8814B(v))

/* 2 REG_PCIE_HISR0_8814B */
#define BIT_PSTIMER_2_8814B BIT(31)
#define BIT_PSTIMER_1_8814B BIT(30)
#define BIT_PSTIMER_0_8814B BIT(29)
#define BIT_GTINT4_8814B BIT(28)
#define BIT_GTINT3_8814B BIT(27)
#define BIT_TXBCN0ERR_8814B BIT(26)
#define BIT_TXBCN0OK_8814B BIT(25)
#define BIT_TSF_BIT32_TOGGLE_8814B BIT(24)
#define BIT_TXDMA_START_INT_8814B BIT(23)
#define BIT_TXDMA_STOP_INT_8814B BIT(22)
#define BIT_HISR7_IND_8814B BIT(21)
#define BIT_BCNDMAINT0_8814B BIT(20)
#define BIT_HISR6_IND_8814B BIT(19)
#define BIT_HISR5_IND_8814B BIT(18)
#define BIT_HISR4_IND_8814B BIT(17)
#define BIT_BCNDERR0_8814B BIT(16)
#define BIT_HSISR_IND_ON_INT_8814B BIT(15)
#define BIT_HISR3_IND_8814B BIT(14)
#define BIT_HISR2_IND_8814B BIT(13)
#define BIT_HISR1_IND_8814B BIT(11)
#define BIT_C2HCMD_8814B BIT(10)
#define BIT_CPWM2_8814B BIT(9)
#define BIT_CPWM_8814B BIT(8)
#define BIT_TXDMAOK_CHANNEL15_8814B BIT(7)
#define BIT_TXDMAOK_CHANNEL14_8814B BIT(6)
#define BIT_TXDMAOK_CHANNEL3_8814B BIT(5)
#define BIT_TXDMAOK_CHANNEL2_8814B BIT(4)
#define BIT_TXDMAOK_CHANNEL1_8814B BIT(3)
#define BIT_TXDMAOK_CHANNEL0_8814B BIT(2)
#define BIT_RDU_8814B BIT(1)
#define BIT_RXOK_8814B BIT(0)

/* 2 REG_PCIE_HISR1_8814B */
#define BIT_PRE_TX_ERR_INT_8814B BIT(31)
#define BIT_TXFIFO_TH_INT_8814B BIT(30)
#define BIT_BTON_STS_UPDATE_INT_8814B BIT(29)
#define BIT_BCNDMAINT7_8814B BIT(27)
#define BIT_BCNDMAINT6_8814B BIT(26)
#define BIT_BCNDMAINT5_8814B BIT(25)
#define BIT_BCNDMAINT4_8814B BIT(24)
#define BIT_BCNDMAINT3_8814B BIT(23)
#define BIT_BCNDMAINT2_8814B BIT(22)
#define BIT_BCNDMAINT1_8814B BIT(21)
#define BIT_BCNDERR7_8814B BIT(20)
#define BIT_BCNDERR6_8814B BIT(19)
#define BIT_BCNDERR5_8814B BIT(18)
#define BIT_BCNDERR4_8814B BIT(17)
#define BIT_BCNDERR3_8814B BIT(16)
#define BIT_BCNDERR2_8814B BIT(15)
#define BIT_BCNDERR1_8814B BIT(14)
#define BIT_ATIMEND_8814B BIT(12)
#define BIT_TXERR_INT_8814B BIT(11)
#define BIT_RXERR_INT_8814B BIT(10)
#define BIT_TXFOVW_8814B BIT(9)
#define BIT_FOVW_8814B BIT(8)
#define BIT_CPU_MGQ_EARLY_INT_8814B BIT(6)
#define BIT_CPU_MGQ_TXDONE_8814B BIT(5)
#define BIT_PSTIMER_5_8814B BIT(4)
#define BIT_PSTIMER_4_8814B BIT(3)
#define BIT_PSTIMER_3_8814B BIT(2)
#define BIT_CPUMGQ_TX_TIMER_8814B BIT(1)
#define BIT_BB_STOPRX_INT_8814B BIT(0)

/* 2 REG_P0HI8Q_HI9Q_TXBD_NUM_8814B */
#define BIT_P0HI9Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI9Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI9Q_DESC_MODE_8814B 0x3
#define BIT_P0HI9Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI9Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI9Q_DESC_MODE_8814B)
#define BITS_P0HI9Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI9Q_DESC_MODE_8814B << BIT_SHIFT_P0HI9Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI9Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI9Q_DESC_MODE_8814B))
#define BIT_GET_P0HI9Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI9Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI9Q_DESC_MODE_8814B)
#define BIT_SET_P0HI9Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI9Q_DESC_MODE_8814B(x) | BIT_P0HI9Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI9Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI9Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI9Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI9Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI9Q_DESC_NUM_8814B)
#define BITS_P0HI9Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI9Q_DESC_NUM_8814B << BIT_SHIFT_P0HI9Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI9Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI9Q_DESC_NUM_8814B))
#define BIT_GET_P0HI9Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI9Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI9Q_DESC_NUM_8814B)
#define BIT_SET_P0HI9Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI9Q_DESC_NUM_8814B(x) | BIT_P0HI9Q_DESC_NUM_8814B(v))

#define BIT_P0HI8Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI8Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI8Q_DESC_MODE_8814B 0x3
#define BIT_P0HI8Q_DESC_MODE_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI8Q_DESC_MODE_8814B)                               \
	 << BIT_SHIFT_P0HI8Q_DESC_MODE_8814B)
#define BITS_P0HI8Q_DESC_MODE_8814B                                            \
	(BIT_MASK_P0HI8Q_DESC_MODE_8814B << BIT_SHIFT_P0HI8Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI8Q_DESC_MODE_8814B(x)                                    \
	((x) & (~BITS_P0HI8Q_DESC_MODE_8814B))
#define BIT_GET_P0HI8Q_DESC_MODE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI8Q_DESC_MODE_8814B) &                           \
	 BIT_MASK_P0HI8Q_DESC_MODE_8814B)
#define BIT_SET_P0HI8Q_DESC_MODE_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI8Q_DESC_MODE_8814B(x) | BIT_P0HI8Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI8Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI8Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI8Q_DESC_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_P0HI8Q_DESC_NUM_8814B)                                \
	 << BIT_SHIFT_P0HI8Q_DESC_NUM_8814B)
#define BITS_P0HI8Q_DESC_NUM_8814B                                             \
	(BIT_MASK_P0HI8Q_DESC_NUM_8814B << BIT_SHIFT_P0HI8Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI8Q_DESC_NUM_8814B(x) ((x) & (~BITS_P0HI8Q_DESC_NUM_8814B))
#define BIT_GET_P0HI8Q_DESC_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_P0HI8Q_DESC_NUM_8814B) &                            \
	 BIT_MASK_P0HI8Q_DESC_NUM_8814B)
#define BIT_SET_P0HI8Q_DESC_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_P0HI8Q_DESC_NUM_8814B(x) | BIT_P0HI8Q_DESC_NUM_8814B(v))

/* 2 REG_P0HI10Q_HI11Q_TXBD_NUM_8814B */
#define BIT_P0HI11Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI11Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI11Q_DESC_MODE_8814B 0x3
#define BIT_P0HI11Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI11Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI11Q_DESC_MODE_8814B)
#define BITS_P0HI11Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI11Q_DESC_MODE_8814B << BIT_SHIFT_P0HI11Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI11Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI11Q_DESC_MODE_8814B))
#define BIT_GET_P0HI11Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI11Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI11Q_DESC_MODE_8814B)
#define BIT_SET_P0HI11Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI11Q_DESC_MODE_8814B(x) | BIT_P0HI11Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI11Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI11Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI11Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI11Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI11Q_DESC_NUM_8814B)
#define BITS_P0HI11Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI11Q_DESC_NUM_8814B << BIT_SHIFT_P0HI11Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI11Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI11Q_DESC_NUM_8814B))
#define BIT_GET_P0HI11Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI11Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI11Q_DESC_NUM_8814B)
#define BIT_SET_P0HI11Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI11Q_DESC_NUM_8814B(x) | BIT_P0HI11Q_DESC_NUM_8814B(v))

#define BIT_P0HI10Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI10Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI10Q_DESC_MODE_8814B 0x3
#define BIT_P0HI10Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI10Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI10Q_DESC_MODE_8814B)
#define BITS_P0HI10Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI10Q_DESC_MODE_8814B << BIT_SHIFT_P0HI10Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI10Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI10Q_DESC_MODE_8814B))
#define BIT_GET_P0HI10Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI10Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI10Q_DESC_MODE_8814B)
#define BIT_SET_P0HI10Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI10Q_DESC_MODE_8814B(x) | BIT_P0HI10Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI10Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI10Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI10Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI10Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI10Q_DESC_NUM_8814B)
#define BITS_P0HI10Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI10Q_DESC_NUM_8814B << BIT_SHIFT_P0HI10Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI10Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI10Q_DESC_NUM_8814B))
#define BIT_GET_P0HI10Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI10Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI10Q_DESC_NUM_8814B)
#define BIT_SET_P0HI10Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI10Q_DESC_NUM_8814B(x) | BIT_P0HI10Q_DESC_NUM_8814B(v))

/* 2 REG_P0HI12Q_HI13Q_TXBD_NUM_8814B */
#define BIT_P0HI13Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI13Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI13Q_DESC_MODE_8814B 0x3
#define BIT_P0HI13Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI13Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI13Q_DESC_MODE_8814B)
#define BITS_P0HI13Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI13Q_DESC_MODE_8814B << BIT_SHIFT_P0HI13Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI13Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI13Q_DESC_MODE_8814B))
#define BIT_GET_P0HI13Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI13Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI13Q_DESC_MODE_8814B)
#define BIT_SET_P0HI13Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI13Q_DESC_MODE_8814B(x) | BIT_P0HI13Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI13Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI13Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI13Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI13Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI13Q_DESC_NUM_8814B)
#define BITS_P0HI13Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI13Q_DESC_NUM_8814B << BIT_SHIFT_P0HI13Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI13Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI13Q_DESC_NUM_8814B))
#define BIT_GET_P0HI13Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI13Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI13Q_DESC_NUM_8814B)
#define BIT_SET_P0HI13Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI13Q_DESC_NUM_8814B(x) | BIT_P0HI13Q_DESC_NUM_8814B(v))

#define BIT_P0HI12Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI12Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI12Q_DESC_MODE_8814B 0x3
#define BIT_P0HI12Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI12Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI12Q_DESC_MODE_8814B)
#define BITS_P0HI12Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI12Q_DESC_MODE_8814B << BIT_SHIFT_P0HI12Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI12Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI12Q_DESC_MODE_8814B))
#define BIT_GET_P0HI12Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI12Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI12Q_DESC_MODE_8814B)
#define BIT_SET_P0HI12Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI12Q_DESC_MODE_8814B(x) | BIT_P0HI12Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI12Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI12Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI12Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI12Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI12Q_DESC_NUM_8814B)
#define BITS_P0HI12Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI12Q_DESC_NUM_8814B << BIT_SHIFT_P0HI12Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI12Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI12Q_DESC_NUM_8814B))
#define BIT_GET_P0HI12Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI12Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI12Q_DESC_NUM_8814B)
#define BIT_SET_P0HI12Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI12Q_DESC_NUM_8814B(x) | BIT_P0HI12Q_DESC_NUM_8814B(v))

/* 2 REG_P0HI14Q_HI15Q_TXBD_NUM_8814B */
#define BIT_P0HI15Q_FLAG_8814B BIT(30)

#define BIT_SHIFT_P0HI15Q_DESC_MODE_8814B 28
#define BIT_MASK_P0HI15Q_DESC_MODE_8814B 0x3
#define BIT_P0HI15Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI15Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI15Q_DESC_MODE_8814B)
#define BITS_P0HI15Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI15Q_DESC_MODE_8814B << BIT_SHIFT_P0HI15Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI15Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI15Q_DESC_MODE_8814B))
#define BIT_GET_P0HI15Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI15Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI15Q_DESC_MODE_8814B)
#define BIT_SET_P0HI15Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI15Q_DESC_MODE_8814B(x) | BIT_P0HI15Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI15Q_DESC_NUM_8814B 16
#define BIT_MASK_P0HI15Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI15Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI15Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI15Q_DESC_NUM_8814B)
#define BITS_P0HI15Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI15Q_DESC_NUM_8814B << BIT_SHIFT_P0HI15Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI15Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI15Q_DESC_NUM_8814B))
#define BIT_GET_P0HI15Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI15Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI15Q_DESC_NUM_8814B)
#define BIT_SET_P0HI15Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI15Q_DESC_NUM_8814B(x) | BIT_P0HI15Q_DESC_NUM_8814B(v))

#define BIT_P0HI14Q_FLAG_8814B BIT(14)

#define BIT_SHIFT_P0HI14Q_DESC_MODE_8814B 12
#define BIT_MASK_P0HI14Q_DESC_MODE_8814B 0x3
#define BIT_P0HI14Q_DESC_MODE_8814B(x)                                         \
	(((x) & BIT_MASK_P0HI14Q_DESC_MODE_8814B)                              \
	 << BIT_SHIFT_P0HI14Q_DESC_MODE_8814B)
#define BITS_P0HI14Q_DESC_MODE_8814B                                           \
	(BIT_MASK_P0HI14Q_DESC_MODE_8814B << BIT_SHIFT_P0HI14Q_DESC_MODE_8814B)
#define BIT_CLEAR_P0HI14Q_DESC_MODE_8814B(x)                                   \
	((x) & (~BITS_P0HI14Q_DESC_MODE_8814B))
#define BIT_GET_P0HI14Q_DESC_MODE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P0HI14Q_DESC_MODE_8814B) &                          \
	 BIT_MASK_P0HI14Q_DESC_MODE_8814B)
#define BIT_SET_P0HI14Q_DESC_MODE_8814B(x, v)                                  \
	(BIT_CLEAR_P0HI14Q_DESC_MODE_8814B(x) | BIT_P0HI14Q_DESC_MODE_8814B(v))

#define BIT_SHIFT_P0HI14Q_DESC_NUM_8814B 0
#define BIT_MASK_P0HI14Q_DESC_NUM_8814B 0xfff
#define BIT_P0HI14Q_DESC_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_P0HI14Q_DESC_NUM_8814B)                               \
	 << BIT_SHIFT_P0HI14Q_DESC_NUM_8814B)
#define BITS_P0HI14Q_DESC_NUM_8814B                                            \
	(BIT_MASK_P0HI14Q_DESC_NUM_8814B << BIT_SHIFT_P0HI14Q_DESC_NUM_8814B)
#define BIT_CLEAR_P0HI14Q_DESC_NUM_8814B(x)                                    \
	((x) & (~BITS_P0HI14Q_DESC_NUM_8814B))
#define BIT_GET_P0HI14Q_DESC_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P0HI14Q_DESC_NUM_8814B) &                           \
	 BIT_MASK_P0HI14Q_DESC_NUM_8814B)
#define BIT_SET_P0HI14Q_DESC_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_P0HI14Q_DESC_NUM_8814B(x) | BIT_P0HI14Q_DESC_NUM_8814B(v))

/* 2 REG_ACH6_ACH7_TXBD_NUM_8814B */
#define BIT_PCIE_ACH7_FLAG_8814B BIT(30)

#define BIT_SHIFT_ACH7_DESC_MODE_8814B 28
#define BIT_MASK_ACH7_DESC_MODE_8814B 0x3
#define BIT_ACH7_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH7_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH7_DESC_MODE_8814B)
#define BITS_ACH7_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH7_DESC_MODE_8814B << BIT_SHIFT_ACH7_DESC_MODE_8814B)
#define BIT_CLEAR_ACH7_DESC_MODE_8814B(x) ((x) & (~BITS_ACH7_DESC_MODE_8814B))
#define BIT_GET_ACH7_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH7_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH7_DESC_MODE_8814B)
#define BIT_SET_ACH7_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH7_DESC_MODE_8814B(x) | BIT_ACH7_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH7_DESC_NUM_8814B 16
#define BIT_MASK_ACH7_DESC_NUM_8814B 0xfff
#define BIT_ACH7_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH7_DESC_NUM_8814B) << BIT_SHIFT_ACH7_DESC_NUM_8814B)
#define BITS_ACH7_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH7_DESC_NUM_8814B << BIT_SHIFT_ACH7_DESC_NUM_8814B)
#define BIT_CLEAR_ACH7_DESC_NUM_8814B(x) ((x) & (~BITS_ACH7_DESC_NUM_8814B))
#define BIT_GET_ACH7_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH7_DESC_NUM_8814B) & BIT_MASK_ACH7_DESC_NUM_8814B)
#define BIT_SET_ACH7_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH7_DESC_NUM_8814B(x) | BIT_ACH7_DESC_NUM_8814B(v))

#define BIT_PCIE_ACH6_FLAG_8814B BIT(14)

#define BIT_SHIFT_ACH6_DESC_MODE_8814B 12
#define BIT_MASK_ACH6_DESC_MODE_8814B 0x3
#define BIT_ACH6_DESC_MODE_8814B(x)                                            \
	(((x) & BIT_MASK_ACH6_DESC_MODE_8814B)                                 \
	 << BIT_SHIFT_ACH6_DESC_MODE_8814B)
#define BITS_ACH6_DESC_MODE_8814B                                              \
	(BIT_MASK_ACH6_DESC_MODE_8814B << BIT_SHIFT_ACH6_DESC_MODE_8814B)
#define BIT_CLEAR_ACH6_DESC_MODE_8814B(x) ((x) & (~BITS_ACH6_DESC_MODE_8814B))
#define BIT_GET_ACH6_DESC_MODE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH6_DESC_MODE_8814B) &                             \
	 BIT_MASK_ACH6_DESC_MODE_8814B)
#define BIT_SET_ACH6_DESC_MODE_8814B(x, v)                                     \
	(BIT_CLEAR_ACH6_DESC_MODE_8814B(x) | BIT_ACH6_DESC_MODE_8814B(v))

#define BIT_SHIFT_ACH6_DESC_NUM_8814B 0
#define BIT_MASK_ACH6_DESC_NUM_8814B 0xfff
#define BIT_ACH6_DESC_NUM_8814B(x)                                             \
	(((x) & BIT_MASK_ACH6_DESC_NUM_8814B) << BIT_SHIFT_ACH6_DESC_NUM_8814B)
#define BITS_ACH6_DESC_NUM_8814B                                               \
	(BIT_MASK_ACH6_DESC_NUM_8814B << BIT_SHIFT_ACH6_DESC_NUM_8814B)
#define BIT_CLEAR_ACH6_DESC_NUM_8814B(x) ((x) & (~BITS_ACH6_DESC_NUM_8814B))
#define BIT_GET_ACH6_DESC_NUM_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH6_DESC_NUM_8814B) & BIT_MASK_ACH6_DESC_NUM_8814B)
#define BIT_SET_ACH6_DESC_NUM_8814B(x, v)                                      \
	(BIT_CLEAR_ACH6_DESC_NUM_8814B(x) | BIT_ACH6_DESC_NUM_8814B(v))

/* 2 REG_ACH4_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH4_HW_IDX_8814B 16
#define BIT_MASK_ACH4_HW_IDX_8814B 0xfff
#define BIT_ACH4_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH4_HW_IDX_8814B) << BIT_SHIFT_ACH4_HW_IDX_8814B)
#define BITS_ACH4_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH4_HW_IDX_8814B << BIT_SHIFT_ACH4_HW_IDX_8814B)
#define BIT_CLEAR_ACH4_HW_IDX_8814B(x) ((x) & (~BITS_ACH4_HW_IDX_8814B))
#define BIT_GET_ACH4_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH4_HW_IDX_8814B) & BIT_MASK_ACH4_HW_IDX_8814B)
#define BIT_SET_ACH4_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH4_HW_IDX_8814B(x) | BIT_ACH4_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH4_HOST_IDX_8814B 0
#define BIT_MASK_ACH4_HOST_IDX_8814B 0xfff
#define BIT_ACH4_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH4_HOST_IDX_8814B) << BIT_SHIFT_ACH4_HOST_IDX_8814B)
#define BITS_ACH4_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH4_HOST_IDX_8814B << BIT_SHIFT_ACH4_HOST_IDX_8814B)
#define BIT_CLEAR_ACH4_HOST_IDX_8814B(x) ((x) & (~BITS_ACH4_HOST_IDX_8814B))
#define BIT_GET_ACH4_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH4_HOST_IDX_8814B) & BIT_MASK_ACH4_HOST_IDX_8814B)
#define BIT_SET_ACH4_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH4_HOST_IDX_8814B(x) | BIT_ACH4_HOST_IDX_8814B(v))

/* 2 REG_ACH5_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH5_HW_IDX_8814B 16
#define BIT_MASK_ACH5_HW_IDX_8814B 0xfff
#define BIT_ACH5_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH5_HW_IDX_8814B) << BIT_SHIFT_ACH5_HW_IDX_8814B)
#define BITS_ACH5_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH5_HW_IDX_8814B << BIT_SHIFT_ACH5_HW_IDX_8814B)
#define BIT_CLEAR_ACH5_HW_IDX_8814B(x) ((x) & (~BITS_ACH5_HW_IDX_8814B))
#define BIT_GET_ACH5_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH5_HW_IDX_8814B) & BIT_MASK_ACH5_HW_IDX_8814B)
#define BIT_SET_ACH5_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH5_HW_IDX_8814B(x) | BIT_ACH5_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH5_HOST_IDX_8814B 0
#define BIT_MASK_ACH5_HOST_IDX_8814B 0xfff
#define BIT_ACH5_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH5_HOST_IDX_8814B) << BIT_SHIFT_ACH5_HOST_IDX_8814B)
#define BITS_ACH5_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH5_HOST_IDX_8814B << BIT_SHIFT_ACH5_HOST_IDX_8814B)
#define BIT_CLEAR_ACH5_HOST_IDX_8814B(x) ((x) & (~BITS_ACH5_HOST_IDX_8814B))
#define BIT_GET_ACH5_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH5_HOST_IDX_8814B) & BIT_MASK_ACH5_HOST_IDX_8814B)
#define BIT_SET_ACH5_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH5_HOST_IDX_8814B(x) | BIT_ACH5_HOST_IDX_8814B(v))

/* 2 REG_ACH6_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH6_HW_IDX_8814B 16
#define BIT_MASK_ACH6_HW_IDX_8814B 0xfff
#define BIT_ACH6_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH6_HW_IDX_8814B) << BIT_SHIFT_ACH6_HW_IDX_8814B)
#define BITS_ACH6_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH6_HW_IDX_8814B << BIT_SHIFT_ACH6_HW_IDX_8814B)
#define BIT_CLEAR_ACH6_HW_IDX_8814B(x) ((x) & (~BITS_ACH6_HW_IDX_8814B))
#define BIT_GET_ACH6_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH6_HW_IDX_8814B) & BIT_MASK_ACH6_HW_IDX_8814B)
#define BIT_SET_ACH6_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH6_HW_IDX_8814B(x) | BIT_ACH6_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH6_HOST_IDX_8814B 0
#define BIT_MASK_ACH6_HOST_IDX_8814B 0xfff
#define BIT_ACH6_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH6_HOST_IDX_8814B) << BIT_SHIFT_ACH6_HOST_IDX_8814B)
#define BITS_ACH6_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH6_HOST_IDX_8814B << BIT_SHIFT_ACH6_HOST_IDX_8814B)
#define BIT_CLEAR_ACH6_HOST_IDX_8814B(x) ((x) & (~BITS_ACH6_HOST_IDX_8814B))
#define BIT_GET_ACH6_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH6_HOST_IDX_8814B) & BIT_MASK_ACH6_HOST_IDX_8814B)
#define BIT_SET_ACH6_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH6_HOST_IDX_8814B(x) | BIT_ACH6_HOST_IDX_8814B(v))

/* 2 REG_ACH7_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH7_HW_IDX_8814B 16
#define BIT_MASK_ACH7_HW_IDX_8814B 0xfff
#define BIT_ACH7_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH7_HW_IDX_8814B) << BIT_SHIFT_ACH7_HW_IDX_8814B)
#define BITS_ACH7_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH7_HW_IDX_8814B << BIT_SHIFT_ACH7_HW_IDX_8814B)
#define BIT_CLEAR_ACH7_HW_IDX_8814B(x) ((x) & (~BITS_ACH7_HW_IDX_8814B))
#define BIT_GET_ACH7_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH7_HW_IDX_8814B) & BIT_MASK_ACH7_HW_IDX_8814B)
#define BIT_SET_ACH7_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH7_HW_IDX_8814B(x) | BIT_ACH7_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH7_HOST_IDX_8814B 0
#define BIT_MASK_ACH7_HOST_IDX_8814B 0xfff
#define BIT_ACH7_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH7_HOST_IDX_8814B) << BIT_SHIFT_ACH7_HOST_IDX_8814B)
#define BITS_ACH7_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH7_HOST_IDX_8814B << BIT_SHIFT_ACH7_HOST_IDX_8814B)
#define BIT_CLEAR_ACH7_HOST_IDX_8814B(x) ((x) & (~BITS_ACH7_HOST_IDX_8814B))
#define BIT_GET_ACH7_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH7_HOST_IDX_8814B) & BIT_MASK_ACH7_HOST_IDX_8814B)
#define BIT_SET_ACH7_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH7_HOST_IDX_8814B(x) | BIT_ACH7_HOST_IDX_8814B(v))

/* 2 REG_ACH8_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH8_HW_IDX_8814B 16
#define BIT_MASK_ACH8_HW_IDX_8814B 0xfff
#define BIT_ACH8_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH8_HW_IDX_8814B) << BIT_SHIFT_ACH8_HW_IDX_8814B)
#define BITS_ACH8_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH8_HW_IDX_8814B << BIT_SHIFT_ACH8_HW_IDX_8814B)
#define BIT_CLEAR_ACH8_HW_IDX_8814B(x) ((x) & (~BITS_ACH8_HW_IDX_8814B))
#define BIT_GET_ACH8_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH8_HW_IDX_8814B) & BIT_MASK_ACH8_HW_IDX_8814B)
#define BIT_SET_ACH8_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH8_HW_IDX_8814B(x) | BIT_ACH8_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH8_HOST_IDX_8814B 0
#define BIT_MASK_ACH8_HOST_IDX_8814B 0xfff
#define BIT_ACH8_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH8_HOST_IDX_8814B) << BIT_SHIFT_ACH8_HOST_IDX_8814B)
#define BITS_ACH8_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH8_HOST_IDX_8814B << BIT_SHIFT_ACH8_HOST_IDX_8814B)
#define BIT_CLEAR_ACH8_HOST_IDX_8814B(x) ((x) & (~BITS_ACH8_HOST_IDX_8814B))
#define BIT_GET_ACH8_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH8_HOST_IDX_8814B) & BIT_MASK_ACH8_HOST_IDX_8814B)
#define BIT_SET_ACH8_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH8_HOST_IDX_8814B(x) | BIT_ACH8_HOST_IDX_8814B(v))

/* 2 REG_ACH9_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH9_HW_IDX_8814B 16
#define BIT_MASK_ACH9_HW_IDX_8814B 0xfff
#define BIT_ACH9_HW_IDX_8814B(x)                                               \
	(((x) & BIT_MASK_ACH9_HW_IDX_8814B) << BIT_SHIFT_ACH9_HW_IDX_8814B)
#define BITS_ACH9_HW_IDX_8814B                                                 \
	(BIT_MASK_ACH9_HW_IDX_8814B << BIT_SHIFT_ACH9_HW_IDX_8814B)
#define BIT_CLEAR_ACH9_HW_IDX_8814B(x) ((x) & (~BITS_ACH9_HW_IDX_8814B))
#define BIT_GET_ACH9_HW_IDX_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ACH9_HW_IDX_8814B) & BIT_MASK_ACH9_HW_IDX_8814B)
#define BIT_SET_ACH9_HW_IDX_8814B(x, v)                                        \
	(BIT_CLEAR_ACH9_HW_IDX_8814B(x) | BIT_ACH9_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH9_HOST_IDX_8814B 0
#define BIT_MASK_ACH9_HOST_IDX_8814B 0xfff
#define BIT_ACH9_HOST_IDX_8814B(x)                                             \
	(((x) & BIT_MASK_ACH9_HOST_IDX_8814B) << BIT_SHIFT_ACH9_HOST_IDX_8814B)
#define BITS_ACH9_HOST_IDX_8814B                                               \
	(BIT_MASK_ACH9_HOST_IDX_8814B << BIT_SHIFT_ACH9_HOST_IDX_8814B)
#define BIT_CLEAR_ACH9_HOST_IDX_8814B(x) ((x) & (~BITS_ACH9_HOST_IDX_8814B))
#define BIT_GET_ACH9_HOST_IDX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ACH9_HOST_IDX_8814B) & BIT_MASK_ACH9_HOST_IDX_8814B)
#define BIT_SET_ACH9_HOST_IDX_8814B(x, v)                                      \
	(BIT_CLEAR_ACH9_HOST_IDX_8814B(x) | BIT_ACH9_HOST_IDX_8814B(v))

/* 2 REG_ACH10_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH10_HW_IDX_8814B 16
#define BIT_MASK_ACH10_HW_IDX_8814B 0xfff
#define BIT_ACH10_HW_IDX_8814B(x)                                              \
	(((x) & BIT_MASK_ACH10_HW_IDX_8814B) << BIT_SHIFT_ACH10_HW_IDX_8814B)
#define BITS_ACH10_HW_IDX_8814B                                                \
	(BIT_MASK_ACH10_HW_IDX_8814B << BIT_SHIFT_ACH10_HW_IDX_8814B)
#define BIT_CLEAR_ACH10_HW_IDX_8814B(x) ((x) & (~BITS_ACH10_HW_IDX_8814B))
#define BIT_GET_ACH10_HW_IDX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_ACH10_HW_IDX_8814B) & BIT_MASK_ACH10_HW_IDX_8814B)
#define BIT_SET_ACH10_HW_IDX_8814B(x, v)                                       \
	(BIT_CLEAR_ACH10_HW_IDX_8814B(x) | BIT_ACH10_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH10_HOST_IDX_8814B 0
#define BIT_MASK_ACH10_HOST_IDX_8814B 0xfff
#define BIT_ACH10_HOST_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_ACH10_HOST_IDX_8814B)                                 \
	 << BIT_SHIFT_ACH10_HOST_IDX_8814B)
#define BITS_ACH10_HOST_IDX_8814B                                              \
	(BIT_MASK_ACH10_HOST_IDX_8814B << BIT_SHIFT_ACH10_HOST_IDX_8814B)
#define BIT_CLEAR_ACH10_HOST_IDX_8814B(x) ((x) & (~BITS_ACH10_HOST_IDX_8814B))
#define BIT_GET_ACH10_HOST_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH10_HOST_IDX_8814B) &                             \
	 BIT_MASK_ACH10_HOST_IDX_8814B)
#define BIT_SET_ACH10_HOST_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_ACH10_HOST_IDX_8814B(x) | BIT_ACH10_HOST_IDX_8814B(v))

/* 2 REG_ACH11_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH11_HW_IDX_8814B 16
#define BIT_MASK_ACH11_HW_IDX_8814B 0xfff
#define BIT_ACH11_HW_IDX_8814B(x)                                              \
	(((x) & BIT_MASK_ACH11_HW_IDX_8814B) << BIT_SHIFT_ACH11_HW_IDX_8814B)
#define BITS_ACH11_HW_IDX_8814B                                                \
	(BIT_MASK_ACH11_HW_IDX_8814B << BIT_SHIFT_ACH11_HW_IDX_8814B)
#define BIT_CLEAR_ACH11_HW_IDX_8814B(x) ((x) & (~BITS_ACH11_HW_IDX_8814B))
#define BIT_GET_ACH11_HW_IDX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_ACH11_HW_IDX_8814B) & BIT_MASK_ACH11_HW_IDX_8814B)
#define BIT_SET_ACH11_HW_IDX_8814B(x, v)                                       \
	(BIT_CLEAR_ACH11_HW_IDX_8814B(x) | BIT_ACH11_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH11_HOST_IDX_8814B 0
#define BIT_MASK_ACH11_HOST_IDX_8814B 0xfff
#define BIT_ACH11_HOST_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_ACH11_HOST_IDX_8814B)                                 \
	 << BIT_SHIFT_ACH11_HOST_IDX_8814B)
#define BITS_ACH11_HOST_IDX_8814B                                              \
	(BIT_MASK_ACH11_HOST_IDX_8814B << BIT_SHIFT_ACH11_HOST_IDX_8814B)
#define BIT_CLEAR_ACH11_HOST_IDX_8814B(x) ((x) & (~BITS_ACH11_HOST_IDX_8814B))
#define BIT_GET_ACH11_HOST_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH11_HOST_IDX_8814B) &                             \
	 BIT_MASK_ACH11_HOST_IDX_8814B)
#define BIT_SET_ACH11_HOST_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_ACH11_HOST_IDX_8814B(x) | BIT_ACH11_HOST_IDX_8814B(v))

/* 2 REG_ACH12_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH12_HW_IDX_8814B 16
#define BIT_MASK_ACH12_HW_IDX_8814B 0xfff
#define BIT_ACH12_HW_IDX_8814B(x)                                              \
	(((x) & BIT_MASK_ACH12_HW_IDX_8814B) << BIT_SHIFT_ACH12_HW_IDX_8814B)
#define BITS_ACH12_HW_IDX_8814B                                                \
	(BIT_MASK_ACH12_HW_IDX_8814B << BIT_SHIFT_ACH12_HW_IDX_8814B)
#define BIT_CLEAR_ACH12_HW_IDX_8814B(x) ((x) & (~BITS_ACH12_HW_IDX_8814B))
#define BIT_GET_ACH12_HW_IDX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_ACH12_HW_IDX_8814B) & BIT_MASK_ACH12_HW_IDX_8814B)
#define BIT_SET_ACH12_HW_IDX_8814B(x, v)                                       \
	(BIT_CLEAR_ACH12_HW_IDX_8814B(x) | BIT_ACH12_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH12_HOST_IDX_8814B 0
#define BIT_MASK_ACH12_HOST_IDX_8814B 0xfff
#define BIT_ACH12_HOST_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_ACH12_HOST_IDX_8814B)                                 \
	 << BIT_SHIFT_ACH12_HOST_IDX_8814B)
#define BITS_ACH12_HOST_IDX_8814B                                              \
	(BIT_MASK_ACH12_HOST_IDX_8814B << BIT_SHIFT_ACH12_HOST_IDX_8814B)
#define BIT_CLEAR_ACH12_HOST_IDX_8814B(x) ((x) & (~BITS_ACH12_HOST_IDX_8814B))
#define BIT_GET_ACH12_HOST_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH12_HOST_IDX_8814B) &                             \
	 BIT_MASK_ACH12_HOST_IDX_8814B)
#define BIT_SET_ACH12_HOST_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_ACH12_HOST_IDX_8814B(x) | BIT_ACH12_HOST_IDX_8814B(v))

/* 2 REG_ACH13_TXBD_IDX_8814B */

#define BIT_SHIFT_ACH13_HW_IDX_8814B 16
#define BIT_MASK_ACH13_HW_IDX_8814B 0xfff
#define BIT_ACH13_HW_IDX_8814B(x)                                              \
	(((x) & BIT_MASK_ACH13_HW_IDX_8814B) << BIT_SHIFT_ACH13_HW_IDX_8814B)
#define BITS_ACH13_HW_IDX_8814B                                                \
	(BIT_MASK_ACH13_HW_IDX_8814B << BIT_SHIFT_ACH13_HW_IDX_8814B)
#define BIT_CLEAR_ACH13_HW_IDX_8814B(x) ((x) & (~BITS_ACH13_HW_IDX_8814B))
#define BIT_GET_ACH13_HW_IDX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_ACH13_HW_IDX_8814B) & BIT_MASK_ACH13_HW_IDX_8814B)
#define BIT_SET_ACH13_HW_IDX_8814B(x, v)                                       \
	(BIT_CLEAR_ACH13_HW_IDX_8814B(x) | BIT_ACH13_HW_IDX_8814B(v))

#define BIT_SHIFT_ACH13_HOST_IDX_8814B 0
#define BIT_MASK_ACH13_HOST_IDX_8814B 0xfff
#define BIT_ACH13_HOST_IDX_8814B(x)                                            \
	(((x) & BIT_MASK_ACH13_HOST_IDX_8814B)                                 \
	 << BIT_SHIFT_ACH13_HOST_IDX_8814B)
#define BITS_ACH13_HOST_IDX_8814B                                              \
	(BIT_MASK_ACH13_HOST_IDX_8814B << BIT_SHIFT_ACH13_HOST_IDX_8814B)
#define BIT_CLEAR_ACH13_HOST_IDX_8814B(x) ((x) & (~BITS_ACH13_HOST_IDX_8814B))
#define BIT_GET_ACH13_HOST_IDX_8814B(x)                                        \
	(((x) >> BIT_SHIFT_ACH13_HOST_IDX_8814B) &                             \
	 BIT_MASK_ACH13_HOST_IDX_8814B)
#define BIT_SET_ACH13_HOST_IDX_8814B(x, v)                                     \
	(BIT_CLEAR_ACH13_HOST_IDX_8814B(x) | BIT_ACH13_HOST_IDX_8814B(v))

/* 2 REG_AC_CHANNEL0_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL0_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL0_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL0_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL0_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL0_WEIGHT_8814B)
#define BITS_AC_CHANNEL0_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL0_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL0_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL0_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL0_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL0_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL0_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL0_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL0_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL0_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL0_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL1_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL1_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL1_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL1_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL1_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL1_WEIGHT_8814B)
#define BITS_AC_CHANNEL1_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL1_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL1_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL1_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL1_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL1_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL1_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL1_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL1_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL1_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL1_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL2_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL2_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL2_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL2_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL2_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL2_WEIGHT_8814B)
#define BITS_AC_CHANNEL2_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL2_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL2_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL2_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL2_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL2_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL2_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL2_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL2_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL2_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL2_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL3_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL3_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL3_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL3_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL3_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL3_WEIGHT_8814B)
#define BITS_AC_CHANNEL3_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL3_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL3_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL3_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL3_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL3_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL3_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL3_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL3_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL3_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL3_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL4_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL4_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL4_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL4_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL4_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL4_WEIGHT_8814B)
#define BITS_AC_CHANNEL4_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL4_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL4_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL4_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL4_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL4_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL4_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL4_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL4_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL4_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL4_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL5_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL5_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL5_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL5_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL5_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL5_WEIGHT_8814B)
#define BITS_AC_CHANNEL5_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL5_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL5_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL5_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL5_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL5_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL5_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL5_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL5_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL5_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL5_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL6_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL6_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL6_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL6_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL6_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL6_WEIGHT_8814B)
#define BITS_AC_CHANNEL6_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL6_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL6_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL6_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL6_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL6_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL6_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL6_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL6_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL6_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL6_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL7_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL7_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL7_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL7_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL7_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL7_WEIGHT_8814B)
#define BITS_AC_CHANNEL7_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL7_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL7_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL7_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL7_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL7_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL7_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL7_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL7_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL7_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL7_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL8_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL8_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL8_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL8_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL8_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL8_WEIGHT_8814B)
#define BITS_AC_CHANNEL8_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL8_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL8_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL8_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL8_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL8_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL8_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL8_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL8_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL8_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL8_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL9_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL9_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL9_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL9_WEIGHT_8814B(x)                                        \
	(((x) & BIT_MASK_AC_CHANNEL9_WEIGHT_8814B)                             \
	 << BIT_SHIFT_AC_CHANNEL9_WEIGHT_8814B)
#define BITS_AC_CHANNEL9_WEIGHT_8814B                                          \
	(BIT_MASK_AC_CHANNEL9_WEIGHT_8814B                                     \
	 << BIT_SHIFT_AC_CHANNEL9_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL9_WEIGHT_8814B(x)                                  \
	((x) & (~BITS_AC_CHANNEL9_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL9_WEIGHT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_AC_CHANNEL9_WEIGHT_8814B) &                         \
	 BIT_MASK_AC_CHANNEL9_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL9_WEIGHT_8814B(x, v)                                 \
	(BIT_CLEAR_AC_CHANNEL9_WEIGHT_8814B(x) |                               \
	 BIT_AC_CHANNEL9_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL10_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL10_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL10_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL10_WEIGHT_8814B(x)                                       \
	(((x) & BIT_MASK_AC_CHANNEL10_WEIGHT_8814B)                            \
	 << BIT_SHIFT_AC_CHANNEL10_WEIGHT_8814B)
#define BITS_AC_CHANNEL10_WEIGHT_8814B                                         \
	(BIT_MASK_AC_CHANNEL10_WEIGHT_8814B                                    \
	 << BIT_SHIFT_AC_CHANNEL10_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL10_WEIGHT_8814B(x)                                 \
	((x) & (~BITS_AC_CHANNEL10_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL10_WEIGHT_8814B(x)                                   \
	(((x) >> BIT_SHIFT_AC_CHANNEL10_WEIGHT_8814B) &                        \
	 BIT_MASK_AC_CHANNEL10_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL10_WEIGHT_8814B(x, v)                                \
	(BIT_CLEAR_AC_CHANNEL10_WEIGHT_8814B(x) |                              \
	 BIT_AC_CHANNEL10_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL11_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL11_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL11_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL11_WEIGHT_8814B(x)                                       \
	(((x) & BIT_MASK_AC_CHANNEL11_WEIGHT_8814B)                            \
	 << BIT_SHIFT_AC_CHANNEL11_WEIGHT_8814B)
#define BITS_AC_CHANNEL11_WEIGHT_8814B                                         \
	(BIT_MASK_AC_CHANNEL11_WEIGHT_8814B                                    \
	 << BIT_SHIFT_AC_CHANNEL11_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL11_WEIGHT_8814B(x)                                 \
	((x) & (~BITS_AC_CHANNEL11_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL11_WEIGHT_8814B(x)                                   \
	(((x) >> BIT_SHIFT_AC_CHANNEL11_WEIGHT_8814B) &                        \
	 BIT_MASK_AC_CHANNEL11_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL11_WEIGHT_8814B(x, v)                                \
	(BIT_CLEAR_AC_CHANNEL11_WEIGHT_8814B(x) |                              \
	 BIT_AC_CHANNEL11_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL12_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL12_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL12_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL12_WEIGHT_8814B(x)                                       \
	(((x) & BIT_MASK_AC_CHANNEL12_WEIGHT_8814B)                            \
	 << BIT_SHIFT_AC_CHANNEL12_WEIGHT_8814B)
#define BITS_AC_CHANNEL12_WEIGHT_8814B                                         \
	(BIT_MASK_AC_CHANNEL12_WEIGHT_8814B                                    \
	 << BIT_SHIFT_AC_CHANNEL12_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL12_WEIGHT_8814B(x)                                 \
	((x) & (~BITS_AC_CHANNEL12_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL12_WEIGHT_8814B(x)                                   \
	(((x) >> BIT_SHIFT_AC_CHANNEL12_WEIGHT_8814B) &                        \
	 BIT_MASK_AC_CHANNEL12_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL12_WEIGHT_8814B(x, v)                                \
	(BIT_CLEAR_AC_CHANNEL12_WEIGHT_8814B(x) |                              \
	 BIT_AC_CHANNEL12_WEIGHT_8814B(v))

/* 2 REG_AC_CHANNEL13_WEIGHT_8814B */

#define BIT_SHIFT_AC_CHANNEL13_WEIGHT_8814B 0
#define BIT_MASK_AC_CHANNEL13_WEIGHT_8814B 0xff
#define BIT_AC_CHANNEL13_WEIGHT_8814B(x)                                       \
	(((x) & BIT_MASK_AC_CHANNEL13_WEIGHT_8814B)                            \
	 << BIT_SHIFT_AC_CHANNEL13_WEIGHT_8814B)
#define BITS_AC_CHANNEL13_WEIGHT_8814B                                         \
	(BIT_MASK_AC_CHANNEL13_WEIGHT_8814B                                    \
	 << BIT_SHIFT_AC_CHANNEL13_WEIGHT_8814B)
#define BIT_CLEAR_AC_CHANNEL13_WEIGHT_8814B(x)                                 \
	((x) & (~BITS_AC_CHANNEL13_WEIGHT_8814B))
#define BIT_GET_AC_CHANNEL13_WEIGHT_8814B(x)                                   \
	(((x) >> BIT_SHIFT_AC_CHANNEL13_WEIGHT_8814B) &                        \
	 BIT_MASK_AC_CHANNEL13_WEIGHT_8814B)
#define BIT_SET_AC_CHANNEL13_WEIGHT_8814B(x, v)                                \
	(BIT_CLEAR_AC_CHANNEL13_WEIGHT_8814B(x) |                              \
	 BIT_AC_CHANNEL13_WEIGHT_8814B(v))

/* 2 REG_PCIE_HISR2_8814B */
#define BIT_BCNDMAINT_P4_8814B BIT(31)
#define BIT_BCNDMAINT_P3_8814B BIT(30)
#define BIT_BCNDMAINT_P2_8814B BIT(29)
#define BIT_BCNDMAINT_P1_8814B BIT(28)
#define BIT_SCH_PHY_TXOP_SIFS_INT_8814B BIT(23)
#define BIT_ATIMEND7_8814B BIT(22)
#define BIT_ATIMEND6_8814B BIT(21)
#define BIT_ATIMEND5_8814B BIT(20)
#define BIT_ATIMEND4_8814B BIT(19)
#define BIT_ATIMEND3_8814B BIT(18)
#define BIT_ATIMEND2_8814B BIT(17)
#define BIT_ATIMEND1_8814B BIT(16)
#define BIT_TXBCN7OK_8814B BIT(14)
#define BIT_TXBCN6OK_8814B BIT(13)
#define BIT_TXBCN5OK_8814B BIT(12)
#define BIT_TXBCN4OK_8814B BIT(11)
#define BIT_TXBCN3OK_8814B BIT(10)
#define BIT_TXBCN2OK_8814B BIT(9)
#define BIT_TXBCN1OK_8814B BIT(8)
#define BIT_TXBCN7ERR_8814B BIT(6)
#define BIT_TXBCN6ERR_8814B BIT(5)
#define BIT_TXBCN5ERR_8814B BIT(4)
#define BIT_TXBCN4ERR_8814B BIT(3)
#define BIT_TXBCN3ERR_8814B BIT(2)
#define BIT_TXBCN2ERR_8814B BIT(1)
#define BIT_TXBCN1ERR_8814B BIT(0)

/* 2 REG_PCIE_HISR3_8814B */
#define BIT_GTINT12_8814B BIT(24)
#define BIT_GTINT11_8814B BIT(23)
#define BIT_GTINT10_8814B BIT(22)
#define BIT_GTINT9_8814B BIT(21)
#define BIT_RX_DESC_BUF_FULL_8814B BIT(20)
#define BIT_CPHY_LDO_OCP_DET_INT_8814B BIT(19)
#define BIT_WDT_PLATFORM_INT_8814B BIT(18)
#define BIT_WDT_CPU_INT_8814B BIT(17)
#define BIT_SETH2CDOK_8814B BIT(16)
#define BIT_H2C_CMD_FULL_8814B BIT(15)
#define BIT_PKT_TRANS_ERR_8814B BIT(14)
#define BIT_TXSHORTCUT_TXDESUPDATEOK_8814B BIT(13)
#define BIT_TXSHORTCUT_BKUPDATEOK_8814B BIT(12)
#define BIT_TXSHORTCUT_BEUPDATEOK_8814B BIT(11)
#define BIT_TXSHORTCUT_VIUPDATEOK_8814B BIT(10)
#define BIT_TXSHORTCUT_VOUPDATEOK_8814B BIT(9)
#define BIT_SEARCH_FAIL_8814B BIT(8)
#define BIT_PWR_INT_127TO96_8814B BIT(7)
#define BIT_PWR_INT_95TO64_8814B BIT(6)
#define BIT_PWR_INT_63TO32_8814B BIT(5)
#define BIT_PWR_INT_31TO0_8814B BIT(4)
#define BIT_RX_DMA_STUCK_8814B BIT(3)
#define BIT_TX_DMA_STUCK_8814B BIT(2)
#define BIT_DDMA0_LP_INT_8814B BIT(1)
#define BIT_DDMA0_HP_INT_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_QUEUELIST_INFO0_8814B */

#define BIT_SHIFT_QINFO0_8814B 0
#define BIT_MASK_QINFO0_8814B 0xffffffffL
#define BIT_QINFO0_8814B(x)                                                    \
	(((x) & BIT_MASK_QINFO0_8814B) << BIT_SHIFT_QINFO0_8814B)
#define BITS_QINFO0_8814B (BIT_MASK_QINFO0_8814B << BIT_SHIFT_QINFO0_8814B)
#define BIT_CLEAR_QINFO0_8814B(x) ((x) & (~BITS_QINFO0_8814B))
#define BIT_GET_QINFO0_8814B(x)                                                \
	(((x) >> BIT_SHIFT_QINFO0_8814B) & BIT_MASK_QINFO0_8814B)
#define BIT_SET_QINFO0_8814B(x, v)                                             \
	(BIT_CLEAR_QINFO0_8814B(x) | BIT_QINFO0_8814B(v))

/* 2 REG_QUEUELIST_INFO1_8814B */

#define BIT_SHIFT_QINFO1_8814B 0
#define BIT_MASK_QINFO1_8814B 0xffffffffL
#define BIT_QINFO1_8814B(x)                                                    \
	(((x) & BIT_MASK_QINFO1_8814B) << BIT_SHIFT_QINFO1_8814B)
#define BITS_QINFO1_8814B (BIT_MASK_QINFO1_8814B << BIT_SHIFT_QINFO1_8814B)
#define BIT_CLEAR_QINFO1_8814B(x) ((x) & (~BITS_QINFO1_8814B))
#define BIT_GET_QINFO1_8814B(x)                                                \
	(((x) >> BIT_SHIFT_QINFO1_8814B) & BIT_MASK_QINFO1_8814B)
#define BIT_SET_QINFO1_8814B(x, v)                                             \
	(BIT_CLEAR_QINFO1_8814B(x) | BIT_QINFO1_8814B(v))

/* 2 REG_QUEUELIST_INFO2_8814B */

#define BIT_SHIFT_QINFO2_8814B 0
#define BIT_MASK_QINFO2_8814B 0xffffffffL
#define BIT_QINFO2_8814B(x)                                                    \
	(((x) & BIT_MASK_QINFO2_8814B) << BIT_SHIFT_QINFO2_8814B)
#define BITS_QINFO2_8814B (BIT_MASK_QINFO2_8814B << BIT_SHIFT_QINFO2_8814B)
#define BIT_CLEAR_QINFO2_8814B(x) ((x) & (~BITS_QINFO2_8814B))
#define BIT_GET_QINFO2_8814B(x)                                                \
	(((x) >> BIT_SHIFT_QINFO2_8814B) & BIT_MASK_QINFO2_8814B)
#define BIT_SET_QINFO2_8814B(x, v)                                             \
	(BIT_CLEAR_QINFO2_8814B(x) | BIT_QINFO2_8814B(v))

/* 2 REG_QUEUELIST_INFO3_8814B */

#define BIT_SHIFT_QINFO3_8814B 0
#define BIT_MASK_QINFO3_8814B 0xffffffffL
#define BIT_QINFO3_8814B(x)                                                    \
	(((x) & BIT_MASK_QINFO3_8814B) << BIT_SHIFT_QINFO3_8814B)
#define BITS_QINFO3_8814B (BIT_MASK_QINFO3_8814B << BIT_SHIFT_QINFO3_8814B)
#define BIT_CLEAR_QINFO3_8814B(x) ((x) & (~BITS_QINFO3_8814B))
#define BIT_GET_QINFO3_8814B(x)                                                \
	(((x) >> BIT_SHIFT_QINFO3_8814B) & BIT_MASK_QINFO3_8814B)
#define BIT_SET_QINFO3_8814B(x, v)                                             \
	(BIT_CLEAR_QINFO3_8814B(x) | BIT_QINFO3_8814B(v))

/* 2 REG_QUEUELIST_INFO_EMPTY_8814B */
#define BIT_FWCMDQ_EMPTY_8814B BIT(31)
#define BIT_MGQ_CPU_EMPTY_V1_8814B BIT(30)
#define BIT_BCNQ_EMPTY_EXTP0_8814B BIT(29)
#define BIT_BCNQ_EMPTY_PORT4_8814B BIT(28)
#define BIT_BCNQ_EMPTY_PORT3_8814B BIT(27)
#define BIT_BCNQ_EMPTY_PORT2_8814B BIT(26)
#define BIT_BCNQ_EMPTY_PORT1_8814B BIT(25)
#define BIT_BCNQ_EMPTY_PORT0_8814B BIT(24)
#define BIT_HQQ_EMPTY_V1_8814B BIT(23)
#define BIT_MQQ_EMPTY_V2_8814B BIT(22)
#define BIT_S1_EMPTY_8814B BIT(21)
#define BIT_S0_EMPTY_8814B BIT(20)
#define BIT_AC19Q_EMPTY_8814B BIT(19)
#define BIT_AC18Q_EMPTY_8814B BIT(18)
#define BIT_AC17Q_EMPTY_8814B BIT(17)
#define BIT_AC16Q_EMPTY_8814B BIT(16)
#define BIT_AC15Q_EMPTY_8814B BIT(15)
#define BIT_AC14Q_EMPTY_8814B BIT(14)
#define BIT_AC13Q_EMPTY_8814B BIT(13)
#define BIT_AC12Q_EMPTY_8814B BIT(12)
#define BIT_AC11Q_EMPTY_8814B BIT(11)
#define BIT_AC10Q_EMPTY_8814B BIT(10)
#define BIT_AC9Q_EMPTY_8814B BIT(9)
#define BIT_AC8Q_EMPTY_8814B BIT(8)
#define BIT_AC7Q_EMPTY_8814B BIT(7)
#define BIT_AC6Q_EMPTY_8814B BIT(6)
#define BIT_AC5Q_EMPTY_8814B BIT(5)
#define BIT_AC4Q_EMPTY_8814B BIT(4)
#define BIT_AC3Q_EMPTY_8814B BIT(3)
#define BIT_AC2Q_EMPTY_8814B BIT(2)
#define BIT_AC1Q_EMPTY_8814B BIT(1)
#define BIT_AC0Q_EMPTY_8814B BIT(0)

/* 2 REG_QUEUELIST_ACQ_EN_8814B */

#define BIT_SHIFT_QINFO_CTRL_8814B 24
#define BIT_MASK_QINFO_CTRL_8814B 0x3f
#define BIT_QINFO_CTRL_8814B(x)                                                \
	(((x) & BIT_MASK_QINFO_CTRL_8814B) << BIT_SHIFT_QINFO_CTRL_8814B)
#define BITS_QINFO_CTRL_8814B                                                  \
	(BIT_MASK_QINFO_CTRL_8814B << BIT_SHIFT_QINFO_CTRL_8814B)
#define BIT_CLEAR_QINFO_CTRL_8814B(x) ((x) & (~BITS_QINFO_CTRL_8814B))
#define BIT_GET_QINFO_CTRL_8814B(x)                                            \
	(((x) >> BIT_SHIFT_QINFO_CTRL_8814B) & BIT_MASK_QINFO_CTRL_8814B)
#define BIT_SET_QINFO_CTRL_8814B(x, v)                                         \
	(BIT_CLEAR_QINFO_CTRL_8814B(x) | BIT_QINFO_CTRL_8814B(v))

#define BIT_SHIFT_QINFO_MODE_BAND_8814B 20
#define BIT_MASK_QINFO_MODE_BAND_8814B 0x7
#define BIT_QINFO_MODE_BAND_8814B(x)                                           \
	(((x) & BIT_MASK_QINFO_MODE_BAND_8814B)                                \
	 << BIT_SHIFT_QINFO_MODE_BAND_8814B)
#define BITS_QINFO_MODE_BAND_8814B                                             \
	(BIT_MASK_QINFO_MODE_BAND_8814B << BIT_SHIFT_QINFO_MODE_BAND_8814B)
#define BIT_CLEAR_QINFO_MODE_BAND_8814B(x) ((x) & (~BITS_QINFO_MODE_BAND_8814B))
#define BIT_GET_QINFO_MODE_BAND_8814B(x)                                       \
	(((x) >> BIT_SHIFT_QINFO_MODE_BAND_8814B) &                            \
	 BIT_MASK_QINFO_MODE_BAND_8814B)
#define BIT_SET_QINFO_MODE_BAND_8814B(x, v)                                    \
	(BIT_CLEAR_QINFO_MODE_BAND_8814B(x) | BIT_QINFO_MODE_BAND_8814B(v))

#define BIT_ACQ19_ENABLE_8814B BIT(19)
#define BIT_ACQ18_ENABLE_8814B BIT(18)
#define BIT_ACQ17_ENABLE_8814B BIT(17)
#define BIT_ACQ16_ENABLE_8814B BIT(16)
#define BIT_ACQ15_ENABLE_8814B BIT(15)
#define BIT_ACQ14_ENABLE_8814B BIT(14)
#define BIT_ACQ13_ENABLE_8814B BIT(13)
#define BIT_ACQ12_ENABLE_8814B BIT(12)
#define BIT_ACQ11_ENABLE_8814B BIT(11)
#define BIT_ACQ10_ENABLE_8814B BIT(10)
#define BIT_ACQ9_ENABLE_8814B BIT(9)
#define BIT_ACQ8_ENABLE_8814B BIT(8)
#define BIT_ACQ7_ENABLE_8814B BIT(7)
#define BIT_ACQ6_ENABLE_8814B BIT(6)
#define BIT_ACQ5_ENABLE_8814B BIT(5)
#define BIT_ACQ4_ENABLE_8814B BIT(4)
#define BIT_ACQ3_ENABLE_8814B BIT(3)
#define BIT_ACQ2_ENABLE_8814B BIT(2)
#define BIT_ACQ1_ENABLE_8814B BIT(1)
#define BIT_ACQ0_ENABLE_8814B BIT(0)

/* 2 REG_BCNQ_BDNY_V2_8814B */

#define BIT_SHIFT_BCNQ_PGBNDY_WSEL_8814B 28
#define BIT_MASK_BCNQ_PGBNDY_WSEL_8814B 0x7
#define BIT_BCNQ_PGBNDY_WSEL_8814B(x)                                          \
	(((x) & BIT_MASK_BCNQ_PGBNDY_WSEL_8814B)                               \
	 << BIT_SHIFT_BCNQ_PGBNDY_WSEL_8814B)
#define BITS_BCNQ_PGBNDY_WSEL_8814B                                            \
	(BIT_MASK_BCNQ_PGBNDY_WSEL_8814B << BIT_SHIFT_BCNQ_PGBNDY_WSEL_8814B)
#define BIT_CLEAR_BCNQ_PGBNDY_WSEL_8814B(x)                                    \
	((x) & (~BITS_BCNQ_PGBNDY_WSEL_8814B))
#define BIT_GET_BCNQ_PGBNDY_WSEL_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BCNQ_PGBNDY_WSEL_8814B) &                           \
	 BIT_MASK_BCNQ_PGBNDY_WSEL_8814B)
#define BIT_SET_BCNQ_PGBNDY_WSEL_8814B(x, v)                                   \
	(BIT_CLEAR_BCNQ_PGBNDY_WSEL_8814B(x) | BIT_BCNQ_PGBNDY_WSEL_8814B(v))

#define BIT_SHIFT_BCNQ_PGBNDY_RCONTENT_8814B 12
#define BIT_MASK_BCNQ_PGBNDY_RCONTENT_8814B 0xfff
#define BIT_BCNQ_PGBNDY_RCONTENT_8814B(x)                                      \
	(((x) & BIT_MASK_BCNQ_PGBNDY_RCONTENT_8814B)                           \
	 << BIT_SHIFT_BCNQ_PGBNDY_RCONTENT_8814B)
#define BITS_BCNQ_PGBNDY_RCONTENT_8814B                                        \
	(BIT_MASK_BCNQ_PGBNDY_RCONTENT_8814B                                   \
	 << BIT_SHIFT_BCNQ_PGBNDY_RCONTENT_8814B)
#define BIT_CLEAR_BCNQ_PGBNDY_RCONTENT_8814B(x)                                \
	((x) & (~BITS_BCNQ_PGBNDY_RCONTENT_8814B))
#define BIT_GET_BCNQ_PGBNDY_RCONTENT_8814B(x)                                  \
	(((x) >> BIT_SHIFT_BCNQ_PGBNDY_RCONTENT_8814B) &                       \
	 BIT_MASK_BCNQ_PGBNDY_RCONTENT_8814B)
#define BIT_SET_BCNQ_PGBNDY_RCONTENT_8814B(x, v)                               \
	(BIT_CLEAR_BCNQ_PGBNDY_RCONTENT_8814B(x) |                             \
	 BIT_BCNQ_PGBNDY_RCONTENT_8814B(v))

#define BIT_SHIFT_BCNQ_PGBNDY_WCONTENT_8814B 0
#define BIT_MASK_BCNQ_PGBNDY_WCONTENT_8814B 0xfff
#define BIT_BCNQ_PGBNDY_WCONTENT_8814B(x)                                      \
	(((x) & BIT_MASK_BCNQ_PGBNDY_WCONTENT_8814B)                           \
	 << BIT_SHIFT_BCNQ_PGBNDY_WCONTENT_8814B)
#define BITS_BCNQ_PGBNDY_WCONTENT_8814B                                        \
	(BIT_MASK_BCNQ_PGBNDY_WCONTENT_8814B                                   \
	 << BIT_SHIFT_BCNQ_PGBNDY_WCONTENT_8814B)
#define BIT_CLEAR_BCNQ_PGBNDY_WCONTENT_8814B(x)                                \
	((x) & (~BITS_BCNQ_PGBNDY_WCONTENT_8814B))
#define BIT_GET_BCNQ_PGBNDY_WCONTENT_8814B(x)                                  \
	(((x) >> BIT_SHIFT_BCNQ_PGBNDY_WCONTENT_8814B) &                       \
	 BIT_MASK_BCNQ_PGBNDY_WCONTENT_8814B)
#define BIT_SET_BCNQ_PGBNDY_WCONTENT_8814B(x, v)                               \
	(BIT_CLEAR_BCNQ_PGBNDY_WCONTENT_8814B(x) |                             \
	 BIT_BCNQ_PGBNDY_WCONTENT_8814B(v))

/* 2 REG_CPU_MGQ_INFO_8814B */
#define BIT_CPUMGT_CLR_V1_8814B BIT(30)
#define BIT_CPUMGT_POLL_8814B BIT(29)
#define BIT_BCN_EXT_POLL_8814B BIT(21)
#define BIT_BCN4_POLL_8814B BIT(20)
#define BIT_BCN3_POLL_8814B BIT(19)
#define BIT_BCN2_POLL_8814B BIT(18)
#define BIT_BCN1_POLL_V1_8814B BIT(17)
#define BIT_BCN_POLL_V1_8814B BIT(16)

#define BIT_SHIFT_FREE_TAIL_PAGE_8814B 0
#define BIT_MASK_FREE_TAIL_PAGE_8814B 0xfff
#define BIT_FREE_TAIL_PAGE_8814B(x)                                            \
	(((x) & BIT_MASK_FREE_TAIL_PAGE_8814B)                                 \
	 << BIT_SHIFT_FREE_TAIL_PAGE_8814B)
#define BITS_FREE_TAIL_PAGE_8814B                                              \
	(BIT_MASK_FREE_TAIL_PAGE_8814B << BIT_SHIFT_FREE_TAIL_PAGE_8814B)
#define BIT_CLEAR_FREE_TAIL_PAGE_8814B(x) ((x) & (~BITS_FREE_TAIL_PAGE_8814B))
#define BIT_GET_FREE_TAIL_PAGE_8814B(x)                                        \
	(((x) >> BIT_SHIFT_FREE_TAIL_PAGE_8814B) &                             \
	 BIT_MASK_FREE_TAIL_PAGE_8814B)
#define BIT_SET_FREE_TAIL_PAGE_8814B(x, v)                                     \
	(BIT_CLEAR_FREE_TAIL_PAGE_8814B(x) | BIT_FREE_TAIL_PAGE_8814B(v))

/* 2 REG_FWHW_TXQ_CTRL_8814B */
#define BIT_RTS_LIMIT_IN_OFDM_8814B BIT(23)
#define BIT_EN_RD_RESP_NAV_BK_8814B BIT(21)
#define BIT_EN_WR_FREE_TAIL_8814B BIT(20)
#define BIT_NOTXRPT_USERATE_EN_8814B BIT(19)
#define BIT_DIS_TXFAIL_RPT_8814B BIT(18)
#define BIT_FTM_TIMEOUT_BYPASS_8814B BIT(16)
#define BIT_EN_BCNQ_DL5_8814B BIT(13)
#define BIT_EN_BCNQ_DL4_8814B BIT(12)
#define BIT_EN_BCNQ_DL3_8814B BIT(11)
#define BIT_EN_BCNQ_DL2_8814B BIT(10)
#define BIT_EN_BCNQ_DL1_8814B BIT(9)
#define BIT_EN_BCNQ_DL0_8814B BIT(8)
#define BIT_EN_RTY_BK_8814B BIT(7)
#define BIT_EN_USE_INI_RAT_8814B BIT(6)
#define BIT_EN_RTS_NAV_BK_8814B BIT(5)
#define BIT_DIS_SSN_CHECK_8814B BIT(4)
#define BIT_MACID_MATCH_RTS_8814B BIT(3)
#define BIT_EN_BCN_TRXRPT_V1_8814B BIT(2)
#define BIT_EN_FTMRPT_V1_8814B BIT(1)
#define BIT_BMC_NAV_PROTECT_8814B BIT(0)

/* 2 REG_DATAFB_SEL_8814B */
#define BIT_BROADCAST_RTY_EN_8814B BIT(3)
#define BIT_EN_RTY_BK_COD_8814B BIT(2)

#define BIT_SHIFT__DATA_FALLBACK_SEL_8814B 0
#define BIT_MASK__DATA_FALLBACK_SEL_8814B 0x3
#define BIT__DATA_FALLBACK_SEL_8814B(x)                                        \
	(((x) & BIT_MASK__DATA_FALLBACK_SEL_8814B)                             \
	 << BIT_SHIFT__DATA_FALLBACK_SEL_8814B)
#define BITS__DATA_FALLBACK_SEL_8814B                                          \
	(BIT_MASK__DATA_FALLBACK_SEL_8814B                                     \
	 << BIT_SHIFT__DATA_FALLBACK_SEL_8814B)
#define BIT_CLEAR__DATA_FALLBACK_SEL_8814B(x)                                  \
	((x) & (~BITS__DATA_FALLBACK_SEL_8814B))
#define BIT_GET__DATA_FALLBACK_SEL_8814B(x)                                    \
	(((x) >> BIT_SHIFT__DATA_FALLBACK_SEL_8814B) &                         \
	 BIT_MASK__DATA_FALLBACK_SEL_8814B)
#define BIT_SET__DATA_FALLBACK_SEL_8814B(x, v)                                 \
	(BIT_CLEAR__DATA_FALLBACK_SEL_8814B(x) |                               \
	 BIT__DATA_FALLBACK_SEL_8814B(v))

/* 2 REG_TXBDNY_8814B */

#define BIT_SHIFT_TXBNDY_8814B 0
#define BIT_MASK_TXBNDY_8814B 0xfff
#define BIT_TXBNDY_8814B(x)                                                    \
	(((x) & BIT_MASK_TXBNDY_8814B) << BIT_SHIFT_TXBNDY_8814B)
#define BITS_TXBNDY_8814B (BIT_MASK_TXBNDY_8814B << BIT_SHIFT_TXBNDY_8814B)
#define BIT_CLEAR_TXBNDY_8814B(x) ((x) & (~BITS_TXBNDY_8814B))
#define BIT_GET_TXBNDY_8814B(x)                                                \
	(((x) >> BIT_SHIFT_TXBNDY_8814B) & BIT_MASK_TXBNDY_8814B)
#define BIT_SET_TXBNDY_8814B(x, v)                                             \
	(BIT_CLEAR_TXBNDY_8814B(x) | BIT_TXBNDY_8814B(v))

/* 2 REG_LIFETIME_EN_8814B */
#define BIT_BT_INT_CPU_8814B BIT(7)
#define BIT_BT_INT_PTA_8814B BIT(6)
#define BIT_EN_CTRL_RTYBIT_8814B BIT(4)
#define BIT_LIFETIME_BK_EN_8814B BIT(3)
#define BIT_LIFETIME_BE_EN_8814B BIT(2)
#define BIT_LIFETIME_VI_EN_8814B BIT(1)
#define BIT_LIFETIME_VO_EN_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_SPEC_SIFS_8814B */

#define BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8814B 8
#define BIT_MASK_SPEC_SIFS_OFDM_PTCL_8814B 0xff
#define BIT_SPEC_SIFS_OFDM_PTCL_8814B(x)                                       \
	(((x) & BIT_MASK_SPEC_SIFS_OFDM_PTCL_8814B)                            \
	 << BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8814B)
#define BITS_SPEC_SIFS_OFDM_PTCL_8814B                                         \
	(BIT_MASK_SPEC_SIFS_OFDM_PTCL_8814B                                    \
	 << BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8814B)
#define BIT_CLEAR_SPEC_SIFS_OFDM_PTCL_8814B(x)                                 \
	((x) & (~BITS_SPEC_SIFS_OFDM_PTCL_8814B))
#define BIT_GET_SPEC_SIFS_OFDM_PTCL_8814B(x)                                   \
	(((x) >> BIT_SHIFT_SPEC_SIFS_OFDM_PTCL_8814B) &                        \
	 BIT_MASK_SPEC_SIFS_OFDM_PTCL_8814B)
#define BIT_SET_SPEC_SIFS_OFDM_PTCL_8814B(x, v)                                \
	(BIT_CLEAR_SPEC_SIFS_OFDM_PTCL_8814B(x) |                              \
	 BIT_SPEC_SIFS_OFDM_PTCL_8814B(v))

#define BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8814B 0
#define BIT_MASK_SPEC_SIFS_CCK_PTCL_8814B 0xff
#define BIT_SPEC_SIFS_CCK_PTCL_8814B(x)                                        \
	(((x) & BIT_MASK_SPEC_SIFS_CCK_PTCL_8814B)                             \
	 << BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8814B)
#define BITS_SPEC_SIFS_CCK_PTCL_8814B                                          \
	(BIT_MASK_SPEC_SIFS_CCK_PTCL_8814B                                     \
	 << BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8814B)
#define BIT_CLEAR_SPEC_SIFS_CCK_PTCL_8814B(x)                                  \
	((x) & (~BITS_SPEC_SIFS_CCK_PTCL_8814B))
#define BIT_GET_SPEC_SIFS_CCK_PTCL_8814B(x)                                    \
	(((x) >> BIT_SHIFT_SPEC_SIFS_CCK_PTCL_8814B) &                         \
	 BIT_MASK_SPEC_SIFS_CCK_PTCL_8814B)
#define BIT_SET_SPEC_SIFS_CCK_PTCL_8814B(x, v)                                 \
	(BIT_CLEAR_SPEC_SIFS_CCK_PTCL_8814B(x) |                               \
	 BIT_SPEC_SIFS_CCK_PTCL_8814B(v))

/* 2 REG_RETRY_LIMIT_8814B */

#define BIT_SHIFT_SRL_8814B 8
#define BIT_MASK_SRL_8814B 0x3f
#define BIT_SRL_8814B(x) (((x) & BIT_MASK_SRL_8814B) << BIT_SHIFT_SRL_8814B)
#define BITS_SRL_8814B (BIT_MASK_SRL_8814B << BIT_SHIFT_SRL_8814B)
#define BIT_CLEAR_SRL_8814B(x) ((x) & (~BITS_SRL_8814B))
#define BIT_GET_SRL_8814B(x) (((x) >> BIT_SHIFT_SRL_8814B) & BIT_MASK_SRL_8814B)
#define BIT_SET_SRL_8814B(x, v) (BIT_CLEAR_SRL_8814B(x) | BIT_SRL_8814B(v))

#define BIT_SHIFT_LRL_8814B 0
#define BIT_MASK_LRL_8814B 0x3f
#define BIT_LRL_8814B(x) (((x) & BIT_MASK_LRL_8814B) << BIT_SHIFT_LRL_8814B)
#define BITS_LRL_8814B (BIT_MASK_LRL_8814B << BIT_SHIFT_LRL_8814B)
#define BIT_CLEAR_LRL_8814B(x) ((x) & (~BITS_LRL_8814B))
#define BIT_GET_LRL_8814B(x) (((x) >> BIT_SHIFT_LRL_8814B) & BIT_MASK_LRL_8814B)
#define BIT_SET_LRL_8814B(x, v) (BIT_CLEAR_LRL_8814B(x) | BIT_LRL_8814B(v))

/* 2 REG_TXBF_CTRL_8814B */
#define BIT_ENABLE_NDPA_8814B BIT(31)
#define BIT_NDPA_PARA_8814B BIT(30)
#define BIT_PROP_TXBF_8814B BIT(29)
#define BIT_EN_NDPA_INT_8814B BIT(28)
#define BIT_TXBF1_80M_160M_8814B BIT(27)
#define BIT_TXBF1_40M_8814B BIT(26)
#define BIT_TXBF1_20M_8814B BIT(25)

#define BIT_SHIFT_TXBF1_AID_8814B 16
#define BIT_MASK_TXBF1_AID_8814B 0x1ff
#define BIT_TXBF1_AID_8814B(x)                                                 \
	(((x) & BIT_MASK_TXBF1_AID_8814B) << BIT_SHIFT_TXBF1_AID_8814B)
#define BITS_TXBF1_AID_8814B                                                   \
	(BIT_MASK_TXBF1_AID_8814B << BIT_SHIFT_TXBF1_AID_8814B)
#define BIT_CLEAR_TXBF1_AID_8814B(x) ((x) & (~BITS_TXBF1_AID_8814B))
#define BIT_GET_TXBF1_AID_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TXBF1_AID_8814B) & BIT_MASK_TXBF1_AID_8814B)
#define BIT_SET_TXBF1_AID_8814B(x, v)                                          \
	(BIT_CLEAR_TXBF1_AID_8814B(x) | BIT_TXBF1_AID_8814B(v))

#define BIT_DIS_NDP_BFEN_8814B BIT(15)
#define BIT_TXBCN_NOBLOCK_NDP_8814B BIT(14)
#define BIT_TXBF0_80M_160M_8814B BIT(11)
#define BIT_TXBF0_40M_8814B BIT(10)
#define BIT_TXBF0_20M_8814B BIT(9)

#define BIT_SHIFT_TXBF0_AID_8814B 0
#define BIT_MASK_TXBF0_AID_8814B 0x1ff
#define BIT_TXBF0_AID_8814B(x)                                                 \
	(((x) & BIT_MASK_TXBF0_AID_8814B) << BIT_SHIFT_TXBF0_AID_8814B)
#define BITS_TXBF0_AID_8814B                                                   \
	(BIT_MASK_TXBF0_AID_8814B << BIT_SHIFT_TXBF0_AID_8814B)
#define BIT_CLEAR_TXBF0_AID_8814B(x) ((x) & (~BITS_TXBF0_AID_8814B))
#define BIT_GET_TXBF0_AID_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TXBF0_AID_8814B) & BIT_MASK_TXBF0_AID_8814B)
#define BIT_SET_TXBF0_AID_8814B(x, v)                                          \
	(BIT_CLEAR_TXBF0_AID_8814B(x) | BIT_TXBF0_AID_8814B(v))

/* 2 REG_DARFRC_8814B */

#define BIT_SHIFT_DARF_RC4_V1_8814B 24
#define BIT_MASK_DARF_RC4_V1_8814B 0x3f
#define BIT_DARF_RC4_V1_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC4_V1_8814B) << BIT_SHIFT_DARF_RC4_V1_8814B)
#define BITS_DARF_RC4_V1_8814B                                                 \
	(BIT_MASK_DARF_RC4_V1_8814B << BIT_SHIFT_DARF_RC4_V1_8814B)
#define BIT_CLEAR_DARF_RC4_V1_8814B(x) ((x) & (~BITS_DARF_RC4_V1_8814B))
#define BIT_GET_DARF_RC4_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC4_V1_8814B) & BIT_MASK_DARF_RC4_V1_8814B)
#define BIT_SET_DARF_RC4_V1_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC4_V1_8814B(x) | BIT_DARF_RC4_V1_8814B(v))

#define BIT_SHIFT_DARF_RC3_V1_8814B 16
#define BIT_MASK_DARF_RC3_V1_8814B 0x3f
#define BIT_DARF_RC3_V1_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC3_V1_8814B) << BIT_SHIFT_DARF_RC3_V1_8814B)
#define BITS_DARF_RC3_V1_8814B                                                 \
	(BIT_MASK_DARF_RC3_V1_8814B << BIT_SHIFT_DARF_RC3_V1_8814B)
#define BIT_CLEAR_DARF_RC3_V1_8814B(x) ((x) & (~BITS_DARF_RC3_V1_8814B))
#define BIT_GET_DARF_RC3_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC3_V1_8814B) & BIT_MASK_DARF_RC3_V1_8814B)
#define BIT_SET_DARF_RC3_V1_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC3_V1_8814B(x) | BIT_DARF_RC3_V1_8814B(v))

#define BIT_SHIFT_DARF_RC2_V1_8814B 8
#define BIT_MASK_DARF_RC2_V1_8814B 0x3f
#define BIT_DARF_RC2_V1_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC2_V1_8814B) << BIT_SHIFT_DARF_RC2_V1_8814B)
#define BITS_DARF_RC2_V1_8814B                                                 \
	(BIT_MASK_DARF_RC2_V1_8814B << BIT_SHIFT_DARF_RC2_V1_8814B)
#define BIT_CLEAR_DARF_RC2_V1_8814B(x) ((x) & (~BITS_DARF_RC2_V1_8814B))
#define BIT_GET_DARF_RC2_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC2_V1_8814B) & BIT_MASK_DARF_RC2_V1_8814B)
#define BIT_SET_DARF_RC2_V1_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC2_V1_8814B(x) | BIT_DARF_RC2_V1_8814B(v))

#define BIT_SHIFT_DARF_RC1_V1_8814B 0
#define BIT_MASK_DARF_RC1_V1_8814B 0x3f
#define BIT_DARF_RC1_V1_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC1_V1_8814B) << BIT_SHIFT_DARF_RC1_V1_8814B)
#define BITS_DARF_RC1_V1_8814B                                                 \
	(BIT_MASK_DARF_RC1_V1_8814B << BIT_SHIFT_DARF_RC1_V1_8814B)
#define BIT_CLEAR_DARF_RC1_V1_8814B(x) ((x) & (~BITS_DARF_RC1_V1_8814B))
#define BIT_GET_DARF_RC1_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC1_V1_8814B) & BIT_MASK_DARF_RC1_V1_8814B)
#define BIT_SET_DARF_RC1_V1_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC1_V1_8814B(x) | BIT_DARF_RC1_V1_8814B(v))

/* 2 REG_DARFRCH_8814B */

#define BIT_SHIFT_DARF_RC8_V2_8814B 24
#define BIT_MASK_DARF_RC8_V2_8814B 0x3f
#define BIT_DARF_RC8_V2_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC8_V2_8814B) << BIT_SHIFT_DARF_RC8_V2_8814B)
#define BITS_DARF_RC8_V2_8814B                                                 \
	(BIT_MASK_DARF_RC8_V2_8814B << BIT_SHIFT_DARF_RC8_V2_8814B)
#define BIT_CLEAR_DARF_RC8_V2_8814B(x) ((x) & (~BITS_DARF_RC8_V2_8814B))
#define BIT_GET_DARF_RC8_V2_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC8_V2_8814B) & BIT_MASK_DARF_RC8_V2_8814B)
#define BIT_SET_DARF_RC8_V2_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC8_V2_8814B(x) | BIT_DARF_RC8_V2_8814B(v))

#define BIT_SHIFT_DARF_RC7_V2_8814B 16
#define BIT_MASK_DARF_RC7_V2_8814B 0x3f
#define BIT_DARF_RC7_V2_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC7_V2_8814B) << BIT_SHIFT_DARF_RC7_V2_8814B)
#define BITS_DARF_RC7_V2_8814B                                                 \
	(BIT_MASK_DARF_RC7_V2_8814B << BIT_SHIFT_DARF_RC7_V2_8814B)
#define BIT_CLEAR_DARF_RC7_V2_8814B(x) ((x) & (~BITS_DARF_RC7_V2_8814B))
#define BIT_GET_DARF_RC7_V2_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC7_V2_8814B) & BIT_MASK_DARF_RC7_V2_8814B)
#define BIT_SET_DARF_RC7_V2_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC7_V2_8814B(x) | BIT_DARF_RC7_V2_8814B(v))

#define BIT_SHIFT_DARF_RC6_V2_8814B 8
#define BIT_MASK_DARF_RC6_V2_8814B 0x3f
#define BIT_DARF_RC6_V2_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC6_V2_8814B) << BIT_SHIFT_DARF_RC6_V2_8814B)
#define BITS_DARF_RC6_V2_8814B                                                 \
	(BIT_MASK_DARF_RC6_V2_8814B << BIT_SHIFT_DARF_RC6_V2_8814B)
#define BIT_CLEAR_DARF_RC6_V2_8814B(x) ((x) & (~BITS_DARF_RC6_V2_8814B))
#define BIT_GET_DARF_RC6_V2_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC6_V2_8814B) & BIT_MASK_DARF_RC6_V2_8814B)
#define BIT_SET_DARF_RC6_V2_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC6_V2_8814B(x) | BIT_DARF_RC6_V2_8814B(v))

#define BIT_SHIFT_DARF_RC5_V2_8814B 0
#define BIT_MASK_DARF_RC5_V2_8814B 0x3f
#define BIT_DARF_RC5_V2_8814B(x)                                               \
	(((x) & BIT_MASK_DARF_RC5_V2_8814B) << BIT_SHIFT_DARF_RC5_V2_8814B)
#define BITS_DARF_RC5_V2_8814B                                                 \
	(BIT_MASK_DARF_RC5_V2_8814B << BIT_SHIFT_DARF_RC5_V2_8814B)
#define BIT_CLEAR_DARF_RC5_V2_8814B(x) ((x) & (~BITS_DARF_RC5_V2_8814B))
#define BIT_GET_DARF_RC5_V2_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DARF_RC5_V2_8814B) & BIT_MASK_DARF_RC5_V2_8814B)
#define BIT_SET_DARF_RC5_V2_8814B(x, v)                                        \
	(BIT_CLEAR_DARF_RC5_V2_8814B(x) | BIT_DARF_RC5_V2_8814B(v))

/* 2 REG_RARFRC_8814B */

#define BIT_SHIFT_RARF_RC4_8814B 24
#define BIT_MASK_RARF_RC4_8814B 0x1f
#define BIT_RARF_RC4_8814B(x)                                                  \
	(((x) & BIT_MASK_RARF_RC4_8814B) << BIT_SHIFT_RARF_RC4_8814B)
#define BITS_RARF_RC4_8814B                                                    \
	(BIT_MASK_RARF_RC4_8814B << BIT_SHIFT_RARF_RC4_8814B)
#define BIT_CLEAR_RARF_RC4_8814B(x) ((x) & (~BITS_RARF_RC4_8814B))
#define BIT_GET_RARF_RC4_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC4_8814B) & BIT_MASK_RARF_RC4_8814B)
#define BIT_SET_RARF_RC4_8814B(x, v)                                           \
	(BIT_CLEAR_RARF_RC4_8814B(x) | BIT_RARF_RC4_8814B(v))

#define BIT_SHIFT_RARF_RC3_8814B 16
#define BIT_MASK_RARF_RC3_8814B 0x1f
#define BIT_RARF_RC3_8814B(x)                                                  \
	(((x) & BIT_MASK_RARF_RC3_8814B) << BIT_SHIFT_RARF_RC3_8814B)
#define BITS_RARF_RC3_8814B                                                    \
	(BIT_MASK_RARF_RC3_8814B << BIT_SHIFT_RARF_RC3_8814B)
#define BIT_CLEAR_RARF_RC3_8814B(x) ((x) & (~BITS_RARF_RC3_8814B))
#define BIT_GET_RARF_RC3_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC3_8814B) & BIT_MASK_RARF_RC3_8814B)
#define BIT_SET_RARF_RC3_8814B(x, v)                                           \
	(BIT_CLEAR_RARF_RC3_8814B(x) | BIT_RARF_RC3_8814B(v))

#define BIT_SHIFT_RARF_RC2_8814B 8
#define BIT_MASK_RARF_RC2_8814B 0x1f
#define BIT_RARF_RC2_8814B(x)                                                  \
	(((x) & BIT_MASK_RARF_RC2_8814B) << BIT_SHIFT_RARF_RC2_8814B)
#define BITS_RARF_RC2_8814B                                                    \
	(BIT_MASK_RARF_RC2_8814B << BIT_SHIFT_RARF_RC2_8814B)
#define BIT_CLEAR_RARF_RC2_8814B(x) ((x) & (~BITS_RARF_RC2_8814B))
#define BIT_GET_RARF_RC2_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC2_8814B) & BIT_MASK_RARF_RC2_8814B)
#define BIT_SET_RARF_RC2_8814B(x, v)                                           \
	(BIT_CLEAR_RARF_RC2_8814B(x) | BIT_RARF_RC2_8814B(v))

#define BIT_SHIFT_RARF_RC1_8814B 0
#define BIT_MASK_RARF_RC1_8814B 0x1f
#define BIT_RARF_RC1_8814B(x)                                                  \
	(((x) & BIT_MASK_RARF_RC1_8814B) << BIT_SHIFT_RARF_RC1_8814B)
#define BITS_RARF_RC1_8814B                                                    \
	(BIT_MASK_RARF_RC1_8814B << BIT_SHIFT_RARF_RC1_8814B)
#define BIT_CLEAR_RARF_RC1_8814B(x) ((x) & (~BITS_RARF_RC1_8814B))
#define BIT_GET_RARF_RC1_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RARF_RC1_8814B) & BIT_MASK_RARF_RC1_8814B)
#define BIT_SET_RARF_RC1_8814B(x, v)                                           \
	(BIT_CLEAR_RARF_RC1_8814B(x) | BIT_RARF_RC1_8814B(v))

/* 2 REG_RARFRCH_8814B */

#define BIT_SHIFT_RARF_RC8_V1_8814B 24
#define BIT_MASK_RARF_RC8_V1_8814B 0x1f
#define BIT_RARF_RC8_V1_8814B(x)                                               \
	(((x) & BIT_MASK_RARF_RC8_V1_8814B) << BIT_SHIFT_RARF_RC8_V1_8814B)
#define BITS_RARF_RC8_V1_8814B                                                 \
	(BIT_MASK_RARF_RC8_V1_8814B << BIT_SHIFT_RARF_RC8_V1_8814B)
#define BIT_CLEAR_RARF_RC8_V1_8814B(x) ((x) & (~BITS_RARF_RC8_V1_8814B))
#define BIT_GET_RARF_RC8_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC8_V1_8814B) & BIT_MASK_RARF_RC8_V1_8814B)
#define BIT_SET_RARF_RC8_V1_8814B(x, v)                                        \
	(BIT_CLEAR_RARF_RC8_V1_8814B(x) | BIT_RARF_RC8_V1_8814B(v))

#define BIT_SHIFT_RARF_RC7_V1_8814B 16
#define BIT_MASK_RARF_RC7_V1_8814B 0x1f
#define BIT_RARF_RC7_V1_8814B(x)                                               \
	(((x) & BIT_MASK_RARF_RC7_V1_8814B) << BIT_SHIFT_RARF_RC7_V1_8814B)
#define BITS_RARF_RC7_V1_8814B                                                 \
	(BIT_MASK_RARF_RC7_V1_8814B << BIT_SHIFT_RARF_RC7_V1_8814B)
#define BIT_CLEAR_RARF_RC7_V1_8814B(x) ((x) & (~BITS_RARF_RC7_V1_8814B))
#define BIT_GET_RARF_RC7_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC7_V1_8814B) & BIT_MASK_RARF_RC7_V1_8814B)
#define BIT_SET_RARF_RC7_V1_8814B(x, v)                                        \
	(BIT_CLEAR_RARF_RC7_V1_8814B(x) | BIT_RARF_RC7_V1_8814B(v))

#define BIT_SHIFT_RARF_RC6_V1_8814B 8
#define BIT_MASK_RARF_RC6_V1_8814B 0x1f
#define BIT_RARF_RC6_V1_8814B(x)                                               \
	(((x) & BIT_MASK_RARF_RC6_V1_8814B) << BIT_SHIFT_RARF_RC6_V1_8814B)
#define BITS_RARF_RC6_V1_8814B                                                 \
	(BIT_MASK_RARF_RC6_V1_8814B << BIT_SHIFT_RARF_RC6_V1_8814B)
#define BIT_CLEAR_RARF_RC6_V1_8814B(x) ((x) & (~BITS_RARF_RC6_V1_8814B))
#define BIT_GET_RARF_RC6_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC6_V1_8814B) & BIT_MASK_RARF_RC6_V1_8814B)
#define BIT_SET_RARF_RC6_V1_8814B(x, v)                                        \
	(BIT_CLEAR_RARF_RC6_V1_8814B(x) | BIT_RARF_RC6_V1_8814B(v))

#define BIT_SHIFT_RARF_RC5_V1_8814B 0
#define BIT_MASK_RARF_RC5_V1_8814B 0x1f
#define BIT_RARF_RC5_V1_8814B(x)                                               \
	(((x) & BIT_MASK_RARF_RC5_V1_8814B) << BIT_SHIFT_RARF_RC5_V1_8814B)
#define BITS_RARF_RC5_V1_8814B                                                 \
	(BIT_MASK_RARF_RC5_V1_8814B << BIT_SHIFT_RARF_RC5_V1_8814B)
#define BIT_CLEAR_RARF_RC5_V1_8814B(x) ((x) & (~BITS_RARF_RC5_V1_8814B))
#define BIT_GET_RARF_RC5_V1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_RARF_RC5_V1_8814B) & BIT_MASK_RARF_RC5_V1_8814B)
#define BIT_SET_RARF_RC5_V1_8814B(x, v)                                        \
	(BIT_CLEAR_RARF_RC5_V1_8814B(x) | BIT_RARF_RC5_V1_8814B(v))

/* 2 REG_RRSR_8814B */

#define BIT_SHIFT_RRSR_RSC_8814B 21
#define BIT_MASK_RRSR_RSC_8814B 0x3
#define BIT_RRSR_RSC_8814B(x)                                                  \
	(((x) & BIT_MASK_RRSR_RSC_8814B) << BIT_SHIFT_RRSR_RSC_8814B)
#define BITS_RRSR_RSC_8814B                                                    \
	(BIT_MASK_RRSR_RSC_8814B << BIT_SHIFT_RRSR_RSC_8814B)
#define BIT_CLEAR_RRSR_RSC_8814B(x) ((x) & (~BITS_RRSR_RSC_8814B))
#define BIT_GET_RRSR_RSC_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RRSR_RSC_8814B) & BIT_MASK_RRSR_RSC_8814B)
#define BIT_SET_RRSR_RSC_8814B(x, v)                                           \
	(BIT_CLEAR_RRSR_RSC_8814B(x) | BIT_RRSR_RSC_8814B(v))

#define BIT_SHIFT_RRSC_BITMAP_8814B 0
#define BIT_MASK_RRSC_BITMAP_8814B 0xfffff
#define BIT_RRSC_BITMAP_8814B(x)                                               \
	(((x) & BIT_MASK_RRSC_BITMAP_8814B) << BIT_SHIFT_RRSC_BITMAP_8814B)
#define BITS_RRSC_BITMAP_8814B                                                 \
	(BIT_MASK_RRSC_BITMAP_8814B << BIT_SHIFT_RRSC_BITMAP_8814B)
#define BIT_CLEAR_RRSC_BITMAP_8814B(x) ((x) & (~BITS_RRSC_BITMAP_8814B))
#define BIT_GET_RRSC_BITMAP_8814B(x)                                           \
	(((x) >> BIT_SHIFT_RRSC_BITMAP_8814B) & BIT_MASK_RRSC_BITMAP_8814B)
#define BIT_SET_RRSC_BITMAP_8814B(x, v)                                        \
	(BIT_CLEAR_RRSC_BITMAP_8814B(x) | BIT_RRSC_BITMAP_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ARFR0_8814B */

#define BIT_SHIFT_ARFRL0_8814B 0
#define BIT_MASK_ARFRL0_8814B 0xffffffffL
#define BIT_ARFRL0_8814B(x)                                                    \
	(((x) & BIT_MASK_ARFRL0_8814B) << BIT_SHIFT_ARFRL0_8814B)
#define BITS_ARFRL0_8814B (BIT_MASK_ARFRL0_8814B << BIT_SHIFT_ARFRL0_8814B)
#define BIT_CLEAR_ARFRL0_8814B(x) ((x) & (~BITS_ARFRL0_8814B))
#define BIT_GET_ARFRL0_8814B(x)                                                \
	(((x) >> BIT_SHIFT_ARFRL0_8814B) & BIT_MASK_ARFRL0_8814B)
#define BIT_SET_ARFRL0_8814B(x, v)                                             \
	(BIT_CLEAR_ARFRL0_8814B(x) | BIT_ARFRL0_8814B(v))

/* 2 REG_ARFRH0_8814B */

#define BIT_SHIFT_ARFRH0_8814B 0
#define BIT_MASK_ARFRH0_8814B 0xffffffffL
#define BIT_ARFRH0_8814B(x)                                                    \
	(((x) & BIT_MASK_ARFRH0_8814B) << BIT_SHIFT_ARFRH0_8814B)
#define BITS_ARFRH0_8814B (BIT_MASK_ARFRH0_8814B << BIT_SHIFT_ARFRH0_8814B)
#define BIT_CLEAR_ARFRH0_8814B(x) ((x) & (~BITS_ARFRH0_8814B))
#define BIT_GET_ARFRH0_8814B(x)                                                \
	(((x) >> BIT_SHIFT_ARFRH0_8814B) & BIT_MASK_ARFRH0_8814B)
#define BIT_SET_ARFRH0_8814B(x, v)                                             \
	(BIT_CLEAR_ARFRH0_8814B(x) | BIT_ARFRH0_8814B(v))

/* 2 REG_REG_ARFR_WT0_8814B */

#define BIT_SHIFT_RATE7_WEIGHTING_8814B 28
#define BIT_MASK_RATE7_WEIGHTING_8814B 0xf
#define BIT_RATE7_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE7_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE7_WEIGHTING_8814B)
#define BITS_RATE7_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE7_WEIGHTING_8814B << BIT_SHIFT_RATE7_WEIGHTING_8814B)
#define BIT_CLEAR_RATE7_WEIGHTING_8814B(x) ((x) & (~BITS_RATE7_WEIGHTING_8814B))
#define BIT_GET_RATE7_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE7_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE7_WEIGHTING_8814B)
#define BIT_SET_RATE7_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE7_WEIGHTING_8814B(x) | BIT_RATE7_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE6_WEIGHTING_8814B 24
#define BIT_MASK_RATE6_WEIGHTING_8814B 0xf
#define BIT_RATE6_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE6_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE6_WEIGHTING_8814B)
#define BITS_RATE6_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE6_WEIGHTING_8814B << BIT_SHIFT_RATE6_WEIGHTING_8814B)
#define BIT_CLEAR_RATE6_WEIGHTING_8814B(x) ((x) & (~BITS_RATE6_WEIGHTING_8814B))
#define BIT_GET_RATE6_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE6_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE6_WEIGHTING_8814B)
#define BIT_SET_RATE6_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE6_WEIGHTING_8814B(x) | BIT_RATE6_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE5_WEIGHTING_8814B 20
#define BIT_MASK_RATE5_WEIGHTING_8814B 0xf
#define BIT_RATE5_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE5_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE5_WEIGHTING_8814B)
#define BITS_RATE5_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE5_WEIGHTING_8814B << BIT_SHIFT_RATE5_WEIGHTING_8814B)
#define BIT_CLEAR_RATE5_WEIGHTING_8814B(x) ((x) & (~BITS_RATE5_WEIGHTING_8814B))
#define BIT_GET_RATE5_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE5_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE5_WEIGHTING_8814B)
#define BIT_SET_RATE5_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE5_WEIGHTING_8814B(x) | BIT_RATE5_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE4_WEIGHTING_8814B 16
#define BIT_MASK_RATE4_WEIGHTING_8814B 0xf
#define BIT_RATE4_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE4_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE4_WEIGHTING_8814B)
#define BITS_RATE4_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE4_WEIGHTING_8814B << BIT_SHIFT_RATE4_WEIGHTING_8814B)
#define BIT_CLEAR_RATE4_WEIGHTING_8814B(x) ((x) & (~BITS_RATE4_WEIGHTING_8814B))
#define BIT_GET_RATE4_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE4_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE4_WEIGHTING_8814B)
#define BIT_SET_RATE4_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE4_WEIGHTING_8814B(x) | BIT_RATE4_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE3_WEIGHTING_8814B 12
#define BIT_MASK_RATE3_WEIGHTING_8814B 0xf
#define BIT_RATE3_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE3_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE3_WEIGHTING_8814B)
#define BITS_RATE3_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE3_WEIGHTING_8814B << BIT_SHIFT_RATE3_WEIGHTING_8814B)
#define BIT_CLEAR_RATE3_WEIGHTING_8814B(x) ((x) & (~BITS_RATE3_WEIGHTING_8814B))
#define BIT_GET_RATE3_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE3_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE3_WEIGHTING_8814B)
#define BIT_SET_RATE3_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE3_WEIGHTING_8814B(x) | BIT_RATE3_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE2_WEIGHTING_8814B 8
#define BIT_MASK_RATE2_WEIGHTING_8814B 0xf
#define BIT_RATE2_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE2_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE2_WEIGHTING_8814B)
#define BITS_RATE2_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE2_WEIGHTING_8814B << BIT_SHIFT_RATE2_WEIGHTING_8814B)
#define BIT_CLEAR_RATE2_WEIGHTING_8814B(x) ((x) & (~BITS_RATE2_WEIGHTING_8814B))
#define BIT_GET_RATE2_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE2_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE2_WEIGHTING_8814B)
#define BIT_SET_RATE2_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE2_WEIGHTING_8814B(x) | BIT_RATE2_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE1_WEIGHTING_8814B 4
#define BIT_MASK_RATE1_WEIGHTING_8814B 0xf
#define BIT_RATE1_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE1_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE1_WEIGHTING_8814B)
#define BITS_RATE1_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE1_WEIGHTING_8814B << BIT_SHIFT_RATE1_WEIGHTING_8814B)
#define BIT_CLEAR_RATE1_WEIGHTING_8814B(x) ((x) & (~BITS_RATE1_WEIGHTING_8814B))
#define BIT_GET_RATE1_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE1_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE1_WEIGHTING_8814B)
#define BIT_SET_RATE1_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE1_WEIGHTING_8814B(x) | BIT_RATE1_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE0_WEIGHTING_8814B 0
#define BIT_MASK_RATE0_WEIGHTING_8814B 0xf
#define BIT_RATE0_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE0_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE0_WEIGHTING_8814B)
#define BITS_RATE0_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE0_WEIGHTING_8814B << BIT_SHIFT_RATE0_WEIGHTING_8814B)
#define BIT_CLEAR_RATE0_WEIGHTING_8814B(x) ((x) & (~BITS_RATE0_WEIGHTING_8814B))
#define BIT_GET_RATE0_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE0_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE0_WEIGHTING_8814B)
#define BIT_SET_RATE0_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE0_WEIGHTING_8814B(x) | BIT_RATE0_WEIGHTING_8814B(v))

/* 2 REG_REG_ARFR_WT1_8814B */

#define BIT_SHIFT_RATE15_WEIGHTING_8814B 28
#define BIT_MASK_RATE15_WEIGHTING_8814B 0xf
#define BIT_RATE15_WEIGHTING_8814B(x)                                          \
	(((x) & BIT_MASK_RATE15_WEIGHTING_8814B)                               \
	 << BIT_SHIFT_RATE15_WEIGHTING_8814B)
#define BITS_RATE15_WEIGHTING_8814B                                            \
	(BIT_MASK_RATE15_WEIGHTING_8814B << BIT_SHIFT_RATE15_WEIGHTING_8814B)
#define BIT_CLEAR_RATE15_WEIGHTING_8814B(x)                                    \
	((x) & (~BITS_RATE15_WEIGHTING_8814B))
#define BIT_GET_RATE15_WEIGHTING_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RATE15_WEIGHTING_8814B) &                           \
	 BIT_MASK_RATE15_WEIGHTING_8814B)
#define BIT_SET_RATE15_WEIGHTING_8814B(x, v)                                   \
	(BIT_CLEAR_RATE15_WEIGHTING_8814B(x) | BIT_RATE15_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE14_WEIGHTING_8814B 24
#define BIT_MASK_RATE14_WEIGHTING_8814B 0xf
#define BIT_RATE14_WEIGHTING_8814B(x)                                          \
	(((x) & BIT_MASK_RATE14_WEIGHTING_8814B)                               \
	 << BIT_SHIFT_RATE14_WEIGHTING_8814B)
#define BITS_RATE14_WEIGHTING_8814B                                            \
	(BIT_MASK_RATE14_WEIGHTING_8814B << BIT_SHIFT_RATE14_WEIGHTING_8814B)
#define BIT_CLEAR_RATE14_WEIGHTING_8814B(x)                                    \
	((x) & (~BITS_RATE14_WEIGHTING_8814B))
#define BIT_GET_RATE14_WEIGHTING_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RATE14_WEIGHTING_8814B) &                           \
	 BIT_MASK_RATE14_WEIGHTING_8814B)
#define BIT_SET_RATE14_WEIGHTING_8814B(x, v)                                   \
	(BIT_CLEAR_RATE14_WEIGHTING_8814B(x) | BIT_RATE14_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE13_WEIGHTING_8814B 20
#define BIT_MASK_RATE13_WEIGHTING_8814B 0xf
#define BIT_RATE13_WEIGHTING_8814B(x)                                          \
	(((x) & BIT_MASK_RATE13_WEIGHTING_8814B)                               \
	 << BIT_SHIFT_RATE13_WEIGHTING_8814B)
#define BITS_RATE13_WEIGHTING_8814B                                            \
	(BIT_MASK_RATE13_WEIGHTING_8814B << BIT_SHIFT_RATE13_WEIGHTING_8814B)
#define BIT_CLEAR_RATE13_WEIGHTING_8814B(x)                                    \
	((x) & (~BITS_RATE13_WEIGHTING_8814B))
#define BIT_GET_RATE13_WEIGHTING_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RATE13_WEIGHTING_8814B) &                           \
	 BIT_MASK_RATE13_WEIGHTING_8814B)
#define BIT_SET_RATE13_WEIGHTING_8814B(x, v)                                   \
	(BIT_CLEAR_RATE13_WEIGHTING_8814B(x) | BIT_RATE13_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE12_WEIGHTING_8814B 16
#define BIT_MASK_RATE12_WEIGHTING_8814B 0xf
#define BIT_RATE12_WEIGHTING_8814B(x)                                          \
	(((x) & BIT_MASK_RATE12_WEIGHTING_8814B)                               \
	 << BIT_SHIFT_RATE12_WEIGHTING_8814B)
#define BITS_RATE12_WEIGHTING_8814B                                            \
	(BIT_MASK_RATE12_WEIGHTING_8814B << BIT_SHIFT_RATE12_WEIGHTING_8814B)
#define BIT_CLEAR_RATE12_WEIGHTING_8814B(x)                                    \
	((x) & (~BITS_RATE12_WEIGHTING_8814B))
#define BIT_GET_RATE12_WEIGHTING_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RATE12_WEIGHTING_8814B) &                           \
	 BIT_MASK_RATE12_WEIGHTING_8814B)
#define BIT_SET_RATE12_WEIGHTING_8814B(x, v)                                   \
	(BIT_CLEAR_RATE12_WEIGHTING_8814B(x) | BIT_RATE12_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE11_WEIGHTING_8814B 12
#define BIT_MASK_RATE11_WEIGHTING_8814B 0xf
#define BIT_RATE11_WEIGHTING_8814B(x)                                          \
	(((x) & BIT_MASK_RATE11_WEIGHTING_8814B)                               \
	 << BIT_SHIFT_RATE11_WEIGHTING_8814B)
#define BITS_RATE11_WEIGHTING_8814B                                            \
	(BIT_MASK_RATE11_WEIGHTING_8814B << BIT_SHIFT_RATE11_WEIGHTING_8814B)
#define BIT_CLEAR_RATE11_WEIGHTING_8814B(x)                                    \
	((x) & (~BITS_RATE11_WEIGHTING_8814B))
#define BIT_GET_RATE11_WEIGHTING_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RATE11_WEIGHTING_8814B) &                           \
	 BIT_MASK_RATE11_WEIGHTING_8814B)
#define BIT_SET_RATE11_WEIGHTING_8814B(x, v)                                   \
	(BIT_CLEAR_RATE11_WEIGHTING_8814B(x) | BIT_RATE11_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE10_WEIGHTING_8814B 8
#define BIT_MASK_RATE10_WEIGHTING_8814B 0xf
#define BIT_RATE10_WEIGHTING_8814B(x)                                          \
	(((x) & BIT_MASK_RATE10_WEIGHTING_8814B)                               \
	 << BIT_SHIFT_RATE10_WEIGHTING_8814B)
#define BITS_RATE10_WEIGHTING_8814B                                            \
	(BIT_MASK_RATE10_WEIGHTING_8814B << BIT_SHIFT_RATE10_WEIGHTING_8814B)
#define BIT_CLEAR_RATE10_WEIGHTING_8814B(x)                                    \
	((x) & (~BITS_RATE10_WEIGHTING_8814B))
#define BIT_GET_RATE10_WEIGHTING_8814B(x)                                      \
	(((x) >> BIT_SHIFT_RATE10_WEIGHTING_8814B) &                           \
	 BIT_MASK_RATE10_WEIGHTING_8814B)
#define BIT_SET_RATE10_WEIGHTING_8814B(x, v)                                   \
	(BIT_CLEAR_RATE10_WEIGHTING_8814B(x) | BIT_RATE10_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE9_WEIGHTING_8814B 4
#define BIT_MASK_RATE9_WEIGHTING_8814B 0xf
#define BIT_RATE9_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE9_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE9_WEIGHTING_8814B)
#define BITS_RATE9_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE9_WEIGHTING_8814B << BIT_SHIFT_RATE9_WEIGHTING_8814B)
#define BIT_CLEAR_RATE9_WEIGHTING_8814B(x) ((x) & (~BITS_RATE9_WEIGHTING_8814B))
#define BIT_GET_RATE9_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE9_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE9_WEIGHTING_8814B)
#define BIT_SET_RATE9_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE9_WEIGHTING_8814B(x) | BIT_RATE9_WEIGHTING_8814B(v))

#define BIT_SHIFT_RATE8_WEIGHTING_8814B 0
#define BIT_MASK_RATE8_WEIGHTING_8814B 0xf
#define BIT_RATE8_WEIGHTING_8814B(x)                                           \
	(((x) & BIT_MASK_RATE8_WEIGHTING_8814B)                                \
	 << BIT_SHIFT_RATE8_WEIGHTING_8814B)
#define BITS_RATE8_WEIGHTING_8814B                                             \
	(BIT_MASK_RATE8_WEIGHTING_8814B << BIT_SHIFT_RATE8_WEIGHTING_8814B)
#define BIT_CLEAR_RATE8_WEIGHTING_8814B(x) ((x) & (~BITS_RATE8_WEIGHTING_8814B))
#define BIT_GET_RATE8_WEIGHTING_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RATE8_WEIGHTING_8814B) &                            \
	 BIT_MASK_RATE8_WEIGHTING_8814B)
#define BIT_SET_RATE8_WEIGHTING_8814B(x, v)                                    \
	(BIT_CLEAR_RATE8_WEIGHTING_8814B(x) | BIT_RATE8_WEIGHTING_8814B(v))

/* 2 REG_CCK_CHECK_8814B */
#define BIT_CHECK_CCK_EN_8814B BIT(7)
#define BIT_EN_BCN_PKT_REL_P0_8814B BIT(6)
#define BIT_BCN_PORT_SEL_8814B BIT(5)
#define BIT_MOREDATA_BYPASS_8814B BIT(4)
#define BIT_EN_CLR_CMD_REL_BCN_PKT_P0_8814B BIT(3)
#define BIT_EN_SET_MOREDATA_8814B BIT(2)
#define BIT__R_DIS_CLEAR_MACID_RELEASE_8814B BIT(1)
#define BIT__R_MACID_RELEASE_EN_8814B BIT(0)

/* 2 REG_AMPDU_MAX_TIME_V1_8814B */

#define BIT_SHIFT_AMPDU_MAX_TIME_8814B 0
#define BIT_MASK_AMPDU_MAX_TIME_8814B 0xff
#define BIT_AMPDU_MAX_TIME_8814B(x)                                            \
	(((x) & BIT_MASK_AMPDU_MAX_TIME_8814B)                                 \
	 << BIT_SHIFT_AMPDU_MAX_TIME_8814B)
#define BITS_AMPDU_MAX_TIME_8814B                                              \
	(BIT_MASK_AMPDU_MAX_TIME_8814B << BIT_SHIFT_AMPDU_MAX_TIME_8814B)
#define BIT_CLEAR_AMPDU_MAX_TIME_8814B(x) ((x) & (~BITS_AMPDU_MAX_TIME_8814B))
#define BIT_GET_AMPDU_MAX_TIME_8814B(x)                                        \
	(((x) >> BIT_SHIFT_AMPDU_MAX_TIME_8814B) &                             \
	 BIT_MASK_AMPDU_MAX_TIME_8814B)
#define BIT_SET_AMPDU_MAX_TIME_8814B(x, v)                                     \
	(BIT_CLEAR_AMPDU_MAX_TIME_8814B(x) | BIT_AMPDU_MAX_TIME_8814B(v))

/* 2 REG_TAB_SEL_8814B */

#define BIT_SHIFT_RATE_SEL_8814B 0
#define BIT_MASK_RATE_SEL_8814B 0xf
#define BIT_RATE_SEL_8814B(x)                                                  \
	(((x) & BIT_MASK_RATE_SEL_8814B) << BIT_SHIFT_RATE_SEL_8814B)
#define BITS_RATE_SEL_8814B                                                    \
	(BIT_MASK_RATE_SEL_8814B << BIT_SHIFT_RATE_SEL_8814B)
#define BIT_CLEAR_RATE_SEL_8814B(x) ((x) & (~BITS_RATE_SEL_8814B))
#define BIT_GET_RATE_SEL_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RATE_SEL_8814B) & BIT_MASK_RATE_SEL_8814B)
#define BIT_SET_RATE_SEL_8814B(x, v)                                           \
	(BIT_CLEAR_RATE_SEL_8814B(x) | BIT_RATE_SEL_8814B(v))

/* 2 REG_BCN_INVALID_CTRL_8814B */
#define BIT_EN_CLR_CMD_REL_BCN_PKT_P4_8814B BIT(7)
#define BIT_EN_BCN_PKT_REL_P4_8814B BIT(6)
#define BIT_EN_CLR_CMD_REL_BCN_PKT_P3_8814B BIT(5)
#define BIT_EN_BCN_PKT_REL_P3_8814B BIT(4)
#define BIT_EN_CLR_CMD_REL_BCN_PKT_P2_8814B BIT(3)
#define BIT_EN_BCN_PKT_REL_P2_8814B BIT(2)
#define BIT_EN_CLR_CMD_REL_BCN_PKT_P1_8814B BIT(1)
#define BIT_EN_BCN_PKT_REL_P1_8814B BIT(0)

/* 2 REG_AMPDU_MAX_LENGTH_HT_8814B */

#define BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8814B 0
#define BIT_MASK_AMPDU_MAX_LENGTH_HT_8814B 0xffff
#define BIT_AMPDU_MAX_LENGTH_HT_8814B(x)                                       \
	(((x) & BIT_MASK_AMPDU_MAX_LENGTH_HT_8814B)                            \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8814B)
#define BITS_AMPDU_MAX_LENGTH_HT_8814B                                         \
	(BIT_MASK_AMPDU_MAX_LENGTH_HT_8814B                                    \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8814B)
#define BIT_CLEAR_AMPDU_MAX_LENGTH_HT_8814B(x)                                 \
	((x) & (~BITS_AMPDU_MAX_LENGTH_HT_8814B))
#define BIT_GET_AMPDU_MAX_LENGTH_HT_8814B(x)                                   \
	(((x) >> BIT_SHIFT_AMPDU_MAX_LENGTH_HT_8814B) &                        \
	 BIT_MASK_AMPDU_MAX_LENGTH_HT_8814B)
#define BIT_SET_AMPDU_MAX_LENGTH_HT_8814B(x, v)                                \
	(BIT_CLEAR_AMPDU_MAX_LENGTH_HT_8814B(x) |                              \
	 BIT_AMPDU_MAX_LENGTH_HT_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NDPA_RATE_8814B */

#define BIT_SHIFT_R_NDPA_RATE_V1_8814B 0
#define BIT_MASK_R_NDPA_RATE_V1_8814B 0xff
#define BIT_R_NDPA_RATE_V1_8814B(x)                                            \
	(((x) & BIT_MASK_R_NDPA_RATE_V1_8814B)                                 \
	 << BIT_SHIFT_R_NDPA_RATE_V1_8814B)
#define BITS_R_NDPA_RATE_V1_8814B                                              \
	(BIT_MASK_R_NDPA_RATE_V1_8814B << BIT_SHIFT_R_NDPA_RATE_V1_8814B)
#define BIT_CLEAR_R_NDPA_RATE_V1_8814B(x) ((x) & (~BITS_R_NDPA_RATE_V1_8814B))
#define BIT_GET_R_NDPA_RATE_V1_8814B(x)                                        \
	(((x) >> BIT_SHIFT_R_NDPA_RATE_V1_8814B) &                             \
	 BIT_MASK_R_NDPA_RATE_V1_8814B)
#define BIT_SET_R_NDPA_RATE_V1_8814B(x, v)                                     \
	(BIT_CLEAR_R_NDPA_RATE_V1_8814B(x) | BIT_R_NDPA_RATE_V1_8814B(v))

/* 2 REG_TX_HANG_CTRL_8814B */
#define BIT_EN_GNT_BT_AWAKE_8814B BIT(3)
#define BIT_EN_EOF_V1_8814B BIT(2)
#define BIT_DIS_OQT_BLOCK_8814B BIT(1)
#define BIT_SEARCH_QUEUE_EN_8814B BIT(0)

/* 2 REG_NDPA_OPT_CTRL_8814B */
#define BIT_DIS_MACID_RELEASE_RTY_8814B BIT(5)

#define BIT_SHIFT_BW_SIGTA_8814B 3
#define BIT_MASK_BW_SIGTA_8814B 0x3
#define BIT_BW_SIGTA_8814B(x)                                                  \
	(((x) & BIT_MASK_BW_SIGTA_8814B) << BIT_SHIFT_BW_SIGTA_8814B)
#define BITS_BW_SIGTA_8814B                                                    \
	(BIT_MASK_BW_SIGTA_8814B << BIT_SHIFT_BW_SIGTA_8814B)
#define BIT_CLEAR_BW_SIGTA_8814B(x) ((x) & (~BITS_BW_SIGTA_8814B))
#define BIT_GET_BW_SIGTA_8814B(x)                                              \
	(((x) >> BIT_SHIFT_BW_SIGTA_8814B) & BIT_MASK_BW_SIGTA_8814B)
#define BIT_SET_BW_SIGTA_8814B(x, v)                                           \
	(BIT_CLEAR_BW_SIGTA_8814B(x) | BIT_BW_SIGTA_8814B(v))

#define BIT_EN_BAR_SIGTA_8814B BIT(2)

#define BIT_SHIFT_NDPA_BW_8814B 0
#define BIT_MASK_NDPA_BW_8814B 0x3
#define BIT_NDPA_BW_8814B(x)                                                   \
	(((x) & BIT_MASK_NDPA_BW_8814B) << BIT_SHIFT_NDPA_BW_8814B)
#define BITS_NDPA_BW_8814B (BIT_MASK_NDPA_BW_8814B << BIT_SHIFT_NDPA_BW_8814B)
#define BIT_CLEAR_NDPA_BW_8814B(x) ((x) & (~BITS_NDPA_BW_8814B))
#define BIT_GET_NDPA_BW_8814B(x)                                               \
	(((x) >> BIT_SHIFT_NDPA_BW_8814B) & BIT_MASK_NDPA_BW_8814B)
#define BIT_SET_NDPA_BW_8814B(x, v)                                            \
	(BIT_CLEAR_NDPA_BW_8814B(x) | BIT_NDPA_BW_8814B(v))

/* 2 REG_AMPDU_MAX_LENGTH_VHT_8814B */

#define BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_8814B 0
#define BIT_MASK_AMPDU_MAX_LENGTH_VHT_8814B 0x3ffff
#define BIT_AMPDU_MAX_LENGTH_VHT_8814B(x)                                      \
	(((x) & BIT_MASK_AMPDU_MAX_LENGTH_VHT_8814B)                           \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_8814B)
#define BITS_AMPDU_MAX_LENGTH_VHT_8814B                                        \
	(BIT_MASK_AMPDU_MAX_LENGTH_VHT_8814B                                   \
	 << BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_8814B)
#define BIT_CLEAR_AMPDU_MAX_LENGTH_VHT_8814B(x)                                \
	((x) & (~BITS_AMPDU_MAX_LENGTH_VHT_8814B))
#define BIT_GET_AMPDU_MAX_LENGTH_VHT_8814B(x)                                  \
	(((x) >> BIT_SHIFT_AMPDU_MAX_LENGTH_VHT_8814B) &                       \
	 BIT_MASK_AMPDU_MAX_LENGTH_VHT_8814B)
#define BIT_SET_AMPDU_MAX_LENGTH_VHT_8814B(x, v)                               \
	(BIT_CLEAR_AMPDU_MAX_LENGTH_VHT_8814B(x) |                             \
	 BIT_AMPDU_MAX_LENGTH_VHT_8814B(v))

/* 2 REG_RD_RESP_PKT_TH_8814B */

#define BIT_SHIFT_RD_RESP_PKT_TH_V1_8814B 0
#define BIT_MASK_RD_RESP_PKT_TH_V1_8814B 0x3f
#define BIT_RD_RESP_PKT_TH_V1_8814B(x)                                         \
	(((x) & BIT_MASK_RD_RESP_PKT_TH_V1_8814B)                              \
	 << BIT_SHIFT_RD_RESP_PKT_TH_V1_8814B)
#define BITS_RD_RESP_PKT_TH_V1_8814B                                           \
	(BIT_MASK_RD_RESP_PKT_TH_V1_8814B << BIT_SHIFT_RD_RESP_PKT_TH_V1_8814B)
#define BIT_CLEAR_RD_RESP_PKT_TH_V1_8814B(x)                                   \
	((x) & (~BITS_RD_RESP_PKT_TH_V1_8814B))
#define BIT_GET_RD_RESP_PKT_TH_V1_8814B(x)                                     \
	(((x) >> BIT_SHIFT_RD_RESP_PKT_TH_V1_8814B) &                          \
	 BIT_MASK_RD_RESP_PKT_TH_V1_8814B)
#define BIT_SET_RD_RESP_PKT_TH_V1_8814B(x, v)                                  \
	(BIT_CLEAR_RD_RESP_PKT_TH_V1_8814B(x) | BIT_RD_RESP_PKT_TH_V1_8814B(v))

/* 2 REG_NEW_EDCA_CTRL_V1_8814B */

#define BIT_SHIFT_RANDOM_VALUE_SHIFT_8814B 9
#define BIT_MASK_RANDOM_VALUE_SHIFT_8814B 0x7
#define BIT_RANDOM_VALUE_SHIFT_8814B(x)                                        \
	(((x) & BIT_MASK_RANDOM_VALUE_SHIFT_8814B)                             \
	 << BIT_SHIFT_RANDOM_VALUE_SHIFT_8814B)
#define BITS_RANDOM_VALUE_SHIFT_8814B                                          \
	(BIT_MASK_RANDOM_VALUE_SHIFT_8814B                                     \
	 << BIT_SHIFT_RANDOM_VALUE_SHIFT_8814B)
#define BIT_CLEAR_RANDOM_VALUE_SHIFT_8814B(x)                                  \
	((x) & (~BITS_RANDOM_VALUE_SHIFT_8814B))
#define BIT_GET_RANDOM_VALUE_SHIFT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_RANDOM_VALUE_SHIFT_8814B) &                         \
	 BIT_MASK_RANDOM_VALUE_SHIFT_8814B)
#define BIT_SET_RANDOM_VALUE_SHIFT_8814B(x, v)                                 \
	(BIT_CLEAR_RANDOM_VALUE_SHIFT_8814B(x) |                               \
	 BIT_RANDOM_VALUE_SHIFT_8814B(v))

#define BIT_ENABLE_NEW_EDCA_8814B BIT(8)

#define BIT_SHIFT_MEDIUM_HAS_IDKE_TRIGGER_8814B 0
#define BIT_MASK_MEDIUM_HAS_IDKE_TRIGGER_8814B 0xff
#define BIT_MEDIUM_HAS_IDKE_TRIGGER_8814B(x)                                   \
	(((x) & BIT_MASK_MEDIUM_HAS_IDKE_TRIGGER_8814B)                        \
	 << BIT_SHIFT_MEDIUM_HAS_IDKE_TRIGGER_8814B)
#define BITS_MEDIUM_HAS_IDKE_TRIGGER_8814B                                     \
	(BIT_MASK_MEDIUM_HAS_IDKE_TRIGGER_8814B                                \
	 << BIT_SHIFT_MEDIUM_HAS_IDKE_TRIGGER_8814B)
#define BIT_CLEAR_MEDIUM_HAS_IDKE_TRIGGER_8814B(x)                             \
	((x) & (~BITS_MEDIUM_HAS_IDKE_TRIGGER_8814B))
#define BIT_GET_MEDIUM_HAS_IDKE_TRIGGER_8814B(x)                               \
	(((x) >> BIT_SHIFT_MEDIUM_HAS_IDKE_TRIGGER_8814B) &                    \
	 BIT_MASK_MEDIUM_HAS_IDKE_TRIGGER_8814B)
#define BIT_SET_MEDIUM_HAS_IDKE_TRIGGER_8814B(x, v)                            \
	(BIT_CLEAR_MEDIUM_HAS_IDKE_TRIGGER_8814B(x) |                          \
	 BIT_MEDIUM_HAS_IDKE_TRIGGER_8814B(v))

/* 2 REG_ACQ_STOP_V2_8814B */
#define BIT_AC19Q_STOP_8814B BIT(19)
#define BIT_AC18Q_STOP_8814B BIT(18)
#define BIT_AC17Q_STOP_8814B BIT(17)
#define BIT_AC16Q_STOP_8814B BIT(16)
#define BIT_AC15Q_STOP_8814B BIT(15)
#define BIT_AC14Q_STOP_8814B BIT(14)
#define BIT_AC13Q_STOP_8814B BIT(13)
#define BIT_AC12Q_STOP_8814B BIT(12)
#define BIT_AC11Q_STOP_8814B BIT(11)
#define BIT_AC10Q_STOP_8814B BIT(10)
#define BIT_AC9Q_STOP_8814B BIT(9)
#define BIT_AC8Q_STOP_8814B BIT(8)
#define BIT_AC7Q_STOP_8814B BIT(7)
#define BIT_AC6Q_STOP_8814B BIT(6)
#define BIT_AC5Q_STOP_8814B BIT(5)
#define BIT_AC4Q_STOP_8814B BIT(4)
#define BIT_AC3Q_STOP_8814B BIT(3)
#define BIT_AC2Q_STOP_8814B BIT(2)
#define BIT_AC1Q_STOP_8814B BIT(1)
#define BIT_AC0Q_STOP_8814B BIT(0)

/* 2 REG_WMAC_LBK_BUF_HD_V1_8814B */

#define BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8814B 0
#define BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8814B 0xfff
#define BIT_WMAC_LBK_BUF_HEAD_V1_8814B(x)                                      \
	(((x) & BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8814B)                           \
	 << BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8814B)
#define BITS_WMAC_LBK_BUF_HEAD_V1_8814B                                        \
	(BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8814B                                   \
	 << BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8814B)
#define BIT_CLEAR_WMAC_LBK_BUF_HEAD_V1_8814B(x)                                \
	((x) & (~BITS_WMAC_LBK_BUF_HEAD_V1_8814B))
#define BIT_GET_WMAC_LBK_BUF_HEAD_V1_8814B(x)                                  \
	(((x) >> BIT_SHIFT_WMAC_LBK_BUF_HEAD_V1_8814B) &                       \
	 BIT_MASK_WMAC_LBK_BUF_HEAD_V1_8814B)
#define BIT_SET_WMAC_LBK_BUF_HEAD_V1_8814B(x, v)                               \
	(BIT_CLEAR_WMAC_LBK_BUF_HEAD_V1_8814B(x) |                             \
	 BIT_WMAC_LBK_BUF_HEAD_V1_8814B(v))

/* 2 REG_MGQ_BDNY_V1_8814B */

#define BIT_SHIFT_MGQ_PGBNDY_V1_8814B 0
#define BIT_MASK_MGQ_PGBNDY_V1_8814B 0xfff
#define BIT_MGQ_PGBNDY_V1_8814B(x)                                             \
	(((x) & BIT_MASK_MGQ_PGBNDY_V1_8814B) << BIT_SHIFT_MGQ_PGBNDY_V1_8814B)
#define BITS_MGQ_PGBNDY_V1_8814B                                               \
	(BIT_MASK_MGQ_PGBNDY_V1_8814B << BIT_SHIFT_MGQ_PGBNDY_V1_8814B)
#define BIT_CLEAR_MGQ_PGBNDY_V1_8814B(x) ((x) & (~BITS_MGQ_PGBNDY_V1_8814B))
#define BIT_GET_MGQ_PGBNDY_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_PGBNDY_V1_8814B) & BIT_MASK_MGQ_PGBNDY_V1_8814B)
#define BIT_SET_MGQ_PGBNDY_V1_8814B(x, v)                                      \
	(BIT_CLEAR_MGQ_PGBNDY_V1_8814B(x) | BIT_MGQ_PGBNDY_V1_8814B(v))

/* 2 REG_TXRPT_CTRL_8814B */

#define BIT_SHIFT_TRXRPT_TIMER_TH_8814B 24
#define BIT_MASK_TRXRPT_TIMER_TH_8814B 0xff
#define BIT_TRXRPT_TIMER_TH_8814B(x)                                           \
	(((x) & BIT_MASK_TRXRPT_TIMER_TH_8814B)                                \
	 << BIT_SHIFT_TRXRPT_TIMER_TH_8814B)
#define BITS_TRXRPT_TIMER_TH_8814B                                             \
	(BIT_MASK_TRXRPT_TIMER_TH_8814B << BIT_SHIFT_TRXRPT_TIMER_TH_8814B)
#define BIT_CLEAR_TRXRPT_TIMER_TH_8814B(x) ((x) & (~BITS_TRXRPT_TIMER_TH_8814B))
#define BIT_GET_TRXRPT_TIMER_TH_8814B(x)                                       \
	(((x) >> BIT_SHIFT_TRXRPT_TIMER_TH_8814B) &                            \
	 BIT_MASK_TRXRPT_TIMER_TH_8814B)
#define BIT_SET_TRXRPT_TIMER_TH_8814B(x, v)                                    \
	(BIT_CLEAR_TRXRPT_TIMER_TH_8814B(x) | BIT_TRXRPT_TIMER_TH_8814B(v))

#define BIT_SHIFT_TRXRPT_LEN_TH_8814B 16
#define BIT_MASK_TRXRPT_LEN_TH_8814B 0xff
#define BIT_TRXRPT_LEN_TH_8814B(x)                                             \
	(((x) & BIT_MASK_TRXRPT_LEN_TH_8814B) << BIT_SHIFT_TRXRPT_LEN_TH_8814B)
#define BITS_TRXRPT_LEN_TH_8814B                                               \
	(BIT_MASK_TRXRPT_LEN_TH_8814B << BIT_SHIFT_TRXRPT_LEN_TH_8814B)
#define BIT_CLEAR_TRXRPT_LEN_TH_8814B(x) ((x) & (~BITS_TRXRPT_LEN_TH_8814B))
#define BIT_GET_TRXRPT_LEN_TH_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TRXRPT_LEN_TH_8814B) & BIT_MASK_TRXRPT_LEN_TH_8814B)
#define BIT_SET_TRXRPT_LEN_TH_8814B(x, v)                                      \
	(BIT_CLEAR_TRXRPT_LEN_TH_8814B(x) | BIT_TRXRPT_LEN_TH_8814B(v))

#define BIT_SHIFT_TRXRPT_READ_PTR_8814B 8
#define BIT_MASK_TRXRPT_READ_PTR_8814B 0xff
#define BIT_TRXRPT_READ_PTR_8814B(x)                                           \
	(((x) & BIT_MASK_TRXRPT_READ_PTR_8814B)                                \
	 << BIT_SHIFT_TRXRPT_READ_PTR_8814B)
#define BITS_TRXRPT_READ_PTR_8814B                                             \
	(BIT_MASK_TRXRPT_READ_PTR_8814B << BIT_SHIFT_TRXRPT_READ_PTR_8814B)
#define BIT_CLEAR_TRXRPT_READ_PTR_8814B(x) ((x) & (~BITS_TRXRPT_READ_PTR_8814B))
#define BIT_GET_TRXRPT_READ_PTR_8814B(x)                                       \
	(((x) >> BIT_SHIFT_TRXRPT_READ_PTR_8814B) &                            \
	 BIT_MASK_TRXRPT_READ_PTR_8814B)
#define BIT_SET_TRXRPT_READ_PTR_8814B(x, v)                                    \
	(BIT_CLEAR_TRXRPT_READ_PTR_8814B(x) | BIT_TRXRPT_READ_PTR_8814B(v))

#define BIT_SHIFT_TRXRPT_WRITE_PTR_8814B 0
#define BIT_MASK_TRXRPT_WRITE_PTR_8814B 0xff
#define BIT_TRXRPT_WRITE_PTR_8814B(x)                                          \
	(((x) & BIT_MASK_TRXRPT_WRITE_PTR_8814B)                               \
	 << BIT_SHIFT_TRXRPT_WRITE_PTR_8814B)
#define BITS_TRXRPT_WRITE_PTR_8814B                                            \
	(BIT_MASK_TRXRPT_WRITE_PTR_8814B << BIT_SHIFT_TRXRPT_WRITE_PTR_8814B)
#define BIT_CLEAR_TRXRPT_WRITE_PTR_8814B(x)                                    \
	((x) & (~BITS_TRXRPT_WRITE_PTR_8814B))
#define BIT_GET_TRXRPT_WRITE_PTR_8814B(x)                                      \
	(((x) >> BIT_SHIFT_TRXRPT_WRITE_PTR_8814B) &                           \
	 BIT_MASK_TRXRPT_WRITE_PTR_8814B)
#define BIT_SET_TRXRPT_WRITE_PTR_8814B(x, v)                                   \
	(BIT_CLEAR_TRXRPT_WRITE_PTR_8814B(x) | BIT_TRXRPT_WRITE_PTR_8814B(v))

/* 2 REG_INIRTS_RATE_SEL_8814B */
#define BIT_LEAG_RTS_BW_DUP_8814B BIT(5)

/* 2 REG_BASIC_CFEND_RATE_8814B */

#define BIT_SHIFT_BASIC_CFEND_RATE_8814B 0
#define BIT_MASK_BASIC_CFEND_RATE_8814B 0x1f
#define BIT_BASIC_CFEND_RATE_8814B(x)                                          \
	(((x) & BIT_MASK_BASIC_CFEND_RATE_8814B)                               \
	 << BIT_SHIFT_BASIC_CFEND_RATE_8814B)
#define BITS_BASIC_CFEND_RATE_8814B                                            \
	(BIT_MASK_BASIC_CFEND_RATE_8814B << BIT_SHIFT_BASIC_CFEND_RATE_8814B)
#define BIT_CLEAR_BASIC_CFEND_RATE_8814B(x)                                    \
	((x) & (~BITS_BASIC_CFEND_RATE_8814B))
#define BIT_GET_BASIC_CFEND_RATE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BASIC_CFEND_RATE_8814B) &                           \
	 BIT_MASK_BASIC_CFEND_RATE_8814B)
#define BIT_SET_BASIC_CFEND_RATE_8814B(x, v)                                   \
	(BIT_CLEAR_BASIC_CFEND_RATE_8814B(x) | BIT_BASIC_CFEND_RATE_8814B(v))

/* 2 REG_STBC_CFEND_RATE_8814B */

#define BIT_SHIFT_STBC_CFEND_RATE_8814B 0
#define BIT_MASK_STBC_CFEND_RATE_8814B 0x1f
#define BIT_STBC_CFEND_RATE_8814B(x)                                           \
	(((x) & BIT_MASK_STBC_CFEND_RATE_8814B)                                \
	 << BIT_SHIFT_STBC_CFEND_RATE_8814B)
#define BITS_STBC_CFEND_RATE_8814B                                             \
	(BIT_MASK_STBC_CFEND_RATE_8814B << BIT_SHIFT_STBC_CFEND_RATE_8814B)
#define BIT_CLEAR_STBC_CFEND_RATE_8814B(x) ((x) & (~BITS_STBC_CFEND_RATE_8814B))
#define BIT_GET_STBC_CFEND_RATE_8814B(x)                                       \
	(((x) >> BIT_SHIFT_STBC_CFEND_RATE_8814B) &                            \
	 BIT_MASK_STBC_CFEND_RATE_8814B)
#define BIT_SET_STBC_CFEND_RATE_8814B(x, v)                                    \
	(BIT_CLEAR_STBC_CFEND_RATE_8814B(x) | BIT_STBC_CFEND_RATE_8814B(v))

/* 2 REG_DATA_SC_8814B */

#define BIT_SHIFT_TXSC_40M_8814B 4
#define BIT_MASK_TXSC_40M_8814B 0xf
#define BIT_TXSC_40M_8814B(x)                                                  \
	(((x) & BIT_MASK_TXSC_40M_8814B) << BIT_SHIFT_TXSC_40M_8814B)
#define BITS_TXSC_40M_8814B                                                    \
	(BIT_MASK_TXSC_40M_8814B << BIT_SHIFT_TXSC_40M_8814B)
#define BIT_CLEAR_TXSC_40M_8814B(x) ((x) & (~BITS_TXSC_40M_8814B))
#define BIT_GET_TXSC_40M_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TXSC_40M_8814B) & BIT_MASK_TXSC_40M_8814B)
#define BIT_SET_TXSC_40M_8814B(x, v)                                           \
	(BIT_CLEAR_TXSC_40M_8814B(x) | BIT_TXSC_40M_8814B(v))

#define BIT_SHIFT_TXSC_20M_8814B 0
#define BIT_MASK_TXSC_20M_8814B 0xf
#define BIT_TXSC_20M_8814B(x)                                                  \
	(((x) & BIT_MASK_TXSC_20M_8814B) << BIT_SHIFT_TXSC_20M_8814B)
#define BITS_TXSC_20M_8814B                                                    \
	(BIT_MASK_TXSC_20M_8814B << BIT_SHIFT_TXSC_20M_8814B)
#define BIT_CLEAR_TXSC_20M_8814B(x) ((x) & (~BITS_TXSC_20M_8814B))
#define BIT_GET_TXSC_20M_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TXSC_20M_8814B) & BIT_MASK_TXSC_20M_8814B)
#define BIT_SET_TXSC_20M_8814B(x, v)                                           \
	(BIT_CLEAR_TXSC_20M_8814B(x) | BIT_TXSC_20M_8814B(v))

/* 2 REG_MOREDATA_V1_8814B */
#define BIT_MOREDATA_CTRL2_EN_V1_8814B BIT(3)
#define BIT_MOREDATA_CTRL1_EN_V1_8814B BIT(2)
#define BIT_PKTIN_MOREDATA_REPLACE_ENABLE_V1_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_DATA_SC1_8814B */

#define BIT_SHIFT_TXSC_160M_8814B 4
#define BIT_MASK_TXSC_160M_8814B 0xf
#define BIT_TXSC_160M_8814B(x)                                                 \
	(((x) & BIT_MASK_TXSC_160M_8814B) << BIT_SHIFT_TXSC_160M_8814B)
#define BITS_TXSC_160M_8814B                                                   \
	(BIT_MASK_TXSC_160M_8814B << BIT_SHIFT_TXSC_160M_8814B)
#define BIT_CLEAR_TXSC_160M_8814B(x) ((x) & (~BITS_TXSC_160M_8814B))
#define BIT_GET_TXSC_160M_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TXSC_160M_8814B) & BIT_MASK_TXSC_160M_8814B)
#define BIT_SET_TXSC_160M_8814B(x, v)                                          \
	(BIT_CLEAR_TXSC_160M_8814B(x) | BIT_TXSC_160M_8814B(v))

#define BIT_SHIFT_TXSC_80M_8814B 0
#define BIT_MASK_TXSC_80M_8814B 0xf
#define BIT_TXSC_80M_8814B(x)                                                  \
	(((x) & BIT_MASK_TXSC_80M_8814B) << BIT_SHIFT_TXSC_80M_8814B)
#define BITS_TXSC_80M_8814B                                                    \
	(BIT_MASK_TXSC_80M_8814B << BIT_SHIFT_TXSC_80M_8814B)
#define BIT_CLEAR_TXSC_80M_8814B(x) ((x) & (~BITS_TXSC_80M_8814B))
#define BIT_GET_TXSC_80M_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TXSC_80M_8814B) & BIT_MASK_TXSC_80M_8814B)
#define BIT_SET_TXSC_80M_8814B(x, v)                                           \
	(BIT_CLEAR_TXSC_80M_8814B(x) | BIT_TXSC_80M_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_TXRPT_START_OFFSET_8814B */
#define BIT_RPTFIFO_RPTNUM_OPT_8814B BIT(31)

#define BIT_SHIFT_MISSED_RPT_NUM_8814B 28
#define BIT_MASK_MISSED_RPT_NUM_8814B 0x7
#define BIT_MISSED_RPT_NUM_8814B(x)                                            \
	(((x) & BIT_MASK_MISSED_RPT_NUM_8814B)                                 \
	 << BIT_SHIFT_MISSED_RPT_NUM_8814B)
#define BITS_MISSED_RPT_NUM_8814B                                              \
	(BIT_MASK_MISSED_RPT_NUM_8814B << BIT_SHIFT_MISSED_RPT_NUM_8814B)
#define BIT_CLEAR_MISSED_RPT_NUM_8814B(x) ((x) & (~BITS_MISSED_RPT_NUM_8814B))
#define BIT_GET_MISSED_RPT_NUM_8814B(x)                                        \
	(((x) >> BIT_SHIFT_MISSED_RPT_NUM_8814B) &                             \
	 BIT_MASK_MISSED_RPT_NUM_8814B)
#define BIT_SET_MISSED_RPT_NUM_8814B(x, v)                                     \
	(BIT_CLEAR_MISSED_RPT_NUM_8814B(x) | BIT_MISSED_RPT_NUM_8814B(v))

#define BIT_SHIFT_MACID_CTRL_OFFSET_V1_8814B 16
#define BIT_MASK_MACID_CTRL_OFFSET_V1_8814B 0x1ff
#define BIT_MACID_CTRL_OFFSET_V1_8814B(x)                                      \
	(((x) & BIT_MASK_MACID_CTRL_OFFSET_V1_8814B)                           \
	 << BIT_SHIFT_MACID_CTRL_OFFSET_V1_8814B)
#define BITS_MACID_CTRL_OFFSET_V1_8814B                                        \
	(BIT_MASK_MACID_CTRL_OFFSET_V1_8814B                                   \
	 << BIT_SHIFT_MACID_CTRL_OFFSET_V1_8814B)
#define BIT_CLEAR_MACID_CTRL_OFFSET_V1_8814B(x)                                \
	((x) & (~BITS_MACID_CTRL_OFFSET_V1_8814B))
#define BIT_GET_MACID_CTRL_OFFSET_V1_8814B(x)                                  \
	(((x) >> BIT_SHIFT_MACID_CTRL_OFFSET_V1_8814B) &                       \
	 BIT_MASK_MACID_CTRL_OFFSET_V1_8814B)
#define BIT_SET_MACID_CTRL_OFFSET_V1_8814B(x, v)                               \
	(BIT_CLEAR_MACID_CTRL_OFFSET_V1_8814B(x) |                             \
	 BIT_MACID_CTRL_OFFSET_V1_8814B(v))

#define BIT_SHIFT_AMPDU_TXRPT_OFFSET_V1_8814B 0
#define BIT_MASK_AMPDU_TXRPT_OFFSET_V1_8814B 0x1ff
#define BIT_AMPDU_TXRPT_OFFSET_V1_8814B(x)                                     \
	(((x) & BIT_MASK_AMPDU_TXRPT_OFFSET_V1_8814B)                          \
	 << BIT_SHIFT_AMPDU_TXRPT_OFFSET_V1_8814B)
#define BITS_AMPDU_TXRPT_OFFSET_V1_8814B                                       \
	(BIT_MASK_AMPDU_TXRPT_OFFSET_V1_8814B                                  \
	 << BIT_SHIFT_AMPDU_TXRPT_OFFSET_V1_8814B)
#define BIT_CLEAR_AMPDU_TXRPT_OFFSET_V1_8814B(x)                               \
	((x) & (~BITS_AMPDU_TXRPT_OFFSET_V1_8814B))
#define BIT_GET_AMPDU_TXRPT_OFFSET_V1_8814B(x)                                 \
	(((x) >> BIT_SHIFT_AMPDU_TXRPT_OFFSET_V1_8814B) &                      \
	 BIT_MASK_AMPDU_TXRPT_OFFSET_V1_8814B)
#define BIT_SET_AMPDU_TXRPT_OFFSET_V1_8814B(x, v)                              \
	(BIT_CLEAR_AMPDU_TXRPT_OFFSET_V1_8814B(x) |                            \
	 BIT_AMPDU_TXRPT_OFFSET_V1_8814B(v))

/* 2 REG_POWER_STAGE1_8814B */
#define BIT_PTA_WL_PRI_MASK_CPU_MGQ_8814B BIT(31)
#define BIT_PTA_WL_PRI_MASK_BCNQ_8814B BIT(30)
#define BIT_PTA_WL_PRI_MASK_HIQ_8814B BIT(29)
#define BIT_PTA_WL_PRI_MASK_MGQ_8814B BIT(28)
#define BIT_PTA_WL_PRI_MASK_BK_8814B BIT(27)
#define BIT_PTA_WL_PRI_MASK_BE_8814B BIT(26)
#define BIT_PTA_WL_PRI_MASK_VI_8814B BIT(25)
#define BIT_PTA_WL_PRI_MASK_VO_8814B BIT(24)

#define BIT_SHIFT_POWER_STAGE1_8814B 0
#define BIT_MASK_POWER_STAGE1_8814B 0xffffff
#define BIT_POWER_STAGE1_8814B(x)                                              \
	(((x) & BIT_MASK_POWER_STAGE1_8814B) << BIT_SHIFT_POWER_STAGE1_8814B)
#define BITS_POWER_STAGE1_8814B                                                \
	(BIT_MASK_POWER_STAGE1_8814B << BIT_SHIFT_POWER_STAGE1_8814B)
#define BIT_CLEAR_POWER_STAGE1_8814B(x) ((x) & (~BITS_POWER_STAGE1_8814B))
#define BIT_GET_POWER_STAGE1_8814B(x)                                          \
	(((x) >> BIT_SHIFT_POWER_STAGE1_8814B) & BIT_MASK_POWER_STAGE1_8814B)
#define BIT_SET_POWER_STAGE1_8814B(x, v)                                       \
	(BIT_CLEAR_POWER_STAGE1_8814B(x) | BIT_POWER_STAGE1_8814B(v))

/* 2 REG_POWER_STAGE2_8814B */
#define BIT__CTRL_PKT_POW_ADJ_8814B BIT(24)

#define BIT_SHIFT_POWER_STAGE2_8814B 0
#define BIT_MASK_POWER_STAGE2_8814B 0xffffff
#define BIT_POWER_STAGE2_8814B(x)                                              \
	(((x) & BIT_MASK_POWER_STAGE2_8814B) << BIT_SHIFT_POWER_STAGE2_8814B)
#define BITS_POWER_STAGE2_8814B                                                \
	(BIT_MASK_POWER_STAGE2_8814B << BIT_SHIFT_POWER_STAGE2_8814B)
#define BIT_CLEAR_POWER_STAGE2_8814B(x) ((x) & (~BITS_POWER_STAGE2_8814B))
#define BIT_GET_POWER_STAGE2_8814B(x)                                          \
	(((x) >> BIT_SHIFT_POWER_STAGE2_8814B) & BIT_MASK_POWER_STAGE2_8814B)
#define BIT_SET_POWER_STAGE2_8814B(x, v)                                       \
	(BIT_CLEAR_POWER_STAGE2_8814B(x) | BIT_POWER_STAGE2_8814B(v))

/* 2 REG_SW_AMPDU_BURST_MODE_CTRL_8814B */
#define BIT_DMA_THIS_QUEUE_BK_8814B BIT(23)
#define BIT_DMA_THIS_QUEUE_BE_8814B BIT(22)
#define BIT_DMA_THIS_QUEUE_VI_8814B BIT(21)
#define BIT_DMA_THIS_QUEUE_VO_8814B BIT(20)

#define BIT_SHIFT_TOTAL_LEN_TH_8814B 8
#define BIT_MASK_TOTAL_LEN_TH_8814B 0xfff
#define BIT_TOTAL_LEN_TH_8814B(x)                                              \
	(((x) & BIT_MASK_TOTAL_LEN_TH_8814B) << BIT_SHIFT_TOTAL_LEN_TH_8814B)
#define BITS_TOTAL_LEN_TH_8814B                                                \
	(BIT_MASK_TOTAL_LEN_TH_8814B << BIT_SHIFT_TOTAL_LEN_TH_8814B)
#define BIT_CLEAR_TOTAL_LEN_TH_8814B(x) ((x) & (~BITS_TOTAL_LEN_TH_8814B))
#define BIT_GET_TOTAL_LEN_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_TOTAL_LEN_TH_8814B) & BIT_MASK_TOTAL_LEN_TH_8814B)
#define BIT_SET_TOTAL_LEN_TH_8814B(x, v)                                       \
	(BIT_CLEAR_TOTAL_LEN_TH_8814B(x) | BIT_TOTAL_LEN_TH_8814B(v))

#define BIT_PRE_TX_CMD_8814B BIT(6)

#define BIT_SHIFT_NUM_SCL_EN_8814B 4
#define BIT_MASK_NUM_SCL_EN_8814B 0x3
#define BIT_NUM_SCL_EN_8814B(x)                                                \
	(((x) & BIT_MASK_NUM_SCL_EN_8814B) << BIT_SHIFT_NUM_SCL_EN_8814B)
#define BITS_NUM_SCL_EN_8814B                                                  \
	(BIT_MASK_NUM_SCL_EN_8814B << BIT_SHIFT_NUM_SCL_EN_8814B)
#define BIT_CLEAR_NUM_SCL_EN_8814B(x) ((x) & (~BITS_NUM_SCL_EN_8814B))
#define BIT_GET_NUM_SCL_EN_8814B(x)                                            \
	(((x) >> BIT_SHIFT_NUM_SCL_EN_8814B) & BIT_MASK_NUM_SCL_EN_8814B)
#define BIT_SET_NUM_SCL_EN_8814B(x, v)                                         \
	(BIT_CLEAR_NUM_SCL_EN_8814B(x) | BIT_NUM_SCL_EN_8814B(v))

#define BIT_BK_EN_8814B BIT(3)
#define BIT_BE_EN_8814B BIT(2)
#define BIT_VI_EN_8814B BIT(1)
#define BIT_VO_EN_8814B BIT(0)

/* 2 REG_PKT_LIFE_TIME_8814B */

#define BIT_SHIFT_PKT_LIFTIME_BEBK_8814B 16
#define BIT_MASK_PKT_LIFTIME_BEBK_8814B 0xffff
#define BIT_PKT_LIFTIME_BEBK_8814B(x)                                          \
	(((x) & BIT_MASK_PKT_LIFTIME_BEBK_8814B)                               \
	 << BIT_SHIFT_PKT_LIFTIME_BEBK_8814B)
#define BITS_PKT_LIFTIME_BEBK_8814B                                            \
	(BIT_MASK_PKT_LIFTIME_BEBK_8814B << BIT_SHIFT_PKT_LIFTIME_BEBK_8814B)
#define BIT_CLEAR_PKT_LIFTIME_BEBK_8814B(x)                                    \
	((x) & (~BITS_PKT_LIFTIME_BEBK_8814B))
#define BIT_GET_PKT_LIFTIME_BEBK_8814B(x)                                      \
	(((x) >> BIT_SHIFT_PKT_LIFTIME_BEBK_8814B) &                           \
	 BIT_MASK_PKT_LIFTIME_BEBK_8814B)
#define BIT_SET_PKT_LIFTIME_BEBK_8814B(x, v)                                   \
	(BIT_CLEAR_PKT_LIFTIME_BEBK_8814B(x) | BIT_PKT_LIFTIME_BEBK_8814B(v))

#define BIT_SHIFT_PKT_LIFTIME_VOVI_8814B 0
#define BIT_MASK_PKT_LIFTIME_VOVI_8814B 0xffff
#define BIT_PKT_LIFTIME_VOVI_8814B(x)                                          \
	(((x) & BIT_MASK_PKT_LIFTIME_VOVI_8814B)                               \
	 << BIT_SHIFT_PKT_LIFTIME_VOVI_8814B)
#define BITS_PKT_LIFTIME_VOVI_8814B                                            \
	(BIT_MASK_PKT_LIFTIME_VOVI_8814B << BIT_SHIFT_PKT_LIFTIME_VOVI_8814B)
#define BIT_CLEAR_PKT_LIFTIME_VOVI_8814B(x)                                    \
	((x) & (~BITS_PKT_LIFTIME_VOVI_8814B))
#define BIT_GET_PKT_LIFTIME_VOVI_8814B(x)                                      \
	(((x) >> BIT_SHIFT_PKT_LIFTIME_VOVI_8814B) &                           \
	 BIT_MASK_PKT_LIFTIME_VOVI_8814B)
#define BIT_SET_PKT_LIFTIME_VOVI_8814B(x, v)                                   \
	(BIT_CLEAR_PKT_LIFTIME_VOVI_8814B(x) | BIT_PKT_LIFTIME_VOVI_8814B(v))

/* 2 REG_STBC_SETTING_8814B */

#define BIT_SHIFT_CDEND_TXTIME_L_8814B 4
#define BIT_MASK_CDEND_TXTIME_L_8814B 0xf
#define BIT_CDEND_TXTIME_L_8814B(x)                                            \
	(((x) & BIT_MASK_CDEND_TXTIME_L_8814B)                                 \
	 << BIT_SHIFT_CDEND_TXTIME_L_8814B)
#define BITS_CDEND_TXTIME_L_8814B                                              \
	(BIT_MASK_CDEND_TXTIME_L_8814B << BIT_SHIFT_CDEND_TXTIME_L_8814B)
#define BIT_CLEAR_CDEND_TXTIME_L_8814B(x) ((x) & (~BITS_CDEND_TXTIME_L_8814B))
#define BIT_GET_CDEND_TXTIME_L_8814B(x)                                        \
	(((x) >> BIT_SHIFT_CDEND_TXTIME_L_8814B) &                             \
	 BIT_MASK_CDEND_TXTIME_L_8814B)
#define BIT_SET_CDEND_TXTIME_L_8814B(x, v)                                     \
	(BIT_CLEAR_CDEND_TXTIME_L_8814B(x) | BIT_CDEND_TXTIME_L_8814B(v))

#define BIT_SHIFT_NESS_8814B 2
#define BIT_MASK_NESS_8814B 0x3
#define BIT_NESS_8814B(x) (((x) & BIT_MASK_NESS_8814B) << BIT_SHIFT_NESS_8814B)
#define BITS_NESS_8814B (BIT_MASK_NESS_8814B << BIT_SHIFT_NESS_8814B)
#define BIT_CLEAR_NESS_8814B(x) ((x) & (~BITS_NESS_8814B))
#define BIT_GET_NESS_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_NESS_8814B) & BIT_MASK_NESS_8814B)
#define BIT_SET_NESS_8814B(x, v) (BIT_CLEAR_NESS_8814B(x) | BIT_NESS_8814B(v))

#define BIT_SHIFT_STBC_CFEND_8814B 0
#define BIT_MASK_STBC_CFEND_8814B 0x3
#define BIT_STBC_CFEND_8814B(x)                                                \
	(((x) & BIT_MASK_STBC_CFEND_8814B) << BIT_SHIFT_STBC_CFEND_8814B)
#define BITS_STBC_CFEND_8814B                                                  \
	(BIT_MASK_STBC_CFEND_8814B << BIT_SHIFT_STBC_CFEND_8814B)
#define BIT_CLEAR_STBC_CFEND_8814B(x) ((x) & (~BITS_STBC_CFEND_8814B))
#define BIT_GET_STBC_CFEND_8814B(x)                                            \
	(((x) >> BIT_SHIFT_STBC_CFEND_8814B) & BIT_MASK_STBC_CFEND_8814B)
#define BIT_SET_STBC_CFEND_8814B(x, v)                                         \
	(BIT_CLEAR_STBC_CFEND_8814B(x) | BIT_STBC_CFEND_8814B(v))

/* 2 REG_STBC_SETTING2_8814B */

#define BIT_SHIFT_CDEND_TXTIME_H_8814B 0
#define BIT_MASK_CDEND_TXTIME_H_8814B 0x1f
#define BIT_CDEND_TXTIME_H_8814B(x)                                            \
	(((x) & BIT_MASK_CDEND_TXTIME_H_8814B)                                 \
	 << BIT_SHIFT_CDEND_TXTIME_H_8814B)
#define BITS_CDEND_TXTIME_H_8814B                                              \
	(BIT_MASK_CDEND_TXTIME_H_8814B << BIT_SHIFT_CDEND_TXTIME_H_8814B)
#define BIT_CLEAR_CDEND_TXTIME_H_8814B(x) ((x) & (~BITS_CDEND_TXTIME_H_8814B))
#define BIT_GET_CDEND_TXTIME_H_8814B(x)                                        \
	(((x) >> BIT_SHIFT_CDEND_TXTIME_H_8814B) &                             \
	 BIT_MASK_CDEND_TXTIME_H_8814B)
#define BIT_SET_CDEND_TXTIME_H_8814B(x, v)                                     \
	(BIT_CLEAR_CDEND_TXTIME_H_8814B(x) | BIT_CDEND_TXTIME_H_8814B(v))

/* 2 REG_QUEUE_CTRL_8814B */
#define BIT_FORCE_RND_PRI_8814B BIT(6)
#define BIT_PTA_EDCCA_EN_8814B BIT(5)
#define BIT_PTA_WL_TX_EN_8814B BIT(4)
#define BIT_USE_DATA_BW_8814B BIT(3)
#define BIT_TRI_PKT_INT_MODE1_8814B BIT(2)
#define BIT_TRI_PKT_INT_MODE0_8814B BIT(1)
#define BIT_ACQ_MODE_SEL_8814B BIT(0)

/* 2 REG_SINGLE_AMPDU_CTRL_8814B */
#define BIT_EN_SINGLE_APMDU_8814B BIT(7)

/* 2 REG_PROT_MODE_CTRL_8814B */

#define BIT_SHIFT_RTS_MAX_AGG_NUM_8814B 24
#define BIT_MASK_RTS_MAX_AGG_NUM_8814B 0x3f
#define BIT_RTS_MAX_AGG_NUM_8814B(x)                                           \
	(((x) & BIT_MASK_RTS_MAX_AGG_NUM_8814B)                                \
	 << BIT_SHIFT_RTS_MAX_AGG_NUM_8814B)
#define BITS_RTS_MAX_AGG_NUM_8814B                                             \
	(BIT_MASK_RTS_MAX_AGG_NUM_8814B << BIT_SHIFT_RTS_MAX_AGG_NUM_8814B)
#define BIT_CLEAR_RTS_MAX_AGG_NUM_8814B(x) ((x) & (~BITS_RTS_MAX_AGG_NUM_8814B))
#define BIT_GET_RTS_MAX_AGG_NUM_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RTS_MAX_AGG_NUM_8814B) &                            \
	 BIT_MASK_RTS_MAX_AGG_NUM_8814B)
#define BIT_SET_RTS_MAX_AGG_NUM_8814B(x, v)                                    \
	(BIT_CLEAR_RTS_MAX_AGG_NUM_8814B(x) | BIT_RTS_MAX_AGG_NUM_8814B(v))

#define BIT_SHIFT_MAX_AGG_NUM_8814B 16
#define BIT_MASK_MAX_AGG_NUM_8814B 0x3f
#define BIT_MAX_AGG_NUM_8814B(x)                                               \
	(((x) & BIT_MASK_MAX_AGG_NUM_8814B) << BIT_SHIFT_MAX_AGG_NUM_8814B)
#define BITS_MAX_AGG_NUM_8814B                                                 \
	(BIT_MASK_MAX_AGG_NUM_8814B << BIT_SHIFT_MAX_AGG_NUM_8814B)
#define BIT_CLEAR_MAX_AGG_NUM_8814B(x) ((x) & (~BITS_MAX_AGG_NUM_8814B))
#define BIT_GET_MAX_AGG_NUM_8814B(x)                                           \
	(((x) >> BIT_SHIFT_MAX_AGG_NUM_8814B) & BIT_MASK_MAX_AGG_NUM_8814B)
#define BIT_SET_MAX_AGG_NUM_8814B(x, v)                                        \
	(BIT_CLEAR_MAX_AGG_NUM_8814B(x) | BIT_MAX_AGG_NUM_8814B(v))

#define BIT_SHIFT_RTS_TXTIME_TH_8814B 8
#define BIT_MASK_RTS_TXTIME_TH_8814B 0xff
#define BIT_RTS_TXTIME_TH_8814B(x)                                             \
	(((x) & BIT_MASK_RTS_TXTIME_TH_8814B) << BIT_SHIFT_RTS_TXTIME_TH_8814B)
#define BITS_RTS_TXTIME_TH_8814B                                               \
	(BIT_MASK_RTS_TXTIME_TH_8814B << BIT_SHIFT_RTS_TXTIME_TH_8814B)
#define BIT_CLEAR_RTS_TXTIME_TH_8814B(x) ((x) & (~BITS_RTS_TXTIME_TH_8814B))
#define BIT_GET_RTS_TXTIME_TH_8814B(x)                                         \
	(((x) >> BIT_SHIFT_RTS_TXTIME_TH_8814B) & BIT_MASK_RTS_TXTIME_TH_8814B)
#define BIT_SET_RTS_TXTIME_TH_8814B(x, v)                                      \
	(BIT_CLEAR_RTS_TXTIME_TH_8814B(x) | BIT_RTS_TXTIME_TH_8814B(v))

#define BIT_SHIFT_RTS_LEN_TH_8814B 0
#define BIT_MASK_RTS_LEN_TH_8814B 0xff
#define BIT_RTS_LEN_TH_8814B(x)                                                \
	(((x) & BIT_MASK_RTS_LEN_TH_8814B) << BIT_SHIFT_RTS_LEN_TH_8814B)
#define BITS_RTS_LEN_TH_8814B                                                  \
	(BIT_MASK_RTS_LEN_TH_8814B << BIT_SHIFT_RTS_LEN_TH_8814B)
#define BIT_CLEAR_RTS_LEN_TH_8814B(x) ((x) & (~BITS_RTS_LEN_TH_8814B))
#define BIT_GET_RTS_LEN_TH_8814B(x)                                            \
	(((x) >> BIT_SHIFT_RTS_LEN_TH_8814B) & BIT_MASK_RTS_LEN_TH_8814B)
#define BIT_SET_RTS_LEN_TH_8814B(x, v)                                         \
	(BIT_CLEAR_RTS_LEN_TH_8814B(x) | BIT_RTS_LEN_TH_8814B(v))

/* 2 REG_BAR_MODE_CTRL_8814B */

#define BIT_SHIFT_BAR_RTY_LMT_8814B 16
#define BIT_MASK_BAR_RTY_LMT_8814B 0x3
#define BIT_BAR_RTY_LMT_8814B(x)                                               \
	(((x) & BIT_MASK_BAR_RTY_LMT_8814B) << BIT_SHIFT_BAR_RTY_LMT_8814B)
#define BITS_BAR_RTY_LMT_8814B                                                 \
	(BIT_MASK_BAR_RTY_LMT_8814B << BIT_SHIFT_BAR_RTY_LMT_8814B)
#define BIT_CLEAR_BAR_RTY_LMT_8814B(x) ((x) & (~BITS_BAR_RTY_LMT_8814B))
#define BIT_GET_BAR_RTY_LMT_8814B(x)                                           \
	(((x) >> BIT_SHIFT_BAR_RTY_LMT_8814B) & BIT_MASK_BAR_RTY_LMT_8814B)
#define BIT_SET_BAR_RTY_LMT_8814B(x, v)                                        \
	(BIT_CLEAR_BAR_RTY_LMT_8814B(x) | BIT_BAR_RTY_LMT_8814B(v))

#define BIT_SHIFT_BAR_PKT_TXTIME_TH_8814B 8
#define BIT_MASK_BAR_PKT_TXTIME_TH_8814B 0xff
#define BIT_BAR_PKT_TXTIME_TH_8814B(x)                                         \
	(((x) & BIT_MASK_BAR_PKT_TXTIME_TH_8814B)                              \
	 << BIT_SHIFT_BAR_PKT_TXTIME_TH_8814B)
#define BITS_BAR_PKT_TXTIME_TH_8814B                                           \
	(BIT_MASK_BAR_PKT_TXTIME_TH_8814B << BIT_SHIFT_BAR_PKT_TXTIME_TH_8814B)
#define BIT_CLEAR_BAR_PKT_TXTIME_TH_8814B(x)                                   \
	((x) & (~BITS_BAR_PKT_TXTIME_TH_8814B))
#define BIT_GET_BAR_PKT_TXTIME_TH_8814B(x)                                     \
	(((x) >> BIT_SHIFT_BAR_PKT_TXTIME_TH_8814B) &                          \
	 BIT_MASK_BAR_PKT_TXTIME_TH_8814B)
#define BIT_SET_BAR_PKT_TXTIME_TH_8814B(x, v)                                  \
	(BIT_CLEAR_BAR_PKT_TXTIME_TH_8814B(x) | BIT_BAR_PKT_TXTIME_TH_8814B(v))

#define BIT_BAR_EN_V1_8814B BIT(6)

#define BIT_SHIFT_BAR_PKTNUM_TH_V1_8814B 0
#define BIT_MASK_BAR_PKTNUM_TH_V1_8814B 0x3f
#define BIT_BAR_PKTNUM_TH_V1_8814B(x)                                          \
	(((x) & BIT_MASK_BAR_PKTNUM_TH_V1_8814B)                               \
	 << BIT_SHIFT_BAR_PKTNUM_TH_V1_8814B)
#define BITS_BAR_PKTNUM_TH_V1_8814B                                            \
	(BIT_MASK_BAR_PKTNUM_TH_V1_8814B << BIT_SHIFT_BAR_PKTNUM_TH_V1_8814B)
#define BIT_CLEAR_BAR_PKTNUM_TH_V1_8814B(x)                                    \
	((x) & (~BITS_BAR_PKTNUM_TH_V1_8814B))
#define BIT_GET_BAR_PKTNUM_TH_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BAR_PKTNUM_TH_V1_8814B) &                           \
	 BIT_MASK_BAR_PKTNUM_TH_V1_8814B)
#define BIT_SET_BAR_PKTNUM_TH_V1_8814B(x, v)                                   \
	(BIT_CLEAR_BAR_PKTNUM_TH_V1_8814B(x) | BIT_BAR_PKTNUM_TH_V1_8814B(v))

/* 2 REG_RA_TRY_RATE_AGG_LMT_8814B */

#define BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8814B 0
#define BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8814B 0x3f
#define BIT_RA_TRY_RATE_AGG_LMT_V1_8814B(x)                                    \
	(((x) & BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8814B)                         \
	 << BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8814B)
#define BITS_RA_TRY_RATE_AGG_LMT_V1_8814B                                      \
	(BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8814B                                 \
	 << BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8814B)
#define BIT_CLEAR_RA_TRY_RATE_AGG_LMT_V1_8814B(x)                              \
	((x) & (~BITS_RA_TRY_RATE_AGG_LMT_V1_8814B))
#define BIT_GET_RA_TRY_RATE_AGG_LMT_V1_8814B(x)                                \
	(((x) >> BIT_SHIFT_RA_TRY_RATE_AGG_LMT_V1_8814B) &                     \
	 BIT_MASK_RA_TRY_RATE_AGG_LMT_V1_8814B)
#define BIT_SET_RA_TRY_RATE_AGG_LMT_V1_8814B(x, v)                             \
	(BIT_CLEAR_RA_TRY_RATE_AGG_LMT_V1_8814B(x) |                           \
	 BIT_RA_TRY_RATE_AGG_LMT_V1_8814B(v))

/* 2 REG_MACID_SLEEP_CTRL_8814B */

#define BIT_SHIFT_DEBUG_PROTOCOL_8814B 24
#define BIT_MASK_DEBUG_PROTOCOL_8814B 0xff
#define BIT_DEBUG_PROTOCOL_8814B(x)                                            \
	(((x) & BIT_MASK_DEBUG_PROTOCOL_8814B)                                 \
	 << BIT_SHIFT_DEBUG_PROTOCOL_8814B)
#define BITS_DEBUG_PROTOCOL_8814B                                              \
	(BIT_MASK_DEBUG_PROTOCOL_8814B << BIT_SHIFT_DEBUG_PROTOCOL_8814B)
#define BIT_CLEAR_DEBUG_PROTOCOL_8814B(x) ((x) & (~BITS_DEBUG_PROTOCOL_8814B))
#define BIT_GET_DEBUG_PROTOCOL_8814B(x)                                        \
	(((x) >> BIT_SHIFT_DEBUG_PROTOCOL_8814B) &                             \
	 BIT_MASK_DEBUG_PROTOCOL_8814B)
#define BIT_SET_DEBUG_PROTOCOL_8814B(x, v)                                     \
	(BIT_CLEAR_DEBUG_PROTOCOL_8814B(x) | BIT_DEBUG_PROTOCOL_8814B(v))

#define BIT_SHIFT_BCNQ_PGBNDY_RSEL_8814B 16
#define BIT_MASK_BCNQ_PGBNDY_RSEL_8814B 0x7
#define BIT_BCNQ_PGBNDY_RSEL_8814B(x)                                          \
	(((x) & BIT_MASK_BCNQ_PGBNDY_RSEL_8814B)                               \
	 << BIT_SHIFT_BCNQ_PGBNDY_RSEL_8814B)
#define BITS_BCNQ_PGBNDY_RSEL_8814B                                            \
	(BIT_MASK_BCNQ_PGBNDY_RSEL_8814B << BIT_SHIFT_BCNQ_PGBNDY_RSEL_8814B)
#define BIT_CLEAR_BCNQ_PGBNDY_RSEL_8814B(x)                                    \
	((x) & (~BITS_BCNQ_PGBNDY_RSEL_8814B))
#define BIT_GET_BCNQ_PGBNDY_RSEL_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BCNQ_PGBNDY_RSEL_8814B) &                           \
	 BIT_MASK_BCNQ_PGBNDY_RSEL_8814B)
#define BIT_SET_BCNQ_PGBNDY_RSEL_8814B(x, v)                                   \
	(BIT_CLEAR_BCNQ_PGBNDY_RSEL_8814B(x) | BIT_BCNQ_PGBNDY_RSEL_8814B(v))

#define BIT_SHIFT_MACID_SLEEP_SEL_8814B 0
#define BIT_MASK_MACID_SLEEP_SEL_8814B 0x7
#define BIT_MACID_SLEEP_SEL_8814B(x)                                           \
	(((x) & BIT_MASK_MACID_SLEEP_SEL_8814B)                                \
	 << BIT_SHIFT_MACID_SLEEP_SEL_8814B)
#define BITS_MACID_SLEEP_SEL_8814B                                             \
	(BIT_MASK_MACID_SLEEP_SEL_8814B << BIT_SHIFT_MACID_SLEEP_SEL_8814B)
#define BIT_CLEAR_MACID_SLEEP_SEL_8814B(x) ((x) & (~BITS_MACID_SLEEP_SEL_8814B))
#define BIT_GET_MACID_SLEEP_SEL_8814B(x)                                       \
	(((x) >> BIT_SHIFT_MACID_SLEEP_SEL_8814B) &                            \
	 BIT_MASK_MACID_SLEEP_SEL_8814B)
#define BIT_SET_MACID_SLEEP_SEL_8814B(x, v)                                    \
	(BIT_CLEAR_MACID_SLEEP_SEL_8814B(x) | BIT_MACID_SLEEP_SEL_8814B(v))

/* 2 REG_MACID_SLEEP_INFO_8814B */

#define BIT_SHIFT_MACID_SLEEP_INFO_8814B 0
#define BIT_MASK_MACID_SLEEP_INFO_8814B 0xffffffffL
#define BIT_MACID_SLEEP_INFO_8814B(x)                                          \
	(((x) & BIT_MASK_MACID_SLEEP_INFO_8814B)                               \
	 << BIT_SHIFT_MACID_SLEEP_INFO_8814B)
#define BITS_MACID_SLEEP_INFO_8814B                                            \
	(BIT_MASK_MACID_SLEEP_INFO_8814B << BIT_SHIFT_MACID_SLEEP_INFO_8814B)
#define BIT_CLEAR_MACID_SLEEP_INFO_8814B(x)                                    \
	((x) & (~BITS_MACID_SLEEP_INFO_8814B))
#define BIT_GET_MACID_SLEEP_INFO_8814B(x)                                      \
	(((x) >> BIT_SHIFT_MACID_SLEEP_INFO_8814B) &                           \
	 BIT_MASK_MACID_SLEEP_INFO_8814B)
#define BIT_SET_MACID_SLEEP_INFO_8814B(x, v)                                   \
	(BIT_CLEAR_MACID_SLEEP_INFO_8814B(x) | BIT_MACID_SLEEP_INFO_8814B(v))

/* 2 REG_HW_SEQ0_8814B */

#define BIT_SHIFT_HW_SSN_SEQ0_8814B 0
#define BIT_MASK_HW_SSN_SEQ0_8814B 0xfff
#define BIT_HW_SSN_SEQ0_8814B(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ0_8814B) << BIT_SHIFT_HW_SSN_SEQ0_8814B)
#define BITS_HW_SSN_SEQ0_8814B                                                 \
	(BIT_MASK_HW_SSN_SEQ0_8814B << BIT_SHIFT_HW_SSN_SEQ0_8814B)
#define BIT_CLEAR_HW_SSN_SEQ0_8814B(x) ((x) & (~BITS_HW_SSN_SEQ0_8814B))
#define BIT_GET_HW_SSN_SEQ0_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ0_8814B) & BIT_MASK_HW_SSN_SEQ0_8814B)
#define BIT_SET_HW_SSN_SEQ0_8814B(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ0_8814B(x) | BIT_HW_SSN_SEQ0_8814B(v))

/* 2 REG_HW_SEQ1_8814B */

#define BIT_SHIFT_HW_SSN_SEQ1_8814B 0
#define BIT_MASK_HW_SSN_SEQ1_8814B 0xfff
#define BIT_HW_SSN_SEQ1_8814B(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ1_8814B) << BIT_SHIFT_HW_SSN_SEQ1_8814B)
#define BITS_HW_SSN_SEQ1_8814B                                                 \
	(BIT_MASK_HW_SSN_SEQ1_8814B << BIT_SHIFT_HW_SSN_SEQ1_8814B)
#define BIT_CLEAR_HW_SSN_SEQ1_8814B(x) ((x) & (~BITS_HW_SSN_SEQ1_8814B))
#define BIT_GET_HW_SSN_SEQ1_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ1_8814B) & BIT_MASK_HW_SSN_SEQ1_8814B)
#define BIT_SET_HW_SSN_SEQ1_8814B(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ1_8814B(x) | BIT_HW_SSN_SEQ1_8814B(v))

/* 2 REG_HW_SEQ2_8814B */

#define BIT_SHIFT_HW_SSN_SEQ2_8814B 0
#define BIT_MASK_HW_SSN_SEQ2_8814B 0xfff
#define BIT_HW_SSN_SEQ2_8814B(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ2_8814B) << BIT_SHIFT_HW_SSN_SEQ2_8814B)
#define BITS_HW_SSN_SEQ2_8814B                                                 \
	(BIT_MASK_HW_SSN_SEQ2_8814B << BIT_SHIFT_HW_SSN_SEQ2_8814B)
#define BIT_CLEAR_HW_SSN_SEQ2_8814B(x) ((x) & (~BITS_HW_SSN_SEQ2_8814B))
#define BIT_GET_HW_SSN_SEQ2_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ2_8814B) & BIT_MASK_HW_SSN_SEQ2_8814B)
#define BIT_SET_HW_SSN_SEQ2_8814B(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ2_8814B(x) | BIT_HW_SSN_SEQ2_8814B(v))

/* 2 REG_HW_SEQ3_8814B */

#define BIT_SHIFT_CSI_HWSEQ_SEL_8814B 12
#define BIT_MASK_CSI_HWSEQ_SEL_8814B 0x3
#define BIT_CSI_HWSEQ_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_CSI_HWSEQ_SEL_8814B) << BIT_SHIFT_CSI_HWSEQ_SEL_8814B)
#define BITS_CSI_HWSEQ_SEL_8814B                                               \
	(BIT_MASK_CSI_HWSEQ_SEL_8814B << BIT_SHIFT_CSI_HWSEQ_SEL_8814B)
#define BIT_CLEAR_CSI_HWSEQ_SEL_8814B(x) ((x) & (~BITS_CSI_HWSEQ_SEL_8814B))
#define BIT_GET_CSI_HWSEQ_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_CSI_HWSEQ_SEL_8814B) & BIT_MASK_CSI_HWSEQ_SEL_8814B)
#define BIT_SET_CSI_HWSEQ_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_CSI_HWSEQ_SEL_8814B(x) | BIT_CSI_HWSEQ_SEL_8814B(v))

#define BIT_SHIFT_HW_SSN_SEQ3_8814B 0
#define BIT_MASK_HW_SSN_SEQ3_8814B 0xfff
#define BIT_HW_SSN_SEQ3_8814B(x)                                               \
	(((x) & BIT_MASK_HW_SSN_SEQ3_8814B) << BIT_SHIFT_HW_SSN_SEQ3_8814B)
#define BITS_HW_SSN_SEQ3_8814B                                                 \
	(BIT_MASK_HW_SSN_SEQ3_8814B << BIT_SHIFT_HW_SSN_SEQ3_8814B)
#define BIT_CLEAR_HW_SSN_SEQ3_8814B(x) ((x) & (~BITS_HW_SSN_SEQ3_8814B))
#define BIT_GET_HW_SSN_SEQ3_8814B(x)                                           \
	(((x) >> BIT_SHIFT_HW_SSN_SEQ3_8814B) & BIT_MASK_HW_SSN_SEQ3_8814B)
#define BIT_SET_HW_SSN_SEQ3_8814B(x, v)                                        \
	(BIT_CLEAR_HW_SSN_SEQ3_8814B(x) | BIT_HW_SSN_SEQ3_8814B(v))

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_PTCL_TOTAL_PG_V3_8814B 0
#define BIT_MASK_PTCL_TOTAL_PG_V3_8814B 0x1fff
#define BIT_PTCL_TOTAL_PG_V3_8814B(x)                                          \
	(((x) & BIT_MASK_PTCL_TOTAL_PG_V3_8814B)                               \
	 << BIT_SHIFT_PTCL_TOTAL_PG_V3_8814B)
#define BITS_PTCL_TOTAL_PG_V3_8814B                                            \
	(BIT_MASK_PTCL_TOTAL_PG_V3_8814B << BIT_SHIFT_PTCL_TOTAL_PG_V3_8814B)
#define BIT_CLEAR_PTCL_TOTAL_PG_V3_8814B(x)                                    \
	((x) & (~BITS_PTCL_TOTAL_PG_V3_8814B))
#define BIT_GET_PTCL_TOTAL_PG_V3_8814B(x)                                      \
	(((x) >> BIT_SHIFT_PTCL_TOTAL_PG_V3_8814B) &                           \
	 BIT_MASK_PTCL_TOTAL_PG_V3_8814B)
#define BIT_SET_PTCL_TOTAL_PG_V3_8814B(x, v)                                   \
	(BIT_CLEAR_PTCL_TOTAL_PG_V3_8814B(x) | BIT_PTCL_TOTAL_PG_V3_8814B(v))

/* 2 REG_PTCL_ERR_STATUS_V1_8814B */
#define BIT_MUARB_SEARCH_ERR_8814B BIT(14)
#define BIT_MU_BFEN_ERR_8814B BIT(12)
#define BIT_NDPA_DROPNULL_ERR_8814B BIT(11)
#define BIT_NDPA_DROPPKT_ERR_8814B BIT(10)
#define BIT_PTCL_PKYIN_ERR_8814B BIT(9)
#define BIT_PTCL_QSELCNL_ERR_8814B BIT(8)
#define BIT_PTCL_RATE_TABLE_INVALID_8814B BIT(7)
#define BIT_FTM_T2R_ERROR_8814B BIT(6)
#define BIT_TXTIMEOUT_ERR_8814B BIT(5)
#define BIT_NULLPAGE_ERR_8814B BIT(4)
#define BIT_CONTENTION_ERR_8814B BIT(3)
#define BIT_HEADNULL_ERR_8814B BIT(2)
#define BIT_OVERFLOW_ERR_8814B BIT(1)
#define BIT_QUEUE_INDEX_ERR_8814B BIT(0)

/* 2 REG_NULL_PKT_STATUS_V2_8814B */
#define BIT_HIQ_DROP_8814B BIT(7)
#define BIT_MGQ_DROP_8814B BIT(6)
#define BIT_TX_NULL_1_V1_8814B BIT(1)
#define BIT_TX_NULL_0_V1_8814B BIT(0)

/* 2 REG_PRECNT_CTRL_8814B */
#define BIT_EN_PRECNT_8814B BIT(11)

#define BIT_SHIFT_PRECNT_TH_8814B 0
#define BIT_MASK_PRECNT_TH_8814B 0x7ff
#define BIT_PRECNT_TH_8814B(x)                                                 \
	(((x) & BIT_MASK_PRECNT_TH_8814B) << BIT_SHIFT_PRECNT_TH_8814B)
#define BITS_PRECNT_TH_8814B                                                   \
	(BIT_MASK_PRECNT_TH_8814B << BIT_SHIFT_PRECNT_TH_8814B)
#define BIT_CLEAR_PRECNT_TH_8814B(x) ((x) & (~BITS_PRECNT_TH_8814B))
#define BIT_GET_PRECNT_TH_8814B(x)                                             \
	(((x) >> BIT_SHIFT_PRECNT_TH_8814B) & BIT_MASK_PRECNT_TH_8814B)
#define BIT_SET_PRECNT_TH_8814B(x, v)                                          \
	(BIT_CLEAR_PRECNT_TH_8814B(x) | BIT_PRECNT_TH_8814B(v))

/* 2 REG_NULL_PKT_STATUS_EXTEND_V1_8814B */
#define BIT_CLI3_TX_NULL_1_V1_8814B BIT(7)
#define BIT_CLI3_TX_NULL_0_V1_8814B BIT(6)
#define BIT_CLI2_TX_NULL_1_V1_8814B BIT(5)
#define BIT_CLI2_TX_NULL_0_V1_8814B BIT(4)
#define BIT_CLI1_TX_NULL_1_V1_8814B BIT(3)
#define BIT_CLI1_TX_NULL_0_V1_8814B BIT(2)
#define BIT_CLI0_TX_NULL_1_V1_8814B BIT(1)
#define BIT_CLI0_TX_NULL_0_V1_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_PTCL_DBG_V1_8814B */

#define BIT_SHIFT_PTCL_DBG_8814B 0
#define BIT_MASK_PTCL_DBG_8814B 0xffffffffL
#define BIT_PTCL_DBG_8814B(x)                                                  \
	(((x) & BIT_MASK_PTCL_DBG_8814B) << BIT_SHIFT_PTCL_DBG_8814B)
#define BITS_PTCL_DBG_8814B                                                    \
	(BIT_MASK_PTCL_DBG_8814B << BIT_SHIFT_PTCL_DBG_8814B)
#define BIT_CLEAR_PTCL_DBG_8814B(x) ((x) & (~BITS_PTCL_DBG_8814B))
#define BIT_GET_PTCL_DBG_8814B(x)                                              \
	(((x) >> BIT_SHIFT_PTCL_DBG_8814B) & BIT_MASK_PTCL_DBG_8814B)
#define BIT_SET_PTCL_DBG_8814B(x, v)                                           \
	(BIT_CLEAR_PTCL_DBG_8814B(x) | BIT_PTCL_DBG_8814B(v))

/* 2 REG_BT_POLLUTE_PKTCNT_8814B */

#define BIT_SHIFT_BT_POLLUTE_PKTCNT_8814B 0
#define BIT_MASK_BT_POLLUTE_PKTCNT_8814B 0xffff
#define BIT_BT_POLLUTE_PKTCNT_8814B(x)                                         \
	(((x) & BIT_MASK_BT_POLLUTE_PKTCNT_8814B)                              \
	 << BIT_SHIFT_BT_POLLUTE_PKTCNT_8814B)
#define BITS_BT_POLLUTE_PKTCNT_8814B                                           \
	(BIT_MASK_BT_POLLUTE_PKTCNT_8814B << BIT_SHIFT_BT_POLLUTE_PKTCNT_8814B)
#define BIT_CLEAR_BT_POLLUTE_PKTCNT_8814B(x)                                   \
	((x) & (~BITS_BT_POLLUTE_PKTCNT_8814B))
#define BIT_GET_BT_POLLUTE_PKTCNT_8814B(x)                                     \
	(((x) >> BIT_SHIFT_BT_POLLUTE_PKTCNT_8814B) &                          \
	 BIT_MASK_BT_POLLUTE_PKTCNT_8814B)
#define BIT_SET_BT_POLLUTE_PKTCNT_8814B(x, v)                                  \
	(BIT_CLEAR_BT_POLLUTE_PKTCNT_8814B(x) | BIT_BT_POLLUTE_PKTCNT_8814B(v))

/* 2 REG_CPUMGQ_TIMER_CTRL2_8814B */

#define BIT_SHIFT_TRI_HEAD_ADDR_8814B 16
#define BIT_MASK_TRI_HEAD_ADDR_8814B 0xfff
#define BIT_TRI_HEAD_ADDR_8814B(x)                                             \
	(((x) & BIT_MASK_TRI_HEAD_ADDR_8814B) << BIT_SHIFT_TRI_HEAD_ADDR_8814B)
#define BITS_TRI_HEAD_ADDR_8814B                                               \
	(BIT_MASK_TRI_HEAD_ADDR_8814B << BIT_SHIFT_TRI_HEAD_ADDR_8814B)
#define BIT_CLEAR_TRI_HEAD_ADDR_8814B(x) ((x) & (~BITS_TRI_HEAD_ADDR_8814B))
#define BIT_GET_TRI_HEAD_ADDR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TRI_HEAD_ADDR_8814B) & BIT_MASK_TRI_HEAD_ADDR_8814B)
#define BIT_SET_TRI_HEAD_ADDR_8814B(x, v)                                      \
	(BIT_CLEAR_TRI_HEAD_ADDR_8814B(x) | BIT_TRI_HEAD_ADDR_8814B(v))

#define BIT_DROP_TH_EN_8814B BIT(8)

#define BIT_SHIFT_DROP_TH_8814B 0
#define BIT_MASK_DROP_TH_8814B 0xff
#define BIT_DROP_TH_8814B(x)                                                   \
	(((x) & BIT_MASK_DROP_TH_8814B) << BIT_SHIFT_DROP_TH_8814B)
#define BITS_DROP_TH_8814B (BIT_MASK_DROP_TH_8814B << BIT_SHIFT_DROP_TH_8814B)
#define BIT_CLEAR_DROP_TH_8814B(x) ((x) & (~BITS_DROP_TH_8814B))
#define BIT_GET_DROP_TH_8814B(x)                                               \
	(((x) >> BIT_SHIFT_DROP_TH_8814B) & BIT_MASK_DROP_TH_8814B)
#define BIT_SET_DROP_TH_8814B(x, v)                                            \
	(BIT_CLEAR_DROP_TH_8814B(x) | BIT_DROP_TH_8814B(v))

/* 2 REG_PTCL_DBG_OUT_8814B */

#define BIT_SHIFT_PTCL_DBG_OUT_8814B 0
#define BIT_MASK_PTCL_DBG_OUT_8814B 0xffffffffL
#define BIT_PTCL_DBG_OUT_8814B(x)                                              \
	(((x) & BIT_MASK_PTCL_DBG_OUT_8814B) << BIT_SHIFT_PTCL_DBG_OUT_8814B)
#define BITS_PTCL_DBG_OUT_8814B                                                \
	(BIT_MASK_PTCL_DBG_OUT_8814B << BIT_SHIFT_PTCL_DBG_OUT_8814B)
#define BIT_CLEAR_PTCL_DBG_OUT_8814B(x) ((x) & (~BITS_PTCL_DBG_OUT_8814B))
#define BIT_GET_PTCL_DBG_OUT_8814B(x)                                          \
	(((x) >> BIT_SHIFT_PTCL_DBG_OUT_8814B) & BIT_MASK_PTCL_DBG_OUT_8814B)
#define BIT_SET_PTCL_DBG_OUT_8814B(x, v)                                       \
	(BIT_CLEAR_PTCL_DBG_OUT_8814B(x) | BIT_PTCL_DBG_OUT_8814B(v))

/* 2 REG_DUMMY_PAGE4_V1_8814B */

/* 2 REG_DUMMY_PAGE4_1_8814B */

/* 2 REG_MU_OFFSET_8814B */

#define BIT_SHIFT_MU_RATETABLE_OFFSET_8814B 16
#define BIT_MASK_MU_RATETABLE_OFFSET_8814B 0x1ff
#define BIT_MU_RATETABLE_OFFSET_8814B(x)                                       \
	(((x) & BIT_MASK_MU_RATETABLE_OFFSET_8814B)                            \
	 << BIT_SHIFT_MU_RATETABLE_OFFSET_8814B)
#define BITS_MU_RATETABLE_OFFSET_8814B                                         \
	(BIT_MASK_MU_RATETABLE_OFFSET_8814B                                    \
	 << BIT_SHIFT_MU_RATETABLE_OFFSET_8814B)
#define BIT_CLEAR_MU_RATETABLE_OFFSET_8814B(x)                                 \
	((x) & (~BITS_MU_RATETABLE_OFFSET_8814B))
#define BIT_GET_MU_RATETABLE_OFFSET_8814B(x)                                   \
	(((x) >> BIT_SHIFT_MU_RATETABLE_OFFSET_8814B) &                        \
	 BIT_MASK_MU_RATETABLE_OFFSET_8814B)
#define BIT_SET_MU_RATETABLE_OFFSET_8814B(x, v)                                \
	(BIT_CLEAR_MU_RATETABLE_OFFSET_8814B(x) |                              \
	 BIT_MU_RATETABLE_OFFSET_8814B(v))

#define BIT_SHIFT_MU_SCORETABLE_OFFSET_8814B 0
#define BIT_MASK_MU_SCORETABLE_OFFSET_8814B 0x1ff
#define BIT_MU_SCORETABLE_OFFSET_8814B(x)                                      \
	(((x) & BIT_MASK_MU_SCORETABLE_OFFSET_8814B)                           \
	 << BIT_SHIFT_MU_SCORETABLE_OFFSET_8814B)
#define BITS_MU_SCORETABLE_OFFSET_8814B                                        \
	(BIT_MASK_MU_SCORETABLE_OFFSET_8814B                                   \
	 << BIT_SHIFT_MU_SCORETABLE_OFFSET_8814B)
#define BIT_CLEAR_MU_SCORETABLE_OFFSET_8814B(x)                                \
	((x) & (~BITS_MU_SCORETABLE_OFFSET_8814B))
#define BIT_GET_MU_SCORETABLE_OFFSET_8814B(x)                                  \
	(((x) >> BIT_SHIFT_MU_SCORETABLE_OFFSET_8814B) &                       \
	 BIT_MASK_MU_SCORETABLE_OFFSET_8814B)
#define BIT_SET_MU_SCORETABLE_OFFSET_8814B(x, v)                               \
	(BIT_CLEAR_MU_SCORETABLE_OFFSET_8814B(x) |                             \
	 BIT_MU_SCORETABLE_OFFSET_8814B(v))

/* 2 REG_BF0_TIME_SETTING_8814B */
#define BIT_BF0_TIMER_SET_8814B BIT(31)
#define BIT_BF0_TIMER_CLR_8814B BIT(30)
#define BIT_BF0_UPDATE_EN_8814B BIT(29)
#define BIT_BF0_TIMER_EN_8814B BIT(28)

#define BIT_SHIFT_BF0_PRETIME_OVER_8814B 16
#define BIT_MASK_BF0_PRETIME_OVER_8814B 0xfff
#define BIT_BF0_PRETIME_OVER_8814B(x)                                          \
	(((x) & BIT_MASK_BF0_PRETIME_OVER_8814B)                               \
	 << BIT_SHIFT_BF0_PRETIME_OVER_8814B)
#define BITS_BF0_PRETIME_OVER_8814B                                            \
	(BIT_MASK_BF0_PRETIME_OVER_8814B << BIT_SHIFT_BF0_PRETIME_OVER_8814B)
#define BIT_CLEAR_BF0_PRETIME_OVER_8814B(x)                                    \
	((x) & (~BITS_BF0_PRETIME_OVER_8814B))
#define BIT_GET_BF0_PRETIME_OVER_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BF0_PRETIME_OVER_8814B) &                           \
	 BIT_MASK_BF0_PRETIME_OVER_8814B)
#define BIT_SET_BF0_PRETIME_OVER_8814B(x, v)                                   \
	(BIT_CLEAR_BF0_PRETIME_OVER_8814B(x) | BIT_BF0_PRETIME_OVER_8814B(v))

#define BIT_SHIFT_BF0_LIFETIME_8814B 0
#define BIT_MASK_BF0_LIFETIME_8814B 0xffff
#define BIT_BF0_LIFETIME_8814B(x)                                              \
	(((x) & BIT_MASK_BF0_LIFETIME_8814B) << BIT_SHIFT_BF0_LIFETIME_8814B)
#define BITS_BF0_LIFETIME_8814B                                                \
	(BIT_MASK_BF0_LIFETIME_8814B << BIT_SHIFT_BF0_LIFETIME_8814B)
#define BIT_CLEAR_BF0_LIFETIME_8814B(x) ((x) & (~BITS_BF0_LIFETIME_8814B))
#define BIT_GET_BF0_LIFETIME_8814B(x)                                          \
	(((x) >> BIT_SHIFT_BF0_LIFETIME_8814B) & BIT_MASK_BF0_LIFETIME_8814B)
#define BIT_SET_BF0_LIFETIME_8814B(x, v)                                       \
	(BIT_CLEAR_BF0_LIFETIME_8814B(x) | BIT_BF0_LIFETIME_8814B(v))

/* 2 REG_BF1_TIME_SETTING_8814B */
#define BIT_BF1_TIMER_SET_8814B BIT(31)
#define BIT_BF1_TIMER_CLR_8814B BIT(30)
#define BIT_BF1_UPDATE_EN_8814B BIT(29)
#define BIT_BF1_TIMER_EN_8814B BIT(28)

#define BIT_SHIFT_BF1_PRETIME_OVER_8814B 16
#define BIT_MASK_BF1_PRETIME_OVER_8814B 0xfff
#define BIT_BF1_PRETIME_OVER_8814B(x)                                          \
	(((x) & BIT_MASK_BF1_PRETIME_OVER_8814B)                               \
	 << BIT_SHIFT_BF1_PRETIME_OVER_8814B)
#define BITS_BF1_PRETIME_OVER_8814B                                            \
	(BIT_MASK_BF1_PRETIME_OVER_8814B << BIT_SHIFT_BF1_PRETIME_OVER_8814B)
#define BIT_CLEAR_BF1_PRETIME_OVER_8814B(x)                                    \
	((x) & (~BITS_BF1_PRETIME_OVER_8814B))
#define BIT_GET_BF1_PRETIME_OVER_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BF1_PRETIME_OVER_8814B) &                           \
	 BIT_MASK_BF1_PRETIME_OVER_8814B)
#define BIT_SET_BF1_PRETIME_OVER_8814B(x, v)                                   \
	(BIT_CLEAR_BF1_PRETIME_OVER_8814B(x) | BIT_BF1_PRETIME_OVER_8814B(v))

#define BIT_SHIFT_BF1_LIFETIME_8814B 0
#define BIT_MASK_BF1_LIFETIME_8814B 0xffff
#define BIT_BF1_LIFETIME_8814B(x)                                              \
	(((x) & BIT_MASK_BF1_LIFETIME_8814B) << BIT_SHIFT_BF1_LIFETIME_8814B)
#define BITS_BF1_LIFETIME_8814B                                                \
	(BIT_MASK_BF1_LIFETIME_8814B << BIT_SHIFT_BF1_LIFETIME_8814B)
#define BIT_CLEAR_BF1_LIFETIME_8814B(x) ((x) & (~BITS_BF1_LIFETIME_8814B))
#define BIT_GET_BF1_LIFETIME_8814B(x)                                          \
	(((x) >> BIT_SHIFT_BF1_LIFETIME_8814B) & BIT_MASK_BF1_LIFETIME_8814B)
#define BIT_SET_BF1_LIFETIME_8814B(x, v)                                       \
	(BIT_CLEAR_BF1_LIFETIME_8814B(x) | BIT_BF1_LIFETIME_8814B(v))

/* 2 REG_BF_TIMEOUT_EN_8814B */
#define BIT_EN_VHT_LDPC_8814B BIT(9)
#define BIT_EN_HT_LDPC_8814B BIT(8)
#define BIT_BF1_TIMEOUT_EN_8814B BIT(1)
#define BIT_BF0_TIMEOUT_EN_8814B BIT(0)

/* 2 REG_MACID_RELEASE_INFO_8814B */

#define BIT_SHIFT_MACID_RELEASE_INFO_8814B 0
#define BIT_MASK_MACID_RELEASE_INFO_8814B 0xffffffffL
#define BIT_MACID_RELEASE_INFO_8814B(x)                                        \
	(((x) & BIT_MASK_MACID_RELEASE_INFO_8814B)                             \
	 << BIT_SHIFT_MACID_RELEASE_INFO_8814B)
#define BITS_MACID_RELEASE_INFO_8814B                                          \
	(BIT_MASK_MACID_RELEASE_INFO_8814B                                     \
	 << BIT_SHIFT_MACID_RELEASE_INFO_8814B)
#define BIT_CLEAR_MACID_RELEASE_INFO_8814B(x)                                  \
	((x) & (~BITS_MACID_RELEASE_INFO_8814B))
#define BIT_GET_MACID_RELEASE_INFO_8814B(x)                                    \
	(((x) >> BIT_SHIFT_MACID_RELEASE_INFO_8814B) &                         \
	 BIT_MASK_MACID_RELEASE_INFO_8814B)
#define BIT_SET_MACID_RELEASE_INFO_8814B(x, v)                                 \
	(BIT_CLEAR_MACID_RELEASE_INFO_8814B(x) |                               \
	 BIT_MACID_RELEASE_INFO_8814B(v))

/* 2 REG_MACID_RELEASE_SUCCESS_INFO_8814B */

#define BIT_SHIFT_MACID_RELEASE_SUCCESS_INFO_8814B 0
#define BIT_MASK_MACID_RELEASE_SUCCESS_INFO_8814B 0xffffffffL
#define BIT_MACID_RELEASE_SUCCESS_INFO_8814B(x)                                \
	(((x) & BIT_MASK_MACID_RELEASE_SUCCESS_INFO_8814B)                     \
	 << BIT_SHIFT_MACID_RELEASE_SUCCESS_INFO_8814B)
#define BITS_MACID_RELEASE_SUCCESS_INFO_8814B                                  \
	(BIT_MASK_MACID_RELEASE_SUCCESS_INFO_8814B                             \
	 << BIT_SHIFT_MACID_RELEASE_SUCCESS_INFO_8814B)
#define BIT_CLEAR_MACID_RELEASE_SUCCESS_INFO_8814B(x)                          \
	((x) & (~BITS_MACID_RELEASE_SUCCESS_INFO_8814B))
#define BIT_GET_MACID_RELEASE_SUCCESS_INFO_8814B(x)                            \
	(((x) >> BIT_SHIFT_MACID_RELEASE_SUCCESS_INFO_8814B) &                 \
	 BIT_MASK_MACID_RELEASE_SUCCESS_INFO_8814B)
#define BIT_SET_MACID_RELEASE_SUCCESS_INFO_8814B(x, v)                         \
	(BIT_CLEAR_MACID_RELEASE_SUCCESS_INFO_8814B(x) |                       \
	 BIT_MACID_RELEASE_SUCCESS_INFO_8814B(v))

/* 2 REG_MACID_RELEASE_CTRL_8814B */

#define BIT_SHIFT_MACID_RELEASE_SEL_8814B 24
#define BIT_MASK_MACID_RELEASE_SEL_8814B 0x7
#define BIT_MACID_RELEASE_SEL_8814B(x)                                         \
	(((x) & BIT_MASK_MACID_RELEASE_SEL_8814B)                              \
	 << BIT_SHIFT_MACID_RELEASE_SEL_8814B)
#define BITS_MACID_RELEASE_SEL_8814B                                           \
	(BIT_MASK_MACID_RELEASE_SEL_8814B << BIT_SHIFT_MACID_RELEASE_SEL_8814B)
#define BIT_CLEAR_MACID_RELEASE_SEL_8814B(x)                                   \
	((x) & (~BITS_MACID_RELEASE_SEL_8814B))
#define BIT_GET_MACID_RELEASE_SEL_8814B(x)                                     \
	(((x) >> BIT_SHIFT_MACID_RELEASE_SEL_8814B) &                          \
	 BIT_MASK_MACID_RELEASE_SEL_8814B)
#define BIT_SET_MACID_RELEASE_SEL_8814B(x, v)                                  \
	(BIT_CLEAR_MACID_RELEASE_SEL_8814B(x) | BIT_MACID_RELEASE_SEL_8814B(v))

#define BIT_SHIFT_MACID_RELEASE_CLEAR_OFFSET_8814B 16
#define BIT_MASK_MACID_RELEASE_CLEAR_OFFSET_8814B 0xff
#define BIT_MACID_RELEASE_CLEAR_OFFSET_8814B(x)                                \
	(((x) & BIT_MASK_MACID_RELEASE_CLEAR_OFFSET_8814B)                     \
	 << BIT_SHIFT_MACID_RELEASE_CLEAR_OFFSET_8814B)
#define BITS_MACID_RELEASE_CLEAR_OFFSET_8814B                                  \
	(BIT_MASK_MACID_RELEASE_CLEAR_OFFSET_8814B                             \
	 << BIT_SHIFT_MACID_RELEASE_CLEAR_OFFSET_8814B)
#define BIT_CLEAR_MACID_RELEASE_CLEAR_OFFSET_8814B(x)                          \
	((x) & (~BITS_MACID_RELEASE_CLEAR_OFFSET_8814B))
#define BIT_GET_MACID_RELEASE_CLEAR_OFFSET_8814B(x)                            \
	(((x) >> BIT_SHIFT_MACID_RELEASE_CLEAR_OFFSET_8814B) &                 \
	 BIT_MASK_MACID_RELEASE_CLEAR_OFFSET_8814B)
#define BIT_SET_MACID_RELEASE_CLEAR_OFFSET_8814B(x, v)                         \
	(BIT_CLEAR_MACID_RELEASE_CLEAR_OFFSET_8814B(x) |                       \
	 BIT_MACID_RELEASE_CLEAR_OFFSET_8814B(v))

#define BIT_MACID_RELEASE_VALUE_8814B BIT(8)

#define BIT_SHIFT_MACID_RELEASE_OFFSET_8814B 0
#define BIT_MASK_MACID_RELEASE_OFFSET_8814B 0xff
#define BIT_MACID_RELEASE_OFFSET_8814B(x)                                      \
	(((x) & BIT_MASK_MACID_RELEASE_OFFSET_8814B)                           \
	 << BIT_SHIFT_MACID_RELEASE_OFFSET_8814B)
#define BITS_MACID_RELEASE_OFFSET_8814B                                        \
	(BIT_MASK_MACID_RELEASE_OFFSET_8814B                                   \
	 << BIT_SHIFT_MACID_RELEASE_OFFSET_8814B)
#define BIT_CLEAR_MACID_RELEASE_OFFSET_8814B(x)                                \
	((x) & (~BITS_MACID_RELEASE_OFFSET_8814B))
#define BIT_GET_MACID_RELEASE_OFFSET_8814B(x)                                  \
	(((x) >> BIT_SHIFT_MACID_RELEASE_OFFSET_8814B) &                       \
	 BIT_MASK_MACID_RELEASE_OFFSET_8814B)
#define BIT_SET_MACID_RELEASE_OFFSET_8814B(x, v)                               \
	(BIT_CLEAR_MACID_RELEASE_OFFSET_8814B(x) |                             \
	 BIT_MACID_RELEASE_OFFSET_8814B(v))

/* 2 REG_FAST_EDCA_VOVI_SETTING_8814B */

#define BIT_SHIFT_VI_FAST_EDCA_TO_8814B 24
#define BIT_MASK_VI_FAST_EDCA_TO_8814B 0xff
#define BIT_VI_FAST_EDCA_TO_8814B(x)                                           \
	(((x) & BIT_MASK_VI_FAST_EDCA_TO_8814B)                                \
	 << BIT_SHIFT_VI_FAST_EDCA_TO_8814B)
#define BITS_VI_FAST_EDCA_TO_8814B                                             \
	(BIT_MASK_VI_FAST_EDCA_TO_8814B << BIT_SHIFT_VI_FAST_EDCA_TO_8814B)
#define BIT_CLEAR_VI_FAST_EDCA_TO_8814B(x) ((x) & (~BITS_VI_FAST_EDCA_TO_8814B))
#define BIT_GET_VI_FAST_EDCA_TO_8814B(x)                                       \
	(((x) >> BIT_SHIFT_VI_FAST_EDCA_TO_8814B) &                            \
	 BIT_MASK_VI_FAST_EDCA_TO_8814B)
#define BIT_SET_VI_FAST_EDCA_TO_8814B(x, v)                                    \
	(BIT_CLEAR_VI_FAST_EDCA_TO_8814B(x) | BIT_VI_FAST_EDCA_TO_8814B(v))

#define BIT_VI_THRESHOLD_SEL_8814B BIT(23)

#define BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8814B 16
#define BIT_MASK_VI_FAST_EDCA_PKT_TH_8814B 0x7f
#define BIT_VI_FAST_EDCA_PKT_TH_8814B(x)                                       \
	(((x) & BIT_MASK_VI_FAST_EDCA_PKT_TH_8814B)                            \
	 << BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8814B)
#define BITS_VI_FAST_EDCA_PKT_TH_8814B                                         \
	(BIT_MASK_VI_FAST_EDCA_PKT_TH_8814B                                    \
	 << BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8814B)
#define BIT_CLEAR_VI_FAST_EDCA_PKT_TH_8814B(x)                                 \
	((x) & (~BITS_VI_FAST_EDCA_PKT_TH_8814B))
#define BIT_GET_VI_FAST_EDCA_PKT_TH_8814B(x)                                   \
	(((x) >> BIT_SHIFT_VI_FAST_EDCA_PKT_TH_8814B) &                        \
	 BIT_MASK_VI_FAST_EDCA_PKT_TH_8814B)
#define BIT_SET_VI_FAST_EDCA_PKT_TH_8814B(x, v)                                \
	(BIT_CLEAR_VI_FAST_EDCA_PKT_TH_8814B(x) |                              \
	 BIT_VI_FAST_EDCA_PKT_TH_8814B(v))

#define BIT_SHIFT_VO_FAST_EDCA_TO_8814B 8
#define BIT_MASK_VO_FAST_EDCA_TO_8814B 0xff
#define BIT_VO_FAST_EDCA_TO_8814B(x)                                           \
	(((x) & BIT_MASK_VO_FAST_EDCA_TO_8814B)                                \
	 << BIT_SHIFT_VO_FAST_EDCA_TO_8814B)
#define BITS_VO_FAST_EDCA_TO_8814B                                             \
	(BIT_MASK_VO_FAST_EDCA_TO_8814B << BIT_SHIFT_VO_FAST_EDCA_TO_8814B)
#define BIT_CLEAR_VO_FAST_EDCA_TO_8814B(x) ((x) & (~BITS_VO_FAST_EDCA_TO_8814B))
#define BIT_GET_VO_FAST_EDCA_TO_8814B(x)                                       \
	(((x) >> BIT_SHIFT_VO_FAST_EDCA_TO_8814B) &                            \
	 BIT_MASK_VO_FAST_EDCA_TO_8814B)
#define BIT_SET_VO_FAST_EDCA_TO_8814B(x, v)                                    \
	(BIT_CLEAR_VO_FAST_EDCA_TO_8814B(x) | BIT_VO_FAST_EDCA_TO_8814B(v))

#define BIT_VO_THRESHOLD_SEL_8814B BIT(7)

#define BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8814B 0
#define BIT_MASK_VO_FAST_EDCA_PKT_TH_8814B 0x7f
#define BIT_VO_FAST_EDCA_PKT_TH_8814B(x)                                       \
	(((x) & BIT_MASK_VO_FAST_EDCA_PKT_TH_8814B)                            \
	 << BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8814B)
#define BITS_VO_FAST_EDCA_PKT_TH_8814B                                         \
	(BIT_MASK_VO_FAST_EDCA_PKT_TH_8814B                                    \
	 << BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8814B)
#define BIT_CLEAR_VO_FAST_EDCA_PKT_TH_8814B(x)                                 \
	((x) & (~BITS_VO_FAST_EDCA_PKT_TH_8814B))
#define BIT_GET_VO_FAST_EDCA_PKT_TH_8814B(x)                                   \
	(((x) >> BIT_SHIFT_VO_FAST_EDCA_PKT_TH_8814B) &                        \
	 BIT_MASK_VO_FAST_EDCA_PKT_TH_8814B)
#define BIT_SET_VO_FAST_EDCA_PKT_TH_8814B(x, v)                                \
	(BIT_CLEAR_VO_FAST_EDCA_PKT_TH_8814B(x) |                              \
	 BIT_VO_FAST_EDCA_PKT_TH_8814B(v))

/* 2 REG_FAST_EDCA_BEBK_SETTING_8814B */

#define BIT_SHIFT_BK_FAST_EDCA_TO_8814B 24
#define BIT_MASK_BK_FAST_EDCA_TO_8814B 0xff
#define BIT_BK_FAST_EDCA_TO_8814B(x)                                           \
	(((x) & BIT_MASK_BK_FAST_EDCA_TO_8814B)                                \
	 << BIT_SHIFT_BK_FAST_EDCA_TO_8814B)
#define BITS_BK_FAST_EDCA_TO_8814B                                             \
	(BIT_MASK_BK_FAST_EDCA_TO_8814B << BIT_SHIFT_BK_FAST_EDCA_TO_8814B)
#define BIT_CLEAR_BK_FAST_EDCA_TO_8814B(x) ((x) & (~BITS_BK_FAST_EDCA_TO_8814B))
#define BIT_GET_BK_FAST_EDCA_TO_8814B(x)                                       \
	(((x) >> BIT_SHIFT_BK_FAST_EDCA_TO_8814B) &                            \
	 BIT_MASK_BK_FAST_EDCA_TO_8814B)
#define BIT_SET_BK_FAST_EDCA_TO_8814B(x, v)                                    \
	(BIT_CLEAR_BK_FAST_EDCA_TO_8814B(x) | BIT_BK_FAST_EDCA_TO_8814B(v))

#define BIT_BK_THRESHOLD_SEL_8814B BIT(23)

#define BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8814B 16
#define BIT_MASK_BK_FAST_EDCA_PKT_TH_8814B 0x7f
#define BIT_BK_FAST_EDCA_PKT_TH_8814B(x)                                       \
	(((x) & BIT_MASK_BK_FAST_EDCA_PKT_TH_8814B)                            \
	 << BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8814B)
#define BITS_BK_FAST_EDCA_PKT_TH_8814B                                         \
	(BIT_MASK_BK_FAST_EDCA_PKT_TH_8814B                                    \
	 << BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8814B)
#define BIT_CLEAR_BK_FAST_EDCA_PKT_TH_8814B(x)                                 \
	((x) & (~BITS_BK_FAST_EDCA_PKT_TH_8814B))
#define BIT_GET_BK_FAST_EDCA_PKT_TH_8814B(x)                                   \
	(((x) >> BIT_SHIFT_BK_FAST_EDCA_PKT_TH_8814B) &                        \
	 BIT_MASK_BK_FAST_EDCA_PKT_TH_8814B)
#define BIT_SET_BK_FAST_EDCA_PKT_TH_8814B(x, v)                                \
	(BIT_CLEAR_BK_FAST_EDCA_PKT_TH_8814B(x) |                              \
	 BIT_BK_FAST_EDCA_PKT_TH_8814B(v))

#define BIT_SHIFT_BE_FAST_EDCA_TO_8814B 8
#define BIT_MASK_BE_FAST_EDCA_TO_8814B 0xff
#define BIT_BE_FAST_EDCA_TO_8814B(x)                                           \
	(((x) & BIT_MASK_BE_FAST_EDCA_TO_8814B)                                \
	 << BIT_SHIFT_BE_FAST_EDCA_TO_8814B)
#define BITS_BE_FAST_EDCA_TO_8814B                                             \
	(BIT_MASK_BE_FAST_EDCA_TO_8814B << BIT_SHIFT_BE_FAST_EDCA_TO_8814B)
#define BIT_CLEAR_BE_FAST_EDCA_TO_8814B(x) ((x) & (~BITS_BE_FAST_EDCA_TO_8814B))
#define BIT_GET_BE_FAST_EDCA_TO_8814B(x)                                       \
	(((x) >> BIT_SHIFT_BE_FAST_EDCA_TO_8814B) &                            \
	 BIT_MASK_BE_FAST_EDCA_TO_8814B)
#define BIT_SET_BE_FAST_EDCA_TO_8814B(x, v)                                    \
	(BIT_CLEAR_BE_FAST_EDCA_TO_8814B(x) | BIT_BE_FAST_EDCA_TO_8814B(v))

#define BIT_BE_THRESHOLD_SEL_8814B BIT(7)

#define BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8814B 0
#define BIT_MASK_BE_FAST_EDCA_PKT_TH_8814B 0x7f
#define BIT_BE_FAST_EDCA_PKT_TH_8814B(x)                                       \
	(((x) & BIT_MASK_BE_FAST_EDCA_PKT_TH_8814B)                            \
	 << BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8814B)
#define BITS_BE_FAST_EDCA_PKT_TH_8814B                                         \
	(BIT_MASK_BE_FAST_EDCA_PKT_TH_8814B                                    \
	 << BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8814B)
#define BIT_CLEAR_BE_FAST_EDCA_PKT_TH_8814B(x)                                 \
	((x) & (~BITS_BE_FAST_EDCA_PKT_TH_8814B))
#define BIT_GET_BE_FAST_EDCA_PKT_TH_8814B(x)                                   \
	(((x) >> BIT_SHIFT_BE_FAST_EDCA_PKT_TH_8814B) &                        \
	 BIT_MASK_BE_FAST_EDCA_PKT_TH_8814B)
#define BIT_SET_BE_FAST_EDCA_PKT_TH_8814B(x, v)                                \
	(BIT_CLEAR_BE_FAST_EDCA_PKT_TH_8814B(x) |                              \
	 BIT_BE_FAST_EDCA_PKT_TH_8814B(v))

/* 2 REG_MACID_DROP_INFO_8814B */

#define BIT_SHIFT_MACID_DROP_INFO_8814B 0
#define BIT_MASK_MACID_DROP_INFO_8814B 0xffffffffL
#define BIT_MACID_DROP_INFO_8814B(x)                                           \
	(((x) & BIT_MASK_MACID_DROP_INFO_8814B)                                \
	 << BIT_SHIFT_MACID_DROP_INFO_8814B)
#define BITS_MACID_DROP_INFO_8814B                                             \
	(BIT_MASK_MACID_DROP_INFO_8814B << BIT_SHIFT_MACID_DROP_INFO_8814B)
#define BIT_CLEAR_MACID_DROP_INFO_8814B(x) ((x) & (~BITS_MACID_DROP_INFO_8814B))
#define BIT_GET_MACID_DROP_INFO_8814B(x)                                       \
	(((x) >> BIT_SHIFT_MACID_DROP_INFO_8814B) &                            \
	 BIT_MASK_MACID_DROP_INFO_8814B)
#define BIT_SET_MACID_DROP_INFO_8814B(x, v)                                    \
	(BIT_CLEAR_MACID_DROP_INFO_8814B(x) | BIT_MACID_DROP_INFO_8814B(v))

/* 2 REG_MACID_DROP_CTRL_8814B */

#define BIT_SHIFT_MACID_DROP_SEL_8814B 0
#define BIT_MASK_MACID_DROP_SEL_8814B 0x7
#define BIT_MACID_DROP_SEL_8814B(x)                                            \
	(((x) & BIT_MASK_MACID_DROP_SEL_8814B)                                 \
	 << BIT_SHIFT_MACID_DROP_SEL_8814B)
#define BITS_MACID_DROP_SEL_8814B                                              \
	(BIT_MASK_MACID_DROP_SEL_8814B << BIT_SHIFT_MACID_DROP_SEL_8814B)
#define BIT_CLEAR_MACID_DROP_SEL_8814B(x) ((x) & (~BITS_MACID_DROP_SEL_8814B))
#define BIT_GET_MACID_DROP_SEL_8814B(x)                                        \
	(((x) >> BIT_SHIFT_MACID_DROP_SEL_8814B) &                             \
	 BIT_MASK_MACID_DROP_SEL_8814B)
#define BIT_SET_MACID_DROP_SEL_8814B(x, v)                                     \
	(BIT_CLEAR_MACID_DROP_SEL_8814B(x) | BIT_MACID_DROP_SEL_8814B(v))

/* 2 REG_MGQ_FIFO_WRITE_POINTER_8814B */
#define BIT_MGQ_FIFO_OV_8814B BIT(7)
#define BIT_MGQ_FIFO_WPTR_ERROR_8814B BIT(6)
#define BIT_EN_MGQ_FIFO_LIFETIME_8814B BIT(5)

#define BIT_SHIFT_MGQ_FIFO_WPTR_8814B 0
#define BIT_MASK_MGQ_FIFO_WPTR_8814B 0x1f
#define BIT_MGQ_FIFO_WPTR_8814B(x)                                             \
	(((x) & BIT_MASK_MGQ_FIFO_WPTR_8814B) << BIT_SHIFT_MGQ_FIFO_WPTR_8814B)
#define BITS_MGQ_FIFO_WPTR_8814B                                               \
	(BIT_MASK_MGQ_FIFO_WPTR_8814B << BIT_SHIFT_MGQ_FIFO_WPTR_8814B)
#define BIT_CLEAR_MGQ_FIFO_WPTR_8814B(x) ((x) & (~BITS_MGQ_FIFO_WPTR_8814B))
#define BIT_GET_MGQ_FIFO_WPTR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_FIFO_WPTR_8814B) & BIT_MASK_MGQ_FIFO_WPTR_8814B)
#define BIT_SET_MGQ_FIFO_WPTR_8814B(x, v)                                      \
	(BIT_CLEAR_MGQ_FIFO_WPTR_8814B(x) | BIT_MGQ_FIFO_WPTR_8814B(v))

/* 2 REG_MGQ_FIFO_READ_POINTER_8814B */

#define BIT_SHIFT_MGQ_FIFO_SIZE_8814B 14
#define BIT_MASK_MGQ_FIFO_SIZE_8814B 0x3
#define BIT_MGQ_FIFO_SIZE_8814B(x)                                             \
	(((x) & BIT_MASK_MGQ_FIFO_SIZE_8814B) << BIT_SHIFT_MGQ_FIFO_SIZE_8814B)
#define BITS_MGQ_FIFO_SIZE_8814B                                               \
	(BIT_MASK_MGQ_FIFO_SIZE_8814B << BIT_SHIFT_MGQ_FIFO_SIZE_8814B)
#define BIT_CLEAR_MGQ_FIFO_SIZE_8814B(x) ((x) & (~BITS_MGQ_FIFO_SIZE_8814B))
#define BIT_GET_MGQ_FIFO_SIZE_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_FIFO_SIZE_8814B) & BIT_MASK_MGQ_FIFO_SIZE_8814B)
#define BIT_SET_MGQ_FIFO_SIZE_8814B(x, v)                                      \
	(BIT_CLEAR_MGQ_FIFO_SIZE_8814B(x) | BIT_MGQ_FIFO_SIZE_8814B(v))

#define BIT_MGQ_FIFO_PAUSE_8814B BIT(13)

#define BIT_SHIFT_MGQ_FIFO_RPTR_8814B 8
#define BIT_MASK_MGQ_FIFO_RPTR_8814B 0x1f
#define BIT_MGQ_FIFO_RPTR_8814B(x)                                             \
	(((x) & BIT_MASK_MGQ_FIFO_RPTR_8814B) << BIT_SHIFT_MGQ_FIFO_RPTR_8814B)
#define BITS_MGQ_FIFO_RPTR_8814B                                               \
	(BIT_MASK_MGQ_FIFO_RPTR_8814B << BIT_SHIFT_MGQ_FIFO_RPTR_8814B)
#define BIT_CLEAR_MGQ_FIFO_RPTR_8814B(x) ((x) & (~BITS_MGQ_FIFO_RPTR_8814B))
#define BIT_GET_MGQ_FIFO_RPTR_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MGQ_FIFO_RPTR_8814B) & BIT_MASK_MGQ_FIFO_RPTR_8814B)
#define BIT_SET_MGQ_FIFO_RPTR_8814B(x, v)                                      \
	(BIT_CLEAR_MGQ_FIFO_RPTR_8814B(x) | BIT_MGQ_FIFO_RPTR_8814B(v))

/* 2 REG_MGQ_FIFO_ENABLE_8814B */
#define BIT_MGQ_FIFO_EN_V1_8814B BIT(15)

#define BIT_SHIFT_MGQ_FIFO_PG_SIZE_8814B 12
#define BIT_MASK_MGQ_FIFO_PG_SIZE_8814B 0x7
#define BIT_MGQ_FIFO_PG_SIZE_8814B(x)                                          \
	(((x) & BIT_MASK_MGQ_FIFO_PG_SIZE_8814B)                               \
	 << BIT_SHIFT_MGQ_FIFO_PG_SIZE_8814B)
#define BITS_MGQ_FIFO_PG_SIZE_8814B                                            \
	(BIT_MASK_MGQ_FIFO_PG_SIZE_8814B << BIT_SHIFT_MGQ_FIFO_PG_SIZE_8814B)
#define BIT_CLEAR_MGQ_FIFO_PG_SIZE_8814B(x)                                    \
	((x) & (~BITS_MGQ_FIFO_PG_SIZE_8814B))
#define BIT_GET_MGQ_FIFO_PG_SIZE_8814B(x)                                      \
	(((x) >> BIT_SHIFT_MGQ_FIFO_PG_SIZE_8814B) &                           \
	 BIT_MASK_MGQ_FIFO_PG_SIZE_8814B)
#define BIT_SET_MGQ_FIFO_PG_SIZE_8814B(x, v)                                   \
	(BIT_CLEAR_MGQ_FIFO_PG_SIZE_8814B(x) | BIT_MGQ_FIFO_PG_SIZE_8814B(v))

#define BIT_SHIFT_MGQ_FIFO_START_PG_8814B 0
#define BIT_MASK_MGQ_FIFO_START_PG_8814B 0xfff
#define BIT_MGQ_FIFO_START_PG_8814B(x)                                         \
	(((x) & BIT_MASK_MGQ_FIFO_START_PG_8814B)                              \
	 << BIT_SHIFT_MGQ_FIFO_START_PG_8814B)
#define BITS_MGQ_FIFO_START_PG_8814B                                           \
	(BIT_MASK_MGQ_FIFO_START_PG_8814B << BIT_SHIFT_MGQ_FIFO_START_PG_8814B)
#define BIT_CLEAR_MGQ_FIFO_START_PG_8814B(x)                                   \
	((x) & (~BITS_MGQ_FIFO_START_PG_8814B))
#define BIT_GET_MGQ_FIFO_START_PG_8814B(x)                                     \
	(((x) >> BIT_SHIFT_MGQ_FIFO_START_PG_8814B) &                          \
	 BIT_MASK_MGQ_FIFO_START_PG_8814B)
#define BIT_SET_MGQ_FIFO_START_PG_8814B(x, v)                                  \
	(BIT_CLEAR_MGQ_FIFO_START_PG_8814B(x) | BIT_MGQ_FIFO_START_PG_8814B(v))

/* 2 REG_MGQ_FIFO_RELEASE_INT_MASK_8814B */

#define BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8814B 0
#define BIT_MASK_MGQ_FIFO_REL_INT_MASK_8814B 0xffff
#define BIT_MGQ_FIFO_REL_INT_MASK_8814B(x)                                     \
	(((x) & BIT_MASK_MGQ_FIFO_REL_INT_MASK_8814B)                          \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8814B)
#define BITS_MGQ_FIFO_REL_INT_MASK_8814B                                       \
	(BIT_MASK_MGQ_FIFO_REL_INT_MASK_8814B                                  \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8814B)
#define BIT_CLEAR_MGQ_FIFO_REL_INT_MASK_8814B(x)                               \
	((x) & (~BITS_MGQ_FIFO_REL_INT_MASK_8814B))
#define BIT_GET_MGQ_FIFO_REL_INT_MASK_8814B(x)                                 \
	(((x) >> BIT_SHIFT_MGQ_FIFO_REL_INT_MASK_8814B) &                      \
	 BIT_MASK_MGQ_FIFO_REL_INT_MASK_8814B)
#define BIT_SET_MGQ_FIFO_REL_INT_MASK_8814B(x, v)                              \
	(BIT_CLEAR_MGQ_FIFO_REL_INT_MASK_8814B(x) |                            \
	 BIT_MGQ_FIFO_REL_INT_MASK_8814B(v))

/* 2 REG_MGQ_FIFO_RELEASE_INT_FLAG_8814B */

#define BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8814B 0
#define BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8814B 0xffff
#define BIT_MGQ_FIFO_REL_INT_FLAG_8814B(x)                                     \
	(((x) & BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8814B)                          \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8814B)
#define BITS_MGQ_FIFO_REL_INT_FLAG_8814B                                       \
	(BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8814B                                  \
	 << BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8814B)
#define BIT_CLEAR_MGQ_FIFO_REL_INT_FLAG_8814B(x)                               \
	((x) & (~BITS_MGQ_FIFO_REL_INT_FLAG_8814B))
#define BIT_GET_MGQ_FIFO_REL_INT_FLAG_8814B(x)                                 \
	(((x) >> BIT_SHIFT_MGQ_FIFO_REL_INT_FLAG_8814B) &                      \
	 BIT_MASK_MGQ_FIFO_REL_INT_FLAG_8814B)
#define BIT_SET_MGQ_FIFO_REL_INT_FLAG_8814B(x, v)                              \
	(BIT_CLEAR_MGQ_FIFO_REL_INT_FLAG_8814B(x) |                            \
	 BIT_MGQ_FIFO_REL_INT_FLAG_8814B(v))

/* 2 REG_MGQ_FIFO_VALID_MAP_8814B */

#define BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8814B 0
#define BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8814B 0xffff
#define BIT_MGQ_FIFO_PKT_VALID_MAP_8814B(x)                                    \
	(((x) & BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8814B)                         \
	 << BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8814B)
#define BITS_MGQ_FIFO_PKT_VALID_MAP_8814B                                      \
	(BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8814B                                 \
	 << BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8814B)
#define BIT_CLEAR_MGQ_FIFO_PKT_VALID_MAP_8814B(x)                              \
	((x) & (~BITS_MGQ_FIFO_PKT_VALID_MAP_8814B))
#define BIT_GET_MGQ_FIFO_PKT_VALID_MAP_8814B(x)                                \
	(((x) >> BIT_SHIFT_MGQ_FIFO_PKT_VALID_MAP_8814B) &                     \
	 BIT_MASK_MGQ_FIFO_PKT_VALID_MAP_8814B)
#define BIT_SET_MGQ_FIFO_PKT_VALID_MAP_8814B(x, v)                             \
	(BIT_CLEAR_MGQ_FIFO_PKT_VALID_MAP_8814B(x) |                           \
	 BIT_MGQ_FIFO_PKT_VALID_MAP_8814B(v))

/* 2 REG_MGQ_FIFO_LIFETIME_8814B */

#define BIT_SHIFT_MGQ_FIFO_LIFETIME_8814B 0
#define BIT_MASK_MGQ_FIFO_LIFETIME_8814B 0xffff
#define BIT_MGQ_FIFO_LIFETIME_8814B(x)                                         \
	(((x) & BIT_MASK_MGQ_FIFO_LIFETIME_8814B)                              \
	 << BIT_SHIFT_MGQ_FIFO_LIFETIME_8814B)
#define BITS_MGQ_FIFO_LIFETIME_8814B                                           \
	(BIT_MASK_MGQ_FIFO_LIFETIME_8814B << BIT_SHIFT_MGQ_FIFO_LIFETIME_8814B)
#define BIT_CLEAR_MGQ_FIFO_LIFETIME_8814B(x)                                   \
	((x) & (~BITS_MGQ_FIFO_LIFETIME_8814B))
#define BIT_GET_MGQ_FIFO_LIFETIME_8814B(x)                                     \
	(((x) >> BIT_SHIFT_MGQ_FIFO_LIFETIME_8814B) &                          \
	 BIT_MASK_MGQ_FIFO_LIFETIME_8814B)
#define BIT_SET_MGQ_FIFO_LIFETIME_8814B(x, v)                                  \
	(BIT_CLEAR_MGQ_FIFO_LIFETIME_8814B(x) | BIT_MGQ_FIFO_LIFETIME_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_PKT_TRANS_8814B */

#define BIT_SHIFT_IE_DESC_OFFSET_8814B 16
#define BIT_MASK_IE_DESC_OFFSET_8814B 0x1ff
#define BIT_IE_DESC_OFFSET_8814B(x)                                            \
	(((x) & BIT_MASK_IE_DESC_OFFSET_8814B)                                 \
	 << BIT_SHIFT_IE_DESC_OFFSET_8814B)
#define BITS_IE_DESC_OFFSET_8814B                                              \
	(BIT_MASK_IE_DESC_OFFSET_8814B << BIT_SHIFT_IE_DESC_OFFSET_8814B)
#define BIT_CLEAR_IE_DESC_OFFSET_8814B(x) ((x) & (~BITS_IE_DESC_OFFSET_8814B))
#define BIT_GET_IE_DESC_OFFSET_8814B(x)                                        \
	(((x) >> BIT_SHIFT_IE_DESC_OFFSET_8814B) &                             \
	 BIT_MASK_IE_DESC_OFFSET_8814B)
#define BIT_SET_IE_DESC_OFFSET_8814B(x, v)                                     \
	(BIT_CLEAR_IE_DESC_OFFSET_8814B(x) | BIT_IE_DESC_OFFSET_8814B(v))

#define BIT_DIS_FWCMD_PATH_ERRCHK_8814B BIT(13)
#define BIT_MAC_HDR_CONVERT_EN_8814B BIT(12)
#define BIT_TXDESC_TRANS_EN_8814B BIT(8)
#define BIT_PKT_TRANS_ERRINT_EN_8814B BIT(7)

#define BIT_SHIFT_PKT_TRANS_ERR_MACID_SEL_8814B 4
#define BIT_MASK_PKT_TRANS_ERR_MACID_SEL_8814B 0x3
#define BIT_PKT_TRANS_ERR_MACID_SEL_8814B(x)                                   \
	(((x) & BIT_MASK_PKT_TRANS_ERR_MACID_SEL_8814B)                        \
	 << BIT_SHIFT_PKT_TRANS_ERR_MACID_SEL_8814B)
#define BITS_PKT_TRANS_ERR_MACID_SEL_8814B                                     \
	(BIT_MASK_PKT_TRANS_ERR_MACID_SEL_8814B                                \
	 << BIT_SHIFT_PKT_TRANS_ERR_MACID_SEL_8814B)
#define BIT_CLEAR_PKT_TRANS_ERR_MACID_SEL_8814B(x)                             \
	((x) & (~BITS_PKT_TRANS_ERR_MACID_SEL_8814B))
#define BIT_GET_PKT_TRANS_ERR_MACID_SEL_8814B(x)                               \
	(((x) >> BIT_SHIFT_PKT_TRANS_ERR_MACID_SEL_8814B) &                    \
	 BIT_MASK_PKT_TRANS_ERR_MACID_SEL_8814B)
#define BIT_SET_PKT_TRANS_ERR_MACID_SEL_8814B(x, v)                            \
	(BIT_CLEAR_PKT_TRANS_ERR_MACID_SEL_8814B(x) |                          \
	 BIT_PKT_TRANS_ERR_MACID_SEL_8814B(v))

#define BIT_PKT_TRANS_IEINIT_ERR_8814B BIT(3)
#define BIT_PKT_TRANS_IENUM_ERR_8814B BIT(2)
#define BIT_PKT_TRANS_IECNT_ERR1_8814B BIT(1)
#define BIT_PKT_TRANS_IECNT_ERR0_8814B BIT(0)

/* 2 REG_SHCUT_LLC_ETH_TYPE0_8814B */

/* 2 REG_SHCUT_LLC_ETH_TYPE1_8814B */

#define BIT_SHIFT_SHCUT_MHDR_OFFSET_8814B 16
#define BIT_MASK_SHCUT_MHDR_OFFSET_8814B 0x1ff
#define BIT_SHCUT_MHDR_OFFSET_8814B(x)                                         \
	(((x) & BIT_MASK_SHCUT_MHDR_OFFSET_8814B)                              \
	 << BIT_SHIFT_SHCUT_MHDR_OFFSET_8814B)
#define BITS_SHCUT_MHDR_OFFSET_8814B                                           \
	(BIT_MASK_SHCUT_MHDR_OFFSET_8814B << BIT_SHIFT_SHCUT_MHDR_OFFSET_8814B)
#define BIT_CLEAR_SHCUT_MHDR_OFFSET_8814B(x)                                   \
	((x) & (~BITS_SHCUT_MHDR_OFFSET_8814B))
#define BIT_GET_SHCUT_MHDR_OFFSET_8814B(x)                                     \
	(((x) >> BIT_SHIFT_SHCUT_MHDR_OFFSET_8814B) &                          \
	 BIT_MASK_SHCUT_MHDR_OFFSET_8814B)
#define BIT_SET_SHCUT_MHDR_OFFSET_8814B(x, v)                                  \
	(BIT_CLEAR_SHCUT_MHDR_OFFSET_8814B(x) | BIT_SHCUT_MHDR_OFFSET_8814B(v))

/* 2 REG_SHCUT_LLC_OUI0_8814B */

/* 2 REG_SHCUT_LLC_OUI1_8814B */

/* 2 REG_SHCUT_LLC_OUI2_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_PKT_TRANS_ERR_MACID_8814B 0
#define BIT_MASK_PKT_TRANS_ERR_MACID_8814B 0xffffffffL
#define BIT_PKT_TRANS_ERR_MACID_8814B(x)                                       \
	(((x) & BIT_MASK_PKT_TRANS_ERR_MACID_8814B)                            \
	 << BIT_SHIFT_PKT_TRANS_ERR_MACID_8814B)
#define BITS_PKT_TRANS_ERR_MACID_8814B                                         \
	(BIT_MASK_PKT_TRANS_ERR_MACID_8814B                                    \
	 << BIT_SHIFT_PKT_TRANS_ERR_MACID_8814B)
#define BIT_CLEAR_PKT_TRANS_ERR_MACID_8814B(x)                                 \
	((x) & (~BITS_PKT_TRANS_ERR_MACID_8814B))
#define BIT_GET_PKT_TRANS_ERR_MACID_8814B(x)                                   \
	(((x) >> BIT_SHIFT_PKT_TRANS_ERR_MACID_8814B) &                        \
	 BIT_MASK_PKT_TRANS_ERR_MACID_8814B)
#define BIT_SET_PKT_TRANS_ERR_MACID_8814B(x, v)                                \
	(BIT_CLEAR_PKT_TRANS_ERR_MACID_8814B(x) |                              \
	 BIT_PKT_TRANS_ERR_MACID_8814B(v))

/* 2 REG_FWCMDQ_CTRL_8814B */
#define BIT_FW_RELEASEPKT_POLLING_8814B BIT(31)

#define BIT_SHIFT_FWCMDQ_RELEASE_HEAD_8814B 16
#define BIT_MASK_FWCMDQ_RELEASE_HEAD_8814B 0xfff
#define BIT_FWCMDQ_RELEASE_HEAD_8814B(x)                                       \
	(((x) & BIT_MASK_FWCMDQ_RELEASE_HEAD_8814B)                            \
	 << BIT_SHIFT_FWCMDQ_RELEASE_HEAD_8814B)
#define BITS_FWCMDQ_RELEASE_HEAD_8814B                                         \
	(BIT_MASK_FWCMDQ_RELEASE_HEAD_8814B                                    \
	 << BIT_SHIFT_FWCMDQ_RELEASE_HEAD_8814B)
#define BIT_CLEAR_FWCMDQ_RELEASE_HEAD_8814B(x)                                 \
	((x) & (~BITS_FWCMDQ_RELEASE_HEAD_8814B))
#define BIT_GET_FWCMDQ_RELEASE_HEAD_8814B(x)                                   \
	(((x) >> BIT_SHIFT_FWCMDQ_RELEASE_HEAD_8814B) &                        \
	 BIT_MASK_FWCMDQ_RELEASE_HEAD_8814B)
#define BIT_SET_FWCMDQ_RELEASE_HEAD_8814B(x, v)                                \
	(BIT_CLEAR_FWCMDQ_RELEASE_HEAD_8814B(x) |                              \
	 BIT_FWCMDQ_RELEASE_HEAD_8814B(v))

#define BIT_FW_GETPKTT_POLLING_8814B BIT(15)

#define BIT_SHIFT_FWCMDQ_H_8814B 0
#define BIT_MASK_FWCMDQ_H_8814B 0xfff
#define BIT_FWCMDQ_H_8814B(x)                                                  \
	(((x) & BIT_MASK_FWCMDQ_H_8814B) << BIT_SHIFT_FWCMDQ_H_8814B)
#define BITS_FWCMDQ_H_8814B                                                    \
	(BIT_MASK_FWCMDQ_H_8814B << BIT_SHIFT_FWCMDQ_H_8814B)
#define BIT_CLEAR_FWCMDQ_H_8814B(x) ((x) & (~BITS_FWCMDQ_H_8814B))
#define BIT_GET_FWCMDQ_H_8814B(x)                                              \
	(((x) >> BIT_SHIFT_FWCMDQ_H_8814B) & BIT_MASK_FWCMDQ_H_8814B)
#define BIT_SET_FWCMDQ_H_8814B(x, v)                                           \
	(BIT_CLEAR_FWCMDQ_H_8814B(x) | BIT_FWCMDQ_H_8814B(v))

/* 2 REG_FWCMDQ_PAGE_8814B */

#define BIT_SHIFT_FWCMDQ_TOTAL_PAGE_8814B 16
#define BIT_MASK_FWCMDQ_TOTAL_PAGE_8814B 0xfff
#define BIT_FWCMDQ_TOTAL_PAGE_8814B(x)                                         \
	(((x) & BIT_MASK_FWCMDQ_TOTAL_PAGE_8814B)                              \
	 << BIT_SHIFT_FWCMDQ_TOTAL_PAGE_8814B)
#define BITS_FWCMDQ_TOTAL_PAGE_8814B                                           \
	(BIT_MASK_FWCMDQ_TOTAL_PAGE_8814B << BIT_SHIFT_FWCMDQ_TOTAL_PAGE_8814B)
#define BIT_CLEAR_FWCMDQ_TOTAL_PAGE_8814B(x)                                   \
	((x) & (~BITS_FWCMDQ_TOTAL_PAGE_8814B))
#define BIT_GET_FWCMDQ_TOTAL_PAGE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_FWCMDQ_TOTAL_PAGE_8814B) &                          \
	 BIT_MASK_FWCMDQ_TOTAL_PAGE_8814B)
#define BIT_SET_FWCMDQ_TOTAL_PAGE_8814B(x, v)                                  \
	(BIT_CLEAR_FWCMDQ_TOTAL_PAGE_8814B(x) | BIT_FWCMDQ_TOTAL_PAGE_8814B(v))

#define BIT_SHIFT_FWCMDQ_QUEUE_PAGE_8814B 0
#define BIT_MASK_FWCMDQ_QUEUE_PAGE_8814B 0xfff
#define BIT_FWCMDQ_QUEUE_PAGE_8814B(x)                                         \
	(((x) & BIT_MASK_FWCMDQ_QUEUE_PAGE_8814B)                              \
	 << BIT_SHIFT_FWCMDQ_QUEUE_PAGE_8814B)
#define BITS_FWCMDQ_QUEUE_PAGE_8814B                                           \
	(BIT_MASK_FWCMDQ_QUEUE_PAGE_8814B << BIT_SHIFT_FWCMDQ_QUEUE_PAGE_8814B)
#define BIT_CLEAR_FWCMDQ_QUEUE_PAGE_8814B(x)                                   \
	((x) & (~BITS_FWCMDQ_QUEUE_PAGE_8814B))
#define BIT_GET_FWCMDQ_QUEUE_PAGE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_FWCMDQ_QUEUE_PAGE_8814B) &                          \
	 BIT_MASK_FWCMDQ_QUEUE_PAGE_8814B)
#define BIT_SET_FWCMDQ_QUEUE_PAGE_8814B(x, v)                                  \
	(BIT_CLEAR_FWCMDQ_QUEUE_PAGE_8814B(x) | BIT_FWCMDQ_QUEUE_PAGE_8814B(v))

/* 2 REG_FWCMDQ_INFO_8814B */
#define BIT_FWCMD_READY_8814B BIT(31)
#define BIT_FWCMDQ_OVERFLOW_8814B BIT(30)
#define BIT_FWCMDQ_UNDERFLOW_8814B BIT(29)
#define BIT_FWCMDQ_RELEASE_MISS_8814B BIT(28)

#define BIT_SHIFT_FWCMDQ_TOTAL_PKT_8814B 16
#define BIT_MASK_FWCMDQ_TOTAL_PKT_8814B 0xfff
#define BIT_FWCMDQ_TOTAL_PKT_8814B(x)                                          \
	(((x) & BIT_MASK_FWCMDQ_TOTAL_PKT_8814B)                               \
	 << BIT_SHIFT_FWCMDQ_TOTAL_PKT_8814B)
#define BITS_FWCMDQ_TOTAL_PKT_8814B                                            \
	(BIT_MASK_FWCMDQ_TOTAL_PKT_8814B << BIT_SHIFT_FWCMDQ_TOTAL_PKT_8814B)
#define BIT_CLEAR_FWCMDQ_TOTAL_PKT_8814B(x)                                    \
	((x) & (~BITS_FWCMDQ_TOTAL_PKT_8814B))
#define BIT_GET_FWCMDQ_TOTAL_PKT_8814B(x)                                      \
	(((x) >> BIT_SHIFT_FWCMDQ_TOTAL_PKT_8814B) &                           \
	 BIT_MASK_FWCMDQ_TOTAL_PKT_8814B)
#define BIT_SET_FWCMDQ_TOTAL_PKT_8814B(x, v)                                   \
	(BIT_CLEAR_FWCMDQ_TOTAL_PKT_8814B(x) | BIT_FWCMDQ_TOTAL_PKT_8814B(v))

#define BIT_SHIFT_FWCMDQ_QUEUE_PKT_8814B 0
#define BIT_MASK_FWCMDQ_QUEUE_PKT_8814B 0xfff
#define BIT_FWCMDQ_QUEUE_PKT_8814B(x)                                          \
	(((x) & BIT_MASK_FWCMDQ_QUEUE_PKT_8814B)                               \
	 << BIT_SHIFT_FWCMDQ_QUEUE_PKT_8814B)
#define BITS_FWCMDQ_QUEUE_PKT_8814B                                            \
	(BIT_MASK_FWCMDQ_QUEUE_PKT_8814B << BIT_SHIFT_FWCMDQ_QUEUE_PKT_8814B)
#define BIT_CLEAR_FWCMDQ_QUEUE_PKT_8814B(x)                                    \
	((x) & (~BITS_FWCMDQ_QUEUE_PKT_8814B))
#define BIT_GET_FWCMDQ_QUEUE_PKT_8814B(x)                                      \
	(((x) >> BIT_SHIFT_FWCMDQ_QUEUE_PKT_8814B) &                           \
	 BIT_MASK_FWCMDQ_QUEUE_PKT_8814B)
#define BIT_SET_FWCMDQ_QUEUE_PKT_8814B(x, v)                                   \
	(BIT_CLEAR_FWCMDQ_QUEUE_PKT_8814B(x) | BIT_FWCMDQ_QUEUE_PKT_8814B(v))

/* 2 REG_FWCMDQ_HOLD_PKTNUM_8814B */

#define BIT_SHIFT_FWCMDQ_HOLD__PKTNUM_8814B 0
#define BIT_MASK_FWCMDQ_HOLD__PKTNUM_8814B 0xfff
#define BIT_FWCMDQ_HOLD__PKTNUM_8814B(x)                                       \
	(((x) & BIT_MASK_FWCMDQ_HOLD__PKTNUM_8814B)                            \
	 << BIT_SHIFT_FWCMDQ_HOLD__PKTNUM_8814B)
#define BITS_FWCMDQ_HOLD__PKTNUM_8814B                                         \
	(BIT_MASK_FWCMDQ_HOLD__PKTNUM_8814B                                    \
	 << BIT_SHIFT_FWCMDQ_HOLD__PKTNUM_8814B)
#define BIT_CLEAR_FWCMDQ_HOLD__PKTNUM_8814B(x)                                 \
	((x) & (~BITS_FWCMDQ_HOLD__PKTNUM_8814B))
#define BIT_GET_FWCMDQ_HOLD__PKTNUM_8814B(x)                                   \
	(((x) >> BIT_SHIFT_FWCMDQ_HOLD__PKTNUM_8814B) &                        \
	 BIT_MASK_FWCMDQ_HOLD__PKTNUM_8814B)
#define BIT_SET_FWCMDQ_HOLD__PKTNUM_8814B(x, v)                                \
	(BIT_CLEAR_FWCMDQ_HOLD__PKTNUM_8814B(x) |                              \
	 BIT_FWCMDQ_HOLD__PKTNUM_8814B(v))

/* 2 REG_MU_TX_CTRL_8814B */
#define BIT_SEARCH_DONE_RDY_8814B BIT(31)
#define BIT_MU_EN_8814B BIT(30)
#define BIT_MU_SECONDARY_WAITMODE_EN_8814B BIT(29)
#define BIT_MU_BB_SCORE_EN_8814B BIT(28)
#define BIT_MU_SECONDARY_ANT_COUNT_EN_8814B BIT(27)
#define BIT_MUARB_SEARCH_ERR_EN_8814B BIT(26)

#define BIT_SHIFT_DIS_SU_TXBF_8814B 16
#define BIT_MASK_DIS_SU_TXBF_8814B 0x3f
#define BIT_DIS_SU_TXBF_8814B(x)                                               \
	(((x) & BIT_MASK_DIS_SU_TXBF_8814B) << BIT_SHIFT_DIS_SU_TXBF_8814B)
#define BITS_DIS_SU_TXBF_8814B                                                 \
	(BIT_MASK_DIS_SU_TXBF_8814B << BIT_SHIFT_DIS_SU_TXBF_8814B)
#define BIT_CLEAR_DIS_SU_TXBF_8814B(x) ((x) & (~BITS_DIS_SU_TXBF_8814B))
#define BIT_GET_DIS_SU_TXBF_8814B(x)                                           \
	(((x) >> BIT_SHIFT_DIS_SU_TXBF_8814B) & BIT_MASK_DIS_SU_TXBF_8814B)
#define BIT_SET_DIS_SU_TXBF_8814B(x, v)                                        \
	(BIT_CLEAR_DIS_SU_TXBF_8814B(x) | BIT_DIS_SU_TXBF_8814B(v))

#define BIT_SHIFT_MU_RL_8814B 12
#define BIT_MASK_MU_RL_8814B 0xf
#define BIT_MU_RL_8814B(x)                                                     \
	(((x) & BIT_MASK_MU_RL_8814B) << BIT_SHIFT_MU_RL_8814B)
#define BITS_MU_RL_8814B (BIT_MASK_MU_RL_8814B << BIT_SHIFT_MU_RL_8814B)
#define BIT_CLEAR_MU_RL_8814B(x) ((x) & (~BITS_MU_RL_8814B))
#define BIT_GET_MU_RL_8814B(x)                                                 \
	(((x) >> BIT_SHIFT_MU_RL_8814B) & BIT_MASK_MU_RL_8814B)
#define BIT_SET_MU_RL_8814B(x, v)                                              \
	(BIT_CLEAR_MU_RL_8814B(x) | BIT_MU_RL_8814B(v))

#define BIT_SHIFT_MU_TAB_SEL_8814B 8
#define BIT_MASK_MU_TAB_SEL_8814B 0xf
#define BIT_MU_TAB_SEL_8814B(x)                                                \
	(((x) & BIT_MASK_MU_TAB_SEL_8814B) << BIT_SHIFT_MU_TAB_SEL_8814B)
#define BITS_MU_TAB_SEL_8814B                                                  \
	(BIT_MASK_MU_TAB_SEL_8814B << BIT_SHIFT_MU_TAB_SEL_8814B)
#define BIT_CLEAR_MU_TAB_SEL_8814B(x) ((x) & (~BITS_MU_TAB_SEL_8814B))
#define BIT_GET_MU_TAB_SEL_8814B(x)                                            \
	(((x) >> BIT_SHIFT_MU_TAB_SEL_8814B) & BIT_MASK_MU_TAB_SEL_8814B)
#define BIT_SET_MU_TAB_SEL_8814B(x, v)                                         \
	(BIT_CLEAR_MU_TAB_SEL_8814B(x) | BIT_MU_TAB_SEL_8814B(v))

#define BIT_SHIFT_MU_TAB_VALID_8814B 0
#define BIT_MASK_MU_TAB_VALID_8814B 0x3f
#define BIT_MU_TAB_VALID_8814B(x)                                              \
	(((x) & BIT_MASK_MU_TAB_VALID_8814B) << BIT_SHIFT_MU_TAB_VALID_8814B)
#define BITS_MU_TAB_VALID_8814B                                                \
	(BIT_MASK_MU_TAB_VALID_8814B << BIT_SHIFT_MU_TAB_VALID_8814B)
#define BIT_CLEAR_MU_TAB_VALID_8814B(x) ((x) & (~BITS_MU_TAB_VALID_8814B))
#define BIT_GET_MU_TAB_VALID_8814B(x)                                          \
	(((x) >> BIT_SHIFT_MU_TAB_VALID_8814B) & BIT_MASK_MU_TAB_VALID_8814B)
#define BIT_SET_MU_TAB_VALID_8814B(x, v)                                       \
	(BIT_CLEAR_MU_TAB_VALID_8814B(x) | BIT_MU_TAB_VALID_8814B(v))

/* 2 REG_MU_STA_GID_VLD_8814B */

#define BIT_SHIFT_MU_STA_GTAB_VALID_8814B 0
#define BIT_MASK_MU_STA_GTAB_VALID_8814B 0xffffffffL
#define BIT_MU_STA_GTAB_VALID_8814B(x)                                         \
	(((x) & BIT_MASK_MU_STA_GTAB_VALID_8814B)                              \
	 << BIT_SHIFT_MU_STA_GTAB_VALID_8814B)
#define BITS_MU_STA_GTAB_VALID_8814B                                           \
	(BIT_MASK_MU_STA_GTAB_VALID_8814B << BIT_SHIFT_MU_STA_GTAB_VALID_8814B)
#define BIT_CLEAR_MU_STA_GTAB_VALID_8814B(x)                                   \
	((x) & (~BITS_MU_STA_GTAB_VALID_8814B))
#define BIT_GET_MU_STA_GTAB_VALID_8814B(x)                                     \
	(((x) >> BIT_SHIFT_MU_STA_GTAB_VALID_8814B) &                          \
	 BIT_MASK_MU_STA_GTAB_VALID_8814B)
#define BIT_SET_MU_STA_GTAB_VALID_8814B(x, v)                                  \
	(BIT_CLEAR_MU_STA_GTAB_VALID_8814B(x) | BIT_MU_STA_GTAB_VALID_8814B(v))

/* 2 REG_MU_STA_USER_POS_INFO_8814B */

#define BIT_SHIFT_MU_STA_GTAB_POSITION_L_8814B 0
#define BIT_MASK_MU_STA_GTAB_POSITION_L_8814B 0xffffffffL
#define BIT_MU_STA_GTAB_POSITION_L_8814B(x)                                    \
	(((x) & BIT_MASK_MU_STA_GTAB_POSITION_L_8814B)                         \
	 << BIT_SHIFT_MU_STA_GTAB_POSITION_L_8814B)
#define BITS_MU_STA_GTAB_POSITION_L_8814B                                      \
	(BIT_MASK_MU_STA_GTAB_POSITION_L_8814B                                 \
	 << BIT_SHIFT_MU_STA_GTAB_POSITION_L_8814B)
#define BIT_CLEAR_MU_STA_GTAB_POSITION_L_8814B(x)                              \
	((x) & (~BITS_MU_STA_GTAB_POSITION_L_8814B))
#define BIT_GET_MU_STA_GTAB_POSITION_L_8814B(x)                                \
	(((x) >> BIT_SHIFT_MU_STA_GTAB_POSITION_L_8814B) &                     \
	 BIT_MASK_MU_STA_GTAB_POSITION_L_8814B)
#define BIT_SET_MU_STA_GTAB_POSITION_L_8814B(x, v)                             \
	(BIT_CLEAR_MU_STA_GTAB_POSITION_L_8814B(x) |                           \
	 BIT_MU_STA_GTAB_POSITION_L_8814B(v))

/* 2 REG_MU_STA_USER_POS_INFO_H_8814B */

#define BIT_SHIFT_MU_STA_GTAB_POSITION_H_8814B 0
#define BIT_MASK_MU_STA_GTAB_POSITION_H_8814B 0xffffffffL
#define BIT_MU_STA_GTAB_POSITION_H_8814B(x)                                    \
	(((x) & BIT_MASK_MU_STA_GTAB_POSITION_H_8814B)                         \
	 << BIT_SHIFT_MU_STA_GTAB_POSITION_H_8814B)
#define BITS_MU_STA_GTAB_POSITION_H_8814B                                      \
	(BIT_MASK_MU_STA_GTAB_POSITION_H_8814B                                 \
	 << BIT_SHIFT_MU_STA_GTAB_POSITION_H_8814B)
#define BIT_CLEAR_MU_STA_GTAB_POSITION_H_8814B(x)                              \
	((x) & (~BITS_MU_STA_GTAB_POSITION_H_8814B))
#define BIT_GET_MU_STA_GTAB_POSITION_H_8814B(x)                                \
	(((x) >> BIT_SHIFT_MU_STA_GTAB_POSITION_H_8814B) &                     \
	 BIT_MASK_MU_STA_GTAB_POSITION_H_8814B)
#define BIT_SET_MU_STA_GTAB_POSITION_H_8814B(x, v)                             \
	(BIT_CLEAR_MU_STA_GTAB_POSITION_H_8814B(x) |                           \
	 BIT_MU_STA_GTAB_POSITION_H_8814B(v))

/* 2 REG_CHNL_INFO_CTRL_8814B */
#define BIT_CHNL_REF_RXNAV_8814B BIT(7)
#define BIT_CHNL_REF_VBON_8814B BIT(6)
#define BIT_CHNL_REF_EDCA_8814B BIT(5)
#define BIT_CHNL_REF_CCA_8814B BIT(4)
#define BIT_RST_CHNL_BUSY_8814B BIT(3)
#define BIT_RST_CHNL_IDLE_8814B BIT(2)
#define BIT_CHNL_INFO_RST_8814B BIT(1)
#define BIT_ATM_AIRTIME_EN_8814B BIT(0)

/* 2 REG_CHNL_IDLE_TIME_8814B */

#define BIT_SHIFT_CHNL_IDLE_TIME_8814B 0
#define BIT_MASK_CHNL_IDLE_TIME_8814B 0xffffffffL
#define BIT_CHNL_IDLE_TIME_8814B(x)                                            \
	(((x) & BIT_MASK_CHNL_IDLE_TIME_8814B)                                 \
	 << BIT_SHIFT_CHNL_IDLE_TIME_8814B)
#define BITS_CHNL_IDLE_TIME_8814B                                              \
	(BIT_MASK_CHNL_IDLE_TIME_8814B << BIT_SHIFT_CHNL_IDLE_TIME_8814B)
#define BIT_CLEAR_CHNL_IDLE_TIME_8814B(x) ((x) & (~BITS_CHNL_IDLE_TIME_8814B))
#define BIT_GET_CHNL_IDLE_TIME_8814B(x)                                        \
	(((x) >> BIT_SHIFT_CHNL_IDLE_TIME_8814B) &                             \
	 BIT_MASK_CHNL_IDLE_TIME_8814B)
#define BIT_SET_CHNL_IDLE_TIME_8814B(x, v)                                     \
	(BIT_CLEAR_CHNL_IDLE_TIME_8814B(x) | BIT_CHNL_IDLE_TIME_8814B(v))

/* 2 REG_CHNL_BUSY_TIME_8814B */

#define BIT_SHIFT_CHNL_BUSY_TIME_8814B 0
#define BIT_MASK_CHNL_BUSY_TIME_8814B 0xffffffffL
#define BIT_CHNL_BUSY_TIME_8814B(x)                                            \
	(((x) & BIT_MASK_CHNL_BUSY_TIME_8814B)                                 \
	 << BIT_SHIFT_CHNL_BUSY_TIME_8814B)
#define BITS_CHNL_BUSY_TIME_8814B                                              \
	(BIT_MASK_CHNL_BUSY_TIME_8814B << BIT_SHIFT_CHNL_BUSY_TIME_8814B)
#define BIT_CLEAR_CHNL_BUSY_TIME_8814B(x) ((x) & (~BITS_CHNL_BUSY_TIME_8814B))
#define BIT_GET_CHNL_BUSY_TIME_8814B(x)                                        \
	(((x) >> BIT_SHIFT_CHNL_BUSY_TIME_8814B) &                             \
	 BIT_MASK_CHNL_BUSY_TIME_8814B)
#define BIT_SET_CHNL_BUSY_TIME_8814B(x, v)                                     \
	(BIT_CLEAR_CHNL_BUSY_TIME_8814B(x) | BIT_CHNL_BUSY_TIME_8814B(v))

/* 2 REG_MU_TRX_DBG_CNT_V1_8814B */
#define BIT_FORCE_SND_STS_EN_8814B BIT(31)

#define BIT_SHIFT_SND_STS_VALUE_8814B 24
#define BIT_MASK_SND_STS_VALUE_8814B 0x3f
#define BIT_SND_STS_VALUE_8814B(x)                                             \
	(((x) & BIT_MASK_SND_STS_VALUE_8814B) << BIT_SHIFT_SND_STS_VALUE_8814B)
#define BITS_SND_STS_VALUE_8814B                                               \
	(BIT_MASK_SND_STS_VALUE_8814B << BIT_SHIFT_SND_STS_VALUE_8814B)
#define BIT_CLEAR_SND_STS_VALUE_8814B(x) ((x) & (~BITS_SND_STS_VALUE_8814B))
#define BIT_GET_SND_STS_VALUE_8814B(x)                                         \
	(((x) >> BIT_SHIFT_SND_STS_VALUE_8814B) & BIT_MASK_SND_STS_VALUE_8814B)
#define BIT_SET_SND_STS_VALUE_8814B(x, v)                                      \
	(BIT_CLEAR_SND_STS_VALUE_8814B(x) | BIT_SND_STS_VALUE_8814B(v))

#define BIT_MU_DNGCNT_RST_8814B BIT(20)

#define BIT_SHIFT_MU_DNGCNT_SEL_8814B 16
#define BIT_MASK_MU_DNGCNT_SEL_8814B 0xf
#define BIT_MU_DNGCNT_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_MU_DNGCNT_SEL_8814B) << BIT_SHIFT_MU_DNGCNT_SEL_8814B)
#define BITS_MU_DNGCNT_SEL_8814B                                               \
	(BIT_MASK_MU_DNGCNT_SEL_8814B << BIT_SHIFT_MU_DNGCNT_SEL_8814B)
#define BIT_CLEAR_MU_DNGCNT_SEL_8814B(x) ((x) & (~BITS_MU_DNGCNT_SEL_8814B))
#define BIT_GET_MU_DNGCNT_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MU_DNGCNT_SEL_8814B) & BIT_MASK_MU_DNGCNT_SEL_8814B)
#define BIT_SET_MU_DNGCNT_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_MU_DNGCNT_SEL_8814B(x) | BIT_MU_DNGCNT_SEL_8814B(v))

#define BIT_SHIFT_MU_DNGCNT_8814B 0
#define BIT_MASK_MU_DNGCNT_8814B 0xffff
#define BIT_MU_DNGCNT_8814B(x)                                                 \
	(((x) & BIT_MASK_MU_DNGCNT_8814B) << BIT_SHIFT_MU_DNGCNT_8814B)
#define BITS_MU_DNGCNT_8814B                                                   \
	(BIT_MASK_MU_DNGCNT_8814B << BIT_SHIFT_MU_DNGCNT_8814B)
#define BIT_CLEAR_MU_DNGCNT_8814B(x) ((x) & (~BITS_MU_DNGCNT_8814B))
#define BIT_GET_MU_DNGCNT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_MU_DNGCNT_8814B) & BIT_MASK_MU_DNGCNT_8814B)
#define BIT_SET_MU_DNGCNT_8814B(x, v)                                          \
	(BIT_CLEAR_MU_DNGCNT_8814B(x) | BIT_MU_DNGCNT_8814B(v))

/* 2 REG_SWPS_CTRL_8814B */

#define BIT_SHIFT_SWPS_RPT_LENGTH_8814B 8
#define BIT_MASK_SWPS_RPT_LENGTH_8814B 0x7f
#define BIT_SWPS_RPT_LENGTH_8814B(x)                                           \
	(((x) & BIT_MASK_SWPS_RPT_LENGTH_8814B)                                \
	 << BIT_SHIFT_SWPS_RPT_LENGTH_8814B)
#define BITS_SWPS_RPT_LENGTH_8814B                                             \
	(BIT_MASK_SWPS_RPT_LENGTH_8814B << BIT_SHIFT_SWPS_RPT_LENGTH_8814B)
#define BIT_CLEAR_SWPS_RPT_LENGTH_8814B(x) ((x) & (~BITS_SWPS_RPT_LENGTH_8814B))
#define BIT_GET_SWPS_RPT_LENGTH_8814B(x)                                       \
	(((x) >> BIT_SHIFT_SWPS_RPT_LENGTH_8814B) &                            \
	 BIT_MASK_SWPS_RPT_LENGTH_8814B)
#define BIT_SET_SWPS_RPT_LENGTH_8814B(x, v)                                    \
	(BIT_CLEAR_SWPS_RPT_LENGTH_8814B(x) | BIT_SWPS_RPT_LENGTH_8814B(v))

#define BIT_SHIFT_MACID_SWPS_EN_SEL_8814B 2
#define BIT_MASK_MACID_SWPS_EN_SEL_8814B 0x3
#define BIT_MACID_SWPS_EN_SEL_8814B(x)                                         \
	(((x) & BIT_MASK_MACID_SWPS_EN_SEL_8814B)                              \
	 << BIT_SHIFT_MACID_SWPS_EN_SEL_8814B)
#define BITS_MACID_SWPS_EN_SEL_8814B                                           \
	(BIT_MASK_MACID_SWPS_EN_SEL_8814B << BIT_SHIFT_MACID_SWPS_EN_SEL_8814B)
#define BIT_CLEAR_MACID_SWPS_EN_SEL_8814B(x)                                   \
	((x) & (~BITS_MACID_SWPS_EN_SEL_8814B))
#define BIT_GET_MACID_SWPS_EN_SEL_8814B(x)                                     \
	(((x) >> BIT_SHIFT_MACID_SWPS_EN_SEL_8814B) &                          \
	 BIT_MASK_MACID_SWPS_EN_SEL_8814B)
#define BIT_SET_MACID_SWPS_EN_SEL_8814B(x, v)                                  \
	(BIT_CLEAR_MACID_SWPS_EN_SEL_8814B(x) | BIT_MACID_SWPS_EN_SEL_8814B(v))

#define BIT_SWPS_MANUALL_POLLING_8814B BIT(1)
#define BIT_SWPS_EN_8814B BIT(0)

/* 2 REG_SWPS_PKT_TH_8814B */

#define BIT_SHIFT_SWPS_PKT_TH_8814B 0
#define BIT_MASK_SWPS_PKT_TH_8814B 0xffff
#define BIT_SWPS_PKT_TH_8814B(x)                                               \
	(((x) & BIT_MASK_SWPS_PKT_TH_8814B) << BIT_SHIFT_SWPS_PKT_TH_8814B)
#define BITS_SWPS_PKT_TH_8814B                                                 \
	(BIT_MASK_SWPS_PKT_TH_8814B << BIT_SHIFT_SWPS_PKT_TH_8814B)
#define BIT_CLEAR_SWPS_PKT_TH_8814B(x) ((x) & (~BITS_SWPS_PKT_TH_8814B))
#define BIT_GET_SWPS_PKT_TH_8814B(x)                                           \
	(((x) >> BIT_SHIFT_SWPS_PKT_TH_8814B) & BIT_MASK_SWPS_PKT_TH_8814B)
#define BIT_SET_SWPS_PKT_TH_8814B(x, v)                                        \
	(BIT_CLEAR_SWPS_PKT_TH_8814B(x) | BIT_SWPS_PKT_TH_8814B(v))

/* 2 REG_SWPS_TIME_TH_8814B */

#define BIT_SHIFT_SWPS_PSTIME_TH_8814B 16
#define BIT_MASK_SWPS_PSTIME_TH_8814B 0xffff
#define BIT_SWPS_PSTIME_TH_8814B(x)                                            \
	(((x) & BIT_MASK_SWPS_PSTIME_TH_8814B)                                 \
	 << BIT_SHIFT_SWPS_PSTIME_TH_8814B)
#define BITS_SWPS_PSTIME_TH_8814B                                              \
	(BIT_MASK_SWPS_PSTIME_TH_8814B << BIT_SHIFT_SWPS_PSTIME_TH_8814B)
#define BIT_CLEAR_SWPS_PSTIME_TH_8814B(x) ((x) & (~BITS_SWPS_PSTIME_TH_8814B))
#define BIT_GET_SWPS_PSTIME_TH_8814B(x)                                        \
	(((x) >> BIT_SHIFT_SWPS_PSTIME_TH_8814B) &                             \
	 BIT_MASK_SWPS_PSTIME_TH_8814B)
#define BIT_SET_SWPS_PSTIME_TH_8814B(x, v)                                     \
	(BIT_CLEAR_SWPS_PSTIME_TH_8814B(x) | BIT_SWPS_PSTIME_TH_8814B(v))

#define BIT_SHIFT_SWPS_TIME_TH_8814B 0
#define BIT_MASK_SWPS_TIME_TH_8814B 0xffff
#define BIT_SWPS_TIME_TH_8814B(x)                                              \
	(((x) & BIT_MASK_SWPS_TIME_TH_8814B) << BIT_SHIFT_SWPS_TIME_TH_8814B)
#define BITS_SWPS_TIME_TH_8814B                                                \
	(BIT_MASK_SWPS_TIME_TH_8814B << BIT_SHIFT_SWPS_TIME_TH_8814B)
#define BIT_CLEAR_SWPS_TIME_TH_8814B(x) ((x) & (~BITS_SWPS_TIME_TH_8814B))
#define BIT_GET_SWPS_TIME_TH_8814B(x)                                          \
	(((x) >> BIT_SHIFT_SWPS_TIME_TH_8814B) & BIT_MASK_SWPS_TIME_TH_8814B)
#define BIT_SET_SWPS_TIME_TH_8814B(x, v)                                       \
	(BIT_CLEAR_SWPS_TIME_TH_8814B(x) | BIT_SWPS_TIME_TH_8814B(v))

/* 2 REG_MACID_SWPS_EN_8814B */

#define BIT_SHIFT_MACID_SWPS_EN_8814B 0
#define BIT_MASK_MACID_SWPS_EN_8814B 0xffffffffL
#define BIT_MACID_SWPS_EN_8814B(x)                                             \
	(((x) & BIT_MASK_MACID_SWPS_EN_8814B) << BIT_SHIFT_MACID_SWPS_EN_8814B)
#define BITS_MACID_SWPS_EN_8814B                                               \
	(BIT_MASK_MACID_SWPS_EN_8814B << BIT_SHIFT_MACID_SWPS_EN_8814B)
#define BIT_CLEAR_MACID_SWPS_EN_8814B(x) ((x) & (~BITS_MACID_SWPS_EN_8814B))
#define BIT_GET_MACID_SWPS_EN_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MACID_SWPS_EN_8814B) & BIT_MASK_MACID_SWPS_EN_8814B)
#define BIT_SET_MACID_SWPS_EN_8814B(x, v)                                      \
	(BIT_CLEAR_MACID_SWPS_EN_8814B(x) | BIT_MACID_SWPS_EN_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_EDCA_VO_PARAM_8814B */

#define BIT_SHIFT_TXOPLIMIT_8814B 16
#define BIT_MASK_TXOPLIMIT_8814B 0x7ff
#define BIT_TXOPLIMIT_8814B(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8814B) << BIT_SHIFT_TXOPLIMIT_8814B)
#define BITS_TXOPLIMIT_8814B                                                   \
	(BIT_MASK_TXOPLIMIT_8814B << BIT_SHIFT_TXOPLIMIT_8814B)
#define BIT_CLEAR_TXOPLIMIT_8814B(x) ((x) & (~BITS_TXOPLIMIT_8814B))
#define BIT_GET_TXOPLIMIT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8814B) & BIT_MASK_TXOPLIMIT_8814B)
#define BIT_SET_TXOPLIMIT_8814B(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8814B(x) | BIT_TXOPLIMIT_8814B(v))

#define BIT_SHIFT_CW_8814B 8
#define BIT_MASK_CW_8814B 0xff
#define BIT_CW_8814B(x) (((x) & BIT_MASK_CW_8814B) << BIT_SHIFT_CW_8814B)
#define BITS_CW_8814B (BIT_MASK_CW_8814B << BIT_SHIFT_CW_8814B)
#define BIT_CLEAR_CW_8814B(x) ((x) & (~BITS_CW_8814B))
#define BIT_GET_CW_8814B(x) (((x) >> BIT_SHIFT_CW_8814B) & BIT_MASK_CW_8814B)
#define BIT_SET_CW_8814B(x, v) (BIT_CLEAR_CW_8814B(x) | BIT_CW_8814B(v))

#define BIT_SHIFT_AIFS_8814B 0
#define BIT_MASK_AIFS_8814B 0xff
#define BIT_AIFS_8814B(x) (((x) & BIT_MASK_AIFS_8814B) << BIT_SHIFT_AIFS_8814B)
#define BITS_AIFS_8814B (BIT_MASK_AIFS_8814B << BIT_SHIFT_AIFS_8814B)
#define BIT_CLEAR_AIFS_8814B(x) ((x) & (~BITS_AIFS_8814B))
#define BIT_GET_AIFS_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8814B) & BIT_MASK_AIFS_8814B)
#define BIT_SET_AIFS_8814B(x, v) (BIT_CLEAR_AIFS_8814B(x) | BIT_AIFS_8814B(v))

/* 2 REG_EDCA_VI_PARAM_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXOPLIMIT_8814B 16
#define BIT_MASK_TXOPLIMIT_8814B 0x7ff
#define BIT_TXOPLIMIT_8814B(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8814B) << BIT_SHIFT_TXOPLIMIT_8814B)
#define BITS_TXOPLIMIT_8814B                                                   \
	(BIT_MASK_TXOPLIMIT_8814B << BIT_SHIFT_TXOPLIMIT_8814B)
#define BIT_CLEAR_TXOPLIMIT_8814B(x) ((x) & (~BITS_TXOPLIMIT_8814B))
#define BIT_GET_TXOPLIMIT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8814B) & BIT_MASK_TXOPLIMIT_8814B)
#define BIT_SET_TXOPLIMIT_8814B(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8814B(x) | BIT_TXOPLIMIT_8814B(v))

#define BIT_SHIFT_CW_8814B 8
#define BIT_MASK_CW_8814B 0xff
#define BIT_CW_8814B(x) (((x) & BIT_MASK_CW_8814B) << BIT_SHIFT_CW_8814B)
#define BITS_CW_8814B (BIT_MASK_CW_8814B << BIT_SHIFT_CW_8814B)
#define BIT_CLEAR_CW_8814B(x) ((x) & (~BITS_CW_8814B))
#define BIT_GET_CW_8814B(x) (((x) >> BIT_SHIFT_CW_8814B) & BIT_MASK_CW_8814B)
#define BIT_SET_CW_8814B(x, v) (BIT_CLEAR_CW_8814B(x) | BIT_CW_8814B(v))

#define BIT_SHIFT_AIFS_8814B 0
#define BIT_MASK_AIFS_8814B 0xff
#define BIT_AIFS_8814B(x) (((x) & BIT_MASK_AIFS_8814B) << BIT_SHIFT_AIFS_8814B)
#define BITS_AIFS_8814B (BIT_MASK_AIFS_8814B << BIT_SHIFT_AIFS_8814B)
#define BIT_CLEAR_AIFS_8814B(x) ((x) & (~BITS_AIFS_8814B))
#define BIT_GET_AIFS_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8814B) & BIT_MASK_AIFS_8814B)
#define BIT_SET_AIFS_8814B(x, v) (BIT_CLEAR_AIFS_8814B(x) | BIT_AIFS_8814B(v))

/* 2 REG_EDCA_BE_PARAM_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXOPLIMIT_8814B 16
#define BIT_MASK_TXOPLIMIT_8814B 0x7ff
#define BIT_TXOPLIMIT_8814B(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8814B) << BIT_SHIFT_TXOPLIMIT_8814B)
#define BITS_TXOPLIMIT_8814B                                                   \
	(BIT_MASK_TXOPLIMIT_8814B << BIT_SHIFT_TXOPLIMIT_8814B)
#define BIT_CLEAR_TXOPLIMIT_8814B(x) ((x) & (~BITS_TXOPLIMIT_8814B))
#define BIT_GET_TXOPLIMIT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8814B) & BIT_MASK_TXOPLIMIT_8814B)
#define BIT_SET_TXOPLIMIT_8814B(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8814B(x) | BIT_TXOPLIMIT_8814B(v))

#define BIT_SHIFT_CW_8814B 8
#define BIT_MASK_CW_8814B 0xff
#define BIT_CW_8814B(x) (((x) & BIT_MASK_CW_8814B) << BIT_SHIFT_CW_8814B)
#define BITS_CW_8814B (BIT_MASK_CW_8814B << BIT_SHIFT_CW_8814B)
#define BIT_CLEAR_CW_8814B(x) ((x) & (~BITS_CW_8814B))
#define BIT_GET_CW_8814B(x) (((x) >> BIT_SHIFT_CW_8814B) & BIT_MASK_CW_8814B)
#define BIT_SET_CW_8814B(x, v) (BIT_CLEAR_CW_8814B(x) | BIT_CW_8814B(v))

#define BIT_SHIFT_AIFS_8814B 0
#define BIT_MASK_AIFS_8814B 0xff
#define BIT_AIFS_8814B(x) (((x) & BIT_MASK_AIFS_8814B) << BIT_SHIFT_AIFS_8814B)
#define BITS_AIFS_8814B (BIT_MASK_AIFS_8814B << BIT_SHIFT_AIFS_8814B)
#define BIT_CLEAR_AIFS_8814B(x) ((x) & (~BITS_AIFS_8814B))
#define BIT_GET_AIFS_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8814B) & BIT_MASK_AIFS_8814B)
#define BIT_SET_AIFS_8814B(x, v) (BIT_CLEAR_AIFS_8814B(x) | BIT_AIFS_8814B(v))

/* 2 REG_EDCA_BK_PARAM_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_TXOPLIMIT_8814B 16
#define BIT_MASK_TXOPLIMIT_8814B 0x7ff
#define BIT_TXOPLIMIT_8814B(x)                                                 \
	(((x) & BIT_MASK_TXOPLIMIT_8814B) << BIT_SHIFT_TXOPLIMIT_8814B)
#define BITS_TXOPLIMIT_8814B                                                   \
	(BIT_MASK_TXOPLIMIT_8814B << BIT_SHIFT_TXOPLIMIT_8814B)
#define BIT_CLEAR_TXOPLIMIT_8814B(x) ((x) & (~BITS_TXOPLIMIT_8814B))
#define BIT_GET_TXOPLIMIT_8814B(x)                                             \
	(((x) >> BIT_SHIFT_TXOPLIMIT_8814B) & BIT_MASK_TXOPLIMIT_8814B)
#define BIT_SET_TXOPLIMIT_8814B(x, v)                                          \
	(BIT_CLEAR_TXOPLIMIT_8814B(x) | BIT_TXOPLIMIT_8814B(v))

#define BIT_SHIFT_CW_8814B 8
#define BIT_MASK_CW_8814B 0xff
#define BIT_CW_8814B(x) (((x) & BIT_MASK_CW_8814B) << BIT_SHIFT_CW_8814B)
#define BITS_CW_8814B (BIT_MASK_CW_8814B << BIT_SHIFT_CW_8814B)
#define BIT_CLEAR_CW_8814B(x) ((x) & (~BITS_CW_8814B))
#define BIT_GET_CW_8814B(x) (((x) >> BIT_SHIFT_CW_8814B) & BIT_MASK_CW_8814B)
#define BIT_SET_CW_8814B(x, v) (BIT_CLEAR_CW_8814B(x) | BIT_CW_8814B(v))

#define BIT_SHIFT_AIFS_8814B 0
#define BIT_MASK_AIFS_8814B 0xff
#define BIT_AIFS_8814B(x) (((x) & BIT_MASK_AIFS_8814B) << BIT_SHIFT_AIFS_8814B)
#define BITS_AIFS_8814B (BIT_MASK_AIFS_8814B << BIT_SHIFT_AIFS_8814B)
#define BIT_CLEAR_AIFS_8814B(x) ((x) & (~BITS_AIFS_8814B))
#define BIT_GET_AIFS_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_AIFS_8814B) & BIT_MASK_AIFS_8814B)
#define BIT_SET_AIFS_8814B(x, v) (BIT_CLEAR_AIFS_8814B(x) | BIT_AIFS_8814B(v))

/* 2 REG_BCNTCFG_8814B */

#define BIT_SHIFT_BCNCW_MAX_8814B 12
#define BIT_MASK_BCNCW_MAX_8814B 0xf
#define BIT_BCNCW_MAX_8814B(x)                                                 \
	(((x) & BIT_MASK_BCNCW_MAX_8814B) << BIT_SHIFT_BCNCW_MAX_8814B)
#define BITS_BCNCW_MAX_8814B                                                   \
	(BIT_MASK_BCNCW_MAX_8814B << BIT_SHIFT_BCNCW_MAX_8814B)
#define BIT_CLEAR_BCNCW_MAX_8814B(x) ((x) & (~BITS_BCNCW_MAX_8814B))
#define BIT_GET_BCNCW_MAX_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCNCW_MAX_8814B) & BIT_MASK_BCNCW_MAX_8814B)
#define BIT_SET_BCNCW_MAX_8814B(x, v)                                          \
	(BIT_CLEAR_BCNCW_MAX_8814B(x) | BIT_BCNCW_MAX_8814B(v))

#define BIT_SHIFT_BCNCW_MIN_8814B 8
#define BIT_MASK_BCNCW_MIN_8814B 0xf
#define BIT_BCNCW_MIN_8814B(x)                                                 \
	(((x) & BIT_MASK_BCNCW_MIN_8814B) << BIT_SHIFT_BCNCW_MIN_8814B)
#define BITS_BCNCW_MIN_8814B                                                   \
	(BIT_MASK_BCNCW_MIN_8814B << BIT_SHIFT_BCNCW_MIN_8814B)
#define BIT_CLEAR_BCNCW_MIN_8814B(x) ((x) & (~BITS_BCNCW_MIN_8814B))
#define BIT_GET_BCNCW_MIN_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCNCW_MIN_8814B) & BIT_MASK_BCNCW_MIN_8814B)
#define BIT_SET_BCNCW_MIN_8814B(x, v)                                          \
	(BIT_CLEAR_BCNCW_MIN_8814B(x) | BIT_BCNCW_MIN_8814B(v))

#define BIT_SHIFT_BCNIFS_8814B 0
#define BIT_MASK_BCNIFS_8814B 0xff
#define BIT_BCNIFS_8814B(x)                                                    \
	(((x) & BIT_MASK_BCNIFS_8814B) << BIT_SHIFT_BCNIFS_8814B)
#define BITS_BCNIFS_8814B (BIT_MASK_BCNIFS_8814B << BIT_SHIFT_BCNIFS_8814B)
#define BIT_CLEAR_BCNIFS_8814B(x) ((x) & (~BITS_BCNIFS_8814B))
#define BIT_GET_BCNIFS_8814B(x)                                                \
	(((x) >> BIT_SHIFT_BCNIFS_8814B) & BIT_MASK_BCNIFS_8814B)
#define BIT_SET_BCNIFS_8814B(x, v)                                             \
	(BIT_CLEAR_BCNIFS_8814B(x) | BIT_BCNIFS_8814B(v))

/* 2 REG_PIFS_8814B */

#define BIT_SHIFT_PIFS_8814B 0
#define BIT_MASK_PIFS_8814B 0xff
#define BIT_PIFS_8814B(x) (((x) & BIT_MASK_PIFS_8814B) << BIT_SHIFT_PIFS_8814B)
#define BITS_PIFS_8814B (BIT_MASK_PIFS_8814B << BIT_SHIFT_PIFS_8814B)
#define BIT_CLEAR_PIFS_8814B(x) ((x) & (~BITS_PIFS_8814B))
#define BIT_GET_PIFS_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_PIFS_8814B) & BIT_MASK_PIFS_8814B)
#define BIT_SET_PIFS_8814B(x, v) (BIT_CLEAR_PIFS_8814B(x) | BIT_PIFS_8814B(v))

/* 2 REG_RDG_PIFS_8814B */

#define BIT_SHIFT_RDG_PIFS_8814B 0
#define BIT_MASK_RDG_PIFS_8814B 0xff
#define BIT_RDG_PIFS_8814B(x)                                                  \
	(((x) & BIT_MASK_RDG_PIFS_8814B) << BIT_SHIFT_RDG_PIFS_8814B)
#define BITS_RDG_PIFS_8814B                                                    \
	(BIT_MASK_RDG_PIFS_8814B << BIT_SHIFT_RDG_PIFS_8814B)
#define BIT_CLEAR_RDG_PIFS_8814B(x) ((x) & (~BITS_RDG_PIFS_8814B))
#define BIT_GET_RDG_PIFS_8814B(x)                                              \
	(((x) >> BIT_SHIFT_RDG_PIFS_8814B) & BIT_MASK_RDG_PIFS_8814B)
#define BIT_SET_RDG_PIFS_8814B(x, v)                                           \
	(BIT_CLEAR_RDG_PIFS_8814B(x) | BIT_RDG_PIFS_8814B(v))

/* 2 REG_SIFS_8814B */

#define BIT_SHIFT_SIFS_OFDM_TRX_8814B 24
#define BIT_MASK_SIFS_OFDM_TRX_8814B 0xff
#define BIT_SIFS_OFDM_TRX_8814B(x)                                             \
	(((x) & BIT_MASK_SIFS_OFDM_TRX_8814B) << BIT_SHIFT_SIFS_OFDM_TRX_8814B)
#define BITS_SIFS_OFDM_TRX_8814B                                               \
	(BIT_MASK_SIFS_OFDM_TRX_8814B << BIT_SHIFT_SIFS_OFDM_TRX_8814B)
#define BIT_CLEAR_SIFS_OFDM_TRX_8814B(x) ((x) & (~BITS_SIFS_OFDM_TRX_8814B))
#define BIT_GET_SIFS_OFDM_TRX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_SIFS_OFDM_TRX_8814B) & BIT_MASK_SIFS_OFDM_TRX_8814B)
#define BIT_SET_SIFS_OFDM_TRX_8814B(x, v)                                      \
	(BIT_CLEAR_SIFS_OFDM_TRX_8814B(x) | BIT_SIFS_OFDM_TRX_8814B(v))

#define BIT_SHIFT_SIFS_CCK_TRX_8814B 16
#define BIT_MASK_SIFS_CCK_TRX_8814B 0xff
#define BIT_SIFS_CCK_TRX_8814B(x)                                              \
	(((x) & BIT_MASK_SIFS_CCK_TRX_8814B) << BIT_SHIFT_SIFS_CCK_TRX_8814B)
#define BITS_SIFS_CCK_TRX_8814B                                                \
	(BIT_MASK_SIFS_CCK_TRX_8814B << BIT_SHIFT_SIFS_CCK_TRX_8814B)
#define BIT_CLEAR_SIFS_CCK_TRX_8814B(x) ((x) & (~BITS_SIFS_CCK_TRX_8814B))
#define BIT_GET_SIFS_CCK_TRX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_SIFS_CCK_TRX_8814B) & BIT_MASK_SIFS_CCK_TRX_8814B)
#define BIT_SET_SIFS_CCK_TRX_8814B(x, v)                                       \
	(BIT_CLEAR_SIFS_CCK_TRX_8814B(x) | BIT_SIFS_CCK_TRX_8814B(v))

#define BIT_SHIFT_SIFS_OFDM_CTX_8814B 8
#define BIT_MASK_SIFS_OFDM_CTX_8814B 0xff
#define BIT_SIFS_OFDM_CTX_8814B(x)                                             \
	(((x) & BIT_MASK_SIFS_OFDM_CTX_8814B) << BIT_SHIFT_SIFS_OFDM_CTX_8814B)
#define BITS_SIFS_OFDM_CTX_8814B                                               \
	(BIT_MASK_SIFS_OFDM_CTX_8814B << BIT_SHIFT_SIFS_OFDM_CTX_8814B)
#define BIT_CLEAR_SIFS_OFDM_CTX_8814B(x) ((x) & (~BITS_SIFS_OFDM_CTX_8814B))
#define BIT_GET_SIFS_OFDM_CTX_8814B(x)                                         \
	(((x) >> BIT_SHIFT_SIFS_OFDM_CTX_8814B) & BIT_MASK_SIFS_OFDM_CTX_8814B)
#define BIT_SET_SIFS_OFDM_CTX_8814B(x, v)                                      \
	(BIT_CLEAR_SIFS_OFDM_CTX_8814B(x) | BIT_SIFS_OFDM_CTX_8814B(v))

#define BIT_SHIFT_SIFS_CCK_CTX_8814B 0
#define BIT_MASK_SIFS_CCK_CTX_8814B 0xff
#define BIT_SIFS_CCK_CTX_8814B(x)                                              \
	(((x) & BIT_MASK_SIFS_CCK_CTX_8814B) << BIT_SHIFT_SIFS_CCK_CTX_8814B)
#define BITS_SIFS_CCK_CTX_8814B                                                \
	(BIT_MASK_SIFS_CCK_CTX_8814B << BIT_SHIFT_SIFS_CCK_CTX_8814B)
#define BIT_CLEAR_SIFS_CCK_CTX_8814B(x) ((x) & (~BITS_SIFS_CCK_CTX_8814B))
#define BIT_GET_SIFS_CCK_CTX_8814B(x)                                          \
	(((x) >> BIT_SHIFT_SIFS_CCK_CTX_8814B) & BIT_MASK_SIFS_CCK_CTX_8814B)
#define BIT_SET_SIFS_CCK_CTX_8814B(x, v)                                       \
	(BIT_CLEAR_SIFS_CCK_CTX_8814B(x) | BIT_SIFS_CCK_CTX_8814B(v))

/* 2 REG_FORCE_BCN_IFS_V1_8814B */

#define BIT_SHIFT_FORCE_BCN_IFS_8814B 0
#define BIT_MASK_FORCE_BCN_IFS_8814B 0xff
#define BIT_FORCE_BCN_IFS_8814B(x)                                             \
	(((x) & BIT_MASK_FORCE_BCN_IFS_8814B) << BIT_SHIFT_FORCE_BCN_IFS_8814B)
#define BITS_FORCE_BCN_IFS_8814B                                               \
	(BIT_MASK_FORCE_BCN_IFS_8814B << BIT_SHIFT_FORCE_BCN_IFS_8814B)
#define BIT_CLEAR_FORCE_BCN_IFS_8814B(x) ((x) & (~BITS_FORCE_BCN_IFS_8814B))
#define BIT_GET_FORCE_BCN_IFS_8814B(x)                                         \
	(((x) >> BIT_SHIFT_FORCE_BCN_IFS_8814B) & BIT_MASK_FORCE_BCN_IFS_8814B)
#define BIT_SET_FORCE_BCN_IFS_8814B(x, v)                                      \
	(BIT_CLEAR_FORCE_BCN_IFS_8814B(x) | BIT_FORCE_BCN_IFS_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_AGGR_BREAK_TIME_8814B */

#define BIT_SHIFT_AGGR_BK_TIME_8814B 0
#define BIT_MASK_AGGR_BK_TIME_8814B 0xff
#define BIT_AGGR_BK_TIME_8814B(x)                                              \
	(((x) & BIT_MASK_AGGR_BK_TIME_8814B) << BIT_SHIFT_AGGR_BK_TIME_8814B)
#define BITS_AGGR_BK_TIME_8814B                                                \
	(BIT_MASK_AGGR_BK_TIME_8814B << BIT_SHIFT_AGGR_BK_TIME_8814B)
#define BIT_CLEAR_AGGR_BK_TIME_8814B(x) ((x) & (~BITS_AGGR_BK_TIME_8814B))
#define BIT_GET_AGGR_BK_TIME_8814B(x)                                          \
	(((x) >> BIT_SHIFT_AGGR_BK_TIME_8814B) & BIT_MASK_AGGR_BK_TIME_8814B)
#define BIT_SET_AGGR_BK_TIME_8814B(x, v)                                       \
	(BIT_CLEAR_AGGR_BK_TIME_8814B(x) | BIT_AGGR_BK_TIME_8814B(v))

/* 2 REG_SLOT_8814B */

#define BIT_SHIFT_SLOT_8814B 0
#define BIT_MASK_SLOT_8814B 0xff
#define BIT_SLOT_8814B(x) (((x) & BIT_MASK_SLOT_8814B) << BIT_SHIFT_SLOT_8814B)
#define BITS_SLOT_8814B (BIT_MASK_SLOT_8814B << BIT_SHIFT_SLOT_8814B)
#define BIT_CLEAR_SLOT_8814B(x) ((x) & (~BITS_SLOT_8814B))
#define BIT_GET_SLOT_8814B(x)                                                  \
	(((x) >> BIT_SHIFT_SLOT_8814B) & BIT_MASK_SLOT_8814B)
#define BIT_SET_SLOT_8814B(x, v) (BIT_CLEAR_SLOT_8814B(x) | BIT_SLOT_8814B(v))

/* 2 REG_EDCA_CPUMGQ_PARAM_8814B */

#define BIT_SHIFT_CW_V1_8814B 8
#define BIT_MASK_CW_V1_8814B 0xff
#define BIT_CW_V1_8814B(x)                                                     \
	(((x) & BIT_MASK_CW_V1_8814B) << BIT_SHIFT_CW_V1_8814B)
#define BITS_CW_V1_8814B (BIT_MASK_CW_V1_8814B << BIT_SHIFT_CW_V1_8814B)
#define BIT_CLEAR_CW_V1_8814B(x) ((x) & (~BITS_CW_V1_8814B))
#define BIT_GET_CW_V1_8814B(x)                                                 \
	(((x) >> BIT_SHIFT_CW_V1_8814B) & BIT_MASK_CW_V1_8814B)
#define BIT_SET_CW_V1_8814B(x, v)                                              \
	(BIT_CLEAR_CW_V1_8814B(x) | BIT_CW_V1_8814B(v))

#define BIT_SHIFT_AIFS_V1_8814B 0
#define BIT_MASK_AIFS_V1_8814B 0xff
#define BIT_AIFS_V1_8814B(x)                                                   \
	(((x) & BIT_MASK_AIFS_V1_8814B) << BIT_SHIFT_AIFS_V1_8814B)
#define BITS_AIFS_V1_8814B (BIT_MASK_AIFS_V1_8814B << BIT_SHIFT_AIFS_V1_8814B)
#define BIT_CLEAR_AIFS_V1_8814B(x) ((x) & (~BITS_AIFS_V1_8814B))
#define BIT_GET_AIFS_V1_8814B(x)                                               \
	(((x) >> BIT_SHIFT_AIFS_V1_8814B) & BIT_MASK_AIFS_V1_8814B)
#define BIT_SET_AIFS_V1_8814B(x, v)                                            \
	(BIT_CLEAR_AIFS_V1_8814B(x) | BIT_AIFS_V1_8814B(v))

/* 2 REG_CPUMGQ_PAUSE_8814B */
#define BIT_MAC_STOP_CPUMGQ_V1_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_TX_PTCL_CTRL_8814B */
#define BIT_DIS_EDCCA_8814B BIT(15)
#define BIT_DIS_CCA_8814B BIT(14)
#define BIT_LSIG_TXOP_TXCMD_NAV_8814B BIT(13)
#define BIT_SIFS_BK_EN_8814B BIT(12)

#define BIT_SHIFT_TXQ_NAV_MSK_8814B 8
#define BIT_MASK_TXQ_NAV_MSK_8814B 0xf
#define BIT_TXQ_NAV_MSK_8814B(x)                                               \
	(((x) & BIT_MASK_TXQ_NAV_MSK_8814B) << BIT_SHIFT_TXQ_NAV_MSK_8814B)
#define BITS_TXQ_NAV_MSK_8814B                                                 \
	(BIT_MASK_TXQ_NAV_MSK_8814B << BIT_SHIFT_TXQ_NAV_MSK_8814B)
#define BIT_CLEAR_TXQ_NAV_MSK_8814B(x) ((x) & (~BITS_TXQ_NAV_MSK_8814B))
#define BIT_GET_TXQ_NAV_MSK_8814B(x)                                           \
	(((x) >> BIT_SHIFT_TXQ_NAV_MSK_8814B) & BIT_MASK_TXQ_NAV_MSK_8814B)
#define BIT_SET_TXQ_NAV_MSK_8814B(x, v)                                        \
	(BIT_CLEAR_TXQ_NAV_MSK_8814B(x) | BIT_TXQ_NAV_MSK_8814B(v))

#define BIT_DIS_CW_8814B BIT(7)
#define BIT_NAV_END_TXOP_8814B BIT(6)
#define BIT_RDG_END_TXOP_8814B BIT(5)
#define BIT_AC_INBCN_HOLD_8814B BIT(4)
#define BIT_MGTQ_TXOP_EN_8814B BIT(3)
#define BIT_MGTQ_RTSMF_EN_8814B BIT(2)
#define BIT_HIQ_RTSMF_EN_8814B BIT(1)
#define BIT_BCN_RTSMF_EN_8814B BIT(0)

/* 2 REG_TXPAUSE_8814B */
#define BIT_STOP_BCN_HI_MGT_8814B BIT(7)
#define BIT_MAC_STOPBCNQ_8814B BIT(6)
#define BIT_MAC_STOPHIQ_8814B BIT(5)
#define BIT_MAC_STOPMGQ_8814B BIT(4)
#define BIT_MAC_STOPBK_8814B BIT(3)
#define BIT_MAC_STOPBE_8814B BIT(2)
#define BIT_MAC_STOPVI_8814B BIT(1)
#define BIT_MAC_STOPVO_8814B BIT(0)

/* 2 REG_DIS_TXREQ_CLR_8814B */
#define BIT_DIS_BT_CCA_8814B BIT(7)
#define BIT_DIS_TXREQ_CLR_HI_8814B BIT(5)
#define BIT_DIS_TXREQ_CLR_MGQ_8814B BIT(4)
#define BIT_DIS_TXREQ_CLR_VO_8814B BIT(3)
#define BIT_DIS_TXREQ_CLR_VI_8814B BIT(2)
#define BIT_DIS_TXREQ_CLR_BE_8814B BIT(1)
#define BIT_DIS_TXREQ_CLR_BK_8814B BIT(0)

/* 2 REG_RD_CTRL_8814B */
#define BIT_EN_CLR_TXREQ_INCCA_8814B BIT(15)
#define BIT_DIS_TX_OVER_BCNQ_8814B BIT(14)
#define BIT_EN_BCNERR_INCCCA_8814B BIT(13)
#define BIT_EDCCA_MSK_CNTDOWN_EN_8814B BIT(11)
#define BIT_DIS_TXOP_CFE_8814B BIT(10)
#define BIT_DIS_LSIG_CFE_8814B BIT(9)
#define BIT_BKQ_RD_INIT_EN_8814B BIT(7)
#define BIT_BEQ_RD_INIT_EN_8814B BIT(6)
#define BIT_VIQ_RD_INIT_EN_8814B BIT(5)
#define BIT_VOQ_RD_INIT_EN_8814B BIT(4)
#define BIT_BKQ_RD_RESP_EN_8814B BIT(3)
#define BIT_BEQ_RD_RESP_EN_8814B BIT(2)
#define BIT_VIQ_RD_RESP_EN_8814B BIT(1)
#define BIT_VOQ_RD_RESP_EN_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_PKT_LIFETIME_CTRL_8814B */
#define BIT_EN_P2P_CTWND1_8814B BIT(23)
#define BIT_EN_BKF_CLR_TXREQ_8814B BIT(22)
#define BIT_EN_BCN_TX_BTCCA_8814B BIT(20)
#define BIT_DIS_PKT_TX_ATIM_8814B BIT(19)
#define BIT_DIS_BCN_DIS_CTN_8814B BIT(18)
#define BIT_EN_NAVEND_RST_TXOP_8814B BIT(17)
#define BIT_EN_FILTER_CCA_8814B BIT(16)

#define BIT_SHIFT_CCA_FILTER_THRS_8814B 8
#define BIT_MASK_CCA_FILTER_THRS_8814B 0xff
#define BIT_CCA_FILTER_THRS_8814B(x)                                           \
	(((x) & BIT_MASK_CCA_FILTER_THRS_8814B)                                \
	 << BIT_SHIFT_CCA_FILTER_THRS_8814B)
#define BITS_CCA_FILTER_THRS_8814B                                             \
	(BIT_MASK_CCA_FILTER_THRS_8814B << BIT_SHIFT_CCA_FILTER_THRS_8814B)
#define BIT_CLEAR_CCA_FILTER_THRS_8814B(x) ((x) & (~BITS_CCA_FILTER_THRS_8814B))
#define BIT_GET_CCA_FILTER_THRS_8814B(x)                                       \
	(((x) >> BIT_SHIFT_CCA_FILTER_THRS_8814B) &                            \
	 BIT_MASK_CCA_FILTER_THRS_8814B)
#define BIT_SET_CCA_FILTER_THRS_8814B(x, v)                                    \
	(BIT_CLEAR_CCA_FILTER_THRS_8814B(x) | BIT_CCA_FILTER_THRS_8814B(v))

#define BIT_SHIFT_EDCCA_THRS_8814B 0
#define BIT_MASK_EDCCA_THRS_8814B 0xff
#define BIT_EDCCA_THRS_8814B(x)                                                \
	(((x) & BIT_MASK_EDCCA_THRS_8814B) << BIT_SHIFT_EDCCA_THRS_8814B)
#define BITS_EDCCA_THRS_8814B                                                  \
	(BIT_MASK_EDCCA_THRS_8814B << BIT_SHIFT_EDCCA_THRS_8814B)
#define BIT_CLEAR_EDCCA_THRS_8814B(x) ((x) & (~BITS_EDCCA_THRS_8814B))
#define BIT_GET_EDCCA_THRS_8814B(x)                                            \
	(((x) >> BIT_SHIFT_EDCCA_THRS_8814B) & BIT_MASK_EDCCA_THRS_8814B)
#define BIT_SET_EDCCA_THRS_8814B(x, v)                                         \
	(BIT_CLEAR_EDCCA_THRS_8814B(x) | BIT_EDCCA_THRS_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_TXOP_LIMIT_CTRL_8814B */

#define BIT_SHIFT_TXOP_TBTT_CNT_8814B 24
#define BIT_MASK_TXOP_TBTT_CNT_8814B 0xff
#define BIT_TXOP_TBTT_CNT_8814B(x)                                             \
	(((x) & BIT_MASK_TXOP_TBTT_CNT_8814B) << BIT_SHIFT_TXOP_TBTT_CNT_8814B)
#define BITS_TXOP_TBTT_CNT_8814B                                               \
	(BIT_MASK_TXOP_TBTT_CNT_8814B << BIT_SHIFT_TXOP_TBTT_CNT_8814B)
#define BIT_CLEAR_TXOP_TBTT_CNT_8814B(x) ((x) & (~BITS_TXOP_TBTT_CNT_8814B))
#define BIT_GET_TXOP_TBTT_CNT_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXOP_TBTT_CNT_8814B) & BIT_MASK_TXOP_TBTT_CNT_8814B)
#define BIT_SET_TXOP_TBTT_CNT_8814B(x, v)                                      \
	(BIT_CLEAR_TXOP_TBTT_CNT_8814B(x) | BIT_TXOP_TBTT_CNT_8814B(v))

#define BIT_SHIFT_TXOP_TBTT_CNT_SEL_8814B 20
#define BIT_MASK_TXOP_TBTT_CNT_SEL_8814B 0xf
#define BIT_TXOP_TBTT_CNT_SEL_8814B(x)                                         \
	(((x) & BIT_MASK_TXOP_TBTT_CNT_SEL_8814B)                              \
	 << BIT_SHIFT_TXOP_TBTT_CNT_SEL_8814B)
#define BITS_TXOP_TBTT_CNT_SEL_8814B                                           \
	(BIT_MASK_TXOP_TBTT_CNT_SEL_8814B << BIT_SHIFT_TXOP_TBTT_CNT_SEL_8814B)
#define BIT_CLEAR_TXOP_TBTT_CNT_SEL_8814B(x)                                   \
	((x) & (~BITS_TXOP_TBTT_CNT_SEL_8814B))
#define BIT_GET_TXOP_TBTT_CNT_SEL_8814B(x)                                     \
	(((x) >> BIT_SHIFT_TXOP_TBTT_CNT_SEL_8814B) &                          \
	 BIT_MASK_TXOP_TBTT_CNT_SEL_8814B)
#define BIT_SET_TXOP_TBTT_CNT_SEL_8814B(x, v)                                  \
	(BIT_CLEAR_TXOP_TBTT_CNT_SEL_8814B(x) | BIT_TXOP_TBTT_CNT_SEL_8814B(v))

#define BIT_SHIFT_TXOP_LMT_EN_8814B 16
#define BIT_MASK_TXOP_LMT_EN_8814B 0xf
#define BIT_TXOP_LMT_EN_8814B(x)                                               \
	(((x) & BIT_MASK_TXOP_LMT_EN_8814B) << BIT_SHIFT_TXOP_LMT_EN_8814B)
#define BITS_TXOP_LMT_EN_8814B                                                 \
	(BIT_MASK_TXOP_LMT_EN_8814B << BIT_SHIFT_TXOP_LMT_EN_8814B)
#define BIT_CLEAR_TXOP_LMT_EN_8814B(x) ((x) & (~BITS_TXOP_LMT_EN_8814B))
#define BIT_GET_TXOP_LMT_EN_8814B(x)                                           \
	(((x) >> BIT_SHIFT_TXOP_LMT_EN_8814B) & BIT_MASK_TXOP_LMT_EN_8814B)
#define BIT_SET_TXOP_LMT_EN_8814B(x, v)                                        \
	(BIT_CLEAR_TXOP_LMT_EN_8814B(x) | BIT_TXOP_LMT_EN_8814B(v))

#define BIT_SHIFT_TXOP_LMT_TX_TIME_8814B 8
#define BIT_MASK_TXOP_LMT_TX_TIME_8814B 0xff
#define BIT_TXOP_LMT_TX_TIME_8814B(x)                                          \
	(((x) & BIT_MASK_TXOP_LMT_TX_TIME_8814B)                               \
	 << BIT_SHIFT_TXOP_LMT_TX_TIME_8814B)
#define BITS_TXOP_LMT_TX_TIME_8814B                                            \
	(BIT_MASK_TXOP_LMT_TX_TIME_8814B << BIT_SHIFT_TXOP_LMT_TX_TIME_8814B)
#define BIT_CLEAR_TXOP_LMT_TX_TIME_8814B(x)                                    \
	((x) & (~BITS_TXOP_LMT_TX_TIME_8814B))
#define BIT_GET_TXOP_LMT_TX_TIME_8814B(x)                                      \
	(((x) >> BIT_SHIFT_TXOP_LMT_TX_TIME_8814B) &                           \
	 BIT_MASK_TXOP_LMT_TX_TIME_8814B)
#define BIT_SET_TXOP_LMT_TX_TIME_8814B(x, v)                                   \
	(BIT_CLEAR_TXOP_LMT_TX_TIME_8814B(x) | BIT_TXOP_LMT_TX_TIME_8814B(v))

#define BIT_TXOP_CNT_TRIGGER_RESET_8814B BIT(7)

#define BIT_SHIFT_TXOP_LMT_PKT_NUM_8814B 0
#define BIT_MASK_TXOP_LMT_PKT_NUM_8814B 0x3f
#define BIT_TXOP_LMT_PKT_NUM_8814B(x)                                          \
	(((x) & BIT_MASK_TXOP_LMT_PKT_NUM_8814B)                               \
	 << BIT_SHIFT_TXOP_LMT_PKT_NUM_8814B)
#define BITS_TXOP_LMT_PKT_NUM_8814B                                            \
	(BIT_MASK_TXOP_LMT_PKT_NUM_8814B << BIT_SHIFT_TXOP_LMT_PKT_NUM_8814B)
#define BIT_CLEAR_TXOP_LMT_PKT_NUM_8814B(x)                                    \
	((x) & (~BITS_TXOP_LMT_PKT_NUM_8814B))
#define BIT_GET_TXOP_LMT_PKT_NUM_8814B(x)                                      \
	(((x) >> BIT_SHIFT_TXOP_LMT_PKT_NUM_8814B) &                           \
	 BIT_MASK_TXOP_LMT_PKT_NUM_8814B)
#define BIT_SET_TXOP_LMT_PKT_NUM_8814B(x, v)                                   \
	(BIT_CLEAR_TXOP_LMT_PKT_NUM_8814B(x) | BIT_TXOP_LMT_PKT_NUM_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_CCA_TXEN_CNT_8814B */
#define BIT_CCA_TXEN_CNT_SWITCH_8814B BIT(17)
#define BIT_CCA_TXEN_CNT_EN_8814B BIT(16)

#define BIT_SHIFT_CCA_TXEN_BIG_CNT_8814B 8
#define BIT_MASK_CCA_TXEN_BIG_CNT_8814B 0xff
#define BIT_CCA_TXEN_BIG_CNT_8814B(x)                                          \
	(((x) & BIT_MASK_CCA_TXEN_BIG_CNT_8814B)                               \
	 << BIT_SHIFT_CCA_TXEN_BIG_CNT_8814B)
#define BITS_CCA_TXEN_BIG_CNT_8814B                                            \
	(BIT_MASK_CCA_TXEN_BIG_CNT_8814B << BIT_SHIFT_CCA_TXEN_BIG_CNT_8814B)
#define BIT_CLEAR_CCA_TXEN_BIG_CNT_8814B(x)                                    \
	((x) & (~BITS_CCA_TXEN_BIG_CNT_8814B))
#define BIT_GET_CCA_TXEN_BIG_CNT_8814B(x)                                      \
	(((x) >> BIT_SHIFT_CCA_TXEN_BIG_CNT_8814B) &                           \
	 BIT_MASK_CCA_TXEN_BIG_CNT_8814B)
#define BIT_SET_CCA_TXEN_BIG_CNT_8814B(x, v)                                   \
	(BIT_CLEAR_CCA_TXEN_BIG_CNT_8814B(x) | BIT_CCA_TXEN_BIG_CNT_8814B(v))

#define BIT_SHIFT_CCA_TXEN_SMALL_CNT_8814B 0
#define BIT_MASK_CCA_TXEN_SMALL_CNT_8814B 0xff
#define BIT_CCA_TXEN_SMALL_CNT_8814B(x)                                        \
	(((x) & BIT_MASK_CCA_TXEN_SMALL_CNT_8814B)                             \
	 << BIT_SHIFT_CCA_TXEN_SMALL_CNT_8814B)
#define BITS_CCA_TXEN_SMALL_CNT_8814B                                          \
	(BIT_MASK_CCA_TXEN_SMALL_CNT_8814B                                     \
	 << BIT_SHIFT_CCA_TXEN_SMALL_CNT_8814B)
#define BIT_CLEAR_CCA_TXEN_SMALL_CNT_8814B(x)                                  \
	((x) & (~BITS_CCA_TXEN_SMALL_CNT_8814B))
#define BIT_GET_CCA_TXEN_SMALL_CNT_8814B(x)                                    \
	(((x) >> BIT_SHIFT_CCA_TXEN_SMALL_CNT_8814B) &                         \
	 BIT_MASK_CCA_TXEN_SMALL_CNT_8814B)
#define BIT_SET_CCA_TXEN_SMALL_CNT_8814B(x, v)                                 \
	(BIT_CLEAR_CCA_TXEN_SMALL_CNT_8814B(x) |                               \
	 BIT_CCA_TXEN_SMALL_CNT_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_MAX_INTER_COLLISION_8814B */

#define BIT_SHIFT_MAX_INTER_COLLISION_BK_8814B 24
#define BIT_MASK_MAX_INTER_COLLISION_BK_8814B 0xff
#define BIT_MAX_INTER_COLLISION_BK_8814B(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_BK_8814B)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BK_8814B)
#define BITS_MAX_INTER_COLLISION_BK_8814B                                      \
	(BIT_MASK_MAX_INTER_COLLISION_BK_8814B                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BK_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_BK_8814B(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_BK_8814B))
#define BIT_GET_MAX_INTER_COLLISION_BK_8814B(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_BK_8814B) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_BK_8814B)
#define BIT_SET_MAX_INTER_COLLISION_BK_8814B(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_BK_8814B(x) |                           \
	 BIT_MAX_INTER_COLLISION_BK_8814B(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_BE_8814B 16
#define BIT_MASK_MAX_INTER_COLLISION_BE_8814B 0xff
#define BIT_MAX_INTER_COLLISION_BE_8814B(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_BE_8814B)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BE_8814B)
#define BITS_MAX_INTER_COLLISION_BE_8814B                                      \
	(BIT_MASK_MAX_INTER_COLLISION_BE_8814B                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_BE_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_BE_8814B(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_BE_8814B))
#define BIT_GET_MAX_INTER_COLLISION_BE_8814B(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_BE_8814B) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_BE_8814B)
#define BIT_SET_MAX_INTER_COLLISION_BE_8814B(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_BE_8814B(x) |                           \
	 BIT_MAX_INTER_COLLISION_BE_8814B(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_VI_8814B 8
#define BIT_MASK_MAX_INTER_COLLISION_VI_8814B 0xff
#define BIT_MAX_INTER_COLLISION_VI_8814B(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_VI_8814B)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VI_8814B)
#define BITS_MAX_INTER_COLLISION_VI_8814B                                      \
	(BIT_MASK_MAX_INTER_COLLISION_VI_8814B                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VI_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_VI_8814B(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_VI_8814B))
#define BIT_GET_MAX_INTER_COLLISION_VI_8814B(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_VI_8814B) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_VI_8814B)
#define BIT_SET_MAX_INTER_COLLISION_VI_8814B(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_VI_8814B(x) |                           \
	 BIT_MAX_INTER_COLLISION_VI_8814B(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_VO_8814B 0
#define BIT_MASK_MAX_INTER_COLLISION_VO_8814B 0xff
#define BIT_MAX_INTER_COLLISION_VO_8814B(x)                                    \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_VO_8814B)                         \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VO_8814B)
#define BITS_MAX_INTER_COLLISION_VO_8814B                                      \
	(BIT_MASK_MAX_INTER_COLLISION_VO_8814B                                 \
	 << BIT_SHIFT_MAX_INTER_COLLISION_VO_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_VO_8814B(x)                              \
	((x) & (~BITS_MAX_INTER_COLLISION_VO_8814B))
#define BIT_GET_MAX_INTER_COLLISION_VO_8814B(x)                                \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_VO_8814B) &                     \
	 BIT_MASK_MAX_INTER_COLLISION_VO_8814B)
#define BIT_SET_MAX_INTER_COLLISION_VO_8814B(x, v)                             \
	(BIT_CLEAR_MAX_INTER_COLLISION_VO_8814B(x) |                           \
	 BIT_MAX_INTER_COLLISION_VO_8814B(v))

/* 2 REG_MAX_INTER_COLLISION_CNT_8814B */
#define BIT_MAX_INTER_COLLISION_EN_8814B BIT(16)

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8814B 12
#define BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8814B 0xf
#define BIT_MAX_INTER_COLLISION_CNT_BK_8814B(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8814B)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8814B)
#define BITS_MAX_INTER_COLLISION_CNT_BK_8814B                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8814B                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_BK_8814B(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_BK_8814B))
#define BIT_GET_MAX_INTER_COLLISION_CNT_BK_8814B(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_BK_8814B) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_BK_8814B)
#define BIT_SET_MAX_INTER_COLLISION_CNT_BK_8814B(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_BK_8814B(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_BK_8814B(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8814B 8
#define BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8814B 0xf
#define BIT_MAX_INTER_COLLISION_CNT_BE_8814B(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8814B)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8814B)
#define BITS_MAX_INTER_COLLISION_CNT_BE_8814B                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8814B                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_BE_8814B(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_BE_8814B))
#define BIT_GET_MAX_INTER_COLLISION_CNT_BE_8814B(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_BE_8814B) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_BE_8814B)
#define BIT_SET_MAX_INTER_COLLISION_CNT_BE_8814B(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_BE_8814B(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_BE_8814B(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8814B 4
#define BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8814B 0xf
#define BIT_MAX_INTER_COLLISION_CNT_VI_8814B(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8814B)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8814B)
#define BITS_MAX_INTER_COLLISION_CNT_VI_8814B                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8814B                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_VI_8814B(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_VI_8814B))
#define BIT_GET_MAX_INTER_COLLISION_CNT_VI_8814B(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_VI_8814B) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_VI_8814B)
#define BIT_SET_MAX_INTER_COLLISION_CNT_VI_8814B(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_VI_8814B(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_VI_8814B(v))

#define BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8814B 0
#define BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8814B 0xf
#define BIT_MAX_INTER_COLLISION_CNT_VO_8814B(x)                                \
	(((x) & BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8814B)                     \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8814B)
#define BITS_MAX_INTER_COLLISION_CNT_VO_8814B                                  \
	(BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8814B                             \
	 << BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8814B)
#define BIT_CLEAR_MAX_INTER_COLLISION_CNT_VO_8814B(x)                          \
	((x) & (~BITS_MAX_INTER_COLLISION_CNT_VO_8814B))
#define BIT_GET_MAX_INTER_COLLISION_CNT_VO_8814B(x)                            \
	(((x) >> BIT_SHIFT_MAX_INTER_COLLISION_CNT_VO_8814B) &                 \
	 BIT_MASK_MAX_INTER_COLLISION_CNT_VO_8814B)
#define BIT_SET_MAX_INTER_COLLISION_CNT_VO_8814B(x, v)                         \
	(BIT_CLEAR_MAX_INTER_COLLISION_CNT_VO_8814B(x) |                       \
	 BIT_MAX_INTER_COLLISION_CNT_VO_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_RD_NAV_NXT_8814B */

#define BIT_SHIFT_RD_NAV_PROT_NXT_8814B 0
#define BIT_MASK_RD_NAV_PROT_NXT_8814B 0xffff
#define BIT_RD_NAV_PROT_NXT_8814B(x)                                           \
	(((x) & BIT_MASK_RD_NAV_PROT_NXT_8814B)                                \
	 << BIT_SHIFT_RD_NAV_PROT_NXT_8814B)
#define BITS_RD_NAV_PROT_NXT_8814B                                             \
	(BIT_MASK_RD_NAV_PROT_NXT_8814B << BIT_SHIFT_RD_NAV_PROT_NXT_8814B)
#define BIT_CLEAR_RD_NAV_PROT_NXT_8814B(x) ((x) & (~BITS_RD_NAV_PROT_NXT_8814B))
#define BIT_GET_RD_NAV_PROT_NXT_8814B(x)                                       \
	(((x) >> BIT_SHIFT_RD_NAV_PROT_NXT_8814B) &                            \
	 BIT_MASK_RD_NAV_PROT_NXT_8814B)
#define BIT_SET_RD_NAV_PROT_NXT_8814B(x, v)                                    \
	(BIT_CLEAR_RD_NAV_PROT_NXT_8814B(x) | BIT_RD_NAV_PROT_NXT_8814B(v))

/* 2 REG_NAV_PROT_LEN_8814B */

#define BIT_SHIFT_NAV_PROT_LEN_8814B 0
#define BIT_MASK_NAV_PROT_LEN_8814B 0xffff
#define BIT_NAV_PROT_LEN_8814B(x)                                              \
	(((x) & BIT_MASK_NAV_PROT_LEN_8814B) << BIT_SHIFT_NAV_PROT_LEN_8814B)
#define BITS_NAV_PROT_LEN_8814B                                                \
	(BIT_MASK_NAV_PROT_LEN_8814B << BIT_SHIFT_NAV_PROT_LEN_8814B)
#define BIT_CLEAR_NAV_PROT_LEN_8814B(x) ((x) & (~BITS_NAV_PROT_LEN_8814B))
#define BIT_GET_NAV_PROT_LEN_8814B(x)                                          \
	(((x) >> BIT_SHIFT_NAV_PROT_LEN_8814B) & BIT_MASK_NAV_PROT_LEN_8814B)
#define BIT_SET_NAV_PROT_LEN_8814B(x, v)                                       \
	(BIT_CLEAR_NAV_PROT_LEN_8814B(x) | BIT_NAV_PROT_LEN_8814B(v))

/* 2 REG_FTM_PTT_8814B */

#define BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8814B 22
#define BIT_MASK_FTM_PTT_TSF_R2T_SEL_8814B 0x7
#define BIT_FTM_PTT_TSF_R2T_SEL_8814B(x)                                       \
	(((x) & BIT_MASK_FTM_PTT_TSF_R2T_SEL_8814B)                            \
	 << BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8814B)
#define BITS_FTM_PTT_TSF_R2T_SEL_8814B                                         \
	(BIT_MASK_FTM_PTT_TSF_R2T_SEL_8814B                                    \
	 << BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8814B)
#define BIT_CLEAR_FTM_PTT_TSF_R2T_SEL_8814B(x)                                 \
	((x) & (~BITS_FTM_PTT_TSF_R2T_SEL_8814B))
#define BIT_GET_FTM_PTT_TSF_R2T_SEL_8814B(x)                                   \
	(((x) >> BIT_SHIFT_FTM_PTT_TSF_R2T_SEL_8814B) &                        \
	 BIT_MASK_FTM_PTT_TSF_R2T_SEL_8814B)
#define BIT_SET_FTM_PTT_TSF_R2T_SEL_8814B(x, v)                                \
	(BIT_CLEAR_FTM_PTT_TSF_R2T_SEL_8814B(x) |                              \
	 BIT_FTM_PTT_TSF_R2T_SEL_8814B(v))

#define BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8814B 19
#define BIT_MASK_FTM_PTT_TSF_T2R_SEL_8814B 0x7
#define BIT_FTM_PTT_TSF_T2R_SEL_8814B(x)                                       \
	(((x) & BIT_MASK_FTM_PTT_TSF_T2R_SEL_8814B)                            \
	 << BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8814B)
#define BITS_FTM_PTT_TSF_T2R_SEL_8814B                                         \
	(BIT_MASK_FTM_PTT_TSF_T2R_SEL_8814B                                    \
	 << BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8814B)
#define BIT_CLEAR_FTM_PTT_TSF_T2R_SEL_8814B(x)                                 \
	((x) & (~BITS_FTM_PTT_TSF_T2R_SEL_8814B))
#define BIT_GET_FTM_PTT_TSF_T2R_SEL_8814B(x)                                   \
	(((x) >> BIT_SHIFT_FTM_PTT_TSF_T2R_SEL_8814B) &                        \
	 BIT_MASK_FTM_PTT_TSF_T2R_SEL_8814B)
#define BIT_SET_FTM_PTT_TSF_T2R_SEL_8814B(x, v)                                \
	(BIT_CLEAR_FTM_PTT_TSF_T2R_SEL_8814B(x) |                              \
	 BIT_FTM_PTT_TSF_T2R_SEL_8814B(v))

#define BIT_SHIFT_FTM_PTT_TSF_SEL_8814B 16
#define BIT_MASK_FTM_PTT_TSF_SEL_8814B 0x7
#define BIT_FTM_PTT_TSF_SEL_8814B(x)                                           \
	(((x) & BIT_MASK_FTM_PTT_TSF_SEL_8814B)                                \
	 << BIT_SHIFT_FTM_PTT_TSF_SEL_8814B)
#define BITS_FTM_PTT_TSF_SEL_8814B                                             \
	(BIT_MASK_FTM_PTT_TSF_SEL_8814B << BIT_SHIFT_FTM_PTT_TSF_SEL_8814B)
#define BIT_CLEAR_FTM_PTT_TSF_SEL_8814B(x) ((x) & (~BITS_FTM_PTT_TSF_SEL_8814B))
#define BIT_GET_FTM_PTT_TSF_SEL_8814B(x)                                       \
	(((x) >> BIT_SHIFT_FTM_PTT_TSF_SEL_8814B) &                            \
	 BIT_MASK_FTM_PTT_TSF_SEL_8814B)
#define BIT_SET_FTM_PTT_TSF_SEL_8814B(x, v)                                    \
	(BIT_CLEAR_FTM_PTT_TSF_SEL_8814B(x) | BIT_FTM_PTT_TSF_SEL_8814B(v))

#define BIT_SHIFT_FTM_PTT_VALUE_8814B 0
#define BIT_MASK_FTM_PTT_VALUE_8814B 0xffff
#define BIT_FTM_PTT_VALUE_8814B(x)                                             \
	(((x) & BIT_MASK_FTM_PTT_VALUE_8814B) << BIT_SHIFT_FTM_PTT_VALUE_8814B)
#define BITS_FTM_PTT_VALUE_8814B                                               \
	(BIT_MASK_FTM_PTT_VALUE_8814B << BIT_SHIFT_FTM_PTT_VALUE_8814B)
#define BIT_CLEAR_FTM_PTT_VALUE_8814B(x) ((x) & (~BITS_FTM_PTT_VALUE_8814B))
#define BIT_GET_FTM_PTT_VALUE_8814B(x)                                         \
	(((x) >> BIT_SHIFT_FTM_PTT_VALUE_8814B) & BIT_MASK_FTM_PTT_VALUE_8814B)
#define BIT_SET_FTM_PTT_VALUE_8814B(x, v)                                      \
	(BIT_CLEAR_FTM_PTT_VALUE_8814B(x) | BIT_FTM_PTT_VALUE_8814B(v))

/* 2 REG_FTM_TSF_8814B */

#define BIT_SHIFT_FTM_T2_TSF_8814B 16
#define BIT_MASK_FTM_T2_TSF_8814B 0xffff
#define BIT_FTM_T2_TSF_8814B(x)                                                \
	(((x) & BIT_MASK_FTM_T2_TSF_8814B) << BIT_SHIFT_FTM_T2_TSF_8814B)
#define BITS_FTM_T2_TSF_8814B                                                  \
	(BIT_MASK_FTM_T2_TSF_8814B << BIT_SHIFT_FTM_T2_TSF_8814B)
#define BIT_CLEAR_FTM_T2_TSF_8814B(x) ((x) & (~BITS_FTM_T2_TSF_8814B))
#define BIT_GET_FTM_T2_TSF_8814B(x)                                            \
	(((x) >> BIT_SHIFT_FTM_T2_TSF_8814B) & BIT_MASK_FTM_T2_TSF_8814B)
#define BIT_SET_FTM_T2_TSF_8814B(x, v)                                         \
	(BIT_CLEAR_FTM_T2_TSF_8814B(x) | BIT_FTM_T2_TSF_8814B(v))

#define BIT_SHIFT_FTM_T1_TSF_8814B 0
#define BIT_MASK_FTM_T1_TSF_8814B 0xffff
#define BIT_FTM_T1_TSF_8814B(x)                                                \
	(((x) & BIT_MASK_FTM_T1_TSF_8814B) << BIT_SHIFT_FTM_T1_TSF_8814B)
#define BITS_FTM_T1_TSF_8814B                                                  \
	(BIT_MASK_FTM_T1_TSF_8814B << BIT_SHIFT_FTM_T1_TSF_8814B)
#define BIT_CLEAR_FTM_T1_TSF_8814B(x) ((x) & (~BITS_FTM_T1_TSF_8814B))
#define BIT_GET_FTM_T1_TSF_8814B(x)                                            \
	(((x) >> BIT_SHIFT_FTM_T1_TSF_8814B) & BIT_MASK_FTM_T1_TSF_8814B)
#define BIT_SET_FTM_T1_TSF_8814B(x, v)                                         \
	(BIT_CLEAR_FTM_T1_TSF_8814B(x) | BIT_FTM_T1_TSF_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HGQ_TIMEOUT_PERIOD_8814B */

#define BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8814B 0
#define BIT_MASK_HGQ_TIMEOUT_PERIOD_8814B 0xff
#define BIT_HGQ_TIMEOUT_PERIOD_8814B(x)                                        \
	(((x) & BIT_MASK_HGQ_TIMEOUT_PERIOD_8814B)                             \
	 << BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8814B)
#define BITS_HGQ_TIMEOUT_PERIOD_8814B                                          \
	(BIT_MASK_HGQ_TIMEOUT_PERIOD_8814B                                     \
	 << BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8814B)
#define BIT_CLEAR_HGQ_TIMEOUT_PERIOD_8814B(x)                                  \
	((x) & (~BITS_HGQ_TIMEOUT_PERIOD_8814B))
#define BIT_GET_HGQ_TIMEOUT_PERIOD_8814B(x)                                    \
	(((x) >> BIT_SHIFT_HGQ_TIMEOUT_PERIOD_8814B) &                         \
	 BIT_MASK_HGQ_TIMEOUT_PERIOD_8814B)
#define BIT_SET_HGQ_TIMEOUT_PERIOD_8814B(x, v)                                 \
	(BIT_CLEAR_HGQ_TIMEOUT_PERIOD_8814B(x) |                               \
	 BIT_HGQ_TIMEOUT_PERIOD_8814B(v))

/* 2 REG_TXCMD_TIMEOUT_PERIOD_8814B */

#define BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8814B 0
#define BIT_MASK_TXCMD_TIMEOUT_PERIOD_8814B 0xff
#define BIT_TXCMD_TIMEOUT_PERIOD_8814B(x)                                      \
	(((x) & BIT_MASK_TXCMD_TIMEOUT_PERIOD_8814B)                           \
	 << BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8814B)
#define BITS_TXCMD_TIMEOUT_PERIOD_8814B                                        \
	(BIT_MASK_TXCMD_TIMEOUT_PERIOD_8814B                                   \
	 << BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8814B)
#define BIT_CLEAR_TXCMD_TIMEOUT_PERIOD_8814B(x)                                \
	((x) & (~BITS_TXCMD_TIMEOUT_PERIOD_8814B))
#define BIT_GET_TXCMD_TIMEOUT_PERIOD_8814B(x)                                  \
	(((x) >> BIT_SHIFT_TXCMD_TIMEOUT_PERIOD_8814B) &                       \
	 BIT_MASK_TXCMD_TIMEOUT_PERIOD_8814B)
#define BIT_SET_TXCMD_TIMEOUT_PERIOD_8814B(x, v)                               \
	(BIT_CLEAR_TXCMD_TIMEOUT_PERIOD_8814B(x) |                             \
	 BIT_TXCMD_TIMEOUT_PERIOD_8814B(v))

/* 2 REG_MISC_CTRL_8814B */
#define BIT_DIS_SECONDARY_CCA_80M_8814B BIT(2)
#define BIT_DIS_SECONDARY_CCA_40M_8814B BIT(1)
#define BIT_DIS_SECONDARY_CCA_20M_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_TXOP_MIN_8814B */
#define BIT_HIQ_NAV_BREAK_EN_8814B BIT(15)
#define BIT_MGQ_NAV_BREAK_EN_8814B BIT(14)

#define BIT_SHIFT_TXOP_MIN_8814B 0
#define BIT_MASK_TXOP_MIN_8814B 0x3fff
#define BIT_TXOP_MIN_8814B(x)                                                  \
	(((x) & BIT_MASK_TXOP_MIN_8814B) << BIT_SHIFT_TXOP_MIN_8814B)
#define BITS_TXOP_MIN_8814B                                                    \
	(BIT_MASK_TXOP_MIN_8814B << BIT_SHIFT_TXOP_MIN_8814B)
#define BIT_CLEAR_TXOP_MIN_8814B(x) ((x) & (~BITS_TXOP_MIN_8814B))
#define BIT_GET_TXOP_MIN_8814B(x)                                              \
	(((x) >> BIT_SHIFT_TXOP_MIN_8814B) & BIT_MASK_TXOP_MIN_8814B)
#define BIT_SET_TXOP_MIN_8814B(x, v)                                           \
	(BIT_CLEAR_TXOP_MIN_8814B(x) | BIT_TXOP_MIN_8814B(v))

/* 2 REG_PRE_BKF_TIME_8814B */

#define BIT_SHIFT_PRE_BKF_TIME_8814B 0
#define BIT_MASK_PRE_BKF_TIME_8814B 0xff
#define BIT_PRE_BKF_TIME_8814B(x)                                              \
	(((x) & BIT_MASK_PRE_BKF_TIME_8814B) << BIT_SHIFT_PRE_BKF_TIME_8814B)
#define BITS_PRE_BKF_TIME_8814B                                                \
	(BIT_MASK_PRE_BKF_TIME_8814B << BIT_SHIFT_PRE_BKF_TIME_8814B)
#define BIT_CLEAR_PRE_BKF_TIME_8814B(x) ((x) & (~BITS_PRE_BKF_TIME_8814B))
#define BIT_GET_PRE_BKF_TIME_8814B(x)                                          \
	(((x) >> BIT_SHIFT_PRE_BKF_TIME_8814B) & BIT_MASK_PRE_BKF_TIME_8814B)
#define BIT_SET_PRE_BKF_TIME_8814B(x, v)                                       \
	(BIT_CLEAR_PRE_BKF_TIME_8814B(x) | BIT_PRE_BKF_TIME_8814B(v))

/* 2 REG_CROSS_TXOP_CTRL_8814B */
#define BIT_TBTT_RETRY_8814B BIT(4)
#define BIT_TXFAIL_BREACK_TXOP_EN_8814B BIT(3)
#define BIT_RTS_NAV_TXOP_8814B BIT(1)
#define BIT_NOT_CROSS_TXOP_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_ACMHWCTRL_8814B */
#define BIT_BEQ_ACM_STATUS_8814B BIT(7)
#define BIT_VIQ_ACM_STATUS_8814B BIT(6)
#define BIT_VOQ_ACM_STATUS_8814B BIT(5)
#define BIT_BEQ_ACM_EN_8814B BIT(3)
#define BIT_VIQ_ACM_EN_8814B BIT(2)
#define BIT_VOQ_ACM_EN_8814B BIT(1)
#define BIT_ACMHWEN_8814B BIT(0)

/* 2 REG_ACMRSTCTRL_8814B */
#define BIT_BE_ACM_RESET_USED_TIME_8814B BIT(2)
#define BIT_VI_ACM_RESET_USED_TIME_8814B BIT(1)
#define BIT_VO_ACM_RESET_USED_TIME_8814B BIT(0)

/* 2 REG_ACMAVG_8814B */

#define BIT_SHIFT_AVGPERIOD_8814B 0
#define BIT_MASK_AVGPERIOD_8814B 0xffff
#define BIT_AVGPERIOD_8814B(x)                                                 \
	(((x) & BIT_MASK_AVGPERIOD_8814B) << BIT_SHIFT_AVGPERIOD_8814B)
#define BITS_AVGPERIOD_8814B                                                   \
	(BIT_MASK_AVGPERIOD_8814B << BIT_SHIFT_AVGPERIOD_8814B)
#define BIT_CLEAR_AVGPERIOD_8814B(x) ((x) & (~BITS_AVGPERIOD_8814B))
#define BIT_GET_AVGPERIOD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_AVGPERIOD_8814B) & BIT_MASK_AVGPERIOD_8814B)
#define BIT_SET_AVGPERIOD_8814B(x, v)                                          \
	(BIT_CLEAR_AVGPERIOD_8814B(x) | BIT_AVGPERIOD_8814B(v))

/* 2 REG_VO_ADMTIME_8814B */

#define BIT_SHIFT_VO_ADMITTED_TIME_8814B 0
#define BIT_MASK_VO_ADMITTED_TIME_8814B 0xffff
#define BIT_VO_ADMITTED_TIME_8814B(x)                                          \
	(((x) & BIT_MASK_VO_ADMITTED_TIME_8814B)                               \
	 << BIT_SHIFT_VO_ADMITTED_TIME_8814B)
#define BITS_VO_ADMITTED_TIME_8814B                                            \
	(BIT_MASK_VO_ADMITTED_TIME_8814B << BIT_SHIFT_VO_ADMITTED_TIME_8814B)
#define BIT_CLEAR_VO_ADMITTED_TIME_8814B(x)                                    \
	((x) & (~BITS_VO_ADMITTED_TIME_8814B))
#define BIT_GET_VO_ADMITTED_TIME_8814B(x)                                      \
	(((x) >> BIT_SHIFT_VO_ADMITTED_TIME_8814B) &                           \
	 BIT_MASK_VO_ADMITTED_TIME_8814B)
#define BIT_SET_VO_ADMITTED_TIME_8814B(x, v)                                   \
	(BIT_CLEAR_VO_ADMITTED_TIME_8814B(x) | BIT_VO_ADMITTED_TIME_8814B(v))

/* 2 REG_VI_ADMTIME_8814B */

#define BIT_SHIFT_VI_ADMITTED_TIME_8814B 0
#define BIT_MASK_VI_ADMITTED_TIME_8814B 0xffff
#define BIT_VI_ADMITTED_TIME_8814B(x)                                          \
	(((x) & BIT_MASK_VI_ADMITTED_TIME_8814B)                               \
	 << BIT_SHIFT_VI_ADMITTED_TIME_8814B)
#define BITS_VI_ADMITTED_TIME_8814B                                            \
	(BIT_MASK_VI_ADMITTED_TIME_8814B << BIT_SHIFT_VI_ADMITTED_TIME_8814B)
#define BIT_CLEAR_VI_ADMITTED_TIME_8814B(x)                                    \
	((x) & (~BITS_VI_ADMITTED_TIME_8814B))
#define BIT_GET_VI_ADMITTED_TIME_8814B(x)                                      \
	(((x) >> BIT_SHIFT_VI_ADMITTED_TIME_8814B) &                           \
	 BIT_MASK_VI_ADMITTED_TIME_8814B)
#define BIT_SET_VI_ADMITTED_TIME_8814B(x, v)                                   \
	(BIT_CLEAR_VI_ADMITTED_TIME_8814B(x) | BIT_VI_ADMITTED_TIME_8814B(v))

/* 2 REG_BE_ADMTIME_8814B */

#define BIT_SHIFT_BE_ADMITTED_TIME_8814B 0
#define BIT_MASK_BE_ADMITTED_TIME_8814B 0xffff
#define BIT_BE_ADMITTED_TIME_8814B(x)                                          \
	(((x) & BIT_MASK_BE_ADMITTED_TIME_8814B)                               \
	 << BIT_SHIFT_BE_ADMITTED_TIME_8814B)
#define BITS_BE_ADMITTED_TIME_8814B                                            \
	(BIT_MASK_BE_ADMITTED_TIME_8814B << BIT_SHIFT_BE_ADMITTED_TIME_8814B)
#define BIT_CLEAR_BE_ADMITTED_TIME_8814B(x)                                    \
	((x) & (~BITS_BE_ADMITTED_TIME_8814B))
#define BIT_GET_BE_ADMITTED_TIME_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BE_ADMITTED_TIME_8814B) &                           \
	 BIT_MASK_BE_ADMITTED_TIME_8814B)
#define BIT_SET_BE_ADMITTED_TIME_8814B(x, v)                                   \
	(BIT_CLEAR_BE_ADMITTED_TIME_8814B(x) | BIT_BE_ADMITTED_TIME_8814B(v))

/* 2 REG_MAC_HEADER_NAV_OFFSET_8814B */

#define BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8814B 0
#define BIT_MASK_MAC_HEADER_NAV_OFFSET_8814B 0xff
#define BIT_MAC_HEADER_NAV_OFFSET_8814B(x)                                     \
	(((x) & BIT_MASK_MAC_HEADER_NAV_OFFSET_8814B)                          \
	 << BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8814B)
#define BITS_MAC_HEADER_NAV_OFFSET_8814B                                       \
	(BIT_MASK_MAC_HEADER_NAV_OFFSET_8814B                                  \
	 << BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8814B)
#define BIT_CLEAR_MAC_HEADER_NAV_OFFSET_8814B(x)                               \
	((x) & (~BITS_MAC_HEADER_NAV_OFFSET_8814B))
#define BIT_GET_MAC_HEADER_NAV_OFFSET_8814B(x)                                 \
	(((x) >> BIT_SHIFT_MAC_HEADER_NAV_OFFSET_8814B) &                      \
	 BIT_MASK_MAC_HEADER_NAV_OFFSET_8814B)
#define BIT_SET_MAC_HEADER_NAV_OFFSET_8814B(x, v)                              \
	(BIT_CLEAR_MAC_HEADER_NAV_OFFSET_8814B(x) |                            \
	 BIT_MAC_HEADER_NAV_OFFSET_8814B(v))

/* 2 REG_DIS_NDPA_NAV_CHECK_8814B */
#define BIT_DIS_NDPA_NAV_CHECK_8814B BIT(0)

/* 2 REG_EDCA_RANDOM_GEN_8814B */

#define BIT_SHIFT_RANDOM_GEN_8814B 0
#define BIT_MASK_RANDOM_GEN_8814B 0xffffff
#define BIT_RANDOM_GEN_8814B(x)                                                \
	(((x) & BIT_MASK_RANDOM_GEN_8814B) << BIT_SHIFT_RANDOM_GEN_8814B)
#define BITS_RANDOM_GEN_8814B                                                  \
	(BIT_MASK_RANDOM_GEN_8814B << BIT_SHIFT_RANDOM_GEN_8814B)
#define BIT_CLEAR_RANDOM_GEN_8814B(x) ((x) & (~BITS_RANDOM_GEN_8814B))
#define BIT_GET_RANDOM_GEN_8814B(x)                                            \
	(((x) >> BIT_SHIFT_RANDOM_GEN_8814B) & BIT_MASK_RANDOM_GEN_8814B)
#define BIT_SET_RANDOM_GEN_8814B(x, v)                                         \
	(BIT_CLEAR_RANDOM_GEN_8814B(x) | BIT_RANDOM_GEN_8814B(v))

/* 2 REG_TXCMD_SEL_8814B */

#define BIT_SHIFT_TXCMD_SEG_SEL_8814B 0
#define BIT_MASK_TXCMD_SEG_SEL_8814B 0xf
#define BIT_TXCMD_SEG_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_TXCMD_SEG_SEL_8814B) << BIT_SHIFT_TXCMD_SEG_SEL_8814B)
#define BITS_TXCMD_SEG_SEL_8814B                                               \
	(BIT_MASK_TXCMD_SEG_SEL_8814B << BIT_SHIFT_TXCMD_SEG_SEL_8814B)
#define BIT_CLEAR_TXCMD_SEG_SEL_8814B(x) ((x) & (~BITS_TXCMD_SEG_SEL_8814B))
#define BIT_GET_TXCMD_SEG_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TXCMD_SEG_SEL_8814B) & BIT_MASK_TXCMD_SEG_SEL_8814B)
#define BIT_SET_TXCMD_SEG_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_TXCMD_SEG_SEL_8814B(x) | BIT_TXCMD_SEG_SEL_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_MU_DBG_INFO_8814B */

#define BIT_SHIFT_MU_DBG_INFO_8814B 0
#define BIT_MASK_MU_DBG_INFO_8814B 0xffffffffL
#define BIT_MU_DBG_INFO_8814B(x)                                               \
	(((x) & BIT_MASK_MU_DBG_INFO_8814B) << BIT_SHIFT_MU_DBG_INFO_8814B)
#define BITS_MU_DBG_INFO_8814B                                                 \
	(BIT_MASK_MU_DBG_INFO_8814B << BIT_SHIFT_MU_DBG_INFO_8814B)
#define BIT_CLEAR_MU_DBG_INFO_8814B(x) ((x) & (~BITS_MU_DBG_INFO_8814B))
#define BIT_GET_MU_DBG_INFO_8814B(x)                                           \
	(((x) >> BIT_SHIFT_MU_DBG_INFO_8814B) & BIT_MASK_MU_DBG_INFO_8814B)
#define BIT_SET_MU_DBG_INFO_8814B(x, v)                                        \
	(BIT_CLEAR_MU_DBG_INFO_8814B(x) | BIT_MU_DBG_INFO_8814B(v))

/* 2 REG_MU_DBG_INFO_1_8814B */

#define BIT_SHIFT_MU_DBG_INFO_1_8814B 0
#define BIT_MASK_MU_DBG_INFO_1_8814B 0xffffffffL
#define BIT_MU_DBG_INFO_1_8814B(x)                                             \
	(((x) & BIT_MASK_MU_DBG_INFO_1_8814B) << BIT_SHIFT_MU_DBG_INFO_1_8814B)
#define BITS_MU_DBG_INFO_1_8814B                                               \
	(BIT_MASK_MU_DBG_INFO_1_8814B << BIT_SHIFT_MU_DBG_INFO_1_8814B)
#define BIT_CLEAR_MU_DBG_INFO_1_8814B(x) ((x) & (~BITS_MU_DBG_INFO_1_8814B))
#define BIT_GET_MU_DBG_INFO_1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_MU_DBG_INFO_1_8814B) & BIT_MASK_MU_DBG_INFO_1_8814B)
#define BIT_SET_MU_DBG_INFO_1_8814B(x, v)                                      \
	(BIT_CLEAR_MU_DBG_INFO_1_8814B(x) | BIT_MU_DBG_INFO_1_8814B(v))

/* 2 REG_SCH_DBG_SEL_8814B */

#define BIT_SHIFT_SCH_DBG_SEL_8814B 0
#define BIT_MASK_SCH_DBG_SEL_8814B 0xff
#define BIT_SCH_DBG_SEL_8814B(x)                                               \
	(((x) & BIT_MASK_SCH_DBG_SEL_8814B) << BIT_SHIFT_SCH_DBG_SEL_8814B)
#define BITS_SCH_DBG_SEL_8814B                                                 \
	(BIT_MASK_SCH_DBG_SEL_8814B << BIT_SHIFT_SCH_DBG_SEL_8814B)
#define BIT_CLEAR_SCH_DBG_SEL_8814B(x) ((x) & (~BITS_SCH_DBG_SEL_8814B))
#define BIT_GET_SCH_DBG_SEL_8814B(x)                                           \
	(((x) >> BIT_SHIFT_SCH_DBG_SEL_8814B) & BIT_MASK_SCH_DBG_SEL_8814B)
#define BIT_SET_SCH_DBG_SEL_8814B(x, v)                                        \
	(BIT_CLEAR_SCH_DBG_SEL_8814B(x) | BIT_SCH_DBG_SEL_8814B(v))

/* 2 REG_SCHEDULER_RST_8814B */
#define BIT_SCHEDULER_RST_V1_8814B BIT(0)

/* 2 REG_MU_DBG_ERR_FLAG_8814B */
#define BIT_BCN_PORTID_ERR_8814B BIT(2)

#define BIT_SHIFT_MU_DBG_ERR_FLAG_8814B 0
#define BIT_MASK_MU_DBG_ERR_FLAG_8814B 0x3
#define BIT_MU_DBG_ERR_FLAG_8814B(x)                                           \
	(((x) & BIT_MASK_MU_DBG_ERR_FLAG_8814B)                                \
	 << BIT_SHIFT_MU_DBG_ERR_FLAG_8814B)
#define BITS_MU_DBG_ERR_FLAG_8814B                                             \
	(BIT_MASK_MU_DBG_ERR_FLAG_8814B << BIT_SHIFT_MU_DBG_ERR_FLAG_8814B)
#define BIT_CLEAR_MU_DBG_ERR_FLAG_8814B(x) ((x) & (~BITS_MU_DBG_ERR_FLAG_8814B))
#define BIT_GET_MU_DBG_ERR_FLAG_8814B(x)                                       \
	(((x) >> BIT_SHIFT_MU_DBG_ERR_FLAG_8814B) &                            \
	 BIT_MASK_MU_DBG_ERR_FLAG_8814B)
#define BIT_SET_MU_DBG_ERR_FLAG_8814B(x, v)                                    \
	(BIT_CLEAR_MU_DBG_ERR_FLAG_8814B(x) | BIT_MU_DBG_ERR_FLAG_8814B(v))

/* 2 REG_TX_ERR_RECOVERY_RST_8814B */

#define BIT_SHIFT_ERR_RECOVER_CNT_8814B 4
#define BIT_MASK_ERR_RECOVER_CNT_8814B 0xf
#define BIT_ERR_RECOVER_CNT_8814B(x)                                           \
	(((x) & BIT_MASK_ERR_RECOVER_CNT_8814B)                                \
	 << BIT_SHIFT_ERR_RECOVER_CNT_8814B)
#define BITS_ERR_RECOVER_CNT_8814B                                             \
	(BIT_MASK_ERR_RECOVER_CNT_8814B << BIT_SHIFT_ERR_RECOVER_CNT_8814B)
#define BIT_CLEAR_ERR_RECOVER_CNT_8814B(x) ((x) & (~BITS_ERR_RECOVER_CNT_8814B))
#define BIT_GET_ERR_RECOVER_CNT_8814B(x)                                       \
	(((x) >> BIT_SHIFT_ERR_RECOVER_CNT_8814B) &                            \
	 BIT_MASK_ERR_RECOVER_CNT_8814B)
#define BIT_SET_ERR_RECOVER_CNT_8814B(x, v)                                    \
	(BIT_CLEAR_ERR_RECOVER_CNT_8814B(x) | BIT_ERR_RECOVER_CNT_8814B(v))

#define BIT_RX_HANG_ERR_8814B BIT(2)
#define BIT_TX_HANG_ERR_8814B BIT(1)
#define BIT_TX_ERR_RECOVERY_RST_8814B BIT(0)

/* 2 REG_SCH_DBG_VALUE_8814B */

#define BIT_SHIFT_SCH_DBG_VALUE_8814B 0
#define BIT_MASK_SCH_DBG_VALUE_8814B 0xffffffffL
#define BIT_SCH_DBG_VALUE_8814B(x)                                             \
	(((x) & BIT_MASK_SCH_DBG_VALUE_8814B) << BIT_SHIFT_SCH_DBG_VALUE_8814B)
#define BITS_SCH_DBG_VALUE_8814B                                               \
	(BIT_MASK_SCH_DBG_VALUE_8814B << BIT_SHIFT_SCH_DBG_VALUE_8814B)
#define BIT_CLEAR_SCH_DBG_VALUE_8814B(x) ((x) & (~BITS_SCH_DBG_VALUE_8814B))
#define BIT_GET_SCH_DBG_VALUE_8814B(x)                                         \
	(((x) >> BIT_SHIFT_SCH_DBG_VALUE_8814B) & BIT_MASK_SCH_DBG_VALUE_8814B)
#define BIT_SET_SCH_DBG_VALUE_8814B(x, v)                                      \
	(BIT_CLEAR_SCH_DBG_VALUE_8814B(x) | BIT_SCH_DBG_VALUE_8814B(v))

/* 2 REG_SCH_TXCMD_8814B */

#define BIT_SHIFT_SCH_TXCMD_8814B 0
#define BIT_MASK_SCH_TXCMD_8814B 0xffffffffL
#define BIT_SCH_TXCMD_8814B(x)                                                 \
	(((x) & BIT_MASK_SCH_TXCMD_8814B) << BIT_SHIFT_SCH_TXCMD_8814B)
#define BITS_SCH_TXCMD_8814B                                                   \
	(BIT_MASK_SCH_TXCMD_8814B << BIT_SHIFT_SCH_TXCMD_8814B)
#define BIT_CLEAR_SCH_TXCMD_8814B(x) ((x) & (~BITS_SCH_TXCMD_8814B))
#define BIT_GET_SCH_TXCMD_8814B(x)                                             \
	(((x) >> BIT_SHIFT_SCH_TXCMD_8814B) & BIT_MASK_SCH_TXCMD_8814B)
#define BIT_SET_SCH_TXCMD_8814B(x, v)                                          \
	(BIT_CLEAR_SCH_TXCMD_8814B(x) | BIT_SCH_TXCMD_8814B(v))

/* 2 REG_PAGE5_DUMMY_8814B */

/* 2 REG_PORT_CTRL_SEL_8814B */

#define BIT_SHIFT_BCN_TIMER_SEL_FWRD_V1_8814B 4
#define BIT_MASK_BCN_TIMER_SEL_FWRD_V1_8814B 0x7
#define BIT_BCN_TIMER_SEL_FWRD_V1_8814B(x)                                     \
	(((x) & BIT_MASK_BCN_TIMER_SEL_FWRD_V1_8814B)                          \
	 << BIT_SHIFT_BCN_TIMER_SEL_FWRD_V1_8814B)
#define BITS_BCN_TIMER_SEL_FWRD_V1_8814B                                       \
	(BIT_MASK_BCN_TIMER_SEL_FWRD_V1_8814B                                  \
	 << BIT_SHIFT_BCN_TIMER_SEL_FWRD_V1_8814B)
#define BIT_CLEAR_BCN_TIMER_SEL_FWRD_V1_8814B(x)                               \
	((x) & (~BITS_BCN_TIMER_SEL_FWRD_V1_8814B))
#define BIT_GET_BCN_TIMER_SEL_FWRD_V1_8814B(x)                                 \
	(((x) >> BIT_SHIFT_BCN_TIMER_SEL_FWRD_V1_8814B) &                      \
	 BIT_MASK_BCN_TIMER_SEL_FWRD_V1_8814B)
#define BIT_SET_BCN_TIMER_SEL_FWRD_V1_8814B(x, v)                              \
	(BIT_CLEAR_BCN_TIMER_SEL_FWRD_V1_8814B(x) |                            \
	 BIT_BCN_TIMER_SEL_FWRD_V1_8814B(v))

#define BIT_SHIFT_PORT_CTRL_SEL_8814B 0
#define BIT_MASK_PORT_CTRL_SEL_8814B 0x7
#define BIT_PORT_CTRL_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_PORT_CTRL_SEL_8814B) << BIT_SHIFT_PORT_CTRL_SEL_8814B)
#define BITS_PORT_CTRL_SEL_8814B                                               \
	(BIT_MASK_PORT_CTRL_SEL_8814B << BIT_SHIFT_PORT_CTRL_SEL_8814B)
#define BIT_CLEAR_PORT_CTRL_SEL_8814B(x) ((x) & (~BITS_PORT_CTRL_SEL_8814B))
#define BIT_GET_PORT_CTRL_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_PORT_CTRL_SEL_8814B) & BIT_MASK_PORT_CTRL_SEL_8814B)
#define BIT_SET_PORT_CTRL_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_PORT_CTRL_SEL_8814B(x) | BIT_PORT_CTRL_SEL_8814B(v))

/* 2 REG_PORT_CTRL_CFG_8814B */
#define BIT_BCNERR_CNT_EN_V1_8814B BIT(11)
#define BIT_DIS_TRX_CAL_BCN_V1_8814B BIT(10)
#define BIT_DIS_TX_CAL_TBTT_V1_8814B BIT(9)
#define BIT_BCN_AGGRESSION_V1_8814B BIT(8)
#define BIT_TSFTR_RST_V1_8814B BIT(7)
#define BIT_DIS_RX_BSSID_FIT_8814B BIT(6)
#define BIT_EN_TXBCN_RPT_V1_8814B BIT(5)
#define BIT_DIS_TSF_UDT_8814B BIT(4)
#define BIT_EN_PORT_FUNCTION_8814B BIT(3)
#define BIT_EN_RXBCN_RPT_8814B BIT(2)
#define BIT_EN_P2P_CTWINDOW_8814B BIT(1)
#define BIT_EN_P2P_BCNQ_AREA_8814B BIT(0)

/* 2 REG_TBTT_PROHIBIT_CFG_8814B */
#define BIT_MASK_PROHIBIT_8814B BIT(23)

#define BIT_SHIFT_TBTT_HOLD_TIME_8814B 8
#define BIT_MASK_TBTT_HOLD_TIME_8814B 0xfff
#define BIT_TBTT_HOLD_TIME_8814B(x)                                            \
	(((x) & BIT_MASK_TBTT_HOLD_TIME_8814B)                                 \
	 << BIT_SHIFT_TBTT_HOLD_TIME_8814B)
#define BITS_TBTT_HOLD_TIME_8814B                                              \
	(BIT_MASK_TBTT_HOLD_TIME_8814B << BIT_SHIFT_TBTT_HOLD_TIME_8814B)
#define BIT_CLEAR_TBTT_HOLD_TIME_8814B(x) ((x) & (~BITS_TBTT_HOLD_TIME_8814B))
#define BIT_GET_TBTT_HOLD_TIME_8814B(x)                                        \
	(((x) >> BIT_SHIFT_TBTT_HOLD_TIME_8814B) &                             \
	 BIT_MASK_TBTT_HOLD_TIME_8814B)
#define BIT_SET_TBTT_HOLD_TIME_8814B(x, v)                                     \
	(BIT_CLEAR_TBTT_HOLD_TIME_8814B(x) | BIT_TBTT_HOLD_TIME_8814B(v))

#define BIT_SHIFT_TBTT_PROHIBIT_SETUP_8814B 0
#define BIT_MASK_TBTT_PROHIBIT_SETUP_8814B 0xf
#define BIT_TBTT_PROHIBIT_SETUP_8814B(x)                                       \
	(((x) & BIT_MASK_TBTT_PROHIBIT_SETUP_8814B)                            \
	 << BIT_SHIFT_TBTT_PROHIBIT_SETUP_8814B)
#define BITS_TBTT_PROHIBIT_SETUP_8814B                                         \
	(BIT_MASK_TBTT_PROHIBIT_SETUP_8814B                                    \
	 << BIT_SHIFT_TBTT_PROHIBIT_SETUP_8814B)
#define BIT_CLEAR_TBTT_PROHIBIT_SETUP_8814B(x)                                 \
	((x) & (~BITS_TBTT_PROHIBIT_SETUP_8814B))
#define BIT_GET_TBTT_PROHIBIT_SETUP_8814B(x)                                   \
	(((x) >> BIT_SHIFT_TBTT_PROHIBIT_SETUP_8814B) &                        \
	 BIT_MASK_TBTT_PROHIBIT_SETUP_8814B)
#define BIT_SET_TBTT_PROHIBIT_SETUP_8814B(x, v)                                \
	(BIT_CLEAR_TBTT_PROHIBIT_SETUP_8814B(x) |                              \
	 BIT_TBTT_PROHIBIT_SETUP_8814B(v))

/* 2 REG_DRVERLYINT_CFG_8814B */

#define BIT_SHIFT_DRVERLYITV_8814B 0
#define BIT_MASK_DRVERLYITV_8814B 0xff
#define BIT_DRVERLYITV_8814B(x)                                                \
	(((x) & BIT_MASK_DRVERLYITV_8814B) << BIT_SHIFT_DRVERLYITV_8814B)
#define BITS_DRVERLYITV_8814B                                                  \
	(BIT_MASK_DRVERLYITV_8814B << BIT_SHIFT_DRVERLYITV_8814B)
#define BIT_CLEAR_DRVERLYITV_8814B(x) ((x) & (~BITS_DRVERLYITV_8814B))
#define BIT_GET_DRVERLYITV_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DRVERLYITV_8814B) & BIT_MASK_DRVERLYITV_8814B)
#define BIT_SET_DRVERLYITV_8814B(x, v)                                         \
	(BIT_CLEAR_DRVERLYITV_8814B(x) | BIT_DRVERLYITV_8814B(v))

/* 2 REG_BCNDMATIM_CFG_8814B */

#define BIT_SHIFT_BCNDMATIM_8814B 0
#define BIT_MASK_BCNDMATIM_8814B 0xff
#define BIT_BCNDMATIM_8814B(x)                                                 \
	(((x) & BIT_MASK_BCNDMATIM_8814B) << BIT_SHIFT_BCNDMATIM_8814B)
#define BITS_BCNDMATIM_8814B                                                   \
	(BIT_MASK_BCNDMATIM_8814B << BIT_SHIFT_BCNDMATIM_8814B)
#define BIT_CLEAR_BCNDMATIM_8814B(x) ((x) & (~BITS_BCNDMATIM_8814B))
#define BIT_GET_BCNDMATIM_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCNDMATIM_8814B) & BIT_MASK_BCNDMATIM_8814B)
#define BIT_SET_BCNDMATIM_8814B(x, v)                                          \
	(BIT_CLEAR_BCNDMATIM_8814B(x) | BIT_BCNDMATIM_8814B(v))

/* 2 REG_CTWND_CFG_8814B */

#define BIT_SHIFT_CTWND_8814B 0
#define BIT_MASK_CTWND_8814B 0xff
#define BIT_CTWND_8814B(x)                                                     \
	(((x) & BIT_MASK_CTWND_8814B) << BIT_SHIFT_CTWND_8814B)
#define BITS_CTWND_8814B (BIT_MASK_CTWND_8814B << BIT_SHIFT_CTWND_8814B)
#define BIT_CLEAR_CTWND_8814B(x) ((x) & (~BITS_CTWND_8814B))
#define BIT_GET_CTWND_8814B(x)                                                 \
	(((x) >> BIT_SHIFT_CTWND_8814B) & BIT_MASK_CTWND_8814B)
#define BIT_SET_CTWND_8814B(x, v)                                              \
	(BIT_CLEAR_CTWND_8814B(x) | BIT_CTWND_8814B(v))

/* 2 REG_BCNIVLCUNT_CFG_8814B */

/* 2 REG_NOT_VALID_8814B */

#define BIT_SHIFT_BCNIVLCUNT_8814B 0
#define BIT_MASK_BCNIVLCUNT_8814B 0x7f
#define BIT_BCNIVLCUNT_8814B(x)                                                \
	(((x) & BIT_MASK_BCNIVLCUNT_8814B) << BIT_SHIFT_BCNIVLCUNT_8814B)
#define BITS_BCNIVLCUNT_8814B                                                  \
	(BIT_MASK_BCNIVLCUNT_8814B << BIT_SHIFT_BCNIVLCUNT_8814B)
#define BIT_CLEAR_BCNIVLCUNT_8814B(x) ((x) & (~BITS_BCNIVLCUNT_8814B))
#define BIT_GET_BCNIVLCUNT_8814B(x)                                            \
	(((x) >> BIT_SHIFT_BCNIVLCUNT_8814B) & BIT_MASK_BCNIVLCUNT_8814B)
#define BIT_SET_BCNIVLCUNT_8814B(x, v)                                         \
	(BIT_CLEAR_BCNIVLCUNT_8814B(x) | BIT_BCNIVLCUNT_8814B(v))

/* 2 REG_EARLY_128US_CFG_8814B */

#define BIT_SHIFT_EARLY_128US_8814B 0
#define BIT_MASK_EARLY_128US_8814B 0x7
#define BIT_EARLY_128US_8814B(x)                                               \
	(((x) & BIT_MASK_EARLY_128US_8814B) << BIT_SHIFT_EARLY_128US_8814B)
#define BITS_EARLY_128US_8814B                                                 \
	(BIT_MASK_EARLY_128US_8814B << BIT_SHIFT_EARLY_128US_8814B)
#define BIT_CLEAR_EARLY_128US_8814B(x) ((x) & (~BITS_EARLY_128US_8814B))
#define BIT_GET_EARLY_128US_8814B(x)                                           \
	(((x) >> BIT_SHIFT_EARLY_128US_8814B) & BIT_MASK_EARLY_128US_8814B)
#define BIT_SET_EARLY_128US_8814B(x, v)                                        \
	(BIT_CLEAR_EARLY_128US_8814B(x) | BIT_EARLY_128US_8814B(v))

/* 2 REG_TSFTR_SYNC_OFFSET_CFG_8814B */

#define BIT_SHIFT_TSFTR_SNC_OFFSET_V1_8814B 0
#define BIT_MASK_TSFTR_SNC_OFFSET_V1_8814B 0xffffff
#define BIT_TSFTR_SNC_OFFSET_V1_8814B(x)                                       \
	(((x) & BIT_MASK_TSFTR_SNC_OFFSET_V1_8814B)                            \
	 << BIT_SHIFT_TSFTR_SNC_OFFSET_V1_8814B)
#define BITS_TSFTR_SNC_OFFSET_V1_8814B                                         \
	(BIT_MASK_TSFTR_SNC_OFFSET_V1_8814B                                    \
	 << BIT_SHIFT_TSFTR_SNC_OFFSET_V1_8814B)
#define BIT_CLEAR_TSFTR_SNC_OFFSET_V1_8814B(x)                                 \
	((x) & (~BITS_TSFTR_SNC_OFFSET_V1_8814B))
#define BIT_GET_TSFTR_SNC_OFFSET_V1_8814B(x)                                   \
	(((x) >> BIT_SHIFT_TSFTR_SNC_OFFSET_V1_8814B) &                        \
	 BIT_MASK_TSFTR_SNC_OFFSET_V1_8814B)
#define BIT_SET_TSFTR_SNC_OFFSET_V1_8814B(x, v)                                \
	(BIT_CLEAR_TSFTR_SNC_OFFSET_V1_8814B(x) |                              \
	 BIT_TSFTR_SNC_OFFSET_V1_8814B(v))

/* 2 REG_TSFTR_SYNC_CTRL_CFG_8814B */
#define BIT_SYNC_TSF_NOW_V1_8814B BIT(5)
#define BIT_SYNC_TSF_ONCE_8814B BIT(4)
#define BIT_SYNC_TSF_AUTO_8814B BIT(3)

#define BIT_SHIFT_SYNC_PORT_SEL_8814B 0
#define BIT_MASK_SYNC_PORT_SEL_8814B 0x7
#define BIT_SYNC_PORT_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_SYNC_PORT_SEL_8814B) << BIT_SHIFT_SYNC_PORT_SEL_8814B)
#define BITS_SYNC_PORT_SEL_8814B                                               \
	(BIT_MASK_SYNC_PORT_SEL_8814B << BIT_SHIFT_SYNC_PORT_SEL_8814B)
#define BIT_CLEAR_SYNC_PORT_SEL_8814B(x) ((x) & (~BITS_SYNC_PORT_SEL_8814B))
#define BIT_GET_SYNC_PORT_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_SYNC_PORT_SEL_8814B) & BIT_MASK_SYNC_PORT_SEL_8814B)
#define BIT_SET_SYNC_PORT_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_SYNC_PORT_SEL_8814B(x) | BIT_SYNC_PORT_SEL_8814B(v))

/* 2 REG_BCN_SPACE_CFG_8814B */

#define BIT_SHIFT_BCN_SPACE_8814B 0
#define BIT_MASK_BCN_SPACE_8814B 0xffff
#define BIT_BCN_SPACE_8814B(x)                                                 \
	(((x) & BIT_MASK_BCN_SPACE_8814B) << BIT_SHIFT_BCN_SPACE_8814B)
#define BITS_BCN_SPACE_8814B                                                   \
	(BIT_MASK_BCN_SPACE_8814B << BIT_SHIFT_BCN_SPACE_8814B)
#define BIT_CLEAR_BCN_SPACE_8814B(x) ((x) & (~BITS_BCN_SPACE_8814B))
#define BIT_GET_BCN_SPACE_8814B(x)                                             \
	(((x) >> BIT_SHIFT_BCN_SPACE_8814B) & BIT_MASK_BCN_SPACE_8814B)
#define BIT_SET_BCN_SPACE_8814B(x, v)                                          \
	(BIT_CLEAR_BCN_SPACE_8814B(x) | BIT_BCN_SPACE_8814B(v))

/* 2 REG_EARLY_INT_ADJUST_CFG_8814B */

#define BIT_SHIFT_EARLY_INT_ADJUST_8814B 0
#define BIT_MASK_EARLY_INT_ADJUST_8814B 0xffff
#define BIT_EARLY_INT_ADJUST_8814B(x)                                          \
	(((x) & BIT_MASK_EARLY_INT_ADJUST_8814B)                               \
	 << BIT_SHIFT_EARLY_INT_ADJUST_8814B)
#define BITS_EARLY_INT_ADJUST_8814B                                            \
	(BIT_MASK_EARLY_INT_ADJUST_8814B << BIT_SHIFT_EARLY_INT_ADJUST_8814B)
#define BIT_CLEAR_EARLY_INT_ADJUST_8814B(x)                                    \
	((x) & (~BITS_EARLY_INT_ADJUST_8814B))
#define BIT_GET_EARLY_INT_ADJUST_8814B(x)                                      \
	(((x) >> BIT_SHIFT_EARLY_INT_ADJUST_8814B) &                           \
	 BIT_MASK_EARLY_INT_ADJUST_8814B)
#define BIT_SET_EARLY_INT_ADJUST_8814B(x, v)                                   \
	(BIT_CLEAR_EARLY_INT_ADJUST_8814B(x) | BIT_EARLY_INT_ADJUST_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_SW_TBTT_TSF_INFO_8814B */

#define BIT_SHIFT_SW_TBTT_TSF_INFO_8814B 0
#define BIT_MASK_SW_TBTT_TSF_INFO_8814B 0xffffffffL
#define BIT_SW_TBTT_TSF_INFO_8814B(x)                                          \
	(((x) & BIT_MASK_SW_TBTT_TSF_INFO_8814B)                               \
	 << BIT_SHIFT_SW_TBTT_TSF_INFO_8814B)
#define BITS_SW_TBTT_TSF_INFO_8814B                                            \
	(BIT_MASK_SW_TBTT_TSF_INFO_8814B << BIT_SHIFT_SW_TBTT_TSF_INFO_8814B)
#define BIT_CLEAR_SW_TBTT_TSF_INFO_8814B(x)                                    \
	((x) & (~BITS_SW_TBTT_TSF_INFO_8814B))
#define BIT_GET_SW_TBTT_TSF_INFO_8814B(x)                                      \
	(((x) >> BIT_SHIFT_SW_TBTT_TSF_INFO_8814B) &                           \
	 BIT_MASK_SW_TBTT_TSF_INFO_8814B)
#define BIT_SET_SW_TBTT_TSF_INFO_8814B(x, v)                                   \
	(BIT_CLEAR_SW_TBTT_TSF_INFO_8814B(x) | BIT_SW_TBTT_TSF_INFO_8814B(v))

/* 2 REG_TSFTR_LOW_8814B */

#define BIT_SHIFT_TSF_TIMER_LOW_8814B 0
#define BIT_MASK_TSF_TIMER_LOW_8814B 0xffffffffL
#define BIT_TSF_TIMER_LOW_8814B(x)                                             \
	(((x) & BIT_MASK_TSF_TIMER_LOW_8814B) << BIT_SHIFT_TSF_TIMER_LOW_8814B)
#define BITS_TSF_TIMER_LOW_8814B                                               \
	(BIT_MASK_TSF_TIMER_LOW_8814B << BIT_SHIFT_TSF_TIMER_LOW_8814B)
#define BIT_CLEAR_TSF_TIMER_LOW_8814B(x) ((x) & (~BITS_TSF_TIMER_LOW_8814B))
#define BIT_GET_TSF_TIMER_LOW_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TSF_TIMER_LOW_8814B) & BIT_MASK_TSF_TIMER_LOW_8814B)
#define BIT_SET_TSF_TIMER_LOW_8814B(x, v)                                      \
	(BIT_CLEAR_TSF_TIMER_LOW_8814B(x) | BIT_TSF_TIMER_LOW_8814B(v))

/* 2 REG_TSFTR_HIGH_8814B */

#define BIT_SHIFT_TSF_TIMER_HIGH_8814B 0
#define BIT_MASK_TSF_TIMER_HIGH_8814B 0xffffffffL
#define BIT_TSF_TIMER_HIGH_8814B(x)                                            \
	(((x) & BIT_MASK_TSF_TIMER_HIGH_8814B)                                 \
	 << BIT_SHIFT_TSF_TIMER_HIGH_8814B)
#define BITS_TSF_TIMER_HIGH_8814B                                              \
	(BIT_MASK_TSF_TIMER_HIGH_8814B << BIT_SHIFT_TSF_TIMER_HIGH_8814B)
#define BIT_CLEAR_TSF_TIMER_HIGH_8814B(x) ((x) & (~BITS_TSF_TIMER_HIGH_8814B))
#define BIT_GET_TSF_TIMER_HIGH_8814B(x)                                        \
	(((x) >> BIT_SHIFT_TSF_TIMER_HIGH_8814B) &                             \
	 BIT_MASK_TSF_TIMER_HIGH_8814B)
#define BIT_SET_TSF_TIMER_HIGH_8814B(x, v)                                     \
	(BIT_CLEAR_TSF_TIMER_HIGH_8814B(x) | BIT_TSF_TIMER_HIGH_8814B(v))

/* 2 REG_BCN_ERR_CNT_MAC_8814B */

#define BIT_SHIFT_BCN_ERR_CNT_MAC_8814B 0
#define BIT_MASK_BCN_ERR_CNT_MAC_8814B 0xff
#define BIT_BCN_ERR_CNT_MAC_8814B(x)                                           \
	(((x) & BIT_MASK_BCN_ERR_CNT_MAC_8814B)                                \
	 << BIT_SHIFT_BCN_ERR_CNT_MAC_8814B)
#define BITS_BCN_ERR_CNT_MAC_8814B                                             \
	(BIT_MASK_BCN_ERR_CNT_MAC_8814B << BIT_SHIFT_BCN_ERR_CNT_MAC_8814B)
#define BIT_CLEAR_BCN_ERR_CNT_MAC_8814B(x) ((x) & (~BITS_BCN_ERR_CNT_MAC_8814B))
#define BIT_GET_BCN_ERR_CNT_MAC_8814B(x)                                       \
	(((x) >> BIT_SHIFT_BCN_ERR_CNT_MAC_8814B) &                            \
	 BIT_MASK_BCN_ERR_CNT_MAC_8814B)
#define BIT_SET_BCN_ERR_CNT_MAC_8814B(x, v)                                    \
	(BIT_CLEAR_BCN_ERR_CNT_MAC_8814B(x) | BIT_BCN_ERR_CNT_MAC_8814B(v))

/* 2 REG_BCN_ERR_CNT_EDCCA_8814B */

#define BIT_SHIFT_BCN_ERR_CNT_EDCCA_8814B 0
#define BIT_MASK_BCN_ERR_CNT_EDCCA_8814B 0xff
#define BIT_BCN_ERR_CNT_EDCCA_8814B(x)                                         \
	(((x) & BIT_MASK_BCN_ERR_CNT_EDCCA_8814B)                              \
	 << BIT_SHIFT_BCN_ERR_CNT_EDCCA_8814B)
#define BITS_BCN_ERR_CNT_EDCCA_8814B                                           \
	(BIT_MASK_BCN_ERR_CNT_EDCCA_8814B << BIT_SHIFT_BCN_ERR_CNT_EDCCA_8814B)
#define BIT_CLEAR_BCN_ERR_CNT_EDCCA_8814B(x)                                   \
	((x) & (~BITS_BCN_ERR_CNT_EDCCA_8814B))
#define BIT_GET_BCN_ERR_CNT_EDCCA_8814B(x)                                     \
	(((x) >> BIT_SHIFT_BCN_ERR_CNT_EDCCA_8814B) &                          \
	 BIT_MASK_BCN_ERR_CNT_EDCCA_8814B)
#define BIT_SET_BCN_ERR_CNT_EDCCA_8814B(x, v)                                  \
	(BIT_CLEAR_BCN_ERR_CNT_EDCCA_8814B(x) | BIT_BCN_ERR_CNT_EDCCA_8814B(v))

/* 2 REG_BCN_ERR_CNT_CCA_8814B */

#define BIT_SHIFT_BCN_ERR_CNT_CCA_8814B 0
#define BIT_MASK_BCN_ERR_CNT_CCA_8814B 0xff
#define BIT_BCN_ERR_CNT_CCA_8814B(x)                                           \
	(((x) & BIT_MASK_BCN_ERR_CNT_CCA_8814B)                                \
	 << BIT_SHIFT_BCN_ERR_CNT_CCA_8814B)
#define BITS_BCN_ERR_CNT_CCA_8814B                                             \
	(BIT_MASK_BCN_ERR_CNT_CCA_8814B << BIT_SHIFT_BCN_ERR_CNT_CCA_8814B)
#define BIT_CLEAR_BCN_ERR_CNT_CCA_8814B(x) ((x) & (~BITS_BCN_ERR_CNT_CCA_8814B))
#define BIT_GET_BCN_ERR_CNT_CCA_8814B(x)                                       \
	(((x) >> BIT_SHIFT_BCN_ERR_CNT_CCA_8814B) &                            \
	 BIT_MASK_BCN_ERR_CNT_CCA_8814B)
#define BIT_SET_BCN_ERR_CNT_CCA_8814B(x, v)                                    \
	(BIT_CLEAR_BCN_ERR_CNT_CCA_8814B(x) | BIT_BCN_ERR_CNT_CCA_8814B(v))

/* 2 REG_BCN_ERR_CNT_INVALID_8814B */

#define BIT_SHIFT_BCN_ERR_CNT_INVALID_8814B 0
#define BIT_MASK_BCN_ERR_CNT_INVALID_8814B 0xff
#define BIT_BCN_ERR_CNT_INVALID_8814B(x)                                       \
	(((x) & BIT_MASK_BCN_ERR_CNT_INVALID_8814B)                            \
	 << BIT_SHIFT_BCN_ERR_CNT_INVALID_8814B)
#define BITS_BCN_ERR_CNT_INVALID_8814B                                         \
	(BIT_MASK_BCN_ERR_CNT_INVALID_8814B                                    \
	 << BIT_SHIFT_BCN_ERR_CNT_INVALID_8814B)
#define BIT_CLEAR_BCN_ERR_CNT_INVALID_8814B(x)                                 \
	((x) & (~BITS_BCN_ERR_CNT_INVALID_8814B))
#define BIT_GET_BCN_ERR_CNT_INVALID_8814B(x)                                   \
	(((x) >> BIT_SHIFT_BCN_ERR_CNT_INVALID_8814B) &                        \
	 BIT_MASK_BCN_ERR_CNT_INVALID_8814B)
#define BIT_SET_BCN_ERR_CNT_INVALID_8814B(x, v)                                \
	(BIT_CLEAR_BCN_ERR_CNT_INVALID_8814B(x) |                              \
	 BIT_BCN_ERR_CNT_INVALID_8814B(v))

/* 2 REG_BCN_ERR_CNT_OTHERS_8814B */

#define BIT_SHIFT_BCN_ERR_CNT_OTHERS_8814B 0
#define BIT_MASK_BCN_ERR_CNT_OTHERS_8814B 0xff
#define BIT_BCN_ERR_CNT_OTHERS_8814B(x)                                        \
	(((x) & BIT_MASK_BCN_ERR_CNT_OTHERS_8814B)                             \
	 << BIT_SHIFT_BCN_ERR_CNT_OTHERS_8814B)
#define BITS_BCN_ERR_CNT_OTHERS_8814B                                          \
	(BIT_MASK_BCN_ERR_CNT_OTHERS_8814B                                     \
	 << BIT_SHIFT_BCN_ERR_CNT_OTHERS_8814B)
#define BIT_CLEAR_BCN_ERR_CNT_OTHERS_8814B(x)                                  \
	((x) & (~BITS_BCN_ERR_CNT_OTHERS_8814B))
#define BIT_GET_BCN_ERR_CNT_OTHERS_8814B(x)                                    \
	(((x) >> BIT_SHIFT_BCN_ERR_CNT_OTHERS_8814B) &                         \
	 BIT_MASK_BCN_ERR_CNT_OTHERS_8814B)
#define BIT_SET_BCN_ERR_CNT_OTHERS_8814B(x, v)                                 \
	(BIT_CLEAR_BCN_ERR_CNT_OTHERS_8814B(x) |                               \
	 BIT_BCN_ERR_CNT_OTHERS_8814B(v))

/* 2 REG_RX_BCN_TIMER_8814B */

#define BIT_SHIFT_RX_BCN_TIMER_8814B 0
#define BIT_MASK_RX_BCN_TIMER_8814B 0xffff
#define BIT_RX_BCN_TIMER_8814B(x)                                              \
	(((x) & BIT_MASK_RX_BCN_TIMER_8814B) << BIT_SHIFT_RX_BCN_TIMER_8814B)
#define BITS_RX_BCN_TIMER_8814B                                                \
	(BIT_MASK_RX_BCN_TIMER_8814B << BIT_SHIFT_RX_BCN_TIMER_8814B)
#define BIT_CLEAR_RX_BCN_TIMER_8814B(x) ((x) & (~BITS_RX_BCN_TIMER_8814B))
#define BIT_GET_RX_BCN_TIMER_8814B(x)                                          \
	(((x) >> BIT_SHIFT_RX_BCN_TIMER_8814B) & BIT_MASK_RX_BCN_TIMER_8814B)
#define BIT_SET_RX_BCN_TIMER_8814B(x, v)                                       \
	(BIT_CLEAR_RX_BCN_TIMER_8814B(x) | BIT_RX_BCN_TIMER_8814B(v))

/* 2 REG_TBTT_CTN_AREA_V1_8814B */

#define BIT_SHIFT_TBTT_CTN_AREA_8814B 0
#define BIT_MASK_TBTT_CTN_AREA_8814B 0xff
#define BIT_TBTT_CTN_AREA_8814B(x)                                             \
	(((x) & BIT_MASK_TBTT_CTN_AREA_8814B) << BIT_SHIFT_TBTT_CTN_AREA_8814B)
#define BITS_TBTT_CTN_AREA_8814B                                               \
	(BIT_MASK_TBTT_CTN_AREA_8814B << BIT_SHIFT_TBTT_CTN_AREA_8814B)
#define BIT_CLEAR_TBTT_CTN_AREA_8814B(x) ((x) & (~BITS_TBTT_CTN_AREA_8814B))
#define BIT_GET_TBTT_CTN_AREA_8814B(x)                                         \
	(((x) >> BIT_SHIFT_TBTT_CTN_AREA_8814B) & BIT_MASK_TBTT_CTN_AREA_8814B)
#define BIT_SET_TBTT_CTN_AREA_8814B(x, v)                                      \
	(BIT_CLEAR_TBTT_CTN_AREA_8814B(x) | BIT_TBTT_CTN_AREA_8814B(v))

/* 2 REG_BCN_MAX_ERR_V1_8814B */

#define BIT_SHIFT_BCN_MAX_ERR_8814B 0
#define BIT_MASK_BCN_MAX_ERR_8814B 0xff
#define BIT_BCN_MAX_ERR_8814B(x)                                               \
	(((x) & BIT_MASK_BCN_MAX_ERR_8814B) << BIT_SHIFT_BCN_MAX_ERR_8814B)
#define BITS_BCN_MAX_ERR_8814B                                                 \
	(BIT_MASK_BCN_MAX_ERR_8814B << BIT_SHIFT_BCN_MAX_ERR_8814B)
#define BIT_CLEAR_BCN_MAX_ERR_8814B(x) ((x) & (~BITS_BCN_MAX_ERR_8814B))
#define BIT_GET_BCN_MAX_ERR_8814B(x)                                           \
	(((x) >> BIT_SHIFT_BCN_MAX_ERR_8814B) & BIT_MASK_BCN_MAX_ERR_8814B)
#define BIT_SET_BCN_MAX_ERR_8814B(x, v)                                        \
	(BIT_CLEAR_BCN_MAX_ERR_8814B(x) | BIT_BCN_MAX_ERR_8814B(v))

/* 2 REG_RXTSF_OFFSET_CCK_V1_8814B */

#define BIT_SHIFT_CCK_RXTSF_OFFSET_8814B 0
#define BIT_MASK_CCK_RXTSF_OFFSET_8814B 0xff
#define BIT_CCK_RXTSF_OFFSET_8814B(x)                                          \
	(((x) & BIT_MASK_CCK_RXTSF_OFFSET_8814B)                               \
	 << BIT_SHIFT_CCK_RXTSF_OFFSET_8814B)
#define BITS_CCK_RXTSF_OFFSET_8814B                                            \
	(BIT_MASK_CCK_RXTSF_OFFSET_8814B << BIT_SHIFT_CCK_RXTSF_OFFSET_8814B)
#define BIT_CLEAR_CCK_RXTSF_OFFSET_8814B(x)                                    \
	((x) & (~BITS_CCK_RXTSF_OFFSET_8814B))
#define BIT_GET_CCK_RXTSF_OFFSET_8814B(x)                                      \
	(((x) >> BIT_SHIFT_CCK_RXTSF_OFFSET_8814B) &                           \
	 BIT_MASK_CCK_RXTSF_OFFSET_8814B)
#define BIT_SET_CCK_RXTSF_OFFSET_8814B(x, v)                                   \
	(BIT_CLEAR_CCK_RXTSF_OFFSET_8814B(x) | BIT_CCK_RXTSF_OFFSET_8814B(v))

/* 2 REG_RXTSF_OFFSET_OFDM_V1_8814B */

#define BIT_SHIFT_OFDM_RXTSF_OFFSET_8814B 0
#define BIT_MASK_OFDM_RXTSF_OFFSET_8814B 0xff
#define BIT_OFDM_RXTSF_OFFSET_8814B(x)                                         \
	(((x) & BIT_MASK_OFDM_RXTSF_OFFSET_8814B)                              \
	 << BIT_SHIFT_OFDM_RXTSF_OFFSET_8814B)
#define BITS_OFDM_RXTSF_OFFSET_8814B                                           \
	(BIT_MASK_OFDM_RXTSF_OFFSET_8814B << BIT_SHIFT_OFDM_RXTSF_OFFSET_8814B)
#define BIT_CLEAR_OFDM_RXTSF_OFFSET_8814B(x)                                   \
	((x) & (~BITS_OFDM_RXTSF_OFFSET_8814B))
#define BIT_GET_OFDM_RXTSF_OFFSET_8814B(x)                                     \
	(((x) >> BIT_SHIFT_OFDM_RXTSF_OFFSET_8814B) &                          \
	 BIT_MASK_OFDM_RXTSF_OFFSET_8814B)
#define BIT_SET_OFDM_RXTSF_OFFSET_8814B(x, v)                                  \
	(BIT_CLEAR_OFDM_RXTSF_OFFSET_8814B(x) | BIT_OFDM_RXTSF_OFFSET_8814B(v))

/* 2 REG_SUB_BCN_SPACE_8814B */

#define BIT_SHIFT_SUB_BCN_SPACE_V2_8814B 0
#define BIT_MASK_SUB_BCN_SPACE_V2_8814B 0xff
#define BIT_SUB_BCN_SPACE_V2_8814B(x)                                          \
	(((x) & BIT_MASK_SUB_BCN_SPACE_V2_8814B)                               \
	 << BIT_SHIFT_SUB_BCN_SPACE_V2_8814B)
#define BITS_SUB_BCN_SPACE_V2_8814B                                            \
	(BIT_MASK_SUB_BCN_SPACE_V2_8814B << BIT_SHIFT_SUB_BCN_SPACE_V2_8814B)
#define BIT_CLEAR_SUB_BCN_SPACE_V2_8814B(x)                                    \
	((x) & (~BITS_SUB_BCN_SPACE_V2_8814B))
#define BIT_GET_SUB_BCN_SPACE_V2_8814B(x)                                      \
	(((x) >> BIT_SHIFT_SUB_BCN_SPACE_V2_8814B) &                           \
	 BIT_MASK_SUB_BCN_SPACE_V2_8814B)
#define BIT_SET_SUB_BCN_SPACE_V2_8814B(x, v)                                   \
	(BIT_CLEAR_SUB_BCN_SPACE_V2_8814B(x) | BIT_SUB_BCN_SPACE_V2_8814B(v))

/* 2 REG_MBID_NUM_V1_8814B */

#define BIT_SHIFT_BCN_ERR_PORT_SEL_8814B 4
#define BIT_MASK_BCN_ERR_PORT_SEL_8814B 0xf
#define BIT_BCN_ERR_PORT_SEL_8814B(x)                                          \
	(((x) & BIT_MASK_BCN_ERR_PORT_SEL_8814B)                               \
	 << BIT_SHIFT_BCN_ERR_PORT_SEL_8814B)
#define BITS_BCN_ERR_PORT_SEL_8814B                                            \
	(BIT_MASK_BCN_ERR_PORT_SEL_8814B << BIT_SHIFT_BCN_ERR_PORT_SEL_8814B)
#define BIT_CLEAR_BCN_ERR_PORT_SEL_8814B(x)                                    \
	((x) & (~BITS_BCN_ERR_PORT_SEL_8814B))
#define BIT_GET_BCN_ERR_PORT_SEL_8814B(x)                                      \
	(((x) >> BIT_SHIFT_BCN_ERR_PORT_SEL_8814B) &                           \
	 BIT_MASK_BCN_ERR_PORT_SEL_8814B)
#define BIT_SET_BCN_ERR_PORT_SEL_8814B(x, v)                                   \
	(BIT_CLEAR_BCN_ERR_PORT_SEL_8814B(x) | BIT_BCN_ERR_PORT_SEL_8814B(v))

#define BIT_SHIFT_MBID_BCN_NUM_V1_8814B 0
#define BIT_MASK_MBID_BCN_NUM_V1_8814B 0xf
#define BIT_MBID_BCN_NUM_V1_8814B(x)                                           \
	(((x) & BIT_MASK_MBID_BCN_NUM_V1_8814B)                                \
	 << BIT_SHIFT_MBID_BCN_NUM_V1_8814B)
#define BITS_MBID_BCN_NUM_V1_8814B                                             \
	(BIT_MASK_MBID_BCN_NUM_V1_8814B << BIT_SHIFT_MBID_BCN_NUM_V1_8814B)
#define BIT_CLEAR_MBID_BCN_NUM_V1_8814B(x) ((x) & (~BITS_MBID_BCN_NUM_V1_8814B))
#define BIT_GET_MBID_BCN_NUM_V1_8814B(x)                                       \
	(((x) >> BIT_SHIFT_MBID_BCN_NUM_V1_8814B) &                            \
	 BIT_MASK_MBID_BCN_NUM_V1_8814B)
#define BIT_SET_MBID_BCN_NUM_V1_8814B(x, v)                                    \
	(BIT_CLEAR_MBID_BCN_NUM_V1_8814B(x) | BIT_MBID_BCN_NUM_V1_8814B(v))

/* 2 REG_MBSSID_CTRL_V1_8814B */
#define BIT_MBID_BCNQ15_EN_8814B BIT(15)
#define BIT_MBID_BCNQ14_EN_8814B BIT(14)
#define BIT_MBID_BCNQ13_EN_8814B BIT(13)
#define BIT_MBID_BCNQ12_EN_8814B BIT(12)
#define BIT_MBID_BCNQ11_EN_8814B BIT(11)
#define BIT_MBID_BCNQ10_EN_8814B BIT(10)
#define BIT_MBID_BCNQ9_EN_8814B BIT(9)
#define BIT_MBID_BCNQ8_EN_8814B BIT(8)
#define BIT_MBID_BCNQ7_EN_8814B BIT(7)
#define BIT_MBID_BCNQ6_EN_8814B BIT(6)
#define BIT_MBID_BCNQ5_EN_8814B BIT(5)
#define BIT_MBID_BCNQ4_EN_8814B BIT(4)
#define BIT_MBID_BCNQ3_EN_8814B BIT(3)
#define BIT_MBID_BCNQ2_EN_8814B BIT(2)
#define BIT_MBID_BCNQ1_EN_8814B BIT(1)
#define BIT_MBID_BCNQ0_EN_8814B BIT(0)

/* 2 REG_USTIME_TSF_V1_8814B */

#define BIT_SHIFT_USTIME_TSF_V1_8814B 0
#define BIT_MASK_USTIME_TSF_V1_8814B 0xff
#define BIT_USTIME_TSF_V1_8814B(x)                                             \
	(((x) & BIT_MASK_USTIME_TSF_V1_8814B) << BIT_SHIFT_USTIME_TSF_V1_8814B)
#define BITS_USTIME_TSF_V1_8814B                                               \
	(BIT_MASK_USTIME_TSF_V1_8814B << BIT_SHIFT_USTIME_TSF_V1_8814B)
#define BIT_CLEAR_USTIME_TSF_V1_8814B(x) ((x) & (~BITS_USTIME_TSF_V1_8814B))
#define BIT_GET_USTIME_TSF_V1_8814B(x)                                         \
	(((x) >> BIT_SHIFT_USTIME_TSF_V1_8814B) & BIT_MASK_USTIME_TSF_V1_8814B)
#define BIT_SET_USTIME_TSF_V1_8814B(x, v)                                      \
	(BIT_CLEAR_USTIME_TSF_V1_8814B(x) | BIT_USTIME_TSF_V1_8814B(v))

/* 2 REG_BW_CFG_8814B */
#define BIT_SLEEP_32K_EN_8814B BIT(3)
#define BIT_DIS_MARK_TSF_US_V1_8814B BIT(2)

#define BIT_SHIFT_BW_CFG_8814B 0
#define BIT_MASK_BW_CFG_8814B 0x3
#define BIT_BW_CFG_8814B(x)                                                    \
	(((x) & BIT_MASK_BW_CFG_8814B) << BIT_SHIFT_BW_CFG_8814B)
#define BITS_BW_CFG_8814B (BIT_MASK_BW_CFG_8814B << BIT_SHIFT_BW_CFG_8814B)
#define BIT_CLEAR_BW_CFG_8814B(x) ((x) & (~BITS_BW_CFG_8814B))
#define BIT_GET_BW_CFG_8814B(x)                                                \
	(((x) >> BIT_SHIFT_BW_CFG_8814B) & BIT_MASK_BW_CFG_8814B)
#define BIT_SET_BW_CFG_8814B(x, v)                                             \
	(BIT_CLEAR_BW_CFG_8814B(x) | BIT_BW_CFG_8814B(v))

/* 2 REG_ATIMWND_CFG_8814B */

#define BIT_SHIFT_ATIMWND_V1_8814B 0
#define BIT_MASK_ATIMWND_V1_8814B 0xff
#define BIT_ATIMWND_V1_8814B(x)                                                \
	(((x) & BIT_MASK_ATIMWND_V1_8814B) << BIT_SHIFT_ATIMWND_V1_8814B)
#define BITS_ATIMWND_V1_8814B                                                  \
	(BIT_MASK_ATIMWND_V1_8814B << BIT_SHIFT_ATIMWND_V1_8814B)
#define BIT_CLEAR_ATIMWND_V1_8814B(x) ((x) & (~BITS_ATIMWND_V1_8814B))
#define BIT_GET_ATIMWND_V1_8814B(x)                                            \
	(((x) >> BIT_SHIFT_ATIMWND_V1_8814B) & BIT_MASK_ATIMWND_V1_8814B)
#define BIT_SET_ATIMWND_V1_8814B(x, v)                                         \
	(BIT_CLEAR_ATIMWND_V1_8814B(x) | BIT_ATIMWND_V1_8814B(v))

/* 2 REG_DTIM_COUNTER_CFG_8814B */

#define BIT_SHIFT_DTIM_COUNT_8814B 0
#define BIT_MASK_DTIM_COUNT_8814B 0xff
#define BIT_DTIM_COUNT_8814B(x)                                                \
	(((x) & BIT_MASK_DTIM_COUNT_8814B) << BIT_SHIFT_DTIM_COUNT_8814B)
#define BITS_DTIM_COUNT_8814B                                                  \
	(BIT_MASK_DTIM_COUNT_8814B << BIT_SHIFT_DTIM_COUNT_8814B)
#define BIT_CLEAR_DTIM_COUNT_8814B(x) ((x) & (~BITS_DTIM_COUNT_8814B))
#define BIT_GET_DTIM_COUNT_8814B(x)                                            \
	(((x) >> BIT_SHIFT_DTIM_COUNT_8814B) & BIT_MASK_DTIM_COUNT_8814B)
#define BIT_SET_DTIM_COUNT_8814B(x, v)                                         \
	(BIT_CLEAR_DTIM_COUNT_8814B(x) | BIT_DTIM_COUNT_8814B(v))

/* 2 REG_ATIM_DTIM_CTRL_SEL_8814B */
#define BIT_DTIM_BYPASS_V1_8814B BIT(7)

#define BIT_SHIFT_ATIM_DTIM_SEL_8814B 0
#define BIT_MASK_ATIM_DTIM_SEL_8814B 0x1f
#define BIT_ATIM_DTIM_SEL_8814B(x)                                             \
	(((x) & BIT_MASK_ATIM_DTIM_SEL_8814B) << BIT_SHIFT_ATIM_DTIM_SEL_8814B)
#define BITS_ATIM_DTIM_SEL_8814B                                               \
	(BIT_MASK_ATIM_DTIM_SEL_8814B << BIT_SHIFT_ATIM_DTIM_SEL_8814B)
#define BIT_CLEAR_ATIM_DTIM_SEL_8814B(x) ((x) & (~BITS_ATIM_DTIM_SEL_8814B))
#define BIT_GET_ATIM_DTIM_SEL_8814B(x)                                         \
	(((x) >> BIT_SHIFT_ATIM_DTIM_SEL_8814B) & BIT_MASK_ATIM_DTIM_SEL_8814B)
#define BIT_SET_ATIM_DTIM_SEL_8814B(x, v)                                      \
	(BIT_CLEAR_ATIM_DTIM_SEL_8814B(x) | BIT_ATIM_DTIM_SEL_8814B(v))

/* 2 REG_ATIMUGT_V1_8814B */

#define BIT_SHIFT_ATIM_URGENT_8814B 0
#define BIT_MASK_ATIM_URGENT_8814B 0xff
#define BIT_ATIM_URGENT_8814B(x)                                               \
	(((x) & BIT_MASK_ATIM_URGENT_8814B) << BIT_SHIFT_ATIM_URGENT_8814B)
#define BITS_ATIM_URGENT_8814B                                                 \
	(BIT_MASK_ATIM_URGENT_8814B << BIT_SHIFT_ATIM_URGENT_8814B)
#define BIT_CLEAR_ATIM_URGENT_8814B(x) ((x) & (~BITS_ATIM_URGENT_8814B))
#define BIT_GET_ATIM_URGENT_8814B(x)                                           \
	(((x) >> BIT_SHIFT_ATIM_URGENT_8814B) & BIT_MASK_ATIM_URGENT_8814B)
#define BIT_SET_ATIM_URGENT_8814B(x, v)                                        \
	(BIT_CLEAR_ATIM_URGENT_8814B(x) | BIT_ATIM_URGENT_8814B(v))

/* 2 REG_BCNDROPCTRL_V1_8814B */
#define BIT_BEACON_DROP_EN_8814B BIT(7)

#define BIT_SHIFT_BEACON_DROP_IVL_8814B 0
#define BIT_MASK_BEACON_DROP_IVL_8814B 0x7f
#define BIT_BEACON_DROP_IVL_8814B(x)                                           \
	(((x) & BIT_MASK_BEACON_DROP_IVL_8814B)                                \
	 << BIT_SHIFT_BEACON_DROP_IVL_8814B)
#define BITS_BEACON_DROP_IVL_8814B                                             \
	(BIT_MASK_BEACON_DROP_IVL_8814B << BIT_SHIFT_BEACON_DROP_IVL_8814B)
#define BIT_CLEAR_BEACON_DROP_IVL_8814B(x) ((x) & (~BITS_BEACON_DROP_IVL_8814B))
#define BIT_GET_BEACON_DROP_IVL_8814B(x)                                       \
	(((x) >> BIT_SHIFT_BEACON_DROP_IVL_8814B) &                            \
	 BIT_MASK_BEACON_DROP_IVL_8814B)
#define BIT_SET_BEACON_DROP_IVL_8814B(x, v)                                    \
	(BIT_CLEAR_BEACON_DROP_IVL_8814B(x) | BIT_BEACON_DROP_IVL_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_DIS_ATIM_V1_8814B */
#define BIT_DIS_ATIM_P4_8814B BIT(19)
#define BIT_DIS_ATIM_P3_8814B BIT(18)
#define BIT_DIS_ATIM_P2_8814B BIT(17)
#define BIT_DIS_ATIM_P1_8814B BIT(16)
#define BIT_DIS_ATIM_VAP15_8814B BIT(15)
#define BIT_DIS_ATIM_VAP14_8814B BIT(14)
#define BIT_DIS_ATIM_VAP13_8814B BIT(13)
#define BIT_DIS_ATIM_VAP12_8814B BIT(12)
#define BIT_DIS_ATIM_VAP11_8814B BIT(11)
#define BIT_DIS_ATIM_VAP10_8814B BIT(10)
#define BIT_DIS_ATIM_VAP9_8814B BIT(9)
#define BIT_DIS_ATIM_VAP8_8814B BIT(8)
#define BIT_DIS_ATIM_VAP7_8814B BIT(7)
#define BIT_DIS_ATIM_VAP6_8814B BIT(6)
#define BIT_DIS_ATIM_VAP5_8814B BIT(5)
#define BIT_DIS_ATIM_VAP4_8814B BIT(4)
#define BIT_DIS_ATIM_VAP3_8814B BIT(3)
#define BIT_DIS_ATIM_VAP2_8814B BIT(2)
#define BIT_DIS_ATIM_VAP1_8814B BIT(1)
#define BIT_DIS_ATIM_ROOT_P0_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_HIQ_NO_LMT_EN_V1_8814B */
#define BIT_HIQ_NO_LMT_EN_P4_8814B BIT(19)
#define BIT_HIQ_NO_LMT_EN_P3_8814B BIT(18)
#define BIT_HIQ_NO_LMT_EN_P2_8814B BIT(17)
#define BIT_HIQ_NO_LMT_EN_P1_8814B BIT(16)
#define BIT_HIQ_NO_LMT_EN_VAP15_8814B BIT(15)
#define BIT_HIQ_NO_LMT_EN_VAP14_8814B BIT(14)
#define BIT_HIQ_NO_LMT_EN_VAP13_8814B BIT(13)
#define BIT_HIQ_NO_LMT_EN_VAP12_8814B BIT(12)
#define BIT_HIQ_NO_LMT_EN_VAP11_8814B BIT(11)
#define BIT_HIQ_NO_LMT_EN_VAP10_8814B BIT(10)
#define BIT_HIQ_NO_LMT_EN_VAP9_8814B BIT(9)
#define BIT_HIQ_NO_LMT_EN_VAP8_8814B BIT(8)
#define BIT_HIQ_NO_LMT_EN_VAP7_8814B BIT(7)
#define BIT_HIQ_NO_LMT_EN_VAP6_8814B BIT(6)
#define BIT_HIQ_NO_LMT_EN_VAP5_8814B BIT(5)
#define BIT_HIQ_NO_LMT_EN_VAP4_8814B BIT(4)
#define BIT_HIQ_NO_LMT_EN_VAP3_8814B BIT(3)
#define BIT_HIQ_NO_LMT_EN_VAP2_8814B BIT(2)
#define BIT_HIQ_NO_LMT_EN_VAP1_8814B BIT(1)
#define BIT_HIQ_NO_LMT_EN_ROOT_P0_8814B BIT(0)

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_P2PPS_CTRL_V1_8814B */
#define BIT_P2P_PWR_RST1_V2_8814B BIT(15)
#define BIT_P2P_PWR_RST0_V2_8814B BIT(14)
#define BIT_EN_TSFBIT32_RST_P2P_V1_8814B BIT(13)

#define BIT_SHIFT_NOA_UNIT0_SEL_V1_8814B 8
#define BIT_MASK_NOA_UNIT0_SEL_V1_8814B 0x7
#define BIT_NOA_UNIT0_SEL_V1_8814B(x)                                          \
	(((x) & BIT_MASK_NOA_UNIT0_SEL_V1_8814B)                               \
	 << BIT_SHIFT_NOA_UNIT0_SEL_V1_8814B)
#define BITS_NOA_UNIT0_SEL_V1_8814B                                            \
	(BIT_MASK_NOA_UNIT0_SEL_V1_8814B << BIT_SHIFT_NOA_UNIT0_SEL_V1_8814B)
#define BIT_CLEAR_NOA_UNIT0_SEL_V1_8814B(x)                                    \
	((x) & (~BITS_NOA_UNIT0_SEL_V1_8814B))
#define BIT_GET_NOA_UNIT0_SEL_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_NOA_UNIT0_SEL_V1_8814B) &                           \
	 BIT_MASK_NOA_UNIT0_SEL_V1_8814B)
#define BIT_SET_NOA_UNIT0_SEL_V1_8814B(x, v)                                   \
	(BIT_CLEAR_NOA_UNIT0_SEL_V1_8814B(x) | BIT_NOA_UNIT0_SEL_V1_8814B(v))

#define BIT_P2P_CTW_ALLSTASLEEP_V1_8814B BIT(7)
#define BIT_P2P_OFF_DISTX_EN_V1_8814B BIT(6)
#define BIT_PWR_MGT_EN_V1_8814B BIT(5)
#define BIT_P2P_NOA1_EN_V1_8814B BIT(2)
#define BIT_P2P_NOA0_EN_V1_8814B BIT(1)

/* 2 REG_P2PPS_SPEC_STATE_V1_8814B */
#define BIT_SPEC_POWER_STATE_8814B BIT(7)
#define BIT_SPEC_CTWINDOW_ON_8814B BIT(6)
#define BIT_SPEC_BEACON_AREA_ON_8814B BIT(5)
#define BIT_SPEC_CTWIN_EARLY_DISTX_8814B BIT(4)
#define BIT_SPEC_NOA1_OFF_PERIOD_8814B BIT(3)
#define BIT_SPEC_FORCE_DOZE1_8814B BIT(2)
#define BIT_SPEC_NOA0_OFF_PERIOD_8814B BIT(1)
#define BIT_SPEC_FORCE_DOZE0_8814B BIT(0)

/* 2 REG_P2PPS_STATE_V1_8814B */
#define BIT_POWER_STATE_8814B BIT(7)
#define BIT_CTWINDOW_ON_8814B BIT(6)
#define BIT_BEACON_AREA_ON_8814B BIT(5)
#define BIT_CTWIN_EARLY_DISTX_8814B BIT(4)
#define BIT_NOA1_OFF_PERIOD_8814B BIT(3)
#define BIT_FORCE_DOZE1_8814B BIT(2)
#define BIT_NOA0_OFF_PERIOD_8814B BIT(1)
#define BIT_FORCE_DOZE0_8814B BIT(0)

/* 2 REG_P2PPS1_CTRL_V1_8814B */
#define BIT_P2P1_PWR_RST1_V2_8814B BIT(15)
#define BIT_P2P1_PWR_RST0_V2_8814B BIT(14)
#define BIT_EN_TSFBIT32_RST_P2P1_V1_8814B BIT(13)

#define BIT_SHIFT_NOA_UNIT1_SEL_V1_8814B 8
#define BIT_MASK_NOA_UNIT1_SEL_V1_8814B 0x7
#define BIT_NOA_UNIT1_SEL_V1_8814B(x)                                          \
	(((x) & BIT_MASK_NOA_UNIT1_SEL_V1_8814B)                               \
	 << BIT_SHIFT_NOA_UNIT1_SEL_V1_8814B)
#define BITS_NOA_UNIT1_SEL_V1_8814B                                            \
	(BIT_MASK_NOA_UNIT1_SEL_V1_8814B << BIT_SHIFT_NOA_UNIT1_SEL_V1_8814B)
#define BIT_CLEAR_NOA_UNIT1_SEL_V1_8814B(x)                                    \
	((x) & (~BITS_NOA_UNIT1_SEL_V1_8814B))
#define BIT_GET_NOA_UNIT1_SEL_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_NOA_UNIT1_SEL_V1_8814B) &                           \
	 BIT_MASK_NOA_UNIT1_SEL_V1_8814B)
#define BIT_SET_NOA_UNIT1_SEL_V1_8814B(x, v)                                   \
	(BIT_CLEAR_NOA_UNIT1_SEL_V1_8814B(x) | BIT_NOA_UNIT1_SEL_V1_8814B(v))

#define BIT_P2P1_CTW_ALLSTASLEEP_V1_8814B BIT(7)
#define BIT_P2P1_OFF_DISTX_EN_8814B BIT(6)
#define BIT_P2P1_PWR_MGT_EN_V1_8814B BIT(5)
#define BIT_P2P1_NOA1_EN_V1_8814B BIT(2)
#define BIT_P2P1_NOA0_EN_V1_8814B BIT(1)

/* 2 REG_P2PPS1_SPEC_STATE_V1_8814B */
#define BIT_P2P1_SPEC_POWER_STATEP_8814B BIT(7)
#define BIT_P2P1_SPEC_CTWINDOW_ON_8814B BIT(6)
#define BIT_P2P1_SPEC_BEACON_AREA_ON_8814B BIT(5)
#define BIT_P2P1_SPEC_CTWIN_EARLY_DISTX_8814B BIT(4)
#define BIT_P2P1_SPEC_NOA1_OFF_PERIOD_8814B BIT(3)
#define BIT_P2P1_SPEC_FORCE_DOZE1_8814B BIT(2)
#define BIT_P2P1_SPEC_NOA0_OFF_PERIOD_8814B BIT(1)
#define BIT_P2P1_SPEC_FORCE_DOZE0_8814B BIT(0)

/* 2 REG_P2PPS1_STATE_V1_8814B */
#define BIT_P2P1_POWER_STATE_8814B BIT(7)
#define BIT_P2P1_CTWINDOW_ON_8814B BIT(6)
#define BIT_P2P1_BEACON_AREA_ON_8814B BIT(5)
#define BIT_P2P1_CTWIN_EARLY_DISTX_8814B BIT(4)
#define BIT_P2P1_NOA1_OFF_PERIOD_8814B BIT(3)
#define BIT_P2P1_FORCE_DOZE1_8814B BIT(2)
#define BIT_P2P1_NOA0_OFF_PERIOD_8814B BIT(1)
#define BIT_P2P1_FORCE_DOZE0_8814B BIT(0)

/* 2 REG_P2PPS2_CTRL_V1_8814B */
#define BIT_P2P2_PWR_RST1_V2_8814B BIT(15)
#define BIT_P2P2_PWR_RST0_V2_8814B BIT(14)
#define BIT_EN_TSFBIT32_RST_P2P2_V1_8814B BIT(13)

#define BIT_SHIFT_NOA_UNIT2_SEL_V1_8814B 8
#define BIT_MASK_NOA_UNIT2_SEL_V1_8814B 0x7
#define BIT_NOA_UNIT2_SEL_V1_8814B(x)                                          \
	(((x) & BIT_MASK_NOA_UNIT2_SEL_V1_8814B)                               \
	 << BIT_SHIFT_NOA_UNIT2_SEL_V1_8814B)
#define BITS_NOA_UNIT2_SEL_V1_8814B                                            \
	(BIT_MASK_NOA_UNIT2_SEL_V1_8814B << BIT_SHIFT_NOA_UNIT2_SEL_V1_8814B)
#define BIT_CLEAR_NOA_UNIT2_SEL_V1_8814B(x)                                    \
	((x) & (~BITS_NOA_UNIT2_SEL_V1_8814B))
#define BIT_GET_NOA_UNIT2_SEL_V1_8814B(x)                                      \
	(((x) >> BIT_SHIFT_NOA_UNIT2_SEL_V1_8814B) &                           \
	 BIT_MASK_NOA_UNIT2_SEL_V1_8814B)
#define BIT_SET_NOA_UNIT2_SEL_V1_8814B(x, v)                                   \
	(BIT_CLEAR_NOA_UNIT2_SEL_V1_8814B(x) | BIT_NOA_UNIT2_SEL_V1_8814B(v))

#define BIT_P2P2_CTW_ALLSTASLEEP_V1_8814B BIT(7)
#define BIT_P2P2_OFF_DISTX_EN_V1_8814B BIT(6)
#define BIT_P2P2_PWR_MGT_EN_V1_8814B BIT(5)
#define BIT_P2P2_NOA1_EN_V1_8814B BIT(2)
#define BIT_P2P2_NOA0_EN_V1_8814B BIT(1)

/* 2 REG_P2PPS2_SPEC_STATE_V1_8814B */
#define BIT_P2P2_SPEC_POWER_STATEP_8814B BIT(7)
#define BIT_P2P2_SPEC_CTWINDOW_ON_8814B BIT(6)
#define BIT_P2P2_SPEC_BEACON_AREA_ON_8814B BIT(5)
#define BIT_P2P2_SPEC_CTWIN_EARLY_DISTX_8814B BIT(4)
#define BIT_P2P2_SPEC_NOA1_OFF_PERIOD_8814B BIT(3)
#define BIT_P2P2_SPEC_FORCE_DOZE1_8814B BIT(2)
#define BIT_P2P2_SPEC_NOA0_OFF_PERIOD_8814B BIT(1)
#define BIT_P2P2_SPEC_FORCE_DOZE0_8814B BIT(0)

/* 2 REG_P2PPS2_STATE_V1_8814B */
#define BIT_P2P2_POWER_STATE_8814B BIT(7)
#define BIT_P2P2_CTWINDOW_ON_8814B BIT(6)
#define BIT_P2P2_BEACON_AREA_ON_8814B BIT(5)
#define BIT_P2P2_CTWIN_EARLY_DISTX_8814B BIT(4)
#define BIT_P2P2_NOA1_OFF_PERIOD_8814B BIT(3)
#define BIT_P2P2_FORCE_DOZE1_8814B BIT(2)
#define BIT_P2P2_NOA0_OFF_PERIOD_8814B BIT(1)
#define BIT_P2P2_FORCE_DOZE0_8814B BIT(0)

/* 2 REG_P2PON_DIS_TXTIME_V1_8814B */

#define BIT_SHIFT_P2PON_DIS_TXTIME_8814B 0
#define BIT_MASK_P2PON_DIS_TXTIME_8814B 0xff
#define BIT_P2PON_DIS_TXTIME_8814B(x)                                          \
	(((x) & BIT_MASK_P2PON_DIS_TXTIME_8814B)                               \
	 << BIT_SHIFT_P2PON_DIS_TXTIME_8814B)
#define BITS_P2PON_DIS_TXTIME_8814B                                            \
	(BIT_MASK_P2PON_DIS_TXTIME_8814B << BIT_SHIFT_P2PON_DIS_TXTIME_8814B)
#define BIT_CLEAR_P2PON_DIS_TXTIME_8814B(x)                                    \
	((x) & (~BITS_P2PON_DIS_TXTIME_8814B))
#define BIT_GET_P2PON_DIS_TXTIME_8814B(x)                                      \
	(((x) >> BIT_SHIFT_P2PON_DIS_TXTIME_8814B) &                           \
	 BIT_MASK_P2PON_DIS_TXTIME_8814B)
#define BIT_SET_P2PON_DIS_TXTIME_8814B(x, v)                                   \
	(BIT_CLEAR_P2PON_DIS_TXTIME_8814B(x) | BIT_P2PON_DIS_TXTIME_8814B(v))

/* 2 REG_P2POFF_DIS_TXTIME_V1_8814B */

#define BIT_SHIFT_P2POFF_DIS_TXTIME_8814B 0
#define BIT_MASK_P2POFF_DIS_TXTIME_8814B 0xff
#define BIT_P2POFF_DIS_TXTIME_8814B(x)                                         \
	(((x) & BIT_MASK_P2POFF_DIS_TXTIME_8814B)                              \
	 << BIT_SHIFT_P2POFF_DIS_TXTIME_8814B)
#define BITS_P2POFF_DIS_TXTIME_8814B                                           \
	(BIT_MASK_P2POFF_DIS_TXTIME_8814B << BIT_SHIFT_P2POFF_DIS_TXTIME_8814B)
#define BIT_CLEAR_P2POFF_DIS_TXTIME_8814B(x)                                   \
	((x) & (~BITS_P2POFF_DIS_TXTIME_8814B))
#define BIT_GET_P2POFF_DIS_TXTIME_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P2POFF_DIS_TXTIME_8814B) &                          \
	 BIT_MASK_P2POFF_DIS_TXTIME_8814B)
#define BIT_SET_P2POFF_DIS_TXTIME_8814B(x, v)                                  \
	(BIT_CLEAR_P2POFF_DIS_TXTIME_8814B(x) | BIT_P2POFF_DIS_TXTIME_8814B(v))

/* 2 REG_CHG_POWER_BCN_AREA_8814B */
#define BIT_CHG_POWER_BCN_AREA_8814B BIT(0)

/* 2 REG_NOA_SEL_8814B */

#define BIT_SHIFT_NOA_SEL_V1_8814B 0
#define BIT_MASK_NOA_SEL_V1_8814B 0x7
#define BIT_NOA_SEL_V1_8814B(x)                                                \
	(((x) & BIT_MASK_NOA_SEL_V1_8814B) << BIT_SHIFT_NOA_SEL_V1_8814B)
#define BITS_NOA_SEL_V1_8814B                                                  \
	(BIT_MASK_NOA_SEL_V1_8814B << BIT_SHIFT_NOA_SEL_V1_8814B)
#define BIT_CLEAR_NOA_SEL_V1_8814B(x) ((x) & (~BITS_NOA_SEL_V1_8814B))
#define BIT_GET_NOA_SEL_V1_8814B(x)                                            \
	(((x) >> BIT_SHIFT_NOA_SEL_V1_8814B) & BIT_MASK_NOA_SEL_V1_8814B)
#define BIT_SET_NOA_SEL_V1_8814B(x, v)                                         \
	(BIT_CLEAR_NOA_SEL_V1_8814B(x) | BIT_NOA_SEL_V1_8814B(v))

/* 2 REG_NOA_PARAM_V1_8814B */

#define BIT_SHIFT_NOA_DURATION_8814B 0
#define BIT_MASK_NOA_DURATION_8814B 0xffffffffL
#define BIT_NOA_DURATION_8814B(x)                                              \
	(((x) & BIT_MASK_NOA_DURATION_8814B) << BIT_SHIFT_NOA_DURATION_8814B)
#define BITS_NOA_DURATION_8814B                                                \
	(BIT_MASK_NOA_DURATION_8814B << BIT_SHIFT_NOA_DURATION_8814B)
#define BIT_CLEAR_NOA_DURATION_8814B(x) ((x) & (~BITS_NOA_DURATION_8814B))
#define BIT_GET_NOA_DURATION_8814B(x)                                          \
	(((x) >> BIT_SHIFT_NOA_DURATION_8814B) & BIT_MASK_NOA_DURATION_8814B)
#define BIT_SET_NOA_DURATION_8814B(x, v)                                       \
	(BIT_CLEAR_NOA_DURATION_8814B(x) | BIT_NOA_DURATION_8814B(v))

/* 2 REG_NOA_PARAM_1_V1_8814B */

#define BIT_SHIFT_NOA_INTERVAL_8814B 0
#define BIT_MASK_NOA_INTERVAL_8814B 0xffffffffL
#define BIT_NOA_INTERVAL_8814B(x)                                              \
	(((x) & BIT_MASK_NOA_INTERVAL_8814B) << BIT_SHIFT_NOA_INTERVAL_8814B)
#define BITS_NOA_INTERVAL_8814B                                                \
	(BIT_MASK_NOA_INTERVAL_8814B << BIT_SHIFT_NOA_INTERVAL_8814B)
#define BIT_CLEAR_NOA_INTERVAL_8814B(x) ((x) & (~BITS_NOA_INTERVAL_8814B))
#define BIT_GET_NOA_INTERVAL_8814B(x)                                          \
	(((x) >> BIT_SHIFT_NOA_INTERVAL_8814B) & BIT_MASK_NOA_INTERVAL_8814B)
#define BIT_SET_NOA_INTERVAL_8814B(x, v)                                       \
	(BIT_CLEAR_NOA_INTERVAL_8814B(x) | BIT_NOA_INTERVAL_8814B(v))

/* 2 REG_NOA_PARAM_2_V1_8814B */

#define BIT_SHIFT_NOA_START_TIME_8814B 0
#define BIT_MASK_NOA_START_TIME_8814B 0xffffffffL
#define BIT_NOA_START_TIME_8814B(x)                                            \
	(((x) & BIT_MASK_NOA_START_TIME_8814B)                                 \
	 << BIT_SHIFT_NOA_START_TIME_8814B)
#define BITS_NOA_START_TIME_8814B                                              \
	(BIT_MASK_NOA_START_TIME_8814B << BIT_SHIFT_NOA_START_TIME_8814B)
#define BIT_CLEAR_NOA_START_TIME_8814B(x) ((x) & (~BITS_NOA_START_TIME_8814B))
#define BIT_GET_NOA_START_TIME_8814B(x)                                        \
	(((x) >> BIT_SHIFT_NOA_START_TIME_8814B) &                             \
	 BIT_MASK_NOA_START_TIME_8814B)
#define BIT_SET_NOA_START_TIME_8814B(x, v)                                     \
	(BIT_CLEAR_NOA_START_TIME_8814B(x) | BIT_NOA_START_TIME_8814B(v))

/* 2 REG_NOA_PARAM_3_V1_8814B */

#define BIT_SHIFT_NOA_COUNT_V2_8814B 0
#define BIT_MASK_NOA_COUNT_V2_8814B 0xffffffffL
#define BIT_NOA_COUNT_V2_8814B(x)                                              \
	(((x) & BIT_MASK_NOA_COUNT_V2_8814B) << BIT_SHIFT_NOA_COUNT_V2_8814B)
#define BITS_NOA_COUNT_V2_8814B                                                \
	(BIT_MASK_NOA_COUNT_V2_8814B << BIT_SHIFT_NOA_COUNT_V2_8814B)
#define BIT_CLEAR_NOA_COUNT_V2_8814B(x) ((x) & (~BITS_NOA_COUNT_V2_8814B))
#define BIT_GET_NOA_COUNT_V2_8814B(x)                                          \
	(((x) >> BIT_SHIFT_NOA_COUNT_V2_8814B) & BIT_MASK_NOA_COUNT_V2_8814B)
#define BIT_SET_NOA_COUNT_V2_8814B(x, v)                                       \
	(BIT_CLEAR_NOA_COUNT_V2_8814B(x) | BIT_NOA_COUNT_V2_8814B(v))

/* 2 REG_NOA_ON_ERLY_TIME_V1_8814B */

#define BIT_SHIFT__NOA_ON_ERLY_TIME_8814B 0
#define BIT_MASK__NOA_ON_ERLY_TIME_8814B 0xff
#define BIT__NOA_ON_ERLY_TIME_8814B(x)                                         \
	(((x) & BIT_MASK__NOA_ON_ERLY_TIME_8814B)                              \
	 << BIT_SHIFT__NOA_ON_ERLY_TIME_8814B)
#define BITS__NOA_ON_ERLY_TIME_8814B                                           \
	(BIT_MASK__NOA_ON_ERLY_TIME_8814B << BIT_SHIFT__NOA_ON_ERLY_TIME_8814B)
#define BIT_CLEAR__NOA_ON_ERLY_TIME_8814B(x)                                   \
	((x) & (~BITS__NOA_ON_ERLY_TIME_8814B))
#define BIT_GET__NOA_ON_ERLY_TIME_8814B(x)                                     \
	(((x) >> BIT_SHIFT__NOA_ON_ERLY_TIME_8814B) &                          \
	 BIT_MASK__NOA_ON_ERLY_TIME_8814B)
#define BIT_SET__NOA_ON_ERLY_TIME_8814B(x, v)                                  \
	(BIT_CLEAR__NOA_ON_ERLY_TIME_8814B(x) | BIT__NOA_ON_ERLY_TIME_8814B(v))

/* 2 REG_NOA_OFF_ERLY_TIME_V1_8814B */

#define BIT_SHIFT__NOA_OFF_ERLY_TIME_8814B 0
#define BIT_MASK__NOA_OFF_ERLY_TIME_8814B 0xff
#define BIT__NOA_OFF_ERLY_TIME_8814B(x)                                        \
	(((x) & BIT_MASK__NOA_OFF_ERLY_TIME_8814B)                             \
	 << BIT_SHIFT__NOA_OFF_ERLY_TIME_8814B)
#define BITS__NOA_OFF_ERLY_TIME_8814B                                          \
	(BIT_MASK__NOA_OFF_ERLY_TIME_8814B                                     \
	 << BIT_SHIFT__NOA_OFF_ERLY_TIME_8814B)
#define BIT_CLEAR__NOA_OFF_ERLY_TIME_8814B(x)                                  \
	((x) & (~BITS__NOA_OFF_ERLY_TIME_8814B))
#define BIT_GET__NOA_OFF_ERLY_TIME_8814B(x)                                    \
	(((x) >> BIT_SHIFT__NOA_OFF_ERLY_TIME_8814B) &                         \
	 BIT_MASK__NOA_OFF_ERLY_TIME_8814B)
#define BIT_SET__NOA_OFF_ERLY_TIME_8814B(x, v)                                 \
	(BIT_CLEAR__NOA_OFF_ERLY_TIME_8814B(x) |                               \
	 BIT__NOA_OFF_ERLY_TIME_8814B(v))

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_NOT_VALID_8814B */

/* 2 REG_P2PPS_HW_AUTO_PAUSE_CTRL_8814B */
#define BIT_P2PPS_NOA_STOP_TX_HANG_8814B BIT(31)
#define BIT_P2PPS_MACID_PAUSE_EN_8814B BIT(11)
#define BIT_P2PPS__MGQ_PAUSE_8814B BIT(10)
#define BIT_P2PPS__HIQ_PAUSE_8814B BIT(9)
#define BIT_P2PPS__BCNQ_PAUSE_8814B BIT(8)

#define BIT_SHIFT_P2PPS_MACID_PAUSE_8814B 0
#define BIT_MASK_P2PPS_MACID_PAUSE_8814B 0xff
#define BIT_P2PPS_MACID_PAUSE_8814B(x)                                         \
	(((x) & BIT_MASK_P2PPS_MACID_PAUSE_8814B)                              \
	 << BIT_SHIFT_P2PPS_MACID_PAUSE_8814B)
#define BITS_P2PPS_MACID_PAUSE_8814B                                           \
	(BIT_MASK_P2PPS_MACID_PAUSE_8814B << BIT_SHIFT_P2PPS_MACID_PAUSE_8814B)
#define BIT_CLEAR_P2PPS_MACID_PAUSE_8814B(x)                                   \
	((x) & (~BITS_P2PPS_MACID_PAUSE_8814B))
#define BIT_GET_P2PPS_MACID_PAUSE_8814B(x)                                     \
	(((x) >> BIT_SHIFT_P2PPS_MACID_PAUSE_8814B) &                          \
	 BIT_MASK_P2PPS_MACID_PAUSE_8814B)
#define BIT_SET_P2PPS_MACID_PAUSE_8814B(x, v)                                  \
	(BIT_CLEAR_P2PPS_MACID_PAUSE_8814B(x) | BIT_P2PPS_MACID_PAUSE_8814B(v))

/* 2 REG_P2PPS1_HW_AUTO_PAUSE_CTRL_8814B */
#define BIT_P2PPS1_NOA_STOP_TX_HANG_8814B BIT(31)
#define BIT_P2PPS1_MACID_PAUSE_EN_8814B BIT(11)
#define BIT_P2PPS1__MGQ_PAUSE_8814B BIT(10)
#define BIT_P2PPS1__HIQ_PAUSE_8814B BIT(9)
#define BIT_P2PPS1__BCNQ_PAUSE_8814B BIT(8)

#define BIT_SHIFT_P2PPS1_MACID_PAUSE_8814B 0
#define BIT_MASK_P2PPS1_MACID_PAUSE_8814B 0xff
#define BIT_P2PPS1_MACID_PAUSE_8814B(x)                                        \
	(((x) & BIT_MASK_P2PPS1_MACID_PAUSE_8814B)                             \
	 << BIT_SHIFT_P2PPS1_MACID_PAUSE_8814B)
#define BITS_P2PPS1_MACID_PAUSE_8814B                                          \
	(BIT_MASK_P2PPS1_MACID_PAUSE_8814B                                     \
	 << BIT_SHIFT_P2PPS1_MACID_PAUSE_8814B)
#define BIT_CLEAR_P2PPS1_MACID_PAUSE_8814B(x)                                  \
	((x) & (~BITS_P2PPS1_MACID_PAUSE_8814B))
#define BIT_GET_P2PPS1_MACID_PAUSE_8814B(x)                                    \
	(((x) >> BIT_SHIFT_P2PPS1_MACID_PAUSE_8814B) &                         \
	 BIT_MASK_P2PPS1_MACID_PAUSE_8814B)
#define BIT_SET_P2PPS1_MACID_PAUSE_8814B(x, v)                                 \
	(BIT_CLEAR_P2PPS1_MACID_PAUSE_8814B(x) |                               \
	 BIT_P2PPS1_MACID_PAUSE_8814B(v))

/* 2 REG_P2PPS2_HW_AUTO_PAUSE_CTRL_8814B */
#define BIT_P2PPS2_NOA_STOP_TX_HANG_8814B BIT(31)
#define BIT_P2PPS2_MACID_PAUSE_EN_8814B BIT(11)
#define BIT_P2PPS2__MGQ_PAUSE_8814B BIT(10)
#define BIT_P2PPS2__HIQ_PAUSE_8814B BIT(9)
#define BIT_P2PPS2__BCNQ_PAUSE_8814B BIT(8)

#define BIT_SHIFT_P2PPS2_MACID_PAUSE_8814B 0
#define BIT_MASK_P2PPS2_MACID_PAUSE_8814B 0xff
#define BIT_P2PPS2_MACID_PAUSE_8814B(x)                                        \
	(((x) & BIT_MASK_P2PPS2_MACID_PAUSE_8814B)                             \
	 << BIT_SHIFT_P2PPS2_MACID_PAUSE_8814B)
#define BITS_P2PPS2_MACID_PAUSE_8814B                                          \
	(BIT_MASK_P2PPS2_MACID_PAUSE_8814B                                     \
	 << BIT_SHIFT_P2PPS2_MACID_PAUSE_8814B)
#define BIT_CLEAR_P2PPS2_MACID_PAUSE_8814B(x)                                  \
	((x) & (~BITS_P2PPS2_MACID_PAUSE_8814B))
#define BIT_GET_P2PPS2_MACID_PAUSE_8814B(x)                                    \
	(((x) >> BIT_SHIFT_P2PPS2_MACID_PAUSE_8814B) &                         \
	 BIT_MASK_P2PPS2_MACID_PAUSE_8814B)
#define BIT_SET_P2PPS2_MACID_PAUSE_8814B(x, v)                                 \
	(BIT_CLEAR_P2PPS2_MACID_PAUSE_8814B(x) |                               \
	 BIT_P2PPS2_MACID_PAUSE_8814B(v))

/* 2 REG_RX_TBTT_SHIFT_8814B */

#define BIT_SHIFT_RX_TBTT_SHIFT_SEL_8814B 24
#define BIT_MASK_RX_TBTT_SHIFT_SEL_8814B 0x7
#define BIT_RX_TBTT_SHIFT_SEL_8814B(x)                                         \
	(((x) & BIT_MASK_RX_TBTT_SHIFT_SEL_8814B) 