/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.jaffl.struct.Struct;
import org.python.posix.BaseHeapFileStat;
import org.python.posix.POSIX;

public class WindowsFileStat
extends BaseHeapFileStat {
    public final Struct.Signed32 st_dev = new Struct.Signed32();
    public final Struct.Signed16 st_ino = new Struct.Signed16();
    public final Struct.Signed16 st_mode = new Struct.Signed16();
    public final Struct.Signed16 st_nlink = new Struct.Signed16();
    public final Struct.Signed16 st_uid = new Struct.Signed16();
    public final Struct.Signed16 st_gid = new Struct.Signed16();
    public final Struct.Signed32 st_rdev = new Struct.Signed32();
    public final Struct.Signed64 st_size = new Struct.Signed64();
    public final Struct.Signed64 st_atime = new Struct.Signed64();
    public final Struct.Signed64 st_mtime = new Struct.Signed64();
    public final Struct.Signed64 st_ctime = new Struct.Signed64();

    public WindowsFileStat(POSIX posix) {
        super(posix);
    }

    public long atime() {
        return this.st_atime.get();
    }

    public long blockSize() {
        return 512L;
    }

    public long blocks() {
        return (this.st_size.get() + 512L - 1L) / 512L;
    }

    public long ctime() {
        return this.st_ctime.get();
    }

    public long dev() {
        return this.st_dev.get();
    }

    public int gid() {
        return this.st_gid.get();
    }

    public long ino() {
        return this.st_ino.get();
    }

    public int mode() {
        return this.st_mode.get() & 0xFFFF;
    }

    public long mtime() {
        return this.st_mtime.get();
    }

    public int nlink() {
        return this.st_nlink.get();
    }

    public long rdev() {
        return this.st_rdev.get();
    }

    public long st_size() {
        return this.st_size.get();
    }

    public int uid() {
        return this.st_uid.get();
    }

    public boolean groupMember(int gid) {
        return true;
    }

    public boolean isExecutable() {
        if (this.isOwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) == 0;
    }

    public boolean isExecutableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x40) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 8) != 0;
        }
        return (this.mode() & 1) == 0;
    }

    public boolean isOwned() {
        return true;
    }

    public boolean isROwned() {
        return true;
    }

    public boolean isReadable() {
        if (this.isOwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) == 0;
    }

    public boolean isReadableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x100) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x20) != 0;
        }
        return (this.mode() & 4) == 0;
    }

    public boolean isWritable() {
        if (this.isOwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.isGroupOwned()) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) == 0;
    }

    public boolean isWritableReal() {
        if (this.isROwned()) {
            return (this.mode() & 0x80) != 0;
        }
        if (this.groupMember(this.gid())) {
            return (this.mode() & 0x10) != 0;
        }
        return (this.mode() & 2) == 0;
    }

    public String toString() {
        return "st_dev: " + this.st_dev.get() + ", st_mode: " + Integer.toOctalString(this.mode()) + ", st_nlink: " + this.st_nlink.get() + ", st_rdev: " + this.st_rdev.get() + ", st_size: " + this.st_size.get() + ", st_uid: " + this.st_uid.get() + ", st_gid: " + this.st_gid.get() + ", st_atime: " + this.st_atime.get() + ", st_ctime: " + this.st_ctime.get() + ", st_mtime: " + this.st_mtime.get() + ", st_ino: " + this.st_ino.get();
    }
}

