/*
 *		Unofficial release 1.3.0
 *	        	B I N G
 *
 * This header porives a few common definitions to be used by all parts 
 * of bing.
 */

/* $Id: bing_defs.h,v 1.3 1999/10/11 05:25:19 fgouget Exp $ */


#ifndef _bing_defs_h_
#define _bing_defs_h_

#ifdef __cplusplus
#define BINGAPI "C"
#else
#define BINGAPI
#endif

#if defined(__STDC__) || defined(__cplusplus)
#define BINGPROTO(func,param)	func param
#else
#define BINGPROTO(func,param)	func()
#endif

#ifdef NO_SNPRINTF
#define snprintf sprintf
#define snfargs(str,size,format) str,format
#else
#ifdef WIN32
#define snprintf _snprintf
#endif
#define snfargs(str,size,format) str,size,format
#endif

#ifndef MIN
#define MIN(a,b)     ((a)<(b)?(a):(b))
#endif


#ifdef _DEBUG
#define DEBUG_MSG(a) \
    do { \
        fprintf(stderr," --%s:%d-- ",__FILE__,__LINE__); \
        fprintf a; \
        fprintf(stderr,"\n"); \
        fflush(stderr); \
    } while (0)
#else
#define DEBUG_MSG(a)
#endif

#endif /* end of file */
