// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2022 MediaTek Inc. All rights reserved.
 *
 * Author: Weijie Gao <weijie.gao@mediatek.com>
 */

#include <vsprintf.h>
#include <asm/io.h>
#include <asm/sections.h>
#include <asm/byteorder.h>
#include <asm/addrspace.h>
#include <linux/string.h>
#include "../mt7621.h"
#include "dram.h"

static const u32 ddr2_act[DDR_PARAM_SIZE] = {
#if defined(CONFIG_MT7621_DRAM_DDR2_512M)
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x22174441,
	0x00000000, 0xF0748661, 0x40001273, 0x9F0A0481,
	0x0304692F, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000000, 0x07100000,
	0x00001B63, 0x00002000, 0x00004000, 0x00006000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
#elif defined(CONFIG_MT7621_DRAM_DDR2_512M_W9751G6KB_A02_1066MHZ)
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x33484584,
	0x00000000, 0xF07486A1, 0x50001273, 0x9F010481,
	0x0304693F, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000010, 0x07100000,
	0x00001F73, 0x00002000, 0x00004000, 0x00006000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
#elif defined(CONFIG_MT7621_DRAM_DDR2_1024M_W971GG6KB25_800MHZ)
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x22174430,
	0x01000000, 0xF0748661, 0x40001273, 0x9F0F0481,
	0x0304692F, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000000, 0x07100000,
	0x00001B63, 0x00002000, 0x00004000, 0x00006000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
#elif defined(CONFIG_MT7621_DRAM_DDR2_1024M_W971GG6KB18_1066MHZ)
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x33484584,
	0x01000000, 0xF07486A1, 0x50001273, 0x9F070481,
	0x0304693F, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000010, 0x07100000,
	0x00001F73, 0x00002000, 0x00004000, 0x00006000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
#else /* CONFIG_MT7621_DRAM_DDR2_1024M */
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x22174441,
	0x01000000, 0xF0748661, 0x40001273, 0x9F0F0481,
	0x0304692F, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000000, 0x07100000,
	0x00001B63, 0x00002000, 0x00004000, 0x00006000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
#endif
};

static const u32 ddr3_act[DDR_PARAM_SIZE] = {
#if defined(CONFIG_MT7621_DRAM_DDR3_1024M)
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x44694683,
	0x01000000, 0xF07486A1, 0xC287221D, 0x9F060481,
	0x03046948, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000210, 0x07100000,
	0x00001B61, 0x00002040, 0x00004010, 0x00006000,
	0x0C000000, 0x07070000, 0x00000000, 0x00000000,
#elif defined(CONFIG_MT7621_DRAM_DDR3_4096M)
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x44694683,
	0x01000000, 0xF07486A1, 0xC287221D, 0x9F0F0481,
	0x03046948, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000240, 0x07100000,
	0x00001B61, 0x00002040, 0x00004010, 0x00006000,
	0x0C000000, 0x07070000, 0x00000000, 0x00000000,
#elif defined(CONFIG_MT7621_DRAM_DDR3_1024M_KGD)
	0xFF00FF00, 0xFF00FF00, 0x00000007, 0x44694683,
	0x01000000, 0xF07406A1, 0xC287221D, 0x9F060481,
	0x03046923, 0x152f2842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000210, 0x07100000,
	0x00001B61, 0x00002040, 0x00004010, 0x00006000,
	0x0C000000, 0x07070000, 0x000C0000, 0x00000000,
#else /* CONFIG_MT7621_DRAM_DDR3_2048M */
	0xAA00AA00, 0xAA00AA00, 0x00000007, 0x44694673,
	0x01000000, 0xF07486A1, 0xC287221D, 0x9F050481,
	0x03046948, 0x15602842, 0x00008888, 0x88888888,
	0x00000000, 0x00000000, 0x00000220, 0x07100000,
	0x00001B61, 0x00002040, 0x00004010, 0x00006000,
	0x0C000000, 0x07070000, 0x00000000, 0x00000000,
#endif
};

#if defined(CONFIG_MT7621_DRAM_FREQ_400)
#define DDR_FREQ_PARAM		0x41000000
#elif defined(CONFIG_MT7621_DRAM_FREQ_1066)
#define DDR_FREQ_PARAM		0x21000000
#elif defined(CONFIG_MT7621_DRAM_FREQ_1200)
#define DDR_FREQ_PARAM		0x11000000
#else /* CONFIG_MT7621_DRAM_FREQ_800 */
#define DDR_FREQ_PARAM		0x31000000
#endif

#define RG_MEPL_FBDIV_S		4
#define RG_MEPL_FBDIV_M		0x7f

static inline void word_copy(u32 *dest, const u32 *src, u32 count)
{
	u32 i;

	for (i = 0; i < count; i++)
		dest[i] = src[i];
}

static u32 calc_cpu_pll_val(void)
{
	u32 div, baseval, fb;

	div = get_xtal_mhz();

	if (div == 40) {
		div /= 2;
		baseval = 0xc0005802;
	} else {
		baseval = 0xc0004802;
	}

	fb = CONFIG_MT7621_CPU_FREQ / div - 1;
	if (fb > RG_MEPL_FBDIV_M)
		fb = RG_MEPL_FBDIV_M;

	return baseval | (fb << RG_MEPL_FBDIV_S);
}

void prepare_stage_bin(void)
{
	u32 stage_size;

	const struct stage_header *stock_stage_bin =
		(const struct stage_header *)__image_copy_end;

	struct stage_header *new_stage_bin =
		(struct stage_header *)STAGE_LOAD_ADDR;

	if (be32_to_cpu(stock_stage_bin->ep) != STAGE_LOAD_ADDR)
		panic("Invalid DDR stage binary blob\n");

	stage_size = be32_to_cpu(stock_stage_bin->stage_size);

	word_copy((u32 *)new_stage_bin, (const u32 *)stock_stage_bin,
		  (stage_size + sizeof(u32) - 1) / sizeof(u32));

	word_copy(new_stage_bin->ddr2_act, ddr2_act, DDR_PARAM_SIZE);
	word_copy(new_stage_bin->ddr3_act, ddr3_act, DDR_PARAM_SIZE);

	new_stage_bin->cpu_pll_cfg = calc_cpu_pll_val();
	new_stage_bin->ddr_pll_cfg = DDR_FREQ_PARAM;
	new_stage_bin->baudrate = CONFIG_BAUDRATE;
}
