/* "NETGEN", a netlist-specification tool for VLSI
   Copyright (C) 1989, 1990   Massimo A. Sivilotti
   Author's address: mass@csvax.cs.caltech.edu;
                     Caltech 256-80, Pasadena CA 91125.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file copying.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


/* actellib.c -- definitions of all cells in ACTEL's cell library */


/* define the following to make pads unique */
/* this is necessary for ntk2adl, but is annoying for PLACE */

#undef USE_UNIQUE_GLOBALS


#include "config.h"
#include <stdio.h>
#include "netgen.h"

static int actel_lib_present = 0;

int ActelLibPresent(void)
{
   return actel_lib_present;
}

void ActelLib(void)
{
  int OldDebug;

  OldDebug = Debug;
  Debug = 0;

  CellDef("OUTBUF");
#ifdef USE_UNIQUE_GLOBALS
     UniqueGlobal("PAD");
#else
     Port("PAD");
#endif
     Port("D");
     SetClass(CLASS_MODULE);
  EndCell();

  CellDef("INBUF");
     Port("Y");
#ifdef USE_UNIQUE_GLOBALS
     UniqueGlobal("PAD");
#else
     Port("PAD");
#endif
     SetClass(CLASS_MODULE);
  EndCell();

  CellDef("CLKBUF");
     Port("Y");
#ifdef USE_UNIQUE_GLOBALS
     UniqueGlobal("PAD");
#else
     Port("PAD");
#endif
     SetClass(CLASS_MODULE);
  EndCell();

  CellDef("TRIBUFF");
#ifdef USE_UNIQUE_GLOBALS
     UniqueGlobal("PAD");
#else
     Port("PAD");
#endif
     Port("D");
     Port("E");
     SetClass(CLASS_MODULE);
  EndCell();

  CellDef("BIBUF");
#ifdef USE_UNIQUE_GLOBALS
     UniqueGlobal("PAD");
#else
     Port("PAD");
#endif
     Port("D");
     Port("E");
     Port("Y");
     SetClass(CLASS_MODULE);
  EndCell();

	CellDef("AND2");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND2A");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND2B");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND2");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND2A");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND2B");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR2");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR2A");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR2B");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR2");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR2A");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR2B");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND3");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND3A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND3B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND3C");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND3");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND3A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND3B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND3C");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR3");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR3A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR3B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR3C");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR3");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR3A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR3B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR3C");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND4");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND4A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND4B");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND4C");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AND4D");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND4");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND4A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND4B");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND4C");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NAND4D");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR4");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR4A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR4B");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR4C");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OR4D");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR4");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR4A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR4B");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR4C");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("NOR4D");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();


/*
INBUF
CLKBUF
OUTBUF
TRIBUF
BIBUF
*/





	CellDef("BUF");
		Port("A");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("BUFA");
		Port("A");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("INV");
		Port("A");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("INVA");
		Port("A");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("XOR");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("XNOR");
		Port("A");
		Port("B");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("XO1");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("X01A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("XA1");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("XA1A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AX1");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AX1A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AX1B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AO1");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AO1A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AO1B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AO1C");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AOI1A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AOI1B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	/* Added by Tim 12/8/99 */
	CellDef("AO3");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("MAJ3");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AO2");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AO2A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AOI2A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("AOI2B");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA1");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA1A");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA1B");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA1C");
		Port("A");
		Port("B");
		Port("C");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA3");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA3A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA3B");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA2");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("OA2A");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("MX2");
		Port("A");
		Port("B");
		Port("S");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("MX2A");
		Port("A");
		Port("B");
		Port("S");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("MX2B");
		Port("A");
		Port("B");
		Port("S");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("MX2C");
		Port("A");
		Port("B");
		Port("S");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("MX4");
		Port("D0");
		Port("D1");
		Port("D2");
		Port("D3");
		Port("S1");
		Port("S0");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("GMX4");
		Port("D0");
		Port("D1");
		Port("D2");
		Port("D3");
		Port("G");
		Port("S0");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("MXT");
		Port("A");
		Port("B");
		Port("C");
		Port("D");
		Port("S0A");
		Port("S0B");
		Port("S1");
		Port("Y");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("HA1");
		Port("A");
		Port("B");
		Port("CO");
		Port("S");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("HA1A");
		Port("A");
		Port("B");
		Port("CO");
		Port("S");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("HA1B");
		Port("A");
		Port("B");
		Port("CO");
		Port("S");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("HA1C");
		Port("A");
		Port("B");
		Port("CO");
		Port("S");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("FA1A");
		Port("A");
		Port("B");
		Port("CI");
		Port("CO");
		Port("S");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("FA1B");
		Port("A");
		Port("B");
		Port("CI");
		Port("CO");
		Port("S");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("FA2A");
		Port("A0");
		Port("A1");
		Port("B");
		Port("CI");
		Port("CO");
		Port("S");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DL1");
		Port("D");
		Port("G");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DL1A");
		Port("D");
		Port("G");
		Port("QN");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DL1B");
		Port("D");
		Port("G");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DL1C");
		Port("D");
		Port("G");
		Port("QN");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLC");
		Port("D");
		Port("G");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLCA");
		Port("D");
		Port("G");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLE");
		Port("D");
		Port("G");
		Port("Q");
		Port("E");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLEA");
		Port("D");
		Port("G");
		Port("Q");
		Port("E");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLEB");
		Port("D");
		Port("G");
		Port("Q");
		Port("E");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLEC");
		Port("D");
		Port("G");
		Port("Q");
		Port("E");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLM");
		Port("A");
		Port("B");
		Port("S");
		Port("G");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DLMA");
		Port("A");
		Port("B");
		Port("S");
		Port("G");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("JKF");
		Port("J");
		Port("K");
		Port("CLK");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("JKFPC");
		Port("J");
		Port("K");
		Port("CLK");
		Port("Q");
		Port("PRE");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("TFC");
		Port("T");
		Port("CLK");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFM");
		Port("A");
		Port("B");
		Port("S");
		Port("CLK");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFMA");
		Port("A");
		Port("B");
		Port("S");
		Port("CLK");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFMB");
		Port("A");
		Port("B");
		Port("S");
		Port("CLK");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DF1");
		Port("D");
		Port("CLK");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DF1A");
		Port("D");
		Port("CLK");
		Port("QN");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DF1B");
		Port("D");
		Port("CLK");
		Port("Q");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DF1C");
		Port("D");
		Port("CLK");
		Port("QN");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1A");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1B");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1C");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1D");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1E");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1F");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFC1G");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("CLR");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1A");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1B");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1C");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1D");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1E");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1F");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFP1G");
		Port("D");
		Port("CLK");
		Port("QN");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFPC");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("CLR");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFPCA");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("CLR");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFE");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("E");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFEA");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("E");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFEB");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("E");
		Port("CLR");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFEC");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("E");
		Port("CLR");
		Port("PRE");
		SetClass(CLASS_MODULE);
	EndCell();

	CellDef("DFED");
		Port("D");
		Port("CLK");
		Port("Q");
		Port("E");
		SetClass(CLASS_MODULE);
	EndCell();

  Debug = OldDebug;

  actel_lib_present = 1;
}


