<?xml version='1.0' encoding='utf-8' standalone='yes'?>

<!--Copyright 2008 Microsoft Corporation-->
<!--DO NOT EDIT THIS FILE IN ECMANGEN.EXE
    It will overwrite the file leading to lose of
    comments and formatting issues when compiling--><assembly
    xmlns="urn:schemas-microsoft-com:asm.v3"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    manifestVersion="1.0"
    >
  <assemblyIdentity
      buildType="$(build.buildType)"
      language="neutral"
      name="PowerShell.Core.Instrumentation"
      processorArchitecture="msil"
      publicKeyToken="$(build.WindowsPublicKeyToken)"
      version="$(build.version)"
      versionScope="nonSxS"
      />
  <!--Define the instrumentation for Windows PowerShell-->
  <instrumentation
      xmlns:trace="http://schemas.microsoft.com/win/2004/08/events/trace"
      xmlns:win="http://manifests.microsoft.com/win/2004/08/windows/events"
      xmlns:xs="http://www.w3.org/2001/XMLSchema"
      >
    <events xmlns="http://schemas.microsoft.com/win/2004/08/events">
      <!--Defines an event provider for PowerShell Core
          The Guid for this provider should not be changed. If its
          changed for any reason, then the manifest needs to be
          first uninstalled and then installed again (using wevtutil)-->
      <provider
          guid="{f90714a8-5509-434a-bf6d-b1624c8a19a2}"
          messageFileName="PowerShell.Core.Instrumentation.dll"
          name="PowerShellCore"
          resourceFileName="PowerShell.Core.Instrumentation.dll"
          symbol="PS_PROVIDER"
          >
        <!--The following section defines the events which can be written
            from PowerShell-->
        <events>
          <!--Here are the guidelines on assigning values to events:
              1. Reserved      - 0x0001 - 0x1000
              2. Commands      - 0x1001 - 0x2000
              3. Runspace      - 0x2001 - 0x3000
              4. Pipeline      - 0x3001 - 0x4000
              5. Session       - 0x4001 - 0x5000
              6. Protocol      - 0x5001 - 0x6000
              7. Host          - 0x6001 - 0x7000
              8. Serialization - 0x7001 - 0x8000
              9. Transport     - 0x8001 - 0x9000
             10. Plugin        - 0x9001 - 0xA000
             11. PerfTrack     - 0xA001 - 0xB000
             12. M3P           - 0xB001 - 0xC000
             13. Debug Events  - 0xC001 - 0xD000
             14. ScheduledJob  - 0xD001 - 0xD0FF
             15. NamedPipeIPC  - 0xD100 - 0xE000

             Values for events in operational channel will be in the range
             0xX001 - 0xXF00 and for those in the analytic channel will be
             in the range from 0xXF01 - 0xXFFF

             The version should be 1 for all events defined in the V2
             timeframe
             -->
          <!--ScheduledJob events -->
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ScheduledJobStarted.message)"
              opcode="Method"
              symbol="ScheduledJobStarted"
              task="ScheduledJob"
              template="T_ScheduledJobStarted"
              value="0xD001"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ScheduledJobCompleted.message)"
              opcode="Method"
              symbol="ScheduledJobCompleted"
              task="ScheduledJob"
              template="T_ScheduledJobCompleted"
              value="0xD002"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_O_ScheduledJobException.message)"
              opcode="Exception"
              symbol="ScheduledJobError"
              task="ScheduledJob"
              template="T_ScheduledJobError"
              value="0xD003"
              version="1"
              />
          <!--M3P events-->
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowPluginStarted.message)"
              opcode="Method"
              symbol="M3PWorkflowPluginStarted"
              task="WorkflowHosting"
              template="T_M3PWorkflowPluginStarted"
              value="0xB007"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowExecutionStarted.message)"
              opcode="Method"
              symbol="M3PWorkflowExecutionStarted"
              task="WorkflowExecution"
              template="T_M3PWorkflowExecutionStarted"
              value="0xB008"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowStateChanged.message)"
              opcode="Method"
              symbol="M3PWorkflowStateChanged"
              task="WorkflowExecution"
              template="T_M3PWorkflowStateChanged"
              value="0xB009"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowPluginRequestedToShutdown.message)"
              opcode="Method"
              symbol="M3PWorkflowPluginRequestedToShutdown"
              task="WorkflowHosting"
              template="T_M3PWorkflowPluginRequestedToShutdown"
              value="0xB010"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowPluginRestarted.message)"
              opcode="Method"
              symbol="M3PWorkflowPluginRestarted"
              task="WorkflowHosting"
              template="T_M3PWorkflowPluginRestarted"
              value="0xB011"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowWorkflowsResuming.message)"
              opcode="Method"
              symbol="M3PWorkflowResuming"
              task="WorkflowExecution"
              template="T_M3PWorkflowsResuming"
              value="0xB012"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowQuotaViolationDetected.message)"
              opcode="Method"
              symbol="M3PWorkflowQuotaViolated"
              task="WorkflowExecution"
              template="T_M3PWorkflowQuotaViolationDetected"
              value="0xB013"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowWorkflowsResumed.message)"
              opcode="Method"
              symbol="M3PWorkflowResumed"
              task="WorkflowExecution"
              template="T_M3PWorkflowWorkflowsResumed"
              value="0xB014"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowRunspacePoolCreated.message)"
              opcode="Method"
              symbol="M3PWorkflowRunspacePoolCreated"
              task="WorkflowExecution"
              template="T_M3PWorkflowRunspacePoolCreated"
              value="0xB016"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionQueued.message)"
              opcode="Method"
              symbol="M3PActivityExecutionQueued"
              task="WorkflowExecution"
              template="T_M3PWorkflowActivityExecutionQueued"
              value="0xB017"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionStarted.message)"
              opcode="Method"
              symbol="M3PActivityExecutionStarted"
              task="WorkflowExecution"
              template="T_M3PWorkflowActivityExecutionStarted"
              value="0xB018"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportingFromXaml.message)"
              opcode="Method"
              symbol="M3PImportingWorkflowFromXaml"
              task="WorkflowExecution"
              template="T_M3PWorkflowImportingFromXaml"
              value="0xB019"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportedFromXaml.message)"
              opcode="Method"
              symbol="M3PImportedWorkflowFromXaml"
              task="WorkflowExecution"
              template="T_M3PWorkflowImportedFromXaml"
              value="0xB01A"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlError.message)"
              opcode="Method"
              symbol="M3PErrorImportingWorkflowFromXaml"
              task="WorkflowExecution"
              template="T_M3PWorkflowImportFromXamlError"
              value="0xB01B"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlValidationStarted.message)"
              opcode="Method"
              symbol="M3PWorkflowValidationStarted"
              task="WorkflowValidation"
              template="T_M3PWorkflowImportFromXamlValidationStarted"
              value="0xB01C"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlValidationFinishedSuccessfully.message)"
              opcode="Method"
              symbol="M3PWorkflowValidationFinished"
              task="WorkflowValidation"
              template="T_M3PWorkflowImportFromXamlValidationFinishedSuccessfully"
              value="0xB01D"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlValidationFinishedWithError.message)"
              opcode="Method"
              symbol="M3PWorkflowValidationError"
              task="WorkflowValidation"
              template="T_M3PWorkflowImportFromXamlValidationFinishedWithError"
              value="0xB01E"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlActivityValidated.message)"
              opcode="Method"
              symbol="M3PWorkflowActivityValidated"
              task="WorkflowExecution"
              template="T_M3PWorkflowImportFromXamlActivityValidated"
              value="0xB01F"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlActivityValidationFailed.message)"
              opcode="Method"
              symbol="M3PWorkflowActivityValidationFailed"
              task="WorkflowValidation"
              template="T_M3PWorkflowImportFromXamlActivityValidationFailed"
              value="0xB020"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionFailed.message)"
              opcode="Method"
              symbol="M3PWorkflowActivityExecutionFailed"
              task="WorkflowExecution"
              template="T_M3PWorkflowActivityExecutionFailed"
              value="0xB021"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowRunspaceAvailabilityChanged.message)"
              opcode="Method"
              symbol="M3PRunspaceAvailabilityChanged"
              task="WorkflowExecution"
              template="T_M3PWorkflowRunspaceAvailabilityChanged"
              value="0xB022"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowRunspaceStateChanged.message)"
              opcode="Method"
              symbol="M3PRunspaceStateChanged"
              task="WorkflowExecution"
              template="T_M3PWorkflowRunspaceStateChanged"
              value="0xB023"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowLoadedForExecution.message)"
              opcode="Method"
              symbol="M3PWorkflowLoadedForExecution"
              task="WorkflowExecution"
              template="T_M3PWorkflowLoadedForExecution"
              value="0xB024"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowUnloaded.message)"
              opcode="Method"
              symbol="M3PWorkflowUnloaded"
              task="WorkflowExecution"
              template="T_M3PWorkflowUnloaded"
              value="0xB025"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowCancelled.message)"
              opcode="Method"
              symbol="M3PWorkflowExecutionCancelled"
              task="WorkflowExecution"
              template="T_M3PWorkflowCancelled"
              value="0xB026"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowAborted.message)"
              opcode="Method"
              symbol="M3PWorkflowExecutionAborted"
              task="WorkflowExecution"
              template="T_M3PWorkflowAborted"
              value="0xB027"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowCleanup.message)"
              opcode="Method"
              symbol="M3PWorkflowCleanupPerformed"
              task="WorkflowExecution"
              template="T_M3PWorkflowCleanup"
              value="0xB028"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowLoadedFromDisk.message)"
              opcode="Method"
              symbol="M3PWorkflowLoadedFromDisk"
              task="WorkflowExecution"
              template="T_M3PWorkflowLoadedFromDisk"
              value="0xB029"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowDeletedFromDisk.message)"
              opcode="Method"
              symbol="M3PWorkflowDeletedFromDisk"
              task="WorkflowExecution"
              template="T_M3PWorkflowDeletedFromDisk"
              value="0xB02A"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PRemoveJobStarted.message)"
              opcode="Method"
              symbol="M3PRemoveJobStarted"
              task="WorkflowExecution"
              template="T_M3PRemoveJobStarted"
              value="0xB02C"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PJobStateChanged.message)"
              opcode="Method"
              symbol="M3PJobStateChanged"
              task="WorkflowExecution"
              template="T_M3PJobStateChanged"
              value="0xB02D"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PJobError.message)"
              opcode="Method"
              symbol="M3PJobError"
              task="WorkflowExecution"
              template="T_M3PJobError"
              value="0xB02E"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowJobCreated.message)"
              opcode="Method"
              symbol="M3PWorkflowJobCreated"
              task="WorkflowExecution"
              template="T_M3PWorkflowJobCreated"
              value="0xB030"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PParentJobCreated.message)"
              opcode="Method"
              symbol="M3PParentJobCreated"
              task="WorkflowExecution"
              template="T_M3PParentJobCreated"
              value="0xB031"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PJobCreationCompleted.message)"
              opcode="Method"
              symbol="M3PJobCreationComplete"
              task="WorkflowExecution"
              template="T_M3PJobCreationCompleted"
              value="0xB032"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PJobRemoved.message)"
              opcode="Method"
              symbol="M3PJobRemoved"
              task="WorkflowExecution"
              template="T_M3PJobRemoved"
              value="0xB033"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PJobRemoveError.message)"
              opcode="Method"
              symbol="M3PJobRemoveError"
              task="WorkflowExecution"
              template="T_M3PJobRemoveError"
              value="0xB034"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PLoadingWorkflowForExecution.message)"
              opcode="Method"
              symbol="M3PLoadingWorkflowForExecution"
              task="WorkflowExecution"
              template="T_M3PLoadingWorkflowForExecution"
              value="0xB035"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowExecutionFinished.message)"
              opcode="Method"
              symbol="M3PWorkflowExecutionFinished"
              task="WorkflowExecution"
              template="T_M3PWorkflowExecutionFinished"
              value="0xB036"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PCancellingWorkflowExecution.message)"
              opcode="Method"
              symbol="M3PCancellingWorkflowExecution"
              task="WorkflowExecution"
              template="T_M3PCancellingWorkflowExecution"
              value="0xB037"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PAbortingWorkflowExecution.message)"
              opcode="Method"
              symbol="M3PAbortingWorkflowExecution"
              task="WorkflowExecution"
              template="T_M3PAbortingWorkflowExecution"
              value="0xB038"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PUnloadingWorkflow.message)"
              opcode="Method"
              symbol="M3PUnloadingWorkflow"
              task="WorkflowExecution"
              template="T_M3PUnloadingWorkflow"
              value="0xB039"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PForcedWorkflowShutdownStarted.message)"
              opcode="Method"
              symbol="M3PForcedWorkflowShutdownStarted"
              task="WorkflowExecution"
              template="T_M3PForcedWorkflowShutdownStarted"
              value="0xB03A"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PForcedWorkflowShutdownFinished.message)"
              opcode="Method"
              symbol="M3PForcedWorkflowShutdownFinished"
              task="WorkflowExecution"
              template="T_M3PForceWorkflowShutdownFinished"
              value="0xB03B"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PForcedWorkflowShutdownError.message)"
              opcode="Method"
              symbol="M3PForcedWorkflowShutdownError"
              task="WorkflowExecution"
              template="T_M3PForcedWorkflowShutdownError"
              value="0xB03C"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PPersistingWorkflow.message)"
              opcode="Method"
              symbol="M3PPersistingWorkflow"
              task="WorkflowExecution"
              template="T_M3PPersistingWorkflow"
              value="0xB03D"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowPersisted.message)"
              opcode="Method"
              symbol="M3PWorkflowPersisted"
              task="WorkflowExecution"
              template="T_M3PWorkflowPersisted"
              value="0xB03E"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionFinished.message)"
              opcode="Method"
              symbol="M3PActivityExecutionFinished"
              task="WorkflowExecution"
              template="T_M3PWorkflowActivityExecutionFinished"
              value="0xB03F"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowExecutionError.message)"
              opcode="Method"
              symbol="M3PWorkflowExecutionError"
              task="WorkflowExecution"
              template="T_M3PWorkflowExecutionError"
              value="0xB040"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PEndpointRegistered.message)"
              opcode="Method"
              symbol="M3PEndpointRegistered"
              task="Configuration"
              template="T_M3PEndpointRegistered"
              value="0xB041"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PEndpointModified.message)"
              opcode="Method"
              symbol="M3PEndpointModified"
              task="Configuration"
              template="T_M3PEndpointModified"
              value="0xB042"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PEndpointUnregistered.message)"
              opcode="Method"
              symbol="M3PEndpointUnregistered"
              task="Configuration"
              template="T_M3PEndpointUnregistered"
              value="0xB043"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PEndpointDisabled.message)"
              opcode="Method"
              symbol="M3PEndpointDisabled"
              task="Configuration"
              template="T_M3PEndpointDisabled"
              value="0xB044"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PEndpointEnabled.message)"
              opcode="Method"
              symbol="M3PEndpointEnabled"
              task="Configuration"
              template="T_M3PEndpointEnabled"
              value="0xB045"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3POutOfProcessRunspaceStarted.message)"
              opcode="Method"
              symbol="M3POutOfProcessRunspaceStarted"
              task="WorkflowExecution"
              template="T_M3POutOfProcessRunspaceStarted"
              value="0xB046"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PParameterSplattingWasPerformed.message)"
              opcode="Method"
              symbol="M3PParameterSplattingWasPerformed"
              task="WorkflowExecution"
              template="T_M3PParameterSplattingWasPerformed"
              value="0xB047"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="PSWorkflow"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_M3PWorkflowEngineStarted.message)"
              opcode="Method"
              symbol="M3PWorkflowEngineStarted"
              task="WorkflowHosting"
              template="T_M3PWorkflowEngineStarted"
              value="0xB048"
              version="1"
              />
          <!--M3P Debug -->
          <event
              channel="C_DEBUG"
              keywords="PSWorkflow"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PWORKFLOW_MANAGER_CHECKPOINTPATH.message)"
              symbol="M3PWorkflowManagerCheckpoint"
              task="win:None"
              template="T_M3PWorkflowManagerCheckpoint"
              value="0xB049"
              version="1"
              />
          <!--Operational-->
          <event
              keywords="Cmdlets"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_CMDLETS_HOSTNAMERESOLVE.message)"
              opcode="Method"
              symbol="E_O_CMDLETS_HOSTNAMERESOLVE"
              task="CreateRunspace"
              value="0x1001"
              version="1"
              />
          <event
              keywords="Cmdlets"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_CMDLETS_SCHEMERESOLVE.message)"
              opcode="Method"
              symbol="E_O_CMDLETS_SCHEMERESOLVE"
              task="CreateRunspace"
              value="0x1002"
              version="1"
              />
          <event
              keywords="Cmdlets"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_CMDLETS_SHELLRESOLVE.message)"
              opcode="Method"
              symbol="E_O_CMDLETS_SHELLRESOLVE"
              task="CreateRunspace"
              value="0x1003"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_COMMAND_HEALTH.message)"
              opcode="Exception"
              symbol="E_O_COMMAND_HEALTH"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1004"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ENGINE_HEALTH.message)"
              opcode="Exception"
              symbol="E_O_ENGINE_HEALTH"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1005"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_PROVIDER_HEALTH.message)"
              opcode="Exception"
              symbol="E_O_PROVIDER_HEALTH"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1006"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_PIPELINE_DETAIL.message)"
              opcode="Exception"
              symbol="E_O_PIPELINE_DETAIL"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1007"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_SCRIPTBLOCK_CREATE_DETAIL.message)"
              opcode="Create"
              symbol="E_O_SCRIPTBLOCK_COMPILE"
              task="CommandStart"
              template="T_ScriptBlock_Compiled"
              value="0x1008"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_SCRIPTBLOCK_INVOKE_START_DETAIL.message)"
              opcode="Open"
              symbol="E_O_SCRIPTBLOCK_INVOKE_START"
              task="CommandStart"
              template="T_ScriptBlock_Executed"
              value="0x1009"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_SCRIPTBLOCK_INVOKE_COMPLETE_DETAIL.message)"
              opcode="Close"
              symbol="E_O_SCRIPTBLOCK_INVOKE_COMPLETE"
              task="CommandStop"
              template="T_ScriptBlock_Executed"
              value="0x100A"
              version="1"
              />
          <!--Analytic -->
          <event
              channel="C_ANALYTIC"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_COMMAND_LIFECYCLE.message)"
              opcode="Method"
              symbol="E_A_COMMAND_LIFECYCLE"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1F01"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_ENGINE_LIFECYCLE.message)"
              opcode="Method"
              symbol="E_A_ENGINE_LIFECYCLE"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1F02"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_PROVIDER_LIFECYCLE.message)"
              opcode="Method"
              symbol="E_A_PROVIDER_LIFECYCLE"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1F03"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_SETTINGS.message)"
              opcode="Method"
              symbol="E_A_SETTINGS"
              task="win:None"
              template="T_LOG_CONTEXT"
              value="0x1F04"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_WriteTransferEvent.message)"
              opcode="Method"
              symbol="WriteTransferEvent"
              template="T_CorrelationEvent"
              value="0x1F05"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Cmdlets"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_ENGINE_TRACE.message)"
              opcode="Method"
              symbol="E_A_ENGINE_TRACE"
              task="win:None"
              template="T_ENGINE_TRACE_CONTEXT"
              value="0x1F06"
              version="1"
              />
          <!--Runspace Events-->
          <!--Operational-->
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_RUNSPACE_CONSTRUCTOR.message)"
              opcode="Constructor"
              symbol="E_O_RUNSPACE_CONSTRUCTOR"
              task="CreateRunspace"
              template="T_STRING"
              value="0x2001"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_RUNSPACEPOOL_CONSTRUCTOR.message)"
              opcode="Constructor"
              symbol="E_O_RUNSPACEPOOL_CONSTRUCTOR"
              task="CreateRunspace"
              template="T_RUNSPACEPOOL"
              value="0x2002"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_RUNSPACEPOOL_OPEN.message)"
              opcode="Open"
              symbol="E_O_RUNSPACEPOOL_OPEN"
              task="CreateRunspace"
              value="0x2003"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_RUNSPACEPOOL_TRANSFER.message)"
              opcode="Open"
              symbol="E_O_RUNSPACEPOOL_TRANSFER"
              task="CreateRunspace"
              value="0x2004"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_RUNSPACE_STATE_CHANGE.message)"
              opcode="Open"
              symbol="E_O_RUNSPACE_STATE_CHANGE"
              task="CreateRunspace"
              template="T_STRING"
              value="0x2005"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_REMOTE_RUNSPACE_CREATE_RETRY.message)"
              opcode="Open"
              symbol="E_O_REMOTE_RUNSPACE_CREATE_RETRY"
              task="CreateRunspace"
              template="T_STRING3"
              value="0x2006"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_LISTENER_START.message)"
              opcode="Open"
              symbol="E_O_REMOTE_NAMEDPIPE_LISTENER_START"
              task="NamedPipe"
              template="T_STRING2"
              value="0xD100"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_LISTENER_END.message)"
              opcode="Close"
              symbol="E_O_REMOTE_NAMEDPIPE_LISTENER_END"
              task="NamedPipe"
              template="T_STRING2"
              value="0xD101"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_LISTENER_ERROR.message)"
              opcode="Exception"
              symbol="E_O_REMOTE_NAMEDPIPE_LISTENER_ERROR"
              task="NamedPipe"
              template="T_STRING3"
              value="0xD102"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_CONNECT.message)"
              opcode="Connect"
              symbol="E_O_REMOTE_NAMEDPIPE_CONNECT"
              task="NamedPipe"
              template="T_STRING3"
              value="0xD103"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_DISCONNECT.message)"
              opcode="Close"
              symbol="E_O_REMOTE_NAMEDPIPE_DISCONNECT"
              task="NamedPipe"
              template="T_STRING3"
              value="0xD104"
              version="1"
              />
          <!--Analytic-->
          <event
              channel="C_ANALYTIC"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACE_PORT.message)"
              opcode="Method"
              symbol="E_A_RUNSPACE_PORT"
              task="CreateRunspace"
              template="T_STRING"
              value="0x2F01"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACE_APPNAME.message)"
              opcode="Method"
              symbol="E_A_RUNSPACE_APPNAME"
              task="CreateRunspace"
              template="T_STRING"
              value="0x2F02"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACE_COMPUTERNAME.message)"
              opcode="Method"
              symbol="E_A_RUNSPACE_COMPUTERNAME"
              task="CreateRunspace"
              template="T_STRING"
              value="0x2F03"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACE_SCHEME.message)"
              opcode="Method"
              symbol="E_A_RUNSPACE_SCHEME"
              task="CreateRunspace"
              template="T_STRING"
              value="0x2F04"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Runspace"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACE_TEST.message)"
              opcode="Method"
              symbol="E_A_RUNSPACE_TEST"
              task="CreateRunspace"
              value="0x2F05"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Runspace"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACE_WSMANCONNECTIONINFO.message)"
              opcode="Method"
              symbol="E_A_RUNSPACE_WSMANCONNECTIONINFO"
              task="CreateRunspace"
              template="T_WSMANCONNECTIONINFO"
              value="0x2F06"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Runspace"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACEPOOL_TRANSFER.message)"
              opcode="Open"
              symbol="E_A_RUNSPACEPOOL_TRANSFER"
              task="CreateRunspace"
              value="0x2F07"
              version="1"
              />
          <!--Transport events-->
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_RCVDOBJ.message)"
              opcode="Receive"
              symbol="E_O_TRANSPORT_RCVDOBJ"
              template="T_REMOTEDATAOBJECT"
              value="0x8001"
              version="1"
              />
          <!--
            Error messages need to be logged both in Operational and Analytic channels
            to support easy debugging
            -->
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_A_APPDOMAIN_UNHANDLED_EXCEPTION.message)"
              opcode="Open"
              symbol="E_A_APPDOMAIN_UNHANDLED_EXCEPTION"
              template="T_STRING3"
              value="0x8007"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_ERROR.message)"
              opcode="Open"
              symbol="E_A_TRANSPORT_ERROR"
              template="T_TRANSPORTERROR"
              value="0x8008"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Transport"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_O_APPDOMAIN_UNHANDLED_EXCEPTION.message)"
              opcode="Open"
              symbol="E_O_APPDOMAIN_UNHANDLED_EXCEPTION"
              template="T_STRING3"
              value="0x8009"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="Transport"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_O_TRANSPORT_ERROR.message)"
              opcode="Open"
              symbol="E_O_TRANSPORT_ERROR"
              template="T_TRANSPORTERROR"
              value="0x8010"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_CONNECT.message)"
              opcode="Connect"
              symbol="E_A_TRANSPORT_CONNECT"
              template="T_STRING"
              value="0x8011"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SHELL_CONNECT_CALLBACK.message)"
              opcode="Connect"
              symbol="E_A_TRANSPORT_SHELL_CONNECT_CALLBACK"
              template="T_STRING"
              value="0x8012"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SHELL_CLOSE.message)"
              opcode="Disconnect"
              symbol="E_A_TRANSPORT_SHELL_CLOSE"
              template="T_STRING"
              value="0x8013"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SHELL_CLOSE_CALLBACK.message)"
              opcode="Disconnect"
              symbol="E_A_TRANSPORT_SHELL_CLOSE_CALLBACK"
              template="T_STRING"
              value="0x8014"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SEND_DATA.message)"
              opcode="Send"
              symbol="E_A_TRANSPORT_SEND_DATA"
              template="T_TRANSPORTDATACONTEXT"
              value="0x8015"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SEND_DATA_CALLBACK.message)"
              opcode="Send"
              symbol="E_A_TRANSPORT_SEND_DATA_CALLBACK"
              template="T_TRANSPORTCONTEXT"
              value="0x8016"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_RECEIVE_DATA.message)"
              opcode="Receive"
              symbol="E_A_TRANSPORT_RECEIVE_DATA"
              template="T_TRANSPORTCONTEXT"
              value="0x8017"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_RECEIVE_DATA_CALLBACK.message)"
              opcode="Receive"
              symbol="E_A_TRANSPORT_RECEIVE_DATA_CALLBACK"
              template="T_TRANSPORTDATACONTEXT"
              value="0x8018"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_CMD_CONNECT.message)"
              opcode="Connect"
              symbol="E_A_TRANSPORT_CMD_CONNECT"
              template="T_TRANSPORTCONTEXT"
              value="0x8019"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_CMD_CONNECT_CALLBACK.message)"
              opcode="Connect"
              symbol="E_A_TRANSPORT_CMD_CONNECT_CALLBACK"
              template="T_TRANSPORTCONTEXT"
              value="0x8020"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_CMD_CLOSE.message)"
              opcode="Disconnect"
              symbol="E_A_TRANSPORT_CMD_CLOSE"
              template="T_TRANSPORTCONTEXT"
              value="0x8021"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_CMD_CLOSE_CALLBACK.message)"
              opcode="Disconnect"
              symbol="E_A_TRANSPORT_CMD_CLOSE_CALLBACK"
              template="T_TRANSPORTCONTEXT"
              value="0x8022"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SIGNAL.message)"
              opcode="Disconnect"
              symbol="E_A_TRANSPORT_SIGNAL"
              template="T_TRANSPORTSIGNAL"
              value="0x8023"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SIGNAL_CALLBACK.message)"
              opcode="Disconnect"
              symbol="E_A_TRANSPORT_SIGNAL_CALLBACK"
              template="T_TRANSPORTCONTEXT"
              value="0x8024"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_URI_REDIRECTION.message)"
              opcode="Connect"
              symbol="E_A_TRANSPORT_URI_REDIRECTION"
              template="T_TRANSPORTURIREDIRECTION"
              value="0x8025"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_TRANSPORT_SERVER_SEND_DATA.message)"
              opcode="Send"
              symbol="E_A_TRANSPORT_SERVER_SEND_DATA"
              template="T_TRANSPORTSERVERDATASEND"
              value="0x8051"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_CREATE_SERVER_REMOTESESSION.message)"
              opcode="Connect"
              symbol="E_A_CREATE_SERVER_REMOTESESSION"
              template="T_STRING3"
              value="0x8052"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_REPORT_CONTEXT.message)"
              opcode="Connect"
              symbol="E_A_REPORT_CONTEXT"
              template="T_STRING2"
              value="0x8053"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_REPORT_OPERATION_COMPLETE.message)"
              opcode="Connect"
              symbol="E_A_REPORT_OPERATION_COMPLETE"
              template="T_STRING4"
              value="0x8054"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_CREATE_COMMAND_REMOTESESSION.message)"
              opcode="Connect"
              symbol="E_A_CREATE_COMMAND_REMOTESESSION"
              template="T_STRING2"
              value="0x8055"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_STOP_COMMAND.message)"
              opcode="Disconnect"
              symbol="E_A_STOP_COMMAND"
              template="T_STRING3"
              value="0x8056"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_SERVER_RECEIVED_DATA.message)"
              opcode="Open"
              symbol="E_A_SERVER_RECEIVED_DATA"
              template="T_STRING3"
              value="0x8057"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_SERVER_RECEIVE_REQUEST.message)"
              opcode="Open"
              symbol="E_A_SERVER_RECEIVE_REQUEST"
              template="T_STRING3"
              value="0x8058"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_SERVER_CLOSE_OPERATION.message)"
              opcode="Disconnect"
              symbol="E_A_SERVER_CLOSE_OPERATION"
              template="T_STRING3"
              value="0x8059"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_LOAD_PSCUSTOMSHELL_ASSEMBLY.message)"
              opcode="Connect"
              symbol="E_A_LOAD_PSCUSTOMSHELL_ASSEMBLY"
              template="T_STRING2"
              value="0x8061"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_LOAD_PSCUSTOMSHELL_TYPE.message)"
              opcode="Connect"
              symbol="E_A_LOAD_PSCUSTOMSHELL_TYPE"
              template="T_STRING2"
              value="0x8062"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_RECEIVED_FRAGMENT.message)"
              opcode="Receive"
              symbol="E_A_RECEIVED_FRAGMENT"
              template="T_FRAGMENT"
              value="0x8063"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_SENT_FRAGMENT.message)"
              opcode="Send"
              symbol="E_A_SENT_FRAGMENT"
              template="T_FRAGMENT"
              value="0x8064"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Transport"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_SHUTTING_DOWN.message)"
              opcode="ShuttingDown"
              symbol="E_A_SHUTTING_DOWN"
              template="T_SHUTTING_DOWN"
              value="0x8065"
              version="1"
              />
          <!--Serializer events-->
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_REHYDRATION_SUCCESS.message)"
              opcode="Rehydration"
              symbol="E_A_SERIALIZER_REHYDRATION_SUCCESS"
              task="Serialization"
              template="T_REHYDRATION_SUCCESS"
              value="0x7001"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_REHYDRATION_FAILURE.message)"
              opcode="Rehydration"
              symbol="E_A_SERIALIZER_REHYDRATION_FAILURE"
              task="Serialization"
              template="T_REHYDRATION_FAILURE"
              value="0x7002"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_DEPTH_OVERRIDE.message)"
              opcode="SerializationSettings"
              symbol="E_A_SERIALIZER_DEPTH_OVERRIDE"
              task="Serialization"
              template="T_SERIALIZER_DEPTH_OVERRIDE"
              value="0x7003"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Verbose"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_MODE_OVERRIDE.message)"
              opcode="SerializationSettings"
              symbol="E_A_SERIALIZER_MODE_OVERRIDE"
              task="Serialization"
              template="T_SERIALIZER_MODE_OVERRIDE"
              value="0x7004"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Warning"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_SCRIPT_PROPERTY_WITHOUT_RUNSPACE.message)"
              opcode="Exception"
              symbol="E_A_SERIALIZER_SCRIPT_PROPERTY_WITHOUT_RUNSPACE"
              task="Serialization"
              template="T_SERIALIZER_SCRIPT_PROPERTY_WITHOUT_RUNSPACE"
              value="0x7005"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Warning"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_PROPERTY_GETTER_FAILED.message)"
              opcode="Exception"
              symbol="E_A_SERIALIZER_PROPERTY_GETTER_FAILED"
              task="Serialization"
              template="T_SERIALIZER_PROPERTY_GETTER_FAILED"
              value="0x7006"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Warning"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_ENUMERATION_FAILED.message)"
              opcode="Exception"
              symbol="E_A_SERIALIZER_ENUMERATION_FAILED"
              task="Serialization"
              template="T_SERIALIZER_ENUMERATION_FAILED"
              value="0x7007"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Warning"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_TOSTRING_FAILED.message)"
              opcode="Exception"
              symbol="E_A_SERIALIZER_TOSTRING_FAILED"
              task="Serialization"
              template="T_SERIALIZER_TOSTRING_FAILED"
              value="0x7008"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_MAX_DEPTH_WHEN_SERIALIZING.message)"
              opcode="Exception"
              symbol="E_A_SERIALIZER_MAX_DEPTH_WHEN_SERIALIZING"
              task="Serialization"
              template="T_SERIALIZER_MAX_DEPTH_WHEN_SERIALIZING"
              value="0x700A"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_XMLEXCEPTION_WHEN_DESERIALIZING.message)"
              opcode="Exception"
              symbol="E_A_SERIALIZER_XMLEXCEPTION_WHEN_DESERIALIZING"
              task="Serialization"
              template="T_SERIALIZER_XMLEXCEPTION_WHEN_DESERIALIZING"
              value="0x700B"
              version="1"
              />
          <event
              channel="C_ANALYTIC"
              keywords="Serializer"
              level="win:Warning"
              message="$(string.PS_PROVIDER.event.E_A_SERIALIZER_SPECIFIC_PROPERTY_MISSING.message)"
              opcode="Exception"
              symbol="E_A_SERIALIZER_SPECIFIC_PROPERTY_MISSING"
              task="Serialization"
              template="T_SERIALIZER_SPECIFIC_PROPERTY_MISSING"
              value="0x700C"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="win:ResponseTime"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_Powershell-Console-Startup-Start.message)"
              opcode="win:Start"
              symbol="Powershell_Console_Startup_Start"
              task="Powershell-Console-Startup"
              value="0xA001"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              keywords="win:ResponseTime"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_Powershell-Console-Startup-Stop.message)"
              opcode="win:Stop"
              symbol="Powershell_Console_Startup_Stop"
              task="Powershell-Console-Startup"
              value="0xA002"
              version="1"
              />
          <!-- Debug log events-->
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_DebugMessage.message)"
              symbol="DebugMessage"
              task="win:None"
              template="T_DEBUGMESSAGE"
              value="0xC000"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_D_Powershell_ErrorRecord.message)"
              opcode="Exception"
              symbol="Powershell_ErrorRecord"
              task="win:None"
              template="T_ERROR_RECORD"
              value="0xB001"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Error"
              message="$(string.PS_PROVIDER.event.E_D_Powershell_Exception.message)"
              opcode="Exception"
              symbol="Powershell_Exception"
              task="win:None"
              template="T_STRING3"
              value="0xB002"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_Powershell_PSObject.message)"
              opcode="Method"
              symbol="Powershell_PSObject"
              task="win:None"
              value="0xB003"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_Powershell_Job.message)"
              opcode="Method"
              symbol="Powershell_Job"
              task="win:None"
              template="T_JOB"
              value="0xB004"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_MESSAGE.message)"
              symbol="TRACE_MESSAGE"
              task="win:None"
              template="T_STRING"
              value="0xB005"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_A_RUNSPACE_WSMANCONNECTIONINFO.message)"
              opcode="Method"
              symbol="E_D_RUNSPACE_WSMANCONNECTIONINFO"
              task="win:None"
              template="T_WSMANCONNECTIONINFO"
              value="0xB006"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_MESSAGE2.message)"
              symbol="TRACE_MESSAGE2"
              task="win:None"
              template="T_STRING2"
              value="0xC001"
              version="1"
              />
          <!-- Events for performance instrumentation-->
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginStartWorkflowApplication.message)"
              symbol="M3PBeginStartWorkflowApplication"
              task="win:None"
              template="T_TrackingGuid"
              value="0xB501"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndStartWorkflowApplication.message)"
              symbol="M3PEndStartWorkflowApplication"
              task="win:None"
              template="T_TrackingGuid"
              value="0xB502"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginCreateNewJob.message)"
              symbol="M3PBeginCreateNewJob"
              task="win:None"
              template="T_TrackingGuid"
              value="0xB503"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndCreateNewJob.message)"
              symbol="M3PEndCreateNewJob"
              task="win:None"
              template="T_TrackingGuid"
              value="0xB504"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PTrackingGuidContainerParentJobCorrelation.message)"
              symbol="M3PTrackingGuidContainerParentJobCorrelation"
              task="win:None"
              template="T_TrackingGuidContainerParentJob"
              value="0xB505"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginJobLogic.message)"
              symbol="M3PBeginJobLogic"
              task="win:None"
              template="T_WorkflowJobGuid"
              value="0xB506"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndJobLogic.message)"
              symbol="M3PEndJobLogic"
              task="win:None"
              template="T_WorkflowJobGuid"
              value="0xB507"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginWorkflowExecution.message)"
              symbol="M3PBeginWorkflowExecution"
              task="win:None"
              template="T_WorkflowJobGuid"
              value="0xB508"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndWorkflowExecution.message)"
              symbol="M3PEndWorkflowExecution"
              task="win:None"
              template="T_WorkflowJobGuid"
              value="0xB509"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PChildWorkflowJobAddition.message)"
              symbol="M3PChildWorkflowJobAddition"
              task="win:None"
              template="T_WorkflowJobContainerParentJob"
              value="0xB50A"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PProxyJobRemoteJobAssociation.message)"
              symbol="M3PProxyJobRemoteJobAssociation"
              task="win:None"
              template="T_ProxyJobContainerParentJob"
              value="0xB50B"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginContainerParentJobExecution.message)"
              symbol="M3PBeginContainerParentJobExecution"
              task="win:None"
              template="T_ContainerParentJob"
              value="0xB50C"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndContainerParentJobExecution.message)"
              symbol="M3PEndContainerParentJobExecution"
              task="win:None"
              template="T_ContainerParentJob"
              value="0xB50D"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginProxyJobExecution.message)"
              symbol="M3PBeginProxyJobExecution"
              task="win:None"
              template="T_ProxyJob"
              value="0xB50E"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndProxyJobExecution.message)"
              symbol="M3PEndProxyJobExecution"
              task="win:None"
              template="T_ProxyJob"
              value="0xB50F"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginProxyJobEventHandler.message)"
              symbol="M3PBeginProxyJobEventHandler"
              task="win:None"
              template="T_ProxyJob"
              value="0xB510"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndProxyJobEventHandler.message)"
              symbol="M3PEndProxyJobEventHandler"
              task="win:None"
              template="T_ProxyJob"
              value="0xB511"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginProxyChildJobEventHandler.message)"
              symbol="M3PBeginProxyChildJobEventHandler"
              task="win:None"
              template="T_ProxyChildJob"
              value="0xB512"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndProxyChildJobEventHandler.message)"
              symbol="M3PEndProxyChildJobEventHandler"
              task="win:None"
              template="T_ProxyChildJob"
              value="0xB513"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PBeginRunGarbageCollection.message)"
              symbol="M3PBeginRunGarbageCollection"
              task="win:None"
              value="0xB514"
              version="1"
              />
          <event
              channel="C_DEBUG"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_D_M3PEndRunGarbageCollection.message)"
              symbol="M3PEndRunGarbageCollection"
              task="win:None"
              value="0xB515"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Warning"
              message="$(string.PS_PROVIDER.event.E_O_M3PPERSISTENCE_STORE_MAXSIZE_REACHED.message)"
              symbol="M3PPersistenceStoreMaxSizeReached"
              task="win:None"
              value="0xB516"
              version="1"
              />
          <!-- Events for ISE-->
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEExecuteScript.message)"
              symbol="ISEExecuteScript"
              task="ISEOperation"
              template="T_ExecuteScriptOperation"
              value="0x6001"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEExecuteSelection.message)"
              symbol="ISEExecuteSelection"
              task="ISEOperation"
              template="T_ExecuteScriptOperation"
              value="0x6002"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEStopCommand.message)"
              symbol="ISEStopCommand"
              task="ISEOperation"
              value="0x6003"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEResumeDebugger.message)"
              symbol="ISEResumeDebugger"
              task="ISEOperation"
              value="0x6004"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEStopDebugger.message)"
              symbol="ISEStopDebugger"
              task="ISEOperation"
              value="0x6005"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEDebuggerStepInto.message)"
              symbol="ISEDebuggerStepInto"
              task="ISEOperation"
              value="0x6006"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEDebuggerStepOver.message)"
              symbol="ISEDebuggerStepOver"
              task="ISEOperation"
              value="0x6007"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEDebuggerStepOut.message)"
              symbol="ISEDebuggerStepOut"
              task="ISEOperation"
              value="0x6008"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEEnableAllBreakpoints.message)"
              symbol="ISEEnableAllBreakpoints"
              task="ISEOperation"
              value="0x6010"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEDisableAllBreakpoints.message)"
              symbol="ISEDisableAllBreakpoints"
              task="win:None"
              value="0x6011"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISERemoveAllBreakpoints.message)"
              symbol="ISERemoveAllBreakpoints"
              task="ISEOperation"
              value="0x6012"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISESetBreakpoint.message)"
              symbol="ISESetBreakpoint"
              task="ISEOperation"
              template="T_BreakpointOperation"
              value="0x6013"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISERemoveBreakpoint.message)"
              symbol="ISERemoveBreakpoint"
              task="ISEOperation"
              template="T_BreakpointOperation"
              value="0x6014"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEEnableBreakpoint.message)"
              symbol="ISEEnableBreakpoint"
              task="ISEOperation"
              template="T_BreakpointOperation"
              value="0x6015"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEDisableBreakpoint.message)"
              symbol="ISEDisableBreakpoint"
              task="ISEOperation"
              template="T_BreakpointOperation"
              value="0x6016"
              version="1"
              />
          <event
              channel="C_OPERATIONAL"
              level="win:Informational"
              message="$(string.PS_PROVIDER.event.E_O_ISEHitBreakpoint.message)"
              symbol="ISEHitBreakpoint"
              task="ISEOperation"
              template="T_BreakpointOperation"
              value="0x6017"
              version="1"
              />
          <event
                channel="C_ANALYTIC"
                keywords="AmsiState"
                level="win:Verbose"
                message="$(string.PS_PROVIDER.event.E_A_AmsiState.message)"
                opcode="Method"
                symbol="AmsiState"
                task="Amsi"
                template="T_AmsiState"
                value="0x4001"
                version="1"
              />
          <event
                channel="C_ANALYTIC"
                keywords="WDACQuery"
                level="win:Verbose"
                message="$(string.PS_PROVIDER.event.E_A_WDACQuery.message)"
                opcode="Method"
                symbol="WDACQuery"
                task="WDAC"
                template="T_WDACQuery"
                value="0x4002"
                version="1"
              />
          <event
                channel="C_ANALYTIC"
                keywords="WDACAudit"
                level="win:Verbose"
                message = "$(string.PS_PROVIDER.event.E_A_WDACAudit.message)"
                opcode="Method"
                symbol="WDACAudit"
                task="WDACAudit"
                template="T_WDACAudit"
                value="0x4003"
                version="1"
              />
          </events>
        <channels>
          <!--There are two channels defined for Windows PowerShell instrumentation
              event provider
                1. Operational - for high level diagnositc messages
                2. Analytic - for high volume high performance trace messages
		-->
          <channel
              chid="C_OPERATIONAL"
              enabled="true"
              isolation="Application"
              message="$(string.PS_CHANNEL_OPERATIONAL.ChannelMessage)"
              name="PowerShellCore/Operational"
              symbol="C_OPERATIONAL"
              type="Operational"
              >
            <logging>
              <!--this log is circular, which means older events
                  will be overwritten if the log gets full-->
              <retention>false</retention>
              <!--max size of the operational log file is 15 MB-->
              <maxSize>15728640</maxSize>
            </logging>
          </channel>
          <channel
              chid="C_ANALYTIC"
              enabled="false"
              isolation="Application"
              message="$(string.PS_CHANNEL_ANALYTIC.ChannelMessage)"
              name="PowerShellCore/Analytic"
              symbol="C_ANALYTIC"
              type="Analytic"
              >
            <logging>
              <!--this log is not circular, which means user has to
                  manually clear logs-->
              <retention>true</retention>
              <!--max size of the analytic log file is 100 MB.
                  It's ok to set it to this high a value because
                  this channel is not enabled by default and the
                  user will have to turn it on and this is the
                  maximum size as well-->
              <maxSize>1048985600</maxSize>
            </logging>
            <publishing>
              <!--increasing the size of the internal ETW buffer
                  to 64 KB so that it can hold large amounts of
                  data-->
              <bufferSize>64</bufferSize>
            </publishing>
          </channel>
          <channel
              chid="C_DEBUG"
              enabled="false"
              isolation="Application"
              message="$(string.PS_CHANNEL_DEBUG.ChannelMessage)"
              name="PowerShellCore/Debug"
              symbol="C_DEBUG"
              type="Debug"
              >
            <logging>
              <!--this log is not circular, which means user has to
					  manually clear logs-->
              <retention>true</retention>
              <!--max size of the analytic log file is 100 MB.
					  It's ok to set it to this high a value because
					  this channel is not enabled by default and the
					  user will have to turn it on and this is the
					  maximum size as well-->
              <maxSize>1048985600</maxSize>
            </logging>
            <publishing>
              <!--increasing the size of the internal ETW buffer
                  to 64 KB so that it can hold large amounts of
                  data-->
              <bufferSize>64</bufferSize>
            </publishing>
          </channel>
          <channel
              chid="C_ADMIN"
              enabled="true"
              isolation="Application"
              message="$(string.PS_CHANNEL_ADMIN.ChannelMessage)"
              name="PowerShellCore/Admin"
              symbol="C_ADMIN"
              type="Admin"
              >
            <logging>
              <!--this log is not circular, which means user has to
					  manually clear logs-->
              <retention>true</retention>
              <!--max size of the analytic log file is 100 MB.
					  It's ok to set it to this high a value because
					  this channel is not enabled by default and the
					  user will have to turn it on and this is the
					  maximum size as well-->
              <maxSize>1048985600</maxSize>
            </logging>
          </channel>
        </channels>
        <levels>
          <level
              message="$(string.PS_PROVIDER.level.L_DEBUG.message)"
              name="Debug"
              symbol="L_DEBUG"
              value="20"
              />
        </levels>
        <tasks>
          <task
              message="$(string.PS_PROVIDER.task.T_CREATERUNSPACE.message)"
              name="CreateRunspace"
              symbol="T_CREATERUNSPACE"
              value="1"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_EXECUTECOMMAND.message)"
              name="ExecuteCommand"
              symbol="T_EXECUTECOMMAND"
              value="2"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_SERIALIZATION.message)"
              name="Serialization"
              symbol="T_SERIALIZATION"
              value="3"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_Powershell-Console-Startup.message)"
              name="Powershell-Console-Startup"
              symbol="T_POWERSHELLSTARTUP"
              value="4"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_M3P-WorkflowHostingTask.message)"
              name="WorkflowHosting"
              symbol="T_WORKFLOWHOSTING"
              value="5"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_M3P-WorkflowExecutionTask.message)"
              name="WorkflowExecution"
              symbol="T_WORKFLOWEXECUTION"
              value="6"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_M3P-WorkflowPersistenceTask.message)"
              name="WorkflowPersistence"
              symbol="T_WORKFLOWPERSISTENCE"
              value="7"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_M3P-WorkflowValidationTask.message)"
              name="WorkflowValidation"
              symbol="T_WORKFLOWVALIDATION"
              value="8"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_M3P-ConfiguarationTask.message)"
              name="Configuration"
              symbol="T_CONFIGURATION"
              value="9"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_ENGINE_START.message)"
              name="EngineStart"
              symbol="T_ENGINESTART"
              value="100"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_ENGINE_STOP.message)"
              name="EngineStop"
              symbol="T_ENGINESTOP"
              value="101"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_COMMAND_START.message)"
              name="CommandStart"
              symbol="T_COMMANDSTART"
              value="102"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_COMMAND_STOP.message)"
              name="CommandStop"
              symbol="T_COMMANDSTOP"
              value="103"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_PROVIDER_START.message)"
              name="ProviderStart"
              symbol="T_PROVIDERSTART"
              value="104"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_PROVIDER_STOP.message)"
              name="ProviderStop"
              symbol="T_PROVIDERSTOP"
              value="105"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_EXECUTE_PIPELINE.message)"
              name="ExecutePipeline"
              symbol="T_EXECUTEPIEPLINE"
              value="106"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_ScheduledJob.message)"
              name="ScheduledJob"
              symbol="T_SCHEDULEDJOB"
              value="110"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_NamedPipe.message)"
              name="NamedPipe"
              symbol="T_NAMEDPIPE"
              value="111"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_ISEOperation.message)"
              name="ISEOperation"
              symbol="T_ISEOperation"
              value="120"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_AmsiState.message)"
              name="Amsi"
              symbol="T_Amsi"
              value="130"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_WDACQuery.message)"
              name="WDAC"
              symbol="T_WDAC"
              value="131"
              />
          <task
              message="$(string.PS_PROVIDER.task.T_WDACAudit.message)"
              name="WDACAudit"
              symbol="T_WDACAudit"
              value="132"
              />
        </tasks>
        <opcodes>
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_OPEN.message)"
              name="Open"
              symbol="O_OPEN"
              value="10"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_CLOSE.message)"
              name="Close"
              symbol="O_CLOSE"
              value="11"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_CONNECT.message)"
              name="Connect"
              symbol="O_CONNECT"
              value="12"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_DISCONNECT.message)"
              name="Disconnect"
              symbol="O_DISCONNECT"
              value="13"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_NEGOTIATE.message)"
              name="Negotiate"
              symbol="O_NEGOTIATE"
              value="14"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_CREATE.message)"
              name="Create"
              symbol="O_CREATE"
              value="15"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_CONSTRUCTOR.message)"
              name="Constructor"
              symbol="O_CONSTRUCTOR"
              value="16"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_DISPOSE.message)"
              name="Dispose"
              symbol="O_DISPOSE"
              value="17"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_EVENTHANDLER.message)"
              name="EventHandler"
              symbol="O_EVENTHANDLER"
              value="18"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_EXCEPTION.message)"
              name="Exception"
              symbol="O_EXCEPTION"
              value="19"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_METHOD.message)"
              name="Method"
              symbol="O_METHOD"
              value="20"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_SEND.message)"
              name="Send"
              symbol="O_SEND"
              value="21"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_RECEIVE.message)"
              name="Receive"
              symbol="O_RECEIVE"
              value="22"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_REHYDRATION.message)"
              name="Rehydration"
              symbol="O_REHYDRATION"
              value="23"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_SERIALIZATION_SETTINGS.message)"
              name="SerializationSettings"
              symbol="O_SERIALIZATION_SETTINGS"
              value="24"
              />
          <opcode
              message="$(string.PS_PROVIDER.opcode.O_SHUTTING_DOWN.message)"
              name="ShuttingDown"
              symbol="O_SHUTTING_DOWN"
              value="25"
              />
        </opcodes>
        <keywords>
          <keyword
              mask="0x1"
              message="$(string.PS_PROVIDER.keyword.K_RUNSPACE.message)"
              name="Runspace"
              symbol="K_RUNSPACE"
              />
          <keyword
              mask="0x2"
              message="$(string.PS_PROVIDER.keyword.K_PIPELINE.message)"
              name="Pipeline"
              symbol="K_PIPELINE"
              />
          <keyword
              mask="0x4"
              message="$(string.PS_PROVIDER.keyword.K_PROTOCOL.message)"
              name="Protocol"
              symbol="K_PROTOCOL"
              />
          <keyword
              mask="0x8"
              message="$(string.PS_PROVIDER.keyword.K_TRANSPORT.message)"
              name="Transport"
              symbol="K_TRANSPORT"
              />
          <keyword
              mask="0x10"
              message="$(string.PS_PROVIDER.keyword.K_HOST.message)"
              name="Host"
              symbol="K_HOST"
              />
          <keyword
              mask="0x20"
              message="$(string.PS_PROVIDER.keyword.K_CMDLETS.message)"
              name="Cmdlets"
              symbol="K_CMDLETS"
              />
          <keyword
              mask="0x40"
              message="$(string.PS_PROVIDER.keyword.K_SERIALIZER.message)"
              name="Serializer"
              symbol="K_SERIALIZER"
              />
          <keyword
              mask="0x80"
              message="$(string.PS_PROVIDER.keyword.K_SESSION.message)"
              name="Session"
              symbol="K_SESSION"
              />
          <keyword
              mask="0x100"
              message="$(string.PS_PROVIDER.keyword.K_PLUGIN.message)"
              name="Plugin"
              symbol="K_PLUGIN"
              />
          <keyword
              mask="0x200"
              message="$(string.PS_PROVIDER.keyword.K_PSWORKFLOW.message)"
              name="PSWorkflow"
              symbol="K_PSWORKFLOW"
              />
          <keyword
              mask="0x400"
              message="$(string.PS_PROVIDER.keyword.K_AmsiState.message)"
              name="AmsiState"
              symbol="K_AmsiState"
              />
          <keyword
              mask="0x800"
              message="$(string.PS_PROVIDER.keyword.K_WDACQuery.message)"
              name="WDACQuery"
              symbol="K_WDACQuery"
              />
          <keyword
              mask="0x1000"
              message="$(string.PS_PROVIDER.keyword.K_WDACAudit.message)"
              name="WDACAudit"
              symbol="K_WDACAudit"
              />
        </keywords>
        <maps>
          <!-- please keep in sync with SerializationMethod from
               C:\e\win7_powershell\admin\monad\src\engine\MshObject.cs
            -->
          <valueMap name="SerializationMethod">
            <map
                message="$(string.SerializationMethod.AllPublicProperties)"
                value="0"
                />
            <map
                message="$(string.SerializationMethod.String)"
                value="1"
                />
            <map
                message="$(string.SerializationMethod.SpecificProperties)"
                value="2"
                />
          </valueMap>
          <!-- please keep in sync with WSManAuthenticationMechanism from
               C:\e\win7_powershell\admin\monad\src\engine\remoting\fanin\WSManNativeAPI.cs
            -->
          <bitMap name="WSManAuthenticationMechanism">
            <map
                message="$(string.WSManAuthenticationMechanism.WSMAN_FLAG_NO_AUTHENTICATION)"
                value="0x1"
                />
            <map
                message="$(string.WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_DIGEST)"
                value="0x2"
                />
            <map
                message="$(string.WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_NEGOTIATE)"
                value="0x4"
                />
            <map
                message="$(string.WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_BASIC)"
                value="0x8"
                />
            <map
                message="$(string.WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_KERBEROS)"
                value="0x10"
                />
            <map
                message="$(string.WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_CLIENT_CERTIFICATE)"
                value="0x20"
                />
            <map
                message="$(string.WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_CREDSSP)"
                value="0x80"
                />
          </bitMap>
          <!-- please keep in sync with WSManAuthenticationMechanism from
               C:\e\win7_powershell\admin\monad\src\engine\remoting\fanin\WSManNativeAPI.cs
            -->
          <bitMap name="RemotingDestination">
            <map
                message="$(string.RemotingDestination.Client)"
                value="0x1"
                />
            <map
                message="$(string.RemotingDestination.Server)"
                value="0x2"
                />
            <map
                message="$(string.RemotingDestination.Listener)"
                value="0x4"
                />
          </bitMap>
          <!-- please keep in sync with RemotingTargetInterface from
               C:\e\win7_powershell\admin\monad\src\engine\remoting\common\WireDataFormat\EncodeAndDecode.cs
            -->
          <valueMap name="RemotingTargetInterface">
            <map
                message="$(string.RemotingTargetInterface.InvalidTargetInterface)"
                value="0"
                />
            <map
                message="$(string.RemotingTargetInterface.Session)"
                value="1"
                />
            <map
                message="$(string.RemotingTargetInterface.RunspacePool)"
                value="2"
                />
            <map
                message="$(string.RemotingTargetInterface.PowerShell)"
                value="3"
                />
          </valueMap>
          <!-- please keep in sync with RemotingDataType from
               C:\e\win7_powershell\admin\monad\src\engine\remoting\common\WireDataFormat\EncodeAndDecode.cs
            -->
          <valueMap name="RemotingDataType">
            <map
                message="$(string.RemotingDataType.InvalidDataType)"
                value="0"
                />
            <map
                message="$(string.RemotingDataType.ExceptionAsErrorRecord)"
                value="1"
                />
            <map
                message="$(string.RemotingDataType.SessionConfiguration)"
                value="0x00010000"
                />
            <map
                message="$(string.RemotingDataType.SessionConfigurationRequest)"
                value="0x00010001"
                />
            <map
                message="$(string.RemotingDataType.SessionCapability)"
                value="0x00010002"
                />
            <map
                message="$(string.RemotingDataType.CloseSession)"
                value="0x00010003"
                />
            <map
                message="$(string.RemotingDataType.CreateRunspacePool)"
                value="0x00010004"
                />
            <map
                message="$(string.RemotingDataType.SetMaxRunspaces)"
                value="0x00021002"
                />
            <map
                message="$(string.RemotingDataType.SetMinRunspaces)"
                value="0x00021003"
                />
            <map
                message="$(string.RemotingDataType.RunspacePoolOperationResponse)"
                value="0x00021004"
                />
            <map
                message="$(string.RemotingDataType.RunspacePoolStateInfo)"
                value="0x00021005"
                />
            <map
                message="$(string.RemotingDataType.CreatePowerShell)"
                value="0x00021006"
                />
            <map
                message="$(string.RemotingDataType.AvailableRunspaces)"
                value="0x00021007"
                />
            <map
                message="$(string.RemotingDataType.PSEventArgs)"
                value="0x00021008"
                />
            <map
                message="$(string.RemotingDataType.RemoteHostCallUsingRunspaceHost)"
                value="0x00021100"
                />
            <map
                message="$(string.RemotingDataType.RemoteRunspaceHostResponseData)"
                value="0x00021101"
                />
            <map
                message="$(string.RemotingDataType.PowerShellInput)"
                value="0x00041002"
                />
            <map
                message="$(string.RemotingDataType.PowerShellInputEnd)"
                value="0x00041003"
                />
            <map
                message="$(string.RemotingDataType.PowerShellOutput)"
                value="0x00041004"
                />
            <map
                message="$(string.RemotingDataType.PowerShellErrorRecord)"
                value="0x00041005"
                />
            <map
                message="$(string.RemotingDataType.PowerShellStateInfo)"
                value="0x00041006"
                />
            <map
                message="$(string.RemotingDataType.PowerShellDebug)"
                value="0x00041007"
                />
            <map
                message="$(string.RemotingDataType.PowerShellVerbose)"
                value="0x00041008"
                />
            <map
                message="$(string.RemotingDataType.PowerShellWarning)"
                value="0x00041009"
                />
            <map
                message="$(string.RemotingDataType.PowerShellProgress)"
                value="0x00041010"
                />
            <map
                message="$(string.RemotingDataType.StopPowerShell)"
                value="0x00041012"
                />
            <map
                message="$(string.RemotingDataType.RemoteHostCallUsingPowerShellHost)"
                value="0x00041100"
                />
            <map
                message="$(string.RemotingDataType.RemotePowerShellHostResponseData)"
                value="0x00041101"
                />
          </valueMap>
        </maps>
        <templates>
          <!--
            see http://msdn.microsoft.com/en-us/library/aa382747(VS.85).aspx
            for definitions of different data types
          -->
          <template tid="T_CorrelationEvent">
            <data
                inType="win:GUID"
                name="currentActivityId"
                />
            <data
                inType="win:GUID"
                name="parentActivityId"
                />
          </template>
          <template tid="T_M3PWorkflowLoadedForExecution">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowExecutionFinished">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PLoadingWorkflowForExecution">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PForcedWorkflowShutdownStarted">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PForceWorkflowShutdownFinished">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowPersisted">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PPersistingWorkflow">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="persistPath"
                />
          </template>
          <template tid="T_M3PForcedWorkflowShutdownError">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="errorDescription"
                />
          </template>
          <template tid="T_M3PUnloadingWorkflow">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowUnloaded">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PCancellingWorkflowExecution">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowCancelled">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowCleanup">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowDeletedFromDisk">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="path"
                />
          </template>
          <template tid="T_M3PWorkflowJobCreated">
            <data
                inType="win:GUID"
                name="parentJobId"
                />
            <data
                inType="win:GUID"
                name="childJobId"
                />
            <data
                inType="win:GUID"
                name="childWorkflowId"
                />
          </template>
          <template tid="T_M3PJobError">
            <data
                inType="win:Int32"
                name="jobId"
                />
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="errorDescription"
                />
          </template>
          <template tid="T_M3PJobStateChanged">
            <data
                inType="win:Int32"
                name="jobId"
                />
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="newState"
                />
            <data
                inType="win:UnicodeString"
                name="oldState"
                />
          </template>
          <template tid="T_M3PRemoveJobStarted">
            <data
                inType="win:GUID"
                name="jobId"
                />
          </template>
          <template tid="T_M3PJobRemoveError">
            <data
                inType="win:GUID"
                name="parentJobId"
                />
            <data
                inType="win:GUID"
                name="childJobId"
                />
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="error"
                />
          </template>
          <template tid="T_M3PJobRemoved">
            <data
                inType="win:GUID"
                name="parentJobId"
                />
            <data
                inType="win:GUID"
                name="childJobId"
                />
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PJobCreationCompleted">
            <data
                inType="win:GUID"
                name="jobId"
                />
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PParentJobCreated">
            <data
                inType="win:GUID"
                name="jobId"
                />
          </template>
          <template tid="T_M3PWorkflowLoadedFromDisk">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="path"
                />
          </template>
          <template tid="T_M3PAbortingWorkflowExecution">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="reason"
                />
          </template>
          <template tid="T_M3PWorkflowAborted">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowPluginStarted">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
            <data
                inType="win:UnicodeString"
                name="user"
                />
            <data
                inType="win:UnicodeString"
                name="hostingMode"
                />
            <data
                inType="win:UnicodeString"
                name="protocol"
                />
            <data
                inType="win:UnicodeString"
                name="configuration"
                />
          </template>
          <template tid="T_M3PWorkflowExecutionStarted">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="managedNodes"
                />
          </template>
          <template tid="T_M3PEndpointRegistered">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
            <data
                inType="win:UnicodeString"
                name="endpointType"
                />
            <data
                inType="win:UnicodeString"
                name="registeredBy"
                />
          </template>
          <template tid="T_M3PWorkflowEngineStarted">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
          </template>
          <template tid="T_M3PWorkflowManagerCheckpoint">
            <data
                inType="win:UnicodeString"
                name="checkpointPath"
                />
            <data
                inType="win:UnicodeString"
                name="configProviderId"
                />
            <data
                inType="win:UnicodeString"
                name="userName"
                />
            <data
                inType="win:UnicodeString"
                name="path"
                />
          </template>
          <template tid="T_M3PParameterSplattingWasPerformed">
            <data
                inType="win:UnicodeString"
                name="parameters"
                />
            <data
                inType="win:UnicodeString"
                name="computers"
                />
          </template>
          <template tid="T_M3POutOfProcessRunspaceStarted">
            <data
                inType="win:UnicodeString"
                name="command"
                />
          </template>
          <template tid="T_M3PEndpointEnabled">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
            <data
                inType="win:UnicodeString"
                name="enabledBy"
                />
          </template>
          <template tid="T_M3PEndpointDisabled">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
            <data
                inType="win:UnicodeString"
                name="disabledBy"
                />
          </template>
          <template tid="T_M3PEndpointUnregistered">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
            <data
                inType="win:UnicodeString"
                name="unregisteredBy"
                />
          </template>
          <template tid="T_M3PEndpointModified">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
            <data
                inType="win:UnicodeString"
                name="modifiedBy"
                />
          </template>
          <template tid="T_M3PWorkflowExecutionError">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="errorDescription"
                />
          </template>
          <template tid="T_M3PWorkflowStateChanged">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="newState"
                />
            <data
                inType="win:UnicodeString"
                name="oldState"
                />
          </template>
          <template tid="T_M3PWorkflowPluginRequestedToShutdown">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
          </template>
          <template tid="T_M3PWorkflowPluginRestarted">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
          </template>
          <template tid="T_M3PWorkflowsResuming">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowQuotaViolationDetected">
            <data
                inType="win:UnicodeString"
                name="endpointName"
                />
            <data
                inType="win:UnicodeString"
                name="configName"
                />
            <data
                inType="win:UnicodeString"
                name="allowedValue"
                />
            <data
                inType="win:UnicodeString"
                name="valueInQuestion"
                />
          </template>
          <template tid="T_M3PWorkflowWorkflowsResumed">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowRunspacePoolCreated">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="managedNode"
                />
          </template>
          <template tid="T_M3PWorkflowActivityExecutionQueued">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="activityName"
                />
          </template>
          <template tid="T_M3PWorkflowActivityExecutionFinished">
            <data
                inType="win:UnicodeString"
                name="activityName"
                />
          </template>
          <template tid="T_M3PWorkflowActivityExecutionStarted">
            <data
                inType="win:UnicodeString"
                name="activityName"
                />
            <data
                inType="win:UnicodeString"
                name="activityTypeName"
                />
          </template>
          <template tid="T_M3PWorkflowImportingFromXaml">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="xamlFile"
                />
          </template>
          <template tid="T_M3PWorkflowImportedFromXaml">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="xamlFile"
                />
          </template>
          <template tid="T_M3PWorkflowImportFromXamlError">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="errorDescription"
                />
          </template>
          <template tid="T_M3PWorkflowImportFromXamlValidationStarted">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowImportFromXamlValidationFinishedSuccessfully">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowImportFromXamlValidationFinishedWithError">
            <data
                inType="win:GUID"
                name="workflowId"
                />
          </template>
          <template tid="T_M3PWorkflowImportFromXamlActivityValidated">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="activityDisplayName"
                />
            <data
                inType="win:UnicodeString"
                name="activityType"
                />
          </template>
          <template tid="T_M3PWorkflowImportFromXamlActivityValidationFailed">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="activityDisplayName"
                />
            <data
                inType="win:UnicodeString"
                name="activityType"
                />
          </template>
          <template tid="T_M3PWorkflowActivityExecutionFailed">
            <data
                inType="win:GUID"
                name="workflowId"
                />
            <data
                inType="win:UnicodeString"
                name="activityName"
                />
            <data
                inType="win:UnicodeString"
                name="failureDescription"
                />
          </template>
          <template tid="T_M3PWorkflowRunspaceAvailabilityChanged">
            <data
                inType="win:UnicodeString"
                name="runspaceId"
                />
            <data
                inType="win:UnicodeString"
                name="availability"
                />
          </template>
          <template tid="T_M3PWorkflowRunspaceStateChanged">
            <data
                inType="win:UnicodeString"
                name="runspaceId"
                />
            <data
                inType="win:UnicodeString"
                name="newState"
                />
            <data
                inType="win:UnicodeString"
                name="oldState"
                />
          </template>
          <template tid="T_DEBUGMESSAGE">
            <data
                inType="win:UnicodeString"
                name="message"
                />
          </template>
          <template tid="T_STRING">
            <data
                inType="win:UnicodeString"
                name="param1"
                />
          </template>
          <template tid="T_STRING2">
            <data
                inType="win:UnicodeString"
                name="param1"
                />
            <data
                inType="win:UnicodeString"
                name="param2"
                />
          </template>
          <template tid="T_STRING3">
            <data
                inType="win:UnicodeString"
                name="param1"
                />
            <data
                inType="win:UnicodeString"
                name="param2"
                />
            <data
                inType="win:UnicodeString"
                name="param3"
                />
          </template>
          <template tid="T_STRING4">
            <data
                inType="win:UnicodeString"
                name="param1"
                />
            <data
                inType="win:UnicodeString"
                name="param2"
                />
            <data
                inType="win:UnicodeString"
                name="param3"
                />
            <data
                inType="win:UnicodeString"
                name="param4"
                />
          </template>
          <template tid="T_WSMANCONNECTIONINFO">
            <data
                inType="win:UnicodeString"
                name="uri"
                />
            <data
                inType="win:UnicodeString"
                name="shell"
                />
            <data
                inType="win:UnicodeString"
                name="userName"
                />
            <data
                inType="win:UnicodeString"
                name="opentimeout"
                />
            <data
                inType="win:UnicodeString"
                name="idletimeout"
                />
            <data
                inType="win:UnicodeString"
                name="canceltimeout"
                />
            <data
                inType="win:UInt32"
                map="WSManAuthenticationMechanism"
                name="auth"
                />
            <data
                inType="win:UnicodeString"
                name="thumbPrint"
                />
            <data
                inType="win:UnicodeString"
                name="redircount"
                />
            <data
                inType="win:UnicodeString"
                name="recvdDataSize"
                />
            <data
                inType="win:UnicodeString"
                name="recvdObjSize"
                />
          </template>
          <template tid="T_RUNSPACEPOOL">
            <data
                inType="win:UnicodeString"
                name="InstanceId"
                />
            <data
                inType="win:UnicodeString"
                name="MaxRunspaces"
                />
            <data
                inType="win:UnicodeString"
                name="MinRunspaces"
                />
          </template>
          <template tid="T_REMOTEDATAOBJECT">
            <data
                inType="win:UnicodeString"
                name="Runspace_InstanceId"
                />
            <data
                inType="win:UnicodeString"
                name="PowerShell_InstanceId"
                />
            <data
                inType="win:UInt32"
                map="RemotingDestination"
                name="Destination"
                />
            <data
                inType="win:UInt32"
                map="RemotingDataType"
                name="DataType"
                />
            <data
                inType="win:UInt32"
                map="RemotingTargetInterface"
                name="TargetInterface"
                />
          </template>
          <template tid="T_TRANSPORTDATACONTEXT">
            <data
                inType="win:UnicodeString"
                name="SessionId"
                />
            <data
                inType="win:UnicodeString"
                name="PipelineId"
                />
            <data
                inType="win:UnicodeString"
                name="DataSize"
                />
          </template>
          <template tid="T_TRANSPORTSERVERDATASEND">
            <data
                inType="win:UnicodeString"
                name="Runspace_InstanceId"
                />
            <data
                inType="win:UnicodeString"
                name="PowerShell_InstanceId"
                />
            <data
                inType="win:UnicodeString"
                name="DataSize"
                />
            <data
                inType="win:UInt32"
                map="RemotingDataType"
                name="DataType"
                />
            <data
                inType="win:UInt32"
                map="RemotingTargetInterface"
                name="TargetInterface"
                />
          </template>
          <template tid="T_TRANSPORTCONTEXT">
            <data
                inType="win:UnicodeString"
                name="SessionId"
                />
            <data
                inType="win:UnicodeString"
                name="PipelineId"
                />
          </template>
          <template tid="T_TRANSPORTERROR">
            <data
                inType="win:UnicodeString"
                name="SessionId"
                />
            <data
                inType="win:UnicodeString"
                name="PipelineId"
                />
            <data
                inType="win:UnicodeString"
                name="ErrorCode"
                />
            <data
                inType="win:UnicodeString"
                name="ErrorMessage"
                />
            <data
                inType="win:UnicodeString"
                name="StackTrace"
                />
          </template>
          <template tid="T_TRANSPORTSIGNAL">
            <data
                inType="win:UnicodeString"
                name="SessionId"
                />
            <data
                inType="win:UnicodeString"
                name="PipelineId"
                />
            <data
                inType="win:UnicodeString"
                name="SignalCode"
                />
          </template>
          <template tid="T_TRANSPORTURIREDIRECTION">
            <data
                inType="win:UnicodeString"
                name="SessionId"
                />
            <data
                inType="win:UnicodeString"
                name="Uri"
                />
          </template>
          <template tid="T_FRAGMENT">
            <data
                inType="win:Int64"
                name="ObjectId"
                />
            <data
                inType="win:Int64"
                name="FragmentId"
                />
            <data
                inType="win:Int32"
                name="sFlag"
                />
            <data
                inType="win:Int32"
                name="eFlag"
                />
            <data
                inType="win:UInt32"
                name="FragmentLength"
                />
            <data
                inType="win:UnicodeString"
                name="FragmentPayload"
                />
          </template>
          <template tid="T_SHUTTING_DOWN"/>
          <template tid="T_REHYDRATION_SUCCESS">
            <data
                inType="win:UnicodeString"
                name="DeserializedType"
                />
            <data
                inType="win:UnicodeString"
                name="CastedToType"
                />
            <data
                inType="win:UnicodeString"
                name="RehydratedType"
                />
          </template>
          <template tid="T_REHYDRATION_FAILURE">
            <data
                inType="win:UnicodeString"
                name="DeserializedType"
                />
            <data
                inType="win:UnicodeString"
                name="CastedToType"
                />
            <data
                inType="win:UnicodeString"
                name="TypeCastException"
                />
            <data
                inType="win:UnicodeString"
                name="TypeCastInnerException"
                />
          </template>
          <template tid="T_SERIALIZER_DEPTH_OVERRIDE">
            <data
                inType="win:UnicodeString"
                name="SerializedType"
                />
            <data
                inType="win:Int32"
                name="OriginalDepth"
                />
            <data
                inType="win:Int32"
                name="OverridenDepth"
                />
            <data
                inType="win:Int32"
                name="CurrentDepthBelowTopLevel"
                />
          </template>
          <template tid="T_SERIALIZER_MODE_OVERRIDE">
            <data
                inType="win:UnicodeString"
                name="SerializedType"
                />
            <data
                inType="win:UInt32"
                map="SerializationMethod"
                name="OverridenMode"
                />
          </template>
          <template tid="T_SERIALIZER_SCRIPT_PROPERTY_WITHOUT_RUNSPACE">
            <data
                inType="win:UnicodeString"
                name="PropertyName"
                />
            <data
                inType="win:UnicodeString"
                name="PropertyOwnerType"
                />
            <data
                inType="win:UnicodeString"
                name="GetterScript"
                />
          </template>
          <template tid="T_SERIALIZER_PROPERTY_GETTER_FAILED">
            <data
                inType="win:UnicodeString"
                name="PropertyName"
                />
            <data
                inType="win:UnicodeString"
                name="PropertyOwnerType"
                />
            <data
                inType="win:UnicodeString"
                name="Exception"
                />
            <data
                inType="win:UnicodeString"
                name="InnerException"
                />
          </template>
          <template tid="T_SERIALIZER_ENUMERATION_FAILED">
            <data
                inType="win:UnicodeString"
                name="TypeBeingEnumerated"
                />
            <data
                inType="win:UnicodeString"
                name="Exception"
                />
          </template>
          <template tid="T_SERIALIZER_TOSTRING_FAILED">
            <data
                inType="win:UnicodeString"
                name="Type"
                />
            <data
                inType="win:UnicodeString"
                name="Exception"
                />
          </template>
          <template tid="T_SERIALIZER_MAX_DEPTH_WHEN_SERIALIZING">
            <data
                inType="win:UnicodeString"
                name="TypeOfObjectAtMaxDepth"
                />
            <data
                inType="win:UnicodeString"
                name="PropertyNameAtMaxDepth"
                />
            <data
                inType="win:Int32"
                name="Depth"
                />
          </template>
          <template tid="T_SERIALIZER_XMLEXCEPTION_WHEN_DESERIALIZING">
            <data
                inType="win:Int32"
                name="LineNumber"
                />
            <data
                inType="win:Int32"
                name="LinePosition"
                />
            <data
                inType="win:UnicodeString"
                name="Exception"
                />
          </template>
          <template tid="T_SERIALIZER_SPECIFIC_PROPERTY_MISSING">
            <data
                inType="win:UnicodeString"
                name="TypeOfObjectWithMissingProperty"
                />
            <data
                inType="win:UnicodeString"
                name="PropertyName"
                />
          </template>
          <template tid="T_JOB">
            <data
                inType="win:UnicodeString"
                name="Id"
                />
            <data
                inType="win:UnicodeString"
                name="InstanceId"
                />
            <data
                inType="win:UnicodeString"
                name="Name"
                />
            <data
                inType="win:UnicodeString"
                name="Location"
                />
            <data
                inType="win:UnicodeString"
                name="State"
                />
            <data
                inType="win:UnicodeString"
                name="Command"
                />
          </template>
          <template tid="T_ERROR_RECORD">
            <data
                inType="win:UnicodeString"
                name="Message"
                />
            <data
                inType="win:UnicodeString"
                name="Category"
                />
            <data
                inType="win:UnicodeString"
                name="Reason"
                />
            <data
                inType="win:UnicodeString"
                name="TargetName"
                />
            <data
                inType="win:UnicodeString"
                name="FullyQualifiedErrorId"
                />
            <data
                inType="win:UnicodeString"
                name="ExceptionMessage"
                />
            <data
                inType="win:UnicodeString"
                name="ExceptionStackTrace"
                />
            <data
                inType="win:UnicodeString"
                name="ExceptionInnerException"
                />
          </template>
          <template tid="T_LOG_CONTEXT">
            <data
                inType="win:UnicodeString"
                name="ContextInfo"
                />
            <data
                inType="win:UnicodeString"
                name="UserData"
                />
            <data
                inType="win:UnicodeString"
                name="Payload"
                />
          </template>
          <template tid="T_ScriptBlock_Compiled">
            <data
                inType="win:Int32"
                name="MessageNumber"
                />
            <data
                inType="win:Int32"
                name="MessageTotal"
                />
            <data
                inType="win:UnicodeString"
                name="ScriptBlockText"
                />
            <data
                inType="win:UnicodeString"
                name="ScriptBlockId"
                />
            <data
                inType="win:UnicodeString"
                name="Path"
                />
          </template>
          <template tid="T_ScriptBlock_Executed">
            <data
                inType="win:UnicodeString"
                name="ScriptBlockId"
                />
            <data
                inType="win:UnicodeString"
                name="RunspaceId"
                />
          </template>
          <template tid="T_ENGINE_TRACE_CONTEXT">
            <data
                inType="win:UnicodeString"
                name="ClassName"
                />
            <data
                inType="win:UnicodeString"
                name="MethodName"
                />
            <data
                inType="win:UnicodeString"
                name="WorkflowGuid"
                />
            <data
                inType="win:UnicodeString"
                name="Message"
                />
            <data
                inType="win:UnicodeString"
                name="JobData"
                />
            <data
                inType="win:UnicodeString"
                name="ActivityName"
                />
            <data
                inType="win:UnicodeString"
                name="ActivityGuid"
                />
            <data
                inType="win:UnicodeString"
                name="Parameters"
                />
          </template>
          <template tid="T_ScheduledJobStarted">
            <data
                inType="win:UnicodeString"
                name="ScheduledJobDefName"
                />
            <data
                inType="win:UnicodeString"
                name="StartTime"
                />
          </template>
          <template tid="T_ScheduledJobCompleted">
            <data
                inType="win:UnicodeString"
                name="ScheduledJobDefName"
                />
            <data
                inType="win:UnicodeString"
                name="StopTime"
                />
            <data
                inType="win:UnicodeString"
                name="State"
                />
          </template>
          <template tid="T_ScheduledJobError">
            <data
                inType="win:UnicodeString"
                name="Name"
                />
            <data
                inType="win:UnicodeString"
                name="Message"
                />
            <data
                inType="win:UnicodeString"
                name="StackTrace"
                />
            <data
                inType="win:UnicodeString"
                name="InnerException"
                />
          </template>
          <template tid="T_TrackingGuid">
            <data
                inType="win:GUID"
                name="TrackingId"
                />
          </template>
          <template tid="T_ProxyJob">
            <data
                inType="win:GUID"
                name="ProxyJobInstanceId"
                />
          </template>
          <template tid="T_ProxyChildJob">
            <data
                inType="win:GUID"
                name="ProxyChildJobInstanceId"
                />
          </template>
          <template tid="T_WorkflowJobGuid">
            <data
                inType="win:GUID"
                name="WorkflowJobJobInstanceId"
                />
          </template>
          <template tid="T_TrackingGuidContainerParentJob">
            <data
                inType="win:GUID"
                name="TrackingId"
                />
            <data
                inType="win:GUID"
                name="ContainerParentJobInstanceId"
                />
          </template>
          <template tid="T_WorkflowJobContainerParentJob">
            <data
                inType="win:GUID"
                name="WorkflowJobInstanceId"
                />
            <data
                inType="win:GUID"
                name="ContainerParentJobInstanceId"
                />
          </template>
          <template tid="T_ProxyJobContainerParentJob">
            <data
                inType="win:GUID"
                name="ProxyJobInstanceId"
                />
            <data
                inType="win:GUID"
                name="ContainerParentJobInstanceId"
                />
          </template>
          <template tid="T_ContainerParentJob">
            <data
                inType="win:GUID"
                name="ContainerParentJobInstanceId"
                />
          </template>
          <template tid="T_BreakpointOperation">
            <data
                inType="win:Int32"
                name="CurrentLine"
                />
            <data
                inType="win:UnicodeString"
                name="FileName"
                />
          </template>
          <template tid="T_ExecuteScriptOperation">
            <data
                inType="win:UnicodeString"
                name="FileName"
                />
          </template>
          <template tid="T_AmsiState">
            <data
                inType="win:UnicodeString"
                name="Action"
                />
            <data
                inType="win:UnicodeString"
                name="AmsiContext"
                />
          </template>
          <template tid="T_WDACQuery">
            <data
                inType="win:UnicodeString"
                name="QueryName"
                />
            <data
                inType="win:UnicodeString"
                name="FileName"
                />
            <data
                inType="win:Int32"
                name="QuerySuccess"
                />
            <data
                inType="win:Int32"
                name="QuerySResult"
                />
          </template>
          <template tid="T_WDACAudit">
            <data
                inType="win:UnicodeString"
                name="Title"
                />
            <data
                inType="win:UnicodeString"
                name="Message"
                />
            <data
                inType="win:UnicodeString"
                name="FullyQualifiedId"
                />
          </template>
        </templates>
      </provider>
    </events>
    <counters
        xmlns="http://schemas.microsoft.com/win/2005/12/counters"
        schemaVersion="1.0"
        >
      <provider
          applicationIdentity="%windir%\system32\WindowsPowerShell\v1.0\PSEvents.dll"
          providerGuid="{5db760bc-64b2-4da7-b4ef-7dab105fbb8c}"
          providerType="userMode"
          symbol="PowershellM3PRes"
          >
        <counterSet
            description="Displays performance counters for PowerShell Workflow engine."
            descriptionID="100"
            guid="{faa17411-9025-4b86-8b5e-ce2f32b06e13}"
            instances="multiple"
            name="PowerShell Workflow"
            nameID="102"
            symbol="PowershellM3PRes"
            uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet"
            >
          <counter
              defaultScale="0"
              description="Displays the number of terminated workflow jobs that failed since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="104"
              detailLevel="standard"
              id="1"
              name="# of failed workflow jobs"
              nameID="106"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.FailedWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that have failed. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="108"
              detailLevel="standard"
              id="2"
              name="# of failed workflow jobs/sec"
              nameID="110"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.FailedWorkflowJobsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that got resumed (following suspension) since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="112"
              detailLevel="standard"
              id="3"
              name="# of resumed workflow jobs"
              nameID="114"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ResumedWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that have been resumed. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="116"
              detailLevel="standard"
              id="4"
              name="# of resumed workflow jobs/sec"
              nameID="118"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ResumedWorkflowJobsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of jobs that are currently being serviced. This counter displays the last observed value."
              descriptionID="120"
              detailLevel="standard"
              id="5"
              name="# of running workflow jobs"
              nameID="122"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.RunningWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that are being serviced. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="124"
              detailLevel="standard"
              id="6"
              name="# of running workflow jobs / sec"
              nameID="126"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.RunningWorkflowJobsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of terminated workflow jobs that were stopped since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="128"
              detailLevel="standard"
              id="7"
              name="# of stopped workflow jobs"
              nameID="130"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.StoppedWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that have been stopped. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="132"
              detailLevel="standard"
              id="8"
              name="# of stopped workflow jobs / sec"
              nameID="134"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.StoppedWorkflowJobsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of terminated workflow jobs that were successfully completed since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="136"
              detailLevel="standard"
              id="9"
              name="# of succeeded workflow jobs"
              nameID="138"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.SucceededWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that have been successfully completed. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="140"
              detailLevel="standard"
              id="10"
              name="# of succeeded workflow jobs/sec"
              nameID="142"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.SucceededWorkflowJobsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of terminated workflow jobs that were suspended since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="144"
              detailLevel="standard"
              id="11"
              name="# of suspended workflow jobs"
              nameID="146"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.SuspendedWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that have been suspended. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="148"
              detailLevel="standard"
              id="12"
              name="# of suspended workflow jobs/sec"
              nameID="150"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.SuspendedWorkflowJobsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of terminated workflow jobs since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="152"
              detailLevel="standard"
              id="13"
              name="# of terminated workflow jobs"
              nameID="154"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.TerminatedWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of workflow jobs that have been terminated. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="156"
              detailLevel="standard"
              id="14"
              name="# of terminated workflow jobs / sec"
              nameID="158"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.TerminatedWorkflowJobsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of jobs that are pending execution and waiting in the PowerShell Workflow job queue. This counter displays the last observed value."
              descriptionID="164"
              detailLevel="standard"
              id="15"
              name="# of waiting workflow jobs"
              nameID="166"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.WaitingWorkflowJobsCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of activity host processes which are busy servicing the requests (incoming / failed). This counter displays the last observed value."
              descriptionID="168"
              detailLevel="standard"
              id="16"
              name="Activity Host Manager: # of busy host processes"
              nameID="170"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrBusyProcessesCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of requests that were re-i nserted into the Activity Host Manager queue&apos;s because of failure due to process crash. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="172"
              detailLevel="standard"
              id="17"
              name="Activity Host Manager: # of failed requests/sec"
              nameID="174"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrFailedRequestsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of failed requests (because of activity host process crash) that are pending execution and waiting in the Activity Host Manager&apos;s queue. This counter displays the last observed value."
              descriptionID="176"
              detailLevel="standard"
              id="18"
              name="Activity Host Manager: # of failed requests in queue"
              nameID="178"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrFailedRequestsQueueLength"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of requests that are arrived in the Activity Host Manager queue. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="180"
              detailLevel="standard"
              id="19"
              name="Activity Host Manager: # of incoming requests/sec"
              nameID="182"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrIncomingRequestsPerSec"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of requests that are pending execution and waiting in the Activity Host Manager&apos;s queue. This counter displays the last observed value."
              descriptionID="184"
              detailLevel="standard"
              id="20"
              name="Activity Host Manager: # of pending requests in queue"
              nameID="186"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrPendingRequestsQueueLength"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of activity host processes that have been created since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="188"
              detailLevel="standard"
              id="21"
              name="Activity Host Manager: # of created host processes"
              nameID="190"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrCreatedProcessesCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of activity host processes that have been disposed since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="192"
              detailLevel="standard"
              id="22"
              name="Activity Host Manager: # of disposed host processes"
              nameID="194"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrDisposedProcessesCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the size of the activity host processes pool. This counter displays the last observed value."
              descriptionID="196"
              detailLevel="standard"
              id="23"
              name="Activity Host Manager: host processes pool size"
              nameID="198"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.ActivityHostMgrProcessesPoolSize"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of requests that are pending execution and waiting in the PowerShell Remoting queue. This counter displays the last observed value."
              descriptionID="200"
              detailLevel="standard"
              id="24"
              name="PowerShell Remoting: # of pending requests in queue"
              nameID="202"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.PSRemotingPendingRequestsQueueLength"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of requests that are being serviced. This counter is not an average over time; it displays the difference between the values observed in the last two samples divided by the duration of the sample interval."
              descriptionID="204"
              detailLevel="standard"
              id="25"
              name="PowerShell Remoting: # of requests being serviced"
              nameID="206"
              type="perf_counter_counter"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.PSRemotingRequestsBeingServicedCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of requests that were forced to wait and waiting in the PowerShell Remoting queue. This counter displays the last observed value."
              descriptionID="208"
              detailLevel="standard"
              id="26"
              name="PowerShell Remoting: # of forced to wait requests in queue"
              nameID="210"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.PSRemotingForcedToWaitRequestsQueueLength"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of PowerShell Remoting connections that have been created since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="212"
              detailLevel="standard"
              id="27"
              name="PowerShell Remoting: # of created connections"
              nameID="214"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.PSRemotingConnectionsCreatedCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of PowerShell Remoting connections that have been disposed since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="216"
              detailLevel="standard"
              id="28"
              name="PowerShell Remoting: # of disposed connections"
              nameID="218"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.PSRemotingConnectionsDisposedCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
          <counter
              defaultScale="0"
              description="Displays the number of PowerShell Remoting connections that were closed and reopened since the start of PowerShell Workflow engine. This counter displays the last observed value."
              descriptionID="220"
              detailLevel="standard"
              id="29"
              name="PowerShell Remoting: # of connections closed-reopened"
              nameID="222"
              type="perf_counter_rawcount"
              uri="PowerShellCore.PerfCounters.PowershellM3PCounterSet.PSRemotingConnectionsClosedReopendCount"
              >
            <counterAttributes>
              <counterAttribute name="reference"/>
            </counterAttributes>
          </counter>
        </counterSet>
      </provider>
    </counters>
  </instrumentation>
  <localization>
    <resources culture="en-US">
      <stringTable>
        <string
            id="SerializationMethod.AllPublicProperties"
            value="AllPublicProperties"
            />
        <string
            id="SerializationMethod.String"
            value="String"
            />
        <string
            id="SerializationMethod.SpecificProperties"
            value="SpecificProperties"
            />
        <string
            id="WSManAuthenticationMechanism.WSMAN_FLAG_NO_AUTHENTICATION"
            value="WSMAN_FLAG_NO_AUTHENTICATION"
            />
        <string
            id="WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_DIGEST"
            value="WSMAN_FLAG_AUTH_DIGEST"
            />
        <string
            id="WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_NEGOTIATE"
            value="WSMAN_FLAG_AUTH_NEGOTIATE"
            />
        <string
            id="WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_BASIC"
            value="WSMAN_FLAG_AUTH_BASIC"
            />
        <string
            id="WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_KERBEROS"
            value="WSMAN_FLAG_AUTH_KERBEROS"
            />
        <string
            id="WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_CLIENT_CERTIFICATE"
            value="WSMAN_FLAG_AUTH_CLIENT_CERTIFICATE"
            />
        <string
            id="WSManAuthenticationMechanism.WSMAN_FLAG_AUTH_CREDSSP"
            value="WSMAN_FLAG_AUTH_CREDSSP"
            />
        <string
            id="RemotingDestination.Client"
            value="Client"
            />
        <string
            id="RemotingDestination.Server"
            value="Server"
            />
        <string
            id="RemotingDestination.Listener"
            value="Listener"
            />
        <string
            id="RemotingTargetInterface.InvalidTargetInterface"
            value="InvalidTargetInterface"
            />
        <string
            id="RemotingTargetInterface.Session"
            value="Session"
            />
        <string
            id="RemotingTargetInterface.RunspacePool"
            value="RunspacePool"
            />
        <string
            id="RemotingTargetInterface.PowerShell"
            value="PowerShell"
            />
        <string
            id="RemotingDataType.InvalidDataType"
            value="InvalidDataType"
            />
        <string
            id="RemotingDataType.ExceptionAsErrorRecord"
            value="ExceptionAsErrorRecord"
            />
        <string
            id="RemotingDataType.SessionConfiguration"
            value="SessionConfiguration"
            />
        <string
            id="RemotingDataType.SessionConfigurationRequest"
            value="SessionConfigurationRequest"
            />
        <string
            id="RemotingDataType.SessionCapability"
            value="SessionCapability"
            />
        <string
            id="RemotingDataType.CloseSession"
            value="CloseSession"
            />
        <string
            id="RemotingDataType.CreateRunspacePool"
            value="CreateRunspacePool"
            />
        <string
            id="RemotingDataType.SetMaxRunspaces"
            value="SetMaxRunspaces"
            />
        <string
            id="RemotingDataType.SetMinRunspaces"
            value="SetMinRunspaces"
            />
        <string
            id="RemotingDataType.RunspacePoolOperationResponse"
            value="RunspacePoolOperationResponse"
            />
        <string
            id="RemotingDataType.RunspacePoolStateInfo"
            value="RunspacePoolStateInfo"
            />
        <string
            id="RemotingDataType.CreatePowerShell"
            value="CreatePowerShell"
            />
        <string
            id="RemotingDataType.AvailableRunspaces"
            value="AvailableRunspaces"
            />
        <string
            id="RemotingDataType.PSEventArgs"
            value="PSEventArgs"
            />
        <string
            id="RemotingDataType.RemoteHostCallUsingRunspaceHost"
            value="RemoteHostCallUsingRunspaceHost"
            />
        <string
            id="RemotingDataType.RemoteRunspaceHostResponseData"
            value="RemoteRunspaceHostResponseData"
            />
        <string
            id="RemotingDataType.PowerShellInput"
            value="PowerShellInput"
            />
        <string
            id="RemotingDataType.PowerShellInputEnd"
            value="PowerShellInputEnd"
            />
        <string
            id="RemotingDataType.PowerShellOutput"
            value="PowerShellOutput"
            />
        <string
            id="RemotingDataType.PowerShellErrorRecord"
            value="PowerShellErrorRecord"
            />
        <string
            id="RemotingDataType.PowerShellStateInfo"
            value="PowerShellStateInfo"
            />
        <string
            id="RemotingDataType.PowerShellDebug"
            value="PowerShellDebug"
            />
        <string
            id="RemotingDataType.PowerShellVerbose"
            value="PowerShellVerbose"
            />
        <string
            id="RemotingDataType.PowerShellWarning"
            value="PowerShellWarning"
            />
        <string
            id="RemotingDataType.PowerShellProgress"
            value="PowerShellProgress"
            />
        <string
            id="RemotingDataType.StopPowerShell"
            value="StopPowerShell"
            />
        <string
            id="RemotingDataType.RemoteHostCallUsingPowerShellHost"
            value="RemoteHostCallUsingPowerShellHost"
            />
        <string
            id="RemotingDataType.RemotePowerShellHostResponseData"
            value="RemotePowerShellHostResponseData"
            />
        <string
            id="PS_PROVIDER.event.E_A_RUNSPACE_TEST.message"
            value="Test analytic message"
            />
        <string
            id="PS_PROVIDER.event.E_A_RUNSPACE_SCHEME.message"
            value="Scheme is %1"
            />
        <string
            id="PS_PROVIDER.event.E_A_RUNSPACE_COMPUTERNAME.message"
            value="ComputerName resolved to %1"
            />
        <string
            id="PS_PROVIDER.event.E_A_RUNSPACE_APPNAME.message"
            value="AppName resolved to %1"
            />
        <string
            id="PS_PROVIDER.event.E_A_RUNSPACE_PORT.message"
            value="Port resolved to %1"
            />
        <string
            id="PS_PROVIDER.event.E_A_RUNSPACE_WSMANCONNECTIONINFO.message"
            value="Connection Paramters are %n Connection URI: %1 %n Resource URI: %2 %n User: %3 %n OpenTimeout: %4 %n IdleTimeout: %5 %n CancelTimeout: %6 %n AuthenticationMechanism: %7 %n Thumb Print: %8 %n MaxUriRedirectionCount: %9 %n MaxReceivedDataSizePerCommand: %10 %n MaxReceivedObjectSize: %11"
            />
        <string
            id="PS_PROVIDER.event.E_O_RUNSPACE_CONSTRUCTOR.message"
            value="Creating Runspace object %n %t Instance Id: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_RUNSPACEPOOL_OPEN.message"
            value="Opening RunspacePool"
            />
        <string
            id="PS_PROVIDER.event.E_O_RUNSPACEPOOL_CONSTRUCTOR.message"
            value="Creating RunspacePool object %n %t InstanceId %1 %n %t MinRunspaces %2 %n %t MaxRunspaces %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_RUNSPACEPOOL_TRANSFER.message"
            value="Modifying activity Id and correlating"
            />
        <string
            id="PS_PROVIDER.event.E_O_RUNSPACE_STATE_CHANGE.message"
            value="Runspace state changed to %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_REMOTE_RUNSPACE_CREATE_RETRY.message"
            value="Attempting session creation retry %1 for error code %2 on session Id %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_APPDOMAIN_UNHANDLED_EXCEPTION.message"
            value="An unhandled exception occurred in the appdomain. %nException Type: %1 %nException Message: %2 %nException StackTrace: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_APPDOMAIN_UNHANDLED_EXCEPTION.message"
            value="An unhandled exception occurred in the appdomain. %nException Type: %1 %nException Message: %2 %nException StackTrace: %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_ERROR.message"
            value="Runspace Id: %1 Pipeline Id: %2. WSMan reported an error with error code: %3. %n Error message: %4 %n StackTrace: %5"
            />
        <string
            id="PS_PROVIDER.event.E_O_TRANSPORT_ERROR.message"
            value="Runspace Id: %1 Pipeline Id: %2. WSMan reported an error with error code: %3. %n Error message: %4 %n StackTrace: %5"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_CONNECT.message"
            value="Runspace Id %1. Establishing a connection using WSMan Create Shell"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SHELL_CONNECT_CALLBACK.message"
            value="Runspace Id %1. Callback received for WSMan Create Shell"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_URI_REDIRECTION.message"
            value="Runspace Id: %1. Connection is getting redirected to Uri: %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SHELL_CLOSE.message"
            value="Runspace Id: %1. Closing shell using WSManCloseShell"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SHELL_CLOSE_CALLBACK.message"
            value="Runspace Id: %1. Callback received for WSManCloseShell"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_CMD_CONNECT.message"
            value="Runspace Id %1 Pipeline Id %2. Establishing a command connection using WSManRunShellCommandEx"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_CMD_CONNECT_CALLBACK.message"
            value="Runspace Id %1 Pipeline Id %2. Callback received for command connection"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_CMD_CLOSE.message"
            value="Runspace Id: %1 Pipeline Id %2. Closing transport for command"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_CMD_CLOSE_CALLBACK.message"
            value="Runspace Id: %1 Pipeline Id %2. Callback received for command close"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SIGNAL.message"
            value="Runspace Id: %1 Pipeline Id %2. Sending signal with code %3 using WSManSignalShellEx"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SIGNAL_CALLBACK.message"
            value="Runspace Id: %1 Pipeline Id %2. Callback received for WSManSignalShellEx"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SEND_DATA.message"
            value="Runspace Id: %1 Pipeline Id: %2. Sending data of size %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SEND_DATA_CALLBACK.message"
            value="Runspace Id: %1 Pipeline Id: %2. Callback received for WSManSendShellInputEx"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_SERVER_SEND_DATA.message"
            value="Runspace Id: %1 Pipeline Id: %2. Server is sending data of size %3 to client. DataType: %4 TargetInterface: %5"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_RECEIVE_DATA.message"
            value="Runspace Id: %1 Pipeline Id: %2. Placing Receive request using WSManReceiveShellOutputEx"
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_RECEIVE_DATA_CALLBACK.message"
            value="Runspace Id: %1 Pipeline Id: %2. Received Data of size %3."
            />
        <string
            id="PS_PROVIDER.event.E_A_TRANSPORT_RCVDOBJ.message"
            value="Received object with Runspace Id: %1 Command Id: %2 Destination: %3 DataType: %4 TargetInterface: %5"
            />
        <string
            id="PS_PROVIDER.event.E_A_CREATE_SERVER_REMOTESESSION.message"
            value="Request %1. Creating a server remote session. UserName: %2 Custom Shell Id: %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_REPORT_CONTEXT.message"
            value="Reporting context for request: %1 Context Reported: %1"
            />
        <string
            id="PS_PROVIDER.event.E_A_REPORT_OPERATION_COMPLETE.message"
            value="Reporting operation complete for request: %1 %n Error Code: %2 %n Error Message: %3 %n StackTrace: %4"
            />
        <string
            id="PS_PROVIDER.event.E_A_CREATE_COMMAND_REMOTESESSION.message"
            value="Shell Context %1. Request Id %2. Creating a commonad session for running a command."
            />
        <string
            id="PS_PROVIDER.event.E_A_STOP_COMMAND.message"
            value="Shell Context %1 Command Context %2 Request Id %3. Stopping command."
            />
        <string
            id="PS_PROVIDER.event.E_A_SERVER_RECEIVED_DATA.message"
            value="Shell Context %1 Command Context %2 Request Id %3. Received data from client."
            />
        <string
            id="PS_PROVIDER.event.E_A_SERVER_RECEIVE_REQUEST.message"
            value="Shell Context %1 Command Context %2 Request Id %3. Client sent a receive request so that server can send data."
            />
        <string
            id="PS_PROVIDER.event.E_A_SERVER_CLOSE_OPERATION.message"
            value="Shell Context %1 Command Context %2 IsReceiveOperation %3. Got close operation request."
            />
        <string
            id="PS_PROVIDER.event.E_A_LOAD_PSCUSTOMSHELL_ASSEMBLY.message"
            value="Loading assembly %1 for custom shell with shell Id %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_LOAD_PSCUSTOMSHELL_TYPE.message"
            value="Loading type %1 for custom shell with shell Id %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_RECEIVED_FRAGMENT.message"
            value="Received remoting fragment. %n %t Object Id: %1 %n %t Fragment Id: %2 %n %t Start Flag: %3 %n %t End Flag: %4 %n %t Payload Length: %5 %n %t Payload Data: %6"
            />
        <string
            id="PS_PROVIDER.event.E_A_SENT_FRAGMENT.message"
            value="Sent remoting fragment. %n %t Object Id: %1 %n %t Fragment Id: %2 %n %t Start Flag: %3 %n %t End Flag: %4 %n %t Payload Length: %5 %n %t Payload Data: %6"
            />
        <string
            id="PS_PROVIDER.event.E_A_SHUTTING_DOWN.message"
            value="Shutting down winrm service."
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_REHYDRATION_SUCCESS.message"
            value="Successfully rehydrated an object. %n %t Deserialized type name: %1 %n %t Rehydrated by casting to type: %2 %n %t Rehydrated object is of type: %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_REHYDRATION_FAILURE.message"
            value="Failed to rehydrated an object. %n %t Deserialized type name: %1 %n %t Rehydrated by casting to type: %2 %n %t Type cast exception: %3 %n %t Type cast inner exception: %4"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_DEPTH_OVERRIDE.message"
            value="Serialization depth has been overriden. %n %t Serialized type name: %1 %n %t Original depth: %2 %n %t Overriden depth: %3 %n %t Current depth below top level: %4"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_MODE_OVERRIDE.message"
            value="Serialization mode has been overriden. %n %t Serialized type name: %1 %n %t Overriden mode: %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_SCRIPT_PROPERTY_WITHOUT_RUNSPACE.message"
            value="Serialization of a script property has been skipped, because there is no runspace to use for evaluation of the property. %n %t Property name: %1 %n %t Property owner&apos;s type name: %2 %n %t Getter script: %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_PROPERTY_GETTER_FAILED.message"
            value="Serialization of a property has been skipped, because property getter failed. %n %t Property name: %1 %n %t Property owner&apos;s type name: %2 %n %t Exception from property getter: %3 %n %t Inner exception from property getter: %4"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_ENUMERATION_FAILED.message"
            value="Serialization of an enumerable object might not be complete, because object being enumerated threw an exception. %n %t Type of object being enumerated: %1 %n %t Exception: %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_TOSTRING_FAILED.message"
            value="Serialization called object&apos;s ToString method which failed. %n %t Type of object: %1 %n %t Exception: %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_MAX_DEPTH_WHEN_SERIALIZING.message"
            value="Maximum depth below top level has been reached, forcing object to be serialized as strings. %n %t Object type at max depth: %1 %n %t Property name at max depth: %2 %n %t Depth: %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_XMLEXCEPTION_WHEN_DESERIALIZING.message"
            value="XmlException has been thrown by the deserializer (most likely indicating incorrect clixml format). %n %t Line number: %1 Line position: %2 %n %t Exception: %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_SERIALIZER_SPECIFIC_PROPERTY_MISSING.message"
            value="Serialization of specified properties failed, because one of the specified properties was missing. %n %t Type of object: %1 %n %t Property name: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_CMDLETS_SHELLRESOLVE.message"
            value="Remote shell name resolved to default PowerShellCore"
            />
        <string
            id="PS_PROVIDER.event.E_O_CMDLETS_SCHEMERESOLVE.message"
            value="Resolving to default scheme http"
            />
        <string
            id="PS_PROVIDER.event.E_O_CMDLETS_HOSTNAMERESOLVE.message"
            value="Computer Name $null or . resolve to LocalHost"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowPluginStarted.message"
            value="Workflow plugin loaded. %n %t EndpointName: %1 %n %t User: %2 %n %t HostingMode: %3 %n %t Protocol: %4 %n %t Configuration: %n %5"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowExecutionStarted.message"
            value="Workflow execution started. %n %t WorkflowId: %1 %n %t ManagedNodes: %2"
            />
          <string
              id="PS_PROVIDER.event.E_A_AmsiState.message"
              value="AmsiUtil state. %n %t state: %1 %n %t Context: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PEndpointRegistered.message"
            value="A new PowerShell endpoint was registered. %n %t EndpointName: %1 %n %t EndpointType: %2 %n %t RegisteredBy: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PEndpointModified.message"
            value="Endpoint configuration modified. %n %t EndpointName: %1 %n %t ModifiedBy: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PEndpointDisabled.message"
            value="Endpoint configuration disabled. %n %t EndpointName: %1 %n %t DisabledBy: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowEngineStarted.message"
            value="Workflow engine started. %n %t EndpointName: %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PWORKFLOW_MANAGER_CHECKPOINTPATH.message"
            value="Workflow manager instantiated with %n %t CheckpointPath: %1 %n %t ConfigProviderId: %2 %n %t UserName: %3 %n %t Path: %4"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PParameterSplattingWasPerformed.message"
            value="Parameter splatting was performed during workflow execution. %n %t Parameters: %1 %n %t Computers: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3POutOfProcessRunspaceStarted.message"
            value="Out of process runspace started. %n %t Command: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PEndpointEnabled.message"
            value="Endpoint configuration enabled. %n %t EndpointName: %1 %n %t EnabledBy: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PEndpointUnregistered.message"
            value="Endpoint configuration unregistered. %n %t EndpointName: %1 %n %t UnregisteredBy: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowExecutionError.message"
            value="Workflow execution error. %n %t WorkflowId: %1 %n %t ErrorDescription: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowStateChanged.message"
            value="Workflow state changed. %n %t WorkflowId: %1 %n %t NewState: %2 %n %t OldState: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowPluginRequestedToShutdown.message"
            value="Workflow plugin has been requested for a shutdown. %n %t EndpointName: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowPluginRestarted.message"
            value="Workflow plugin restarted. %n %t EndpointName: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowWorkflowsResuming.message"
            value="Workflow is resuming. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowWorkflowsResumed.message"
            value="Workflow has resumed. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowQuotaViolationDetected.message"
            value="A quota limit that was set for the endpoint was exceeded. %n %t EndpointName: %1 %n %t ConfigName: %2 %n %t AllowedValue: %3 %n %t ValueInQuestion: %4"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowRunspacePoolCreated.message"
            value="Workflow runspace pool was created. %n %t WorkflowId: %1 %n %t ManagedNode: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionQueued.message"
            value="Activity was queued for execution. %n %t WorkflowId: %1 %n %t ActivityName: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionFinished.message"
            value="Activity execution finished. %n %t ActivityName: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionStarted.message"
            value="Activity execution started. %n %t ActivityName: %1 %n %t ActivityTypeName: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportingFromXaml.message"
            value="Workflow is being imported from a XAML file. %n %t WorkflowId: %1 %n %t XamlFile: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportedFromXaml.message"
            value="Workflow has been imported from a XAML file. %n %t WorkflowId: %1 %n %t XamlFile: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlError.message"
            value="Workflow could not be imported from a XAML file because of an error. %n %t WorkflowId: %1 %n %t ErrorDescription: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlValidationStarted.message"
            value="Workflow validation started. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlValidationFinishedSuccessfully.message"
            value="Workflow validation succeeded. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlValidationFinishedWithError.message"
            value="Workflow validation failed with error. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlActivityValidated.message"
            value="Workflow activity validated. %n %t WorkflowId: %1 %n %t ActivityDisplayName: %2 %n %t ActivityTypeName: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowActivityExecutionFailed.message"
            value="Activity execution failed. %n %t WorkflowId: %1 %n %t ActivityName: %2 %n %t FailureDescription: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowImportFromXamlActivityValidationFailed.message"
            value="Workflow activity could not be validated. %n %t WorkflowId: %1 %n %t ActivityDisplayName: %2 %n %t ActivityTypeName: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowRunspaceAvailabilityChanged.message"
            value="Runspace availability changed. %n %t RunspaceId: %1 %n %t Availability: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowLoadedForExecution.message"
            value="Workflow loaded for execution. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowExecutionFinished.message"
            value="Workflow execution finished. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PLoadingWorkflowForExecution.message"
            value="Loading workflow for execution. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PForcedWorkflowShutdownStarted.message"
            value="Forced workflow shutdown started. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PForcedWorkflowShutdownFinished.message"
            value="Forced workflow shutdown finished. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PForcedWorkflowShutdownError.message"
            value="An error occurred while forcefully shutting down a workflow. %n %t WorkflowId: %1 %n %t ErrorDescription: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PPersistingWorkflow.message"
            value="Persisting workflow to disk. %n %t WorkflowId: %1 %n %t PersistPath: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowPersisted.message"
            value="Workflow persisted to disk. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PUnloadingWorkflow.message"
            value="Unloading workflow. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowUnloaded.message"
            value="Workflow unloaded. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PCancellingWorkflowExecution.message"
            value="Cancelling workflow execution. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowCancelled.message"
            value="Workflow execution cancelled. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PAbortingWorkflowExecution.message"
            value="Aborting workflow execution. %n %t WorkflowId: %1 %n %t Reason: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowAborted.message"
            value="Workflow execution aborted. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowLoadedFromDisk.message"
            value="Persisted workflow loaded from disk. %n %t WorkflowId: %1 %n %t Path: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PRemoveJobStarted.message"
            value="Starting remove job. %n %t JobId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PJobError.message"
            value="Job error. %n %t JobId: %1 %n %t WorkflowId: %2 %n %t ErrorDescription: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowJobCreated.message"
            value="Job created for workflow (child job). %n %t ParentJobId: %1 %n %t ChildJobId: %2 %n %t ChildWorkflowId: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PParentJobCreated.message"
            value="Parent job created for workflow. %n %t JobId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PJobRemoveError.message"
            value="An error occurred while removing job. %n %t ParentJobId: %1 %n %t ChildJobId: %2 %n %t WorkflowId: %3 %n %t Error: %4"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PJobRemoved.message"
            value="Child job removed for workflow. %n %t ParentJobId: %1 %n %t ChildJobId: %2 %n %t WorkflowId: %3"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PJobCreationCompleted.message"
            value="All required jobs were created for workflow execution. %n %t JobId: %1 %n %t WorkflowId: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PJobStateChanged.message"
            value="Job state changed. %n %t JobId: %1 %n %t WorkflowId: %2 %n %t NewState: %3 %n %t OldState: %4"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowDeletedFromDisk.message"
            value="Workflow data was deleted from disk. %n %t WorkflowId: %1 %n %t Path: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowCleanup.message"
            value="Workflow cleanup operation executed. %n %t WorkflowId: %1"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PWorkflowRunspaceStateChanged.message"
            value="Runspace state changed. %n %t RunspaceId: %1 %n %t NewState: %2 %n %t OldState: %3"
            />
        <string
            id="PS_PROVIDER.event.E_A_RUNSPACEPOOL_TRANSFER.message"
            value="Modifying activity Id and correlating"
            />
        <string
            id="PS_PROVIDER.channel.C_ANALYTIC.message"
            value="Channel used for writing high volume high performance trace messages"
            />
        <string
            id="PS_PROVIDER.channel.C_OPERATIONAL.message"
            value="Channel used for writing diagnostic messages"
            />
        <string
            id="PS_PROVIDER.level.L_DEBUG.message"
            value="Debug level defined by PowerShell (which is above Informational defined by system)"
            />
        <string
            id="PS_PROVIDER.task.T_SERIALIZATION.message"
            value="Serialize or deserialize remoting payload"
            />
        <string
            id="PS_PROVIDER.task.T_Powershell-Console-Startup.message"
            value="PowerShell Console Startup"
            />
        <string
            id="PS_PROVIDER.task.T_M3P-WorkflowHostingTask.message"
            value="Workflow Hosting"
            />
        <string
            id="PS_PROVIDER.task.T_M3P-WorkflowExecutionTask.message"
            value="Workflow Execution"
            />
        <string
            id="PS_PROVIDER.task.T_M3P-WorkflowPersistenceTask.message"
            value="Workflow Persistence"
            />
        <string
            id="PS_PROVIDER.task.T_M3P-ConfiguarationTask.message"
            value="Configuration"
            />
        <string
            id="PS_PROVIDER.task.T_M3P-WorkflowValidationTask.message"
            value="Workflow Validation"
            />
        <string
            id="PS_PROVIDER.event.E_O_Powershell-Console-Startup-Start.message"
            value="PowerShell console is starting up"
            />
        <string
            id="PS_PROVIDER.event.E_O_Powershell-Console-Startup-Stop.message"
            value="PowerShell console is ready for user input"
            />
        <string
            id="PS_PROVIDER.event.E_D_Powershell_ErrorRecord.message"
            value="Tracing ErrorRecord: %n Message: %1 %n CategoryInfo.Category: %2 %n CategoryInfo.Reason : %3 %n CategoryInfo.TargetName : %4 %n FullyQualifiedErrorId: %5 %n Exception Details: %n Message : %6 %n Stack Trace: %7 %n InnerException %8 %n"
            />
        <string
            id="PS_PROVIDER.event.E_D_Powershell_Exception.message"
            value="Exception: %n Message: %1 %n StackTrace: %2 %n InnerException : %3 %n"
            />
        <string
            id="PS_PROVIDER.event.E_O_Powershell_PSObject.message"
            value="Tracing PSObject"
            />
        <string
            id="PS_PROVIDER.event.E_D_Powershell_Job.message"
            value="Tracing Job: %n Id: %1 %n InstanceId: %2 %n Name: %3 %n Location: %4 %n State: %5 %n Command: %6 %n"
            />
        <string
            id="PS_PROVIDER.event.E_D_MESSAGE.message"
            value="Trace Information: %n %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_MESSAGE2.message"
            value="Trace Information: %n %1 %2"
            />
        <string
            id="PS_PROVIDER.event.E_D_DebugMessage.message"
            value="%1"
            />
        <string
            id="PS_PROVIDER.event.E_O_COMMAND_HEALTH.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.event.E_O_ENGINE_HEALTH.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.event.E_O_PROVIDER_HEALTH.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.event.E_O_PIPELINE_DETAIL.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.event.E_A_COMMAND_LIFECYCLE.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.event.E_A_ENGINE_LIFECYCLE.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.event.E_A_PROVIDER_LIFECYCLE.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.task.T_ENGINE_START.message"
            value="Starting Engine"
            />
        <string
            id="PS_PROVIDER.task.T_ENGINE_STOP.message"
            value="Stopping Engine"
            />
        <string
            id="PS_PROVIDER.task.T_COMMAND_START.message"
            value="Starting Command"
            />
        <string
            id="PS_PROVIDER.task.T_COMMAND_STOP.message"
            value="Stopping Command"
            />
        <string
            id="PS_PROVIDER.task.T_PROVIDER_START.message"
            value="Starting Provider"
            />
        <string
            id="PS_PROVIDER.task.T_PROVIDER_STOP.message"
            value="Stopping Provider"
            />
        <string
            id="PS_PROVIDER.task.T_EXECUTE_PIPELINE.message"
            value="Executing Pipeline"
            />
        <string
            id="PS_PROVIDER.task.T_EXECUTE_SCRIPTBLOCK.message"
            value="Executing ScriptBlock"
            />
        <string
            id="PS_PROVIDER.event.E_O_SCRIPTBLOCK_CREATE_DETAIL.message"
            value="Creating Scriptblock text (%1 of %2):%n%3%n%nScriptBlock ID: %4%nPath: %5"
            />
        <string
            id="PS_PROVIDER.event.E_O_SCRIPTBLOCK_INVOKE_START_DETAIL.message"
            value="Started invocation of ScriptBlock ID: %1%nRunspace ID: %2"
            />
        <string
            id="PS_PROVIDER.event.E_O_SCRIPTBLOCK_INVOKE_COMPLETE_DETAIL.message"
            value="Completed invocation of ScriptBlock ID: %1%nRunspace ID: %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_WriteTransferEvent.message"
            value="Correlating activity id&apos;s. %n %t CurrentActivityId: %1 %n %t ParentActivityId: %2"
            />
        <string
            id="PS_PROVIDER.event.E_A_SETTINGS.message"
            value="%3%n%nContext:%n%1%n%nUser Data:%n%2%n"
            />
        <string
            id="PS_PROVIDER.event.E_A_ENGINE_TRACE.message"
            value="Class Name = %1%nMethod Name = %2%nWorkflow GUID = %3%nMessage = %4%n%5%nActivity Name = %6%nActivity GUID = %7%nParameters = %8"
            />
        <string
            id="PS_PROVIDER.task.T_EXECUTECOMMAND.message"
            value="Execute a Remote Command"
            />
        <string
            id="PS_PROVIDER.task.T_CREATERUNSPACE.message"
            value="Connect"
            />
        <string
            id="PS_PROVIDER.opcode.O_DISCONNECT.message"
            value="Disconnect"
            />
        <string
            id="PS_PROVIDER.opcode.O_METHOD.message"
            value="To be used when operation is just executing a method"
            />
        <string
            id="PS_PROVIDER.opcode.O_EXCEPTION.message"
            value="To be used when an exception is raised"
            />
        <string
            id="PS_PROVIDER.opcode.O_EVENTHANDLER.message"
            value="To be used when an event handler is raised"
            />
        <string
            id="PS_PROVIDER.opcode.O_DISPOSE.message"
            value="To be used when an object is disposed"
            />
        <string
            id="PS_PROVIDER.opcode.O_REHYDRATION.message"
            value="Rehydration"
            />
        <string
            id="PS_PROVIDER.opcode.O_SERIALIZATION_SETTINGS.message"
            value="Serialization settings"
            />
        <string
            id="PS_PROVIDER.opcode.O_SHUTTING_DOWN.message"
            value="Shutting down"
            />
        <string
            id="PS_PROVIDER.opcode.O_CONSTRUCTOR.message"
            value="to be used when an object is constructed"
            />
        <string
            id="PS_PROVIDER.opcode.O_CREATE.message"
            value="On create calls"
            />
        <string
            id="PS_PROVIDER.opcode.O_NEGOTIATE.message"
            value="Negotiate"
            />
        <string
            id="PS_PROVIDER.opcode.O_CONNECT.message"
            value="connect"
            />
        <string
            id="PS_PROVIDER.opcode.O_CLOSE.message"
            value="Close (Async)"
            />
        <string
            id="PS_PROVIDER.opcode.O_OPEN.message"
            value="Open (async)"
            />
        <string
            id="PS_PROVIDER.opcode.O_SEND.message"
            value="Send (Async)"
            />
        <string
            id="PS_PROVIDER.opcode.O_RECEIVE.message"
            value="Receive (Async)"
            />
        <string
            id="PS_PROVIDER.keyword.K_PLUGIN.message"
            value="The managed PowerShell plugin worker"
            />
        <string
            id="PS_PROVIDER.keyword.K_PSWORKFLOW.message"
            value="PSWorkflow Hosting And Execution Layer"
            />
          <string
              id="PS_PROVIDER.keyword.K_AmsiState.message"
              value="Amsi state"
            />
          <string
            id="PS_PROVIDER.keyword.K_SESSION.message"
            value="All session layer"
            />
        <string
            id="PS_PROVIDER.keyword.K_SERIALIZER.message"
            value="The serialization layer"
            />
        <string
            id="PS_PROVIDER.keyword.K_CMDLETS.message"
            value="All remoting cmdlets"
            />
        <string
            id="PS_PROVIDER.keyword.K_HOST.message"
            value="PowerShell remoting host proxy calls"
            />
        <string
            id="PS_PROVIDER.keyword.K_TRANSPORT.message"
            value="PowerShell remoting transport"
            />
        <string
            id="PS_PROVIDER.keyword.K_PROTOCOL.message"
            value="PowerShell remoting protocol"
            />
        <string
            id="PS_PROVIDER.keyword.K_PIPELINE.message"
            value="Pipeline of Commands"
            />
        <string
            id="PS_PROVIDER.keyword.K_RUNSPACE.message"
            value="PowerShell Runspace"
            />
        <string
            id="PS_CHANNEL_OPERATIONAL.ChannelMessage"
            value="PowerShellCore/Operational"
            />
        <string
            id="PS_CHANNEL_ANALYTIC.ChannelMessage"
            value="PowerShellCore/Analytic"
            />
        <string
            id="PS_CHANNEL_DEBUG.ChannelMessage"
            value="PowerShellCore/Debug"
            />
        <string
            id="PS_CHANNEL_ADMIN.ChannelMessage"
            value="PowerShellCore/Admin"
            />
        <string
            id="PS_PROVIDER.event.E_O_ScheduledJobStarted.message"
            value="Scheduled Job %1 started at %2 %n"
            />
        <string
            id="PS_PROVIDER.event.E_O_ScheduledJobCompleted.message"
            value="Scheduled Job %1 completed at %2 with state %3 %n"
            />
        <string
            id="PS_PROVIDER.event.E_O_ScheduledJobException.message"
            value="Scheduled Job Exception %1: %n Message: %2 %n StackTrace: %3 %n InnerException: %4 %n"
            />
        <string
            id="PS_PROVIDER.task.T_ScheduledJob.message"
            value="PowerShell Scheduled Jobs"
            />
        <string
            id="PS_PROVIDER.task.T_NamedPipe.message"
            value="PowerShell Named Pipe IPC"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginStartWorkflowApplication.message"
            value="BEGIN ImportWorkflowCommand::StartWorkflowApplication. Starting invocation of workflow function. Tracking Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndStartWorkflowApplication.message"
            value="END ImportWorkflowCommand::StartWorkflowApplication. Ending invocation of workflow function. Tracking Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginCreateNewJob.message"
            value="BEGIN Creating new job in ImportWorkflowCommand::StartWorkflowApplication. Tracking Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndCreateNewJob.message"
            value="END Creating new job in ImportWorkflowCommand::StartWorkflowApplication. Tracking Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PTrackingGuidContainerParentJobCorrelation.message"
            value="END Creating new job in ImportWorkflowCommand::StartWorkflowApplication. Tracking Guid %1 : ContainerParentJob Guid %2"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginJobLogic.message"
            value="BEGIN JobLogic ContainerParentJob Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndJobLogic.message"
            value="END JobLogic ContainerParentJob Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginWorkflowExecution.message"
            value="BEGIN WorkflowExecution ContainerParentJob Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndWorkflowExecution.message"
            value="END WorkflowExecution ContainerParentJob Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PChildWorkflowJobAddition.message"
            value="WorkflowJob with Guid %1 added to ContainerParentJob with Guid %2"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PProxyJobRemoteJobAssociation.message"
            value="ProxyJob with Guid %1 associated with remote ContainerParentJob with Guid %2"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginContainerParentJobExecution.message"
            value="BEGIN Execution of ContainerParentJob with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndContainerParentJobExecution.message"
            value="END Execution of ContainerParentJob with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginProxyJobExecution.message"
            value="BEGIN Execution of Proxy Job with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndProxyJobExecution.message"
            value="END Execution of Proxy Job with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginProxyJobEventHandler.message"
            value="BEGIN StateChanged event handler for Proxy Job with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndProxyJobEventHandler.message"
            value="END StateChanged event handler for Proxy Job with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginProxyChildJobEventHandler.message"
            value="BEGIN StateChanged event handler for Proxy Child Job with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndProxyChildJobEventHandler.message"
            value="END StateChanged event handler for Proxy Child Job with Guid %1"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PBeginRunGarbageCollection.message"
            value="BEGIN Running garbage collection"
            />
        <string
            id="PS_PROVIDER.event.E_D_M3PEndRunGarbageCollection.message"
            value="END Running garbage collection"
            />
        <string
            id="PS_PROVIDER.event.E_O_M3PPERSISTENCE_STORE_MAXSIZE_REACHED.message"
            value="Persistence store has reached its maximum specified size"
            />
        <string
            id="PS_PROVIDER.task.T_ISEOperation.message"
            value="PowerShell ISE Operation"
            />
          <string
              id="PS_PROVIDER.task.T_AmsiState.message"
              value="Amsi State"
            />
          <string
            id="PS_PROVIDER.event.E_O_ISEExecuteScript.message"
            value="Windows PowerShell ISE has started to run script file %1."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEExecuteSelection.message"
            value="Windows PowerShell ISE has started to run a user-selected script from file %1."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEStopCommand.message"
            value="Windows PowerShell ISE is stopping the current command."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEResumeDebugger.message"
            value="Windows PowerShell ISE is resuming the debugger."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEStopDebugger.message"
            value="Windows PowerShell ISE is stopping the debugger."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEDebuggerStepInto.message"
            value="Windows PowerShell ISE is stepping into debugging."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEDebuggerStepOver.message"
            value="Windows PowerShell ISE is stepping over debugging."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEDebuggerStepOut.message"
            value="Windows PowerShell ISE is stepping out of debugging."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEEnableAllBreakpoints.message"
            value="Windows PowerShell ISE is enabling all breakpoints."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEDisableAllBreakpoints.message"
            value="Windows PowerShell ISE is disabling all breakpoints."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISERemoveAllBreakpoints.message"
            value="Windows PowerShell ISE is removing all breakpoints."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISESetBreakpoint.message"
            value="Windows PowerShell ISE is setting the breakpoint at line #: %1 of file %2."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISERemoveBreakpoint.message"
            value="Windows PowerShell ISE is removing the breakpoint on line #: %1 of file %2."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEEnableBreakpoint.message"
            value="Windows PowerShell ISE is enabling the breakpoint on line #: %1 of file %2."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEDisableBreakpoint.message"
            value="Windows PowerShell ISE is disabling the breakpoint on line #: %1 of file %2."
            />
        <string
            id="PS_PROVIDER.event.E_O_ISEHitBreakpoint.message"
            value="Windows PowerShell ISE has hit a breakpoint on line #: %1 of file %2."
            />
        <string
            id="PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_LISTENER_START.message"
            value="Windows PowerShell has started an IPC listening thread on process: %1 in AppDomain: %2."
            />
        <string
            id="PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_LISTENER_END.message"
            value="Windows PowerShell has ended an IPC listening thread on process: %1 in AppDomain: %2."
            />
        <string
            id="PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_LISTENER_ERROR.message"
            value="An error has occurred in Windows PowerShell IPC listening thread on process: %1 in AppDomain: %2.  Error Message: %3."
            />
        <string
            id="PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_CONNECT.message"
            value="Windows PowerShell IPC connect on process: %1 in AppDomain: %2 for User: %3."
            />
        <string
            id="PS_PROVIDER.event.E_O_REMOTE_NAMEDPIPE_DISCONNECT.message"
            value="Windows PowerShell IPC disconnect on process: %1 in AppDomain: %2 for User: %3."
            />
        <string
            id="PS_PROVIDER.event.E_A_WDACQuery.message"
            value="WDAC Query. %n %t Query: %1 %n %t File: %2 %n %t SuccessCode: %3 %n %t ResultCode: %4"
            />
        <string
            id="PS_PROVIDER.keyword.K_WDACQuery.message"
            value="WDAC Query"
            />
        <string
            id="PS_PROVIDER.task.T_WDACQuery.message"
            value="WDAC Query"
            />
        <string
            id="PS_PROVIDER.event.E_A_WDACAudit.message"
            value="WDAC Audit. %n %t Title: %1 %n %t Message: %2 %n %t FullyQualifiedId: %3"
            />
        <string
            id="PS_PROVIDER.keyword.K_WDACAudit.message"
            value="WDAC Audit"
            />
        <string
            id="PS_PROVIDER.task.T_WDACAudit.message"
            value="WDAC Audit"
            />
      </stringTable>
    </resources>
  </localization>
</assembly>
