/*
 * graph.h: Function prototypes and structures for the edge/vertex functionality in rotoscope.
 *
 * 
 * Copyright 2006, James Foster
 *
 * This file is part of rotoscope.
 *
 * Rotoscope is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rotoscope is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with rotoscope; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef _GRAPH_H_
#define _GRAPH_H_

#include <glib.h>

typedef struct
{
	unsigned int x;
	unsigned int y;
} Vertex;

typedef struct
{
	Vertex a;
	Vertex b;
} Edge;

Vertex* create_vertex( unsigned int x, unsigned int y );
gboolean save_graph_to_file( GList* edges, char* filename );
GList* load_graph_from_file( char* filename );

#endif

