---
icon: material/ship-wheel
---

# Stability policy

This section contains information on how cargo-nextest will maintain backwards compatibility over time.

## The cargo-nextest binary

The cargo-nextest binary follows [semantic versioning](https://semver.org/), with its [public API](https://semver.org/#spec-item-1) defined as exactly:

1. command-line arguments, options and flags
2. [machine-readable output](../machine-readable/index.md)
3. the [configuration file format](../configuration/index.md)

!!! experimental "Experimental features"

    Experimental features are not part of the public API. They may change or be removed in a patch release.

Within a version series (currently 0.9.x), the public API will be append-only. New options or keys may be added, but
existing keys will continue to be as they were. Existing options may be deprecated but will not be
removed within a version series, except via the policy listed in [Making behavior changes](#making-behavior-changes).

The public API does _not_ include human-readable output generated by nextest, or in general anything
printed to standard error.

### Making behavior changes

In general, the meaning of options will not change and functionality will not be removed from
cargo-nextest within a version series.

However, in some cases, we may need to make behavior changes to fix a bug or security issue. These
sorts of changes will be made based on standard semantic versioning rules: bugs will be fixed in
patch releases, with due consideration given to existing use cases.

We may also need to make behavior changes to address major user interface
deficiencies. **This will not be done lightly:** the maintainers of nextest
understand the importance of stable, dependable CLI interfaces.

In those cases, we will follow the following procedure:

1. On the nextest discussion board, an announcement will be created under the [_behavior-change_ label](https://github.com/nextest-rs/nextest/discussions?discussions_q=label%3Abehavior-change+is%3Aopen). This issue will outline the motivation, and be used for coordination and feedback.
2. The behavior will be marked as deprecated and a warning will be provided within the CLI. If applicable, an alternative will be provided in the warning message. If there is no alternative, a configuration option and/or environment variable will be provided to silence the warning.
3. A timeline to change the behavior will be provided. The timeline will be at least 3 months long to provide ample time for users to adapt to the new behavior.
4. After that time has elapsed, the behavior will be changed in the following version of nextest.

### Release notes

Detailed release notes for each version are available in [nextest's changelog](../../changelog.md). These release notes are also published to [GitHub Releases](https://github.com/nextest-rs/nextest/releases?q=%22cargo-nextest%22&expanded=true).

Behavior changes are clearly marked in release notes.

## Libraries used by cargo-nextest

The libraries used by cargo-nextest, [nextest-metadata](https://crates.io/crates/nextest-metadata) and [nextest-runner](https://crates.io/crates/nextest-runner), follow the standard [Rust library versioning policy](https://doc.rust-lang.org/cargo/reference/semver.html).

### nextest-metadata

nextest-metadata contains data structures for deserializing cargo-nextest's [machine-readable output](../machine-readable/index.md).

**nextest-metadata is forward-compatible with cargo-nextest**. A given version of nextest-metadata will continue to work with all future versions of cargo-nextest (within the same version series).

However, currently, **nextest-metadata is not backwards-compatible**: a new version of nextest-metadata may not be able to parse metadata generated by older versions of cargo-nextest. In other words, each version of nextest-metadata has a minimum supported cargo-nextest version, analogous to a crate's [minimum supported Rust version (MSRV)](https://rust-lang.github.io/rfcs/2495-min-rust-version.html).

A bump to the minimum supported cargo-nextest version is considered a breaking change, and will be paired with a major version bump.

(The policy around backwards compatibility may be relaxed in the future based on user needs.)

### nextest-runner

nextest-runner is an internal crate that contains the core runner logic for nextest.
Every nextest release is likely to correspond to a breaking change to nextest-runner.

## Minimum supported Rust version (MSRV)

The MSRV of cargo-nextest and dependent crates is currently **Rust {{ msrv }}**.

The MSRV may be changed in a patch release. At least the last 3 versions of
stable Rust will be supported at any time.
